/****************************************************************************
**
** Copyright (C) 2018 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt VS Tools.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

using System.Runtime.Serialization;

namespace QtVsTools.Qml.Debug.V4
{
    using Json;

    [DataContract]
    sealed class Scope
    {
        //  { "index"      : <index of this scope in the scope chain. Index 0 is the top scope
        //                    and the global scope will always have the highest index for a
        //                    frame>,
        //    "frameIndex" : <index of the frame>,
        //    "type"       : <type of the scope:
        //                     0: Global
        //                     1: Local
        //                     2: With
        //                     3: Closure
        //                     4: Catch >,
        //    "object"     : <the scope object defining the content of the scope.
        //                    For local and closure scopes this is transient objects,
        //                    which has a negative handle value>
        //  }
        [DataMember(Name = "index")]
        public int Index { get; set; }

        [DataMember(Name = "frameIndex")]
        public int FrameIndex { get; set; }

        [DataContract]
        public enum ScopeType
        {
            Global = 0,
            Local = 1,
            With = 2,
            Closure = 3,
            Catch = 4
        }

        [DataMember(Name = "type")]
        public ScopeType Type { get; set; }

        [DataMember(Name = "object")]
        public DeferredObject<JsValue> Object { get; set; }
    }

    [DataContract]
    sealed class ScopeRequest : Request<ScopeResponse, ScopeRequest.ArgumentsStruct>
    {
        //  { "seq"       : <number>,
        //    "type"      : "request",
        //    "command"   : "scope",
        //    "arguments" : { "number" : <scope number>
        //                    "frameNumber" : <frame number, optional uses selected
        //                                    frame if missing>
        //                  }
        //  }
        public const string REQ_COMMAND = "scope";
        public ScopeRequest() : base()
        {
            Command = REQ_COMMAND;
        }

        [DataContract]
        public class ArgumentsStruct
        {
            [DataMember(Name = "number")]
            public int ScopeNumber { get; set; }

            [DataMember(Name = "frameNumber", EmitDefaultValue = false)]
            public int? FrameNumber { get; set; }
        }
    }

    [DataContract]
    sealed class ScopeResponse : Response
    {
        //  { "seq"         : <number>,
        //    "type"        : "response",
        //    "request_seq" : <number>,
        //    "command"     : "scope",
        //    "body"        : { "index"      : <index of this scope in the scope chain. Index 0 is
        //                                      the top scope
        //                                      and the global scope will always have the highest
        //                                      index for a
        //                                      frame>,
        //                      "frameIndex" : <index of the frame>,
        //                      "type"       : <type of the scope:
        //                                       0: Global
        //                                       1: Local
        //                                       2: With
        //                                       3: Closure
        //                                       4: Catch >,
        //                      "object"     : <the scope object defining the content of the scope.
        //                                      For local and closure scopes this is transient
        //                                      objects,
        //                                      which has a negative handle value>
        //                    }
        //    "running"     : <is the VM running after sending this response>
        //    "success"     : true
        //  }
        public const string REQ_COMMAND = ScopeRequest.REQ_COMMAND;
        public ScopeResponse() : base()
        {
            Command = REQ_COMMAND;
        }

        [DataMember(Name = "body")]
        public Scope Scope { get; set; }
    }
}
