#ifdef GEN_INTELLISENSE_DIRECTIVES
#pragma once
#include "components/types.hpp"
#endif

// This file was generated automatially by gencpp's bootstrap.cpp (See: https://github.com/Ed94/gencpp)

enum CodeType : u32
{
	CT_Invalid,
	CT_Untyped,
	CT_NewLine,
	CT_Comment,
	CT_Access_Private,
	CT_Access_Protected,
	CT_Access_Public,
	CT_PlatformAttributes,
	CT_Class,
	CT_Class_Fwd,
	CT_Class_Body,
	CT_Constructor,
	CT_Constructor_Fwd,
	CT_Destructor,
	CT_Destructor_Fwd,
	CT_Enum,
	CT_Enum_Fwd,
	CT_Enum_Body,
	CT_Enum_Class,
	CT_Enum_Class_Fwd,
	CT_Execution,
	CT_Export_Body,
	CT_Extern_Linkage,
	CT_Extern_Linkage_Body,
	CT_Friend,
	CT_Function,
	CT_Function_Fwd,
	CT_Function_Body,
	CT_Global_Body,
	CT_Module,
	CT_Namespace,
	CT_Namespace_Body,
	CT_Operator,
	CT_Operator_Fwd,
	CT_Operator_Member,
	CT_Operator_Member_Fwd,
	CT_Operator_Cast,
	CT_Operator_Cast_Fwd,
	CT_Parameters,
	CT_Preprocess_Define,
	CT_Preprocess_Include,
	CT_Preprocess_If,
	CT_Preprocess_IfDef,
	CT_Preprocess_IfNotDef,
	CT_Preprocess_ElIf,
	CT_Preprocess_Else,
	CT_Preprocess_EndIf,
	CT_Preprocess_Pragma,
	CT_Specifiers,
	CT_Struct,
	CT_Struct_Fwd,
	CT_Struct_Body,
	CT_Template,
	CT_Typedef,
	CT_Typename,
	CT_Union,
	CT_Union_Fwd,
	CT_Union_Body,
	CT_Using,
	CT_Using_Namespace,
	CT_Variable,
	CT_NumTypes,
	CT_UnderlyingType = GEN_U32_MAX
};

inline Str codetype_to_str( CodeType type )
{
	local_persist Str lookup[61] = {
		{ "Invalid",             sizeof( "Invalid" ) - 1             },
		{ "Untyped",             sizeof( "Untyped" ) - 1             },
		{ "NewLine",             sizeof( "NewLine" ) - 1             },
		{ "Comment",             sizeof( "Comment" ) - 1             },
		{ "Access_Private",      sizeof( "Access_Private" ) - 1      },
		{ "Access_Protected",    sizeof( "Access_Protected" ) - 1    },
		{ "Access_Public",       sizeof( "Access_Public" ) - 1       },
		{ "PlatformAttributes",  sizeof( "PlatformAttributes" ) - 1  },
		{ "Class",               sizeof( "Class" ) - 1               },
		{ "Class_Fwd",           sizeof( "Class_Fwd" ) - 1           },
		{ "Class_Body",          sizeof( "Class_Body" ) - 1          },
		{ "Constructor",         sizeof( "Constructor" ) - 1         },
		{ "Constructor_Fwd",     sizeof( "Constructor_Fwd" ) - 1     },
		{ "Destructor",          sizeof( "Destructor" ) - 1          },
		{ "Destructor_Fwd",      sizeof( "Destructor_Fwd" ) - 1      },
		{ "Enum",                sizeof( "Enum" ) - 1                },
		{ "Enum_Fwd",            sizeof( "Enum_Fwd" ) - 1            },
		{ "Enum_Body",           sizeof( "Enum_Body" ) - 1           },
		{ "Enum_Class",          sizeof( "Enum_Class" ) - 1          },
		{ "Enum_Class_Fwd",      sizeof( "Enum_Class_Fwd" ) - 1      },
		{ "Execution",           sizeof( "Execution" ) - 1           },
		{ "Export_Body",         sizeof( "Export_Body" ) - 1         },
		{ "Extern_Linkage",      sizeof( "Extern_Linkage" ) - 1      },
		{ "Extern_Linkage_Body", sizeof( "Extern_Linkage_Body" ) - 1 },
		{ "Friend",              sizeof( "Friend" ) - 1              },
		{ "Function",            sizeof( "Function" ) - 1            },
		{ "Function_Fwd",        sizeof( "Function_Fwd" ) - 1        },
		{ "Function_Body",       sizeof( "Function_Body" ) - 1       },
		{ "Global_Body",         sizeof( "Global_Body" ) - 1         },
		{ "Module",              sizeof( "Module" ) - 1              },
		{ "Namespace",           sizeof( "Namespace" ) - 1           },
		{ "Namespace_Body",      sizeof( "Namespace_Body" ) - 1      },
		{ "Operator",            sizeof( "Operator" ) - 1            },
		{ "Operator_Fwd",        sizeof( "Operator_Fwd" ) - 1        },
		{ "Operator_Member",     sizeof( "Operator_Member" ) - 1     },
		{ "Operator_Member_Fwd", sizeof( "Operator_Member_Fwd" ) - 1 },
		{ "Operator_Cast",       sizeof( "Operator_Cast" ) - 1       },
		{ "Operator_Cast_Fwd",   sizeof( "Operator_Cast_Fwd" ) - 1   },
		{ "Parameters",          sizeof( "Parameters" ) - 1          },
		{ "Preprocess_Define",   sizeof( "Preprocess_Define" ) - 1   },
		{ "Preprocess_Include",  sizeof( "Preprocess_Include" ) - 1  },
		{ "Preprocess_If",       sizeof( "Preprocess_If" ) - 1       },
		{ "Preprocess_IfDef",    sizeof( "Preprocess_IfDef" ) - 1    },
		{ "Preprocess_IfNotDef", sizeof( "Preprocess_IfNotDef" ) - 1 },
		{ "Preprocess_ElIf",     sizeof( "Preprocess_ElIf" ) - 1     },
		{ "Preprocess_Else",     sizeof( "Preprocess_Else" ) - 1     },
		{ "Preprocess_EndIf",    sizeof( "Preprocess_EndIf" ) - 1    },
		{ "Preprocess_Pragma",   sizeof( "Preprocess_Pragma" ) - 1   },
		{ "Specifiers",          sizeof( "Specifiers" ) - 1          },
		{ "Struct",              sizeof( "Struct" ) - 1              },
		{ "Struct_Fwd",          sizeof( "Struct_Fwd" ) - 1          },
		{ "Struct_Body",         sizeof( "Struct_Body" ) - 1         },
		{ "Template",            sizeof( "Template" ) - 1            },
		{ "Typedef",             sizeof( "Typedef" ) - 1             },
		{ "Typename",            sizeof( "Typename" ) - 1            },
		{ "Union",               sizeof( "Union" ) - 1               },
		{ "Union_Fwd",           sizeof( "Union_Fwd" ) - 1           },
		{ "Union_Body",          sizeof( "Union_Body" ) - 1          },
		{ "Using",               sizeof( "Using" ) - 1               },
		{ "Using_Namespace",     sizeof( "Using_Namespace" ) - 1     },
		{ "Variable",            sizeof( "Variable" ) - 1            },
	};
	return lookup[type];
}

inline Str codetype_to_keyword_str( CodeType type )
{
	local_persist Str lookup[61] = {
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "//",              sizeof( "//" ) - 1              },
		{ "private",         sizeof( "private" ) - 1         },
		{ "protected",       sizeof( "protected" ) - 1       },
		{ "public",          sizeof( "public" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "class",           sizeof( "class" ) - 1           },
		{ "clsss",           sizeof( "clsss" ) - 1           },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "enum",            sizeof( "enum" ) - 1            },
		{ "enum",            sizeof( "enum" ) - 1            },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "enum class",      sizeof( "enum class" ) - 1      },
		{ "enum class",      sizeof( "enum class" ) - 1      },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "extern",          sizeof( "extern" ) - 1          },
		{ "extern",          sizeof( "extern" ) - 1          },
		{ "friend",          sizeof( "friend" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "module",          sizeof( "module" ) - 1          },
		{ "namespace",       sizeof( "namespace" ) - 1       },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "operator",        sizeof( "operator" ) - 1        },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "define",          sizeof( "define" ) - 1          },
		{ "include",         sizeof( "include" ) - 1         },
		{ "if",              sizeof( "if" ) - 1              },
		{ "ifdef",           sizeof( "ifdef" ) - 1           },
		{ "ifndef",          sizeof( "ifndef" ) - 1          },
		{ "elif",            sizeof( "elif" ) - 1            },
		{ "else",            sizeof( "else" ) - 1            },
		{ "endif",           sizeof( "endif" ) - 1           },
		{ "pragma",          sizeof( "pragma" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "struct",          sizeof( "struct" ) - 1          },
		{ "struct",          sizeof( "struct" ) - 1          },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "template",        sizeof( "template" ) - 1        },
		{ "typedef",         sizeof( "typedef" ) - 1         },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "union",           sizeof( "union" ) - 1           },
		{ "union",           sizeof( "union" ) - 1           },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
		{ "using",           sizeof( "using" ) - 1           },
		{ "using namespace", sizeof( "using namespace" ) - 1 },
		{ "__NA__",          sizeof( "__NA__" ) - 1          },
	};
	return lookup[type];
}

forceinline Str to_str( CodeType type )
{
	return codetype_to_str( type );
}

forceinline Str to_keyword_str( CodeType type )
{
	return codetype_to_keyword_str( type );
}
