Release v1.13.42 (2018-05-04)
===

### Service Client Updates
* `service/guardduty`: Updates service API, documentation, and paginators
  * Amazon GuardDuty is adding five new API operations for creating and managing filters. For each filter, you can specify a criteria and an action. The action you specify is applied to findings that match the specified criteria.

Release v1.13.41 (2018-05-03)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for secretsmanager

Release v1.13.40 (2018-05-02)
===

### Service Client Updates
* `service/acm`: Updates service documentation
  * Documentation updates for acm
* `service/codepipeline`: Updates service API and documentation
  * Added support for webhooks with accompanying definitions as needed in the AWS CodePipeline API Guide.
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 Fleet is a new feature that simplifies the provisioning of Amazon EC2 capacity across different EC2 instance types, Availability Zones, and the On-Demand, Reserved Instance, and Spot Instance purchase models. With a single API call, you can now provision capacity to achieve desired scale, performance, and cost.
* `service/ssm`: Updates service API and documentation
  * Added support for new parameter, DocumentVersion, for SendCommand API. Users can now specify version of SSM document to be executed on the target(s).

Release v1.13.39 (2018-04-30)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API, documentation, and paginators
* `service/dynamodb`: Updates service API and documentation
  * Adds two new APIs UpdateGlobalTableSettings and DescribeGlobalTableSettings. This update introduces new constraints in the CreateGlobalTable and UpdateGlobalTable APIs . Tables must have the same write capacity units. If Global Secondary Indexes exist then they must have the same write capacity units and key schema.
* `service/guardduty`: Updates service API and documentation
  * You can disable the email notification when inviting GuardDuty members using the disableEmailNotification parameter in the InviteMembers operation.
* `service/route53domains`: Updates service API and documentation
  * This release adds a SubmittedSince attribute to the ListOperations API, so you can list operations that were submitted after a specified date and time.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker has added support for VPC configuration for both Endpoints and Training Jobs. This allows you to connect from the instances running the Endpoint or Training Job to your VPC and any resources reachable in the VPC rather than being restricted to resources that were internet accessible.
* `service/workspaces`: Updates service API and documentation
  * Added new IP Access Control APIs, an API to change the state of a Workspace, and the ADMIN_MAINTENANCE WorkSpace state. With the new IP Access Control APIs, you can now create/delete IP Access Control Groups, add/delete/update rules for IP Access Control Groups, Associate/Disassociate IP Access Control Groups to/from a WorkSpaces Directory, and Describe IP Based Access Control Groups.

Release v1.13.38 (2018-04-26)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glacier`: Updates service documentation
  * Documentation updates for Glacier to fix a broken link
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for secretsmanager

Release v1.13.37 (2018-04-25)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * AWS CodeDeploy has a new exception that indicates when a GitHub token is not valid.
* `service/rekognition`: Updates service documentation
  * Documentation updates for Amazon Rekognition.
* `service/xray`: Updates service API and documentation
  * Added PutEncryptionConfig and GetEncryptionConfig APIs for managing data encryption settings. Use PutEncryptionConfig to configure X-Ray to use an AWS Key Management Service customer master key to encrypt trace data at rest.

Release v1.13.36 (2018-04-24)
===

### Service Client Updates
* `service/elasticbeanstalk`: Updates service API and documentation
  * Support tracking Elastic Beanstalk resources in AWS Config.
* `service/secretsmanager`: Updates service documentation
  * Documentation updates for secretsmanager

Release v1.13.35 (2018-04-23)
===

### Service Client Updates
* `service/autoscaling-plans`: Updates service API and documentation
* `service/iot`: Updates service API and documentation
  * Add IotAnalyticsAction which sends message data to an AWS IoT Analytics channel
* `service/iotanalytics`: Adds new service

### SDK Enhancements
* `aws/endpoints`: Add Get Region description to endpoints package ([#1909](https://github.com/aws/aws-sdk-go/pull/1909))
  * Adds exposing the description field of the endpoints Region struct.
  * Fixes [#1194](https://github.com/aws/aws-sdk-go/issues/1194)

### SDK Bugs
* Fix XML unmarshaler not correctly unmarshaling list of timestamp values ([#1894](https://github.com/aws/aws-sdk-go/pull/1894))
  * Fixes a bug in the XML unmarshaler that would incorrectly try to unmarshal "time.Time" parameters that did not have the struct tag type on them. This would occur for nested lists like CloudWatch's GetMetricDataResponse MetricDataResults timestamp parameters.
  * Fixes [#1892](https://github.com/aws/aws-sdk-go/issues/1892)
Release v1.13.34 (2018-04-20)
===

### Service Client Updates
* `service/firehose`: Updates service API and documentation
  * With this release, Amazon Kinesis Data Firehose allows you to tag your delivery streams. Tags are metadata that you can create and use to manage your delivery streams. For more information about tagging, see AWS Tagging Strategies. For technical documentation, look for the tagging operations in the Amazon Kinesis Firehose API reference.
* `service/medialive`: Updates service API and documentation
  * With AWS Elemental MediaLive you can now output live channels as RTMP (Real-Time Messaging Protocol) and RTMPS as the encrypted version of the protocol (Secure, over SSL/TLS). RTMP is the preferred protocol for sending live streams to popular social platforms which  means you can send live channel content to social and sharing platforms in a secure and reliable way while continuing to stream to your own website, app or network.

Release v1.13.33 (2018-04-19)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/codepipeline`: Updates service API and documentation
  * Added new SourceRevision structure to Execution Summary with accompanying definitions as needed in the AWS CodePipeline API Guide.
* `service/devicefarm`: Updates service API and documentation
  * Adding support for VPCEndpoint feature. Allows customers to be able to access their private endpoints/services running in their VPC during test automation.
* `service/ec2`: Updates service API and documentation
  * Added support for customers to see the time at which a Dedicated Host was allocated or released.
* `service/rds`: Updates service API and documentation
  * The ModifyDBCluster operation now includes an EngineVersion parameter. You can use this to upgrade the engine for a clustered database.
* `service/secretsmanager`: Updates service documentation and examples
  * Documentation updates
* `service/ssm`: Updates service API and documentation
  * Added new APIs DeleteInventory and DescribeInventoryDeletions, for customers to delete their custom inventory data.

Release v1.13.32 (2018-04-10)
===

### Service Client Updates
* `service/dms`: Updates service API and documentation
  * Native Change Data Capture start point and task recovery support in Database Migration Service.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * "AWS Glue now supports timeout values for ETL jobs. With this release, all new ETL jobs have a default timeout value of 48 hours. AWS Glue also now supports the ability to start a schedule or job events trigger when it is created."
* `service/mediapackage`: Updates service API and documentation
  * Adds a new OriginEndpoint package type CmafPackage in MediaPackage. Origin endpoints can now be configured to use the Common Media Application Format (CMAF) media streaming format. This version of CmafPackage only supports HTTP Live Streaming (HLS) manifests with fragmented MP4.
* `service/ssm`: Updates service API and documentation
  * Added TooManyUpdates exception for AddTagsToResource and RemoveTagsFromResource API
* `service/workmail`: Updates service API, documentation, and paginators
  * Amazon WorkMail adds the ability to grant users and groups with "Full Access", "Send As" and "Send on Behalf" permissions on a given mailbox.

Release v1.13.31 (2018-04-09)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API and documentation
  * Cloud Directory customers can fetch attributes within a facet on an object with the new GetObjectAttributes API and can fetch attributes from multiple facets or objects with the BatchGetObjectAttributes operation.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.30 (2018-04-06)
===

### Service Client Updates
* `service/batch`: Updates service API and documentation
  * Support for Timeout in SubmitJob and RegisterJobDefinition

Release v1.13.29 (2018-04-05)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/ssm`: Updates service documentation

Release v1.13.28 (2018-04-04)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * AWS Certificate Manager has added support for AWS Certificate Manager Private Certificate Authority (CA). Customers can now request private certificates with the RequestCertificate API, and also export private certificates with the ExportCertificate API.
* `service/acm-pca`: Adds new service
* `service/config`: Updates service API and documentation
* `service/fms`: Adds new service
* `service/monitoring`: Updates service API and documentation
  * The new GetMetricData API enables you to collect batch amounts of metric data and optionally perform math expressions on the data. With one GetMetricData call you can retrieve as many as 100 different metrics and a total of 100,800 data points.
* `service/s3`: Updates service API and documentation
  * ONEZONE_IA storage class stores object data in only one Availability Zone at a lower price than STANDARD_IA. This SDK release provides API support for this new storage class.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker is now supporting many additional instance types in previously supported families for Notebooks, Training Jobs, and Endpoints. Training Jobs and Endpoints now support instances in the m5 family in addition to the previously supported instance families. For specific instance types supported please see the documentation for the SageMaker API.
* `service/secretsmanager`: Adds new service
  * AWS Secrets Manager enables you to easily create and manage the secrets that you use in your customer-facing apps.  Instead of embedding credentials into your source code, you can dynamically query Secrets Manager from your app whenever you need credentials.  You can automatically and frequently rotate your secrets without having to deploy updates to your apps.  All secret values are encrypted when they're at rest with AWS KMS, and while they're in transit with HTTPS and TLS.
* `service/transcribe`: Updates service API, documentation, and paginators

Release v1.13.27 (2018-04-03)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * Added Private Device Management feature. Customers can now manage their private devices efficiently - view their status, set labels and apply profiles on them. Customers can also schedule automated tests and remote access sessions on individual instances in their private device fleet.
* `service/lambda`: Updates service API and documentation
  * added nodejs8.10 as a valid runtime
* `service/translate`: Updates service API and documentation

Release v1.13.26 (2018-04-02)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Amazon API Gateway now supports resource policies for APIs making it easier to set access controls for invoking APIs.
* `service/cloudfront`: Adds new service
  * You can now use a new Amazon CloudFront capability called Field-Level Encryption to further enhance the security of sensitive data, such as credit card numbers or personally identifiable information (PII) like social security numbers. CloudFront's field-level encryption further encrypts sensitive data in an HTTPS form using field-specific encryption keys (which you supply) before a POST request is forwarded to your origin. This ensures that sensitive data can only be decrypted and viewed by certain components or services in your application stack. Field-level encryption is easy to setup. Simply configure the fields that have to be further encrypted by CloudFront using the public keys you specify and you can reduce attack surface for your sensitive data.
* `service/es`: Updates service API and documentation
  * This adds Amazon Cognito authentication support to Kibana.

Release v1.13.25 (2018-03-30)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * Documentation updates for acm
* `service/connect`: Adds new service
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.24 (2018-03-29)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API, documentation, and paginators
* `service/cloudformation`: Updates service API and documentation
  * Enabling resource level permission control for StackSets APIs. Adding support for customers to use customized AdministrationRole to create security boundaries between different users.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/greengrass`: Updates service API and documentation
  * Greengrass APIs now support creating Machine Learning resource types and configuring binary data as the input payload for Greengrass Lambda functions.
* `service/ssm`: Updates service API
  * This Patch Manager release supports creating patch baselines for CentOS.

Release v1.13.23 (2018-03-28)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iam`: Updates service API and documentation
  * Add support for Longer Role Sessions. Four APIs manage max session duration: GetRole, ListRoles, CreateRole, and the new API UpdateRole. The max session duration integer attribute is measured in seconds.
* `service/mturk-requester`: Updates service API and documentation
* `service/sts`: Updates service API and documentation
  * Change utilizes the Max Session Duration attribute introduced for IAM Roles and allows STS customers to request session duration up to the Max Session Duration of 12 hours from AssumeRole based APIs.

Release v1.13.22 (2018-03-27)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * AWS Certificate Manager has added support for customers to disable Certificate Transparency logging on a per-certificate basis.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.21 (2018-03-26)
===

### Service Client Updates
* `service/dynamodb`: Updates service API and documentation
  * Point-in-time recovery (PITR) provides continuous backups of your DynamoDB table data. With PITR, you do not have to worry about creating, maintaining, or scheduling backups. You enable PITR on your table and your backup is available for restore at any point in time from the moment you enable it, up to a maximum of the 35 preceding days. PITR provides continuous backups until you explicitly disable it. For more information, see the Amazon DynamoDB Developer Guide.

Release v1.13.20 (2018-03-23)
===

### Service Client Updates
* `service/rds`: Updates service documentation
  * Documentation updates for RDS

Release v1.13.19 (2018-03-22)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Feedback URL allows admins to provide a feedback link or a survey link for collecting user feedback while streaming sessions. When a feedback link is provided, streaming users will see a "Send Feedback" choice in their streaming session toolbar. On selecting this choice, user will be redirected to the link provided in a new browser tab. If a feedback link is not provided, users will not see the "Send Feedback" option.
* `service/codebuild`: Updates service API and documentation
  * Adding support for branch filtering when using webhooks with AWS CodeBuild.
* `service/ecs`: Updates service API and documentation
  * Amazon Elastic Container Service (ECS) now includes integrated Service Discovery using Route 53 Auto Naming. Customers can now specify a Route 53 Auto Naming service as part of an ECS service. ECS will register task IPs with Route 53, making them available via DNS in your VPC.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

### SDK Bugs
* `aws/endpoints`: Use service metadata for fallback signing name ([#1854](https://github.com/aws/aws-sdk-go/pull/1854))
  * Updates the SDK's endpoint resolution to fallback deriving the service's signing name from the service's modeled metadata in addition the the endpoints modeled data.
  * Fixes [#1850](https://github.com/aws/aws-sdk-go/issues/1850)
Release v1.13.18 (2018-03-21)
===

### Service Client Updates
* `service/serverlessrepo`: Updates service documentation

Release v1.13.17 (2018-03-20)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/config`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Amazon ECS users can now mount a temporary volume in memory in containers and specify the shared memory that a container can use through the use of docker's 'tmpfs' and 'shm-size' features respectively. These fields can be specified under linuxParameters in ContainerDefinition in the Task Definition Template.
* `service/elasticbeanstalk`: Updates service documentation
  * Documentation updates for the new Elastic Beanstalk API DescribeAccountAttributes.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/events`: Updates service API and documentation
  * Added SQS FIFO queue target support
* `service/glue`: Updates service API and documentation
  * API Updates for DevEndpoint: PublicKey is now optional for CreateDevEndpoint. The new DevEndpoint field PrivateAddress will be populated for DevEndpoints associated with a VPC.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive has added support for updating Inputs and Input Security Groups. You can update Input Security Groups at any time and it will update all channels using that Input Security Group. Inputs can be updated as long as they are not attached to a currently running channel.

Release v1.13.16 (2018-03-16)
===

### Service Client Updates
* `service/elasticbeanstalk`: Updates service API and documentation
  * AWS Elastic Beanstalk is launching a new public API named DescribeAccountAttributes which allows customers to access account level attributes. In this release, the API will support quotas for resources such as applications, application versions, and environments.

Release v1.13.15 (2018-03-15)
===

### Service Client Updates
* `service/organizations`: Updates service API and documentation
  * This release adds additional reason codes to improve clarity to exceptions that can occur.
* `service/pinpoint`: Updates service API and documentation
  * With this release, you can delete endpoints from your Amazon Pinpoint projects. Customers can now specify one of their leased dedicated long or short codes to send text messages.
* `service/sagemaker`: Updates service API, documentation, and paginators
  * This release provides support for ml.p3.xlarge instance types for notebook instances.  Lifecycle configuration is now available to customize your notebook instances on start; the configuration can be reused between multiple notebooks.  If a notebook instance is attached to a VPC you can now opt out of internet access that by default is provided by SageMaker.

Release v1.13.14 (2018-03-14)
===

### Service Client Updates
* `service/lightsail`: Updates service API and documentation
  * Updates to existing Lightsail documentation

Release v1.13.13 (2018-03-13)
===

### Service Client Updates
* `service/servicediscovery`: Updates service API and documentation
  * This release adds support for custom health checks, which let you check the health of resources that aren't accessible over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.

Release v1.13.12 (2018-03-12)
===

### Service Client Updates
* `service/cloudhsmv2`: Updates service API
  * CreateCluster can now take both 8 and 17 character Subnet IDs. DeleteHsm can now take both 8 and 17 character ENI IDs.
* `service/discovery`: Updates service API and documentation
  * Documentation updates for discovery
* `service/iot`: Updates service API and documentation
  * We added new fields to the response of the following APIs. (1) describe-certificate: added new generationId, customerVersion fields (2) describe-ca-certificate: added new generationId, customerVersion and lastModifiedDate fields (3) get-policy: added generationId, creationDate and lastModifiedDate fields
* `service/redshift`: Updates service API and documentation
  * DescribeClusterSnapshotsMessage with ClusterExists flag returns snapshots of existing clusters. Else both existing and deleted cluster snapshots are returned

Release v1.13.11 (2018-03-08)
===

### Service Client Updates
* `service/AWSMigrationHub`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Amazon Elastic Container Service (ECS) now supports container health checks. Customers can now specify a docker container health check command and parameters in their task definition. ECS will monitor, report and take scheduling action based on the health status.
* `service/pinpoint`: Updates service API and documentation
  * With this release, you can export endpoints from your Amazon Pinpoint projects. You can export a) all of the endpoints assigned to a project or b) the subset of endpoints assigned to a segment.
* `service/rds`: Updates service documentation
  * Documentation updates for RDS

Release v1.13.10 (2018-03-07)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/medialive`: Updates service API and documentation
  * Updates API to model required traits and minimum/maximum constraints.

Release v1.13.9 (2018-03-06)
===

### Service Client Updates
* `service/ecs`: Updates service documentation
  * Documentation updates for Amazon ECS
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.8 (2018-03-01)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Added support for modifying Placement Group association of instances via ModifyInstancePlacement API.
* `service/events`: Updates service API and documentation
  * Added BatchParameters to the PutTargets API
* `service/servicecatalog`: Updates service API and documentation
  * This release of ServiceCatalog adds the DeleteTagOption API.
* `service/ssm`: Updates service API and documentation
  * This Inventory release supports the status message details reported by the last sync for the resource data sync API.
* `service/storagegateway`: Updates service API and documentation
  * AWS Storage Gateway (File) support for two new file share attributes are added.           1. Users can specify the S3 Canned ACL to use for new objects created in the file share.         2. Users can create file shares for requester-pays buckets.

Release v1.13.7 (2018-02-28)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.6 (2018-02-27)
===

### Service Client Updates
* `service/ecr`: Updates service documentation
  * Documentation updates for Amazon ECR.

Release v1.13.5 (2018-02-26)
===

### Service Client Updates
* `service/route53`: Updates service API
  * Added support for creating LBR rules using ap-northeast-3 region.
* `service/sts`: Updates service API and documentation
  * Increased SAMLAssertion parameter size from 50000 to 100000 for AWS Security Token Service AssumeRoleWithSAML API to allow customers to pass bigger SAML assertions

Release v1.13.4 (2018-02-23)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This API update is to enable customers to copy their Amazon AppStream 2.0 images within and between AWS Regions
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.3 (2018-02-22)
===

### Service Client Updates
* `service/ce`: Updates service API and documentation
* `service/elasticloadbalancingv2`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.13.2 (2018-02-21)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * This release adds an API for adding a file directly to an AWS CodeCommit repository without requiring a Git client.
* `service/ec2`: Updates service API and documentation
  * Adds support for tagging an EBS snapshot as part of the API call that creates the EBS snapshot
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/serverlessrepo`: Updates service API, documentation, and paginators

Release v1.13.1 (2018-02-20)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Amazon EC2 Auto Scaling support for service-linked roles
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/waf`: Updates service API and documentation
  * The new PermissionPolicy APIs in AWS WAF Regional allow customers to attach resource-based policies to their entities.
* `service/waf-regional`: Updates service API and documentation

Release v1.13.0 (2018-02-19)
===

### Service Client Updates
* `service/config`: Updates service API
  * With this release, AWS Config updated the ConfigurationItemStatus enum values. The values prior to this update did not represent appropriate values returned by GetResourceConfigHistory. You must update your code to enumerate the new enum values so this is a breaking change. To map old properties to new properties, use the following descriptions: New discovered resource - Old property: Discovered, New property: ResourceDiscovered. Updated resource - Old property: Ok, New property: OK. Deleted resource - Old property: Deleted, New property: ResourceDeleted or ResourceDeletedNotRecorded. Not-recorded resource - Old property: N/A, New property: ResourceNotRecorded or ResourceDeletedNotRecorded.

Release v1.12.79 (2018-02-16)
===

### Service Client Updates
* `service/rds`: Updates service API and documentation
  * Updates RDS API to indicate whether a DBEngine supports read replicas.

Release v1.12.78 (2018-02-15)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/gamelift`: Updates service API and documentation
  * Updates to allow Fleets to run on On-Demand or Spot instances.
* `service/mediaconvert`: Updates service API and documentation
  * Nielsen ID3 tags can now be inserted into transport stream (TS) and HLS outputs. For more information on Nielsen configuration you can go to https://docs.aws.amazon.com/mediaconvert/latest/apireference/jobs.html#jobs-nielsenconfiguration

Release v1.12.77 (2018-02-14)
===

### Service Client Updates
* `service/appsync`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lex-models`: Updates service API and documentation

Release v1.12.76 (2018-02-13)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glacier`: Updates service documentation
  * Documentation updates for glacier
* `service/route53`: Updates service API
  * Added support for creating Private Hosted Zones and metric-based healthchecks in the ap-northeast-3 region for whitelisted customers.

Release v1.12.75 (2018-02-12)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Network interfaces now supply the following additional status of "associated" to better distinguish the current status.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/guardduty`: Updates service API and documentation
  * Added PortProbeAction information to the Action section of the port probe-type finding.
* `service/kms`: Updates service API
  * This release of AWS Key Management Service includes support for InvalidArnException in the RetireGrant API.
* `service/rds`: Updates service documentation
  * Aurora MySQL now supports MySQL 5.7.

Release v1.12.74 (2018-02-09)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Users can now better understand the longer ID opt-in status of their account using the two new APIs DescribeAggregateIdFormat and DescribePrincipalIdFormat
* `service/lex-models`: Updates service API and documentation
* `service/runtime.lex`: Updates service API and documentation

Release v1.12.73 (2018-02-08)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Adds support for allowing customers to provide a redirect URL for a stack. Users will be redirected to the link provided by the admin at the end of their streaming session.
* `service/budgets`: Updates service API and documentation
  * Making budgetLimit and timePeriod optional, and updating budgets docs.
* `service/dms`: Updates service API, documentation, and paginators
  * This release includes the addition of two new APIs: describe replication instance task logs and reboot instance. The first allows user to see how much storage each log for a task on a given instance is occupying. The second gives users the option to reboot the application software on the instance and force a fail over for MAZ instances to test robustness of their integration with our service.
* `service/ds`: Updates service API
  * Updated the regex of some input parameters to support longer EC2 identifiers.
* `service/dynamodb`: Updates service API and documentation
  * Amazon DynamoDB now supports server-side encryption using a default service key (alias/aws/dynamodb) from the AWS Key Management Service (KMS). AWS KMS is a service that combines secure, highly available hardware and software to provide a key management system scaled for the cloud. AWS KMS is used via the AWS Management Console or APIs to centrally create encryption keys, define the policies that control how keys can be used, and audit key usage to prove they are being used correctly. For more information, see the Amazon DynamoDB Developer Guide.
* `service/gamelift`: Updates service API and documentation
  * Amazon GameLift FlexMatch added the StartMatchBackfill API.  This API allows developers to add new players to an existing game session using the same matchmaking rules and player data that were used to initially create the session.
* `service/medialive`: Updates service API and documentation
  * AWS Elemental MediaLive has added support for updating channel settings for idle channels. You can now update channel name, channel outputs and output destinations, encoder settings, user role ARN, and input specifications. Channel settings can be updated in the console or with API calls. Please note that running channels need to be stopped before they can be updated. We've also deprecated the 'Reserved' field.
* `service/mediastore`: Updates service API and documentation
  * AWS Elemental MediaStore now supports per-container CORS configuration.

Release v1.12.72 (2018-02-07)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * This new feature will now allow customers to add a customized json classifier. They can specify a json path to indicate the object, array or field of the json documents they'd like crawlers to inspect when they crawl json files.
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * This release of Service Catalog adds SearchProvisionedProducts API and ProvisionedProductPlan APIs.
* `service/servicediscovery`: Updates service API and documentation
  * This release adds support for registering CNAME record types and creating Route 53 alias records that route traffic to Amazon Elastic Load Balancers using Amazon Route 53 Auto Naming APIs.
* `service/ssm`: Updates service API and documentation
  * This Patch Manager release supports configuring Linux repos as part of patch baselines, controlling updates of non-OS security packages and also creating patch baselines for SUSE12

### SDK Enhancements
* `private/model/api`: Add validation to ensure there is no duplication of services in models/apis ([#1758](https://github.com/aws/aws-sdk-go/pull/1758))
    * Prevents the SDK from mistakenly generating code a single service multiple times with different model versions.
* `example/service/ec2/instancesbyRegion`: Fix typos in example ([#1762](https://github.com/aws/aws-sdk-go/pull/1762))
* `private/model/api`: removing SDK API reference crosslinks from input/output shapes. (#1765) 

### SDK Bugs
* `aws/session`: Fix bug in session.New not supporting AWS_SDK_LOAD_CONFIG ([#1770](https://github.com/aws/aws-sdk-go/pull/1770))
    * Fixes a bug in the session.New function that was not correctly sourcing the shared configuration files' path.
    * Fixes [#1771](https://github.com/aws/aws-sdk-go/pull/1771)
Release v1.12.71 (2018-02-05)
===

### Service Client Updates
* `service/acm`: Updates service documentation
  * Documentation updates for acm
* `service/cloud9`: Updates service documentation and examples
  * API usage examples for AWS Cloud9.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kinesis`: Updates service API and documentation
  * Using ListShards a Kinesis Data Streams customer or client can get information about shards in a data stream (including meta-data for each shard) without obtaining data stream level information.
* `service/opsworks`: Updates service API, documentation, and waiters
  * AWS OpsWorks Stacks supports EBS encryption and HDD volume types. Also, a new DescribeOperatingSystems API is available, which lists all operating systems supported by OpsWorks Stacks.

Release v1.12.70 (2018-01-26)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * Add InteractionMode in CreateRemoteAccessSession for DirectDeviceAccess feature.
* `service/medialive`: Updates service API and documentation
  * Add InputSpecification to CreateChannel (specification of input attributes is used for channel sizing and affects pricing);  add NotFoundException to DeleteInputSecurityGroups.
* `service/mturk-requester`: Updates service documentation

Release v1.12.69 (2018-01-26)
===

### SDK Bugs
* `models/api`: Fix colliding names [#1754](https://github.com/aws/aws-sdk-go/pull/1754) [#1756](https://github.com/aws/aws-sdk-go/pull/1756)
    * SDK had duplicate folders that were causing errors in some builds.
    * Fixes [#1753](https://github.com/aws/aws-sdk-go/issues/1753)
Release v1.12.68 (2018-01-25)
===

### Service Client Updates
* `service/alexaforbusiness`: Updates service API and documentation
* `service/codebuild`: Updates service API and documentation
  * Adding support for Shallow Clone and GitHub Enterprise in AWS CodeBuild.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/guardduty`: Adds new service
  * Added the missing AccessKeyDetails object to the resource shape.
* `service/lambda`: Updates service API and documentation
  * AWS Lambda now supports Revision ID on your function versions and aliases, to track and apply conditional updates when you are updating your function version or alias resources.

### SDK Bugs
* `service/s3/s3manager`: Fix check for nil OrigErr in Error() [#1749](https://github.com/aws/aws-sdk-go/issues/1749)
    * S3 Manager's `Error` type did not check for nil of `OrigErr` when calling `Error()`
    * Fixes [#1748](https://github.com/aws/aws-sdk-go/issues/1748)
Release v1.12.67 (2018-01-22)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Add additional costTypes: IncludeDiscount, UseAmortized,  to support finer control for different charges included in a cost budget.

Release v1.12.66 (2018-01-19)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glue`: Updates service API and documentation
  * New AWS Glue DataCatalog APIs to manage table versions and a new feature to skip archiving of the old table version when updating table.
* `service/transcribe`: Adds new service

Release v1.12.65 (2018-01-18)
===

### Service Client Updates
* `service/sagemaker`: Updates service API and documentation
  * CreateTrainingJob and CreateEndpointConfig now supports KMS Key for volume encryption.

Release v1.12.64 (2018-01-17)
===

### Service Client Updates
* `service/autoscaling-plans`: Updates service documentation
* `service/ec2`: Updates service documentation
  * Documentation updates for EC2

Release v1.12.63 (2018-01-17)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/autoscaling-plans`: Adds new service
* `service/rds`: Updates service API and documentation
  * With this release you can now integrate RDS DB instances with CloudWatch Logs. We have added parameters to the operations for creating and modifying DB instances (for example CreateDBInstance) to allow you to take advantage of this capability through the CLI and API. Once you enable this feature, a stream of log events will publish to CloudWatch Logs for each log type you enable.

Release v1.12.62 (2018-01-15)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lambda`: Updates service API and documentation
  * Support for creating Lambda Functions using 'dotnetcore2.0' and 'go1.x'.

Release v1.12.61 (2018-01-12)
===

### Service Client Updates
* `service/glue`: Updates service API and documentation
  * Support is added to generate ETL scripts in Scala which can now be run by  AWS Glue ETL jobs. In addition, the trigger API now supports firing when any conditions are met (in addition to all conditions). Also, jobs can be triggered based on a "failed" or "stopped" job run (in addition to a "succeeded" job run).

Release v1.12.60 (2018-01-11)
===

### Service Client Updates
* `service/elasticloadbalancing`: Updates service API and documentation
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/rds`: Updates service API and documentation
  * Read Replicas for Amazon RDS for MySQL, MariaDB, and PostgreSQL now support Multi-AZ deployments.Amazon RDS Read Replicas enable you to create one or more read-only copies of your database instance within the same AWS Region or in a different AWS Region. Updates made to the source database are asynchronously copied to the Read Replicas. In addition to providing scalability for read-heavy workloads, you can choose to promote a Read Replica to become standalone a DB instance when needed.Amazon RDS Multi-AZ Deployments provide enhanced availability for database instances within a single AWS Region. With Multi-AZ, your data is synchronously replicated to a standby in a different Availability Zone (AZ). In case of an infrastructure failure, Amazon RDS performs an automatic failover to the standby, minimizing disruption to your applications.You can now combine Read Replicas with Multi-AZ as part of a disaster recovery strategy for your production databases. A well-designed and tested plan is critical for maintaining business continuity after a disaster. Since Read Replicas can also be created in different regions than the source database, your Read Replica can be promoted to become the new production database in case of a regional disruption.You can also combine Read Replicas with Multi-AZ for your database engine upgrade process. You can create a Read Replica of your production database instance and upgrade it to a new database engine version. When the upgrade is complete, you can stop applications, promote the Read Replica to a standalone database instance and switch over your applications. Since the database instance is already a Multi-AZ deployment, no additional steps are needed.For more information, see the Amazon RDS User Guide.
* `service/ssm`: Updates service documentation
  * Updates documentation for the HierarchyLevelLimitExceededException error.

Release v1.12.59 (2018-01-09)
===

### Service Client Updates
* `service/kms`: Updates service documentation
  * Documentation updates for AWS KMS

Release v1.12.58 (2018-01-09)
===

### Service Client Updates
* `service/ds`: Updates service API and documentation
  * On October 24 we introduced AWS Directory Service for Microsoft Active Directory (Standard Edition), also known as AWS Microsoft AD (Standard Edition), which is a managed Microsoft Active Directory (AD) that is optimized for small and midsize businesses (SMBs). With this SDK release, you can now create an AWS Microsoft AD directory using API. This enables you to run typical SMB workloads using a cost-effective, highly available, and managed Microsoft AD in the AWS Cloud.

Release v1.12.57 (2018-01-08)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * The AWS CodeDeploy API was updated to support DeleteGitHubAccountToken, a new method that deletes a GitHub account connection.
* `service/discovery`: Updates service API and documentation
  * Documentation updates for AWS Application Discovery Service.
* `service/route53`: Updates service API and documentation
  * This release adds an exception to the CreateTrafficPolicyVersion API operation.

Release v1.12.56 (2018-01-05)
===

### Service Client Updates
* `service/inspector`: Updates service API, documentation, and examples
  * Added 2 new attributes to the DescribeAssessmentTemplate response, indicating the total number of assessment runs and last assessment run ARN (if present.)
* `service/snowball`: Updates service documentation
  * Documentation updates for snowball
* `service/ssm`: Updates service documentation
  * Documentation updates for ssm

Release v1.12.55 (2018-01-02)
===

### Service Client Updates
* `service/rds`: Updates service documentation
  * Documentation updates for rds

Release v1.12.54 (2017-12-29)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/workspaces`: Updates service API and documentation
  * Modify WorkSpaces have been updated with flexible storage and switching of hardware bundles feature. The following configurations have been added to ModifyWorkSpacesProperties: storage and compute. This update provides the capability to configure the storage of a WorkSpace. It also adds the capability of switching hardware bundle of a WorkSpace by specifying an eligible compute (Value, Standard, Performance, Power).

Release v1.12.53 (2017-12-22)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * This release fixes an issue with tags not showing in DescribeAddresses responses.
* `service/ecs`: Updates service API and documentation
  * Amazon ECS users can now set a health check initialization wait period of their ECS services, the services that are associated with an Elastic Load Balancer (ELB) will wait for a period of time before the ELB become healthy. You can now configure this in Create and Update Service.
* `service/inspector`: Updates service API and documentation
  * PreviewAgents API now returns additional fields within the AgentPreview data type. The API now shows the agent health and availability status for all instances included in the assessment target. This allows users to check the health status of Inspector Agents before running an assessment. In addition, it shows the instance ID, hostname, and IP address of the targeted instances.
* `service/sagemaker`: Updates service API and documentation
  * SageMaker Models no longer support SupplementalContainers.  API's that have been affected are CreateModel and DescribeModel.

Release v1.12.52 (2017-12-21)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Adding support allowing AWS CodeBuild customers to select specific curated image versions.
* `service/ec2`: Updates service API and documentation
  * Elastic IP tagging enables you to add key and value metadata to your Elastic IPs so that you can search, filter, and organize them according to your organization's needs.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kinesisanalytics`: Updates service API and documentation
  * Kinesis Analytics now supports AWS Lambda functions as output.

Release v1.12.51 (2017-12-21)
===

### Service Client Updates
* `service/config`: Updates service API
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot`: Updates service API and documentation
  * This release adds support for code signed Over-the-air update functionality for Amazon FreeRTOS. Users can now create and schedule Over-the-air updates to their Amazon FreeRTOS devices using these new APIs.

Release v1.12.50 (2017-12-19)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * API Gateway now adds support for calling API with compressed payloads using one of the supported content codings, tagging an API stage for cost allocation, and returning API keys from a custom authorizer for use with a usage plan.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mediastore-data`: Updates service documentation
* `service/route53`: Updates service API and documentation
  * Route 53 added support for a new China (Ningxia) region, cn-northwest-1. You can now specify cn-northwest-1 as the region for latency-based or geoproximity routing. Route 53 also added support for a new EU (Paris) region, eu-west-3. You can now associate VPCs in eu-west-3 with private hosted zones and create alias records that route traffic to resources in eu-west-3.

Release v1.12.49 (2017-12-19)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/monitoring`: Updates service documentation
  * Documentation updates for monitoring

Release v1.12.48 (2017-12-15)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This API update is to enable customers to add tags to their Amazon AppStream 2.0 resources

Release v1.12.47 (2017-12-14)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Adds support for Cognito Authorizer scopes at the API method level.
* `service/email`: Updates service documentation
  * Added information about the maximum number of transactions per second for the SendCustomVerificationEmail operation.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.46 (2017-12-12)
===

### Service Client Updates
* `service/workmail`: Adds new service
  * Today, Amazon WorkMail released an administrative SDK and enabled AWS CloudTrail integration. With the administrative SDK, you can natively integrate WorkMail with your existing services. The SDK enables programmatic user, resource, and group management through API calls. This means your existing IT tools and workflows can now automate WorkMail management, and third party applications can streamline WorkMail migrations and account actions.

Release v1.12.45 (2017-12-11)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lex-models`: Updates service API and documentation
* `service/sagemaker`: Updates service API
  * CreateModel API Update:  The request parameter 'ExecutionRoleArn' has changed from optional to required.

Release v1.12.44 (2017-12-08)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * This API update is to support the feature that allows customers to automatically consume the latest Amazon AppStream 2.0 agent as and when published by AWS.
* `service/ecs`: Updates service documentation
  * Documentation updates for Windows containers.
* `service/monitoring`: Updates service API and documentation
  * With this launch, you can now create a CloudWatch alarm that alerts you when M out of N datapoints of a metric are breaching your predefined threshold, such as three out of five times in any given five minutes interval or two out of six times in a thirty minutes interval. When M out of N datapoints are not breaching your threshold in an interval, the alarm will be in OK state. Please note that the M datapoints out of N datapoints in an interval can be of any order and does not need to be consecutive. Consequently, you can now get alerted even when the spikes in your metrics are intermittent over an interval.

Release v1.12.43 (2017-12-07)
===

### Service Client Updates
* `service/email`: Updates service API, documentation, and paginators
  * Customers can customize the emails that Amazon SES sends when verifying new identities. This feature is helpful for developers whose applications send email through Amazon SES on behalf of their customers.
* `service/es`: Updates service API and documentation
  * Added support for encryption of data at rest on Amazon Elasticsearch Service using AWS KMS

### SDK Bugs
* `models/apis` Fixes removes colliding sagemaker models folders ([#1686](https://github.com/aws/aws-sdk-go/pull/1686))
  * Fixes Release v1.12.42's SageMaker vs sagemaker model folders.
Release v1.12.42 (2017-12-06)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API and documentation
  * Amazon Cloud Directory makes it easier for you to apply schema changes across your directories with in-place schema upgrades. Your directories now remain available while backward-compatible schema changes are being applied, such as the addition of new fields. You also can view the history of your schema changes in Cloud Directory by using both major and minor version identifiers, which can help you track and audit schema versions across directories.
* `service/elasticbeanstalk`: Updates service documentation
  * Documentation updates for AWS Elastic Beanstalk.
* `service/sagemaker`: Adds new service
  * Initial waiters for common SageMaker workflows.

Release v1.12.41 (2017-12-05)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * Add error action API for RulesEngine.
* `service/servicecatalog`: Updates service API and documentation
  * ServiceCatalog has two distinct personas for its use, an "admin" persona (who creates sets of products with different versions and prescribes who has access to them) and an "end-user" persona (who can launch cloud resources based on the configuration data their admins have given them access to).  This API update will allow admin users to deactivate/activate product versions, end-user will only be able to access and launch active product versions.
* `service/servicediscovery`: Adds new service
  * Amazon Route 53 Auto Naming lets you configure public or private namespaces that your microservice applications run in. When instances of the service become available, you can call the Auto Naming API to register the instance, and Amazon Route 53 automatically creates up to five DNS records and an optional health check. Clients that submit DNS queries for the service receive an answer that contains up to eight healthy records.

Release v1.12.40 (2017-12-04)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Add additional costTypes to support finer control for different charges included in a cost budget.
* `service/ecs`: Updates service documentation
  * Documentation updates for ecs

Release v1.12.39 (2017-12-01)
===

### Service Client Updates
* `service/SageMaker`: Updates service waiters

Release v1.12.38 (2017-11-30)
===

### Service Client Updates
* `service/AWSMoneypenny`: Adds new service
* `service/Cloud9`: Adds new service
* `service/Serverless Registry`: Adds new service
* `service/apigateway`: Updates service API, documentation, and paginators
  * Added support Private Integration and VPC Link features in API Gateway. This allows to create an API with the API Gateway private integration, thus providing clients access to HTTP/HTTPS resources in an Amazon VPC from outside of the VPC through a VpcLink resource.
* `service/ec2`: Updates service API and documentation
  * Adds the following updates: 1. Spread Placement ensures that instances are placed on distinct hardware in order to reduce correlated failures. 2. Inter-region VPC Peering allows customers to peer VPCs across different AWS regions without requiring additional gateways, VPN connections or physical hardware
* `service/lambda`: Updates service API and documentation
  * AWS Lambda now supports the ability to set the concurrency limits for individual functions, and increasing memory to 3008 MB.

Release v1.12.37 (2017-11-30)
===

### Service Client Updates
* `service/Ardi`: Adds new service
* `service/autoscaling`: Updates service API and documentation
  * You can now use Auto Scaling with EC2 Launch Templates via the CreateAutoScalingGroup and UpdateAutoScalingGroup APIs.
* `service/ec2`: Updates service API and documentation
  * Adds the following updates: 1. T2 Unlimited enables high CPU performance for any period of time whenever required 2. You are now able to create and launch EC2 m5 and h1 instances
* `service/lightsail`: Updates service API and documentation
  * This release adds support for load balancer and TLS/SSL certificate management. This set of APIs allows customers to create, manage, and scale secure load balanced applications on Lightsail infrastructure. To provide support for customers who manage their DNS on Lightsail, we've added the ability create an Alias A type record which can point to a load balancer DNS name via the CreateDomainEntry API http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDomainEntry.html.
* `service/ssm`: Updates service API and documentation
  * This release updates AWS Systems Manager APIs to enable executing automations at controlled rate, target resources in a resource groups and execute entire automation at once or single step at a time. It is now also possible to use YAML, in addition to JSON, when creating Systems Manager documents.
* `service/waf`: Updates service API and documentation
  * This release adds support for rule group and managed rule group. Rule group is a container of rules that customers can create, put rules in it and associate the rule group to a WebACL. All rules in a rule group will function identically as they would if each rule was individually associated to the WebACL. Managed rule group is a pre-configured rule group composed by our security partners and made available via the AWS Marketplace. Customers can subscribe to these managed rule groups, associate the managed rule group to their WebACL and start using them immediately to protect their resources.
* `service/waf-regional`: Updates service API and documentation

Release v1.12.36 (2017-11-29)
===

### Service Client Updates
* `service/DeepInsight`: Adds new service
* `service/IronmanRuntime`: Adds new service
* `service/Orchestra - Laser`: Adds new service
* `service/SageMaker`: Adds new service
* `service/Shine`: Adds new service
* `service/archived.kinesisvideo`: Adds new service
* `service/data.kinesisvideo`: Adds new service
* `service/dynamodb`: Updates service API and documentation
  * Amazon DynamoDB now supports the following features: Global Table and On-Demand Backup. Global Table is a fully-managed, multi-region, multi-master database. DynamoDB customers can now write anywhere and read anywhere with single-digit millisecond latency by performing database operations closest to where end users reside. Global Table also enables customers to disaster-proof their applications, keeping them running and data accessible even in the face of natural disasters or region disruptions. Customers can set up Global Table with just a few clicks in the AWS Management Console-no application rewrites required. On-Demand Backup capability is to protect data from loss due to application errors, and meet customers' archival needs for compliance and regulatory reasons. Customers can backup and restore their DynamoDB table data anytime, with a single-click in the AWS management console or a single API call. Backup and restore actions execute with zero impact on table performance or availability. For more information, see the Amazon DynamoDB Developer Guide.
* `service/ecs`: Updates service API and documentation
  * Amazon Elastic Container Service (Amazon ECS) released a new launch type for running containers on a serverless infrastructure. The Fargate launch type allows you to run your containerized applications without the need to provision and manage the backend infrastructure. Just register your task definition and Fargate launches the container for you.
* `service/glacier`: Updates service API and documentation
  * This release includes support for Glacier Select, a new feature that allows you to filter and analyze your Glacier archives and store the results in a user-specified S3 location.
* `service/greengrass`: Updates service API and documentation
  * Greengrass OTA feature allows updating Greengrass Core and Greengrass OTA Agent. Local Resource Access feature allows Greengrass Lambdas to access local resources such as peripheral devices and volumes.
* `service/iot`: Updates service API and documentation
  * This release adds support for a number of new IoT features, including AWS IoT Device Management (Jobs, Fleet Index and Thing Registration), Thing Groups, Policies on Thing Groups, Registry & Job Events, JSON Logs, Fine-Grained Logging Controls, Custom Authorization and AWS Service Authentication Using X.509 Certificates.
* `service/kinesisvideo`: Adds new service
  * Announcing Amazon Kinesis Video Streams, a fully managed video ingestion and storage service. Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for machine learning, analytics, and processing. You can also stream other time-encoded data like RADAR and LIDAR signals using Kinesis Video Streams.
* `service/rekognition`: Updates service API, documentation, and paginators
  * This release introduces Amazon Rekognition support for video analysis.
* `service/s3`: Updates service API and documentation
  * This release includes support for Glacier Select, a new feature that allows you to filter and analyze your Glacier storage class objects and store the results in a user-specified S3 location.

Release v1.12.35 (2017-11-29)
===

### Service Client Updates
* `service/AmazonMQ`: Adds new service
* `service/GuardDuty`: Adds new service
* `service/apigateway`: Updates service API and documentation
  * Changes related to CanaryReleaseDeployment feature. Enables API developer to create a deployment as canary deployment and test API changes with percentage of customers before promoting changes to all customers.
* `service/batch`: Updates service API and documentation
  * Add support for Array Jobs which allow users to easily submit many copies of a job with a single API call. This change also enhances the job dependency model to support N_TO_N and sequential dependency chains. The ListJobs and DescribeJobs APIs now have the ability to list or describe the status of entire Array Jobs or individual elements within the array.
* `service/cognito-idp`: Updates service API and documentation
* `service/deepdish`: Adds new service
  * AWS AppSync is an enterprise-level, fully managed GraphQL service with real-time data synchronization and offline programming features.
* `service/ec2`: Updates service API and documentation
  * Adds the following updates: 1. You are now able to host a service powered by AWS PrivateLink to provide private connectivity to other VPCs. You are now also able to create endpoints to other services powered by PrivateLink including AWS services, Marketplace Seller services or custom services created by yourself or other AWS VPC customers. 2. You are now able to save launch parameters in a single template that can be used with Auto Scaling, Spot Fleet, Spot, and On Demand instances. 3. You are now able to launch Spot instances via the RunInstances API, using a single additional parameter. RunInstances will response synchronously with an instance ID should capacity be available for your Spot request. 4. A simplified Spot pricing model which delivers low, predictable prices that adjust gradually, based on long-term trends in supply and demand. 5. Amazon EC2 Spot can now hibernate Amazon EBS-backed instances in the event of an interruption, so your workloads pick up from where they left off. Spot can fulfill your request by resuming instances from a hibernated state when capacity is available.
* `service/lambda`: Updates service API and documentation
  * Lambda aliases can now shift traffic between two function versions, based on preassigned weights.

Release v1.12.34 (2017-11-27)
===

### Service Client Updates
* `service/data.mediastore`: Adds new service
* `service/mediaconvert`: Adds new service
  * AWS Elemental MediaConvert is a file-based video conversion service that transforms media into formats required for traditional broadcast and for internet streaming to multi-screen devices.
* `service/medialive`: Adds new service
  * AWS Elemental MediaLive is a video service that lets you easily create live outputs for broadcast and streaming delivery.
* `service/mediapackage`: Adds new service
  * AWS Elemental MediaPackage is a just-in-time video packaging and origination service that lets you format highly secure and reliable live outputs for a variety of devices.
* `service/mediastore`: Adds new service
  * AWS Elemental MediaStore is an AWS storage service optimized for media. It gives you the performance, consistency, and low latency required to deliver live and on-demand video content. AWS Elemental MediaStore acts as the origin store in your video workflow.

Release v1.12.33 (2017-11-22)
===

### Service Client Updates
* `service/acm`: Updates service API and documentation
  * AWS Certificate Manager now supports the ability to import domainless certs and additional Key Types as well as an additional validation method for DNS.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.32 (2017-11-22)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Add support for Access logs and customizable integration timeouts
* `service/cloudformation`: Updates service API and documentation
  * 1) Instance-level parameter overrides (CloudFormation-StackSet feature): This feature will allow the customers to override the template parameters on specific stackInstances. Customers will also have ability to update their existing instances with/without parameter-overrides using a new API "UpdateStackInstances"                                                                                                                                                                                                                                                         2) Add support for SSM parameters in CloudFormation - This feature will allow the customers to use Systems Manager parameters in CloudFormation templates. They will be able to see values for these parameters in Describe APIs.
* `service/codebuild`: Updates service API and documentation
  * Adding support for accessing Amazon VPC resources from AWS CodeBuild, dependency caching and build badges.
* `service/elasticmapreduce`: Updates service API and documentation
  * Enable Kerberos on Amazon EMR.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rekognition`: Updates service API and documentation
  * This release includes updates to Amazon Rekognition for the following APIs. The new DetectText API allows you to recognize and extract textual content from images. Face Model Versioning has been added to operations that deal with face detection.
* `service/shield`: Updates service API, documentation, and paginators
  * The AWS Shield SDK has been updated in order to support Elastic IP address protections, the addition of AttackProperties objects in DescribeAttack responses, and a new GetSubscriptionState operation.
* `service/storagegateway`: Updates service API and documentation
  * AWS Storage Gateway now enables you to get notification when all your files written to your NFS file share have been uploaded to Amazon S3. Storage Gateway also enables guessing of the MIME type for uploaded objects based on file extensions.
* `service/xray`: Updates service API, documentation, and paginators
  * Added automatic pagination support for AWS X-Ray APIs in the SDKs that support this feature.

Release v1.12.31 (2017-11-20)
===

### Service Client Updates
* `service/apigateway`: Updates service documentation
  * Documentation updates for Apigateway
* `service/codecommit`: Updates service API, documentation, and paginators
  * AWS CodeCommit now supports pull requests. You can use pull requests to collaboratively review code changes for minor changes or fixes, major feature additions, or new versions of your released software.
* `service/firehose`: Updates service API and documentation
  * This release includes a new Kinesis Firehose feature that supports Splunk as Kinesis Firehose delivery destination. You can now use Kinesis Firehose to ingest real-time data to Splunk in a serverless, reliable, and salable manner. This release also includes a new feature that allows you to configure Lambda buffer size in Kinesis Firehose data transformation feature. You can now customize the data buffer size before invoking Lambda function in Kinesis Firehose for data transformation. This feature allows you to flexibly trade-off processing and delivery latency with cost and efficiency based on your specific use cases and requirements.
* `service/iis`: Adds new service
  * The AWS Cost Explorer API gives customers programmatic access to AWS cost and usage information, allowing them to perform adhoc queries and build interactive cost management applications that leverage this dataset.
* `service/kinesis`: Updates service API and documentation
  * Customers can now obtain the important characteristics of their stream with DescribeStreamSummary. The response will not include the shard list for the stream but will have the number of open shards, and all the other fields included in the DescribeStream response.
* `service/workdocs`: Updates service API and documentation
  * DescribeGroups API and miscellaneous enhancements

### SDK Bugs
* `aws/client`: Retry delays for throttled exception were not limited to 5 mintues [#1654](https://github.com/aws/aws-sdk-go/pull/1654)
  * Fixes [#1653](https://github.com/aws/aws-sdk-go/issues/1653)
Release v1.12.30 (2017-11-17)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/dms`: Updates service API, documentation, and paginators
  * Support for migration task assessment. Support for data validation after the migration.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * Amazon RDS now supports importing MySQL databases by using backup files from Amazon S3.
* `service/s3`: Updates service API
  * Added ORC to the supported S3 Inventory formats.

### SDK Bugs
* `private/protocol/restjson`: Define JSONValue marshaling for body and querystring ([#1640](https://github.com/aws/aws-sdk-go/pull/1640))
  * Adds support for APIs which use JSONValue for body and querystring targets.
  * Fixes [#1636](https://github.com/aws/aws-sdk-go/issues/1636)
Release v1.12.29 (2017-11-16)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/ec2`: Updates service API
  * You are now able to create and launch EC2 x1e smaller instance sizes
* `service/glue`: Updates service API and documentation
  * API update for AWS Glue. New crawler configuration attribute enables customers to specify crawler behavior. New XML classifier enables classification of XML data.
* `service/opsworkscm`: Updates service API, documentation, and waiters
  * Documentation updates for OpsWorks-cm: a new feature, OpsWorks for Puppet Enterprise, that allows users to create and manage OpsWorks-hosted Puppet Enterprise servers.
* `service/organizations`: Updates service API, documentation, and paginators
  * This release adds APIs that you can use to enable and disable integration with AWS services designed to work with AWS Organizations. This integration allows the AWS service to perform operations on your behalf on all of the accounts in your organization. Although you can use these APIs yourself, we recommend that you instead use the commands provided in the other AWS service to enable integration with AWS Organizations.
* `service/route53`: Updates service API and documentation
  * You can use Route 53's GetAccountLimit/GetHostedZoneLimit/GetReusableDelegationSetLimit APIs to view your current limits (including custom set limits) on Route 53 resources such as hosted zones and health checks. These APIs also return the number of each resource you're currently using to enable comparison against your current limits.

Release v1.12.28 (2017-11-15)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * 1. Extended GetDocumentationParts operation to support retrieving documentation parts resources without contents.  2. Added hosted zone ID in the custom domain response.
* `service/email`: Updates service API, documentation, and examples
  * SES launches Configuration Set Reputation Metrics and Email Pausing Today, two features that build upon the capabilities of the reputation dashboard. The first is the ability to export reputation metrics for individual configuration sets. The second is the ability to temporarily pause email sending, either at the configuration set level, or across your entire Amazon SES account.
* `service/polly`: Updates service API
  * Amazon Polly adds Korean language support with new female voice - "Seoyeon" and new Indian English female voice - "Aditi"
* `service/states`: Updates service API and documentation
  * You can now use the UpdateStateMachine API to update your state machine definition and role ARN. Existing executions will continue to use the previous definition and role ARN. You can use the DescribeStateMachineForExecution API to determine which state machine definition and role ARN is associated with an execution

Release v1.12.27 (2017-11-14)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * Added new mode for Task Networking in ECS, called awsvpc mode. Mode configuration parameters to be passed in via awsvpcConfiguration. Updated APIs now use/show this new mode - RegisterTaskDefinition, CreateService, UpdateService, RunTask, StartTask.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lightsail`: Updates service API and documentation
  * Lightsail now supports attached block storage, which allows you to scale your applications and protect application data with additional SSD-backed storage disks. This feature allows Lightsail customers to attach secure storage disks to their Lightsail instances and manage their attached disks, including creating and deleting disks, attaching and detaching disks from instances, and backing up disks via snapshot.
* `service/route53`: Updates service API and documentation
  * When a Route 53 health check or hosted zone is created by a linked AWS service, the object now includes information about the service that created it. Hosted zones or health checks that are created by a linked service can't be updated or deleted using Route 53.
* `service/ssm`: Updates service API and documentation
  * EC2 Systems Manager GetInventory API adds support for aggregation.

### SDK Enhancements
* `aws/request`: Remove default port from HTTP host header ([#1618](https://github.com/aws/aws-sdk-go/pull/1618))
  * Updates the SDK to automatically remove default ports based on the URL's scheme when setting the HTTP Host header's value.
  * Fixes [#1537](https://github.com/aws/aws-sdk-go/issues/1537)

Release v1.12.26 (2017-11-09)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Introduces the following features: 1. Create a default subnet in an Availability Zone if no default subnet exists. 2. Spot Fleet integrates with Elastic Load Balancing to enable you to attach one or more load balancers to a Spot Fleet request. When you attach the load balancer, it automatically registers the instance in the Spot Fleet to the load balancers which distributes incoming traffic across the instances.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.25 (2017-11-08)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/batch`: Updates service documentation
  * Documentation updates for AWS Batch.
* `service/ec2`: Updates service API and documentation
  * AWS PrivateLink for Amazon Services - Customers can now privately access Amazon services from their Amazon Virtual Private Cloud (VPC), without using public IPs, and without requiring the traffic to traverse across the Internet.
* `service/elasticache`: Updates service API and documentation
  * This release adds online resharding for ElastiCache for Redis offering, providing the ability to add and remove shards from a running cluster. Developers can now dynamically scale-out or scale-in their Redis cluster workloads to adapt to changes in demand. ElastiCache will resize the cluster by adding or removing shards and redistribute hash slots uniformly across the new shard configuration, all while the cluster continues to stay online and serves requests.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.24 (2017-11-07)
===

### Service Client Updates
* `service/elasticloadbalancingv2`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * DescribeOrderableDBInstanceOptions now returns the minimum and maximum allowed values for storage size, total provisioned IOPS, and provisioned IOPS per GiB for a DB instance.
* `service/s3`: Updates service API, documentation, and examples
  * This releases adds support for 4 features: 1. Default encryption for S3 Bucket, 2. Encryption status in inventory and Encryption support for inventory.  3. Cross region replication of KMS-encrypted objects, and 4. ownership overwrite for CRR.

Release v1.12.23 (2017-11-07)
===

### Service Client Updates
* `service/api.pricing`: Adds new service
* `service/ec2`: Updates service API
  * You are now able to create and launch EC2 C5 instances, the next generation of EC2's compute-optimized instances, in us-east-1, us-west-2 and eu-west-1. C5 instances offer up to 72 vCPUs, 144 GiB of DDR4 instance memory, 25 Gbps in Network bandwidth and improved EBS and Networking bandwidth on smaller instance sizes to deliver improved performance for compute-intensive workloads.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kms`: Updates service API, documentation, and examples
  * Documentation updates for AWS KMS.
* `service/organizations`: Updates service documentation
  * This release updates permission statements for several API operations, and corrects some other minor errors.
* `service/states`: Updates service API, documentation, and paginators
  * Documentation update.

Release v1.12.22 (2017-11-03)
===

### Service Client Updates
* `service/ecs`: Updates service API and documentation
  * Amazon ECS users can now add devices to their containers and enable init process in containers through the use of docker's 'devices' and 'init' features. These fields can be specified under linuxParameters in ContainerDefinition in the Task Definition Template.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.21 (2017-11-02)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * This release supports creating and managing Regional and Edge-Optimized API endpoints.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

### SDK Bugs
* `aws/request`: Fix bug in request presign creating invalide URL ([#1624](https://github.com/aws/aws-sdk-go/pull/1624))
  * Fixes a bug the Request Presign and PresignRequest methods that would allow a invalid expire duration as input. A expire time of 0 would be interpreted by the SDK to generate a normal request signature, not a presigned URL. This caused the returned URL unusable.
  * Fixes [#1617](https://github.com/aws/aws-sdk-go/issues/1617)
Release v1.12.20 (2017-11-01)
===

### Service Client Updates
* `service/acm`: Updates service documentation
  * Documentation updates for ACM
* `service/cloudhsmv2`: Updates service documentation
  * Minor documentation update for AWS CloudHSM (cloudhsmv2).
* `service/directconnect`: Updates service API and documentation
  * AWS DirectConnect now provides support for Global Access for Virtual Private Cloud (VPC) via a new feature called Direct Connect Gateway. A Direct Connect Gateway will allow you to group multiple Direct Connect Private Virtual Interfaces (DX-VIF) and Private Virtual Gateways (VGW) from different AWS regions (but belonging to the same AWS Account) and pass traffic from any DX-VIF to any VPC in the grouping.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

### SDK Enhancements
* `aws/client`: Adding status code 429 to throttlable status codes in default retryer (#1621)

Release v1.12.19 (2017-10-26)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.18 (2017-10-26)
===

### Service Client Updates
* `service/cloudfront`: Updates service API and documentation
  * You can now specify additional options for MinimumProtocolVersion, which controls the SSL/TLS protocol that CloudFront uses to communicate with viewers. The minimum protocol version that you choose also determines the ciphers that CloudFront uses to encrypt the content that it returns to viewers.
* `service/ec2`: Updates service API
  * You are now able to create and launch EC2 P3 instance, next generation GPU instances, optimized for machine learning and high performance computing applications. With up to eight NVIDIA Tesla V100 GPUs, P3 instances provide up to one petaflop of mixed-precision, 125 teraflops of single-precision, and 62 teraflops of double-precision floating point performance, as well as a 300 GB/s second-generation NVLink interconnect that enables high-speed, low-latency GPU-to-GPU communication. P3 instances also feature up to 64 vCPUs based on custom Intel Xeon E5 (Broadwell) processors, 488 GB of DRAM, and 25 Gbps of dedicated aggregate network bandwidth using the Elastic Network Adapter (ENA).
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.17 (2017-10-24)
===

### Service Client Updates
* `service/config`: Updates service API
* `service/elasticache`: Updates service API, documentation, and examples
  * Amazon ElastiCache for Redis today announced support for data encryption both for data in-transit and data at-rest. The new encryption in-transit functionality enables ElastiCache for Redis customers to encrypt data for all communication between clients and Redis engine, and all intra-cluster Redis communication. The encryption at-rest functionality allows customers to encrypt their S3 based backups. Customers can begin using the new functionality by simply enabling this functionality via AWS console, and a small configuration change in their Redis clients. The ElastiCache for Redis service automatically manages life cycle of the certificates required for encryption, including the issuance, renewal and expiration of certificates. Additionally, as part of this launch, customers will gain the ability to start using the Redis AUTH command that provides an added level of authentication.
* `service/glue`: Adds new service
  * AWS Glue: Adding a new API, BatchStopJobRun, to stop one or more job runs for a specified Job.
* `service/pinpoint`: Updates service API and documentation
  * Added support for APNs VoIP messages. Added support for collapsible IDs, message priority, and TTL for APNs and FCM/GCM.

Release v1.12.16 (2017-10-23)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/organizations`: Updates service API and documentation
  * This release supports integrating other AWS services with AWS Organizations through the use of an IAM service-linked role called AWSServiceRoleForOrganizations. Certain operations automatically create that role if it does not already exist.

Release v1.12.15 (2017-10-20)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adding pagination support for DescribeSecurityGroups for EC2 Classic and VPC Security Groups

Release v1.12.14 (2017-10-19)
===

### Service Client Updates
* `service/sqs`: Updates service API and documentation
  * Added support for tracking cost allocation by adding, updating, removing, and listing the metadata tags of Amazon SQS queues.
* `service/ssm`: Updates service API and documentation
  * EC2 Systems Manager versioning support for Parameter Store. Also support for referencing parameter versions in SSM Documents.

Release v1.12.13 (2017-10-18)
===

### Service Client Updates
* `service/lightsail`: Updates service API and documentation
  * This release adds support for Windows Server-based Lightsail instances. The GetInstanceAccessDetails API now returns the password of your Windows Server-based instance when using the default key pair. GetInstanceAccessDetails also returns a PasswordData object for Windows Server instances containing the ciphertext and keyPairName. The Blueprint data type now includes a list of platform values (LINUX_UNIX or WINDOWS). The Bundle data type now includes a list of SupportedPlatforms values (LINUX_UNIX or WINDOWS).

Release v1.12.12 (2017-10-17)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/es`: Updates service API and documentation
  * This release adds support for VPC access to Amazon Elasticsearch Service.
  * This release adds support for VPC access to Amazon Elasticsearch Service.

Release v1.12.11 (2017-10-16)
===

### Service Client Updates
* `service/cloudhsm`: Updates service API and documentation
  * Documentation updates for AWS CloudHSM Classic.
* `service/ec2`: Updates service API and documentation
  * You can now change the tenancy of your VPC from dedicated to default with a single API operation. For more details refer to the documentation for changing VPC tenancy.
* `service/es`: Updates service API and documentation
  * AWS Elasticsearch adds support for enabling slow log publishing. Using slow log publishing options customers can configure and enable index/query slow log publishing of their domain to preferred AWS Cloudwatch log group.
* `service/rds`: Updates service API and waiters
  * Adds waiters for DBSnapshotAvailable and DBSnapshotDeleted.
* `service/waf`: Updates service API and documentation
  * This release adds support for regular expressions as match conditions in rules, and support for geographical location by country of request IP address as a match condition in rules.
* `service/waf-regional`: Updates service API and documentation

Release v1.12.10 (2017-10-12)
===

### Service Client Updates
* `service/codecommit`: Updates service API and documentation
  * This release includes the DeleteBranch API and a change to the contents of a Commit object.
* `service/dms`: Updates service API and documentation
  * This change includes addition of new optional parameter to an existing API
* `service/elasticbeanstalk`: Updates service API and documentation
  * Added the ability to add, delete or update Tags
* `service/polly`: Updates service API
  * Amazon Polly exposes two new voices: "Matthew" (US English) and "Takumi" (Japanese)
* `service/rds`: Updates service API and documentation
  * You can now call DescribeValidDBInstanceModifications to learn what modifications you can make to your DB instance. You can use this information when you call ModifyDBInstance.

Release v1.12.9 (2017-10-11)
===

### Service Client Updates
* `service/ecr`: Updates service API, documentation, and paginators
  * Adds support for new API set used to manage Amazon ECR repository lifecycle policies. Amazon ECR lifecycle policies enable you to specify the lifecycle management of images in a repository. The configuration is a set of one or more rules, where each rule defines an action for Amazon ECR to apply to an image. This allows the automation of cleaning up unused images, for example expiring images based on age or status. A lifecycle policy preview API is provided as well, which allows you to see the impact of a lifecycle policy on an image repository before you execute it
* `service/email`: Updates service API and documentation
  * Added content related to email template management and templated email sending operations.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.12.8 (2017-10-10)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * This release includes updates to AWS Virtual Private Gateway.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `service/opsworkscm`: Updates service API and documentation
  * Provide engine specific information for node associations.

Release v1.12.7 (2017-10-06)
===

### Service Client Updates
* `service/sqs`: Updates service documentation
  * Documentation updates regarding availability of FIFO queues and miscellaneous corrections.

Release v1.12.6 (2017-10-05)
===

### Service Client Updates
* `service/redshift`: Updates service API and documentation
  * DescribeEventSubscriptions API supports tag keys and tag values as request parameters.

Release v1.12.5 (2017-10-04)
===

### Service Client Updates
* `service/kinesisanalytics`: Updates service API and documentation
  * Kinesis Analytics now supports schema discovery on objects in S3. Additionally, Kinesis Analytics now supports input data preprocessing through Lambda.
* `service/route53domains`: Updates service API and documentation
  * Added a new API that checks whether a domain name can be transferred to Amazon Route 53.

### SDK Bugs
* `service/s3/s3crypto`: Correct PutObjectRequest documentation ([#1568](https://github.com/aws/aws-sdk-go/pull/1568))
  * s3Crypto's PutObjectRequest docstring example was using an incorrect value. Corrected the type used in the example.
Release v1.12.4 (2017-10-03)
===

### Service Client Updates
* `service/ec2`: Updates service API, documentation, and waiters
  * This release includes service updates to AWS VPN.
* `service/ssm`: Updates service API and documentation
  * EC2 Systems Manager support for tagging SSM Documents. Also support for tag-based permissions to restrict access to SSM Documents based on these tags.

Release v1.12.3 (2017-10-02)
===

### Service Client Updates
* `service/cloudhsm`: Updates service documentation and paginators
  * Documentation updates for CloudHSM

Release v1.12.2 (2017-09-29)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Includes APIs for managing and accessing image builders, and deleting images.
* `service/codebuild`: Updates service API and documentation
  * Adding support for Building GitHub Pull Requests in AWS CodeBuild
* `service/mturk-requester`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * This release flags the HandshakeParty structure's Type and Id fields as 'required'. They effectively were required in the past, as you received an error if you did not include them. This is now reflected at the API definition level.
* `service/route53`: Updates service API and documentation
  * This change allows customers to reset elements of health check.

### SDK Bugs
* `private/protocol/query`: Fix query protocol handling of nested byte slices ([#1557](https://github.com/aws/aws-sdk-go/issues/1557))
  * Fixes the query protocol to correctly marshal nested []byte values of API operations.
* `service/s3`: Fix PutObject and UploadPart API to include ContentMD5 field ([#1559](https://github.com/aws/aws-sdk-go/pull/1559))
  * Fixes the SDK's S3 PutObject and UploadPart API code generation to correctly render the ContentMD5 field into the associated input types for these two API operations.
  * Fixes [#1553](https://github.com/aws/aws-sdk-go/pull/1553)
Release v1.12.1 (2017-09-27)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/pinpoint`: Updates service API and documentation
  * Added two new push notification channels: Amazon Device Messaging (ADM) and, for push notification support in China, Baidu Cloud Push. Added support for APNs auth via .p8 key file. Added operation for direct message deliveries to user IDs, enabling you to message an individual user on multiple endpoints.

Release v1.12.0 (2017-09-26)
===

### SDK Bugs
* `API Marshaler`: Revert REST JSON and XML protocol marshaler improvements
  * Bug [#1550](https://github.com/aws/aws-sdk-go/issues/1550) identified a missed condition in the Amazon Route 53 RESTXML protocol marshaling causing requests to that service to fail. Reverting the marshaler improvements until the bug can be fixed.

Release v1.11.0 (2017-09-26)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * You can now prevent a stack from being accidentally deleted by enabling termination protection on the stack. If you attempt to delete a stack with termination protection enabled, the deletion fails and the stack, including its status, remains unchanged. You can enable termination protection on a stack when you create it. Termination protection on stacks is disabled by default. After creation, you can set termination protection on a stack whose status is CREATE_COMPLETE, UPDATE_COMPLETE, or UPDATE_ROLLBACK_COMPLETE.

### SDK Features
* Add dep Go dependency management metadata files (#1544)
  * Adds the Go `dep` dependency management metadata files to the SDK.
  * Fixes [#1451](https://github.com/aws/aws-sdk-go/issues/1451)
  * Fixes [#634](https://github.com/aws/aws-sdk-go/issues/634)
* `service/dynamodb/expression`: Add expression building utility for DynamoDB ([#1527](https://github.com/aws/aws-sdk-go/pull/1527))
  * Adds a new package, expression, to the SDK providing builder utilities to create DynamoDB expressions safely taking advantage of type safety.
* `API Marshaler`: Add generated marshalers for RESTXML protocol ([#1409](https://github.com/aws/aws-sdk-go/pull/1409))
  * Updates the RESTXML protocol marshaler to use generated code instead of reflection for REST XML based services.
* `API Marshaler`: Add generated marshalers for RESTJSON protocol ([#1547](https://github.com/aws/aws-sdk-go/pull/1547))
  * Updates the RESTJSON protocol marshaler to use generated code instead of reflection for REST JSON based services.

### SDK Enhancements
* `private/protocol`: Update format of REST JSON and XMl benchmarks ([#1546](https://github.com/aws/aws-sdk-go/pull/1546))
  * Updates the format of the REST JSON and XML benchmarks to be readable. RESTJSON benchmarks were updated to more accurately bench building of the protocol.

Release v1.10.51 (2017-09-22)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation
  * Amazon ECS users can now add and drop Linux capabilities to their containers through the use of docker's cap-add and cap-drop features. Customers can specify the capabilities they wish to add or drop for each container in their task definition.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service documentation
  * Documentation updates for rds

Release v1.10.50 (2017-09-21)
===

### Service Client Updates
* `service/budgets`: Updates service API
  * Including "DuplicateRecordException" in UpdateNotification and UpdateSubscriber.
* `service/ec2`: Updates service API and documentation
  * Add EC2 APIs to copy Amazon FPGA Images (AFIs) within the same region and across multiple regions, delete AFIs, and modify AFI attributes. AFI attributes include name, description and granting/denying other AWS accounts to load the AFI.
* `service/logs`: Updates service API and documentation
  * Adds support for associating LogGroups with KMS Keys.

### SDK Bugs
* Fix greengrass service model being duplicated with different casing. ([#1541](https://github.com/aws/aws-sdk-go/pull/1541))
  * Fixes [#1540](https://github.com/aws/aws-sdk-go/issues/1540)
  * Fixes [#1539](https://github.com/aws/aws-sdk-go/issues/1539)
Release v1.10.49 (2017-09-20)
===

### Service Client Updates
* `service/Greengrass`: Adds new service
* `service/appstream`: Updates service API and documentation
  * API updates for supporting On-Demand fleets.
* `service/codepipeline`: Updates service API and documentation
  * This change includes a PipelineMetadata object that is part of the output from the GetPipeline API that includes the Pipeline ARN, created, and updated timestamp.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * Introduces the --option-group-name parameter to the ModifyDBSnapshot CLI command. You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance.  For more information, see http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG
* `service/runtime.lex`: Updates service API and documentation

Release v1.10.48 (2017-09-19)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Fixed bug in EC2 clients preventing ElasticGpuSet from being set.

### SDK Enhancements
* `aws/credentials`: Add EnvProviderName constant. ([#1531](https://github.com/aws/aws-sdk-go/issues/1531))
  * Adds the "EnvConfigCredentials" string literal as EnvProviderName constant.
  * Fixes [#1444](https://github.com/aws/aws-sdk-go/issues/1444)

Release v1.10.47 (2017-09-18)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 now lets you opt for Spot instances to be stopped in the event of an interruption instead of being terminated.  Your Spot request can be fulfilled again by restarting instances from a previously stopped state, subject to availability of capacity at or below your preferred price.  When you submit a persistent Spot request, you can choose from "terminate" or "stop" as the instance interruption behavior.  Choosing "stop" will shutdown your Spot instances so you can continue from this stopped state later on.  This feature is only available for instances with Amazon EBS volume as their root device.
* `service/email`: Updates service API and documentation
  * Amazon Simple Email Service (Amazon SES) now lets you customize the domains used for tracking open and click events. Previously, open and click tracking links referred to destinations hosted on domains operated by Amazon SES. With this feature, you can use your own branded domains for capturing open and click events.
* `service/iam`: Updates service API and documentation
  * A new API, DeleteServiceLinkedRole, submits a service-linked role deletion request and returns a DeletionTaskId, which you can use to check the status of the deletion.

Release v1.10.46 (2017-09-15)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Add a new enum "REQUEST" to '--type <value>' field in the current create-authorizer API, and make "identitySource" optional.

Release v1.10.45 (2017-09-14)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Supporting Parameter Store in environment variables for AWS CodeBuild
* `service/organizations`: Updates service documentation
  * Documentation updates for AWS Organizations
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * This release of Service Catalog adds API support to copy products.

Release v1.10.44 (2017-09-13)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Customers can create Life Cycle Hooks at the time of creating Auto Scaling Groups through the CreateAutoScalingGroup API
* `service/batch`: Updates service documentation and examples
  * Documentation updates for batch
* `service/ec2`: Updates service API
  * You are now able to create and launch EC2 x1e.32xlarge instance, a new EC2 instance in the X1 family, in us-east-1, us-west-2, eu-west-1, and ap-northeast-1. x1e.32xlarge offers 128 vCPUs, 3,904 GiB of DDR4 instance memory, high memory bandwidth, large L3 caches, and leading reliability capabilities to boost the performance and reliability of in-memory applications.
* `service/events`: Updates service API and documentation
  * Exposes ConcurrentModificationException as one of the valid exceptions for PutPermission and RemovePermission operation.

### SDK Enhancements
* `service/autoscaling`: Fix documentation for PutScalingPolicy.AutoScalingGroupName [#1522](https://github.com/aws/aws-sdk-go/pull/1522)
* `service/s3/s3manager`: Clarify S3 Upload manager Concurrency config [#1521](https://github.com/aws/aws-sdk-go/pull/1521)
  * Fixes [#1458](https://github.com/aws/aws-sdk-go/issues/1458)
* `service/dynamodb/dynamodbattribute`: Add support for time alias. [#1520](https://github.com/aws/aws-sdk-go/pull/1520)
  * Related to [#1505](https://github.com/aws/aws-sdk-go/pull/1505)

Release v1.10.43 (2017-09-12)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Fixed bug in EC2 clients preventing HostOfferingSet from being set
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.10.42 (2017-09-12)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * DeviceFarm has added support for two features - RemoteDebugging and Customer Artifacts. Customers  can now do remote Debugging on their Private Devices and can now retrieve custom files generated by their tests on the device and the device host (execution environment) on both public and private devices.

Release v1.10.41 (2017-09-08)
===

### Service Client Updates
* `service/logs`: Updates service API and documentation
  * Adds support for the PutResourcePolicy, DescribeResourcePolicy and DeleteResourcePolicy APIs.

Release v1.10.40 (2017-09-07)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service documentation
* `service/ec2`: Updates service API and documentation
  * With Tagging support, you can add Key and Value metadata to search, filter and organize your NAT Gateways according to your organization's needs.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lex-models`: Updates service API and documentation
* `service/route53`: Updates service API and documentation
  * You can configure Amazon Route 53 to log information about the DNS queries that Amazon Route 53 receives for your domains and subdomains. When you configure query logging, Amazon Route 53 starts to send logs to CloudWatch Logs. You can use various tools, including the AWS console, to access the query logs.

Release v1.10.39 (2017-09-06)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Add an optional "thresholdType" to notifications to support percentage or absolute value thresholds.

Release v1.10.38 (2017-09-05)
===

### Service Client Updates
* `service/codestar`: Updates service API and documentation
  * Added support to tag CodeStar projects. Tags can be used to organize and find CodeStar projects on key-value pairs that you can choose. For example, you could add a tag with a key of "Release" and a value of "Beta" to projects your organization is working on for an upcoming beta release.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.10.37 (2017-09-01)
===

### Service Client Updates
* `service/MobileHub`: Adds new service
* `service/gamelift`: Updates service API and documentation
  * GameLift VPC resources can be peered with any other AWS VPC. R4 memory-optimized instances now available to deploy.
* `service/ssm`: Updates service API and documentation
  * Adding KMS encryption support to SSM Inventory Resource Data Sync. Exposes the ClientToken parameter on SSM StartAutomationExecution to provide idempotent execution requests.

Release v1.10.36 (2017-08-31)
===

### Service Client Updates
* `service/codebuild`: Updates service API, documentation, and examples
  * The AWS CodeBuild HTTP API now provides the BatchDeleteBuilds operation, which enables you to delete existing builds.
* `service/ec2`: Updates service API and documentation
  * Descriptions for Security Group Rules enables customers to be able to define a description for ingress and egress security group rules . The Descriptions for Security Group Rules feature supports one description field per Security Group rule for both ingress and egress rules . Descriptions for Security Group Rules provides a simple way to describe the purpose or function of a Security Group Rule allowing for easier customer identification of configuration elements .      Prior to the release of Descriptions for Security Group Rules , customers had to maintain a separate system outside of AWS if they wanted to track Security Group Rule mapping and their purpose for being implemented. If a security group rule has already been created and you would like to update or change your description for that security group rule you can use the UpdateSecurityGroupRuleDescription API.
* `service/elasticloadbalancingv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lex-models`: Updates service API and documentation

### SDK Bugs
* `aws/signer/v4`: Revert [#1491](https://github.com/aws/aws-sdk-go/issues/1491) as change conflicts with an undocumented AWS v4 signature test case.
  * Related to: [#1495](https://github.com/aws/aws-sdk-go/issues/1495).
Release v1.10.35 (2017-08-30)
===

### Service Client Updates
* `service/application-autoscaling`: Updates service API and documentation
* `service/organizations`: Updates service API and documentation
  * The exception ConstraintViolationException now contains a new reason subcode MASTERACCOUNT_MISSING_CONTACT_INFO to make it easier to understand why attempting to remove an account from an Organization can fail. We also improved several other of the text descriptions and examples.

Release v1.10.34 (2017-08-29)
===

### Service Client Updates
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Provides capability to add secondary CIDR blocks to a VPC.

### SDK Bugs
* `aws/signer/v4`: Fix Signing Unordered Multi Value Query Parameters ([#1491](https://github.com/aws/aws-sdk-go/pull/1491))
  * Removes sorting of query string values when calculating v4 signing as this is not part of the spec. The spec only requires the keys, not values, to be sorted which is achieved by Query.Encode().
Release v1.10.33 (2017-08-25)
===

### Service Client Updates
* `service/cloudformation`: Updates service API and documentation
  * Rollback triggers enable you to have AWS CloudFormation monitor the state of your application during stack creation and updating, and to roll back that operation if the application breaches the threshold of any of the alarms you've specified.
* `service/gamelift`: Updates service API
  * Update spelling of MatchmakingTicket status values for internal consistency.
* `service/rds`: Updates service API and documentation
  * Option group options now contain additional properties that identify requirements for certain options. Check these properties to determine if your DB instance must be in a VPC or have auto minor upgrade turned on before you can use an option. Check to see if you can downgrade the version of an option after you have installed it.

### SDK Enhancements
* `example/service/ec2`: Add EC2 list instances example ([#1492](https://github.com/aws/aws-sdk-go/pull/1492))

Release v1.10.32 (2017-08-25)
===

### Service Client Updates
* `service/rekognition`: Updates service API, documentation, and examples
  * Update the enum value of LandmarkType and GenderType to be consistent with service response

Release v1.10.31 (2017-08-23)
===

### Service Client Updates
* `service/appstream`: Updates service documentation
  * Documentation updates for appstream
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.10.30 (2017-08-22)
===

### Service Client Updates
* `service/ssm`: Updates service API and documentation
  * Changes to associations in Systems Manager State Manager can now be recorded. Previously, when you edited associations, you could not go back and review older association settings. Now, associations are versioned, and can be named using human-readable strings, allowing you to see a trail of association changes. You can also perform rate-based scheduling, which allows you to schedule associations more granularly.

Release v1.10.29 (2017-08-21)
===

### Service Client Updates
* `service/firehose`: Updates service API, documentation, and paginators
  * This change will allow customers to attach a Firehose delivery stream to an existing Kinesis stream directly. You no longer need a forwarder to move data from a Kinesis stream to a Firehose delivery stream. You can now run your streaming applications on your Kinesis stream and easily attach a Firehose delivery stream to it for data delivery to S3, Redshift, or Elasticsearch concurrently.
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports CAA resource record type. A CAA record controls which certificate authorities are allowed to issue certificates for the domain or subdomain.

Release v1.10.28 (2017-08-18)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.10.27 (2017-08-16)
===

### Service Client Updates
* `service/gamelift`: Updates service API and documentation
  * The Matchmaking Grouping Service is a new feature that groups player match requests for a given game together into game sessions based on developer configured rules.

### SDK Enhancements
* `aws/arn`: aws/arn: Package for parsing and producing ARNs ([#1463](https://github.com/aws/aws-sdk-go/pull/1463))
  * Adds the `arn` package for AWS ARN parsing and building. Use this package to build AWS ARNs for services such as outlined in the [documentation](http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).

### SDK Bugs
* `aws/signer/v4`: Correct V4 presign signature to include content sha25 in URL ([#1469](https://github.com/aws/aws-sdk-go/pull/1469))
  * Updates the V4 signer so that when a Presign is generated the `X-Amz-Content-Sha256` header is added to the query string instead of being required to be in the header. This allows you to generate presigned URLs for GET requests, e.g S3.GetObject that do not require additional headers to be set by the downstream users of the presigned URL.
  * Related To: [#1467](https://github.com/aws/aws-sdk-go/issues/1467)

Release v1.10.26 (2017-08-15)
===

### Service Client Updates
* `service/ec2`: Updates service API
  * Fixed bug in EC2 clients preventing HostReservation from being set
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.10.25 (2017-08-14)
===

### Service Client Updates
* `service/AWS Glue`: Adds new service
* `service/batch`: Updates service API and documentation
  * This release enhances the DescribeJobs API to include the CloudWatch logStreamName attribute in ContainerDetail and ContainerDetailAttempt
* `service/cloudhsmv2`: Adds new service
  * CloudHSM provides hardware security modules for protecting sensitive data and cryptographic keys within an EC2 VPC, and enable the customer to maintain control over key access and use. This is a second-generation of the service that will improve security, lower cost and provide better customer usability.
* `service/elasticfilesystem`: Updates service API, documentation, and paginators
  * Customers can create encrypted EFS file systems and specify a KMS master key to encrypt it with.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/mgh`: Adds new service
  * AWS Migration Hub provides a single location to track migrations across multiple AWS and partner solutions. Using Migration Hub allows you to choose the AWS and partner migration tools that best fit your needs, while providing visibility into the status of your entire migration portfolio. Migration Hub also provides key metrics and progress for individual applications, regardless of which tools are being used to migrate them. For example, you might use AWS Database Migration Service, AWS Server Migration Service, and partner migration tools to migrate an application comprised of a database, virtualized web servers, and a bare metal server. Using Migration Hub will provide you with a single screen that shows the migration progress of all the resources in the application. This allows you to quickly get progress updates across all of your migrations, easily identify and troubleshoot any issues, and reduce the overall time and effort spent on your migration projects. Migration Hub is available to all AWS customers at no additional charge. You only pay for the cost of the migration tools you use, and any resources being consumed on AWS.
* `service/ssm`: Updates service API and documentation
  * Systems Manager Maintenance Windows include the following changes or enhancements: New task options using Systems Manager Automation, AWS Lambda, and AWS Step Functions; enhanced ability to edit the targets of a Maintenance Window, including specifying a target name and description, and ability to edit the owner field; enhanced ability to edits tasks; enhanced support for Run Command parameters; and you can now use a --safe flag when attempting to deregister a target. If this flag is enabled when you attempt to deregister a target, the system returns an error if the target is referenced by any task. Also, Systems Manager now includes Configuration Compliance to scan your fleet of managed instances for patch compliance and configuration inconsistencies. You can collect and aggregate data from multiple AWS accounts and Regions, and then drill down into specific resources that aren't compliant.
* `service/storagegateway`: Updates service API and documentation
  * Add optional field ForceDelete to DeleteFileShare api.

Release v1.10.24 (2017-08-11)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * Adds support for specifying Application Load Balancers in deployment groups, for both in-place and blue/green deployments.
* `service/cognito-idp`: Updates service API and documentation
* `service/ec2`: Updates service API and documentation
  * Provides customers an opportunity to recover an EIP that was released

Release v1.10.23 (2017-08-10)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API and documentation
  * Enable BatchDetachPolicy
* `service/codebuild`: Updates service API
  * Supporting Bitbucket as source type in AWS CodeBuild.

Release v1.10.22 (2017-08-09)
===

### Service Client Updates
* `service/rds`: Updates service documentation
  * Documentation updates for RDS.

Release v1.10.21 (2017-08-09)
===

### Service Client Updates
* `service/elasticbeanstalk`: Updates service API and documentation
  * Add support for paginating the result of DescribeEnvironments     Include the ARN of described environments in DescribeEnvironments output

### SDK Enhancements
* `aws`: Add pointer conversion utilities to transform int64 to time.Time [#1433](https://github.com/aws/aws-sdk-go/pull/1433)
  * Adds `SecondsTimeValue` and `MillisecondsTimeValue` utilities.

Release v1.10.20 (2017-08-01)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * AWS CodeDeploy now supports the use of multiple tag groups in a single deployment group (an intersection of tags) to identify the instances for a deployment. When you create or update a deployment group, use the new ec2TagSet and onPremisesTagSet structures to specify up to three groups of tags. Only instances that are identified by at least one tag in each of the tag groups are included in the deployment group.
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service waiters
  * Ec2 SpotInstanceRequestFulfilled waiter update
* `service/elasticloadbalancingv2`: Updates service waiters
* `service/email`: Updates service API, documentation, paginators, and examples
  * This update adds information about publishing email open and click events. This update also adds information about publishing email events to Amazon Simple Notification Service (Amazon SNS).
* `service/pinpoint`: Updates service API and documentation
  * This release of the Pinpoint SDK enables App management - create, delete, update operations, Raw Content delivery for APNs and GCM campaign messages and From Address override.

Release v1.10.19 (2017-08-01)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/inspector`: Updates service API, documentation, and paginators
  * Inspector's StopAssessmentRun API has been updated with a new input option - stopAction. This request parameter can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default value, and the previous behavior) stops the AWS agent data collection and begins the results evaluation for findings generation based on the data collected so far. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.
* `service/ssm`: Updates service API and documentation
  * Adds a SendAutomationSignal API to SSM Service. This API is used to send a signal to an automation execution to change the current behavior or status of the execution.

Release v1.10.18 (2017-07-27)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * The CreateDefaultVPC API enables you to create a new default VPC . You no longer need to contact AWS support, if your default VPC has been deleted.
* `service/kinesisanalytics`: Updates service API and documentation
  * Added additional exception types and clarified documentation.

Release v1.10.17 (2017-07-27)
===

### Service Client Updates
* `service/dynamodb`: Updates service documentation and examples
  * Corrected a typo.
* `service/ec2`: Updates service API and documentation
  * Amazon EC2 Elastic GPUs allow you to easily attach low-cost graphics acceleration to current generation EC2 instances. With Amazon EC2 Elastic GPUs, you can configure the right amount of graphics acceleration to your particular workload without being constrained by fixed hardware configurations and limited GPU selection.
* `service/monitoring`: Updates service documentation
  * This release adds high resolution features to CloudWatch, with support for Custom Metrics down to 1 second and Alarms down to 10 seconds.

Release v1.10.16 (2017-07-26)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API and documentation
  * Cloud Directory adds support for additional batch operations.
* `service/cloudformation`: Updates service API and documentation
  * AWS CloudFormation StackSets enables you to manage stacks across multiple accounts and regions.

### SDK Enhancements
* `aws/signer/v4`: Optimize V4 signer's header duplicate space stripping. [#1417](https://github.com/aws/aws-sdk-go/pull/1417)

Release v1.10.15 (2017-07-24)
===

### Service Client Updates
* `service/appstream`: Updates service API, documentation, and waiters
  * Amazon AppStream 2.0 image builders and fleets can now access applications and network resources that rely on Microsoft Active Directory (AD) for authentication and permissions. This new feature allows you to join your streaming instances to your AD, so you can use your existing AD user management tools.
* `service/ec2`: Updates service API and documentation
  * Spot Fleet tagging capability allows customers to automatically tag instances launched by Spot Fleet. You can use this feature to label or distinguish instances created by distinct Spot Fleets. Tagging your EC2 instances also enables you to see instance cost allocation by tag in your AWS bill.

### SDK Bugs
* `aws/signer/v4`: Fix out of bounds panic in stripExcessSpaces [#1412](https://github.com/aws/aws-sdk-go/pull/1412)
  * Fixes the out of bands panic in stripExcessSpaces caused by an incorrect calculation of the stripToIdx value. Simplified to code also.
  * Fixes [#1411](https://github.com/aws/aws-sdk-go/issues/1411)
Release v1.10.14 (2017-07-20)
===

### Service Client Updates
* `service/elasticmapreduce`: Updates service API and documentation
  * Amazon EMR now includes the ability to use a custom Amazon Linux AMI and adjustable root volume size when launching a cluster.

Release v1.10.13 (2017-07-19)
===

### Service Client Updates
* `service/budgets`: Updates service API and documentation
  * Update budget Management API's to list/create/update RI_UTILIZATION type budget. Update budget Management API's to support DAILY timeUnit for RI_UTILIZATION type budget.

### SDK Enhancements
* `service/s3`:  Use interfaces assertions instead of ValuesAtPath for S3 field lookups. [#1401](https://github.com/aws/aws-sdk-go/pull/1401)
  * Improves the performance across the board for all S3 API calls by removing the usage of `ValuesAtPath` being used for every S3 API call.

### SDK Bugs
* `aws/request`: waiter test bug
  * waiters_test.go file would sometimes fail due to travis hiccups. This occurs because a test would sometimes fail the cancel check and succeed the timeout. However, the timeout check should never occur in that test. This fix introduces a new field that dictates how waiters will sleep.
Release v1.10.12 (2017-07-17)
===

### Service Client Updates
* `service/cognito-idp`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation
  * Lambda@Edge lets you run code closer to your end users without provisioning or managing servers. With Lambda@Edge, your code runs in AWS edge locations, allowing you to respond to your end users at the lowest latency. Your code is triggered by Amazon CloudFront events, such as requests to and from origin servers and viewers, and it is ready to execute at every AWS edge location whenever a request for content is received. You just upload your Node.js code to AWS Lambda and Lambda takes care of everything required to run and scale your code with high availability. You only pay for the compute time you consume - there is no charge when your code is not running.

Release v1.10.11 (2017-07-14)
===

### Service Client Updates
* `service/discovery`: Updates service API and documentation
  * Adding feature to the Export API for Discovery Service to allow filters for the export task to allow export based on per agent id.
* `service/ec2`: Updates service API
  * New EC2 GPU Graphics instance
* `service/marketplacecommerceanalytics`: Updates service documentation
  * Update to Documentation Model For New Report Cadence / Reformat of Docs

Release v1.10.10 (2017-07-13)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Adds support for management of gateway responses.
* `service/ec2`: Updates service API and documentation
  * X-ENI (or Cross-Account ENI) is a new feature that allows the attachment or association of Elastic Network Interfaces (ENI) between VPCs in different AWS accounts located in the same availability zone. With this new capability, service providers and partners can deliver managed solutions in a variety of new architectural patterns where the provider and consumer of the service are in different AWS accounts.
* `service/lex-models`: Updates service documentation

Release v1.10.9 (2017-07-12)
===

### Service Client Updates
* `service/autoscaling`: Updates service API and documentation
  * Auto Scaling now supports a new type of scaling policy called target tracking scaling policies that you can use to set up dynamic scaling for your application.
* `service/swf`: Updates service API, documentation, paginators, and examples
  * Added support for attaching control data to Lambda tasks. Control data lets you attach arbitrary strings to your decisions and history events.

Release v1.10.8 (2017-07-06)
===

### Service Client Updates
* `service/ds`: Updates service API, documentation, and paginators
  * You can now improve the resilience and performance of your Microsoft AD directory by deploying additional domain controllers. Added UpdateNumberofDomainControllers API that allows you to update the number of domain controllers you want for your directory, and DescribeDomainControllers API that allows you to describe the detailed information of each domain controller of your directory. Also added the 'DesiredNumberOfDomainControllers' field to the DescribeDirectories API output for Microsoft AD.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/kinesis`: Updates service API and documentation
  * You can now encrypt your data at rest within an Amazon Kinesis Stream using server-side encryption. Server-side encryption via AWS KMS makes it easy for customers to meet strict data management requirements by encrypting their data at rest within the Amazon Kinesis Streams, a fully managed real-time data processing service.
* `service/kms`: Updates service API and documentation
  * This release of AWS Key Management Service introduces the ability to determine whether a key is AWS managed or customer managed.
* `service/ssm`: Updates service API and documentation
  * Amazon EC2 Systems Manager now expands Patching support to Amazon Linux, Red Hat and Ubuntu in addition to the already supported Windows Server.

Release v1.10.7 (2017-07-05)
===

### Service Client Updates
* `service/monitoring`: Updates service API and documentation
  * We are excited to announce the availability of APIs and CloudFormation support for CloudWatch Dashboards. You can use the new dashboard APIs or CloudFormation templates to dynamically build and maintain dashboards to monitor your infrastructure and applications. There are four new dashboard APIs - PutDashboard, GetDashboard, DeleteDashboards, and ListDashboards APIs. PutDashboard is used to create a new dashboard or modify an existing one whereas GetDashboard is the API to get the details of a specific dashboard. ListDashboards and DeleteDashboards are used to get the names or delete multiple dashboards respectively. Getting started with dashboard APIs is similar to any other AWS APIs. The APIs can be accessed through AWS SDK or through CLI tools.
* `service/route53`: Updates service API and documentation
  * Bug fix for InvalidChangeBatch exception.

### SDK Enhancements
* `service/s3/s3manager`: adding cleanup function to batch objects [#1375](https://github.com/aws/aws-sdk-go/issues/1375)
  * This enhancement will add an After field that will be called after each iteration of the batch operation.

Release v1.10.6 (2017-06-30)
===

### Service Client Updates
* `service/marketplacecommerceanalytics`: Updates service documentation
  * Documentation updates for AWS Marketplace Commerce Analytics.
* `service/s3`: Updates service API and documentation
  * API Update for S3: Adding Object Tagging Header to MultipartUpload Initialization

Release v1.10.5 (2017-06-29)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/events`: Updates service API and documentation
  * CloudWatch Events now allows different AWS accounts to share events with each other through a new resource called event bus. Event buses accept events from AWS services, other AWS accounts and PutEvents API calls. Currently all AWS accounts have one default event bus. To send events to another account, customers simply write rules to match the events of interest and attach an event bus in the receiving account as the target to the rule. The PutTargets API has been updated to allow adding cross account event buses as targets. In addition, we have released two new APIs - PutPermission and RemovePermission - that enables customers to add/remove permissions to their default event bus.
* `service/gamelift`: Updates service API and documentation
  * Allow developers to download GameLift fleet creation logs to assist with debugging.
* `service/ssm`: Updates service API and documentation
  * Adding Resource Data Sync support to SSM Inventory.  New APIs:  * CreateResourceDataSync - creates a new resource data sync configuration,  * ListResourceDataSync - lists existing resource data sync configurations,  * DeleteResourceDataSync - deletes an existing resource data sync configuration.

Release v1.10.4 (2017-06-27)
===

### Service Client Updates
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * Proper tagging of resources is critical to post-launch operations such as billing, cost allocation, and resource management. By using Service Catalog's TagOption Library, administrators can define a library of re-usable TagOptions that conform to company standards, and associate these with Service Catalog portfolios and products. Learn how to move your current tags to the new library, create new TagOptions, and view and associate your library items with portfolios and products. Understand how to ensure that the right tags are created on products launched through Service Catalog and how to provide users with defined selectable tags.

### SDK Bugs
* `aws/signer/v4`: checking length on `stripExcessSpaces` [#1372](https://github.com/aws/aws-sdk-go/issues/1372)
  * Fixes a bug where `stripExcessSpaces` did not check length against the slice.
  * Fixes: [#1371](https://github.com/aws/aws-sdk-go/issues/1371)
Release v1.10.3 (2017-06-23)
===

### Service Client Updates
* `service/lambda`: Updates service API and documentation
  * The Lambda Invoke API will now throw new exception InvalidRuntimeException (status code 502) for invokes with deprecated runtimes.

Release v1.10.2 (2017-06-22)
===

### Service Client Updates
* `service/codepipeline`: Updates service API, documentation, and paginators
  * A new API, ListPipelineExecutions, enables you to retrieve summary information about the most recent executions in a pipeline, including pipeline execution ID, status, start time, and last updated time. You can request information for a maximum of 100 executions. Pipeline execution data is available for the most recent 12 months of activity.
* `service/dms`: Updates service API and documentation
  * Added tagging for DMS certificates.
* `service/elasticloadbalancing`: Updates service waiters
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lightsail`: Updates service API and documentation
  * This release adds a new nextPageToken property to the result of the GetOperationsForResource API. Developers can now get the next set of items in a list by making subsequent calls to GetOperationsForResource API with the token from the previous call. This release also deprecates the nextPageCount property, which previously returned null (use the nextPageToken property instead). This release also deprecates the customImageName property on the CreateInstancesRequest class, which was previously ignored by the API.
* `service/route53`: Updates service API and documentation
  * This release reintroduces the HealthCheckInUse exception.

Release v1.10.1 (2017-06-21)
===

### Service Client Updates
* `service/dax`: Adds new service
  * Amazon DynamoDB Accelerator (DAX) is a fully managed, highly available, in-memory cache for DynamoDB that delivers up to a 10x performance improvement - from milliseconds to microseconds - even at millions of requests per second. DAX does all the heavy lifting required to add in-memory acceleration to your DynamoDB tables, without requiring developers to manage cache invalidation, data population, or cluster management.
* `service/route53`: Updates service API and documentation
  * Amazon Route 53 now supports multivalue answers in response to DNS queries, which lets you route traffic approximately randomly to multiple resources, such as web servers. Create one multivalue answer record for each resource and, optionally, associate an Amazon Route 53 health check with each record, and Amazon Route 53 responds to DNS queries with up to eight healthy records.
* `service/ssm`: Updates service API, documentation, and paginators
  * Adding hierarchy support to the SSM Parameter Store API. Added support tor tagging. New APIs: GetParameter - retrieves one parameter, DeleteParameters - deletes multiple parameters (max number 10), GetParametersByPath - retrieves parameters located in the hierarchy. Updated APIs: PutParameter - added ability to enforce parameter value by applying regex (AllowedPattern), DescribeParameters - modified to support Tag filtering.
* `service/waf`: Updates service API and documentation
  * You can now create, edit, update, and delete a new type of WAF rule with a rate tracking component.
* `service/waf-regional`: Updates service API and documentation

Release v1.10.0 (2017-06-20)
===

### Service Client Updates
* `service/workdocs`: Updates service API and documentation
  * This release provides a new API to retrieve the activities performed by WorkDocs users.

### SDK Features
* `aws/credentials/plugincreds`: Add support for Go plugin for credentials [#1320](https://github.com/aws/aws-sdk-go/pull/1320)
  * Adds support for using plugins to retrieve credentials for API requests. This change adds a new package plugincreds under aws/credentials. See the `example/aws/credentials/plugincreds` folder in the SDK for example usage.

Release v1.9.00 (2017-06-19)
===

### Service Client Updates
* `service/organizations`: Updates service API and documentation
  * Improvements to Exception Modeling

### SDK Features
* `service/s3/s3manager`: Adds batch operations to s3manager [#1333](https://github.com/aws/aws-sdk-go/pull/1333)
  * Allows for batch upload, download, and delete of objects. Also adds the interface pattern to allow for easy traversal of objects. E.G `DownloadWithIterator`, `UploadWithIterator`, and `BatchDelete`. `BatchDelete` also contains a utility iterator using the `ListObjects` API to easily delete a list of objects.
  
Release v1.8.44 (2017-06-16)
===

### Service Client Updates
* `service/xray`: Updates service API, documentation, and paginators
  * Add a response time histogram to the services in response of GetServiceGraph API.

Release v1.8.43 (2017-06-15)
===

### Service Client Updates
* `service/ec2`: Updates service API and documentation
  * Adds API to describe Amazon FPGA Images (AFIs) available to customers, which includes public AFIs, private AFIs that you own, and AFIs owned by other AWS accounts for which you have load permissions.
* `service/ecs`: Updates service API and documentation
  * Added support for cpu, memory, and memory reservation container overrides on the RunTask and StartTask APIs.
* `service/iot`: Updates service API and documentation
  * Revert the last release: remove CertificatePem from DescribeCertificate API.
* `service/servicecatalog`: Updates service API, documentation, and paginators
  * Added ProvisioningArtifactSummaries to DescribeProductAsAdmin's output to show the provisioning artifacts belong to the product. Allow filtering by SourceProductId in SearchProductsAsAdmin for AWS Marketplace products. Added a verbose option to DescribeProvisioningArtifact to display the CloudFormation template used to create the provisioning artifact.Added DescribeProvisionedProduct API. Changed the type of ProvisionedProduct's Status to be distinct from Record's Status. New ProvisionedProduct's Status are AVAILABLE, UNDER_CHANGE, TAINTED, ERROR. Changed Record's Status set of values to CREATED, IN_PROGRESS, IN_PROGRESS_IN_ERROR, SUCCEEDED, FAILED.

### SDK Bugs
* `private/model/api`: Fix RESTXML support for XML Namespace [#1343](https://github.com/aws/aws-sdk-go/pull/1343)
  * Fixes a bug with the SDK's generation of services using the REST XML protocol not annotating shape references with the XML Namespace attribute.
  * Fixes [#1334](https://github.com/aws/aws-sdk-go/pull/1334)
Release v1.8.42 (2017-06-14)
===

### Service Client Updates
* `service/applicationautoscaling`: Updates service API and documentation
* `service/clouddirectory`: Updates service documentation
  * Documentation update for Cloud Directory

Release v1.8.41 (2017-06-13)
===

### Service Client Updates
* `service/configservice`: Updates service API

Release v1.8.40 (2017-06-13)
===

### Service Client Updates
* `service/rds`: Updates service API and documentation
  * API Update for RDS: this update enables copy-on-write, a new Aurora MySQL Compatible Edition feature that allows users to restore their database, and support copy of TDE enabled snapshot cross region.

### SDK Bugs
* `aws/request`: Fix NewErrParamMinLen to use correct ParamMinLenErrCode [#1336](https://github.com/aws/aws-sdk-go/issues/1336)
  * Fixes the `NewErrParamMinLen` function returning the wrong error code. `ParamMinLenErrCode` should be returned not `ParamMinValueErrCode`.
  * Fixes [#1335](https://github.com/aws/aws-sdk-go/issues/1335)
Release v1.8.39 (2017-06-09)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/opsworks`: Updates service API and documentation
  * Tagging Support for AWS OpsWorks Stacks

Release v1.8.38 (2017-06-08)
===

### Service Client Updates
* `service/iot`: Updates service API and documentation
  * In addition to using certificate ID, AWS IoT customers can now obtain the description of a certificate with the certificate PEM.
* `service/pinpoint`: Updates service API and documentation
  * Starting today Amazon Pinpoint adds SMS Text and Email Messaging support in addition to Mobile Push Notifications, providing developers, product managers and marketers with multi-channel messaging capabilities to drive user engagement in their applications. Pinpoint also enables backend services and applications to message users directly and provides advanced user and app analytics to understand user behavior and messaging performance.
* `service/rekognition`: Updates service API and documentation
  * API Update for AmazonRekognition: Adding RecognizeCelebrities API

Release v1.8.37 (2017-06-07)
===

### Service Client Updates
* `service/codebuild`: Updates service API and documentation
  * Add support to APIs for privileged containers. This change would allow performing privileged operations like starting the Docker daemon inside builds possible in custom docker images.
* `service/greengrass`: Adds new service
  * AWS Greengrass is software that lets you run local compute, messaging, and device state synchronization for connected devices in a secure way. With AWS Greengrass, connected devices can run AWS Lambda functions, keep device data in sync, and communicate with other devices securely even when not connected to the Internet. Using AWS Lambda, Greengrass ensures your IoT devices can respond quickly to local events, operate with intermittent connections, and minimize the cost of transmitting IoT data to the cloud.

Release v1.8.36 (2017-06-06)
===

### Service Client Updates
* `service/acm`: Updates service documentation
  * Documentation update for AWS Certificate Manager.
* `service/cloudfront`: Updates service documentation
  * Doc update to fix incorrect prefix in S3OriginConfig
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/iot`: Updates service API
  * Update client side validation for SalesForce action.

Release v1.8.35 (2017-06-05)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * AppStream 2.0 Custom Security Groups allows you to easily control what network resources your streaming instances and images have access to. You can assign up to 5 security groups per Fleet to control the inbound and outbound network access to your streaming instances to specific IP ranges, network protocols, or ports.
* `service/iot`: Updates service API, documentation, paginators, and examples
  * Added Salesforce action to IoT Rules Engine.

Release v1.8.34 (2017-06-02)
===

### Service Client Updates
* `service/kinesisanalytics`: Updates service API, documentation, and paginators
  * Kinesis Analytics publishes error messages CloudWatch logs in case of application misconfigurations
* `service/workdocs`: Updates service API and documentation
  * This release includes new APIs to manage tags and custom metadata on resources and also new APIs to add and retrieve comments at the document level.

Release v1.8.33 (2017-06-01)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * AWS CodeDeploy has improved how it manages connections to GitHub accounts and repositories. You can now create and store up to 25 connections to GitHub accounts in order to associate AWS CodeDeploy applications with GitHub repositories. Each connection can support multiple repositories. You can create connections to up to 25 different GitHub accounts, or create more than one connection to a single account. The ListGitHubAccountTokenNames command has been introduced to retrieve the names of stored connections to GitHub accounts that you have created. The name of the connection to GitHub used for an AWS CodeDeploy application is also included in the ApplicationInfo structure.  Two new fields, lastAttemptedDeployment and lastSuccessfulDeployment, have been added to DeploymentGroupInfo to improve the handling of deployment group information in the AWS CodeDeploy console. Information about these latest deployments can also be retrieved using the GetDeploymentGroup and BatchGetDeployment group requests. Also includes a region update  (us-gov-west-1).
* `service/cognitoidentityprovider`: Updates service API, documentation, and paginators
* `service/elbv2`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lexmodelbuildingservice`: Updates service documentation and examples

### SDK Enhancements
* `aws/defaults`: Exports shared credentials and config default filenames used by the SDK. [#1308](https://github.com/aws/aws-sdk-go/pull/1308)
  * Adds SharedCredentialsFilename and SharedConfigFilename functions to defaults package.

### SDK Bugs
* `aws/credentials`: Fixes shared credential provider's default filename on Windows. [#1308](https://github.com/aws/aws-sdk-go/pull/1308)
  * The shared credentials provider would attempt to use the wrong filename on Windows if the `HOME` environment variable was defined.
* `service/s3/s3manager`: service/s3/s3manager: Fix Downloader ignoring Range get parameter [#1311](https://github.com/aws/aws-sdk-go/pull/1311)
  * Fixes the S3 Download Manager ignoring the GetObjectInput's Range parameter. If this parameter is provided it will force the downloader to fallback to a single GetObject request disabling concurrency and automatic part size gets.
  * Fixes [#1296](https://github.com/aws/aws-sdk-go/issues/1296)
Release v1.8.32 (2017-05-31)
===

### Service Client Updates
* `service/rds`: Updates service API and documentation
  * Amazon RDS customers can now easily and quickly stop and start their DB instances.

Release v1.8.31 (2017-05-30)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API, documentation, and paginators
  * Cloud Directory has launched support for Typed Links, enabling customers to create object-to-object relationships that are not hierarchical in nature. Typed Links enable customers to quickly query for data along these relationships. Customers can also enforce referential integrity using Typed Links, ensuring data in use is not inadvertently deleted.
* `service/s3`: Updates service paginators and examples
  * New example snippets for Amazon S3.

Release v1.8.30 (2017-05-25)
===

### Service Client Updates
* `service/appstream`: Updates service API and documentation
  * Support added for persistent user storage, backed by S3.
* `service/rekognition`: Updates service API and documentation
  * Updated the CompareFaces API response to include orientation information, unmatched faces, landmarks, pose, and quality of the compared faces.

Release v1.8.29 (2017-05-24)
===

### Service Client Updates
* `service/iam`: Updates service API
  * The unique ID and access key lengths were extended from 32 to 128
* `service/storagegateway`: Updates service API and documentation
  * Two Storage Gateway data types, Tape and TapeArchive, each have a new response element, TapeUsedInBytes. This element helps you manage your virtual tapes. By using TapeUsedInBytes, you can see the amount of data written to each virtual tape.
* `service/sts`: Updates service API, documentation, and paginators
  * The unique ID and access key lengths were extended from 32 to 128.

Release v1.8.28 (2017-05-23)
===

### Service Client Updates
* `service/databasemigrationservice`: Updates service API, documentation, paginators, and examples
  * This release adds support for using Amazon S3 and Amazon DynamoDB as targets for database migration, and using MongoDB as a source for database migration. For more information, see the AWS Database Migration Service documentation.

Release v1.8.27 (2017-05-22)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/resourcegroupstaggingapi`: Updates service API, documentation, and paginators
  * You can now specify the number of resources returned per page in GetResources operation, as an optional parameter, to easily manage the list of resources returned by your queries.

### SDK Bugs
* `aws/request`: Add support for PUT temporary redirects (307) [#1283](https://github.com/aws/aws-sdk-go/issues/1283)
  * Adds support for Go 1.8's GetBody function allowing the SDK's http request using PUT and POST methods to be redirected with temporary redirects with 307 status code.
  * Fixes: [#1267](https://github.com/aws/aws-sdk-go/issues/1267)
* `aws/request`: Add handling for retrying temporary errors during unmarshal [#1289](https://github.com/aws/aws-sdk-go/issues/1289)
  * Adds support for retrying temporary errors that occur during unmarshaling of a request's response body.
  * Fixes: [#1275](https://github.com/aws/aws-sdk-go/issues/1275)
Release v1.8.26 (2017-05-18)
===

### Service Client Updates
* `service/athena`: Adds new service
  * This release adds support for Amazon Athena. Amazon Athena is an interactive query service that makes it easy to analyze data in Amazon S3 using standard SQL. Athena is serverless, so there is no infrastructure to manage, and you pay only for the queries that you run.
* `service/lightsail`: Updates service API, documentation, and paginators
  * This release adds new APIs that make it easier to set network port configurations on Lightsail instances. Developers can now make a single request to both open and close public ports on an instance using the PutInstancePublicPorts operation.

### SDK Bugs
* `aws/request`: Fix logging from reporting wrong retry request errors #1281
  * Fixes the SDK's retry request logging to report the the actual error that occurred, not a stubbed Unknown error message.
  * Fixes the SDK's response logger to not output the response log multiple times per retry.
Release v1.8.25 (2017-05-17)
===

### Service Client Updates
* `service/autoscaling`: Updates service documentation, paginators, and examples
  * Various Auto Scaling documentation updates
* `service/cloudwatchevents`: Updates service documentation
  * Various CloudWatch Events documentation updates.
* `service/cloudwatchlogs`: Updates service documentation and paginators
  * Various CloudWatch Logs documentation updates.
* `service/polly`: Updates service API
  * Amazon Polly adds new German voice "Vicki"

Release v1.8.24 (2017-05-16)
===

### Service Client Updates
* `service/codedeploy`: Updates service API and documentation
  * This release introduces the previousRevision field in the responses to the GetDeployment and BatchGetDeployments actions. previousRevision provides information about the application revision that was deployed to the deployment group before the most recent successful deployment.  Also, the fileExistsBehavior parameter has been added for CreateDeployment action requests. In the past, if the AWS CodeDeploy agent detected files in a target location that weren't part of the application revision from the most recent successful deployment, it would fail the current deployment by default. This new parameter provides options for how the agent handles these files: fail the deployment, retain the content, or overwrite the content.
* `service/gamelift`: Updates service API and documentation
  * Allow developers to specify how metrics are grouped in CloudWatch for their GameLift fleets. Developers can also specify how many concurrent game sessions activate on a per-instance basis.
* `service/inspector`: Updates service API, documentation, paginators, and examples
  * Adds ability to produce an assessment report that includes detailed and comprehensive results of a specified assessment run.
* `service/kms`: Updates service documentation
  * Update documentation for KMS.

Release v1.8.23 (2017-05-15)
===

### Service Client Updates
* `service/ssm`: Updates service API and documentation
  * UpdateAssociation API now supports updating document name and targets of an association. GetAutomationExecution API can return FailureDetails as an optional field to the StepExecution Object, which contains failure type, failure stage as well as other failure related information for a failed step.

### SDK Enhancements
* `aws/session`: SDK should be able to load multiple custom shared config files. [#1258](https://github.com/aws/aws-sdk-go/issues/1258)
  * This change adds a `SharedConfigFiles` field to the `session.Options` type that allows you to specify the files, and their order, the SDK will use for loading shared configuration and credentials from when the `Session` is created. Use the `NewSessionWithOptions` Session constructor to specify these options. You'll also most likely want to enable support for the shared configuration file's additional attributes by setting `session.Option`'s `SharedConfigState` to `session.SharedConfigEnabled`. 

Release v1.8.22 (2017-05-11)
===

### Service Client Updates
* `service/elb`: Updates service API, documentation, and paginators
* `service/elbv2`: Updates service API and documentation
* `service/lexmodelbuildingservice`: Updates service API and documentation
* `service/organizations`: Updates service API, documentation, paginators, and examples
  * AWS Organizations APIs that return an Account object now include the email address associated with the account’s root user.

Release v1.8.21 (2017-05-09)
===

### Service Client Updates
* `service/codestar`: Updates service documentation
  * Updated documentation for AWS CodeStar.
* `service/workspaces`: Updates service API, documentation, and paginators
  * Doc-only Update for WorkSpaces

Release v1.8.20 (2017-05-04)
===

### Service Client Updates
* `service/ecs`: Updates service API, documentation, and paginators
  * Exposes container instance registration time in ECS:DescribeContainerInstances.
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/marketplaceentitlementservice`: Adds new service
* `service/lambda`: Updates service API and documentation
  * Support for UpdateFunctionCode DryRun option

Release v1.8.19 (2017-04-28)
===

### Service Client Updates
* `service/cloudformation`: Updates service waiters and paginators
  * Adding back the removed waiters and paginators.

Release v1.8.18 (2017-04-28)
===

### Service Client Updates
* `service/cloudformation`: Updates service API, documentation, waiters, paginators, and examples
  * API update for CloudFormation: New optional parameter ClientRequestToken which can be used as an idempotency token to safely retry certain operations as well as tagging StackEvents.
* `service/rds`: Updates service API, documentation, and examples
  * The DescribeDBClusterSnapshots API now returns a SourceDBClusterSnapshotArn field which identifies the source DB cluster snapshot of a copied snapshot.
* `service/rekognition`: Updates service API
  * Fix for missing file type check
* `service/snowball`: Updates service API, documentation, and paginators
  * The Snowball API has a new exception that can be thrown for list operation requests.
* `service/sqs`: Updates service API, documentation, and paginators
  * Adding server-side encryption (SSE) support to SQS by integrating with AWS KMS; adding new queue attributes to SQS CreateQueue, SetQueueAttributes and GetQueueAttributes APIs to support SSE.

Release v1.8.17 (2017-04-26)
===

### Service Client Updates
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * With Amazon Relational Database Service (Amazon RDS) running MySQL or Amazon Aurora, you can now authenticate to your DB instance using IAM database authentication.

Release v1.8.16 (2017-04-21)
===

### Service Client Updates
* `service/appstream`: Updates service API, documentation, and paginators
  * The new feature named "Default Internet Access" will enable Internet access from AppStream 2.0 instances - image builders and fleet instances. Admins will check a flag either through AWS management console for AppStream 2.0 or through API while creating an image builder or while creating/updating a fleet.
* `service/kinesis`: Updates service API, documentation, waiters, and paginators
  * Adds a new waiter, StreamNotExists, to Kinesis.

### SDK Enhancements
* `aws/endpoints`: Add utilities improving endpoints lookup (#1218)
  * Adds several utilities to the endpoints packages to make looking up partitions, regions, and services easier.
  * Fixes #994

### SDK Bugs
* `private/protocol/xml/xmlutil`: Fix unmarshaling dropping errors (#1219)
  * The XML unmarshaler would drop any serialization or body read error that occurred on the floor effectively hiding any errors that would occur.
  * Fixes #1205
Release v1.8.15 (2017-04-20)
===

### Service Client Updates
* `service/devicefarm`: Updates service API and documentation
  * API Update for AWS Device Farm: Support for Deals and Promotions
* `service/directconnect`: Updates service documentation
  * Documentation updates for AWS Direct Connect.
* `service/elbv2`: Updates service waiters
* `service/kms`: Updates service documentation and examples
  * Doc-only update for Key Management Service (KMS): Update docs for GrantConstraints and GenerateRandom
* `service/route53`: Updates service documentation
  * Release notes: SDK documentation now includes examples for ChangeResourceRecordSets for all types of resource record set, such as weighted, alias, and failover.
* `service/route53domains`: Updates service API, documentation, and paginators
  * Adding examples and other documentation updates.

### SDK Enhancements
* `service/s3`: Add utilities to make getting a bucket's region easier (#1207)
  * Adds two features which make it easier to get a bucket's region, `s3.NormalizeBucketLocation` and `s3manager.GetBucketRegion`.

### SDK Bugs
* `service/s3`: Fix HeadObject's incorrect documented error codes (#1213)
  * The HeadObject's model incorrectly states that the operation can return the NoSuchKey error code.
  * Fixes #1208

Release v1.8.14 (2017-04-19)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * Add support for "embed" property.
* `service/codestar`: Adds new service
  * AWS CodeStar is a cloud-based service for creating, managing, and working with software development projects on AWS. An AWS CodeStar project creates and integrates AWS services for your project development toolchain. AWS CodeStar also manages the permissions required for project users.
* `service/ec2`: Updates service API and documentation
  * Adds support for creating an Amazon FPGA Image (AFI) from a specified design checkpoint (DCP).
* `service/iam`: Updates service API and documentation
  * This changes introduces a new IAM role type, Service Linked Role, which works like a normal role but must be managed via services' control.
* `service/lambda`: Updates service API and documentation
  * Lambda integration with CloudDebugger service to enable customers to enable tracing for the Lambda functions and send trace information to the CloudDebugger service.
* `service/lexmodelbuildingservice`: Adds new service
* `service/polly`: Updates service API, documentation, and paginators
  * API Update for Amazon Polly: Add support for speech marks
* `service/rekognition`: Updates service API and documentation
  * Given an image, the API detects explicit or suggestive adult content in the image and returns a list of corresponding labels with confidence scores, as well as a taxonomy (parent-child relation) for each label.

Release v1.8.13 (2017-04-18)
===

### Service Client Updates
* `service/lambda`: Updates service API and documentation
  * You can use tags to group and filter your Lambda functions, making it easier to analyze them for billing allocation purposes. For more information, see Tagging Lambda Functions.  You can now write or upgrade your Lambda functions using Python version 3.6. For more information, see Programming Model for Authoring Lambda Functions in Python. Note: Features will be rolled out in the US regions on 4/19.

### SDK Enhancements
* `aws/request`: add support for appengine's custom standard library (#1190)
  * Remove syscall error checking on appengine platforms.

Release v1.8.12 (2017-04-11)
===

### Service Client Updates
* `service/apigateway`: Updates service API and documentation
  * API Gateway request validators
* `service/batch`: Updates service API and documentation
  * API Update for AWS Batch: Customer provided AMI for MANAGED Compute Environment
* `service/gamelift`: Updates service API and documentation
  * Allows developers to utilize an improved workflow when calling our Queues API and introduces a new feature that allows developers to specify a maximum allowable latency per Queue.
* `service/opsworks`: Updates service API, documentation, and paginators
  * Cloudwatch Logs agent configuration can now be attached to OpsWorks Layers using CreateLayer and UpdateLayer. OpsWorks will then automatically install and manage the CloudWatch Logs agent on the instances part of the OpsWorks Layer.

### SDK Bugs
* `aws/client`: Fix clients polluting handler list (#1197)
  * Fixes the clients potentially polluting the passed in handler list with the client's customizations. This change ensures every client always works with a clean copy of the request handlers and it cannot pollute the handlers back upstream.
  * Fixes #1184
* `aws/request`: Fix waiter error match condition (#1195)
  * Fixes the waiters's matching overwriting the request's err, effectively ignoring the error condition. This broke waiters with the FailureWaiterState matcher state.
Release v1.8.11 (2017-04-07)
===

### Service Client Updates
* `service/redshift`: Updates service API, documentation, and paginators
  * This update adds the GetClusterCredentials API which is used to get temporary login credentials to the cluster. AccountWithRestoreAccess now has a new member AccountAlias, this is the identifier of the AWS support account authorized to restore the specified snapshot. This is added to support the feature where the customer can share their snapshot with the Amazon Redshift Support Account without having to manually specify the AWS Redshift Service account ID on the AWS Console/API.

Release v1.8.10 (2017-04-06)
===

### Service Client Updates
* `service/elbv2`: Updates service documentation

Release v1.8.9 (2017-04-05)
===

### Service Client Updates
* `service/elasticache`: Updates service API, documentation, paginators, and examples
  * ElastiCache added support for testing the Elasticache Multi-AZ feature with Automatic Failover.

Release v1.8.8 (2017-04-04)
===

### Service Client Updates
* `service/cloudwatch`: Updates service API, documentation, and paginators
  * Amazon Web Services announced the immediate availability of two additional alarm configuration rules for Amazon CloudWatch Alarms. The first rule is for configuring missing data treatment. Customers have the options to treat missing data as alarm threshold breached, alarm threshold not breached, maintain alarm state and the current default treatment. The second rule is for alarms based on percentiles metrics that can trigger unnecassarily if the percentile is calculated from a small number of samples. The new rule can treat percentiles with low sample counts as same as missing data. If the first rule is enabled, the same treatment will be applied when an alarm encounters a percentile with low sample counts.

Release v1.8.7 (2017-04-03)
===

### Service Client Updates
* `service/lexruntimeservice`: Updates service API and documentation
  * Adds support to PostContent for speech input

### SDK Enhancements
* `aws/request`: Improve handler copy, push back, push front performance (#1171)
  * Minor optimization to the handler list's handling of copying and pushing request handlers to the handler list.
* Update codegen header to use Go std wording (#1172)
  * Go recently accepted the proposal for standard generated file header wording in, https://golang.org/s/generatedcode.

### SDK Bugs
* `service/dynamodb`: Fix DynamoDB using custom retryer (#1170)
  * Fixes (#1139) the DynamoDB service client clobbering any custom retryer that was passed into the service client or Session's config.
Release v1.8.6 (2017-04-01)
===

### Service Client Updates
* `service/clouddirectory`: Updates service API and documentation
  * ListObjectAttributes now supports filtering by facet.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.8.5 (2017-03-30)
===

### Service Client Updates
* `service/cloudformation`: Updates service waiters and paginators
  * Adding paginators for ListExports and ListImports
* `service/cloudfront`: Adds new service
  * Amazon CloudFront now supports user configurable HTTP Read and Keep-Alive Idle Timeouts for your Custom Origin Servers
* `service/configservice`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/resourcegroupstaggingapi`: Adds new service
* `service/storagegateway`: Updates service API and documentation
  * File gateway mode in AWS Storage gateway provides access to objects in S3 as files on a Network File System (NFS) mount point. Once a file share is created, any changes made externally to the S3 bucket will not be reflected by the gateway. Using the cache refresh feature in this update, the customer can trigger an on-demand scan of the keys in their S3 bucket and refresh the file namespace cached on the gateway. It takes as an input the fileShare ARN and refreshes the cache for only that file share. Additionally there is new functionality on file gateway that allows you configure what squash options they would like on their file share, this allows a customer to configure their gateway to not squash root permissions. This can be done by setting options in NfsOptions for CreateNfsFileShare and UpdateNfsFileShare APIs.

Release v1.8.4 (2017-03-28)
===

### Service Client Updates
* `service/batch`: Updates service API, documentation, and paginators
  * Customers can now provide a retryStrategy as part of the RegisterJobDefinition and SubmitJob API calls. The retryStrategy object has a number value for attempts. This is the number of non successful executions before a job is considered FAILED. In addition, the JobDetail object now has an attempts field and shows all execution attempts.
* `service/ec2`: Updates service API and documentation
	* Customers can now tag their Amazon EC2 Instances and Amazon EBS Volumes at
	the time of their creation. You can do this from the EC2 Instance launch
	wizard or through the RunInstances or CreateVolume APIs. By tagging
	resources at the time of creation, you can eliminate the need to run custom
	tagging scripts after resource creation. In addition, you can now set
	resource-level permissions on the CreateVolume, CreateTags, DeleteTags, and
	the RunInstances APIs. This allows you to implement stronger security
	policies by giving you more granular control over which users and groups
	have access to these APIs. You can also enforce the use of tagging and
	control what tag keys and values are set on your resources. When you combine
	tag usage and resource-level IAM policies together, you can ensure your
	instances and volumes are properly secured upon creation and achieve more
	accurate cost allocation reporting. These new features are provided at no
	additional cost.

### SDK Enhancements
* `aws/request`: Add retry support for RequestTimeoutException (#1158)
  * Adds support for retrying RequestTimeoutException error code that is returned by some services.

### SDK Bugs
* `private/model/api`: Fix Waiter and Paginators panic on nil param inputs (#1157)
  * Corrects the code generation for Paginators and waiters that caused a panic if nil input parameters were used with the operations.
Release v1.8.3 (2017-03-27)
===

## Service Client Updates
* `service/ssm`: Updates service API, documentation, and paginators
  * Updated validation rules for SendCommand and RegisterTaskWithMaintenanceWindow APIs.
Release v1.8.2 (2017-03-24)
===

Service Client Updates
---
* `service/applicationautoscaling`: Updates service API, documentation, and paginators
  * Application AutoScaling is launching support for a new target resource (AppStream 2.0 Fleets) as a scalable target.
* `service/cloudtrail`: Updates service API and documentation
  * Doc-only Update for CloudTrail: Add required parameters for GetEventSelectors and PutEventSelectors

Release v1.8.1 (2017-03-23)
===

Service Client Updates
---
* `service/applicationdiscoveryservice`: Updates service API, documentation, and paginators
  * Adds export configuration options to the AWS Discovery Service API.
* `service/elbv2`: Updates waiters
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/lambda`: Updates service API and paginators
  * Adds support for new runtime Node.js v6.10 for AWS Lambda service

Release v1.8.0 (2017-03-22)
===

Service Client Updates
---
* `service/codebuild`: Updates service documentation
* `service/directconnect`: Updates service API
  * Deprecated DescribeConnectionLoa, DescribeInterconnectLoa, AllocateConnectionOnInterconnect and DescribeConnectionsOnInterconnect operations in favor of DescribeLoa, DescribeLoa, AllocateHostedConnection and DescribeHostedConnections respectively.
* `service/marketplacecommerceanalytics`: Updates service API, documentation, and paginators
  * This update adds a new data set, us_sales_and_use_tax_records, which enables AWS Marketplace sellers to programmatically access to their U.S. Sales and Use Tax report data.
* `service/pinpoint`: Updates service API and documentation
  * Amazon Pinpoint User Segmentation
  * Added ability to segment endpoints by user attributes in addition to endpoint attributes. Amazon Pinpoint Event Stream Preview
  * Added functionality to publish raw app analytics and campaign events data as events streams to Kinesis and Kinesis Firehose
  * The feature provides developers with increased flexibility of exporting raw events to S3, Redshift, Elasticsearch using a Kinesis Firehose stream or enable real time event processing use cases using a Kinesis stream
* `service/rekognition`: Updates service documentation.

SDK Features
---
* `aws/request`: Add support for context.Context to SDK API operation requests (#1132)
  * Adds support for context.Context to the SDK by adding `WithContext` methods for each API operation, Paginators and Waiters. e.g `PutObjectWithContext`. This change also adds the ability to provide request functional options to the method calls instead of requiring you to use the `Request` API operation method (e.g `PutObjectRequest`).
  * Adds a `Complete` Request handler list that will be called ever time a request is completed. This includes both success and failure. Complete will only be called once per API operation request.
  * `private/waiter` package moved from the private group to `aws/request/waiter` and made publicly available.
  * Adds Context support to all API operations, Waiters(WaitUntil) and Paginators(Pages) methods.
  * Adds Context support for s3manager and s3crypto clients.

SDK Enhancements
---
* `aws/signer/v4`: Adds support for unsigned payload signer config (#1130)
  * Adds configuration option to the v4.Signer to specify the request's body should not be signed. This will only correclty function on services that support unsigned payload. e.g. S3, Glacier. 

SDK Bug Fixes
---
* `service/s3`: Fix S3 HostID to be available in S3 request error message (#1131)
  * Adds a new type s3.RequestFailure which exposes the S3 HostID value from a S3 API operation response. This is helpful when you have an error with S3, and need to contact support. Both RequestID and HostID are needed.
* `private/model/api`: Do not return a link if uid is empty (#1133)
  * Fixes SDK's doc generation to not generate API reference doc links if the SDK us unable to create a valid link.
* `aws/request`: Optimization to handler list copy to prevent multiple alloc calls. (#1134)
Release v1.7.9 (2017-03-13)
===

Service Client Updates
---
* `service/devicefarm`: Updates service API, documentation, paginators, and examples
  * Network shaping allows users to simulate network connections and conditions while testing their Android, iOS, and web apps with AWS Device Farm.
* `service/cloudwatchevents`: Updates service API, documentation, and examples

SDK Enhancement
===
* `aws/session`: Add support for side loaded CA bundles (#1117)
  * Adds supports for side loading Certificate Authority bundle files to the SDK using AWS_CA_BUNDLE environment variable or CustomCABundle session option.
* `service/s3/s3crypto`: Add support for AES/CBC/PKCS5Padding (#1124)

SDK Bug
===
* `service/rds`: Fixing issue when not providing `SourceRegion` on cross
region operations (#1127)
* `service/rds`: Enables cross region for `CopyDBClusterSnapshot` and
`CreateDBCluster` (#1128)

Release v1.7.8 (2017-03-10)
===

Service Client Updates
---
* `service/codedeploy`: Updates service paginators
  * Add paginators for Codedeploy
* `service/emr`: Updates service API, documentation, and paginators
  * This release includes support for instance fleets in Amazon EMR.

Release v1.7.7 (2017-03-09)
===

Service Client Updates
---
* `service/apigateway`: Updates service API, documentation, and paginators
  * API Gateway has added support for ACM certificates on custom domain names. Both Amazon-issued certificates and uploaded third-part certificates are supported.
* `service/clouddirectory`: Updates service API, documentation, and paginators
  * Introduces a new Cloud Directory API that enables you to retrieve all available parent paths for any type of object (a node, leaf node, policy node, and index node) in a hierarchy.

Release v1.7.6 (2017-03-09)
===

Service Client Updates
---
* `service/organizations`: Updates service documentation and examples
  * Doc-only Update for Organizations: Add SDK Code Snippets
* `service/workdocs`: Adds new service
  * The Administrative SDKs for Amazon WorkDocs provides full administrator level access to WorkDocs site resources, allowing developers to integrate their applications to manage WorkDocs users, content and permissions programmatically

Release v1.7.5 (2017-03-08)
===

Service Client Updates
---
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * Add support to using encrypted clusters as cross-region replication masters. Update CopyDBClusterSnapshot API to support encrypted cross region copy of Aurora cluster snapshots.

Release v1.7.4 (2017-03-06)
===

Service Client Updates
---
* `service/budgets`: Updates service API and paginators
  * When creating or editing a budget via the AWS Budgets API you can define notifications that are sent to subscribers when the actual or forecasted value for cost or usage exceeds the notificationThreshold associated with the budget notification object. Starting today, the maximum allowed value for the notificationThreshold was raised from 100 to 300. This change was made to give you more flexibility when setting budget notifications.
* `service/cloudtrail`: Updates service documentation and paginators
  * Doc-only update for AWSCloudTrail: Updated links/descriptions
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/opsworkscm`: Updates service API, documentation, and paginators
  * OpsWorks for Chef Automate has added a new field "AssociatePublicIpAddress" to the CreateServer request, "CloudFormationStackArn" to the Server model and "TERMINATED" server state.


Release v1.7.3 (2017-02-28)
===

Service Client Updates
---
* `service/mturk`: Renaming service
  * service/mechanicalturkrequesterservice was renamed to service/mturk. Be sure to change any references of the old client to the new.

Release v1.7.2 (2017-02-28)
===

Service Client Updates
---
* `service/dynamodb`: Updates service API and documentation
  * Release notes: Time to Live (TTL) is a feature that allows you to define when items in a table expire and can be purged from the database, so that you don't have to track expired data and delete it manually. With TTL enabled on a DynamoDB table, you can set a timestamp for deletion on a per-item basis, allowing you to limit storage usage to only those records that are relevant.
* `service/iam`: Updates service API, documentation, and paginators
  * This release adds support for AWS Organizations service control policies (SCPs) to SimulatePrincipalPolicy operation. If there are SCPs associated with the simulated user's account, their effect on the result is captured in the OrganizationDecisionDetail element in the EvaluationResult.
* `service/mechanicalturkrequesterservice`: Adds new service
  * Amazon Mechanical Turk is a web service that provides an on-demand, scalable, human workforce to complete jobs that humans can do better than computers, for example, recognizing objects in photos.
* `service/organizations`: Adds new service
  * AWS Organizations is a web service that enables you to consolidate your multiple AWS accounts into an organization and centrally manage your accounts and their resources.
* `service/dynamodbstreams`: Updates service API, documentation, and paginators
* `service/waf`: Updates service API, documentation, and paginators
  * Aws WAF - For GetSampledRequests action, changed max number of samples from 100 to 500.
* `service/wafregional`: Updates service API, documentation, and paginators

Release v1.7.1 (2017-02-24)
===

Service Client Updates
---
* `service/elasticsearchservice`: Updates service API, documentation, paginators, and examples
  * Added three new API calls to existing Amazon Elasticsearch service to expose Amazon Elasticsearch imposed limits to customers.

Release v1.7.0 (2017-02-23)
===

Service Client Updates
---
* `service/ec2`: Updates service API
  * New EC2 I3 instance type

SDK Bug
---
* `service/s3/s3manager`: Adding support for SSE (#1097)
  * Fixes SSE fields not being applied to a part during multi part upload.

SDK Feature
---
* `aws/session`: Add support for AssumeRoles with MFA (#1088)
  * Adds support for assuming IAM roles with MFA enabled. A TokenProvider func was added to stscreds.AssumeRoleProvider that will be called each time the role's credentials need to be refreshed. A basic token provider that sources the MFA token from stdin as stscreds.StdinTokenProvider.
* `aws/session`: Update SDK examples and docs to use session.Must (#1099)
  * Updates the SDK's example and docs to use session.Must where possible to highlight its usage as apposed to session error checking that is most cases errors will be terminal to the application anyways.
Release v1.6.27 (2017-02-22)
===

Service Client Updates
---
* `service/clouddirectory`: Updates service documentation
  * ListObjectAttributes documentation updated based on forum feedback
* `service/elasticbeanstalk`: Updates service API, documentation, and paginators
  * Elastic Beanstalk adds support for creating and managing custom platform.
* `service/gamelift`: Updates service API, documentation, and paginators
  * Allow developers to configure global queues for creating GameSessions. Allow PlayerData on PlayerSessions to store player-specific data.
* `service/route53`: Updates service API, documentation, and examples
  * Added support for operations CreateVPCAssociationAuthorization and DeleteVPCAssociationAuthorization to throw a ConcurrentModification error when a conflicting modification occurs in parallel to the authorizations in place for a given hosted zone.

Release v1.6.26 (2017-02-21)
===

Service Client Updates
---
* `service/ec2`: Updates service API and documentation
  * Added the billingProduct parameter to the RegisterImage API.

Release v1.6.25 (2017-02-17)
===

Service Client Updates
---
* `service/directconnect`: Updates service API, documentation, and paginators
  * This update will introduce the ability for Direct Connect customers to take advantage of Link Aggregation (LAG).     This allows you to bundle many individual physical interfaces into a single logical interface, referred to as a LAG.     This makes administration much simpler as the majority of configuration is done on the LAG while you are free     to add or remove physical interfaces from the bundle as bandwidth demand increases or decreases. A concrete example     of the simplification added by LAG is that customers need only a single BGP session as opposed to one session per     physical connection.

Release v1.6.24 (2017-02-16)
===

Service Client Updates
---
* `service/cognitoidentity`: Updates service API, documentation, and paginators
  * Allow createIdentityPool and updateIdentityPool API to set server side token check value on identity pool
* `service/configservice`: Updates service API and documentation
  * AWS Config now supports a new test mode for the PutEvaluations API. Set the TestMode parameter to true in your custom rule to verify whether your AWS Lambda function will deliver evaluation results to AWS Config. No updates occur to your existing evaluations, and evaluation results are not sent to AWS Config.

Release v1.6.23 (2017-02-15)
===

Service Client Updates
---
* `service/kms`: Updates service API, documentation, paginators, and examples
  * his release of AWS Key Management Service introduces the ability to tag keys. Tagging keys can help you organize your keys and track your KMS costs in the cost allocation report. This release also increases the maximum length of a key ID to accommodate ARNs that include a long key alias.

Release v1.6.22 (2017-02-14)
===

Service Client Updates
---
* `service/ec2`: Updates service API, documentation, and paginators
  * Adds support for the new Modify Volumes apis.

Release v1.6.21 (2017-02-11)
===

Service Client Updates
---
* `service/storagegateway`: Updates service API, documentation, and paginators
  * File gateway mode in AWS Storage gateway provides access to objects in S3 as files on a Network File System (NFS) mount point. This is done by creating Nfs file shares using existing APIs CreateNfsFileShare. Using the feature in this update, the customer can restrict the clients that have read/write access to the gateway by specifying the list of clients as a list of IP addresses or CIDR blocks. This list can be specified using the API CreateNfsFileShare while creating new file shares, or UpdateNfsFileShare while update existing file shares. To find out the list of clients that have access, the existing API DescribeNfsFileShare will now output the list of clients that have access.

Release v1.6.20 (2017-02-09)
===

Service Client Updates
---
* `service/ec2`: Updates service API and documentation
  * This feature allows customers to associate an IAM profile to running instances that do not have any.
* `service/rekognition`: Updates service API and documentation
  * DetectFaces and IndexFaces operations now return an estimate of the age of the face as an age range.

SDK Features
---
* `aws/endpoints`: Add option to resolve unknown endpoints (#1074)
Release v1.6.19 (2017-02-08)
===

Service Client Updates
---
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glacier`: Updates service examples
	* Doc Update
* `service/lexruntimeservice`: Adds new service
	* Preview release

SDK Bug Fixes
---
* `private/protocol/json`: Fixes json to throw an error if a float number is (+/-)Inf and NaN (#1068)
* `private/model/api`: Fix documentation error listing (#1067)

SDK Features
---
* `private/model`: Add service response error code generation (#1061)

Release v1.6.18 (2017-01-27)
===

Service Client Updates
---
* `service/clouddirectory`: Adds new service
  * Amazon Cloud Directory is a highly scalable, high performance, multi-tenant directory service in the cloud. Its web-based directories make it easy for you to organize and manage application resources such as users, groups, locations, devices, policies, and the rich relationships between them.
* `service/codedeploy`: Updates service API, documentation, and paginators
  * This release of AWS CodeDeploy introduces support for blue/green deployments. In a blue/green deployment, the current set of instances in a deployment group is replaced by new instances that have the latest application revision installed on them. After traffic is rerouted behind a load balancer to the replacement instances, the original instances can be terminated automatically or kept running for other uses.
* `service/ec2`: Updates service API and documentation
  * Adds instance health check functionality to replace unhealthy EC2 Spot fleet instances with fresh ones.
* `service/rds`: Updates service API and documentation
  * Snapshot Engine Version Upgrade

Release v1.6.17 (2017-01-25)
===

Service Client Updates
---
* `service/elbv2`: Updates service API, documentation, and paginators
  * Application Load Balancers now support native Internet Protocol version 6 (IPv6) in an Amazon Virtual Private Cloud (VPC). With this ability, clients can now connect to the Application Load Balancer in a dual-stack mode via either IPv4 or IPv6.
* `service/rds`: Updates service API and documentation
  * Cross Region Read Replica Copying (CreateDBInstanceReadReplica)

Release v1.6.16 (2017-01-24)
===

Service Client Updates
---
* `service/codebuild`: Updates service documentation and paginators
  * Documentation updates
* `service/codecommit`: Updates service API, documentation, and paginators
  * AWS CodeCommit now includes the option to view the differences between a commit and its parent commit from within the console. You can view the differences inline (Unified view) or side by side (Split view). To view information about the differences between a commit and something other than its parent, you can use the AWS CLI and the get-differences and get-blob commands, or you can use the GetDifferences and GetBlob APIs.
* `service/ecs`: Updates service API and documentation
  * Amazon ECS now supports a state for container instances that can be used to drain a container instance in preparation for maintenance or cluster scale down.

Release v1.6.15 (2017-01-20)
===

Service Client Updates
---
* `service/acm`: Updates service API, documentation, and paginators
  * Update for AWS Certificate Manager: Updated response elements for DescribeCertificate API in support of managed renewal
* `service/health`: Updates service documentation

Release v1.6.14 (2017-01-19)
===

Service Client Updates
---
* `service/ec2`: Updates service API, documentation, and paginators
  * Amazon EC2 Spot instances now support dedicated tenancy, providing the ability to run Spot instances single-tenant manner on physically isolated hardware within a VPC to satisfy security, privacy, or other compliance requirements. Dedicated Spot instances can be requested using RequestSpotInstances and RequestSpotFleet.

Release v1.6.13 (2017-01-18)
===

Service Client Updates
---
* `service/rds`: Updates service API, documentation, and paginators

Release v1.6.12 (2017-01-17)
===

Service Client Updates
---
* `service/dynamodb`: Updates service API, documentation, and paginators
  * Tagging Support for Amazon DynamoDB Tables and Indexes
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/glacier`: Updates service API, paginators, and examples
  * Doc-only Update for Glacier: Added code snippets
* `service/polly`: Updates service documentation and examples
  * Doc-only update for Amazon Polly -- added snippets
* `service/rekognition`: Updates service documentation and paginators
  * Added code samples to Rekognition reference topics.
* `service/route53`: Updates service API and paginators
  * Add ca-central-1 and eu-west-2 enum values to CloudWatchRegion enum

Release v1.6.11 (2017-01-16)
===

Service Client Updates
---
* `service/configservice`: Updates service API, documentation, and paginators
* `service/costandusagereportservice`: Adds new service
  * The AWS Cost and Usage Report Service API allows you to enable and disable the Cost & Usage report, as well as modify the report name, the data granularity, and the delivery preferences.
* `service/dynamodb`: Updates service API, documentation, and examples
  * Snippets for the DynamoDB API.
* `service/elasticache`: Updates service API, documentation, and examples
  * Adds new code examples.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.6.10 (2017-01-04)
===

Service Client Updates
---
* `service/configservice`: Updates service API and documentation
  * AWSConfig is planning to add support for OversizedConfigurationItemChangeNotification message type in putConfigRule. After this release customers can use/write rules based on OversizedConfigurationItemChangeNotification mesage type.
* `service/efs`: Updates service API, documentation, and examples
  * Doc-only Update for EFS: Added code snippets
* `service/iam`: Updates service documentation and examples
* `service/lambda`: Updates service documentation and examples
  * Doc only updates for Lambda: Added code snippets
* `service/marketplacecommerceanalytics`: Updates service API and documentation
  * Added support for data set disbursed_amount_by_instance_hours, with historical data available starting 2012-09-04. New data is published to this data set every 30 days.
* `service/rds`: Updates service documentation
  * Updated documentation for CopyDBSnapshot.
* `service/rekognition`: Updates service documentation and examples
  * Doc-only Update for Rekognition: Added code snippets
* `service/snowball`: Updates service examples
* `service/dynamodbstreams`: Updates service API and examples
  * Doc-only Update for DynamoDB Streams:  Added code snippets

SDK Feature
---
* `private/model/api`: Increasing the readability of code generated files. (#1024)
Release v1.6.9 (2016-12-30)
===

Service Client Updates
---
* `service/codedeploy`: Updates service API and documentation
  * CodeDeploy will support Iam Session Arns in addition to Iam User Arns for on premise host authentication.
* `service/ecs`: Updates service API and documentation
  * Amazon EC2 Container Service (ECS) now supports the ability to customize the placement of tasks on container instances.
* `aws/endpoints`: Updated Regions and Endpoints metadata.

Release v1.6.8 (2016-12-22)
===

Service Client Updates
---
* `service/apigateway`: Updates service API and documentation
  * Amazon API Gateway is adding support for generating SDKs in more languages. This update introduces two new operations used to dynamically discover these SDK types and what configuration each type accepts.
* `service/directoryservice`: Updates service documentation
  * Added code snippets for the DS SDKs
* `service/elasticbeanstalk`: Updates service API and documentation
* `service/iam`: Updates service API and documentation
  * Adds service-specific credentials to IAM service to make it easier to onboard CodeCommit customers.  These are username/password credentials that work with a single service.
* `service/kms`: Updates service API, documentation, and examples
  * Update docs and add SDK examples

Release v1.6.7 (2016-12-22)
===

Service Client Updates
---
* `service/ecr`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/rds`: Updates service API and documentation
  * Cross Region Encrypted Snapshot Copying (CopyDBSnapshot)

Release v1.6.6 (2016-12-20)
===

Service Client Updates
---
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/firehose`: Updates service API, documentation, and examples
  * Processing feature enables users to process and modify records before Amazon Firehose delivers them to destinations.
* `service/route53`: Updates service API and documentation
  * Enum updates for eu-west-2 and ca-central-1
* `service/storagegateway`: Updates service API, documentation, and examples
  * File gateway is a new mode in the AWS Storage Gateway that support a file interface into S3, alongside the current block-based volume and VTL storage. File gateway combines a service and virtual software appliance, enabling you to store and retrieve objects in Amazon S3 using industry standard file protocols such as NFS. The software appliance, or gateway, is deployed into your on-premises environment as a virtual machine (VM) running on VMware ESXi. The gateway provides access to objects in S3 as files on a Network File System (NFS) mount point.

Release v1.6.5 (2016-12-19)
===

Service Client Updates
---
* `service/cloudformation`: Updates service documentation
  * Minor doc update for CloudFormation.
* `service/cloudtrail`: Updates service paginators
* `service/cognitoidentity`: Updates service API and documentation
  * We are adding Groups to Cognito user pools. Developers can perform CRUD operations on groups, add and remove users from groups, list users in groups, etc. We are adding fine-grained role-based access control for Cognito identity pools. Developers can configure an identity pool to get the IAM role from an authenticated user's token, or they can configure rules that will map a user to a different role
* `service/applicationdiscoveryservice`: Updates service API and documentation
  * Adds new APIs to group discovered servers into Applications with get summary and neighbors. Includes additional filters for ListConfigurations and DescribeAgents API.
* `service/inspector`: Updates service API, documentation, and examples
  * Doc-only Update for Inspector: Adding SDK code snippets for Inspector
* `service/sqs`: Updates service documentation

SDK Bug Fixes
---
* `aws/request`: Add PriorRequestNotComplete to throttle retry codes (#1011)
  * Fixes: Not retrying when PriorRequestNotComplete #1009

SDK Feature
---
* `private/model/api`: Adds crosslinking to service documentation (#1010)

Release v1.6.4 (2016-12-15)
===

Service Client Updates
---
* `service/cognitoidentityprovider`: Updates service API and documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/ssm`: Updates service API and documentation
  * This will provide customers with access to the Patch Baseline and Patch Compliance APIs.

SDK Bug Fixes
---
* `service/route53`: Fix URL path cleaning for Route53 API requests (#1006)
  * Fixes: SerializationError when using Route53 ChangeResourceRecordSets #1005
* `aws/request`: Add PriorRequestNotComplete to throttle retry codes (#1002)
  * Fixes: Not retrying when PriorRequestNotComplete #1001

Release v1.6.3 (2016-12-14)
===

Service Client Updates
---
* `service/batch`: Adds new service
  * AWS Batch is a batch computing service that lets customers define queues and compute environments and then submit work as batch jobs.
* `service/databasemigrationservice`: Updates service API and documentation
  * Adds support for SSL enabled Oracle endpoints and task modification.
* `service/elasticbeanstalk`: Updates service documentation
* `aws/endpoints`: Updated Regions and Endpoints metadata.
* `service/cloudwatchlogs`: Updates service API and documentation
  * Add support for associating LogGroups with AWSTagris tags
* `service/marketplacecommerceanalytics`: Updates service API and documentation
  * Add new enum to DataSetType: sales_compensation_billed_revenue
* `service/rds`: Updates service documentation
  * Doc-only Update for RDS: New versions available in CreateDBInstance
* `service/sts`: Updates service documentation
  * Adding Code Snippet Examples for SDKs for STS

SDK Bug Fixes
---
* `aws/request`: Fix retrying timeout requests (#981)
  * Fixes: Requests Retrying is broken if the error was caused due to a client timeout #947
* `aws/request`: Fix for Go 1.8 request incorrectly sent with body (#991)
  * Fixes: service/route53: ListHostedZones hangs and then fails with go1.8 #984
* private/protocol/rest: Use RawPath instead of Opaque (#993)
  * Fixes: HTTP2 request failing with REST protocol services, e.g AWS X-Ray
* private/model/api: Generate REST-JSON JSONVersion correctly (#998)
  * Fixes: REST-JSON protocol service code missing JSONVersion metadata.

Release v1.6.2 (2016-12-08)
===

Service Client Updates
---
* `service/cloudfront`: Add lambda function associations to cache behaviors
* `service/codepipeline`: This is a doc-only update request to incorporate some recent minor revisions to the doc content.
* `service/rds`: Updates service API and documentation
* `service/wafregional`: With this new feature, customers can use AWS WAF directly on Application Load Balancers in a VPC within available regions to protect their websites and web services from malicious attacks such as SQL injection, Cross Site Scripting, bad bots, etc.

Release v1.6.1 (2016-12-07)
===

Service Client Updates
---
* `service/config`: Updates service API
* `service/s3`: Updates service API
* `service/sqs`: Updates service API and documentation

Release v1.6.0 (2016-12-06)
===

Service Client Updates
---
* `service/config`: Updates service API and documentation
* `service/ec2`: Updates service API
* `service/sts`: Updates service API, documentation, and examples

SDK Bug Fixes
---
* private/protocol/xml/xmlutil: Fix SDK XML unmarshaler #975
  * Fixes GetBucketACL Grantee required type always nil. #916

SDK Feature
---
* aws/endpoints: Add endpoint metadata to SDK #961
  * Adds Region and Endpoint metadata to the SDK. This allows you to enumerate regions and endpoint metadata based on a defined model embedded in the SDK.

Release v1.5.13 (2016-12-01)
===

Service Client Updates
---
* `service/apigateway`: Updates service API and documentation
* `service/appstream`: Adds new service
* `service/codebuild`: Adds new service
* `service/directconnect`: Updates service API and documentation
* `service/ec2`: Adds new service
* `service/elasticbeanstalk`: Updates service API and documentation
* `service/health`: Adds new service
* `service/lambda`: Updates service API and documentation
* `service/opsworkscm`: Adds new service
* `service/pinpoint`: Adds new service
* `service/shield`: Adds new service
* `service/ssm`: Updates service API and documentation
* `service/states`: Adds new service
* `service/xray`: Adds new service

Release v1.5.12 (2016-11-30)
===

Service Client Updates
---
* `service/lightsail`: Adds new service
* `service/polly`: Adds new service
* `service/rekognition`: Adds new service
* `service/snowball`: Updates service API and documentation

Release v1.5.11 (2016-11-29)
===

Service Client Updates
---
`service/s3`: Updates service API and documentation

Release v1.5.10 (2016-11-22)
===

Service Client Updates
---
* `service/cloudformation`: Updates service API and documentation
* `service/glacier`: Updates service API, documentation, and examples
* `service/route53`: Updates service API and documentation
* `service/s3`: Updates service API and documentation

SDK Bug Fixes
---
* `private/protocol/xml/xmlutil`: Fixes xml marshaler to unmarshal properly
into tagged fields 
[#916](https://github.com/aws/aws-sdk-go/issues/916)

Release v1.5.9 (2016-11-22)
===

Service Client Updates
---
* `service/cloudtrail`: Updates service API and documentation
* `service/ecs`: Updates service API and documentation

Release v1.5.8 (2016-11-18)
===

Service Client Updates
---
* `service/application-autoscaling`: Updates service API and documentation
* `service/elasticmapreduce`: Updates service API and documentation
* `service/elastictranscoder`: Updates service API, documentation, and examples
* `service/gamelift`: Updates service API and documentation
* `service/lambda`: Updates service API and documentation

Release v1.5.7 (2016-11-18)
===

Service Client Updates
---
* `service/apigateway`: Updates service API and documentation
* `service/meteringmarketplace`: Updates service API and documentation
* `service/monitoring`: Updates service API and documentation
* `service/sqs`: Updates service API, documentation, and examples

Release v1.5.6 (2016-11-16)
===

Service Client Updates
---
`service/route53`: Updates service API and documentation
`service/servicecatalog`: Updates service API and documentation

Release v1.5.5 (2016-11-15)
===

Service Client Updates
---
* `service/ds`: Updates service API and documentation
* `service/elasticache`: Updates service API and documentation
* `service/kinesis`: Updates service API and documentation

Release v1.5.4 (2016-11-15)
===

Service Client Updates
---
* `service/cognito-idp`: Updates service API and documentation

Release v1.5.3 (2016-11-11)
===

Service Client Updates
---
* `service/cloudformation`: Updates service documentation and examples
* `service/logs`: Updates service API and documentation

Release v1.5.2 (2016-11-03)
===

Service Client Updates
---
* `service/directconnect`: Updates service API and documentation

Release v1.5.1 (2016-11-02)
===

Service Client Updates
---
* `service/email`: Updates service API and documentation

Release v1.5.0 (2016-11-01)
===

Service Client Updates
---
* `service/cloudformation`: Updates service API and documentation
* `service/ecr`: Updates service paginators

SDK Feature Updates
---
* `private/model/api`: Add generated setters for API parameters (#918)
  * Adds setters to the SDK's API parameter types, and are a convenience method that reduce the need to use `aws.String` and like utility. 

Release v1.4.22 (2016-10-25)
===

Service Client Updates
---
* `service/elasticloadbalancingv2`: Updates service documentation.
* `service/autoscaling`: Updates service documentation.

Release v1.4.21 (2016-10-24)
===

Service Client Updates
---
* `service/sms`: AWS Server Migration Service (SMS) is an agentless service which makes it easier and faster for you to migrate thousands of on-premises workloads to AWS. AWS SMS allows you to automate, schedule, and track incremental replications of live server volumes, making it easier for you to coordinate large-scale server migrations.
* `service/ecs`: Updates documentation.

SDK Feature Updates
---
* `private/models/api`: Improve code generation of documentation.

Release v1.4.20 (2016-10-20)
===

Service Client Updates
---
* `service/budgets`: Adds new service, AWS Budgets.
* `service/waf`: Updates service documentation.

Release v1.4.19 (2016-10-18)
===

Service Client Updates
---
* `service/cloudfront`: Updates service API and documentation.
  * Ability to use Amazon CloudFront to deliver your content both via IPv6 and IPv4 using HTTP/HTTPS.
* `service/configservice`: Update service API and documentation.
* `service/iot`: Updates service API and documentation.
* `service/kinesisanalytics`: Updates service API and documentation.
  * Whenever Amazon Kinesis Analytics is not able to detect schema for the given streaming source on DiscoverInputSchema API, we would return the raw records that was sampled to detect the schema.
* `service/rds`: Updates service API and documentation.
  * Amazon Aurora integrates with other AWS services to allow you to extend your Aurora DB cluster to utilize other capabilities in the AWS cloud. Permission to access other AWS services is granted by creating an IAM role with the necessary permissions, and then associating the role with your DB cluster.

SDK Feature Updates
---
* `service/dynamodb/dynamodbattribute`: Add UnmarshalListOfMaps #897
  * Adds support for unmarshaling a list of maps. This is useful for unmarshaling the DynamoDB AttributeValue list of maps returned by APIs like Query and Scan.

Release v1.4.18 (2016-10-17)
===

Service Model Updates
---
* `service/route53`: Updates service API and documentation.

Release v1.4.17
===

Service Model Updates
---
* `service/acm`: Update service API, and documentation.
  * This change allows users to import third-party SSL/TLS certificates into ACM.
* `service/elasticbeanstalk`: Update service API, documentation, and pagination.
  * Elastic Beanstalk DescribeApplicationVersions API is being updated to support pagination.
* `service/gamelift`: Update service API, and documentation.
  * New APIs to protect game developer resource (builds, alias, fleets, instances, game sessions and player sessions) against abuse.

SDK Features
---
* `service/s3`: Add support for accelerate with dualstack [#887](https://github.com/aws/aws-sdk-go/issues/887)

Release v1.4.16 (2016-10-13)
===

Service Model Updates
---
* `service/ecr`: Update Amazon EC2 Container Registry service model
  * DescribeImages is a new api used to expose image metadata which today includes image size and image creation timestamp.
* `service/elasticache`: Update Amazon ElastiCache service model
  * Elasticache is launching a new major engine release of Redis, 3.2 (providing stability updates and new command sets over 2.8), as well as ElasticSupport for enabling Redis Cluster in 3.2, which provides support for multiple node groups to horizontally scale data, as well as superior engine failover capabilities 

SDK Bug Fixes
---
* `aws/session`: Skip shared config on read errors [#883](https://github.com/aws/aws-sdk-go/issues/883)
* `aws/signer/v4`: Add support for URL.EscapedPath to signer [#885](https://github.com/aws/aws-sdk-go/issues/885)

SDK Features
---
* `private/model/api`: Add docs for errors to API operations [#881](https://github.com/aws/aws-sdk-go/issues/881)
* `private/model/api`: Improve field and waiter doc strings [#879](https://github.com/aws/aws-sdk-go/issues/879)
* `service/dynamodb/dynamodbattribute`: Allow multiple struct tag elements [#886](https://github.com/aws/aws-sdk-go/issues/886)
* Add build tags to internal SDK tools [#880](https://github.com/aws/aws-sdk-go/issues/880)

Release v1.4.15 (2016-10-06)
===

Service Model Updates
---
* `service/cognitoidentityprovider`: Update Amazon Cognito Identity Provider service model
* `service/devicefarm`: Update AWS Device Farm documentation
* `service/opsworks`: Update AWS OpsWorks service model
* `service/s3`: Update Amazon Simple Storage Service model
* `service/waf`: Update AWS WAF service model

SDK Bug Fixes
---
* `aws/request`: Fix HTTP Request Body race condition [#874](https://github.com/aws/aws-sdk-go/issues/874)

SDK Feature Updates
---
* `aws/ec2metadata`: Add support for EC2 User Data [#872](https://github.com/aws/aws-sdk-go/issues/872)
* `aws/signer/v4`: Remove logic determining if request needs to be resigned [#876](https://github.com/aws/aws-sdk-go/issues/876)

Release v1.4.14 (2016-09-29)
===
* `service/ec2`:  api, documentation, and paginators updates.
* `service/s3`:  api and documentation updates.

Release v1.4.13 (2016-09-27)
===
* `service/codepipeline`:  documentation updates.
* `service/cloudformation`:  api and documentation updates.
* `service/kms`:  documentation updates.
* `service/elasticfilesystem`:  documentation updates.
* `service/snowball`:  documentation updates.
