#ifndef FPMAS_RANDOM_DISTRIBUTION_API_H
#define FPMAS_RANDOM_DISTRIBUTION_API_H

/** \file src/fpmas/api/random/distribution.h
 * Random Distribution API
 */

#include "generator.h"

namespace fpmas { namespace api { namespace random {

	/**
	 * Defines a generic random distribution API.
	 *
	 * @tparam T type of generated random values
	 */
	template<typename T>
	class Distribution {
		public:
			/**
			 * Returns the minimum value potentially generated by the
			 * distribution.
			 *
			 * @return minimum generated value
			 */
			virtual T min() const = 0;

			/**
			 * Returns the maximum value potentially generated by the
			 * distribution.
			 *
			 * @return maximum generated value
			 */
			virtual T max() const = 0;

			virtual ~Distribution() {}
	};
}}}
#endif
