/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.analysis.AutoValue_AnalysesConfig;
import com.google.errorprone.analysis.TopLevelAnalysis;
import java.util.Set;

public abstract class AnalysesConfig {
    public static AnalysesConfig create(ErrorProneOptions options) {
        return new AutoValue_AnalysesConfig(options);
    }

    AnalysesConfig() {
    }

    abstract ErrorProneOptions errorProneOptions();

    void validate(TopLevelAnalysis analysis) throws InvalidCommandLineOptionException {
        if (!this.errorProneOptions().ignoreUnknownChecks()) {
            Set<String> knownAnalyses = analysis.knownAnalysisNames();
            for (String configured : this.errorProneOptions().getSeverityMap().keySet()) {
                if (knownAnalyses.contains(configured)) continue;
                throw new InvalidCommandLineOptionException(configured + " is not a valid checker name");
            }
        }
    }
}

