/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

abstract class AbstractAsyncTypeReturnsNull
extends BugChecker
implements BugChecker.ReturnTreeMatcher {
    private final Matcher<MethodTree> implementsAsyncTypeMethod;

    AbstractAsyncTypeReturnsNull(Class<?> asyncClass) {
        this.implementsAsyncTypeMethod = AbstractAsyncTypeReturnsNull.overridesMethodOfClass(asyncClass);
    }

    @Override
    public final Description matchReturn(ReturnTree tree, VisitorState state) {
        if (Matchers.enclosingMethod(this.implementsAsyncTypeMethod).matches(tree, state) && tree.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
            return this.describeMatch(tree, SuggestedFix.builder().replace(tree.getExpression(), "immediateFuture(null)").addStaticImport(Futures.class.getName() + ".immediateFuture").build());
        }
        return Description.NO_MATCH;
    }

    private static Matcher<MethodTree> overridesMethodOfClass(final Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree tree, VisitorState state) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
                if (symbol == null) {
                    return false;
                }
                for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods(symbol, state.getTypes())) {
                    if (superMethod.owner == null || !superMethod.owner.getQualifiedName().contentEquals(clazz.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

