/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ArrayToStringCompoundAssignment", summary="Implicit toString used on an array (String += Array)", explanation="When concatenating-and-assigning an array to a string, the implicit toString call on the array will yield its identity, such as [I@4488aabb. This is almost never needed. Use Arrays.toString to obtain a human-readable array summary.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ArrayToStringCompoundAssignment
extends BugChecker
implements BugChecker.CompoundAssignmentTreeMatcher {
    private static final Matcher<CompoundAssignmentTree> assignmentMatcher = Matchers.compoundAssignment(Tree.Kind.PLUS_ASSIGNMENT, Matchers.isSameType("java.lang.String"), Matchers.isArrayType());

    @Override
    public Description matchCompoundAssignment(CompoundAssignmentTree t, VisitorState state) {
        if (!assignmentMatcher.matches(t, state)) {
            return Description.NO_MATCH;
        }
        String receiver = t.getVariable().toString();
        String expression = t.getExpression().toString();
        Fix fix = SuggestedFix.builder().replace(t, receiver + " += Arrays.toString(" + expression + ")").addImport("java.util.Arrays").build();
        return this.describeMatch(t, fix);
    }
}

