/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

@BugPattern(name="InjectInvalidTargetingOnScopingAnnotation", summary="The target of a scoping annotation must be set to METHOD and/or TYPE.", explanation="Scoping annotations are only appropriate for provision and therefore are only appropriate on @Provides methods and classes that will be provided just-in-time.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectInvalidTargetingOnScopingAnnotation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final String TARGET_ANNOTATION = "java.lang.annotation.Target";
    private static final Matcher<ClassTree> SCOPE_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"));

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol(classTree);
        if ((((Symbol)classSymbol).flags() & 0x2000L) != 0L && SCOPE_ANNOTATION_MATCHER.matches(classTree, state)) {
            Target target = ASTHelpers.getAnnotation(classSymbol, Target.class);
            boolean hasExclusivelyTypeAndOrMethodTargeting = false;
            if (target != null) {
                for (ElementType elementType : target.value()) {
                    if (elementType != ElementType.METHOD && elementType != ElementType.TYPE) {
                        return this.describe(classTree, state);
                    }
                    if (elementType != ElementType.METHOD && elementType != ElementType.TYPE) continue;
                    hasExclusivelyTypeAndOrMethodTargeting = true;
                }
            }
            if (!hasExclusivelyTypeAndOrMethodTargeting) {
                return this.describe(classTree, state);
            }
        }
        return Description.NO_MATCH;
    }

    public Description describe(ClassTree classTree, VisitorState state) {
        Attribute.Compound target = ASTHelpers.getSymbol(classTree).attribute(state.getSymbolFromString(TARGET_ANNOTATION));
        if (target == null) {
            return this.describeMatch(classTree, SuggestedFix.builder().addImport(TARGET_ANNOTATION).addStaticImport("java.lang.annotation.ElementType.TYPE").addStaticImport("java.lang.annotation.ElementType.METHOD").prefixWith(classTree, "@Target({TYPE, METHOD})\n").build());
        }
        AnnotationTree targetNode = null;
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotationTree).equals(state.getSymbolFromString(TARGET_ANNOTATION))) continue;
            targetNode = annotationTree;
        }
        return this.describeMatch(targetNode, SuggestedFix.builder().addImport(TARGET_ANNOTATION).addStaticImport("java.lang.annotation.ElementType.TYPE").addStaticImport("java.lang.annotation.ElementType.METHOD").replace(targetNode, "@Target({TYPE, METHOD})").build());
    }
}

