/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="JavaxInjectOnFinalField", summary="@javax.inject.Inject cannot be put on a final field.", explanation="According to the JSR-330 spec, the @javax.inject.Inject annotation cannot go on final fields.)", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectJavaxInjectOnFinalField
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final Matcher<Tree> FINAL_FIELD_MATCHER = new Matcher<Tree>(){

        @Override
        public boolean matches(Tree t, VisitorState state) {
            return InjectJavaxInjectOnFinalField.isField(t, state) && ((VariableTree)t).getModifiers().getFlags().contains((Object)Modifier.FINAL);
        }
    };
    private static final Matcher<AnnotationTree> JAVAX_INJECT_ANNOTATION_MATCHER = new AnnotationType("javax.inject.Inject");

    @Override
    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (JAVAX_INJECT_ANNOTATION_MATCHER.matches(annotationTree, state) && FINAL_FIELD_MATCHER.matches(InjectJavaxInjectOnFinalField.getAnnotatedNode(state), state)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private static Tree getAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }

    private static boolean isField(Tree tree, VisitorState state) {
        return tree.getKind().equals((Object)Tree.Kind.VARIABLE) && ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class).getMembers().contains(tree);
    }
}

