/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;

@BugPattern(name="InjectedConstructorAnnotations", summary="Injected constructors cannot be optional nor have binding annotations", explanation="The constructor is annotated with @Inject(optional=true), or it is annotated with @Inject and a binding annotation. This will cause a Guice runtime error.\n\nSee [https://code.google.com/p/google-guice/wiki/InjectionPoints] for details.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectedConstructorAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String GUICE_BINDING_ANNOTATION = "com.google.inject.BindingAnnotation";
    private static final Matcher<AnnotationTree> OPTIONAL_INJECTION_MATCHER = Matchers.allOf(Matchers.isType("com.google.inject.Inject"), Matchers.hasArgumentWithValue("optional", Matchers.booleanLiteral(true)));
    private static final Matcher<AnnotationTree> BINDING_ANNOTATION_MATCHER = new Matcher<AnnotationTree>(){

        @Override
        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            return Matchers.hasAnnotation(InjectedConstructorAnnotations.GUICE_BINDING_ANNOTATION).matches(annotationTree.getAnnotationType(), state);
        }
    };

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        SuggestedFix.Builder fix = null;
        if (this.isInjectedConstructor(methodTree, state)) {
            for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
                if (OPTIONAL_INJECTION_MATCHER.matches(annotationTree, state)) {
                    if (fix == null) {
                        fix = SuggestedFix.builder();
                    }
                    fix = fix.replace(annotationTree, "@Inject");
                    continue;
                }
                if (!BINDING_ANNOTATION_MATCHER.matches(annotationTree, state)) continue;
                if (fix == null) {
                    fix = SuggestedFix.builder();
                }
                fix = fix.delete(annotationTree);
            }
        }
        if (fix == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, fix.build());
    }

    private boolean isInjectedConstructor(MethodTree methodTree, VisitorState state) {
        return Matchers.allOf(Matchers.methodIsConstructor(), Matchers.hasAnnotation(GUICE_INJECT_ANNOTATION)).matches(methodTree, state);
    }
}

