/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="MissingOverride", summary="method overrides method in supertype; expected @Override", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class MissingOverride
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation(sym, Override.class)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol override = this.getFirstOverride(sym, state.getTypes());
        if (override == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation(override, Deprecated.class)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix(SuggestedFix.prefixWith(tree, "@Override ")).setMessage(String.format("%s %s method in %s; expected @Override", ((Symbol)sym).getSimpleName(), override.enclClass().isInterface() || override.getModifiers().contains((Object)Modifier.ABSTRACT) ? "implements" : "overrides", override.enclClass().getSimpleName())).build();
    }

    private Symbol.MethodSymbol getFirstOverride(Symbol sym, Types types) {
        Symbol.ClassSymbol owner = sym.enclClass();
        for (Type s : types.closure(owner.type)) {
            if (s == owner.type) continue;
            for (Symbol m : s.tsym.members().getSymbolsByName(sym.name)) {
                Symbol.MethodSymbol msym;
                if (!(m instanceof Symbol.MethodSymbol) || (msym = (Symbol.MethodSymbol)m).isStatic() || !sym.overrides(msym, owner, types, false)) continue;
                return msym;
            }
        }
        return null;
    }
}

