/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.OperatorPrecedence;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.EnumMap;
import javax.lang.model.type.TypeKind;

@BugPattern(name="NarrowingCompoundAssignment", summary="Compound assignments to bytes, shorts, chars, and floats hide dangerous casts", explanation="The compound assignment E1 op= E2 could be mistaken for being equivalent to  E1 = E1 op E2. However, this is not the case: compound  assignment operators automatically cast the result of the computation to the type on the left hand side. So E1 op= E2 is actually equivalent to E1 = (T) (E1 op E2), where T is the type of E1. If the type of the expression is wider than the type of the variable (i.e. the variable is a byte, char, short, or float), then the compound assignment will perform a narrowing primitive conversion. Attempting to perform the equivalent simple assignment would generate a compilation error.\n\n For example, 'byte b = 0; b = b << 1;' does not compile, but 'byte b = 0; b <<= 1;' does!\n\n (See Puzzle #9 in 'Java Puzzlers: Traps, Pitfalls, and Corner Cases'.)", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class NarrowingCompoundAssignment
extends BugChecker
implements BugChecker.CompoundAssignmentTreeMatcher {
    private static final EnumMap<TypeKind, String> DEFICIENT_TYPES = new EnumMap(TypeKind.class);

    static String assignmentToString(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case REMAINDER: {
                return "%";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case AND: {
                return "&";
            }
            case XOR: {
                return "^";
            }
            case OR: {
                return "|";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
        }
        throw new IllegalArgumentException("Unexpected operator assignment kind: " + (Object)((Object)kind));
    }

    static Tree.Kind regularAssignmentFromCompound(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY_ASSIGNMENT: {
                return Tree.Kind.MULTIPLY;
            }
            case DIVIDE_ASSIGNMENT: {
                return Tree.Kind.DIVIDE;
            }
            case REMAINDER_ASSIGNMENT: {
                return Tree.Kind.REMAINDER;
            }
            case PLUS_ASSIGNMENT: {
                return Tree.Kind.PLUS;
            }
            case MINUS_ASSIGNMENT: {
                return Tree.Kind.MINUS;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case AND_ASSIGNMENT: {
                return Tree.Kind.AND;
            }
            case XOR_ASSIGNMENT: {
                return Tree.Kind.XOR;
            }
            case OR_ASSIGNMENT: {
                return Tree.Kind.OR;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
        }
        throw new IllegalArgumentException("Unexpected compound assignment kind: " + (Object)((Object)kind));
    }

    @Override
    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        Tree.Kind rhsKind;
        String deficient = DEFICIENT_TYPES.get((Object)NarrowingCompoundAssignment.type(tree.getVariable()).getKind());
        if (deficient == null) {
            return Description.NO_MATCH;
        }
        if (state.getTypes().isConvertible(NarrowingCompoundAssignment.type(tree.getExpression()), NarrowingCompoundAssignment.type(tree.getVariable()))) {
            return Description.NO_MATCH;
        }
        String var = state.getSourceForNode((JCTree)((Object)tree.getVariable()));
        String expr = state.getSourceForNode((JCTree)((Object)tree.getExpression()));
        if (var == null || expr == null) {
            return Description.NO_MATCH;
        }
        switch (tree.getKind()) {
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Description.NO_MATCH;
            }
        }
        Tree.Kind regularAssignmentKind = NarrowingCompoundAssignment.regularAssignmentFromCompound(tree.getKind());
        String op = NarrowingCompoundAssignment.assignmentToString(regularAssignmentKind);
        if (tree.getExpression() instanceof JCTree.JCBinary && OperatorPrecedence.from(rhsKind = ((JCTree.JCBinary)tree.getExpression()).getKind()) == OperatorPrecedence.from(regularAssignmentKind)) {
            expr = String.format("(%s)", expr);
        }
        String replacement = String.format("%s = (%s) (%s %s %s)", var, deficient, var, op, expr);
        return this.describeMatch(tree, SuggestedFix.replace(tree, replacement));
    }

    static Type type(Tree tree) {
        return ((JCTree)tree).type;
    }

    static {
        DEFICIENT_TYPES.put(TypeKind.BYTE, "byte");
        DEFICIENT_TYPES.put(TypeKind.SHORT, "short");
        DEFICIENT_TYPES.put(TypeKind.CHAR, "char");
        DEFICIENT_TYPES.put(TypeKind.FLOAT, "float");
    }
}

