/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="UnsynchronizedOverridesSynchronized", summary="Unsynchronized method overrides a synchronized method.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class UnsynchronizedOverridesSynchronized
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(methodTree);
        if (UnsynchronizedOverridesSynchronized.isSynchronized(methodSymbol)) {
            return Description.NO_MATCH;
        }
        for (Symbol.MethodSymbol s : ASTHelpers.findSuperMethods(methodSymbol, state.getTypes())) {
            if (!UnsynchronizedOverridesSynchronized.isSynchronized(s) || ASTHelpers.isSameType(s.owner.type, state.getTypeFromString("java.io.InputStream"), state)) continue;
            return this.buildDescription(methodTree).addFix(SuggestedFix.addModifier(methodTree, Modifier.SYNCHRONIZED, state)).setMessage(String.format("Unsynchronized method %s overrides synchronized method in %s", methodSymbol.getSimpleName(), s.enclClass().getSimpleName())).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean isSynchronized(Symbol.MethodSymbol sym) {
        return sym.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }
}

