/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnnotationInfo;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.lang.reflect.TypeVariable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class WellKnownMutability {
    static final ImmutableMap<String, ImmutableAnnotationInfo> KNOWN_IMMUTABLE = WellKnownMutability.getBootstrapClasses();
    static final ImmutableSet<String> KNOWN_UNSAFE = WellKnownMutability.getKnownUnsafeClasses();

    WellKnownMutability() {
    }

    private static ImmutableMap<String, ImmutableAnnotationInfo> getBootstrapClasses() {
        return new Builder().addAll(Primitives.allPrimitiveTypes()).addAll(Primitives.allWrapperTypes()).add(Class.class, new String[0]).add(String.class, new String[0]).add(InetAddress.class, new String[0]).add(Locale.class, new String[0]).add("org.joda.time.DateTime", new String[0]).add("org.joda.time.DateTimeZone", new String[0]).add("org.joda.time.Duration", new String[0]).add("org.joda.time.Instant", new String[0]).add("org.joda.time.LocalDate", new String[0]).add("org.joda.time.LocalDateTime", new String[0]).add("org.joda.time.format.DateTimeFormatter", new String[0]).add(UnsignedLong.class, new String[0]).add(Converter.class, new String[0]).add("com.google.protobuf.ByteString", new String[0]).add("com.google.protobuf.Descriptors$Descriptor", new String[0]).add("com.google.protobuf.Descriptors$EnumDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FieldDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FileDescriptor", new String[0]).add("com.google.protobuf.Descriptors$ServiceDescriptor", new String[0]).add("com.google.protobuf.ExtensionRegistry$ExtensionInfo", new String[0]).add("com.google.common.net.MediaType", new String[0]).add("com.google.common.net.Uri", new String[0]).add("com.google.protobuf.Extension", new String[0]).add(ImmutableCollection.class, "E").add(ImmutableSet.class, "E").add(ImmutableList.class, "E").add(ImmutableMultiset.class, "E").add(ImmutableMap.class, "K", "V").add(ImmutableBiMap.class, "K", "V").add(ImmutableMultimap.class, "K", "V").add(ImmutableRangeMap.class, "K", "V").add(ImmutableTable.class, "R", "C", "V").add(Optional.class, "T").add(Splitter.class, new String[0]).add(Joiner.class, new String[0]).add(Range.class, "C").build();
    }

    private static ImmutableSet<String> getKnownUnsafeClasses() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Class clazz : ImmutableSet.of(Iterable.class, Object.class, ArrayList.class, Collection.class, List.class, Map.class, (Object[])new Class[]{Set.class, EnumSet.class, EnumMap.class})) {
            result.add((Object)clazz.getName());
        }
        return result.build();
    }

    public static boolean isImmutableProto(VisitorState state, Type type) {
        return WellKnownMutability.isProto2MessageClass(state, type) && !WellKnownMutability.isProto2MutableMessageClass(state, type);
    }

    private static boolean isProto2MessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        Type messageType = state.getTypeFromString("com.google.protobuf.MessageLite");
        if (messageType == null) {
            return false;
        }
        Type protocolMessageType = state.getTypeFromString("com.google.io.protocol.ProtocolMessage");
        if (protocolMessageType == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isAssignable(type, messageType) && !types.isAssignable(type, protocolMessageType);
    }

    private static boolean isProto2MutableMessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        Type mutableMessageType = state.getTypeFromString("com.google.protobuf.MutableMessageLite");
        if (mutableMessageType == null) {
            return false;
        }
        Type protocolMessageType = state.getTypeFromString("com.google.io.protocol.ProtocolMessage");
        if (protocolMessageType == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isAssignable(type, mutableMessageType) && !types.isAssignable(type, protocolMessageType);
    }

    static class Builder {
        ImmutableMap.Builder<String, ImmutableAnnotationInfo> mapBuilder = ImmutableMap.builder();

        Builder() {
        }

        public Builder addAll(Set<Class<?>> clazzs) {
            for (Class<?> clazz : clazzs) {
                this.add(clazz, new String[0]);
            }
            return this;
        }

        public Builder add(Class<?> clazz, String ... containerOf) {
            ImmutableSet containerTyParams = ImmutableSet.copyOf((Object[])containerOf);
            HashSet<String> actualTyParams = new HashSet<String>();
            for (TypeVariable<Class<?>> x : clazz.getTypeParameters()) {
                actualTyParams.add(x.getName());
            }
            Sets.SetView difference = Sets.difference((Set)containerTyParams, actualTyParams);
            if (!difference.isEmpty()) {
                throw new AssertionError((Object)String.format("Container type parameter(s) %s did not exist, expected %s", difference, actualTyParams));
            }
            this.mapBuilder.put((Object)clazz.getName(), (Object)ImmutableAnnotationInfo.create(clazz.getName(), (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        public Builder add(String className, String ... containerOf) {
            this.mapBuilder.put((Object)className, (Object)ImmutableAnnotationInfo.create(className, (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        public ImmutableMap<String, ImmutableAnnotationInfo> build() {
            return this.mapBuilder.build();
        }
    }
}

