/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;

public final class DataFlow {
    private static LoadingCache<AnalysisParams, Analysis<?, ?, ?>> analysisCache = CacheBuilder.newBuilder().build(new CacheLoader<AnalysisParams, Analysis<?, ?, ?>>(){

        public Analysis<?, ?, ?> load(AnalysisParams key) {
            ProcessingEnvironment env = key.getEnvironment();
            ControlFlowGraph cfg = key.getCFG();
            TransferFunction transfer = key.getTransferFunction();
            Analysis analysis = new Analysis(env, transfer);
            analysis.performAnalysis(cfg);
            return analysis;
        }
    });
    private static LoadingCache<CFGParams, ControlFlowGraph> cfgCache = CacheBuilder.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<CFGParams, ControlFlowGraph>(){

        public ControlFlowGraph load(CFGParams key) {
            TreePath methodPath = key.getMethodPath();
            MethodTree method = (MethodTree)methodPath.getLeaf();
            BlockTree body = method.getBody();
            TreePath bodyPath = new TreePath(methodPath, body);
            ClassTree classTree = null;
            UnderlyingAST.CFGMethod ast = new UnderlyingAST.CFGMethod(method, classTree);
            ProcessingEnvironment env = key.getEnvironment();
            analysisCache.invalidateAll();
            CompilationUnitTree root = bodyPath.getCompilationUnit();
            return CFGBuilder.build((CompilationUnitTree)root, (ProcessingEnvironment)env, (UnderlyingAST)ast, (boolean)false, (boolean)false);
        }
    });

    public static <T> TreePath findPathFromEnclosingNodeToTopLevel(TreePath path, Class<T> klass) {
        while (path != null && !klass.isInstance(path.getLeaf())) {
            path = path.getParentPath();
        }
        return path;
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> Result<A, S, T> methodDataflow(TreePath methodPath, Context context, T transfer) {
        Tree leaf = methodPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof MethodTree), (String)"Leaf of methodPath must be of type MethodTree, but was %s", (Object[])new Object[]{leaf.getClass().getName()});
        MethodTree method = (MethodTree)leaf;
        Preconditions.checkNotNull((Object)method.getBody(), (String)"Method to analyze must have a body. Method passed in: %s() in file %s", (Object[])new Object[]{method.getName(), methodPath.getCompilationUnit().getSourceFile().getName()});
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        final ControlFlowGraph cfg = (ControlFlowGraph)cfgCache.getUnchecked((Object)new CFGParams(methodPath, env));
        AnalysisParams aparams = new AnalysisParams(transfer, cfg, env);
        final Analysis analysis = (Analysis)analysisCache.getUnchecked((Object)aparams);
        return new Result<A, S, T>(){

            @Override
            public Analysis<A, S, T> getAnalysis() {
                return analysis;
            }

            @Override
            public ControlFlowGraph getControlFlowGraph() {
                return cfg;
            }
        };
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> A expressionDataflow(TreePath exprPath, Context context, T transfer) {
        Tree leaf = exprPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof ExpressionTree), (String)"Leaf of exprPath must be of type ExpressionTree, but was %s", (Object[])new Object[]{leaf.getClass().getName()});
        ExpressionTree expr = (ExpressionTree)leaf;
        TreePath enclosingMethodPath = DataFlow.findPathFromEnclosingNodeToTopLevel(exprPath, MethodTree.class);
        if (enclosingMethodPath == null) {
            return null;
        }
        MethodTree method = (MethodTree)enclosingMethodPath.getLeaf();
        if (method.getBody() == null) {
            return null;
        }
        return (A)DataFlow.methodDataflow(enclosingMethodPath, context, transfer).getAnalysis().getValue((Tree)expr);
    }

    private static final class AnalysisParams {
        private final ProcessingEnvironment env;
        private final ControlFlowGraph cfg;
        private final TransferFunction<?, ?> transfer;

        public AnalysisParams(TransferFunction<?, ?> trans, ControlFlowGraph cfg, ProcessingEnvironment env) {
            this.env = env;
            this.cfg = cfg;
            this.transfer = trans;
        }

        public ProcessingEnvironment getEnvironment() {
            return this.env;
        }

        public ControlFlowGraph getCFG() {
            return this.cfg;
        }

        public TransferFunction getTransferFunction() {
            return this.transfer;
        }

        public int hashCode() {
            return Objects.hash(this.cfg, this.transfer);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnalysisParams other = (AnalysisParams)obj;
            return Objects.equals(this.cfg, other.cfg) && Objects.equals(this.transfer, other.transfer);
        }
    }

    private static final class CFGParams {
        final ProcessingEnvironment env;
        final TreePath methodPath;

        public ProcessingEnvironment getEnvironment() {
            return this.env;
        }

        public TreePath getMethodPath() {
            return this.methodPath;
        }

        public CFGParams(TreePath methodPath, ProcessingEnvironment env) {
            this.env = env;
            this.methodPath = methodPath;
        }

        public int hashCode() {
            return Objects.hash(this.methodPath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CFGParams other = (CFGParams)obj;
            return Objects.equals(this.methodPath, other.methodPath);
        }
    }

    public static interface Result<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
        public Analysis<A, S, T> getAnalysis();

        public ControlFlowGraph getControlFlowGraph();
    }
}

