/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;

public class Constructor
implements Matcher<NewClassTree> {
    private final String className;
    private final java.util.List<String> parameterTypes;

    public Constructor(String className, java.util.List<String> parameterTypes) {
        this.className = className;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public boolean matches(NewClassTree newClassTree, VisitorState state) {
        try {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)newClassTree;
            String thisClassName = newClass.constructor.getEnclosingElement().toString();
            List<Type> thisParameterTypes = newClass.constructor.type.getParameterTypes();
            ArrayList<String> thisParameterTypesAsStrings = new ArrayList<String>(thisParameterTypes.length());
            for (Type t : thisParameterTypes) {
                thisParameterTypesAsStrings.add(t.toString());
            }
            return thisClassName.equals(this.className) && thisParameterTypesAsStrings.equals(this.parameterTypes);
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

