# System.IdentityModel.Claims

``` diff
+namespace System.IdentityModel.Claims {
+    public class Claim {
+        public Claim(string claimType, object resource, string right);
+        public string ClaimType { get; }
+        public static IEqualityComparer<Claim> DefaultComparer { get; }
+        public object Resource { get; }
+        public string Right { get; }
+        public static Claim System { get; }
+        public static Claim CreateDnsClaim(string dns);
+        public static Claim CreateHashClaim(byte[] hash);
+        public static Claim CreateNameClaim(string name);
+        public static Claim CreateSpnClaim(string spn);
+        public static Claim CreateThumbprintClaim(byte[] thumbprint);
+        public static Claim CreateUpnClaim(string upn);
+        public static Claim CreateUriClaim(Uri uri);
+        public static Claim CreateWindowsSidClaim(SecurityIdentifier sid);
+        public static Claim CreateX500DistinguishedNameClaim(X500DistinguishedName x500DistinguishedName);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public abstract class ClaimSet : IEnumerable, IEnumerable<Claim> {
+        protected ClaimSet();
+        public abstract int Count { get; }
+        public abstract ClaimSet Issuer { get; }
+        public static ClaimSet System { get; }
+        public abstract Claim this[int index] { get; }
+        public static ClaimSet Windows { get; }
+        public virtual bool ContainsClaim(Claim claim);
+        public virtual bool ContainsClaim(Claim claim, IEqualityComparer<Claim> comparer);
+        public abstract IEnumerable<Claim> FindClaims(string claimType, string right);
+        public abstract IEnumerator<Claim> GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public static class ClaimTypes {
+        public static string Anonymous { get; }
+        public static string Authentication { get; }
+        public static string AuthorizationDecision { get; }
+        public static string Country { get; }
+        public static string DateOfBirth { get; }
+        public static string DenyOnlySid { get; }
+        public static string Dns { get; }
+        public static string Email { get; }
+        public static string Gender { get; }
+        public static string GivenName { get; }
+        public static string Hash { get; }
+        public static string HomePhone { get; }
+        public static string Locality { get; }
+        public static string MobilePhone { get; }
+        public static string Name { get; }
+        public static string NameIdentifier { get; }
+        public static string OtherPhone { get; }
+        public static string PostalCode { get; }
+        public static string PPID { get; }
+        public static string Rsa { get; }
+        public static string Sid { get; }
+        public static string Spn { get; }
+        public static string StateOrProvince { get; }
+        public static string StreetAddress { get; }
+        public static string Surname { get; }
+        public static string System { get; }
+        public static string Thumbprint { get; }
+        public static string Upn { get; }
+        public static string Uri { get; }
+        public static string Webpage { get; }
+        public static string X500DistinguishedName { get; }
+    }
+    public class DefaultClaimSet : ClaimSet {
+        public DefaultClaimSet(IList<Claim> claims);
+        public DefaultClaimSet(params Claim[] claims);
+        public DefaultClaimSet(ClaimSet issuer, IList<Claim> claims);
+        public DefaultClaimSet(ClaimSet issuer, params Claim[] claims);
+        public override int Count { get; }
+        public override ClaimSet Issuer { get; }
+        public override Claim this[int index] { get; }
+        public override bool ContainsClaim(Claim claim);
+        public override IEnumerable<Claim> FindClaims(string claimType, string right);
+        public override IEnumerator<Claim> GetEnumerator();
+        protected void Initialize(ClaimSet issuer, IList<Claim> claims);
+        public override string ToString();
+    }
+    public static class Rights {
+        public static string Identity { get; }
+        public static string PossessProperty { get; }
+    }
+    public class WindowsClaimSet : ClaimSet, IDisposable, IIdentityInfo {
+        public WindowsClaimSet(WindowsIdentity windowsIdentity);
+        public WindowsClaimSet(WindowsIdentity windowsIdentity, bool includeWindowsGroups);
+        public WindowsClaimSet(WindowsIdentity windowsIdentity, bool includeWindowsGroups, DateTime expirationTime);
+        public WindowsClaimSet(WindowsIdentity windowsIdentity, DateTime expirationTime);
+        public WindowsClaimSet(WindowsIdentity windowsIdentity, string authenticationType, bool includeWindowsGroups, DateTime expirationTime);
+        public override int Count { get; }
+        public DateTime ExpirationTime { get; }
+        public override ClaimSet Issuer { get; }
+        public override Claim this[int index] { get; }
+        public WindowsIdentity WindowsIdentity { get; }
+        public void Dispose();
+        public override IEnumerable<Claim> FindClaims(string claimType, string right);
+        public override IEnumerator<Claim> GetEnumerator();
+        public override string ToString();
+        public static bool TryCreateWindowsSidClaim(WindowsIdentity windowsIdentity, out Claim claim);
+    }
+    public class X509CertificateClaimSet : ClaimSet, IDisposable, IIdentityInfo {
+        public X509CertificateClaimSet(X509Certificate2 certificate);
+        public override int Count { get; }
+        public DateTime ExpirationTime { get; }
+        public override ClaimSet Issuer { get; }
+        public override Claim this[int index] { get; }
+        public X509Certificate2 X509Certificate { get; }
+        public void Dispose();
+        public override IEnumerable<Claim> FindClaims(string claimType, string right);
+        public override IEnumerator<Claim> GetEnumerator();
+        public override string ToString();
+    }
+}
```

