# System.Net.NetworkInformation

``` diff
+namespace System.Net.NetworkInformation {
+    public enum DuplicateAddressDetectionState {
+        Deprecated = 3,
+        Duplicate = 2,
+        Invalid = 0,
+        Preferred = 4,
+        Tentative = 1,
+    }
+    public abstract class GatewayIPAddressInformation {
+        protected GatewayIPAddressInformation();
+        public abstract IPAddress Address { get; }
+    }
+    public class GatewayIPAddressInformationCollection : ICollection<GatewayIPAddressInformation>, IEnumerable, IEnumerable<GatewayIPAddressInformation> {
+        protected internal GatewayIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual GatewayIPAddressInformation this[int index] { get; }
+        public virtual void Add(GatewayIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(GatewayIPAddressInformation address);
+        public virtual void CopyTo(GatewayIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<GatewayIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(GatewayIPAddressInformation address);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public abstract class IcmpV4Statistics {
+        protected IcmpV4Statistics();
+        public abstract long AddressMaskRepliesReceived { get; }
+        public abstract long AddressMaskRepliesSent { get; }
+        public abstract long AddressMaskRequestsReceived { get; }
+        public abstract long AddressMaskRequestsSent { get; }
+        public abstract long DestinationUnreachableMessagesReceived { get; }
+        public abstract long DestinationUnreachableMessagesSent { get; }
+        public abstract long EchoRepliesReceived { get; }
+        public abstract long EchoRepliesSent { get; }
+        public abstract long EchoRequestsReceived { get; }
+        public abstract long EchoRequestsSent { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long ErrorsSent { get; }
+        public abstract long MessagesReceived { get; }
+        public abstract long MessagesSent { get; }
+        public abstract long ParameterProblemsReceived { get; }
+        public abstract long ParameterProblemsSent { get; }
+        public abstract long RedirectsReceived { get; }
+        public abstract long RedirectsSent { get; }
+        public abstract long SourceQuenchesReceived { get; }
+        public abstract long SourceQuenchesSent { get; }
+        public abstract long TimeExceededMessagesReceived { get; }
+        public abstract long TimeExceededMessagesSent { get; }
+        public abstract long TimestampRepliesReceived { get; }
+        public abstract long TimestampRepliesSent { get; }
+        public abstract long TimestampRequestsReceived { get; }
+        public abstract long TimestampRequestsSent { get; }
+    }
+    public abstract class IcmpV6Statistics {
+        protected IcmpV6Statistics();
+        public abstract long DestinationUnreachableMessagesReceived { get; }
+        public abstract long DestinationUnreachableMessagesSent { get; }
+        public abstract long EchoRepliesReceived { get; }
+        public abstract long EchoRepliesSent { get; }
+        public abstract long EchoRequestsReceived { get; }
+        public abstract long EchoRequestsSent { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long ErrorsSent { get; }
+        public abstract long MembershipQueriesReceived { get; }
+        public abstract long MembershipQueriesSent { get; }
+        public abstract long MembershipReductionsReceived { get; }
+        public abstract long MembershipReductionsSent { get; }
+        public abstract long MembershipReportsReceived { get; }
+        public abstract long MembershipReportsSent { get; }
+        public abstract long MessagesReceived { get; }
+        public abstract long MessagesSent { get; }
+        public abstract long NeighborAdvertisementsReceived { get; }
+        public abstract long NeighborAdvertisementsSent { get; }
+        public abstract long NeighborSolicitsReceived { get; }
+        public abstract long NeighborSolicitsSent { get; }
+        public abstract long PacketTooBigMessagesReceived { get; }
+        public abstract long PacketTooBigMessagesSent { get; }
+        public abstract long ParameterProblemsReceived { get; }
+        public abstract long ParameterProblemsSent { get; }
+        public abstract long RedirectsReceived { get; }
+        public abstract long RedirectsSent { get; }
+        public abstract long RouterAdvertisementsReceived { get; }
+        public abstract long RouterAdvertisementsSent { get; }
+        public abstract long RouterSolicitsReceived { get; }
+        public abstract long RouterSolicitsSent { get; }
+        public abstract long TimeExceededMessagesReceived { get; }
+        public abstract long TimeExceededMessagesSent { get; }
+    }
+    public class IPAddressCollection : ICollection<IPAddress>, IEnumerable, IEnumerable<IPAddress> {
+        protected internal IPAddressCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual IPAddress this[int index] { get; }
+        public virtual void Add(IPAddress address);
+        public virtual void Clear();
+        public virtual bool Contains(IPAddress address);
+        public virtual void CopyTo(IPAddress[] array, int offset);
+        public virtual IEnumerator<IPAddress> GetEnumerator();
+        public virtual bool Remove(IPAddress address);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public abstract class IPAddressInformation {
+        protected IPAddressInformation();
+        public abstract IPAddress Address { get; }
+        public abstract bool IsDnsEligible { get; }
+        public abstract bool IsTransient { get; }
+    }
+    public class IPAddressInformationCollection : ICollection<IPAddressInformation>, IEnumerable, IEnumerable<IPAddressInformation> {
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual IPAddressInformation this[int index] { get; }
+        public virtual void Add(IPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(IPAddressInformation address);
+        public virtual void CopyTo(IPAddressInformation[] array, int offset);
+        public virtual IEnumerator<IPAddressInformation> GetEnumerator();
+        public virtual bool Remove(IPAddressInformation address);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public abstract class IPGlobalProperties {
+        protected IPGlobalProperties();
+        public abstract string DhcpScopeName { get; }
+        public abstract string DomainName { get; }
+        public abstract string HostName { get; }
+        public abstract bool IsWinsProxy { get; }
+        public abstract NetBiosNodeType NodeType { get; }
+        public abstract TcpConnectionInformation[] GetActiveTcpConnections();
+        public abstract IPEndPoint[] GetActiveTcpListeners();
+        public abstract IPEndPoint[] GetActiveUdpListeners();
+        public abstract IcmpV4Statistics GetIcmpV4Statistics();
+        public abstract IcmpV6Statistics GetIcmpV6Statistics();
+        public static IPGlobalProperties GetIPGlobalProperties();
+        public abstract IPGlobalStatistics GetIPv4GlobalStatistics();
+        public abstract IPGlobalStatistics GetIPv6GlobalStatistics();
+        public abstract TcpStatistics GetTcpIPv4Statistics();
+        public abstract TcpStatistics GetTcpIPv6Statistics();
+        public abstract UdpStatistics GetUdpIPv4Statistics();
+        public abstract UdpStatistics GetUdpIPv6Statistics();
+        public virtual Task<UnicastIPAddressInformationCollection> GetUnicastAddressesAsync();
+    }
+    public abstract class IPGlobalStatistics {
+        protected IPGlobalStatistics();
+        public abstract int DefaultTtl { get; }
+        public abstract bool ForwardingEnabled { get; }
+        public abstract int NumberOfInterfaces { get; }
+        public abstract int NumberOfIPAddresses { get; }
+        public abstract int NumberOfRoutes { get; }
+        public abstract long OutputPacketRequests { get; }
+        public abstract long OutputPacketRoutingDiscards { get; }
+        public abstract long OutputPacketsDiscarded { get; }
+        public abstract long OutputPacketsWithNoRoute { get; }
+        public abstract long PacketFragmentFailures { get; }
+        public abstract long PacketReassembliesRequired { get; }
+        public abstract long PacketReassemblyFailures { get; }
+        public abstract long PacketReassemblyTimeout { get; }
+        public abstract long PacketsFragmented { get; }
+        public abstract long PacketsReassembled { get; }
+        public abstract long ReceivedPackets { get; }
+        public abstract long ReceivedPacketsDelivered { get; }
+        public abstract long ReceivedPacketsDiscarded { get; }
+        public abstract long ReceivedPacketsForwarded { get; }
+        public abstract long ReceivedPacketsWithAddressErrors { get; }
+        public abstract long ReceivedPacketsWithHeadersErrors { get; }
+        public abstract long ReceivedPacketsWithUnknownProtocol { get; }
+    }
+    public abstract class IPInterfaceProperties {
+        protected IPInterfaceProperties();
+        public abstract IPAddressInformationCollection AnycastAddresses { get; }
+        public abstract IPAddressCollection DhcpServerAddresses { get; }
+        public abstract IPAddressCollection DnsAddresses { get; }
+        public abstract string DnsSuffix { get; }
+        public abstract GatewayIPAddressInformationCollection GatewayAddresses { get; }
+        public abstract bool IsDnsEnabled { get; }
+        public abstract bool IsDynamicDnsEnabled { get; }
+        public abstract MulticastIPAddressInformationCollection MulticastAddresses { get; }
+        public abstract UnicastIPAddressInformationCollection UnicastAddresses { get; }
+        public abstract IPAddressCollection WinsServersAddresses { get; }
+        public abstract IPv4InterfaceProperties GetIPv4Properties();
+        public abstract IPv6InterfaceProperties GetIPv6Properties();
+    }
+    public abstract class IPInterfaceStatistics {
+        protected IPInterfaceStatistics();
+        public abstract long BytesReceived { get; }
+        public abstract long BytesSent { get; }
+        public abstract long IncomingPacketsDiscarded { get; }
+        public abstract long IncomingPacketsWithErrors { get; }
+        public abstract long IncomingUnknownProtocolPackets { get; }
+        public abstract long NonUnicastPacketsReceived { get; }
+        public abstract long NonUnicastPacketsSent { get; }
+        public abstract long OutgoingPacketsDiscarded { get; }
+        public abstract long OutgoingPacketsWithErrors { get; }
+        public abstract long OutputQueueLength { get; }
+        public abstract long UnicastPacketsReceived { get; }
+        public abstract long UnicastPacketsSent { get; }
+    }
+    public enum IPStatus {
+        BadDestination = 11018,
+        BadHeader = 11042,
+        BadOption = 11007,
+        BadRoute = 11012,
+        DestinationHostUnreachable = 11003,
+        DestinationNetworkUnreachable = 11002,
+        DestinationPortUnreachable = 11005,
+        DestinationProhibited = 11004,
+        DestinationProtocolUnreachable = 11004,
+        DestinationScopeMismatch = 11045,
+        DestinationUnreachable = 11040,
+        HardwareError = 11008,
+        IcmpError = 11044,
+        NoResources = 11006,
+        PacketTooBig = 11009,
+        ParameterProblem = 11015,
+        SourceQuench = 11016,
+        Success = 0,
+        TimedOut = 11010,
+        TimeExceeded = 11041,
+        TtlExpired = 11013,
+        TtlReassemblyTimeExceeded = 11014,
+        Unknown = -1,
+        UnrecognizedNextHeader = 11043,
+    }
+    public abstract class IPv4InterfaceProperties {
+        protected IPv4InterfaceProperties();
+        public abstract int Index { get; }
+        public abstract bool IsAutomaticPrivateAddressingActive { get; }
+        public abstract bool IsAutomaticPrivateAddressingEnabled { get; }
+        public abstract bool IsDhcpEnabled { get; }
+        public abstract bool IsForwardingEnabled { get; }
+        public abstract int Mtu { get; }
+        public abstract bool UsesWins { get; }
+    }
+    public abstract class IPv6InterfaceProperties {
+        protected IPv6InterfaceProperties();
+        public abstract int Index { get; }
+        public abstract int Mtu { get; }
+        public virtual long GetScopeId(ScopeLevel scopeLevel);
+    }
+    public abstract class MulticastIPAddressInformation : IPAddressInformation {
+        protected MulticastIPAddressInformation();
+        public abstract long AddressPreferredLifetime { get; }
+        public abstract long AddressValidLifetime { get; }
+        public abstract long DhcpLeaseLifetime { get; }
+        public abstract DuplicateAddressDetectionState DuplicateAddressDetectionState { get; }
+        public abstract PrefixOrigin PrefixOrigin { get; }
+        public abstract SuffixOrigin SuffixOrigin { get; }
+    }
+    public class MulticastIPAddressInformationCollection : ICollection<MulticastIPAddressInformation>, IEnumerable, IEnumerable<MulticastIPAddressInformation> {
+        protected internal MulticastIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual MulticastIPAddressInformation this[int index] { get; }
+        public virtual void Add(MulticastIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(MulticastIPAddressInformation address);
+        public virtual void CopyTo(MulticastIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<MulticastIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(MulticastIPAddressInformation address);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public enum NetBiosNodeType {
+        Broadcast = 1,
+        Hybrid = 8,
+        Mixed = 4,
+        Peer2Peer = 2,
+        Unknown = 0,
+    }
+    public delegate void NetworkAddressChangedEventHandler(object sender, EventArgs e);
+    public static class NetworkChange {
+        public static event NetworkAddressChangedEventHandler NetworkAddressChanged;
+    }
+    public class NetworkInformationException : Exception {
+        public NetworkInformationException();
+        public NetworkInformationException(int errorCode);
+        public int ErrorCode { get; }
+    }
+    public abstract class NetworkInterface {
+        protected NetworkInterface();
+        public virtual string Description { get; }
+        public virtual string Id { get; }
+        public static int IPv6LoopbackInterfaceIndex { get; }
+        public virtual bool IsReceiveOnly { get; }
+        public static int LoopbackInterfaceIndex { get; }
+        public virtual string Name { get; }
+        public virtual NetworkInterfaceType NetworkInterfaceType { get; }
+        public virtual OperationalStatus OperationalStatus { get; }
+        public virtual long Speed { get; }
+        public virtual bool SupportsMulticast { get; }
+        public static NetworkInterface[] GetAllNetworkInterfaces();
+        public virtual IPInterfaceProperties GetIPProperties();
+        public virtual IPInterfaceStatistics GetIPStatistics();
+        public static bool GetIsNetworkAvailable();
+        public virtual PhysicalAddress GetPhysicalAddress();
+        public virtual bool Supports(NetworkInterfaceComponent networkInterfaceComponent);
+    }
+    public enum NetworkInterfaceComponent {
+        IPv4 = 0,
+        IPv6 = 1,
+    }
+    public enum NetworkInterfaceType {
+        AsymmetricDsl = 94,
+        Atm = 37,
+        BasicIsdn = 20,
+        Ethernet = 6,
+        Ethernet3Megabit = 26,
+        FastEthernetFx = 69,
+        FastEthernetT = 62,
+        Fddi = 15,
+        GenericModem = 48,
+        GigabitEthernet = 117,
+        HighPerformanceSerialBus = 144,
+        IPOverAtm = 114,
+        Isdn = 63,
+        Loopback = 24,
+        MultiRateSymmetricDsl = 143,
+        Ppp = 23,
+        PrimaryIsdn = 21,
+        RateAdaptDsl = 95,
+        Slip = 28,
+        SymmetricDsl = 96,
+        TokenRing = 9,
+        Tunnel = 131,
+        Unknown = 1,
+        VeryHighSpeedDsl = 97,
+        Wireless80211 = 71,
+        Wman = 237,
+        Wwanpp = 243,
+        Wwanpp2 = 244,
+    }
+    public enum OperationalStatus {
+        Dormant = 5,
+        Down = 2,
+        LowerLayerDown = 7,
+        NotPresent = 6,
+        Testing = 3,
+        Unknown = 4,
+        Up = 1,
+    }
+    public class PhysicalAddress {
+        public static readonly PhysicalAddress None;
+        public PhysicalAddress(byte[] address);
+        public override bool Equals(object comparand);
+        public byte[] GetAddressBytes();
+        public override int GetHashCode();
+        public static PhysicalAddress Parse(string address);
+        public override string ToString();
+    }
+    public class Ping : IDisposable {
+        public Ping();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public Task<PingReply> SendPingAsync(IPAddress address);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout, byte[] buffer);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout, byte[] buffer, PingOptions options);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout, byte[] buffer);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout, byte[] buffer, PingOptions options);
+    }
+    public class PingException : InvalidOperationException {
+        public PingException(string message);
+        public PingException(string message, Exception innerException);
+    }
+    public class PingOptions {
+        public PingOptions();
+        public PingOptions(int ttl, bool dontFragment);
+        public bool DontFragment { get; set; }
+        public int Ttl { get; set; }
+    }
+    public class PingReply {
+        public IPAddress Address { get; }
+        public byte[] Buffer { get; }
+        public PingOptions Options { get; }
+        public long RoundtripTime { get; }
+        public IPStatus Status { get; }
+    }
+    public enum PrefixOrigin {
+        Dhcp = 3,
+        Manual = 1,
+        Other = 0,
+        RouterAdvertisement = 4,
+        WellKnown = 2,
+    }
+    public enum ScopeLevel {
+        Admin = 4,
+        Global = 14,
+        Interface = 1,
+        Link = 2,
+        None = 0,
+        Organization = 8,
+        Site = 5,
+        Subnet = 3,
+    }
+    public enum SuffixOrigin {
+        LinkLayerAddress = 4,
+        Manual = 1,
+        OriginDhcp = 3,
+        Other = 0,
+        Random = 5,
+        WellKnown = 2,
+    }
+    public abstract class TcpConnectionInformation {
+        protected TcpConnectionInformation();
+        public abstract IPEndPoint LocalEndPoint { get; }
+        public abstract IPEndPoint RemoteEndPoint { get; }
+        public abstract TcpState State { get; }
+    }
+    public enum TcpState {
+        Closed = 1,
+        CloseWait = 8,
+        Closing = 9,
+        DeleteTcb = 12,
+        Established = 5,
+        FinWait1 = 6,
+        FinWait2 = 7,
+        LastAck = 10,
+        Listen = 2,
+        SynReceived = 4,
+        SynSent = 3,
+        TimeWait = 11,
+        Unknown = 0,
+    }
+    public abstract class TcpStatistics {
+        protected TcpStatistics();
+        public abstract long ConnectionsAccepted { get; }
+        public abstract long ConnectionsInitiated { get; }
+        public abstract long CumulativeConnections { get; }
+        public abstract long CurrentConnections { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long FailedConnectionAttempts { get; }
+        public abstract long MaximumConnections { get; }
+        public abstract long MaximumTransmissionTimeout { get; }
+        public abstract long MinimumTransmissionTimeout { get; }
+        public abstract long ResetConnections { get; }
+        public abstract long ResetsSent { get; }
+        public abstract long SegmentsReceived { get; }
+        public abstract long SegmentsResent { get; }
+        public abstract long SegmentsSent { get; }
+    }
+    public abstract class UdpStatistics {
+        protected UdpStatistics();
+        public abstract long DatagramsReceived { get; }
+        public abstract long DatagramsSent { get; }
+        public abstract long IncomingDatagramsDiscarded { get; }
+        public abstract long IncomingDatagramsWithErrors { get; }
+        public abstract int UdpListeners { get; }
+    }
+    public abstract class UnicastIPAddressInformation : IPAddressInformation {
+        protected UnicastIPAddressInformation();
+        public abstract long AddressPreferredLifetime { get; }
+        public abstract long AddressValidLifetime { get; }
+        public abstract long DhcpLeaseLifetime { get; }
+        public abstract DuplicateAddressDetectionState DuplicateAddressDetectionState { get; }
+        public abstract IPAddress IPv4Mask { get; }
+        public virtual int PrefixLength { get; }
+        public abstract PrefixOrigin PrefixOrigin { get; }
+        public abstract SuffixOrigin SuffixOrigin { get; }
+    }
+    public class UnicastIPAddressInformationCollection : ICollection<UnicastIPAddressInformation>, IEnumerable, IEnumerable<UnicastIPAddressInformation> {
+        protected internal UnicastIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual UnicastIPAddressInformation this[int index] { get; }
+        public virtual void Add(UnicastIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(UnicastIPAddressInformation address);
+        public virtual void CopyTo(UnicastIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<UnicastIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(UnicastIPAddressInformation address);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+}
```

