# System.Runtime.InteropServices

``` diff
+namespace System.Runtime.InteropServices {
+    public sealed class AllowReversePInvokeCallsAttribute : Attribute {
+        public AllowReversePInvokeCallsAttribute();
+    }
+    public enum Architecture {
+        Arm = 2,
+        Arm64 = 3,
+        X64 = 1,
+        X86 = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ArrayWithOffset {
+        public ArrayWithOffset(object array, int offset);
+        public override bool Equals(object obj);
+        public bool Equals(ArrayWithOffset obj);
+        public object GetArray();
+        public override int GetHashCode();
+        public int GetOffset();
+        public static bool operator ==(ArrayWithOffset a, ArrayWithOffset b);
+        public static bool operator !=(ArrayWithOffset a, ArrayWithOffset b);
+    }
+    public sealed class BestFitMappingAttribute : Attribute {
+        public bool ThrowOnUnmappableChar;
+        public BestFitMappingAttribute(bool BestFitMapping);
+        public bool BestFitMapping { get; }
+    }
+    public sealed class BStrWrapper {
+        public BStrWrapper(object value);
+        public BStrWrapper(string value);
+        public string WrappedObject { get; }
+    }
+    public enum CallingConvention {
+        Cdecl = 2,
+        FastCall = 5,
+        StdCall = 3,
+        ThisCall = 4,
+        Winapi = 1,
+    }
+    public enum CharSet {
+        Ansi = 2,
+        Auto = 4,
+        None = 1,
+        Unicode = 3,
+    }
+    public sealed class ClassInterfaceAttribute : Attribute {
+        public ClassInterfaceAttribute(short classInterfaceType);
+        public ClassInterfaceAttribute(ClassInterfaceType classInterfaceType);
+        public ClassInterfaceType Value { get; }
+    }
+    public enum ClassInterfaceType {
+        AutoDispatch = 1,
+        AutoDual = 2,
+        None = 0,
+    }
+    public sealed class CoClassAttribute : Attribute {
+        public CoClassAttribute(Type coClass);
+        public Type CoClass { get; }
+    }
+    public class ComAwareEventInfo : EventInfo {
+        public ComAwareEventInfo(Type type, string eventName);
+        public override EventAttributes Attributes { get; }
+        public override Type DeclaringType { get; }
+        public override string Name { get; }
+        public override void AddEventHandler(object target, Delegate handler);
+        public override void RemoveEventHandler(object target, Delegate handler);
+    }
+    public sealed class ComDefaultInterfaceAttribute : Attribute {
+        public ComDefaultInterfaceAttribute(Type defaultInterface);
+        public Type Value { get; }
+    }
+    public sealed class ComEventInterfaceAttribute : Attribute {
+        public ComEventInterfaceAttribute(Type SourceInterface, Type EventProvider);
+        public Type EventProvider { get; }
+        public Type SourceInterface { get; }
+    }
+    public static class ComEventsHelper {
+        public static void Combine(object rcw, Guid iid, int dispid, Delegate d);
+        public static Delegate Remove(object rcw, Guid iid, int dispid, Delegate d);
+    }
+    public class COMException : Exception {
+        public COMException();
+        public COMException(string message);
+        public COMException(string message, Exception inner);
+        public COMException(string message, int errorCode);
+        public override string ToString();
+    }
+    public sealed class ComImportAttribute : Attribute {
+        public ComImportAttribute();
+    }
+    public enum ComInterfaceType {
+        InterfaceIsDual = 0,
+        InterfaceIsIDispatch = 2,
+        InterfaceIsIInspectable = 3,
+        InterfaceIsIUnknown = 1,
+    }
+    public enum ComMemberType {
+        Method = 0,
+        PropGet = 1,
+        PropSet = 2,
+    }
+    public sealed class ComSourceInterfacesAttribute : Attribute {
+        public ComSourceInterfacesAttribute(string sourceInterfaces);
+        public ComSourceInterfacesAttribute(Type sourceInterface);
+        public ComSourceInterfacesAttribute(Type sourceInterface1, Type sourceInterface2);
+        public ComSourceInterfacesAttribute(Type sourceInterface1, Type sourceInterface2, Type sourceInterface3);
+        public ComSourceInterfacesAttribute(Type sourceInterface1, Type sourceInterface2, Type sourceInterface3, Type sourceInterface4);
+        public string Value { get; }
+    }
+    public sealed class ComVisibleAttribute : Attribute {
+        public ComVisibleAttribute(bool visibility);
+        public bool Value { get; }
+    }
+    public abstract class CriticalHandle : IDisposable {
+        protected IntPtr handle;
+        protected CriticalHandle(IntPtr invalidHandleValue);
+        public bool IsClosed { get; }
+        public abstract bool IsInvalid { get; }
+        public void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~CriticalHandle();
+        protected abstract bool ReleaseHandle();
+        protected void SetHandle(IntPtr handle);
+        public void SetHandleAsInvalid();
+    }
+    public sealed class CurrencyWrapper {
+        public CurrencyWrapper(Decimal obj);
+        public CurrencyWrapper(object obj);
+        public Decimal WrappedObject { get; }
+    }
+    public enum CustomQueryInterfaceMode {
+        Allow = 1,
+        Ignore = 0,
+    }
+    public enum CustomQueryInterfaceResult {
+        Failed = 2,
+        Handled = 0,
+        NotHandled = 1,
+    }
+    public sealed class DefaultCharSetAttribute : Attribute {
+        public DefaultCharSetAttribute(CharSet charSet);
+        public CharSet CharSet { get; }
+    }
+    public sealed class DefaultDllImportSearchPathsAttribute : Attribute {
+        public DefaultDllImportSearchPathsAttribute(DllImportSearchPath paths);
+        public DllImportSearchPath Paths { get; }
+    }
+    public sealed class DefaultParameterValueAttribute : Attribute {
+        public DefaultParameterValueAttribute(object value);
+        public object Value { get; }
+    }
+    public sealed class DispatchWrapper {
+        public DispatchWrapper(object obj);
+        public object WrappedObject { get; }
+    }
+    public sealed class DispIdAttribute : Attribute {
+        public DispIdAttribute(int dispId);
+        public int Value { get; }
+    }
+    public sealed class DllImportAttribute : Attribute {
+        public bool BestFitMapping;
+        public bool ExactSpelling;
+        public bool PreserveSig;
+        public bool SetLastError;
+        public bool ThrowOnUnmappableChar;
+        public CallingConvention CallingConvention;
+        public CharSet CharSet;
+        public string EntryPoint;
+        public DllImportAttribute(string dllName);
+        public string Value { get; }
+    }
+    public enum DllImportSearchPath {
+        ApplicationDirectory = 512,
+        AssemblyDirectory = 2,
+        LegacyBehavior = 0,
+        SafeDirectories = 4096,
+        System32 = 2048,
+        UseDllDirectoryForDependencies = 256,
+        UserDirectories = 1024,
+    }
+    public sealed class ErrorWrapper {
+        public ErrorWrapper(Exception e);
+        public ErrorWrapper(int errorCode);
+        public ErrorWrapper(object errorCode);
+        public int ErrorCode { get; }
+    }
+    public class ExternalException : SystemException {
+        public ExternalException();
+        public ExternalException(string message);
+        public ExternalException(string message, Exception inner);
+        public virtual int ErrorCode { get; }
+    }
+    public sealed class FieldOffsetAttribute : Attribute {
+        public FieldOffsetAttribute(int offset);
+        public int Value { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GCHandle {
+        public bool IsAllocated { get; }
+        public object Target { get; set; }
+        public IntPtr AddrOfPinnedObject();
+        public static GCHandle Alloc(object value);
+        public static GCHandle Alloc(object value, GCHandleType type);
+        public override bool Equals(object o);
+        public void Free();
+        public static GCHandle FromIntPtr(IntPtr value);
+        public override int GetHashCode();
+        public static bool operator ==(GCHandle a, GCHandle b);
+        public static explicit operator GCHandle (IntPtr value);
+        public static explicit operator IntPtr (GCHandle value);
+        public static bool operator !=(GCHandle a, GCHandle b);
+        public static IntPtr ToIntPtr(GCHandle value);
+    }
+    public enum GCHandleType {
+        Normal = 2,
+        Pinned = 3,
+        Weak = 0,
+        WeakTrackResurrection = 1,
+    }
+    public sealed class GuidAttribute : Attribute {
+        public GuidAttribute(string guid);
+        public string Value { get; }
+    }
+    public sealed class HandleCollector {
+        public HandleCollector(string name, int initialThreshold);
+        public HandleCollector(string name, int initialThreshold, int maximumThreshold);
+        public int Count { get; }
+        public int InitialThreshold { get; }
+        public int MaximumThreshold { get; }
+        public string Name { get; }
+        public void Add();
+        public void Remove();
+    }
+    public interface ICustomAdapter {
+        object GetUnderlyingObject();
+    }
+    public interface ICustomQueryInterface {
+        CustomQueryInterfaceResult GetInterface(ref Guid iid, out IntPtr ppv);
+    }
+    public sealed class InAttribute : Attribute {
+        public InAttribute();
+    }
+    public sealed class InterfaceTypeAttribute : Attribute {
+        public InterfaceTypeAttribute(short interfaceType);
+        public InterfaceTypeAttribute(ComInterfaceType interfaceType);
+        public ComInterfaceType Value { get; }
+    }
+    public class InvalidComObjectException : Exception {
+        public InvalidComObjectException();
+        public InvalidComObjectException(string message);
+        public InvalidComObjectException(string message, Exception inner);
+    }
+    public class InvalidOleVariantTypeException : Exception {
+        public InvalidOleVariantTypeException();
+        public InvalidOleVariantTypeException(string message);
+        public InvalidOleVariantTypeException(string message, Exception inner);
+    }
+    public enum LayoutKind {
+        Auto = 3,
+        Explicit = 2,
+        Sequential = 0,
+    }
+    public static class Marshal {
+        public static readonly int SystemDefaultCharSize;
+        public static readonly int SystemMaxDBCSCharSize;
+        public static int AddRef(IntPtr pUnk);
+        public static IntPtr AllocCoTaskMem(int cb);
+        public static IntPtr AllocHGlobal(int cb);
+        public static IntPtr AllocHGlobal(IntPtr cb);
+        public static bool AreComObjectsAvailableForCleanup();
+        public static void Copy(byte[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(char[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(double[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(short[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(int[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(long[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(IntPtr source, byte[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, char[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, double[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, short[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, int[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, long[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, IntPtr[] destination, int startIndex, int length);
+        public static void Copy(IntPtr source, float[] destination, int startIndex, int length);
+        public static void Copy(IntPtr[] source, int startIndex, IntPtr destination, int length);
+        public static void Copy(float[] source, int startIndex, IntPtr destination, int length);
+        public static IntPtr CreateAggregatedObject(IntPtr pOuter, object o);
+        public static IntPtr CreateAggregatedObject<T>(IntPtr pOuter, T o);
+        public static object CreateWrapperOfType(object o, Type t);
+        public static TWrapper CreateWrapperOfType<T, TWrapper>(T o);
+        public static void DestroyStructure(IntPtr ptr, Type structuretype);
+        public static void DestroyStructure<T>(IntPtr ptr);
+        public static int FinalReleaseComObject(object o);
+        public static void FreeBSTR(IntPtr ptr);
+        public static void FreeCoTaskMem(IntPtr ptr);
+        public static void FreeHGlobal(IntPtr hglobal);
+        public static IntPtr GetComInterfaceForObject(object o, Type T);
+        public static IntPtr GetComInterfaceForObject(object o, Type T, CustomQueryInterfaceMode mode);
+        public static IntPtr GetComInterfaceForObject<T, TInterface>(T o);
+        public static Delegate GetDelegateForFunctionPointer(IntPtr ptr, Type t);
+        public static TDelegate GetDelegateForFunctionPointer<TDelegate>(IntPtr ptr);
+        public static int GetExceptionCode();
+        public static Exception GetExceptionForHR(int errorCode);
+        public static Exception GetExceptionForHR(int errorCode, IntPtr errorInfo);
+        public static IntPtr GetFunctionPointerForDelegate(Delegate d);
+        public static IntPtr GetFunctionPointerForDelegate<TDelegate>(TDelegate d);
+        public static int GetHRForException(Exception e);
+        public static int GetHRForLastWin32Error();
+        public static IntPtr GetIUnknownForObject(object o);
+        public static int GetLastWin32Error();
+        public static void GetNativeVariantForObject(object obj, IntPtr pDstNativeVariant);
+        public static void GetNativeVariantForObject<T>(T obj, IntPtr pDstNativeVariant);
+        public static object GetObjectForIUnknown(IntPtr pUnk);
+        public static object GetObjectForNativeVariant(IntPtr pSrcNativeVariant);
+        public static T GetObjectForNativeVariant<T>(IntPtr pSrcNativeVariant);
+        public static object[] GetObjectsForNativeVariants(IntPtr aSrcNativeVariant, int cVars);
+        public static T[] GetObjectsForNativeVariants<T>(IntPtr aSrcNativeVariant, int cVars);
+        public static int GetStartComSlot(Type t);
+        public static Type GetTypeFromCLSID(Guid clsid);
+        public static string GetTypeInfoName(ITypeInfo typeInfo);
+        public static object GetUniqueObjectForIUnknown(IntPtr unknown);
+        public static bool IsComObject(object o);
+        public static IntPtr OffsetOf(Type t, string fieldName);
+        public static IntPtr OffsetOf<T>(string fieldName);
+        public static void Prelink(MethodInfo m);
+        public static void PrelinkAll(Type c);
+        public static string PtrToStringAnsi(IntPtr ptr);
+        public static string PtrToStringAnsi(IntPtr ptr, int len);
+        public static string PtrToStringBSTR(IntPtr ptr);
+        public static string PtrToStringUni(IntPtr ptr);
+        public static string PtrToStringUni(IntPtr ptr, int len);
+        public static string PtrToStringUTF8(IntPtr ptr);
+        public static string PtrToStringUTF8(IntPtr ptr, int byteLen);
+        public static void PtrToStructure(IntPtr ptr, object structure);
+        public static object PtrToStructure(IntPtr ptr, Type structureType);
+        public static T PtrToStructure<T>(IntPtr ptr);
+        public static void PtrToStructure<T>(IntPtr ptr, T structure);
+        public static int QueryInterface(IntPtr pUnk, ref Guid iid, out IntPtr ppv);
+        public static byte ReadByte(IntPtr ptr);
+        public static byte ReadByte(IntPtr ptr, int ofs);
+        public static byte ReadByte(object ptr, int ofs);
+        public static short ReadInt16(IntPtr ptr);
+        public static short ReadInt16(IntPtr ptr, int ofs);
+        public static short ReadInt16(object ptr, int ofs);
+        public static int ReadInt32(IntPtr ptr);
+        public static int ReadInt32(IntPtr ptr, int ofs);
+        public static int ReadInt32(object ptr, int ofs);
+        public static long ReadInt64(IntPtr ptr);
+        public static long ReadInt64(IntPtr ptr, int ofs);
+        public static long ReadInt64(object ptr, int ofs);
+        public static IntPtr ReadIntPtr(IntPtr ptr);
+        public static IntPtr ReadIntPtr(IntPtr ptr, int ofs);
+        public static IntPtr ReadIntPtr(object ptr, int ofs);
+        public static IntPtr ReAllocCoTaskMem(IntPtr pv, int cb);
+        public static IntPtr ReAllocHGlobal(IntPtr pv, IntPtr cb);
+        public static int Release(IntPtr pUnk);
+        public static int ReleaseComObject(object o);
+        public static int SizeOf(object structure);
+        public static int SizeOf(Type t);
+        public static int SizeOf<T>();
+        public static int SizeOf<T>(T structure);
+        public static IntPtr StringToBSTR(string s);
+        public static IntPtr StringToCoTaskMemAnsi(string s);
+        public static IntPtr StringToCoTaskMemUni(string s);
+        public static IntPtr StringToCoTaskMemUTF8(string s);
+        public static IntPtr StringToHGlobalAnsi(string s);
+        public static IntPtr StringToHGlobalUni(string s);
+        public static void StructureToPtr(object structure, IntPtr ptr, bool fDeleteOld);
+        public static void StructureToPtr<T>(T structure, IntPtr ptr, bool fDeleteOld);
+        public static void ThrowExceptionForHR(int errorCode);
+        public static void ThrowExceptionForHR(int errorCode, IntPtr errorInfo);
+        public static IntPtr UnsafeAddrOfPinnedArrayElement(Array arr, int index);
+        public static IntPtr UnsafeAddrOfPinnedArrayElement<T>(T[] arr, int index);
+        public static void WriteByte(IntPtr ptr, byte val);
+        public static void WriteByte(IntPtr ptr, int ofs, byte val);
+        public static void WriteByte(object ptr, int ofs, byte val);
+        public static void WriteInt16(IntPtr ptr, char val);
+        public static void WriteInt16(IntPtr ptr, short val);
+        public static void WriteInt16(IntPtr ptr, int ofs, char val);
+        public static void WriteInt16(IntPtr ptr, int ofs, short val);
+        public static void WriteInt16(object ptr, int ofs, char val);
+        public static void WriteInt16(object ptr, int ofs, short val);
+        public static void WriteInt32(IntPtr ptr, int val);
+        public static void WriteInt32(IntPtr ptr, int ofs, int val);
+        public static void WriteInt32(object ptr, int ofs, int val);
+        public static void WriteInt64(IntPtr ptr, int ofs, long val);
+        public static void WriteInt64(IntPtr ptr, long val);
+        public static void WriteInt64(object ptr, int ofs, long val);
+        public static void WriteIntPtr(IntPtr ptr, int ofs, IntPtr val);
+        public static void WriteIntPtr(IntPtr ptr, IntPtr val);
+        public static void WriteIntPtr(object ptr, int ofs, IntPtr val);
+        public static void ZeroFreeBSTR(IntPtr s);
+        public static void ZeroFreeCoTaskMemAnsi(IntPtr s);
+        public static void ZeroFreeCoTaskMemUnicode(IntPtr s);
+        public static void ZeroFreeCoTaskMemUTF8(IntPtr s);
+        public static void ZeroFreeGlobalAllocAnsi(IntPtr s);
+        public static void ZeroFreeGlobalAllocUnicode(IntPtr s);
+    }
+    public sealed class MarshalAsAttribute : Attribute {
+        public short SizeParamIndex;
+        public int IidParameterIndex;
+        public int SizeConst;
+        public UnmanagedType ArraySubType;
+        public VarEnum SafeArraySubType;
+        public string MarshalCookie;
+        public string MarshalType;
+        public Type MarshalTypeRef;
+        public Type SafeArrayUserDefinedSubType;
+        public MarshalAsAttribute(short unmanagedType);
+        public MarshalAsAttribute(UnmanagedType unmanagedType);
+        public UnmanagedType Value { get; }
+    }
+    public class MarshalDirectiveException : Exception {
+        public MarshalDirectiveException();
+        public MarshalDirectiveException(string message);
+        public MarshalDirectiveException(string message, Exception inner);
+    }
+    public sealed class NativeCallableAttribute : Attribute {
+        public CallingConvention CallingConvention;
+        public string EntryPoint;
+        public NativeCallableAttribute();
+    }
+    public sealed class OptionalAttribute : Attribute {
+        public OptionalAttribute();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct OSPlatform : IEquatable<OSPlatform> {
+        public static OSPlatform Linux { get; }
+        public static OSPlatform OSX { get; }
+        public static OSPlatform Windows { get; }
+        public static OSPlatform Create(string osPlatform);
+        public override bool Equals(object obj);
+        public bool Equals(OSPlatform other);
+        public override int GetHashCode();
+        public static bool operator ==(OSPlatform left, OSPlatform right);
+        public static bool operator !=(OSPlatform left, OSPlatform right);
+        public override string ToString();
+    }
+    public sealed class OutAttribute : Attribute {
+        public OutAttribute();
+    }
+    public sealed class PreserveSigAttribute : Attribute {
+        public PreserveSigAttribute();
+    }
+    public static class RuntimeEnvironment {
+        public static string GetRuntimeDirectory();
+    }
+    public static class RuntimeInformation {
+        public static string FrameworkDescription { get; }
+        public static Architecture OSArchitecture { get; }
+        public static string OSDescription { get; }
+        public static Architecture ProcessArchitecture { get; }
+        public static bool IsOSPlatform(OSPlatform osPlatform);
+    }
+    public class SafeArrayRankMismatchException : Exception {
+        public SafeArrayRankMismatchException();
+        public SafeArrayRankMismatchException(string message);
+        public SafeArrayRankMismatchException(string message, Exception inner);
+    }
+    public class SafeArrayTypeMismatchException : Exception {
+        public SafeArrayTypeMismatchException();
+        public SafeArrayTypeMismatchException(string message);
+        public SafeArrayTypeMismatchException(string message, Exception inner);
+    }
+    public abstract class SafeBuffer : SafeHandle {
+        protected SafeBuffer(bool ownsHandle);
+        public ulong ByteLength { get; }
+        public override bool IsInvalid { get; }
+        public unsafe void AcquirePointer(ref byte* pointer);
+        public void Initialize(uint numElements, uint sizeOfEachElement);
+        public void Initialize(ulong numBytes);
+        public void Initialize<T>(uint numElements) where T : struct, ValueType;
+        public T Read<T>(ulong byteOffset) where T : struct, ValueType;
+        public void ReadArray<T>(ulong byteOffset, T[] array, int index, int count) where T : struct, ValueType;
+        public void ReleasePointer();
+        public void Write<T>(ulong byteOffset, T value) where T : struct, ValueType;
+        public void WriteArray<T>(ulong byteOffset, T[] array, int index, int count) where T : struct, ValueType;
+    }
+    public abstract class SafeHandle : IDisposable {
+        protected IntPtr handle;
+        protected SafeHandle();
+        protected SafeHandle(IntPtr invalidHandleValue, bool ownsHandle);
+        public bool IsClosed { get; }
+        public abstract bool IsInvalid { get; }
+        public void Close();
+        public void DangerousAddRef(ref bool success);
+        public IntPtr DangerousGetHandle();
+        public void DangerousRelease();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~SafeHandle();
+        protected abstract bool ReleaseHandle();
+        protected void SetHandle(IntPtr handle);
+        public void SetHandleAsInvalid();
+    }
+    public class SEHException : Exception {
+        public SEHException();
+        public SEHException(string message);
+        public SEHException(string message, Exception inner);
+        public virtual bool CanResume();
+    }
+    public sealed class StructLayoutAttribute : Attribute {
+        public int Pack;
+        public int Size;
+        public CharSet CharSet;
+        public StructLayoutAttribute(LayoutKind layoutKind);
+        public LayoutKind Value { get; }
+    }
+    public sealed class TypeIdentifierAttribute : Attribute {
+        public TypeIdentifierAttribute();
+        public TypeIdentifierAttribute(string scope, string identifier);
+        public string Identifier { get; }
+        public string Scope { get; }
+    }
+    public sealed class UnknownWrapper {
+        public UnknownWrapper(object obj);
+        public object WrappedObject { get; }
+    }
+    public sealed class UnmanagedFunctionPointerAttribute : Attribute {
+        public bool BestFitMapping;
+        public bool SetLastError;
+        public bool ThrowOnUnmappableChar;
+        public CharSet CharSet;
+        public UnmanagedFunctionPointerAttribute(CallingConvention callingConvention);
+        public CallingConvention CallingConvention { get; }
+    }
+    public enum UnmanagedType {
+        AnsiBStr = 35,
+        AsAny = 40,
+        Bool = 2,
+        BStr = 19,
+        ByValArray = 30,
+        ByValTStr = 23,
+        Currency = 15,
+        CustomMarshaler = 44,
+        Error = 45,
+        FunctionPtr = 38,
+        HString = 47,
+        I1 = 3,
+        I2 = 5,
+        I4 = 7,
+        I8 = 9,
+        IDispatch = 26,
+        IInspectable = 46,
+        Interface = 28,
+        IUnknown = 25,
+        LPArray = 42,
+        LPStr = 20,
+        LPStruct = 43,
+        LPTStr = 22,
+        LPUTF8Str = 48,
+        LPWStr = 21,
+        R4 = 11,
+        R8 = 12,
+        SafeArray = 29,
+        Struct = 27,
+        SysInt = 31,
+        SysUInt = 32,
+        TBStr = 36,
+        U1 = 4,
+        U2 = 6,
+        U4 = 8,
+        U8 = 10,
+        VariantBool = 37,
+        VBByRefStr = 34,
+    }
+    public enum VarEnum {
+        VT_ARRAY = 8192,
+        VT_BLOB = 65,
+        VT_BLOB_OBJECT = 70,
+        VT_BOOL = 11,
+        VT_BSTR = 8,
+        VT_BYREF = 16384,
+        VT_CARRAY = 28,
+        VT_CF = 71,
+        VT_CLSID = 72,
+        VT_CY = 6,
+        VT_DATE = 7,
+        VT_DECIMAL = 14,
+        VT_DISPATCH = 9,
+        VT_EMPTY = 0,
+        VT_ERROR = 10,
+        VT_FILETIME = 64,
+        VT_HRESULT = 25,
+        VT_I1 = 16,
+        VT_I2 = 2,
+        VT_I4 = 3,
+        VT_I8 = 20,
+        VT_INT = 22,
+        VT_LPSTR = 30,
+        VT_LPWSTR = 31,
+        VT_NULL = 1,
+        VT_PTR = 26,
+        VT_R4 = 4,
+        VT_R8 = 5,
+        VT_RECORD = 36,
+        VT_SAFEARRAY = 27,
+        VT_STORAGE = 67,
+        VT_STORED_OBJECT = 69,
+        VT_STREAM = 66,
+        VT_STREAMED_OBJECT = 68,
+        VT_UI1 = 17,
+        VT_UI2 = 18,
+        VT_UI4 = 19,
+        VT_UI8 = 21,
+        VT_UINT = 23,
+        VT_UNKNOWN = 13,
+        VT_USERDEFINED = 29,
+        VT_VARIANT = 12,
+        VT_VECTOR = 4096,
+        VT_VOID = 24,
+    }
+    public sealed class VariantWrapper {
+        public VariantWrapper(object obj);
+        public object WrappedObject { get; }
+    }
+}
```

