# System.ServiceModel.Channels

``` diff
+namespace System.ServiceModel.Channels {
+    public abstract class AddressHeader {
+        protected AddressHeader();
+        public abstract string Name { get; }
+        public abstract string Namespace { get; }
+        public static AddressHeader CreateAddressHeader(object value);
+        public static AddressHeader CreateAddressHeader(object value, XmlObjectSerializer serializer);
+        public static AddressHeader CreateAddressHeader(string name, string ns, object value);
+        public static AddressHeader CreateAddressHeader(string name, string ns, object value, XmlObjectSerializer serializer);
+        public override bool Equals(object obj);
+        public virtual XmlDictionaryReader GetAddressHeaderReader();
+        public override int GetHashCode();
+        public T GetValue<T>();
+        public T GetValue<T>(XmlObjectSerializer serializer);
+        protected abstract void OnWriteAddressHeaderContents(XmlDictionaryWriter writer);
+        protected virtual void OnWriteStartAddressHeader(XmlDictionaryWriter writer);
+        public MessageHeader ToMessageHeader();
+        public void WriteAddressHeader(XmlDictionaryWriter writer);
+        public void WriteAddressHeader(XmlWriter writer);
+        public void WriteAddressHeaderContents(XmlDictionaryWriter writer);
+        public void WriteStartAddressHeader(XmlDictionaryWriter writer);
+    }
+    public sealed class AddressHeaderCollection : ReadOnlyCollection<AddressHeader> {
+        public AddressHeaderCollection();
+        public AddressHeaderCollection(IEnumerable<AddressHeader> addressHeaders);
+        public void AddHeadersTo(Message message);
+        public AddressHeader[] FindAll(string name, string ns);
+        public AddressHeader FindHeader(string name, string ns);
+    }
+    public sealed class AddressingVersion {
+        public static AddressingVersion None { get; }
+        public static AddressingVersion WSAddressing10 { get; }
+        public override string ToString();
+    }
+    public sealed class ApplicationContainerSettings {
+        public const int CurrentSession = -1;
+        public const int ServiceSession = 0;
+        public string PackageFullName { get; set; }
+        public int SessionId { get; set; }
+    }
+    public static class ApplicationContainerSettingsDefaults {
+        public const int CurrentSession = -1;
+        public const int ServiceSession = 0;
+        public const string CurrentUserSessionDefaultString = "CurrentSession";
+        public const string PackageFullNameDefaultString = null;
+        public const string Session0ServiceSessionString = "ServiceSession";
+    }
+    public static class BasicHttpBindingDefaults {
+        public const BasicHttpMessageCredentialType MessageSecurityClientCredentialType = 0;
+        public const TransferMode TransferMode = 0;
+        public const WSMessageEncoding MessageEncoding = 0;
+        public static Encoding TextEncoding { get; }
+    }
+    public static class BinaryEncoderDefaults {
+        public const int MaxSessionSize = 2048;
+        public static BinaryVersion BinaryVersion { get; }
+        public static EnvelopeVersion EnvelopeVersion { get; }
+    }
+    public sealed class BinaryMessageEncodingBindingElement : MessageEncodingBindingElement {
+        public BinaryMessageEncodingBindingElement();
+        public CompressionFormat CompressionFormat { get; set; }
+        public int MaxReadPoolSize { get; set; }
+        public int MaxSessionSize { get; set; }
+        public int MaxWritePoolSize { get; set; }
+        public override MessageVersion MessageVersion { get; set; }
+        public XmlDictionaryReaderQuotas ReaderQuotas { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override MessageEncoderFactory CreateMessageEncoderFactory();
+        public override T GetProperty<T>(BindingContext context);
+        public bool ShouldSerializeMessageVersion();
+        public bool ShouldSerializeReaderQuotas();
+    }
+    public class BinaryVersion {
+        public static readonly BinaryVersion DeflateVersion1;
+        public static readonly BinaryVersion GZipVersion1;
+        public static readonly BinaryVersion Version1;
+        public string ContentType { get; }
+        public static BinaryVersion CurrentVersion { get; }
+        public IXmlDictionary Dictionary { get; }
+        public string SessionContentType { get; }
+    }
+    public abstract class Binding : IDefaultCommunicationTimeouts {
+        protected Binding();
+        protected Binding(string name, string ns);
+        public TimeSpan CloseTimeout { get; set; }
+        public MessageVersion MessageVersion { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public TimeSpan OpenTimeout { get; set; }
+        public TimeSpan ReceiveTimeout { get; set; }
+        public abstract string Scheme { get; }
+        public TimeSpan SendTimeout { get; set; }
+        public IChannelFactory<TChannel> BuildChannelFactory<TChannel>(params object[] parameters);
+        public virtual IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public bool CanBuildChannelFactory<TChannel>(params object[] parameters);
+        public virtual bool CanBuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public abstract BindingElementCollection CreateBindingElements();
+        public T GetProperty<T>(BindingParameterCollection parameters) where T : class;
+    }
+    public class BindingContext {
+        public BindingContext(CustomBinding binding, BindingParameterCollection parameters);
+        public CustomBinding Binding { get; }
+        public BindingParameterCollection BindingParameters { get; }
+        public Uri ListenUriBaseAddress { get; set; }
+        public ListenUriMode ListenUriMode { get; set; }
+        public string ListenUriRelativeAddress { get; set; }
+        public BindingElementCollection RemainingBindingElements { get; }
+        public IChannelFactory<TChannel> BuildInnerChannelFactory<TChannel>();
+        public bool CanBuildInnerChannelFactory<TChannel>();
+        public BindingContext Clone();
+        public T GetInnerProperty<T>() where T : class;
+    }
+    public abstract class BindingElement {
+        protected BindingElement();
+        protected BindingElement(BindingElement elementToBeCloned);
+        public virtual IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public virtual bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public abstract BindingElement Clone();
+        public abstract T GetProperty<T>(BindingContext context) where T : class;
+    }
+    public class BindingElementCollection : Collection<BindingElement> {
+        public BindingElementCollection();
+        public BindingElementCollection(IEnumerable<BindingElement> elements);
+        public BindingElementCollection(BindingElement[] elements);
+        public void AddRange(params BindingElement[] elements);
+        public BindingElementCollection Clone();
+        public bool Contains(Type bindingElementType);
+        public T Find<T>();
+        public Collection<T> FindAll<T>();
+        protected override void InsertItem(int index, BindingElement item);
+        public T Remove<T>();
+        public Collection<T> RemoveAll<T>();
+        protected override void SetItem(int index, BindingElement item);
+    }
+    public class BindingParameterCollection : KeyedCollection<Type, object> {
+        public BindingParameterCollection();
+        protected override Type GetKeyForItem(object item);
+        protected override void InsertItem(int index, object item);
+        protected override void SetItem(int index, object item);
+    }
+    public abstract class BodyWriter {
+        protected BodyWriter(bool isBuffered);
+        public bool IsBuffered { get; }
+        public IAsyncResult BeginWriteBodyContents(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        public BodyWriter CreateBufferedCopy(int maxBufferSize);
+        public void EndWriteBodyContents(IAsyncResult result);
+        protected virtual IAsyncResult OnBeginWriteBodyContents(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        protected virtual BodyWriter OnCreateBufferedCopy(int maxBufferSize);
+        protected virtual void OnEndWriteBodyContents(IAsyncResult result);
+        protected abstract void OnWriteBodyContents(XmlDictionaryWriter writer);
+        protected virtual Task OnWriteBodyContentsAsync(XmlDictionaryWriter writer);
+        public void WriteBodyContents(XmlDictionaryWriter writer);
+    }
+    public abstract class BufferManager {
+        protected BufferManager();
+        public abstract void Clear();
+        public static BufferManager CreateBufferManager(long maxBufferPoolSize, int maxBufferSize);
+        public abstract void ReturnBuffer(byte[] buffer);
+        public abstract byte[] TakeBuffer(int bufferSize);
+    }
+    public abstract class ChannelBase : CommunicationObject, IChannel, ICommunicationObject, IDefaultCommunicationTimeouts {
+        protected ChannelBase(ChannelManagerBase channelManager);
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        protected TimeSpan DefaultReceiveTimeout { get; }
+        protected TimeSpan DefaultSendTimeout { get; }
+        protected ChannelManagerBase Manager { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.CloseTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.OpenTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.ReceiveTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.SendTimeout { get; }
+        public virtual T GetProperty<T>() where T : class;
+        protected override void OnClosed();
+    }
+    public abstract class ChannelFactoryBase : ChannelManagerBase, IChannelFactory, ICommunicationObject {
+        protected ChannelFactoryBase();
+        protected ChannelFactoryBase(IDefaultCommunicationTimeouts timeouts);
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        protected override TimeSpan DefaultReceiveTimeout { get; }
+        protected override TimeSpan DefaultSendTimeout { get; }
+        public virtual T GetProperty<T>() where T : class;
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnEndClose(IAsyncResult result);
+    }
+    public abstract class ChannelFactoryBase<TChannel> : ChannelFactoryBase, IChannelFactory, IChannelFactory<TChannel>, ICommunicationObject {
+        protected ChannelFactoryBase();
+        protected ChannelFactoryBase(IDefaultCommunicationTimeouts timeouts);
+        public TChannel CreateChannel(EndpointAddress address);
+        public TChannel CreateChannel(EndpointAddress address, Uri via);
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected abstract TChannel OnCreateChannel(EndpointAddress address, Uri via);
+        protected override void OnEndClose(IAsyncResult result);
+        protected void ValidateCreateChannel();
+    }
+    public abstract class ChannelManagerBase : CommunicationObject, IDefaultCommunicationTimeouts {
+        protected ChannelManagerBase();
+        protected abstract TimeSpan DefaultReceiveTimeout { get; }
+        protected abstract TimeSpan DefaultSendTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.CloseTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.OpenTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.ReceiveTimeout { get; }
+        TimeSpan System.ServiceModel.IDefaultCommunicationTimeouts.SendTimeout { get; }
+    }
+    public class ChannelParameterCollection : Collection<object> {
+        public ChannelParameterCollection();
+        public ChannelParameterCollection(IChannel channel);
+        protected virtual IChannel Channel { get; }
+        protected override void ClearItems();
+        protected override void InsertItem(int index, object item);
+        public void PropagateChannelParameters(IChannel innerChannel);
+        protected override void RemoveItem(int index);
+        protected override void SetItem(int index, object item);
+    }
+    public abstract class ClientWebSocketFactory {
+        protected ClientWebSocketFactory();
+        public abstract Task<WebSocket> CreateWebSocketAsync(Uri address, WebHeaderCollection headers, ICredentials credentials, WebSocketTransportSettings settings, TimeoutHelper timeoutHelper);
+        public static ClientWebSocketFactory GetFactory();
+    }
+    public abstract class CommunicationObject : ICommunicationObject {
+        protected CommunicationObject();
+        protected CommunicationObject(object mutex);
+        protected abstract TimeSpan DefaultCloseTimeout { get; }
+        protected abstract TimeSpan DefaultOpenTimeout { get; }
+        protected bool IsDisposed { get; }
+        public CommunicationState State { get; }
+        protected object ThisLock { get; }
+        public event EventHandler Closed;
+        public event EventHandler Closing;
+        public event EventHandler Faulted;
+        public event EventHandler Opened;
+        public event EventHandler Opening;
+        public void Abort();
+        public IAsyncResult BeginClose(AsyncCallback callback, object state);
+        public IAsyncResult BeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        public IAsyncResult BeginOpen(AsyncCallback callback, object state);
+        public IAsyncResult BeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        public void Close();
+        public void Close(TimeSpan timeout);
+        public void EndClose(IAsyncResult result);
+        public void EndOpen(IAsyncResult result);
+        protected void Fault();
+        protected virtual Type GetCommunicationObjectType();
+        protected abstract void OnAbort();
+        protected abstract IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected abstract IAsyncResult OnBeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        protected abstract void OnClose(TimeSpan timeout);
+        protected internal virtual Task OnCloseAsync(TimeSpan timeout);
+        protected virtual void OnClosed();
+        protected virtual void OnClosing();
+        protected abstract void OnEndClose(IAsyncResult result);
+        protected abstract void OnEndOpen(IAsyncResult result);
+        protected virtual void OnFaulted();
+        protected abstract void OnOpen(TimeSpan timeout);
+        protected internal virtual Task OnOpenAsync(TimeSpan timeout);
+        protected virtual void OnOpened();
+        protected virtual void OnOpening();
+        public void Open();
+        public void Open(TimeSpan timeout);
+        Task System.ServiceModel.IAsyncCommunicationObject.CloseAsync(TimeSpan timeout);
+        Task System.ServiceModel.IAsyncCommunicationObject.OpenAsync(TimeSpan timeout);
+        protected internal void ThrowIfDisposed();
+        protected internal void ThrowIfDisposedOrImmutable();
+        protected internal void ThrowIfDisposedOrNotOpen();
+    }
+    public static class CommunicationObjectInternal {
+        public static TimeSpan GetInternalCloseTimeout(this CommunicationObject communicationObject);
+        public static IAsyncResult OnBeginClose(CommunicationObject communicationObject, TimeSpan timeout, AsyncCallback callback, object state);
+        public static IAsyncResult OnBeginOpen(CommunicationObject communicationObject, TimeSpan timeout, AsyncCallback callback, object state);
+        public static void OnClose(CommunicationObject communicationObject, TimeSpan timeout);
+        public static Task OnCloseAsyncInternal(CommunicationObject communicationObject, TimeSpan timeout);
+        public static void OnEnd(IAsyncResult result);
+        public static void OnOpen(CommunicationObject communicationObject, TimeSpan timeout);
+        public static Task OnOpenAsyncInternal(CommunicationObject communicationObject, TimeSpan timeout);
+        public static void ThrowIfClosed(CommunicationObject communicationObject);
+        public static void ThrowIfClosedOrOpened(CommunicationObject communicationObject);
+        public static void ThrowIfDisposed(CommunicationObject communicationObject);
+        public static void ThrowIfDisposedOrNotOpen(CommunicationObject communicationObject);
+    }
+    public abstract class CommunicationPool<TKey, TItem> where TKey : class where TItem : class {
+        protected CommunicationPool(int maxCount);
+        public int MaxIdleConnectionPoolCount { get; }
+        protected object ThisLock { get; }
+        protected abstract void AbortItem(TItem item);
+        public void AddConnection(TKey key, TItem connection, TimeSpan timeout);
+        public bool Close(TimeSpan timeout);
+        protected abstract void CloseItem(TItem item, TimeSpan timeout);
+        protected abstract void CloseItemAsync(TItem item, TimeSpan timeout);
+        protected virtual CommunicationPool<TKey, TItem>.EndpointConnectionPool CreateEndpointConnectionPool(TKey key);
+        protected abstract TKey GetPoolKey(EndpointAddress address, Uri via);
+        protected virtual void OnClosed();
+        public void ReturnConnection(TKey key, TItem connection, bool connectionIsStillGood, TimeSpan timeout);
+        public TItem TakeConnection(EndpointAddress address, Uri via, TimeSpan timeout, out TKey key);
+        public bool TryOpen();
+        protected class EndpointConnectionPool {
+            public EndpointConnectionPool(CommunicationPool<TKey, TItem> parent, TKey key);
+            protected TKey Key { get; }
+            protected CommunicationPool<TKey, TItem> Parent { get; }
+            protected object ThisLock { get; }
+            public void Abort();
+            protected virtual void AbortItem(TItem item);
+            public void AddConnection(TItem connection, TimeSpan timeout);
+            public void Close(TimeSpan timeout);
+            public void CloseIdleConnection(TItem connection, TimeSpan timeout);
+            public bool CloseIfEmpty();
+            protected virtual void CloseItem(TItem item, TimeSpan timeout);
+            protected virtual void CloseItemAsync(TItem item, TimeSpan timeout);
+            protected virtual CommunicationPool<TKey, TItem>.IdleConnectionPool GetIdleConnectionPool();
+            protected virtual void OnConnectionAborted();
+            public virtual void Prune(List<TItem> itemsToClose);
+            public void ReturnConnection(TItem connection, bool connectionIsStillGood, TimeSpan timeout);
+            public TItem TakeConnection(TimeSpan timeout);
+            protected class PoolIdleConnectionPool : CommunicationPool<TKey, TItem>.IdleConnectionPool {
+                public PoolIdleConnectionPool(int maxCount);
+                public override int Count { get; }
+                public override bool Add(TItem connection);
+                public override bool Return(TItem connection);
+                public override TItem Take(out bool closeItem);
+            }
+        }
+        protected abstract class IdleConnectionPool {
+            protected IdleConnectionPool();
+            public abstract int Count { get; }
+            public abstract bool Add(TItem item);
+            public abstract bool Return(TItem item);
+            public abstract TItem Take(out bool closeItem);
+        }
+    }
+    public enum CompressionFormat {
+        Deflate = 2,
+        GZip = 1,
+        None = 0,
+    }
+    public abstract class ConnectionOrientedTransportBindingElement : TransportBindingElement {
+        public int ConnectionBufferSize { get; set; }
+        public int MaxBufferSize { get; set; }
+        public TransferMode TransferMode { get; set; }
+        public override bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public static class ConnectionOrientedTransportDefaults {
+        public const bool AllowNtlm = true;
+        public const int ConnectionBufferSize = 8192;
+        public const int MaxContentTypeSize = 256;
+        public const int MaxOutboundConnectionsPerEndpoint = 10;
+        public const int MaxPendingAcceptsConst = 0;
+        public const int MaxPendingConnectionsConst = 0;
+        public const int MaxViaSize = 2048;
+        public const ProtectionLevel ProtectionLevel = 2;
+        public const HostNameComparisonMode HostNameComparisonMode = 0;
+        public const TransferMode TransferMode = 0;
+        public const string ChannelInitializationTimeoutString = "00:00:30";
+        public const string ConnectionPoolGroupName = "default";
+        public const string IdleTimeoutString = "00:02:00";
+        public const string MaxOutputDelayString = "00:00:00.2";
+        public static TimeSpan ChannelInitializationTimeout { get; }
+        public static TimeSpan IdleTimeout { get; }
+        public static TimeSpan MaxOutputDelay { get; }
+        public static int GetMaxConnections();
+        public static int GetMaxPendingAccepts();
+        public static int GetMaxPendingConnections();
+    }
+    public abstract class ConnectionPool : IdlingCommunicationPool<string, IConnection> {
+        protected ConnectionPool(IConnectionOrientedTransportChannelFactorySettings settings, TimeSpan leaseTimeout);
+        public string Name { get; }
+        protected override void AbortItem(IConnection item);
+        protected override void CloseItem(IConnection item, TimeSpan timeout);
+        protected override void CloseItemAsync(IConnection item, TimeSpan timeout);
+        public virtual bool IsCompatible(IConnectionOrientedTransportChannelFactorySettings settings);
+    }
+    public abstract class ConnectionPoolRegistry {
+        protected ConnectionPoolRegistry();
+        protected abstract ConnectionPool CreatePool(IConnectionOrientedTransportChannelFactorySettings settings);
+        public ConnectionPool Lookup(IConnectionOrientedTransportChannelFactorySettings settings);
+        public void Release(ConnectionPool pool, TimeSpan timeout);
+    }
+    public class CustomBinding : Binding {
+        public CustomBinding();
+        public CustomBinding(IEnumerable<BindingElement> bindingElementsInTopDownChannelStackOrder);
+        public CustomBinding(Binding binding);
+        public CustomBinding(params BindingElement[] bindingElementsInTopDownChannelStackOrder);
+        public CustomBinding(string name, string ns, params BindingElement[] bindingElementsInTopDownChannelStackOrder);
+        public BindingElementCollection Elements { get; }
+        public override string Scheme { get; }
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public abstract class DelegatingStream : Stream {
+        protected DelegatingStream(Stream stream);
+        protected Stream BaseStream { get; }
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override int ReadTimeout { get; set; }
+        public override int WriteTimeout { get; set; }
+        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public static class EncoderDefaults {
+        public const int BufferedReadDefaultMaxArrayLength = 2147483647;
+        public const int BufferedReadDefaultMaxBytesPerRead = 2147483647;
+        public const int BufferedReadDefaultMaxDepth = 128;
+        public const int BufferedReadDefaultMaxNameTableCharCount = 2147483647;
+        public const int BufferedReadDefaultMaxStringContentLength = 2147483647;
+        public const int MaxArrayLength = 16384;
+        public const int MaxBytesPerRead = 4096;
+        public const int MaxDepth = 32;
+        public const int MaxNameTableCharCount = 16384;
+        public const int MaxReadPoolSize = 64;
+        public const int MaxStringContentLength = 8192;
+        public const int MaxWritePoolSize = 16;
+        public const CompressionFormat DefaultCompressionFormat = 0;
+        public static readonly XmlDictionaryReaderQuotas ReaderQuotas;
+        public static bool IsDefaultReaderQuotas(XmlDictionaryReaderQuotas quotas);
+    }
+    public abstract class FaultConverter {
+        protected FaultConverter();
+        public static FaultConverter GetDefaultFaultConverter(MessageVersion version);
+        protected abstract bool OnTryCreateException(Message message, MessageFault fault, out Exception exception);
+        protected abstract bool OnTryCreateFaultMessage(Exception exception, out Message message);
+        public bool TryCreateException(Message message, MessageFault fault, out Exception exception);
+        public bool TryCreateFaultMessage(Exception exception, out Message message);
+    }
+    public class HttpMessageHandlerFactory {
+        [MethodImpl(NoInlining)]protected HttpMessageHandlerFactory();
+        [MethodImpl(NoInlining)]public HttpMessageHandlerFactory(Func<IEnumerable<DelegatingHandler>> handlers);
+        [MethodImpl(NoInlining)]public HttpMessageHandlerFactory(params Type[] handlers);
+        [MethodImpl(NoInlining)]public HttpMessageHandler Create(HttpMessageHandler innerChannel);
+        protected virtual HttpMessageHandler OnCreate(HttpMessageHandler innerChannel);
+    }
+    public static class HttpRequestMessageExtensionMethods {
+        public static bool CreateContentIfNull(this HttpRequestMessage httpRequestMessage);
+    }
+    public sealed class HttpRequestMessageProperty : IMessageProperty {
+        public HttpRequestMessageProperty();
+        public WebHeaderCollection Headers { get; }
+        public HttpRequestMessage HttpRequestMessage { get; }
+        public string Method { get; set; }
+        public static string Name { get; }
+        public string QueryString { get; set; }
+        public bool SuppressEntityBody { get; set; }
+        IMessageProperty System.ServiceModel.Channels.IMessageProperty.CreateCopy();
+    }
+    public sealed class HttpResponseMessageProperty : IMessageProperty {
+        public HttpResponseMessageProperty();
+        public WebHeaderCollection Headers { get; }
+        public HttpResponseMessage HttpResponseMessage { get; }
+        public static string Name { get; }
+        public HttpStatusCode StatusCode { get; set; }
+        public string StatusDescription { get; set; }
+        public bool SuppressEntityBody { get; set; }
+        public bool SuppressPreamble { get; set; }
+        IMessageProperty System.ServiceModel.Channels.IMessageProperty.CreateCopy();
+    }
+    public class HttpsTransportBindingElement : HttpTransportBindingElement {
+        public HttpsTransportBindingElement();
+        protected HttpsTransportBindingElement(HttpsTransportBindingElement elementToBeCloned);
+        public bool RequireClientCertificate { get; set; }
+        public override string Scheme { get; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public class HttpTransportBindingElement : TransportBindingElement {
+        public HttpTransportBindingElement();
+        protected HttpTransportBindingElement(HttpTransportBindingElement elementToBeCloned);
+        public bool AllowCookies { get; set; }
+        public AuthenticationSchemes AuthenticationScheme { get; set; }
+        public bool DecompressionEnabled { get; set; }
+        public ExtendedProtectionPolicy ExtendedProtectionPolicy { get; set; }
+        public HostNameComparisonMode HostNameComparisonMode { get; set; }
+        public bool KeepAliveEnabled { get; set; }
+        public int MaxBufferSize { get; set; }
+        public int MaxPendingAccepts { get; set; }
+        public HttpMessageHandlerFactory MessageHandlerFactory { get; set; }
+        public string Realm { get; set; }
+        public TimeSpan RequestInitializationTimeout { get; set; }
+        public override string Scheme { get; }
+        public TransferMode TransferMode { get; set; }
+        public bool UnsafeConnectionNtlmAuthentication { get; set; }
+        public bool UseDefaultWebProxy { get; }
+        public WebSocketTransportSettings WebSocketSettings { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public static class HttpTransportDefaults {
+        public const bool AllowCookies = false;
+        public const bool DecompressionEnabled = true;
+        public const bool KeepAliveEnabled = true;
+        public const bool UnsafeConnectionNtlmAuthentication = false;
+        public const bool UseDefaultWebProxy = true;
+        public const int DefaultMaxPendingAccepts = 0;
+        public const int MaxPendingAcceptsUpperLimit = 100000;
+        public const AuthenticationSchemes AuthenticationScheme = 32768;
+        public const HttpMessageHandlerFactory MessageHandlerFactory = null;
+        public const HostNameComparisonMode HostNameComparisonMode = 0;
+        public const TransferMode TransferMode = 0;
+        public const string ConnectionHeader = "Connection";
+        public const string Realm = "";
+        public const string RequestInitializationTimeoutString = "00:00:00";
+        public const string UpgradeHeader = "Upgrade";
+        public static TimeSpan RequestInitializationTimeout { get; }
+        public static MessageEncoderFactory GetDefaultMessageEncoderFactory();
+        public static WebSocketTransportSettings GetDefaultWebSocketTransportSettings();
+        public static int GetEffectiveMaxPendingAccepts(int maxPendingAccepts);
+    }
+    public interface IAsyncChannelFactory : IAsyncCommunicationObject, IChannelFactory, ICommunicationObject
+    public interface IAsyncRequest : IRequestBase {
+        Task<Message> ReceiveReplyAsync(TimeoutHelper timeoutHelper);
+        Task SendRequestAsync(Message message, TimeoutHelper timeoutHelper);
+    }
+    public interface IBindingDeliveryCapabilities {
+        bool AssuresOrderedDelivery { get; }
+        bool QueuedDelivery { get; }
+    }
+    public interface IBindingMulticastCapabilities {
+        bool IsMulticast { get; }
+    }
+    public interface IBindingRuntimePreferences {
+        bool ReceiveSynchronously { get; }
+    }
+    public interface IChannel : ICommunicationObject {
+        T GetProperty<T>() where T : class;
+    }
+    public interface IChannelFactory : ICommunicationObject {
+        T GetProperty<T>() where T : class;
+    }
+    public interface IChannelFactory<TChannel> : IChannelFactory, ICommunicationObject {
+        TChannel CreateChannel(EndpointAddress to);
+        TChannel CreateChannel(EndpointAddress to, Uri via);
+    }
+    public interface IChannelListener : ICommunicationObject {
+        Uri Uri { get; }
+        IAsyncResult BeginWaitForChannel(TimeSpan timeout, AsyncCallback callback, object state);
+        bool EndWaitForChannel(IAsyncResult result);
+        T GetProperty<T>() where T : class;
+        bool WaitForChannel(TimeSpan timeout);
+    }
+    public interface IChannelListener<TChannel> : IChannelListener, ICommunicationObject where TChannel : class, IChannel {
+        TChannel AcceptChannel();
+        TChannel AcceptChannel(TimeSpan timeout);
+        IAsyncResult BeginAcceptChannel(AsyncCallback callback, object state);
+        IAsyncResult BeginAcceptChannel(TimeSpan timeout, AsyncCallback callback, object state);
+        TChannel EndAcceptChannel(IAsyncResult result);
+    }
+    public interface IConnection {
+        byte[] AsyncReadBuffer { get; }
+        int AsyncReadBufferSize { get; }
+        void Abort();
+        AsyncCompletionResult BeginRead(int offset, int size, TimeSpan timeout, Action<object> callback, object state);
+        AsyncCompletionResult BeginWrite(byte[] buffer, int offset, int size, bool immediate, TimeSpan timeout, Action<object> callback, object state);
+        void Close(TimeSpan timeout, bool asyncAndLinger);
+        int EndRead();
+        void EndWrite();
+        object GetCoreTransport();
+        int Read(byte[] buffer, int offset, int size, TimeSpan timeout);
+        void Write(byte[] buffer, int offset, int size, bool immediate, TimeSpan timeout);
+        void Write(byte[] buffer, int offset, int size, bool immediate, TimeSpan timeout, BufferManager bufferManager);
+    }
+    public interface IConnectionInitiator {
+        IConnection Connect(Uri uri, TimeSpan timeout);
+        Task<IConnection> ConnectAsync(Uri uri, TimeSpan timeout);
+    }
+    public interface IConnectionOrientedConnectionSettings {
+        int ConnectionBufferSize { get; }
+        TimeSpan IdleTimeout { get; }
+        TimeSpan MaxOutputDelay { get; }
+    }
+    public interface IConnectionOrientedTransportChannelFactorySettings : IConnectionOrientedConnectionSettings, IConnectionOrientedTransportFactorySettings, IDefaultCommunicationTimeouts, ITransportFactorySettings {
+        string ConnectionPoolGroupName { get; }
+        int MaxOutboundConnectionsPerEndpoint { get; }
+    }
+    public interface IConnectionOrientedTransportFactorySettings : IConnectionOrientedConnectionSettings, IDefaultCommunicationTimeouts, ITransportFactorySettings {
+        int MaxBufferSize { get; }
+        TransferMode TransferMode { get; }
+        StreamUpgradeProvider Upgrade { get; }
+    }
+    public abstract class IdlingCommunicationPool<TKey, TItem> : CommunicationPool<TKey, TItem> where TKey : class where TItem : class {
+        protected IdlingCommunicationPool(int maxCount, TimeSpan idleTimeout, TimeSpan leaseTimeout);
+        public TimeSpan IdleTimeout { get; }
+        protected TimeSpan LeaseTimeout { get; }
+        protected override void CloseItemAsync(TItem item, TimeSpan timeout);
+        protected override CommunicationPool<TKey, TItem>.EndpointConnectionPool CreateEndpointConnectionPool(TKey key);
+        protected class IdleTimeoutEndpointConnectionPool : CommunicationPool<TKey, TItem>.EndpointConnectionPool {
+            public IdleTimeoutEndpointConnectionPool(IdlingCommunicationPool<TKey, TItem> parent, TKey key);
+            protected override void AbortItem(TItem item);
+            protected override void CloseItem(TItem item, TimeSpan timeout);
+            protected override void CloseItemAsync(TItem item, TimeSpan timeout);
+            protected override CommunicationPool<TKey, TItem>.IdleConnectionPool GetIdleConnectionPool();
+            public override void Prune(List<TItem> itemsToClose);
+            protected class IdleTimeoutIdleConnectionPool : CommunicationPool<TKey, TItem>.EndpointConnectionPool.PoolIdleConnectionPool {
+                public IdleTimeoutIdleConnectionPool(IdlingCommunicationPool<TKey, TItem>.IdleTimeoutEndpointConnectionPool parent, object thisLock);
+                public override bool Add(TItem connection);
+                public void OnItemClosing(TItem connection);
+                public void Prune(List<TItem> itemsToClose, bool calledFromTimer);
+                public override bool Return(TItem connection);
+                public override TItem Take(out bool closeItem);
+            }
+        }
+    }
+    public interface IDuplexChannel : IChannel, ICommunicationObject, IInputChannel, IOutputChannel
+    public interface IDuplexSession : IInputSession, IOutputSession, ISession {
+        IAsyncResult BeginCloseOutputSession(AsyncCallback callback, object state);
+        IAsyncResult BeginCloseOutputSession(TimeSpan timeout, AsyncCallback callback, object state);
+        void CloseOutputSession();
+        void CloseOutputSession(TimeSpan timeout);
+        void EndCloseOutputSession(IAsyncResult result);
+    }
+    public interface IDuplexSessionChannel : IChannel, ICommunicationObject, IDuplexChannel, IInputChannel, IOutputChannel, ISessionChannel<IDuplexSession>
+    public interface IHttpCookieContainerManager {
+        CookieContainer CookieContainer { get; set; }
+    }
+    public interface IInputChannel : IChannel, ICommunicationObject {
+        EndpointAddress LocalAddress { get; }
+        IAsyncResult BeginReceive(AsyncCallback callback, object state);
+        IAsyncResult BeginReceive(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult BeginTryReceive(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult BeginWaitForMessage(TimeSpan timeout, AsyncCallback callback, object state);
+        Message EndReceive(IAsyncResult result);
+        bool EndTryReceive(IAsyncResult result, out Message message);
+        bool EndWaitForMessage(IAsyncResult result);
+        Message Receive();
+        Message Receive(TimeSpan timeout);
+        bool TryReceive(TimeSpan timeout, out Message message);
+        bool WaitForMessage(TimeSpan timeout);
+    }
+    public interface IInputSession : ISession
+    public interface IInputSessionChannel : IChannel, ICommunicationObject, IInputChannel, ISessionChannel<IInputSession>
+    public interface IMessageProperty {
+        IMessageProperty CreateCopy();
+    }
+    public interface IMessageSource {
+        Message Receive(TimeSpan timeout);
+        Task<Message> ReceiveAsync(TimeSpan timeout);
+        bool WaitForMessage(TimeSpan timeout);
+        Task<bool> WaitForMessageAsync(TimeSpan timeout);
+    }
+    public interface IOutputChannel : IChannel, ICommunicationObject {
+        EndpointAddress RemoteAddress { get; }
+        Uri Via { get; }
+        IAsyncResult BeginSend(Message message, AsyncCallback callback, object state);
+        IAsyncResult BeginSend(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        void EndSend(IAsyncResult result);
+        void Send(Message message);
+        void Send(Message message, TimeSpan timeout);
+    }
+    public interface IOutputSession : ISession
+    public interface IOutputSessionChannel : IChannel, ICommunicationObject, IOutputChannel, ISessionChannel<IOutputSession>
+    public interface IReceiveContextSettings {
+        bool Enabled { get; set; }
+        TimeSpan ValidityDuration { get; }
+    }
+    public interface IReplyChannel : IChannel, ICommunicationObject {
+        EndpointAddress LocalAddress { get; }
+        IAsyncResult BeginReceiveRequest(AsyncCallback callback, object state);
+        IAsyncResult BeginReceiveRequest(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult BeginTryReceiveRequest(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult BeginWaitForRequest(TimeSpan timeout, AsyncCallback callback, object state);
+        RequestContext EndReceiveRequest(IAsyncResult result);
+        bool EndTryReceiveRequest(IAsyncResult result, out RequestContext context);
+        bool EndWaitForRequest(IAsyncResult result);
+        RequestContext ReceiveRequest();
+        RequestContext ReceiveRequest(TimeSpan timeout);
+        bool TryReceiveRequest(TimeSpan timeout, out RequestContext context);
+        bool WaitForRequest(TimeSpan timeout);
+    }
+    public interface IReplySessionChannel : IChannel, ICommunicationObject, IReplyChannel, ISessionChannel<IInputSession>
+    public interface IRequestBase {
+        void Abort(RequestChannel requestChannel);
+        void Fault(RequestChannel requestChannel);
+        void OnReleaseRequest();
+    }
+    public interface IRequestChannel : IChannel, ICommunicationObject {
+        EndpointAddress RemoteAddress { get; }
+        Uri Via { get; }
+        IAsyncResult BeginRequest(Message message, AsyncCallback callback, object state);
+        IAsyncResult BeginRequest(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        Message EndRequest(IAsyncResult result);
+        Message Request(Message message);
+        Message Request(Message message, TimeSpan timeout);
+    }
+    public interface IRequestSessionChannel : IChannel, ICommunicationObject, IRequestChannel, ISessionChannel<IOutputSession>
+    public interface ISecurityCapabilities {
+        ProtectionLevel SupportedRequestProtectionLevel { get; }
+        ProtectionLevel SupportedResponseProtectionLevel { get; }
+        bool SupportsClientAuthentication { get; }
+        bool SupportsClientWindowsIdentity { get; }
+        bool SupportsServerAuthentication { get; }
+    }
+    public interface ISession {
+        string Id { get; }
+    }
+    public interface ISessionChannel<TSession> where TSession : ISession {
+        TSession Session { get; }
+    }
+    public interface ITcpChannelFactorySettings : IConnectionOrientedConnectionSettings, IConnectionOrientedTransportChannelFactorySettings, IConnectionOrientedTransportFactorySettings, IDefaultCommunicationTimeouts, ITransportFactorySettings {
+        TimeSpan LeaseTimeout { get; }
+    }
+    public interface ITransportCompressionSupport {
+        bool IsCompressionFormatSupported(CompressionFormat compressionFormat);
+    }
+    public interface ITransportFactorySettings : IDefaultCommunicationTimeouts {
+        BufferManager BufferManager { get; }
+        bool ManualAddressing { get; }
+        long MaxReceivedMessageSize { get; }
+        MessageEncoderFactory MessageEncoderFactory { get; }
+        MessageVersion MessageVersion { get; }
+    }
+    public sealed class LocalClientSecuritySettings {
+        public LocalClientSecuritySettings();
+        public bool CacheCookies { get; set; }
+        public int CookieRenewalThresholdPercentage { get; set; }
+        public bool DetectReplays { get; set; }
+        public IdentityVerifier IdentityVerifier { get; set; }
+        public TimeSpan MaxClockSkew { get; set; }
+        public TimeSpan MaxCookieCachingTime { get; set; }
+        public NonceCache NonceCache { get; set; }
+        public bool ReconnectTransportOnFailure { get; set; }
+        public int ReplayCacheSize { get; set; }
+        public TimeSpan ReplayWindow { get; set; }
+        public TimeSpan SessionKeyRenewalInterval { get; set; }
+        public TimeSpan SessionKeyRolloverInterval { get; set; }
+        public TimeSpan TimestampValidityDuration { get; set; }
+        public LocalClientSecuritySettings Clone();
+    }
+    public class MaxMessageSizeStream : DelegatingStream {
+        public MaxMessageSizeStream(Stream stream, long maxMessageSize);
+        public static Exception CreateMaxReceivedMessageSizeExceededException(long maxMessageSize);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public abstract class Message : IDisposable {
+        protected Message();
+        public abstract MessageHeaders Headers { get; }
+        protected bool IsDisposed { get; }
+        public virtual bool IsEmpty { get; }
+        public virtual bool IsFault { get; }
+        public abstract MessageProperties Properties { get; }
+        public MessageState State { get; }
+        public abstract MessageVersion Version { get; }
+        public IAsyncResult BeginWriteBodyContents(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        public IAsyncResult BeginWriteMessage(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        public void Close();
+        public MessageBuffer CreateBufferedCopy(int maxBufferSize);
+        public static Message CreateMessage(MessageVersion version, MessageFault fault, string action);
+        public static Message CreateMessage(MessageVersion version, FaultCode faultCode, string reason, object detail, string action);
+        public static Message CreateMessage(MessageVersion version, FaultCode faultCode, string reason, string action);
+        public static Message CreateMessage(MessageVersion version, string action);
+        public static Message CreateMessage(MessageVersion version, string action, object body);
+        public static Message CreateMessage(MessageVersion version, string action, object body, XmlObjectSerializer serializer);
+        public static Message CreateMessage(MessageVersion version, string action, BodyWriter body);
+        public static Message CreateMessage(MessageVersion version, string action, XmlDictionaryReader body);
+        public static Message CreateMessage(MessageVersion version, string action, XmlReader body);
+        public static Message CreateMessage(XmlDictionaryReader envelopeReader, int maxSizeOfHeaders, MessageVersion version);
+        public static Message CreateMessage(XmlReader envelopeReader, int maxSizeOfHeaders, MessageVersion version);
+        public void EndWriteBodyContents(IAsyncResult result);
+        public void EndWriteMessage(IAsyncResult result);
+        public T GetBody<T>();
+        public T GetBody<T>(XmlObjectSerializer serializer);
+        public string GetBodyAttribute(string localName, string ns);
+        public XmlDictionaryReader GetReaderAtBodyContents();
+        protected virtual IAsyncResult OnBeginWriteBodyContents(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        protected virtual IAsyncResult OnBeginWriteMessage(XmlDictionaryWriter writer, AsyncCallback callback, object state);
+        protected virtual void OnBodyToString(XmlDictionaryWriter writer);
+        protected virtual void OnClose();
+        protected virtual MessageBuffer OnCreateBufferedCopy(int maxBufferSize);
+        protected virtual void OnEndWriteBodyContents(IAsyncResult result);
+        protected virtual void OnEndWriteMessage(IAsyncResult result);
+        protected virtual T OnGetBody<T>(XmlDictionaryReader reader);
+        protected virtual string OnGetBodyAttribute(string localName, string ns);
+        protected virtual XmlDictionaryReader OnGetReaderAtBodyContents();
+        protected abstract void OnWriteBodyContents(XmlDictionaryWriter writer);
+        protected virtual Task OnWriteBodyContentsAsync(XmlDictionaryWriter writer);
+        protected virtual void OnWriteMessage(XmlDictionaryWriter writer);
+        public virtual Task OnWriteMessageAsync(XmlDictionaryWriter writer);
+        protected virtual void OnWriteStartBody(XmlDictionaryWriter writer);
+        protected virtual void OnWriteStartEnvelope(XmlDictionaryWriter writer);
+        protected virtual void OnWriteStartHeaders(XmlDictionaryWriter writer);
+        void System.IDisposable.Dispose();
+        public override string ToString();
+        public void WriteBody(XmlDictionaryWriter writer);
+        public void WriteBody(XmlWriter writer);
+        public void WriteBodyContents(XmlDictionaryWriter writer);
+        public Task WriteBodyContentsAsync(XmlDictionaryWriter writer);
+        public void WriteMessage(XmlDictionaryWriter writer);
+        public void WriteMessage(XmlWriter writer);
+        public virtual Task WriteMessageAsync(XmlDictionaryWriter writer);
+        public virtual Task WriteMessageAsync(XmlWriter writer);
+        public void WriteStartBody(XmlDictionaryWriter writer);
+        public void WriteStartBody(XmlWriter writer);
+        public void WriteStartEnvelope(XmlDictionaryWriter writer);
+    }
+    public abstract class MessageBuffer : IDisposable {
+        protected MessageBuffer();
+        public abstract int BufferSize { get; }
+        public virtual string MessageContentType { get; }
+        public abstract void Close();
+        public abstract Message CreateMessage();
+        void System.IDisposable.Dispose();
+        public virtual void WriteMessage(Stream stream);
+    }
+    public abstract class MessageEncoder {
+        protected MessageEncoder();
+        public abstract string ContentType { get; }
+        public abstract string MediaType { get; }
+        public abstract MessageVersion MessageVersion { get; }
+        public virtual IAsyncResult BeginWriteMessage(Message message, Stream stream, AsyncCallback callback, object state);
+        public virtual void EndWriteMessage(IAsyncResult result);
+        public virtual T GetProperty<T>() where T : class;
+        public virtual bool IsContentTypeSupported(string contentType);
+        public Message ReadMessage(ArraySegment<byte> buffer, BufferManager bufferManager);
+        public abstract Message ReadMessage(ArraySegment<byte> buffer, BufferManager bufferManager, string contentType);
+        public Message ReadMessage(Stream stream, int maxSizeOfHeaders);
+        public abstract Message ReadMessage(Stream stream, int maxSizeOfHeaders, string contentType);
+        public virtual Task<Message> ReadMessageAsync(ArraySegment<byte> buffer, BufferManager bufferManager, string contentType);
+        public virtual Task<Message> ReadMessageAsync(Stream stream, int maxSizeOfHeaders, string contentType);
+        public override string ToString();
+        public ArraySegment<byte> WriteMessage(Message message, int maxMessageSize, BufferManager bufferManager);
+        public abstract ArraySegment<byte> WriteMessage(Message message, int maxMessageSize, BufferManager bufferManager, int messageOffset);
+        public abstract void WriteMessage(Message message, Stream stream);
+        public virtual Task<ArraySegment<byte>> WriteMessageAsync(Message message, int maxMessageSize, BufferManager bufferManager, int messageOffset);
+        public virtual Task WriteMessageAsync(Message message, Stream stream);
+    }
+    public abstract class MessageEncoderFactory {
+        protected MessageEncoderFactory();
+        public abstract MessageEncoder Encoder { get; }
+        public abstract MessageVersion MessageVersion { get; }
+        public virtual MessageEncoder CreateSessionEncoder();
+    }
+    public abstract class MessageEncodingBindingElement : BindingElement {
+        protected MessageEncodingBindingElement();
+        protected MessageEncodingBindingElement(MessageEncodingBindingElement elementToBeCloned);
+        public abstract MessageVersion MessageVersion { get; set; }
+        public abstract MessageEncoderFactory CreateMessageEncoderFactory();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public abstract class MessageFault {
+        protected MessageFault();
+        public virtual string Actor { get; }
+        public abstract FaultCode Code { get; }
+        public abstract bool HasDetail { get; }
+        public bool IsMustUnderstandFault { get; }
+        public virtual string Node { get; }
+        public abstract FaultReason Reason { get; }
+        public static MessageFault CreateFault(Message message, int maxBufferSize);
+        public static MessageFault CreateFault(FaultCode code, FaultReason reason);
+        public static MessageFault CreateFault(FaultCode code, FaultReason reason, object detail);
+        public static MessageFault CreateFault(FaultCode code, FaultReason reason, object detail, XmlObjectSerializer serializer);
+        public static MessageFault CreateFault(FaultCode code, FaultReason reason, object detail, XmlObjectSerializer serializer, string actor);
+        public static MessageFault CreateFault(FaultCode code, FaultReason reason, object detail, XmlObjectSerializer serializer, string actor, string node);
+        public static MessageFault CreateFault(FaultCode code, string reason);
+        public T GetDetail<T>();
+        public T GetDetail<T>(XmlObjectSerializer serializer);
+        public XmlDictionaryReader GetReaderAtDetailContents();
+        protected virtual XmlDictionaryReader OnGetReaderAtDetailContents();
+        protected virtual void OnWriteDetail(XmlDictionaryWriter writer, EnvelopeVersion version);
+        protected abstract void OnWriteDetailContents(XmlDictionaryWriter writer);
+        protected virtual void OnWriteStartDetail(XmlDictionaryWriter writer, EnvelopeVersion version);
+        public static bool WasHeaderNotUnderstood(MessageHeaders headers, string name, string ns);
+        public void WriteTo(XmlDictionaryWriter writer, EnvelopeVersion version);
+        public void WriteTo(XmlWriter writer, EnvelopeVersion version);
+    }
+    public abstract class MessageHeader : MessageHeaderInfo {
+        protected MessageHeader();
+        public override string Actor { get; }
+        public override bool IsReferenceParameter { get; }
+        public override bool MustUnderstand { get; }
+        public override bool Relay { get; }
+        public static MessageHeader CreateHeader(string name, string ns, object value);
+        public static MessageHeader CreateHeader(string name, string ns, object value, bool mustUnderstand);
+        public static MessageHeader CreateHeader(string name, string ns, object value, bool mustUnderstand, string actor);
+        public static MessageHeader CreateHeader(string name, string ns, object value, bool mustUnderstand, string actor, bool relay);
+        public static MessageHeader CreateHeader(string name, string ns, object value, XmlObjectSerializer serializer);
+        public static MessageHeader CreateHeader(string name, string ns, object value, XmlObjectSerializer serializer, bool mustUnderstand);
+        public static MessageHeader CreateHeader(string name, string ns, object value, XmlObjectSerializer serializer, bool mustUnderstand, string actor);
+        public static MessageHeader CreateHeader(string name, string ns, object value, XmlObjectSerializer serializer, bool mustUnderstand, string actor, bool relay);
+        public virtual bool IsMessageVersionSupported(MessageVersion messageVersion);
+        protected abstract void OnWriteHeaderContents(XmlDictionaryWriter writer, MessageVersion messageVersion);
+        protected virtual void OnWriteStartHeader(XmlDictionaryWriter writer, MessageVersion messageVersion);
+        public override string ToString();
+        public void WriteHeader(XmlDictionaryWriter writer, MessageVersion messageVersion);
+        public void WriteHeader(XmlWriter writer, MessageVersion messageVersion);
+        protected void WriteHeaderAttributes(XmlDictionaryWriter writer, MessageVersion messageVersion);
+        public void WriteHeaderContents(XmlDictionaryWriter writer, MessageVersion messageVersion);
+        public void WriteStartHeader(XmlDictionaryWriter writer, MessageVersion messageVersion);
+    }
+    public abstract class MessageHeaderInfo {
+        protected MessageHeaderInfo();
+        public abstract string Actor { get; }
+        public abstract bool IsReferenceParameter { get; }
+        public abstract bool MustUnderstand { get; }
+        public abstract string Name { get; }
+        public abstract string Namespace { get; }
+        public abstract bool Relay { get; }
+    }
+    public sealed class MessageHeaders : IEnumerable, IEnumerable<MessageHeaderInfo> {
+        public MessageHeaders(MessageHeaders collection);
+        public MessageHeaders(MessageVersion version);
+        public MessageHeaders(MessageVersion version, int initialSize);
+        public string Action { get; set; }
+        public int Count { get; }
+        public EndpointAddress FaultTo { get; set; }
+        public EndpointAddress From { get; set; }
+        public UniqueId MessageId { get; set; }
+        public MessageVersion MessageVersion { get; }
+        public UniqueId RelatesTo { get; set; }
+        public EndpointAddress ReplyTo { get; set; }
+        public MessageHeaderInfo this[int index] { get; }
+        public Uri To { get; set; }
+        public UnderstoodHeaders UnderstoodHeaders { get; }
+        public void Add(MessageHeader header);
+        public void Clear();
+        public void CopyHeaderFrom(Message message, int headerIndex);
+        public void CopyHeaderFrom(MessageHeaders collection, int headerIndex);
+        public void CopyHeadersFrom(Message message);
+        public void CopyHeadersFrom(MessageHeaders collection);
+        public void CopyTo(MessageHeaderInfo[] array, int index);
+        public int FindHeader(string name, string ns);
+        public int FindHeader(string name, string ns, params string[] actors);
+        public IEnumerator<MessageHeaderInfo> GetEnumerator();
+        public T GetHeader<T>(int index);
+        public T GetHeader<T>(int index, XmlObjectSerializer serializer);
+        public T GetHeader<T>(string name, string ns);
+        public T GetHeader<T>(string name, string ns, XmlObjectSerializer serializer);
+        public T GetHeader<T>(string name, string ns, params string[] actors);
+        public XmlDictionaryReader GetReaderAtHeader(int headerIndex);
+        public bool HaveMandatoryHeadersBeenUnderstood();
+        public bool HaveMandatoryHeadersBeenUnderstood(params string[] actors);
+        public void Insert(int headerIndex, MessageHeader header);
+        public void RemoveAll(string name, string ns);
+        public void RemoveAt(int headerIndex);
+        public void SetAction(XmlDictionaryString action);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public void WriteHeader(int headerIndex, XmlDictionaryWriter writer);
+        public void WriteHeader(int headerIndex, XmlWriter writer);
+        public void WriteHeaderContents(int headerIndex, XmlDictionaryWriter writer);
+        public void WriteHeaderContents(int headerIndex, XmlWriter writer);
+        public void WriteStartHeader(int headerIndex, XmlDictionaryWriter writer);
+        public void WriteStartHeader(int headerIndex, XmlWriter writer);
+    }
+    public sealed class MessageProperties : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IDisposable, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public MessageProperties();
+        public MessageProperties(MessageProperties properties);
+        public bool AllowOutputBatching { get; set; }
+        public int Count { get; }
+        public MessageEncoder Encoder { get; set; }
+        public bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public ICollection<string> Keys { get; }
+        public SecurityMessageProperty Security { get; set; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.IsReadOnly { get; }
+        public object this[string name] { get; set; }
+        public ICollection<object> Values { get; }
+        public Uri Via { get; set; }
+        public void Add(string name, object property);
+        public void Clear();
+        public bool ContainsKey(string name);
+        public void CopyProperties(MessageProperties properties);
+        public void Dispose();
+        public bool Remove(string name);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Add(KeyValuePair<string, object> pair);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Contains(KeyValuePair<string, object> pair);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.CopyTo(KeyValuePair<string, object>[] array, int index);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Remove(KeyValuePair<string, object> pair);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue(string name, out object value);
+    }
+    public enum MessageState {
+        Closed = 4,
+        Copied = 3,
+        Created = 0,
+        Read = 1,
+        Written = 2,
+    }
+    public sealed class MessageVersion {
+        public AddressingVersion Addressing { get; }
+        public static MessageVersion Default { get; }
+        public EnvelopeVersion Envelope { get; }
+        public static MessageVersion None { get; }
+        public static MessageVersion Soap11 { get; }
+        public static MessageVersion Soap11WSAddressing10 { get; }
+        public static MessageVersion Soap12 { get; }
+        public static MessageVersion Soap12WSAddressing10 { get; }
+        public static MessageVersion CreateVersion(EnvelopeVersion envelopeVersion);
+        public static MessageVersion CreateVersion(EnvelopeVersion envelopeVersion, AddressingVersion addressingVersion);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public sealed class NamedPipeSettings {
+        public ApplicationContainerSettings ApplicationContainerSettings { get; private set; }
+    }
+    public static class NetHttpBindingDefaults {
+        public const WebSocketTransportUsage TransportUsage = 0;
+        public const NetHttpMessageEncoding MessageEncoding = 0;
+    }
+    public static class NetTcpDefaults {
+        public const MessageCredentialType MessageSecurityClientCredentialType = 1;
+    }
+    public static class OneWayDefaults {
+        public const bool PacketRoutable = false;
+        public const int MaxAcceptedChannels = 10;
+        public const int MaxOutboundChannelsPerEndpoint = 10;
+        public const string IdleTimeoutString = "00:02:00";
+        public const string LeaseTimeoutString = "00:10:00";
+        public static TimeSpan IdleTimeout { get; }
+        public static TimeSpan LeaseTimeout { get; }
+    }
+    public abstract class OutputChannel : ChannelBase, IChannel, ICommunicationObject, IOutputChannel {
+        protected OutputChannel(ChannelManagerBase manager);
+        public abstract EndpointAddress RemoteAddress { get; }
+        public abstract Uri Via { get; }
+        protected virtual void AddHeadersTo(Message message);
+        public IAsyncResult BeginSend(Message message, AsyncCallback callback, object state);
+        public IAsyncResult BeginSend(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        public void EndSend(IAsyncResult result);
+        public override T GetProperty<T>();
+        protected abstract void OnSend(Message message, TimeSpan timeout);
+        protected abstract Task OnSendAsync(Message message, TimeSpan timeout);
+        public void Send(Message message);
+        public void Send(Message message, TimeSpan timeout);
+    }
+    public abstract class RequestChannel : ChannelBase, IAsyncCommunicationObject, IAsyncRequestChannel, IChannel, ICommunicationObject, IRequestChannel {
+        protected RequestChannel(ChannelManagerBase channelFactory, EndpointAddress to, Uri via, bool manualAddressing);
+        protected bool ManualAddressing { get; }
+        public EndpointAddress RemoteAddress { get; }
+        public Uri Via { get; }
+        protected void AbortPendingRequests();
+        protected virtual void AddHeadersTo(Message message);
+        public IAsyncResult BeginRequest(Message message, AsyncCallback callback, object state);
+        public IAsyncResult BeginRequest(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        protected IAsyncResult BeginWaitForPendingRequests(TimeSpan timeout, AsyncCallback callback, object state);
+        protected abstract IAsyncRequest CreateAsyncRequest(Message message);
+        public Message EndRequest(IAsyncResult result);
+        protected void EndWaitForPendingRequests(IAsyncResult result);
+        protected void FaultPendingRequests();
+        public override T GetProperty<T>();
+        protected override void OnAbort();
+        public Message Request(Message message);
+        public Message Request(Message message, TimeSpan timeout);
+        public Task<Message> RequestAsync(Message message);
+        public Task<Message> RequestAsync(Message message, TimeSpan timeout);
+        protected void WaitForPendingRequests(TimeSpan timeout);
+        protected internal Task WaitForPendingRequestsAsync(TimeSpan timeout);
+    }
+    public abstract class RequestContext : IDisposable {
+        protected RequestContext();
+        public abstract Message RequestMessage { get; }
+        public abstract void Abort();
+        public abstract IAsyncResult BeginReply(Message message, AsyncCallback callback, object state);
+        public abstract IAsyncResult BeginReply(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        public abstract void Close();
+        public abstract void Close(TimeSpan timeout);
+        protected virtual void Dispose(bool disposing);
+        public abstract void EndReply(IAsyncResult result);
+        public abstract void Reply(Message message);
+        public abstract void Reply(Message message, TimeSpan timeout);
+        void System.IDisposable.Dispose();
+    }
+    public abstract class SecurityBindingElement : BindingElement {
+        public SupportingTokenParameters EndpointSupportingTokenParameters { get; }
+        public bool IncludeTimestamp { get; set; }
+        public LocalClientSecuritySettings LocalClientSettings { get; }
+        public MessageSecurityVersion MessageSecurityVersion { get; set; }
+        public SecurityHeaderLayout SecurityHeaderLayout { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        protected abstract IChannelFactory<TChannel> BuildChannelFactoryCore<TChannel>(BindingContext context);
+        public override bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public static TransportSecurityBindingElement CreateCertificateOverTransportBindingElement(MessageSecurityVersion version);
+        public static SecurityBindingElement CreateMutualCertificateBindingElement();
+        public static SecurityBindingElement CreateMutualCertificateBindingElement(MessageSecurityVersion version);
+        public static SecurityBindingElement CreateMutualCertificateBindingElement(MessageSecurityVersion version, bool allowSerializedSigningTokenOnReply);
+        public static SecurityBindingElement CreateSecureConversationBindingElement(SecurityBindingElement bootstrapSecurity);
+        public static TransportSecurityBindingElement CreateUserNameOverTransportBindingElement();
+        public override T GetProperty<T>(BindingContext context);
+        protected static void SetIssuerBindingContextIfRequired(SecurityTokenParameters parameters, BindingContext issuerBindingContext);
+        public virtual void SetKeyDerivation(bool requireDerivedKeys);
+        public override string ToString();
+    }
+    public class SecurityCapabilities : ISecurityCapabilities {
+        public SecurityCapabilities(bool supportsClientAuth, bool supportsServerAuth, bool supportsClientWindowsIdentity, ProtectionLevel requestProtectionLevel, ProtectionLevel responseProtectionLevel);
+        public static SecurityCapabilities None { get; }
+        public ProtectionLevel SupportedRequestProtectionLevel { get; }
+        public ProtectionLevel SupportedResponseProtectionLevel { get; }
+        public bool SupportsClientAuthentication { get; }
+        public bool SupportsClientWindowsIdentity { get; }
+        public bool SupportsServerAuthentication { get; }
+        public static bool IsEqual(ISecurityCapabilities capabilities1, ISecurityCapabilities capabilities2);
+    }
+    public enum SecurityHeaderLayout {
+        Lax = 1,
+        LaxTimestampFirst = 2,
+        LaxTimestampLast = 3,
+        Strict = 0,
+    }
+    public class ServiceChannelProxy : DispatchProxy, IChannel, IClientChannel, ICommunicationObject, IContextChannel, IDisposable, IDuplexContextChannel, IExtensibleObject<IContextChannel>, IOutputChannel, IRequestChannel, IServiceChannel {
+        public ServiceChannelProxy();
+        public bool AutomaticInputSessionShutdown { get; set; }
+        public InstanceContext CallbackInstance { get; set; }
+        EndpointAddress System.ServiceModel.Channels.IOutputChannel.RemoteAddress { get; }
+        Uri System.ServiceModel.Channels.IOutputChannel.Via { get; }
+        EndpointAddress System.ServiceModel.Channels.IRequestChannel.RemoteAddress { get; }
+        Uri System.ServiceModel.Channels.IRequestChannel.Via { get; }
+        bool System.ServiceModel.IClientChannel.AllowInitializationUI { get; set; }
+        bool System.ServiceModel.IClientChannel.DidInteractiveInitialization { get; }
+        Uri System.ServiceModel.IClientChannel.Via { get; }
+        CommunicationState System.ServiceModel.ICommunicationObject.State { get; }
+        bool System.ServiceModel.IContextChannel.AllowOutputBatching { get; set; }
+        IInputSession System.ServiceModel.IContextChannel.InputSession { get; }
+        EndpointAddress System.ServiceModel.IContextChannel.LocalAddress { get; }
+        TimeSpan System.ServiceModel.IContextChannel.OperationTimeout { get; set; }
+        IOutputSession System.ServiceModel.IContextChannel.OutputSession { get; }
+        EndpointAddress System.ServiceModel.IContextChannel.RemoteAddress { get; }
+        string System.ServiceModel.IContextChannel.SessionId { get; }
+        IExtensionCollection<IContextChannel> System.ServiceModel.IExtensibleObject<System.ServiceModel.IContextChannel>.Extensions { get; }
+        Uri System.ServiceModel.IServiceChannel.ListenUri { get; }
+        event EventHandler<UnknownMessageReceivedEventArgs> System.ServiceModel.IClientChannel.UnknownMessageReceived;
+        event EventHandler System.ServiceModel.ICommunicationObject.Closed;
+        event EventHandler System.ServiceModel.ICommunicationObject.Closing;
+        event EventHandler System.ServiceModel.ICommunicationObject.Faulted;
+        event EventHandler System.ServiceModel.ICommunicationObject.Opened;
+        event EventHandler System.ServiceModel.ICommunicationObject.Opening;
+        public IAsyncResult BeginCloseOutputSession(TimeSpan timeout, AsyncCallback callback, object state);
+        public void CloseOutputSession(TimeSpan timeout);
+        public void EndCloseOutputSession(IAsyncResult result);
+        protected override object Invoke(MethodInfo targetMethod, object[] args);
+        void System.IDisposable.Dispose();
+        T System.ServiceModel.Channels.IChannel.GetProperty<T>();
+        IAsyncResult System.ServiceModel.Channels.IOutputChannel.BeginSend(Message message, AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.Channels.IOutputChannel.BeginSend(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        void System.ServiceModel.Channels.IOutputChannel.EndSend(IAsyncResult result);
+        void System.ServiceModel.Channels.IOutputChannel.Send(Message message);
+        void System.ServiceModel.Channels.IOutputChannel.Send(Message message, TimeSpan timeout);
+        IAsyncResult System.ServiceModel.Channels.IRequestChannel.BeginRequest(Message message, AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.Channels.IRequestChannel.BeginRequest(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+        Message System.ServiceModel.Channels.IRequestChannel.EndRequest(IAsyncResult result);
+        Message System.ServiceModel.Channels.IRequestChannel.Request(Message message);
+        Message System.ServiceModel.Channels.IRequestChannel.Request(Message message, TimeSpan timeout);
+        IAsyncResult System.ServiceModel.IClientChannel.BeginDisplayInitializationUI(AsyncCallback callback, object state);
+        void System.ServiceModel.IClientChannel.DisplayInitializationUI();
+        void System.ServiceModel.IClientChannel.EndDisplayInitializationUI(IAsyncResult result);
+        void System.ServiceModel.ICommunicationObject.Abort();
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        void System.ServiceModel.ICommunicationObject.Close();
+        void System.ServiceModel.ICommunicationObject.Close(TimeSpan timeout);
+        void System.ServiceModel.ICommunicationObject.EndClose(IAsyncResult result);
+        void System.ServiceModel.ICommunicationObject.EndOpen(IAsyncResult result);
+        void System.ServiceModel.ICommunicationObject.Open();
+        void System.ServiceModel.ICommunicationObject.Open(TimeSpan timeout);
+        public override string ToString();
+    }
+    public class ServiceModelHttpMessageHandler : DelegatingHandler {
+        public ServiceModelHttpMessageHandler();
+        public DecompressionMethods AutomaticDecompression { get; set; }
+        public bool CheckCertificateRevocationList { get; set; }
+        public X509CertificateCollection ClientCertificates { get; }
+        public CookieContainer CookieContainer { get; set; }
+        public ICredentials Credentials { get; set; }
+        public bool PreAuthenticate { get; set; }
+        public Func<HttpRequestMessage, X509Certificate2, X509Chain, SslPolicyErrors, bool> ServerCertificateValidationCallback { get; set; }
+        public bool SupportsCertificateValidationCallback { get; }
+        public bool SupportsClientCertificates { get; }
+        public bool SupportsProxy { get; }
+        public bool UseCookies { get; set; }
+        public bool UseDefaultCredentials { get; set; }
+        public bool UseProxy { get; set; }
+        protected override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class SslStreamSecurityBindingElement : BindingElement {
+        public SslStreamSecurityBindingElement();
+        protected SslStreamSecurityBindingElement(SslStreamSecurityBindingElement elementToBeCloned);
+        public IdentityVerifier IdentityVerifier { get; set; }
+        public SslProtocols SslProtocols { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override StreamUpgradeProvider BuildClientStreamUpgradeProvider(BindingContext context);
+        public override bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public abstract class StreamSecurityUpgradeInitiator : StreamUpgradeInitiator {
+        protected StreamSecurityUpgradeInitiator();
+        public abstract SecurityMessageProperty GetRemoteSecurity();
+    }
+    public abstract class StreamSecurityUpgradeProvider : StreamUpgradeProvider {
+        protected StreamSecurityUpgradeProvider();
+        protected StreamSecurityUpgradeProvider(IDefaultCommunicationTimeouts timeouts);
+        public abstract EndpointIdentity Identity { get; }
+    }
+    public abstract class StreamUpgradeBindingElement : BindingElement {
+        protected StreamUpgradeBindingElement();
+        protected StreamUpgradeBindingElement(StreamUpgradeBindingElement elementToBeCloned);
+        public abstract StreamUpgradeProvider BuildClientStreamUpgradeProvider(BindingContext context);
+    }
+    public abstract class StreamUpgradeInitiator {
+        protected StreamUpgradeInitiator();
+        public abstract string GetNextUpgrade();
+        public abstract Stream InitiateUpgrade(Stream stream);
+    }
+    public abstract class StreamUpgradeProvider : CommunicationObject, IAsyncCommunicationObject, ICommunicationObject {
+        protected StreamUpgradeProvider();
+        protected StreamUpgradeProvider(IDefaultCommunicationTimeouts timeouts);
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        public abstract StreamUpgradeInitiator CreateUpgradeInitiator(EndpointAddress remoteAddress, Uri via);
+        public virtual T GetProperty<T>() where T : class;
+    }
+    public enum SupportedAddressingMode {
+        Anonymous = 0,
+        Mixed = 2,
+        NonAnonymous = 1,
+    }
+    public sealed class TcpConnectionPoolSettings {
+        public string GroupName { get; set; }
+        public TimeSpan IdleTimeout { get; set; }
+        public TimeSpan LeaseTimeout { get; set; }
+        public int MaxOutboundConnectionsPerEndpoint { get; set; }
+    }
+    public class TcpTransportBindingElement : ConnectionOrientedTransportBindingElement {
+        public TcpTransportBindingElement();
+        protected TcpTransportBindingElement(TcpTransportBindingElement elementToBeCloned);
+        public TcpConnectionPoolSettings ConnectionPoolSettings { get; }
+        public override string Scheme { get; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public static class TcpTransportDefaults {
+        public const bool PortSharingEnabled = false;
+        public const bool TeredoEnabled = false;
+        public const int ListenBacklogConst = 0;
+        public const string ConnectionLeaseTimeoutString = "00:05:00";
+        public static TimeSpan ConnectionLeaseTimeout { get; }
+        public static int GetListenBacklog();
+    }
+    public static class TextEncoderDefaults {
+        public static readonly TextEncoderDefaults.CharSetEncoding[] CharSetEncodings;
+        public const string EncodingString = "utf-8";
+        public const string MessageVersionString = "Soap12WSAddressing10";
+        public static readonly Encoding Encoding;
+        public static readonly Encoding[] SupportedEncodings;
+        public static string EncodingToCharSet(Encoding encoding);
+        public static bool TryGetEncoding(string charSet, out Encoding encoding);
+        public static void ValidateEncoding(Encoding encoding);
+        public class CharSetEncoding {
+            public string CharSet;
+            public Encoding Encoding;
+            public CharSetEncoding(string charSet, Encoding enc);
+        }
+    }
+    public sealed class TextMessageEncodingBindingElement : MessageEncodingBindingElement {
+        public TextMessageEncodingBindingElement();
+        public TextMessageEncodingBindingElement(MessageVersion messageVersion, Encoding writeEncoding);
+        public int MaxReadPoolSize { get; set; }
+        public int MaxWritePoolSize { get; set; }
+        public override MessageVersion MessageVersion { get; set; }
+        public XmlDictionaryReaderQuotas ReaderQuotas { get; set; }
+        public Encoding WriteEncoding { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override MessageEncoderFactory CreateMessageEncoderFactory();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public abstract class TransportBindingElement : BindingElement {
+        protected TransportBindingElement();
+        protected TransportBindingElement(TransportBindingElement elementToBeCloned);
+        public virtual bool ManualAddressing { get; set; }
+        public virtual long MaxBufferPoolSize { get; set; }
+        public virtual long MaxReceivedMessageSize { get; set; }
+        public abstract string Scheme { get; }
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public abstract class TransportChannelFactory<TChannel> : ChannelFactoryBase<TChannel>, IDefaultCommunicationTimeouts, ITransportFactorySettings {
+        protected TransportChannelFactory(TransportBindingElement bindingElement, BindingContext context);
+        protected TransportChannelFactory(TransportBindingElement bindingElement, BindingContext context, MessageEncoderFactory defaultMessageEncoderFactory);
+        public BufferManager BufferManager { get; }
+        public bool ManualAddressing { get; }
+        public long MaxBufferPoolSize { get; }
+        public long MaxReceivedMessageSize { get; }
+        public MessageEncoderFactory MessageEncoderFactory { get; }
+        public MessageVersion MessageVersion { get; }
+        public abstract string Scheme { get; }
+        BufferManager System.ServiceModel.Channels.ITransportFactorySettings.BufferManager { get; }
+        bool System.ServiceModel.Channels.ITransportFactorySettings.ManualAddressing { get; }
+        long System.ServiceModel.Channels.ITransportFactorySettings.MaxReceivedMessageSize { get; }
+        MessageEncoderFactory System.ServiceModel.Channels.ITransportFactorySettings.MessageEncoderFactory { get; }
+        public virtual int GetMaxBufferSize();
+        public override T GetProperty<T>();
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnOpening();
+        public void ValidateScheme(Uri via);
+    }
+    public static class TransportDefaults {
+        public const bool ExtractGroupsForWindowsAccounts = true;
+        public const bool ManualAddressing = false;
+        public const bool RequireClientCertificate = false;
+        public const int MaxBufferSize = 65536;
+        public const int MaxDrainSize = 65536;
+        public const int MaxFaultSize = 65536;
+        public const int MaxRMFaultSize = 65536;
+        public const int MaxSecurityFaultSize = 16384;
+        public const long MaxBufferPoolSize = (long)524288;
+        public const long MaxReceivedMessageSize = (long)65536;
+        public const SslProtocols SslProtocols = 4032;
+        public const TokenImpersonationLevel ImpersonationLevel = 2;
+        public const HostNameComparisonMode HostNameComparisonMode = 1;
+        public static MessageEncoderFactory GetDefaultMessageEncoderFactory();
+    }
+    public abstract class TransportDuplexSessionChannel : TransportOutputChannel, IChannel, ICommunicationObject, IDuplexChannel, IDuplexSessionChannel, IInputChannel, IOutputChannel, ISessionChannel<IDuplexSession> {
+        protected TransportDuplexSessionChannel(ChannelManagerBase manager, ITransportFactorySettings settings, EndpointAddress localAddress, Uri localVia, EndpointAddress remoteAddresss, Uri via);
+        protected BufferManager BufferManager { get; }
+        protected abstract bool IsStreamedOutput { get; }
+        public EndpointAddress LocalAddress { get; }
+        protected MessageEncoder MessageEncoder { get; set; }
+        public SecurityMessageProperty RemoteSecurity { get; protected set; }
+        public IDuplexSession Session { get; protected set; }
+        protected void ApplyChannelBinding(Message message);
+        protected abstract AsyncCompletionResult BeginCloseOutput(TimeSpan timeout, Action<object> callback, object state);
+        public IAsyncResult BeginReceive(AsyncCallback callback, object state);
+        public IAsyncResult BeginReceive(TimeSpan timeout, AsyncCallback callback, object state);
+        public IAsyncResult BeginTryReceive(TimeSpan timeout, AsyncCallback callback, object state);
+        public IAsyncResult BeginWaitForMessage(TimeSpan timeout, AsyncCallback callback, object state);
+        protected void CloseOutputSession(TimeSpan timeout);
+        protected Task CloseOutputSessionAsync(TimeSpan timeout);
+        protected abstract void CloseOutputSessionCore(TimeSpan timeout);
+        protected abstract Task CloseOutputSessionCoreAsync(TimeSpan timeout);
+        protected abstract void CompleteClose(TimeSpan timeout);
+        protected abstract ArraySegment<byte> EncodeMessage(Message message);
+        public Message EndReceive(IAsyncResult result);
+        public bool EndTryReceive(IAsyncResult result, out Message message);
+        public bool EndWaitForMessage(IAsyncResult result);
+        protected virtual void FinishWritingMessage();
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnClosed();
+        protected override void OnEndClose(IAsyncResult result);
+        protected override void OnFaulted();
+        protected virtual void OnReceiveMessage(Message message);
+        protected override void OnSend(Message message, TimeSpan timeout);
+        protected override Task OnSendAsync(Message message, TimeSpan timeout);
+        protected abstract void OnSendCore(Message message, TimeSpan timeout);
+        protected virtual void PrepareMessage(Message message);
+        public Message Receive();
+        public Message Receive(TimeSpan timeout);
+        public Task<Message> ReceiveAsync(TimeSpan timeout);
+        protected abstract void ReturnConnectionIfNecessary(bool abort, TimeSpan timeout);
+        protected void SetMessageSource(IMessageSource messageSource);
+        protected abstract AsyncCompletionResult StartWritingBufferedMessage(Message message, ArraySegment<byte> messageData, bool allowOutputBatching, TimeSpan timeout, Action<object> callback, object state);
+        protected abstract AsyncCompletionResult StartWritingStreamedMessage(Message message, TimeSpan timeout, Action<object> callback, object state);
+        public bool TryReceive(TimeSpan timeout, out Message message);
+        public bool WaitForMessage(TimeSpan timeout);
+        public Task<bool> WaitForMessageAsync(TimeSpan timeout);
+        public class ConnectionDuplexSession : IDuplexSession, IInputSession, IOutputSession, ISession {
+            public ConnectionDuplexSession(TransportDuplexSessionChannel channel);
+            public TransportDuplexSessionChannel Channel { get; }
+            public string Id { get; }
+            public IAsyncResult BeginCloseOutputSession(AsyncCallback callback, object state);
+            public IAsyncResult BeginCloseOutputSession(TimeSpan timeout, AsyncCallback callback, object state);
+            public void CloseOutputSession();
+            public void CloseOutputSession(TimeSpan timeout);
+            public void EndCloseOutputSession(IAsyncResult result);
+        }
+    }
+    public abstract class TransportOutputChannel : OutputChannel {
+        protected TransportOutputChannel(ChannelManagerBase channelManager, EndpointAddress to, Uri via, bool manualAddressing, MessageVersion messageVersion);
+        public EventTraceActivity EventTraceActivity { get; }
+        protected bool ManualAddressing { get; }
+        public MessageVersion MessageVersion { get; }
+        public override EndpointAddress RemoteAddress { get; }
+        public override Uri Via { get; }
+        protected override void AddHeadersTo(Message message);
+    }
+    public sealed class TransportSecurityBindingElement : SecurityBindingElement {
+        public TransportSecurityBindingElement();
+        protected override IChannelFactory<TChannel> BuildChannelFactoryCore<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public sealed class UnderstoodHeaders : IEnumerable, IEnumerable<MessageHeaderInfo> {
+        public void Add(MessageHeaderInfo headerInfo);
+        public bool Contains(MessageHeaderInfo headerInfo);
+        public IEnumerator<MessageHeaderInfo> GetEnumerator();
+        public void Remove(MessageHeaderInfo headerInfo);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public static class WebSocketDefaults {
+        public const bool CreateNotificationOnConnection = false;
+        public const int BufferSize = 16384;
+        public const int MinReceiveBufferSize = 256;
+        public const int MinSendBufferSize = 16;
+        public const WebSocketTransportUsage TransportUsage = 2;
+        public const string DefaultKeepAliveIntervalString = "00:00:00";
+        public const string SubProtocol = null;
+        public const string WebSocketConnectionHeaderValue = "Upgrade";
+        public const string WebSocketUpgradeHeaderValue = "websocket";
+        public static readonly TimeSpan DefaultKeepAliveInterval;
+    }
+    public sealed class WebSocketTransportSettings : IEquatable<WebSocketTransportSettings> {
+        public const string BinaryEncoderTransferModeHeader = "microsoft-binary-transfer-mode";
+        public const string BinaryMessageReceivedAction = "http://schemas.microsoft.com/2011/02/websockets/onbinarymessage";
+        public const string ConnectionOpenedAction = "http://schemas.microsoft.com/2011/02/session/onopen";
+        public const string SoapContentTypeHeader = "soap-content-type";
+        public const string TextMessageReceivedAction = "http://schemas.microsoft.com/2011/02/websockets/ontextmessage";
+        public WebSocketTransportSettings();
+        public bool DisablePayloadMasking { get; set; }
+        public TimeSpan KeepAliveInterval { get; set; }
+        public string SubProtocol { get; set; }
+        public WebSocketTransportUsage TransportUsage { get; set; }
+        public override bool Equals(object obj);
+        public bool Equals(WebSocketTransportSettings other);
+        public override int GetHashCode();
+    }
+    public enum WebSocketTransportUsage {
+        Always = 1,
+        Never = 2,
+        WhenDuplex = 0,
+    }
+    public class WindowsStreamSecurityBindingElement : BindingElement {
+        public WindowsStreamSecurityBindingElement();
+        protected WindowsStreamSecurityBindingElement(WindowsStreamSecurityBindingElement elementToBeCloned);
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingContext context);
+        public override StreamUpgradeProvider BuildClientStreamUpgradeProvider(BindingContext context);
+        public override bool CanBuildChannelFactory<TChannel>(BindingContext context);
+        public override BindingElement Clone();
+        public override T GetProperty<T>(BindingContext context);
+    }
+    public class XmlObjectSerializerFault : MessageFault {
+        public XmlObjectSerializerFault(FaultCode code, FaultReason reason, object detail, XmlObjectSerializer serializer, string actor, string node);
+        public override string Actor { get; }
+        public override FaultCode Code { get; }
+        public override bool HasDetail { get; }
+        public override string Node { get; }
+        public override FaultReason Reason { get; }
+        protected override void OnWriteDetailContents(XmlDictionaryWriter writer);
+    }
+}
```

