# System.ServiceModel.Dispatcher

``` diff
+namespace System.ServiceModel.Dispatcher {
+    public class ChannelDispatcher : ChannelDispatcherBase {
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        public SynchronizedCollection<EndpointDispatcher> Endpoints { get; }
+        public Collection<IErrorHandler> ErrorHandlers { get; }
+        public bool IncludeExceptionDetailInFaults { get; set; }
+        public override IChannelListener Listener { get; }
+        public bool ManualAddressing { get; set; }
+        public int MaxPendingReceives { get; set; }
+        public int MaxTransactedBatchSize { get; set; }
+        public MessageVersion MessageVersion { get; set; }
+        public bool ReceiveContextEnabled { get; set; }
+        public bool ReceiveSynchronously { get; set; }
+        public bool SendAsynchronously { get; set; }
+        public override void CloseInput();
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override IAsyncResult OnBeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnClosed();
+        protected override void OnEndClose(IAsyncResult result);
+        protected override void OnEndOpen(IAsyncResult result);
+        protected override void OnOpen(TimeSpan timeout);
+        protected internal override Task OnOpenAsync(TimeSpan timeout);
+        protected override void OnOpened();
+        protected override void OnOpening();
+    }
+    public abstract class ChannelDispatcherBase : CommunicationObject {
+        protected ChannelDispatcherBase();
+        public abstract IChannelListener Listener { get; }
+        public virtual void CloseInput();
+    }
+    public sealed class ClientOperation {
+        public ClientOperation(ClientRuntime parent, string name, string action);
+        public ClientOperation(ClientRuntime parent, string name, string action, string replyAction);
+        public string Action { get; }
+        public MethodInfo BeginMethod { get; set; }
+        public ICollection<IParameterInspector> ClientParameterInspectors { get; }
+        public bool DeserializeReply { get; set; }
+        public MethodInfo EndMethod { get; set; }
+        public SynchronizedCollection<FaultContractInfo> FaultContractInfos { get; }
+        public IClientMessageFormatter Formatter { get; set; }
+        public bool IsInitiating { get; set; }
+        public bool IsOneWay { get; set; }
+        public string Name { get; }
+        public new SynchronizedCollection<IParameterInspector> ParameterInspectors { get; }
+        public ClientRuntime Parent { get; }
+        public string ReplyAction { get; }
+        public bool SerializeRequest { get; set; }
+        public MethodInfo SyncMethod { get; set; }
+        public MethodInfo TaskMethod { get; set; }
+        public Type TaskTResult { get; set; }
+    }
+    public class ClientOperationCompatBase {
+        public IList<IParameterInspector> ParameterInspectors { get; }
+    }
+    public sealed class ClientRuntime {
+        public Type CallbackClientType { get; set; }
+        public DispatchRuntime CallbackDispatchRuntime { get; }
+        public SynchronizedCollection<IChannelInitializer> ChannelInitializers { get; }
+        public ICollection<IClientMessageInspector> ClientMessageInspectors { get; }
+        public ICollection<ClientOperation> ClientOperations { get; }
+        public Type ContractClientType { get; set; }
+        public string ContractName { get; }
+        public string ContractNamespace { get; }
+        public DispatchRuntime DispatchRuntime { get; }
+        public SynchronizedCollection<IInteractiveChannelInitializer> InteractiveChannelInitializers { get; }
+        public bool ManualAddressing { get; set; }
+        public int MaxFaultSize { get; set; }
+        public new SynchronizedCollection<IClientMessageInspector> MessageInspectors { get; }
+        public bool MessageVersionNoneFaultsEnabled { get; set; }
+        public new SynchronizedKeyedCollection<string, ClientOperation> Operations { get; }
+        public IClientOperationSelector OperationSelector { get; set; }
+        public ClientOperation UnhandledClientOperation { get; }
+        public bool ValidateMustUnderstand { get; set; }
+        public Uri Via { get; set; }
+    }
+    public class ClientRuntimeCompatBase {
+        public IList<IClientMessageInspector> MessageInspectors { get; }
+        public KeyedCollection<string, ClientOperation> Operations { get; }
+    }
+    public sealed class DispatchOperation {
+        public DispatchOperation(DispatchRuntime parent, string name, string action);
+        public DispatchOperation(DispatchRuntime parent, string name, string action, string replyAction);
+        public string Action { get; }
+        public bool AutoDisposeParameters { get; set; }
+        public bool DeserializeRequest { get; set; }
+        public SynchronizedCollection<FaultContractInfo> FaultContractInfos { get; }
+        public IOperationInvoker Invoker { get; set; }
+        public bool IsOneWay { get; }
+        public string Name { get; }
+        public SynchronizedCollection<IParameterInspector> ParameterInspectors { get; }
+        public DispatchRuntime Parent { get; }
+        public string ReplyAction { get; }
+        public bool SerializeReply { get; set; }
+    }
+    public sealed class DispatchRuntime {
+        public bool AutomaticInputSessionShutdown { get; set; }
+        public ClientRuntime CallbackClientRuntime { get; }
+        public ChannelDispatcher ChannelDispatcher { get; }
+        public ConcurrencyMode ConcurrencyMode { get; set; }
+        public EndpointDispatcher EndpointDispatcher { get; }
+        public bool EnsureOrderedDispatch { get; set; }
+        public IInstanceContextProvider InstanceContextProvider { get; set; }
+        public IInstanceProvider InstanceProvider { get; set; }
+        public SynchronizedKeyedCollection<string, DispatchOperation> Operations { get; }
+        public SynchronizationContext SynchronizationContext { get; set; }
+        public Type Type { get; set; }
+        public DispatchOperation UnhandledDispatchOperation { get; set; }
+    }
+    public class EndpointDispatcher {
+        public EndpointDispatcher();
+        public ChannelDispatcher ChannelDispatcher { get; }
+        public string ContractName { get; }
+        public string ContractNamespace { get; }
+        public DispatchRuntime DispatchRuntime { get; }
+        public EndpointAddress EndpointAddress { get; }
+        public int FilterPriority { get; set; }
+    }
+    public class FaultContractInfo {
+        public FaultContractInfo(string action, Type detail);
+        public string Action { get; }
+        public Type Detail { get; }
+    }
+    public class FaultFormatter : IClientFaultFormatter, IDispatchFaultFormatter {
+        protected virtual FaultException CreateFaultException(MessageFault messageFault, string action);
+        protected FaultException CreateFaultException(MessageFault messageFault, string action, object detailObj, Type detailType, XmlDictionaryReader detailReader);
+        public FaultException Deserialize(MessageFault messageFault, string action);
+        protected virtual XmlObjectSerializer GetSerializer(Type detailType, string faultExceptionAction, out string action);
+        public MessageFault Serialize(FaultException faultException, out string action);
+        public class OperationFault<T> : XmlObjectSerializerFault {
+            public OperationFault(XmlObjectSerializer serializer, FaultException<T> faultException);
+        }
+    }
+    public interface IChannelInitializer {
+        void Initialize(IClientChannel channel);
+    }
+    public interface IClientMessageFormatter {
+        object DeserializeReply(Message message, object[] parameters);
+        Message SerializeRequest(MessageVersion messageVersion, object[] parameters);
+    }
+    public interface IClientMessageInspector {
+        void AfterReceiveReply(ref Message reply, object correlationState);
+        object BeforeSendRequest(ref Message request, IClientChannel channel);
+    }
+    public interface IClientOperationSelector {
+        bool AreParametersRequiredForSelection { get; }
+        string SelectOperation(MethodBase method, object[] parameters);
+    }
+    public interface IErrorHandler {
+        bool HandleError(Exception error);
+        void ProvideFault(Exception error, MessageVersion version, ref Message fault);
+    }
+    public interface IInstanceContextProvider {
+        InstanceContext GetExistingInstanceContext(Message message, IContextChannel channel);
+    }
+    public interface IInstanceProvider {
+        object GetInstance(InstanceContext instanceContext);
+        object GetInstance(InstanceContext instanceContext, Message message);
+        void ReleaseInstance(InstanceContext instanceContext, object instance);
+    }
+    public interface IInteractiveChannelInitializer {
+        IAsyncResult BeginDisplayInitializationUI(IClientChannel channel, AsyncCallback callback, object state);
+        void EndDisplayInitializationUI(IAsyncResult result);
+    }
+    public class InstanceBehavior
+    public interface IOperationInvoker {
+        object[] AllocateInputs();
+        IAsyncResult InvokeBegin(object instance, object[] inputs, AsyncCallback callback, object state);
+        object InvokeEnd(object instance, out object[] outputs, IAsyncResult result);
+    }
+    public interface IParameterInspector {
+        void AfterCall(string operationName, object[] outputs, object returnValue, object correlationState);
+        object BeforeCall(string operationName, object[] inputs);
+    }
+    public class OperationInvokerBehavior : IOperationBehavior {
+        public OperationInvokerBehavior();
+        void System.ServiceModel.Description.IOperationBehavior.AddBindingParameters(OperationDescription description, BindingParameterCollection parameters);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyClientBehavior(OperationDescription description, ClientOperation proxy);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyDispatchBehavior(OperationDescription description, DispatchOperation dispatch);
+        void System.ServiceModel.Description.IOperationBehavior.Validate(OperationDescription description);
+    }
+    public class SyncMethodInvoker : IOperationInvoker {
+        public SyncMethodInvoker(MethodInfo method);
+        public MethodInfo Method { get; }
+        public string MethodName { get; }
+        public object[] AllocateInputs();
+        public IAsyncResult InvokeBegin(object instance, object[] inputs, AsyncCallback callback, object state);
+        public object InvokeEnd(object instance, out object[] outputs, IAsyncResult result);
+    }
+    public class TaskMethodInvoker : IOperationInvoker {
+        public TaskMethodInvoker(MethodInfo taskMethod, Type taskType);
+        public MethodInfo Method { get; }
+        public string MethodName { get; }
+        public object[] AllocateInputs();
+        public IAsyncResult InvokeBegin(object instance, object[] inputs, AsyncCallback callback, object state);
+        public object InvokeEnd(object instance, out object[] outputs, IAsyncResult result);
+    }
+}
```

