# System

``` diff
+namespace System {
+    public class AccessViolationException : SystemException {
+        public AccessViolationException();
+        public AccessViolationException(string message);
+        public AccessViolationException(string message, Exception innerException);
+    }
+    public delegate void Action();
+    public delegate void Action<in T>(T obj);
+    public delegate void Action<in T1, in T2>(T1 arg1, T2 arg2);
+    public delegate void Action<in T1, in T2, in T3>(T1 arg1, T2 arg2, T3 arg3);
+    public delegate void Action<in T1, in T2, in T3, in T4>(T1 arg1, T2 arg2, T3 arg3, T4 arg4);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15);
+    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, in T16>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15, T16 arg16);
+    public static class Activator {
+        public static object CreateInstance(Type type);
+        public static object CreateInstance(Type type, bool nonPublic);
+        public static object CreateInstance(Type type, params object[] args);
+        public static T CreateInstance<T>();
+    }
+    public class AggregateException : Exception {
+        public AggregateException();
+        public AggregateException(IEnumerable<Exception> innerExceptions);
+        public AggregateException(params Exception[] innerExceptions);
+        public AggregateException(string message);
+        public AggregateException(string message, IEnumerable<Exception> innerExceptions);
+        public AggregateException(string message, Exception innerException);
+        public AggregateException(string message, params Exception[] innerExceptions);
+        public ReadOnlyCollection<Exception> InnerExceptions { get; }
+        public override string Message { get; }
+        public AggregateException Flatten();
+        public override Exception GetBaseException();
+        public void Handle(Func<Exception, bool> predicate);
+        public override string ToString();
+    }
+    public static class AppContext {
+        public static string BaseDirectory { get; }
+        public static string TargetFrameworkName { get; }
+        public static object GetData(string name);
+        public static void SetSwitch(string switchName, bool isEnabled);
+        public static bool TryGetSwitch(string switchName, out bool isEnabled);
+    }
+    public sealed class AppDomain : _AppDomain {
+        public string BaseDirectory { get; }
+        public static AppDomain CurrentDomain { get; }
+        public bool IsFullyTrusted { get; }
+        public object GetData(string name);
+        public override string ToString();
+    }
+    public class AppDomainManager {
+        public AppDomainManager();
+        public virtual bool CheckSecuritySettings(SecurityState state);
+        public virtual void InitializeNewDomain(AppDomainSetup appDomainInfo);
+    }
+    public sealed class AppDomainSetup
+    public class AppDomainUnloadedException : SystemException {
+        public AppDomainUnloadedException();
+        public AppDomainUnloadedException(string message);
+        public AppDomainUnloadedException(string message, Exception innerException);
+    }
+    public class ApplicationException : Exception {
+        public ApplicationException();
+        public ApplicationException(string message);
+        public ApplicationException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ArgIterator {
+        public override bool Equals(object o);
+        public override int GetHashCode();
+    }
+    public class ArgumentException : Exception {
+        public ArgumentException();
+        public ArgumentException(string message);
+        public ArgumentException(string message, Exception innerException);
+        public ArgumentException(string message, string paramName);
+        public ArgumentException(string message, string paramName, Exception innerException);
+        public override string Message { get; }
+        public virtual string ParamName { get; }
+    }
+    public class ArgumentNullException : ArgumentException {
+        public ArgumentNullException();
+        public ArgumentNullException(string paramName);
+        public ArgumentNullException(string message, Exception innerException);
+        public ArgumentNullException(string paramName, string message);
+    }
+    public class ArgumentOutOfRangeException : ArgumentException {
+        public ArgumentOutOfRangeException();
+        public ArgumentOutOfRangeException(string paramName);
+        public ArgumentOutOfRangeException(string message, Exception innerException);
+        public ArgumentOutOfRangeException(string paramName, object actualValue, string message);
+        public ArgumentOutOfRangeException(string paramName, string message);
+        public virtual object ActualValue { get; }
+        public override string Message { get; }
+    }
+    public class ArithmeticException : Exception {
+        public ArithmeticException();
+        public ArithmeticException(string message);
+        public ArithmeticException(string message, Exception innerException);
+    }
+    public abstract class Array : ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
+        public bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public int Length { get; }
+        public int Rank { get; }
+        public object SyncRoot { get; }
+        int System.Collections.ICollection.Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public static ReadOnlyCollection<T> AsReadOnly<T>(T[] array);
+        public static int BinarySearch(Array array, int index, int length, object value);
+        public static int BinarySearch(Array array, int index, int length, object value, IComparer comparer);
+        public static int BinarySearch(Array array, object value);
+        public static int BinarySearch(Array array, object value, IComparer comparer);
+        public static int BinarySearch<T>(T[] array, int index, int length, T value);
+        public static int BinarySearch<T>(T[] array, int index, int length, T value, IComparer<T> comparer);
+        public static int BinarySearch<T>(T[] array, T value);
+        public static int BinarySearch<T>(T[] array, T value, IComparer<T> comparer);
+        public static void Clear(Array array, int index, int length);
+        public object Clone();
+        public static void ConstrainedCopy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length);
+        public static void Copy(Array sourceArray, Array destinationArray, int length);
+        public static void Copy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length);
+        public void CopyTo(Array array, int index);
+        public static Array CreateInstance(Type elementType, int length);
+        public static Array CreateInstance(Type elementType, params int[] lengths);
+        public static Array CreateInstance(Type elementType, int[] lengths, int[] lowerBounds);
+        public static T[] Empty<T>();
+        public static bool Exists<T>(T[] array, Predicate<T> match);
+        public static T Find<T>(T[] array, Predicate<T> match);
+        public static T[] FindAll<T>(T[] array, Predicate<T> match);
+        public static int FindIndex<T>(T[] array, int startIndex, int count, Predicate<T> match);
+        public static int FindIndex<T>(T[] array, int startIndex, Predicate<T> match);
+        public static int FindIndex<T>(T[] array, Predicate<T> match);
+        public static T FindLast<T>(T[] array, Predicate<T> match);
+        public static int FindLastIndex<T>(T[] array, int startIndex, int count, Predicate<T> match);
+        public static int FindLastIndex<T>(T[] array, int startIndex, Predicate<T> match);
+        public static int FindLastIndex<T>(T[] array, Predicate<T> match);
+        public static void ForEach<T>(T[] array, Action<T> action);
+        public IEnumerator GetEnumerator();
+        public int GetLength(int dimension);
+        public int GetLowerBound(int dimension);
+        public int GetUpperBound(int dimension);
+        public object GetValue(int index);
+        public object GetValue(params int[] indices);
+        public static int IndexOf(Array array, object value);
+        public static int IndexOf(Array array, object value, int startIndex);
+        public static int IndexOf(Array array, object value, int startIndex, int count);
+        public static int IndexOf<T>(T[] array, T value);
+        public static int IndexOf<T>(T[] array, T value, int startIndex);
+        public static int IndexOf<T>(T[] array, T value, int startIndex, int count);
+        public void Initialize();
+        public static int LastIndexOf(Array array, object value);
+        public static int LastIndexOf(Array array, object value, int startIndex);
+        public static int LastIndexOf(Array array, object value, int startIndex, int count);
+        public static int LastIndexOf<T>(T[] array, T value);
+        public static int LastIndexOf<T>(T[] array, T value, int startIndex);
+        public static int LastIndexOf<T>(T[] array, T value, int startIndex, int count);
+        public static void Resize<T>(ref T[] array, int newSize);
+        public static void Reverse(Array array);
+        public static void Reverse(Array array, int index, int length);
+        public void SetValue(object value, int index);
+        public void SetValue(object value, params int[] indices);
+        public static void Sort(Array array);
+        public static void Sort(Array keys, Array items);
+        public static void Sort(Array keys, Array items, IComparer comparer);
+        public static void Sort(Array keys, Array items, int index, int length);
+        public static void Sort(Array keys, Array items, int index, int length, IComparer comparer);
+        public static void Sort(Array array, IComparer comparer);
+        public static void Sort(Array array, int index, int length);
+        public static void Sort(Array array, int index, int length, IComparer comparer);
+        public static void Sort<T>(T[] array);
+        public static void Sort<T>(T[] array, IComparer<T> comparer);
+        public static void Sort<T>(T[] array, Comparison<T> comparison);
+        public static void Sort<T>(T[] array, int index, int length);
+        public static void Sort<T>(T[] array, int index, int length, IComparer<T> comparer);
+        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items);
+        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, IComparer<TKey> comparer);
+        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, int index, int length);
+        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, int index, int length, IComparer<TKey> comparer);
+        int System.Collections.IList.Add(object value);
+        void System.Collections.IList.Clear();
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+        void System.Collections.IList.RemoveAt(int index);
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        public static bool TrueForAll<T>(T[] array, Predicate<T> match);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ArraySegment<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+        public ArraySegment(T[] array);
+        public ArraySegment(T[] array, int offset, int count);
+        public T[] Array { get; }
+        public int Count { get; }
+        public int Offset { get; }
+        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
+        T System.Collections.Generic.IReadOnlyList<T>.this[int index] { get; }
+        public bool Equals(ArraySegment<T> obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ArraySegment<T> a, ArraySegment<T> b);
+        public static bool operator !=(ArraySegment<T> a, ArraySegment<T> b);
+        void System.Collections.Generic.ICollection<T>.Add(T item);
+        void System.Collections.Generic.ICollection<T>.Clear();
+        bool System.Collections.Generic.ICollection<T>.Contains(T item);
+        void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<T>.Remove(T item);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        int System.Collections.Generic.IList<T>.IndexOf(T item);
+        void System.Collections.Generic.IList<T>.Insert(int index, T item);
+        void System.Collections.Generic.IList<T>.RemoveAt(int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public class ArrayTypeMismatchException : Exception {
+        public ArrayTypeMismatchException();
+        public ArrayTypeMismatchException(string message);
+        public ArrayTypeMismatchException(string message, Exception innerException);
+    }
+    public delegate void AsyncCallback(IAsyncResult ar);
+    public abstract class Attribute {
+        protected Attribute();
+        public override bool Equals(object obj);
+        public static Attribute GetCustomAttribute(Assembly element, Type attributeType);
+        public static Attribute GetCustomAttribute(Assembly element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(Module element, Type attributeType);
+        public static Attribute GetCustomAttribute(Module element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(Assembly element);
+        public static Attribute[] GetCustomAttributes(Assembly element, bool inherit);
+        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type, bool inherit);
+        public static Attribute[] GetCustomAttributes(Module element);
+        public static Attribute[] GetCustomAttributes(Module element, bool inherit);
+        public static Attribute[] GetCustomAttributes(Module element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(Module element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, bool inherit);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType, bool inherit);
+        public override int GetHashCode();
+        public static bool IsDefined(Assembly element, Type attributeType);
+        public static bool IsDefined(Assembly element, Type attributeType, bool inherit);
+        public static bool IsDefined(MemberInfo element, Type attributeType);
+        public static bool IsDefined(MemberInfo element, Type attributeType, bool inherit);
+        public static bool IsDefined(Module element, Type attributeType);
+        public static bool IsDefined(Module element, Type attributeType, bool inherit);
+        public static bool IsDefined(ParameterInfo element, Type attributeType);
+        public static bool IsDefined(ParameterInfo element, Type attributeType, bool inherit);
+        public virtual bool Match(object obj);
+    }
+    public enum AttributeTargets {
+        All = 32767,
+        Assembly = 1,
+        Class = 4,
+        Constructor = 32,
+        Delegate = 4096,
+        Enum = 16,
+        Event = 512,
+        Field = 256,
+        GenericParameter = 16384,
+        Interface = 1024,
+        Method = 64,
+        Module = 2,
+        Parameter = 2048,
+        Property = 128,
+        ReturnValue = 8192,
+        Struct = 8,
+    }
+    public sealed class AttributeUsageAttribute : Attribute {
+        public AttributeUsageAttribute(AttributeTargets validOn);
+        public bool AllowMultiple { get; set; }
+        public bool Inherited { get; set; }
+        public AttributeTargets ValidOn { get; }
+    }
+    public class BadImageFormatException : Exception {
+        public BadImageFormatException();
+        public BadImageFormatException(string message);
+        public BadImageFormatException(string message, Exception inner);
+        public BadImageFormatException(string message, string fileName);
+        public BadImageFormatException(string message, string fileName, Exception inner);
+        public string FileName { get; }
+        public override string Message { get; }
+        public override string ToString();
+    }
+    public static class BitConverter {
+        public static readonly bool IsLittleEndian;
+        public static long DoubleToInt64Bits(double value);
+        public static byte[] GetBytes(bool value);
+        public static byte[] GetBytes(char value);
+        public static byte[] GetBytes(double value);
+        public static byte[] GetBytes(short value);
+        public static byte[] GetBytes(int value);
+        public static byte[] GetBytes(long value);
+        public static byte[] GetBytes(float value);
+        public static byte[] GetBytes(ushort value);
+        public static byte[] GetBytes(uint value);
+        public static byte[] GetBytes(ulong value);
+        public static double Int64BitsToDouble(long value);
+        public static bool ToBoolean(byte[] value, int startIndex);
+        public static char ToChar(byte[] value, int startIndex);
+        public static double ToDouble(byte[] value, int startIndex);
+        public static short ToInt16(byte[] value, int startIndex);
+        public static int ToInt32(byte[] value, int startIndex);
+        public static long ToInt64(byte[] value, int startIndex);
+        public static float ToSingle(byte[] value, int startIndex);
+        public static string ToString(byte[] value);
+        public static string ToString(byte[] value, int startIndex);
+        public static string ToString(byte[] value, int startIndex, int length);
+        public static ushort ToUInt16(byte[] value, int startIndex);
+        public static uint ToUInt32(byte[] value, int startIndex);
+        public static ulong ToUInt64(byte[] value, int startIndex);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool> {
+        public static readonly string FalseString;
+        public static readonly string TrueString;
+        public int CompareTo(bool value);
+        public int CompareTo(object obj);
+        public bool Equals(bool obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static bool Parse(string value);
+        int System.IComparable.CompareTo(object obj);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        string System.IConvertible.ToString(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public static bool TryParse(string value, out bool result);
+    }
+    public static class Buffer {
+        public static void BlockCopy(Array src, int srcOffset, Array dst, int dstOffset, int count);
+        public static int ByteLength(Array array);
+        public static byte GetByte(Array array, int index);
+        public unsafe static void MemoryCopy(void* source, void* destination, long destinationSizeInBytes, long sourceBytesToCopy);
+        public unsafe static void MemoryCopy(void* source, void* destination, ulong destinationSizeInBytes, ulong sourceBytesToCopy);
+        public static void SetByte(Array array, int index, byte value);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable {
+        public const byte MaxValue = (byte)255;
+        public const byte MinValue = (byte)0;
+        public int CompareTo(byte value);
+        public int CompareTo(object value);
+        public bool Equals(byte obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static byte Parse(string s);
+        public static byte Parse(string s, NumberStyles style);
+        public static byte Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static byte Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, out byte result);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out byte result);
+    }
+    public class CannotUnloadAppDomainException : SystemException {
+        public CannotUnloadAppDomainException();
+        public CannotUnloadAppDomainException(string message);
+        public CannotUnloadAppDomainException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
+        public const char MaxValue = '\uFFFF';
+        public const char MinValue = '\0';
+        public int CompareTo(char value);
+        public int CompareTo(object value);
+        public static string ConvertFromUtf32(int utf32);
+        public static int ConvertToUtf32(char highSurrogate, char lowSurrogate);
+        public static int ConvertToUtf32(string s, int index);
+        public bool Equals(char obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static double GetNumericValue(char c);
+        public static double GetNumericValue(string s, int index);
+        public TypeCode GetTypeCode();
+        public static UnicodeCategory GetUnicodeCategory(char c);
+        public static UnicodeCategory GetUnicodeCategory(string s, int index);
+        public static bool IsControl(char c);
+        public static bool IsControl(string s, int index);
+        public static bool IsDigit(char c);
+        public static bool IsDigit(string s, int index);
+        public static bool IsHighSurrogate(char c);
+        public static bool IsHighSurrogate(string s, int index);
+        public static bool IsLetter(char c);
+        public static bool IsLetter(string s, int index);
+        public static bool IsLetterOrDigit(char c);
+        public static bool IsLetterOrDigit(string s, int index);
+        public static bool IsLower(char c);
+        public static bool IsLower(string s, int index);
+        public static bool IsLowSurrogate(char c);
+        public static bool IsLowSurrogate(string s, int index);
+        public static bool IsNumber(char c);
+        public static bool IsNumber(string s, int index);
+        public static bool IsPunctuation(char c);
+        public static bool IsPunctuation(string s, int index);
+        public static bool IsSeparator(char c);
+        public static bool IsSeparator(string s, int index);
+        public static bool IsSurrogate(char c);
+        public static bool IsSurrogate(string s, int index);
+        public static bool IsSurrogatePair(char highSurrogate, char lowSurrogate);
+        public static bool IsSurrogatePair(string s, int index);
+        public static bool IsSymbol(char c);
+        public static bool IsSymbol(string s, int index);
+        public static bool IsUpper(char c);
+        public static bool IsUpper(string s, int index);
+        public static bool IsWhiteSpace(char c);
+        public static bool IsWhiteSpace(string s, int index);
+        public static char Parse(string s);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        string System.IConvertible.ToString(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public static char ToLower(char c);
+        public static char ToLower(char c, CultureInfo culture);
+        public static char ToLowerInvariant(char c);
+        public override string ToString();
+        public static string ToString(char c);
+        public string ToString(IFormatProvider provider);
+        public static char ToUpper(char c);
+        public static char ToUpper(char c, CultureInfo culture);
+        public static char ToUpperInvariant(char c);
+        public static bool TryParse(string s, out char result);
+    }
+    public sealed class CLSCompliantAttribute : Attribute {
+        public CLSCompliantAttribute(bool isCompliant);
+        public bool IsCompliant { get; }
+    }
+    public delegate int Comparison<in T>(T x, T y);
+    public static class Console {
+        public static ConsoleColor BackgroundColor { get; set; }
+        public static int BufferHeight { get; set; }
+        public static int BufferWidth { get; set; }
+        public static bool CapsLock { get; }
+        public static int CursorLeft { get; set; }
+        public static int CursorSize { get; set; }
+        public static int CursorTop { get; set; }
+        public static bool CursorVisible { get; set; }
+        public static TextWriter Error { get; }
+        public static ConsoleColor ForegroundColor { get; set; }
+        public static TextReader In { get; }
+        public static Encoding InputEncoding { get; set; }
+        public static bool IsErrorRedirected { get; }
+        public static bool IsInputRedirected { get; }
+        public static bool IsOutputRedirected { get; }
+        public static bool KeyAvailable { get; }
+        public static int LargestWindowHeight { get; }
+        public static int LargestWindowWidth { get; }
+        public static bool NumberLock { get; }
+        public static TextWriter Out { get; }
+        public static Encoding OutputEncoding { get; set; }
+        public static string Title { get; set; }
+        public static bool TreatControlCAsInput { get; set; }
+        public static int WindowHeight { get; set; }
+        public static int WindowLeft { get; set; }
+        public static int WindowTop { get; set; }
+        public static int WindowWidth { get; set; }
+        public static event ConsoleCancelEventHandler CancelKeyPress;
+        public static void Beep();
+        public static void Beep(int frequency, int duration);
+        public static void Clear();
+        public static void MoveBufferArea(int sourceLeft, int sourceTop, int sourceWidth, int sourceHeight, int targetLeft, int targetTop);
+        public static void MoveBufferArea(int sourceLeft, int sourceTop, int sourceWidth, int sourceHeight, int targetLeft, int targetTop, char sourceChar, ConsoleColor sourceForeColor, ConsoleColor sourceBackColor);
+        public static Stream OpenStandardError();
+        public static Stream OpenStandardInput();
+        public static Stream OpenStandardOutput();
+        public static int Read();
+        public static ConsoleKeyInfo ReadKey();
+        public static ConsoleKeyInfo ReadKey(bool intercept);
+        public static string ReadLine();
+        public static void ResetColor();
+        public static void SetBufferSize(int width, int height);
+        public static void SetCursorPosition(int left, int top);
+        public static void SetError(TextWriter newError);
+        public static void SetIn(TextReader newIn);
+        public static void SetOut(TextWriter newOut);
+        public static void SetWindowPosition(int left, int top);
+        public static void SetWindowSize(int width, int height);
+        public static void Write(bool value);
+        public static void Write(char value);
+        public static void Write(char[] buffer);
+        public static void Write(char[] buffer, int index, int count);
+        public static void Write(Decimal value);
+        public static void Write(double value);
+        public static void Write(int value);
+        public static void Write(long value);
+        public static void Write(object value);
+        public static void Write(float value);
+        public static void Write(string s);
+        public static void Write(string format, object arg0);
+        public static void Write(string format, object arg0, object arg1);
+        public static void Write(string format, object arg0, object arg1, object arg2);
+        public static void Write(string format, params object[] arg);
+        public static void Write(uint value);
+        public static void Write(ulong value);
+        public static void WriteLine();
+        public static void WriteLine(bool value);
+        public static void WriteLine(char value);
+        public static void WriteLine(char[] buffer);
+        public static void WriteLine(char[] buffer, int index, int count);
+        public static void WriteLine(Decimal value);
+        public static void WriteLine(double value);
+        public static void WriteLine(int value);
+        public static void WriteLine(long value);
+        public static void WriteLine(object value);
+        public static void WriteLine(float value);
+        public static void WriteLine(string s);
+        public static void WriteLine(string format, object arg0);
+        public static void WriteLine(string format, object arg0, object arg1);
+        public static void WriteLine(string format, object arg0, object arg1, object arg2);
+        public static void WriteLine(string format, params object[] arg);
+        public static void WriteLine(uint value);
+        public static void WriteLine(ulong value);
+    }
+    public sealed class ConsoleCancelEventArgs : EventArgs {
+        public bool Cancel { get; set; }
+        public ConsoleSpecialKey SpecialKey { get; }
+    }
+    public delegate void ConsoleCancelEventHandler(object sender, ConsoleCancelEventArgs e);
+    public enum ConsoleColor {
+        Black = 0,
+        Blue = 9,
+        Cyan = 11,
+        DarkBlue = 1,
+        DarkCyan = 3,
+        DarkGray = 8,
+        DarkGreen = 2,
+        DarkMagenta = 5,
+        DarkRed = 4,
+        DarkYellow = 6,
+        Gray = 7,
+        Green = 10,
+        Magenta = 13,
+        Red = 12,
+        White = 15,
+        Yellow = 14,
+    }
+    public enum ConsoleKey {
+        A = 65,
+        Add = 107,
+        B = 66,
+        Backspace = 8,
+        C = 67,
+        Clear = 12,
+        D = 68,
+        D0 = 48,
+        D1 = 49,
+        D2 = 50,
+        D3 = 51,
+        D4 = 52,
+        D5 = 53,
+        D6 = 54,
+        D7 = 55,
+        D8 = 56,
+        D9 = 57,
+        Decimal = 110,
+        Delete = 46,
+        Divide = 111,
+        DownArrow = 40,
+        E = 69,
+        End = 35,
+        Enter = 13,
+        Escape = 27,
+        Execute = 43,
+        F = 70,
+        F1 = 112,
+        F10 = 121,
+        F11 = 122,
+        F12 = 123,
+        F13 = 124,
+        F14 = 125,
+        F15 = 126,
+        F16 = 127,
+        F17 = 128,
+        F18 = 129,
+        F19 = 130,
+        F2 = 113,
+        F20 = 131,
+        F21 = 132,
+        F22 = 133,
+        F23 = 134,
+        F24 = 135,
+        F3 = 114,
+        F4 = 115,
+        F5 = 116,
+        F6 = 117,
+        F7 = 118,
+        F8 = 119,
+        F9 = 120,
+        G = 71,
+        H = 72,
+        Help = 47,
+        Home = 36,
+        I = 73,
+        Insert = 45,
+        J = 74,
+        K = 75,
+        L = 76,
+        LeftArrow = 37,
+        M = 77,
+        Multiply = 106,
+        N = 78,
+        NumPad0 = 96,
+        NumPad1 = 97,
+        NumPad2 = 98,
+        NumPad3 = 99,
+        NumPad4 = 100,
+        NumPad5 = 101,
+        NumPad6 = 102,
+        NumPad7 = 103,
+        NumPad8 = 104,
+        NumPad9 = 105,
+        O = 79,
+        Oem1 = 186,
+        Oem2 = 191,
+        Oem3 = 192,
+        Oem4 = 219,
+        Oem5 = 220,
+        Oem6 = 221,
+        Oem7 = 222,
+        Oem8 = 223,
+        OemClear = 254,
+        OemComma = 188,
+        OemMinus = 189,
+        OemPeriod = 190,
+        OemPlus = 187,
+        P = 80,
+        PageDown = 34,
+        PageUp = 33,
+        Pause = 19,
+        Print = 42,
+        PrintScreen = 44,
+        Q = 81,
+        R = 82,
+        RightArrow = 39,
+        S = 83,
+        Select = 41,
+        Separator = 108,
+        Sleep = 95,
+        Spacebar = 32,
+        Subtract = 109,
+        T = 84,
+        Tab = 9,
+        U = 85,
+        UpArrow = 38,
+        V = 86,
+        W = 87,
+        X = 88,
+        Y = 89,
+        Z = 90,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct ConsoleKeyInfo {
+        public ConsoleKeyInfo(char keyChar, ConsoleKey key, bool shift, bool alt, bool control);
+        public ConsoleKey Key { get; }
+        public char KeyChar { get; }
+        public ConsoleModifiers Modifiers { get; }
+        public bool Equals(ConsoleKeyInfo obj);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static bool operator ==(ConsoleKeyInfo a, ConsoleKeyInfo b);
+        public static bool operator !=(ConsoleKeyInfo a, ConsoleKeyInfo b);
+    }
+    public enum ConsoleModifiers {
+        Alt = 1,
+        Control = 4,
+        Shift = 2,
+    }
+    public enum ConsoleSpecialKey {
+        ControlBreak = 1,
+        ControlC = 0,
+    }
+    public class ContextMarshalException : SystemException {
+        public ContextMarshalException();
+        public ContextMarshalException(string message);
+        public ContextMarshalException(string message, Exception inner);
+    }
+    public class ContextStaticAttribute : Attribute {
+        public ContextStaticAttribute();
+    }
+    public static class Convert {
+        public static readonly object DBNull;
+        public static object ChangeType(object value, Type conversionType);
+        public static object ChangeType(object value, Type conversionType, IFormatProvider provider);
+        public static object ChangeType(object value, TypeCode typeCode, IFormatProvider provider);
+        public static byte[] FromBase64CharArray(char[] inArray, int offset, int length);
+        public static byte[] FromBase64String(string s);
+        public static TypeCode GetTypeCode(object value);
+        public static bool IsDBNull(object value);
+        public static int ToBase64CharArray(byte[] inArray, int offsetIn, int length, char[] outArray, int offsetOut);
+        public static string ToBase64String(byte[] inArray);
+        public static string ToBase64String(byte[] inArray, int offset, int length);
+        public static bool ToBoolean(bool value);
+        public static bool ToBoolean(byte value);
+        public static bool ToBoolean(char value);
+        public static bool ToBoolean(Decimal value);
+        public static bool ToBoolean(double value);
+        public static bool ToBoolean(short value);
+        public static bool ToBoolean(int value);
+        public static bool ToBoolean(long value);
+        public static bool ToBoolean(object value);
+        public static bool ToBoolean(object value, IFormatProvider provider);
+        public static bool ToBoolean(sbyte value);
+        public static bool ToBoolean(float value);
+        public static bool ToBoolean(string value);
+        public static bool ToBoolean(string value, IFormatProvider provider);
+        public static bool ToBoolean(ushort value);
+        public static bool ToBoolean(uint value);
+        public static bool ToBoolean(ulong value);
+        public static byte ToByte(bool value);
+        public static byte ToByte(byte value);
+        public static byte ToByte(char value);
+        public static byte ToByte(Decimal value);
+        public static byte ToByte(double value);
+        public static byte ToByte(short value);
+        public static byte ToByte(int value);
+        public static byte ToByte(long value);
+        public static byte ToByte(object value);
+        public static byte ToByte(object value, IFormatProvider provider);
+        public static byte ToByte(sbyte value);
+        public static byte ToByte(float value);
+        public static byte ToByte(string value);
+        public static byte ToByte(string value, IFormatProvider provider);
+        public static byte ToByte(string value, int fromBase);
+        public static byte ToByte(ushort value);
+        public static byte ToByte(uint value);
+        public static byte ToByte(ulong value);
+        public static char ToChar(byte value);
+        public static char ToChar(char value);
+        public static char ToChar(decimal value);
+        public static char ToChar(double value);
+        public static char ToChar(short value);
+        public static char ToChar(int value);
+        public static char ToChar(long value);
+        public static char ToChar(object value);
+        public static char ToChar(object value, IFormatProvider provider);
+        public static char ToChar(sbyte value);
+        public static char ToChar(float value);
+        public static char ToChar(string value);
+        public static char ToChar(string value, IFormatProvider provider);
+        public static char ToChar(ushort value);
+        public static char ToChar(uint value);
+        public static char ToChar(ulong value);
+        public static DateTime ToDateTime(object value);
+        public static DateTime ToDateTime(object value, IFormatProvider provider);
+        public static DateTime ToDateTime(string value);
+        public static DateTime ToDateTime(string value, IFormatProvider provider);
+        public static Decimal ToDecimal(bool value);
+        public static Decimal ToDecimal(byte value);
+        public static decimal ToDecimal(char value);
+        public static decimal ToDecimal(DateTime value);
+        public static Decimal ToDecimal(Decimal value);
+        public static Decimal ToDecimal(double value);
+        public static Decimal ToDecimal(short value);
+        public static Decimal ToDecimal(int value);
+        public static Decimal ToDecimal(long value);
+        public static Decimal ToDecimal(object value);
+        public static Decimal ToDecimal(object value, IFormatProvider provider);
+        public static Decimal ToDecimal(sbyte value);
+        public static Decimal ToDecimal(float value);
+        public static Decimal ToDecimal(string value);
+        public static Decimal ToDecimal(string value, IFormatProvider provider);
+        public static Decimal ToDecimal(ushort value);
+        public static Decimal ToDecimal(uint value);
+        public static Decimal ToDecimal(ulong value);
+        public static double ToDouble(bool value);
+        public static double ToDouble(byte value);
+        public static double ToDouble(char value);
+        public static double ToDouble(Decimal value);
+        public static double ToDouble(double value);
+        public static double ToDouble(short value);
+        public static double ToDouble(int value);
+        public static double ToDouble(long value);
+        public static double ToDouble(object value);
+        public static double ToDouble(object value, IFormatProvider provider);
+        public static double ToDouble(sbyte value);
+        public static double ToDouble(float value);
+        public static double ToDouble(string value);
+        public static double ToDouble(string value, IFormatProvider provider);
+        public static double ToDouble(ushort value);
+        public static double ToDouble(uint value);
+        public static double ToDouble(ulong value);
+        public static short ToInt16(bool value);
+        public static short ToInt16(byte value);
+        public static short ToInt16(char value);
+        public static short ToInt16(Decimal value);
+        public static short ToInt16(double value);
+        public static short ToInt16(short value);
+        public static short ToInt16(int value);
+        public static short ToInt16(long value);
+        public static short ToInt16(object value);
+        public static short ToInt16(object value, IFormatProvider provider);
+        public static short ToInt16(sbyte value);
+        public static short ToInt16(float value);
+        public static short ToInt16(string value);
+        public static short ToInt16(string value, IFormatProvider provider);
+        public static short ToInt16(string value, int fromBase);
+        public static short ToInt16(ushort value);
+        public static short ToInt16(uint value);
+        public static short ToInt16(ulong value);
+        public static int ToInt32(bool value);
+        public static int ToInt32(byte value);
+        public static int ToInt32(char value);
+        public static int ToInt32(Decimal value);
+        public static int ToInt32(double value);
+        public static int ToInt32(short value);
+        public static int ToInt32(int value);
+        public static int ToInt32(long value);
+        public static int ToInt32(object value);
+        public static int ToInt32(object value, IFormatProvider provider);
+        public static int ToInt32(sbyte value);
+        public static int ToInt32(float value);
+        public static int ToInt32(string value);
+        public static int ToInt32(string value, IFormatProvider provider);
+        public static int ToInt32(string value, int fromBase);
+        public static int ToInt32(ushort value);
+        public static int ToInt32(uint value);
+        public static int ToInt32(ulong value);
+        public static long ToInt64(bool value);
+        public static long ToInt64(byte value);
+        public static long ToInt64(char value);
+        public static long ToInt64(Decimal value);
+        public static long ToInt64(double value);
+        public static long ToInt64(short value);
+        public static long ToInt64(int value);
+        public static long ToInt64(long value);
+        public static long ToInt64(object value);
+        public static long ToInt64(object value, IFormatProvider provider);
+        public static long ToInt64(sbyte value);
+        public static long ToInt64(float value);
+        public static long ToInt64(string value);
+        public static long ToInt64(string value, IFormatProvider provider);
+        public static long ToInt64(string value, int fromBase);
+        public static long ToInt64(ushort value);
+        public static long ToInt64(uint value);
+        public static long ToInt64(ulong value);
+        public static sbyte ToSByte(bool value);
+        public static sbyte ToSByte(byte value);
+        public static sbyte ToSByte(char value);
+        public static sbyte ToSByte(Decimal value);
+        public static sbyte ToSByte(double value);
+        public static sbyte ToSByte(short value);
+        public static sbyte ToSByte(int value);
+        public static sbyte ToSByte(long value);
+        public static sbyte ToSByte(object value);
+        public static sbyte ToSByte(object value, IFormatProvider provider);
+        public static sbyte ToSByte(sbyte value);
+        public static sbyte ToSByte(float value);
+        public static sbyte ToSByte(string value);
+        public static sbyte ToSByte(string value, IFormatProvider provider);
+        public static sbyte ToSByte(string value, int fromBase);
+        public static sbyte ToSByte(ushort value);
+        public static sbyte ToSByte(uint value);
+        public static sbyte ToSByte(ulong value);
+        public static float ToSingle(bool value);
+        public static float ToSingle(byte value);
+        public static float ToSingle(char value);
+        public static float ToSingle(Decimal value);
+        public static float ToSingle(double value);
+        public static float ToSingle(short value);
+        public static float ToSingle(int value);
+        public static float ToSingle(long value);
+        public static float ToSingle(object value);
+        public static float ToSingle(object value, IFormatProvider provider);
+        public static float ToSingle(sbyte value);
+        public static float ToSingle(float value);
+        public static float ToSingle(string value);
+        public static float ToSingle(string value, IFormatProvider provider);
+        public static float ToSingle(ushort value);
+        public static float ToSingle(uint value);
+        public static float ToSingle(ulong value);
+        public static string ToString(bool value);
+        public static string ToString(bool value, IFormatProvider provider);
+        public static string ToString(byte value);
+        public static string ToString(byte value, IFormatProvider provider);
+        public static string ToString(byte value, int toBase);
+        public static string ToString(char value);
+        public static string ToString(char value, IFormatProvider provider);
+        public static string ToString(DateTime value);
+        public static string ToString(DateTime value, IFormatProvider provider);
+        public static string ToString(Decimal value);
+        public static string ToString(Decimal value, IFormatProvider provider);
+        public static string ToString(double value);
+        public static string ToString(double value, IFormatProvider provider);
+        public static string ToString(short value);
+        public static string ToString(short value, IFormatProvider provider);
+        public static string ToString(short value, int toBase);
+        public static string ToString(int value);
+        public static string ToString(int value, IFormatProvider provider);
+        public static string ToString(int value, int toBase);
+        public static string ToString(long value);
+        public static string ToString(long value, IFormatProvider provider);
+        public static string ToString(long value, int toBase);
+        public static string ToString(object value);
+        public static string ToString(object value, IFormatProvider provider);
+        public static string ToString(sbyte value);
+        public static string ToString(sbyte value, IFormatProvider provider);
+        public static string ToString(float value);
+        public static string ToString(float value, IFormatProvider provider);
+        public static string ToString(ushort value);
+        public static string ToString(ushort value, IFormatProvider provider);
+        public static string ToString(uint value);
+        public static string ToString(uint value, IFormatProvider provider);
+        public static string ToString(ulong value);
+        public static string ToString(ulong value, IFormatProvider provider);
+        public static ushort ToUInt16(bool value);
+        public static ushort ToUInt16(byte value);
+        public static ushort ToUInt16(char value);
+        public static ushort ToUInt16(Decimal value);
+        public static ushort ToUInt16(double value);
+        public static ushort ToUInt16(short value);
+        public static ushort ToUInt16(int value);
+        public static ushort ToUInt16(long value);
+        public static ushort ToUInt16(object value);
+        public static ushort ToUInt16(object value, IFormatProvider provider);
+        public static ushort ToUInt16(sbyte value);
+        public static ushort ToUInt16(float value);
+        public static ushort ToUInt16(string value);
+        public static ushort ToUInt16(string value, IFormatProvider provider);
+        public static ushort ToUInt16(string value, int fromBase);
+        public static ushort ToUInt16(ushort value);
+        public static ushort ToUInt16(uint value);
+        public static ushort ToUInt16(ulong value);
+        public static uint ToUInt32(bool value);
+        public static uint ToUInt32(byte value);
+        public static uint ToUInt32(char value);
+        public static uint ToUInt32(Decimal value);
+        public static uint ToUInt32(double value);
+        public static uint ToUInt32(short value);
+        public static uint ToUInt32(int value);
+        public static uint ToUInt32(long value);
+        public static uint ToUInt32(object value);
+        public static uint ToUInt32(object value, IFormatProvider provider);
+        public static uint ToUInt32(sbyte value);
+        public static uint ToUInt32(float value);
+        public static uint ToUInt32(string value);
+        public static uint ToUInt32(string value, IFormatProvider provider);
+        public static uint ToUInt32(string value, int fromBase);
+        public static uint ToUInt32(ushort value);
+        public static uint ToUInt32(uint value);
+        public static uint ToUInt32(ulong value);
+        public static ulong ToUInt64(bool value);
+        public static ulong ToUInt64(byte value);
+        public static ulong ToUInt64(char value);
+        public static ulong ToUInt64(Decimal value);
+        public static ulong ToUInt64(double value);
+        public static ulong ToUInt64(short value);
+        public static ulong ToUInt64(int value);
+        public static ulong ToUInt64(long value);
+        public static ulong ToUInt64(object value);
+        public static ulong ToUInt64(object value, IFormatProvider provider);
+        public static ulong ToUInt64(sbyte value);
+        public static ulong ToUInt64(float value);
+        public static ulong ToUInt64(string value);
+        public static ulong ToUInt64(string value, IFormatProvider provider);
+        public static ulong ToUInt64(string value, int fromBase);
+        public static ulong ToUInt64(ushort value);
+        public static ulong ToUInt64(uint value);
+        public static ulong ToUInt64(ulong value);
+    }
+    public delegate TOutput Converter<in TInput, out TOutput>(TInput input);
+    public sealed class DataMisalignedException : Exception {
+        public DataMisalignedException();
+        public DataMisalignedException(string message);
+        public DataMisalignedException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable {
+        public static readonly DateTime MaxValue;
+        public static readonly DateTime MinValue;
+        public DateTime(int year, int month, int day);
+        public DateTime(int year, int month, int day, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, DateTimeKind kind);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, DateTimeKind kind);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, DateTimeKind kind);
+        public DateTime(long ticks);
+        public DateTime(long ticks, DateTimeKind kind);
+        public DateTime Date { get; }
+        public int Day { get; }
+        public DayOfWeek DayOfWeek { get; }
+        public int DayOfYear { get; }
+        public int Hour { get; }
+        public DateTimeKind Kind { get; }
+        public int Millisecond { get; }
+        public int Minute { get; }
+        public int Month { get; }
+        public static DateTime Now { get; }
+        public int Second { get; }
+        public long Ticks { get; }
+        public TimeSpan TimeOfDay { get; }
+        public static DateTime Today { get; }
+        public static DateTime UtcNow { get; }
+        public int Year { get; }
+        public DateTime Add(TimeSpan value);
+        public DateTime AddDays(double value);
+        public DateTime AddHours(double value);
+        public DateTime AddMilliseconds(double value);
+        public DateTime AddMinutes(double value);
+        public DateTime AddMonths(int months);
+        public DateTime AddSeconds(double value);
+        public DateTime AddTicks(long value);
+        public DateTime AddYears(int value);
+        public static int Compare(DateTime t1, DateTime t2);
+        public int CompareTo(DateTime value);
+        public int CompareTo(object value);
+        public static int DaysInMonth(int year, int month);
+        public bool Equals(DateTime value);
+        public static bool Equals(DateTime t1, DateTime t2);
+        public override bool Equals(object value);
+        public static DateTime FromBinary(long dateData);
+        public static DateTime FromFileTime(long fileTime);
+        public static DateTime FromFileTimeUtc(long fileTime);
+        public static DateTime FromOADate(double d);
+        public string[] GetDateTimeFormats();
+        public string[] GetDateTimeFormats(char format);
+        public string[] GetDateTimeFormats(char format, IFormatProvider provider);
+        public string[] GetDateTimeFormats(IFormatProvider provider);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public bool IsDaylightSavingTime();
+        public static bool IsLeapYear(int year);
+        public static DateTime operator +(DateTime d, TimeSpan t);
+        public static bool operator ==(DateTime d1, DateTime d2);
+        public static bool operator >(DateTime t1, DateTime t2);
+        public static bool operator >=(DateTime t1, DateTime t2);
+        public static bool operator !=(DateTime d1, DateTime d2);
+        public static bool operator <(DateTime t1, DateTime t2);
+        public static bool operator <=(DateTime t1, DateTime t2);
+        public static TimeSpan operator -(DateTime d1, DateTime d2);
+        public static DateTime operator -(DateTime d, TimeSpan t);
+        public static DateTime Parse(string s);
+        public static DateTime Parse(string s, IFormatProvider provider);
+        public static DateTime Parse(string s, IFormatProvider provider, DateTimeStyles styles);
+        public static DateTime ParseExact(string s, string format, IFormatProvider provider);
+        public static DateTime ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style);
+        public static DateTime ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style);
+        public static DateTime SpecifyKind(DateTime value, DateTimeKind kind);
+        public TimeSpan Subtract(DateTime value);
+        public DateTime Subtract(TimeSpan value);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public long ToBinary();
+        public long ToFileTime();
+        public long ToFileTimeUtc();
+        public DateTime ToLocalTime();
+        public string ToLongDateString();
+        public string ToLongTimeString();
+        public double ToOADate();
+        public string ToShortDateString();
+        public string ToShortTimeString();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public DateTime ToUniversalTime();
+        public static bool TryParse(string s, out DateTime result);
+        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles styles, out DateTime result);
+        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateTime result);
+    }
+    public enum DateTimeKind {
+        Local = 2,
+        Unspecified = 0,
+        Utc = 1,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable {
+        public static readonly DateTimeOffset MaxValue;
+        public static readonly DateTimeOffset MinValue;
+        public DateTimeOffset(DateTime dateTime);
+        public DateTimeOffset(DateTime dateTime, TimeSpan offset);
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, TimeSpan offset);
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeSpan offset);
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, TimeSpan offset);
+        public DateTimeOffset(long ticks, TimeSpan offset);
+        public DateTime Date { get; }
+        public DateTime DateTime { get; }
+        public int Day { get; }
+        public DayOfWeek DayOfWeek { get; }
+        public int DayOfYear { get; }
+        public int Hour { get; }
+        public DateTime LocalDateTime { get; }
+        public int Millisecond { get; }
+        public int Minute { get; }
+        public int Month { get; }
+        public static DateTimeOffset Now { get; }
+        public TimeSpan Offset { get; }
+        public int Second { get; }
+        public long Ticks { get; }
+        public TimeSpan TimeOfDay { get; }
+        public DateTime UtcDateTime { get; }
+        public static DateTimeOffset UtcNow { get; }
+        public long UtcTicks { get; }
+        public int Year { get; }
+        public DateTimeOffset Add(TimeSpan timeSpan);
+        public DateTimeOffset AddDays(double days);
+        public DateTimeOffset AddHours(double hours);
+        public DateTimeOffset AddMilliseconds(double milliseconds);
+        public DateTimeOffset AddMinutes(double minutes);
+        public DateTimeOffset AddMonths(int months);
+        public DateTimeOffset AddSeconds(double seconds);
+        public DateTimeOffset AddTicks(long ticks);
+        public DateTimeOffset AddYears(int years);
+        public static int Compare(DateTimeOffset first, DateTimeOffset second);
+        public int CompareTo(DateTimeOffset other);
+        public bool Equals(DateTimeOffset other);
+        public static bool Equals(DateTimeOffset first, DateTimeOffset second);
+        public override bool Equals(object obj);
+        public bool EqualsExact(DateTimeOffset other);
+        public static DateTimeOffset FromFileTime(long fileTime);
+        public static DateTimeOffset FromUnixTimeMilliseconds(long milliseconds);
+        public static DateTimeOffset FromUnixTimeSeconds(long seconds);
+        public override int GetHashCode();
+        public static DateTimeOffset operator +(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
+        public static bool operator ==(DateTimeOffset left, DateTimeOffset right);
+        public static bool operator >(DateTimeOffset left, DateTimeOffset right);
+        public static bool operator >=(DateTimeOffset left, DateTimeOffset right);
+        public static implicit operator DateTimeOffset (DateTime dateTime);
+        public static bool operator !=(DateTimeOffset left, DateTimeOffset right);
+        public static bool operator <(DateTimeOffset left, DateTimeOffset right);
+        public static bool operator <=(DateTimeOffset left, DateTimeOffset right);
+        public static TimeSpan operator -(DateTimeOffset left, DateTimeOffset right);
+        public static DateTimeOffset operator -(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
+        public static DateTimeOffset Parse(string input);
+        public static DateTimeOffset Parse(string input, IFormatProvider formatProvider);
+        public static DateTimeOffset Parse(string input, IFormatProvider formatProvider, DateTimeStyles styles);
+        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider formatProvider);
+        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider formatProvider, DateTimeStyles styles);
+        public static DateTimeOffset ParseExact(string input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles);
+        public TimeSpan Subtract(DateTimeOffset value);
+        public DateTimeOffset Subtract(TimeSpan value);
+        int System.IComparable.CompareTo(object obj);
+        public long ToFileTime();
+        public DateTimeOffset ToLocalTime();
+        public DateTimeOffset ToOffset(TimeSpan offset);
+        public override string ToString();
+        public string ToString(IFormatProvider formatProvider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider formatProvider);
+        public DateTimeOffset ToUniversalTime();
+        public long ToUnixTimeMilliseconds();
+        public long ToUnixTimeSeconds();
+        public static bool TryParse(string input, out DateTimeOffset result);
+        public static bool TryParse(string input, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+    }
+    public enum DayOfWeek {
+        Friday = 5,
+        Monday = 1,
+        Saturday = 6,
+        Sunday = 0,
+        Thursday = 4,
+        Tuesday = 2,
+        Wednesday = 3,
+    }
+    public sealed class DBNull : IConvertible {
+        public static readonly DBNull Value;
+        public TypeCode GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Decimal : IComparable, IComparable<Decimal>, IConvertible, IEquatable<Decimal>, IFormattable {
+        public static readonly Decimal MaxValue;
+        public static readonly Decimal MinusOne;
+        public static readonly Decimal MinValue;
+        public static readonly Decimal One;
+        public static readonly Decimal Zero;
+        public Decimal(double value);
+        public Decimal(int value);
+        public Decimal(int lo, int mid, int hi, bool isNegative, byte scale);
+        public Decimal(int[] bits);
+        public Decimal(long value);
+        public Decimal(float value);
+        public Decimal(uint value);
+        public Decimal(ulong value);
+        public static Decimal Add(Decimal d1, Decimal d2);
+        public static Decimal Ceiling(Decimal d);
+        public static int Compare(Decimal d1, Decimal d2);
+        public int CompareTo(Decimal value);
+        public int CompareTo(object value);
+        public static Decimal Divide(Decimal d1, Decimal d2);
+        public bool Equals(Decimal value);
+        public static bool Equals(Decimal d1, Decimal d2);
+        public override bool Equals(object value);
+        public static Decimal Floor(Decimal d);
+        public static int[] GetBits(Decimal d);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static Decimal Multiply(Decimal d1, Decimal d2);
+        public static Decimal Negate(Decimal d);
+        public static Decimal operator +(Decimal d1, Decimal d2);
+        public static Decimal operator --(Decimal d);
+        public static Decimal operator /(Decimal d1, Decimal d2);
+        public static bool operator ==(Decimal d1, Decimal d2);
+        public static explicit operator byte (Decimal value);
+        public static explicit operator sbyte (Decimal value);
+        public static explicit operator char (Decimal value);
+        public static explicit operator short (Decimal value);
+        public static explicit operator ushort (Decimal value);
+        public static explicit operator int (Decimal value);
+        public static explicit operator uint (Decimal value);
+        public static explicit operator long (Decimal value);
+        public static explicit operator ulong (Decimal value);
+        public static explicit operator float (Decimal value);
+        public static explicit operator double (Decimal value);
+        public static explicit operator Decimal (double value);
+        public static explicit operator Decimal (float value);
+        public static bool operator >(Decimal d1, Decimal d2);
+        public static bool operator >=(Decimal d1, Decimal d2);
+        public static implicit operator Decimal (byte value);
+        public static implicit operator Decimal (char value);
+        public static implicit operator Decimal (short value);
+        public static implicit operator Decimal (int value);
+        public static implicit operator Decimal (long value);
+        public static implicit operator Decimal (sbyte value);
+        public static implicit operator Decimal (ushort value);
+        public static implicit operator Decimal (uint value);
+        public static implicit operator Decimal (ulong value);
+        public static Decimal operator ++(Decimal d);
+        public static bool operator !=(Decimal d1, Decimal d2);
+        public static bool operator <(Decimal d1, Decimal d2);
+        public static bool operator <=(Decimal d1, Decimal d2);
+        public static Decimal operator %(Decimal d1, Decimal d2);
+        public static Decimal operator *(Decimal d1, Decimal d2);
+        public static Decimal operator -(Decimal d1, Decimal d2);
+        public static Decimal operator -(Decimal d);
+        public static Decimal operator +(Decimal d);
+        public static Decimal Parse(string s);
+        public static Decimal Parse(string s, NumberStyles style);
+        public static Decimal Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static Decimal Parse(string s, IFormatProvider provider);
+        public static Decimal Remainder(Decimal d1, Decimal d2);
+        public static decimal Round(decimal d, int decimals);
+        public static Decimal Subtract(Decimal d1, Decimal d2);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public static byte ToByte(Decimal value);
+        public static double ToDouble(Decimal d);
+        public static short ToInt16(Decimal value);
+        public static int ToInt32(Decimal d);
+        public static long ToInt64(Decimal d);
+        public static sbyte ToSByte(Decimal value);
+        public static float ToSingle(Decimal d);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static ushort ToUInt16(Decimal value);
+        public static uint ToUInt32(Decimal d);
+        public static ulong ToUInt64(Decimal d);
+        public static Decimal Truncate(Decimal d);
+        public static bool TryParse(string s, out Decimal result);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Decimal result);
+    }
+    public abstract class Delegate {
+        protected Delegate(object target, string method);
+        protected Delegate(Type target, string method);
+        public MethodInfo Method { get; }
+        public object Target { get; }
+        public static Delegate Combine(Delegate a, Delegate b);
+        public static Delegate Combine(params Delegate[] delegates);
+        protected virtual Delegate CombineImpl(Delegate d);
+        public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method);
+        [MethodImpl(NoInlining)]public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, object target, string method);
+        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase);
+        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, MethodInfo method);
+        [MethodImpl(NoInlining)]public static Delegate CreateDelegate(Type type, MethodInfo method, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, Type target, string method);
+        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase);
+        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase, bool throwOnBindFailure);
+        public object DynamicInvoke(params object[] args);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public virtual Delegate[] GetInvocationList();
+        public static bool operator ==(Delegate d1, Delegate d2);
+        public static bool operator !=(Delegate d1, Delegate d2);
+        public static Delegate Remove(Delegate source, Delegate value);
+        public static Delegate RemoveAll(Delegate source, Delegate value);
+        protected virtual Delegate RemoveImpl(Delegate d);
+    }
+    public class DivideByZeroException : ArithmeticException {
+        public DivideByZeroException();
+        public DivideByZeroException(string message);
+        public DivideByZeroException(string message, Exception innerException);
+    }
+    public class DllNotFoundException : TypeLoadException {
+        public DllNotFoundException();
+        public DllNotFoundException(string message);
+        public DllNotFoundException(string message, Exception inner);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable {
+        public const double Epsilon = 4.94065645841247E-324;
+        public const double MaxValue = 1.7976931348623157E+308;
+        public const double MinValue = -1.7976931348623157E+308;
+        public const double NaN = 0.0 / 0.0;
+        public const double NegativeInfinity = -1.0 / 0.0;
+        public const double PositiveInfinity = 1.0 / 0.0;
+        public int CompareTo(double value);
+        public int CompareTo(object value);
+        public bool Equals(double obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static bool IsInfinity(double d);
+        public static bool IsNaN(double d);
+        public static bool IsNegativeInfinity(double d);
+        public static bool IsPositiveInfinity(double d);
+        public static bool operator ==(double left, double right);
+        public static bool operator >(double left, double right);
+        public static bool operator >=(double left, double right);
+        public static bool operator !=(double left, double right);
+        public static bool operator <(double left, double right);
+        public static bool operator <=(double left, double right);
+        public static double Parse(string s);
+        public static double Parse(string s, NumberStyles style);
+        public static double Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static double Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, out double result);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out double result);
+    }
+    public class EntryPointNotFoundException : TypeLoadException {
+        public EntryPointNotFoundException();
+        public EntryPointNotFoundException(string message);
+        public EntryPointNotFoundException(string message, Exception inner);
+    }
+    public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+        protected Enum();
+        public int CompareTo(object target);
+        public override bool Equals(object obj);
+        public static string Format(Type enumType, object value, string format);
+        public override int GetHashCode();
+        public static string GetName(Type enumType, object value);
+        public static string[] GetNames(Type enumType);
+        public TypeCode GetTypeCode();
+        public static Type GetUnderlyingType(Type enumType);
+        public static Array GetValues(Type enumType);
+        public bool HasFlag(Enum flag);
+        public static bool IsDefined(Type enumType, object value);
+        public static object Parse(Type enumType, string value);
+        public static object Parse(Type enumType, string value, bool ignoreCase);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        string System.IConvertible.ToString(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        string System.IFormattable.ToString(string format, IFormatProvider provider);
+        public static object ToObject(Type enumType, object value);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse<TEnum>(string value, bool ignoreCase, out TEnum result) where TEnum : struct, ValueType;
+        public static bool TryParse<TEnum>(string value, out TEnum result) where TEnum : struct, ValueType;
+    }
+    public static class Environment {
+        public static int CurrentManagedThreadId { get; }
+        public static int ExitCode { [MethodImpl(InternalCall)]get; [MethodImpl(InternalCall)]set; }
+        public static bool HasShutdownStarted { get; }
+        public static string MachineName { get; }
+        public static string NewLine { get; }
+        public static OperatingSystem OSVersion { get; }
+        public static int ProcessorCount { get; }
+        public static string StackTrace { get; }
+        public static int TickCount { get; }
+        public static Version Version { get; }
+        public static void Exit(int exitCode);
+        public static string ExpandEnvironmentVariables(string name);
+        public static void FailFast(string message);
+        public static void FailFast(string message, Exception exception);
+        public static string[] GetCommandLineArgs();
+        public static string GetEnvironmentVariable(string variable);
+        public static IDictionary GetEnvironmentVariables();
+        public static void SetEnvironmentVariable(string variable, string value);
+    }
+    public class EventArgs {
+        public static readonly EventArgs Empty;
+        public EventArgs();
+    }
+    public delegate void EventHandler(object sender, EventArgs e);
+    public delegate void EventHandler<TEventArgs>(object sender, TEventArgs e);
+    public class Exception {
+        public Exception();
+        public Exception(string message);
+        public Exception(string message, Exception innerException);
+        public virtual IDictionary Data { get; }
+        public virtual string HelpLink { get; set; }
+        public int HResult { get; protected set; }
+        public Exception InnerException { get; }
+        public virtual string Message { get; }
+        public virtual string Source { get; set; }
+        public virtual string StackTrace { get; }
+        public virtual Exception GetBaseException();
+        public override string ToString();
+    }
+    public sealed class ExecutionEngineException : SystemException
+    public class FieldAccessException : MemberAccessException {
+        public FieldAccessException();
+        public FieldAccessException(string message);
+        public FieldAccessException(string message, Exception inner);
+    }
+    public class FlagsAttribute : Attribute {
+        public FlagsAttribute();
+    }
+    public class FormatException : Exception {
+        public FormatException();
+        public FormatException(string message);
+        public FormatException(string message, Exception innerException);
+    }
+    public abstract class FormattableString : IFormattable {
+        protected FormattableString();
+        public abstract int ArgumentCount { get; }
+        public abstract string Format { get; }
+        public abstract object GetArgument(int index);
+        public abstract object[] GetArguments();
+        public static string Invariant(FormattableString formattable);
+        string System.IFormattable.ToString(string ignored, IFormatProvider formatProvider);
+        public override string ToString();
+        public abstract string ToString(IFormatProvider formatProvider);
+    }
+    public delegate TResult Func<out TResult>();
+    public delegate TResult Func<in T, out TResult>(T arg);
+    public delegate TResult Func<in T1, in T2, out TResult>(T1 arg1, T2 arg2);
+    public delegate TResult Func<in T1, in T2, in T3, out TResult>(T1 arg1, T2 arg2, T3 arg3);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15);
+    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, in T16, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15, T16 arg16);
+    public static class GC {
+        public static int MaxGeneration { get; }
+        public static void AddMemoryPressure(long bytesAllocated);
+        public static void Collect();
+        public static void Collect(int generation);
+        public static void Collect(int generation, GCCollectionMode mode);
+        public static void Collect(int generation, GCCollectionMode mode, bool blocking);
+        public static void Collect(int generation, GCCollectionMode mode, bool blocking, bool compacting);
+        public static int CollectionCount(int generation);
+        public static int GetGeneration(object obj);
+        public static long GetTotalMemory(bool forceFullCollection);
+        public static void KeepAlive(object obj);
+        public static void RemoveMemoryPressure(long bytesAllocated);
+        public static void ReRegisterForFinalize(object obj);
+        public static void SuppressFinalize(object obj);
+        public static void WaitForPendingFinalizers();
+    }
+    public enum GCCollectionMode {
+        Default = 0,
+        Forced = 1,
+        Optimized = 2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
+        public static readonly Guid Empty;
+        public Guid(byte[] b);
+        public Guid(int a, short b, short c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
+        public Guid(int a, short b, short c, byte[] d);
+        public Guid(string g);
+        public Guid(uint a, ushort b, ushort c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
+        public int CompareTo(Guid value);
+        public int CompareTo(object value);
+        public bool Equals(Guid g);
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public static Guid NewGuid();
+        public static bool operator ==(Guid a, Guid b);
+        public static bool operator !=(Guid a, Guid b);
+        public static Guid Parse(string input);
+        public static Guid ParseExact(string input, string format);
+        int System.IComparable.CompareTo(object value);
+        string System.IFormattable.ToString(string format, IFormatProvider provider);
+        public byte[] ToByteArray();
+        public override string ToString();
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string input, out Guid result);
+        public static bool TryParseExact(string input, string format, out Guid result);
+    }
+    public interface IAsyncResult {
+        object AsyncState { get; }
+        WaitHandle AsyncWaitHandle { get; }
+        bool CompletedSynchronously { get; }
+        bool IsCompleted { get; }
+    }
+    public interface IComparable {
+        int CompareTo(object obj);
+    }
+    public interface IComparable<in T> {
+        int CompareTo(T other);
+    }
+    public interface IConvertible {
+        TypeCode GetTypeCode();
+        bool ToBoolean(IFormatProvider provider);
+        byte ToByte(IFormatProvider provider);
+        char ToChar(IFormatProvider provider);
+        DateTime ToDateTime(IFormatProvider provider);
+        Decimal ToDecimal(IFormatProvider provider);
+        double ToDouble(IFormatProvider provider);
+        short ToInt16(IFormatProvider provider);
+        int ToInt32(IFormatProvider provider);
+        long ToInt64(IFormatProvider provider);
+        sbyte ToSByte(IFormatProvider provider);
+        float ToSingle(IFormatProvider provider);
+        string ToString(IFormatProvider provider);
+        object ToType(Type conversionType, IFormatProvider provider);
+        ushort ToUInt16(IFormatProvider provider);
+        uint ToUInt32(IFormatProvider provider);
+        ulong ToUInt64(IFormatProvider provider);
+    }
+    public interface ICustomFormatter {
+        string Format(string format, object arg, IFormatProvider formatProvider);
+    }
+    public interface IDisposable {
+        void Dispose();
+    }
+    public interface IEquatable<T> {
+        bool Equals(T other);
+    }
+    public interface IFormatProvider {
+        object GetFormat(Type formatType);
+    }
+    public interface IFormattable {
+        string ToString(string format, IFormatProvider formatProvider);
+    }
+    public sealed class IndexOutOfRangeException : Exception {
+        public IndexOutOfRangeException();
+        public IndexOutOfRangeException(string message);
+        public IndexOutOfRangeException(string message, Exception innerException);
+    }
+    public sealed class InsufficientExecutionStackException : Exception {
+        public InsufficientExecutionStackException();
+        public InsufficientExecutionStackException(string message);
+        public InsufficientExecutionStackException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable {
+        public const short MaxValue = (short)32767;
+        public const short MinValue = (short)-32768;
+        public int CompareTo(short value);
+        public int CompareTo(object value);
+        public bool Equals(short obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static short Parse(string s);
+        public static short Parse(string s, NumberStyles style);
+        public static short Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static short Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out short result);
+        public static bool TryParse(string s, out short result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable {
+        public const int MaxValue = 2147483647;
+        public const int MinValue = -2147483648;
+        public int CompareTo(int value);
+        public int CompareTo(object value);
+        public bool Equals(int obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static int Parse(string s);
+        public static int Parse(string s, NumberStyles style);
+        public static int Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static int Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out int result);
+        public static bool TryParse(string s, out int result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable {
+        public const long MaxValue = (long)9223372036854775807;
+        public const long MinValue = (long)-9223372036854775808;
+        public int CompareTo(long value);
+        public int CompareTo(object value);
+        public bool Equals(long obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static long Parse(string s);
+        public static long Parse(string s, NumberStyles style);
+        public static long Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static long Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out long result);
+        public static bool TryParse(string s, out long result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct IntPtr {
+        public static readonly IntPtr Zero;
+        public IntPtr(int value);
+        public IntPtr(long value);
+        public unsafe IntPtr(void* value);
+        public static int Size { get; }
+        public static IntPtr Add(IntPtr pointer, int offset);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static IntPtr operator +(IntPtr pointer, int offset);
+        public static bool operator ==(IntPtr value1, IntPtr value2);
+        public static explicit operator IntPtr (int value);
+        public static explicit operator IntPtr (long value);
+        public unsafe static explicit operator void* (IntPtr value);
+        public static explicit operator int (IntPtr value);
+        public static explicit operator long (IntPtr value);
+        public unsafe static explicit operator IntPtr (void* value);
+        public static bool operator !=(IntPtr value1, IntPtr value2);
+        public static IntPtr operator -(IntPtr pointer, int offset);
+        public static IntPtr Subtract(IntPtr pointer, int offset);
+        public int ToInt32();
+        public long ToInt64();
+        public unsafe void* ToPointer();
+        public override string ToString();
+        public string ToString(string format);
+    }
+    public class InvalidCastException : Exception {
+        public InvalidCastException();
+        public InvalidCastException(string message);
+        public InvalidCastException(string message, Exception innerException);
+        public InvalidCastException(string message, int errorCode);
+    }
+    public class InvalidOperationException : Exception {
+        public InvalidOperationException();
+        public InvalidOperationException(string message);
+        public InvalidOperationException(string message, Exception innerException);
+    }
+    public sealed class InvalidProgramException : Exception {
+        public InvalidProgramException();
+        public InvalidProgramException(string message);
+        public InvalidProgramException(string message, Exception inner);
+    }
+    public class InvalidTimeZoneException : Exception {
+        public InvalidTimeZoneException();
+        public InvalidTimeZoneException(string message);
+        public InvalidTimeZoneException(string message, Exception innerException);
+    }
+    public interface IObservable<out T> {
+        IDisposable Subscribe(IObserver<T> observer);
+    }
+    public interface IObserver<in T> {
+        void OnCompleted();
+        void OnError(Exception error);
+        void OnNext(T value);
+    }
+    public interface IProgress<in T> {
+        void Report(T value);
+    }
+    public interface IServiceProvider {
+        object GetService(Type serviceType);
+    }
+    public class Lazy<T> {
+        public Lazy();
+        public Lazy(bool isThreadSafe);
+        public Lazy(Func<T> valueFactory);
+        public Lazy(Func<T> valueFactory, bool isThreadSafe);
+        public Lazy(Func<T> valueFactory, LazyThreadSafetyMode mode);
+        public Lazy(LazyThreadSafetyMode mode);
+        public bool IsValueCreated { get; }
+        public T Value { get; }
+        public override string ToString();
+    }
+    public class Lazy<T, TMetadata> : Lazy<T> {
+        public Lazy(Func<T> valueFactory, TMetadata metadata);
+        public Lazy(Func<T> valueFactory, TMetadata metadata, bool isThreadSafe);
+        public Lazy(Func<T> valueFactory, TMetadata metadata, LazyThreadSafetyMode mode);
+        public Lazy(TMetadata metadata);
+        public Lazy(TMetadata metadata, bool isThreadSafe);
+        public Lazy(TMetadata metadata, LazyThreadSafetyMode mode);
+        public TMetadata Metadata { get; }
+    }
+    public static class Math {
+        public const double E = 2.7182818284590451;
+        public const double PI = 3.1415926535897931;
+        public static Decimal Abs(Decimal value);
+        public static double Abs(double value);
+        public static short Abs(short value);
+        public static int Abs(int value);
+        public static long Abs(long value);
+        public static sbyte Abs(sbyte value);
+        public static float Abs(float value);
+        public static double Acos(double d);
+        public static double Asin(double d);
+        public static double Atan(double d);
+        public static double Atan2(double y, double x);
+        public static Decimal Ceiling(Decimal d);
+        public static double Ceiling(double a);
+        public static double Cos(double d);
+        public static double Cosh(double value);
+        public static double Exp(double d);
+        public static Decimal Floor(Decimal d);
+        public static double Floor(double d);
+        public static double IEEERemainder(double x, double y);
+        public static double Log(double d);
+        public static double Log(double a, double newBase);
+        public static double Log10(double d);
+        public static byte Max(byte val1, byte val2);
+        public static Decimal Max(Decimal val1, Decimal val2);
+        public static double Max(double val1, double val2);
+        public static short Max(short val1, short val2);
+        public static int Max(int val1, int val2);
+        public static long Max(long val1, long val2);
+        public static sbyte Max(sbyte val1, sbyte val2);
+        public static float Max(float val1, float val2);
+        public static ushort Max(ushort val1, ushort val2);
+        public static uint Max(uint val1, uint val2);
+        public static ulong Max(ulong val1, ulong val2);
+        public static byte Min(byte val1, byte val2);
+        public static Decimal Min(Decimal val1, Decimal val2);
+        public static double Min(double val1, double val2);
+        public static short Min(short val1, short val2);
+        public static int Min(int val1, int val2);
+        public static long Min(long val1, long val2);
+        public static sbyte Min(sbyte val1, sbyte val2);
+        public static float Min(float val1, float val2);
+        public static ushort Min(ushort val1, ushort val2);
+        public static uint Min(uint val1, uint val2);
+        public static ulong Min(ulong val1, ulong val2);
+        public static double Pow(double x, double y);
+        public static Decimal Round(Decimal d);
+        public static Decimal Round(Decimal d, int decimals);
+        public static Decimal Round(Decimal d, int decimals, MidpointRounding mode);
+        public static Decimal Round(Decimal d, MidpointRounding mode);
+        public static double Round(double a);
+        public static double Round(double value, int digits);
+        public static double Round(double value, int digits, MidpointRounding mode);
+        public static double Round(double value, MidpointRounding mode);
+        public static int Sign(Decimal value);
+        public static int Sign(double value);
+        public static int Sign(short value);
+        public static int Sign(int value);
+        public static int Sign(long value);
+        public static int Sign(sbyte value);
+        public static int Sign(float value);
+        public static double Sin(double a);
+        public static double Sinh(double value);
+        public static double Sqrt(double d);
+        public static double Tan(double a);
+        public static double Tanh(double value);
+        public static Decimal Truncate(Decimal d);
+        public static double Truncate(double d);
+    }
+    public class MemberAccessException : Exception {
+        public MemberAccessException();
+        public MemberAccessException(string message);
+        public MemberAccessException(string message, Exception inner);
+    }
+    public class MethodAccessException : MemberAccessException {
+        public MethodAccessException();
+        public MethodAccessException(string message);
+        public MethodAccessException(string message, Exception inner);
+    }
+    public enum MidpointRounding {
+        AwayFromZero = 1,
+        ToEven = 0,
+    }
+    public class MissingFieldException : MissingMemberException {
+        public MissingFieldException();
+        public MissingFieldException(string message);
+        public MissingFieldException(string message, Exception inner);
+        public override string Message { get; }
+    }
+    public class MissingMemberException : MemberAccessException {
+        public MissingMemberException();
+        public MissingMemberException(string message);
+        public MissingMemberException(string message, Exception inner);
+        public override string Message { get; }
+    }
+    public class MissingMethodException : MissingMemberException {
+        public MissingMethodException();
+        public MissingMethodException(string message);
+        public MissingMethodException(string message, Exception inner);
+        public override string Message { get; }
+    }
+    public sealed class MTAThreadAttribute : Attribute {
+        public MTAThreadAttribute();
+    }
+    public abstract class MulticastDelegate : Delegate {
+        protected MulticastDelegate(object target, string method);
+        protected sealed override Delegate CombineImpl(Delegate follow);
+        public sealed override bool Equals(object obj);
+        public sealed override int GetHashCode();
+        public sealed override Delegate[] GetInvocationList();
+        public static bool operator ==(MulticastDelegate d1, MulticastDelegate d2);
+        public static bool operator !=(MulticastDelegate d1, MulticastDelegate d2);
+        protected sealed override Delegate RemoveImpl(Delegate value);
+    }
+    public sealed class MulticastNotSupportedException : SystemException {
+        public MulticastNotSupportedException();
+        public MulticastNotSupportedException(string message);
+        public MulticastNotSupportedException(string message, Exception inner);
+    }
+    public class NotFiniteNumberException : ArithmeticException {
+        public NotFiniteNumberException();
+        public NotFiniteNumberException(string message);
+        public NotFiniteNumberException(string message, Exception innerException);
+    }
+    public class NotImplementedException : Exception {
+        public NotImplementedException();
+        public NotImplementedException(string message);
+        public NotImplementedException(string message, Exception inner);
+    }
+    public class NotSupportedException : Exception {
+        public NotSupportedException();
+        public NotSupportedException(string message);
+        public NotSupportedException(string message, Exception innerException);
+    }
+    public static class Nullable {
+        public static int Compare<T>(Nullable<T> n1, Nullable<T> n2) where T : struct, ValueType;
+        public static bool Equals<T>(Nullable<T> n1, Nullable<T> n2) where T : struct, ValueType;
+        public static Type GetUnderlyingType(Type nullableType);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Nullable<T> where T : struct, ValueType {
+        public Nullable(T value);
+        public bool HasValue { get; }
+        public T Value { get; }
+        public override bool Equals(object other);
+        public override int GetHashCode();
+        public T GetValueOrDefault();
+        public T GetValueOrDefault(T defaultValue);
+        public static explicit operator T (Nullable<T> value);
+        public static implicit operator Nullable<T> (T value);
+        public override string ToString();
+    }
+    public class NullReferenceException : Exception {
+        public NullReferenceException();
+        public NullReferenceException(string message);
+        public NullReferenceException(string message, Exception innerException);
+    }
+    public class Object {
+        public Object();
+        public virtual bool Equals(object obj);
+        public static bool Equals(object objA, object objB);
+        ~Object();
+        public virtual int GetHashCode();
+        public Type GetType();
+        protected object MemberwiseClone();
+        public static bool ReferenceEquals(object objA, object objB);
+        public virtual string ToString();
+    }
+    public class ObjectDisposedException : InvalidOperationException {
+        public ObjectDisposedException(string objectName);
+        public ObjectDisposedException(string message, Exception innerException);
+        public ObjectDisposedException(string objectName, string message);
+        public override string Message { get; }
+        public string ObjectName { get; }
+    }
+    public sealed class ObsoleteAttribute : Attribute {
+        public ObsoleteAttribute();
+        public ObsoleteAttribute(string message);
+        public ObsoleteAttribute(string message, bool error);
+        public bool IsError { get; }
+        public string Message { get; }
+    }
+    public sealed class OperatingSystem {
+        public OperatingSystem(PlatformID platform, Version version);
+        public PlatformID Platform { get; }
+        public Version Version { get; }
+        public object Clone();
+        public override string ToString();
+    }
+    public class OperationCanceledException : Exception {
+        public OperationCanceledException();
+        public OperationCanceledException(string message);
+        public OperationCanceledException(string message, Exception innerException);
+        public OperationCanceledException(string message, Exception innerException, CancellationToken token);
+        public OperationCanceledException(string message, CancellationToken token);
+        public OperationCanceledException(CancellationToken token);
+        public CancellationToken CancellationToken { get; }
+    }
+    public class OutOfMemoryException : Exception {
+        public OutOfMemoryException();
+        public OutOfMemoryException(string message);
+        public OutOfMemoryException(string message, Exception innerException);
+    }
+    public class OverflowException : ArithmeticException {
+        public OverflowException();
+        public OverflowException(string message);
+        public OverflowException(string message, Exception innerException);
+    }
+    public sealed class ParamArrayAttribute : Attribute {
+        public ParamArrayAttribute();
+    }
+    public enum PlatformID {
+        MacOSX = 6,
+        Unix = 4,
+        Win32NT = 2,
+        Win32S = 0,
+        Win32Windows = 1,
+        WinCE = 3,
+        Xbox = 5,
+    }
+    public class PlatformNotSupportedException : NotSupportedException {
+        public PlatformNotSupportedException();
+        public PlatformNotSupportedException(string message);
+        public PlatformNotSupportedException(string message, Exception inner);
+    }
+    public delegate bool Predicate<in T>(T obj);
+    public class Progress<T> : IProgress<T> {
+        public Progress();
+        public Progress(Action<T> handler);
+        public event EventHandler<T> ProgressChanged;
+        protected virtual void OnReport(T value);
+        void System.IProgress<T>.Report(T value);
+    }
+    public class Random {
+        public Random();
+        public Random(int Seed);
+        public virtual int Next();
+        public virtual int Next(int maxValue);
+        public virtual int Next(int minValue, int maxValue);
+        public virtual void NextBytes(byte[] buffer);
+        public virtual double NextDouble();
+        protected virtual double Sample();
+    }
+    public class RankException : Exception {
+        public RankException();
+        public RankException(string message);
+        public RankException(string message, Exception innerException);
+    }
+    public class ResolveEventArgs : EventArgs {
+        public ResolveEventArgs(string name);
+        public ResolveEventArgs(string name, Assembly requestingAssembly);
+        public string Name { get; }
+        public Assembly RequestingAssembly { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct RuntimeArgumentHandle
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct RuntimeFieldHandle {
+        public override bool Equals(object obj);
+        public bool Equals(RuntimeFieldHandle handle);
+        public override int GetHashCode();
+        public static bool operator ==(RuntimeFieldHandle left, RuntimeFieldHandle right);
+        public static bool operator !=(RuntimeFieldHandle left, RuntimeFieldHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct RuntimeMethodHandle {
+        public IntPtr Value { get; }
+        public override bool Equals(object obj);
+        public bool Equals(RuntimeMethodHandle handle);
+        public override int GetHashCode();
+        public static bool operator ==(RuntimeMethodHandle left, RuntimeMethodHandle right);
+        public static bool operator !=(RuntimeMethodHandle left, RuntimeMethodHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct RuntimeTypeHandle {
+        public IntPtr Value { get; }
+        public override bool Equals(object obj);
+        public bool Equals(RuntimeTypeHandle handle);
+        public override int GetHashCode();
+        public static bool operator ==(object left, RuntimeTypeHandle right);
+        public static bool operator ==(RuntimeTypeHandle left, object right);
+        public static bool operator !=(object left, RuntimeTypeHandle right);
+        public static bool operator !=(RuntimeTypeHandle left, object right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable {
+        public const sbyte MaxValue = (sbyte)127;
+        public const sbyte MinValue = (sbyte)-128;
+        public int CompareTo(object obj);
+        public int CompareTo(sbyte value);
+        public override bool Equals(object obj);
+        public bool Equals(sbyte obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static sbyte Parse(string s);
+        public static sbyte Parse(string s, NumberStyles style);
+        public static sbyte Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static sbyte Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object obj);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out sbyte result);
+        public static bool TryParse(string s, out sbyte result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable {
+        public const float Epsilon = 1.401298E-45f;
+        public const float MaxValue = 3.40282347E+38f;
+        public const float MinValue = -3.40282347E+38f;
+        public const float NaN = 0.0f / 0.0f;
+        public const float NegativeInfinity = -1.0f / 0.0f;
+        public const float PositiveInfinity = 1.0f / 0.0f;
+        public int CompareTo(object value);
+        public int CompareTo(float value);
+        public override bool Equals(object obj);
+        public bool Equals(float obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static bool IsInfinity(float f);
+        public static bool IsNaN(float f);
+        public static bool IsNegativeInfinity(float f);
+        public static bool IsPositiveInfinity(float f);
+        public static bool operator ==(float left, float right);
+        public static bool operator >(float left, float right);
+        public static bool operator >=(float left, float right);
+        public static bool operator !=(float left, float right);
+        public static bool operator <(float left, float right);
+        public static bool operator <=(float left, float right);
+        public static float Parse(string s);
+        public static float Parse(string s, NumberStyles style);
+        public static float Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static float Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out float result);
+        public static bool TryParse(string s, out float result);
+    }
+    public sealed class StackOverflowException : SystemException {
+        public StackOverflowException();
+        public StackOverflowException(string message);
+        public StackOverflowException(string message, Exception innerException);
+    }
+    public sealed class STAThreadAttribute : Attribute {
+        public STAThreadAttribute();
+    }
+    public sealed class String : IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public static readonly string Empty;
+        public unsafe String(char* value);
+        public unsafe String(char* value, int startIndex, int length);
+        public String(char c, int count);
+        public String(char[] value);
+        public String(char[] value, int startIndex, int length);
+        [MethodImpl(InternalCall)]public unsafe String(sbyte* value);
+        public int Length { get; }
+        [System.Runtime.CompilerServices.IndexerName("Chars")]
+        public char this[int index] { get; }
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length);
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length, CultureInfo culture, CompareOptions options);
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length, StringComparison comparisonType);
+        public static int Compare(string strA, string strB);
+        public static int Compare(string strA, string strB, bool ignoreCase);
+        public static int Compare(string strA, string strB, CultureInfo culture, CompareOptions options);
+        public static int Compare(string strA, string strB, StringComparison comparisonType);
+        public static int CompareOrdinal(string strA, int indexA, string strB, int indexB, int length);
+        public static int CompareOrdinal(string strA, string strB);
+        public int CompareTo(object value);
+        public int CompareTo(string strB);
+        public static string Concat(IEnumerable<string> values);
+        public static string Concat(object arg0);
+        public static string Concat(object arg0, object arg1);
+        public static string Concat(object arg0, object arg1, object arg2);
+        public static string Concat(params object[] args);
+        public static string Concat(string str0, string str1);
+        public static string Concat(string str0, string str1, string str2);
+        public static string Concat(string str0, string str1, string str2, string str3);
+        public static string Concat(params string[] values);
+        public static string Concat<T>(IEnumerable<T> values);
+        public bool Contains(string value);
+        public static string Copy(string str);
+        public void CopyTo(int sourceIndex, char[] destination, int destinationIndex, int count);
+        public bool EndsWith(string value);
+        public bool EndsWith(string value, StringComparison comparisonType);
+        public override bool Equals(object obj);
+        public bool Equals(string value);
+        public static bool Equals(string a, string b);
+        public static bool Equals(string a, string b, StringComparison comparisonType);
+        public bool Equals(string value, StringComparison comparisonType);
+        public static string Format(IFormatProvider provider, string format, object arg0);
+        public static string Format(IFormatProvider provider, string format, object arg0, object arg1);
+        public static string Format(IFormatProvider provider, string format, object arg0, object arg1, object arg2);
+        public static string Format(IFormatProvider provider, string format, params object[] args);
+        public static string Format(string format, object arg0);
+        public static string Format(string format, object arg0, object arg1);
+        public static string Format(string format, object arg0, object arg1, object arg2);
+        public static string Format(string format, params object[] args);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public int IndexOf(char value);
+        public int IndexOf(char value, int startIndex);
+        public int IndexOf(char value, int startIndex, int count);
+        public int IndexOf(string value);
+        public int IndexOf(string value, int startIndex);
+        public int IndexOf(string value, int startIndex, int count);
+        public int IndexOf(string value, int startIndex, int count, StringComparison comparisonType);
+        public int IndexOf(string value, int startIndex, StringComparison comparisonType);
+        public int IndexOf(string value, StringComparison comparisonType);
+        public int IndexOfAny(char[] anyOf);
+        public int IndexOfAny(char[] anyOf, int startIndex);
+        public int IndexOfAny(char[] anyOf, int startIndex, int count);
+        public string Insert(int startIndex, string value);
+        public static string Intern(string str);
+        public static string IsInterned(string str);
+        public static bool IsNullOrEmpty(string value);
+        public static bool IsNullOrWhiteSpace(string value);
+        public static string Join(string separator, IEnumerable<string> values);
+        public static string Join(string separator, params object[] values);
+        public static string Join(string separator, params string[] value);
+        public static string Join(string separator, string[] value, int startIndex, int count);
+        public static string Join<T>(string separator, IEnumerable<T> values);
+        public int LastIndexOf(char value);
+        public int LastIndexOf(char value, int startIndex);
+        public int LastIndexOf(char value, int startIndex, int count);
+        public int LastIndexOf(string value);
+        public int LastIndexOf(string value, int startIndex);
+        public int LastIndexOf(string value, int startIndex, int count);
+        public int LastIndexOf(string value, int startIndex, int count, StringComparison comparisonType);
+        public int LastIndexOf(string value, int startIndex, StringComparison comparisonType);
+        public int LastIndexOf(string value, StringComparison comparisonType);
+        public int LastIndexOfAny(char[] anyOf);
+        public int LastIndexOfAny(char[] anyOf, int startIndex);
+        public int LastIndexOfAny(char[] anyOf, int startIndex, int count);
+        public static bool operator ==(string a, string b);
+        public static bool operator !=(string a, string b);
+        public string PadLeft(int totalWidth);
+        public string PadLeft(int totalWidth, char paddingChar);
+        public string PadRight(int totalWidth);
+        public string PadRight(int totalWidth, char paddingChar);
+        public string Remove(int startIndex);
+        public string Remove(int startIndex, int count);
+        public string Replace(char oldChar, char newChar);
+        public string Replace(string oldValue, string newValue);
+        public string[] Split(params char[] separator);
+        public string[] Split(char[] separator, int count);
+        public string[] Split(char[] separator, int count, StringSplitOptions options);
+        public string[] Split(char[] separator, StringSplitOptions options);
+        public string[] Split(string[] separator, int count, StringSplitOptions options);
+        public string[] Split(string[] separator, StringSplitOptions options);
+        public bool StartsWith(string value);
+        public bool StartsWith(string value, StringComparison comparisonType);
+        public string Substring(int startIndex);
+        public string Substring(int startIndex, int length);
+        IEnumerator<char> System.Collections.Generic.IEnumerable<System.Char>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        string System.IConvertible.ToString(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public char[] ToCharArray();
+        public char[] ToCharArray(int startIndex, int length);
+        public string ToLower();
+        public string ToLower(CultureInfo culture);
+        public string ToLowerInvariant();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToUpper();
+        public string ToUpper(CultureInfo culture);
+        public string ToUpperInvariant();
+        public string Trim();
+        public string Trim(params char[] trimChars);
+        public string TrimEnd(params char[] trimChars);
+        public string TrimStart(params char[] trimChars);
+    }
+    public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        protected StringComparer();
+        public static StringComparer CurrentCulture { get; }
+        public static StringComparer CurrentCultureIgnoreCase { get; }
+        public static StringComparer InvariantCulture { get; }
+        public static StringComparer InvariantCultureIgnoreCase { get; }
+        public static StringComparer Ordinal { get; }
+        public static StringComparer OrdinalIgnoreCase { get; }
+        public int Compare(object x, object y);
+        public abstract int Compare(string x, string y);
+        public static StringComparer Create(CultureInfo culture, bool ignoreCase);
+        public new bool Equals(object x, object y);
+        public abstract bool Equals(string x, string y);
+        public int GetHashCode(object obj);
+        public abstract int GetHashCode(string obj);
+        int System.Collections.IComparer.Compare(object x, object y);
+        bool System.Collections.IEqualityComparer.Equals(object x, object y);
+        int System.Collections.IEqualityComparer.GetHashCode(object obj);
+    }
+    public enum StringComparison {
+        CurrentCulture = 0,
+        CurrentCultureIgnoreCase = 1,
+        InvariantCulture = 2,
+        InvariantCultureIgnoreCase = 3,
+        Ordinal = 4,
+        OrdinalIgnoreCase = 5,
+    }
+    public static class StringNormalizationExtensions {
+        public static bool IsNormalized(this string value);
+        public static bool IsNormalized(this string value, NormalizationForm normalizationForm);
+        public static string Normalize(this string value);
+        public static string Normalize(this string value, NormalizationForm normalizationForm);
+    }
+    public enum StringSplitOptions {
+        None = 0,
+        RemoveEmptyEntries = 1,
+    }
+    public class SystemException : Exception {
+        public SystemException();
+        public SystemException(string message);
+        public SystemException(string message, Exception innerException);
+    }
+    public class ThreadStaticAttribute : Attribute {
+        public ThreadStaticAttribute();
+    }
+    public class TimeoutException : Exception {
+        public TimeoutException();
+        public TimeoutException(string message);
+        public TimeoutException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable {
+        public const long TicksPerDay = (long)864000000000;
+        public const long TicksPerHour = (long)36000000000;
+        public const long TicksPerMillisecond = (long)10000;
+        public const long TicksPerMinute = (long)600000000;
+        public const long TicksPerSecond = (long)10000000;
+        public static readonly TimeSpan MaxValue;
+        public static readonly TimeSpan MinValue;
+        public static readonly TimeSpan Zero;
+        public TimeSpan(int hours, int minutes, int seconds);
+        public TimeSpan(int days, int hours, int minutes, int seconds);
+        public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds);
+        public TimeSpan(long ticks);
+        public int Days { get; }
+        public int Hours { get; }
+        public int Milliseconds { get; }
+        public int Minutes { get; }
+        public int Seconds { get; }
+        public long Ticks { get; }
+        public double TotalDays { get; }
+        public double TotalHours { get; }
+        public double TotalMilliseconds { get; }
+        public double TotalMinutes { get; }
+        public double TotalSeconds { get; }
+        public TimeSpan Add(TimeSpan ts);
+        public static int Compare(TimeSpan t1, TimeSpan t2);
+        public int CompareTo(object value);
+        public int CompareTo(TimeSpan value);
+        public TimeSpan Duration();
+        public override bool Equals(object value);
+        public bool Equals(TimeSpan obj);
+        public static bool Equals(TimeSpan t1, TimeSpan t2);
+        public static TimeSpan FromDays(double value);
+        public static TimeSpan FromHours(double value);
+        public static TimeSpan FromMilliseconds(double value);
+        public static TimeSpan FromMinutes(double value);
+        public static TimeSpan FromSeconds(double value);
+        public static TimeSpan FromTicks(long value);
+        public override int GetHashCode();
+        public TimeSpan Negate();
+        public static TimeSpan operator +(TimeSpan t1, TimeSpan t2);
+        public static bool operator ==(TimeSpan t1, TimeSpan t2);
+        public static bool operator >(TimeSpan t1, TimeSpan t2);
+        public static bool operator >=(TimeSpan t1, TimeSpan t2);
+        public static bool operator !=(TimeSpan t1, TimeSpan t2);
+        public static bool operator <(TimeSpan t1, TimeSpan t2);
+        public static bool operator <=(TimeSpan t1, TimeSpan t2);
+        public static TimeSpan operator -(TimeSpan t1, TimeSpan t2);
+        public static TimeSpan operator -(TimeSpan t);
+        public static TimeSpan operator +(TimeSpan t);
+        public static TimeSpan Parse(string s);
+        public static TimeSpan Parse(string input, IFormatProvider formatProvider);
+        public static TimeSpan ParseExact(string input, string format, IFormatProvider formatProvider);
+        public static TimeSpan ParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles);
+        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider formatProvider);
+        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles);
+        public TimeSpan Subtract(TimeSpan ts);
+        int System.IComparable.CompareTo(object value);
+        public override string ToString();
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider formatProvider);
+        public static bool TryParse(string input, IFormatProvider formatProvider, out TimeSpan result);
+        public static bool TryParse(string s, out TimeSpan result);
+        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, out TimeSpan result);
+        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, out TimeSpan result);
+    }
+    public sealed class TimeZoneInfo : IEquatable<TimeZoneInfo> {
+        public TimeSpan BaseUtcOffset { get; }
+        public string DaylightName { get; }
+        public string DisplayName { get; }
+        public string Id { get; }
+        public static TimeZoneInfo Local { get; }
+        public string StandardName { get; }
+        public bool SupportsDaylightSavingTime { get; }
+        public static TimeZoneInfo Utc { get; }
+        public static DateTime ConvertTime(DateTime dateTime, TimeZoneInfo destinationTimeZone);
+        public static DateTime ConvertTime(DateTime dateTime, TimeZoneInfo sourceTimeZone, TimeZoneInfo destinationTimeZone);
+        public static DateTimeOffset ConvertTime(DateTimeOffset dateTimeOffset, TimeZoneInfo destinationTimeZone);
+        public override bool Equals(object obj);
+        public bool Equals(TimeZoneInfo other);
+        public static TimeZoneInfo FindSystemTimeZoneById(string id);
+        public TimeSpan[] GetAmbiguousTimeOffsets(DateTime dateTime);
+        public TimeSpan[] GetAmbiguousTimeOffsets(DateTimeOffset dateTimeOffset);
+        public override int GetHashCode();
+        public static ReadOnlyCollection<TimeZoneInfo> GetSystemTimeZones();
+        public TimeSpan GetUtcOffset(DateTime dateTime);
+        public TimeSpan GetUtcOffset(DateTimeOffset dateTimeOffset);
+        public bool IsAmbiguousTime(DateTime dateTime);
+        public bool IsAmbiguousTime(DateTimeOffset dateTimeOffset);
+        public bool IsDaylightSavingTime(DateTime dateTime);
+        public bool IsDaylightSavingTime(DateTimeOffset dateTimeOffset);
+        public bool IsInvalidTime(DateTime dateTime);
+        public override string ToString();
+        public sealed class AdjustmentRule : IEquatable<TimeZoneInfo.AdjustmentRule> {
+            public static TimeZoneInfo.AdjustmentRule CreateAdjustmentRule(DateTime dateStart, DateTime dateEnd, TimeSpan daylightDelta, TimeZoneInfo.TransitionTime daylightTransitionStart, TimeZoneInfo.TransitionTime daylightTransitionEnd);
+            public bool Equals(TimeZoneInfo.AdjustmentRule other);
+            public override int GetHashCode();
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct TransitionTime : IEquatable<TimeZoneInfo.TransitionTime> {
+            public override bool Equals(object obj);
+            public bool Equals(TimeZoneInfo.TransitionTime other);
+            public override int GetHashCode();
+        }
+    }
+    public static class Tuple {
+        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8>> Create<T1, T2, T3, T4, T5, T6, T7, T8>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, T8 item8);
+        public static Tuple<T1, T2, T3, T4, T5, T6, T7> Create<T1, T2, T3, T4, T5, T6, T7>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
+        public static Tuple<T1, T2, T3, T4, T5, T6> Create<T1, T2, T3, T4, T5, T6>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
+        public static Tuple<T1, T2, T3, T4, T5> Create<T1, T2, T3, T4, T5>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
+        public static Tuple<T1, T2, T3, T4> Create<T1, T2, T3, T4>(T1 item1, T2 item2, T3 item3, T4 item4);
+        public static Tuple<T1, T2, T3> Create<T1, T2, T3>(T1 item1, T2 item2, T3 item3);
+        public static Tuple<T1, T2> Create<T1, T2>(T1 item1, T2 item2);
+        public static Tuple<T1> Create<T1>(T1 item1);
+    }
+    public class Tuple<T1> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1);
+        public T1 Item1 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3, T4> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public T4 Item4 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3, T4, T5> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public T4 Item4 { get; }
+        public T5 Item5 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3, T4, T5, T6> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public T4 Item4 { get; }
+        public T5 Item5 { get; }
+        public T6 Item6 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3, T4, T5, T6, T7> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public T4 Item4 { get; }
+        public T5 Item5 { get; }
+        public T6 Item6 { get; }
+        public T7 Item7 { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public class Tuple<T1, T2, T3, T4, T5, T6, T7, TRest> : IComparable, IStructuralComparable, IStructuralEquatable {
+        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, TRest rest);
+        public T1 Item1 { get; }
+        public T2 Item2 { get; }
+        public T3 Item3 { get; }
+        public T4 Item4 { get; }
+        public T5 Item5 { get; }
+        public T6 Item6 { get; }
+        public T7 Item7 { get; }
+        public TRest Rest { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        int System.IComparable.CompareTo(object obj);
+        public override string ToString();
+    }
+    public abstract class Type {
+        public static readonly char Delimiter;
+        public static readonly object Missing;
+        public static readonly MemberFilter FilterNameIgnoreCase;
+        public static readonly Type[] EmptyTypes;
+        protected Type();
+        public abstract Assembly Assembly { get; }
+        public abstract string AssemblyQualifiedName { get; }
+        public TypeAttributes Attributes { get; }
+        public abstract Type BaseType { get; }
+        public virtual bool ContainsGenericParameters { get; }
+        public virtual MethodBase DeclaringMethod { get; }
+        public abstract Type DeclaringType { get; }
+        public static Binder DefaultBinder { get; }
+        public abstract string FullName { get; }
+        public virtual GenericParameterAttributes GenericParameterAttributes { get; }
+        public abstract int GenericParameterPosition { get; }
+        public abstract Type[] GenericTypeArguments { get; }
+        public abstract Guid GUID { get; }
+        public bool HasElementType { get; }
+        public bool IsAbstract { get; }
+        public bool IsAnsiClass { get; }
+        public virtual bool IsArray { get; }
+        public bool IsAutoClass { get; }
+        public bool IsAutoLayout { get; }
+        public virtual bool IsByRef { get; }
+        public bool IsClass { get; }
+        public bool IsCOMObject { get; }
+        public abstract bool IsConstructedGenericType { get; }
+        public bool IsEnum { get; }
+        public bool IsExplicitLayout { get; }
+        public abstract bool IsGenericParameter { get; }
+        public virtual bool IsGenericType { get; }
+        public virtual bool IsGenericTypeDefinition { get; }
+        public bool IsImport { get; }
+        public bool IsInterface { get; }
+        public bool IsLayoutSequential { get; }
+        public bool IsMarshalByRef { get; }
+        public bool IsNested { get; }
+        public bool IsNestedAssembly { get; }
+        public bool IsNestedFamANDAssem { get; }
+        public bool IsNestedFamily { get; }
+        public bool IsNestedFamORAssem { get; }
+        public bool IsNestedPrivate { get; }
+        public bool IsNestedPublic { get; }
+        public bool IsNotPublic { get; }
+        public virtual bool IsPointer { get; }
+        public bool IsPrimitive { get; }
+        public bool IsPublic { get; }
+        public bool IsSealed { get; }
+        public virtual bool IsSerializable { get; }
+        public bool IsSpecialName { get; }
+        public bool IsUnicodeClass { get; }
+        public bool IsValueType { get; }
+        public bool IsVisible { get; }
+        public override MemberTypes MemberType { get; }
+        public abstract new Module Module { get; }
+        public abstract string Name { get; }
+        public abstract string Namespace { get; }
+        public override Type ReflectedType { get; }
+        public virtual StructLayoutAttribute StructLayoutAttribute { get; }
+        public virtual RuntimeTypeHandle TypeHandle { get; }
+        public ConstructorInfo TypeInitializer { get; }
+        public abstract Type UnderlyingSystemType { get; }
+        public override bool Equals(object o);
+        public bool Equals(Type o);
+        public virtual Type[] FindInterfaces(TypeFilter filter, object filterCriteria);
+        public virtual MemberInfo[] FindMembers(MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter, object filterCriteria);
+        public abstract int GetArrayRank();
+        protected abstract TypeAttributes GetAttributeFlagsImpl();
+        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        public ConstructorInfo GetConstructor(Type[] types);
+        protected abstract ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public ConstructorInfo[] GetConstructors();
+        public abstract ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public virtual MemberInfo[] GetDefaultMembers();
+        public abstract Type GetElementType();
+        public virtual string GetEnumName(object value);
+        public virtual string[] GetEnumNames();
+        public virtual Type GetEnumUnderlyingType();
+        public virtual Array GetEnumValues();
+        public EventInfo GetEvent(string name);
+        public abstract EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public virtual EventInfo[] GetEvents();
+        public abstract EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public FieldInfo GetField(string name);
+        public abstract FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public FieldInfo[] GetFields();
+        public abstract FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public virtual Type[] GetGenericArguments();
+        public virtual Type[] GetGenericParameterConstraints();
+        public abstract Type GetGenericTypeDefinition();
+        public override int GetHashCode();
+        public Type GetInterface(string name);
+        public abstract Type GetInterface(string name, bool ignoreCase);
+        public virtual InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public abstract Type[] GetInterfaces();
+        public MemberInfo[] GetMember(string name);
+        public virtual MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
+        public virtual MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public MemberInfo[] GetMembers();
+        public abstract MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, Type[] types);
+        public MethodInfo GetMethod(string name, Type[] types, ParameterModifier[] modifiers);
+        protected abstract MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo[] GetMethods();
+        public abstract MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public Type GetNestedType(string name);
+        public abstract Type GetNestedType(string name, BindingFlags bindingAttr);
+        public Type[] GetNestedTypes();
+        public abstract Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public PropertyInfo[] GetProperties();
+        public abstract PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name);
+        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public PropertyInfo GetProperty(string name, Type returnType);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public PropertyInfo GetProperty(string name, Type[] types);
+        protected abstract PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public static Type GetType(string typeName);
+        public static Type GetType(string typeName, bool throwOnError);
+        public static Type GetType(string typeName, bool throwOnError, bool ignoreCase);
+        public static TypeCode GetTypeCode(Type type);
+        public static Type GetTypeFromHandle(RuntimeTypeHandle handle);
+        public static RuntimeTypeHandle GetTypeHandle(object o);
+        protected abstract bool HasElementTypeImpl();
+        public object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args);
+        public abstract object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected abstract bool IsArrayImpl();
+        public virtual bool IsAssignableFrom(Type c);
+        protected abstract bool IsByRefImpl();
+        protected abstract bool IsCOMObjectImpl();
+        public virtual bool IsEnumDefined(object value);
+        public virtual bool IsEquivalentTo(Type other);
+        public virtual bool IsInstanceOfType(object o);
+        protected abstract bool IsPointerImpl();
+        protected abstract bool IsPrimitiveImpl();
+        public virtual bool IsSubclassOf(Type c);
+        protected virtual bool IsValueTypeImpl();
+        public abstract Type MakeArrayType();
+        public abstract Type MakeArrayType(int rank);
+        public abstract Type MakeByRefType();
+        public abstract Type MakeGenericType(params Type[] typeArguments);
+        public abstract Type MakePointerType();
+        public override string ToString();
+    }
+    public class TypeAccessException : TypeLoadException {
+        public TypeAccessException();
+        public TypeAccessException(string message);
+        public TypeAccessException(string message, Exception inner);
+    }
+    public enum TypeCode {
+        Boolean = 3,
+        Byte = 6,
+        Char = 4,
+        DateTime = 16,
+        DBNull = 2,
+        Decimal = 15,
+        Double = 14,
+        Empty = 0,
+        Int16 = 7,
+        Int32 = 9,
+        Int64 = 11,
+        Object = 1,
+        SByte = 5,
+        Single = 13,
+        String = 18,
+        UInt16 = 8,
+        UInt32 = 10,
+        UInt64 = 12,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypedReference {
+        public override bool Equals(object o);
+        public override int GetHashCode();
+    }
+    public sealed class TypeInitializationException : Exception {
+        public TypeInitializationException(string fullTypeName, Exception innerException);
+        public string TypeName { get; }
+    }
+    public class TypeLoadException : Exception {
+        public TypeLoadException();
+        public TypeLoadException(string message);
+        public TypeLoadException(string message, Exception inner);
+        public override string Message { get; }
+        public string TypeName { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable {
+        public const ushort MaxValue = (ushort)65535;
+        public const ushort MinValue = (ushort)0;
+        public int CompareTo(object value);
+        public int CompareTo(ushort value);
+        public override bool Equals(object obj);
+        public bool Equals(ushort obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static ushort Parse(string s);
+        public static ushort Parse(string s, NumberStyles style);
+        public static ushort Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static ushort Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out ushort result);
+        public static bool TryParse(string s, out ushort result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable {
+        public const uint MaxValue = (uint)4294967295;
+        public const uint MinValue = (uint)0;
+        public int CompareTo(object value);
+        public int CompareTo(uint value);
+        public override bool Equals(object obj);
+        public bool Equals(uint obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static uint Parse(string s);
+        public static uint Parse(string s, NumberStyles style);
+        public static uint Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static uint Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out uint result);
+        public static bool TryParse(string s, out uint result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable {
+        public const ulong MaxValue = (ulong)18446744073709551615;
+        public const ulong MinValue = (ulong)0;
+        public int CompareTo(object value);
+        public int CompareTo(ulong value);
+        public override bool Equals(object obj);
+        public bool Equals(ulong obj);
+        public override int GetHashCode();
+        public TypeCode GetTypeCode();
+        public static ulong Parse(string s);
+        public static ulong Parse(string s, NumberStyles style);
+        public static ulong Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static ulong Parse(string s, IFormatProvider provider);
+        int System.IComparable.CompareTo(object value);
+        TypeCode System.IConvertible.GetTypeCode();
+        bool System.IConvertible.ToBoolean(IFormatProvider provider);
+        byte System.IConvertible.ToByte(IFormatProvider provider);
+        char System.IConvertible.ToChar(IFormatProvider provider);
+        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
+        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
+        double System.IConvertible.ToDouble(IFormatProvider provider);
+        short System.IConvertible.ToInt16(IFormatProvider provider);
+        int System.IConvertible.ToInt32(IFormatProvider provider);
+        long System.IConvertible.ToInt64(IFormatProvider provider);
+        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
+        float System.IConvertible.ToSingle(IFormatProvider provider);
+        object System.IConvertible.ToType(Type type, IFormatProvider provider);
+        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
+        uint System.IConvertible.ToUInt32(IFormatProvider provider);
+        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out ulong result);
+        public static bool TryParse(string s, out ulong result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct UIntPtr {
+        public static readonly UIntPtr Zero;
+        public UIntPtr(uint value);
+        public UIntPtr(ulong value);
+        public unsafe UIntPtr(void* value);
+        public static int Size { get; }
+        public static UIntPtr Add(UIntPtr pointer, int offset);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static UIntPtr operator +(UIntPtr pointer, int offset);
+        public static bool operator ==(UIntPtr value1, UIntPtr value2);
+        public static explicit operator UIntPtr (uint value);
+        public static explicit operator UIntPtr (ulong value);
+        public static explicit operator uint (UIntPtr value);
+        public static explicit operator ulong (UIntPtr value);
+        public unsafe static explicit operator void* (UIntPtr value);
+        public unsafe static explicit operator UIntPtr (void* value);
+        public static bool operator !=(UIntPtr value1, UIntPtr value2);
+        public static UIntPtr operator -(UIntPtr pointer, int offset);
+        public static UIntPtr Subtract(UIntPtr pointer, int offset);
+        public unsafe void* ToPointer();
+        public override string ToString();
+        public uint ToUInt32();
+        public ulong ToUInt64();
+    }
+    public class UnauthorizedAccessException : Exception {
+        public UnauthorizedAccessException();
+        public UnauthorizedAccessException(string message);
+        public UnauthorizedAccessException(string message, Exception inner);
+    }
+    public class UnhandledExceptionEventArgs : EventArgs {
+        public UnhandledExceptionEventArgs(object exception, bool isTerminating);
+        public object ExceptionObject { get; }
+        public bool IsTerminating { get; }
+    }
+    public delegate void UnhandledExceptionEventHandler(object sender, UnhandledExceptionEventArgs e);
+    public class Uri {
+        public Uri(string uriString);
+        public Uri(string uriString, UriKind uriKind);
+        public Uri(Uri baseUri, string relativeUri);
+        public Uri(Uri baseUri, Uri relativeUri);
+        public string AbsolutePath { get; }
+        public string AbsoluteUri { get; }
+        public string Authority { get; }
+        public string DnsSafeHost { get; }
+        public string Fragment { get; }
+        public string Host { get; }
+        public UriHostNameType HostNameType { get; }
+        public string IdnHost { get; }
+        public bool IsAbsoluteUri { get; }
+        public bool IsDefaultPort { get; }
+        public bool IsFile { get; }
+        public bool IsLoopback { get; }
+        public bool IsUnc { get; }
+        public string LocalPath { get; }
+        public string OriginalString { get; }
+        public string PathAndQuery { get; }
+        public int Port { get; }
+        public string Query { get; }
+        public string Scheme { get; }
+        public string[] Segments { get; }
+        public bool UserEscaped { get; }
+        public string UserInfo { get; }
+        public static UriHostNameType CheckHostName(string name);
+        public static bool CheckSchemeName(string schemeName);
+        public static int Compare(Uri uri1, Uri uri2, UriComponents partsToCompare, UriFormat compareFormat, StringComparison comparisonType);
+        public override bool Equals(object comparand);
+        public static string EscapeDataString(string stringToEscape);
+        public static string EscapeUriString(string stringToEscape);
+        public string GetComponents(UriComponents components, UriFormat format);
+        public override int GetHashCode();
+        public bool IsBaseOf(Uri uri);
+        public bool IsWellFormedOriginalString();
+        public static bool IsWellFormedUriString(string uriString, UriKind uriKind);
+        public Uri MakeRelativeUri(Uri uri);
+        public static bool operator ==(Uri uri1, Uri uri2);
+        public static bool operator !=(Uri uri1, Uri uri2);
+        public override string ToString();
+        public static bool TryCreate(string uriString, UriKind uriKind, out Uri result);
+        public static bool TryCreate(Uri baseUri, string relativeUri, out Uri result);
+        public static bool TryCreate(Uri baseUri, Uri relativeUri, out Uri result);
+        public static string UnescapeDataString(string stringToUnescape);
+    }
+    public class UriBuilder {
+        public UriBuilder();
+        public UriBuilder(string uri);
+        public UriBuilder(string schemeName, string hostName);
+        public UriBuilder(string scheme, string host, int portNumber);
+        public UriBuilder(string scheme, string host, int port, string pathValue);
+        public UriBuilder(string scheme, string host, int port, string path, string extraValue);
+        public UriBuilder(Uri uri);
+        public string Fragment { get; set; }
+        public string Host { get; set; }
+        public string Password { get; set; }
+        public string Path { get; set; }
+        public int Port { get; set; }
+        public string Query { get; set; }
+        public string Scheme { get; set; }
+        public Uri Uri { get; }
+        public string UserName { get; set; }
+        public override bool Equals(object rparam);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public enum UriComponents {
+        AbsoluteUri = 127,
+        Fragment = 64,
+        Host = 4,
+        HostAndPort = 132,
+        HttpRequestUrl = 61,
+        KeepDelimiter = 1073741824,
+        NormalizedHost = 256,
+        Path = 16,
+        PathAndQuery = 48,
+        Port = 8,
+        Query = 32,
+        Scheme = 1,
+        SchemeAndServer = 13,
+        SerializationInfoString = -2147483648,
+        StrongAuthority = 134,
+        StrongPort = 128,
+        UserInfo = 2,
+    }
+    public enum UriFormat {
+        SafeUnescaped = 3,
+        Unescaped = 2,
+        UriEscaped = 1,
+    }
+    public class UriFormatException : FormatException {
+        public UriFormatException();
+        public UriFormatException(string textString);
+        public UriFormatException(string textString, Exception e);
+    }
+    public enum UriHostNameType {
+        Basic = 1,
+        Dns = 2,
+        IPv4 = 3,
+        IPv6 = 4,
+        Unknown = 0,
+    }
+    public enum UriKind {
+        Absolute = 1,
+        Relative = 2,
+        RelativeOrAbsolute = 0,
+    }
+    public class UriTypeConverter : TypeConverter {
+        public UriTypeConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public abstract class ValueType {
+        protected ValueType();
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public sealed class Version : IComparable, IComparable<Version>, IEquatable<Version> {
+        public Version(int major, int minor);
+        public Version(int major, int minor, int build);
+        public Version(int major, int minor, int build, int revision);
+        public Version(string version);
+        public int Build { get; }
+        public int Major { get; }
+        public short MajorRevision { get; }
+        public int Minor { get; }
+        public short MinorRevision { get; }
+        public int Revision { get; }
+        public object Clone();
+        public int CompareTo(object version);
+        public int CompareTo(Version value);
+        public override bool Equals(object obj);
+        public bool Equals(Version obj);
+        public override int GetHashCode();
+        public static bool operator ==(Version v1, Version v2);
+        public static bool operator >(Version v1, Version v2);
+        public static bool operator >=(Version v1, Version v2);
+        public static bool operator !=(Version v1, Version v2);
+        public static bool operator <(Version v1, Version v2);
+        public static bool operator <=(Version v1, Version v2);
+        public static Version Parse(string input);
+        int System.IComparable.CompareTo(object version);
+        public override string ToString();
+        public string ToString(int fieldCount);
+        public static bool TryParse(string input, out Version result);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct Void
+    public class WeakReference {
+        protected WeakReference();
+        public WeakReference(object target);
+        public WeakReference(object target, bool trackResurrection);
+        public virtual bool IsAlive { get; }
+        public virtual object Target { get; set; }
+        public virtual bool TrackResurrection { get; }
+        ~WeakReference();
+    }
+    public sealed class WeakReference<T> where T : class {
+        public WeakReference(T target);
+        public WeakReference(T target, bool trackResurrection);
+        ~WeakReference();
+        public void SetTarget(T target);
+        public bool TryGetTarget(out T target);
+    }
+}
```

