# System.Reflection.PortableExecutable

``` diff
 namespace System.Reflection.PortableExecutable {
+    public sealed class DebugDirectoryBuilder {
+        public DebugDirectoryBuilder();
+        public void AddCodeViewEntry(string pdbPath, BlobContentId pdbContentId, ushort portablePdbVersion);
+        public void AddEmbeddedPortablePdbEntry(BlobBuilder debugMetadata, ushort portablePdbVersion);
+        public void AddReproducibleEntry();
+    }
     public struct DebugDirectoryEntry {
+        public bool IsPortableCodeView { get; }
     }
     public enum DebugDirectoryEntryType {
+        EmbeddedPortablePdb = 17,
     }
+    public class ManagedPEBuilder : PEBuilder {
+        public const int ManagedResourcesDataAlignment = 8;
+        public const int MappedFieldDataAlignment = 8;
+        public ManagedPEBuilder(PEHeaderBuilder header, MetadataRootBuilder metadataRootBuilder, BlobBuilder ilStream, BlobBuilder mappedFieldData=null, BlobBuilder managedResources=null, ResourceSectionBuilder nativeResources=null, DebugDirectoryBuilder debugDirectoryBuilder=null, int strongNameSignatureSize=128, MethodDefinitionHandle entryPoint=null, CorFlags flags=(CorFlags)(1), Func<IEnumerable<Blob>, BlobContentId> deterministicIdProvider=null);
+        protected override ImmutableArray<PEBuilder.Section> CreateSections();
+        protected internal override PEDirectoriesBuilder GetDirectories();
+        protected override BlobBuilder SerializeSection(string name, SectionLocation location);
+        public void Sign(BlobBuilder peImage, Func<IEnumerable<Blob>, byte[]> signatureProvider);
+    }
+    public abstract class PEBuilder {
+        protected PEBuilder(PEHeaderBuilder header, Func<IEnumerable<Blob>, BlobContentId> deterministicIdProvider);
+        public PEHeaderBuilder Header { get; }
+        public Func<IEnumerable<Blob>, BlobContentId> IdProvider { get; }
+        public bool IsDeterministic { get; }
+        protected abstract ImmutableArray<PEBuilder.Section> CreateSections();
+        protected internal abstract PEDirectoriesBuilder GetDirectories();
+        protected ImmutableArray<PEBuilder.Section> GetSections();
+        public BlobContentId Serialize(BlobBuilder builder);
+        protected abstract BlobBuilder SerializeSection(string name, SectionLocation location);
+        protected struct Section {
+            public readonly SectionCharacteristics Characteristics;
+            public readonly string Name;
+            public Section(string name, SectionCharacteristics characteristics);
+        }
+    }
+    public sealed class PEDirectoriesBuilder {
+        public PEDirectoriesBuilder();
+        public int AddressOfEntryPoint { get; set; }
+        public DirectoryEntry BaseRelocationTable { get; set; }
+        public DirectoryEntry BoundImportTable { get; set; }
+        public DirectoryEntry CopyrightTable { get; set; }
+        public DirectoryEntry CorHeaderTable { get; set; }
+        public DirectoryEntry DebugTable { get; set; }
+        public DirectoryEntry DelayImportTable { get; set; }
+        public DirectoryEntry ExceptionTable { get; set; }
+        public DirectoryEntry ExportTable { get; set; }
+        public DirectoryEntry GlobalPointerTable { get; set; }
+        public DirectoryEntry ImportAddressTable { get; set; }
+        public DirectoryEntry ImportTable { get; set; }
+        public DirectoryEntry LoadConfigTable { get; set; }
+        public DirectoryEntry ResourceTable { get; set; }
+        public DirectoryEntry ThreadLocalStorageTable { get; set; }
+    }
+    public sealed class PEHeaderBuilder {
+        public PEHeaderBuilder(Machine machine=(Machine)(0), int sectionAlignment=8192, int fileAlignment=512, ulong imageBase=(ulong)4194304, byte majorLinkerVersion=(byte)48, byte minorLinkerVersion=(byte)0, ushort majorOperatingSystemVersion=(ushort)4, ushort minorOperatingSystemVersion=(ushort)0, ushort majorImageVersion=(ushort)0, ushort minorImageVersion=(ushort)0, ushort majorSubsystemVersion=(ushort)4, ushort minorSubsystemVersion=(ushort)0, Subsystem subsystem=(Subsystem)(3), DllCharacteristics dllCharacteristics=(DllCharacteristics)(34112), Characteristics imageCharacteristics=(Characteristics)(8192), ulong sizeOfStackReserve=(ulong)1048576, ulong sizeOfStackCommit=(ulong)4096, ulong sizeOfHeapReserve=(ulong)1048576, ulong sizeOfHeapCommit=(ulong)4096);
+        public DllCharacteristics DllCharacteristics { get; }
+        public int FileAlignment { get; }
+        public ulong ImageBase { get; }
+        public Characteristics ImageCharacteristics { get; }
+        public Machine Machine { get; }
+        public ushort MajorImageVersion { get; }
+        public byte MajorLinkerVersion { get; }
+        public ushort MajorOperatingSystemVersion { get; }
+        public ushort MajorSubsystemVersion { get; }
+        public ushort MinorImageVersion { get; }
+        public byte MinorLinkerVersion { get; }
+        public ushort MinorOperatingSystemVersion { get; }
+        public ushort MinorSubsystemVersion { get; }
+        public int SectionAlignment { get; }
+        public ulong SizeOfHeapCommit { get; }
+        public ulong SizeOfHeapReserve { get; }
+        public ulong SizeOfStackCommit { get; }
+        public ulong SizeOfStackReserve { get; }
+        public Subsystem Subsystem { get; }
+        public static PEHeaderBuilder CreateExecutableHeader();
+        public static PEHeaderBuilder CreateLibraryHeader();
+    }
     public sealed class PEHeaders {
+        public PEHeaders(Stream peStream, int size, bool isLoadedImage);
     }
     public struct PEMemoryBlock {
+        public ImmutableArray<byte> GetContent(int start, int length);
+        public BlobReader GetReader();
+        public BlobReader GetReader(int start, int length);
     }
     public sealed class PEReader : IDisposable {
+        public unsafe PEReader(byte* peImage, int size, bool isLoadedImage);
+        public bool IsLoadedImage { get; }
+        public PEMemoryBlock GetSectionData(string sectionName);
+        public MetadataReaderProvider ReadEmbeddedPortablePdbDebugDirectoryData(DebugDirectoryEntry entry);
+        public bool TryOpenAssociatedPortablePdb(string peImagePath, Func<string, Stream> pdbFileStreamProvider, out MetadataReaderProvider pdbReaderProvider, out string pdbPath);
     }
     public enum PEStreamOptions {
+        IsLoadedImage = 8,
     }
+    public abstract class ResourceSectionBuilder {
+        protected ResourceSectionBuilder();
+        protected internal abstract void Serialize(BlobBuilder builder, SectionLocation location);
+    }
+    public struct SectionLocation {
+        public SectionLocation(int relativeVirtualAddress, int pointerToRawData);
+        public int PointerToRawData { get; }
+        public int RelativeVirtualAddress { get; }
+    }
 }
```

