# .NET Core 2.1.14 Update - November 19, 2019

[.NET Core 2.1.14](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.14, ASP.NET Core 2.1.14 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2114)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

We've created an issue at [dotnet/core #3848](https://github.com/dotnet/core/issues/3848) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

The November Update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.607](2.1.607-download.md) |
| Windows | Visual Studio 2017 | [2.1.510](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)


The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.14 is being deployed to Azure App Services and the deployment is expected to complete later in December 2019.

## Changes in 2.1.14

.NET Core 2.1.14 release carries only non-security fixes.


### Fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.14+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A2.1.14+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
dotnet-ef                                                    | 2.1.14
Microsoft.AspNetCore.All                                     | 2.1.14
Microsoft.AspNetCore.App                                     | 2.1.14
Microsoft.AspNetCore.CookiePolicy                            | 2.1.14
Microsoft.Data.Sqlite                                        | 2.1.14
Microsoft.Data.Sqlite.Core                                   | 2.1.14
Microsoft.DotNet.Web.Client.ItemTemplates                    | 2.1.14
Microsoft.DotNet.Web.ItemTemplates                           | 2.1.14
Microsoft.DotNet.Web.ProjectTemplates.2.1                    | 2.1.14
Microsoft.DotNet.Web.Spa.ProjectTemplates.2.1                | 2.1.14
Microsoft.EntityFrameworkCore                                | 2.1.14
Microsoft.EntityFrameworkCore.Abstractions                   | 2.1.14
Microsoft.EntityFrameworkCore.Analyzers                      | 2.1.14
Microsoft.EntityFrameworkCore.Design                         | 2.1.14
Microsoft.EntityFrameworkCore.InMemory                       | 2.1.14
Microsoft.EntityFrameworkCore.Proxies                        | 2.1.14
Microsoft.EntityFrameworkCore.Relational                     | 2.1.14
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 2.1.14
Microsoft.EntityFrameworkCore.Specification.Tests            | 2.1.14
Microsoft.EntityFrameworkCore.Sqlite                         | 2.1.14
Microsoft.EntityFrameworkCore.Sqlite.Core                    | 2.1.14
Microsoft.EntityFrameworkCore.SqlServer                      | 2.1.14
Microsoft.EntityFrameworkCore.Tools                          | 2.1.14
Microsoft.Net.Http.Headers                                   | 2.1.14
Microsoft.NETCore.App                                       | 2.1.14
Microsoft.NETCore.DotNetAppHost                             | 2.1.14
Microsoft.NETCore.DotNetHost                                | 2.1.14
Microsoft.NETCore.DotNetHostPolicy                          | 2.1.14
Microsoft.NETCore.DotNetHostResolver                        | 2.1.14
Microsoft.NETCore.Platforms | 2.1.7
runtime.linux-arm.Microsoft.NETCore.App                     | 2.1.14
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost           | 2.1.14
runtime.linux-arm.Microsoft.NETCore.DotNetHost              | 2.1.14
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy        | 2.1.14
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver      | 2.1.14
runtime.linux-arm64.Microsoft.NETCore.App                   | 2.1.14
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost         | 2.1.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHost            | 2.1.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy      | 2.1.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver    | 2.1.14
runtime.linux-musl-x64.Microsoft.NETCore.App                | 2.1.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost      | 2.1.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost         | 2.1.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy   | 2.1.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.14
runtime.linux-x64.Microsoft.NETCore.App                     | 2.1.14
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost           | 2.1.14
runtime.linux-x64.Microsoft.NETCore.DotNetHost              | 2.1.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy        | 2.1.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver      | 2.1.14
runtime.osx-x64.Microsoft.NETCore.App                       | 2.1.14
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost             | 2.1.14
runtime.osx-x64.Microsoft.NETCore.DotNetHost                | 2.1.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy          | 2.1.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver        | 2.1.14
runtime.rhel.6-x64.Microsoft.NETCore.App                    | 2.1.14
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost          | 2.1.14
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost             | 2.1.14
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy       | 2.1.14
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver     | 2.1.14
runtime.win-arm.Microsoft.NETCore.App                       | 2.1.14
runtime.win-arm.Microsoft.NETCore.DotNetAppHost             | 2.1.14
runtime.win-arm.Microsoft.NETCore.DotNetHost                | 2.1.14
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy          | 2.1.14
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver        | 2.1.14
runtime.win-arm64.Microsoft.NETCore.App                     | 2.1.14
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost           | 2.1.14
runtime.win-arm64.Microsoft.NETCore.DotNetHost              | 2.1.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy        | 2.1.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver      | 2.1.14
runtime.win-x64.Microsoft.NETCore.App                       | 2.1.14
runtime.win-x64.Microsoft.NETCore.DotNetAppHost             | 2.1.14
runtime.win-x64.Microsoft.NETCore.DotNetHost                | 2.1.14
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy          | 2.1.14
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver        | 2.1.14
runtime.win-x86.Microsoft.NETCore.App                       | 2.1.14
runtime.win-x86.Microsoft.NETCore.DotNetAppHost             | 2.1.14
runtime.win-x86.Microsoft.NETCore.DotNetHost                | 2.1.14
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy          | 2.1.14
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver        | 2.1.14


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.14/2.1.14.md



[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.14-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-november-2019/



[//]: # ( Runtime 2.1.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3481487-b642-4fd3-a7f5-03f2c2928391/6d447b52647c707e8a9cc5688c9b3e25/dotnet-runtime-2.1.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f038666-b586-4dda-9f14-d381fdc6158c/65db2c6bbc8b307b05a660829ad65c5e/dotnet-runtime-2.1.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10098873-534a-4047-a8f5-769de79a9cf9/068b5428705be938738acb3df8a61d61/dotnet-runtime-2.1.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f7daa05-c09f-41c3-b607-eabeefb6b677/1effcfea7b7f5208de533db8686f6e0f/dotnet-runtime-2.1.14-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/06923cb7-155a-46df-93ff-cc242dc7e02e/3e3ff170cb7cf14cd4292cf60c3fc999/dotnet-runtime-2.1.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5e16024-db4e-4e85-9ed7-93fd84fb9169/8c5a9772f7f27c5f9150023a5b76f24d/dotnet-runtime-2.1.14-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72922a8d-167a-4cef-988e-c503f2662a3e/4a47749e136204cab0a837fb43e3a248/dotnet-runtime-2.1.14-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ced5e190-47e0-4999-be3a-75275d73cb05/1e0d49a46b9bb74b53baaa8b847ed325/dotnet-runtime-2.1.14-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/03780932-d28e-48de-ab90-f89192339efa/9d6552b4b9bfb4d02e5d200fff864dc3/dotnet-runtime-2.1.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9b76a451-c2a7-4782-874d-7c7cbde6a85c/d83ac3bb4a4f1f67a5a1f735078329ac/dotnet-runtime-2.1.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/dcb18371-7b50-47c4-9f29-f06d6f4f28a3/25eedfee64248e3c77a6c69125c0bd2a/dotnet-runtime-2.1.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/87f0d3c5-0734-4db6-83a3-363319fb4be1/3f302e68598e26c8741631f9278d4da5/dotnet-runtime-2.1.14-win-x86.zip

[//]: # ( WindowsDesktop 2.1.14)

[//]: # ( ASP 2.1.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c563df7-736b-49ce-bd17-e739f3765541/e93dd1eff909e59a7ba72784a64dc031/aspnetcore-runtime-2.1.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64d8b249-f3d0-4ad9-89f9-9adfc909d3b0/aad4f4a97b6e9dcc97263d986eec1627/aspnetcore-runtime-2.1.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22e9f27e-12cd-4ba9-86ce-113cbe7c55c2/a1097e49b4da2c1949919e752264f691/aspnetcore-runtime-2.1.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2e75bdf-df99-44ff-96e0-e3da03d8d5d8/0bb27a7f2d1d8739bb1a12ee733d1107/aspnetcore-runtime-2.1.14-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7c6615ef-61cc-4ba0-8eb1-9df7a414c4f5/b8f812c62cf812b76f79d8d6dfa3cc74/aspnetcore-runtime-2.1.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e87a5727-370b-4615-bfd9-f61fdb9e0ef8/54770041947c33387f49f6258f0174c6/aspnetcore-runtime-2.1.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a72ab6f-19ae-4fec-90d9-4a569754a161/5d56446b827fda77ee71f345436a587d/aspnetcore-runtime-2.1.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1d40fcaf-ef03-4679-bb55-ab77a221d1af/a83e07fac23b52ad9cb3939353bf683e/aspnetcore-runtime-2.1.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d08902cf-87b0-4bfe-b25c-627ff77b8802/8293c56094f50ba8c4ed703aff95c325/dotnet-hosting-2.1.14-win.exe

[//]: # ( SDK 2.1.510 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe208bcf-28bf-42d5-b790-3a118e7b7c82/a69bf3850220341ffe4be393421a8935/dotnet-sdk-2.1.510-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ade3d6db-1b15-4fdb-ba2c-88af5228ef63/c77c3867c76be59680a9dca0fe633958/dotnet-sdk-2.1.510-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c2124b3-531e-403d-9d8c-18e9adeaf519/52732ea74aadc5247ef65a6b9980b946/dotnet-sdk-2.1.510-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ed5aaac-d5c3-46e0-9cdc-4b91f1cf9f2c/666c0ab4b5a08d1aada9f89d2cf9376e/dotnet-sdk-2.1.510-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a2c3ab2c-93dd-474d-9fb8-879afa46f4f4/0df8ed04c1164ebf7e27cbbea71a2444/dotnet-sdk-2.1.510-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60350f58-062a-40af-8d1f-d2e768571a6d/57226616ee0de9dd5bcc33a1e30d14c9/dotnet-sdk-2.1.510-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95a84458-1f5d-492f-9fe0-2225e9bb5e6e/20ff110a40b7c8a288bc0a2868fa204f/dotnet-sdk-2.1.510-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ad201538-1ed5-40f8-8d3f-d5e87e3f86f6/2f86a429b505e9f9dc8c6e4173c9f30a/dotnet-sdk-2.1.510-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b8543fd7-e7cc-4041-80d9-269efd3cbbec/352d2ce6e4c8484d95de6ea3cdd1aa63/dotnet-sdk-2.1.510-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f23cd820-0d00-43d9-ab07-53a19a508dd3/6ee2da1dab6b179e521acb30503524ad/dotnet-sdk-2.1.510-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/704c8cad-577a-42b3-93f3-96ecbc40092f/894c286cebe80aecc2d1a975b60c914e/dotnet-sdk-2.1.510-win-x86.zip

[//]: # ( Symbols )
