# .NET Core 2.1.16 Update - February 18, 2020

[.NET Core 2.1.16](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.16, ASP.NET Core 2.1.16 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2116)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4280](https://github.com/dotnet/core/issues/4280) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.609](2.1.609-download.md) |
| Windows | Visual Studio 2017 | [2.1.512](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's March servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.16 is being deployed to Azure App Services and the deployment is expected to complete later in February 2020.

## .NET Core Lifecycle News

[.NET Core 2.2 reached end of life](https://github.com/dotnet/announcements/issues/147/) on December 23, 2019. This means .NET Core 2.2 is no longer supported and updates will no longer be provided. We recommend moving to .NET Core 3.1, our long term support (LTS) release.

.NET Core 3.0 will reach end of life on March 3, 2020 which is 3 months after the release of .NET Core 3.1. You can view the [Microsoft Support for .NET Core](https://github.com/dotnet/core/blob/main/microsoft-support.md) for more information about life-cycle of each product.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.


## Changes in 2.1.16

.NET Core 2.1.16 release carries only non-security fixes.

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.16+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.16+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A2.1.16+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)


## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App	|	2.1.16
Microsoft.NETCore.DotNetAppHost	|	2.1.16
Microsoft.NETCore.DotNetHost	|	2.1.16
Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.linux-arm.Microsoft.NETCore.App	|	2.1.16
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.linux-arm.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.linux-arm64.Microsoft.NETCore.App	|	2.1.16
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.linux-musl-x64.Microsoft.NETCore.App	|	2.1.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.linux-x64.Microsoft.NETCore.App	|	2.1.16
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.linux-x64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.osx-x64.Microsoft.NETCore.App	|	2.1.16
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.osx-x64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.rhel.6-x64.Microsoft.NETCore.App	|	2.1.16
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.win-arm.Microsoft.NETCore.App	|	2.1.16
runtime.win-arm.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.win-arm.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.win-arm64.Microsoft.NETCore.App	|	2.1.16
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.win-arm64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.win-x64.Microsoft.NETCore.App	|	2.1.16
runtime.win-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.win-x64.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
runtime.win-x86.Microsoft.NETCore.App	|	2.1.16
runtime.win-x86.Microsoft.NETCore.DotNetAppHost	|	2.1.16
runtime.win-x86.Microsoft.NETCore.DotNetHost	|	2.1.16
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy	|	2.1.16
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver	|	2.1.16
VS.Redist.Common.NetCore.HostFXR.x64.2.1	|	2.1.16
VS.Redist.Common.NetCore.HostFXR.x86.2.1	|	2.1.16
VS.Redist.Common.NetCore.SharedFramework.x64.2.1	|	2.1.16
VS.Redist.Common.NetCore.SharedFramework.x86.2.1	|	2.1.16
VS.Redist.Common.NetCore.SharedHost.x64.2.1	|	2.1.16
VS.Redist.Common.NetCore.SharedHost.x86.2.1	|	2.1.16
Microsoft.NETCore.Platforms	|	2.1.8
System.Data.SqlClient	|	4.5.3
Microsoft.AspNetCore.All	|	2.1.16
Microsoft.AspNetCore.App	|	2.1.16
Microsoft.AspNetCore.Authentication.Cookies	|	2.1.16
Microsoft.AspNetCore.Mvc.Core	|	2.1.16
Microsoft.DotNet.Web.Client.ItemTemplates	|	2.1.16
Microsoft.DotNet.Web.ItemTemplates	|	2.1.16
Microsoft.DotNet.Web.ProjectTemplates.2.1	|	2.1.16
Microsoft.DotNet.Web.Spa.ProjectTemplates.2.1	|	2.1.16



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.16/2.1.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.16-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-february-2020/


[//]: # ( Runtime 2.1.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1154ac1-c67b-4403-9fcd-7ea74db15940/6b747093fa4ef3cdf82a4f48f2f918bf/dotnet-runtime-2.1.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68a9089a-d7a9-4df8-bef3-07823c85c985/e12aaa871454d8d58b8c76f4224e3304/dotnet-runtime-2.1.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3ee1032-49f8-4135-b1cb-4db12425762e/ca3920fc3593576d9b6ed780f121c3ee/dotnet-runtime-2.1.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55d69fac-3c70-48da-ab75-a11732ea41fd/35a62311fe92ff96dfd6b4121078bbbd/dotnet-runtime-2.1.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fd9b3790-0a70-4bfd-bb76-0cfa5501d5ae/875f08c18afaa5b083a4845c8534427d/dotnet-runtime-2.1.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69cb2041-a16a-4ac1-a7d8-79a92e64c32a/e3fa8a41d1c592cfd455a6867ab9a1b8/dotnet-runtime-2.1.16-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73f1cb6e-3ffe-42ca-9d59-374b5e4fea9c/0b77418b9408a85f88dc3999f52865f4/dotnet-runtime-2.1.16-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/abc50270-cbf1-41fd-b974-7cab384b285b/7feedd5db9dfae07fb1f29ae15da90b1/dotnet-runtime-2.1.16-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d666bf27-e5d0-4cad-ae16-474b88cf6235/bf72e6c63a4c876ea0e5438365268a1a/dotnet-runtime-2.1.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f4bb7517-97b5-47e6-89c3-d7fd1ec0c905/dd7492dacebb2f815aad2942f9f98ef5/dotnet-runtime-2.1.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5f3cbfce-d76d-4d51-87a2-e6a460333d37/11cd1f4b33548a5c32a87de8d1c95667/dotnet-runtime-2.1.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f6eca37-4f5b-43c6-ae3f-72f3695de183/cb006c70c820d904b1a0425b9f5cae59/dotnet-runtime-2.1.16-win-x86.zip

[//]: # ( WindowsDesktop 2.1.16)

[//]: # ( ASP 2.1.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0312cc24-a7b9-4f0b-a568-e8358427f5f2/b85c525cb9cf1f8e044f2c06177219cf/aspnetcore-runtime-2.1.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c414945c-f69e-4a54-84c5-ef4f84842ed3/641a14bef2a4737f00b693d99fd1b0bc/aspnetcore-runtime-2.1.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b484e0dc-235b-43b5-8956-89d387c31c2d/68e41e2465147cbe508537b9ca70db64/aspnetcore-runtime-2.1.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34583c5c-cd52-4f0b-93a3-4671e089a26a/a0ec82ce0e0b4049ff039e772e2e9ac4/aspnetcore-runtime-2.1.16-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e97eb0e-7c06-4b6f-8dfc-492b10c537c2/6890daed9329abeff9cf6ecb8f66e87c/aspnetcore-runtime-2.1.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/163b8448-4586-4041-b094-28d9a9749e6d/269d7ee08654abaf9c0f671cadad93a0/aspnetcore-runtime-2.1.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/858d5354-3ae8-44a1-9bfc-d8e08c50d437/f9e0e11519597837d762a6d0fb31bca4/aspnetcore-runtime-2.1.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4a9a1e38-1b7e-4b47-a954-e9698845fffa/802cba0d946b4cfd1f59c4805f0e1b19/aspnetcore-runtime-2.1.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/783f01c8-5e85-4a26-b0f8-e2197cd37a5a/fe65d151ad17e0d64f868cb3b8855616/dotnet-hosting-2.1.16-win.exe

[//]: # ( SDK 2.1.512 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8e9e807-e290-4d6e-84e7-81cd79ae8542/cbe9d232869e16c03230d73da38f0c05/dotnet-sdk-2.1.512-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82f51d0d-d766-426d-9f62-2a58fb5beb17/8848ae51a7aff600a7bd029fd24a4287/dotnet-sdk-2.1.512-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c8b6691-6307-426f-be34-0484c82c2f16/9f613bfb38bfa61b289e937e95b3f769/dotnet-sdk-2.1.512-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b9e28c-4b82-47e0-b2d5-8cba61bcd076/b18b9aa9a3aaef3d3e74a51d8841657f/dotnet-sdk-2.1.512-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e9cd00c1-4c0b-4605-9ad8-454dc0e11727/6d9cb2593d7cacbc18415a248f6abcd7/dotnet-sdk-2.1.512-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04d61ce9-25c0-442e-8f97-d8fdfac06994/5bfcf2046270973b0d0f44b9e724d665/dotnet-sdk-2.1.512-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a28ac11-6c2c-443c-a718-c3efede3cc37/61b8490f83856a650ca8d59679e2484b/dotnet-sdk-2.1.512-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d6cdde91-e4ca-4db9-904a-f1276791944f/f8866e8bd14072d88f4d5fdd64fcbd13/dotnet-sdk-2.1.512-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9a7571ee-fc95-4cbc-ba14-ae6b6d07215e/1d815c6d941e4a0ecb66ff681244556c/dotnet-sdk-2.1.512-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1b78884d-0453-48a4-876a-2b8054d4d011/6a08821b865c6e7f36da847d8ffd6906/dotnet-sdk-2.1.512-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f11f82a7-b044-43e5-8167-4fcdb65bb8cd/96352d211163f2a7d73bdf9b0c3563f8/dotnet-sdk-2.1.512-win-x86.zip

[//]: # ( Symbols )

[//]: # ( Runtime 2.1.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/642b50a5-6d8e-468c-8983-2e4f52cb5cef/5f7de0d4eb4e2a2076ac026a37804a74/dotnet-runtime-2.1.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf06e231-6998-4237-9383-660ff2b096cf/05d4fbcba454cde64b63a100d880b501/dotnet-runtime-2.1.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f53383b6-f980-4561-b214-a6f2efd5f1ce/864c92809a322d80993eac826da498f3/dotnet-runtime-2.1.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf08e56f-f5bb-4a11-80e6-f3e663f1d2ae/b589c7600042c20ca48de32bb388f145/dotnet-runtime-2.1.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/70f7a735-567a-41ae-91ee-43ee0a12f907/7512ca026f0a4168d53d43b62ca2dee2/dotnet-runtime-2.1.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58b6c6f5-9a86-46c9-b185-23867c20ba6a/a517c07e52a0403a8dbdbad3e031ba53/dotnet-runtime-2.1.16-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aab4d0ea-5876-4bde-a87d-b1a12029b571/e079c0d61c2a163314981c8e072f3809/dotnet-runtime-2.1.16-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/14624816-e69c-479b-9747-01d461c09ad7/3661b2350f143c48e3f300c3bab743fa/dotnet-runtime-2.1.16-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/33f5e828-ac34-46d4-8d4b-2cd7aa89cad7/97e4361a356f466029c3c30fa7f6e778/dotnet-runtime-2.1.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/be05350a-bb89-40ae-b221-20a5d9a6bf6b/e4c01caf023d723515963fe04206e228/dotnet-runtime-2.1.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4b049376-acbb-47c2-b7ee-4a6391072cfd/9ce04542737026143b82d9d6c763ddd4/dotnet-runtime-2.1.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/671c727e-0d9c-4917-879d-e1067ee65d2f/c0939f16a6113f0e60b451c6e7d80526/dotnet-runtime-2.1.16-win-x86.zip

[//]: # ( WindowsDesktop 2.1.16)

[//]: # ( ASP 2.1.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5320e7dc-edb5-47da-b7a7-21f41d900df8/790d4fc9c0740753027e09e85b8f8b73/aspnetcore-runtime-2.1.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48c55817-a638-4efa-b01a-c6e109bebe6c/3ef6df9794ad3954340317e50edf0e0b/aspnetcore-runtime-2.1.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fa590c6-dbb4-41d2-81a1-d6650d3b390c/6f7c69995ebadeaa43fcd8872083cd58/aspnetcore-runtime-2.1.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf269e2e-4202-43fa-811e-e55aa86fc08d/8189293f3d624f68ab1cd99fa4ca03fe/aspnetcore-runtime-2.1.16-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/020c2ecb-cdb8-4ea0-bf4a-3e06e43e72f9/cdf754ac6ee692b270c37c5c34bdc8b1/aspnetcore-runtime-2.1.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c14d9b1-08aa-43a2-9266-3d18ad34b625/2b8ac6bc26085f66007dc6ec0af9705e/aspnetcore-runtime-2.1.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9afe37a3-47a2-4184-881c-69bfcb2e4ed7/e24dfa19aa5622ee399bdf1f99bbda86/aspnetcore-runtime-2.1.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eadccb14-3710-4c79-9f30-51c32840de1b/8b267a8f530a2409ed4c6888cad04360/aspnetcore-runtime-2.1.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5a059308-c27a-4223-b04d-0e815dce2cd0/10f528c237fed56192ea22283d81c409/dotnet-hosting-2.1.16-win.exe

[//]: # ( SDK 2.1.512 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0925365c-7054-4887-b54a-d19ccf815256/b905091a2dd235d01568627ebe910798/dotnet-sdk-2.1.512-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03a099c0-c240-484e-a301-d66790fa2b26/adc347091fa559a9b821da98cd945707/dotnet-sdk-2.1.512-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbc74bd2-11d9-4c98-80ab-de1409d35646/a65c13ec6940b14a2118880a886fb555/dotnet-sdk-2.1.512-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/326ff625-4f6d-440c-95bf-a9cecb63396a/a9206932a7493ceebcecc62b36e8f039/dotnet-sdk-2.1.512-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6e341d69-2393-43e8-abc8-952b191af9ed/f975eeed4a2b152cdfdad5eb6934677d/dotnet-sdk-2.1.512-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08c2e7be-1e80-43c5-877b-d2de421059f6/94ae355bb7cc23ab0f8181314d511c82/dotnet-sdk-2.1.512-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be338c91-bb76-48dd-98f0-e5655ebdf838/bb5ec78a2393612fa9346dfe01e08e74/dotnet-sdk-2.1.512-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e651460-8be6-4530-bfa9-e3d0bd7323ae/cd007b52ba0ffb21227083919870a827/dotnet-sdk-2.1.512-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/48d31be5-20b4-486a-ad90-04e6f56d2894/f31e810a8ad9197c42c9e25c3ed2a829/dotnet-sdk-2.1.512-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/458eda17-3e47-4b99-8c83-e762a8c1f41f/f19b0647f60580a94bcd49817e12586d/dotnet-sdk-2.1.512-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/794f499c-6746-49a0-a9fb-16c8ea6a36c8/8ab3d8d2a9fd7198a9620c8295b63293/dotnet-sdk-2.1.512-win-x86.zip

[//]: # ( Symbols )
