# .NET Core 2.1.804

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.804
* .NET Core Runtime 2.1.16
* ASP.NET Core 2.1.16

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.16/2.1.16.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |


1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.609](2.1.609-download.md) |
| Windows | Visual Studio 2017 | [2.1.512](2.1.16.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 2.1/stable –classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.16-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.16/2.1.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.16-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/




[//]: # ( Runtime 2.1.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1154ac1-c67b-4403-9fcd-7ea74db15940/6b747093fa4ef3cdf82a4f48f2f918bf/dotnet-runtime-2.1.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68a9089a-d7a9-4df8-bef3-07823c85c985/e12aaa871454d8d58b8c76f4224e3304/dotnet-runtime-2.1.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3ee1032-49f8-4135-b1cb-4db12425762e/ca3920fc3593576d9b6ed780f121c3ee/dotnet-runtime-2.1.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55d69fac-3c70-48da-ab75-a11732ea41fd/35a62311fe92ff96dfd6b4121078bbbd/dotnet-runtime-2.1.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fd9b3790-0a70-4bfd-bb76-0cfa5501d5ae/875f08c18afaa5b083a4845c8534427d/dotnet-runtime-2.1.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69cb2041-a16a-4ac1-a7d8-79a92e64c32a/e3fa8a41d1c592cfd455a6867ab9a1b8/dotnet-runtime-2.1.16-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73f1cb6e-3ffe-42ca-9d59-374b5e4fea9c/0b77418b9408a85f88dc3999f52865f4/dotnet-runtime-2.1.16-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/abc50270-cbf1-41fd-b974-7cab384b285b/7feedd5db9dfae07fb1f29ae15da90b1/dotnet-runtime-2.1.16-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d666bf27-e5d0-4cad-ae16-474b88cf6235/bf72e6c63a4c876ea0e5438365268a1a/dotnet-runtime-2.1.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f4bb7517-97b5-47e6-89c3-d7fd1ec0c905/dd7492dacebb2f815aad2942f9f98ef5/dotnet-runtime-2.1.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5f3cbfce-d76d-4d51-87a2-e6a460333d37/11cd1f4b33548a5c32a87de8d1c95667/dotnet-runtime-2.1.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f6eca37-4f5b-43c6-ae3f-72f3695de183/cb006c70c820d904b1a0425b9f5cae59/dotnet-runtime-2.1.16-win-x86.zip

[//]: # ( WindowsDesktop 2.1.16)

[//]: # ( ASP 2.1.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0312cc24-a7b9-4f0b-a568-e8358427f5f2/b85c525cb9cf1f8e044f2c06177219cf/aspnetcore-runtime-2.1.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c414945c-f69e-4a54-84c5-ef4f84842ed3/641a14bef2a4737f00b693d99fd1b0bc/aspnetcore-runtime-2.1.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b484e0dc-235b-43b5-8956-89d387c31c2d/68e41e2465147cbe508537b9ca70db64/aspnetcore-runtime-2.1.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34583c5c-cd52-4f0b-93a3-4671e089a26a/a0ec82ce0e0b4049ff039e772e2e9ac4/aspnetcore-runtime-2.1.16-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e97eb0e-7c06-4b6f-8dfc-492b10c537c2/6890daed9329abeff9cf6ecb8f66e87c/aspnetcore-runtime-2.1.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/163b8448-4586-4041-b094-28d9a9749e6d/269d7ee08654abaf9c0f671cadad93a0/aspnetcore-runtime-2.1.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/858d5354-3ae8-44a1-9bfc-d8e08c50d437/f9e0e11519597837d762a6d0fb31bca4/aspnetcore-runtime-2.1.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4a9a1e38-1b7e-4b47-a954-e9698845fffa/802cba0d946b4cfd1f59c4805f0e1b19/aspnetcore-runtime-2.1.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/783f01c8-5e85-4a26-b0f8-e2197cd37a5a/fe65d151ad17e0d64f868cb3b8855616/dotnet-hosting-2.1.16-win.exe

[//]: # ( SDK 2.1.804 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22123f10-a2bc-486b-81d9-ce67889b0b90/2aa4f985999dad2f7a8c6a84bcdd591d/dotnet-sdk-2.1.804-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50645f34-f3dd-45e8-80cc-231c34da6b21/7390b6302c466fc407758093d5e915cd/dotnet-sdk-2.1.804-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c468e75-b1ef-4b41-88c2-59dbd645fcdf/32337541ffbba0ec7e89bf0392a7e11e/dotnet-sdk-2.1.804-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c4d5cc1-3ce5-4298-aa8c-56d2befc5474/60d79468f9b770d116bb7a5a1937abd8/dotnet-sdk-2.1.804-linux-x64.tar.gz
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b530c5b6-855c-4810-9d22-a3dc42ab0338/8fc82d06db18ad614ee7e50d265e22b0/dotnet-sdk-2.1.804-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d539e23c-8265-4358-b71f-fe9dcb48c464/8ad8a50e82b952b17cfbf3c97e7b82af/dotnet-sdk-2.1.804-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0ec90d98-54fd-4bfc-9f36-c946abf15d9e/852c978e4377c898f5ccd36b1663cd55/dotnet-sdk-2.1.804-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/65e1d6ca-0f71-442c-8e9f-88127df46bad/497378e04707fec0f04458c82c73b035/dotnet-sdk-2.1.804-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c767afcc-6106-4fa6-99bf-d68bc0259205/002aabc810d17f2940c3db554b8f3f4d/dotnet-sdk-2.1.804-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/80cd608f-f1b6-40e0-a76d-c08deb9b64eb/588b721ec845afdd47c8730dc7a141b0/dotnet-sdk-2.1.804-win-x86.zip

[//]: # ( WindowsDesktop 2.1.16)

[//]: # ( Symbols )

[//]: # ( Runtime 2.1.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/642b50a5-6d8e-468c-8983-2e4f52cb5cef/5f7de0d4eb4e2a2076ac026a37804a74/dotnet-runtime-2.1.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf06e231-6998-4237-9383-660ff2b096cf/05d4fbcba454cde64b63a100d880b501/dotnet-runtime-2.1.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f53383b6-f980-4561-b214-a6f2efd5f1ce/864c92809a322d80993eac826da498f3/dotnet-runtime-2.1.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf08e56f-f5bb-4a11-80e6-f3e663f1d2ae/b589c7600042c20ca48de32bb388f145/dotnet-runtime-2.1.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/70f7a735-567a-41ae-91ee-43ee0a12f907/7512ca026f0a4168d53d43b62ca2dee2/dotnet-runtime-2.1.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58b6c6f5-9a86-46c9-b185-23867c20ba6a/a517c07e52a0403a8dbdbad3e031ba53/dotnet-runtime-2.1.16-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aab4d0ea-5876-4bde-a87d-b1a12029b571/e079c0d61c2a163314981c8e072f3809/dotnet-runtime-2.1.16-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/14624816-e69c-479b-9747-01d461c09ad7/3661b2350f143c48e3f300c3bab743fa/dotnet-runtime-2.1.16-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/33f5e828-ac34-46d4-8d4b-2cd7aa89cad7/97e4361a356f466029c3c30fa7f6e778/dotnet-runtime-2.1.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/be05350a-bb89-40ae-b221-20a5d9a6bf6b/e4c01caf023d723515963fe04206e228/dotnet-runtime-2.1.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4b049376-acbb-47c2-b7ee-4a6391072cfd/9ce04542737026143b82d9d6c763ddd4/dotnet-runtime-2.1.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/671c727e-0d9c-4917-879d-e1067ee65d2f/c0939f16a6113f0e60b451c6e7d80526/dotnet-runtime-2.1.16-win-x86.zip

[//]: # ( WindowsDesktop 2.1.16)

[//]: # ( ASP 2.1.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5320e7dc-edb5-47da-b7a7-21f41d900df8/790d4fc9c0740753027e09e85b8f8b73/aspnetcore-runtime-2.1.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48c55817-a638-4efa-b01a-c6e109bebe6c/3ef6df9794ad3954340317e50edf0e0b/aspnetcore-runtime-2.1.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fa590c6-dbb4-41d2-81a1-d6650d3b390c/6f7c69995ebadeaa43fcd8872083cd58/aspnetcore-runtime-2.1.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf269e2e-4202-43fa-811e-e55aa86fc08d/8189293f3d624f68ab1cd99fa4ca03fe/aspnetcore-runtime-2.1.16-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/020c2ecb-cdb8-4ea0-bf4a-3e06e43e72f9/cdf754ac6ee692b270c37c5c34bdc8b1/aspnetcore-runtime-2.1.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c14d9b1-08aa-43a2-9266-3d18ad34b625/2b8ac6bc26085f66007dc6ec0af9705e/aspnetcore-runtime-2.1.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9afe37a3-47a2-4184-881c-69bfcb2e4ed7/e24dfa19aa5622ee399bdf1f99bbda86/aspnetcore-runtime-2.1.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eadccb14-3710-4c79-9f30-51c32840de1b/8b267a8f530a2409ed4c6888cad04360/aspnetcore-runtime-2.1.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5a059308-c27a-4223-b04d-0e815dce2cd0/10f528c237fed56192ea22283d81c409/dotnet-hosting-2.1.16-win.exe

[//]: # ( SDK 2.1.804 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/365bc2c9-eb08-4c17-b462-e4addba6dd0a/5101726ab1e41e751c169e3b735357fc/dotnet-sdk-2.1.804-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d8b6ed1-e489-4e68-bc88-201801435297/bfe788aeab04d79507d940675ee6f27b/dotnet-sdk-2.1.804-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4546f2c5-3ec8-4d0d-a47d-ba44b58a2a3f/4b5319fcb0ec675d3a05cdc4d6c65c80/dotnet-sdk-2.1.804-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ba4d9b0-3fca-40ed-b5a2-1552dfa4f89e/8e5e555b543a7afd8fd764e080d25671/dotnet-sdk-2.1.804-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f845905d-89d4-4e47-b2ec-398e47ff8411/2f49da28650e5259e694aa7321dcf935/dotnet-sdk-2.1.804-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d378181-83f9-4a91-a25f-b823edba34a4/313ea90f4e72678fca86dffa6223fee5/dotnet-sdk-2.1.804-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0514c39f-3e3b-4e1c-804a-04f143b9b7a7/0faf3ad41cdb40bc274809b61ea72127/dotnet-sdk-2.1.804-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b2730cab-bf3e-4fd5-836a-262960e0f65d/89fabb24ebb624d1fb212b26451a402c/dotnet-sdk-2.1.804-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e571ccd9-4aaa-49be-bd94-da08b7b39dd4/45d4a2d7e585f98a00fec2c7daadff8b/dotnet-sdk-2.1.804-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0320343a-6431-457e-bdd3-bfb85fa213a3/e69ccb9ad66b4b80d90b414b095671ac/dotnet-sdk-2.1.804-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a36f89d0-817b-445a-894d-f02851e39c89/6d675df4531974f37c7a923810fa5951/dotnet-sdk-2.1.804-win-x86.zip


[//]: # ( Symbols )

