# .NET Core July 2018 Update - July 10, 2018

.NET Core 2.1.2 is available for download and usage in your environment. This release includes .NET Core 2.1.2, ASP.NET Core 2.1.2 and .NET Core SDK 2.1.302.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-212)
* [Known Issues](2.1-known-issues.md)
* [Lifecycle](#.net-core-lifecycle-news)

Visit the [.NET Core blog][dotnet-blog] to read more about this release. Your feedback is important and appreciated. We've created an issue at [dotnet/core #1765](https://github.com/dotnet/core/issues/1765) for your questions and comments.

## Downloads

|           | SDK Installer*                                   | SDK Binaries*                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br> [Hosting Bundle][hosting-win-x64.exe] |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]
| Linux     | [See installations steps below][linux-install]   | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm-x32] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm-x32] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]  \| [ARM32][asp-runtime-linux-arm-x86] \| [x64 Alpine][asp-runtime-linux-musl-x64] |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][symbols-coreclr] \| [Shared Framework][symbols-corefx] \| [Setup][symbols-core-setup] | - | [ASP.NET Core][symbols-aspnetcore] |

\* Includes the .NET Core and ASP.NET Core runtimes

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)
* [microsoft/aspnetcore](https://hub.docker.com/r/microsoft/aspnetcore)
* [microsoft/aspnetcore-build](https://hub.docker.com/r/microsoft/aspnetcore-build)

### Azure AppServices

* Deployment of .NET Core 2.1.2 to Azure App Services has been completed and is available in all regions.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

### Supported Linux version changes

Fedora 26 and Ubuntu 17.10 will reach end of life in July. This is the last update of .NET Core which will support these versions.

## Notable Changes in 2.1.2

### [CVE-2018-8356: .NET Core Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/73)

**Executive summary**

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a security feature bypass vulnerability that exists when .NET Core does not correctly validate certificates. An attacker who successfully exploited this vulnerability could present an expired certificate when challenged.

The update addresses the vulnerability by correcting how .NET Core applications handle certificate validation.

#### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
System.Private.ServiceModel | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Duplex | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Http | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.NetTcp | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Primitives | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Security | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |

### [CVE-2018-8171: ASP.NET Core Security Feature Bypass Vulnerability](https://github.com/aspnet/Announcements/issues/310)

**Executive summary**

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a security feature bypass in ASP.NET Core when the number of incorrect login attempts is not validated. An attacker who successfully exploited this vulnerability could try an infinite number of authentication attempts.

The update addresses the vulnerability by correcting how ASP.NET Core validates the number of incorrect login attempts.

#### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
Microsoft.AspNetCore.Identity | 1.0.0, 1.0.1, 1.0.2, 1.0.3, 1.0.4, 1.0.5 <br> 1.1.0, 1.1.1, 1.1.2, 1.1.3, 1.1.4, 1.1.5 <br> 2.0.0, 2.0.1, 2.0.2, 2.0.3 <br> 2.1.0, 2.1.1 | 1.0.6 <br> 1.1.6 <br> 2.0.4 <br> 2.1.2 |

### [July 2018: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/311)

**Executive summary**

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.0 and 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability in ASP.NET Core when a malformed request is terminated. An attacker who successfully exploited this vulnerability could cause a denial of service attack.

The update addresses the vulnerability by correcting how ASP.NET Core handles such requests.

#### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
Microsoft.AspNetCore.Server.Kestrel.Core | 2.0.0, 2.0.1, 2.0.2, 2.0.3 <br> 2.1.0, 2.1.1 | 2.0.4 <br> 2.1.2 |
Microsoft.AspNetCore.All | 2.0.0, 2.0.1, 2.0.2, 2.0.3, 2.0.4, 2.0.5 <br> 2.0.6, 2.0.7, 2.0.8 <br> 2.1.0, 2.1.1 <br> | 2.0.9 <br> 2.1.2 |
Microsoft.AspNetCore.App | 2.1.0, 2.1.1 | 2.1.2 |

[dlc-runtime]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/
[dlc-sdk]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/2.1.2/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/2.1.302/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.2.md

[runtime-linux-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-x64.tar.gz
[runtime-linux-arm-x32]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm64.tar.gz
[runtime-rhel.6-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-rhel.6-x64.tar.gz
[runtime-mac-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.pkg
[runtime-win-x86]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.zip
[runtime-win-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.zip
[runtime-win-x86.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.exe
[runtime-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.exe

[sdk-linux-x64]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-x64.tar.gz
[sdk-linux-arm-x32]:  https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-arm.tar.gz
[sdk-linux-arm-x64]:  https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-arm64.tar.gz
[sdk-linux-musl-x64]:  https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-musl-x64.tar.gz
[sdk-mac-x64]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/2.1.302/dotnet-sdk-2.1.302-osx-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-osx-x64.pkg
[sdk-mac-x64.pkg-gs]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-osx-gs-x64.pkg
[sdk-win-x86]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x86.zip
[sdk-win-x64]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x64.zip
[sdk-win-x86.exe]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x86.exe
[sdk-win-x86.exe-gs]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-gs-x86.exe
[sdk-win-x64.exe]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x64.exe
[sdk-win-x64.exe-gs]: https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-gs-x64.exe
[sdk-rhel.6-x64]:  https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-rhel.6-x64.tar.gz

[hosting-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-hosting-2.1.2-win.exe
[asp-runtime-linux-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-x64.tar.gz
[asp-runtime-linux-arm-x86]:  https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-musl-x64.tar.gz
[asp-runtime-mac-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x64.exe
[asp-runtime-win-x86.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x86.exe
[asp-runtime-win-x86]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x86.zip
[asp-runtime-win-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x64.zip

[symbols-aspnetcore]: https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/aspnet-2.1.2-symbols.zip
[symbols-coreclr]: https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/coreclr-2.1.2-symbols.zip
[symbols-corefx]: https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/corefx-2.1.2-symbols.zip
[symbols-core-setup]: https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/core-setup-2.1.2-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.2-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.302-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2018/07/10/net-core-july-2018-update/
