# .NET Core 2.1.816

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.816
* .NET Core Runtime 2.1.28
* ASP.NET Core 2.1.28

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.28/2.1.28.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-setup]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup>
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |


1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.524](2.1.28.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together.

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 2.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it won't conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The following commands don't specifically include package managers to help with readability. Here are the package managers typically used by the distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP.NET Core Runtime and .NET Core Runtime.

## Windows Server Hosting

If you're looking to host standalone apps on servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.28-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.28/2.1.28.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.28-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.28-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux


[//]: # ( Runtime 2.1.28)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cae3152-429c-4992-b2f1-83b07f925421/89d02520b0f2ef641b436c45909e689b/dotnet-runtime-2.1.28-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4af029ad-99e6-40a4-b927-a4cd79f47f7c/3ec70f13b0cb0323df22cd7b59ffb980/dotnet-runtime-2.1.28-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f38cb438-29cf-4a1e-b6c8-d2dd32246738/554d91dec92633a5dcf8523031de8ea9/dotnet-runtime-2.1.28-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95e68908-4a59-4adb-a44f-116914572423/7f8ee037851be82c8a583f47ee2969a7/dotnet-runtime-2.1.28-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a8f778c-ea65-410c-af5a-92157867242c/eb2bdb045e80feb1abee7379d564014a/dotnet-runtime-2.1.28-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4dea9288-0fc5-4a34-9b34-67a75fdb3c5a/7cd3fea18a3497b6b4036cd1870fc0e7/dotnet-runtime-2.1.28-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ba7836b6-bee6-476e-9a79-8c7de81859b5/1f9afd284d8e74f3cbd681ad1e918b47/dotnet-runtime-2.1.28-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e61b270-52e5-45f7-90a9-b19c41311cb9/5bdc26bef54286b1724dd72c65bd3777/dotnet-runtime-2.1.28-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/331d855f-6ee0-4670-8747-1073ab8eaaf5/8147b578e658cf3417f39bafffee029f/dotnet-runtime-2.1.28-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/51f11589-d908-40ef-80b1-f765c0145ee4/710f52b2fa2f06da78ea52c1eb8141d3/dotnet-runtime-2.1.28-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dcaf05c7-0d60-4ce3-a156-4e3e506c5be2/059659be59dc450ef34008c9f1f973fe/dotnet-runtime-2.1.28-win-x86.zip

[//]: # ( ASP 2.1.28)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbdb615e-48c3-4646-9b90-76a5a15b4562/cc878beda4838f0cf7155c12036cc511/aspnetcore-runtime-2.1.28-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a917a51-3aa7-41d5-bb6b-de9221d7b28f/4ccd9b1315e571d921469c3c7f18cd14/aspnetcore-runtime-2.1.28-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66483281-5453-4504-9686-f72d1fd357f7/0de98386ca1709bde2b5f2f7df4c80da/aspnetcore-runtime-2.1.28-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bcf8163-d9b5-410c-90e8-89315640794f/9a891b6d67e6d9f421aba1defed2e927/aspnetcore-runtime-2.1.28-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bd462316-665c-48a0-bba3-7b6d8675fda7/8b1d772d8abf1c83ea01a2dbd144ba80/aspnetcore-runtime-2.1.28-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ac76841e-9b96-4a0b-ba26-2fe37bd8df64/304db7abae0fcb1801c8f26be86ad62a/aspnetcore-runtime-2.1.28-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8d8691f6-8cae-4ce5-b56f-398a2bc062a0/b364e46ea00c13bdb30d518d4d2765d2/aspnetcore-runtime-2.1.28-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/137e0c77-b999-4f22-be7e-5bac7898237f/6d731bdc005d43d5849f07cccd56404f/aspnetcore-runtime-2.1.28-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/50a47fa0-aff0-44d2-a4ef-0d7c608101e6/3bdef1208816793d6775b6d1912ab81f/dotnet-hosting-2.1.28-win.exe

[//]: # ( SDK 2.1.816 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ea408766-09d2-4380-87c4-06648783d0f3/eacfa729764eb187057c864bf2d0099d/dotnet-sdk-2.1.816-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/364c342f-4bdb-446a-acb2-849d15521857/6924364bd7d88c64201d6afff0a28821/dotnet-sdk-2.1.816-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59c275f6-1002-48aa-ada0-3379aca30315/0c56d045a2e1b96af9310eb55e6eefb9/dotnet-sdk-2.1.816-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/745ce65b-e1b7-442d-aebf-8fe18c4fceba/73d02f94e66602d4b6531b0b2003c798/dotnet-sdk-2.1.816-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/277c5dde-2b75-4157-9f84-f596b59d8972/550b12c5fb217701b6e87be925b771fa/dotnet-sdk-2.1.816-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bab2bbde-8af1-41fb-84cb-2421320ac5f7/9f86d7b193410f72dab4adcf3210c6bd/dotnet-sdk-2.1.816-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0d291e03-45d3-441e-8368-9e4b9ab183b4/b93203d22edecfcb17b6b479b54491df/dotnet-sdk-2.1.816-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/01afc7b8-49e9-4455-b525-b01f0f531a5f/d3f240d79b78f1cdb5fc115bc0dc9eec/dotnet-sdk-2.1.816-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/383e9184-4b14-48cb-b0f9-c3c62d1d08ac/fef5d78eee266c169d0bdffc9c2a781a/dotnet-sdk-2.1.816-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2d21117e-2194-4114-9718-622538890891/63b3af75f8675c8533fa34a6e3c42caf/dotnet-sdk-2.1.816-win-x86.zip
