# .NET Core October 2018 Update - October 2, 2018

.NET Core 2.1.5 is available for [download](2.1.5-download.md) and usage in your environment. This release includes .NET Core 2.1.5, ASP.NET Core 2.1.5 and .NET Core SDK 2.1.403. All fixes of note can be seen in the [2.1.5 commits](2.1.5-commits.md) list.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-215)
* [Known Issues](../2.1-known-issues.md)
* [Lifecycle](#net-core-lifecycle-news)

Visit the [.NET Core blog][dotnet-blog] to read more about this release. Your feedback is important and appreciated. We've created an issue at [dotnet/core.issues](https://github.com/dotnet/core/issues/) for your questions and comments.

## Downloads

|           | SDK Installer*                                   | SDK Binaries*                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br> [Hosting Bundle][hosting-win-x64.exe] |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]
| Linux     | [x64][linux-install]                             | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]  \| [ARM32][asp-runtime-linux-arm] \| [x64 Alpine][asp-runtime-linux-musl-x64] |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols] \| [SDK][dotnet-sdk-symbols]  | -                                        | [Runtime][coreclr-symbols] \| [Shared Framework][corefx-symbols] \| [Setup][core-setup-symbols] | - | [ASP.NET Core][aspnet-symbols] |

\* Includes the .NET Core and ASP.NET Core runtimes

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* Deployment of .NET Core 2.1.5 to Azure App Services will begin on today, October 2, 2018. Deployment will proceed to additional regions and is expected to complete by the end of the week.

## .NET Core Lifecycle News

.NET Core 2.0 went end-of-life yesterday, October 1, 2018 (see [announcement](https://github.com/dotnet/announcements/issues/86)). This means 2.0 is no longer eligible for updates and builds will no longer be provided.

2.1 was declared LTS last month (see [announcement](https://blogs.msdn.microsoft.com/dotnet/2018/08/21/net-core-august-2018-update/)) which began the end of life clock for 1.0 and 1.1. If remaining on the LTS channel is important to you, begin planning to migrate existing 1.0/1.1 applications to 2.1 before support for these channels ends on June 27, 2019.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Notable Changes in 2.1.5

This release includes a number of impactful fixes. Please see the [commit list](2.1.5-commits.md) for details. The commit list now includes details for ASP.NET Core and EntityFrameworkCore.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.5/2.1.5.md

[runtime-linux-arm]: https://download.visualstudio.microsoft.com/download/pr/4d555219-1f04-47c6-90e5-8b3ff8989b9c/0798763e6e4b98a62846116f997d046e/dotnet-runtime-2.1.5-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.visualstudio.microsoft.com/download/pr/42912b6c-fab3-4666-a467-65e1ecbfc4b3/44f1a69971dd0c81de9ede19393de24c/dotnet-runtime-2.1.5-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.visualstudio.microsoft.com/download/pr/8b757bfd-de6c-4c72-8d73-abfa6d7bae35/54a47a57feccb5277e0973e17142caa6/dotnet-runtime-2.1.5-linux-arm64.tar.gz
[runtime-linux-x64]: https://download.visualstudio.microsoft.com/download/pr/05a71d80-3e59-4f1f-8298-2697013e261c/be191f2f4f4db74c29030008ed3632f0/dotnet-runtime-2.1.5-linux-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b83df670-529a-4d28-b4f5-81c46d339ef9/6d23d425c2b0ffd9828c521dbf19ef63/dotnet-runtime-2.1.5-osx-x64.pkg
[runtime-mac-x64]: https://download.visualstudio.microsoft.com/download/pr/eafd1d99-8824-4af0-8924-df9050d2265f/76094b7c8d80390504eba6ec08e4044a/dotnet-runtime-2.1.5-osx-x64.tar.gz
[runtime-rhel.6-x64]: https://download.visualstudio.microsoft.com/download/pr/5b4b7ccd-7167-42f8-9111-bd7f09cc7b1c/fc68d0ca7566224ec99b56df25b7f9ee/dotnet-runtime-2.1.5-rhel.6-x64.tar.gz
[runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2781df30-e8c8-4c96-a317-a369a1d27b88/d70f97bfd35b88fe6e2b5410b3655247/dotnet-runtime-2.1.5-win-x64.exe
[runtime-win-x64]: https://download.visualstudio.microsoft.com/download/pr/ce443d89-75f1-4122-aaa8-c094a9017b4a/255b06ace4207a8ee923758160ed01c3/dotnet-runtime-2.1.5-win-x64.zip
[runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4d7f6916-827d-4047-8abd-30dd6db910e9/694eaa49bbf7bb574b75429ed101035c/dotnet-runtime-2.1.5-win-x86.exe
[runtime-win-x86]: https://download.visualstudio.microsoft.com/download/pr/256f1cce-ad71-4ebe-ae45-5be6b7d4edb8/68f8caf678adde0af55266e955556c74/dotnet-runtime-2.1.5-win-x86.zip
[asp-runtime-linux-arm]: https://download.visualstudio.microsoft.com/download/pr/6253ecc6-4af6-42ac-a965-33a864a79a3b/b4ba7e62c5318106fd55aaa17b4335de/aspnetcore-runtime-2.1.5-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.visualstudio.microsoft.com/download/pr/c283d1d5-b4c7-4d9b-bab5-b78c6d03887f/e6ba9246446aa885f935e2245acbbedd/aspnetcore-runtime-2.1.5-linux-musl-x64.tar.gz
[asp-runtime-linux-x64]: https://download.visualstudio.microsoft.com/download/pr/97fce50e-e736-41c3-a700-d83d43178197/4c00b063affdbc940dd16f62c68d1505/aspnetcore-runtime-2.1.5-linux-x64.tar.gz
[asp-runtime-mac-x64]: https://download.visualstudio.microsoft.com/download/pr/48c6f111-9195-46bd-8115-dcbf8a954bba/4c011f106cfc78e8344ca50b0a08d056/aspnetcore-runtime-2.1.5-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/74b2ff3f-b288-4b4c-9b11-3ef77100ef5a/b0b90830e6b1050afec21c556d1b3733/aspnetcore-runtime-2.1.5-win-x64.exe
[asp-runtime-win-x64]: https://download.visualstudio.microsoft.com/download/pr/6abfd5c4-f9e2-41fb-9363-fd60e3f9132f/1a5d3c82408f5e27b0e83be8c7f1ae42/aspnetcore-runtime-2.1.5-win-x64.zip
[asp-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e3470fc1-4b89-4ef1-af3b-bf4fe57195f8/ae80490e90972949886a36816490f3ff/aspnetcore-runtime-2.1.5-win-x86.exe
[asp-runtime-win-x86]: https://download.visualstudio.microsoft.com/download/pr/de489207-08c5-4bb1-9b66-641528ea6ca2/03bd984cb700799179dca77dadf3a003/aspnetcore-runtime-2.1.5-win-x86.zip
[hosting-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/86df96bb-384c-4d7a-82ce-2e4c2c871189/045870c1ab4004219cb312039c5a64d5/dotnet-hosting-2.1.5-win.exe
[sdk-linux-arm-x64]: https://download.visualstudio.microsoft.com/download/pr/00038a67-bb86-4c39-88df-7c0998002a9e/97de51fd691c68e18ddd3dcaf3d60181/dotnet-sdk-2.1.403-linux-arm64.tar.gz
[sdk-linux-arm]: https://download.visualstudio.microsoft.com/download/pr/10b96626-02d8-415a-be85-051a2a48d0c2/5ec51d3d9f092ba558fb5f1f03d26699/dotnet-sdk-2.1.403-linux-arm.tar.gz
[sdk-linux-musl-x64]: https://download.visualstudio.microsoft.com/download/pr/527fff7b-1862-4d2e-ab78-94c6cca188bc/8c62477e25ac1448c93ed4a8da11cc37/dotnet-sdk-2.1.403-linux-musl-x64.tar.gz
[sdk-linux-x64]: https://download.visualstudio.microsoft.com/download/pr/e85de743-f80b-481b-b10e-d2e37f05a7ce/0bf3ff93417e19ad8d6b2d3ded84d664/dotnet-sdk-2.1.403-linux-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/38102737-cb48-46c2-8f52-fb7102b50ae7/d81958d71c3c2679796e1ecfbd9cc903/dotnet-sdk-2.1.403-osx-x64.pkg
[sdk-mac-x64.pkg-gs]:  https://download.visualstudio.microsoft.com/download/pr/38102737-cb48-46c2-8f52-fb7102b50ae7/d81958d71c3c2679796e1ecfbd9cc903/dotnet-sdk-2.1.403-osx-x64.pkg
[sdk-mac-x64]: https://download.visualstudio.microsoft.com/download/pr/fcdaa140-a2a3-46cf-bab1-e211e7d070c8/9498335457a65063ec789e5532020cf7/dotnet-sdk-2.1.403-osx-x64.tar.gz
[sdk-rhel.6-x64]: https://download.visualstudio.microsoft.com/download/pr/db34d22e-e7ca-4883-a35e-b3d864a5b330/c5f9d14eb4630686574eba29b0049470/dotnet-sdk-2.1.403-rhel.6-x64.tar.gz
[sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/45f93081-cdb4-41c1-8d8d-e6c3bbf2872b/62d6a598956fdfe585acb1f15268d930/dotnet-sdk-2.1.403-win-x64.exe
[sdk-win-x64.exe-gs]:  https://download.visualstudio.microsoft.com/download/pr/45f93081-cdb4-41c1-8d8d-e6c3bbf2872b/62d6a598956fdfe585acb1f15268d930/dotnet-sdk-2.1.403-win-x64.exe
[sdk-win-x64]: https://download.visualstudio.microsoft.com/download/pr/28820b2a-0aec-4c24-a271-a14bcb3e2686/5e0ad8ae32f1497e8d0cace2447b9e01/dotnet-sdk-2.1.403-win-x64.zip
[sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c0aa84bb-3da1-4bce-9434-7036e94ae4b2/6d4fb01377f1f1eebb0997289dc8ecfb/dotnet-sdk-2.1.403-win-x86.exe
[sdk-win-x86.exe-gs]:  https://download.visualstudio.microsoft.com/download/pr/c0aa84bb-3da1-4bce-9434-7036e94ae4b2/6d4fb01377f1f1eebb0997289dc8ecfb/dotnet-sdk-2.1.403-win-x86.exe
[sdk-win-x86]: https://download.visualstudio.microsoft.com/download/pr/849dd909-5412-4b79-a66b-b173d462d0f2/a75544b6df62239374e77e78d9a5899f/dotnet-sdk-2.1.403-win-x86.zip

[aspnet-symbols]: https://download.visualstudio.microsoft.com/download/pr/cd19548d-5b4b-49dc-b33b-be0fff2c814d/f92efb317bd7864097ef824174e6ded7/aspnet-2.1.5-symbols.zip
[cli-symbols]: https://download.visualstudio.microsoft.com/download/pr/d3d1518b-c3ad-445c-a6a4-bc31691517f1/cb22f3c8e70ccacfc9dbb74748d11ee8/cli-2.1.5-symbols.zip
[core-setup-symbols]: https://download.visualstudio.microsoft.com/download/pr/b7ea7023-1d3e-4b6c-956f-fd95acddaf34/93db59925f87bf2088f262ea29536ced/core-setup-2.1.5-symbols.zip
[coreclr-symbols]: https://download.visualstudio.microsoft.com/download/pr/26b24856-99c8-4caf-a5b4-81502b2df64f/ff4916b6eb2370d79241510511f845a6/coreclr-2.1.5-symbols.zip
[corefx-symbols]: https://download.visualstudio.microsoft.com/download/pr/d9ee037a-60e6-4efc-aa09-27c8b2f6c5df/73556861aecee927a870c2afb10576aa/corefx-2.1.5-symbols.zip
[dotnet-sdk-symbols]: https://download.visualstudio.microsoft.com/download/pr/f5348f78-7a05-40c3-9b5d-240f9f96162e/90b6da7e4ed745894884ea596b22335a/dotnet-sdk-2.1.5-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.5-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.403-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2018/10/02/net-core-october-2018-update/
