# System.Reflection.PortableExecutable

``` diff
 namespace System.Reflection.PortableExecutable {
     public sealed class DebugDirectoryBuilder {
+        public void AddEntry(DebugDirectoryEntryType type, uint version, uint stamp);
+        public void AddEntry<TData>(DebugDirectoryEntryType type, uint version, uint stamp, TData data, Action<BlobBuilder, TData> dataSerializer);
+        public void AddPdbChecksumEntry(string algorithmName, ImmutableArray<byte> checksum);
     }
     public enum DebugDirectoryEntryType {
+        PdbChecksum = 19,
     }
     public enum Machine : ushort {
+        Arm64 = (ushort)43620,
     }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PdbChecksumDebugDirectoryData {
+        public string AlgorithmName { get; }
+        public ImmutableArray<byte> Checksum { get; }
+    }
     public sealed class PEReader : IDisposable {
+        public PdbChecksumDebugDirectoryData ReadPdbChecksumDebugDirectoryData(DebugDirectoryEntry entry);
     }
 }
```

