# System.Text

``` diff
 namespace System.Text {
     public abstract class Decoder {
+        public virtual void Convert(ReadOnlySpan<byte> bytes, Span<char> chars, bool flush, out int bytesUsed, out int charsUsed, out bool completed);
+        public virtual int GetCharCount(ReadOnlySpan<byte> bytes, bool flush);
+        public virtual int GetChars(ReadOnlySpan<byte> bytes, Span<char> chars, bool flush);
     }
     public abstract class Encoder {
+        public virtual void Convert(ReadOnlySpan<char> chars, Span<byte> bytes, bool flush, out int charsUsed, out int bytesUsed, out bool completed);
+        public virtual int GetByteCount(ReadOnlySpan<char> chars, bool flush);
+        public virtual int GetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, bool flush);
     }
     public abstract class Encoding : ICloneable {
+        public virtual ReadOnlySpan<byte> Preamble { get; }
+        public virtual int GetByteCount(ReadOnlySpan<char> chars);
+        public virtual int GetBytes(ReadOnlySpan<char> chars, Span<byte> bytes);
+        public virtual int GetCharCount(ReadOnlySpan<byte> bytes);
+        public virtual int GetChars(ReadOnlySpan<byte> bytes, Span<char> chars);
+        public string GetString(ReadOnlySpan<byte> bytes);
     }
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder Append(ReadOnlySpan<char> value);
+        public StringBuilder Append(StringBuilder value);
+        public StringBuilder Append(StringBuilder value, int startIndex, int count);
+        public void CopyTo(int sourceIndex, Span<char> destination, int count);
+        public bool Equals(ReadOnlySpan<char> span);
+        public StringBuilder Insert(int index, ReadOnlySpan<char> value);
     }
 }
```

