# System.Threading.Tasks.Sources

``` diff
+namespace System.Threading.Tasks.Sources {
+    public interface IValueTaskSource {
+        void GetResult(short token);
+        ValueTaskSourceStatus GetStatus(short token);
+        void OnCompleted(Action<object> continuation, object state, short token, ValueTaskSourceOnCompletedFlags flags);
+    }
+    public interface IValueTaskSource<out TResult> {
+        TResult GetResult(short token);
+        ValueTaskSourceStatus GetStatus(short token);
+        void OnCompleted(Action<object> continuation, object state, short token, ValueTaskSourceOnCompletedFlags flags);
+    }
+    public enum ValueTaskSourceOnCompletedFlags {
+        FlowExecutionContext = 2,
+        None = 0,
+        UseSchedulingContext = 1,
+    }
+    public enum ValueTaskSourceStatus {
+        Canceled = 3,
+        Faulted = 2,
+        Pending = 0,
+        Succeeded = 1,
+    }
+}
```

