# System

``` diff
 namespace System {
-    public class ArgumentException : SystemException, ISerializable
+    public class ArgumentException : SystemException
-    public class ArgumentOutOfRangeException : ArgumentException, ISerializable
+    public class ArgumentOutOfRangeException : ArgumentException
-    public struct ArraySegment<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+    public readonly struct ArraySegment<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
-        void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);

     }
     public static class BitConverter {
+        public static bool ToBoolean(ReadOnlySpan<byte> value);
+        public static char ToChar(ReadOnlySpan<byte> value);
+        public static double ToDouble(ReadOnlySpan<byte> value);
+        public static short ToInt16(ReadOnlySpan<byte> value);
+        public static int ToInt32(ReadOnlySpan<byte> value);
+        public static long ToInt64(ReadOnlySpan<byte> value);
+        public static float ToSingle(ReadOnlySpan<byte> value);
+        public static ushort ToUInt16(ReadOnlySpan<byte> value);
+        public static uint ToUInt32(ReadOnlySpan<byte> value);
+        public static ulong ToUInt64(ReadOnlySpan<byte> value);
+        public static bool TryWriteBytes(Span<byte> destination, bool value);
+        public static bool TryWriteBytes(Span<byte> destination, char value);
+        public static bool TryWriteBytes(Span<byte> destination, double value);
+        public static bool TryWriteBytes(Span<byte> destination, short value);
+        public static bool TryWriteBytes(Span<byte> destination, int value);
+        public static bool TryWriteBytes(Span<byte> destination, long value);
+        public static bool TryWriteBytes(Span<byte> destination, float value);
+        public static bool TryWriteBytes(Span<byte> destination, ushort value);
+        public static bool TryWriteBytes(Span<byte> destination, uint value);
+        public static bool TryWriteBytes(Span<byte> destination, ulong value);
     }
     public struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool> {
+        public static Boolean Parse(ReadOnlySpan<char> value);
+        public Boolean TryFormat(Span<char> destination, out int charsWritten);
+        public static Boolean TryParse(ReadOnlySpan<char> value, out Boolean result);
     }
     public struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable {
+        public static Byte Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out Byte result);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Byte result);
     }
-    public struct ConsoleKeyInfo
+    public readonly struct ConsoleKeyInfo
     public static class Convert {
+        public static string ToBase64String(ReadOnlySpan<byte> bytes, Base64FormattingOptions options = (Base64FormattingOptions)(0));
+        public static bool TryFromBase64Chars(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public static bool TryFromBase64String(string s, Span<byte> bytes, out int bytesWritten);
+        public static bool TryToBase64Chars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten, Base64FormattingOptions options = (Base64FormattingOptions)(0));
     }
-    public struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable {
+    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable {
+        public static readonly DateTime UnixEpoch;
+        public static DateTime Parse(ReadOnlySpan<char> s, IFormatProvider provider = null, DateTimeStyles styles = (DateTimeStyles)(0));
+        public static DateTime ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style = (DateTimeStyles)(0));
+        public static DateTime ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style = (DateTimeStyles)(0));
-        int System.IComparable.CompareTo(object value);

-        TypeCode System.IConvertible.GetTypeCode();

+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out DateTime result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider provider, DateTimeStyles styles, out DateTime result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateTime result);
     }
     public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable {
+        public static readonly DateTimeOffset UnixEpoch;
+        public static DateTimeOffset Parse(ReadOnlySpan<char> input, IFormatProvider formatProvider = null, DateTimeStyles styles = (DateTimeStyles)(0));
+        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider formatProvider, DateTimeStyles styles = (DateTimeStyles)(0));
+        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles = (DateTimeStyles)(0));
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider formatProvider = null);
+        public static bool TryParse(ReadOnlySpan<char> input, out DateTimeOffset result);
+        public static bool TryParse(ReadOnlySpan<char> input, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
     }
     public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
+        public static Decimal Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(111), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out Decimal result);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Decimal result);
     }
     public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable {
+        public static bool IsFinite(Double d);
+        public static bool IsNegative(Double d);
+        public static bool IsNormal(Double d);
+        public static bool IsSubnormal(Double d);
+        public static Double Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(231), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out Double result);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Double result);
     }
-    public class DuplicateWaitObjectException : ArgumentException, ISerializable
+    public class DuplicateWaitObjectException : ArgumentException
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
-        TypeCode System.IConvertible.GetTypeCode();

     }
     public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
+        public Guid(ReadOnlySpan<byte> b);
+        public static Guid Parse(ReadOnlySpan<char> input);
+        public static Guid ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>));
+        public static bool TryParse(ReadOnlySpan<char> input, out Guid result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, out Guid result);
+        public bool TryWriteBytes(Span<byte> destination);
     }
+    public struct HashCode {
+        public void Add<T>(T value);
+        public void Add<T>(T value, IEqualityComparer<T> comparer);
+        public static int Combine<T1, T2, T3, T4, T5, T6, T7, T8>(T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7, T8 value8);
+        public static int Combine<T1, T2, T3, T4, T5, T6, T7>(T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7);
+        public static int Combine<T1, T2, T3, T4, T5, T6>(T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6);
+        public static int Combine<T1, T2, T3, T4, T5>(T1 value1, T2 value2, T3 value3, T4 value4, T5 value5);
+        public static int Combine<T1, T2, T3, T4>(T1 value1, T2 value2, T3 value3, T4 value4);
+        public static int Combine<T1, T2, T3>(T1 value1, T2 value2, T3 value3);
+        public static int Combine<T1, T2>(T1 value1, T2 value2);
+        public static int Combine<T1>(T1 value1);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public int ToHashCode();
+    }
     public struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable {
+        public static Int16 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Int16 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Int16 result);
     }
     public struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable {
+        public static Int32 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out Int32 charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Int32 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Int32 result);
     }
     public struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable {
+        public static Int64 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Int64 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Int64 result);
     }
     public static class Math {
+        public static double Acosh(double d);
+        public static double Asinh(double d);
+        public static double Atanh(double d);
+        public static double Cbrt(double d);
     }
     public static class MathF {
+        public static float Acosh(float x);
+        public static float Asinh(float x);
+        public static float Atanh(float x);
+        public static float Cbrt(float x);
     }
+    public readonly struct Memory<T> {
+        public Memory(T[] array);
+        public Memory(T[] array, int start, int length);
+        public static Memory<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public int Length { get; }
+        public Span<T> Span { get; }
+        public void CopyTo(Memory<T> destination);
+        public bool Equals(Memory<T> other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static implicit operator Memory<T> (ArraySegment<T> segment);
+        public static implicit operator ReadOnlyMemory<T> (Memory<T> memory);
+        public static implicit operator Memory<T> (T[] array);
+        public MemoryHandle Pin();
+        public Memory<T> Slice(int start);
+        public Memory<T> Slice(int start, int length);
+        public T[] ToArray();
+        public override string ToString();
+        public bool TryCopyTo(Memory<T> destination);
+    }
+    public static class MemoryExtensions {
+        public static ReadOnlyMemory<char> AsMemory(this string text);
+        public static ReadOnlyMemory<char> AsMemory(this string text, int start);
+        public static ReadOnlyMemory<char> AsMemory(this string text, int start, int length);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment, int start);
+        public static Memory<T> AsMemory<T>(this ArraySegment<T> segment, int start, int length);
+        public static Memory<T> AsMemory<T>(this T[] array);
+        public static Memory<T> AsMemory<T>(this T[] array, int start);
+        public static Memory<T> AsMemory<T>(this T[] array, int start, int length);
+        public static ReadOnlySpan<char> AsSpan(this string text);
+        public static ReadOnlySpan<char> AsSpan(this string text, int start);
+        public static ReadOnlySpan<char> AsSpan(this string text, int start, int length);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, int start);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, int start, int length);
+        public static Span<T> AsSpan<T>(this T[] array);
+        public static Span<T> AsSpan<T>(this T[] array, int start);
+        public static Span<T> AsSpan<T>(this T[] array, int start, int length);
+        public static int BinarySearch<T, TComparable>(this ReadOnlySpan<T> span, TComparable comparable) where TComparable : IComparable<T>;
+        public static int BinarySearch<T, TComparable>(this Span<T> span, TComparable comparable) where TComparable : IComparable<T>;
+        public static int BinarySearch<T, TComparer>(this ReadOnlySpan<T> span, T value, TComparer comparer) where TComparer : IComparer<T>;
+        public static int BinarySearch<T, TComparer>(this Span<T> span, T value, TComparer comparer) where TComparer : IComparer<T>;
+        public static int BinarySearch<T>(this ReadOnlySpan<T> span, IComparable<T> comparable);
+        public static int BinarySearch<T>(this Span<T> span, IComparable<T> comparable);
+        public static int CompareTo(this ReadOnlySpan<char> span, ReadOnlySpan<char> other, StringComparison comparisonType);
+        public static bool Contains(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static void CopyTo<T>(this T[] source, Memory<T> destination);
+        public static void CopyTo<T>(this T[] source, Span<T> destination);
+        public static bool EndsWith(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static bool EndsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool EndsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool Equals(this ReadOnlySpan<char> span, ReadOnlySpan<char> other, StringComparison comparisonType);
+        public static int IndexOf(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static int IndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static bool IsWhiteSpace(this ReadOnlySpan<char> span);
+        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static bool Overlaps<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other);
+        public static bool Overlaps<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, out int elementOffset);
+        public static bool Overlaps<T>(this Span<T> span, ReadOnlySpan<T> other);
+        public static bool Overlaps<T>(this Span<T> span, ReadOnlySpan<T> other, out int elementOffset);
+        public static void Reverse<T>(this Span<T> span);
+        public static int SequenceCompareTo<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
+        public static int SequenceCompareTo<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
+        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
+        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
+        public static bool StartsWith(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static bool StartsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool StartsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int ToLower(this ReadOnlySpan<char> source, Span<char> destination, CultureInfo culture);
+        public static int ToLowerInvariant(this ReadOnlySpan<char> source, Span<char> destination);
+        public static int ToUpper(this ReadOnlySpan<char> source, Span<char> destination, CultureInfo culture);
+        public static int ToUpperInvariant(this ReadOnlySpan<char> source, Span<char> destination);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> Trim(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> TrimEnd(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span, char trimChar);
+        public static ReadOnlySpan<char> TrimStart(this ReadOnlySpan<char> span, ReadOnlySpan<char> trimChars);
+    }
-    public class MissingMethodException : MissingMemberException, ISerializable
+    public class MissingMethodException : MissingMemberException
     public class Random {
+        public virtual void NextBytes(Span<byte> buffer);
     }
+    public readonly struct ReadOnlyMemory<T> {
+        public ReadOnlyMemory(T[] array);
+        public ReadOnlyMemory(T[] array, int start, int length);
+        public static ReadOnlyMemory<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public int Length { get; }
+        public ReadOnlySpan<T> Span { get; }
+        public void CopyTo(Memory<T> destination);
+        public override bool Equals(object obj);
+        public bool Equals(ReadOnlyMemory<T> other);
+        public override int GetHashCode();
+        public static implicit operator ReadOnlyMemory<T> (ArraySegment<T> segment);
+        public static implicit operator ReadOnlyMemory<T> (T[] array);
+        public MemoryHandle Pin();
+        public ReadOnlyMemory<T> Slice(int start);
+        public ReadOnlyMemory<T> Slice(int start, int length);
+        public T[] ToArray();
+        public override string ToString();
+        public bool TryCopyTo(Memory<T> destination);
+    }
+    public readonly ref struct ReadOnlySpan<T> {
+        public unsafe ReadOnlySpan(void* pointer, int length);
+        public ReadOnlySpan(T[] array);
+        public ReadOnlySpan(T[] array, int start, int length);
+        public static ReadOnlySpan<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public int Length { get; }
+        public ref readonly T this[int index] { get; }
+        public void CopyTo(Span<T> destination);
+        public override bool Equals(object obj);
+        public ReadOnlySpan<T>.Enumerator GetEnumerator();
+        public override int GetHashCode();
+        public ref readonly T GetPinnableReference();
+        public static bool operator ==(ReadOnlySpan<T> left, ReadOnlySpan<T> right);
+        public static implicit operator ReadOnlySpan<T> (ArraySegment<T> segment);
+        public static implicit operator ReadOnlySpan<T> (T[] array);
+        public static bool operator !=(ReadOnlySpan<T> left, ReadOnlySpan<T> right);
+        public ReadOnlySpan<T> Slice(int start);
+        public ReadOnlySpan<T> Slice(int start, int length);
+        public T[] ToArray();
+        public override string ToString();
+        public bool TryCopyTo(Span<T> destination);
+        public ref struct Enumerator {
+            public ref readonly T Current { get; }
+            public bool MoveNext();
+        }
+    }
-    public struct RuntimeArgumentHandle
+    public ref struct RuntimeArgumentHandle
     public struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable {
+        public static SByte Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out SByte result);
+        public static bool TryParse(ReadOnlySpan<char> s, out SByte result);
     }
+    public readonly struct SequencePosition : IEquatable<SequencePosition> {
+        public SequencePosition(object @object, int integer);
+        public override bool Equals(object obj);
+        public bool Equals(SequencePosition other);
+        public override int GetHashCode();
+        public int GetInteger();
+        public object GetObject();
+    }
     public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable {
+        public static bool IsFinite(Single f);
+        public static bool IsNegative(Single f);
+        public static bool IsNormal(Single f);
+        public static bool IsSubnormal(Single f);
+        public static Single Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(231), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Single result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Single result);
     }
+    public readonly ref struct Span<T> {
+        public unsafe Span(void* pointer, int length);
+        public Span(T[] array);
+        public Span(T[] array, int start, int length);
+        public static Span<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public int Length { get; }
+        public ref T this[int index] { get; }
+        public void Clear();
+        public void CopyTo(Span<T> destination);
+        public override bool Equals(object obj);
+        public void Fill(T value);
+        public Span<T>.Enumerator GetEnumerator();
+        public override int GetHashCode();
+        public ref T GetPinnableReference();
+        public static bool operator ==(Span<T> left, Span<T> right);
+        public static implicit operator Span<T> (ArraySegment<T> segment);
+        public static implicit operator ReadOnlySpan<T> (Span<T> span);
+        public static implicit operator Span<T> (T[] array);
+        public static bool operator !=(Span<T> left, Span<T> right);
+        public Span<T> Slice(int start);
+        public Span<T> Slice(int start, int length);
+        public T[] ToArray();
+        public override string ToString();
+        public bool TryCopyTo(Span<T> destination);
+        public ref struct Enumerator {
+            public ref T Current { get; }
+            public bool MoveNext();
+        }
+    }
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public String(ReadOnlySpan<char> value);
+        public bool Contains(char value);
+        public bool Contains(char value, StringComparison comparisonType);
+        public bool Contains(String value, StringComparison comparisonType);
+        public static String Create<TState>(int length, TState state, SpanAction<char, TState> action);
+        public int IndexOf(char value, StringComparison comparisonType);
+        public static implicit operator ReadOnlySpan<char> (String value);
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        public static StringComparer Create(CultureInfo culture, CompareOptions options);
     }
     public struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable {
+        public static TimeSpan Parse(ReadOnlySpan<char> input, IFormatProvider formatProvider = null);
+        public static TimeSpan ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider formatProvider, TimeSpanStyles styles = (TimeSpanStyles)(0));
+        public static TimeSpan ParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles = (TimeSpanStyles)(0));
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider formatProvider = null);
+        public static bool TryParse(ReadOnlySpan<char> input, IFormatProvider formatProvider, out TimeSpan result);
+        public static bool TryParse(ReadOnlySpan<char> s, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider formatProvider, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider formatProvider, out TimeSpan result);
     }
     public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo>, ISerializable {
-        public struct TransitionTime : IDeserializationCallback, IEquatable<TimeZoneInfo.TransitionTime>, ISerializable
+        public readonly struct TransitionTime : IDeserializationCallback, IEquatable<TimeZoneInfo.TransitionTime>, ISerializable
     }
     public abstract class Type : MemberInfo, IReflect {
+        public virtual bool IsByRefLike { get; }
+        public virtual bool IsGenericMethodParameter { get; }
+        public virtual bool IsGenericTypeParameter { get; }
+        public virtual bool IsSignatureType { get; }
+        public MethodInfo GetMethod(string name, int genericParameterCount, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, int genericParameterCount, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, int genericParameterCount, Type[] types);
+        public MethodInfo GetMethod(string name, int genericParameterCount, Type[] types, ParameterModifier[] modifiers);
+        protected virtual MethodInfo GetMethodImpl(string name, int genericParameterCount, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public static Type MakeGenericMethodParameter(int position);
     }
-    public struct TypedReference
+    public ref struct TypedReference
-    public class TypeUnloadedException : SystemException, ISerializable
+    public class TypeUnloadedException : SystemException
     public struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable {
+        public static UInt16 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out UInt16 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UInt16 result);
     }
     public struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable {
+        public static UInt32 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out UInt32 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UInt32 result);
     }
     public struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable {
+        public static UInt64 Parse(ReadOnlySpan<char> s, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out UInt64 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UInt64 result);
     }
     public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version> {
+        public static Version Parse(ReadOnlySpan<char> input);
+        public bool TryFormat(Span<char> destination, out int charsWritten);
+        public bool TryFormat(Span<char> destination, int fieldCount, out int charsWritten);
+        public static bool TryParse(ReadOnlySpan<char> input, out Version result);
     }
 }
```

