# Commits to .NET Core 2.2.0

This is a curated list of commits across the .NET Core 2.2.0 development cycle.

* [CoreCLR](#coreclr)
* [CoreFX](#corefx)
* [CLI](#cli)
* [AspNetCore](#aspnetcore)

## CoreCLR

* [`[82558c91d4]`](https://github.com/dotnet/coreclr/commit/82558c91d4) Manual port of #20796
* [`[e887df82cc]`](https://github.com/dotnet/coreclr/commit/e887df82cc) Add the execution policy when running powershell in size on disk benchmarks (#20680)
* [`[35832fc396]`](https://github.com/dotnet/coreclr/commit/35832fc396) Disable Ubuntu arm64 & Windows arm/arm64 default CI jobs (#20842)
* [`[1c5dc619ee]`](https://github.com/dotnet/coreclr/commit/1c5dc619ee) Enable Tizen CI (#19410)
* [`[47e6ebe80b]`](https://github.com/dotnet/coreclr/commit/47e6ebe80b) Add EventPipe Config File Option MultiFileSec (#20548) (#20615)
* [`[70846ce7c9]`](https://github.com/dotnet/coreclr/commit/70846ce7c9) Disable tiered compilation by default for 2.2 RTM (#20525)
* [`[fd1893fa1a]`](https://github.com/dotnet/coreclr/commit/fd1893fa1a) Fix issue #20076 createdump faults. (#20403)
* [`[bba9fdab23]`](https://github.com/dotnet/coreclr/commit/bba9fdab23) Fix MacOS launch bug when spaces in module names. (#20402)
* [`[e809449dcf]`](https://github.com/dotnet/coreclr/commit/e809449dcf) Use AppContext.BaseDirectory instead of AppDomain.CurrentDomain.BaseDirectory when initializing EventPipeController. (#20467)
* [`[be8a268b3f]`](https://github.com/dotnet/coreclr/commit/be8a268b3f) Lock arm64 corefx build to corresponding branch
* [`[425136cfa7]`](https://github.com/dotnet/coreclr/commit/425136cfa7) Port of fix for #19444 to 2.2
* [`[27701ab4a5]`](https://github.com/dotnet/coreclr/commit/27701ab4a5) Port BSTR support from master (#20393)
* [`[702b0fd608]`](https://github.com/dotnet/coreclr/commit/702b0fd608) [release/2.2] Startup hook provider (#20005)
* [`[50185823a0]`](https://github.com/dotnet/coreclr/commit/50185823a0) Port EventPipe Out-of-Process Control to Release/2.2 (#20303)
* [`[9bff252639]`](https://github.com/dotnet/coreclr/commit/9bff252639) Port to 2.1 - Fix hijack for ARM/ARM64/x86 on Unix (#20116)
* [`[1e07644bb5]`](https://github.com/dotnet/coreclr/commit/1e07644bb5) Fix xplat debugging perf problem. (#19911) (#20054)
* [`[ad096c8867]`](https://github.com/dotnet/coreclr/commit/ad096c8867) JIT: Fix operand evaluation order for GT_INDEX_ADDR (#20047) (#20127)
* [`[cb730c5c1e]`](https://github.com/dotnet/coreclr/commit/cb730c5c1e) Fix callKillSet for CORINFO_HELP_ASSIGN_BYREF on x64. (#19780) (#19803)
* [`[d05c93d373]`](https://github.com/dotnet/coreclr/commit/d05c93d373) Port Fix ICU load on OpenSUSE Tumbleweed to 2.1 (#19861)
* [`[a25682cdcf]`](https://github.com/dotnet/coreclr/commit/a25682cdcf) Determine memory load based on cgroup usage. (#19518) (#19650)
* [`[4a7e9eae93]`](https://github.com/dotnet/coreclr/commit/4a7e9eae93) Fix CoreCLR debug launch (#19730) (#19770)
* [`[fe2ffd6f0d]`](https://github.com/dotnet/coreclr/commit/fe2ffd6f0d) Port PR #17617 from 3.0
* [`[2e066fafb9]`](https://github.com/dotnet/coreclr/commit/2e066fafb9) Port PR #17879 from 3.0
* [`[d6cc8737ea]`](https://github.com/dotnet/coreclr/commit/d6cc8737ea) Port PR #17990 from 3.0
* [`[ffbd5ee637]`](https://github.com/dotnet/coreclr/commit/ffbd5ee637) Port PR #18129 from 3.0
* [`[cfb55cb29a]`](https://github.com/dotnet/coreclr/commit/cfb55cb29a) Port PR #18247 from 3.0
* [`[05a2d74369]`](https://github.com/dotnet/coreclr/commit/05a2d74369) Fix a PAL spin lock issue (#19606)
* [`[88876b3e29]`](https://github.com/dotnet/coreclr/commit/88876b3e29) Make sure RuntimeEventSource is passed to EventListener.OnEventSourceCreated (#19697)
* [`[9663131aec]`](https://github.com/dotnet/coreclr/commit/9663131aec) Fix a PAL spin lock issue (#19606)
* [`[e0fbb7769e]`](https://github.com/dotnet/coreclr/commit/e0fbb7769e) Disable tiered compilation on arm64
* [`[a40b631948]`](https://github.com/dotnet/coreclr/commit/a40b631948) Fix tiered compilation option for case-sensitive systems (#19567)
* [`[293630edc4]`](https://github.com/dotnet/coreclr/commit/293630edc4) Enable Tiered Compilation by default (#19525)
* [`[14d728a6cb]`](https://github.com/dotnet/coreclr/commit/14d728a6cb) Fix an apartment state issue (partial port of #19384)
* [`[1d61034605]`](https://github.com/dotnet/coreclr/commit/1d61034605) Use 16 bytes to spill SIMD12 (#19237)
* [`[d90c382c2d]`](https://github.com/dotnet/coreclr/commit/d90c382c2d) Eliminate arm64 contract asserts (#19015)
* [`[db93fecac9]`](https://github.com/dotnet/coreclr/commit/db93fecac9) Apply tiering's call counting delay more broadly (#18610)
* [`[9ea3d2ad54]`](https://github.com/dotnet/coreclr/commit/9ea3d2ad54) Don't close the JIT func info file on shutdown (#18060)
* [`[fce15e5875]`](https://github.com/dotnet/coreclr/commit/fce15e5875) Fix nested spin locks in thread pool etw firing (#17677)
* [`[eae0a38b81]`](https://github.com/dotnet/coreclr/commit/eae0a38b81) Port PR #17617 from 3.0
* [`[f706053851]`](https://github.com/dotnet/coreclr/commit/f706053851) Port PR #17879 from 3.0
* [`[5db8cec4e9]`](https://github.com/dotnet/coreclr/commit/5db8cec4e9) Port PR #17990 from 3.0
* [`[70e26d060f]`](https://github.com/dotnet/coreclr/commit/70e26d060f) Port PR #18129 from 3.0
* [`[de90cbd4dd]`](https://github.com/dotnet/coreclr/commit/de90cbd4dd) Port PR #18247 from 3.0
* [`[98a7f8733e]`](https://github.com/dotnet/coreclr/commit/98a7f8733e) Add CI PR-triggered Ubuntu x64 innerloop no-tiering job (#19123)
* [`[fe0f570e2a]`](https://github.com/dotnet/coreclr/commit/fe0f570e2a) Enable the no tiered compilation innerloop PR legs (#18953)
* [`[19ff879571]`](https://github.com/dotnet/coreclr/commit/19ff879571) Add no tiered compilation test jobs (#18864)
* [`[10e33d0208]`](https://github.com/dotnet/coreclr/commit/10e33d0208) Adjust JIT automated testing for tiered compilation (#18828)
* [`[ac5dee512d]`](https://github.com/dotnet/coreclr/commit/ac5dee512d) Fix dbgshim's > 1000 module bug (issue #19538) (#19553) (#19570)
* [`[7813233bed]`](https://github.com/dotnet/coreclr/commit/7813233bed) Only register signals and create alt exception stack in coreclr (#19526)

## CoreFX

* [`[fe7d8ea67c]`](https://github.com/dotnet/corefx/commit/fe7d8ea67c) Pass CancellationToken to Stream in ManagedWebSocket (#33198)
* [`[8b52a2e8e2]`](https://github.com/dotnet/corefx/commit/8b52a2e8e2) Enable Tizen CI (#31698)
* [`[21dfcf72d9]`](https://github.com/dotnet/corefx/commit/21dfcf72d9) Treat the 'algorithm' parameter in Digest HTTP authentication as case-insensitive. (#32632) (#32920)
* [`[7bcae0e6fc]`](https://github.com/dotnet/corefx/commit/7bcae0e6fc) Fix Timer rooting issue with SocketsHttpHandler (#32845)
* [`[a8b44a739a]`](https://github.com/dotnet/corefx/commit/a8b44a739a) Port: Fix NetworkInterfaces exception when forwarding conf file is not available in linux system (#32350) (#32626)
* [`[3aaa88fdc2]`](https://github.com/dotnet/corefx/commit/3aaa88fdc2) Increment Microsoft.NETCore.Platforms version
* [`[7cddd8ebef]`](https://github.com/dotnet/corefx/commit/7cddd8ebef) Change HttpConnectionPool.GetConnectionAsync to do read-ahead outside of lock (#32495) (#32568)
* [`[cc4bb7b84f]`](https://github.com/dotnet/corefx/commit/cc4bb7b84f) Add Ubuntu 18.10 (Cosmic Cuttlefish) (#32292)
* [`[d3d3336ce2]`](https://github.com/dotnet/corefx/commit/d3d3336ce2) Read SSL_CERT_FILE contents before SSL_CERT_DIR contents (#32455)
* [`[615e5e92e5]`](https://github.com/dotnet/corefx/commit/615e5e92e5) Add system.io.pipelines stable version
* [`[10d562a999]`](https://github.com/dotnet/corefx/commit/10d562a999) update license header for xml files used for generating source code (#31752) (#32338)
* [`[22fc23779b]`](https://github.com/dotnet/corefx/commit/22fc23779b) Test a couple of fixes for apartment state issues (#31822)
* [`[be79afda4d]`](https://github.com/dotnet/corefx/commit/be79afda4d) Fix windows auth when we receive a 401 after auth completes (#32243)
* [`[76b3ac0136]`](https://github.com/dotnet/corefx/commit/76b3ac0136) Pin version of S.D.DiagnosticSource on non-netfx platforms
* [`[503ee03583]`](https://github.com/dotnet/corefx/commit/503ee03583) Need save the update outputDirectory change. (#31398)
* [`[85b40be5e2]`](https://github.com/dotnet/corefx/commit/85b40be5e2) Fixes extract out of directory by ensuring trailing separator for nested paths. (#32165)
* [`[b02a70a0d8]`](https://github.com/dotnet/corefx/commit/b02a70a0d8) Add Microsoft-Windows-DotNETRuntime to the list of framework EventSources. (#32125)
* [`[ab121ec606]`](https://github.com/dotnet/corefx/commit/ab121ec606) Port "Do not expand stacktraces when completion exception is rethrown multiple times" (#31680)
* [`[ebc79f6489]`](https://github.com/dotnet/corefx/commit/ebc79f6489) Ensure that TrySetECDHNamedCurve is always called, enabling ECDHE ciphersuites (#32034)
* [`[5b16645d8a]`](https://github.com/dotnet/corefx/commit/5b16645d8a) Adding special target that will get a resource file and pass it to ilasm for S.R.CS.Unsafe so that it has the right version headers (#31806)
* [`[47f2013f06]`](https://github.com/dotnet/corefx/commit/47f2013f06) Update harvested package version for sqlclient to match latest stable 4.5.1
* [`[cf4cc56b0b]`](https://github.com/dotnet/corefx/commit/cf4cc56b0b) Switch System.Data.SqlClient back to default versioning for 2.2 (#32030)
* [`[2a17f505df]`](https://github.com/dotnet/corefx/commit/2a17f505df) Fix race in the StackTraceSymbols.CoreCLR.cs metadata provider cache.
* [`[81af9c2033]`](https://github.com/dotnet/corefx/commit/81af9c2033) updates after running commad: msbuild /t:UpdatePackageIndex
* [`[83ac6fa606]`](https://github.com/dotnet/corefx/commit/83ac6fa606) Fix Granularity for copy operation on unix (#31046)
* [`[81a99c51fe]`](https://github.com/dotnet/corefx/commit/81a99c51fe) Fix Icon overflow bug when image entry is a PNG file
* [`[93109de12b]`](https://github.com/dotnet/corefx/commit/93109de12b) update package version and add System.Data.SqlClient package to the list of packages
* [`[f48a970612]`](https://github.com/dotnet/corefx/commit/f48a970612) [Release/2.2 Port] Expose EventWrittenEventArgs.OSThreadId and EventWrittenEventArgs.TimeStamp in System.Diagnostics.Tracing contract (#31703)
* [`[3d184f9f06]`](https://github.com/dotnet/corefx/commit/3d184f9f06) Add Microsoft.NETCore.Platforms to the package build list
* [`[5af7a6b967]`](https://github.com/dotnet/corefx/commit/5af7a6b967) Increate ReadAsyncCompletesIfFlushAsyncCanceledMidFlush timeout to 5 minutes (#31745)
* [`[d8e222dfd9]`](https://github.com/dotnet/corefx/commit/d8e222dfd9) Limit ReadAsyncCompletesIfFlushAsyncCanceledMidFlush iteration count
* [`[bee0e9df4d]`](https://github.com/dotnet/corefx/commit/bee0e9df4d) Syncronize cancellation in ReadAsyncCompletesIfFlushAsyncCanceledMidFlush (#31365)
* [`[141c2f4ce3]`](https://github.com/dotnet/corefx/commit/141c2f4ce3) Fix ReadAsync not returning when cancellation token fires during FlushAsync (#31212)
* [`[88f6354bb3]`](https://github.com/dotnet/corefx/commit/88f6354bb3) Make StackFrame tests robust against varying levels of optimizations (#30463)
* [`[ce799ec144]`](https://github.com/dotnet/corefx/commit/ce799ec144) Handle rename of m_provider to m_etwProvider. (#30014) (#31854)
* [`[f4e9110b2f]`](https://github.com/dotnet/corefx/commit/f4e9110b2f) Fix looking up headers on HttpClient response (#31550)
* [`[e86d925ba5]`](https://github.com/dotnet/corefx/commit/e86d925ba5) Update package.sbuilds and version baselines for the 2.1.4 update
* [`[d69ef185c3]`](https://github.com/dotnet/corefx/commit/d69ef185c3) Updated the package version for System.IO.Pipelines to 4.5.1
* [`[7993de4d2a]`](https://github.com/dotnet/corefx/commit/7993de4d2a) Add macOS 10.14 Mojave to the RID graph  (#31548)
* [`[95f382a9f2]`](https://github.com/dotnet/corefx/commit/95f382a9f2) Handle NT auth with Connection: close on initial challenge #31527
* [`[cf41dcce70]`](https://github.com/dotnet/corefx/commit/cf41dcce70) Handle overflow in uname -r (#31261)
* [`[d438da4875]`](https://github.com/dotnet/corefx/commit/d438da4875) Ensure that exporting an unsorted attributes signed payload doesn't sort them.
* [`[2f8e2bb0c5]`](https://github.com/dotnet/corefx/commit/2f8e2bb0c5) Allow SignedCms to verify documents whose signer didn't sort attributes.
* [`[16cf9914d7]`](https://github.com/dotnet/corefx/commit/16cf9914d7) Port of 'Ensure ConcurrentBag's TryTake is linearizable' again

## CLI

* [`[785a64e5a]`](https://github.com/dotnet/cli/commit/785a64e5a) Enabling crossgen for win-arm
* [`[eb253fa49]`](https://github.com/dotnet/cli/commit/eb253fa49) Enabling building for win-arm.
* [`[401c963e0]`](https://github.com/dotnet/cli/commit/401c963e0) Insert NuGet Build 4.9.0-rtm.5658 into cli
* [`[49f1571dd]`](https://github.com/dotnet/cli/commit/49f1571dd) MSBuild 15.9.20
* [`[ef881e004]`](https://github.com/dotnet/cli/commit/ef881e004) Update nunit-dotnet-new to version 1.5.3
* [`[5aad7bca5]`](https://github.com/dotnet/cli/commit/5aad7bca5) Insert NuGet Build 4.9.0-preview5.5630 into cli
* [`[743ba08df]`](https://github.com/dotnet/cli/commit/743ba08df) Insert NuGet Build 4.9.0-preview4.5552 into cli
* [`[4dee502cf]`](https://github.com/dotnet/cli/commit/4dee502cf) Adding new VS.Redist packages for 2.1, so that we can serve both 15.x and 16.x.
* [`[738c4cb96]`](https://github.com/dotnet/cli/commit/738c4cb96) Updating 1.0 and 1.1 implicit self-contained versions
* [`[c04acdbdb]`](https://github.com/dotnet/cli/commit/c04acdbdb) Update LatestPatchVersionForNetCore 1.0 and 1.1
* [`[df4663506]`](https://github.com/dotnet/cli/commit/df4663506) MSBuild 15.9.19
* [`[5ec02ad56]`](https://github.com/dotnet/cli/commit/5ec02ad56) Fix tool install fail on culture "en-US-POSIX"
* [`[c19ba0742]`](https://github.com/dotnet/cli/commit/c19ba0742) Insert testplatform 15.9 RTM
* [`[2153bcaab]`](https://github.com/dotnet/cli/commit/2153bcaab) Fixing exec with line breaks on windows now, affected by the same MSBuild change that changed how exec treats line endings.
* [`[dba04383b]`](https://github.com/dotnet/cli/commit/dba04383b) Insert NuGet Build 4.9.0-preview4.5536 into cli
* [`[48ed870b7]`](https://github.com/dotnet/cli/commit/48ed870b7) Updating exec for OSX by putting the whole command in a single line. There was a change in MSBuild where we changed the way the exec command is treated.
* [`[68b7810f4]`](https://github.com/dotnet/cli/commit/68b7810f4) Adding NU5123 to the NOWARN list. This was a new warning introduced by NuGet that we started hitting when upgrading to a newer SDK.
* [`[54ac9be91]`](https://github.com/dotnet/cli/commit/54ac9be91) Add the Razor SDK to the versions to update
* [`[f3813f90c]`](https://github.com/dotnet/cli/commit/f3813f90c) Add retry to download
* [`[fbaca979b]`](https://github.com/dotnet/cli/commit/fbaca979b) Add IsTestProject prop to test
* [`[a3237bb47]`](https://github.com/dotnet/cli/commit/a3237bb47) Insert testplatform v15.9.0-preview-20180924-03
* [`[2ed37b3f4]`](https://github.com/dotnet/cli/commit/2ed37b3f4) Fix multiline powershell invocations
* [`[d134af0eb]`](https://github.com/dotnet/cli/commit/d134af0eb) Insert testplatform v15.9.0-preview-20180925-03
* [`[824a01420]`](https://github.com/dotnet/cli/commit/824a01420) forward param for dotnet tool udpate (#9969)
* [`[744162714]`](https://github.com/dotnet/cli/commit/744162714) Add DotnetTool path to avoid setting permanent env
* [`[22b4b8451]`](https://github.com/dotnet/cli/commit/22b4b8451) Upgrade NuGet to 4.9.0-preview3.5473
* [`[7d2f3151e]`](https://github.com/dotnet/cli/commit/7d2f3151e) Implement the `dotnet list package` command.
* [`[45ee7b63e]`](https://github.com/dotnet/cli/commit/45ee7b63e) Insert updated Web SDK
* [`[ad5450595]`](https://github.com/dotnet/cli/commit/ad5450595) Add ImplicitPackageReferenceVersion items to bundled versions file
* [`[5f1cad1a1]`](https://github.com/dotnet/cli/commit/5f1cad1a1) Always use the suffixed version for the  'VS.Redist.Common.Net.Core.SDK.*' files & publish them.
* [`[8ad94c40e]`](https://github.com/dotnet/cli/commit/8ad94c40e) Insert NuGet Build 4.9.0-preview3.5507 into cli
* [`[b4aa2fe0b]`](https://github.com/dotnet/cli/commit/b4aa2fe0b) Update core-setup and re-enable all sdk resolver tests
* [`[cbe8cd367]`](https://github.com/dotnet/cli/commit/cbe8cd367) Insert NuGet Build 4.9.0-preview3.5496 into cli
* [`[f5d25c792]`](https://github.com/dotnet/cli/commit/f5d25c792) MSBuild 15.9.13-preview
* [`[4fb90d694]`](https://github.com/dotnet/cli/commit/4fb90d694) Installer metadata in ARP uses HTTP URLs
* [`[5497aa2f0]`](https://github.com/dotnet/cli/commit/5497aa2f0) Insert NuGet Build 4.9.0-preview2.5467 into cli
* [`[ed4ae7133]`](https://github.com/dotnet/cli/commit/ed4ae7133) Insert NuGet Build 4.8.1-rtm.5435 into cli
* [`[68dc2496c]`](https://github.com/dotnet/cli/commit/68dc2496c) Update dependnecy updater (port from 2.2.1xx]
* [`[0408e13bc]`](https://github.com/dotnet/cli/commit/0408e13bc) Update AspnetCore.All instead of AspnetCore.App
* [`[2650d3b0a]`](https://github.com/dotnet/cli/commit/2650d3b0a) Add additional package version updaters for other aspnet dependencies
* [`[a4040c998]`](https://github.com/dotnet/cli/commit/a4040c998) Add reference to Nuget.Versioning
* [`[d4e5da80b]`](https://github.com/dotnet/cli/commit/d4e5da80b) Fixing the external restore sources file. We needed to create the test artifact folder.
* [`[92feb56d6]`](https://github.com/dotnet/cli/commit/92feb56d6) Change release suffix to servicing
* [`[739be7bf3]`](https://github.com/dotnet/cli/commit/739be7bf3) Insert NuGet Build 4.9.0-preview2.5428 into cli
* [`[cd6a3a6b3]`](https://github.com/dotnet/cli/commit/cd6a3a6b3) Fix rpmdb error (#9906)
* [`[eb9bfdca5]`](https://github.com/dotnet/cli/commit/eb9bfdca5) MSBuild 15.8.168
* [`[e79d0269b]`](https://github.com/dotnet/cli/commit/e79d0269b) MSBuild 15.9.10-preview
* [`[40172615b]`](https://github.com/dotnet/cli/commit/40172615b) Changing the property names for 2.2 templates to be named 22 instead of 20.
* [`[efa3ad3c9]`](https://github.com/dotnet/cli/commit/efa3ad3c9) Updating the windows installer notice to reflect 2.2 and its requirement of 15.9.
* [`[4dcd0031a]`](https://github.com/dotnet/cli/commit/4dcd0031a) Adding a workaround for the sockets issue when restoring with many nuget feeds.
* [`[812d5dfeb]`](https://github.com/dotnet/cli/commit/812d5dfeb) Adding a workaround for the sockets issue when restoring with many nuget feeds.
* [`[3992e7f00]`](https://github.com/dotnet/cli/commit/3992e7f00) Porting back fix from https://github.com/dotnet/cli/pull/9854/files to 2.1.4xx
* [`[a1fd9b00b]`](https://github.com/dotnet/cli/commit/a1fd9b00b) MSBuild 15.9.8-preview
* [`[5df7da56a]`](https://github.com/dotnet/cli/commit/5df7da56a) Updating the test templates to 2.2 version
* [`[0996683c1]`](https://github.com/dotnet/cli/commit/0996683c1) Updated Reevaluate property name
* [`[090a10b67]`](https://github.com/dotnet/cli/commit/090a10b67) Adding NuGet project lock file options for dotnet restore command
* [`[6152eaabc]`](https://github.com/dotnet/cli/commit/6152eaabc) Add --disable-parallel to dotnet-new.Tests
* [`[3ccc3593c]`](https://github.com/dotnet/cli/commit/3ccc3593c) MSBuild SDK Resolver Improvements (#9547)
* [`[b2be5b446]`](https://github.com/dotnet/cli/commit/b2be5b446) MSBuild 15.9.0-preview-000006
* [`[cae652883]`](https://github.com/dotnet/cli/commit/cae652883) Use prebuild image
* [`[5635f0d06]`](https://github.com/dotnet/cli/commit/5635f0d06) Disabled MSBuildTreatWarningsAsErrors
* [`[ea47700f7]`](https://github.com/dotnet/cli/commit/ea47700f7) TestPlatform 15.9.0-preview Insertion
* [`[624259561]`](https://github.com/dotnet/cli/commit/624259561) Fix warnings-as-errors in Linux packaging
* [`[1ec1f612a]`](https://github.com/dotnet/cli/commit/1ec1f612a) Don't let crossgen warnings become msbuild warnings-as-errors

## AspNetCore

An incredible amount of work went into ASP.NET Core for the 2.2 release (as you can see below). The list below will hopefully provide additional insight into the contenst of the .NET Core 2.2.0 release

* [`[197c5567f4]`](https://github.com/aspnet/AspNetCore/commit/197c5567f4) Update EFCore submodule (#4349)
* [`[d9a953dfeb]`](https://github.com/aspnet/AspNetCore/commit/d9a953dfeb) Autobahn test suite fix(#4302)
* [`[054cfac97e]`](https://github.com/aspnet/AspNetCore/commit/054cfac97e) Add EntityFrameworkCore to the list of submodules patching in 2.2.1 (#4341)
* [`[7dc01b6928]`](https://github.com/aspnet/AspNetCore/commit/7dc01b6928) Fix 2.2 benchmarks (#4322)
* [`[e435fd1d23]`](https://github.com/aspnet/AspNetCore/commit/e435fd1d23) Fix accidental skipped tests (#4301)
* [`[78c0813631]`](https://github.com/aspnet/AspNetCore/commit/78c0813631) Set Microsoft.Owin.Security.Interop to 'noship' for 2.2 (#4314)[ci skip]
* [`[8b48191120]`](https://github.com/aspnet/AspNetCore/commit/8b48191120) Ensure static analysis gets the right package versions when patching a package
* [`[b38f936f31]`](https://github.com/aspnet/AspNetCore/commit/b38f936f31) Ensure Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets is included in 2.2.1 (#4308)
* [`[63b26d42d2]`](https://github.com/aspnet/AspNetCore/commit/63b26d42d2) Replace ManualResetEvent with TaskCompletionSource in TestHost tests
* [`[079107aa92]`](https://github.com/aspnet/AspNetCore/commit/079107aa92) Make gradlew executable (#4275)
* [`[af8d67f353]`](https://github.com/aspnet/AspNetCore/commit/af8d67f353) Ensure static analysis gets the right package versions when patching a package
* [`[d025e4e0ad]`](https://github.com/aspnet/AspNetCore/commit/d025e4e0ad) Fix submodules for Mvc MvcPrecompilation Razor and SignalR
* [`[dabf5d8ba9]`](https://github.com/aspnet/AspNetCore/commit/dabf5d8ba9) [2.1] [Kestrel] Move AddressRegistrationTests to own TestGroup
* [`[101303eceb]`](https://github.com/aspnet/AspNetCore/commit/101303eceb) Fix RepositoryUrls
* [`[89330075b4]`](https://github.com/aspnet/AspNetCore/commit/89330075b4) Target right version of ANCM nuget package (#4194)
* [`[8ce7bb7f16]`](https://github.com/aspnet/AspNetCore/commit/8ce7bb7f16) Add HealthChecks to Middleware.sln
* [`[c80604a7da]`](https://github.com/aspnet/AspNetCore/commit/c80604a7da) Fix directory structure (#4201)
* [`[a13e3b4813]`](https://github.com/aspnet/AspNetCore/commit/a13e3b4813) Marked the `Microsoft.Extensions.ApiDescription.Design` package as "noship" (#4185)
* [`[2711049cf4]`](https://github.com/aspnet/AspNetCore/commit/2711049cf4) Fix submodules for ServerTests StaticFiles and Session
* [`[1d36dfeb5e]`](https://github.com/aspnet/AspNetCore/commit/1d36dfeb5e) Sign Browserlink
* [`[3f025e3a38]`](https://github.com/aspnet/AspNetCore/commit/3f025e3a38) Make Microsoft.AspNetCore.Server.IntegrationTesting a temporary external dependency
* [`[ae619e6b7f]`](https://github.com/aspnet/AspNetCore/commit/ae619e6b7f) Include Microsoft.Extensions.Http.dll in signing
* [`[ade4572238]`](https://github.com/aspnet/AspNetCore/commit/ade4572238) Fix submodules for AADIntegration JavaScriptServices and MetaPackages
* [`[69534b5687]`](https://github.com/aspnet/AspNetCore/commit/69534b5687) Fix AzureIntegration submodule
* [`[d0bcdf3dd9]`](https://github.com/aspnet/AspNetCore/commit/d0bcdf3dd9) Fix dynamic require for Webpack (#3306)
* [`[e4249dade0]`](https://github.com/aspnet/AspNetCore/commit/e4249dade0) Fix the SiteExtension signing exclusion
* [`[ca42d0295e]`](https://github.com/aspnet/AspNetCore/commit/ca42d0295e) Use property group for sign exclussions
* [`[5e961e27ea]`](https://github.com/aspnet/AspNetCore/commit/5e961e27ea) Ignore apphost.exe in runtime store (#4073)
* [`[f7c26f9912]`](https://github.com/aspnet/AspNetCore/commit/f7c26f9912) [2.2.1] Use non-pinnable buffer for zero byte read (#4066)
* [`[9adb829eb5]`](https://github.com/aspnet/AspNetCore/commit/9adb829eb5) Fix MusicStore RootPath
* [`[e2a712a1cd]`](https://github.com/aspnet/AspNetCore/commit/e2a712a1cd) Add logging to HubConnectionHandlerTests (#3286)
* [`[681d743170]`](https://github.com/aspnet/AspNetCore/commit/681d743170) Update MusicStore source
* [`[09e5daa037]`](https://github.com/aspnet/AspNetCore/commit/09e5daa037) Update schema before running tests (#4030)
* [`[289050b9f2]`](https://github.com/aspnet/AspNetCore/commit/289050b9f2) Normalize code sign metadata to avoid duplication between projects and cross-gen config settings
* [`[51c9b7355d]`](https://github.com/aspnet/AspNetCore/commit/51c9b7355d) Create Kestrel.sln, update documentation and README, and ensure all Kestrel test projects have the test logger installed
* [`[0029b8f053]`](https://github.com/aspnet/AspNetCore/commit/0029b8f053) Use non-pinnable buffer for zero byte read (#3094)
* [`[b4dbaa95d0]`](https://github.com/aspnet/AspNetCore/commit/b4dbaa95d0) Add ChromeDriver dependency
* [`[e69285a36d]`](https://github.com/aspnet/AspNetCore/commit/e69285a36d) Use Selenium to test Chrome
* [`[7e96a02975]`](https://github.com/aspnet/AspNetCore/commit/7e96a02975) Skip cert errors on Chromium too (#3299)
* [`[a8ec75aac4]`](https://github.com/aspnet/AspNetCore/commit/a8ec75aac4) Prepare for the 2.2.1 patch
* [`[87092a2590]`](https://github.com/aspnet/AspNetCore/commit/87092a2590) Update targets and infrastructure for dotnet-watch et. al.
* [`[c80588ec51]`](https://github.com/aspnet/AspNetCore/commit/c80588ec51) Stop skipping libuv functional tests (#3091)
* [`[6d375e9027]`](https://github.com/aspnet/AspNetCore/commit/6d375e9027) Wait for reads before advancing clock in Http2TimeoutTests (#3090)
* [`[ccd098ecad]`](https://github.com/aspnet/AspNetCore/commit/ccd098ecad) Update DataProtection to use custom reference resolution
* [`[b476df9acd]`](https://github.com/aspnet/AspNetCore/commit/b476df9acd) Custom CORS-like middleware to allow wildcard origin in test app (#3292)
* [`[ce8cf65589]`](https://github.com/aspnet/AspNetCore/commit/ce8cf65589) Update SignalR submodule
* [`[a9def470e3]`](https://github.com/aspnet/AspNetCore/commit/a9def470e3) Don't attempt to detect java if SkipJavaClient is true
* [`[2fee09506e]`](https://github.com/aspnet/AspNetCore/commit/2fee09506e) Update the SignalR module to correct code signing config
* [`[a242dc726d]`](https://github.com/aspnet/AspNetCore/commit/a242dc726d) Ensure .jar files are included in code signing with the correct certificate
* [`[140cf62b56]`](https://github.com/aspnet/AspNetCore/commit/140cf62b56) Re-enable SignCheck
* [`[f64d6a2b50]`](https://github.com/aspnet/AspNetCore/commit/f64d6a2b50) Updating dependencies (#3996)
* [`[dfacde4dee]`](https://github.com/aspnet/AspNetCore/commit/dfacde4dee) Fix /t:FastCheck for local-projects
* [`[1c8df01d09]`](https://github.com/aspnet/AspNetCore/commit/1c8df01d09) Update PR validation to fix the FastCheck config and IIS tests
* [`[27a47d07c5]`](https://github.com/aspnet/AspNetCore/commit/27a47d07c5) Reorganize the src/WebSockets/ folder to follow new source code organization conventions
* [`[5db6394769]`](https://github.com/aspnet/AspNetCore/commit/5db6394769) Always decrement count on HTTP/2 stream completion (#3087)
* [`[8356baf7a6]`](https://github.com/aspnet/AspNetCore/commit/8356baf7a6) Port ANCM installer changes to 2.1 (#3874)
* [`[4d2e68649f]`](https://github.com/aspnet/AspNetCore/commit/4d2e68649f) Expect correct error message in HTTP/2 test (#3085)
* [`[a3baf40c74]`](https://github.com/aspnet/AspNetCore/commit/a3baf40c74) Set dependency version on Microsoft.Extensions.DiagnosticAdapter to 2.1.0 and prune unused logging analyzers dependency
* [`[7f4d10775c]`](https://github.com/aspnet/AspNetCore/commit/7f4d10775c) Add signcheck exclusions (#3985)
* [`[031a2ed214]`](https://github.com/aspnet/AspNetCore/commit/031a2ed214) Stop producing runtime-site-extension-internal.zip (#248)
* [`[50bb0b3bc9]`](https://github.com/aspnet/AspNetCore/commit/50bb0b3bc9) Implement no-op HTTP/2 IHttpUpgradeFeature (#3082)
* [`[f05b0e792d]`](https://github.com/aspnet/AspNetCore/commit/f05b0e792d) Add some logging for functional tests
* [`[a1c1083798]`](https://github.com/aspnet/AspNetCore/commit/a1c1083798) [2.2] Fix race conditions in HTTP/2 tests (#3078)
* [`[263fb650be]`](https://github.com/aspnet/AspNetCore/commit/263fb650be) Detect shared configuration in ANCM installers and fail if enabled (#3962)
* [`[f4d3ebe09a]`](https://github.com/aspnet/AspNetCore/commit/f4d3ebe09a) Add docs blurb to Readme (#3276)
* [`[a03b8f85a8]`](https://github.com/aspnet/AspNetCore/commit/a03b8f85a8) Add docker retry to stackexchange redis tests (#3270)
* [`[d81128de11]`](https://github.com/aspnet/AspNetCore/commit/d81128de11) Fix CodeSign.props to include the .dll in the file name for logging files
* [`[56f78b4593]`](https://github.com/aspnet/AspNetCore/commit/56f78b4593) Retry redis docker (#3265)
* [`[7ef549416f]`](https://github.com/aspnet/AspNetCore/commit/7ef549416f) Add prerelease label to deb installer package version
* [`[ffd4bcd850]`](https://github.com/aspnet/AspNetCore/commit/ffd4bcd850) Server per test (#3253)
* [`[5eac0befd0]`](https://github.com/aspnet/AspNetCore/commit/5eac0befd0) Include assemblies from aspnet/FileSystem in the list of assemblies to code-signing
* [`[9d794af34d]`](https://github.com/aspnet/AspNetCore/commit/9d794af34d) Update to .NET Core 2.2.0-rtm-27105-02 and Extensions 2.2.0-rtm-181105-01
* [`[90b11de8f1]`](https://github.com/aspnet/AspNetCore/commit/90b11de8f1) Get IISIntegration CI working (#3875)
* [`[e8fec8eb52]`](https://github.com/aspnet/AspNetCore/commit/e8fec8eb52) Enable symbols generation for crossgen'ed assemblies on linux-arm (#3877)
* [`[0e24161d42]`](https://github.com/aspnet/AspNetCore/commit/0e24161d42) Ensure Microsoft.AspNetCore.Server.IntegrationTesting.IIS doesn't produce a finalized version
* [`[40a9b18c43]`](https://github.com/aspnet/AspNetCore/commit/40a9b18c43) Ignore certificate errors
* [`[f2a383dc76]`](https://github.com/aspnet/AspNetCore/commit/f2a383dc76) Don't count long tick intervals against rate measurements (#3070)
* [`[1ab2caa431]`](https://github.com/aspnet/AspNetCore/commit/1ab2caa431) Update list of files to include DependencyInjection
* [`[303ee1ff56]`](https://github.com/aspnet/AspNetCore/commit/303ee1ff56) Fix the filename for the debian installer
* [`[b006a2c789]`](https://github.com/aspnet/AspNetCore/commit/b006a2c789) Clean up logging (#3247)
* [`[d745b8c161]`](https://github.com/aspnet/AspNetCore/commit/d745b8c161) Fix #485
* [`[22a32500ac]`](https://github.com/aspnet/AspNetCore/commit/22a32500ac) Fix several issues
* [`[f170981fec]`](https://github.com/aspnet/AspNetCore/commit/f170981fec) Add auth server package
* [`[57d52d392d]`](https://github.com/aspnet/AspNetCore/commit/57d52d392d) Add Microsoft.NETFramework.ReferenceAssemblies to list of external dependencies
* [`[cd36ae4f16]`](https://github.com/aspnet/AspNetCore/commit/cd36ae4f16) Delete mv_to_src.sh
* [`[ee0a11d048]`](https://github.com/aspnet/AspNetCore/commit/ee0a11d048) Update code signing configuration to account for crossgen-ed assemblies (#3783)
* [`[7fbedc602c]`](https://github.com/aspnet/AspNetCore/commit/7fbedc602c) Move 22 into subfolder
* [`[55e809c5dc]`](https://github.com/aspnet/AspNetCore/commit/55e809c5dc) Move more files
* [`[83139d36f4]`](https://github.com/aspnet/AspNetCore/commit/83139d36f4) Add some missing test logging (#3242)
* [`[040fb6f18a]`](https://github.com/aspnet/AspNetCore/commit/040fb6f18a) Move IISIntegration into subfolder
* [`[d50c0c13b9]`](https://github.com/aspnet/AspNetCore/commit/d50c0c13b9) Measure the rate of all HTTP/2 output (#3067)
* [`[a6199bbfba]`](https://github.com/aspnet/AspNetCore/commit/a6199bbfba) Add integration and functional tests of `[BindRequired]` on page properties (#8677)
* [`[3b485909eb]`](https://github.com/aspnet/AspNetCore/commit/3b485909eb) Fix aspnet/AspNetCore#3634
* [`[954362f344]`](https://github.com/aspnet/AspNetCore/commit/954362f344) Update the sign config entry for API-MS-Win-core-xstate-l2-1-0.dll to match case exactly
* [`[4c51201f58]`](https://github.com/aspnet/AspNetCore/commit/4c51201f58) Include win-arm assets in the signing configuration
* [`[b262521969]`](https://github.com/aspnet/AspNetCore/commit/b262521969) Include x86 assets in the signing configuration
* [`[c802d5ef5f]`](https://github.com/aspnet/AspNetCore/commit/c802d5ef5f) Redesign HealthStatus (again) (#520)
* [`[569016c2c5]`](https://github.com/aspnet/AspNetCore/commit/569016c2c5) Code sign all packages in a single batch (#3778)
* [`[27efce1042]`](https://github.com/aspnet/AspNetCore/commit/27efce1042) Do not use the default 5000 port for functional tests
* [`[1f896dc61b]`](https://github.com/aspnet/AspNetCore/commit/1f896dc61b) :arrow_up: Update NetTopologySuite.IO.SqlServerBytes to 1.15.0
* [`[5b486cdfa9]`](https://github.com/aspnet/AspNetCore/commit/5b486cdfa9) Java API Doc revisions
* [`[865de16086]`](https://github.com/aspnet/AspNetCore/commit/865de16086) Enable cookie jar for Node client using request package (#3202)
* [`[c74a945dda]`](https://github.com/aspnet/AspNetCore/commit/c74a945dda) Convert `RouteValueDictionary` values to `string` using `CultureInfo.InvariantCulture` (#8674)
* [`[41fa3ff3eb]`](https://github.com/aspnet/AspNetCore/commit/41fa3ff3eb) Add Razor.Workspaces to non-shipping in NPV
* [`[36ca210a65]`](https://github.com/aspnet/AspNetCore/commit/36ca210a65) [Java] Add null ref test for websocket
* [`[3e08bf8833]`](https://github.com/aspnet/AspNetCore/commit/3e08bf8833) Move tests to net472
* [`[734b919b02]`](https://github.com/aspnet/AspNetCore/commit/734b919b02) Respect SuppressInferBindingSourcesForParameters
* [`[c9600ac2d4]`](https://github.com/aspnet/AspNetCore/commit/c9600ac2d4) [Java] Log invocation binding failures (#3160)
* [`[af6527dcef]`](https://github.com/aspnet/AspNetCore/commit/af6527dcef) Fix XML doc on HttpMethodAttribute and derived ones
* [`[e958d82584]`](https://github.com/aspnet/AspNetCore/commit/e958d82584) Add more chrome test logging
* [`[73f2f19984]`](https://github.com/aspnet/AspNetCore/commit/73f2f19984) [Java] API level support down to 23
* [`[97dc5852a2]`](https://github.com/aspnet/AspNetCore/commit/97dc5852a2) Suppress warning NU5125 about upcoming deprecation of PackageLicenseUrl (#3758)
* [`[4c94bc272b]`](https://github.com/aspnet/AspNetCore/commit/4c94bc272b) Rename anti-caching option
* [`[a058bc0c0a]`](https://github.com/aspnet/AspNetCore/commit/a058bc0c0a) Win-arm shared framework
* [`[9407fe12f6]`](https://github.com/aspnet/AspNetCore/commit/9407fe12f6) RxJava is on the public API so the library needs to declare it as such (#3155)
* [`[134bd90888]`](https://github.com/aspnet/AspNetCore/commit/134bd90888) Filter paths in SiteExtension trigger (#3747)
* [`[35d2ab37f7]`](https://github.com/aspnet/AspNetCore/commit/35d2ab37f7) Allow passing a dictionary to ValidationProblemDetails
* [`[ccde910b29]`](https://github.com/aspnet/AspNetCore/commit/ccde910b29) Specify TaskCreationOptions when using TCS
* [`[1afd5b2594]`](https://github.com/aspnet/AspNetCore/commit/1afd5b2594) Don't use Map
* [`[37e562902f]`](https://github.com/aspnet/AspNetCore/commit/37e562902f) Support single `IDocumentProvider` method signature - #8593 - also find `IDocumentProvider` using a more-laborious process   - `Type.GetType(string)` requires an assembly-qualified name and we don't know the assembly - default method name now `GenerateAsync` - only supported signature is `public Task GenerateAsync(string, TextWriter)`
* [`[373e67896a]`](https://github.com/aspnet/AspNetCore/commit/373e67896a) Fix the path to RPM template and config files
* [`[eba014d534]`](https://github.com/aspnet/AspNetCore/commit/eba014d534) Add additional signing configuration for external assemblies in the tools packages
* [`[e8b9dc52ba]`](https://github.com/aspnet/AspNetCore/commit/e8b9dc52ba) Fix NullPointerException when unboxing null to int.
* [`[6ecf5374c6]`](https://github.com/aspnet/AspNetCore/commit/6ecf5374c6) Use 3PartySHA2 instead of 3PartyDual for code-signing Newtonsoft.Json.dll (#2678)
* [`[e0c575000f]`](https://github.com/aspnet/AspNetCore/commit/e0c575000f) Ensure MicrosoftNETCoreAppPackageVersion is always defined
* [`[6bafc157e7]`](https://github.com/aspnet/AspNetCore/commit/6bafc157e7) Update code signing config to exclude .js and .ttf files in template packages
* [`[2adf798ba0]`](https://github.com/aspnet/AspNetCore/commit/2adf798ba0) Fix peer dependencies in React templates
* [`[a74235c7ec]`](https://github.com/aspnet/AspNetCore/commit/a74235c7ec) Reflect Access-Control-Request-Headers and Access-Control-Request-Method when policy is configured to support wildcard
* [`[395b681348]`](https://github.com/aspnet/AspNetCore/commit/395b681348) Add HTTP/2 request body data rate limit (#3051)
* [`[99f2ecd02f]`](https://github.com/aspnet/AspNetCore/commit/99f2ecd02f) Move transformation tests from AzureIntegration (#3726)
* [`[d9aba751ae]`](https://github.com/aspnet/AspNetCore/commit/d9aba751ae) Change TargetFramework for micro benchmarks
* [`[958e0b1d9f]`](https://github.com/aspnet/AspNetCore/commit/958e0b1d9f) Get rid of Page1 Page2
* [`[ae122d9bc0]`](https://github.com/aspnet/AspNetCore/commit/ae122d9bc0) Include rid-specific runtime packages in the list of artifacts
* [`[77a3089c8d]`](https://github.com/aspnet/AspNetCore/commit/77a3089c8d) Workaround quirks in NuGet
* [`[dbc28c523e]`](https://github.com/aspnet/AspNetCore/commit/dbc28c523e) Avoid double restores by invoking NuGet.targets directly
* [`[616aeba156]`](https://github.com/aspnet/AspNetCore/commit/616aeba156) Use chrome instead of chromium on Ubuntu
* [`[0aab8e5dd0]`](https://github.com/aspnet/AspNetCore/commit/0aab8e5dd0) added maven badge to readme.md (#3201)
* [`[b05185f1f1]`](https://github.com/aspnet/AspNetCore/commit/b05185f1f1) ESLint (#796)
* [`[9b3d1f56fd]`](https://github.com/aspnet/AspNetCore/commit/9b3d1f56fd) Handle peer dependency warnings (#794)
* [`[4433d967ad]`](https://github.com/aspnet/AspNetCore/commit/4433d967ad) Update CLI functional tests to account for the addition of Microsoft.IdentityModel.JsonWebTokens.dll
* [`[c6f9783671]`](https://github.com/aspnet/AspNetCore/commit/c6f9783671) Add AspNetCore runtime back into the runtime site extension (#244)
* [`[31f1e170d0]`](https://github.com/aspnet/AspNetCore/commit/31f1e170d0) Add interop tests with headless chrome
* [`[a8a3f99f1a]`](https://github.com/aspnet/AspNetCore/commit/a8a3f99f1a) Skip restore on .zipproj files
* [`[044f613804]`](https://github.com/aspnet/AspNetCore/commit/044f613804) Include failed HRESULTs and exceptions in FREB log (#1548)
* [`[de185b6a06]`](https://github.com/aspnet/AspNetCore/commit/de185b6a06) Duplicate debug log handle for console logging (#1558)
* [`[91db78cf92]`](https://github.com/aspnet/AspNetCore/commit/91db78cf92) Add safe copy for enumeration (#1052)
* [`[3d828221a1]`](https://github.com/aspnet/AspNetCore/commit/3d828221a1) Rename sandbox website directory (#892)
* [`[01f9af21c5]`](https://github.com/aspnet/AspNetCore/commit/01f9af21c5) Temporarily stop producing a package for dotnet-httprepl (#505)
* [`[aa88f16b08]`](https://github.com/aspnet/AspNetCore/commit/aa88f16b08) Fix cors with creds (#193)
* [`[70a786adcd]`](https://github.com/aspnet/AspNetCore/commit/70a786adcd) Make AspNetCoreHostingModel element not be insert when targeting net461 and inprocess => InProcess (#797)
* [`[29c06e2636]`](https://github.com/aspnet/AspNetCore/commit/29c06e2636) Update deps (#3170)
* [`[c129d272a4]`](https://github.com/aspnet/AspNetCore/commit/c129d272a4) Update npm readme with Node info (#3194)
* [`[2544926b2f]`](https://github.com/aspnet/AspNetCore/commit/2544926b2f) Provide a convenience API to configure ApiBehaviorOptions
* [`[5c3017524f]`](https://github.com/aspnet/AspNetCore/commit/5c3017524f) Fix upgrade deps and run upgrade deps (#1553)
* [`[577be72faa]`](https://github.com/aspnet/AspNetCore/commit/577be72faa) Split sandbox and functional tests websites (#890)
* [`[935df249c4]`](https://github.com/aspnet/AspNetCore/commit/935df249c4) Shorten siteextension version to fit into 20 chars (#3707)
* [`[a5fcd9dd87]`](https://github.com/aspnet/AspNetCore/commit/a5fcd9dd87) Add application/wasm #3681 (#259)
* [`[f7e8255ece]`](https://github.com/aspnet/AspNetCore/commit/f7e8255ece) Add forwards compat tests (#1547)
* [`[3842779379]`](https://github.com/aspnet/AspNetCore/commit/3842779379) Check what current processes are running to see if dotnet.exe/iisexpress.exe is being stopped. (#1530)
* [`[f7d10bec02]`](https://github.com/aspnet/AspNetCore/commit/f7d10bec02) [Java] Plumb RxJava through client (#3148)
* [`[63900a462b]`](https://github.com/aspnet/AspNetCore/commit/63900a462b) Use Node https module for https requests (#3171)
* [`[40959a97e7]`](https://github.com/aspnet/AspNetCore/commit/40959a97e7) Fix link generation of routes with default values (#8616)
* [`[bd32ec3837]`](https://github.com/aspnet/AspNetCore/commit/bd32ec3837) Add basic test for RouteValueEqualityComparer.Equals(...). (#883)
* [`[25b5ab2c39]`](https://github.com/aspnet/AspNetCore/commit/25b5ab2c39) Improve performance and reduce allocations in RouteValuesAddressScheme. (#879)
* [`[32532078d6]`](https://github.com/aspnet/AspNetCore/commit/32532078d6) Log binary data as a parameter #2860
* [`[c93e3a76ff]`](https://github.com/aspnet/AspNetCore/commit/c93e3a76ff) Eliminate redundant isValid check from DefaultEndpointSelector.ProcessFinalCandidates(...). (#881)
* [`[26e5ea3274]`](https://github.com/aspnet/AspNetCore/commit/26e5ea3274) Improves performance and reduce allocations in DefaultEndpointDataSource (#882)
* [`[707b1bbf3b]`](https://github.com/aspnet/AspNetCore/commit/707b1bbf3b) Fix link
* [`[b623b9912e]`](https://github.com/aspnet/AspNetCore/commit/b623b9912e) Make EFCore.Cosmos no-ship package
* [`[14323b5dd5]`](https://github.com/aspnet/AspNetCore/commit/14323b5dd5) Delete CODEOWNERS
* [`[0a22b927b2]`](https://github.com/aspnet/AspNetCore/commit/0a22b927b2) Use GUIDs for cache tests.
* [`[2a610ee1b8]`](https://github.com/aspnet/AspNetCore/commit/2a610ee1b8) Reduce flakiness of LargeUpload tests (#3036)
* [`[ad3cba5509]`](https://github.com/aspnet/AspNetCore/commit/ad3cba5509) Disable inheritance test on linux #3034
* [`[ffa72f5a0c]`](https://github.com/aspnet/AspNetCore/commit/ffa72f5a0c) Fix two string allocation issues (#1539)
* [`[79d098045b]`](https://github.com/aspnet/AspNetCore/commit/79d098045b) Code-sign the Microsoft.AspNetCore.AspNetCoreModule{V2} packages
* [`[1d05592cd7]`](https://github.com/aspnet/AspNetCore/commit/1d05592cd7) Allow parameter names to match required keys in templates (#872)
* [`[b3db95eb2d]`](https://github.com/aspnet/AspNetCore/commit/b3db95eb2d) Change 'create' to 'delete' in message
* [`[2081160678]`](https://github.com/aspnet/AspNetCore/commit/2081160678) Improve performance and reduce allocations of TemplateSegment (#856)
* [`[0f90a15cf1]`](https://github.com/aspnet/AspNetCore/commit/0f90a15cf1) Use Array.Clone() to copy arrays, and avoid copy where applicable (#855)
* [`[42914d93ca]`](https://github.com/aspnet/AspNetCore/commit/42914d93ca) Declare out variables inline, and use discards (#873)
* [`[277a5502fd]`](https://github.com/aspnet/AspNetCore/commit/277a5502fd) Flush response headers #3031
* [`[95ccb1ee52]`](https://github.com/aspnet/AspNetCore/commit/95ccb1ee52) More Java Docs (#3138)
* [`[4134e7bcf3]`](https://github.com/aspnet/AspNetCore/commit/4134e7bcf3) Re-enable repo code signing
* [`[ddbe0fef26]`](https://github.com/aspnet/AspNetCore/commit/ddbe0fef26) Allow custom handling of antiforgery failures
* [`[8a183bb4f4]`](https://github.com/aspnet/AspNetCore/commit/8a183bb4f4) Allow serving Razor files with leading underscore
* [`[30870b34c0]`](https://github.com/aspnet/AspNetCore/commit/30870b34c0) Fix abort race in response body tests #451
* [`[d82a3e6c99]`](https://github.com/aspnet/AspNetCore/commit/d82a3e6c99) Update to new VSTS script (#3162)
* [`[23a4e11261]`](https://github.com/aspnet/AspNetCore/commit/23a4e11261) Send RST for canceled HTTP/2 writes #3007
* [`[7f34909708]`](https://github.com/aspnet/AspNetCore/commit/7f34909708) Include EFCore in real code signing
* [`[8b05b859e8]`](https://github.com/aspnet/AspNetCore/commit/8b05b859e8) Fix jenkins filename and add VSTS test runs (#1537)
* [`[33386e424a]`](https://github.com/aspnet/AspNetCore/commit/33386e424a) Re-enable skipped auth test #474
* [`[e68c8025d5]`](https://github.com/aspnet/AspNetCore/commit/e68c8025d5) Don't set Redis timeout (#3154)
* [`[af01ed1715]`](https://github.com/aspnet/AspNetCore/commit/af01ed1715) Shorten log file names (#1536)
* [`[7191c12a65]`](https://github.com/aspnet/AspNetCore/commit/7191c12a65) Enable logging in chat sample (#3134)
* [`[b92c82e97f]`](https://github.com/aspnet/AspNetCore/commit/b92c82e97f) Add static shim test (#1505)
* [`[d3f2ca9c9a]`](https://github.com/aspnet/AspNetCore/commit/d3f2ca9c9a) Do not inherit socket handles #2789
* [`[55d849a0d0]`](https://github.com/aspnet/AspNetCore/commit/55d849a0d0) Add compression pass through tests (#1525)
* [`[203c2a22ed]`](https://github.com/aspnet/AspNetCore/commit/203c2a22ed) Add package-info file for docs (#3123)
* [`[48d40e0e36]`](https://github.com/aspnet/AspNetCore/commit/48d40e0e36) Add mitigations to HttpsClientCert_GetCertInformation flakiness (#1529)
* [`[1d3090f056]`](https://github.com/aspnet/AspNetCore/commit/1d3090f056) Only reset the request body pipe for HTTP/1 #3006
* [`[e51da32e9d]`](https://github.com/aspnet/AspNetCore/commit/e51da32e9d) Prefer StringComparison over StringComparer when not using comparers (#870)
* [`[27e75e7a51]`](https://github.com/aspnet/AspNetCore/commit/27e75e7a51) Add a switch to allow turning on ValidationVisitor shortcircuiting (#8599)
* [`[80d3bbfcc9]`](https://github.com/aspnet/AspNetCore/commit/80d3bbfcc9) Update code signing config to exclude .js files in template packages
* [`[97acb95715]`](https://github.com/aspnet/AspNetCore/commit/97acb95715) Set default protocol to HTTP/1.x
* [`[a43587290f]`](https://github.com/aspnet/AspNetCore/commit/a43587290f) fix : DefaultFilesMiddleware serve with unicode path (#257)
* [`[b951ac9b64]`](https://github.com/aspnet/AspNetCore/commit/b951ac9b64) Fix path to aspnetcoreca.dll for signed output (#1513)
* [`[8f99140f30]`](https://github.com/aspnet/AspNetCore/commit/8f99140f30) Add client disconnect logs (#1521)
* [`[6d076dafae]`](https://github.com/aspnet/AspNetCore/commit/6d076dafae) Update certificate info for .zip and .mof files
* [`[e75dc56327]`](https://github.com/aspnet/AspNetCore/commit/e75dc56327) Sign Newtonsoft.Json with AssemblySigning3rdPartyCertName
* [`[297156a4ef]`](https://github.com/aspnet/AspNetCore/commit/297156a4ef) Check if HubConnection stopped normally (#3135)
* [`[6366deb193]`](https://github.com/aspnet/AspNetCore/commit/6366deb193) Update dataprotection to 2.2.0-rtm
* [`[a68e40c2ca]`](https://github.com/aspnet/AspNetCore/commit/a68e40c2ca) Fix package name (#241)
* [`[47e2ba3755]`](https://github.com/aspnet/AspNetCore/commit/47e2ba3755) Fix package name
* [`[74aefc855d]`](https://github.com/aspnet/AspNetCore/commit/74aefc855d) Set DOTNET_ROOT in runtime site extension (#240)
* [`[393815b8ad]`](https://github.com/aspnet/AspNetCore/commit/393815b8ad) Increase test timeout to accomodate slow machines
* [`[3ae18fb539]`](https://github.com/aspnet/AspNetCore/commit/3ae18fb539) Add skip conditions (#1520)
* [`[f2ddc6efc0]`](https://github.com/aspnet/AspNetCore/commit/f2ddc6efc0) Update .NET Core to 2.2.0-preview3-27014-02
* [`[904aac3612]`](https://github.com/aspnet/AspNetCore/commit/904aac3612) Embed version into 2.1 logging site extensions name (#238)
* [`[1ff9a3d80c]`](https://github.com/aspnet/AspNetCore/commit/1ff9a3d80c) Fixed broken link (#504)
* [`[06dbdf5ced]`](https://github.com/aspnet/AspNetCore/commit/06dbdf5ced) Increase retry count
* [`[4b9a3fcc05]`](https://github.com/aspnet/AspNetCore/commit/4b9a3fcc05) Skip falky tests caused by https://github.com/dotnet/corefx/issues/30691
* [`[73f161cc60]`](https://github.com/aspnet/AspNetCore/commit/73f161cc60) Set crossorigin anonymous for integrity
* [`[24e2e5ad52]`](https://github.com/aspnet/AspNetCore/commit/24e2e5ad52) Port startup tests to IIS (#1513)
* [`[cc45d0cb41]`](https://github.com/aspnet/AspNetCore/commit/cc45d0cb41) Use dev certs
* [`[bd375fc9ee]`](https://github.com/aspnet/AspNetCore/commit/bd375fc9ee) Fix audit failure
* [`[b0deed05be]`](https://github.com/aspnet/AspNetCore/commit/b0deed05be) Add server abort tests (#1510)
* [`[c421178a22]`](https://github.com/aspnet/AspNetCore/commit/c421178a22) Update docs for compat switch value
* [`[5551729797]`](https://github.com/aspnet/AspNetCore/commit/5551729797) Update Formatted Log Messages (#3124)
* [`[0b5973e501]`](https://github.com/aspnet/AspNetCore/commit/0b5973e501) Enable auth tests on IIS (#1511)
* [`[8ad589c4d1]`](https://github.com/aspnet/AspNetCore/commit/8ad589c4d1) Provide better errors if launching the browser failed
* [`[3a1cf72451]`](https://github.com/aspnet/AspNetCore/commit/3a1cf72451) #3009 HTTP/2 Test stabalization (#3010)
* [`[fb57810f29]`](https://github.com/aspnet/AspNetCore/commit/fb57810f29) Shortcircuit validation when using default validator providers and no validation metadata is discovered
* [`[dbc1d38a58]`](https://github.com/aspnet/AspNetCore/commit/dbc1d38a58) Move ANCM installers to Universe (#1456)
* [`[164d14064c]`](https://github.com/aspnet/AspNetCore/commit/164d14064c) Use casing for ProblemDetails that specified by RFC
* [`[fb3f5d95c2]`](https://github.com/aspnet/AspNetCore/commit/fb3f5d95c2) Backport infrastructure changes and source reorganization
* [`[1f2e704dd3]`](https://github.com/aspnet/AspNetCore/commit/1f2e704dd3) Implement MinResponseDataRate for HTTP/2 (#3003)
* [`[897386ab3f]`](https://github.com/aspnet/AspNetCore/commit/897386ab3f) Temporary disable AppVerif tests in Jenkins (#1509)
* [`[642e8e9d7c]`](https://github.com/aspnet/AspNetCore/commit/642e8e9d7c) Add Basic auth tests and fix Windows auth tests (#1502)
* [`[5d5438a7f0]`](https://github.com/aspnet/AspNetCore/commit/5d5438a7f0) Relax test SkuTelemetry strictness #1875
* [`[fbf0708f19]`](https://github.com/aspnet/AspNetCore/commit/fbf0708f19) Fix DfaGraphWriter ISuppressMatchingMetadata check (#850)
* [`[e6bdf128f2]`](https://github.com/aspnet/AspNetCore/commit/e6bdf128f2) Log when a request is an OPTIONS request but not a preflight request
* [`[b833d1df88]`](https://github.com/aspnet/AspNetCore/commit/b833d1df88) Set DOTNET_HOME to repo dir when `--ci` is specified (#1490)
* [`[facaa1387a]`](https://github.com/aspnet/AspNetCore/commit/facaa1387a) Logging with SLF4J (#3120)
* [`[fe82fd9682]`](https://github.com/aspnet/AspNetCore/commit/fe82fd9682) Committing changes required to have SignalR depend on the centralized Microsoft BOM file for Java libraries (#3114)
* [`[1fb57d9ed9]`](https://github.com/aspnet/AspNetCore/commit/1fb57d9ed9) Enable appverifier and dumps on jenkins (#1491)
* [`[9b1fd75b7e]`](https://github.com/aspnet/AspNetCore/commit/9b1fd75b7e) Include mof file in ANCMV2 package (#1499)
* [`[081cef0934]`](https://github.com/aspnet/AspNetCore/commit/081cef0934) Track aborted streams for a given grace period #2832
* [`[b5c0ed228a]`](https://github.com/aspnet/AspNetCore/commit/b5c0ed228a) Skip code-signing EFCore with repo signing while we workout issues with signtool (#1487)
* [`[0afaccf4df]`](https://github.com/aspnet/AspNetCore/commit/0afaccf4df) Prevent contention (#1486)
* [`[df394051d0]`](https://github.com/aspnet/AspNetCore/commit/df394051d0) JQuery Unobtrusive to 3.2.11
* [`[e08774b6f0]`](https://github.com/aspnet/AspNetCore/commit/e08774b6f0) [Java] Add ability to configure headers (#3090)
* [`[1132cad70b]`](https://github.com/aspnet/AspNetCore/commit/1132cad70b) public const string AuthenticationScheme (#1496)
* [`[e0883c2da3]`](https://github.com/aspnet/AspNetCore/commit/e0883c2da3) Add NetTopologySuite.IO.SqlServerBytes dependency
* [`[06e9531d50]`](https://github.com/aspnet/AspNetCore/commit/06e9531d50) Update IdentityModel packages
* [`[800c79c0e4]`](https://github.com/aspnet/AspNetCore/commit/800c79c0e4) Fast-path async in HttpResponseStreamWriter
* [`[773aa6e6ff]`](https://github.com/aspnet/AspNetCore/commit/773aa6e6ff) Http{Request|Response}Stream.ValidateState made inlineable
* [`[ed4cef6b98]`](https://github.com/aspnet/AspNetCore/commit/ed4cef6b98) Add *.StackExchangeRedis packages (#1466)
* [`[3f5f419df8]`](https://github.com/aspnet/AspNetCore/commit/3f5f419df8) Add Redis 2.0 package (#325)
* [`[286e4bebf7]`](https://github.com/aspnet/AspNetCore/commit/286e4bebf7) Add StackExchange.Redis 2.X.X package (#3089)
* [`[3f001750ad]`](https://github.com/aspnet/AspNetCore/commit/3f001750ad) Rationalize code sharing between the three code generation projects - #8417 - just two files needed to be moved&hellip;
* [`[bfa583a9aa]`](https://github.com/aspnet/AspNetCore/commit/bfa583a9aa) Guard OnAsyncCompletion from completing request before OnExecuteRequestHandler exits (#1489)
* [`[2ee351786f]`](https://github.com/aspnet/AspNetCore/commit/2ee351786f) [Java] Add pings and server timeout (#3027)
* [`[ab124fc344]`](https://github.com/aspnet/AspNetCore/commit/ab124fc344) Fix applicationInitialization tests and disconnect handler (#1484)
* [`[7d09ec6ccc]`](https://github.com/aspnet/AspNetCore/commit/7d09ec6ccc) Low hanging fruit (#763)
* [`[be4fe6c6f9]`](https://github.com/aspnet/AspNetCore/commit/be4fe6c6f9) Wait for handshake response in Java Client(#3068)
* [`[2c365b8fc5]`](https://github.com/aspnet/AspNetCore/commit/2c365b8fc5) Explicitly push to a branch
* [`[ac7a6b56d4]`](https://github.com/aspnet/AspNetCore/commit/ac7a6b56d4) Reenable client disconnect tests (#1485)
* [`[692185f7d2]`](https://github.com/aspnet/AspNetCore/commit/692185f7d2) Upgrade Java client to RTM versioning (#3104)
* [`[cd33755bee]`](https://github.com/aspnet/AspNetCore/commit/cd33755bee) [Java] Make public API look like RxJava (#3103)
* [`[f6e20a38e2]`](https://github.com/aspnet/AspNetCore/commit/f6e20a38e2) HostString throws ArgumentNullException for null host (#1045)
* [`[9daf5ff7a4]`](https://github.com/aspnet/AspNetCore/commit/9daf5ff7a4) Fix PageRouteTransformerConvention with custom page routes (#8576)
* [`[7a09638afe]`](https://github.com/aspnet/AspNetCore/commit/7a09638afe) Modernize startup error pages (#1476)
* [`[f2fbd803b9]`](https://github.com/aspnet/AspNetCore/commit/f2fbd803b9) Flow request trace context to CreateApplication (#1480)
* [`[3cf20afc8a]`](https://github.com/aspnet/AspNetCore/commit/3cf20afc8a) Fix syntax error
* [`[904c9d3623]`](https://github.com/aspnet/AspNetCore/commit/904c9d3623) Use Moq v4.10
* [`[85ecc5ba4c]`](https://github.com/aspnet/AspNetCore/commit/85ecc5ba4c) Add Redis 2.0 (#1459)
* [`[0a1c60e2d3]`](https://github.com/aspnet/AspNetCore/commit/0a1c60e2d3) Update Moq to 4.11.0
* [`[f65c1a4e3d]`](https://github.com/aspnet/AspNetCore/commit/f65c1a4e3d) Push UpdateRepos to maestro branch
* [`[3cd98acda3]`](https://github.com/aspnet/AspNetCore/commit/3cd98acda3) Updating external dependencies (#1464)
* [`[70f2d3abd9]`](https://github.com/aspnet/AspNetCore/commit/70f2d3abd9) Update Roslyn version.
* [`[21b98de09b]`](https://github.com/aspnet/AspNetCore/commit/21b98de09b) Update System.IO.Pipelines to 4.5.2 (#1458)
* [`[12761474d3]`](https://github.com/aspnet/AspNetCore/commit/12761474d3) Rename Cosmos.Sql to Cosmos (#1467)
* [`[83e8d64952]`](https://github.com/aspnet/AspNetCore/commit/83e8d64952) Updating EF submodule
* [`[1593966f3b]`](https://github.com/aspnet/AspNetCore/commit/1593966f3b) Update repos send PRs
* [`[1f31e0556d]`](https://github.com/aspnet/AspNetCore/commit/1f31e0556d) Add IHealthCheckPublisher for push-based checks (#498)
* [`[f87d8b4aaf]`](https://github.com/aspnet/AspNetCore/commit/f87d8b4aaf) Change Java client package name to com.microsoft.signalr (#3096)
* [`[8bca6b3877]`](https://github.com/aspnet/AspNetCore/commit/8bca6b3877) Add HTTP/2 keep-alive and request header timeouts (#2992)
* [`[1be7cd1f74]`](https://github.com/aspnet/AspNetCore/commit/1be7cd1f74) Disconnect the disconnect handler when request processing ends  (#1471)
* [`[7eb16afc9c]`](https://github.com/aspnet/AspNetCore/commit/7eb16afc9c) Java Client API Review pt2 (#3078)
* [`[813a9e68bc]`](https://github.com/aspnet/AspNetCore/commit/813a9e68bc) Add Java Check (#3085)
* [`[956441aa68]`](https://github.com/aspnet/AspNetCore/commit/956441aa68) Ignore created URI if Assembly.CodeBase contains a fragment (#8556)
* [`[b9166f14f1]`](https://github.com/aspnet/AspNetCore/commit/b9166f14f1) Skipping test failing on Win2k8 R2
* [`[4347a45f29]`](https://github.com/aspnet/AspNetCore/commit/4347a45f29) Always add event source logger (#287)
* [`[9722d89572]`](https://github.com/aspnet/AspNetCore/commit/9722d89572) Adjust log levels
* [`[67a1f2dda9]`](https://github.com/aspnet/AspNetCore/commit/67a1f2dda9) Add security text about Host header
* [`[81fb93a896]`](https://github.com/aspnet/AspNetCore/commit/81fb93a896) Fix Routing#837
* [`[9db2833fc2]`](https://github.com/aspnet/AspNetCore/commit/9db2833fc2) Make endpoint selector policies per-candidate-set
* [`[af47b27f0d]`](https://github.com/aspnet/AspNetCore/commit/af47b27f0d) Add blurb about Host header
* [`[5b90028fe3]`](https://github.com/aspnet/AspNetCore/commit/5b90028fe3) Expose status code of BadHttpRequestException
* [`[d1829b2491]`](https://github.com/aspnet/AspNetCore/commit/d1829b2491) Transport stop triggers HubConnection stop (#3054)
* [`[daf6e1ecd7]`](https://github.com/aspnet/AspNetCore/commit/daf6e1ecd7) Http/2 response trailers #622
* [`[89b0430bda]`](https://github.com/aspnet/AspNetCore/commit/89b0430bda) Add IHttpResponseTrailersFeature and extensions
* [`[6f76189846]`](https://github.com/aspnet/AspNetCore/commit/6f76189846) Normalize internationalized domain names when adding to CORS Fixes https://github.com/aspnet/Home/issues/3353
* [`[7f6dd893dd]`](https://github.com/aspnet/AspNetCore/commit/7f6dd893dd) Make the ActionBase type internal (#3069)
* [`[f91ae20a3c]`](https://github.com/aspnet/AspNetCore/commit/f91ae20a3c) Improve RequestAborted token handling (#2977)
* [`[b3f9f38ac6]`](https://github.com/aspnet/AspNetCore/commit/b3f9f38ac6) Test LibuvConstants.IsConnectionReset
* [`[df2ad98743]`](https://github.com/aspnet/AspNetCore/commit/df2ad98743) Use logical 'or' instead of bitwise in IsConnectionReset method. (#2983)
* [`[82276ece2f]`](https://github.com/aspnet/AspNetCore/commit/82276ece2f) Use the Microsoft400 code-signing cert for the Razor VSIX assembly
* [`[153165f9ad]`](https://github.com/aspnet/AspNetCore/commit/153165f9ad) Handle OPTIONS requests without a handler in Razor Pages (#8528)
* [`[35d35f22a3]`](https://github.com/aspnet/AspNetCore/commit/35d35f22a3) Disallow any frames after a reset is received #2154
* [`[94101a9cde]`](https://github.com/aspnet/AspNetCore/commit/94101a9cde) Add PageRouteTransformerConvention (#8541)
* [`[2ccf79a912]`](https://github.com/aspnet/AspNetCore/commit/2ccf79a912) [Java] Pass Url to transport start so we can reuse the transport (#3051)
* [`[7854d65c11]`](https://github.com/aspnet/AspNetCore/commit/7854d65c11) Support page parameter in attribute route (#8530)
* [`[f02e13fa09]`](https://github.com/aspnet/AspNetCore/commit/f02e13fa09) Fix rebase
* [`[3f6c5e3435]`](https://github.com/aspnet/AspNetCore/commit/3f6c5e3435) [Java] Check for 200 status code on negotiate (#3050)
* [`[1ccb889f9c]`](https://github.com/aspnet/AspNetCore/commit/1ccb889f9c) Functional Interfaces in the Java Client(#3047)
* [`[2e41a7063b]`](https://github.com/aspnet/AspNetCore/commit/2e41a7063b) [Java] Add accessTokenProvider (#3046)
* [`[51491de90b]`](https://github.com/aspnet/AspNetCore/commit/51491de90b) Enable Node10 for macOS (#1448)
* [`[5bd2a41517]`](https://github.com/aspnet/AspNetCore/commit/5bd2a41517) Make transport logs for connection close more detailed and consistent (#2978)
* [`[9c37082a74]`](https://github.com/aspnet/AspNetCore/commit/9c37082a74) Add Linux, Node8, and Node10 to test matrix (#1445)
* [`[64b10d5582]`](https://github.com/aspnet/AspNetCore/commit/64b10d5582) HTTP --> HTTPS
* [`[f2691ee4b6]`](https://github.com/aspnet/AspNetCore/commit/f2691ee4b6) Add a copy of scripts from dotnet-deb-tool 2.0.0 to this repo (#1442)
* [`[3ae2814c27]`](https://github.com/aspnet/AspNetCore/commit/3ae2814c27) Make Java client more reusable (#3029)
* [`[70ddf15cbc]`](https://github.com/aspnet/AspNetCore/commit/70ddf15cbc) MethodMatches :shower:
* [`[17e029f15d]`](https://github.com/aspnet/AspNetCore/commit/17e029f15d) [Java] Clean up WebSockets Transport (#3044)
* [`[a48e75dfb4]`](https://github.com/aspnet/AspNetCore/commit/a48e75dfb4) Implicitly set content type for ObjectResults containing ProblemDetails (#8512)
* [`[713e224591]`](https://github.com/aspnet/AspNetCore/commit/713e224591) [Java] Add HttpClient support for testing (#3011)
* [`[014e7eb963]`](https://github.com/aspnet/AspNetCore/commit/014e7eb963) Add EFCore DbContext check
* [`[efe83ad531]`](https://github.com/aspnet/AspNetCore/commit/efe83ad531) Add Diagnostics.EFCore package
* [`[f425134ffe]`](https://github.com/aspnet/AspNetCore/commit/f425134ffe) Fix #2265 - Port Blazor testing improvements
* [`[3ddc86a428]`](https://github.com/aspnet/AspNetCore/commit/3ddc86a428) Fix mof file (#1457)
* [`[3227de8c0b]`](https://github.com/aspnet/AspNetCore/commit/3227de8c0b) Fix #629 - Add logging to DfaMatcther
* [`[a2f404f4d5]`](https://github.com/aspnet/AspNetCore/commit/a2f404f4d5) Perf improvements for EndpointSelector
* [`[ed15bad5fb]`](https://github.com/aspnet/AspNetCore/commit/ed15bad5fb) Make CandidateState (publicly) immutable
* [`[1f5eec1d55]`](https://github.com/aspnet/AspNetCore/commit/1f5eec1d55) Rename EndpointFeature -> EndpointSelectorContext
* [`[8b99832eaf]`](https://github.com/aspnet/AspNetCore/commit/8b99832eaf) Add ASCII optimized jump tables
* [`[d1f3b90a0e]`](https://github.com/aspnet/AspNetCore/commit/d1f3b90a0e) RouteValuesAddressMetadata ctors and XML docs (#818)
* [`[3044cc8d9e]`](https://github.com/aspnet/AspNetCore/commit/3044cc8d9e) Add .etl to .gitignore (PerfView)
* [`[6effb13bbd]`](https://github.com/aspnet/AspNetCore/commit/6effb13bbd) Update to .NET Core 2.1.5
* [`[72cd5eedcf]`](https://github.com/aspnet/AspNetCore/commit/72cd5eedcf) Prepare the 2.1.6 patch (#1434)
* [`[2a1ba9e4ff]`](https://github.com/aspnet/AspNetCore/commit/2a1ba9e4ff) Change websockets library (#3012)
* [`[67f2c3149e]`](https://github.com/aspnet/AspNetCore/commit/67f2c3149e) Use port 0 to avoid port collisions during tests
* [`[ccb6579cd7]`](https://github.com/aspnet/AspNetCore/commit/ccb6579cd7) Do not return ProblemDetails for < 4xx status codes Fixes #8504
* [`[7cf1cf2a54]`](https://github.com/aspnet/AspNetCore/commit/7cf1cf2a54) Update API check baselines to 2.1.0
* [`[fa961b003f]`](https://github.com/aspnet/AspNetCore/commit/fa961b003f) Added execution time duration (HealthReportEntry TotalDuration) (#493)
* [`[c887f730dd]`](https://github.com/aspnet/AspNetCore/commit/c887f730dd) Add DFA Graph viewer to sample
* [`[45a52ebff5]`](https://github.com/aspnet/AspNetCore/commit/45a52ebff5) Move Log call before starting application (#1453)
* [`[1f91b523f7]`](https://github.com/aspnet/AspNetCore/commit/1f91b523f7) Add error to negotiate (#2998)
* [`[8dcc011324]`](https://github.com/aspnet/AspNetCore/commit/8dcc011324) spelling, inline outs, redundant braces (#252)
* [`[e9c2acf4dc]`](https://github.com/aspnet/AspNetCore/commit/e9c2acf4dc) Add HTTP/2 response draining timeout (#2956)
* [`[fc39ea3bec]`](https://github.com/aspnet/AspNetCore/commit/fc39ea3bec) Make hosting bundle get prodcon runtime versions (#1435)
* [`[66ba370a0a]`](https://github.com/aspnet/AspNetCore/commit/66ba370a0a) Update .NET Core to 2.2.0-preview3-26927-02
* [`[c6633e6ec5]`](https://github.com/aspnet/AspNetCore/commit/c6633e6ec5) Increase retry count (#1449)
* [`[c9747bcf6b]`](https://github.com/aspnet/AspNetCore/commit/c9747bcf6b) Use Microsoft400 for code signing CAB, MSI, and installer bundles (#1433)
* [`[4baa07ccae]`](https://github.com/aspnet/AspNetCore/commit/4baa07ccae) Update code signing properties and configuration
* [`[e8d3321025]`](https://github.com/aspnet/AspNetCore/commit/e8d3321025) Add AdditionalRestoreSources parameter to Cli.FunctionalTests (#1429)
* [`[870efd5965]`](https://github.com/aspnet/AspNetCore/commit/870efd5965) More robust plugin load (#3022)
* [`[db1e4cf3d4]`](https://github.com/aspnet/AspNetCore/commit/db1e4cf3d4) Use Microsoft400 for installers signing, not 401 (#1426)
* [`[3c8c8ba333]`](https://github.com/aspnet/AspNetCore/commit/3c8c8ba333) [TS] Reject handshake if connection closes before response (#3000)
* [`[79663b480d]`](https://github.com/aspnet/AspNetCore/commit/79663b480d) Add more Spotless rules (#3005)
* [`[f56b682b36]`](https://github.com/aspnet/AspNetCore/commit/f56b682b36) Impose integer decode limit in HPACK
* [`[8311fd870b]`](https://github.com/aspnet/AspNetCore/commit/8311fd870b) Include the response type in ProducesResponseType for client errors (#8490)
* [`[e4ebae107c]`](https://github.com/aspnet/AspNetCore/commit/e4ebae107c) Fix the path to SignedPackageFile items and include the VSIX .dll in code signing
* [`[0157e38a23]`](https://github.com/aspnet/AspNetCore/commit/0157e38a23) Fix the path for SignedPackageFile and include the VSIX .dll in signing
* [`[13f2ebe2f6]`](https://github.com/aspnet/AspNetCore/commit/13f2ebe2f6) [Java] Throw useful error on incorrect argument length (#3010)
* [`[b07338b618]`](https://github.com/aspnet/AspNetCore/commit/b07338b618) Don't use depricated methods (#751)
* [`[02dac71f64]`](https://github.com/aspnet/AspNetCore/commit/02dac71f64) Move e2e-tests.yml into the right folder
* [`[90ed3bde5e]`](https://github.com/aspnet/AspNetCore/commit/90ed3bde5e) Add more logging for E2E tests
* [`[831937c86c]`](https://github.com/aspnet/AspNetCore/commit/831937c86c) Add LinkGenerator extensions for MVC
* [`[c6347f035f]`](https://github.com/aspnet/AspNetCore/commit/c6347f035f) Conditionally include RootNamespace
* [`[0745266c17]`](https://github.com/aspnet/AspNetCore/commit/0745266c17) Razor->WebApp
* [`[1eb5da31e5]`](https://github.com/aspnet/AspNetCore/commit/1eb5da31e5) Improve error messages and add static html pages for failure to start site. (#1421)
* [`[3832019027]`](https://github.com/aspnet/AspNetCore/commit/3832019027) Update Facebook to v3.1 endpoints #92
* [`[49c2317c14]`](https://github.com/aspnet/AspNetCore/commit/49c2317c14) Fix #810
* [`[7c16c92317]`](https://github.com/aspnet/AspNetCore/commit/7c16c92317) Fix a bug in GetUriByRouteValues
* [`[01b35bc391]`](https://github.com/aspnet/AspNetCore/commit/01b35bc391) Make HTTP/2 connection and stream windows configurable #2814
* [`[50cef4822a]`](https://github.com/aspnet/AspNetCore/commit/50cef4822a) Invoke FlushAsync before disposing the HttpResponseWriter in JsonResultExecutor
* [`[ceaa3c86fc]`](https://github.com/aspnet/AspNetCore/commit/ceaa3c86fc) Add configurability for max header field size in HPACK
* [`[204ff0a785]`](https://github.com/aspnet/AspNetCore/commit/204ff0a785) Set cache headers in health check middleware
* [`[f17142b2ec]`](https://github.com/aspnet/AspNetCore/commit/f17142b2ec) Delay resolution until after application services are built (#1553)
* [`[18145880fa]`](https://github.com/aspnet/AspNetCore/commit/18145880fa) Improved logging for health checks
* [`[b642db5a47]`](https://github.com/aspnet/AspNetCore/commit/b642db5a47) Revised LinkGenerator
* [`[5c8dfef15e]`](https://github.com/aspnet/AspNetCore/commit/5c8dfef15e) Change `CollectionModelBinder` and `ComplexTypeModelBinder` to enforce `[BindRequired]` - #8180 - add an error when binding fails for top-level model   - same case as when MVC creates "default" / empty model i.e. `ParameterBinder` can't detect this - update `CollectionModelBinder` subclasses and the various providers as well - controlled by existing `MvcOptions.AllowValidatingTopLevelNodes` option
* [`[f808bdc331]`](https://github.com/aspnet/AspNetCore/commit/f808bdc331) Disconnect the disconnect handler when request processing ends (#1413)
* [`[ef3d3b1cdd]`](https://github.com/aspnet/AspNetCore/commit/ef3d3b1cdd) [TS] Change websocket library in Node (#2989)
* [`[31bb166372]`](https://github.com/aspnet/AspNetCore/commit/31bb166372) Reference Microsoft.NET.Sdk.Razor in projects with Razor files
* [`[14c5fcdb50]`](https://github.com/aspnet/AspNetCore/commit/14c5fcdb50) Reference Microsoft.NET.Sdk.Razor in projects with Razor files
* [`[312221df2f]`](https://github.com/aspnet/AspNetCore/commit/312221df2f) Reference Microsoft.NET.Sdk.Razor in projects with Razor files
* [`[a140f38810]`](https://github.com/aspnet/AspNetCore/commit/a140f38810) Enhancments
* [`[4dfd93c1d7]`](https://github.com/aspnet/AspNetCore/commit/4dfd93c1d7) [TS] Wait for handshake response (#2983)
* [`[587ead92e4]`](https://github.com/aspnet/AspNetCore/commit/587ead92e4) Reference Microsoft.NET.Sdk.Razor in projects with Razor files
* [`[f0a34a4ca4]`](https://github.com/aspnet/AspNetCore/commit/f0a34a4ca4) Clone Windows Identity in LongPolling connections (#2985)
* [`[61386d5f67]`](https://github.com/aspnet/AspNetCore/commit/61386d5f67) Reference Microsoft.NET.Sdk.Razor in projects with Razor files
* [`[bf1aa1d818]`](https://github.com/aspnet/AspNetCore/commit/bf1aa1d818) Make tests classes and HubMessageType enum package private in the Java client(#2992)
* [`[c559498632]`](https://github.com/aspnet/AspNetCore/commit/c559498632) Make parameter transformer test verifiable (#804)
* [`[d463b5e613]`](https://github.com/aspnet/AspNetCore/commit/d463b5e613) Fix ReaderThrowsResetExceptionOnInvalidBody (#1420)
* [`[8fb6c2a50a]`](https://github.com/aspnet/AspNetCore/commit/8fb6c2a50a) Allow cancellation to propagate
* [`[5c4c746797]`](https://github.com/aspnet/AspNetCore/commit/5c4c746797) Reaction PR from routing rename
* [`[a657c3bdf2]`](https://github.com/aspnet/AspNetCore/commit/a657c3bdf2) Updates to Parameter Transformer
* [`[d28468ca8f]`](https://github.com/aspnet/AspNetCore/commit/d28468ca8f) Override IIS headers in inproc (#1409)
* [`[b08b237927]`](https://github.com/aspnet/AspNetCore/commit/b08b237927) StopServer before asserting TestSink (#1416)
* [`[375d037946]`](https://github.com/aspnet/AspNetCore/commit/375d037946) Add applicationInitialization tests (#1402)
* [`[6ba5e87b45]`](https://github.com/aspnet/AspNetCore/commit/6ba5e87b45) Allow CancellationToken in streaming hub methods (#2818)
* [`[4259b65c16]`](https://github.com/aspnet/AspNetCore/commit/4259b65c16) Use options for registering health checks (#479)
* [`[4b378692a4]`](https://github.com/aspnet/AspNetCore/commit/4b378692a4) [Java] Add Invoke support (#2961)
* [`[9c424b7b02]`](https://github.com/aspnet/AspNetCore/commit/9c424b7b02) Use content-type specified by ProducesAttribute if no formatter supports it
* [`[8be051ce34]`](https://github.com/aspnet/AspNetCore/commit/8be051ce34) Idempotentize AddSignalR (#2972)
* [`[f7da3503d6]`](https://github.com/aspnet/AspNetCore/commit/f7da3503d6) Allow Implicit 200 status codes to match Ok result
* [`[3f7ee338d4]`](https://github.com/aspnet/AspNetCore/commit/3f7ee338d4)  Change SelfHostDeployer to use dynamic ports by default (#1383)
* [`[b41f1f0cae]`](https://github.com/aspnet/AspNetCore/commit/b41f1f0cae) Make cert fixture lazy (#1412)
* [`[f27df1d61e]`](https://github.com/aspnet/AspNetCore/commit/f27df1d61e) Java Async APIs (#2971)
* [`[f70df60435]`](https://github.com/aspnet/AspNetCore/commit/f70df60435) Move RazorGenerate and RazorTagHelper tasks in to the Sdk
* [`[4e57b0e1f1]`](https://github.com/aspnet/AspNetCore/commit/4e57b0e1f1) Add functional style request aborted test (#1406)
* [`[7fb4940258]`](https://github.com/aspnet/AspNetCore/commit/7fb4940258) :arrow_up: Update NetTopologySuite.Core to 1.15.1
* [`[7144add4ad]`](https://github.com/aspnet/AspNetCore/commit/7144add4ad) Check for ITagHelper in tag helper feature provider (#2602)
* [`[b6c311c14d]`](https://github.com/aspnet/AspNetCore/commit/b6c311c14d) Add client disconnect and connection abort support (#1388)
* [`[f63412f1bb]`](https://github.com/aspnet/AspNetCore/commit/f63412f1bb) Update package verions
* [`[ece5ad36e2]`](https://github.com/aspnet/AspNetCore/commit/ece5ad36e2) Implement ITlsConnectionFeature (#1390)
* [`[15ba5065a9]`](https://github.com/aspnet/AspNetCore/commit/15ba5065a9) Skip connection reset tests on macOS in 2.1 (#2942)
* [`[fc86cc3ca1]`](https://github.com/aspnet/AspNetCore/commit/fc86cc3ca1) Allow Invoke \ InvokeAsync methods for a ViewComponent to be defined in base types Fixes https://github.com/aspnet/Mvc/issues/8397
* [`[c73b13f544]`](https://github.com/aspnet/AspNetCore/commit/c73b13f544) Cherry-pick @pranavkm's functional test for #7562 - 30a5eda508 / origin/prkrishn/form-file-value-provider
* [`[c13e2498a8]`](https://github.com/aspnet/AspNetCore/commit/c13e2498a8) Create model in `ComplexTypeModelBinder` if ANY property has a greedy binding source - #7562 part 1
* [`[70ea1268a7]`](https://github.com/aspnet/AspNetCore/commit/70ea1268a7) Use JUnit 5 for tests (#2968)
* [`[bc148a0724]`](https://github.com/aspnet/AspNetCore/commit/bc148a0724) Incorrect nameof usage (#2967)
* [`[f3b6430aab]`](https://github.com/aspnet/AspNetCore/commit/f3b6430aab) Initialize Heartbeat in KestrelServer.StartAsync (#2939)
* [`[a7e412ec80]`](https://github.com/aspnet/AspNetCore/commit/a7e412ec80) Fix category logger for HttpsConnectionAdapter and LoggingConnectionAdapter. #2929 (#2935)
* [`[b8423b8530]`](https://github.com/aspnet/AspNetCore/commit/b8423b8530) Change how HTTP/2 frames are parsed and generated #2858
* [`[69ff195f66]`](https://github.com/aspnet/AspNetCore/commit/69ff195f66) Enable hpack/4.2 - Maximum Table Size test
* [`[025aca52df]`](https://github.com/aspnet/AspNetCore/commit/025aca52df) Port long Huffman encoding bug fix
* [`[5e896ca506]`](https://github.com/aspnet/AspNetCore/commit/5e896ca506) Implement IHttpBufferingFeature (#1391)
* [`[060698a52f]`](https://github.com/aspnet/AspNetCore/commit/060698a52f) Update to use non-capturing timer
* [`[8791f9ad0d]`](https://github.com/aspnet/AspNetCore/commit/8791f9ad0d) Change test parameter transformer to slugify values (#8453)
* [`[3952845c57]`](https://github.com/aspnet/AspNetCore/commit/3952845c57) Unpin package versions for 2.1.5
* [`[4b83f7b510]`](https://github.com/aspnet/AspNetCore/commit/4b83f7b510) Make FileVersionProvider repleacable
* [`[233140c33a]`](https://github.com/aspnet/AspNetCore/commit/233140c33a) Allow IFormFile parameters annotated with [FromForm] to be correctly … (#8452)
* [`[412944e1f5]`](https://github.com/aspnet/AspNetCore/commit/412944e1f5) Transform parameters before lower casing in link generation (#793)
* [`[48b3f18642]`](https://github.com/aspnet/AspNetCore/commit/48b3f18642) Improve the handshake request parsing errors (#2953)
* [`[426a48a65a]`](https://github.com/aspnet/AspNetCore/commit/426a48a65a) Performance improvments to LinkGenerator and TemplateBinder
* [`[5e083c371b]`](https://github.com/aspnet/AspNetCore/commit/5e083c371b) Don't capture asynclocals onto Timer
* [`[1e8e541f65]`](https://github.com/aspnet/AspNetCore/commit/1e8e541f65) Clean up timeout reporting
* [`[35597db277]`](https://github.com/aspnet/AspNetCore/commit/35597db277) Fix #8451
* [`[9a68f48a5c]`](https://github.com/aspnet/AspNetCore/commit/9a68f48a5c) Minor improvments to RVD perf
* [`[b8f7f967ce]`](https://github.com/aspnet/AspNetCore/commit/b8f7f967ce) Normalize FSharp templates and don't check in site.min.js
* [`[d0ddb068be]`](https://github.com/aspnet/AspNetCore/commit/d0ddb068be) Return FormCollection.Empty when Content-Length is 0 (#1038)
* [`[704a77b8a4]`](https://github.com/aspnet/AspNetCore/commit/704a77b8a4) Fix template run script
* [`[c93c974dbc]`](https://github.com/aspnet/AspNetCore/commit/c93c974dbc) Update certs on Jenkins (#1397)
* [`[55e5e56422]`](https://github.com/aspnet/AspNetCore/commit/55e5e56422) Dispatch Http/2 write callbacks #2878
* [`[1a0f988064]`](https://github.com/aspnet/AspNetCore/commit/1a0f988064) Skip AppOfflineDroppedWhileSiteFailedToStartInRequestHandler_SiteStops_InProcess (#1396)
* [`[55597adf61]`](https://github.com/aspnet/AspNetCore/commit/55597adf61) [Java] De-Serializing Custom Types (#2940)
* [`[cb88e906b2]`](https://github.com/aspnet/AspNetCore/commit/cb88e906b2) Allow ProducesAttribute to apply along with conventions
* [`[a73d073eea]`](https://github.com/aspnet/AspNetCore/commit/a73d073eea) Allow ApiControlelrAttribute to be applied to assemblies
* [`[dfae9c208a]`](https://github.com/aspnet/AspNetCore/commit/dfae9c208a) Add IParameterTransformer support (#8329)
* [`[cee960f3c5]`](https://github.com/aspnet/AspNetCore/commit/cee960f3c5) Add IParameterTransformer (#750)
* [`[105f8b47a1]`](https://github.com/aspnet/AspNetCore/commit/105f8b47a1) Fix endpoint support for area/controller/action in attribute route (#8447)
* [`[9db1c2af1a]`](https://github.com/aspnet/AspNetCore/commit/9db1c2af1a) Making all the things Package Private in the Java Client (#2945)
* [`[8dffc68cea]`](https://github.com/aspnet/AspNetCore/commit/8dffc68cea) Cancel previous request on close (#2923) (#2942)
* [`[015a8c1461]`](https://github.com/aspnet/AspNetCore/commit/015a8c1461) Collect "redis MONITOR" logs (#2946)
* [`[a51eec7a1d]`](https://github.com/aspnet/AspNetCore/commit/a51eec7a1d) Add NodeJS in-box support (#2910)
* [`[1a8616349f]`](https://github.com/aspnet/AspNetCore/commit/1a8616349f) Add non-capturing timer sources package
* [`[5ba327faa1]`](https://github.com/aspnet/AspNetCore/commit/5ba327faa1) Relax connection stop checks in tests to reduce flakiness
* [`[e5cc4564cb]`](https://github.com/aspnet/AspNetCore/commit/e5cc4564cb) add docs for constructor
* [`[5f172efa9d]`](https://github.com/aspnet/AspNetCore/commit/5f172efa9d) Add support Endpoint Name endpoint finding
* [`[57cc8aea96]`](https://github.com/aspnet/AspNetCore/commit/57cc8aea96) Various improvments to route values link APIs
* [`[f38f60f8ce]`](https://github.com/aspnet/AspNetCore/commit/f38f60f8ce) Map ListenOptions.Protocols from IConfiguration #2903
* [`[c683844817]`](https://github.com/aspnet/AspNetCore/commit/c683844817) Fix #553 - Add logging for new LinkGenerator
* [`[6e27a04bf3]`](https://github.com/aspnet/AspNetCore/commit/6e27a04bf3) No HttpContext to route constraints in MvcEndpointDataSource (#8436)
* [`[399ac267ca]`](https://github.com/aspnet/AspNetCore/commit/399ac267ca) Cancel previous request on close (#2923)
* [`[188bbc6ce1]`](https://github.com/aspnet/AspNetCore/commit/188bbc6ce1) add component detection task (#1338)
* [`[f93f67a53a]`](https://github.com/aspnet/AspNetCore/commit/f93f67a53a) Better logging to help debug test failure (#2576)
* [`[14b1432481]`](https://github.com/aspnet/AspNetCore/commit/14b1432481) Fix min.css files
* [`[adc5706bcb]`](https://github.com/aspnet/AspNetCore/commit/adc5706bcb) Add more redis logs (#2936)
* [`[f573b8840a]`](https://github.com/aspnet/AspNetCore/commit/f573b8840a) Fix aspnet/Routing#782
* [`[f47aa1283e]`](https://github.com/aspnet/AspNetCore/commit/f47aa1283e) Make usage of TestConnection.Receive vs ReceiveEnd consistent (#2896)
* [`[e4ab90ec1c]`](https://github.com/aspnet/AspNetCore/commit/e4ab90ec1c) Use built in DownloadFile task
* [`[4bcfbe4d40]`](https://github.com/aspnet/AspNetCore/commit/4bcfbe4d40) [REPL] Help improvements for repl (#478)
* [`[9e89f798c6]`](https://github.com/aspnet/AspNetCore/commit/9e89f798c6) Add logging to functional tests
* [`[db99baac35]`](https://github.com/aspnet/AspNetCore/commit/db99baac35) Don't capture AsyncLocals onto Timers (#2904)
* [`[39e6c6ff2f]`](https://github.com/aspnet/AspNetCore/commit/39e6c6ff2f) Spotless for the Java Client (#2924)
* [`[bb26b62a1f]`](https://github.com/aspnet/AspNetCore/commit/bb26b62a1f) Ensure the identical time value is used to assert date in tests
* [`[eb6b6e58c2]`](https://github.com/aspnet/AspNetCore/commit/eb6b6e58c2) Reenable tests that were throwing in Program.Main (#1379)
* [`[fd80509fef]`](https://github.com/aspnet/AspNetCore/commit/fd80509fef) LocalizedHtmlString.Value doesn't include arguments (#8376)
* [`[74ba9898f4]`](https://github.com/aspnet/AspNetCore/commit/74ba9898f4) [Fixes #8250] Improve the error message when TEntryPoint is not in an entry point assembly
* [`[489a179c41]`](https://github.com/aspnet/AspNetCore/commit/489a179c41) Add a test for Routing#435
* [`[06568d990b]`](https://github.com/aspnet/AspNetCore/commit/06568d990b) Set the signing cert for .msi files to the 'Microsoft' certificate
* [`[869582e1fc]`](https://github.com/aspnet/AspNetCore/commit/869582e1fc) Skip Auth test due to HttpClient regression #474
* [`[863b1c2c97]`](https://github.com/aspnet/AspNetCore/commit/863b1c2c97) Action endpoint metadata contains attributes from action and controller (#8395)
* [`[f18c1d7159]`](https://github.com/aspnet/AspNetCore/commit/f18c1d7159) Should skip negotiate in tests that use fake urls (#2921)
* [`[d3d7c55198]`](https://github.com/aspnet/AspNetCore/commit/d3d7c55198) fix some spelling (#2888)
* [`[c2f15f4199]`](https://github.com/aspnet/AspNetCore/commit/c2f15f4199) Don't use depricated constructor
* [`[43cbb9edda]`](https://github.com/aspnet/AspNetCore/commit/43cbb9edda) Unify exceptions for unsupported message types (#2908)
* [`[b0155446ab]`](https://github.com/aspnet/AspNetCore/commit/b0155446ab) Use HubException for error in HandShakeResponse (#2914)
* [`[1fca011674]`](https://github.com/aspnet/AspNetCore/commit/1fca011674) Fix output location for lib files (#1373)
* [`[07cc9e66c6]`](https://github.com/aspnet/AspNetCore/commit/07cc9e66c6) Add a feature to disable file watching in Razor pages (#8369)
* [`[b1f0f173aa]`](https://github.com/aspnet/AspNetCore/commit/b1f0f173aa) Use ConnectionResetException with 'The client disconnected' message (#1364)
* [`[b8e56691cb]`](https://github.com/aspnet/AspNetCore/commit/b8e56691cb) Implement MaxRequestLineSize for HTTP/2 #2813
* [`[384a518bda]`](https://github.com/aspnet/AspNetCore/commit/384a518bda) Implement MaxRequestHeadersTotalSize for HTTP/2 #2812
* [`[edc1935475]`](https://github.com/aspnet/AspNetCore/commit/edc1935475) Flow the cancellation tokens to ReadAsync and WriteAsync (#2865)
* [`[647ea8a945]`](https://github.com/aspnet/AspNetCore/commit/647ea8a945) Add VSCode debug configuration for Java (#2916)
* [`[cfb0d732b0]`](https://github.com/aspnet/AspNetCore/commit/cfb0d732b0) fix some spelling (#1035)
* [`[b156dee4f1]`](https://github.com/aspnet/AspNetCore/commit/b156dee4f1) Fix some spelling (#8378)
* [`[c0f3a46ffe]`](https://github.com/aspnet/AspNetCore/commit/c0f3a46ffe) Don't call GetValidity method twice.
* [`[e174d277bd]`](https://github.com/aspnet/AspNetCore/commit/e174d277bd) Inline
* [`[337bc462de]`](https://github.com/aspnet/AspNetCore/commit/337bc462de) Fast-path async in PagedBufferedTextWriter
* [`[e3b704095b]`](https://github.com/aspnet/AspNetCore/commit/e3b704095b) Revisions to LinkGenerator (#770)
* [`[dcfb63a768]`](https://github.com/aspnet/AspNetCore/commit/dcfb63a768) Avoid RoutePattern allocating empty dictionaries (#772)
* [`[dbebdbecd6]`](https://github.com/aspnet/AspNetCore/commit/dbebdbecd6) Add flag for including label with DfaNodes (#769)
* [`[abc378d3dc]`](https://github.com/aspnet/AspNetCore/commit/abc378d3dc) Avoid resizing large struct arrays (#767)
* [`[0f5d471dfd]`](https://github.com/aspnet/AspNetCore/commit/0f5d471dfd) Create collections on DfaNode as needed (#779)
* [`[3a281b8f58]`](https://github.com/aspnet/AspNetCore/commit/3a281b8f58) Allow TagHelpers to occur after unclosed C# blocks without assert failures.
* [`[71b7bb50b2]`](https://github.com/aspnet/AspNetCore/commit/71b7bb50b2) Ensure external processes are killed when test process exits (#1371)
* [`[88d8571474]`](https://github.com/aspnet/AspNetCore/commit/88d8571474) Add Trace level for request events, allow logging to eventlog (#1337)
* [`[b48b282ad8]`](https://github.com/aspnet/AspNetCore/commit/b48b282ad8) Add RazorRendering benchmarkapp (#8366)
* [`[dc6088bf21]`](https://github.com/aspnet/AspNetCore/commit/dc6088bf21) Negotiate + SignalR Service Support for the Java client (#2882)
* [`[5956300df7]`](https://github.com/aspnet/AspNetCore/commit/5956300df7) Retry TestServer port selection (#1367)
* [`[18a718d1f0]`](https://github.com/aspnet/AspNetCore/commit/18a718d1f0) Catch all exception in native callbacks (#1369)
* [`[613fbcc349]`](https://github.com/aspnet/AspNetCore/commit/613fbcc349) Enable code analysis on shim project (#1361)
* [`[2f4172e7e7]`](https://github.com/aspnet/AspNetCore/commit/2f4172e7e7) Reduce probability of MultipleAppTests failure (#1365)
* [`[e9b0415bb9]`](https://github.com/aspnet/AspNetCore/commit/e9b0415bb9) Make System.IO.Pipelines a direct dependency of Microsoft.AspNetCore.App
* [`[cb642ff95f]`](https://github.com/aspnet/AspNetCore/commit/cb642ff95f) Update to .NET Core 2.2.0-preview2-26905-02 (#1377)
* [`[b5ff991eb9]`](https://github.com/aspnet/AspNetCore/commit/b5ff991eb9) Fix incorrect version in version.props file (#1363)
* [`[753c3da852]`](https://github.com/aspnet/AspNetCore/commit/753c3da852) Avoid ODE in tests with Server logging (#2742) (#2907)
* [`[c88e5147da]`](https://github.com/aspnet/AspNetCore/commit/c88e5147da) Use dynamically chosen ports to avoid address binding collisions
* [`[68672bc965]`](https://github.com/aspnet/AspNetCore/commit/68672bc965) Update to .NET Core 2.1.5-servicing-26902-03 (#1371)
* [`[a22b715bf4]`](https://github.com/aspnet/AspNetCore/commit/a22b715bf4) Update published files for 2.2-preview2 (#1370)
* [`[b2cf5028e0]`](https://github.com/aspnet/AspNetCore/commit/b2cf5028e0) Run E2E tests in parallel and on macOS (#1369)
* [`[60fc0158c1]`](https://github.com/aspnet/AspNetCore/commit/60fc0158c1) Flow the ProdCon restore feed in to E2E tests
* [`[a57ed95fd3]`](https://github.com/aspnet/AspNetCore/commit/a57ed95fd3) Fix errors connecting to github from powershell and TLS1.2 in test scripts
* [`[0459b6d0d4]`](https://github.com/aspnet/AspNetCore/commit/0459b6d0d4) Fix dotnet.exe abort exception and startup/shutdown timeouts (#1352)
* [`[9f37a92dc9]`](https://github.com/aspnet/AspNetCore/commit/9f37a92dc9) Add Microsoft.AspNetCore.DataProtection.EntityFrameworkCore
* [`[7520ffa0ef]`](https://github.com/aspnet/AspNetCore/commit/7520ffa0ef) Fix up service scoping in the EF Core xml repository and update package version to 2.2
* [`[153020ef8a]`](https://github.com/aspnet/AspNetCore/commit/153020ef8a) Allow UTF8 encoded header values
* [`[b7b1ea207d]`](https://github.com/aspnet/AspNetCore/commit/b7b1ea207d) Start shipping templates to NuGet
* [`[525fbf495b]`](https://github.com/aspnet/AspNetCore/commit/525fbf495b) Fix #468 - all UseHealthChecks without a path
* [`[3e7410333a]`](https://github.com/aspnet/AspNetCore/commit/3e7410333a) Update to .NET Core 2.1.5-servicing-26830-03 (#1364)
* [`[d8b7dbd1f3]`](https://github.com/aspnet/AspNetCore/commit/d8b7dbd1f3) Avoid null refs when IStatusCodeActionResult cannot be discovered
* [`[945e798ca7]`](https://github.com/aspnet/AspNetCore/commit/945e798ca7) [Design] Set the endpoint feature only on success
* [`[1128bd572c]`](https://github.com/aspnet/AspNetCore/commit/1128bd572c) Add a functional test for middleware after routing
* [`[f42f4c56e6]`](https://github.com/aspnet/AspNetCore/commit/f42f4c56e6) Initialize HttpConnectionManager before registering callbacks (#2878)
* [`[11f28139d4]`](https://github.com/aspnet/AspNetCore/commit/11f28139d4) Add Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite
* [`[3dfa26f7e3]`](https://github.com/aspnet/AspNetCore/commit/3dfa26f7e3) Resolve virtual ViewContext max once per method
* [`[729a98adfc]`](https://github.com/aspnet/AspNetCore/commit/729a98adfc) Call AllocConsole (#1351)
* [`[922298bc90]`](https://github.com/aspnet/AspNetCore/commit/922298bc90) Add rc file as an include for ANCMV1 (#1284) (#1344)
* [`[f90a47c5af]`](https://github.com/aspnet/AspNetCore/commit/f90a47c5af) Introduce ProducesErrorResponseTypeAttribute
* [`[3e4a3d0b90]`](https://github.com/aspnet/AspNetCore/commit/3e4a3d0b90) Allow health checks to use any DI lifetime (#466)
* [`[80b30b21ee]`](https://github.com/aspnet/AspNetCore/commit/80b30b21ee) Fix platform benchmarks TFM (#2868)
* [`[a741af1e77]`](https://github.com/aspnet/AspNetCore/commit/a741af1e77) Add header to sample (#1353)
* [`[6e33b889c0]`](https://github.com/aspnet/AspNetCore/commit/6e33b889c0) Unpin System.Data.Sqlient (#1356)
* [`[4737ec1909]`](https://github.com/aspnet/AspNetCore/commit/4737ec1909) Update default triggers to only include master and release branches
* [`[927e7c8bfc]`](https://github.com/aspnet/AspNetCore/commit/927e7c8bfc) Support route data tokens with Endpoint Routing (#8360)
* [`[f6fc60a0ed]`](https://github.com/aspnet/AspNetCore/commit/f6fc60a0ed) Add script to invoke E2E tests on CI using ProdCon results (#1354)
* [`[3511c8cef0]`](https://github.com/aspnet/AspNetCore/commit/3511c8cef0) Add vectorized il-emit trie jump table
* [`[5cdc172b17]`](https://github.com/aspnet/AspNetCore/commit/5cdc172b17) Fix obsolete constraint resolver usage (#8361)
* [`[ffdbea9dc1]`](https://github.com/aspnet/AspNetCore/commit/ffdbea9dc1) Add analyzer support for status code methods and constructors
* [`[2a426dfea5]`](https://github.com/aspnet/AspNetCore/commit/2a426dfea5) Make ViewBuffer methods more inlinable (#8339)
* [`[777af897a8]`](https://github.com/aspnet/AspNetCore/commit/777af897a8) Select highest version of Microsoft.NETCore.App which matches major and minor version of SDK (#19)
* [`[8e3d1f9e33]`](https://github.com/aspnet/AspNetCore/commit/8e3d1f9e33) Ignore globally-installed .NET Core components (#18)
* [`[941d94c907]`](https://github.com/aspnet/AspNetCore/commit/941d94c907)  Rename from AspNetCoreSdkTests to Cli.FunctionalTests (#17)
* [`[afccb085a2]`](https://github.com/aspnet/AspNetCore/commit/afccb085a2) Fix links and formating
* [`[22a40b6f2b]`](https://github.com/aspnet/AspNetCore/commit/22a40b6f2b) Use Pages as List
* [`[7bd9f9cc3e]`](https://github.com/aspnet/AspNetCore/commit/7bd9f9cc3e) Reduce IList interface calls
* [`[ddff4f06e5]`](https://github.com/aspnet/AspNetCore/commit/ddff4f06e5) Rename to Cli.FunctionalTests
* [`[26710080fe]`](https://github.com/aspnet/AspNetCore/commit/26710080fe) Set AspNetCoreHostingModel in templates (#716)
* [`[82a01a414d]`](https://github.com/aspnet/AspNetCore/commit/82a01a414d) Set trace id in ProblemDetalsClientErrorFactory
* [`[852ad8df87]`](https://github.com/aspnet/AspNetCore/commit/852ad8df87) Allow content to be written after caught exception from child TagHelper.
* [`[8f7d995508]`](https://github.com/aspnet/AspNetCore/commit/8f7d995508) Added Entity Framework Core backed IXmlRepository with tests and sample (#303)
* [`[883471fee9]`](https://github.com/aspnet/AspNetCore/commit/883471fee9) Update options module (#1348)
* [`[f91ba38907]`](https://github.com/aspnet/AspNetCore/commit/f91ba38907) fix chrome headless lag on Win7 (#2890)
* [`[73e6742ba2]`](https://github.com/aspnet/AspNetCore/commit/73e6742ba2) Use gradle to detect java (#2888)
* [`[208f6ff568]`](https://github.com/aspnet/AspNetCore/commit/208f6ff568) Fix #574: Set NoDefaultLaunchSettingsFile
* [`[234b003b31]`](https://github.com/aspnet/AspNetCore/commit/234b003b31) Set longRunningTestSeconds for Functional tests
* [`[820c0405e3]`](https://github.com/aspnet/AspNetCore/commit/820c0405e3) Add new options package (#1345)
* [`[99c4f2f36a]`](https://github.com/aspnet/AspNetCore/commit/99c4f2f36a) Support policy arguments and resolving services by constructors  (#753)
* [`[d09c3c9e28]`](https://github.com/aspnet/AspNetCore/commit/d09c3c9e28) Polish ProblemDetails
* [`[65ddfd1f02]`](https://github.com/aspnet/AspNetCore/commit/65ddfd1f02) Add dotnet-httprepl to artifacts.props
* [`[c62c7f6a61]`](https://github.com/aspnet/AspNetCore/commit/c62c7f6a61) Check event logs until process start time (#1338)
* [`[667ad4daff]`](https://github.com/aspnet/AspNetCore/commit/667ad4daff) Use ClientErrorData to configure ClientErrorResultFilter
* [`[96b77c8663]`](https://github.com/aspnet/AspNetCore/commit/96b77c8663) Fix aspnet/Routing#721
* [`[68e6b7e1b8]`](https://github.com/aspnet/AspNetCore/commit/68e6b7e1b8) Update ANCM version to 12.1 (#1286)
* [`[5ea537fbc4]`](https://github.com/aspnet/AspNetCore/commit/5ea537fbc4) Don't advance examined in Http1MessageBody.PumpAsync for canceled reads (#2847)
* [`[89f4850883]`](https://github.com/aspnet/AspNetCore/commit/89f4850883) Avoid throwing the same exception instances in parallel (#2859)
* [`[04c606d55f]`](https://github.com/aspnet/AspNetCore/commit/04c606d55f) LongPolling: Setting connection to inactive while there is still an active poll (#2769)
* [`[fd53f84f63]`](https://github.com/aspnet/AspNetCore/commit/fd53f84f63) TypeScript improvements and tslib dep (#2808)
* [`[9c28f95b12]`](https://github.com/aspnet/AspNetCore/commit/9c28f95b12) Add Microsoft.AspNetCore.Razor.Design to templates (#674)
* [`[037482829d]`](https://github.com/aspnet/AspNetCore/commit/037482829d) Add commit hash to V1 description (#1281)
* [`[5f20f2a2dd]`](https://github.com/aspnet/AspNetCore/commit/5f20f2a2dd) Update schema for ANCMv1 (#1276)
* [`[338af6f07d]`](https://github.com/aspnet/AspNetCore/commit/338af6f07d) Reduce probability of startup port collisions (#1273)
* [`[6dc55a0462]`](https://github.com/aspnet/AspNetCore/commit/6dc55a0462) Don't preserve the ExecutionContext when dispatching callbacks (#2861)
* [`[42fa04aa87]`](https://github.com/aspnet/AspNetCore/commit/42fa04aa87) Add the latest version of Microsoft.AspNetCore.Razor.Design to the offline package cache (#1316)
* [`[6b1d22c581]`](https://github.com/aspnet/AspNetCore/commit/6b1d22c581) Add package descriptions for Microsoft.AspNetCore.{App, All} (#1320)
* [`[b206d59612]`](https://github.com/aspnet/AspNetCore/commit/b206d59612) Prepare 2.1.5 patch
* [`[0fcf2448c3]`](https://github.com/aspnet/AspNetCore/commit/0fcf2448c3) Fix aspnet/Routing#722
* [`[2605b943f3]`](https://github.com/aspnet/AspNetCore/commit/2605b943f3) Use only one log file for stdout (#1334)
* [`[8ed9d0aac2]`](https://github.com/aspnet/AspNetCore/commit/8ed9d0aac2) Use Endpoint instead of RouteEndpoint where possible (#8331)
* [`[a634f6b116]`](https://github.com/aspnet/AspNetCore/commit/a634f6b116) add another test
* [`[cb0627b28a]`](https://github.com/aspnet/AspNetCore/commit/cb0627b28a) Addressing a skipped test
* [`[04b365a22f]`](https://github.com/aspnet/AspNetCore/commit/04b365a22f) Don't hold onto the HttpContext in the HostingLogScope (#1531)
* [`[9f49539177]`](https://github.com/aspnet/AspNetCore/commit/9f49539177) Re enable --no-restore (#1336)
* [`[f70ba53253]`](https://github.com/aspnet/AspNetCore/commit/f70ba53253) Fix race when SystemClock is accessed before first heartbeat (#2851)
* [`[a3b20c57ea]`](https://github.com/aspnet/AspNetCore/commit/a3b20c57ea) Add appsettings.json to EmptyWeb
* [`[6ddbfb64b9]`](https://github.com/aspnet/AspNetCore/commit/6ddbfb64b9) Improve configuration file handling logic (#1317)
* [`[2cbf5bd84e]`](https://github.com/aspnet/AspNetCore/commit/2cbf5bd84e) Query event logs when verifying event log messages. (#1323)
* [`[0500d5f7ef]`](https://github.com/aspnet/AspNetCore/commit/0500d5f7ef) Another attempt to fix the list of agent demands to workaround issues in VSTS
* [`[a7301120b1]`](https://github.com/aspnet/AspNetCore/commit/a7301120b1) Unwrap filter factories in TypeFilterAttribute & ServiceFilterAttribute
* [`[4389297962]`](https://github.com/aspnet/AspNetCore/commit/4389297962) Try using a different syntax for queue demands
* [`[fe6d5fff03]`](https://github.com/aspnet/AspNetCore/commit/fe6d5fff03) Fix demand condition to use agent.name
* [`[63355f13ba]`](https://github.com/aspnet/AspNetCore/commit/63355f13ba) Attempt to fix queue demands
* [`[64127e6c76]`](https://github.com/aspnet/AspNetCore/commit/64127e6c76) Implement MaxFrameSize and HeaderTableSize for HTTP/2
* [`[fc3c2eef5e]`](https://github.com/aspnet/AspNetCore/commit/fc3c2eef5e) Handle SocketError.ProtocolType as a connection reset on macOS (#2845)
* [`[e5a1101239]`](https://github.com/aspnet/AspNetCore/commit/e5a1101239) Improve exception handling in SocketConnection (#2844)
* [`[dfb579d45c]`](https://github.com/aspnet/AspNetCore/commit/dfb579d45c) [Fixes #8021] Copy the request headers before sending the request on the RedirectHandler If another handler modifies the request headers the modified headers get applied on subsequent requests, which is not correct. This change copies the headers before sending the request and uses the original headers for the redirect request instead of the potentially modified ones.
* [`[40fb13a021]`](https://github.com/aspnet/AspNetCore/commit/40fb13a021) Fix DfaMatcher to work with non-RouteEndpoint (#739)
* [`[1d4d882c0d]`](https://github.com/aspnet/AspNetCore/commit/1d4d882c0d) Spelling mistake in debug log
* [`[b3893720b7]`](https://github.com/aspnet/AspNetCore/commit/b3893720b7) inproc property was changed in 2.2 (#1316)
* [`[2db0c086b2]`](https://github.com/aspnet/AspNetCore/commit/2db0c086b2) fix #2853 by adding blurb to readme (#2854)
* [`[e2de54a92d]`](https://github.com/aspnet/AspNetCore/commit/e2de54a92d) Update MvcEndpointDataSource to use RoutePattern (#8249)
* [`[15e46ad323]`](https://github.com/aspnet/AspNetCore/commit/15e46ad323) Change RoutePattern to not throw when inline and arg default value are the same (#747)
* [`[68a0863524]`](https://github.com/aspnet/AspNetCore/commit/68a0863524) General connection management (#2834)
* [`[a0aa61fd10]`](https://github.com/aspnet/AspNetCore/commit/a0aa61fd10) Improvements for IEndpointSelectorPolicy
* [`[12e2d30f6b]`](https://github.com/aspnet/AspNetCore/commit/12e2d30f6b) Publish .jar files to ProdCon output
* [`[ba2eacc3f5]`](https://github.com/aspnet/AspNetCore/commit/ba2eacc3f5) Automatically detect if private feed is required (#16)
* [`[3b3f128306]`](https://github.com/aspnet/AspNetCore/commit/3b3f128306) Enable app verifier on VSTS; Fix debug log handle use (#1291)
* [`[03da30f3bf]`](https://github.com/aspnet/AspNetCore/commit/03da30f3bf) Replace remaining references to global routing (#8312)
* [`[ed19e34256]`](https://github.com/aspnet/AspNetCore/commit/ed19e34256) Upgrade deps
* [`[de0932961b]`](https://github.com/aspnet/AspNetCore/commit/de0932961b) Default Identity UI to Bootstrap4
* [`[110d835434]`](https://github.com/aspnet/AspNetCore/commit/110d835434) Fix layout and login partial issues
* [`[3ed89516ba]`](https://github.com/aspnet/AspNetCore/commit/3ed89516ba) Update precedence for 2.2 templates
* [`[eebbb6a602]`](https://github.com/aspnet/AspNetCore/commit/eebbb6a602) Support portable.exe apps and better error reporting (#1287)
* [`[d9e71527e8]`](https://github.com/aspnet/AspNetCore/commit/d9e71527e8) Fix copyright year
* [`[f8a46faf9d]`](https://github.com/aspnet/AspNetCore/commit/f8a46faf9d) Detect ASP.NET SignalR server connection attempt (#2820)
* [`[5f4d0dac3c]`](https://github.com/aspnet/AspNetCore/commit/5f4d0dac3c) Ignore failures from sending ping (#2840)
* [`[36e5aceb3c]`](https://github.com/aspnet/AspNetCore/commit/36e5aceb3c) Serve 503 if server process is shutting down (#1293)
* [`[1680b9f4fc]`](https://github.com/aspnet/AspNetCore/commit/1680b9f4fc) Change endpoint invoker to RequestDelegate, Endpoint/EndpointMetadataCollection namespaces, split out IRouteValuesFeature (#712)
* [`[f703a288dd]`](https://github.com/aspnet/AspNetCore/commit/f703a288dd) Import restore sources into Microsoft.VisualStudio.RazorExtension.csproj
* [`[0b471f2b2f]`](https://github.com/aspnet/AspNetCore/commit/0b471f2b2f) Sockets: do 0 byte reads to avoid allocating memory for idle connections
* [`[5bd818bd64]`](https://github.com/aspnet/AspNetCore/commit/5bd818bd64) Introduce ProblemDetailsFilter
* [`[e23d9cb4ac]`](https://github.com/aspnet/AspNetCore/commit/e23d9cb4ac) Fix a few leaked handles (#1260)
* [`[967afc3b0f]`](https://github.com/aspnet/AspNetCore/commit/967afc3b0f)  Optimize RoutePattern allocations (#706)
* [`[ac0e8f11ca]`](https://github.com/aspnet/AspNetCore/commit/ac0e8f11ca) Fix TS msgpack on IE and Ping breaking connection on server (#2847)
* [`[9ccd3addc3]`](https://github.com/aspnet/AspNetCore/commit/9ccd3addc3) Synchronizes copyrights between V1 and V2. (#1283)
* [`[8b078218b0]`](https://github.com/aspnet/AspNetCore/commit/8b078218b0) Change ANCM version to 12.2 (#1272)
* [`[135da118d1]`](https://github.com/aspnet/AspNetCore/commit/135da118d1) Add rc file as an include for ANCMV1 (#1284)
* [`[26964b2687]`](https://github.com/aspnet/AspNetCore/commit/26964b2687) Macrosify out-of-proc (#1268)
* [`[60d617c5ac]`](https://github.com/aspnet/AspNetCore/commit/60d617c5ac) Check connection state before start stop and send (#2824)
* [`[2778570f0b]`](https://github.com/aspnet/AspNetCore/commit/2778570f0b) Redirect native logs into stdout and pipe (#1154)
* [`[2d61889e5e]`](https://github.com/aspnet/AspNetCore/commit/2d61889e5e) Support empty value for ASPNETCORE_PORT (#1280)
* [`[6da64c6d55]`](https://github.com/aspnet/AspNetCore/commit/6da64c6d55) Fix process start error message (#1267)
* [`[2560815501]`](https://github.com/aspnet/AspNetCore/commit/2560815501) Add NetTopologySuite external dependency
* [`[e85c36fa8c]`](https://github.com/aspnet/AspNetCore/commit/e85c36fa8c) Clarify CORS policy result log messages (#177)
* [`[6f7a841374]`](https://github.com/aspnet/AspNetCore/commit/6f7a841374) Fire OnStreamCompleted after all pipes are closed
* [`[a1e8b3a9af]`](https://github.com/aspnet/AspNetCore/commit/a1e8b3a9af) Free environment variable table in inprocess application (#1254)
* [`[ff52525134]`](https://github.com/aspnet/AspNetCore/commit/ff52525134) Skip ContentLength_Received_MultipleDataFramesOverSize_Reset
* [`[5bae8c768d]`](https://github.com/aspnet/AspNetCore/commit/5bae8c768d) Fix publishing targets to correctly reference the right item group: NpmPackageToPublish
* [`[5fc59b2331]`](https://github.com/aspnet/AspNetCore/commit/5fc59b2331) Free ALLOC_CACHE_HANDLER on dll unload (#1253)
* [`[0986f74264]`](https://github.com/aspnet/AspNetCore/commit/0986f74264) Added benchmarks for link generation
* [`[b4538831b7]`](https://github.com/aspnet/AspNetCore/commit/b4538831b7) Add package descriptions for Microsoft.AspNetCore.{App, All}
* [`[4b1e0d09c7]`](https://github.com/aspnet/AspNetCore/commit/4b1e0d09c7) Skip npm package publishing if there are no npm packages to release
* [`[16164689dc]`](https://github.com/aspnet/AspNetCore/commit/16164689dc) Update documentation on the various package archive formats (#1324)
* [`[24ed5586dc]`](https://github.com/aspnet/AspNetCore/commit/24ed5586dc) Collect dumps on VSTS (#1244)
* [`[8c9093332b]`](https://github.com/aspnet/AspNetCore/commit/8c9093332b) Support for Adding OnClosed Callbacks(#2821)
* [`[267b149bc8]`](https://github.com/aspnet/AspNetCore/commit/267b149bc8) Fix whitespace in task parameters (#1322)
* [`[731767837a]`](https://github.com/aspnet/AspNetCore/commit/731767837a) Introducing new **catchAll parameter to allow generating links with unencoded values
* [`[522006d2c8]`](https://github.com/aspnet/AspNetCore/commit/522006d2c8) [Design] Add a MaxValidationDepth option to ValidationVisitor
* [`[670598c05a]`](https://github.com/aspnet/AspNetCore/commit/670598c05a) Stop using IISExpress .config templates (#863)
* [`[30b01d2460]`](https://github.com/aspnet/AspNetCore/commit/30b01d2460) Stop using IISExpress .config templates (#142)
* [`[3b853daa1a]`](https://github.com/aspnet/AspNetCore/commit/3b853daa1a) Log unhandled exceptions to help see errors in tests (#2815)
* [`[83488886e0]`](https://github.com/aspnet/AspNetCore/commit/83488886e0) Clean up some remants of the past (#2827)
* [`[730646c301]`](https://github.com/aspnet/AspNetCore/commit/730646c301) Perf for EMC
* [`[6724b4d796]`](https://github.com/aspnet/AspNetCore/commit/6724b4d796) Add EMC benchmark
* [`[4fa0b068b8]`](https://github.com/aspnet/AspNetCore/commit/4fa0b068b8) Fix #710 - add support for data tokens
* [`[97f54c532b]`](https://github.com/aspnet/AspNetCore/commit/97f54c532b) Support supression of matching for endpoints
* [`[6440545c4a]`](https://github.com/aspnet/AspNetCore/commit/6440545c4a) Add hosting model switch tests (#1245)
* [`[56236f6a74]`](https://github.com/aspnet/AspNetCore/commit/56236f6a74) Add stress test zip as an asset (#1243)
* [`[b981e24a53]`](https://github.com/aspnet/AspNetCore/commit/b981e24a53) Updated the lock files (#2813)
* [`[0c2923135b]`](https://github.com/aspnet/AspNetCore/commit/0c2923135b) Limit concurrent HTTP/2 Streams per connection #2815
* [`[e9c0787308]`](https://github.com/aspnet/AspNetCore/commit/e9c0787308) Support list of package sources
* [`[d3f51da519]`](https://github.com/aspnet/AspNetCore/commit/d3f51da519) Add EFCore.Cosmos.Sql to shipping package list
* [`[9290f3fd52]`](https://github.com/aspnet/AspNetCore/commit/9290f3fd52) Set HTTP request timeout to infinite - Prevent failures due to slow requests when running many tests in parallel
* [`[60ca38ab56]`](https://github.com/aspnet/AspNetCore/commit/60ca38ab56) Fix deployment parameters override (#1241)
* [`[3e00887c2f]`](https://github.com/aspnet/AspNetCore/commit/3e00887c2f) Call StopServer before checking all event logs (#1242)
* [`[085a0b808e]`](https://github.com/aspnet/AspNetCore/commit/085a0b808e) Use RoutePattern in TemplateBinder
* [`[af770ede87]`](https://github.com/aspnet/AspNetCore/commit/af770ede87) Ignore parameters that specify a model binder type
* [`[431627958c]`](https://github.com/aspnet/AspNetCore/commit/431627958c) Adding support for Close Message (#2793)
* [`[1924b32c33]`](https://github.com/aspnet/AspNetCore/commit/1924b32c33) Add local vars for easier debugging
* [`[b1b60d9424]`](https://github.com/aspnet/AspNetCore/commit/b1b60d9424) Rename tests to run in optimal order
* [`[85c934dcdd]`](https://github.com/aspnet/AspNetCore/commit/85c934dcdd) Throw if the Websocket cant connect in Java client(#2801)
* [`[c6aaa13db9]`](https://github.com/aspnet/AspNetCore/commit/c6aaa13db9) Add JS API doc link to npm packages (#2809)
* [`[51e6492b44]`](https://github.com/aspnet/AspNetCore/commit/51e6492b44) Update for SDK 2.2.100-preview1 (#15)
* [`[7e25d7908a]`](https://github.com/aspnet/AspNetCore/commit/7e25d7908a) Warn when the parameter name for a model bound complex parameter has the same name as a top level property
* [`[53ceaf1b2c]`](https://github.com/aspnet/AspNetCore/commit/53ceaf1b2c) [TS Client] Properly wait for WebSocket close (#2804)
* [`[1104564797]`](https://github.com/aspnet/AspNetCore/commit/1104564797) Throw when web config action is added without publish (#1234)
* [`[8dbe564263]`](https://github.com/aspnet/AspNetCore/commit/8dbe564263) Add commit hash to V1 description (#1229)
* [`[5e20c313d9]`](https://github.com/aspnet/AspNetCore/commit/5e20c313d9) Array or List in query string does not get parsed #7712 (#7967)
* [`[110fea288b]`](https://github.com/aspnet/AspNetCore/commit/110fea288b) Produce a stress test app (#1228)
* [`[2421ae8c83]`](https://github.com/aspnet/AspNetCore/commit/2421ae8c83) Add IStatusCodeActionResult (#8265)
* [`[045d5f1c7f]`](https://github.com/aspnet/AspNetCore/commit/045d5f1c7f) Add gradle to 3pn (#2798)
* [`[d725972355]`](https://github.com/aspnet/AspNetCore/commit/d725972355) Start adding configuration reload tests (#1212)
* [`[43398482a5]`](https://github.com/aspnet/AspNetCore/commit/43398482a5) Implement MaxRequestBodySize for HTTP/2 #2810
* [`[cd6de2fa18]`](https://github.com/aspnet/AspNetCore/commit/cd6de2fa18) Improve HTTP/2 stream abort logic (#2819)
* [`[6310cffd7c]`](https://github.com/aspnet/AspNetCore/commit/6310cffd7c) Add timestamps to log messages (#2777)
* [`[82cef1a0c6]`](https://github.com/aspnet/AspNetCore/commit/82cef1a0c6) fix chrome headless when root by adding --no-sandbox (#2796)
* [`[9618a59485]`](https://github.com/aspnet/AspNetCore/commit/9618a59485) Add .gitattributes file
* [`[f1c1f82e8b]`](https://github.com/aspnet/AspNetCore/commit/f1c1f82e8b) Fix is_regular_file again (#1218)
* [`[08ee882217]`](https://github.com/aspnet/AspNetCore/commit/08ee882217) Update Gradle to 4.9 (#2786)
* [`[e0235b1e21]`](https://github.com/aspnet/AspNetCore/commit/e0235b1e21) Fix aspnet/Home#3379 - add a functional test for Redis storage provider to ensure keys round-trip (#321)
* [`[a8be2bf25b]`](https://github.com/aspnet/AspNetCore/commit/a8be2bf25b) Add common retry helper for SeverManager (#1207)
* [`[b029f79b4d]`](https://github.com/aspnet/AspNetCore/commit/b029f79b4d) Import styles in correct order (#668)
* [`[253ac7c143]`](https://github.com/aspnet/AspNetCore/commit/253ac7c143) Ignore line ending diff
* [`[9da8e2c908]`](https://github.com/aspnet/AspNetCore/commit/9da8e2c908) Ensure UnsupportedContentTypeFilter runs before ModelStateInvalidFilter
* [`[ac9b1f97c5]`](https://github.com/aspnet/AspNetCore/commit/ac9b1f97c5) Add a restore feed for 2.1.3 packages
* [`[b82fcc0b21]`](https://github.com/aspnet/AspNetCore/commit/b82fcc0b21) log when WebSocketTransport has started (#2752)
* [`[a7a95c6da1]`](https://github.com/aspnet/AspNetCore/commit/a7a95c6da1) Add PR validation on VSTS
* [`[9534c08142]`](https://github.com/aspnet/AspNetCore/commit/9534c08142) Change versioning of Microsoft.AspNetCore.DataProtection.Redis to 2.2 (#320)
* [`[62a30a731d]`](https://github.com/aspnet/AspNetCore/commit/62a30a731d) Fix bug in graceful shutdown
* [`[4628525301]`](https://github.com/aspnet/AspNetCore/commit/4628525301) Start W3SVC if it is stopped (#1197)
* [`[b078521f17]`](https://github.com/aspnet/AspNetCore/commit/b078521f17) Hold open the nginx dynamic port
* [`[bd3a8a3511]`](https://github.com/aspnet/AspNetCore/commit/bd3a8a3511) Small test fix to avoid potential flakiness
* [`[7c9e234457]`](https://github.com/aspnet/AspNetCore/commit/7c9e234457) Gracefully wait for streams to complete when pipe completes
* [`[8361b8cfa9]`](https://github.com/aspnet/AspNetCore/commit/8361b8cfa9) Split handler resolution from application info (#1177)
* [`[c8418c6de8]`](https://github.com/aspnet/AspNetCore/commit/c8418c6de8) Derive SocketAwaitable from SocketAsyncEventArgs (#2592)
* [`[e6330ab19b]`](https://github.com/aspnet/AspNetCore/commit/e6330ab19b) Fix win7 test again (#1187)
* [`[d7ad4c79ee]`](https://github.com/aspnet/AspNetCore/commit/d7ad4c79ee) Fix incremental checks for test projects (#1186)
* [`[dd429e9597]`](https://github.com/aspnet/AspNetCore/commit/dd429e9597) Catch exceptions thrown by is_regular_file (#1179)
* [`[12cb35894e]`](https://github.com/aspnet/AspNetCore/commit/12cb35894e) Add support for GraphViz
* [`[aaf0293ebc]`](https://github.com/aspnet/AspNetCore/commit/aaf0293ebc) Fix logging verification in tests (#2795)
* [`[433dd42909]`](https://github.com/aspnet/AspNetCore/commit/433dd42909) Use web.config for ASPNETCORE_DETAILEDERRORS
* [`[6a6e1743ae]`](https://github.com/aspnet/AspNetCore/commit/6a6e1743ae) Expose full implementation for configureLogging in ESM definition file (#2770)
* [`[a550ae6cc3]`](https://github.com/aspnet/AspNetCore/commit/a550ae6cc3) Provide a better error message when invoking a non-existant hub method (#2768)
* [`[c9104d4932]`](https://github.com/aspnet/AspNetCore/commit/c9104d4932) Move Java client into com.microsoft.aspnet.signalr (#2763)
* [`[da1189e6f1]`](https://github.com/aspnet/AspNetCore/commit/da1189e6f1) Use StatusCodes constants instead of literals in the ProducesResponseType code fix (#8234)
* [`[2265acde78]`](https://github.com/aspnet/AspNetCore/commit/2265acde78) Don't start stream if already canceled (#2764)
* [`[186a85b7e0]`](https://github.com/aspnet/AspNetCore/commit/186a85b7e0) Add timestamp to logs TS client (#2760)
* [`[d153bab4a1]`](https://github.com/aspnet/AspNetCore/commit/d153bab4a1) Use configurationRedirection for IIS Deployer (#1170)
* [`[c0557cfca7]`](https://github.com/aspnet/AspNetCore/commit/c0557cfca7) Improve exception handling in Http2Connection.ProcessRequestsAsync (#2787)
* [`[5378900e0c]`](https://github.com/aspnet/AspNetCore/commit/5378900e0c) Ack settings before window updates #2772
* [`[d3f418efd8]`](https://github.com/aspnet/AspNetCore/commit/d3f418efd8) disable the gradle daemon on the CI (#2759)
* [`[c73d513289]`](https://github.com/aspnet/AspNetCore/commit/c73d513289) Add Http2 frame logging
* [`[3f55bf3cfb]`](https://github.com/aspnet/AspNetCore/commit/3f55bf3cfb) Make System.IO.Pipelines a direct dependency of Microsoft.AspNetCore.App
* [`[2f85e4a36d]`](https://github.com/aspnet/AspNetCore/commit/2f85e4a36d) Add a restore feed for 2.1.3 packages
* [`[c1da83637e]`](https://github.com/aspnet/AspNetCore/commit/c1da83637e) fix jdk detection by detecting javac instead of tools.jar (#2751)
* [`[5e7f63b096]`](https://github.com/aspnet/AspNetCore/commit/5e7f63b096) Make un-graceful shutdown a bit more graceful (#2748)
* [`[7431892e64]`](https://github.com/aspnet/AspNetCore/commit/7431892e64) Replace "std::experimental::filesystem" with "std::filesystem" (#1153)
* [`[b53d50f6f0]`](https://github.com/aspnet/AspNetCore/commit/b53d50f6f0) Fix incorrectly resolved cross-document pointers
* [`[8c26579016]`](https://github.com/aspnet/AspNetCore/commit/8c26579016) Don't push artifacts in forks (#1168)
* [`[3c19cede7d]`](https://github.com/aspnet/AspNetCore/commit/3c19cede7d) Updated dependencies
* [`[0e99235d59]`](https://github.com/aspnet/AspNetCore/commit/0e99235d59) Add in-memory functional test project (#2780)
* [`[0cf53e7d34]`](https://github.com/aspnet/AspNetCore/commit/0cf53e7d34) Show HTTP/2 status on requests #106
* [`[e4161d8971]`](https://github.com/aspnet/AspNetCore/commit/e4161d8971) Prepare 2.1.4 patch
* [`[c1aa708a8b]`](https://github.com/aspnet/AspNetCore/commit/c1aa708a8b) TypeScript improvements and tslib dep (#2692)
* [`[cef7dfcdbb]`](https://github.com/aspnet/AspNetCore/commit/cef7dfcdbb) Check connection state in ping Typescript client (#2753)
* [`[02d1d4b1aa]`](https://github.com/aspnet/AspNetCore/commit/02d1d4b1aa) Adding Javadocs (#2745)
* [`[9585084258]`](https://github.com/aspnet/AspNetCore/commit/9585084258) Using Routing feature branch versions
* [`[fc8979aeca]`](https://github.com/aspnet/AspNetCore/commit/fc8979aeca) Update TS docs for docs.microsoft.com generation (#2605)
* [`[685176faf5]`](https://github.com/aspnet/AspNetCore/commit/685176faf5) Updated dependencies
* [`[b494e50353]`](https://github.com/aspnet/AspNetCore/commit/b494e50353) Fixup shutdown functional tests
* [`[8a74cf3ed5]`](https://github.com/aspnet/AspNetCore/commit/8a74cf3ed5) Gracefully shutdown HTTP/2 connections on server and client initiated shutdown
* [`[d8741d1b0f]`](https://github.com/aspnet/AspNetCore/commit/d8741d1b0f) Skip Redis tests on macOS (#2740)
* [`[dadff9fc29]`](https://github.com/aspnet/AspNetCore/commit/dadff9fc29) Avoid ODE in tests with Server logging (#2742)
* [`[e403de7fbf]`](https://github.com/aspnet/AspNetCore/commit/e403de7fbf) Solve LongPolling races by moving Cts disposal to connection disposal (#2731)
* [`[d76c074780]`](https://github.com/aspnet/AspNetCore/commit/d76c074780) Up Redis test log level (#2743)
* [`[31b6ad69ae]`](https://github.com/aspnet/AspNetCore/commit/31b6ad69ae) Increase poll timeout in TS client (#2737)
* [`[39c5700148]`](https://github.com/aspnet/AspNetCore/commit/39c5700148) Add docs to RouteValuesAddress (#695)
* [`[c6830afa55]`](https://github.com/aspnet/AspNetCore/commit/c6830afa55) Add default debug log file name and dll information to debug log (#1149)
* [`[8ec69456ca]`](https://github.com/aspnet/AspNetCore/commit/8ec69456ca) Update CustomWriterStartup.cs
* [`[647f0f81c2]`](https://github.com/aspnet/AspNetCore/commit/647f0f81c2) CompatibilityVersion -> 2.2
* [`[e47a08612b]`](https://github.com/aspnet/AspNetCore/commit/e47a08612b) JQuery-validate-unobtrusive version 3.2.10
* [`[60a559719f]`](https://github.com/aspnet/AspNetCore/commit/60a559719f) Reduce probability of startup port collisions (#1136)
* [`[47f2f451e3]`](https://github.com/aspnet/AspNetCore/commit/47f2f451e3) EnableEndpointRouting documentation (#8220)
* [`[4e7cbb1931]`](https://github.com/aspnet/AspNetCore/commit/4e7cbb1931) Initialize logging under exclusive lock (#1161)
* [`[41d648fcc1]`](https://github.com/aspnet/AspNetCore/commit/41d648fcc1) Fully-qualify model name
* [`[ea7e53cab0]`](https://github.com/aspnet/AspNetCore/commit/ea7e53cab0) Send Resets for unhandled app exceptions #2733
* [`[c48412441d]`](https://github.com/aspnet/AspNetCore/commit/c48412441d) Add logging infrastructure to the Java Client (#2720)
* [`[e78e3db6f4]`](https://github.com/aspnet/AspNetCore/commit/e78e3db6f4) Honor InherentKeepAliveFeature for server timeout (#2727)
* [`[71c15fb76a]`](https://github.com/aspnet/AspNetCore/commit/71c15fb76a) Use bootstrap4 for templates
* [`[959771e73a]`](https://github.com/aspnet/AspNetCore/commit/959771e73a) Fix incrementality checks for test projects (#1145)
* [`[c2f5101b73]`](https://github.com/aspnet/AspNetCore/commit/c2f5101b73) Split managed application status and IApplication status (#1148)
* [`[d95f971693]`](https://github.com/aspnet/AspNetCore/commit/d95f971693) Fix broken tests
* [`[eb591fb29d]`](https://github.com/aspnet/AspNetCore/commit/eb591fb29d) Attempt to fix exclusions in NuGetPackageVerifier.json again
* [`[4336b50340]`](https://github.com/aspnet/AspNetCore/commit/4336b50340) Updated dependencies
* [`[e53a9f57db]`](https://github.com/aspnet/AspNetCore/commit/e53a9f57db) adding more docs
* [`[5ee3ae9002]`](https://github.com/aspnet/AspNetCore/commit/5ee3ae9002) Add XML docs to data sources and metadata (#692)
* [`[27a35d5d9b]`](https://github.com/aspnet/AspNetCore/commit/27a35d5d9b) fix benchmarks manifest
* [`[d1cba1f55b]`](https://github.com/aspnet/AspNetCore/commit/d1cba1f55b) Add Database health sample
* [`[6efb51d817]`](https://github.com/aspnet/AspNetCore/commit/6efb51d817) Add Microsoft.AspNetCore.Mvc.Api.Analyzers to Mvc.sln
* [`[ebafbcdae3]`](https://github.com/aspnet/AspNetCore/commit/ebafbcdae3) Add filtering by port
* [`[2a761d635c]`](https://github.com/aspnet/AspNetCore/commit/2a761d635c) Replace "std::experimental::filesystem" with "std::filesystem" (#1153)
* [`[9ff001d57c]`](https://github.com/aspnet/AspNetCore/commit/9ff001d57c) Capture global logs on VSTS (#1151)
* [`[f867367b56]`](https://github.com/aspnet/AspNetCore/commit/f867367b56) Use V2 schema for V1 outputs, do not pack pdb's (#1152)
* [`[4d706f045f]`](https://github.com/aspnet/AspNetCore/commit/4d706f045f) rebase changes
* [`[09ce9c3041]`](https://github.com/aspnet/AspNetCore/commit/09ce9c3041) Api clean up
* [`[091cb94094]`](https://github.com/aspnet/AspNetCore/commit/091cb94094) Change metadata namespace Change EndpointOptions visibility to internal Add IRequiredValuesMetadata
* [`[c8946a40e4]`](https://github.com/aspnet/AspNetCore/commit/c8946a40e4) Created LinkGenerationTemplate and friends
* [`[8a9b407761]`](https://github.com/aspnet/AspNetCore/commit/8a9b407761) Use netcoreapp2.1 instead of 2.2
* [`[a375cba359]`](https://github.com/aspnet/AspNetCore/commit/a375cba359) Copy action constraints and EndPointMetadata when setting up a PageActionDescriptor (#8208)
* [`[ac410b76d9]`](https://github.com/aspnet/AspNetCore/commit/ac410b76d9) Change MvcEndpointInfo to internal (#8210)
* [`[90b093baac]`](https://github.com/aspnet/AspNetCore/commit/90b093baac) Updated dependencies.props
* [`[05eb6a7f7c]`](https://github.com/aspnet/AspNetCore/commit/05eb6a7f7c) Add ERROR_SHARING_VIOLATION to retry list for IISDeployer.Start (#1147)
* [`[bc13fd5450]`](https://github.com/aspnet/AspNetCore/commit/bc13fd5450) Write websocket header directly to the repsonse headers (#253)
* [`[b177ba5309]`](https://github.com/aspnet/AspNetCore/commit/b177ba5309) Changed api of LinkGenerator
* [`[0989231ed5]`](https://github.com/aspnet/AspNetCore/commit/0989231ed5) Make structs readonly
* [`[810c7cf9ad]`](https://github.com/aspnet/AspNetCore/commit/810c7cf9ad) Fix ODE race with cancellationtokensource (#2721)
* [`[9cea167cfa]`](https://github.com/aspnet/AspNetCore/commit/9cea167cfa) Add docs - EndpointFeature and related types (#687)
* [`[90606338fb]`](https://github.com/aspnet/AspNetCore/commit/90606338fb) Log when closing connection due to timeout (#2722)
* [`[4eb2e41601]`](https://github.com/aspnet/AspNetCore/commit/4eb2e41601) Wait between requests while checking app_offline (#1144)
* [`[e2b6f07778]`](https://github.com/aspnet/AspNetCore/commit/e2b6f07778) Respect LowercaseUrls in ApiExplorer Fixes #8006
* [`[768d2a023e]`](https://github.com/aspnet/AspNetCore/commit/768d2a023e) Add Origin validation to WebSockets middleware (#252)
* [`[39f46060e7]`](https://github.com/aspnet/AspNetCore/commit/39f46060e7) Correct changeset for Mvc submodule
* [`[5a20037965]`](https://github.com/aspnet/AspNetCore/commit/5a20037965) Move API convention analyzers to Microsoft.AspNetCore.Mvc.Api.Analyzers
* [`[c0ed5c71a4]`](https://github.com/aspnet/AspNetCore/commit/c0ed5c71a4) Add Microsoft.AspNetCore.Mvc.Api.Analyzers
* [`[6d9aa281c5]`](https://github.com/aspnet/AspNetCore/commit/6d9aa281c5) Render `maxlength` attribute for an input tag, when MaxLength or StringLength validation attributes are applied to the model class.
* [`[beca0259c2]`](https://github.com/aspnet/AspNetCore/commit/beca0259c2) Verify request Content-Length #2733
* [`[477fd1d90d]`](https://github.com/aspnet/AspNetCore/commit/477fd1d90d) Aquire exclusive lock when creating application info (#1142)
* [`[b7335ac768]`](https://github.com/aspnet/AspNetCore/commit/b7335ac768) Add a code fix that applies ProducesResponseTypeAttributes
* [`[32d380a058]`](https://github.com/aspnet/AspNetCore/commit/32d380a058) Don't send WebSocketCloseStatus.Empty, it's invalid (#2716)
* [`[64124e9c85]`](https://github.com/aspnet/AspNetCore/commit/64124e9c85) Add filtering to Health Checks middleware
* [`[47f427d5ac]`](https://github.com/aspnet/AspNetCore/commit/47f427d5ac) Updating Health Checks for 2.2
* [`[8c4f187c22]`](https://github.com/aspnet/AspNetCore/commit/8c4f187c22) Endpoint routing rename and API review changes (#684)
* [`[8ea2cd9081]`](https://github.com/aspnet/AspNetCore/commit/8ea2cd9081) Ship shim with integration testing  (#1129)
* [`[7d4df89025]`](https://github.com/aspnet/AspNetCore/commit/7d4df89025) Back Port WebPack (#2641)
* [`[7487da155f]`](https://github.com/aspnet/AspNetCore/commit/7487da155f) Switch signing certificate for Newtonsoft.JSON to Microsoft3rdPartyAppComponentDual
* [`[7f8f210a24]`](https://github.com/aspnet/AspNetCore/commit/7f8f210a24) Add license headers to all files
* [`[89ab0cfde8]`](https://github.com/aspnet/AspNetCore/commit/89ab0cfde8) Initial commit of the HTTP REPL
* [`[165c712201]`](https://github.com/aspnet/AspNetCore/commit/165c712201) Use OSS package versions consistent with aspnet/benchmarks and Microsoft.AspNetcore.All 2.1.2 - update our own NuGet packages to align lower-level dependencies
* [`[814a803ed8]`](https://github.com/aspnet/AspNetCore/commit/814a803ed8) Use local instances of MemoryCache in script, link and image tag helper
* [`[ab84d17bb3]`](https://github.com/aspnet/AspNetCore/commit/ab84d17bb3) Unskip endpoint routing functional tests
* [`[046af405b6]`](https://github.com/aspnet/AspNetCore/commit/046af405b6) Rename global routing to endpoint routing (#8179)
* [`[4b5a32d3b9]`](https://github.com/aspnet/AspNetCore/commit/4b5a32d3b9) Use TestApplication (#1118)
* [`[ff0a5bbbdf]`](https://github.com/aspnet/AspNetCore/commit/ff0a5bbbdf) Update resources.h (#1134)
* [`[c8eedb3540]`](https://github.com/aspnet/AspNetCore/commit/c8eedb3540) Fix race when connection is canceled and new poll comes in (#2697)
* [`[d99d2d881c]`](https://github.com/aspnet/AspNetCore/commit/d99d2d881c) Fix HTTPS certs on VSTS (#1123)
* [`[85c7bd8fac]`](https://github.com/aspnet/AspNetCore/commit/85c7bd8fac) Discard ambient values during link generation if the values do not match explicit values [Fixes #544] Link generation: Discard ambient values unless routing to the same address
* [`[ef2c127459]`](https://github.com/aspnet/AspNetCore/commit/ef2c127459) Show route name
* [`[bf839dadf1]`](https://github.com/aspnet/AspNetCore/commit/bf839dadf1) Delete ISSUE_TEMPLATE.md
* [`[f62877b9db]`](https://github.com/aspnet/AspNetCore/commit/f62877b9db) Show default values in CompositeEndpointDataSource's debugger display string
* [`[a4b91d6dce]`](https://github.com/aspnet/AspNetCore/commit/a4b91d6dce) Flatten AggregateExceptions in rzc
* [`[0726b8b98b]`](https://github.com/aspnet/AspNetCore/commit/0726b8b98b) Make publicly exposed Roslyn types internal
* [`[e094d2579e]`](https://github.com/aspnet/AspNetCore/commit/e094d2579e) Suppress obsolete warnings
* [`[da10db413a]`](https://github.com/aspnet/AspNetCore/commit/da10db413a) Fix query string name in transport spec (#2702)
* [`[3d6e1e69fd]`](https://github.com/aspnet/AspNetCore/commit/3d6e1e69fd) Close LongPolling connection on poll exception (#2701)
* [`[25b826de75]`](https://github.com/aspnet/AspNetCore/commit/25b826de75) Update JavaClientVersion variable (#2703)
* [`[3ff064cea3]`](https://github.com/aspnet/AspNetCore/commit/3ff064cea3) Lock when reading \ writing process output
* [`[4baed363e5]`](https://github.com/aspnet/AspNetCore/commit/4baed363e5) Close #467 -  fix race conditions in tests that restart a watchable app
* [`[b2a1a7c9de]`](https://github.com/aspnet/AspNetCore/commit/b2a1a7c9de) Ensure parent is a MethodDeclarationSyntax
* [`[652c529f8f]`](https://github.com/aspnet/AspNetCore/commit/652c529f8f) Fix ServerShutsDownWhenMainExits test (#1120)
* [`[3cdb73440e]`](https://github.com/aspnet/AspNetCore/commit/3cdb73440e) Disable memory pool late return validation in H2SpecTests (#2768)
* [`[d346255db6]`](https://github.com/aspnet/AspNetCore/commit/d346255db6) Add analyzer and codefix that suggests removing unnecessary invalid model state validity checks
* [`[7a4a945fd6]`](https://github.com/aspnet/AspNetCore/commit/7a4a945fd6) Stop site and app pool before restoring config (#1112)
* [`[6d46410a76]`](https://github.com/aspnet/AspNetCore/commit/6d46410a76) Don't ACK ACKs (#2767)
* [`[367717760b]`](https://github.com/aspnet/AspNetCore/commit/367717760b) Handle subtype with suffix being a subtype without a suffix (#8170)
* [`[80b6ae4eb4]`](https://github.com/aspnet/AspNetCore/commit/80b6ae4eb4) Handle subtype with suffix being a subtype without a suffix (#1027)
* [`[b85adeee6d]`](https://github.com/aspnet/AspNetCore/commit/b85adeee6d) Skip 21 inproc tests (#862)
* [`[a14fe7f748]`](https://github.com/aspnet/AspNetCore/commit/a14fe7f748) Update issue template for security issues (#2693)
* [`[0102d4efab]`](https://github.com/aspnet/AspNetCore/commit/0102d4efab) Introduce ApiConventionMethodAttribute
* [`[cb557cf771]`](https://github.com/aspnet/AspNetCore/commit/cb557cf771) Changed `GetDesiredIndentation` to be resilient to our SyntaxTree which occasionally has gaps.
* [`[7d641f8796]`](https://github.com/aspnet/AspNetCore/commit/7d641f8796) Skip VSTS attribute (#1115)
* [`[41493f01e3]`](https://github.com/aspnet/AspNetCore/commit/41493f01e3) Don't stop redirect stdout/stderr after startup is done. (#1067)
* [`[c01c7075be]`](https://github.com/aspnet/AspNetCore/commit/c01c7075be) Add EndpointMetadata to ActionDescriptor and hookup CORS (#8158)
* [`[0af3bef0fe]`](https://github.com/aspnet/AspNetCore/commit/0af3bef0fe) Fix win7 test failures. (#1109)
* [`[c6ba21efc1]`](https://github.com/aspnet/AspNetCore/commit/c6ba21efc1) Add VSTS ci pipeline (#893)
* [`[f870503cdd]`](https://github.com/aspnet/AspNetCore/commit/f870503cdd) Fix HttpMethodMetadata debug string (#666)
* [`[647e7c3266]`](https://github.com/aspnet/AspNetCore/commit/647e7c3266) Add new ConfigureKestrel extensions #2760
* [`[f901bca8a7]`](https://github.com/aspnet/AspNetCore/commit/f901bca8a7) Fixing jenkins agents. (#1106)
* [`[c7dd9ff68a]`](https://github.com/aspnet/AspNetCore/commit/c7dd9ff68a) Enable Http/2 by default #2720
* [`[6efdf78fb5]`](https://github.com/aspnet/AspNetCore/commit/6efdf78fb5) IIS ANCM support in test matrix (#1509)
* [`[94cfc01fbf]`](https://github.com/aspnet/AspNetCore/commit/94cfc01fbf) Implement HTTP/2 input flow control (#2740)
* [`[54e5370e8f]`](https://github.com/aspnet/AspNetCore/commit/54e5370e8f) Add CORS support to HttpMethodMatcherPolicy
* [`[fed2eb1cdf]`](https://github.com/aspnet/AspNetCore/commit/fed2eb1cdf) More robust username discovery on Linux in NginxDeployer (#1508)
* [`[7067d92c75]`](https://github.com/aspnet/AspNetCore/commit/7067d92c75) Limit RH native assets to netcoreapp2.2 (#1105)
* [`[556880872d]`](https://github.com/aspnet/AspNetCore/commit/556880872d) Ensure later validations of `null` models do not overwrite `Invalid` state - #8078
* [`[afa5d60821]`](https://github.com/aspnet/AspNetCore/commit/afa5d60821) Add content/webroot and currect directory tests (#1103)
* [`[498fa2d72f]`](https://github.com/aspnet/AspNetCore/commit/498fa2d72f) Avoid `InvalidOperationException` when serializing `SerializableError` - #8055 - provide unique name (`<Empty-Key>`) for XML elements that would otherwise be nameless
* [`[61b4473abe]`](https://github.com/aspnet/AspNetCore/commit/61b4473abe) Fix another shutdown race and appofline race (#1071)
* [`[2a48a9a2c4]`](https://github.com/aspnet/AspNetCore/commit/2a48a9a2c4) Adding Java Client Overloads up to T8. (#2660)
* [`[daed55be36]`](https://github.com/aspnet/AspNetCore/commit/daed55be36) Parse HandshakeResponse (#2656)
* [`[ba18129d79]`](https://github.com/aspnet/AspNetCore/commit/ba18129d79) Skip win7 tests (#1096)
* [`[f31ab716ee]`](https://github.com/aspnet/AspNetCore/commit/f31ab716ee) Change MvcEndpointDataSource to use GetChangeToken (#8137)
* [`[aa8a8b7471]`](https://github.com/aspnet/AspNetCore/commit/aa8a8b7471) Skip IIS Jenkins (#1094)
* [`[aee905e359]`](https://github.com/aspnet/AspNetCore/commit/aee905e359) Sort list of artifacts and add selenium to external artifacts
* [`[10ce77b9ca]`](https://github.com/aspnet/AspNetCore/commit/10ce77b9ca) Updated MvcEndpointDataSource to create endpoints with SuppressLinkGenerationMetadata
* [`[e0294f1d1b]`](https://github.com/aspnet/AspNetCore/commit/e0294f1d1b) Upgraded dependencies.props
* [`[bcd6e83591]`](https://github.com/aspnet/AspNetCore/commit/bcd6e83591) Upgraded dependencies.props
* [`[19f24cad16]`](https://github.com/aspnet/AspNetCore/commit/19f24cad16) fix silly constructor
* [`[1340f9c26b]`](https://github.com/aspnet/AspNetCore/commit/1340f9c26b) Add EndpointSelectorCandidate ctor to not break MVC (#661)
* [`[fdff66054f]`](https://github.com/aspnet/AspNetCore/commit/fdff66054f) Missing ChangeToken -> GetChangeToken updates (#660)
* [`[c08504b08a]`](https://github.com/aspnet/AspNetCore/commit/c08504b08a) MVC startup experience (#8131)
* [`[f385308503]`](https://github.com/aspnet/AspNetCore/commit/f385308503) Pass "--debug:ephemeral-hive" to "dotnet new"
* [`[147c9527f3]`](https://github.com/aspnet/AspNetCore/commit/147c9527f3) Implement EndpointSelector and MatcherPolicy (#646)
* [`[f37ca0d2e9]`](https://github.com/aspnet/AspNetCore/commit/f37ca0d2e9) Show list of endpoints in CompositeEndpointDataSource's DebuggerDisplayString [Fixes #633] Show list of registered endpoints as debugger display string
* [`[71cb933a08]`](https://github.com/aspnet/AspNetCore/commit/71cb933a08) Show a flattened tree in LinkGenerationDecisionTree's DebuggerDisplayString [Fixes #636] Flatten the LinkGenerationDecisionTree to show as debugger display string
* [`[34499dbe24]`](https://github.com/aspnet/AspNetCore/commit/34499dbe24) Added support for suppressing link generation for endpoints
* [`[630aeade07]`](https://github.com/aspnet/AspNetCore/commit/630aeade07) Added tests related to generating urls with route name
* [`[5bd475ef90]`](https://github.com/aspnet/AspNetCore/commit/5bd475ef90) Add event logs for some startup failure cases (#1081)
* [`[5580928209]`](https://github.com/aspnet/AspNetCore/commit/5580928209) Upgraded dependencies.props
* [`[7da1baf9d8]`](https://github.com/aspnet/AspNetCore/commit/7da1baf9d8) Do not use decision tree for named routes in RouteValuesBasedEndpointFinder
* [`[9b217892ab]`](https://github.com/aspnet/AspNetCore/commit/9b217892ab) Using routing feature branch versions to prevent cross repo breaking changes
* [`[5f1631ab46]`](https://github.com/aspnet/AspNetCore/commit/5f1631ab46) Added support for configuring route options with LinkGenerator
* [`[18e0871fe2]`](https://github.com/aspnet/AspNetCore/commit/18e0871fe2) Update to NETCore.App 2.1.3-servicing-26722-02
* [`[684e7855a6]`](https://github.com/aspnet/AspNetCore/commit/684e7855a6) Handle `null` entries correctly for `IsEmptyOrWhiteSpace` - #2497
* [`[feceb3ddea]`](https://github.com/aspnet/AspNetCore/commit/feceb3ddea) Lowercase scheme and host to better align with RFC 6454.
* [`[52c1e942c6]`](https://github.com/aspnet/AspNetCore/commit/52c1e942c6) Added UseCamelCasing and UseMemberCasing extension methods to MvcJsonOptions (#7256)
* [`[fba4e3ec4e]`](https://github.com/aspnet/AspNetCore/commit/fba4e3ec4e) Switch to non-experimental filesystem (#1082)
* [`[1e807240ea]`](https://github.com/aspnet/AspNetCore/commit/1e807240ea) Add GetChangeToken to EndpointDataSource (#649)
* [`[c0ba374549]`](https://github.com/aspnet/AspNetCore/commit/c0ba374549) Custom error messages with validation message tag helper #8035
* [`[e1e7ec0f28]`](https://github.com/aspnet/AspNetCore/commit/e1e7ec0f28) Enable couple of skipped Dispatching functional tests
* [`[c3545c18eb]`](https://github.com/aspnet/AspNetCore/commit/c3545c18eb) Add api sets to IntegrationTesting.IIS (#1083)
* [`[28c0c4d128]`](https://github.com/aspnet/AspNetCore/commit/28c0c4d128) Add ability to override the testing web content root using environment variables
* [`[d4beab5d09]`](https://github.com/aspnet/AspNetCore/commit/d4beab5d09) CompositeValidationAttribute
* [`[a330c920d7]`](https://github.com/aspnet/AspNetCore/commit/a330c920d7) Support overrides on using P2P references for benchmarks
* [`[f1c060bf3d]`](https://github.com/aspnet/AspNetCore/commit/f1c060bf3d) RoutePattern everywhere
* [`[8f8d3afd36]`](https://github.com/aspnet/AspNetCore/commit/8f8d3afd36) Fix bug in benchmark
* [`[90395c933d]`](https://github.com/aspnet/AspNetCore/commit/90395c933d) Implement IRoutingFeature on EndpointFeature for back-compat (#641)
* [`[256aed8369]`](https://github.com/aspnet/AspNetCore/commit/256aed8369) Make IISExpress shutdown gracefully. (#1066)
* [`[7d12e6bb13]`](https://github.com/aspnet/AspNetCore/commit/7d12e6bb13) Updating external dependencies (#1268)
* [`[e11a33280f]`](https://github.com/aspnet/AspNetCore/commit/e11a33280f) Update the templating submodule
* [`[f1e66b5a6f]`](https://github.com/aspnet/AspNetCore/commit/f1e66b5a6f) Reset LZMA to only include the implicit package version (#1266)
* [`[612fcca729]`](https://github.com/aspnet/AspNetCore/commit/612fcca729) Validate Http/2 pseudo headers #2205 #2263 #2659
* [`[eb6faf1754]`](https://github.com/aspnet/AspNetCore/commit/eb6faf1754) Redo baselines
* [`[8e667ba730]`](https://github.com/aspnet/AspNetCore/commit/8e667ba730) Rename parser tests to have shorter names
* [`[433eeb6943]`](https://github.com/aspnet/AspNetCore/commit/433eeb6943) Abort connection on protocol error (#2654)
* [`[603cd03bfa]`](https://github.com/aspnet/AspNetCore/commit/603cd03bfa) Stop writing responses after the unexpected end of request content (#2734)
* [`[0970888187]`](https://github.com/aspnet/AspNetCore/commit/0970888187) Do not reference AspNetCoreModuleV2 on non-windows (#217)
* [`[b934e46161]`](https://github.com/aspnet/AspNetCore/commit/b934e46161) Complete the transport pipes after connection middleware runs (#2735)
* [`[89fda83bbd]`](https://github.com/aspnet/AspNetCore/commit/89fda83bbd) Move config operations from helpers to functions on the deployment parameters (#1063)
* [`[41f56dbbed]`](https://github.com/aspnet/AspNetCore/commit/41f56dbbed) Minor fix to DefaultLinkGenerator and enabled constraint related tests in DefaultLinkGeneratorTest
* [`[36d90c9bc2]`](https://github.com/aspnet/AspNetCore/commit/36d90c9bc2) Run request service constraint test with dispatching (#8112)
* [`[ec8976ffaf]`](https://github.com/aspnet/AspNetCore/commit/ec8976ffaf) Update MvcEndpointDataSource on raised change token (#8108)
* [`[8260ed6c46]`](https://github.com/aspnet/AspNetCore/commit/8260ed6c46) Update to NETCore.App 2.1.3-servicing-26718-02
* [`[01ce77da56]`](https://github.com/aspnet/AspNetCore/commit/01ce77da56) Rename Web Application to Starter Web Application
* [`[4752d45e0e]`](https://github.com/aspnet/AspNetCore/commit/4752d45e0e) Add the minorVersion field to the HandshakeResponse in the TS client for 3.0 (#2657)
* [`[056da5114a]`](https://github.com/aspnet/AspNetCore/commit/056da5114a) Add partial handshake test (#2630)
* [`[21d9ec64f0]`](https://github.com/aspnet/AspNetCore/commit/21d9ec64f0) Add copy constructor to deployment parameters (#1497)
* [`[97ebe36b13]`](https://github.com/aspnet/AspNetCore/commit/97ebe36b13) Disable client disconnect tests (#1076)
* [`[477296a3cc]`](https://github.com/aspnet/AspNetCore/commit/477296a3cc) Make DFA matcher the default
* [`[badbcb9437]`](https://github.com/aspnet/AspNetCore/commit/badbcb9437) Add MvcEndpointDataSource benchmarks (#8104)
* [`[54471a2930]`](https://github.com/aspnet/AspNetCore/commit/54471a2930) Add client abort tests (#1051)
* [`[400d243f42]`](https://github.com/aspnet/AspNetCore/commit/400d243f42) Fix remaining feature gaps in DfaMatcher (#621)
* [`[7f6b05149d]`](https://github.com/aspnet/AspNetCore/commit/7f6b05149d) Generate deterministic unique ids for tag helpers
* [`[b741743537]`](https://github.com/aspnet/AspNetCore/commit/b741743537) Set IsMet and SkipReason with empty constructor (#1070)
* [`[21f2edce16]`](https://github.com/aspnet/AspNetCore/commit/21f2edce16) Generate and verify baselines for ClassifiedSpans and TagHelperSpans - Moved GetClassifiedSpans and GetTagHelperSpans logic to Razor.Language
* [`[c1fab727a0]`](https://github.com/aspnet/AspNetCore/commit/c1fab727a0) Upgraded dependencies.props
* [`[b5be7b56d9]`](https://github.com/aspnet/AspNetCore/commit/b5be7b56d9) Add Microsoft.AspNetCore.Server.IIS to metapackges (#1263)
* [`[c0e00d65dd]`](https://github.com/aspnet/AspNetCore/commit/c0e00d65dd) Use IntegrationTesting.IIS (#859)
* [`[194ef76432]`](https://github.com/aspnet/AspNetCore/commit/194ef76432) Use IntegrationTesting.IIS (#133)
* [`[074264cd3a]`](https://github.com/aspnet/AspNetCore/commit/074264cd3a) Use less global variables (#1064)
* [`[1196349bf4]`](https://github.com/aspnet/AspNetCore/commit/1196349bf4) [Fixes #583] Handle change events in RouteValueBaseEndpointFinder
* [`[dd252c0ccc]`](https://github.com/aspnet/AspNetCore/commit/dd252c0ccc) Updated dependencies.props to use feature branch versions
* [`[aed2e24483]`](https://github.com/aspnet/AspNetCore/commit/aed2e24483) Allow to pass in HttpContext when generating links
* [`[42218d5fb5]`](https://github.com/aspnet/AspNetCore/commit/42218d5fb5) Versioning with endpoint constraint (#8098)
* [`[02e1d78319]`](https://github.com/aspnet/AspNetCore/commit/02e1d78319) Minor fixes for MatchProcessorFactory
* [`[5f29e8b062]`](https://github.com/aspnet/AspNetCore/commit/5f29e8b062) Hoist path out of loop in BarebonesMatcher
* [`[7c6a60b62b]`](https://github.com/aspnet/AspNetCore/commit/7c6a60b62b) EFCore: Upgrade IX-Async
* [`[3e53533db3]`](https://github.com/aspnet/AspNetCore/commit/3e53533db3) Adding HubConnection State Enum (#2627)
* [`[a2942ce885]`](https://github.com/aspnet/AspNetCore/commit/a2942ce885) Update Intro Video Link (#2637)
* [`[b62499e02c]`](https://github.com/aspnet/AspNetCore/commit/b62499e02c) Ensure PageContext.ViewData and ViewContext.ViewData are the same instance Fixes #7675
* [`[9d951325b2]`](https://github.com/aspnet/AspNetCore/commit/9d951325b2) Re-organize shared src packages so we can do true IVT between src assemblies
* [`[25c65a5d85]`](https://github.com/aspnet/AspNetCore/commit/25c65a5d85) Add HubMessage abstraction and parse messages from the server into different message types (#2620)
* [`[a44007adfb]`](https://github.com/aspnet/AspNetCore/commit/a44007adfb) Fix deadlock in GOAWAY_Received_RelievesConnectionBackpressure (#2724)
* [`[5f065b6670]`](https://github.com/aspnet/AspNetCore/commit/5f065b6670) Fix deadlock in GOAWAY_Received_RelievesConnectionBackpressure (#2724)
* [`[429bcfe216]`](https://github.com/aspnet/AspNetCore/commit/429bcfe216) Sending and receiving RST frames. #2462
* [`[b2e4743c7d]`](https://github.com/aspnet/AspNetCore/commit/b2e4743c7d) Change benchmarks (#612)
* [`[497a38035d]`](https://github.com/aspnet/AspNetCore/commit/497a38035d) Add application startup check that dispatcher is added to request pipeline (#614)
* [`[73e4d55d7b]`](https://github.com/aspnet/AspNetCore/commit/73e4d55d7b) Check dispatcher services registered (#610)
* [`[c657e31b94]`](https://github.com/aspnet/AspNetCore/commit/c657e31b94) Fix Console invalid handle issues. (#1029)
* [`[ef6f326188]`](https://github.com/aspnet/AspNetCore/commit/ef6f326188) Add experimental JumpTables
* [`[9e114b547d]`](https://github.com/aspnet/AspNetCore/commit/9e114b547d) Introduce RoutePattern (#585)
* [`[cfd63e1e2e]`](https://github.com/aspnet/AspNetCore/commit/cfd63e1e2e) Change HTML splitting logic to not split on surrogate pairs.
* [`[6551eae321]`](https://github.com/aspnet/AspNetCore/commit/6551eae321) Consolidate HTTP charset validation logic
* [`[04484527ac]`](https://github.com/aspnet/AspNetCore/commit/04484527ac) Update for 2.1.401-preview (#14)
* [`[bc79a47959]`](https://github.com/aspnet/AspNetCore/commit/bc79a47959) Temporary change to prevent cross repo breaking change: Added ooverload for MatcherEndpoint
* [`[42708bec91]`](https://github.com/aspnet/AspNetCore/commit/42708bec91) Added support for route constraints in Dispatcher world
* [`[b144f3a12f]`](https://github.com/aspnet/AspNetCore/commit/b144f3a12f) Update artifacts.props
* [`[3af5287b66]`](https://github.com/aspnet/AspNetCore/commit/3af5287b66) Make HealthChecks back into shipping packages
* [`[35fad0881b]`](https://github.com/aspnet/AspNetCore/commit/35fad0881b) Mark unused `ParameterBinder.BindModelAsync(...)` overloads as `[Obsolete]` - #7660 - also addresses part of #7317, only in `ComplexTypeModelBinderIntegrationTest`
* [`[f2608c2ff4]`](https://github.com/aspnet/AspNetCore/commit/f2608c2ff4) Do not suppress `ModelValidationState.Invalid` entries - #7992, #7963
* [`[284f6ab458]`](https://github.com/aspnet/AspNetCore/commit/284f6ab458) Add M.A.S.IntegrationTesting.IIS to artifacts.props (#1259)
* [`[7c27818fab]`](https://github.com/aspnet/AspNetCore/commit/7c27818fab) Update for 2.1.302 RTM (#13)
* [`[b359d6bed1]`](https://github.com/aspnet/AspNetCore/commit/b359d6bed1) Fix CI test failures (#1045)
* [`[1c7f53ae39]`](https://github.com/aspnet/AspNetCore/commit/1c7f53ae39) Fix TemplateBinder to consider null and empty string values the same
* [`[7209cab5e9]`](https://github.com/aspnet/AspNetCore/commit/7209cab5e9) Productize JumpTable (#594)
* [`[e69a47f230]`](https://github.com/aspnet/AspNetCore/commit/e69a47f230) Implement patch policies per repo and set default to ProductChangesOnly
* [`[eb7835f4c8]`](https://github.com/aspnet/AspNetCore/commit/eb7835f4c8) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[d8e10d0870]`](https://github.com/aspnet/AspNetCore/commit/d8e10d0870) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[36d7c8ec42]`](https://github.com/aspnet/AspNetCore/commit/36d7c8ec42) Add startup event log for ANCM inproc (#1047)
* [`[a5083d525b]`](https://github.com/aspnet/AspNetCore/commit/a5083d525b) Fix regression with Authorize + IPolicyProvider (#8068)
* [`[0cf972cc43]`](https://github.com/aspnet/AspNetCore/commit/0cf972cc43) Error message on no dispatcher middleware in endpoint middleware (#600)
* [`[aef7ff7959]`](https://github.com/aspnet/AspNetCore/commit/aef7ff7959) Add JwtBearer test for SaveToken #1768
* [`[62bf802971]`](https://github.com/aspnet/AspNetCore/commit/62bf802971) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[10f68863ec]`](https://github.com/aspnet/AspNetCore/commit/10f68863ec) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[47caa67a65]`](https://github.com/aspnet/AspNetCore/commit/47caa67a65) Rewrite JwtBearer token test #640
* [`[c9122a8428]`](https://github.com/aspnet/AspNetCore/commit/c9122a8428) Include AuthenticationTicket.Properties in AuthenticationTicket success result handling #1765 (#1767)
* [`[a452423998]`](https://github.com/aspnet/AspNetCore/commit/a452423998) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[66cac69adf]`](https://github.com/aspnet/AspNetCore/commit/66cac69adf) Updating dependencies to 2.1.2 and adding a section for pinned variable versions
* [`[d8c77335e8]`](https://github.com/aspnet/AspNetCore/commit/d8c77335e8) Reorganize code so Kestrel now produces the Microsoft.Extensions.Buffers.Testing.Sources package
* [`[74667eda9c]`](https://github.com/aspnet/AspNetCore/commit/74667eda9c) Don't specify MainEntryPoint when compiling Razor assembly
* [`[174c5eaa6c]`](https://github.com/aspnet/AspNetCore/commit/174c5eaa6c) Make fewer public API changes
* [`[4f1b7ccca6]`](https://github.com/aspnet/AspNetCore/commit/4f1b7ccca6) Use ModelMetadata from actual types for validation
* [`[f179339a79]`](https://github.com/aspnet/AspNetCore/commit/f179339a79) Combine BufferWriter and CountingBufferWriter
* [`[3042728f8b]`](https://github.com/aspnet/AspNetCore/commit/3042728f8b) Add Microsoft.AspNetCore.Server.IntegrationTesting.IIS (#1253)
* [`[6bed0b7206]`](https://github.com/aspnet/AspNetCore/commit/6bed0b7206) Add Microsoft.AspNetCore.Server.IntegrationTesting.IIS package (#1037)
* [`[e5dfea5725]`](https://github.com/aspnet/AspNetCore/commit/e5dfea5725) Adds project properties and project capabilities to IIS and IISIntegration (#969)
* [`[ba599c49bb]`](https://github.com/aspnet/AspNetCore/commit/ba599c49bb) Be more resiliant to apphost.config issues (#1044)
* [`[c81f379045]`](https://github.com/aspnet/AspNetCore/commit/c81f379045) Normalize file extensions and project structures (#1038)
* [`[85e92ab3cc]`](https://github.com/aspnet/AspNetCore/commit/85e92ab3cc) Added support for route constraints in Dispatcher world
* [`[7aba48ca27]`](https://github.com/aspnet/AspNetCore/commit/7aba48ca27) Add support for httpmethods in swaggatherer
* [`[c367e1d681]`](https://github.com/aspnet/AspNetCore/commit/c367e1d681) Fix dispatching functional tests not using dispatching startup (#8052)
* [`[385f647215]`](https://github.com/aspnet/AspNetCore/commit/385f647215) Allow debug log file to be specified in handler settings; move tests from IISExpress to shared. (#1033)
* [`[dbc930cc78]`](https://github.com/aspnet/AspNetCore/commit/dbc930cc78) ResponseCache attribute on RazorPages Error handler method should be moved to model Fixes #553
* [`[6fde01a825]`](https://github.com/aspnet/AspNetCore/commit/6fde01a825) Replace PortSupportedCondition #2706
* [`[d2a8d3a61c]`](https://github.com/aspnet/AspNetCore/commit/d2a8d3a61c) Fix cookie regression (#1811)
* [`[683e327637]`](https://github.com/aspnet/AspNetCore/commit/683e327637) Pin Microsoft.Extensions.DependencyModel to 2.1.0
* [`[e1f1705d11]`](https://github.com/aspnet/AspNetCore/commit/e1f1705d11) Reenable tests and forward fixture logs (#1034)
* [`[183ecd85d6]`](https://github.com/aspnet/AspNetCore/commit/183ecd85d6) Fix MVC integration with UseEndpoint (#8047)
* [`[a826f478ad]`](https://github.com/aspnet/AspNetCore/commit/a826f478ad) Implement HTTP/2 output flow control (#2690)
* [`[4f81f75777]`](https://github.com/aspnet/AspNetCore/commit/4f81f75777) Updating external dependencies (#1249)
* [`[181e521b40]`](https://github.com/aspnet/AspNetCore/commit/181e521b40) Fix compiler error as a result of merging 2.1.2 into release/2.1
* [`[51c94337d7]`](https://github.com/aspnet/AspNetCore/commit/51c94337d7) /systray:false (#1486)
* [`[11b83dc2b3]`](https://github.com/aspnet/AspNetCore/commit/11b83dc2b3) Rename reg keys from IIS ANCM V1 to V2  (#1017)
* [`[86fed4de5f]`](https://github.com/aspnet/AspNetCore/commit/86fed4de5f) Fix shutdown race (#1031)
* [`[1e7be641ae]`](https://github.com/aspnet/AspNetCore/commit/1e7be641ae) Add some common aliases for conventions
* [`[9ad9ada9ea]`](https://github.com/aspnet/AspNetCore/commit/9ad9ada9ea) Pin to the latest stable 2.1.x corefx packages
* [`[2d4fb0af6f]`](https://github.com/aspnet/AspNetCore/commit/2d4fb0af6f) Add support for registering multiple On handlers (#2599)
* [`[bd995d4cb1]`](https://github.com/aspnet/AspNetCore/commit/bd995d4cb1) [Fixes #7959] Conventional routing with custom templates not working when you have area attributes
* [`[dc2ae93c3f]`](https://github.com/aspnet/AspNetCore/commit/dc2ae93c3f) Add fallback attribute to partial tag helper.
* [`[dee479fda7]`](https://github.com/aspnet/AspNetCore/commit/dee479fda7) Add partial helper to Razor Page \ PageModel
* [`[cbfd791d7b]`](https://github.com/aspnet/AspNetCore/commit/cbfd791d7b) Make facts and theories conditional (#1023)
* [`[3ec66beecd]`](https://github.com/aspnet/AspNetCore/commit/3ec66beecd) Move IIS tests to a test group
* [`[d2bb674b0a]`](https://github.com/aspnet/AspNetCore/commit/d2bb674b0a) Add support for default response (#8028)
* [`[ed7c4e8f5c]`](https://github.com/aspnet/AspNetCore/commit/ed7c4e8f5c) Parser tests clean up
* [`[8ad64d2a35]`](https://github.com/aspnet/AspNetCore/commit/8ad64d2a35) Port IISExpress tests to run on both IIS and IISExpress (#1010)
* [`[931f0754af]`](https://github.com/aspnet/AspNetCore/commit/931f0754af) Do not restore in parallel - workaround for race condition in /t:Restore
* [`[c1fb4479a3]`](https://github.com/aspnet/AspNetCore/commit/c1fb4479a3) Update LZMA to restore netcoreapp2.2 packages
* [`[856ac6cb8d]`](https://github.com/aspnet/AspNetCore/commit/856ac6cb8d) AddSignalR tests (#2600)
* [`[748e992865]`](https://github.com/aspnet/AspNetCore/commit/748e992865) Dygray/handshake versioning (#2520)
* [`[b4fdc5e5c0]`](https://github.com/aspnet/AspNetCore/commit/b4fdc5e5c0) AddSignalR tests (#2600)
* [`[475700209a]`](https://github.com/aspnet/AspNetCore/commit/475700209a) AddSignalR tests
* [`[fa702ff6ef]`](https://github.com/aspnet/AspNetCore/commit/fa702ff6ef) Update AddSignalRCore to respect user registered services (#2434)
* [`[2af13658fc]`](https://github.com/aspnet/AspNetCore/commit/2af13658fc) Unprotect key material with the local cache of certificates before checking the cert store
* [`[73867a086c]`](https://github.com/aspnet/AspNetCore/commit/73867a086c) IIS-Inproc new project cap (#1238)
* [`[e7db3f840b]`](https://github.com/aspnet/AspNetCore/commit/e7db3f840b) Handle pipe name with whitespace properly
* [`[727bd52b64]`](https://github.com/aspnet/AspNetCore/commit/727bd52b64) Add package version to Microsoft.AspNetCore.App in project templates
* [`[724cc3ce88]`](https://github.com/aspnet/AspNetCore/commit/724cc3ce88) Only run fallback logic for dotnet and dotnet.exe (#1004)
* [`[3bdb33ccd4]`](https://github.com/aspnet/AspNetCore/commit/3bdb33ccd4) Sync native calls
* [`[e7d36a42e6]`](https://github.com/aspnet/AspNetCore/commit/e7d36a42e6) Only add environment variables if we are running on win8.1 or above. (#1007)
* [`[b7f666e91b]`](https://github.com/aspnet/AspNetCore/commit/b7f666e91b) Adding Support for On Overloads in Java Client (#2568) (#2583)
* [`[c526f489ce]`](https://github.com/aspnet/AspNetCore/commit/c526f489ce) Adding Support for On Overloads in Java Client (#2568)
* [`[d2d9a47686]`](https://github.com/aspnet/AspNetCore/commit/d2d9a47686) Invoke dotnet vstest directly instead of using the VSTest target
* [`[3efc1eede4]`](https://github.com/aspnet/AspNetCore/commit/3efc1eede4) Set correct event providers for ANCM V2 (#1009)
* [`[cc0e0394ac]`](https://github.com/aspnet/AspNetCore/commit/cc0e0394ac) Add required infrastructure improvements to submodules to support NETStandard.Library 2.0.3
* [`[1895502c48]`](https://github.com/aspnet/AspNetCore/commit/1895502c48) Update the LZMA to include NETStandard.Library 2.0.3
* [`[8b39e98477]`](https://github.com/aspnet/AspNetCore/commit/8b39e98477) Add web.administation to universe (#1233)
* [`[422997a59a]`](https://github.com/aspnet/AspNetCore/commit/422997a59a) [automated] Change default branch to master
* [`[57ff9d0b48]`](https://github.com/aspnet/AspNetCore/commit/57ff9d0b48) [automated] Change default branch to master
* [`[dfd75e939d]`](https://github.com/aspnet/AspNetCore/commit/dfd75e939d) Add full IIS tests (#979)
* [`[335500ab0e]`](https://github.com/aspnet/AspNetCore/commit/335500ab0e) Use ModelMetadata from actual types for validation
* [`[c2fcfabdf3]`](https://github.com/aspnet/AspNetCore/commit/c2fcfabdf3) Add optional property to PartialTagHelper (#7991)
* [`[f9a09372b7]`](https://github.com/aspnet/AspNetCore/commit/f9a09372b7) Converted TagHelperBlockRewriterTest
* [`[f6befb9ed3]`](https://github.com/aspnet/AspNetCore/commit/f6befb9ed3) Added ObjectResult implementation for Unauthorized response
* [`[133d49c57e]`](https://github.com/aspnet/AspNetCore/commit/133d49c57e) Fix Api Explorer not returning type with ActionResult<T> and no type in ProducesResponseTypeAttribute
* [`[7f2a64e32b]`](https://github.com/aspnet/AspNetCore/commit/7f2a64e32b) Razor runtime compilation produces errors if running on a shared runtime that's rolled forward
* [`[65d3787fc4]`](https://github.com/aspnet/AspNetCore/commit/65d3787fc4) Pass parameters to createapplication method (#998)
* [`[984e7826d6]`](https://github.com/aspnet/AspNetCore/commit/984e7826d6) Converted TagHelperParseTreeRewriterTest
* [`[b232a1103a]`](https://github.com/aspnet/AspNetCore/commit/b232a1103a) Prereq for converting tag helper tests
* [`[82f7f2aab8]`](https://github.com/aspnet/AspNetCore/commit/82f7f2aab8) Fix Api Explorer not returning type with ActionResult<T> and no type in ProducesResponseTypeAttribute
* [`[c4d5ef94a9]`](https://github.com/aspnet/AspNetCore/commit/c4d5ef94a9) Razor runtime compilation produces errors if running on a shared runtime that's rolled forward
* [`[dfed3d7563]`](https://github.com/aspnet/AspNetCore/commit/dfed3d7563) Add and use GetEnvironmentVariableValue (#997)
* [`[6c50820a49]`](https://github.com/aspnet/AspNetCore/commit/6c50820a49) Add ANCM to runtime site extension (#210)
* [`[f5f0988baf]`](https://github.com/aspnet/AspNetCore/commit/f5f0988baf) Make handlerSettings optional (#989)
* [`[66cb3d50aa]`](https://github.com/aspnet/AspNetCore/commit/66cb3d50aa) Upgraded dependencies.props
* [`[b9d956df59]`](https://github.com/aspnet/AspNetCore/commit/b9d956df59) Ensure no trailing slashes for LZMA generation
* [`[192e8073ee]`](https://github.com/aspnet/AspNetCore/commit/192e8073ee) Work around `CryptographicException`s thrown in some full framework test runs - always skip affected tests on full framework
* [`[1c1256406e]`](https://github.com/aspnet/AspNetCore/commit/1c1256406e) Update README, config, and scripts to use release/2.2 (#1232)
* [`[942d4d194c]`](https://github.com/aspnet/AspNetCore/commit/942d4d194c) Convert HtmlToCodeSwitchTest
* [`[13585f711f]`](https://github.com/aspnet/AspNetCore/commit/13585f711f) Using Routing feature branch package
* [`[f4bf222099]`](https://github.com/aspnet/AspNetCore/commit/f4bf222099) make audit happier (#2560)
* [`[d1988cf72f]`](https://github.com/aspnet/AspNetCore/commit/d1988cf72f) Add CODEOWNERS file (#1231)
* [`[b84a233d39]`](https://github.com/aspnet/AspNetCore/commit/b84a233d39) Add ability to print debug logs to a file (#954)
* [`[1009705283]`](https://github.com/aspnet/AspNetCore/commit/1009705283) Added a RouteValuesBasedEndpointFinder
* [`[ac31e5ab30]`](https://github.com/aspnet/AspNetCore/commit/ac31e5ab30) [2.1.3] Consistently handle connection aborts (#2619)
* [`[42e8f4abc8]`](https://github.com/aspnet/AspNetCore/commit/42e8f4abc8) Convert HtmlTagsTest to use baselines.
* [`[8211dfff9c]`](https://github.com/aspnet/AspNetCore/commit/8211dfff9c) Convert HtmlErrorTest to use baselines.
* [`[b760c6fceb]`](https://github.com/aspnet/AspNetCore/commit/b760c6fceb) update some packages (#2536)
* [`[bafde7738f]`](https://github.com/aspnet/AspNetCore/commit/bafde7738f) Harden docker detection (#2552)
* [`[4a09d4795e]`](https://github.com/aspnet/AspNetCore/commit/4a09d4795e) Use HandleWrapper and initialize variables for FileOutputManager (#986)
* [`[27780c28ba]`](https://github.com/aspnet/AspNetCore/commit/27780c28ba) Do not override error responses (#985)
* [`[ea96c50dce]`](https://github.com/aspnet/AspNetCore/commit/ea96c50dce) Convert WhitespaceRewriterTest
* [`[ca2d5738d6]`](https://github.com/aspnet/AspNetCore/commit/ca2d5738d6) Automatically generate binding redirects assembly attributes for the Razor VSIX
* [`[8eef4a4bb3]`](https://github.com/aspnet/AspNetCore/commit/8eef4a4bb3) Convert HtmlDocumentTest
* [`[96c5b3c2ae]`](https://github.com/aspnet/AspNetCore/commit/96c5b3c2ae) Update StackExchange.Redis.StrongName version
* [`[67b5588185]`](https://github.com/aspnet/AspNetCore/commit/67b5588185) Convert CSharpWhitespaceHandlingTest to use baselines.
* [`[6b8aac13e0]`](https://github.com/aspnet/AspNetCore/commit/6b8aac13e0) Prepare infrastructure for the 2.1.3 patch
* [`[048a6ec3ea]`](https://github.com/aspnet/AspNetCore/commit/048a6ec3ea) Converted HtmlAttributeTest
* [`[5950928baa]`](https://github.com/aspnet/AspNetCore/commit/5950928baa) Convert CSharpSpecialBlockTest to use baselines.
* [`[4dd4e5ef3e]`](https://github.com/aspnet/AspNetCore/commit/4dd4e5ef3e) Shorten names so MVC repo can be cloned on Windows benchmarks server
* [`[a7fd53b3a3]`](https://github.com/aspnet/AspNetCore/commit/a7fd53b3a3) Convert CSharpNestedStatementsTest
* [`[df22392996]`](https://github.com/aspnet/AspNetCore/commit/df22392996) Convert CSharpImplicitExpressionTest
* [`[d48946c2e0]`](https://github.com/aspnet/AspNetCore/commit/d48946c2e0) Convert CSharpExplicitExpressionTest
* [`[4fda468f06]`](https://github.com/aspnet/AspNetCore/commit/4fda468f06) Convert CSharpSectionTest
* [`[c0929a9002]`](https://github.com/aspnet/AspNetCore/commit/c0929a9002) Convert CSharpErrorTest
* [`[69cfb95b90]`](https://github.com/aspnet/AspNetCore/commit/69cfb95b90) Convert CSharpStatementTest to use baselines.
* [`[25547e80d1]`](https://github.com/aspnet/AspNetCore/commit/25547e80d1) Convert CSharpTemplateTest to use baselines.
* [`[32e0d136f2]`](https://github.com/aspnet/AspNetCore/commit/32e0d136f2) Fix null handle issue on full IIS (#973)
* [`[af1bf0e1c3]`](https://github.com/aspnet/AspNetCore/commit/af1bf0e1c3) caching handlers to avoid heap fregamentation (#967)
* [`[d4b8fee39f]`](https://github.com/aspnet/AspNetCore/commit/d4b8fee39f) Upgraded AngularJS to 6.0
* [`[bc8aae5d50]`](https://github.com/aspnet/AspNetCore/commit/bc8aae5d50) Show errors from Karma (#2545)
* [`[ab27e0bd52]`](https://github.com/aspnet/AspNetCore/commit/ab27e0bd52) Converted CSharpBlockTest to use baselines
* [`[1e58748f59]`](https://github.com/aspnet/AspNetCore/commit/1e58748f59) Converted HtmlBlockTest to use baselines
* [`[a92089d2f9]`](https://github.com/aspnet/AspNetCore/commit/a92089d2f9) Converted CSharpDirectivesTest to use baselines
* [`[b0ce55e6c8]`](https://github.com/aspnet/AspNetCore/commit/b0ce55e6c8) Adding the HubProtocol Layer to the Java Client (#2524)
* [`[bc5f02444b]`](https://github.com/aspnet/AspNetCore/commit/bc5f02444b) Benchmarks and improvements to route value dictionary (#577)
* [`[d318d733c4]`](https://github.com/aspnet/AspNetCore/commit/d318d733c4) StreamInvocationMessage => StreamInvocation Message (#2542)
* [`[754c3b0c2e]`](https://github.com/aspnet/AspNetCore/commit/754c3b0c2e) Fix props files inside Microsoft.AspNetCore.AspNetCoreModule* Nuget packages (#975)
* [`[0f4f1950f1]`](https://github.com/aspnet/AspNetCore/commit/0f4f1950f1) Attempt to make it easier to detect when the request is done (#1021)
* [`[e1af5b8b6d]`](https://github.com/aspnet/AspNetCore/commit/e1af5b8b6d) Array or List in query string does not get parsed #7712 (#7967)
* [`[7101953c1e]`](https://github.com/aspnet/AspNetCore/commit/7101953c1e) Update TagHelperBlockRewriter.cs
* [`[331f0b15cd]`](https://github.com/aspnet/AspNetCore/commit/331f0b15cd) Update ServerConnection.cs
* [`[e3b84fbe85]`](https://github.com/aspnet/AspNetCore/commit/e3b84fbe85) Updating Readme to call run.ps1 install vs.
* [`[0d96354eef]`](https://github.com/aspnet/AspNetCore/commit/0d96354eef) Return static 500.30 file on startup fails for in-process (#934)
* [`[2aea2c6b9f]`](https://github.com/aspnet/AspNetCore/commit/2aea2c6b9f) Use correct newline string when splitting baselines
* [`[554855cab3]`](https://github.com/aspnet/AspNetCore/commit/554855cab3) No CORS headers sent if Exception is thrown
* [`[999c24d78d]`](https://github.com/aspnet/AspNetCore/commit/999c24d78d) Converted more parser tests to baselines - Converted CSharpAutoCompleteTest
* [`[bc345bc8e7]`](https://github.com/aspnet/AspNetCore/commit/bc345bc8e7) Reduce usage of static inprocess application (#962)
* [`[d3d257b90e]`](https://github.com/aspnet/AspNetCore/commit/d3d257b90e) Add tracing to shimconfig (#964)
* [`[aeebcdefc1]`](https://github.com/aspnet/AspNetCore/commit/aeebcdefc1) Switch to tracing macros in application info (#965)
* [`[94a7c83998]`](https://github.com/aspnet/AspNetCore/commit/94a7c83998) Change DefaultApiConventions (#7939)
* [`[928a81155e]`](https://github.com/aspnet/AspNetCore/commit/928a81155e) Add external dependencies used only in MVC benchmarks apps - part of aspnet/Mvc#7805
* [`[32121abde3]`](https://github.com/aspnet/AspNetCore/commit/32121abde3) Fixes exit(0) with hostable webcore (#966)
* [`[9d1ffa2d06]`](https://github.com/aspnet/AspNetCore/commit/9d1ffa2d06) Use guid for temp directories and delete them after tests (#963)
* [`[6911e192e4]`](https://github.com/aspnet/AspNetCore/commit/6911e192e4) Add IsRequired and DefaultValue to ApiParameterDescription
* [`[da206e8afe]`](https://github.com/aspnet/AspNetCore/commit/da206e8afe) Create a separate sln for V1 (#944)
* [`[30fcfb65ea]`](https://github.com/aspnet/AspNetCore/commit/30fcfb65ea) Productionize Path tokenization
* [`[6b3437deb7]`](https://github.com/aspnet/AspNetCore/commit/6b3437deb7) Initial Java Client(#2521)
* [`[a296fe4cdf]`](https://github.com/aspnet/AspNetCore/commit/a296fe4cdf) Add retries for restores during LZMA generation
* [`[6efd679ce3]`](https://github.com/aspnet/AspNetCore/commit/6efd679ce3) Fix TreeMatcher with route constraints (#576)
* [`[de197bfcd1]`](https://github.com/aspnet/AspNetCore/commit/de197bfcd1) Use dynamic ports for Https/Ntlm tests (#874)
* [`[93de3f83ce]`](https://github.com/aspnet/AspNetCore/commit/93de3f83ce) Reenable precompiled headers in AspNetCore project (#937)
* [`[c2874d923d]`](https://github.com/aspnet/AspNetCore/commit/c2874d923d) Add Microsoft.Internal.AspNetCore.H2Spec.All dependency
* [`[61e16e2b31]`](https://github.com/aspnet/AspNetCore/commit/61e16e2b31) Automation for h2spec functional tests #2640
* [`[323e7c7205]`](https://github.com/aspnet/AspNetCore/commit/323e7c7205) Use PartialTagHelper instead of Html.Partial
* [`[d7bcb19c79]`](https://github.com/aspnet/AspNetCore/commit/d7bcb19c79) Update deps
* [`[17d2545b55]`](https://github.com/aspnet/AspNetCore/commit/17d2545b55) Throw if the type parameter for ActionResult<T> is an action result (#7942)
* [`[ea5ed2250d]`](https://github.com/aspnet/AspNetCore/commit/ea5ed2250d) Pin aspnetcore runtime version for LZMA generation
* [`[ed1fa44a3d]`](https://github.com/aspnet/AspNetCore/commit/ed1fa44a3d) Add diagnostics to hostfxrutil (#951)
* [`[2599e0f5cc]`](https://github.com/aspnet/AspNetCore/commit/2599e0f5cc) Fix up a few pieces for the fallback integrity check feature.
* [`[e395b9240a]`](https://github.com/aspnet/AspNetCore/commit/e395b9240a) Add support for SDK 2.1.302 (#12)
* [`[4f7e849cc1]`](https://github.com/aspnet/AspNetCore/commit/4f7e849cc1) Setting up for ApiConventionAttribute analyzers (#7912)
* [`[daebec95f3]`](https://github.com/aspnet/AspNetCore/commit/daebec95f3) Add SdkVersion to Template.ToString() - Documents which SdkVersion was tested
* [`[324565772c]`](https://github.com/aspnet/AspNetCore/commit/324565772c) Prevent app code from blocking the connection loop #2657
* [`[c6cc1ef6d6]`](https://github.com/aspnet/AspNetCore/commit/c6cc1ef6d6) Apply attribute to page model rather than handler
* [`[db95a8c624]`](https://github.com/aspnet/AspNetCore/commit/db95a8c624) Add more matcher tests
* [`[7977793d4f]`](https://github.com/aspnet/AspNetCore/commit/7977793d4f) Catch all exceptions on ANCM/IIS border (#864)
* [`[1e823d88e2]`](https://github.com/aspnet/AspNetCore/commit/1e823d88e2) Ignore case on handlerVersion (#941)
* [`[0a97bf9ae8]`](https://github.com/aspnet/AspNetCore/commit/0a97bf9ae8) Use lock wrapper in shim (#936)
* [`[bac1b1e8b6]`](https://github.com/aspnet/AspNetCore/commit/bac1b1e8b6) Readd update schema to jenkins agents (#942)
* [`[8a69fb7f51]`](https://github.com/aspnet/AspNetCore/commit/8a69fb7f51) Upgrade Deps (#2514)
* [`[e7ab81fe0b]`](https://github.com/aspnet/AspNetCore/commit/e7ab81fe0b) Ensure analyzer package is referenced by Microsoft.AspNetCore.Mvc
* [`[b821ce8b8e]`](https://github.com/aspnet/AspNetCore/commit/b821ce8b8e) First step in converting parser tests to use baselines - Added the necessary infrastructure to serialize and verify the syntax tree - Updated ParserVisitor to be overrideable - Made CSharpVerbatimBlockTest to use baselines
* [`[17e3aa8ee4]`](https://github.com/aspnet/AspNetCore/commit/17e3aa8ee4) Handle pipe name with whitespace properly
* [`[4812929127]`](https://github.com/aspnet/AspNetCore/commit/4812929127) Added benchmarks for syntax tree generation
* [`[a159cadf18]`](https://github.com/aspnet/AspNetCore/commit/a159cadf18) Dispose server before checking test sink (#940)
* [`[3547341762]`](https://github.com/aspnet/AspNetCore/commit/3547341762) Add support for conventional routes with dispatching (#7928)
* [`[2b269e0433]`](https://github.com/aspnet/AspNetCore/commit/2b269e0433) Set Min OS version for ALPN tests at Win 8.1.
* [`[af99b9a10c]`](https://github.com/aspnet/AspNetCore/commit/af99b9a10c) Add Empty Java Project for New Client(#2499)
* [`[9677553a33]`](https://github.com/aspnet/AspNetCore/commit/9677553a33) Don't specify MainEntryPoint when compiling Razor assembly
* [`[99f1db7bdc]`](https://github.com/aspnet/AspNetCore/commit/99f1db7bdc) Add TLS Filter sample #2251
* [`[60711bfca1]`](https://github.com/aspnet/AspNetCore/commit/60711bfca1) Use std::filesystem in hostfxr utilities (#926)
* [`[17fdbf6514]`](https://github.com/aspnet/AspNetCore/commit/17fdbf6514) pdbs in content files (#938)
* [`[38c3606685]`](https://github.com/aspnet/AspNetCore/commit/38c3606685) Adds pdbs (and other files) to testing package (#929)
* [`[58aa16ee69]`](https://github.com/aspnet/AspNetCore/commit/58aa16ee69) Centralize routing and dispatching functional test logic (#7938)
* [`[a0a9c2c585]`](https://github.com/aspnet/AspNetCore/commit/a0a9c2c585) Integrate Dispatcher's link generator Related to https://github.com/aspnet/Routing/issues/530
* [`[41fad8a33a]`](https://github.com/aspnet/AspNetCore/commit/41fad8a33a) Don't smart indent code inside of Razor block constructs.
* [`[ccfd5f80b7]`](https://github.com/aspnet/AspNetCore/commit/ccfd5f80b7) Pin runtime version for LZMA generation
* [`[1aa15374b5]`](https://github.com/aspnet/AspNetCore/commit/1aa15374b5) Add partial parsing of `@functions` directive body.
* [`[c498f03cb4]`](https://github.com/aspnet/AspNetCore/commit/c498f03cb4) Expose Tls details as a feature. #2661 Limit Http/2 to TLS 1.2 #2251 Bootstrap functional tests #2238
* [`[4634a97fae]`](https://github.com/aspnet/AspNetCore/commit/4634a97fae) Use older shared runtime
* [`[a712ccc98a]`](https://github.com/aspnet/AspNetCore/commit/a712ccc98a) Fix up error message when compilation references are missing
* [`[94d4f9d2fc]`](https://github.com/aspnet/AspNetCore/commit/94d4f9d2fc) Add OSX Jenkins
* [`[8672b1b04a]`](https://github.com/aspnet/AspNetCore/commit/8672b1b04a) Inherit web IHostingEnvironment and IApplicationEnvironment from the Generic Host one (#1461)
* [`[5b8db03a57]`](https://github.com/aspnet/AspNetCore/commit/5b8db03a57) Fixing up a few small issues
* [`[00e99dbbb2]`](https://github.com/aspnet/AspNetCore/commit/00e99dbbb2) Flesh out experimental matchers
* [`[a57b7c4d7f]`](https://github.com/aspnet/AspNetCore/commit/a57b7c4d7f) Don't discover tag helpers if some references are missing
* [`[d6f3a1bd22]`](https://github.com/aspnet/AspNetCore/commit/d6f3a1bd22) Enable using directive IntelliSense auto-completion.
* [`[af63afdae7]`](https://github.com/aspnet/AspNetCore/commit/af63afdae7) Add partial parsing for parenthesis
* [`[bc49a82d02]`](https://github.com/aspnet/AspNetCore/commit/bc49a82d02) Use feature branch package of Localization
* [`[14f020cf11]`](https://github.com/aspnet/AspNetCore/commit/14f020cf11) Improve tracking of connection lifetime (#2646)
* [`[738553931e]`](https://github.com/aspnet/AspNetCore/commit/738553931e) Update windows image to one that has VSIX compatible workloads.
* [`[e4e9bd1a3c]`](https://github.com/aspnet/AspNetCore/commit/e4e9bd1a3c) Flow a cancellation token in to AsChannelReader (#2491)
* [`[7a93d69354]`](https://github.com/aspnet/AspNetCore/commit/7a93d69354) Adds shared request handler lib project (#916)
* [`[d3ddc1709a]`](https://github.com/aspnet/AspNetCore/commit/d3ddc1709a) Added initial support for link generation when using Dispatcher
* [`[f94f6b73ef]`](https://github.com/aspnet/AspNetCore/commit/f94f6b73ef) fix running Functional Tests in the browser (#2494)
* [`[35d9590f3c]`](https://github.com/aspnet/AspNetCore/commit/35d9590f3c) Prevent double-close race condition in ListenHandleTests.CanListenToOpenTcpSocketHandle() (#2666)
* [`[a7406d4497]`](https://github.com/aspnet/AspNetCore/commit/a7406d4497) Add MvcEndpointDataSource and functional tests (#7886)
* [`[e2e13eb718]`](https://github.com/aspnet/AspNetCore/commit/e2e13eb718) Update templating submodule
* [`[da14806d9e]`](https://github.com/aspnet/AspNetCore/commit/da14806d9e) Make content files include subdirectory dlls.
* [`[d218881f5f]`](https://github.com/aspnet/AspNetCore/commit/d218881f5f) Fix nuspec file path to out of proc request handler. (#914)
* [`[aa91b802f9]`](https://github.com/aspnet/AspNetCore/commit/aa91b802f9) Add script used to deploy blobs to Azure storage
* [`[287a3c5e69]`](https://github.com/aspnet/AspNetCore/commit/287a3c5e69) Allow IgnoreAntiForgeryToken applied on Razor Page models to work
* [`[13663e1e15]`](https://github.com/aspnet/AspNetCore/commit/13663e1e15) Convert to using definitions from HeaderNames
* [`[9efa7665c9]`](https://github.com/aspnet/AspNetCore/commit/9efa7665c9) Fix endpoint constraint cache (#555)
* [`[cafb1c3c90]`](https://github.com/aspnet/AspNetCore/commit/cafb1c3c90) Update Identity and Kestrel submodules
* [`[c3989f8477]`](https://github.com/aspnet/AspNetCore/commit/c3989f8477) Update to .NET Core App 2.0.9-servicing-26612-03
* [`[e4e3551a1e]`](https://github.com/aspnet/AspNetCore/commit/e4e3551a1e) Prepare 2.1.2 patch
* [`[9d97ff38f8]`](https://github.com/aspnet/AspNetCore/commit/9d97ff38f8) Load ANCM out of process via global versioning (#895)
* [`[c7af64332b]`](https://github.com/aspnet/AspNetCore/commit/c7af64332b) change to use Karma for Functional Tests (#2450)
* [`[cb8264321d]`](https://github.com/aspnet/AspNetCore/commit/cb8264321d) Add VerifyLogger to JS tests (#2472)
* [`[28d1bc4fa2]`](https://github.com/aspnet/AspNetCore/commit/28d1bc4fa2) Fix TreeMatcher's use of EndpointSelector (#551)
* [`[05a6e42fe7]`](https://github.com/aspnet/AspNetCore/commit/05a6e42fe7) Upgrade IntegrationTesting version to prevent hang during "dotnet publish" (#902)
* [`[6c2ef122f8]`](https://github.com/aspnet/AspNetCore/commit/6c2ef122f8) Add support for conventions in DefaultApiDescriptionProvider
* [`[c5de0e1892]`](https://github.com/aspnet/AspNetCore/commit/c5de0e1892) Pass timeout to WaitForExit() on "dotnet publish" (#1453)
* [`[dc76027a7a]`](https://github.com/aspnet/AspNetCore/commit/dc76027a7a) Generate line pragmas even for whitespace.
* [`[84bc8351c9]`](https://github.com/aspnet/AspNetCore/commit/84bc8351c9) Initial endpoint constraints functionality (#548)
* [`[a217206f1f]`](https://github.com/aspnet/AspNetCore/commit/a217206f1f) Enforce max frame size #2651
* [`[7317762b29]`](https://github.com/aspnet/AspNetCore/commit/7317762b29) fix #2407 by tslinting tests before running (#2459)
* [`[c7ebae47ea]`](https://github.com/aspnet/AspNetCore/commit/c7ebae47ea) Show detailed error message for HubExceptions (#2461)
* [`[810a302e66]`](https://github.com/aspnet/AspNetCore/commit/810a302e66) Disable AllowRenegotiation for HTTP/2
* [`[0306038658]`](https://github.com/aspnet/AspNetCore/commit/0306038658) Return empty string for connectionId in some cases (#2470)
* [`[b2ec939006]`](https://github.com/aspnet/AspNetCore/commit/b2ec939006) Make brace indenter smarter about making edits to non-valid content kinds.
* [`[e403187be3]`](https://github.com/aspnet/AspNetCore/commit/e403187be3) ResponseCache attribute on RazorPages Error handler method should be moved to model Fixes #553
* [`[ad07036020]`](https://github.com/aspnet/AspNetCore/commit/ad07036020) Use checksum for classname if filepath is null
* [`[08f12f2bfd]`](https://github.com/aspnet/AspNetCore/commit/08f12f2bfd) Add sample matcher tests
* [`[d3ceb777ef]`](https://github.com/aspnet/AspNetCore/commit/d3ceb777ef) Adding Microsoft.AspNetCoreSignalR.Specification.Tests (#1204)
* [`[dd64e4d9a5]`](https://github.com/aspnet/AspNetCore/commit/dd64e4d9a5) Clean up Spec Test dependencies (#2451)
* [`[203258d00e]`](https://github.com/aspnet/AspNetCore/commit/203258d00e) Update AnchorTagHelper.cs
* [`[c29527f992]`](https://github.com/aspnet/AspNetCore/commit/c29527f992) Add some assertions for controllers and controller actions
* [`[3f3bfe05ec]`](https://github.com/aspnet/AspNetCore/commit/3f3bfe05ec) Add a test condition for skipping tests when the default keychain is missing for macOS
* [`[25bbb466db]`](https://github.com/aspnet/AspNetCore/commit/25bbb466db) Create compressed delta lzma for antares
* [`[1b470f3d3b]`](https://github.com/aspnet/AspNetCore/commit/1b470f3d3b) Fix Endpoint order in TreeMatcher (#542)
* [`[e41764c161]`](https://github.com/aspnet/AspNetCore/commit/e41764c161) Update AddSignalRCore to respect user registered services (#2434)
* [`[6a39c161c5]`](https://github.com/aspnet/AspNetCore/commit/6a39c161c5) Add VSTS ci pipeline
* [`[00827e38bb]`](https://github.com/aspnet/AspNetCore/commit/00827e38bb) Harden TFM checks #2624
* [`[48dd7a9688]`](https://github.com/aspnet/AspNetCore/commit/48dd7a9688) Fix log order (#540)
* [`[cf24fb23e7]`](https://github.com/aspnet/AspNetCore/commit/cf24fb23e7) Fix bug in generating .version file in the shared frameworks
* [`[707f6b3e28]`](https://github.com/aspnet/AspNetCore/commit/707f6b3e28) Adding Microsoft.AspNetCore.SignalR.Specification.Tests (#1202)
* [`[08b55caa22]`](https://github.com/aspnet/AspNetCore/commit/08b55caa22) Upgrade dependencies
* [`[21f8ce5e95]`](https://github.com/aspnet/AspNetCore/commit/21f8ce5e95) Initial DispatcherMiddleware tests (#529)
* [`[edf26be1bf]`](https://github.com/aspnet/AspNetCore/commit/edf26be1bf) move feature around
* [`[49f839a286]`](https://github.com/aspnet/AspNetCore/commit/49f839a286) Add benchmarks for matcher implementations
* [`[aef5dc4e93]`](https://github.com/aspnet/AspNetCore/commit/aef5dc4e93) Add Swaggatherer (Swagger + Gatherer)
* [`[648705f648]`](https://github.com/aspnet/AspNetCore/commit/648705f648) Create a  Public Test Suite for HubLifetimeManager implementations (#2353)
* [`[b27f032b43]`](https://github.com/aspnet/AspNetCore/commit/b27f032b43) Fix EndpointMetadataCollection filename (#528)
* [`[a1ba1f0f86]`](https://github.com/aspnet/AspNetCore/commit/a1ba1f0f86) Add more diagnostics to FileThumbPrint
* [`[1c3245abc8]`](https://github.com/aspnet/AspNetCore/commit/1c3245abc8) List external dependency for Microsoft.NETCore.DotNetAppHost 2.1.0
* [`[592ed3b4f5]`](https://github.com/aspnet/AspNetCore/commit/592ed3b4f5) Create an analyzer to warn users not to decorate filters on page handler methods
* [`[84a1aa4160]`](https://github.com/aspnet/AspNetCore/commit/84a1aa4160) Update windows image to one that has VSIX compatible workloads.
* [`[3d0f68b22c]`](https://github.com/aspnet/AspNetCore/commit/3d0f68b22c) server closes connections that have gone silent (#2364)
* [`[a5bb91c2cb]`](https://github.com/aspnet/AspNetCore/commit/a5bb91c2cb) Prevent 2.1 template tests from corrupting machine state
* [`[e1b08b2739]`](https://github.com/aspnet/AspNetCore/commit/e1b08b2739) Removing dependency on redux-mock-store.
* [`[f7a9b6f6a3]`](https://github.com/aspnet/AspNetCore/commit/f7a9b6f6a3) Fixing issue in the react and redux template where the test would fail as its not wrapped in a router.
* [`[1822992354]`](https://github.com/aspnet/AspNetCore/commit/1822992354) Fix null ref on ExeLocation not being set (#884)
* [`[ef071f605f]`](https://github.com/aspnet/AspNetCore/commit/ef071f605f) Make gtest a submodule (#885)
* [`[704ad8086d]`](https://github.com/aspnet/AspNetCore/commit/704ad8086d) Update description of script [ci skip]
* [`[948ebf34ec]`](https://github.com/aspnet/AspNetCore/commit/948ebf34ec) Add Redis support to E2E benchmarks (#2418)
* [`[c2a267b085]`](https://github.com/aspnet/AspNetCore/commit/c2a267b085) Update branch name and description of dotnet-maestro-bot prs
* [`[c98b2d1089]`](https://github.com/aspnet/AspNetCore/commit/c98b2d1089) Allow specifying commit message for auto-generated commits
* [`[2fed6710a9]`](https://github.com/aspnet/AspNetCore/commit/2fed6710a9) Added benchmark and test for dispatcher
* [`[dc4be30d88]`](https://github.com/aspnet/AspNetCore/commit/dc4be30d88) Rename Treenumerator -> TreeEnumerator
* [`[0ea16ddd57]`](https://github.com/aspnet/AspNetCore/commit/0ea16ddd57) Code dump of dispatcher prototype code
* [`[0aff4a0440]`](https://github.com/aspnet/AspNetCore/commit/0aff4a0440) Handle client and server aborts differently from eachhother (#2612)
* [`[10efae64e0]`](https://github.com/aspnet/AspNetCore/commit/10efae64e0) Add WebSocket and EventSource polyfills to options (#2408)
* [`[f09edb3b5d]`](https://github.com/aspnet/AspNetCore/commit/f09edb3b5d) Target c++17 (#881)
* [`[34725c0117]`](https://github.com/aspnet/AspNetCore/commit/34725c0117) Update implicit version of aspnetcore.app for tests
* [`[acea87a617]`](https://github.com/aspnet/AspNetCore/commit/acea87a617) IUrlHelper and support for RouteOptions.LowercaseUrls
* [`[cb77c17cf4]`](https://github.com/aspnet/AspNetCore/commit/cb77c17cf4) TestCase added and  IUrlHelper and support for RouteOptions.LowercaseUrls
* [`[f227cbeca3]`](https://github.com/aspnet/AspNetCore/commit/f227cbeca3) Added sperate option "IUrlHelper and support for RouteOptions.LowercaseUrls "
* [`[695fb00308]`](https://github.com/aspnet/AspNetCore/commit/695fb00308) IUrlHelper and support for RouteOptions.LowercaseUrls
* [`[72a7c31973]`](https://github.com/aspnet/AspNetCore/commit/72a7c31973) Upgrade benchmarks project
* [`[eaa5e30132]`](https://github.com/aspnet/AspNetCore/commit/eaa5e30132) Add LiveShare test project to IVT.
* [`[e4d290b601]`](https://github.com/aspnet/AspNetCore/commit/e4d290b601) Fix Json regression in Socket Transport (#2578)
* [`[4f85ca2b1d]`](https://github.com/aspnet/AspNetCore/commit/4f85ca2b1d) Add connection ID scope to HubConnection (#2394)
* [`[d1416e679b]`](https://github.com/aspnet/AspNetCore/commit/d1416e679b) [2.1.1] Provide clearer exception message for breaking change (#2623)
* [`[af177c5adc]`](https://github.com/aspnet/AspNetCore/commit/af177c5adc) Add Memory<byte> overloads to HttpUpgradeStream (#2622)
* [`[28dad2b2b1]`](https://github.com/aspnet/AspNetCore/commit/28dad2b2b1) Unskip and fix race in ConnectionClosedEvenIfAppSwallowsException (#2632)
* [`[8d55a447d4]`](https://github.com/aspnet/AspNetCore/commit/8d55a447d4) Allow running some IIS Express variants without publishing #1431
* [`[c801671fbf]`](https://github.com/aspnet/AspNetCore/commit/c801671fbf) Stop producing old-style rpm/deb installers (#1191)
* [`[591ce7b1e8]`](https://github.com/aspnet/AspNetCore/commit/591ce7b1e8) Fixed scenario name in benchmarks app
* [`[60f63cf9fb]`](https://github.com/aspnet/AspNetCore/commit/60f63cf9fb) Added a sample app for benchmarks
* [`[f0c552ee49]`](https://github.com/aspnet/AspNetCore/commit/f0c552ee49) Fixup DebuggerDisplay for PageActionDescriptor
* [`[309e9e3077]`](https://github.com/aspnet/AspNetCore/commit/309e9e3077) Widen dependency version range on Microsoft.AspNetCore.App to allow patch updates (#1186)
* [`[5d37d312e0]`](https://github.com/aspnet/AspNetCore/commit/5d37d312e0) Add Content-Type header in HttpClient.ts (#2242) (#2413)
* [`[9e15b2bca4]`](https://github.com/aspnet/AspNetCore/commit/9e15b2bca4) Fix PipeReader consumption pattern [2.1]
* [`[d2025d516c]`](https://github.com/aspnet/AspNetCore/commit/d2025d516c) Update implementation
* [`[4935711bce]`](https://github.com/aspnet/AspNetCore/commit/4935711bce) Add trailing slash to <DotNetAssetRootUrl>
* [`[30a59f6df7]`](https://github.com/aspnet/AspNetCore/commit/30a59f6df7)  TypeScript strict mode (#2388)
* [`[3ef5a9048d]`](https://github.com/aspnet/AspNetCore/commit/3ef5a9048d) Update deps
* [`[488fff41a7]`](https://github.com/aspnet/AspNetCore/commit/488fff41a7) Deploy tests the same way we do for RazorSdk
* [`[a5fb8a3d3c]`](https://github.com/aspnet/AspNetCore/commit/a5fb8a3d3c) [Fixes #523] Fix the jquery.min.js file in RazorPages web application
* [`[4f5b358ba8]`](https://github.com/aspnet/AspNetCore/commit/4f5b358ba8) Added tests to verify fallback source content is same as the CDN content
* [`[54fe5f73ca]`](https://github.com/aspnet/AspNetCore/commit/54fe5f73ca) [Fixes #528] Windows authentication is not applied on launchSettings.json
* [`[74883b2cf0]`](https://github.com/aspnet/AspNetCore/commit/74883b2cf0) [Fixes #528] Windows authentication is not applied on launchSettings.json
* [`[da8ca36fe8]`](https://github.com/aspnet/AspNetCore/commit/da8ca36fe8) Pin to stable 2.1.0 corefx packages (#1188)
* [`[7e43d35049]`](https://github.com/aspnet/AspNetCore/commit/7e43d35049) Make ListenOptions.Protocols public again for HTTP/2 work
* [`[f953d70d75]`](https://github.com/aspnet/AspNetCore/commit/f953d70d75) Update to 2.1.1
* [`[7579b6db68]`](https://github.com/aspnet/AspNetCore/commit/7579b6db68) Install 2.1.0
* [`[71fb3b2f6a]`](https://github.com/aspnet/AspNetCore/commit/71fb3b2f6a) Fix version coherence check to filter out non-package artifacts
* [`[56d69db0fa]`](https://github.com/aspnet/AspNetCore/commit/56d69db0fa) Add Razor document tracking to FallbackRazorProjectHost.
* [`[faf600ce71]`](https://github.com/aspnet/AspNetCore/commit/faf600ce71) Fixup the effect of cascading versions (#1187)
* [`[c976d0aa6e]`](https://github.com/aspnet/AspNetCore/commit/c976d0aa6e) [2.1.1] Gracefully handle disposing while writing (#2180) (#2355)
* [`[0452f460c6]`](https://github.com/aspnet/AspNetCore/commit/0452f460c6)  Fix not reading to end of argument JSON on binding error (#2319) (#2360)
* [`[2d63669695]`](https://github.com/aspnet/AspNetCore/commit/2d63669695) [Fixes #7609] ApiBehaviorApplicationModelProvider overwrites existing BindingInfo in entirety when inferring binding sources
* [`[3c72da941f]`](https://github.com/aspnet/AspNetCore/commit/3c72da941f) Update WebApi.Client package version
* [`[5ec7bacdfe]`](https://github.com/aspnet/AspNetCore/commit/5ec7bacdfe) Lower severity of AuthenticationException logs from SslStream handshake (#2614)
* [`[b08163d3b7]`](https://github.com/aspnet/AspNetCore/commit/b08163d3b7) [2.1.1] Use TaskCreationOptions.RunContinuationsAsynchronously a lot (#2618)
* [`[cdbcfb7a05]`](https://github.com/aspnet/AspNetCore/commit/cdbcfb7a05) Fixup references to versions in vsix
* [`[984cd46c4d]`](https://github.com/aspnet/AspNetCore/commit/984cd46c4d) Fix ActionMethodExecutor incorrectly setting DeclaredType on ObjectResult
* [`[0f12047271]`](https://github.com/aspnet/AspNetCore/commit/0f12047271) Fix dependency versions for Hosting and Mvc.RazorPages
* [`[81355b508b]`](https://github.com/aspnet/AspNetCore/commit/81355b508b) Add Razor to the list of patching repos
* [`[632425d0e6]`](https://github.com/aspnet/AspNetCore/commit/632425d0e6) Unskip skipped tests
* [`[508e66ece6]`](https://github.com/aspnet/AspNetCore/commit/508e66ece6) Submodule gtest (#2391)
* [`[3fa10f92ad]`](https://github.com/aspnet/AspNetCore/commit/3fa10f92ad) Fix losing UTC DateTimeKind on ISO8601 UTC values (#2317) (#2357)
* [`[8e31319215]`](https://github.com/aspnet/AspNetCore/commit/8e31319215) Prevent null refs in some simple cases in CachedExpressionCompiler
* [`[9b7f097870]`](https://github.com/aspnet/AspNetCore/commit/9b7f097870) Add aspnet tools myget feed
* [`[28a859605f]`](https://github.com/aspnet/AspNetCore/commit/28a859605f) Override MicrosoftNETCoreApp22PackageVersion
* [`[0769734e67]`](https://github.com/aspnet/AspNetCore/commit/0769734e67) Update to NETCore.App 2.2.0-preview1-26529-01 (#1183)
* [`[823630c508]`](https://github.com/aspnet/AspNetCore/commit/823630c508) Add webpack 4 support to aspnet-webpack
* [`[edf4e8fd9e]`](https://github.com/aspnet/AspNetCore/commit/edf4e8fd9e) DataAnnotations of Enum values use DataAnnotationLocalizerProvider
* [`[f0f1df9b4a]`](https://github.com/aspnet/AspNetCore/commit/f0f1df9b4a) PingInterval -> KeepAliveInterval (#2384)
* [`[e3835b3c94]`](https://github.com/aspnet/AspNetCore/commit/e3835b3c94) ping timeout changes (#2375)
* [`[b7e05e453b]`](https://github.com/aspnet/AspNetCore/commit/b7e05e453b) Try to fix Jenkins (#870)
* [`[eb175b8291]`](https://github.com/aspnet/AspNetCore/commit/eb175b8291) Updating external dependencies (#1181)
* [`[a3300a6a60]`](https://github.com/aspnet/AspNetCore/commit/a3300a6a60) Add try..finally around RunAsync and WaitForTokenShutdownAsync #1194
* [`[ff5b69fd5e]`](https://github.com/aspnet/AspNetCore/commit/ff5b69fd5e) Updating external dependencies (#1179)
* [`[4e41cf6a84]`](https://github.com/aspnet/AspNetCore/commit/4e41cf6a84) Updating external dependencies (#1179)
* [`[94e0ecca73]`](https://github.com/aspnet/AspNetCore/commit/94e0ecca73) Compiling a 2.1.0 project targeting desktop with a reference to the ViewCompilation package produces a warning about mismatch in architectures
* [`[9008abdd09]`](https://github.com/aspnet/AspNetCore/commit/9008abdd09) Update gtest (#862)
* [`[e93b66aaf6]`](https://github.com/aspnet/AspNetCore/commit/e93b66aaf6) Add Spanish language Jenkins configuration
* [`[418aac57f4]`](https://github.com/aspnet/AspNetCore/commit/418aac57f4) [Fixes #7609] ApiBehaviorApplicationModelProvider overwrites existing BindingInfo in entirety when inferring binding sources
* [`[a42f9d28be]`](https://github.com/aspnet/AspNetCore/commit/a42f9d28be) Don't police netcoreapp version
* [`[48a9013e08]`](https://github.com/aspnet/AspNetCore/commit/48a9013e08) Do not overwrite ContentRoot #267
* [`[83134227ab]`](https://github.com/aspnet/AspNetCore/commit/83134227ab) Add support for DOTNET_WATCH_ITERATION (#443)
* [`[1e143c71c6]`](https://github.com/aspnet/AspNetCore/commit/1e143c71c6) Add Hostable Web Core based inprocess test server  (#853)
* [`[7b64e41ed9]`](https://github.com/aspnet/AspNetCore/commit/7b64e41ed9) Collect latency values by default for benchmark runs (#2365)
* [`[176704fe50]`](https://github.com/aspnet/AspNetCore/commit/176704fe50) Updating external dependencies (#1177)
* [`[6c927d093b]`](https://github.com/aspnet/AspNetCore/commit/6c927d093b) End to end versioning tests (#2354)
* [`[5c633aa183]`](https://github.com/aspnet/AspNetCore/commit/5c633aa183) Log 404 responses from long polling transport DELETE as Debug instead of Error (#2366)
* [`[ad55661ceb]`](https://github.com/aspnet/AspNetCore/commit/ad55661ceb) update package.json versions, just for kicks
* [`[23cb0c90b2]`](https://github.com/aspnet/AspNetCore/commit/23cb0c90b2) Enable jenkins tests (#855)
* [`[f70088c2d9]`](https://github.com/aspnet/AspNetCore/commit/f70088c2d9) Don't block so many threads in HeartbeatTests (#2610)
* [`[6cf45a4f8a]`](https://github.com/aspnet/AspNetCore/commit/6cf45a4f8a) Prepare the 2.1.1 patch
* [`[76e6d0279b]`](https://github.com/aspnet/AspNetCore/commit/76e6d0279b) add publish-apps script
* [`[736b7f5042]`](https://github.com/aspnet/AspNetCore/commit/736b7f5042) Client pings server on interval (#2309)
* [`[1dea860997]`](https://github.com/aspnet/AspNetCore/commit/1dea860997) Prepare the 2.0.9 patch
* [`[61376db9aa]`](https://github.com/aspnet/AspNetCore/commit/61376db9aa) Updating external dependencies (#1173)
* [`[4fb42482d9]`](https://github.com/aspnet/AspNetCore/commit/4fb42482d9) Add myget.org aspnetcore-tools to Nuget.config
* [`[b6fedd6ea0]`](https://github.com/aspnet/AspNetCore/commit/b6fedd6ea0) Enable x86 test
* [`[09d3b32fe5]`](https://github.com/aspnet/AspNetCore/commit/09d3b32fe5) Enable x86 testing #949
* [`[cf684a1e8f]`](https://github.com/aspnet/AspNetCore/commit/cf684a1e8f) Re-enable IPv6 test
* [`[bb6657f3f6]`](https://github.com/aspnet/AspNetCore/commit/bb6657f3f6) Re-enable x86 test variants
* [`[0f18ff1b9f]`](https://github.com/aspnet/AspNetCore/commit/0f18ff1b9f) Include AuthenticationTicket.Properties in AuthenticationTicket success result handling #1765 (#1767)
* [`[5c69566b8b]`](https://github.com/aspnet/AspNetCore/commit/5c69566b8b) Updating external dependencies (#1172)
* [`[93d8a93498]`](https://github.com/aspnet/AspNetCore/commit/93d8a93498) Enable serialization of `TagHelperDescriptor`s.
* [`[de9c5b3909]`](https://github.com/aspnet/AspNetCore/commit/de9c5b3909) netcoreapp22 status
* [`[a9d6cf13eb]`](https://github.com/aspnet/AspNetCore/commit/a9d6cf13eb) Consistently handle connection resets (#2547)
* [`[76bd523092]`](https://github.com/aspnet/AspNetCore/commit/76bd523092) Updating external dependencies (#1122)
* [`[f9d4fba39d]`](https://github.com/aspnet/AspNetCore/commit/f9d4fba39d) Added a taghelpers and imports overload to Process and ProcessDesignTime We want to have a way to specify the taghelper descriptors and imports to use while processing a specific document. - Added an overload to Process and ProcessDesignTime to take in a list TagHelperDescriptors and a list of imports - Added the corresponding CreateCodeDocumentCore overload - Added GetTagHelpers and SetTagHelpers extension methods for CodeDocument - Added the necessary plumbing to use the taghelpers from the CodeDocument when available and fallback logic. - Added DocumentImportsTracker and updated background code generation logic to use the new overload - Added/updated tests
* [`[49c653ed0b]`](https://github.com/aspnet/AspNetCore/commit/49c653ed0b) Infer BindingSource.FormFile for IEnumerable<IFormFile>
* [`[077b1d87a9]`](https://github.com/aspnet/AspNetCore/commit/077b1d87a9) #7024 Request: ServiceBasedPageModelActivatorProvider [Review Changes]
* [`[b8e5036e20]`](https://github.com/aspnet/AspNetCore/commit/b8e5036e20) #7024 Request: ServiceBasedPageModelActivatorProvider
* [`[0c795c4f33]`](https://github.com/aspnet/AspNetCore/commit/0c795c4f33) #7024  Request: ServiceBasedPageModelActivatorProvider
* [`[380a153405]`](https://github.com/aspnet/AspNetCore/commit/380a153405) Clarify record separator usage (#2345)
* [`[e8f9119d4b]`](https://github.com/aspnet/AspNetCore/commit/e8f9119d4b) Enable test file logging on Jenkins (#2588)
* [`[b1194f67e7]`](https://github.com/aspnet/AspNetCore/commit/b1194f67e7) Increase logging in flakey CanCloseStreamMethodEarly test (#2330)
* [`[1ff2e7022f]`](https://github.com/aspnet/AspNetCore/commit/1ff2e7022f) Fix local VSIX creation.
* [`[9817985268]`](https://github.com/aspnet/AspNetCore/commit/9817985268) Use VS15.8 Preview 2 version of Roslyn for tooling.
* [`[4ac8b21978]`](https://github.com/aspnet/AspNetCore/commit/4ac8b21978) Fix dispose logic for EditorDocument
* [`[a35ef53891]`](https://github.com/aspnet/AspNetCore/commit/a35ef53891) Fix mef attributes project path provider
* [`[e29296220d]`](https://github.com/aspnet/AspNetCore/commit/e29296220d)  Fix not reading to end of argument JSON on binding error (#2319)
* [`[879646aba3]`](https://github.com/aspnet/AspNetCore/commit/879646aba3) Fix losing UTC DateTimeKind on ISO8601 UTC values (#2317)
* [`[64db0c9e95]`](https://github.com/aspnet/AspNetCore/commit/64db0c9e95) Fix mismatching request handler xml tags
* [`[96bbe70cd8]`](https://github.com/aspnet/AspNetCore/commit/96bbe70cd8) Handle incoming HTTP requests being canceled gracefully (#2314)
* [`[fb80636cb5]`](https://github.com/aspnet/AspNetCore/commit/fb80636cb5) Cookie Policy sample essential cookie (#1762)
* [`[ff1ea3cf85]`](https://github.com/aspnet/AspNetCore/commit/ff1ea3cf85) Split ANCM request handlers into two! (#839)
* [`[99a661edd6]`](https://github.com/aspnet/AspNetCore/commit/99a661edd6) Improve reliability of RequestTimesOutWhenRequestBodyNotReceivedAtSpecifiedMinimumRate (#2589)
* [`[cd516b328e]`](https://github.com/aspnet/AspNetCore/commit/cd516b328e) Handle process stdout
* [`[eab984e635]`](https://github.com/aspnet/AspNetCore/commit/eab984e635) Update artifact
* [`[624a5ed522]`](https://github.com/aspnet/AspNetCore/commit/624a5ed522) Fix ActionMethodExecutor incorrectly setting DeclaredType on ObjectResult
* [`[a736441ca5]`](https://github.com/aspnet/AspNetCore/commit/a736441ca5) Enable analyzers (#7789)
* [`[8932383d67]`](https://github.com/aspnet/AspNetCore/commit/8932383d67) Always pack Microsoft.AspNetCore.Server.IIS (#852)
* [`[15ca3dcdaa]`](https://github.com/aspnet/AspNetCore/commit/15ca3dcdaa) Move templates to netcoreapp2.2
* [`[bff2060454]`](https://github.com/aspnet/AspNetCore/commit/bff2060454) Fix JsonHubProtocol error message when too many arguments (#2312)
* [`[b493f01b35]`](https://github.com/aspnet/AspNetCore/commit/b493f01b35) Fix #2291 by documenting how to debug TS tests (#2306)
* [`[1951ddf6ea]`](https://github.com/aspnet/AspNetCore/commit/1951ddf6ea) Improve reliability of MaxRequestBufferSizeTests.LargeUpload (#2586)
* [`[95d41507fc]`](https://github.com/aspnet/AspNetCore/commit/95d41507fc) Add `ProjectPathProvider` abstract for document tracker creation.
* [`[32cee74a0c]`](https://github.com/aspnet/AspNetCore/commit/32cee74a0c) Generate baselines and enable Api check (#2304)
* [`[eda6940350]`](https://github.com/aspnet/AspNetCore/commit/eda6940350) Fix integration testing after logging change
* [`[9a249ffcc1]`](https://github.com/aspnet/AspNetCore/commit/9a249ffcc1) Add a LiveShare project snapshot base to make it easier to detect breaking changes.
* [`[43cabfdd61]`](https://github.com/aspnet/AspNetCore/commit/43cabfdd61) Upgrade deps
* [`[a13339dd5c]`](https://github.com/aspnet/AspNetCore/commit/a13339dd5c) Re-enable ConnectionCountingReturnsToZero on non-macOS machines (#2585)
* [`[336fe6ed90]`](https://github.com/aspnet/AspNetCore/commit/336fe6ed90) Dispose base
* [`[3719dc00fa]`](https://github.com/aspnet/AspNetCore/commit/3719dc00fa) Enable analyzers (#2300)
* [`[90fe58be75]`](https://github.com/aspnet/AspNetCore/commit/90fe58be75) [Fixes #523] Fix the jquery.min.js file in RazorPages web application
* [`[ac595c0c51]`](https://github.com/aspnet/AspNetCore/commit/ac595c0c51) Added tests to verify fallback source content is same as the CDN content
* [`[5dac1be2d7]`](https://github.com/aspnet/AspNetCore/commit/5dac1be2d7) Mark UserSecrets extension as a system component (#439)
* [`[f72d366603]`](https://github.com/aspnet/AspNetCore/commit/f72d366603) Split config and hostfxr parsing between shim and request handler. (#814)
* [`[8d4363b515]`](https://github.com/aspnet/AspNetCore/commit/8d4363b515) Update VSIX publishing to be consistent with non-VSIX publishing
* [`[1aa78a5853]`](https://github.com/aspnet/AspNetCore/commit/1aa78a5853) Rewrite JwtBearer token test #640
* [`[cd8f238f83]`](https://github.com/aspnet/AspNetCore/commit/cd8f238f83) Add Content-Type header in HttpClient.ts (#2242)
* [`[27799b5acb]`](https://github.com/aspnet/AspNetCore/commit/27799b5acb) Enable pubternability analyzer (#2560)
* [`[9b911cbb6e]`](https://github.com/aspnet/AspNetCore/commit/9b911cbb6e) Add some benchmarks for project system
* [`[aaaff4475a]`](https://github.com/aspnet/AspNetCore/commit/aaaff4475a) [Platform] Read and Advance once per parse loop (#2575)
* [`[ef9fa1868a]`](https://github.com/aspnet/AspNetCore/commit/ef9fa1868a) Fix SRI hash values for jquery (#521)
* [`[e1a22b315d]`](https://github.com/aspnet/AspNetCore/commit/e1a22b315d) Android HttpClientHandler.ClientCertificates fix (#2270)
* [`[2041cf6ede]`](https://github.com/aspnet/AspNetCore/commit/2041cf6ede) Don't create empty lambdas (#2283)
* [`[0c5be39112]`](https://github.com/aspnet/AspNetCore/commit/0c5be39112) Move to TestMatrix approach
* [`[b30f0d3b90]`](https://github.com/aspnet/AspNetCore/commit/b30f0d3b90) Change to a test matrix approach
* [`[4ce8155176]`](https://github.com/aspnet/AspNetCore/commit/4ce8155176) Update to netcoreapp2.2 (#46)
* [`[0b6dbab37a]`](https://github.com/aspnet/AspNetCore/commit/0b6dbab37a) Using block in the externally controlled example (#1422)
* [`[5227de9a31]`](https://github.com/aspnet/AspNetCore/commit/5227de9a31)  Always check if ANCM is in the base output folder. (#1420)
* [`[e9b8bf085d]`](https://github.com/aspnet/AspNetCore/commit/e9b8bf085d) Fix dotnet publish issues with aspnetcorerh.dll (#835)
* [`[95f543848c]`](https://github.com/aspnet/AspNetCore/commit/95f543848c) Fix multiple connections for a single user in Redis and MemoryLeak (#2273)
* [`[34c797a46b]`](https://github.com/aspnet/AspNetCore/commit/34c797a46b) Move in-process server implementation to IIS.Server (#837)
* [`[6272b3625e]`](https://github.com/aspnet/AspNetCore/commit/6272b3625e) Dispatch cancellation on CTRL+C to avoid deadlocks in killing the process tree
* [`[d80471ad15]`](https://github.com/aspnet/AspNetCore/commit/d80471ad15) Added logging to model binding requestpredicate shortcircuit
* [`[b0796ce8a8]`](https://github.com/aspnet/AspNetCore/commit/b0796ce8a8) Update the `Stes to reproduece` section header (#7767)
* [`[43aa392dff]`](https://github.com/aspnet/AspNetCore/commit/43aa392dff) Add state to TS HubConnection (#2268)
* [`[f8f6f39f55]`](https://github.com/aspnet/AspNetCore/commit/f8f6f39f55) Wait off the ConnectionClosed token to stop tracking ConnectionCallback (#2574)
* [`[19d82928ba]`](https://github.com/aspnet/AspNetCore/commit/19d82928ba)  Making Razor compilation cache replaceable (#7780)
* [`[2434d17613]`](https://github.com/aspnet/AspNetCore/commit/2434d17613) Exclude Visual Studio packages from default NGPV ruleset (#2352)
* [`[0e7effa376]`](https://github.com/aspnet/AspNetCore/commit/0e7effa376) Disable websocket tests on Windows 7 (#838)
* [`[c683316253]`](https://github.com/aspnet/AspNetCore/commit/c683316253) Generate repetitive TransportConnection FeatureCollection code (#2548)
* [`[a06a7b55c4]`](https://github.com/aspnet/AspNetCore/commit/a06a7b55c4) Upgrade from 2.1.300-rc1 to 2.1.300-rtm (#9)
* [`[15b219f55f]`](https://github.com/aspnet/AspNetCore/commit/15b219f55f) Update to netcoreapp2.2
* [`[04f2101696]`](https://github.com/aspnet/AspNetCore/commit/04f2101696) Reenable api check
* [`[7c70207594]`](https://github.com/aspnet/AspNetCore/commit/7c70207594) Made the Visual Studio parser smarter about overlapping reparse requests.
* [`[514917b9a8]`](https://github.com/aspnet/AspNetCore/commit/514917b9a8) Wait for input writer to complete before calling OnConnectionClosed (#2566)
* [`[bb348bb93c]`](https://github.com/aspnet/AspNetCore/commit/bb348bb93c) Updating external dependencies (#1162)
* [`[36b7f72460]`](https://github.com/aspnet/AspNetCore/commit/36b7f72460) Expose Hub method for server time for benchmarking (#2264)
* [`[47f28fa6fa]`](https://github.com/aspnet/AspNetCore/commit/47f28fa6fa) Re-enable API check
* [`[7625bbcb6c]`](https://github.com/aspnet/AspNetCore/commit/7625bbcb6c) Add HubConnection.State (#2204)
* [`[ffc665ccc2]`](https://github.com/aspnet/AspNetCore/commit/ffc665ccc2) Use correct TaskCompletionSource ctor (#2261)
* [`[c52a3bf534]`](https://github.com/aspnet/AspNetCore/commit/c52a3bf534) [Platform] Speedups (#2569)
* [`[d9f035ad7c]`](https://github.com/aspnet/AspNetCore/commit/d9f035ad7c) CacheTagHelper should be able to vary by culture Fixes #3398
* [`[a09c141ff4]`](https://github.com/aspnet/AspNetCore/commit/a09c141ff4) Add support for netcoreapp2.2 in benchmarks (#2561)
* [`[4d92d76b64]`](https://github.com/aspnet/AspNetCore/commit/4d92d76b64) Initial commit providing the AdapterFactory directly to the ObjectAdapter to all for customization of the Adapter selection and the ability to override the built in adapters to leverage their ability as much as possible.
* [`[b64c0105b8]`](https://github.com/aspnet/AspNetCore/commit/b64c0105b8) Use correct TaskCompletionSource ctor (#2567)
* [`[b7eacbb1c3]`](https://github.com/aspnet/AspNetCore/commit/b7eacbb1c3) Upgrade node-sass to 4.9.0 [Fixes #513] Angular template incompatible with NodeJs 10
* [`[22a865b832]`](https://github.com/aspnet/AspNetCore/commit/22a865b832) Extract a layer of IIS Async IO handling (#818)
* [`[f005e80b14]`](https://github.com/aspnet/AspNetCore/commit/f005e80b14) Embed version in the JavaScript client (#2229)
* [`[76a6cbcd84]`](https://github.com/aspnet/AspNetCore/commit/76a6cbcd84) Embed version in the JavaScript client (#2229)
* [`[0fa02f424f]`](https://github.com/aspnet/AspNetCore/commit/0fa02f424f) Make all tests pass on Linux (#8)
* [`[e1f7cb4105]`](https://github.com/aspnet/AspNetCore/commit/e1f7cb4105) Update Issue Template (#2231)
* [`[fafdd7e3af]`](https://github.com/aspnet/AspNetCore/commit/fafdd7e3af) Track the open/closed state of documents
* [`[da21fc89cf]`](https://github.com/aspnet/AspNetCore/commit/da21fc89cf) Handle exception in SocketConnection.Shutdown() (#2562)
* [`[023e61495f]`](https://github.com/aspnet/AspNetCore/commit/023e61495f) Test combining multi-byte character writes with individual chars (#2238)
* [`[e6a88c1b9c]`](https://github.com/aspnet/AspNetCore/commit/e6a88c1b9c) Relieve response backpressure immediately when closing socket (#2557)
* [`[4b1fb58a8a]`](https://github.com/aspnet/AspNetCore/commit/4b1fb58a8a)  Throw error on unexpected close (#2205)
* [`[5dfdf604a9]`](https://github.com/aspnet/AspNetCore/commit/5dfdf604a9) osx-x64
* [`[3dbfa3e8f8]`](https://github.com/aspnet/AspNetCore/commit/3dbfa3e8f8) More realistic echo scenario (#2240)
* [`[1ca6ce3377]`](https://github.com/aspnet/AspNetCore/commit/1ca6ce3377) setupAction parameter in MvcLocalizationServices.AddLocalizationServices is never used Fixes #7761
* [`[db33d593f0]`](https://github.com/aspnet/AspNetCore/commit/db33d593f0) Gracefully handle disposing while writing (#2180)
* [`[ab00ca08bd]`](https://github.com/aspnet/AspNetCore/commit/ab00ca08bd) Bash script to run tests
* [`[24e5ef2c5a]`](https://github.com/aspnet/AspNetCore/commit/24e5ef2c5a) linux-x64
* [`[4c0de435d8]`](https://github.com/aspnet/AspNetCore/commit/4c0de435d8) Add Internal.AspNetCore.Analyzers (#1161)
* [`[a1fb0703ed]`](https://github.com/aspnet/AspNetCore/commit/a1fb0703ed) Allow targetting of netcoreapp2.2 for sharedfx and lzma
* [`[ddd5c62054]`](https://github.com/aspnet/AspNetCore/commit/ddd5c62054) Let metapackages target netcoreapp2.2
* [`[8cbc4375d8]`](https://github.com/aspnet/AspNetCore/commit/8cbc4375d8) Updating external dependencies
* [`[a2a0d6e344]`](https://github.com/aspnet/AspNetCore/commit/a2a0d6e344) Replace static Enumerable.Concat() with instace IEnumerable.Concat()
* [`[4279f92575]`](https://github.com/aspnet/AspNetCore/commit/4279f92575) fixup! Upgrade metapackages, shared framework, and installers to netcoreapp2.2
* [`[6beb419a02]`](https://github.com/aspnet/AspNetCore/commit/6beb419a02) Upgrade metapackages, shared framework, and installers to netcoreapp2.2
* [`[27355346b4]`](https://github.com/aspnet/AspNetCore/commit/27355346b4) Update Jwt to 2.2 (#2237)
* [`[af8152f80e]`](https://github.com/aspnet/AspNetCore/commit/af8152f80e) Test self-contained applications
* [`[ddc478ab87]`](https://github.com/aspnet/AspNetCore/commit/ddc478ab87) Added using block around a disposable type usage
* [`[7bd10b41ba]`](https://github.com/aspnet/AspNetCore/commit/7bd10b41ba) Fix #1145 - set commit author and email
* [`[904626800a]`](https://github.com/aspnet/AspNetCore/commit/904626800a) Updating external dependencies (#1157)
* [`[e0e1c39cce]`](https://github.com/aspnet/AspNetCore/commit/e0e1c39cce) Added a LiveShareWorkspaceProvider to enable location of the remote workspace in live share scenarios.
* [`[695bf56afc]`](https://github.com/aspnet/AspNetCore/commit/695bf56afc) Run VerifyCoherentVersions check (#1156)
* [`[1d5245c421]`](https://github.com/aspnet/AspNetCore/commit/1d5245c421) Reorganize file tracker
* [`[91b5fb9ebd]`](https://github.com/aspnet/AspNetCore/commit/91b5fb9ebd) Clean up automated commit
* [`[8e9f05b902]`](https://github.com/aspnet/AspNetCore/commit/8e9f05b902) Don't touch product repos
* [`[350310aa96]`](https://github.com/aspnet/AspNetCore/commit/350310aa96) Handle netcoreapp cases
* [`[0f2b315fe4]`](https://github.com/aspnet/AspNetCore/commit/0f2b315fe4) Fixup Razor Sdk tests to work on netcoreapp2.2
* [`[bb70e7077f]`](https://github.com/aspnet/AspNetCore/commit/bb70e7077f) Handle ifdefs
* [`[ec2d5c7aa4]`](https://github.com/aspnet/AspNetCore/commit/ec2d5c7aa4) Run functional tests with a `TestLoggerFactory` - #7744
* [`[379a73f5d2]`](https://github.com/aspnet/AspNetCore/commit/379a73f5d2) Add benchmarks to IISIntegration (#823)
* [`[26454fb1da]`](https://github.com/aspnet/AspNetCore/commit/26454fb1da) Add ViewComponentResult helper methods to Page \ PageModel
* [`[f52c9c0f97]`](https://github.com/aspnet/AspNetCore/commit/f52c9c0f97) Update analyzer tests to use Microsoft.AspNetCore.Analyzer.Testing
* [`[6f211b9bbf]`](https://github.com/aspnet/AspNetCore/commit/6f211b9bbf) Use rc1
* [`[7e35c9f909]`](https://github.com/aspnet/AspNetCore/commit/7e35c9f909) Include MicrosoftNETCoreApp22packageVersion
* [`[dc9db57389]`](https://github.com/aspnet/AspNetCore/commit/dc9db57389) Fix out of process websocket check (#819)
* [`[e731c7695d]`](https://github.com/aspnet/AspNetCore/commit/e731c7695d) Detect appversion automatically
* [`[c3992acf3a]`](https://github.com/aspnet/AspNetCore/commit/c3992acf3a) Update script to fixup app version
* [`[dfd9b17f68]`](https://github.com/aspnet/AspNetCore/commit/dfd9b17f68) More keynotfound avoidance
* [`[341ba98d27]`](https://github.com/aspnet/AspNetCore/commit/341ba98d27) [dotnet-watch] Don't show false error messages (#434)
* [`[f35deb71f9]`](https://github.com/aspnet/AspNetCore/commit/f35deb71f9) Prevent KeyNotFound when logging
* [`[93186e4118]`](https://github.com/aspnet/AspNetCore/commit/93186e4118) Updating external dependencies (#1144)
* [`[1012b36bfb]`](https://github.com/aspnet/AspNetCore/commit/1012b36bfb) update README for npm packages (#2216)
* [`[025f9695f9]`](https://github.com/aspnet/AspNetCore/commit/025f9695f9) Update polly dependencies
* [`[b520569f23]`](https://github.com/aspnet/AspNetCore/commit/b520569f23) Update polly dependencies
* [`[5c17bff55d]`](https://github.com/aspnet/AspNetCore/commit/5c17bff55d) Don't throw on FIN from upgraded connections (#2533)
* [`[da7a95f563]`](https://github.com/aspnet/AspNetCore/commit/da7a95f563) Handle null collections when writing NegotiateResponse (#2202)
* [`[e0188c4936]`](https://github.com/aspnet/AspNetCore/commit/e0188c4936) Modify info level logging for pages (#7733)
* [`[86c3ec0069]`](https://github.com/aspnet/AspNetCore/commit/86c3ec0069) Mark WebHooks packages as non-shipping - #1141
* [`[e3e80b957c]`](https://github.com/aspnet/AspNetCore/commit/e3e80b957c) switch tests to 'jest' (#2193)
* [`[34c81aa794]`](https://github.com/aspnet/AspNetCore/commit/34c81aa794) Add link to dotnet-CLI in README [ci skip]
* [`[562b494229]`](https://github.com/aspnet/AspNetCore/commit/562b494229) New Idle Connection Benchmark Scenario  (#2178)
* [`[c311771b32]`](https://github.com/aspnet/AspNetCore/commit/c311771b32) Edit readme
* [`[cf0c11c2ca]`](https://github.com/aspnet/AspNetCore/commit/cf0c11c2ca) Update AzureServicesAppAuthentication to 1.0.1 (#1143)
* [`[57593543c4]`](https://github.com/aspnet/AspNetCore/commit/57593543c4) Make AzureKeyVault.HostingStartup shipping and update dependency version (#1142)
* [`[c009e15b0c]`](https://github.com/aspnet/AspNetCore/commit/c009e15b0c) Make HttpTransportType a flags enum in TypeScript (#2179)
* [`[6ea43cb951]`](https://github.com/aspnet/AspNetCore/commit/6ea43cb951) Backport fixes to maestro-bot scripts
* [`[b492dbe5d1]`](https://github.com/aspnet/AspNetCore/commit/b492dbe5d1) fix #2187 by passing min size through to buffer writer when encoding (#2190)
* [`[8b1fbad10e]`](https://github.com/aspnet/AspNetCore/commit/8b1fbad10e) Don't complete KestrelServer.StopAsync task inline (#2534)
* [`[789d21befa]`](https://github.com/aspnet/AspNetCore/commit/789d21befa) ANCM V1 => V2 package(#1136)
* [`[f181bc8c1f]`](https://github.com/aspnet/AspNetCore/commit/f181bc8c1f) Adds ANCM V2 (#116)
* [`[53cad943b3]`](https://github.com/aspnet/AspNetCore/commit/53cad943b3) Split ANCM into two dlls. (#811)
* [`[fb08967c9f]`](https://github.com/aspnet/AspNetCore/commit/fb08967c9f) Make Deployers handle ANCM V1 and V2 (#1407) (#1409)
* [`[89956df7ea]`](https://github.com/aspnet/AspNetCore/commit/89956df7ea) [Review] Updated migrations and scripts (#484)
* [`[b538f22ad5]`](https://github.com/aspnet/AspNetCore/commit/b538f22ad5) Add more UI for document generation
* [`[99114c25a4]`](https://github.com/aspnet/AspNetCore/commit/99114c25a4) Adjust spacing in csproj files (#492)
* [`[e0612d7e07]`](https://github.com/aspnet/AspNetCore/commit/e0612d7e07) Fixes for the document window state
* [`[fdfd5381a5]`](https://github.com/aspnet/AspNetCore/commit/fdfd5381a5) clean up the shutdown timer
* [`[8c7f33a6d7]`](https://github.com/aspnet/AspNetCore/commit/8c7f33a6d7) Port C# client perf fix to release (#2189)
* [`[ee710d3954]`](https://github.com/aspnet/AspNetCore/commit/ee710d3954) Convert NuGetPackageSource from enum to class
* [`[394adba776]`](https://github.com/aspnet/AspNetCore/commit/394adba776) Replace NuGetConfig with NuGetPackageSource
* [`[823baabb8f]`](https://github.com/aspnet/AspNetCore/commit/823baabb8f) Move test data into test class
* [`[b1010b7bd5]`](https://github.com/aspnet/AspNetCore/commit/b1010b7bd5) fix #2171 by adding HttpTransportType.None (#2172)
* [`[86d885e533]`](https://github.com/aspnet/AspNetCore/commit/86d885e533) Added a template for filing issues
* [`[622e133a8a]`](https://github.com/aspnet/AspNetCore/commit/622e133a8a) fix #2134 by disposing httpconnection if start fails (#2137) (#2188)
* [`[1c59b85c9a]`](https://github.com/aspnet/AspNetCore/commit/1c59b85c9a) Run PreinstallBundledPackages
* [`[b85ab0a7d2]`](https://github.com/aspnet/AspNetCore/commit/b85ab0a7d2) Fix Sending100ContinueDoesNotStartResponse #2507
* [`[52802d1afa]`](https://github.com/aspnet/AspNetCore/commit/52802d1afa) Make Deployers handle ANCM V1 and V2 (#1407)
* [`[c414223c72]`](https://github.com/aspnet/AspNetCore/commit/c414223c72) Make feature detection tests use out of process path (#805)
* [`[d6f15759fd]`](https://github.com/aspnet/AspNetCore/commit/d6f15759fd) Add property to allow the SDK to disable shared framework trimming (#1130)
* [`[41c8dcf449]`](https://github.com/aspnet/AspNetCore/commit/41c8dcf449) Fix not setting HttpConnection.ConnectionId (#2154)
* [`[555c1fd720]`](https://github.com/aspnet/AspNetCore/commit/555c1fd720) Fix not detecting marker service (#2149)
* [`[e0e9eb0b36]`](https://github.com/aspnet/AspNetCore/commit/e0e9eb0b36) Add pre-generated shims to dotnet tool packages
* [`[a94323499b]`](https://github.com/aspnet/AspNetCore/commit/a94323499b) Change CopyToPublishDirectory on Content items instead of explicitly removing this from publish items
* [`[ae329edd2a]`](https://github.com/aspnet/AspNetCore/commit/ae329edd2a) Fix #2169 by correcting shutdown timeout (#2170)
* [`[d711916ad6]`](https://github.com/aspnet/AspNetCore/commit/d711916ad6) fix #2140 by ensuring the access token flows to WebSocketTransport (#2173)
* [`[e49b0a34ab]`](https://github.com/aspnet/AspNetCore/commit/e49b0a34ab) Make exchange classes pure virtual (#792)
* [`[295801ac50]`](https://github.com/aspnet/AspNetCore/commit/295801ac50) XML documentation (#2106)
* [`[c89cf1a12b]`](https://github.com/aspnet/AspNetCore/commit/c89cf1a12b) JSDocs (#2168)
* [`[e36b0982bf]`](https://github.com/aspnet/AspNetCore/commit/e36b0982bf) port change from v2 to v1 on resetting timeout for debugger attached (#787)
* [`[a941f3c712]`](https://github.com/aspnet/AspNetCore/commit/a941f3c712) Add some more functional tests (Cookies/PathSelection/DynamicSchemes) (#42)
* [`[2340cd5e59]`](https://github.com/aspnet/AspNetCore/commit/2340cd5e59) Mark all dotnet-* packages as 'ship' (#1131)
* [`[fb2f89ed51]`](https://github.com/aspnet/AspNetCore/commit/fb2f89ed51) Factor out internal interface for default directory testing
* [`[2c1376c95f]`](https://github.com/aspnet/AspNetCore/commit/2c1376c95f) Add a AddHostedService extension #1402
* [`[35f7d3f09c]`](https://github.com/aspnet/AspNetCore/commit/35f7d3f09c) Added tests to verify that RazorPages and FuzzyMatching with Head requests work
* [`[601f41026a]`](https://github.com/aspnet/AspNetCore/commit/601f41026a) Updated icon for RazorClassLibrary
* [`[708b2ded76]`](https://github.com/aspnet/AspNetCore/commit/708b2ded76) Skip ANCM v2 in-proc chunked tests (#111)
* [`[1e5b3a5cc5]`](https://github.com/aspnet/AspNetCore/commit/1e5b3a5cc5) Execute app after publish
* [`[b23d9b7679]`](https://github.com/aspnet/AspNetCore/commit/b23d9b7679) Decouple connection objects from the server (#2535)
* [`[4b50481915]`](https://github.com/aspnet/AspNetCore/commit/4b50481915) Respond to dotnet-ef target framework update
* [`[3d2bf869c5]`](https://github.com/aspnet/AspNetCore/commit/3d2bf869c5) Don't rely on USERPROFILE to find the path to dotnet.exe (#803)
* [`[c72df2865c]`](https://github.com/aspnet/AspNetCore/commit/c72df2865c) Check existence of ANCMV2 Path (#1397)
* [`[a2cb92b358]`](https://github.com/aspnet/AspNetCore/commit/a2cb92b358) Code improvements of JwtBearer module (#1742)
* [`[2a7e6719a4]`](https://github.com/aspnet/AspNetCore/commit/2a7e6719a4) Combine tests to significantly reduce runtime
* [`[9cf79dcc1a]`](https://github.com/aspnet/AspNetCore/commit/9cf79dcc1a) Publish and verify files
* [`[d8020e34b5]`](https://github.com/aspnet/AspNetCore/commit/d8020e34b5) Add Gitter badge (#2174)
* [`[c9746d43c9]`](https://github.com/aspnet/AspNetCore/commit/c9746d43c9) Add HubConnection receive benchmark (#2164)
* [`[c59dcb9b4c]`](https://github.com/aspnet/AspNetCore/commit/c59dcb9b4c) Add IVT for Razor.LiveShare.Test.
* [`[6ee830bc6a]`](https://github.com/aspnet/AspNetCore/commit/6ee830bc6a) Update submodules to 2.1.0-rtm version
* [`[ff61bdf819]`](https://github.com/aspnet/AspNetCore/commit/ff61bdf819) Set version to 2.1.0-rtm
* [`[f67458f156]`](https://github.com/aspnet/AspNetCore/commit/f67458f156) Fix #2298 simplify TagHelperDescriptor hash
* [`[de98f8c962]`](https://github.com/aspnet/AspNetCore/commit/de98f8c962) Use TaskCreationOptions.RunContinuationsAsynchronously a lot
* [`[8fe927d40d]`](https://github.com/aspnet/AspNetCore/commit/8fe927d40d) Run app and verify response
* [`[2885b4b138]`](https://github.com/aspnet/AspNetCore/commit/2885b4b138) Make document tracker resilient to multiple subscribes.
* [`[e9b84a298a]`](https://github.com/aspnet/AspNetCore/commit/e9b84a298a) Sample generic host using MSMQ (#1381)
* [`[c53514fa19]`](https://github.com/aspnet/AspNetCore/commit/c53514fa19) Don't throw from AbortAsync (#2166)
* [`[ab451b53b7]`](https://github.com/aspnet/AspNetCore/commit/ab451b53b7) Simplify error handling in HubConnectionHandler (#2162)
* [`[f4e7771c0c]`](https://github.com/aspnet/AspNetCore/commit/f4e7771c0c) Respond to dotnet-ef target framework upgrade (#503)
* [`[ec34d7cbbb]`](https://github.com/aspnet/AspNetCore/commit/ec34d7cbbb) Add ReactRedux template
* [`[be75da0202]`](https://github.com/aspnet/AspNetCore/commit/be75da0202) Add ReactTemplate
* [`[fec565bf4d]`](https://github.com/aspnet/AspNetCore/commit/fec565bf4d) Add AngularTemplate
* [`[6db0dc7db0]`](https://github.com/aspnet/AspNetCore/commit/6db0dc7db0) Add RazorClassLibraryTemplate
* [`[ee9537bebd]`](https://github.com/aspnet/AspNetCore/commit/ee9537bebd) Add Razor.LiveShare IVT to Editor.Razor.
* [`[4681618075]`](https://github.com/aspnet/AspNetCore/commit/4681618075) Add WebApiTemplate
* [`[f75eb0f0e9]`](https://github.com/aspnet/AspNetCore/commit/f75eb0f0e9) Add MvcTemplate
* [`[9ccf6501ef]`](https://github.com/aspnet/AspNetCore/commit/9ccf6501ef) Add RazorTemplate
* [`[3a041176e9]`](https://github.com/aspnet/AspNetCore/commit/3a041176e9) Add WebTemplate
* [`[813e50087c]`](https://github.com/aspnet/AspNetCore/commit/813e50087c) Specify RuntimeFrameworkVersion \ NSLibraryVersion when running tests
* [`[dd1934771f]`](https://github.com/aspnet/AspNetCore/commit/dd1934771f) Update to linux-musl-x64 SDK
* [`[1a4035418a]`](https://github.com/aspnet/AspNetCore/commit/1a4035418a) Verify files generated by restore
* [`[9dc18f277d]`](https://github.com/aspnet/AspNetCore/commit/9dc18f277d) Test "dotnet restore" for all ASP.NET templates with 3 NuGet configs
* [`[ad66ebb220]`](https://github.com/aspnet/AspNetCore/commit/ad66ebb220) Add Razor.LiveShare IVT to CodeAnalysis.Razor.
* [`[8d0f84ea46]`](https://github.com/aspnet/AspNetCore/commit/8d0f84ea46) Add IAuthorizationPolicyProvider sample (#31)
* [`[49299d78a4]`](https://github.com/aspnet/AspNetCore/commit/49299d78a4) Add Razor.LiveShare IVT to Razor.Workspaces.
* [`[e2edc280c5]`](https://github.com/aspnet/AspNetCore/commit/e2edc280c5) Add documents, engine, tag helpers to snapshot
* [`[c880ccd89d]`](https://github.com/aspnet/AspNetCore/commit/c880ccd89d) Add debug kestrel PR run (#2523)
* [`[4b52428a4d]`](https://github.com/aspnet/AspNetCore/commit/4b52428a4d) EchoAll scenario doesn't work well with warmup (#2143)
* [`[66d3de5142]`](https://github.com/aspnet/AspNetCore/commit/66d3de5142) Fix Hub location
* [`[5a0b8fd8d9]`](https://github.com/aspnet/AspNetCore/commit/5a0b8fd8d9) Initial commit
* [`[924d99abe7]`](https://github.com/aspnet/AspNetCore/commit/924d99abe7) Update BenchmarkServer readme
* [`[a375ac31a4]`](https://github.com/aspnet/AspNetCore/commit/a375ac31a4) Update to .NET Core 2.2.0-preview1-26425-02
* [`[a9cb4a04d2]`](https://github.com/aspnet/AspNetCore/commit/a9cb4a04d2) Add Microsoft.Extensions.Buffers.MemoryPool.Sources package (#1114)
* [`[76ff1dc5cd]`](https://github.com/aspnet/AspNetCore/commit/76ff1dc5cd) Use fork of universe
* [`[43b52b6933]`](https://github.com/aspnet/AspNetCore/commit/43b52b6933) Updating external dependencies
* [`[8c43f9abcd]`](https://github.com/aspnet/AspNetCore/commit/8c43f9abcd) Include .App in LZMA ... again
* [`[af28b95a93]`](https://github.com/aspnet/AspNetCore/commit/af28b95a93) Reference razor sdk to avoid runtime compilation #38
* [`[e888481548]`](https://github.com/aspnet/AspNetCore/commit/e888481548) update legal info for V1 assembly (#784)
* [`[075453b180]`](https://github.com/aspnet/AspNetCore/commit/075453b180) Fix Sending100ContinueDoesNotStartResponse #2507
* [`[7dfd5dab00]`](https://github.com/aspnet/AspNetCore/commit/7dfd5dab00) Reference razor sdk to avoid runtime compilation
* [`[3ce1b4d1d5]`](https://github.com/aspnet/AspNetCore/commit/3ce1b4d1d5) UpdateDeps to match maestro (#1105)
* [`[e08d7fe9c3]`](https://github.com/aspnet/AspNetCore/commit/e08d7fe9c3) UpdateDeps to match maestro (#1105)
* [`[21f435bc8d]`](https://github.com/aspnet/AspNetCore/commit/21f435bc8d) Update KestrelHttpServer submodule
* [`[b0e1fa5e30]`](https://github.com/aspnet/AspNetCore/commit/b0e1fa5e30) Fix connection abort
* [`[fefae2682b]`](https://github.com/aspnet/AspNetCore/commit/fefae2682b) Add linux-musl-x64 shared runtime (#1104)
* [`[a293d2c187]`](https://github.com/aspnet/AspNetCore/commit/a293d2c187) Update to NETStandard.Library 2.0.3 (#1099)
* [`[7ac5eb14b1]`](https://github.com/aspnet/AspNetCore/commit/7ac5eb14b1) Update KestrelHttpServer submodule
* [`[1ba0832277]`](https://github.com/aspnet/AspNetCore/commit/1ba0832277) Add workaround for mismatch between TFM and AspNetCore TargetFrameworkVersions
* [`[0e5247f56b]`](https://github.com/aspnet/AspNetCore/commit/0e5247f56b) Mark KeyVault.HostingStartup as shipoob
* [`[1655a8fd6d]`](https://github.com/aspnet/AspNetCore/commit/1655a8fd6d) Disable writing to console if exceptions are expected
* [`[debac65a02]`](https://github.com/aspnet/AspNetCore/commit/debac65a02) Updating external dependencies
* [`[bd46d757ba]`](https://github.com/aspnet/AspNetCore/commit/bd46d757ba) fix #2134 by disposing httpconnection if start fails (#2137)
* [`[1c9607a1ed]`](https://github.com/aspnet/AspNetCore/commit/1c9607a1ed) Verify Verifiable spelling (#2114)
* [`[33ee8626c8]`](https://github.com/aspnet/AspNetCore/commit/33ee8626c8) Cache some property access in json hub protocol (#2128)
* [`[0f131ac245]`](https://github.com/aspnet/AspNetCore/commit/0f131ac245) Disambiguate /p from -p on dotnet-run
* [`[01c0690cc9]`](https://github.com/aspnet/AspNetCore/commit/01c0690cc9) Final TS tidyup (#2120)
* [`[47eafca4d8]`](https://github.com/aspnet/AspNetCore/commit/47eafca4d8) CancellationToken EVERYWHERE (#2101)
* [`[2a10e6fe1d]`](https://github.com/aspnet/AspNetCore/commit/2a10e6fe1d) Added nuspec file for Mvc.Razor.ViewCompilation to include symbols
* [`[aa181128ac]`](https://github.com/aspnet/AspNetCore/commit/aa181128ac) Generate symbol nupkgs for tools
* [`[595e83d0eb]`](https://github.com/aspnet/AspNetCore/commit/595e83d0eb) Added nuspec file to Mvc.Analyzers assembly
* [`[75295b1289]`](https://github.com/aspnet/AspNetCore/commit/75295b1289) Rename delta zips to *.patch.zip/*.patch.tar.gz
* [`[eaefd0be14]`](https://github.com/aspnet/AspNetCore/commit/eaefd0be14) Update UpdateDeps script
* [`[5d5222cdd8]`](https://github.com/aspnet/AspNetCore/commit/5d5222cdd8) Introduce BindPropertiesAttribute
* [`[058830c9df]`](https://github.com/aspnet/AspNetCore/commit/058830c9df) fix #2116 by requiring task return values from typed client (#2117)
* [`[2be905def4]`](https://github.com/aspnet/AspNetCore/commit/2be905def4) Make newline comparison work crossplat
* [`[2a4fa4ef28]`](https://github.com/aspnet/AspNetCore/commit/2a4fa4ef28) Updating external dependencies
* [`[90f35168fc]`](https://github.com/aspnet/AspNetCore/commit/90f35168fc) Update KestrelHttpServer submodules
* [`[e04cb0b5ce]`](https://github.com/aspnet/AspNetCore/commit/e04cb0b5ce) Add Microsoft.AspNetCore.Analyzer.Testing artifact (#1093)
* [`[3052666b8c]`](https://github.com/aspnet/AspNetCore/commit/3052666b8c) Mark dotnet-aspnet-codegenerator as 'ship' Fixes #1027
* [`[8c3b83c047]`](https://github.com/aspnet/AspNetCore/commit/8c3b83c047) Fix ClientCancellationAborts test #1379
* [`[c7bb660730]`](https://github.com/aspnet/AspNetCore/commit/c7bb660730) Create a StaticFilesAuth sample #28
* [`[d69798d2c1]`](https://github.com/aspnet/AspNetCore/commit/d69798d2c1) Clean up pipes usage in TestHost
* [`[dacea904cc]`](https://github.com/aspnet/AspNetCore/commit/dacea904cc) privatize IConnection and HttpConnection (#2105)
* [`[e6011ef69b]`](https://github.com/aspnet/AspNetCore/commit/e6011ef69b) Use custom group names in tests to not collide with other tests running (#2102)
* [`[3b8243d203]`](https://github.com/aspnet/AspNetCore/commit/3b8243d203) Removing the chat sample (#2113)
* [`[9101ab636b]`](https://github.com/aspnet/AspNetCore/commit/9101ab636b) Always check for WebSockets close (#2100)
* [`[5516a969e3]`](https://github.com/aspnet/AspNetCore/commit/5516a969e3) Change Hub and friends to abstract (#2108)
* [`[ace9a0d414]`](https://github.com/aspnet/AspNetCore/commit/ace9a0d414) fix #2097 by adding GetHttpContext to HubConnectionContext (#2099)
* [`[a3c3928335]`](https://github.com/aspnet/AspNetCore/commit/a3c3928335) Add parameter so we can produce binary logs for individual repos
* [`[1f87572985]`](https://github.com/aspnet/AspNetCore/commit/1f87572985) Update to NETStandard.Library 2.0.2 (#1089)
* [`[1957655653]`](https://github.com/aspnet/AspNetCore/commit/1957655653) Run hub invocations serially (#2086)
* [`[6b6d890c8f]`](https://github.com/aspnet/AspNetCore/commit/6b6d890c8f) fix #2078 by adding locking (#2079)
* [`[7aa792efe6]`](https://github.com/aspnet/AspNetCore/commit/7aa792efe6) Produce a zip containing site-extension files (#189)
* [`[44e282e8d4]`](https://github.com/aspnet/AspNetCore/commit/44e282e8d4) Generate symbols.nupkg for Mvc.Razor
* [`[30928ba944]`](https://github.com/aspnet/AspNetCore/commit/30928ba944) Disable implicit package version verification when --no-restore is used
* [`[ece1fec0f5]`](https://github.com/aspnet/AspNetCore/commit/ece1fec0f5) Rename EFCore.DocumentDb package to EFCore.Cosmos.Sql
* [`[fa74427ef9]`](https://github.com/aspnet/AspNetCore/commit/fa74427ef9) Use the Razor.Sdk package
* [`[617d0bb4f6]`](https://github.com/aspnet/AspNetCore/commit/617d0bb4f6) fix websocket sample (#2096)
* [`[050a1ecf27]`](https://github.com/aspnet/AspNetCore/commit/050a1ecf27) fix package.json versions (#2098)
* [`[676bf179f3]`](https://github.com/aspnet/AspNetCore/commit/676bf179f3) Reduce redundant dependencies (#2091)
* [`[ad52ba7316]`](https://github.com/aspnet/AspNetCore/commit/ad52ba7316) Global suppress low impact logging verification in tests (#2089)
* [`[adccac3591]`](https://github.com/aspnet/AspNetCore/commit/adccac3591) Fix GetArtifactInfo
* [`[e9937ffb66]`](https://github.com/aspnet/AspNetCore/commit/e9937ffb66) Split lock into WriteLock and StateLock to prevent deadlocks and unneeded lock contention (#2081)
* [`[7351b274f7]`](https://github.com/aspnet/AspNetCore/commit/7351b274f7) Add LPTHREAD_START_ROUTINE due to compiler change (fixing issue #780) (#783)
* [`[d42a9953a4]`](https://github.com/aspnet/AspNetCore/commit/d42a9953a4) Update Polly.Extensions.Http-Signed to 1.0.4
* [`[57f338623b]`](https://github.com/aspnet/AspNetCore/commit/57f338623b) Update Polly.Extensions.Http-Signed to 1.0.4
* [`[ac0ee35362]`](https://github.com/aspnet/AspNetCore/commit/ac0ee35362) Change AutobahnTester to use dynamic ports with Kestrel (#238)
* [`[55feeeab15]`](https://github.com/aspnet/AspNetCore/commit/55feeeab15) Add DeploymentParameters.Scheme property (#1388)
* [`[d2fe76be21]`](https://github.com/aspnet/AspNetCore/commit/d2fe76be21) Write process and pipe information to a pid file
* [`[903fe1e902]`](https://github.com/aspnet/AspNetCore/commit/903fe1e902) Added support for negotiate response to redirect the client to another SignalR endpoint (#2070)
* [`[60a9810268]`](https://github.com/aspnet/AspNetCore/commit/60a9810268) Allow PartialTagHelper to specify a null model. Fixes #7667
* [`[6034f7f1bb]`](https://github.com/aspnet/AspNetCore/commit/6034f7f1bb) Use dynamic ports in StaticFileMiddlewareTests (#236)
* [`[341f6c4f30]`](https://github.com/aspnet/AspNetCore/commit/341f6c4f30) reset some timeout values to infinite if debugger is attached (#776)
* [`[de3d5e0e29]`](https://github.com/aspnet/AspNetCore/commit/de3d5e0e29) Exclude additionalDeps files due to file path conflicts with the 2.0.7 release
* [`[73dff82e00]`](https://github.com/aspnet/AspNetCore/commit/73dff82e00) Update Roslyn version numbers
* [`[faca3da42f]`](https://github.com/aspnet/AspNetCore/commit/faca3da42f) Ensure ViewData is set on PageResult after a handler method executes [Fixes #7665] Initializing PageResult.Page as part of result execution breaks Identity UI
* [`[4f7d53f4e7]`](https://github.com/aspnet/AspNetCore/commit/4f7d53f4e7) [Fixes #7658] FileStreamResultExecutor fails to Dispose FileStream
* [`[6e4bd1eb46]`](https://github.com/aspnet/AspNetCore/commit/6e4bd1eb46) Fixed PageFilter docs
* [`[1cede88f26]`](https://github.com/aspnet/AspNetCore/commit/1cede88f26) [Fixes #7656] Deps file for netstandard2.0 targeting projects copied by Microsoft.AspNetCore.Mvc.Testing does not play well with Mvc
* [`[5c9b64244a]`](https://github.com/aspnet/AspNetCore/commit/5c9b64244a) Expose the IHubProtocol on HubConnectionContext (#2073)
* [`[de692a6afe]`](https://github.com/aspnet/AspNetCore/commit/de692a6afe) Flow DotNetAssetRootAccessTokenSuffix through to docker-run as an env variable
* [`[6edc4bf3b6]`](https://github.com/aspnet/AspNetCore/commit/6edc4bf3b6) Mark Microsoft.NETCore.DotNetAppHost as a private dependency
* [`[076ebbe055]`](https://github.com/aspnet/AspNetCore/commit/076ebbe055) Add version variable for Microsoft.NETCore.DotNetAppHost dependency (needed for global tools) (#1079)
* [`[679225c241]`](https://github.com/aspnet/AspNetCore/commit/679225c241) Use correct MessagePack in Benchmarks (#2066)
* [`[b4046b5ed8]`](https://github.com/aspnet/AspNetCore/commit/b4046b5ed8) Fix #1989 by adding a 'binding failure' pseudo-message (#2064)
* [`[391c281194]`](https://github.com/aspnet/AspNetCore/commit/391c281194) Capture server logs in tests (#2029)
* [`[2c6ae20e11]`](https://github.com/aspnet/AspNetCore/commit/2c6ae20e11) Update Roslyn version numbers
* [`[95cd76abdd]`](https://github.com/aspnet/AspNetCore/commit/95cd76abdd) Fix package category for shipoob packages
* [`[7089f16859]`](https://github.com/aspnet/AspNetCore/commit/7089f16859) Update to include Kestrel patch changes
* [`[c376dab2b6]`](https://github.com/aspnet/AspNetCore/commit/c376dab2b6) Fixup submodule branches
* [`[cba1e5b166]`](https://github.com/aspnet/AspNetCore/commit/cba1e5b166) Add Microsoft.AspNetCore.AzureKeyVault.HostingStartup as a shipping package
* [`[5d96a48638]`](https://github.com/aspnet/AspNetCore/commit/5d96a48638) Prepare 2.0.8 patch
* [`[1cdd9bab0e]`](https://github.com/aspnet/AspNetCore/commit/1cdd9bab0e) Fixup feature branch version calculation
* [`[0f0b9a73c1]`](https://github.com/aspnet/AspNetCore/commit/0f0b9a73c1) Logger thread safety?
* [`[6842ae307f]`](https://github.com/aspnet/AspNetCore/commit/6842ae307f) Undo dev changes
* [`[0cc416f1f9]`](https://github.com/aspnet/AspNetCore/commit/0cc416f1f9)  Change SelfHostDeployer to use dynamic ports by default (#1383)
* [`[e781cd38cf]`](https://github.com/aspnet/AspNetCore/commit/e781cd38cf) [Fixes #7635] Provide a way to configure HTTP Client instances
* [`[e0b4c13895]`](https://github.com/aspnet/AspNetCore/commit/e0b4c13895) [Fixes #7587] Default to Development environment in tests
* [`[e06b1fd690]`](https://github.com/aspnet/AspNetCore/commit/e06b1fd690) [Fixes #1242] Moves IStartupConfigureServicesFilter and IStartupConfigureContainerFilter interfaces to the internal namespace
* [`[9f6531b547]`](https://github.com/aspnet/AspNetCore/commit/9f6531b547) Fix script target
* [`[a32e7dc18b]`](https://github.com/aspnet/AspNetCore/commit/a32e7dc18b) Adapt dev to release/2.1
* [`[b4946fc638]`](https://github.com/aspnet/AspNetCore/commit/b4946fc638) Bring modules back to release/2.1 versions
* [`[65b1ea45aa]`](https://github.com/aspnet/AspNetCore/commit/65b1ea45aa) Disable NU5119 for site extensions (#183)
* [`[dc997821cc]`](https://github.com/aspnet/AspNetCore/commit/dc997821cc) Added nuspec and symbols.nuspec files to Razor.Design
* [`[14fa14b5d3]`](https://github.com/aspnet/AspNetCore/commit/14fa14b5d3) 2.2.0
* [`[2811eadb14]`](https://github.com/aspnet/AspNetCore/commit/2811eadb14) Use the Razor.Sdk package
* [`[befde0fe71]`](https://github.com/aspnet/AspNetCore/commit/befde0fe71) Use the Razor.Sdk package
* [`[d44982b166]`](https://github.com/aspnet/AspNetCore/commit/d44982b166) Update GenerateTags.ps1 script
* [`[259dd04c99]`](https://github.com/aspnet/AspNetCore/commit/259dd04c99) Fix weird NRE
* [`[9d8b83e6b3]`](https://github.com/aspnet/AspNetCore/commit/9d8b83e6b3) Updated version to 1.1.0 preview1
* [`[05d6bbb782]`](https://github.com/aspnet/AspNetCore/commit/05d6bbb782) Flush first long poll immediately (#2032)
* [`[a30faf1a30]`](https://github.com/aspnet/AspNetCore/commit/a30faf1a30) Skip ANCM v2 in-proc chunked tests (#111)
* [`[d35bcea0a5]`](https://github.com/aspnet/AspNetCore/commit/d35bcea0a5) Move HubException and add serialization ctor (#2049)
* [`[0cb45afdaa]`](https://github.com/aspnet/AspNetCore/commit/0cb45afdaa) Script missed this one
* [`[353f8554a9]`](https://github.com/aspnet/AspNetCore/commit/353f8554a9) This version got missed in updating
* [`[6fd09af374]`](https://github.com/aspnet/AspNetCore/commit/6fd09af374) Improve logging of request drain timeout (#2480)
* [`[3a45136cc4]`](https://github.com/aspnet/AspNetCore/commit/3a45136cc4) make IConnectionInherentKeepAliveFeature a boolean feature (#2496)
* [`[a426334018]`](https://github.com/aspnet/AspNetCore/commit/a426334018) Expose IList instead of List
* [`[a5d9930802]`](https://github.com/aspnet/AspNetCore/commit/a5d9930802) API review changes (#2043)
* [`[4d151a599e]`](https://github.com/aspnet/AspNetCore/commit/4d151a599e) Dynamically expand timeout when waiting for Angular CLI to be ready. Fixes #1611
* [`[78f7dccfab]`](https://github.com/aspnet/AspNetCore/commit/78f7dccfab) Performance fix
* [`[927b08f893]`](https://github.com/aspnet/AspNetCore/commit/927b08f893) Cache property access (#2030)
* [`[4f4dfe1d23]`](https://github.com/aspnet/AspNetCore/commit/4f4dfe1d23) Move RedisLog to Internal namespace (#2038)
* [`[b5d5f11ef8]`](https://github.com/aspnet/AspNetCore/commit/b5d5f11ef8) Rename excludedIds to excludedConnectionIds (#2037)
* [`[7745fd748a]`](https://github.com/aspnet/AspNetCore/commit/7745fd748a) Extension methods for IHubClients methods (#2016)
* [`[0da06fb5d2]`](https://github.com/aspnet/AspNetCore/commit/0da06fb5d2) Microsoft.AspNetCore.SignalR.Redis API review (#2036)
* [`[b3a9011698]`](https://github.com/aspnet/AspNetCore/commit/b3a9011698) API review changes for Microsoft.AspNetCore.SignalR (#2033)
* [`[6eac7049ba]`](https://github.com/aspnet/AspNetCore/commit/6eac7049ba) Update text and binary formatter helpers to be shared (#2035)
* [`[62f14054eb]`](https://github.com/aspnet/AspNetCore/commit/62f14054eb) Capture and log prematurely closed connections
* [`[fbb13c4c1f]`](https://github.com/aspnet/AspNetCore/commit/fbb13c4c1f) Improve response status logging
* [`[725bb33949]`](https://github.com/aspnet/AspNetCore/commit/725bb33949) Lazy initialize HttpConnectionContext.Items (#2027)
* [`[585bcc3ee0]`](https://github.com/aspnet/AspNetCore/commit/585bcc3ee0) How about this?
* [`[c835288e84]`](https://github.com/aspnet/AspNetCore/commit/c835288e84) Suppress web socket closing without handshake
* [`[89922a399f]`](https://github.com/aspnet/AspNetCore/commit/89922a399f) Capture server logs in tests
* [`[ddc905c219]`](https://github.com/aspnet/AspNetCore/commit/ddc905c219) Add VerifyNoErrorsScope (#1972)
* [`[b9e7113c01]`](https://github.com/aspnet/AspNetCore/commit/b9e7113c01) Move types out of .Core namespace and make method virtual (#2024)
* [`[377ed1b834]`](https://github.com/aspnet/AspNetCore/commit/377ed1b834) JsonHubProtocol and MessagePackHubProtocol version fields now private (#2023)
* [`[cc5ae02b7d]`](https://github.com/aspnet/AspNetCore/commit/cc5ae02b7d) Fix binding & validating dictionaries of non-simple types in jQuery requests - #7423 - retry failed inner bindings with alternate syntax in `ModelStateDictionary`   - use property syntax if first attempt tried index syntax and visa versa - instantiate `ShortFormDictionaryValidationStrategy` with full `ModelState` keys   - can now provide exact `ModelState` keys that `ModelStateDictionary` used in inner bindings - normalize model names without a leading period in `JQueryKeyValuePairNormalizer`
* [`[5a77c8be25]`](https://github.com/aspnet/AspNetCore/commit/5a77c8be25)  API review Microsoft.AspNetCore.SignalR.Internal (#2022)
* [`[4fe41dc6d0]`](https://github.com/aspnet/AspNetCore/commit/4fe41dc6d0) Increase timeout of test (#2021)
* [`[d6395a52bc]`](https://github.com/aspnet/AspNetCore/commit/d6395a52bc) Send delete request after poll ends (#2020)
* [`[0f8485cafc]`](https://github.com/aspnet/AspNetCore/commit/0f8485cafc) Renamed class to match the file (#2019)
* [`[e30a02cee5]`](https://github.com/aspnet/AspNetCore/commit/e30a02cee5)  Less StringValue struct copies for header checks (#2488)
* [`[d0c949f2d1]`](https://github.com/aspnet/AspNetCore/commit/d0c949f2d1) Update artifacts.props
* [`[3f0a6ebc0d]`](https://github.com/aspnet/AspNetCore/commit/3f0a6ebc0d) API Review Dependency Injection (#2015)
* [`[c7f7f36210]`](https://github.com/aspnet/AspNetCore/commit/c7f7f36210) API Review for Http.Connections (#2010)
* [`[95835d6c37]`](https://github.com/aspnet/AspNetCore/commit/95835d6c37) Continue generating RelatedAssemblyPart on assembly if GenerateAssemblyInfo=false
* [`[898b8cec84]`](https://github.com/aspnet/AspNetCore/commit/898b8cec84) Prepare for RazorAssemblyAttribute -> RazorTargetAssemblyAttribute rename
* [`[1e26571ba6]`](https://github.com/aspnet/AspNetCore/commit/1e26571ba6) [Fixes #7635] Provide a way to configure clients in WebApplicationFactory
* [`[22510e1377]`](https://github.com/aspnet/AspNetCore/commit/22510e1377) [Fixes #7587] No easy way to change ASPNETCORE_ENVIRONMENT
* [`[d5e044f693]`](https://github.com/aspnet/AspNetCore/commit/d5e044f693) [Fixes #7373] Assigning to the context's Result property, when implementing IPageFilter, causes an exception
* [`[faf2f3f065]`](https://github.com/aspnet/AspNetCore/commit/faf2f3f065) Attempt to workaround issues with File.Move on NFS file shares (aspnet/Home#2941)
* [`[d0137a996c]`](https://github.com/aspnet/AspNetCore/commit/d0137a996c) Internalize Microsoft.AspNetCore.Http.Connections.Client.Internal (#2014)
* [`[021356bf27]`](https://github.com/aspnet/AspNetCore/commit/021356bf27) Internalize classes in Http.Connections (#2013)
* [`[2d51d23697]`](https://github.com/aspnet/AspNetCore/commit/2d51d23697) Add file logging to functional tests
* [`[623ab63091]`](https://github.com/aspnet/AspNetCore/commit/623ab63091) HubConnectionTests.Helper Header (#2011)
* [`[e854535a8c]`](https://github.com/aspnet/AspNetCore/commit/e854535a8c) Push symbols to new myget symbols feed
* [`[a9c7c322cb]`](https://github.com/aspnet/AspNetCore/commit/a9c7c322cb) Add "webapp" alias to RazorPages template.json (#467)
* [`[d995b0418a]`](https://github.com/aspnet/AspNetCore/commit/d995b0418a) Allow BindPropertyAttribute to be specified on controller classes
* [`[f3e599649b]`](https://github.com/aspnet/AspNetCore/commit/f3e599649b) Use token instead of ssh
* [`[c7486c5f3c]`](https://github.com/aspnet/AspNetCore/commit/c7486c5f3c) Skip broken tests (#181)
* [`[64019efb0f]`](https://github.com/aspnet/AspNetCore/commit/64019efb0f) 2.1.0-preview3-26413-02 (#1068)
* [`[499d39b364]`](https://github.com/aspnet/AspNetCore/commit/499d39b364) rename MsgPack assembly only (#2005)
* [`[39f7420c4d]`](https://github.com/aspnet/AspNetCore/commit/39f7420c4d) Fixed routing test
* [`[43e6ab750a]`](https://github.com/aspnet/AspNetCore/commit/43e6ab750a) Fix #1927 by using Synchronous Callbacks everywhere. (#2003)
* [`[0919914e56]`](https://github.com/aspnet/AspNetCore/commit/0919914e56) Internalize more classes (#2004)
* [`[6130eb0ec5]`](https://github.com/aspnet/AspNetCore/commit/6130eb0ec5) Is 1888 fixed
* [`[5d52701cd2]`](https://github.com/aspnet/AspNetCore/commit/5d52701cd2) Add Error razor page to Spa templates (#464)
* [`[b67b5586f2]`](https://github.com/aspnet/AspNetCore/commit/b67b5586f2) corefx 2.1.0-preview3-26413-01 (#1064)
* [`[c35030267c]`](https://github.com/aspnet/AspNetCore/commit/c35030267c) Update usage of TestSink
* [`[a8c0970cde]`](https://github.com/aspnet/AspNetCore/commit/a8c0970cde) Check for non-null RequestServices (#1378)
* [`[2e761415e4]`](https://github.com/aspnet/AspNetCore/commit/2e761415e4) Implement IDisposable for derived types for WebApplicationFactory<T> (#7637)
* [`[3e69fdc4ad]`](https://github.com/aspnet/AspNetCore/commit/3e69fdc4ad) Delegate disposable to the IConnectionFactory (#1999)
* [`[f824751bb9]`](https://github.com/aspnet/AspNetCore/commit/f824751bb9) Added Razor class library project template [Fixes #323] Add a Razor class library project template
* [`[abe139ee16]`](https://github.com/aspnet/AspNetCore/commit/abe139ee16) Make the protocol and messages public (#1994)
* [`[4a568e90d2]`](https://github.com/aspnet/AspNetCore/commit/4a568e90d2) API review changes (#1992)
* [`[70c63fe9e8]`](https://github.com/aspnet/AspNetCore/commit/70c63fe9e8) Http.Connections.Client API Review changes (#1987)
* [`[d57da6b71f]`](https://github.com/aspnet/AspNetCore/commit/d57da6b71f) Collapse AsSpan().Slice(..) into AsSpan(..) (#2491)
* [`[0ee4a86564]`](https://github.com/aspnet/AspNetCore/commit/0ee4a86564) Collapse AsSpan().Slice(..) into AsSpan(..) (#1991)
* [`[16c6a65bf2]`](https://github.com/aspnet/AspNetCore/commit/16c6a65bf2) polyfill UInt8Array.forEach for IE (#1981)
* [`[0053124ca4]`](https://github.com/aspnet/AspNetCore/commit/0053124ca4) Make Proxies Internal (#1982)
* [`[df4d901ae7]`](https://github.com/aspnet/AspNetCore/commit/df4d901ae7) Fix 5 param On extension method (#1984)
* [`[10f3b6863e]`](https://github.com/aspnet/AspNetCore/commit/10f3b6863e)  Avoid nullref in KestrelEventSource (#2483)
* [`[c4b9e061ca]`](https://github.com/aspnet/AspNetCore/commit/c4b9e061ca) Update usage of TestSink
* [`[4188d2fe68]`](https://github.com/aspnet/AspNetCore/commit/4188d2fe68) sttimer changes to V2 (#773)
* [`[9c83280770]`](https://github.com/aspnet/AspNetCore/commit/9c83280770) Fixing couple issues (#763)
* [`[24328b8e88]`](https://github.com/aspnet/AspNetCore/commit/24328b8e88) fix #1281 by adding support for DELETE endpoint on server (#1925)
* [`[0992db9fd2]`](https://github.com/aspnet/AspNetCore/commit/0992db9fd2) fix #1914 by switching RedisProtocol to MsgPack (#1968)
* [`[c734b9910a]`](https://github.com/aspnet/AspNetCore/commit/c734b9910a) fix #1951 by transpiling to ES5 (#1970)
* [`[74f13328ed]`](https://github.com/aspnet/AspNetCore/commit/74f13328ed) Adding Utf8Json dependency (#1060)
* [`[4e1ba2a6c7]`](https://github.com/aspnet/AspNetCore/commit/4e1ba2a6c7) Delay process exit in ConsoleLifetime #1329
* [`[18a15435e9]`](https://github.com/aspnet/AspNetCore/commit/18a15435e9) Specify branch name when calling PublishToBlobFeed
* [`[ee12c4fcf2]`](https://github.com/aspnet/AspNetCore/commit/ee12c4fcf2) Downgrade HTTPs handshake failures to debug #1853
* [`[c6fa9793eb]`](https://github.com/aspnet/AspNetCore/commit/c6fa9793eb) Make Protocols internal
* [`[1fc282acb8]`](https://github.com/aspnet/AspNetCore/commit/1fc282acb8) Move Benchmark Apps to new folder and use .All package when Benchmarks runs our scenarios (#1965)
* [`[4184b2406d]`](https://github.com/aspnet/AspNetCore/commit/4184b2406d) Updated to make routing always use UrlEncoder.Default and not depend on DI to get it. [Fixes #513] RedirectToAction with Non-English Characters in Parameters and Authentication Causes Error
* [`[d4773e831c]`](https://github.com/aspnet/AspNetCore/commit/d4773e831c) Set default transport and application buffer sizes (#1964)
* [`[7563ccae20]`](https://github.com/aspnet/AspNetCore/commit/7563ccae20) Always use TaskCreationOptions.RunContinuationsAsynchronously (#1966)
* [`[1ae901de3d]`](https://github.com/aspnet/AspNetCore/commit/1ae901de3d) Fix incorrect test for long poll and web sockets requests (#1971)
* [`[ca44b4adfc]`](https://github.com/aspnet/AspNetCore/commit/ca44b4adfc) Moved kestrel specific features into transport abstractions (#2482)
* [`[e34b4e8335]`](https://github.com/aspnet/AspNetCore/commit/e34b4e8335) Use DependencyContext.CompileLibraries to determine dependency graph (#7626)
* [`[f6b2880369]`](https://github.com/aspnet/AspNetCore/commit/f6b2880369) Flow the ConnectionContext to the SNI callback (#2478)
* [`[f7d5f3e64e]`](https://github.com/aspnet/AspNetCore/commit/f7d5f3e64e) Enable trace for test app (#178)
* [`[08f9990c39]`](https://github.com/aspnet/AspNetCore/commit/08f9990c39) Ensure there's a redis connection earlier
* [`[9365fcd053]`](https://github.com/aspnet/AspNetCore/commit/9365fcd053) Don't publish the refs directory when the app does not have any Razor files
* [`[b8c3273cae]`](https://github.com/aspnet/AspNetCore/commit/b8c3273cae) Dont always copy handlers (#1945)
* [`[c9ab30e150]`](https://github.com/aspnet/AspNetCore/commit/c9ab30e150) Enable detailed errors for redis tests (#1962)
* [`[c3ac7629d1]`](https://github.com/aspnet/AspNetCore/commit/c3ac7629d1) WebAPI launchUrl; MVC _LoginPartial; F# AllowedHosts (#463)
* [`[ee6e8c15ce]`](https://github.com/aspnet/AspNetCore/commit/ee6e8c15ce) increase jasmine timeout and add timestamps to logs (#1959)
* [`[4ff09370a9]`](https://github.com/aspnet/AspNetCore/commit/4ff09370a9) Delete Startup.cs (#35)
* [`[e411cbf7e2]`](https://github.com/aspnet/AspNetCore/commit/e411cbf7e2) Moving PlatformBenchmarks from aspnet/benchmarks (#2457)
* [`[6d9df1ef33]`](https://github.com/aspnet/AspNetCore/commit/6d9df1ef33) Noop Razor Sdk for F# projects
* [`[a5b8be2ad3]`](https://github.com/aspnet/AspNetCore/commit/a5b8be2ad3) Update UpdateDependencies script
* [`[0b5cb8a8b8]`](https://github.com/aspnet/AspNetCore/commit/0b5cb8a8b8) Reload HostFilteringOptions on change
* [`[5c34364d73]`](https://github.com/aspnet/AspNetCore/commit/5c34364d73) Move ANCM Request Handler pdb to correct location
* [`[8cc851ff9b]`](https://github.com/aspnet/AspNetCore/commit/8cc851ff9b) Clean up timer code with custom awaitable (#1935)
* [`[cb5bba36fc]`](https://github.com/aspnet/AspNetCore/commit/cb5bba36fc) Get off the event loop before dispatch (#1952)
* [`[62272ad56a]`](https://github.com/aspnet/AspNetCore/commit/62272ad56a) Round off file result's LastModifiedDate to whole seconds for correct comparison with http header dates [Fixes #7572] PhysicalFileResult does not respond 304 Not Modified
* [`[182209cb63]`](https://github.com/aspnet/AspNetCore/commit/182209cb63) Add ANCMV1 package (#1050)
* [`[83821a028d]`](https://github.com/aspnet/AspNetCore/commit/83821a028d) Rename HubEndPointTestUtils folder (#1943)
* [`[13f7981010]`](https://github.com/aspnet/AspNetCore/commit/13f7981010) Rename Callback to Configure in UseConnections (#1939)
* [`[e2169ceda6]`](https://github.com/aspnet/AspNetCore/commit/e2169ceda6) Connect to Redis asynchronously (#1922)
* [`[71be5bf637]`](https://github.com/aspnet/AspNetCore/commit/71be5bf637) fix logging browser tests (#1940)
* [`[49acd16712]`](https://github.com/aspnet/AspNetCore/commit/49acd16712) Updating external dependencies
* [`[46efcd9332]`](https://github.com/aspnet/AspNetCore/commit/46efcd9332) Move srwWrapper to right location
* [`[5c91dbe062]`](https://github.com/aspnet/AspNetCore/commit/5c91dbe062) Get tests working
* [`[b978df455c]`](https://github.com/aspnet/AspNetCore/commit/b978df455c) Create a separate nuget package for ANCMV1
* [`[df9efa0770]`](https://github.com/aspnet/AspNetCore/commit/df9efa0770) Code changes to get ANCM current working on github
* [`[b594130020]`](https://github.com/aspnet/AspNetCore/commit/b594130020) Adds source code from VSTS
* [`[157e7f4fdd]`](https://github.com/aspnet/AspNetCore/commit/157e7f4fdd) Creates two separate projects for ANCM V1 and V2.
* [`[5fa2892561]`](https://github.com/aspnet/AspNetCore/commit/5fa2892561) Change the HubSample to reconnect to the server (#1933)
* [`[bec259f976]`](https://github.com/aspnet/AspNetCore/commit/bec259f976) #364 - Expose HTTP_503_RESPONSE_VERBOSITY option (#447)
* [`[da32f45f58]`](https://github.com/aspnet/AspNetCore/commit/da32f45f58) Do not set sslPort if HTTPS not configured (#458)
* [`[2657a17a63]`](https://github.com/aspnet/AspNetCore/commit/2657a17a63) Use an older version of microsoft/dotnet which still has libunwind.so in it
* [`[d63e8c5558]`](https://github.com/aspnet/AspNetCore/commit/d63e8c5558) CPP
* [`[5504374125]`](https://github.com/aspnet/AspNetCore/commit/5504374125) Preserve directive node diagnostics in document node
* [`[14cc048102]`](https://github.com/aspnet/AspNetCore/commit/14cc048102) Fix npm command
* [`[8e261175d2]`](https://github.com/aspnet/AspNetCore/commit/8e261175d2) Generate a .csv file containing tag information
* [`[c5db8370d0]`](https://github.com/aspnet/AspNetCore/commit/c5db8370d0) chmod +x .sh scripts
* [`[78e4d4383c]`](https://github.com/aspnet/AspNetCore/commit/78e4d4383c) Updating external dependencies to '20180406-05-1567334' (release/2.1) (#1044)
* [`[ee2e46a614]`](https://github.com/aspnet/AspNetCore/commit/ee2e46a614) What about now?
* [`[6b18dea711]`](https://github.com/aspnet/AspNetCore/commit/6b18dea711) Replace Constants.CompletedTask with Task.CompletedTask (#235)
* [`[61f7c82d49]`](https://github.com/aspnet/AspNetCore/commit/61f7c82d49) Replace Helpers.CompletedTask and Helpers.CanceledTask (#446)
* [`[8a3516284e]`](https://github.com/aspnet/AspNetCore/commit/8a3516284e) Add GetMessageBytes to IHubProtocol (#1915)
* [`[31dfe91962]`](https://github.com/aspnet/AspNetCore/commit/31dfe91962) Support async access token factory (#1911)
* [`[6bc2ebb4c5]`](https://github.com/aspnet/AspNetCore/commit/6bc2ebb4c5) Use invariant culture and ordinal comparisons (#1928)
* [`[32bbc58bef]`](https://github.com/aspnet/AspNetCore/commit/32bbc58bef) Replace messagepack dependency (#1046)
* [`[b030ab7e49]`](https://github.com/aspnet/AspNetCore/commit/b030ab7e49) Update Connections.Abstractions.csproj (#2473)
* [`[f4313170f8]`](https://github.com/aspnet/AspNetCore/commit/f4313170f8) Split HandshakeProtocol into another class (#1921)
* [`[6d050140e5]`](https://github.com/aspnet/AspNetCore/commit/6d050140e5) Swtich to MessagePack-CSharp (#1879)
* [`[e32b51d6e6]`](https://github.com/aspnet/AspNetCore/commit/e32b51d6e6) ENdpoint
* [`[ecd665c471]`](https://github.com/aspnet/AspNetCore/commit/ecd665c471) Crank 2: Let's Get Crankier (#1888)
* [`[7afb3b6b12]`](https://github.com/aspnet/AspNetCore/commit/7afb3b6b12) Adds Gtest. (#762)
* [`[3db924003e]`](https://github.com/aspnet/AspNetCore/commit/3db924003e) Use VirtualRazorProjectSystem for Razor tests
* [`[7a14be006d]`](https://github.com/aspnet/AspNetCore/commit/7a14be006d) Fast reads
* [`[c4196fabf3]`](https://github.com/aspnet/AspNetCore/commit/c4196fabf3) Fix npm command
* [`[0feb83b637]`](https://github.com/aspnet/AspNetCore/commit/0feb83b637) Dont format some things
* [`[ec31ff0c28]`](https://github.com/aspnet/AspNetCore/commit/ec31ff0c28) Throw if multiple Body bound parameters are discovered
* [`[dca31cc6f6]`](https://github.com/aspnet/AspNetCore/commit/dca31cc6f6) Perf
* [`[01089da84d]`](https://github.com/aspnet/AspNetCore/commit/01089da84d) Use in for ReadOnlySequence (#1900)
* [`[962ea25637]`](https://github.com/aspnet/AspNetCore/commit/962ea25637) Update deps (#1919)
* [`[7ed3ccb768]`](https://github.com/aspnet/AspNetCore/commit/7ed3ccb768) Update to core-setup 2.0.7-20180406 packages
* [`[406d8f9a81]`](https://github.com/aspnet/AspNetCore/commit/406d8f9a81) readonly readonly structs (#1908)
* [`[bd78785f8d]`](https://github.com/aspnet/AspNetCore/commit/bd78785f8d)  Minor DefaultHubLifetimeManager improvements (#1904)
* [`[9fd713c73a]`](https://github.com/aspnet/AspNetCore/commit/9fd713c73a) Make MemoryBufferWriter a Stream (#1907)
* [`[27d18578d0]`](https://github.com/aspnet/AspNetCore/commit/27d18578d0) Use expression body properties and implicit arrays where possible (#1906)
* [`[0f663cadc4]`](https://github.com/aspnet/AspNetCore/commit/0f663cadc4) readonly all the things (#1901)
* [`[767f2900f9]`](https://github.com/aspnet/AspNetCore/commit/767f2900f9) Add support for creating a bounded channel in helper
* [`[0d9c3d8898]`](https://github.com/aspnet/AspNetCore/commit/0d9c3d8898) Buffer messages so we get a single outgoing request (#1898)
* [`[c1049b722d]`](https://github.com/aspnet/AspNetCore/commit/c1049b722d) The grand unification of ConnectionContext (#1895)
* [`[e3da7feab4]`](https://github.com/aspnet/AspNetCore/commit/e3da7feab4) Clean up client ITransport interface (#1893)
* [`[86083c0302]`](https://github.com/aspnet/AspNetCore/commit/86083c0302) Removing native support for IObservable<T> (#1890)
* [`[05ebd10258]`](https://github.com/aspnet/AspNetCore/commit/05ebd10258) Make baseUrl work again (#1889)
* [`[acc0b7ad0d]`](https://github.com/aspnet/AspNetCore/commit/acc0b7ad0d) Serialize NegotiateResponse with IBufferWriter (#1881)
* [`[699d17fdeb]`](https://github.com/aspnet/AspNetCore/commit/699d17fdeb) Don't generate crossgen symbols if the framework is not crossgen-ed
* [`[f632330d7f]`](https://github.com/aspnet/AspNetCore/commit/f632330d7f) Allocate pipe writer stream per connection (#1885)
* [`[50ce20f0f9]`](https://github.com/aspnet/AspNetCore/commit/50ce20f0f9) Generate an arm32 shared framework without crossgen (#1037)
* [`[e51676fb47]`](https://github.com/aspnet/AspNetCore/commit/e51676fb47) Policheck errors
* [`[6c79085b10]`](https://github.com/aspnet/AspNetCore/commit/6c79085b10) Use PackageVersion to define version of the LineupPackage
* [`[b6ce0b5188]`](https://github.com/aspnet/AspNetCore/commit/b6ce0b5188) Update submodules
* [`[e3d90bdf6a]`](https://github.com/aspnet/AspNetCore/commit/e3d90bdf6a) Fix graceful closing of pipes (#1882)
* [`[5e019bd707]`](https://github.com/aspnet/AspNetCore/commit/5e019bd707) Add Microsoft.AspNetCore.All
* [`[d48a33cdab]`](https://github.com/aspnet/AspNetCore/commit/d48a33cdab) Update EFCore submodule
* [`[4ddf8664c0]`](https://github.com/aspnet/AspNetCore/commit/4ddf8664c0) Don't throw from Observer's OnNext (#1872)
* [`[36edadabb4]`](https://github.com/aspnet/AspNetCore/commit/36edadabb4) Lock when sending data to connection (#1876)
* [`[921986d561]`](https://github.com/aspnet/AspNetCore/commit/921986d561) Fix AccessTokenFactory not being called with each request (#1880)
* [`[b0c4e9d0f7]`](https://github.com/aspnet/AspNetCore/commit/b0c4e9d0f7) 0 byte read in WebSockets (#1878)
* [`[4cea9d3f2f]`](https://github.com/aspnet/AspNetCore/commit/4cea9d3f2f) Update Polly.Extensions.Http-Signed dependency
* [`[a29b8ae396]`](https://github.com/aspnet/AspNetCore/commit/a29b8ae396) fix #1874 by adding RedisProtocolBenchmark (#1875)
* [`[4cd24a2b08]`](https://github.com/aspnet/AspNetCore/commit/4cd24a2b08) Add experimental flag to un-special-case data-
* [`[d1c0ab587c]`](https://github.com/aspnet/AspNetCore/commit/d1c0ab587c) Add support for type parameters to class nodes
* [`[5356456766]`](https://github.com/aspnet/AspNetCore/commit/5356456766) Simplify test TFMs #82
* [`[19b2fea0d8]`](https://github.com/aspnet/AspNetCore/commit/19b2fea0d8) Preserialize for all formats when sending through Redis (#1843)
* [`[9f7e295af8]`](https://github.com/aspnet/AspNetCore/commit/9f7e295af8) Add task to generate the repo to repo graph (#1036)
* [`[47c7c1ad8f]`](https://github.com/aspnet/AspNetCore/commit/47c7c1ad8f) Disable global loading of RequestHandler for in-process (#732)
* [`[4236f0e51c]`](https://github.com/aspnet/AspNetCore/commit/4236f0e51c) Fix AllowedHosts configuration (#452)
* [`[35b6d81f77]`](https://github.com/aspnet/AspNetCore/commit/35b6d81f77) Don't dispose on cancellation (#1859)
* [`[c78df3e261]`](https://github.com/aspnet/AspNetCore/commit/c78df3e261) Added Microsoft.AspNetCore.SignalR.Protocols.Json (#1035)
* [`[61c3d0c403]`](https://github.com/aspnet/AspNetCore/commit/61c3d0c403) Added Microsoft.AspNetCore.SignalR.Protocols.Json (#1861)
* [`[e9db9e64c7]`](https://github.com/aspnet/AspNetCore/commit/e9db9e64c7) Add streaming benchmarks (#1854)
* [`[f7fc2647de]`](https://github.com/aspnet/AspNetCore/commit/f7fc2647de) var all the things (#1855)
* [`[e51852d0fc]`](https://github.com/aspnet/AspNetCore/commit/e51852d0fc) Use Anchor tag to normalize urls(#1828)
* [`[fccc9d1b50]`](https://github.com/aspnet/AspNetCore/commit/fccc9d1b50) fix #1815 by disposing linked cts (#1849)
* [`[6b76d1355e]`](https://github.com/aspnet/AspNetCore/commit/6b76d1355e) Add SendAsyncGroup to broadcast benchmarks (#1852)
* [`[8a368b5610]`](https://github.com/aspnet/AspNetCore/commit/8a368b5610) Add supportedAuthentication for NoAuth in templates which have NoAuth (#443)
* [`[ae42d7599d]`](https://github.com/aspnet/AspNetCore/commit/ae42d7599d) Show error if page directive is not at the top of file
* [`[32b4d5cc6c]`](https://github.com/aspnet/AspNetCore/commit/32b4d5cc6c) Set X-Requested-With on all requests (#1848)
* [`[80f87e7730]`](https://github.com/aspnet/AspNetCore/commit/80f87e7730) Add Handshake timeout to C# Client (#1840)
* [`[d9c823d3b0]`](https://github.com/aspnet/AspNetCore/commit/d9c823d3b0) Renable auth tests with new HttpClient #439, ServerTests/#82
* [`[2ee0d6e337]`](https://github.com/aspnet/AspNetCore/commit/2ee0d6e337) Delay loading the dev cert #2422
* [`[9f530d6621]`](https://github.com/aspnet/AspNetCore/commit/9f530d6621) Chunk writes to file in tests (#759)
* [`[9ea2c50068]`](https://github.com/aspnet/AspNetCore/commit/9ea2c50068) Add SNI support #2357
* [`[f44af6b812]`](https://github.com/aspnet/AspNetCore/commit/f44af6b812) Reenable IISExpress out of process tests; add ANCM in process tests. (#106)
* [`[f5aeef7319]`](https://github.com/aspnet/AspNetCore/commit/f5aeef7319) Update NetCoreApp to preview2-26403-06
* [`[313772ef03]`](https://github.com/aspnet/AspNetCore/commit/313772ef03) fix #1727 by adding polyfills for IE (#1841)
* [`[45c9ad4712]`](https://github.com/aspnet/AspNetCore/commit/45c9ad4712) Update NetCoreApp to preview2-26403-06
* [`[b1007744b0]`](https://github.com/aspnet/AspNetCore/commit/b1007744b0) Added PipeOptions.CurrentUserOnly option to the named pipe streams
* [`[afa56e3012]`](https://github.com/aspnet/AspNetCore/commit/afa56e3012) MsgPack perf (#1845)
* [`[99ae47be09]`](https://github.com/aspnet/AspNetCore/commit/99ae47be09) Add ability to log message content (#1792)
* [`[7c2d9e87e9]`](https://github.com/aspnet/AspNetCore/commit/7c2d9e87e9) Clean up pipe pair on transport start failure (#1836)
* [`[ba0131a731]`](https://github.com/aspnet/AspNetCore/commit/ba0131a731) Rename TransportTypes to HttpTransportTypes (#1839)
* [`[5e38303377]`](https://github.com/aspnet/AspNetCore/commit/5e38303377) Use xhr.onreadystatechange instead of xhr.onload (#1838)
* [`[9c9d732da6]`](https://github.com/aspnet/AspNetCore/commit/9c9d732da6) Upgraded dependencies
* [`[09418f1e39]`](https://github.com/aspnet/AspNetCore/commit/09418f1e39) Re-add dotnet-core myget feed
* [`[ed55571572]`](https://github.com/aspnet/AspNetCore/commit/ed55571572) Fix path to tool for CI (#438)
* [`[769dd4684a]`](https://github.com/aspnet/AspNetCore/commit/769dd4684a) Add NewtonsoftJsonPackageVersion back
* [`[ab55bae128]`](https://github.com/aspnet/AspNetCore/commit/ab55bae128) Add dotnet-ef to dependencies.props (#435)
* [`[0a5a963bb0]`](https://github.com/aspnet/AspNetCore/commit/0a5a963bb0) Use dotnet-ef package (#433)
* [`[612db42772]`](https://github.com/aspnet/AspNetCore/commit/612db42772) Re-enable SSL tests cross plat Home/#2477
* [`[c222a398db]`](https://github.com/aspnet/AspNetCore/commit/c222a398db) Fix TLS versions for Mac
* [`[623c27ab01]`](https://github.com/aspnet/AspNetCore/commit/623c27ab01) Dispose SocketAsyncEventArgs when we dispose the Socket (#2459)
* [`[221c95e0af]`](https://github.com/aspnet/AspNetCore/commit/221c95e0af) Couple logging additions (#1827)
* [`[a92da1b8f4]`](https://github.com/aspnet/AspNetCore/commit/a92da1b8f4) Fix CopyToAsyncDoesNotCopyBlocks test (#2458)
* [`[26957e090d]`](https://github.com/aspnet/AspNetCore/commit/26957e090d) Reaction to *Memory changes (#420)
* [`[6a1367ff70]`](https://github.com/aspnet/AspNetCore/commit/6a1367ff70) Reaction to *Memory changes (#1824)
* [`[ba2b883db0]`](https://github.com/aspnet/AspNetCore/commit/ba2b883db0) Reaction to *Memory changes (#2446)
* [`[7450163495]`](https://github.com/aspnet/AspNetCore/commit/7450163495) Reaction to *Memory changes (#1029)
* [`[f52359d202]`](https://github.com/aspnet/AspNetCore/commit/f52359d202) Update AJAX CDN links (#430)
* [`[d1b745f249]`](https://github.com/aspnet/AspNetCore/commit/d1b745f249) Use Razor.Sdk package to verify templates
* [`[6b183c5ac0]`](https://github.com/aspnet/AspNetCore/commit/6b183c5ac0) Use 4K as the minimum segment size (#2452)
* [`[2872a236ec]`](https://github.com/aspnet/AspNetCore/commit/2872a236ec) Updating external dependencies to '20180330-03-1543000' (#1024)
* [`[1b5a2f25e4]`](https://github.com/aspnet/AspNetCore/commit/1b5a2f25e4) Versions
* [`[9930499ee1]`](https://github.com/aspnet/AspNetCore/commit/9930499ee1) Work around HttpClient TLS regression
* [`[2466764b65]`](https://github.com/aspnet/AspNetCore/commit/2466764b65) update Kestrel submodule
* [`[3460d44848]`](https://github.com/aspnet/AspNetCore/commit/3460d44848) Fix non-serializable tests (#1820)
* [`[5d1bd0b70d]`](https://github.com/aspnet/AspNetCore/commit/5d1bd0b70d) update SignalR submodule
* [`[fbdb3c558f]`](https://github.com/aspnet/AspNetCore/commit/fbdb3c558f) Mark dotnet-aspnet-codegenerator as noship (#1022)
* [`[6e957e436a]`](https://github.com/aspnet/AspNetCore/commit/6e957e436a) Support inprocess hosting in IISExpressDeployer via switching the HostingModel property. (#1368)
* [`[5ce672dfe6]`](https://github.com/aspnet/AspNetCore/commit/5ce672dfe6) ThreadStatic MemoryBufferWriter (#1821)
* [`[6640f14e35]`](https://github.com/aspnet/AspNetCore/commit/6640f14e35) Detailed errors enabled for functional tests (#1822)
* [`[852a5b31be]`](https://github.com/aspnet/AspNetCore/commit/852a5b31be) Fix bad rebase
* [`[07a1907918]`](https://github.com/aspnet/AspNetCore/commit/07a1907918) Introduce ViewDataAttribute
* [`[6d4a632b96]`](https://github.com/aspnet/AspNetCore/commit/6d4a632b96) Fix race condition in test code waiting for dotnet-watch to restart
* [`[e9d58154ec]`](https://github.com/aspnet/AspNetCore/commit/e9d58154ec) Added TCP client sample to HubSample (#1805)
* [`[0ed396db0b]`](https://github.com/aspnet/AspNetCore/commit/0ed396db0b) Enable tests on 2.1 for Win7
* [`[c515cece8e]`](https://github.com/aspnet/AspNetCore/commit/c515cece8e) Use ModelMetadataProvider to infer BindingSource on application model
* [`[bbc9f56ece]`](https://github.com/aspnet/AspNetCore/commit/bbc9f56ece) update artifacts.props in dev (#1025)
* [`[ef30e2e2df]`](https://github.com/aspnet/AspNetCore/commit/ef30e2e2df) Clean up the SSE client side transport (#1816)
* [`[bb7cb14a1c]`](https://github.com/aspnet/AspNetCore/commit/bb7cb14a1c) Clean up the logging style for HttpConnectionManager (#1819)
* [`[82bda4a9c8]`](https://github.com/aspnet/AspNetCore/commit/82bda4a9c8) Added micro benchmarks for SSE parsing and Writing (#1818)
* [`[a37fa83aee]`](https://github.com/aspnet/AspNetCore/commit/a37fa83aee)  Fixed a parser bug found when trying out the array pool (#2450)
* [`[ca161e9bc8]`](https://github.com/aspnet/AspNetCore/commit/ca161e9bc8) Improve writing single characters with UTF8 text writer (#1814)
* [`[e6e45cea05]`](https://github.com/aspnet/AspNetCore/commit/e6e45cea05) Change how HttpConnection sets headers (#1806)
* [`[04a22f23dd]`](https://github.com/aspnet/AspNetCore/commit/04a22f23dd) Deserializing ISO formatted strings in method arguments (#1812)
* [`[dc86690f04]`](https://github.com/aspnet/AspNetCore/commit/dc86690f04) Change default handshake timeout (#1808)
* [`[3a2a571c11]`](https://github.com/aspnet/AspNetCore/commit/3a2a571c11) Update to preview2-26330-05 (#1023)
* [`[7382198356]`](https://github.com/aspnet/AspNetCore/commit/7382198356) Copy connection middleware when using ListenLocalHost (#2447)
* [`[903a9ea6a0]`](https://github.com/aspnet/AspNetCore/commit/903a9ea6a0) Use IBufferWriter in IHubProtocol (#1791)
* [`[ba7b43a391]`](https://github.com/aspnet/AspNetCore/commit/ba7b43a391) Reaction to *Memory changes
* [`[0293e53e11]`](https://github.com/aspnet/AspNetCore/commit/0293e53e11) Handle uninitialized connections in disposal (#1786) (#1794)
* [`[9428f49b8e]`](https://github.com/aspnet/AspNetCore/commit/9428f49b8e) update deps
* [`[eb7dc14c39]`](https://github.com/aspnet/AspNetCore/commit/eb7dc14c39) Handle uninitialized connections in disposal (#1786)
* [`[67cb8a0e11]`](https://github.com/aspnet/AspNetCore/commit/67cb8a0e11) Add IConnection to Connections.Abstractions (#2444)
* [`[1f41b26145]`](https://github.com/aspnet/AspNetCore/commit/1f41b26145) Skip broken test
* [`[6b3a27e73c]`](https://github.com/aspnet/AspNetCore/commit/6b3a27e73c) Bedrock Renames (#1777)
* [`[8ea2de1dc2]`](https://github.com/aspnet/AspNetCore/commit/8ea2de1dc2) Check native HRESULTs (#742)
* [`[ac9addabcc]`](https://github.com/aspnet/AspNetCore/commit/ac9addabcc) Update jquery-validation-unobtrusive (#421)
* [`[30f0883319]`](https://github.com/aspnet/AspNetCore/commit/30f0883319) Target a lower TFM
* [`[133dd964ab]`](https://github.com/aspnet/AspNetCore/commit/133dd964ab) Introduce ViewDataAttribute
* [`[1186ab688b]`](https://github.com/aspnet/AspNetCore/commit/1186ab688b) noship .RH
* [`[0362905a70]`](https://github.com/aspnet/AspNetCore/commit/0362905a70) Re-enable ConnectionCanSendAndReceiveMessages + logging (#1778)
* [`[a49d7a64be]`](https://github.com/aspnet/AspNetCore/commit/a49d7a64be) Add new Polly HTTP dependency
* [`[61f260e386]`](https://github.com/aspnet/AspNetCore/commit/61f260e386) Make Microsoft.AspNetCore.Mvc depend on Microsoft.AspNetCore.Mvc.Analyzers
* [`[6f03496448]`](https://github.com/aspnet/AspNetCore/commit/6f03496448) Make Microsoft.AspNetCore.Mvc depend on Microsoft.AspNetCore.Mvc.Analyzers
* [`[313133131f]`](https://github.com/aspnet/AspNetCore/commit/313133131f) Check for Websockets in Fallback functional tests (#1772)
* [`[44b667b3e6]`](https://github.com/aspnet/AspNetCore/commit/44b667b3e6) Add detailed error option (#1763)
* [`[173594db1f]`](https://github.com/aspnet/AspNetCore/commit/173594db1f) Add new Polly HTTP dependency
* [`[3f40f042bc]`](https://github.com/aspnet/AspNetCore/commit/3f40f042bc) out of process fix (#738)
* [`[adbbbcf4de]`](https://github.com/aspnet/AspNetCore/commit/adbbbcf4de) Disable regressed negotiate test #439
* [`[b5a2fcb96a]`](https://github.com/aspnet/AspNetCore/commit/b5a2fcb96a) Dispose the http client in DisposeAsync (#1780)
* [`[a26e6f5a30]`](https://github.com/aspnet/AspNetCore/commit/a26e6f5a30) Make shutdown logic for SSE and LongPolling more similar to WebSockets (#1779)
* [`[21d0475cf2]`](https://github.com/aspnet/AspNetCore/commit/21d0475cf2) Add Microsoft.AspNetCore.Analyzers.Experimental package
* [`[f20bf9ea02]`](https://github.com/aspnet/AspNetCore/commit/f20bf9ea02) Fix #7503 change to model name for IValidableObject
* [`[7a1096a72b]`](https://github.com/aspnet/AspNetCore/commit/7a1096a72b) Fix #7503 change to model name for IValidableObject
* [`[96f29c5696]`](https://github.com/aspnet/AspNetCore/commit/96f29c5696) Use latest compat version in MvcSandbox
* [`[7b3491e11e]`](https://github.com/aspnet/AspNetCore/commit/7b3491e11e) Prepare to 0 byte flush change (#2442)
* [`[51fb15d6cf]`](https://github.com/aspnet/AspNetCore/commit/51fb15d6cf) Client logging fixes and improvements (#1773)
* [`[46f27cdd0b]`](https://github.com/aspnet/AspNetCore/commit/46f27cdd0b) Fix internal HubConnection state when handshake fails (#1774)
* [`[365e255c9b]`](https://github.com/aspnet/AspNetCore/commit/365e255c9b) Add authentication UI packages to the LZMA
* [`[df6471f462]`](https://github.com/aspnet/AspNetCore/commit/df6471f462) Add startup filter to detect overriden server (#740)
* [`[476d337989]`](https://github.com/aspnet/AspNetCore/commit/476d337989) Move Cpp Client to main repo (#1703)
* [`[2f9ce959ea]`](https://github.com/aspnet/AspNetCore/commit/2f9ce959ea) Target net461 for all tests (#420)
* [`[cb7942abe4]`](https://github.com/aspnet/AspNetCore/commit/cb7942abe4) Add no-https option for all templates (#413)
* [`[aca30fe8a2]`](https://github.com/aspnet/AspNetCore/commit/aca30fe8a2) --no-https option for RazorPagesWeb-CSharp template (#362)
* [`[a2a920dde5]`](https://github.com/aspnet/AspNetCore/commit/a2a920dde5) Normalize the tool assembly path before using it as the base for pipe name
* [`[5ae68a012c]`](https://github.com/aspnet/AspNetCore/commit/5ae68a012c) Re-enable F# template tests
* [`[199c70b72e]`](https://github.com/aspnet/AspNetCore/commit/199c70b72e) Reenable ReadAndWriteEchoTwice test (#739)
* [`[2a64c1953d]`](https://github.com/aspnet/AspNetCore/commit/2a64c1953d) Skip broken tests
* [`[a4d0bf2e3a]`](https://github.com/aspnet/AspNetCore/commit/a4d0bf2e3a) collect log messages during browser tests (#1670)
* [`[7a53e07623]`](https://github.com/aspnet/AspNetCore/commit/7a53e07623) Parse data as it comes in off the wire in the .NET client and server (#1766)
* [`[988972e1e5]`](https://github.com/aspnet/AspNetCore/commit/988972e1e5) Disable regressed negotiate test #439
* [`[d360886b78]`](https://github.com/aspnet/AspNetCore/commit/d360886b78) Fix #7558 infer [FromRoute] with parameter in ANY route
* [`[cddf46c0cd]`](https://github.com/aspnet/AspNetCore/commit/cddf46c0cd) Make HubConnection write messages directly to the PipeWriter (#1762)
* [`[eaaaeb1ba3]`](https://github.com/aspnet/AspNetCore/commit/eaaaeb1ba3) Upgrade deps (#1761)
* [`[7f86b92f7e]`](https://github.com/aspnet/AspNetCore/commit/7f86b92f7e) Handshake and negotiation optimization (#1731)
* [`[03938dfd95]`](https://github.com/aspnet/AspNetCore/commit/03938dfd95) Handle Mutex creation exceptions
* [`[d5dafae2cc]`](https://github.com/aspnet/AspNetCore/commit/d5dafae2cc) Always flush in WebSocketsTransport (#1756)
* [`[289d3592fa]`](https://github.com/aspnet/AspNetCore/commit/289d3592fa) Update to SQLitePCLRaw 1.1.10
* [`[8c84518ecc]`](https://github.com/aspnet/AspNetCore/commit/8c84518ecc) Message writing optimization (#1683)
* [`[890c8566d6]`](https://github.com/aspnet/AspNetCore/commit/890c8566d6) Fix WebSocketsSupportedConditionAttribute version check (#1751)
* [`[c06de96bd3]`](https://github.com/aspnet/AspNetCore/commit/c06de96bd3) Do not canonicalize short paths (#736)
* [`[5b0af04b29]`](https://github.com/aspnet/AspNetCore/commit/5b0af04b29) Fix RPM generation when store folder is empty, and add restore source for dotnetfeed
* [`[19b9dca268]`](https://github.com/aspnet/AspNetCore/commit/19b9dca268) Change IHubProtocol interface to support partial parsing (#1745)
* [`[f8e315d03d]`](https://github.com/aspnet/AspNetCore/commit/f8e315d03d) CompiledPageRouteModelProvider should de-dup descriptors
* [`[adb254f4bb]`](https://github.com/aspnet/AspNetCore/commit/adb254f4bb) Add the 2.0.6 manifest to Microsoft.AspNetCore.All
* [`[5b85e8309e]`](https://github.com/aspnet/AspNetCore/commit/5b85e8309e) Adding File Header (#1741)
* [`[d2564cf4e6]`](https://github.com/aspnet/AspNetCore/commit/d2564cf4e6) Upgrade deps
* [`[5cb9b887d4]`](https://github.com/aspnet/AspNetCore/commit/5cb9b887d4) Upgraded deps
* [`[7b0f50aa53]`](https://github.com/aspnet/AspNetCore/commit/7b0f50aa53) Expand environment variables processPath and arguments, reject invalid processPaths. (#715)
* [`[c93c168df3]`](https://github.com/aspnet/AspNetCore/commit/c93c168df3) Add mapping service for action results
* [`[62881a2cc4]`](https://github.com/aspnet/AspNetCore/commit/62881a2cc4) Disable APICheck on precompilation to workaround failure
* [`[dd27854c42]`](https://github.com/aspnet/AspNetCore/commit/dd27854c42) Add .App metapackage to the LZMA
* [`[c217e7b690]`](https://github.com/aspnet/AspNetCore/commit/c217e7b690)  Add deps file RH injection  (#731)
* [`[61ffc55bc1]`](https://github.com/aspnet/AspNetCore/commit/61ffc55bc1) Add ANCM version to generate list of deps versions
* [`[26815a688c]`](https://github.com/aspnet/AspNetCore/commit/26815a688c) Update universe for DockerSecrets rename (#1004)
* [`[bc91191876]`](https://github.com/aspnet/AspNetCore/commit/bc91191876) More benchmark command fixes
* [`[df317cffca]`](https://github.com/aspnet/AspNetCore/commit/df317cffca) Fixing benchmarks
* [`[ad724f6b0a]`](https://github.com/aspnet/AspNetCore/commit/ad724f6b0a) Use x64 binaries when project's targeting AnyCPU (#255)
* [`[927af3125e]`](https://github.com/aspnet/AspNetCore/commit/927af3125e) Use RazorCompiledItemMetadataAttribute to calculate route
* [`[f25f411b68]`](https://github.com/aspnet/AspNetCore/commit/f25f411b68) Add HostFiltering configuration to templates
* [`[62fec52a9f]`](https://github.com/aspnet/AspNetCore/commit/62fec52a9f) Add a framework specific reference to Microsoft.DiaSymReader.Native
* [`[3fe479ab83]`](https://github.com/aspnet/AspNetCore/commit/3fe479ab83) Add MicrosoftDiaSymReaderNativePackageVersion
* [`[428e470e83]`](https://github.com/aspnet/AspNetCore/commit/428e470e83) Fix UpdateDependencies script for maestro
* [`[3d88d912e6]`](https://github.com/aspnet/AspNetCore/commit/3d88d912e6) Updating external dependencies to '20180325-03-1519352' (#998)
* [`[895ccb6b10]`](https://github.com/aspnet/AspNetCore/commit/895ccb6b10) Add MicrosoftDiaSymReaderNativePackageVersion
* [`[db1bdc7ede]`](https://github.com/aspnet/AspNetCore/commit/db1bdc7ede) Upgraded dependencies
* [`[d1215d8fa1]`](https://github.com/aspnet/AspNetCore/commit/d1215d8fa1) Skip checking thumbprint of file in osx
* [`[b7e2678592]`](https://github.com/aspnet/AspNetCore/commit/b7e2678592) Add new SignalR scenarios (#1730)
* [`[d6c296ba8c]`](https://github.com/aspnet/AspNetCore/commit/d6c296ba8c) Updating external dependencies to '20180325-03-1519352' (#998)
* [`[203ebb64ed]`](https://github.com/aspnet/AspNetCore/commit/203ebb64ed) Updated dependencies.props
* [`[d94db644e3]`](https://github.com/aspnet/AspNetCore/commit/d94db644e3) Backport: separate list of dependency versions and dependency items, and stop issuing KRB4002 on duplicates
* [`[ade5ae534d]`](https://github.com/aspnet/AspNetCore/commit/ade5ae534d) Set DebugType=full for .NET Framework projects
* [`[0c084fa28a]`](https://github.com/aspnet/AspNetCore/commit/0c084fa28a) [Fixes #7518] NullReferenceException thrown when Controller method uses Guid parameter default value
* [`[be04ccac6e]`](https://github.com/aspnet/AspNetCore/commit/be04ccac6e) Move DuplexPipe into Kestrel.Core as internal (#2428)
* [`[b78e70fadb]`](https://github.com/aspnet/AspNetCore/commit/b78e70fadb) Use more pooled Utf8BufferTextReaders (#1728)
* [`[cc52beec17]`](https://github.com/aspnet/AspNetCore/commit/cc52beec17) Fallback for TS client
* [`[79b51ad642]`](https://github.com/aspnet/AspNetCore/commit/79b51ad642) Added logging of .NET client HTTP requests (#1723)
* [`[804eeede11]`](https://github.com/aspnet/AspNetCore/commit/804eeede11) Use the correct application part factory by default
* [`[05145c2751]`](https://github.com/aspnet/AspNetCore/commit/05145c2751) Fix UpdateDependencies script for maestro
* [`[e80d0b000a]`](https://github.com/aspnet/AspNetCore/commit/e80d0b000a) Make BufferedReadString public and add doc (#1011)
* [`[eb5b94e3c4]`](https://github.com/aspnet/AspNetCore/commit/eb5b94e3c4) Make consistent variable names for RestoreSourcePropsPath
* [`[b8285b8356]`](https://github.com/aspnet/AspNetCore/commit/b8285b8356) Don't create the span on netstandard (#1721)
* [`[3f6051c9d5]`](https://github.com/aspnet/AspNetCore/commit/3f6051c9d5) Make PreserveCompilationContext=true
* [`[1e11b5fa95]`](https://github.com/aspnet/AspNetCore/commit/1e11b5fa95) Make PreserveCompilationContext=true
* [`[da255ff9db]`](https://github.com/aspnet/AspNetCore/commit/da255ff9db) Make `TestProject.GetProjectDirectory` more thorough when finding project directory.
* [`[e1cb3f25ac]`](https://github.com/aspnet/AspNetCore/commit/e1cb3f25ac) Switch to AddDefaultIdentity
* [`[a1de323ff4]`](https://github.com/aspnet/AspNetCore/commit/a1de323ff4) Make LibuvTransport(Factory) pubternal (#2426)
* [`[cc58605db6]`](https://github.com/aspnet/AspNetCore/commit/cc58605db6) Update to Newtonsoft.Json 11.0.2
* [`[0716789523]`](https://github.com/aspnet/AspNetCore/commit/0716789523) move to test folder
* [`[f292383090]`](https://github.com/aspnet/AspNetCore/commit/f292383090) use iisintegration
* [`[ddc0e4fb3a]`](https://github.com/aspnet/AspNetCore/commit/ddc0e4fb3a) Run benchmarks on .NET Core 2.1 (#1722)
* [`[65204ec6f2]`](https://github.com/aspnet/AspNetCore/commit/65204ec6f2) Small changes (#1714)
* [`[733a3b3c2d]`](https://github.com/aspnet/AspNetCore/commit/733a3b3c2d) Upgrade the dependencies (#1712)
* [`[5f64ecfd4d]`](https://github.com/aspnet/AspNetCore/commit/5f64ecfd4d) Add conditional test attribute for WebSockets (#1709) (#1710)
* [`[4f5bc7046e]`](https://github.com/aspnet/AspNetCore/commit/4f5bc7046e) Add conditional test attribute for WebSockets (#1709)
* [`[83966930d3]`](https://github.com/aspnet/AspNetCore/commit/83966930d3) Skip WebApiTemplate_Works_NetCore test temporarily (#401) (#403)
* [`[1fe30aabbe]`](https://github.com/aspnet/AspNetCore/commit/1fe30aabbe) Skip WebApiTemplate_Works_NetCore test temporarily (#401)
* [`[cb05ce4e0b]`](https://github.com/aspnet/AspNetCore/commit/cb05ce4e0b) Progress towards deleting Sockets.Abstractions (#1705)
* [`[6701339835]`](https://github.com/aspnet/AspNetCore/commit/6701339835) Expose DefaultConnectionContext POCO (#2421)
* [`[f1c8dc408f]`](https://github.com/aspnet/AspNetCore/commit/f1c8dc408f) updated the solution
* [`[c181d1db96]`](https://github.com/aspnet/AspNetCore/commit/c181d1db96) Graceful close handshake
* [`[7bc54b99e0]`](https://github.com/aspnet/AspNetCore/commit/7bc54b99e0) Use tool assembly path for computing default pipe name
* [`[e94d77c47f]`](https://github.com/aspnet/AspNetCore/commit/e94d77c47f) Add model attribute for PartialTagHelper.
* [`[731f05df38]`](https://github.com/aspnet/AspNetCore/commit/731f05df38) call exit to force shutdown in case of timeout (#726)
* [`[c2a8f7bd2c]`](https://github.com/aspnet/AspNetCore/commit/c2a8f7bd2c) Upgrade Azure Active Directory Integration module
* [`[26578f5079]`](https://github.com/aspnet/AspNetCore/commit/26578f5079) Reenable API check
* [`[1ff5bdca79]`](https://github.com/aspnet/AspNetCore/commit/1ff5bdca79) Set model prefix for [ApiController]
* [`[0e7f12bfb3]`](https://github.com/aspnet/AspNetCore/commit/0e7f12bfb3) Add HostFiltering to the default web host
* [`[14429721d9]`](https://github.com/aspnet/AspNetCore/commit/14429721d9) Make handler selector more flexible
* [`[414b3d958a]`](https://github.com/aspnet/AspNetCore/commit/414b3d958a) Update the AAAD integration submodule
* [`[191e10e5a7]`](https://github.com/aspnet/AspNetCore/commit/191e10e5a7) Add the Azure Active Directory integration package
* [`[63fd1e1a4d]`](https://github.com/aspnet/AspNetCore/commit/63fd1e1a4d) Re-enable api check
* [`[adc7184d98]`](https://github.com/aspnet/AspNetCore/commit/adc7184d98) Register missed directives in RazorPageGenerator
* [`[a9667c3fbd]`](https://github.com/aspnet/AspNetCore/commit/a9667c3fbd) issue template (#1701)
* [`[f49270d9d6]`](https://github.com/aspnet/AspNetCore/commit/f49270d9d6) Add Azure AD package + tests
* [`[8492092f41]`](https://github.com/aspnet/AspNetCore/commit/8492092f41) Upgrade dependencies
* [`[71a6927318]`](https://github.com/aspnet/AspNetCore/commit/71a6927318) Fix feed sources and package dependency
* [`[1d6c09ab31]`](https://github.com/aspnet/AspNetCore/commit/1d6c09ab31) Make the use of Assembly.CodeBase more robust
* [`[72210e4078]`](https://github.com/aspnet/AspNetCore/commit/72210e4078) Add AuthenticationProperties.Parameters (#1008)
* [`[967b0dd0a4]`](https://github.com/aspnet/AspNetCore/commit/967b0dd0a4) Fixed dependencies
* [`[2e63e5afe3]`](https://github.com/aspnet/AspNetCore/commit/2e63e5afe3) The rename games part 1 of many (#1696)
* [`[af636fc8d4]`](https://github.com/aspnet/AspNetCore/commit/af636fc8d4) Upgraded deps
* [`[abdcb47b8f]`](https://github.com/aspnet/AspNetCore/commit/abdcb47b8f) Renames from API review (#2413)
* [`[77200410d6]`](https://github.com/aspnet/AspNetCore/commit/77200410d6) Updated Razor views
* [`[06c93669d6]`](https://github.com/aspnet/AspNetCore/commit/06c93669d6) Allow overwriting parameters on challenge requests
* [`[4acda9dd9b]`](https://github.com/aspnet/AspNetCore/commit/4acda9dd9b) Set userBrowserLink to false for VS host file (#395)
* [`[ed801f0e88]`](https://github.com/aspnet/AspNetCore/commit/ed801f0e88) Do not return 200 for exceptions
* [`[a47e1051e8]`](https://github.com/aspnet/AspNetCore/commit/a47e1051e8) Add protocol version to handshake (#1666)
* [`[1686a71046]`](https://github.com/aspnet/AspNetCore/commit/1686a71046) Return HRESULT
* [`[6d642ea5ce]`](https://github.com/aspnet/AspNetCore/commit/6d642ea5ce) Move Typescript client folder (#1692)
* [`[f1a3775247]`](https://github.com/aspnet/AspNetCore/commit/f1a3775247) Copy HttpContext properties for long polling transport  (#1684)
* [`[c569d163c4]`](https://github.com/aspnet/AspNetCore/commit/c569d163c4) Filter osx from symbols packages and include npm artifacts in prodcon
* [`[5aae1f91a8]`](https://github.com/aspnet/AspNetCore/commit/5aae1f91a8) Include symbols in published output
* [`[e5822232bb]`](https://github.com/aspnet/AspNetCore/commit/e5822232bb) Update to .NET Core 2.0.7-servicing-26322-01
* [`[0a450d2f53]`](https://github.com/aspnet/AspNetCore/commit/0a450d2f53) Add a version to the Razor about dialog entry
* [`[500279ea98]`](https://github.com/aspnet/AspNetCore/commit/500279ea98) Add missing source
* [`[8590bb9367]`](https://github.com/aspnet/AspNetCore/commit/8590bb9367) Updating baselines
* [`[9e61d6bd98]`](https://github.com/aspnet/AspNetCore/commit/9e61d6bd98) Update application parts implementation
* [`[0fbd2bb45e]`](https://github.com/aspnet/AspNetCore/commit/0fbd2bb45e) Add Azure AD B2C integration package
* [`[af05248042]`](https://github.com/aspnet/AspNetCore/commit/af05248042) [Fixes #4] Adds an Azure Active Directory B2C package * Adds extension methods to configure Azure Active Directory B2C   authentication for Web applications and APIs. * Adds all the supporting controllers/pages to support handling UI   flows. * Adds a sample using B2C to authenticate in a web application.
* [`[e2e5a226c2]`](https://github.com/aspnet/AspNetCore/commit/e2e5a226c2) Better fix
* [`[f6f5e575fb]`](https://github.com/aspnet/AspNetCore/commit/f6f5e575fb) Test more things
* [`[205fe9daf1]`](https://github.com/aspnet/AspNetCore/commit/205fe9daf1) Do not return 200 for exceptions
* [`[b5c46f35b3]`](https://github.com/aspnet/AspNetCore/commit/b5c46f35b3) Check for actual start in SSE (#1681)
* [`[631c2cdd3e]`](https://github.com/aspnet/AspNetCore/commit/631c2cdd3e) add SystemNetWebSocketsWebSocketProtocolPackageVersion
* [`[0f622ec53d]`](https://github.com/aspnet/AspNetCore/commit/0f622ec53d) ANCM stress app
* [`[7eb13646d5]`](https://github.com/aspnet/AspNetCore/commit/7eb13646d5) Add AAD Integration repo
* [`[b24e3b2e78]`](https://github.com/aspnet/AspNetCore/commit/b24e3b2e78) Use applicationUrl instead of ASPNETCORE_URLS (#390)
* [`[af96c91584]`](https://github.com/aspnet/AspNetCore/commit/af96c91584) Add support for running test sites on IIS from VS (#714)
* [`[ccb6793126]`](https://github.com/aspnet/AspNetCore/commit/ccb6793126) Introduce LifecycleProperty
* [`[6eb4b0ecfb]`](https://github.com/aspnet/AspNetCore/commit/6eb4b0ecfb) Prepare the 2.0.7 patch
* [`[b111c91cb0]`](https://github.com/aspnet/AspNetCore/commit/b111c91cb0) Don't copy the array for incoming msgpack reads (#1686)
* [`[899a298534]`](https://github.com/aspnet/AspNetCore/commit/899a298534) Fix package metadata to match default settings for aspnetcore (#389)
* [`[8947b81507]`](https://github.com/aspnet/AspNetCore/commit/8947b81507) Branch for preview2
* [`[d61d723cba]`](https://github.com/aspnet/AspNetCore/commit/d61d723cba) Update package metadata to include commit hash (#713)
* [`[3f84eee116]`](https://github.com/aspnet/AspNetCore/commit/3f84eee116) Detect availability of web sockets on client and server (#1682)
* [`[8ee5007a5d]`](https://github.com/aspnet/AspNetCore/commit/8ee5007a5d) Fix native tests running (#710)
* [`[689f114932]`](https://github.com/aspnet/AspNetCore/commit/689f114932) Add Managed to native project dependencies (#708)
* [`[d6176ac7de]`](https://github.com/aspnet/AspNetCore/commit/d6176ac7de) ApplicationPartFactory: The works
* [`[1bac12716d]`](https://github.com/aspnet/AspNetCore/commit/1bac12716d) Updating baselines
* [`[1aac4f4332]`](https://github.com/aspnet/AspNetCore/commit/1aac4f4332) Mark dotnet-aspnet-codegenerator as ship (#982)
* [`[ffeebfc8b9]`](https://github.com/aspnet/AspNetCore/commit/ffeebfc8b9) support shutdown timeout for inprocess application (#703)
* [`[6c54d51390]`](https://github.com/aspnet/AspNetCore/commit/6c54d51390) Ensure repos have a NuGetPackageVerifier file (#980)
* [`[a286e62c3d]`](https://github.com/aspnet/AspNetCore/commit/a286e62c3d) Update Templating to include changes from release/2.0 (#981)
* [`[a7178a66bd]`](https://github.com/aspnet/AspNetCore/commit/a7178a66bd) Show error if page directive is not at the top of file
* [`[71c2ddd155]`](https://github.com/aspnet/AspNetCore/commit/71c2ddd155) Fix #1575 by removing use of Map (#1671)
* [`[6053a34cf3]`](https://github.com/aspnet/AspNetCore/commit/6053a34cf3) Don't expose HubConnectionContext on the Hub (#1674)
* [`[e5cffe685b]`](https://github.com/aspnet/AspNetCore/commit/e5cffe685b) Do not rely on the implicit StringValues to array converter.
* [`[e889175c0e]`](https://github.com/aspnet/AspNetCore/commit/e889175c0e) Properly wait for process exit for docker helper and log errors (#1667)
* [`[6583e5fb47]`](https://github.com/aspnet/AspNetCore/commit/6583e5fb47) Improved allocations and throughput for broadcast scenarios (#1660)
* [`[1ddea573bb]`](https://github.com/aspnet/AspNetCore/commit/1ddea573bb) Update to Newtonsoft.Json 11.0.1 (#979)
* [`[5748898fc4]`](https://github.com/aspnet/AspNetCore/commit/5748898fc4) Make the RequestServicesContainerMiddleware thinner (#1360) (#1362)
* [`[8631f287d9]`](https://github.com/aspnet/AspNetCore/commit/8631f287d9) Add a few more Razor Sdk fixes
* [`[03efe5a4a7]`](https://github.com/aspnet/AspNetCore/commit/03efe5a4a7) Update Templating submodule
* [`[22423271c9]`](https://github.com/aspnet/AspNetCore/commit/22423271c9) Make the RequestServicesContainerMiddleware thinner (#1360)
* [`[dfc550a9ab]`](https://github.com/aspnet/AspNetCore/commit/dfc550a9ab) Fix the release channel for CLI blobs
* [`[72d706526e]`](https://github.com/aspnet/AspNetCore/commit/72d706526e) Upgrade Microsoft.NET.Test.Sdk to 15.6.1 (#972)
* [`[5baa53393f]`](https://github.com/aspnet/AspNetCore/commit/5baa53393f) fixing fowarding handler for AsyncCompletion (#669)
* [`[431a8e195a]`](https://github.com/aspnet/AspNetCore/commit/431a8e195a) [Fixes #2144] Incorrect target element of nested tag helper
* [`[fde11611f8]`](https://github.com/aspnet/AspNetCore/commit/fde11611f8) Fix the latest version pointer file in the blob store
* [`[586c4ff780]`](https://github.com/aspnet/AspNetCore/commit/586c4ff780) Move layout and partial script to Shared dir (#368)
* [`[24f07ce791]`](https://github.com/aspnet/AspNetCore/commit/24f07ce791) Fix LongPolling retry after poll timeout (#1654)
* [`[69f52cc3b6]`](https://github.com/aspnet/AspNetCore/commit/69f52cc3b6) Removing Microsoft.AspNetCore.SpaTemplates project and friends
* [`[b3625b8173]`](https://github.com/aspnet/AspNetCore/commit/b3625b8173) Make the RequestServicesContainerMiddleware thinner (#1360)
* [`[81fb221d9e]`](https://github.com/aspnet/AspNetCore/commit/81fb221d9e) Embed OIDC metadata and mock out the backchannel #1686
* [`[f786df9dc9]`](https://github.com/aspnet/AspNetCore/commit/f786df9dc9) Use partial tag helper (#375)
* [`[edaf72c7fc]`](https://github.com/aspnet/AspNetCore/commit/edaf72c7fc) Add update migrations script (#376)
* [`[5f3908cb54]`](https://github.com/aspnet/AspNetCore/commit/5f3908cb54) Stop expressly testing on netcoreapp2.0
* [`[f1d8ca3045]`](https://github.com/aspnet/AspNetCore/commit/f1d8ca3045) Add CommitHash to file info (#700)
* [`[885679c8bd]`](https://github.com/aspnet/AspNetCore/commit/885679c8bd) Made HubEndPoint derive from EndPoint (#1658)
* [`[473e578efc]`](https://github.com/aspnet/AspNetCore/commit/473e578efc) Fix CORS on TS Client (#1652)
* [`[4f10560087]`](https://github.com/aspnet/AspNetCore/commit/4f10560087) Rename negotiate to handshake, add handshake response, add close frame (#1591)
* [`[2bc3466e3d]`](https://github.com/aspnet/AspNetCore/commit/2bc3466e3d) Do not write generated files to disk if the input has parser errors
* [`[ca674ed419]`](https://github.com/aspnet/AspNetCore/commit/ca674ed419) Update artifacts.props
* [`[71fd4ffd8a]`](https://github.com/aspnet/AspNetCore/commit/71fd4ffd8a) fix #1542 by removing browser field (#1625)
* [`[5fa658c800]`](https://github.com/aspnet/AspNetCore/commit/5fa658c800) Never run continuation inline in SocketAwaitable.OnCompleted (#2407)
* [`[9dc7c65205]`](https://github.com/aspnet/AspNetCore/commit/9dc7c65205) Fix: Missing Html intellisense after directives
* [`[fa8fcc9a62]`](https://github.com/aspnet/AspNetCore/commit/fa8fcc9a62) Made wwwroot 'copyOnly' to avoid modifications in it's files
* [`[6444acedfd]`](https://github.com/aspnet/AspNetCore/commit/6444acedfd) Fix BOM test paths for Unix (#377)
* [`[79e744f691]`](https://github.com/aspnet/AspNetCore/commit/79e744f691) Handle unreadable import items in design time
* [`[2bb9a8aaf9]`](https://github.com/aspnet/AspNetCore/commit/2bb9a8aaf9) Adding handlerSettings configuration to aspnetcore schema for future use (#689)
* [`[d1bf120c54]`](https://github.com/aspnet/AspNetCore/commit/d1bf120c54) Make 2.1 MVC the default for uninitialized projects
* [`[130a751dfa]`](https://github.com/aspnet/AspNetCore/commit/130a751dfa) Add an experimental Language Version
* [`[be53b64fc1]`](https://github.com/aspnet/AspNetCore/commit/be53b64fc1) Add an experimental Language Version
* [`[6e4a968e12]`](https://github.com/aspnet/AspNetCore/commit/6e4a968e12) Fix #2149 give generated files distinct extension
* [`[ed18a8f975]`](https://github.com/aspnet/AspNetCore/commit/ed18a8f975) Seal ActionResultOfT (#7507)
* [`[7ff56dadf4]`](https://github.com/aspnet/AspNetCore/commit/7ff56dadf4) CodeGen RouteTemplate as a RazorCompiledItemAttribute
* [`[e2b6975bff]`](https://github.com/aspnet/AspNetCore/commit/e2b6975bff) Marked PageArgumentBinder type as Obsolete
* [`[09b5ff7b72]`](https://github.com/aspnet/AspNetCore/commit/09b5ff7b72) Use ParameterInfo for getting metadata of a parameter to show the correct information in ApiExplorer [Fixes #7435] 2.1-Preview 1: IsBindingRequired and IsRequired still false with RequiredAttribute on controller parameter.
* [`[35716ebf2c]`](https://github.com/aspnet/AspNetCore/commit/35716ebf2c) Make dotnet-ef a global tool
* [`[f6f89554c9]`](https://github.com/aspnet/AspNetCore/commit/f6f89554c9) Fix trimming line if CR not directly before LF (#1006)
* [`[fe7587cdb5]`](https://github.com/aspnet/AspNetCore/commit/fe7587cdb5) Add new HostFiltering package
* [`[4875856974]`](https://github.com/aspnet/AspNetCore/commit/4875856974) Fix #4604 for good
* [`[cf7c8629ff]`](https://github.com/aspnet/AspNetCore/commit/cf7c8629ff) Use ActivatorUtlities.CreateFactory instead of CreateInstance (#1643)
* [`[d4d5a08bc2]`](https://github.com/aspnet/AspNetCore/commit/d4d5a08bc2) The payload property was never used (#1641)
* [`[c5e2e3499a]`](https://github.com/aspnet/AspNetCore/commit/c5e2e3499a) The payload property was never used (#1639)
* [`[7df5c87815]`](https://github.com/aspnet/AspNetCore/commit/7df5c87815) Add copyright headers to new files
* [`[b792fcb4ef]`](https://github.com/aspnet/AspNetCore/commit/b792fcb4ef) Reduce the per message read allocations (#1635)
* [`[a9807e220d]`](https://github.com/aspnet/AspNetCore/commit/a9807e220d) Update git submodules
* [`[8b8c7107a8]`](https://github.com/aspnet/AspNetCore/commit/8b8c7107a8) Update client-ts versions (#1624)
* [`[881703e4c0]`](https://github.com/aspnet/AspNetCore/commit/881703e4c0) Upgrade Microsoft.NET.Test.Sdk to 15.6.1 (#1627)
* [`[cf4874997e]`](https://github.com/aspnet/AspNetCore/commit/cf4874997e) Heap allocate HTTP_DATA_CHUNK if the size of the response is too large.  (#683)
* [`[9337a63cf5]`](https://github.com/aspnet/AspNetCore/commit/9337a63cf5) Fix dependency
* [`[db0dc0f960]`](https://github.com/aspnet/AspNetCore/commit/db0dc0f960) Ignore writeasync failures when sending to multiple connections (#1589)
* [`[cfaf14a79a]`](https://github.com/aspnet/AspNetCore/commit/cfaf14a79a) Update Antiforgery submodule
* [`[5cb31f6082]`](https://github.com/aspnet/AspNetCore/commit/5cb31f6082) Hardcode extension .PrecompiledViews
* [`[0e38ee3e63]`](https://github.com/aspnet/AspNetCore/commit/0e38ee3e63) Create connectionIds using RNGCrypto (#1606)
* [`[079a56be1a]`](https://github.com/aspnet/AspNetCore/commit/079a56be1a) Small optimizations (#1617)
* [`[c640f422e0]`](https://github.com/aspnet/AspNetCore/commit/c640f422e0) Pascal case formatted log parameter names (#1615)
* [`[b0ec797681]`](https://github.com/aspnet/AspNetCore/commit/b0ec797681) Re-Enable ANCM OutOfProcess tests  (#678)
* [`[d8e363d99c]`](https://github.com/aspnet/AspNetCore/commit/d8e363d99c) Added parameter validation to RazorTagHelper and RazorGenerate tasks
* [`[a313aead2a]`](https://github.com/aspnet/AspNetCore/commit/a313aead2a) Update supported installer platforms
* [`[9839e6b07b]`](https://github.com/aspnet/AspNetCore/commit/9839e6b07b) Perf in MessageParsers (#1616)
* [`[5a6f44c6eb]`](https://github.com/aspnet/AspNetCore/commit/5a6f44c6eb) Update BasicMiddleware submodule
* [`[fa825fe247]`](https://github.com/aspnet/AspNetCore/commit/fa825fe247) Add new HostFiltering package
* [`[1f470164d9]`](https://github.com/aspnet/AspNetCore/commit/1f470164d9) Update artifacts.props
* [`[5e74b36c53]`](https://github.com/aspnet/AspNetCore/commit/5e74b36c53) Verify read/write buffers, use offset parameter when reading. (#652)
* [`[227c6b8133]`](https://github.com/aspnet/AspNetCore/commit/227c6b8133) Use the array unpacker instead of the Stream unpacker (#1619)
* [`[8ff9ce70c9]`](https://github.com/aspnet/AspNetCore/commit/8ff9ce70c9) Fixes spelling (#679)
* [`[2527face16]`](https://github.com/aspnet/AspNetCore/commit/2527face16) Query EndPoints once during reset (#2398)
* [`[acf7584d13]`](https://github.com/aspnet/AspNetCore/commit/acf7584d13) Reenable API Check
* [`[b0e5483a5c]`](https://github.com/aspnet/AspNetCore/commit/b0e5483a5c) Update .gitattributes to workaround npm changing line endings (#1610)
* [`[7addc9d681]`](https://github.com/aspnet/AspNetCore/commit/7addc9d681) Use --ci when running CI scripts
* [`[2f3e0384bf]`](https://github.com/aspnet/AspNetCore/commit/2f3e0384bf) Fix managed test run
* [`[8e54e792fb]`](https://github.com/aspnet/AspNetCore/commit/8e54e792fb) do shutdown check before processing request (#677)
* [`[4e7d1a5a32]`](https://github.com/aspnet/AspNetCore/commit/4e7d1a5a32) Rename PartialTagHelper `asp-for` to `for`.
* [`[5f149cfa9c]`](https://github.com/aspnet/AspNetCore/commit/5f149cfa9c) Skip F# net framework test (#363)
* [`[c6369bfba1]`](https://github.com/aspnet/AspNetCore/commit/c6369bfba1) Move MicrosoftDotNetArchivePackageVersion to pinned version section
* [`[b74582e101]`](https://github.com/aspnet/AspNetCore/commit/b74582e101) Ensure PreserveCompilationContext is set if we're targeting precompilation tool
* [`[8588b77160]`](https://github.com/aspnet/AspNetCore/commit/8588b77160) Re-adding Concurrent read/write tests. Fix flakiness. (#650)
* [`[5f69a01cc5]`](https://github.com/aspnet/AspNetCore/commit/5f69a01cc5) RazorSdk - Attribute code generation fixes
* [`[d27844dfef]`](https://github.com/aspnet/AspNetCore/commit/d27844dfef) ConnectionMetadata is now ConnectionItems (#1604)
* [`[d31512528d]`](https://github.com/aspnet/AspNetCore/commit/d31512528d) Items is now a first class property on ConnectionContext (#2395)
* [`[a041b368bb]`](https://github.com/aspnet/AspNetCore/commit/a041b368bb) Add missing TestAssets projects to Hosting.sln (#1352)
* [`[2b68db873a]`](https://github.com/aspnet/AspNetCore/commit/2b68db873a) add AddRedis overload that takes connection string (#1588)
* [`[6a8ede0770]`](https://github.com/aspnet/AspNetCore/commit/6a8ede0770) Further making Microsoft.AspNetCore.Sockets "not a thing" (#1599)
* [`[f9ad346be8]`](https://github.com/aspnet/AspNetCore/commit/f9ad346be8) Fix RazorDirectiveCompletionProvider MEF dependency.
* [`[9d064b24c7]`](https://github.com/aspnet/AspNetCore/commit/9d064b24c7) enable debug print in aspnetcore.dll (#663)
* [`[9901f0f3e4]`](https://github.com/aspnet/AspNetCore/commit/9901f0f3e4) Default to the managed socket transport (#2392)
* [`[a3886057d5]`](https://github.com/aspnet/AspNetCore/commit/a3886057d5) Add benchmark application to our repo (#1579)
* [`[c5efbc0b15]`](https://github.com/aspnet/AspNetCore/commit/c5efbc0b15) Update BenchmarkDotNet (#958)
* [`[6de76c5e69]`](https://github.com/aspnet/AspNetCore/commit/6de76c5e69) Respect the buffer size arguments on options (#230)
* [`[dc0567690d]`](https://github.com/aspnet/AspNetCore/commit/dc0567690d) Use features from Protocol.Abstractions (#1594)
* [`[04eef791bc]`](https://github.com/aspnet/AspNetCore/commit/04eef791bc) Added transfer format to Protocol.Abstractions (#2391)
* [`[e65e58daf3]`](https://github.com/aspnet/AspNetCore/commit/e65e58daf3) Reduce Sockets mainloop Send/Receive statemachine size (#2376)
* [`[572627e88c]`](https://github.com/aspnet/AspNetCore/commit/572627e88c) Handle posting to the libuv thread after StopAsync (#2388)
* [`[4fe4757b4a]`](https://github.com/aspnet/AspNetCore/commit/4fe4757b4a) fix package-lock.json files (#1592)
* [`[027a6588f9]`](https://github.com/aspnet/AspNetCore/commit/027a6588f9) Backport scripts from dev used to generate tags on repos
* [`[f6108928d8]`](https://github.com/aspnet/AspNetCore/commit/f6108928d8) Pass ReadOnlySequence via in (#2389)
* [`[27440da725]`](https://github.com/aspnet/AspNetCore/commit/27440da725) Add additional restore sources to PackageArchive.targets
* [`[a6d03bd407]`](https://github.com/aspnet/AspNetCore/commit/a6d03bd407) Workaround MonoDevelop.Core.FilePath tests failing to run due to strong name issues.
* [`[bfdb48717f]`](https://github.com/aspnet/AspNetCore/commit/bfdb48717f) Host header format validation
* [`[a16c3614d4]`](https://github.com/aspnet/AspNetCore/commit/a16c3614d4) Update submodule urls
* [`[810c4bcb0a]`](https://github.com/aspnet/AspNetCore/commit/810c4bcb0a) Fix two AVs with InProcess (#656)
* [`[d246c6f201]`](https://github.com/aspnet/AspNetCore/commit/d246c6f201) add port info to event log (#660)
* [`[7a511d6a94]`](https://github.com/aspnet/AspNetCore/commit/7a511d6a94) websocket handler changes  (#661)
* [`[1d602d1205]`](https://github.com/aspnet/AspNetCore/commit/1d602d1205) Add host project system for VS4Mac.
* [`[62956530ae]`](https://github.com/aspnet/AspNetCore/commit/62956530ae) Rename StreamAsync to StreamAsChannelAsync (#1587)
* [`[bcea8330c4]`](https://github.com/aspnet/AspNetCore/commit/bcea8330c4) Clean up some left overs (#2385)
* [`[425724ce28]`](https://github.com/aspnet/AspNetCore/commit/425724ce28) Avoid generating RelatedAssemblyAttribute when RazorSdk isn't in play
* [`[f0788926a0]`](https://github.com/aspnet/AspNetCore/commit/f0788926a0) Add additional APIs required by Razor Sdk
* [`[1ce0e6ecdf]`](https://github.com/aspnet/AspNetCore/commit/1ce0e6ecdf) Add lzma repo task
* [`[7db6925ffc]`](https://github.com/aspnet/AspNetCore/commit/7db6925ffc) Split sqllite and sql server migrations (#348)
* [`[bee77ebf91]`](https://github.com/aspnet/AspNetCore/commit/bee77ebf91) Rename VirtualScheme => PolicyScheme (#1665)
* [`[4103d47f09]`](https://github.com/aspnet/AspNetCore/commit/4103d47f09) Rename ns Microsoft.AspNetCore.Authroization.Test to Microsoft.AspNetCore.Authorization.Test (#1693)
* [`[4b5bd5a066]`](https://github.com/aspnet/AspNetCore/commit/4b5bd5a066) Force HTTP/1.1 for POSTs to work around High Sierra HttpClient issue.
* [`[2d8f3d95fe]`](https://github.com/aspnet/AspNetCore/commit/2d8f3d95fe) Feature/clean up proto abstractions (#2383)
* [`[adb760210d]`](https://github.com/aspnet/AspNetCore/commit/adb760210d) Minimal reaction to proto abstractions changes (#1583)
* [`[5de21c8da3]`](https://github.com/aspnet/AspNetCore/commit/5de21c8da3) Update MonoDevelop.Addins package to 1.3.8.
* [`[9fc6b8fcf5]`](https://github.com/aspnet/AspNetCore/commit/9fc6b8fcf5) Clean up mac completion broker.
* [`[a3f0260ee8]`](https://github.com/aspnet/AspNetCore/commit/a3f0260ee8) Upload to Azure in parallel (#952)
* [`[dbc5e38d04]`](https://github.com/aspnet/AspNetCore/commit/dbc5e38d04) Match launchSettings variable to sourceName in template.json (#354)
* [`[0141d6e4a3]`](https://github.com/aspnet/AspNetCore/commit/0141d6e4a3) Fix #1580 by correcting README sample (#1581)
* [`[0879dbd082]`](https://github.com/aspnet/AspNetCore/commit/0879dbd082) Convert ValuesController return types to ActionResult<T> (#351)
* [`[a0b1b15101]`](https://github.com/aspnet/AspNetCore/commit/a0b1b15101) [Fixes #7412] AspNetCore 2.1 breaks integration with 3rd party validation libraries
* [`[ddd0b4c260]`](https://github.com/aspnet/AspNetCore/commit/ddd0b4c260) Clean up protocol abstractions (#2381)
* [`[a952313f1c]`](https://github.com/aspnet/AspNetCore/commit/a952313f1c) Added JQueryQueryStringValueProviderFactory and JQueryQueryStringValueProvider [Fixes #6372] jQuery ajax request with complex data does not work with .net core 1.1 model bindings
* [`[fcd4484542]`](https://github.com/aspnet/AspNetCore/commit/fcd4484542) Fix TagHelperDescriptor.Kind serialization
* [`[e8f798fb5a]`](https://github.com/aspnet/AspNetCore/commit/e8f798fb5a) Upgrade dependencies
* [`[974eb28b8b]`](https://github.com/aspnet/AspNetCore/commit/974eb28b8b) Hub method reflection caching and invocation benchmarks (#1574)
* [`[d816c6ef60]`](https://github.com/aspnet/AspNetCore/commit/d816c6ef60) Add additional properties to HttpOptions (#1557)
* [`[4acdebc5be]`](https://github.com/aspnet/AspNetCore/commit/4acdebc5be) Temporary workaround issue with Sdk mismatch (#7472)
* [`[12c3cf028c]`](https://github.com/aspnet/AspNetCore/commit/12c3cf028c) Assign language and template type to 3 C# item templates (#343)
* [`[91160a155a]`](https://github.com/aspnet/AspNetCore/commit/91160a155a) Force http/1.1 to work around High Sierra failures
* [`[b0a40d8bc7]`](https://github.com/aspnet/AspNetCore/commit/b0a40d8bc7) Rename Microsoft.EntityFrameworkCore.Attributes to Microsoft.EntityFrameworkCore.Abstractions
* [`[02abb69cb2]`](https://github.com/aspnet/AspNetCore/commit/02abb69cb2) fix missing reference/dereference handler (#651)
* [`[13aa0ae513]`](https://github.com/aspnet/AspNetCore/commit/13aa0ae513) Force HTTP/1.1
* [`[20997d1fc0]`](https://github.com/aspnet/AspNetCore/commit/20997d1fc0) Upgrade deps
* [`[0b81658850]`](https://github.com/aspnet/AspNetCore/commit/0b81658850) Add SignalR Marker Service (#1573)
* [`[d6178f2482]`](https://github.com/aspnet/AspNetCore/commit/d6178f2482) Fixed streaming hub method with ValueTask (#1572)
* [`[71bff00c0d]`](https://github.com/aspnet/AspNetCore/commit/71bff00c0d) Use LibuvThread inspired IO Queue in Socket transport (#2368)
* [`[a686b8ed36]`](https://github.com/aspnet/AspNetCore/commit/a686b8ed36) UpdateRepos.ps1 get latest of branch
* [`[483fba5972]`](https://github.com/aspnet/AspNetCore/commit/483fba5972) Generate application part attributes
* [`[d987b48672]`](https://github.com/aspnet/AspNetCore/commit/d987b48672) Expect websockets to be disabled on Win7. (#649)
* [`[0b07894ea7]`](https://github.com/aspnet/AspNetCore/commit/0b07894ea7) fix srwlock initialize (#647)
* [`[d941a4be09]`](https://github.com/aspnet/AspNetCore/commit/d941a4be09) Workaround automatic Http2 upgrade in POSTs (#1571)
* [`[1318a83511]`](https://github.com/aspnet/AspNetCore/commit/1318a83511) Fixed the NextIs method to put back the symbol, when at the end of the file
* [`[faccd90aa5]`](https://github.com/aspnet/AspNetCore/commit/faccd90aa5) Added unit-tests to validate new methods
* [`[cb49b98b6f]`](https://github.com/aspnet/AspNetCore/commit/cb49b98b6f) Follow windows conventions for file versions (#646)
* [`[989a6c699f]`](https://github.com/aspnet/AspNetCore/commit/989a6c699f) Don't add the tag helper provider by default
* [`[f52771d0e9]`](https://github.com/aspnet/AspNetCore/commit/f52771d0e9) Fix MicrosoftExtensionsBuffersTestingSources package version variable
* [`[8e74412a4c]`](https://github.com/aspnet/AspNetCore/commit/8e74412a4c) Update to new corefx (#946)
* [`[4a4efe0f39]`](https://github.com/aspnet/AspNetCore/commit/4a4efe0f39) Update to new corefx (#1561)
* [`[77c5d2a971]`](https://github.com/aspnet/AspNetCore/commit/77c5d2a971) Update to new corefx (#642)
* [`[fc80c15a65]`](https://github.com/aspnet/AspNetCore/commit/fc80c15a65) Update to new corefx (#2369)
* [`[6885fb15d0]`](https://github.com/aspnet/AspNetCore/commit/6885fb15d0) Updated the test TagHelperBlockRewriteTest class
* [`[8dca8f030c]`](https://github.com/aspnet/AspNetCore/commit/8dca8f030c) moving recycle and shutdown to applicationinfo (#639)
* [`[ce2a5adb10]`](https://github.com/aspnet/AspNetCore/commit/ce2a5adb10) Use 10.0.15063.0 for Windows SDK
* [`[99aa25e4d8]`](https://github.com/aspnet/AspNetCore/commit/99aa25e4d8) Add Missing File Header (#1560)
* [`[adbd964efd]`](https://github.com/aspnet/AspNetCore/commit/adbd964efd) Transport Fallback (#1455)
* [`[4eea754dc3]`](https://github.com/aspnet/AspNetCore/commit/4eea754dc3) Don't create std log file for out of process when logs are disabled (#640)
* [`[98e270ea6a]`](https://github.com/aspnet/AspNetCore/commit/98e270ea6a) Exclude utility project from test discovery (#1556)
* [`[b6dc00229d]`](https://github.com/aspnet/AspNetCore/commit/b6dc00229d) Convert TestHost ResponseStream to use Pipes.
* [`[a41bf6228f]`](https://github.com/aspnet/AspNetCore/commit/a41bf6228f) Client sends user agent with version based on assembly version (#1551)
* [`[c46f164c26]`](https://github.com/aspnet/AspNetCore/commit/c46f164c26) Fix shared fx symbols name
* [`[42fbba3520]`](https://github.com/aspnet/AspNetCore/commit/42fbba3520) More detailed request timeout exceptions #2245
* [`[419ae06935]`](https://github.com/aspnet/AspNetCore/commit/419ae06935) fixing double locking issue (#637)
* [`[dbd557c965]`](https://github.com/aspnet/AspNetCore/commit/dbd557c965) Exclude the upgrade feature if the OS does not support it #427
* [`[f32addd408]`](https://github.com/aspnet/AspNetCore/commit/f32addd408) Update RecycleApplication function (#634)
* [`[4288ae2117]`](https://github.com/aspnet/AspNetCore/commit/4288ae2117) Update to Ubuntu 16.04
* [`[d6ba2ee966]`](https://github.com/aspnet/AspNetCore/commit/d6ba2ee966) Add wireframe for ConfigureApplicationPart
* [`[fd64d416d2]`](https://github.com/aspnet/AspNetCore/commit/fd64d416d2) Add pipeline files for dotnet-ci (#143)
* [`[1c44e8febf]`](https://github.com/aspnet/AspNetCore/commit/1c44e8febf) Fix streaming hub methods combined with async (#1544)
* [`[0e28f34c1a]`](https://github.com/aspnet/AspNetCore/commit/0e28f34c1a) Add general logging event to be used by the RequestHandler (#633)
* [`[5af246b554]`](https://github.com/aspnet/AspNetCore/commit/5af246b554) Ignore constructors when discovering actions
* [`[1b9313287b]`](https://github.com/aspnet/AspNetCore/commit/1b9313287b) Restrict HubProtocol on Server + HubOptions<THub> (#1492)
* [`[53360e0165]`](https://github.com/aspnet/AspNetCore/commit/53360e0165) Disable SynchronousReadAndWriteTest (#630)
* [`[c833e7b994]`](https://github.com/aspnet/AspNetCore/commit/c833e7b994) change the logic on handling configuration change and adds shutdown logic (#610)
* [`[68f58a8dd5]`](https://github.com/aspnet/AspNetCore/commit/68f58a8dd5) Fixes for NPM packages in preview1 (#1540)
* [`[7f8b23847e]`](https://github.com/aspnet/AspNetCore/commit/7f8b23847e) Add Microsoft.AspNet.WebApi.Client to .App and .All metapackages
* [`[c88f949c39]`](https://github.com/aspnet/AspNetCore/commit/c88f949c39) Be explicit about PipeScheduler.Inline (#2367)
* [`[e552b5861a]`](https://github.com/aspnet/AspNetCore/commit/e552b5861a) Switch default implementation of Pbkdf2 on Linux/macOS to Rfc2898DeriveBytes (#301)
* [`[1df139eb6d]`](https://github.com/aspnet/AspNetCore/commit/1df139eb6d) Clone tickets for sliding refresh #1607
* [`[846432c9ac]`](https://github.com/aspnet/AspNetCore/commit/846432c9ac) Improve unexpected server error message to client (#1532)
* [`[b86df651af]`](https://github.com/aspnet/AspNetCore/commit/b86df651af) Fix Http2ConnectionTests flakiness (#2364)
* [`[27e6c699e5]`](https://github.com/aspnet/AspNetCore/commit/27e6c699e5) Don't print normal output as error
* [`[eb3e6cfab5]`](https://github.com/aspnet/AspNetCore/commit/eb3e6cfab5) Realign all package versions (#941)
* [`[00da533f10]`](https://github.com/aspnet/AspNetCore/commit/00da533f10) NPM troubleshooting documentation (#1529)
* [`[42dcd0ba28]`](https://github.com/aspnet/AspNetCore/commit/42dcd0ba28) UrlHelperFactory.GetUrlHelper throws NullReferenceException when passed a null action context.
* [`[3517ecda2f]`](https://github.com/aspnet/AspNetCore/commit/3517ecda2f) Ensure DebugType = embedded and DebugType = none work
* [`[f061d328d9]`](https://github.com/aspnet/AspNetCore/commit/f061d328d9) Do not use `FormattedModelValue` in password editor template - #7418 - add quirk switch to reverse this if necessary
* [`[4e8a9d2493]`](https://github.com/aspnet/AspNetCore/commit/4e8a9d2493) Move reading and writing of Pipelines to a single loop; Cancel Read every time we write. (#582)
* [`[978938b7c3]`](https://github.com/aspnet/AspNetCore/commit/978938b7c3) Initial commit
* [`[3d20362df6]`](https://github.com/aspnet/AspNetCore/commit/3d20362df6) Add .gitignore and .gitattributes
* [`[cbffeb33ea]`](https://github.com/aspnet/AspNetCore/commit/cbffeb33ea) fixing a stress issue (#619)
* [`[0f6ba66e46]`](https://github.com/aspnet/AspNetCore/commit/0f6ba66e46) Add InMemoryTransportBenchmark (#2354)
* [`[c444f65c5d]`](https://github.com/aspnet/AspNetCore/commit/c444f65c5d) Import capabilities to support solution explorer nesting
* [`[8d1c85ab74]`](https://github.com/aspnet/AspNetCore/commit/8d1c85ab74) Add overload for AddModelError without ModelMetadata (#7407)
* [`[f954e9548b]`](https://github.com/aspnet/AspNetCore/commit/f954e9548b) Upgrade dependency versions
* [`[7b8c85f7dd]`](https://github.com/aspnet/AspNetCore/commit/7b8c85f7dd) Use dotnet-deb-tool 2.0.0 from the aspnetcore-dev myget feed
* [`[e71bfb99e8]`](https://github.com/aspnet/AspNetCore/commit/e71bfb99e8) Upgrade dependency versions
* [`[9839799645]`](https://github.com/aspnet/AspNetCore/commit/9839799645) Add CookiePolicy logging #1588
* [`[d476886803]`](https://github.com/aspnet/AspNetCore/commit/d476886803) Upgrade dependency versions
* [`[5bd650bdd1]`](https://github.com/aspnet/AspNetCore/commit/5bd650bdd1) Pack should pack symbol nupkg
* [`[17dd3e85cb]`](https://github.com/aspnet/AspNetCore/commit/17dd3e85cb) fix missing event log descriptions (#622)
* [`[00485d9f1b]`](https://github.com/aspnet/AspNetCore/commit/00485d9f1b) Fix #2099 - make AssemblyExtension public
* [`[0276bb199e]`](https://github.com/aspnet/AspNetCore/commit/0276bb199e) Produce an Alpine Linux version of the ASP.NET Core shared framework (#931)
* [`[3e0360a891]`](https://github.com/aspnet/AspNetCore/commit/3e0360a891) Fix #2041 - Add static constructor to DocumentWriter
* [`[af9974178b]`](https://github.com/aspnet/AspNetCore/commit/af9974178b) Added test (#1517)
* [`[300453396a]`](https://github.com/aspnet/AspNetCore/commit/300453396a) Pass StringValues via in (#2295)
* [`[92c511b2b4]`](https://github.com/aspnet/AspNetCore/commit/92c511b2b4) Fix #2099 - make AssemblyExtension public
* [`[3ffcc9bdb5]`](https://github.com/aspnet/AspNetCore/commit/3ffcc9bdb5) Add EFCore.Analyzers package
* [`[0c7ff81a9f]`](https://github.com/aspnet/AspNetCore/commit/0c7ff81a9f) Handle FileNotFoundException when it is thrown while attempting to send a file (#233)
* [`[ee6db5a7fd]`](https://github.com/aspnet/AspNetCore/commit/ee6db5a7fd) Switch to use forwarding instead of virtual handler (#27)
* [`[569c31bc62]`](https://github.com/aspnet/AspNetCore/commit/569c31bc62) Add some more logging (#1510)
* [`[9c74991ad6]`](https://github.com/aspnet/AspNetCore/commit/9c74991ad6) set the RID for tests in netfx (#1516)
* [`[e05c2abd94]`](https://github.com/aspnet/AspNetCore/commit/e05c2abd94) Fix #2041 - Add static constructor to DocumentWriter
* [`[2a5c27c789]`](https://github.com/aspnet/AspNetCore/commit/2a5c27c789) Add new package artifacts (#930)
* [`[d6784b5f16]`](https://github.com/aspnet/AspNetCore/commit/d6784b5f16) Report faults on Razor project system exceptions
* [`[437b34b746]`](https://github.com/aspnet/AspNetCore/commit/437b34b746) Reac to pipes in corefx (#926)
* [`[2dac2e34fa]`](https://github.com/aspnet/AspNetCore/commit/2dac2e34fa) Reac to pipes in corefx (#618)
* [`[8908eec6e7]`](https://github.com/aspnet/AspNetCore/commit/8908eec6e7) Pipelines in corefx (#1501)
* [`[fcbe74fbf1]`](https://github.com/aspnet/AspNetCore/commit/fcbe74fbf1) fix coding guideline issue. Use BOOL instead of bool (#620)
* [`[62df770c39]`](https://github.com/aspnet/AspNetCore/commit/62df770c39) PreserveCompilationContext needs to be set only if a project has any Razor files
* [`[6c7041b9f2]`](https://github.com/aspnet/AspNetCore/commit/6c7041b9f2) Update Secuirty submodule for WsFederation
* [`[21acbf06e8]`](https://github.com/aspnet/AspNetCore/commit/21acbf06e8) Update google auth endpoint to v2 #1307
* [`[13b25ec518]`](https://github.com/aspnet/AspNetCore/commit/13b25ec518) Reduce detailed payload logs to trace (#1515)
* [`[2a41837df4]`](https://github.com/aspnet/AspNetCore/commit/2a41837df4) Add new WsFederation package (#927)
* [`[c4eb501343]`](https://github.com/aspnet/AspNetCore/commit/c4eb501343) Emit warnings after off is called (#1513)
* [`[cc8acdff57]`](https://github.com/aspnet/AspNetCore/commit/cc8acdff57) Update facebook API version to 2.12 #1306
* [`[251d57942b]`](https://github.com/aspnet/AspNetCore/commit/251d57942b) Clean up error message when Razor compiler is not referenced
* [`[63f0322810]`](https://github.com/aspnet/AspNetCore/commit/63f0322810) Allow whitespace and backslash in path
* [`[f51ddf68a6]`](https://github.com/aspnet/AspNetCore/commit/f51ddf68a6) Add RazorGenerate items to UpToDateCheckInput
* [`[5cc4f315cb]`](https://github.com/aspnet/AspNetCore/commit/5cc4f315cb) Fix install text (#1506)
* [`[1790d6bdf0]`](https://github.com/aspnet/AspNetCore/commit/1790d6bdf0) Serialize once per format to increase perf in broadcasting scenarios (#1498)
* [`[d9778252d0]`](https://github.com/aspnet/AspNetCore/commit/d9778252d0) Sort header and query values
* [`[71b90a31a9]`](https://github.com/aspnet/AspNetCore/commit/71b90a31a9) websocket enabled check (#612)
* [`[a69d2fedaf]`](https://github.com/aspnet/AspNetCore/commit/a69d2fedaf) Update the TS Client Poll Timeout (#1499)
* [`[e35d0bc43f]`](https://github.com/aspnet/AspNetCore/commit/e35d0bc43f) Add more fine grained logging to RazorViewCompiler
* [`[d67a604b84]`](https://github.com/aspnet/AspNetCore/commit/d67a604b84) Add pretty title
* [`[a1aaf6f44e]`](https://github.com/aspnet/AspNetCore/commit/a1aaf6f44e) Create CrossRepoBreakingChanges.md
* [`[4dc2c17f04]`](https://github.com/aspnet/AspNetCore/commit/4dc2c17f04) Add script for setting and pushing tags (#919)
* [`[8594d2b897]`](https://github.com/aspnet/AspNetCore/commit/8594d2b897) Use Threadpool for pipe scheduler (#1497)
* [`[b60e4cfea6]`](https://github.com/aspnet/AspNetCore/commit/b60e4cfea6) Removing remnants from the days of OPTIONS (#1495)
* [`[4a49d6dd75]`](https://github.com/aspnet/AspNetCore/commit/4a49d6dd75) Restore "Force conformance tests to run on the CI (#228)" (#229)
* [`[aa21a6be6e]`](https://github.com/aspnet/AspNetCore/commit/aa21a6be6e) Use File.Open overload that overwrites file entirely in DiscoverCommand (#2110)
* [`[83bf2375b3]`](https://github.com/aspnet/AspNetCore/commit/83bf2375b3) #2035 Do not await OnCompleted handlers before sending the Response (#2324)
* [`[0e4731e480]`](https://github.com/aspnet/AspNetCore/commit/0e4731e480) Expose Transport and Application Max Buffer Sizes (#1473)
* [`[06945ba81e]`](https://github.com/aspnet/AspNetCore/commit/06945ba81e) Include exceptions when displaying test logs (#2346)
* [`[c4304ea723]`](https://github.com/aspnet/AspNetCore/commit/c4304ea723) Add dotnet-aspnet-codegenerator to artifacts.props
* [`[0134e56909]`](https://github.com/aspnet/AspNetCore/commit/0134e56909) Include exceptions when displaying test logs (#2344)
* [`[b538ceba93]`](https://github.com/aspnet/AspNetCore/commit/b538ceba93) Change final code documents to not contain non-existent imports.
* [`[de7e2a2573]`](https://github.com/aspnet/AspNetCore/commit/de7e2a2573) Use enum for method rather than string compares (#2294)
* [`[f7da0edcb2]`](https://github.com/aspnet/AspNetCore/commit/f7da0edcb2) Skip ConnectionCanSendAndReceiveMessages
* [`[39951e892e]`](https://github.com/aspnet/AspNetCore/commit/39951e892e) Don't throw in HttpRequestStream.Flush (#2342)
* [`[6728e756b7]`](https://github.com/aspnet/AspNetCore/commit/6728e756b7) Sanitize and centralize exception throws (#2293)
* [`[6a2d41cc9f]`](https://github.com/aspnet/AspNetCore/commit/6a2d41cc9f) Fix #924 by introducing HubDispatcher abstraction (#1479)
* [`[64c86634a8]`](https://github.com/aspnet/AspNetCore/commit/64c86634a8) Added a test to verify incremental TagHelper discovery
* [`[1796abcbcd]`](https://github.com/aspnet/AspNetCore/commit/1796abcbcd) Updated the test TagHelperBlockRewriteTest class
* [`[6252ffd86a]`](https://github.com/aspnet/AspNetCore/commit/6252ffd86a) Flatten exception handling (#2313)
* [`[c57784447e]`](https://github.com/aspnet/AspNetCore/commit/c57784447e) Speed up TryGetAsciiString (#1973)
* [`[c0f88ebdc1]`](https://github.com/aspnet/AspNetCore/commit/c0f88ebdc1) Faster IFeatureCollection.Get<TFeature> (#2290)
* [`[32baa655b9]`](https://github.com/aspnet/AspNetCore/commit/32baa655b9) Do over the websocket transport (#1481)
* [`[c29531f2eb]`](https://github.com/aspnet/AspNetCore/commit/c29531f2eb) Delimit key values for query strings
* [`[68b3df8fe9]`](https://github.com/aspnet/AspNetCore/commit/68b3df8fe9) Don't ship global CLI tool packages to nuget.org or put into LZMA (#906)
* [`[8cac91b15e]`](https://github.com/aspnet/AspNetCore/commit/8cac91b15e) Update jQuery (#307)
* [`[e9ccf1a11d]`](https://github.com/aspnet/AspNetCore/commit/e9ccf1a11d) Update AzureIntegration submodule
* [`[c5c4ff4b9c]`](https://github.com/aspnet/AspNetCore/commit/c5c4ff4b9c) Add SDK feed override (#157)
* [`[590c621c6f]`](https://github.com/aspnet/AspNetCore/commit/590c621c6f) Update README to reflect that dotnet-watch et. al. are bundled in the CLI
* [`[fd38a67f80]`](https://github.com/aspnet/AspNetCore/commit/fd38a67f80) Drop Pipelines.Testing dependency that we don't use (#915)
* [`[dc62b9ba38]`](https://github.com/aspnet/AspNetCore/commit/dc62b9ba38) adding mof file for freb log (#603)
* [`[d996f6b7fc]`](https://github.com/aspnet/AspNetCore/commit/d996f6b7fc) Drop Pipelines.Testing dependency that we don't use (#2343)
* [`[70dcbf6ed6]`](https://github.com/aspnet/AspNetCore/commit/70dcbf6ed6) Add UnprotectKeysWithAnyCertificate
* [`[09adc4a847]`](https://github.com/aspnet/AspNetCore/commit/09adc4a847) Add timeout back to hanging test (#1480)
* [`[3f96f6e232]`](https://github.com/aspnet/AspNetCore/commit/3f96f6e232) Add new Http.Polly package to universe
* [`[12f7a0367d]`](https://github.com/aspnet/AspNetCore/commit/12f7a0367d) Fail script when push to repo fails
* [`[4f3e044928]`](https://github.com/aspnet/AspNetCore/commit/4f3e044928) HtmlHelper.DisplayTextFor should use DisplayAttribute of enums - #7033
* [`[6f9e7728ca]`](https://github.com/aspnet/AspNetCore/commit/6f9e7728ca) Use FeatureBranchVersionSuffix when generating VersionSuffix
* [`[782b563a58]`](https://github.com/aspnet/AspNetCore/commit/782b563a58) fixing empty logfile name in event log (#602)
* [`[6d7269dafb]`](https://github.com/aspnet/AspNetCore/commit/6d7269dafb) Return HTTP 404 if FileNotFoundException is thrown when attempting to send a file (#232)
* [`[21b1febf2b]`](https://github.com/aspnet/AspNetCore/commit/21b1febf2b) Adds environment variable feature for inprocess (#583)
* [`[540e8437da]`](https://github.com/aspnet/AspNetCore/commit/540e8437da) Enable PreserveCompilationContext by default
* [`[33e60ae363]`](https://github.com/aspnet/AspNetCore/commit/33e60ae363) Separate VS/DesignTime properties from general SDK properties
* [`[8938f6c8c2]`](https://github.com/aspnet/AspNetCore/commit/8938f6c8c2) Change the default extension for Razor views to .Views.dll
* [`[1f6e2c8029]`](https://github.com/aspnet/AspNetCore/commit/1f6e2c8029) grant the config setting on 502.5 page setting (#600)
* [`[e3d3b088ae]`](https://github.com/aspnet/AspNetCore/commit/e3d3b088ae) adding logging for outprocess start and application recycle (#573)
* [`[c5e83c61f8]`](https://github.com/aspnet/AspNetCore/commit/c5e83c61f8) Changed AddDefaultImports to take strings instead of project items.
* [`[873cfa9adf]`](https://github.com/aspnet/AspNetCore/commit/873cfa9adf) In SpaProxy, don't fail if there are non-forwardable headers. Fixes #1543.
* [`[7debea272c]`](https://github.com/aspnet/AspNetCore/commit/7debea272c) Update Angular template content to match @angular/cli@1.7.0
* [`[3fc69dc71f]`](https://github.com/aspnet/AspNetCore/commit/3fc69dc71f) Updated Streams to override Memory and Span overloads (#2333)
* [`[ff496ca580]`](https://github.com/aspnet/AspNetCore/commit/ff496ca580) Fix absolute paths to dotnet (#597)
* [`[9a9a2cf66a]`](https://github.com/aspnet/AspNetCore/commit/9a9a2cf66a) Make content files work better in class library projects referencing Razor Sdk
* [`[b3a33efeae]`](https://github.com/aspnet/AspNetCore/commit/b3a33efeae) Update MsgPack-Cli version
* [`[d9122fbdf7]`](https://github.com/aspnet/AspNetCore/commit/d9122fbdf7) update SignalR and MsgPack-Cli version (#909)
* [`[c8d4cf689f]`](https://github.com/aspnet/AspNetCore/commit/c8d4cf689f) Tackling some low hanging performance fruit (#1470)
* [`[f868fd8558]`](https://github.com/aspnet/AspNetCore/commit/f868fd8558) Rename cumulatvie runtimestores for publishing
* [`[3ca7c0365a]`](https://github.com/aspnet/AspNetCore/commit/3ca7c0365a) Force conformance tests to run on the CI (#228)
* [`[c395db12e6]`](https://github.com/aspnet/AspNetCore/commit/c395db12e6) Fix path searching for where.exe and request handler parsing (#595)
* [`[2a7d2ea12e]`](https://github.com/aspnet/AspNetCore/commit/2a7d2ea12e) Produce timestamped cumulative runtime store archives to enable ingestion of timestamped packages
* [`[0b777dad3f]`](https://github.com/aspnet/AspNetCore/commit/0b777dad3f) Decouple tooling from MVC assemblies
* [`[5008c7803c]`](https://github.com/aspnet/AspNetCore/commit/5008c7803c) Add a project system
* [`[59a1cf9293]`](https://github.com/aspnet/AspNetCore/commit/59a1cf9293) Add support for method parameters to Razor IR
* [`[fcf6ea03a9]`](https://github.com/aspnet/AspNetCore/commit/fcf6ea03a9) Add IDE extensibility for project engine
* [`[b644ecfeaa]`](https://github.com/aspnet/AspNetCore/commit/b644ecfeaa) Relayer interaction between extensions and engine
* [`[13824c418e]`](https://github.com/aspnet/AspNetCore/commit/13824c418e) Catch 15.7 up with dev
* [`[049caf0c10]`](https://github.com/aspnet/AspNetCore/commit/049caf0c10) Use RTM `Microsoft.AspNet.WebApi.Client` package - aspnet/Mvc#7212
* [`[0891903596]`](https://github.com/aspnet/AspNetCore/commit/0891903596) Use RTM `Microsoft.AspNet.WebApi.Client` package - aspnet/Mvc#7212
* [`[a2ac9c573e]`](https://github.com/aspnet/AspNetCore/commit/a2ac9c573e) Added try finally to semaphore release (#1469)
* [`[1f8591184e]`](https://github.com/aspnet/AspNetCore/commit/1f8591184e) Use ReferenceEquals not MulticastDelegate.equals (#2330)
* [`[de7faec246]`](https://github.com/aspnet/AspNetCore/commit/de7faec246) Pass the array segment offset to WriteAsync (#1467)
* [`[a513386f68]`](https://github.com/aspnet/AspNetCore/commit/a513386f68) Somehow the token didn't get passed into the reader (#1465)
* [`[43106f688a]`](https://github.com/aspnet/AspNetCore/commit/43106f688a) Re-enable "Move to RazorProjectEngine."
* [`[1fe383b973]`](https://github.com/aspnet/AspNetCore/commit/1fe383b973) Duplicate logic for Experimental
* [`[b48aeaf323]`](https://github.com/aspnet/AspNetCore/commit/b48aeaf323) Add Polly.Signed to lineup (#882)
* [`[10ae07774e]`](https://github.com/aspnet/AspNetCore/commit/10ae07774e) Fix experimental projects
* [`[eea8c1a146]`](https://github.com/aspnet/AspNetCore/commit/eea8c1a146) Support decrypting keys with X509Certificate that is not in the X509Store
* [`[06e225dc9f]`](https://github.com/aspnet/AspNetCore/commit/06e225dc9f) Better error for when you forget to clone submodules
* [`[ab472117ef]`](https://github.com/aspnet/AspNetCore/commit/ab472117ef) Update AspNetCoreRuntime package properties (#155)
* [`[1bd37cabf0]`](https://github.com/aspnet/AspNetCore/commit/1bd37cabf0) Make it possible to run the Browser Functional Tests from the command line (#1448)
* [`[1c451a7ff4]`](https://github.com/aspnet/AspNetCore/commit/1c451a7ff4) Update the remarks section for ViewData (#7371)
* [`[251ea37b49]`](https://github.com/aspnet/AspNetCore/commit/251ea37b49) Update Controller.cs
* [`[1f94925afa]`](https://github.com/aspnet/AspNetCore/commit/1f94925afa) Add note about required NPM version (#1462)
* [`[9ec207399d]`](https://github.com/aspnet/AspNetCore/commit/9ec207399d) bug fix: unused parameter in the constructor
* [`[87c3ca4752]`](https://github.com/aspnet/AspNetCore/commit/87c3ca4752) Send stderr logs to anonymous pipe instead of file when logging is disabled. (#549)
* [`[177e22ef41]`](https://github.com/aspnet/AspNetCore/commit/177e22ef41) Publish the Windows Server hosting bundle in prodcon output (#897)
* [`[dd5a84bd0e]`](https://github.com/aspnet/AspNetCore/commit/dd5a84bd0e) Add MVC razor extensions to the MvcSandbox
* [`[608330dc86]`](https://github.com/aspnet/AspNetCore/commit/608330dc86) Move to RazorProjectEngine.
* [`[00b0329059]`](https://github.com/aspnet/AspNetCore/commit/00b0329059) No more ExperimentalProjectVersionPrefix
* [`[50641534ad]`](https://github.com/aspnet/AspNetCore/commit/50641534ad) Publish corefxlab packages to the transport feed
* [`[e27009528f]`](https://github.com/aspnet/AspNetCore/commit/e27009528f) Add reference to MVC.Razor.Extensions
* [`[c293267421]`](https://github.com/aspnet/AspNetCore/commit/c293267421) Fixed unnecessary invocation of TagHelper target
* [`[a13a0aa8c4]`](https://github.com/aspnet/AspNetCore/commit/a13a0aa8c4) WebSdk transitions (#2078)
* [`[47e6d71215]`](https://github.com/aspnet/AspNetCore/commit/47e6d71215) test
* [`[d78e7ea80d]`](https://github.com/aspnet/AspNetCore/commit/d78e7ea80d) Fixed race in sockets transport (#2279) (#2322)
* [`[56ead8118a]`](https://github.com/aspnet/AspNetCore/commit/56ead8118a) Decouple Razor tools from MVC
* [`[334c3bd6c9]`](https://github.com/aspnet/AspNetCore/commit/334c3bd6c9) Use correct directory for packing sharedfx files
* [`[66714b5fc0]`](https://github.com/aspnet/AspNetCore/commit/66714b5fc0) Use ExperimentalPackageVersion
* [`[16bcd8871e]`](https://github.com/aspnet/AspNetCore/commit/16bcd8871e) WebSdk transitions
* [`[29920b7723]`](https://github.com/aspnet/AspNetCore/commit/29920b7723) Disable first time run experience (#153)
* [`[f1e63e0f9e]`](https://github.com/aspnet/AspNetCore/commit/f1e63e0f9e) Use ExperimentalPackageVersion
* [`[188aa81949]`](https://github.com/aspnet/AspNetCore/commit/188aa81949) Add spec for requirements of the LZMA [ci skip]
* [`[501c180b5f]`](https://github.com/aspnet/AspNetCore/commit/501c180b5f) Use properties in package props to redirect imports
* [`[961ed8992c]`](https://github.com/aspnet/AspNetCore/commit/961ed8992c) Add SITE_EXTENSION_SDK_VERSION override (#151)
* [`[14332c5daf]`](https://github.com/aspnet/AspNetCore/commit/14332c5daf) Allows Content-Length for 304 Not Modified response (#2321)
* [`[4ca45d951f]`](https://github.com/aspnet/AspNetCore/commit/4ca45d951f) Increment index by 1 as indexOf is inclusive when searching for dotnet.exe (#589)
* [`[81eca88270]`](https://github.com/aspnet/AspNetCore/commit/81eca88270) Enable KeyVault hosting startup (#149)
* [`[06e40252a0]`](https://github.com/aspnet/AspNetCore/commit/06e40252a0) Add support for top level validation to Razor Pages
* [`[fec15b8246]`](https://github.com/aspnet/AspNetCore/commit/fec15b8246) Split dependency versions into pinned vs automatically updated/overridden (#879)
* [`[02200d4c11]`](https://github.com/aspnet/AspNetCore/commit/02200d4c11) Integrate new WebSDK
* [`[a6165304b3]`](https://github.com/aspnet/AspNetCore/commit/a6165304b3) Add ExperimentalPackageVersion
* [`[133eff3119]`](https://github.com/aspnet/AspNetCore/commit/133eff3119) Move to RazorProjectEngine.
* [`[8770751a97]`](https://github.com/aspnet/AspNetCore/commit/8770751a97) Update the remarks section for ViewData
* [`[551158c239]`](https://github.com/aspnet/AspNetCore/commit/551158c239) Fixed exception during deserialization of a message with Redis (#1426)
* [`[9aa67caa59]`](https://github.com/aspnet/AspNetCore/commit/9aa67caa59) Put aspnetcore-runtime installers into a subfolder in dotnetcli (#886)
* [`[37db7a2367]`](https://github.com/aspnet/AspNetCore/commit/37db7a2367) Enable KeyVault hosting startup (#149)
* [`[5e97b02de6]`](https://github.com/aspnet/AspNetCore/commit/5e97b02de6) Mark Microsoft.AspNetCore.AspNetCoreModule as not-shipping
* [`[82579b6333]`](https://github.com/aspnet/AspNetCore/commit/82579b6333) Get rid of RazorConfiguration.DesignTime
* [`[5e1220377e]`](https://github.com/aspnet/AspNetCore/commit/5e1220377e) Mark Microsoft.AspNetCore.AspNetCoreModule as shipping
* [`[d9b32ee323]`](https://github.com/aspnet/AspNetCore/commit/d9b32ee323) Logging invocations with errors would throw inside logger (#1445)
* [`[d20d47924c]`](https://github.com/aspnet/AspNetCore/commit/d20d47924c) Add HostString.MatchesAny #2863
* [`[5483ea80f3]`](https://github.com/aspnet/AspNetCore/commit/5483ea80f3) Rebase fixes
* [`[b7c61128af]`](https://github.com/aspnet/AspNetCore/commit/b7c61128af) Resolve portable pdbs from symbols packages
* [`[6c4f043136]`](https://github.com/aspnet/AspNetCore/commit/6c4f043136) Include SignalR packages in .App/.All
* [`[3f3ac47d2e]`](https://github.com/aspnet/AspNetCore/commit/3f3ac47d2e) Update readme with generic rpm installer name
* [`[e21df792fb]`](https://github.com/aspnet/AspNetCore/commit/e21df792fb) Rename generic rpm installers
* [`[6abf11a3bb]`](https://github.com/aspnet/AspNetCore/commit/6abf11a3bb) Prepare output paths (#860)
* [`[ad4b73ebe9]`](https://github.com/aspnet/AspNetCore/commit/ad4b73ebe9) Fix property name in universe (#857)
* [`[bb5bf073c2]`](https://github.com/aspnet/AspNetCore/commit/bb5bf073c2) Update to final versions
* [`[6c22f25818]`](https://github.com/aspnet/AspNetCore/commit/6c22f25818) Client pipelines (#1435)
* [`[23c1fed2e4]`](https://github.com/aspnet/AspNetCore/commit/23c1fed2e4) Resolve portable pdbs from symbols packages
* [`[f4585bdbfd]`](https://github.com/aspnet/AspNetCore/commit/f4585bdbfd) Re-enable templates tests on CI (#874)
* [`[456121af8b]`](https://github.com/aspnet/AspNetCore/commit/456121af8b) Fix #320 - skip the certificate error page in Edge
* [`[c733156596]`](https://github.com/aspnet/AspNetCore/commit/c733156596) SDK changes needed to decouple Razor from MVC
* [`[183f476492]`](https://github.com/aspnet/AspNetCore/commit/183f476492) Add site extension store and additonal deps environmetn variables (#146)
* [`[4c08acd8a4]`](https://github.com/aspnet/AspNetCore/commit/4c08acd8a4) Don't allocate all the memory up front when receiving incoming sends (#1433)
* [`[94155b0e89]`](https://github.com/aspnet/AspNetCore/commit/94155b0e89) Use protocol.abstractions primitives instead of socket abstractions (#1432)
* [`[01f4bf01cc]`](https://github.com/aspnet/AspNetCore/commit/01f4bf01cc) Disambiguate between protocol abstractions and sockets (this is temporary)
* [`[f65e89294d]`](https://github.com/aspnet/AspNetCore/commit/f65e89294d) Add Plaintext sample (#2312)
* [`[342c4c44f6]`](https://github.com/aspnet/AspNetCore/commit/342c4c44f6) Change namespace to avoid conflict
* [`[e3f197cef0]`](https://github.com/aspnet/AspNetCore/commit/e3f197cef0) Use protocol.abstractions primitives instead of socket abstractions (#1429)
* [`[2156030460]`](https://github.com/aspnet/AspNetCore/commit/2156030460) Clean up some of protocol abstractions (#2311)
* [`[2ed78d5762]`](https://github.com/aspnet/AspNetCore/commit/2ed78d5762) Don't expose Channel from HubConnectionContext (#1428)
* [`[28439d1441]`](https://github.com/aspnet/AspNetCore/commit/28439d1441) Initial changes to move to pipelines (#1424)
* [`[3375fc8b99]`](https://github.com/aspnet/AspNetCore/commit/3375fc8b99) Change RazorProjectEngine to operate on RazorProjectItems.
* [`[a7676ddaf4]`](https://github.com/aspnet/AspNetCore/commit/a7676ddaf4) Include SignalR packages in .App/.All
* [`[e81e124586]`](https://github.com/aspnet/AspNetCore/commit/e81e124586) Fix whitespaces
* [`[1f3a26051d]`](https://github.com/aspnet/AspNetCore/commit/1f3a26051d) Fix duplicated namespace on startup
* [`[6bb798d2b7]`](https://github.com/aspnet/AspNetCore/commit/6bb798d2b7) Add minimumsamesitepolicy.None in the cookie policy options on the templates
* [`[67cf534bda]`](https://github.com/aspnet/AspNetCore/commit/67cf534bda) Fix B2C templates
* [`[8d5fa7da7d]`](https://github.com/aspnet/AspNetCore/commit/8d5fa7da7d) Update readme with generic rpm installer name
* [`[a5cba06ef8]`](https://github.com/aspnet/AspNetCore/commit/a5cba06ef8) Rename generic rpm installers
* [`[84bc74ea9f]`](https://github.com/aspnet/AspNetCore/commit/84bc74ea9f) Move to RazorProjectFileSystem.
* [`[1a77aecf68]`](https://github.com/aspnet/AspNetCore/commit/1a77aecf68) Align NETStandard.Library version variable with Universe
* [`[a64672d6e9]`](https://github.com/aspnet/AspNetCore/commit/a64672d6e9) Ensure publish directory is cleaned when /t:Clean is executed [ci skip]
* [`[0608de37dc]`](https://github.com/aspnet/AspNetCore/commit/0608de37dc) Upgrade dependencies to 2.1.0-preview1-28258
* [`[5dd590e75e]`](https://github.com/aspnet/AspNetCore/commit/5dd590e75e) Add clearer exception message to HttpResponseStream ODE (#2305)
* [`[e537cdd319]`](https://github.com/aspnet/AspNetCore/commit/e537cdd319) Prepare for Razor Sdk to be imported by Web Sdk
* [`[184520f501]`](https://github.com/aspnet/AspNetCore/commit/184520f501) Adding AngleSharp for testing purposes
* [`[06f1340f2a]`](https://github.com/aspnet/AspNetCore/commit/06f1340f2a) [2.1] Update initial identity migration (#313)
* [`[4040cb9638]`](https://github.com/aspnet/AspNetCore/commit/4040cb9638) Create all directories and make it by default (#862)
* [`[508d7ab9e1]`](https://github.com/aspnet/AspNetCore/commit/508d7ab9e1) Prepare output paths (#860)
* [`[bf5f40b1ed]`](https://github.com/aspnet/AspNetCore/commit/bf5f40b1ed) In Websocket proxy, don't forward User-Agent. Fixes #1469.
* [`[3d118de0d5]`](https://github.com/aspnet/AspNetCore/commit/3d118de0d5) Pass properties to super in derived classes. Fixes #289
* [`[6b44610079]`](https://github.com/aspnet/AspNetCore/commit/6b44610079) Align class event handler creation with React docs
* [`[c000f6af2d]`](https://github.com/aspnet/AspNetCore/commit/c000f6af2d) Update Angular template to match @angular/cli@1.6.8 output
* [`[331bf3515d]`](https://github.com/aspnet/AspNetCore/commit/331bf3515d) Add TSLint rule file and fix all violations (#1381)
* [`[72255f5338]`](https://github.com/aspnet/AspNetCore/commit/72255f5338) Fix property name in universe (#857)
* [`[0b2f053ad8]`](https://github.com/aspnet/AspNetCore/commit/0b2f053ad8) Fix #785 - publish nuget packages and the shared runtime at the same time
* [`[0435b6dc6e]`](https://github.com/aspnet/AspNetCore/commit/0435b6dc6e) add headers and revamp msgpack tests (#1382)
* [`[e12c666ed7]`](https://github.com/aspnet/AspNetCore/commit/e12c666ed7) Upgrade Remotion.Linq dependency to RTM
* [`[7b9da556fb]`](https://github.com/aspnet/AspNetCore/commit/7b9da556fb) Add `HttpRequestRewindExtensions` - aspnet/Home#2684 - makes the `BufferingHelper` methods used in MVC and WebHooks `public`
* [`[d27e66a8fc]`](https://github.com/aspnet/AspNetCore/commit/d27e66a8fc) Initialize ViewContext for TagHelperComponentTagHelper (#7326)
* [`[6d757988c9]`](https://github.com/aspnet/AspNetCore/commit/6d757988c9) Integrate new Sdk
* [`[0a7edd665e]`](https://github.com/aspnet/AspNetCore/commit/0a7edd665e) Added another integration test
* [`[7490b4413c]`](https://github.com/aspnet/AspNetCore/commit/7490b4413c) Change GenerateMPACK ItemGroup names to be non-plural.
* [`[83c31f611f]`](https://github.com/aspnet/AspNetCore/commit/83c31f611f) Update GenerateMPACK to capture PDBs.
* [`[9162ab3436]`](https://github.com/aspnet/AspNetCore/commit/9162ab3436) Default to using program files if where.exe doesn't find dotnet.exe (#578)
* [`[e133377d72]`](https://github.com/aspnet/AspNetCore/commit/e133377d72) Upgrade dependencies
* [`[c062d637fe]`](https://github.com/aspnet/AspNetCore/commit/c062d637fe) Add new contructor in SelectListItem.cs
* [`[57ce00d9ad]`](https://github.com/aspnet/AspNetCore/commit/57ce00d9ad) Fix conflicts / rebase (#1412)
* [`[bfb86b71df]`](https://github.com/aspnet/AspNetCore/commit/bfb86b71df) Fixing support for Protobuf in SocialWeather (#1362)
* [`[816ecf5cda]`](https://github.com/aspnet/AspNetCore/commit/816ecf5cda) Reduce the amount of argument checking by flattening the call graph. (#995)
* [`[0ec2bd4e76]`](https://github.com/aspnet/AspNetCore/commit/0ec2bd4e76) Add .App to LZMA
* [`[0f9d1f13ed]`](https://github.com/aspnet/AspNetCore/commit/0f9d1f13ed) Publish symbol packages to transport feed
* [`[594f03e935]`](https://github.com/aspnet/AspNetCore/commit/594f03e935) fix version in version.props (#1398)
* [`[a0c47c0c66]`](https://github.com/aspnet/AspNetCore/commit/a0c47c0c66) Increase ServerFixture startup timeout (#1409)
* [`[672a5f3c76]`](https://github.com/aspnet/AspNetCore/commit/672a5f3c76) Allow null value in query string KVP per RFC 3986 (#994)
* [`[711436b7a1]`](https://github.com/aspnet/AspNetCore/commit/711436b7a1) Notify which package is missing
* [`[84beb5985f]`](https://github.com/aspnet/AspNetCore/commit/84beb5985f) Add support for relative paths
* [`[450900d14c]`](https://github.com/aspnet/AspNetCore/commit/450900d14c) Added protected ctor to AuthenticationSchemeProvider (#990)
* [`[32659f2f00]`](https://github.com/aspnet/AspNetCore/commit/32659f2f00) Add SiteExtension readme (#142)
* [`[0df6bfb839]`](https://github.com/aspnet/AspNetCore/commit/0df6bfb839) Change the casing of Sdk to match other Sdks
* [`[f35d96b0db]`](https://github.com/aspnet/AspNetCore/commit/f35d96b0db) Include Microsoft.AspNetCore.App in the LZMA
* [`[e353005562]`](https://github.com/aspnet/AspNetCore/commit/e353005562) Use correct ArgumentNullException parameter name (#436)
* [`[e035d0ed96]`](https://github.com/aspnet/AspNetCore/commit/e035d0ed96) Fail fast on .NET Full Framework and log exceptions in hostfxr utility (#533)
* [`[870f023aa9]`](https://github.com/aspnet/AspNetCore/commit/870f023aa9) Add prelimianry support for extensions to Razor (#2012)
* [`[5b28c06d64]`](https://github.com/aspnet/AspNetCore/commit/5b28c06d64) Add prelimianry support for extensions to Razor (#2012)
* [`[6d21d9c04b]`](https://github.com/aspnet/AspNetCore/commit/6d21d9c04b) Raise IdentityModel dependencies to 5.2.0. Add new WsFed dependencies.
* [`[216e9f62c4]`](https://github.com/aspnet/AspNetCore/commit/216e9f62c4) Fix kestrel urls in launchSettings.json
* [`[a4427f5263]`](https://github.com/aspnet/AspNetCore/commit/a4427f5263) Fix kestrel urls in launchSettings.json
* [`[93b10d9060]`](https://github.com/aspnet/AspNetCore/commit/93b10d9060) Shorten logger to prevent longpath
* [`[ea9a74ee3c]`](https://github.com/aspnet/AspNetCore/commit/ea9a74ee3c) Change RazorTextViewConnectionListener to not depend on a primary workspace.
* [`[4f82c3e230]`](https://github.com/aspnet/AspNetCore/commit/4f82c3e230) Add new WsFederation package and dependencies
* [`[60cbedf5ee]`](https://github.com/aspnet/AspNetCore/commit/60cbedf5ee) Don't throw in Nginx deployer dispose (#1327)
* [`[8461158306]`](https://github.com/aspnet/AspNetCore/commit/8461158306) Use consistent file casing for Razor Sdk
* [`[fd62b194ca]`](https://github.com/aspnet/AspNetCore/commit/fd62b194ca) Update project .gitignore. Closes #280
* [`[eb5abc6ac5]`](https://github.com/aspnet/AspNetCore/commit/eb5abc6ac5) Add CPS dependencies
* [`[35779abd9a]`](https://github.com/aspnet/AspNetCore/commit/35779abd9a) Rename Microsoft.AspNetCore.Razor.Sdk to Microsoft.NET.Sdk.Razor
* [`[9ff2d2f87d]`](https://github.com/aspnet/AspNetCore/commit/9ff2d2f87d) Add CPS dependencies
* [`[8079ab8b58]`](https://github.com/aspnet/AspNetCore/commit/8079ab8b58) Adding host configurations for F# templates (#281)
* [`[ebeb7b93f9]`](https://github.com/aspnet/AspNetCore/commit/ebeb7b93f9) Add empty TypeScript starter template file. Closes #279
* [`[e0e4b007ec]`](https://github.com/aspnet/AspNetCore/commit/e0e4b007ec) Use http method names from HttpAbstractions
* [`[4eea2f6992]`](https://github.com/aspnet/AspNetCore/commit/4eea2f6992) Change DefaultTagHelperFactsService to not expect a primary workspace.
* [`[58411b4cc4]`](https://github.com/aspnet/AspNetCore/commit/58411b4cc4) Use header names from HttpAbstractions
* [`[d452ff44b3]`](https://github.com/aspnet/AspNetCore/commit/d452ff44b3) Include portable symbols in nupkgs (#2009)
* [`[1ea32bd569]`](https://github.com/aspnet/AspNetCore/commit/1ea32bd569) [Fixes #283] Updates vs-2017.3.host.json to include the HTTP port
* [`[2eef8fdff2]`](https://github.com/aspnet/AspNetCore/commit/2eef8fdff2) Add retries to help with test flakiness
* [`[64f9474eb1]`](https://github.com/aspnet/AspNetCore/commit/64f9474eb1) Change RazorCodeDocumentProvider to not be per-workspace.
* [`[b61dc35ee6]`](https://github.com/aspnet/AspNetCore/commit/b61dc35ee6) fix #1199 by suppressing ODE in received callback (#1395)
* [`[fff1c01aa0]`](https://github.com/aspnet/AspNetCore/commit/fff1c01aa0) Add Mac implementation of VisualStudioWorkspaceAccessor new APIs.
* [`[6d2460ae7f]`](https://github.com/aspnet/AspNetCore/commit/6d2460ae7f) Update DefaultRazorEditorFactoryService to be per-workspace.
* [`[5e454a36fa]`](https://github.com/aspnet/AspNetCore/commit/5e454a36fa) Change TextBufferProjectService to not be per-workspace.
* [`[c0b8be58ba]`](https://github.com/aspnet/AspNetCore/commit/c0b8be58ba) Add scheme forwarding (authN policies) (#1625)
* [`[f58ea8133b]`](https://github.com/aspnet/AspNetCore/commit/f58ea8133b) fix #1387 by removing our hacky EventSource typings (#1393)
* [`[818d4256aa]`](https://github.com/aspnet/AspNetCore/commit/818d4256aa) Fix #1999
* [`[94cfac8ec6]`](https://github.com/aspnet/AspNetCore/commit/94cfac8ec6) Use Microsoft.AspNetCore.App in templates
* [`[3ad022d5a9]`](https://github.com/aspnet/AspNetCore/commit/3ad022d5a9) Include SpaServices.Extensions in .App and .All metapackages
* [`[e4e837fa24]`](https://github.com/aspnet/AspNetCore/commit/e4e837fa24) Flatten dependencies of Microsoft.AspNetCore.All metapackage
* [`[2233481d34]`](https://github.com/aspnet/AspNetCore/commit/2233481d34) Ensure all packages are included in ArtifactInfo
* [`[2d5ab4d741]`](https://github.com/aspnet/AspNetCore/commit/2d5ab4d741) Add note about using latest tsc version to README (#1390)
* [`[9119433ab7]`](https://github.com/aspnet/AspNetCore/commit/9119433ab7) Add the middleware name to the exception message UseMiddlewareNoInvokeMethod (#993)
* [`[dea3eb7856]`](https://github.com/aspnet/AspNetCore/commit/dea3eb7856) Not instantiating the RequestHeaders and not relying on TypedHeaders to parse AcceptCharset
* [`[930664de6e]`](https://github.com/aspnet/AspNetCore/commit/930664de6e) Add INFO level logging (#7314)
* [`[6b095cf533]`](https://github.com/aspnet/AspNetCore/commit/6b095cf533) Allow overriding the hosting service provider  (#1325)
* [`[f8d61a4c52]`](https://github.com/aspnet/AspNetCore/commit/f8d61a4c52) Dispose the host if Initialize fails (#1324)
* [`[8cecca07a2]`](https://github.com/aspnet/AspNetCore/commit/8cecca07a2) Fix race in Restart during Close task (#1263)
* [`[cf951a16db]`](https://github.com/aspnet/AspNetCore/commit/cf951a16db) Workaround flakiness in compiling the ChatSample (#1384)
* [`[1f810fd535]`](https://github.com/aspnet/AspNetCore/commit/1f810fd535) Upgrading dependencies (#1383)
* [`[9607b25d4d]`](https://github.com/aspnet/AspNetCore/commit/9607b25d4d) Ignoring broken test
* [`[e8d69911fd]`](https://github.com/aspnet/AspNetCore/commit/e8d69911fd) Adding Http2 headers to HeaderNames class (#992)
* [`[e3131d0d5d]`](https://github.com/aspnet/AspNetCore/commit/e3131d0d5d) Use PackageVersion to set the name of the debian installers, not Version
* [`[20613b6fd2]`](https://github.com/aspnet/AspNetCore/commit/20613b6fd2) Re-add ExperimentalVersions (#831)
* [`[99010aaea4]`](https://github.com/aspnet/AspNetCore/commit/99010aaea4) Change EditorSettingsManager to not be per-workspace.
* [`[0afcf7ed76]`](https://github.com/aspnet/AspNetCore/commit/0afcf7ed76) Produce timestamped cumulative runtime store archives to enable ingestion of timestamped packages
* [`[05174814f6]`](https://github.com/aspnet/AspNetCore/commit/05174814f6) Ensure the LZMA includes CLI global tools .nupkg, nupkg.sha512, and .nuspec files (#829)
* [`[ba0abd2285]`](https://github.com/aspnet/AspNetCore/commit/ba0abd2285) Add missing bootstrap and js min files to RazorPages template (#269)
* [`[fe2628a68f]`](https://github.com/aspnet/AspNetCore/commit/fe2628a68f) Mark Logging.Analyzers as shipoob so it gets signed
* [`[723e2d854d]`](https://github.com/aspnet/AspNetCore/commit/723e2d854d) Update publish to include more metadata in the manifest (#826)
* [`[18575e8879]`](https://github.com/aspnet/AspNetCore/commit/18575e8879) Run more checks on Universe PRs
* [`[0215740183]`](https://github.com/aspnet/AspNetCore/commit/0215740183) [Fixes #5859] Consider allowing binding header values to types other than string and string collections
* [`[f3e7b801bc]`](https://github.com/aspnet/AspNetCore/commit/f3e7b801bc) Clarify version alignment of client and server in README (#1371)
* [`[e214d5cdfa]`](https://github.com/aspnet/AspNetCore/commit/e214d5cdfa) Reduce LongPolling timeout to accommodate Cloudflare's timeout (#1368)
* [`[b677a9e43f]`](https://github.com/aspnet/AspNetCore/commit/b677a9e43f) Skip only on non-windows
* [`[13388ca6ae]`](https://github.com/aspnet/AspNetCore/commit/13388ca6ae) Make testapps run without deployment
* [`[818bb50e43]`](https://github.com/aspnet/AspNetCore/commit/818bb50e43) Update metapackages
* [`[80f943caef]`](https://github.com/aspnet/AspNetCore/commit/80f943caef) Flow RazorLanguageVersion to RazorEngine.
* [`[471f0672d0]`](https://github.com/aspnet/AspNetCore/commit/471f0672d0) Use even newer version
* [`[48df8feaee]`](https://github.com/aspnet/AspNetCore/commit/48df8feaee) Allow ignoring Repos in UpdateSubmodules
* [`[80cbcfd075]`](https://github.com/aspnet/AspNetCore/commit/80cbcfd075) Update rest of versions
* [`[8ea181f088]`](https://github.com/aspnet/AspNetCore/commit/8ea181f088) Use the OnWriterCompleted and OnReaderCompleted events directly. (#2280)
* [`[e8816350ef]`](https://github.com/aspnet/AspNetCore/commit/e8816350ef) Add namespace for SignedOut.cshtml.cs (#266)
* [`[9137604ea3]`](https://github.com/aspnet/AspNetCore/commit/9137604ea3) Add ShipInstaller=dotnetcli to non-package blobs
* [`[f99426db15]`](https://github.com/aspnet/AspNetCore/commit/f99426db15) Fixup experimental version
* [`[011cf720e6]`](https://github.com/aspnet/AspNetCore/commit/011cf720e6) Add IServerVariablesFeature
* [`[6e122c45b4]`](https://github.com/aspnet/AspNetCore/commit/6e122c45b4) Mark cookie as non-essential. Home#2393
* [`[50b396cec6]`](https://github.com/aspnet/AspNetCore/commit/50b396cec6) Fixed race in sockets transport (#2279)
* [`[b37880c985]`](https://github.com/aspnet/AspNetCore/commit/b37880c985) Downgrade version of analyzers
* [`[dbff416be6]`](https://github.com/aspnet/AspNetCore/commit/dbff416be6) Add support for running conventions on controller properties, Razor Page parameter and properties
* [`[cb55973c27]`](https://github.com/aspnet/AspNetCore/commit/cb55973c27) Dispose the host if Initialize fails (#1318)
* [`[5d4fd2a592]`](https://github.com/aspnet/AspNetCore/commit/5d4fd2a592) Add project capability in 2.1 M.A.App for inproc hosting (#796)
* [`[2625b389b8]`](https://github.com/aspnet/AspNetCore/commit/2625b389b8) fix #1155 by renaming signalRTokenHeader to access_token (#1343) (#1359)
* [`[9f64c69a2a]`](https://github.com/aspnet/AspNetCore/commit/9f64c69a2a) Disambiguates IFormFile name docs (#935)
* [`[84bc0fa4c9]`](https://github.com/aspnet/AspNetCore/commit/84bc0fa4c9) Change ForegroundDispatcher to be a MEF service.
* [`[f319632c1f]`](https://github.com/aspnet/AspNetCore/commit/f319632c1f) Testing package fixes
* [`[c15cd757cf]`](https://github.com/aspnet/AspNetCore/commit/c15cd757cf) Set ASPNETCORE_URLS
* [`[8280c1b73f]`](https://github.com/aspnet/AspNetCore/commit/8280c1b73f) Update Kestrel HTTPS developer certificate error message
* [`[6d15dcf1ca]`](https://github.com/aspnet/AspNetCore/commit/6d15dcf1ca) Use TryAdd for ISessionStore service #2755
* [`[9e89e28f49]`](https://github.com/aspnet/AspNetCore/commit/9e89e28f49) Update runtime publishing to the release/2.1 channel
* [`[6ba5e8cadf]`](https://github.com/aspnet/AspNetCore/commit/6ba5e8cadf) Include metadata when publishing to blob (#804)
* [`[272aa16322]`](https://github.com/aspnet/AspNetCore/commit/272aa16322) Update JwtBearer sample error handling #1613
* [`[bd72b1bac9]`](https://github.com/aspnet/AspNetCore/commit/bd72b1bac9) Don't import the SDK when cross-targeting
* [`[a710688426]`](https://github.com/aspnet/AspNetCore/commit/a710688426) Include messages with Assert.True/False
* [`[0ec3dedc88]`](https://github.com/aspnet/AspNetCore/commit/0ec3dedc88) Fixes null ref in DatabaseErrorPageMiddleware.
* [`[2181fdc943]`](https://github.com/aspnet/AspNetCore/commit/2181fdc943) Invoke where.exe to find dotnet.exe (#559)
* [`[ad6f4046c8]`](https://github.com/aspnet/AspNetCore/commit/ad6f4046c8) Add EFCore.DocumentDb package (noship)
* [`[6590992c96]`](https://github.com/aspnet/AspNetCore/commit/6590992c96) fix #1155 by renaming signalRTokenHeader to access_token (#1343)
* [`[ab8328abca]`](https://github.com/aspnet/AspNetCore/commit/ab8328abca) Raise the CookiePolicy consent cookie lifetime to one year #1589
* [`[4203540cb0]`](https://github.com/aspnet/AspNetCore/commit/4203540cb0) Fix SocialWeather sample (#1313)
* [`[1cc4098d3a]`](https://github.com/aspnet/AspNetCore/commit/1cc4098d3a) Defensively stop redis container before starting (#1356)
* [`[baa665db81]`](https://github.com/aspnet/AspNetCore/commit/baa665db81) Include global CLI tool packages in the LZMA (#809)
* [`[7127bb5dbb]`](https://github.com/aspnet/AspNetCore/commit/7127bb5dbb) Add DeclaredModelType to Razor pages * This allows razor pages to override their model type with a model that   extends the declared model type through the page application model.
* [`[1e725e6f71]`](https://github.com/aspnet/AspNetCore/commit/1e725e6f71) Add Razor.Sdk package
* [`[33d391349a]`](https://github.com/aspnet/AspNetCore/commit/33d391349a) Add some docs for using the packages from browsers (#1355)
* [`[2326783a04]`](https://github.com/aspnet/AspNetCore/commit/2326783a04) Have definitive values for TheoryData
* [`[04bf7eec0f]`](https://github.com/aspnet/AspNetCore/commit/04bf7eec0f) Introduce a Razor SDK package
* [`[771a7e35a4]`](https://github.com/aspnet/AspNetCore/commit/771a7e35a4) Add MVC support for RazorProjectEngine.
* [`[354905dc00]`](https://github.com/aspnet/AspNetCore/commit/354905dc00) Set NodeJS 8 as a required toolset
* [`[b2373e157e]`](https://github.com/aspnet/AspNetCore/commit/b2373e157e) Support Webpack configs authored in TypeScript. Covers #1301
* [`[b30020a655]`](https://github.com/aspnet/AspNetCore/commit/b30020a655) PartialTagHelper should not fallback to the current page's model if asp-for expression exists
* [`[6162476e0a]`](https://github.com/aspnet/AspNetCore/commit/6162476e0a) Add aspnet/WebHooks to Universe
* [`[96a3a03de8]`](https://github.com/aspnet/AspNetCore/commit/96a3a03de8) Fix incorrect content-type (#1347)
* [`[a74ef9dfd9]`](https://github.com/aspnet/AspNetCore/commit/a74ef9dfd9) Error message for [ApiController] without attribute route needs to be better Fixes #7277
* [`[f71cbd39b5]`](https://github.com/aspnet/AspNetCore/commit/f71cbd39b5) Update to Preview2
* [`[a01fa1c5b6]`](https://github.com/aspnet/AspNetCore/commit/a01fa1c5b6) Flow RazorLanguageVersion to RazorEngine.
* [`[76cc53c2be]`](https://github.com/aspnet/AspNetCore/commit/76cc53c2be) Pick up templating changes
* [`[6274733565]`](https://github.com/aspnet/AspNetCore/commit/6274733565) TypeScript annotation fixes
* [`[30a68dec49]`](https://github.com/aspnet/AspNetCore/commit/30a68dec49) Fix flakiness in address-in-use test (#2267)
* [`[5f6f288056]`](https://github.com/aspnet/AspNetCore/commit/5f6f288056) Added support for Thenables
* [`[06348dded7]`](https://github.com/aspnet/AspNetCore/commit/06348dded7) Change request timeout validation to 1 second. (#546)
* [`[7c07beb494]`](https://github.com/aspnet/AspNetCore/commit/7c07beb494) adding support to pass Env param to webpack
* [`[e7ffb8bb71]`](https://github.com/aspnet/AspNetCore/commit/e7ffb8bb71) Returning provided promise in `addTask`
* [`[3e6f7f3e45]`](https://github.com/aspnet/AspNetCore/commit/3e6f7f3e45) Loosen aspnet-webpack peerDependency requirement back to cover what it allowed before (so it's not a breaking change)
* [`[4fd4fd9f41]`](https://github.com/aspnet/AspNetCore/commit/4fd4fd9f41) Mark HTTP/2 as not supported with an AppContext switch override.
* [`[d61a4ca89f]`](https://github.com/aspnet/AspNetCore/commit/d61a4ca89f) some fix for handling configuration change and recycling (#539)
* [`[b0bc3d111a]`](https://github.com/aspnet/AspNetCore/commit/b0bc3d111a) Fix misnamed variables
* [`[1669e39735]`](https://github.com/aspnet/AspNetCore/commit/1669e39735) Add firewall exclusions for test executables (#244)
* [`[857c0632a0]`](https://github.com/aspnet/AspNetCore/commit/857c0632a0) Use variable for CLI tool reference
* [`[b1ccc31ccf]`](https://github.com/aspnet/AspNetCore/commit/b1ccc31ccf) Update SPA template identifiers to end with ".2.1". Fixes #230
* [`[a5ab5b2abc]`](https://github.com/aspnet/AspNetCore/commit/a5ab5b2abc) Change submodule branches
* [`[da8675306b]`](https://github.com/aspnet/AspNetCore/commit/da8675306b) Do not include debug symbols in the secret manager vsix
* [`[67c76287ed]`](https://github.com/aspnet/AspNetCore/commit/67c76287ed) Return stream method error to client (#1331)
* [`[88e14a0bfe]`](https://github.com/aspnet/AspNetCore/commit/88e14a0bfe) Add constructor for the SelectListItem class
* [`[6ab9e94703]`](https://github.com/aspnet/AspNetCore/commit/6ab9e94703) Upgrade dependencies
* [`[6bc49ad6ca]`](https://github.com/aspnet/AspNetCore/commit/6bc49ad6ca) update to use corefx package (#222)
* [`[4f3e0966d9]`](https://github.com/aspnet/AspNetCore/commit/4f3e0966d9) Enabling antiforgery tests, which were disabled because of the #7040 issue
* [`[40e906f23a]`](https://github.com/aspnet/AspNetCore/commit/40e906f23a) Expose IHttpConnectionFeature properties (#1338)
* [`[2269a31983]`](https://github.com/aspnet/AspNetCore/commit/2269a31983) [Fixes #245] Update Identity to use the default layout from the application. Added /Areas/Identity/Pages/_ViewStart.cshtml and set the layout to the applications layout.
* [`[17a407bba2]`](https://github.com/aspnet/AspNetCore/commit/17a407bba2) [Fixes #7271] Support covariant casting of ViewDataDictionary<T> On HtmlHelper<T> we now support contextualizing an instance of HtmlHelper<TBase> with a ViewDataDictionary<TDerived> in ViewContext.ViewData.
* [`[13b3d51b80]`](https://github.com/aspnet/AspNetCore/commit/13b3d51b80) Exclude native assets from Microsoft.NETCore.App
* [`[1c0cf15b11]`](https://github.com/aspnet/AspNetCore/commit/1c0cf15b11) Add messages to Asserts (#2259)
* [`[78f4c7342b]`](https://github.com/aspnet/AspNetCore/commit/78f4c7342b) Update jQuery (#250)
* [`[641e17ca5b]`](https://github.com/aspnet/AspNetCore/commit/641e17ca5b) Update submodules
* [`[522f98de21]`](https://github.com/aspnet/AspNetCore/commit/522f98de21) Update branches
* [`[beefdd5f46]`](https://github.com/aspnet/AspNetCore/commit/beefdd5f46) Exclude native assets from Microsoft.NETCore.App
* [`[3d167c1e6c]`](https://github.com/aspnet/AspNetCore/commit/3d167c1e6c) Run http request on separate thread. (#545)
* [`[cf9075d3fc]`](https://github.com/aspnet/AspNetCore/commit/cf9075d3fc) Mirror System.Net.WebSockets.WebSocketProtocol (#789)
* [`[10f0f7b2ee]`](https://github.com/aspnet/AspNetCore/commit/10f0f7b2ee) Add project capability for inproc hosting (#532)
* [`[ee1c5c440c]`](https://github.com/aspnet/AspNetCore/commit/ee1c5c440c) Fix HeartbeatTests flakiness (#2268)
* [`[763393efc4]`](https://github.com/aspnet/AspNetCore/commit/763393efc4) Added a test verifying that the cache headers are not set after the response has started.
* [`[59f2cf8e66]`](https://github.com/aspnet/AspNetCore/commit/59f2cf8e66) Add contracts for RazorProjectEngine.
* [`[2d87bdf565]`](https://github.com/aspnet/AspNetCore/commit/2d87bdf565) Add support for MvcPrecompilation settings (#1956)
* [`[4fa975a416]`](https://github.com/aspnet/AspNetCore/commit/4fa975a416) Writing header cache values only when the response hasn't yet started
* [`[ec442c3d80]`](https://github.com/aspnet/AspNetCore/commit/ec442c3d80) set HasRuntimeOutput for test projects (#221)
* [`[b088eaa91f]`](https://github.com/aspnet/AspNetCore/commit/b088eaa91f) Rename JwtBearer to AccessToken in C# Client (#1333)
* [`[e64954c9c7]`](https://github.com/aspnet/AspNetCore/commit/e64954c9c7) Undo compatibility error messages
* [`[6138087de6]`](https://github.com/aspnet/AspNetCore/commit/6138087de6) Updated the DefaultAntiforgery to set the the cache headers only if they aren't set yet.
* [`[d159cb9b00]`](https://github.com/aspnet/AspNetCore/commit/d159cb9b00) Add application DbContext
* [`[ebdb3c650a]`](https://github.com/aspnet/AspNetCore/commit/ebdb3c650a) Smooth rough ApiBehavior edges
* [`[a449345436]`](https://github.com/aspnet/AspNetCore/commit/a449345436) Clean up logging (#1308)
* [`[1d6b02c1f5]`](https://github.com/aspnet/AspNetCore/commit/1d6b02c1f5) [Fixes #7239] Add support for loading additional parts. * Support loading parts through an assembly metadata attribute with a   key of Microsoft.AspNetCore.Mvc.AdditionalReference and a value that   describes the additional assembly to add to the list of parts and   whether or not it should be added by default. The additional reference   can only contain the file name of the assembly and it must be located   side by side with the assembly where the additional reference is   defined. * Add an AdditionalAssemblyPart application parts to represent parts   that are not part of the original application per se, like precompiled   views. * Update the ViewsFeatureProvider to search for razor views in the   application part directly instead of trying to load the precompiled   views assembly part.
* [`[24307dd301]`](https://github.com/aspnet/AspNetCore/commit/24307dd301) update deps
* [`[6b4673bbdc]`](https://github.com/aspnet/AspNetCore/commit/6b4673bbdc) Fixes bitness alignment issue for 32bit (#527)
* [`[22c09387cb]`](https://github.com/aspnet/AspNetCore/commit/22c09387cb) Update runtime store generation to respect DotNetAssetRootUrl
* [`[c0eabc39e3]`](https://github.com/aspnet/AspNetCore/commit/c0eabc39e3) Fix xform sample
* [`[f33892ebc4]`](https://github.com/aspnet/AspNetCore/commit/f33892ebc4) Add Microsoft.AspNetCore.Mvc.Analyzer
* [`[c6c77dd4d3]`](https://github.com/aspnet/AspNetCore/commit/c6c77dd4d3) Introduce Mvc analyzers
* [`[d7d502a04c]`](https://github.com/aspnet/AspNetCore/commit/d7d502a04c) Free stdout after app closes (#535)
* [`[e9058ff347]`](https://github.com/aspnet/AspNetCore/commit/e9058ff347) Update Scaffolding submodule to include aspnet/Scaffolding#676
* [`[5bd5ba9626]`](https://github.com/aspnet/AspNetCore/commit/5bd5ba9626) Mirror System.Data.SqlClient
* [`[d85ed094aa]`](https://github.com/aspnet/AspNetCore/commit/d85ed094aa) gracefully shutdown the filewatcher thread (#530)
* [`[f0f65317fb]`](https://github.com/aspnet/AspNetCore/commit/f0f65317fb) Add EntityFramework.Proxies package
* [`[b9db1ac7c8]`](https://github.com/aspnet/AspNetCore/commit/b9db1ac7c8) update deps
* [`[61d42825d7]`](https://github.com/aspnet/AspNetCore/commit/61d42825d7) Update deps
* [`[87288822a3]`](https://github.com/aspnet/AspNetCore/commit/87288822a3) Fix infinite loop in sample (#1324)
* [`[ae0207b578]`](https://github.com/aspnet/AspNetCore/commit/ae0207b578) Updated ResponseCaching to include https://github.com/aspnet/ResponseCaching/pull/154
* [`[95508a0058]`](https://github.com/aspnet/AspNetCore/commit/95508a0058) Fix rebase error
* [`[2599ecca46]`](https://github.com/aspnet/AspNetCore/commit/2599ecca46) Fix Antares specific behaviors in site extensions (#136)
* [`[d38764a8f0]`](https://github.com/aspnet/AspNetCore/commit/d38764a8f0) Rename InvokeAsync to SendAsync on the server (#1312)
* [`[df31235288]`](https://github.com/aspnet/AspNetCore/commit/df31235288) Ensure the required 2.0.x runtime is installed
* [`[5232d2352b]`](https://github.com/aspnet/AspNetCore/commit/5232d2352b) Use unique names for commonly used properties
* [`[2f44dbd572]`](https://github.com/aspnet/AspNetCore/commit/2f44dbd572) Update FileSystem submodule to include aspnet/FileSystem#315
* [`[2204989660]`](https://github.com/aspnet/AspNetCore/commit/2204989660) Always load hostfxr parameters if the app isn't loaded (#529)
* [`[523ee741f9]`](https://github.com/aspnet/AspNetCore/commit/523ee741f9) Update to .NET Core 2.0.6-servicing-26118-01 and System.Data.SqlClient 4.4.3-servicing-26117-02
* [`[3e2c3a7ab5]`](https://github.com/aspnet/AspNetCore/commit/3e2c3a7ab5) Update templating module to include aspnet/Templating#231
* [`[fa9d64bd8f]`](https://github.com/aspnet/AspNetCore/commit/fa9d64bd8f) Update BasicMiddleware and Kestrel submodules
* [`[829aea2f65]`](https://github.com/aspnet/AspNetCore/commit/829aea2f65) Add doc for common questions about working with git-submodules [ci skip]
* [`[3a0fa2de36]`](https://github.com/aspnet/AspNetCore/commit/3a0fa2de36) Update to handle changes from Web SDK
* [`[d69061552f]`](https://github.com/aspnet/AspNetCore/commit/d69061552f) Update deps
* [`[233e67d0e0]`](https://github.com/aspnet/AspNetCore/commit/233e67d0e0) Prepare for Web SDK changes
* [`[d4ed8a7b77]`](https://github.com/aspnet/AspNetCore/commit/d4ed8a7b77) Prefer BeforeTargets/AfterTargets over evaluation
* [`[a177c557c5]`](https://github.com/aspnet/AspNetCore/commit/a177c557c5) [2.0.x PATCH] Add app.config to net 4.x templates (#231)
* [`[526dfdb332]`](https://github.com/aspnet/AspNetCore/commit/526dfdb332) Switch back to libuv as the default transport (#2257)
* [`[fb4d7fe5d9]`](https://github.com/aspnet/AspNetCore/commit/fb4d7fe5d9) Update FileSystem submodule and apply the result of the cascading versions
* [`[dfe0697f06]`](https://github.com/aspnet/AspNetCore/commit/dfe0697f06) EventId starts at 1 for logging (#1318)
* [`[767a857635]`](https://github.com/aspnet/AspNetCore/commit/767a857635) Set CompatibilityVersion for templates (#240)
* [`[040ea2e6b4]`](https://github.com/aspnet/AspNetCore/commit/040ea2e6b4) Fix MockLibuv.OnPostTask (#2260)
* [`[0bfe043f6d]`](https://github.com/aspnet/AspNetCore/commit/0bfe043f6d) Add yaml files (#241)
* [`[9f5d51656a]`](https://github.com/aspnet/AspNetCore/commit/9f5d51656a) Fix check for use of compile items
* [`[f2d6cfa821]`](https://github.com/aspnet/AspNetCore/commit/f2d6cfa821) Update checksums
* [`[e16134d4d2]`](https://github.com/aspnet/AspNetCore/commit/e16134d4d2) update deps
* [`[f0ae0ce528]`](https://github.com/aspnet/AspNetCore/commit/f0ae0ce528) Add PageConvention overloads for areas
* [`[82eed8fdf9]`](https://github.com/aspnet/AspNetCore/commit/82eed8fdf9) update deps
* [`[d1cfc51c9d]`](https://github.com/aspnet/AspNetCore/commit/d1cfc51c9d) Add a property so the web sdk can know that the Razor compiler is available.
* [`[ab7ec622ef]`](https://github.com/aspnet/AspNetCore/commit/ab7ec622ef) Make paths absolute for in-process, fix relative path check (#513)
* [`[49a3b6bcae]`](https://github.com/aspnet/AspNetCore/commit/49a3b6bcae) Use ZipArchive task instead of powershell.
* [`[c78b8a7c1c]`](https://github.com/aspnet/AspNetCore/commit/c78b8a7c1c) Update SQLite submodule
* [`[6751e3b7ca]`](https://github.com/aspnet/AspNetCore/commit/6751e3b7ca) Discover assembly parts for Microsoft.AspnetCore.All
* [`[0584fe3ecf]`](https://github.com/aspnet/AspNetCore/commit/0584fe3ecf) Make RazorCompileOnPublish the default
* [`[627696677c]`](https://github.com/aspnet/AspNetCore/commit/627696677c) Split up Razor SDK logic (#1934)
* [`[eb107092d9]`](https://github.com/aspnet/AspNetCore/commit/eb107092d9) Upgrade dependencies
* [`[f8192fd63c]`](https://github.com/aspnet/AspNetCore/commit/f8192fd63c) Workaround corefx/26390 (#295)
* [`[e53e74c6a6]`](https://github.com/aspnet/AspNetCore/commit/e53e74c6a6) Fix broken link in readme [ci skip]
* [`[a5d6f9b36f]`](https://github.com/aspnet/AspNetCore/commit/a5d6f9b36f) Rename submodule branches to release/2.0
* [`[7835809ff2]`](https://github.com/aspnet/AspNetCore/commit/7835809ff2) Add Razor.Design to MVC package
* [`[444b67b141]`](https://github.com/aspnet/AspNetCore/commit/444b67b141) Update deps
* [`[968e033e4b]`](https://github.com/aspnet/AspNetCore/commit/968e033e4b) Make Block and Span cache Length.
* [`[92111ea515]`](https://github.com/aspnet/AspNetCore/commit/92111ea515) Make Block and Span cache Length.
* [`[c88f7be1ab]`](https://github.com/aspnet/AspNetCore/commit/c88f7be1ab) Include the VSIX and MPack files in the bill of materials
* [`[cf371a4e74]`](https://github.com/aspnet/AspNetCore/commit/cf371a4e74) Disable heartbeat warning when debugger is attached (#2258)
* [`[7b65bdb6ef]`](https://github.com/aspnet/AspNetCore/commit/7b65bdb6ef) Panwang/addinglog (#508)
* [`[e8af1141cb]`](https://github.com/aspnet/AspNetCore/commit/e8af1141cb) Attempt to fix Razor CI flakiness
* [`[f4d27e67bb]`](https://github.com/aspnet/AspNetCore/commit/f4d27e67bb) Improve server shutdown logic (#2247)
* [`[5d2f598c80]`](https://github.com/aspnet/AspNetCore/commit/5d2f598c80) Update initial migrations
* [`[8c1623695a]`](https://github.com/aspnet/AspNetCore/commit/8c1623695a) Update deps
* [`[a3df6a7bf9]`](https://github.com/aspnet/AspNetCore/commit/a3df6a7bf9) Add dynamic scheme sample
* [`[ad24f6b22d]`](https://github.com/aspnet/AspNetCore/commit/ad24f6b22d) Roll corefx packages back to 26112-01 (#783)
* [`[ba1eb281d1]`](https://github.com/aspnet/AspNetCore/commit/ba1eb281d1) Stop logging username/token
* [`[68aa609650]`](https://github.com/aspnet/AspNetCore/commit/68aa609650) Setting ContentType in the HTTP responses (#1149)
* [`[e30b8ee360]`](https://github.com/aspnet/AspNetCore/commit/e30b8ee360) Update runtime to catch up to SDK (#781)
* [`[5839baaa2e]`](https://github.com/aspnet/AspNetCore/commit/5839baaa2e) Update roslyn dependencies
* [`[ab3134e373]`](https://github.com/aspnet/AspNetCore/commit/ab3134e373) Support conflict resolution when multiple precompiled views have the same path
* [`[b5554a8038]`](https://github.com/aspnet/AspNetCore/commit/b5554a8038) Make Razor SDK support refs and views on publish
* [`[d686acad87]`](https://github.com/aspnet/AspNetCore/commit/d686acad87) Avoid use of AssemblyQualifiedName in tests
* [`[c3dedd9feb]`](https://github.com/aspnet/AspNetCore/commit/c3dedd9feb) update deps
* [`[d1984aa44b]`](https://github.com/aspnet/AspNetCore/commit/d1984aa44b) Add hook for precompilation
* [`[14cea3c1b9]`](https://github.com/aspnet/AspNetCore/commit/14cea3c1b9) Move properties
* [`[f0c3843a5b]`](https://github.com/aspnet/AspNetCore/commit/f0c3843a5b) Implment support for publish
* [`[f025a27f04]`](https://github.com/aspnet/AspNetCore/commit/f025a27f04) Unify how AdhocWorkspace is constructed.
* [`[e6bb551018]`](https://github.com/aspnet/AspNetCore/commit/e6bb551018) Adds support for loading the developer certificate from a pfx file * If we can't find a developer certificate on the certificate store   we will look for a developer certificate on the file system if a   password has been specified for the Development certificate. * We will look at ${APPDATA}/ASP.NET/https/<<AppName>>.pfx for windows   and fallback to ${HOME}/.aspnet/https/<<AppName>>.pfx * In case the password wasn't specified through configuration, the file   is not found on the file system or can't be loaded, we won't   do anything.
* [`[946b64143e]`](https://github.com/aspnet/AspNetCore/commit/946b64143e) Allow override routes on Pages
* [`[ecb323b5dc]`](https://github.com/aspnet/AspNetCore/commit/ecb323b5dc) Use FilePath if RelativePhysicalPath on RazorProjectItem is null
* [`[66c13ae5e5]`](https://github.com/aspnet/AspNetCore/commit/66c13ae5e5)  Use weak comparison for If-None-Match header (#7237)
* [`[d4adf14819]`](https://github.com/aspnet/AspNetCore/commit/d4adf14819) Update exclusions for nuget package verifier
* [`[e5de4e672c]`](https://github.com/aspnet/AspNetCore/commit/e5de4e672c) Marked Antiforgery cookie as essential Related to https://github.com/aspnet/Home/issues/2408 : Determine if the antiforgery cookie is considered essential
* [`[386c3f4664]`](https://github.com/aspnet/AspNetCore/commit/386c3f4664) Update EF Core submodule
* [`[a862959566]`](https://github.com/aspnet/AspNetCore/commit/a862959566) Support stream cancellation on TS client (#1275)
* [`[230e4a02ef]`](https://github.com/aspnet/AspNetCore/commit/230e4a02ef) Split compilation and tests into separate phases (#779)
* [`[91fb3eb41e]`](https://github.com/aspnet/AspNetCore/commit/91fb3eb41e) Changed CookieTempDataProvider's cookie SameSite to Lax [Fixes #7190] Can not retrieve cookie-based TempData after Google authentication with account selection in Google Chrome
* [`[d342ebf8c8]`](https://github.com/aspnet/AspNetCore/commit/d342ebf8c8) Use compatibility switch for auth filters
* [`[c922b0b90d]`](https://github.com/aspnet/AspNetCore/commit/c922b0b90d) Improving logging - model binding Related to issue #6498: When enabling "Trace" logging for MVC loggers, I should be buried in log messages
* [`[946ba04333]`](https://github.com/aspnet/AspNetCore/commit/946ba04333) mark System.Threading.Channels non-private and update SignalR (#778)
* [`[4791eccc4f]`](https://github.com/aspnet/AspNetCore/commit/4791eccc4f) Update references to the 2.0.5 runtime store
* [`[5f501710aa]`](https://github.com/aspnet/AspNetCore/commit/5f501710aa)  Make Razor targets noop with no razor files
* [`[0311f9b415]`](https://github.com/aspnet/AspNetCore/commit/0311f9b415) Throw InvalidDataException instead of FormatException in NegotationProtocol (#1246)
* [`[b20e35e76a]`](https://github.com/aspnet/AspNetCore/commit/b20e35e76a) Set RelativePhysicalPath in FileProviderRazorProjectItem
* [`[57697baedb]`](https://github.com/aspnet/AspNetCore/commit/57697baedb) Tolerate leading "~/" or "/" (#509)
* [`[1c4d23f79d]`](https://github.com/aspnet/AspNetCore/commit/1c4d23f79d) Add TFM compatibility check to 2.1 metapackage
* [`[9438a453b0]`](https://github.com/aspnet/AspNetCore/commit/9438a453b0) Do not serve response body for HEAD requests (#7230)
* [`[4bbd0bc530]`](https://github.com/aspnet/AspNetCore/commit/4bbd0bc530) fix artifacts, external deps and update SignalR (#775)
* [`[bef015de51]`](https://github.com/aspnet/AspNetCore/commit/bef015de51) Update aspnet/Routing submodule
* [`[e3679cb3c1]`](https://github.com/aspnet/AspNetCore/commit/e3679cb3c1) SocketsSample Send to Connection (#1285)
* [`[a036fa6bf4]`](https://github.com/aspnet/AspNetCore/commit/a036fa6bf4) Add support for cleaning certificates on the machine to the dev-certs tool
* [`[30b520df3e]`](https://github.com/aspnet/AspNetCore/commit/30b520df3e) Be verbose about missing items
* [`[5214c9382b]`](https://github.com/aspnet/AspNetCore/commit/5214c9382b) Run some verification checks on PRs and add early errors for bad PackageArtifact config (#771)
* [`[74229e57db]`](https://github.com/aspnet/AspNetCore/commit/74229e57db) Fix FunctionalTests on fresh system
* [`[2aae8774f6]`](https://github.com/aspnet/AspNetCore/commit/2aae8774f6) [Fixes 7139] Add format filter mapping for xml formatters
* [`[00c6b53b06]`](https://github.com/aspnet/AspNetCore/commit/00c6b53b06) [Fixes #7115] Update property type check in SaveTempDataPropertyFilterBase to match TempDataSerializer requirements
* [`[d2c27104dd]`](https://github.com/aspnet/AspNetCore/commit/d2c27104dd) Throwing AntiforgeryValidationException for failure to deserializing tokens
* [`[d786cebb72]`](https://github.com/aspnet/AspNetCore/commit/d786cebb72) Add SignalR to the meta-package (#768)
* [`[144984e599]`](https://github.com/aspnet/AspNetCore/commit/144984e599) Split MsgPack into separate assembly (#1274)
* [`[bda4d15fbd]`](https://github.com/aspnet/AspNetCore/commit/bda4d15fbd) Fix download link to RPM package [ci skip]
* [`[50fe88195e]`](https://github.com/aspnet/AspNetCore/commit/50fe88195e) Updating SocketsSample with new IHubClients and IHubCallerClients APIs (#1282)
* [`[871debe753]`](https://github.com/aspnet/AspNetCore/commit/871debe753) Use platform assemblies paths instead of app paths for crossgen
* [`[83b7d0b052]`](https://github.com/aspnet/AspNetCore/commit/83b7d0b052) Update EF Core and Kestrel submodules
* [`[8707d71f1e]`](https://github.com/aspnet/AspNetCore/commit/8707d71f1e) Set overwrite to true on creating AspNetCoreModule nupkg (#514)
* [`[95d743e2c6]`](https://github.com/aspnet/AspNetCore/commit/95d743e2c6) Renable compatibility switch functional tests
* [`[2d38720211]`](https://github.com/aspnet/AspNetCore/commit/2d38720211) Don't call PushToBlobFeed in the repo context
* [`[420500e2a9]`](https://github.com/aspnet/AspNetCore/commit/420500e2a9) #2102 Always start the response before draining the request.
* [`[9a8dd6ef12]`](https://github.com/aspnet/AspNetCore/commit/9a8dd6ef12) Allow Content-Length 0 for Websocket-Connection (#2217)
* [`[8d6b86c76a]`](https://github.com/aspnet/AspNetCore/commit/8d6b86c76a) Add `RazorLanguage.CoreContentType`.
* [`[eabde9fe9e]`](https://github.com/aspnet/AspNetCore/commit/eabde9fe9e) Add CookiePolicy and consent UI
* [`[913cefdea2]`](https://github.com/aspnet/AspNetCore/commit/913cefdea2) Fix a bug blocking recompilation
* [`[a6fe3a67a3]`](https://github.com/aspnet/AspNetCore/commit/a6fe3a67a3) Add Razor compilation to MvcSandbox
* [`[6bd421d197]`](https://github.com/aspnet/AspNetCore/commit/6bd421d197) Fixing BackSlashExpander class name
* [`[afc75a8296]`](https://github.com/aspnet/AspNetCore/commit/afc75a8296) Move `IHttpRequestStreamReaderFactory` from `.Internal` to `.Infrastructure` - #7044 - move `IHttpResponseStreamWriterFactory` too - add breaking change records e.g. for changes to `BodyModelBinder[Provider]` constructors   - these changes relate to previously-"internal" constructors and one property
* [`[c9ac2e6c29]`](https://github.com/aspnet/AspNetCore/commit/c9ac2e6c29) Add `DisplayMetadata.NullDisplayTextProvider` and similar properties - #6730 - `DisplayFormatStringProvider`, `EditFormatStringProvider`
* [`[91b852136b]`](https://github.com/aspnet/AspNetCore/commit/91b852136b) Update publish step to support pushing all assets to the transport feed
* [`[6358e0d3ef]`](https://github.com/aspnet/AspNetCore/commit/6358e0d3ef) Update README and list of installers to publish
* [`[0f39f91a08]`](https://github.com/aspnet/AspNetCore/commit/0f39f91a08) Copy all outputs to artifacts directory after publish
* [`[75e3ed952b]`](https://github.com/aspnet/AspNetCore/commit/75e3ed952b) Update functional tests
* [`[fbb73bccd0]`](https://github.com/aspnet/AspNetCore/commit/fbb73bccd0) Update our version of the RazorCoreCompile
* [`[595d05965a]`](https://github.com/aspnet/AspNetCore/commit/595d05965a) Rename some things
* [`[b7415502bf]`](https://github.com/aspnet/AspNetCore/commit/b7415502bf) Add RelativePhysicalPath
* [`[a54852fe6e]`](https://github.com/aspnet/AspNetCore/commit/a54852fe6e) Add targets to deploy all known installers to an azure blob feed
* [`[89b532c985]`](https://github.com/aspnet/AspNetCore/commit/89b532c985) Invoke Users (#1257)
* [`[5a93dffb06]`](https://github.com/aspnet/AspNetCore/commit/5a93dffb06) Distro agnostic installers
* [`[32a29980d8]`](https://github.com/aspnet/AspNetCore/commit/32a29980d8) Update config to pull runtime store from the public CLI feed
* [`[d58d0f917f]`](https://github.com/aspnet/AspNetCore/commit/d58d0f917f) Add support for recompilation
* [`[8ebe0a2d29]`](https://github.com/aspnet/AspNetCore/commit/8ebe0a2d29) Derive Web API templates from ControllerBase (#220)
* [`[96060d8b63]`](https://github.com/aspnet/AspNetCore/commit/96060d8b63) Generate cumulative archives for all platforms
* [`[b68d9cf01f]`](https://github.com/aspnet/AspNetCore/commit/b68d9cf01f) Always deserialize to DefaultRazorDiagnostic
* [`[ee6256d941]`](https://github.com/aspnet/AspNetCore/commit/ee6256d941) Update sample to use aspnetcore.dll and aspnetcorerh.dll (#512)
* [`[73bd09dc1c]`](https://github.com/aspnet/AspNetCore/commit/73bd09dc1c) Add CombineAuthorizeFilters option
* [`[acd6f7b064]`](https://github.com/aspnet/AspNetCore/commit/acd6f7b064) Generate full pdb when running in net461
* [`[cabc9874c5]`](https://github.com/aspnet/AspNetCore/commit/cabc9874c5) Generate deps for hosting startup in external dependencies
* [`[867438a4ae]`](https://github.com/aspnet/AspNetCore/commit/867438a4ae) LZMA woes
* [`[07d014ab32]`](https://github.com/aspnet/AspNetCore/commit/07d014ab32) January patch fixes
* [`[4ed1ade289]`](https://github.com/aspnet/AspNetCore/commit/4ed1ade289) Trim common manifest
* [`[95c663a289]`](https://github.com/aspnet/AspNetCore/commit/95c663a289) Handle malformed origin Uri (#139)
* [`[405d6f97bf]`](https://github.com/aspnet/AspNetCore/commit/405d6f97bf) Rename Microsoft.AspNetCore.AspNetCoreModule.RequestHandler to .Server.IIS
* [`[48ed4a6997]`](https://github.com/aspnet/AspNetCore/commit/48ed4a6997) Package aspnetcorerh in Microsoft.AspNetCore.Server.IIS
* [`[dde7671c06]`](https://github.com/aspnet/AspNetCore/commit/dde7671c06) OIDC: Use IdentityModel redirect form generator #1448
* [`[226b24060f]`](https://github.com/aspnet/AspNetCore/commit/226b24060f) Update deps
* [`[2e73bab2a4]`](https://github.com/aspnet/AspNetCore/commit/2e73bab2a4) Move option for JSON errors to MvcJsonOptions
* [`[16324c3126]`](https://github.com/aspnet/AspNetCore/commit/16324c3126) Add an Identifier by default
* [`[9f5b1aa18a]`](https://github.com/aspnet/AspNetCore/commit/9f5b1aa18a) Update README to indicate dotnet-install is for prerelease versions of the CLI [ci skip]
* [`[61dbe32e1e]`](https://github.com/aspnet/AspNetCore/commit/61dbe32e1e) Fixup missed variable rename
* [`[d602f9d770]`](https://github.com/aspnet/AspNetCore/commit/d602f9d770) Add relative path to source document
* [`[cedbbd8394]`](https://github.com/aspnet/AspNetCore/commit/cedbbd8394) Use latest `Microsoft.AspNet.WebApi.Client` package - aspnet/Mvc#5822 - see also PR aspnet/Mvc#7200
* [`[7bbfd2dcad]`](https://github.com/aspnet/AspNetCore/commit/7bbfd2dcad) Rename intermediate sharedfx archive to avoid conflicts with final file (#755)
* [`[9fd60ff864]`](https://github.com/aspnet/AspNetCore/commit/9fd60ff864) Marked CookieTempDataProvider's cookie as non-essential [Fixes #7160] Determine if the temp data cookie is considered essential
* [`[f2d2db0033]`](https://github.com/aspnet/AspNetCore/commit/f2d2db0033) Makes schema in root folder (#510)
* [`[594c62947e]`](https://github.com/aspnet/AspNetCore/commit/594c62947e) Adds aspnetcore_schemas to zip (#509)
* [`[8b34b7f2ae]`](https://github.com/aspnet/AspNetCore/commit/8b34b7f2ae) Invoke Multiple Groups (#1254)
* [`[1f855f7b06]`](https://github.com/aspnet/AspNetCore/commit/1f855f7b06) Implement ITrackingConsentFeature.CreateConsentCookie() #1590
* [`[e1f9a65083]`](https://github.com/aspnet/AspNetCore/commit/e1f9a65083) MultipleClients -> Clients (#1269)
* [`[ce69341265]`](https://github.com/aspnet/AspNetCore/commit/ce69341265) Add ITrackingConsentFeature.CreateConsentCookie
* [`[da3a49a9b0]`](https://github.com/aspnet/AspNetCore/commit/da3a49a9b0) Add HttpsPort settings to Empty F# template (#219)
* [`[12806465d8]`](https://github.com/aspnet/AspNetCore/commit/12806465d8) Crossgen SharedFx
* [`[ebd358ec05]`](https://github.com/aspnet/AspNetCore/commit/ebd358ec05) Update AzureServicesAppAuthentication (#727)
* [`[ad2149f5f0]`](https://github.com/aspnet/AspNetCore/commit/ad2149f5f0) Change ApplicationProtocol to ReadOnlyMemory<byte> #2182
* [`[40d027fca3]`](https://github.com/aspnet/AspNetCore/commit/40d027fca3) File results - logging
* [`[589b3978a8]`](https://github.com/aspnet/AspNetCore/commit/589b3978a8) Make M.A.AspNetCoreModule a conditional dependency
* [`[4c8a7de748]`](https://github.com/aspnet/AspNetCore/commit/4c8a7de748) Switch SystemThreadingTasksExtensionsPackageVersion to preview1
* [`[bef789cd1d]`](https://github.com/aspnet/AspNetCore/commit/bef789cd1d) Update SystemThreadingTasksExtensionsPackageVersion (#752)
* [`[de3355454c]`](https://github.com/aspnet/AspNetCore/commit/de3355454c) Make M.A.AspNetCoreModule a conditional dependency (#218)
* [`[f269f6b729]`](https://github.com/aspnet/AspNetCore/commit/f269f6b729) Make M.A.AspNetCoreModule a package dependency only on windows (#102)
* [`[d3fac039fb]`](https://github.com/aspnet/AspNetCore/commit/d3fac039fb) Make the ANCM a conditional dependency  (#838)
* [`[bd3195ff43]`](https://github.com/aspnet/AspNetCore/commit/bd3195ff43) Fix dependencies.props
* [`[7ab7e83988]`](https://github.com/aspnet/AspNetCore/commit/7ab7e83988) Update Kestrel dependency
* [`[2d3a01d48d]`](https://github.com/aspnet/AspNetCore/commit/2d3a01d48d) Change ApplicationProtocol to ReadOnlyMemory<byte> #2182
* [`[98e74b9a69]`](https://github.com/aspnet/AspNetCore/commit/98e74b9a69) Added TagHelperSerializationBenchmark
* [`[988d1b3c34]`](https://github.com/aspnet/AspNetCore/commit/988d1b3c34) Use common BDN runner and config
* [`[f4ea4033a3]`](https://github.com/aspnet/AspNetCore/commit/f4ea4033a3) Disabling tests while investigating ANCM responding with 400 status code. (#837)
* [`[c0761df411]`](https://github.com/aspnet/AspNetCore/commit/c0761df411) Disables Functional tests due to status code 400 issues (#505)
* [`[6a928fbe73]`](https://github.com/aspnet/AspNetCore/commit/6a928fbe73)  Disabling tests due to 400 status code issues (#101)
* [`[8502900c18]`](https://github.com/aspnet/AspNetCore/commit/8502900c18) Add Dispatcher packages descriptions (#507)
* [`[d81da5675f]`](https://github.com/aspnet/AspNetCore/commit/d81da5675f) Update IISIntegration submodule
* [`[7c939212a2]`](https://github.com/aspnet/AspNetCore/commit/7c939212a2) Add RequestHandler as an artifact (#737)
* [`[c3bc6fed9c]`](https://github.com/aspnet/AspNetCore/commit/c3bc6fed9c) Adds RequestHandler dll and hostfxr changes from ANCM (#497)
* [`[575c006aff]`](https://github.com/aspnet/AspNetCore/commit/575c006aff) Produce a zip with ANCM binaries
* [`[997544077a]`](https://github.com/aspnet/AspNetCore/commit/997544077a) Use common BDN runner and config (#7186)
* [`[22da82ff8a]`](https://github.com/aspnet/AspNetCore/commit/22da82ff8a) Sync remaining Angular-CSharp changes from OOB release into dev branch
* [`[0d9f17211f]`](https://github.com/aspnet/AspNetCore/commit/0d9f17211f) Fix @angular/platform-server version in package-lock.json
* [`[c637130f88]`](https://github.com/aspnet/AspNetCore/commit/c637130f88) In React and ReactRedux templates, switch from npm-shrinkwrap.json to package-lock.json
* [`[27878265bc]`](https://github.com/aspnet/AspNetCore/commit/27878265bc) Update Angular template to Angular CLI 1.6.3, plus switch it from npm-shrinkwrap.json to package-lock.json
* [`[c66d5240d1]`](https://github.com/aspnet/AspNetCore/commit/c66d5240d1) Recreate cache of endpoints when data source updated (#503)
* [`[0eca36ed26]`](https://github.com/aspnet/AspNetCore/commit/0eca36ed26) Fix ChatSample to send array correctly (#1261)
* [`[d5d159eb5f]`](https://github.com/aspnet/AspNetCore/commit/d5d159eb5f) Lock around heartbeat handler (#1264)
* [`[5d8670243c]`](https://github.com/aspnet/AspNetCore/commit/5d8670243c) Use location of aspnetcore.dll rather than the activating process.  (#500)
* [`[bf61ce2b8f]`](https://github.com/aspnet/AspNetCore/commit/bf61ce2b8f) Document compatiblity switch for input formatter exceptions
* [`[d49d432898]`](https://github.com/aspnet/AspNetCore/commit/d49d432898) Fix tag helper discovery in our tool
* [`[7d64990a69]`](https://github.com/aspnet/AspNetCore/commit/7d64990a69) Ensure RazorPages in an area are not route-able through root based paths when root directory and area root directory overlap
* [`[64259fe51c]`](https://github.com/aspnet/AspNetCore/commit/64259fe51c) Add skips for dotnet/standard#567
* [`[f6c1d6483b]`](https://github.com/aspnet/AspNetCore/commit/f6c1d6483b) Update IIS Integration submodule
* [`[e13ceb690b]`](https://github.com/aspnet/AspNetCore/commit/e13ceb690b) Detect remote denails for Twitter accounts
* [`[51820e3e25]`](https://github.com/aspnet/AspNetCore/commit/51820e3e25) Use DebugType specified in DependencyContext to determine pdb type
* [`[186e5733c0]`](https://github.com/aspnet/AspNetCore/commit/186e5733c0) Add metadata to Razor (#1894)
* [`[404105bd19]`](https://github.com/aspnet/AspNetCore/commit/404105bd19) Add Identity.External claims sample
* [`[aad7a245a2]`](https://github.com/aspnet/AspNetCore/commit/aad7a245a2) Fix loglevel for invalid range headers
* [`[276c1e4360]`](https://github.com/aspnet/AspNetCore/commit/276c1e4360) Improve logging - output formatter selection
* [`[49bdcfb150]`](https://github.com/aspnet/AspNetCore/commit/49bdcfb150) Updated Razor Pages areas for compatibility switches
* [`[3ae601e4df]`](https://github.com/aspnet/AspNetCore/commit/3ae601e4df) Prevent type name collisions when file hierarchy + namespace is identical (#1881)
* [`[15d2f5a898]`](https://github.com/aspnet/AspNetCore/commit/15d2f5a898) Allow explicit configuration of StaticFileOptions in new SPA APIs. Fixes #1424.
* [`[814441c933]`](https://github.com/aspnet/AspNetCore/commit/814441c933) Allow configuration of SPA startup timeout. Part of #1447
* [`[b8424b0e8b]`](https://github.com/aspnet/AspNetCore/commit/b8424b0e8b) Add property to skip installing the aspnetcore shared framework
* [`[57c8b71b4d]`](https://github.com/aspnet/AspNetCore/commit/57c8b71b4d) [Fixes #6547] Re-introduce HttpMethodActionConstraint dictionary perf improvement
* [`[407f55841b]`](https://github.com/aspnet/AspNetCore/commit/407f55841b) Disables tests (#499)
* [`[52a06e93bc]`](https://github.com/aspnet/AspNetCore/commit/52a06e93bc) Added test for DefaultRazorSyntaxFactsService
* [`[28de4aea87]`](https://github.com/aspnet/AspNetCore/commit/28de4aea87) Makes ANCM an internal dependency (#735)
* [`[b70191fb82]`](https://github.com/aspnet/AspNetCore/commit/b70191fb82) Specify configuration for functional tests
* [`[84e7faf9be]`](https://github.com/aspnet/AspNetCore/commit/84e7faf9be) Updated logging in RangeHelper.cs
* [`[3f31706743]`](https://github.com/aspnet/AspNetCore/commit/3f31706743) Resolve internal package reference issue
* [`[d59b0ef38c]`](https://github.com/aspnet/AspNetCore/commit/d59b0ef38c) Adds universe manifest and signing info
* [`[03b092888e]`](https://github.com/aspnet/AspNetCore/commit/03b092888e) Add Microsoft.VisualStudio.ComponentGroup.NativeDesktop.Win81 to required workloads
* [`[3d17a40c0d]`](https://github.com/aspnet/AspNetCore/commit/3d17a40c0d) Removing other test projects
* [`[483a8c61a3]`](https://github.com/aspnet/AspNetCore/commit/483a8c61a3) Adds package native projects
* [`[82e32240a4]`](https://github.com/aspnet/AspNetCore/commit/82e32240a4) Update the Enum Invalid Value setting for compat
* [`[5325c65b88]`](https://github.com/aspnet/AspNetCore/commit/5325c65b88) Replace identity code with built-in version on the templates
* [`[514381f16f]`](https://github.com/aspnet/AspNetCore/commit/514381f16f) Add Razor.Design as a dependency of MVC
* [`[0344969e50]`](https://github.com/aspnet/AspNetCore/commit/0344969e50) Update Universe to ship global CLI tool packages (#733)
* [`[e348158499]`](https://github.com/aspnet/AspNetCore/commit/e348158499) Change site extension target to match CI folder layout
* [`[261b27b700]`](https://github.com/aspnet/AspNetCore/commit/261b27b700) Port CLI tools to be dotnet global tools
* [`[8c94d27d6a]`](https://github.com/aspnet/AspNetCore/commit/8c94d27d6a) [Fixes #181] Go back to server selected listening ports.
* [`[e849dc91fb]`](https://github.com/aspnet/AspNetCore/commit/e849dc91fb) Disable sign request generation and update AzureIntegration
* [`[886a985726]`](https://github.com/aspnet/AspNetCore/commit/886a985726) Target netcoreapp2.1
* [`[69f87610ce]`](https://github.com/aspnet/AspNetCore/commit/69f87610ce) Produce the Windows sharedfx as win-x64/x64 for consistency with Microsoft.NETCore.App (#731)
* [`[f8692d14e4]`](https://github.com/aspnet/AspNetCore/commit/f8692d14e4) Add logging to RangeHelper.cs
* [`[ee72ea73da]`](https://github.com/aspnet/AspNetCore/commit/ee72ea73da) Add exclusions for NPV for non-ASP.NET assemblies
* [`[948af4ce6f]`](https://github.com/aspnet/AspNetCore/commit/948af4ce6f) Add descriptions for Razor infrastructure
* [`[87db08e030]`](https://github.com/aspnet/AspNetCore/commit/87db08e030) Add missing baselines
* [`[747420e5aa]`](https://github.com/aspnet/AspNetCore/commit/747420e5aa) Compatibility switches (#7142)
* [`[b2e2719e43]`](https://github.com/aspnet/AspNetCore/commit/b2e2719e43) Make AspNetCoreSettings actually work
* [`[54c8bc82db]`](https://github.com/aspnet/AspNetCore/commit/54c8bc82db) Fix #1874 (#1879)
* [`[f8b4f4c620]`](https://github.com/aspnet/AspNetCore/commit/f8b4f4c620) Add consent to CookiePolicy #1561
* [`[50391c0341]`](https://github.com/aspnet/AspNetCore/commit/50391c0341) Ensure PackageVersion is set when computing sharedfx output path
* [`[ac702f6818]`](https://github.com/aspnet/AspNetCore/commit/ac702f6818) Add the cookie IsEssential flag and feature
* [`[44f1787cec]`](https://github.com/aspnet/AspNetCore/commit/44f1787cec)  Consolidate dotnet-hosting and aspnetcore-shared installers (#728)
* [`[c8e93a6108]`](https://github.com/aspnet/AspNetCore/commit/c8e93a6108) Use localhost dev cert in sample (#2235)
* [`[464e08b4f4]`](https://github.com/aspnet/AspNetCore/commit/464e08b4f4) Force http in tests
* [`[f08311f337]`](https://github.com/aspnet/AspNetCore/commit/f08311f337) Use new common benchmark config (#1251)
* [`[80af17fc4b]`](https://github.com/aspnet/AspNetCore/commit/80af17fc4b) Moved TagHelperParseTreeRewriter out of LegacyRazorDiagnostic
* [`[9aaaefbb1b]`](https://github.com/aspnet/AspNetCore/commit/9aaaefbb1b) Initialize RequestCookieCollection case insensitive (#981)
* [`[350c4ec4f6]`](https://github.com/aspnet/AspNetCore/commit/350c4ec4f6) Introduce IAlwaysRunResultFilter \ IAsyncAlwaysRunResultFilter (#7120)
* [`[36ff269fef]`](https://github.com/aspnet/AspNetCore/commit/36ff269fef) Use the Muxer path if available
* [`[e7cc0d33af]`](https://github.com/aspnet/AspNetCore/commit/e7cc0d33af) Use common BDN config (#2233)
* [`[63aceea121]`](https://github.com/aspnet/AspNetCore/commit/63aceea121) Change TagHelperBlockRewriter's error usage to use RazorDiagnosticFactory.
* [`[bd03c16ee7]`](https://github.com/aspnet/AspNetCore/commit/bd03c16ee7) Ensure test apps use the same SDK as Razor
* [`[14fc427068]`](https://github.com/aspnet/AspNetCore/commit/14fc427068) Make RazorCodeGen track file renames \ deletes
* [`[bc6c9baafa]`](https://github.com/aspnet/AspNetCore/commit/bc6c9baafa) Re-Add Microsoft.AspNetCore.Identity.UI
* [`[ca34ac2a35]`](https://github.com/aspnet/AspNetCore/commit/ca34ac2a35) Restore and pack in different steps
* [`[738617266e]`](https://github.com/aspnet/AspNetCore/commit/738617266e) Invoke Multiple Connections (#1242)
* [`[ef81eae0e2]`](https://github.com/aspnet/AspNetCore/commit/ef81eae0e2) Add Microsoft.AspNetCore.Identity.UI package
* [`[ee9b080875]`](https://github.com/aspnet/AspNetCore/commit/ee9b080875) Allow untrusted certs in tests
* [`[0125769f8a]`](https://github.com/aspnet/AspNetCore/commit/0125769f8a) Use SiteExtension.Sdk in Microsoft.AspNetCore.AzureAppServices.SiteExtension (#128)
* [`[dfaf37cbba]`](https://github.com/aspnet/AspNetCore/commit/dfaf37cbba) Implement config support #1290 #1879 #2016 #2166 #2167 #2188
* [`[db3c3ba589]`](https://github.com/aspnet/AspNetCore/commit/db3c3ba589) Ensure HeaderDictionary store is initialized consistently (#979)
* [`[455cf2e0c3]`](https://github.com/aspnet/AspNetCore/commit/455cf2e0c3) Add the Razor.Design dependency to MVC
* [`[1bd99f6b67]`](https://github.com/aspnet/AspNetCore/commit/1bd99f6b67) Initial typescript tidy up (#1239)
* [`[4b53f4bc53]`](https://github.com/aspnet/AspNetCore/commit/4b53f4bc53) Adds ANCM to IISIntegration (#492)
* [`[a020288200]`](https://github.com/aspnet/AspNetCore/commit/a020288200) Fix P2P references from extensions
* [`[82a68d73de]`](https://github.com/aspnet/AspNetCore/commit/82a68d73de) Include the VSIX and MPack files in the bill of materials
* [`[3c20e7c45b]`](https://github.com/aspnet/AspNetCore/commit/3c20e7c45b) Update the artifact type for the JSON manifest file
* [`[2f785cdd41]`](https://github.com/aspnet/AspNetCore/commit/2f785cdd41) Upgrade deps (#488)
* [`[2cf020103a]`](https://github.com/aspnet/AspNetCore/commit/2cf020103a) Update to new corefx packages (#486)
* [`[57fc6833fe]`](https://github.com/aspnet/AspNetCore/commit/57fc6833fe) Mark the SecretManager VSIX as IsProductComponent=true
* [`[294e6e8739]`](https://github.com/aspnet/AspNetCore/commit/294e6e8739) Avoid double-slashes when consuming dotnet-core assets from a custom blob store
* [`[2c27272e4d]`](https://github.com/aspnet/AspNetCore/commit/2c27272e4d) Adding a basic test for RazorGenerate
* [`[8570f1e0c0]`](https://github.com/aspnet/AspNetCore/commit/8570f1e0c0) Move site extensions out from src (#131)
* [`[fadeb7394a]`](https://github.com/aspnet/AspNetCore/commit/fadeb7394a) Add more bash magic to our script to avoid issues with unset and unbound variables
* [`[b3be0ebb91]`](https://github.com/aspnet/AspNetCore/commit/b3be0ebb91) Moved TokenizerBackerParser out of LegacyRazorDiagnostic
* [`[a609297ebb]`](https://github.com/aspnet/AspNetCore/commit/a609297ebb) Fix quote escaping issues in bash
* [`[ee8d0f30eb]`](https://github.com/aspnet/AspNetCore/commit/ee8d0f30eb) Add AzureIntegration.targets (#722)
* [`[38fa399c90]`](https://github.com/aspnet/AspNetCore/commit/38fa399c90) Add missing arguments to run.sh
* [`[7d4fb5dcab]`](https://github.com/aspnet/AspNetCore/commit/7d4fb5dcab) Moved HtmlMarkupParser out of LegacyRazorDiagnostic
* [`[0e20ea5178]`](https://github.com/aspnet/AspNetCore/commit/0e20ea5178) Include LineIndex and CharacterIndex when comparing SourceLocation
* [`[808f539297]`](https://github.com/aspnet/AspNetCore/commit/808f539297) Moved CSharpCodeParser out of LegacyRazorDiagnostic
* [`[926dae0d88]`](https://github.com/aspnet/AspNetCore/commit/926dae0d88) Move DefaultTagHelperTargetExtension errors to use RazorDiagnosticFactory.
* [`[dfa085afaf]`](https://github.com/aspnet/AspNetCore/commit/dfa085afaf) Add support for areas to Razor Pages
* [`[b900a82bc3]`](https://github.com/aspnet/AspNetCore/commit/b900a82bc3) Refocus Razor runtime assemblies
* [`[3bb71255d4]`](https://github.com/aspnet/AspNetCore/commit/3bb71255d4) clean up HttpConnectionTests (#1208)
* [`[00a6dc983a]`](https://github.com/aspnet/AspNetCore/commit/00a6dc983a) Fix #1170 by removing invocationId from non-blocking calls (#1218)
* [`[150bb3faf4]`](https://github.com/aspnet/AspNetCore/commit/150bb3faf4) Add BindingAddress to HttpAbstractions (#977)
* [`[c8bd72be36]`](https://github.com/aspnet/AspNetCore/commit/c8bd72be36) Others in Group (#1230)
* [`[d64005e205]`](https://github.com/aspnet/AspNetCore/commit/d64005e205) Add a list of important properties.
* [`[06c2cf31d4]`](https://github.com/aspnet/AspNetCore/commit/06c2cf31d4) Hardcode Debug in test
* [`[5425c69df6]`](https://github.com/aspnet/AspNetCore/commit/5425c69df6) Use path.combine instead
* [`[c8cabde1f1]`](https://github.com/aspnet/AspNetCore/commit/c8cabde1f1) Improve logging - individual filters
* [`[8490becc40]`](https://github.com/aspnet/AspNetCore/commit/8490becc40) Update pacakge dependencies  (#718)
* [`[aa4de988b0]`](https://github.com/aspnet/AspNetCore/commit/aa4de988b0) Use current Visual Studio image
* [`[18ce7f07ac]`](https://github.com/aspnet/AspNetCore/commit/18ce7f07ac) Moved CSharpTokenizer errors out of legacy diagnostic
* [`[463e11b739]`](https://github.com/aspnet/AspNetCore/commit/463e11b739) Make SyntaxTree mutations not leak.
* [`[05e1271b3c]`](https://github.com/aspnet/AspNetCore/commit/05e1271b3c) Goodbye Slim :(
* [`[d93a3c4a37]`](https://github.com/aspnet/AspNetCore/commit/d93a3c4a37) Add community projects section
* [`[1a842e92ec]`](https://github.com/aspnet/AspNetCore/commit/1a842e92ec) Fix dotnet myget npm registry link (#1223)
* [`[eb2668e74e]`](https://github.com/aspnet/AspNetCore/commit/eb2668e74e) AllExcept for Groups - GroupExcept (#1204)
* [`[8fcb046345]`](https://github.com/aspnet/AspNetCore/commit/8fcb046345) Moved the test infrastructure to depend on RazorDiagnostic instead of RazorError
* [`[d38e73c5d0]`](https://github.com/aspnet/AspNetCore/commit/d38e73c5d0) Update MonoDevelop.Sdk to 1.0.1
* [`[7234850c9a]`](https://github.com/aspnet/AspNetCore/commit/7234850c9a) Update MonoDevelop.Sdk to 1.0.1.
* [`[03878f671c]`](https://github.com/aspnet/AspNetCore/commit/03878f671c) Fix NERCorePlatforms package version
* [`[61e9e01574]`](https://github.com/aspnet/AspNetCore/commit/61e9e01574) Fix wrong package versions
* [`[9453dba8cb]`](https://github.com/aspnet/AspNetCore/commit/9453dba8cb) Update pacakge deps (#716)
* [`[2584f260ac]`](https://github.com/aspnet/AspNetCore/commit/2584f260ac) Add Microsoft.EntityFrameworkCore.Attributes [ci skip]
* [`[9f02935074]`](https://github.com/aspnet/AspNetCore/commit/9f02935074) Call Listen after Bind in tests (#2221)
* [`[085838e83a]`](https://github.com/aspnet/AspNetCore/commit/085838e83a) Make ErrorSink and Tokenizer depend on RazorDiagnostic instead of RazorError
* [`[6bbd063e26]`](https://github.com/aspnet/AspNetCore/commit/6bbd063e26) Use DefaultRazorDiagnostic in DefaultDirectiveSyntaxTreePass
* [`[d2c1138429]`](https://github.com/aspnet/AspNetCore/commit/d2c1138429) fix #1171 by teaching HttpConnection to be restartable in TypeScript (#1211)
* [`[4164821e4c]`](https://github.com/aspnet/AspNetCore/commit/4164821e4c) Add VS agnostic non-OOP DefaultTagHelperResolver.
* [`[4c4a7b3c6c]`](https://github.com/aspnet/AspNetCore/commit/4c4a7b3c6c) Improve logging - filter pipeline execution Related to issue #6498: When enabling "Trace" logging for MVC loggers, I should be buried in log messages
* [`[5d9f04cf34]`](https://github.com/aspnet/AspNetCore/commit/5d9f04cf34) Run `[RequireHttps]` filter early in pipeline
* [`[e7749b9ccc]`](https://github.com/aspnet/AspNetCore/commit/e7749b9ccc) return ReturnUrl when ExternalLogin fails (#186)
* [`[1aff9d0031]`](https://github.com/aspnet/AspNetCore/commit/1aff9d0031) Make RazorEditorFactoryService VS agnostic.
* [`[f7636fdfc0]`](https://github.com/aspnet/AspNetCore/commit/f7636fdfc0) Add TextBufferProjectService Mac implementation.
* [`[e73a289b3d]`](https://github.com/aspnet/AspNetCore/commit/e73a289b3d) Inclue RepositoryRoot
* [`[55dee97e99]`](https://github.com/aspnet/AspNetCore/commit/55dee97e99) Add Microsoft.AspNetCore.Razor.Design
* [`[6a10d620e4]`](https://github.com/aspnet/AspNetCore/commit/6a10d620e4) Updated the file content
* [`[eb74ea32f1]`](https://github.com/aspnet/AspNetCore/commit/eb74ea32f1) Add app.config to net 4.x templates (#191)
* [`[6eaf1219f6]`](https://github.com/aspnet/AspNetCore/commit/6eaf1219f6) Use nameof() when returning Views (#196)
* [`[804ab764c2]`](https://github.com/aspnet/AspNetCore/commit/804ab764c2) Re-enable the version consistency check
* [`[31ef3c49df]`](https://github.com/aspnet/AspNetCore/commit/31ef3c49df) Makes MapHub and MapEndpoint consistent with other ASP.NET Core APIs using PathString. #1188
* [`[1e1630068f]`](https://github.com/aspnet/AspNetCore/commit/1e1630068f) Make DefaultTagHelperResolver use the correct GetTagHelpersAsync.
* [`[7654f73c54]`](https://github.com/aspnet/AspNetCore/commit/7654f73c54) Assert foreground thread before dispatching events
* [`[2aaed28054]`](https://github.com/aspnet/AspNetCore/commit/2aaed28054) Rename dotnet-developercertificates to dotnet-dev-certs (#371)
* [`[b73c50be41]`](https://github.com/aspnet/AspNetCore/commit/b73c50be41) Add Mac implementation of FileChangeTracker.
* [`[0686383c90]`](https://github.com/aspnet/AspNetCore/commit/0686383c90) Add PathSchemeSelection sample
* [`[42943ce58c]`](https://github.com/aspnet/AspNetCore/commit/42943ce58c) Set DotNetAdditionalRestoreSources on all ExternalDependency items
* [`[1f3f010f87]`](https://github.com/aspnet/AspNetCore/commit/1f3f010f87) Upgrade CLI tools to .NET Core 2.1
* [`[b89a0655b6]`](https://github.com/aspnet/AspNetCore/commit/b89a0655b6) Add Microsoft.AspNetCore.Razor.Design
* [`[7e26af908e]`](https://github.com/aspnet/AspNetCore/commit/7e26af908e) [Fixes #6514] Add default ctor overload to AuthorizeFilter
* [`[821daa5ad0]`](https://github.com/aspnet/AspNetCore/commit/821daa5ad0) [Fixes #7085] ApplicationModelConventionExtensions should make a copy of collections when iterating them
* [`[358506f7bb]`](https://github.com/aspnet/AspNetCore/commit/358506f7bb) Changed the aspnet/Razor phare to be a link
* [`[13e4025dac]`](https://github.com/aspnet/AspNetCore/commit/13e4025dac) Using nameof() instead of hard-coded string. (#188)
* [`[588d9cdb11]`](https://github.com/aspnet/AspNetCore/commit/588d9cdb11) Use Utf8Parser instead of custom code (#1200)
* [`[26ea920fa6]`](https://github.com/aspnet/AspNetCore/commit/26ea920fa6) Set LoginProvider when ExternalLoginConfirmation fails (#187)
* [`[66ab939cff]`](https://github.com/aspnet/AspNetCore/commit/66ab939cff) Making HttpConnection restartable (C#) (#1147)
* [`[f2069e5ae5]`](https://github.com/aspnet/AspNetCore/commit/f2069e5ae5) Fixed the link to the replacement feature.
* [`[4f8db67cdd]`](https://github.com/aspnet/AspNetCore/commit/4f8db67cdd) Updated the readme.md file with obsolete details
* [`[f8a38b9d3d]`](https://github.com/aspnet/AspNetCore/commit/f8a38b9d3d) Update BenchmarkDotNet (#704)
* [`[8ded472fe9]`](https://github.com/aspnet/AspNetCore/commit/8ded472fe9) Add status code support to SpaPrerenderingExtensions
* [`[f208b27bd7]`](https://github.com/aspnet/AspNetCore/commit/f208b27bd7) Moved TextBufferProjectService from Mef to ILanguageService
* [`[75e102f97a]`](https://github.com/aspnet/AspNetCore/commit/75e102f97a) Support for Others and Caller Client Subsets(#1192)
* [`[6b8223b544]`](https://github.com/aspnet/AspNetCore/commit/6b8223b544) Moved RazorTextBufferProvider from Mef to ILanguageService
* [`[fb68a31ad5]`](https://github.com/aspnet/AspNetCore/commit/fb68a31ad5) Moved RazorCodeDocumentProvider from Mef to ILanguageService
* [`[2b54b2fc91]`](https://github.com/aspnet/AspNetCore/commit/2b54b2fc91) Upgrade deps (#2215)
* [`[14892d4fbc]`](https://github.com/aspnet/AspNetCore/commit/14892d4fbc) Created PULL_REQUEST_TEMPLATE.md
* [`[471bd8a170]`](https://github.com/aspnet/AspNetCore/commit/471bd8a170) Upgrade deps (#488)
* [`[c925897dde]`](https://github.com/aspnet/AspNetCore/commit/c925897dde) Create .github/ISSUE_TEMPLATE.md
* [`[c0b9ae5e55]`](https://github.com/aspnet/AspNetCore/commit/c0b9ae5e55) Update deps (#1201)
* [`[8a1c210c69]`](https://github.com/aspnet/AspNetCore/commit/8a1c210c69) Add Microsoft.AspNetCore.AzureKeyVault.HostingStartup (#697)
* [`[f4236a1dde]`](https://github.com/aspnet/AspNetCore/commit/f4236a1dde) Split KeyVault hosting startup into separate separate package (#126)
* [`[42050eed56]`](https://github.com/aspnet/AspNetCore/commit/42050eed56) Add Internal.AspNetCore.SiteExtension.Sdk external dependency (#701)
* [`[de47a6f50e]`](https://github.com/aspnet/AspNetCore/commit/de47a6f50e) Upgrade package references (#1195)
* [`[a1d91fcada]`](https://github.com/aspnet/AspNetCore/commit/a1d91fcada) Update to new corefx packages (#486)
* [`[ce07904b1a]`](https://github.com/aspnet/AspNetCore/commit/ce07904b1a) Upgrade corefx packages and shared runtime (#702)
* [`[65cdddf5d9]`](https://github.com/aspnet/AspNetCore/commit/65cdddf5d9) Make DefaultVisualStudioDocumentTrackerFactory VS agnostic.
* [`[37eed518f8]`](https://github.com/aspnet/AspNetCore/commit/37eed518f8) Make VisualStudioRazorParserFactory VisualStudio agnostic.
* [`[4d2e642b94]`](https://github.com/aspnet/AspNetCore/commit/4d2e642b94) Add launchSettings.json by default to our templates * Adds launchSettings.json to all of our templates. * Provides an alternative flag to exclude it. * Adds HTTPS support in launchSettings.json. * Re-adds HTTPS redirect and HSTS middleware for C# templates. * Improves some infrastructure aspects:     * Prefix all our test projects with AspNet.Template to allow easy       killing of orphaned processes.     * Setup an HTTPS certificate automatically for use with tests in the       same way our tooling does it on customers machines.     * Switch from OS selected ports to randomly selected ports. This is       required as we need to know the port to use for HTTPS.     * Allow disabling browser automation through an environment variable.     * Setup Firefox to allow untrusted certificates when using Selenium.     * Allow running Selenium tests on firefox by setting an environment       variable.
* [`[7246e58189]`](https://github.com/aspnet/AspNetCore/commit/7246e58189) Skip WebSockets on win7 and 2008 (#1194)
* [`[d1881c74c9]`](https://github.com/aspnet/AspNetCore/commit/d1881c74c9) Rename props to avoid reserved names
* [`[35d4ad0f30]`](https://github.com/aspnet/AspNetCore/commit/35d4ad0f30) Always produce shared framework zips
* [`[88e66f2b21]`](https://github.com/aspnet/AspNetCore/commit/88e66f2b21) Prepare the 2.0.5 patch and add task to ensure repo versions cascade
* [`[0ade3698b4]`](https://github.com/aspnet/AspNetCore/commit/0ade3698b4) Identify the difference between skipped and shipped repositories
* [`[7cea779b7a]`](https://github.com/aspnet/AspNetCore/commit/7cea779b7a) Update JsonHelper to escape HTML.
* [`[3bc3ca2a41]`](https://github.com/aspnet/AspNetCore/commit/3bc3ca2a41) Add 2.0.3 manifests to all metapackage
* [`[554c3310e3]`](https://github.com/aspnet/AspNetCore/commit/554c3310e3) Updates for 2.0.5 installers
* [`[f708c463d9]`](https://github.com/aspnet/AspNetCore/commit/f708c463d9) Export RazorDocumentManager using roslyn services
* [`[16c23b846e]`](https://github.com/aspnet/AspNetCore/commit/16c23b846e) Split showing and generating recovery codes
* [`[e4ecd070eb]`](https://github.com/aspnet/AspNetCore/commit/e4ecd070eb) Use AuthenticatorUrl generated on the server in EnableAuthenticator pages * Update prerelease package versions * Install the right CLI version
* [`[bc95a4a6c1]`](https://github.com/aspnet/AspNetCore/commit/bc95a4a6c1) Add missing @ (#184)
* [`[a8330067c4]`](https://github.com/aspnet/AspNetCore/commit/a8330067c4) Implement #1157 by adding client timeout for C# client (#1165)
* [`[ed9e34caab]`](https://github.com/aspnet/AspNetCore/commit/ed9e34caab) Set ErrorViewModel in ConfirmEmail (#180)
* [`[88e05f71a5]`](https://github.com/aspnet/AspNetCore/commit/88e05f71a5) Add no-cache header to error pages (#182)
* [`[fabe0fbe3c]`](https://github.com/aspnet/AspNetCore/commit/fabe0fbe3c) Catch any error in UpdateRepos
* [`[911264eb04]`](https://github.com/aspnet/AspNetCore/commit/911264eb04) Clean up shared framework generation.
* [`[7cd1b6a5d0]`](https://github.com/aspnet/AspNetCore/commit/7cd1b6a5d0) Make BraceSmartIndenterFactory VisualStudio agnostic.
* [`[d5bb73a98c]`](https://github.com/aspnet/AspNetCore/commit/d5bb73a98c) [Fixes #6197] AddXmlSerializerFormatters with no namespace
* [`[b07d405cc2]`](https://github.com/aspnet/AspNetCore/commit/b07d405cc2) Update the templating submodule
* [`[05d02e7cab]`](https://github.com/aspnet/AspNetCore/commit/05d02e7cab) [Fixes #6533] Log when XML formatters fail to create a serializer
* [`[ba496bf1af]`](https://github.com/aspnet/AspNetCore/commit/ba496bf1af) Add a way for tooling to determine if a span corresponds to a TagHelper.
* [`[db38da7edb]`](https://github.com/aspnet/AspNetCore/commit/db38da7edb) Fix Xml formatters to taking in MvcOptions to take affect of options mutation Related to issue [Fixes #6858] Changes to MvcOption's settings (SuppressInputFormatterBuffering & AllowBindingUndefinedValueToEnumType) are not taking affect
* [`[c94685e470]`](https://github.com/aspnet/AspNetCore/commit/c94685e470) Use aspnetcore-dev
* [`[835325f5ee]`](https://github.com/aspnet/AspNetCore/commit/835325f5ee) Clean up Universe
* [`[15c3bca8e6]`](https://github.com/aspnet/AspNetCore/commit/15c3bca8e6) Change log names in testing and assembly logs are from (#1182)
* [`[6e152e24e1]`](https://github.com/aspnet/AspNetCore/commit/6e152e24e1) forgot a copyright header (#1183)
* [`[9f1e6607dd]`](https://github.com/aspnet/AspNetCore/commit/9f1e6607dd) Changes OS bitness check to Environment rather than System.Runtime.InteropServices.RuntimeInformation (#1286)
* [`[6be80e7bed]`](https://github.com/aspnet/AspNetCore/commit/6be80e7bed) Use windows VS error reporter instead of the no-op default
* [`[f5dcdfd8de]`](https://github.com/aspnet/AspNetCore/commit/f5dcdfd8de) Encode ForgotPassword email link (#179)
* [`[e0daa126e2]`](https://github.com/aspnet/AspNetCore/commit/e0daa126e2) Produce aspnetcore shared framework
* [`[7ec0e9fb23]`](https://github.com/aspnet/AspNetCore/commit/7ec0e9fb23) Make GenerateMPack target more resilient.
* [`[a0f4101453]`](https://github.com/aspnet/AspNetCore/commit/a0f4101453) Add Mac implementation of ErrorReporter.
* [`[f4bb309994]`](https://github.com/aspnet/AspNetCore/commit/f4bb309994) Implement #1162 by adding client timeout for JavaScript (#1163)
* [`[ae9c3cf04d]`](https://github.com/aspnet/AspNetCore/commit/ae9c3cf04d) expand ping test expectations to avoid flakiness (#1181)
* [`[bc8b2c86fd]`](https://github.com/aspnet/AspNetCore/commit/bc8b2c86fd) Add Mac implementation of VisualStudioForegroundDispatcher.
* [`[e6a2f6811c]`](https://github.com/aspnet/AspNetCore/commit/e6a2f6811c) LinepuePackageRestoreSource to aspnetcore-dev
* [`[f67670927f]`](https://github.com/aspnet/AspNetCore/commit/f67670927f) Add Mac implementation of VisualStudioWorkspaceAccessor.
* [`[6ca98f4dc9]`](https://github.com/aspnet/AspNetCore/commit/6ca98f4dc9) Removing some unreferenced external dependencies (#691)
* [`[74512dc3b2]`](https://github.com/aspnet/AspNetCore/commit/74512dc3b2) Change HMR install to devDependencies
* [`[cd1d57f97b]`](https://github.com/aspnet/AspNetCore/commit/cd1d57f97b) Add MonoDevelop.Core and MonoDevelop.Ide addin dependencies.
* [`[8ebcde0463]`](https://github.com/aspnet/AspNetCore/commit/8ebcde0463) Add MonoDevelop.Sdk package to the mirror.
* [`[668f8e3b4b]`](https://github.com/aspnet/AspNetCore/commit/668f8e3b4b) Lazily allocate protocol-specific connection objects (#2190)
* [`[e09ea40551]`](https://github.com/aspnet/AspNetCore/commit/e09ea40551) [Fixes #6591] TempData should support nullable types
* [`[d87770a56c]`](https://github.com/aspnet/AspNetCore/commit/d87770a56c) Use aspnetcore-dev
* [`[c1d2024864]`](https://github.com/aspnet/AspNetCore/commit/c1d2024864) Implement #1156 by having the server send Ping messages (#1161)
* [`[629f87181a]`](https://github.com/aspnet/AspNetCore/commit/629f87181a) [Fixes #6858] Changes to MvcOption's settings (SuppressInputFormatterBuffering & AllowBindingUndefinedValueToEnumType) are not taking affect
* [`[269cff5bf5]`](https://github.com/aspnet/AspNetCore/commit/269cff5bf5) Change parameter name to htmlMessage (#178)
* [`[78c8bdbbef]`](https://github.com/aspnet/AspNetCore/commit/78c8bdbbef) Exclude Microsoft.AspNetCore.Runtime.SiteExtension from pack (#125)
* [`[7c9a985382]`](https://github.com/aspnet/AspNetCore/commit/7c9a985382) Also use DotNetAdditionalRestoreSources when restoring external dependencies
* [`[3cf18e3e19]`](https://github.com/aspnet/AspNetCore/commit/3cf18e3e19) Also use DotNetAdditionalRestoreSources when restoring external dependencies
* [`[b8a1c04ffb]`](https://github.com/aspnet/AspNetCore/commit/b8a1c04ffb) Make the HttpParser a singleton  (#2203)
* [`[e4671392ec]`](https://github.com/aspnet/AspNetCore/commit/e4671392ec) Fix #1140 by plumbing WebSocketOptions up to HttpOptions (#1174)
* [`[8abbaa46cc]`](https://github.com/aspnet/AspNetCore/commit/8abbaa46cc) Added imports tracking to TagHelper project system - #1744
* [`[3a76af803a]`](https://github.com/aspnet/AspNetCore/commit/3a76af803a) Rename the parameter used to specify additional sources to avoid conflating with DotNetRestoreSources used in projects
* [`[400ef9e3b1]`](https://github.com/aspnet/AspNetCore/commit/400ef9e3b1) Update ANCM version
* [`[0bb3f18049]`](https://github.com/aspnet/AspNetCore/commit/0bb3f18049) Add support for BadRequest in RazorPages (#7097)
* [`[3005337a9c]`](https://github.com/aspnet/AspNetCore/commit/3005337a9c) fix #625 by implementing HubMethodNameAttribute (#1173)
* [`[c07d699f0f]`](https://github.com/aspnet/AspNetCore/commit/c07d699f0f) Add AspNetCore runtime site extension (#118)
* [`[1cfc3d715c]`](https://github.com/aspnet/AspNetCore/commit/1cfc3d715c) Add Microsoft.Extensions.ApplicationModelDetection (#645)
* [`[6b2a702ff4]`](https://github.com/aspnet/AspNetCore/commit/6b2a702ff4) Handle line ending differences in a few tests - #6205 - combine `TagHelpers_SupportsPathNavigation()` and `TagHelpers_SupportsRelativeNavigation()` into one
* [`[7c2c5f2bef]`](https://github.com/aspnet/AspNetCore/commit/7c2c5f2bef) EnableApiCheck for Kestrel.Https (#2198)
* [`[e6c716444d]`](https://github.com/aspnet/AspNetCore/commit/e6c716444d) Add a <partial /> tag helper
* [`[f121d9c688]`](https://github.com/aspnet/AspNetCore/commit/f121d9c688) Split out version specification from ExternalDependency initialization
* [`[5819301f7e]`](https://github.com/aspnet/AspNetCore/commit/5819301f7e) Change Web API to API (#169)
* [`[db511a036d]`](https://github.com/aspnet/AspNetCore/commit/db511a036d) Update produced packages to 2.1.0-preview-* (#1172)
* [`[1db6eb0823]`](https://github.com/aspnet/AspNetCore/commit/1db6eb0823) Add support for automatically installing new versions of the 2.1 runtime (#676)
* [`[db6c04818e]`](https://github.com/aspnet/AspNetCore/commit/db6c04818e) Add application model detection package  (#119)
* [`[f7c3546b98]`](https://github.com/aspnet/AspNetCore/commit/f7c3546b98) LZMA update for 2.0.4
* [`[940c71eaf8]`](https://github.com/aspnet/AspNetCore/commit/940c71eaf8) Correct spelling in summary (#975)
* [`[740b81e989]`](https://github.com/aspnet/AspNetCore/commit/740b81e989) Update ANCM Version (#682)
* [`[2e14ec8f9b]`](https://github.com/aspnet/AspNetCore/commit/2e14ec8f9b) Update AspNetCoreModuleX64Location and X86.  (#264)
* [`[6414cf0f23]`](https://github.com/aspnet/AspNetCore/commit/6414cf0f23) Use sources.props
* [`[8d7e9b737a]`](https://github.com/aspnet/AspNetCore/commit/8d7e9b737a) Update Internal.AspNetCore.Sdk
* [`[5e9e3a8574]`](https://github.com/aspnet/AspNetCore/commit/5e9e3a8574) Make sure to add whitespace after the status code even if the reasonphrase is empty (#2184)
* [`[e81746c3b6]`](https://github.com/aspnet/AspNetCore/commit/e81746c3b6) Reference Task.Extensions directly
* [`[1219e97e27]`](https://github.com/aspnet/AspNetCore/commit/1219e97e27) Avoid LOH
* [`[531c7cfba1]`](https://github.com/aspnet/AspNetCore/commit/531c7cfba1) More micro benchmarks (#1158)
* [`[33dfcf9759]`](https://github.com/aspnet/AspNetCore/commit/33dfcf9759) Add more VS packages to the mirror
* [`[12e6e99d92]`](https://github.com/aspnet/AspNetCore/commit/12e6e99d92) Add support for restore sources and package version props url
* [`[98de3aa50d]`](https://github.com/aspnet/AspNetCore/commit/98de3aa50d) Suppress API check due to reflection load errors (#2185)
* [`[5274867cb7]`](https://github.com/aspnet/AspNetCore/commit/5274867cb7) Update VS editor package versions.
* [`[182714c324]`](https://github.com/aspnet/AspNetCore/commit/182714c324) Move away from WPF text view connection listener.
* [`[df1d0bbcd4]`](https://github.com/aspnet/AspNetCore/commit/df1d0bbcd4) Change text buffer code document provider to follow our public API MEF rules.
* [`[345eb29c62]`](https://github.com/aspnet/AspNetCore/commit/345eb29c62) Update code doc provider to only rely on VSRazorParser.
* [`[ce68427050]`](https://github.com/aspnet/AspNetCore/commit/ce68427050) Use ALPN support in SSLStream on .NET Core >= 2.1 (#2179)
* [`[9e82629c1f]`](https://github.com/aspnet/AspNetCore/commit/9e82629c1f) Add AureliaPlugin to the vendor bundle
* [`[3a4c81dcc9]`](https://github.com/aspnet/AspNetCore/commit/3a4c81dcc9) Change order of UseBrowserLink method invocation
* [`[af23185c06]`](https://github.com/aspnet/AspNetCore/commit/af23185c06) Change order of UseBrowserLink method invocation
* [`[a68c7241b5]`](https://github.com/aspnet/AspNetCore/commit/a68c7241b5) Invoke a simpler UseMvc overload in Razor Pages templates
* [`[529ef02290]`](https://github.com/aspnet/AspNetCore/commit/529ef02290) Invoke a simpler UseMvc overload in Razor Pages templates
* [`[5d7e31d16f]`](https://github.com/aspnet/AspNetCore/commit/5d7e31d16f) Minor simplifications to Vue fetchdata logic
* [`[5e752169d6]`](https://github.com/aspnet/AspNetCore/commit/5e752169d6) Vue.js template: Use async/await
* [`[02bbcb68f1]`](https://github.com/aspnet/AspNetCore/commit/02bbcb68f1) fixed docs on SocketNodeInstance
* [`[40603f1566]`](https://github.com/aspnet/AspNetCore/commit/40603f1566) In Angular template, make nav button collapsing work (without importing all bootstrap.js scripts)
* [`[98f29207a2]`](https://github.com/aspnet/AspNetCore/commit/98f29207a2) Support running "dotnet restore" directly in template source folders
* [`[c517ad3f65]`](https://github.com/aspnet/AspNetCore/commit/c517ad3f65) For Angular template, update to @angular/cli 1.5.4 equivalent output
* [`[887e22ec07]`](https://github.com/aspnet/AspNetCore/commit/887e22ec07) Eclipse S.T.Tasks.Extension version referenced by S.T.Channels
* [`[76de77746d]`](https://github.com/aspnet/AspNetCore/commit/76de77746d) Eclipse CoreFx package versions to prevent package downgrade warnings
* [`[076e5fe6af]`](https://github.com/aspnet/AspNetCore/commit/076e5fe6af) Fixup name of SystemServiceProcessServiceControllerPackageVersion
* [`[e539a4421a]`](https://github.com/aspnet/AspNetCore/commit/e539a4421a) Replace hardcoded string with constant
* [`[0a76ad7017]`](https://github.com/aspnet/AspNetCore/commit/0a76ad7017) Added TagHelper discovery to Razor project systen
* [`[90120f6a3b]`](https://github.com/aspnet/AspNetCore/commit/90120f6a3b) Added necessary infrastructure for Tag helper project system imports tracking
* [`[4b48a46521]`](https://github.com/aspnet/AspNetCore/commit/4b48a46521) Fix property name in PackageArchive targets
* [`[711a618310]`](https://github.com/aspnet/AspNetCore/commit/711a618310) Adds test for proposal in #7014
* [`[3a132e4af5]`](https://github.com/aspnet/AspNetCore/commit/3a132e4af5) Open up private methods in ValidationVisitor - Allows for other validation libraries to customize validation behaviour
* [`[959e7027b0]`](https://github.com/aspnet/AspNetCore/commit/959e7027b0) Add ValidateComplexTypesIfChildValidationFails to ValidationVisitor - Allows more granular control of when model-level validation should run.
* [`[dfd15c8679]`](https://github.com/aspnet/AspNetCore/commit/dfd15c8679) Only produce one version of the runtime store, templates packages, and installers (#665)
* [`[4394b57143]`](https://github.com/aspnet/AspNetCore/commit/4394b57143) JWT C# Sample
* [`[a4dd0cd9d7]`](https://github.com/aspnet/AspNetCore/commit/a4dd0cd9d7) JWT JS Sample
* [`[18a65496b7]`](https://github.com/aspnet/AspNetCore/commit/18a65496b7) Adding support for JWT in the TS client
* [`[0bafb304c2]`](https://github.com/aspnet/AspNetCore/commit/0bafb304c2) Adding support for JWT in the C# client
* [`[5841ab1065]`](https://github.com/aspnet/AspNetCore/commit/5841ab1065) Set minimum VS version to 15.0.26730.03
* [`[ee5535203e]`](https://github.com/aspnet/AspNetCore/commit/ee5535203e) Fixed rfc3339 formats to work with all localizations (#7066)
* [`[54e96bd404]`](https://github.com/aspnet/AspNetCore/commit/54e96bd404) Tolerate leading "~/" or "/" (#499)
* [`[4ecabacc76]`](https://github.com/aspnet/AspNetCore/commit/4ecabacc76) Create an initial implementation of the secret manager for VS (#355)
* [`[fadd6f89fd]`](https://github.com/aspnet/AspNetCore/commit/fadd6f89fd) Start Redis first in tests (#1146)
* [`[6277bf8b3a]`](https://github.com/aspnet/AspNetCore/commit/6277bf8b3a) Add more external dependencies to dependencies.props
* [`[aff78a04af]`](https://github.com/aspnet/AspNetCore/commit/aff78a04af) Update property name to match naming scheme
* [`[e03c6a7908]`](https://github.com/aspnet/AspNetCore/commit/e03c6a7908) Cross-compile Windows Services hosting package
* [`[afd80750e3]`](https://github.com/aspnet/AspNetCore/commit/afd80750e3) Update ServiceController version for netstandard support
* [`[76cb441a8e]`](https://github.com/aspnet/AspNetCore/commit/76cb441a8e) On test completion, kill the ASP.NET process tree (otherwise orphan processes are left behind)
* [`[1b0258ab8f]`](https://github.com/aspnet/AspNetCore/commit/1b0258ab8f) Move AddEntryToTree to shared source (#496)
* [`[19e943e6b9]`](https://github.com/aspnet/AspNetCore/commit/19e943e6b9) Update base key
* [`[a1d75df47d]`](https://github.com/aspnet/AspNetCore/commit/a1d75df47d) Use new Memory<byte> APIs on SocketAsyncEventArgs (#2173)
* [`[9dc9381ae4]`](https://github.com/aspnet/AspNetCore/commit/9dc9381ae4) Re-order execution in CacheTagHelper to avoid setting the result too early
* [`[21b15803ae]`](https://github.com/aspnet/AspNetCore/commit/21b15803ae) In tests, restore NPM dependencies using yarn if installed
* [`[62a8eafe51]`](https://github.com/aspnet/AspNetCore/commit/62a8eafe51) Distribute SPA templates over multiple test classes so they can run in parallel
* [`[7961894771]`](https://github.com/aspnet/AspNetCore/commit/7961894771) Re-enable test parallelization. Fixes #63.
* [`[4af7a47aac]`](https://github.com/aspnet/AspNetCore/commit/4af7a47aac) Change code document provider to work in old Razor.
* [`[1247466f5e]`](https://github.com/aspnet/AspNetCore/commit/1247466f5e) Upgrade dependencies
* [`[93cbf4dbef]`](https://github.com/aspnet/AspNetCore/commit/93cbf4dbef) Change negotiate to POST (#1122)
* [`[046553cfe4]`](https://github.com/aspnet/AspNetCore/commit/046553cfe4) Avoiding serializing to MemoryStream
* [`[67fc879c54]`](https://github.com/aspnet/AspNetCore/commit/67fc879c54) Null out send buffer less (#2164)
* [`[2dc3e36421]`](https://github.com/aspnet/AspNetCore/commit/2dc3e36421) Fix F# Program.fs
* [`[75274c76d5]`](https://github.com/aspnet/AspNetCore/commit/75274c76d5) Give redis docker image time to download (#1131)
* [`[2623b50695]`](https://github.com/aspnet/AspNetCore/commit/2623b50695) Update info on SPA template home components
* [`[9b1509a52b]`](https://github.com/aspnet/AspNetCore/commit/9b1509a52b) Handle @angular/cli not accept requests immediately on startup
* [`[a76a891865]`](https://github.com/aspnet/AspNetCore/commit/a76a891865) Workarounds to make SPA template tests work
* [`[849a0843c9]`](https://github.com/aspnet/AspNetCore/commit/849a0843c9) Fixes for constructing IWebDriver
* [`[f028839b5d]`](https://github.com/aspnet/AspNetCore/commit/f028839b5d) Workaround for publishing issue
* [`[2dda2dd99d]`](https://github.com/aspnet/AspNetCore/commit/2dda2dd99d) Stop tests from hanging if the ASP.NET process fails to exit
* [`[b01f1a9f6a]`](https://github.com/aspnet/AspNetCore/commit/b01f1a9f6a) Add support for looking up AspNetCoreSettings.props file beyond repo root
* [`[4f7aab7720]`](https://github.com/aspnet/AspNetCore/commit/4f7aab7720) Prevent Razor Core from running in non-core scenarios.
* [`[89d1862f21]`](https://github.com/aspnet/AspNetCore/commit/89d1862f21)  #2139 Add ListenLocalhost and ListenAnyIP
* [`[5fffd464cd]`](https://github.com/aspnet/AspNetCore/commit/5fffd464cd) Support input type "week" (#7045)
* [`[85ea220c4e]`](https://github.com/aspnet/AspNetCore/commit/85ea220c4e) Fixes dotnet.exe string as runtime now reads it (#246)
* [`[a6458bb149]`](https://github.com/aspnet/AspNetCore/commit/a6458bb149) Updating IdentityModel to preview2 (#652)
* [`[30acb48dfc]`](https://github.com/aspnet/AspNetCore/commit/30acb48dfc) Add blank lines
* [`[cb3124be17]`](https://github.com/aspnet/AspNetCore/commit/cb3124be17) First pass at Keep Alive (#1119)
* [`[379160707f]`](https://github.com/aspnet/AspNetCore/commit/379160707f) Switching to new base64 APIs (#1127)
* [`[476333771c]`](https://github.com/aspnet/AspNetCore/commit/476333771c) #955 Print available scheme names in exception message for invalid scheme (#961)
* [`[5bd38028f4]`](https://github.com/aspnet/AspNetCore/commit/5bd38028f4) Upgrade dependencies.props
* [`[1d9585b69d]`](https://github.com/aspnet/AspNetCore/commit/1d9585b69d) Replace Angular, React, ReactRedux templates with new CLI based ones
* [`[68c4620a55]`](https://github.com/aspnet/AspNetCore/commit/68c4620a55) Consider React dev server ready when it starts listening, not when (and if) it compiles successfully
* [`[296435e40c]`](https://github.com/aspnet/AspNetCore/commit/296435e40c) When capturing prerendering template, avoid problems with HTTP compression
* [`[e279bcdcb4]`](https://github.com/aspnet/AspNetCore/commit/e279bcdcb4) Put Microsoft.AspNetCore.Mvc.Testing in the shipping category
* [`[8fc5804903]`](https://github.com/aspnet/AspNetCore/commit/8fc5804903) Added Microsoft.AspNetCore.DeveloperCertificates.XPlat package
* [`[6c4427cde5]`](https://github.com/aspnet/AspNetCore/commit/6c4427cde5) Added a package for generating HTTPS Certificates on CLI first run scenarios
* [`[65906d3610]`](https://github.com/aspnet/AspNetCore/commit/65906d3610) Unify git submodules to point to the 'release/2.0.0' branch (#649)
* [`[9a2e3ceab6]`](https://github.com/aspnet/AspNetCore/commit/9a2e3ceab6) Added public api changes for TagHelper project system
* [`[945710907b]`](https://github.com/aspnet/AspNetCore/commit/945710907b) Fixing js end-to-end test after introducing streaminvocation (#1120)
* [`[848e3c5cda]`](https://github.com/aspnet/AspNetCore/commit/848e3c5cda) Fix parsing error on raw urls without path. (#406)
* [`[3a8f512fa7]`](https://github.com/aspnet/AspNetCore/commit/3a8f512fa7) Couple more reaction changes for Hosting (#1126)
* [`[6cf78ceb1b]`](https://github.com/aspnet/AspNetCore/commit/6cf78ceb1b) Move TagHelperCompletionService to VS.Editor.Razor and export it.
* [`[458111ad03]`](https://github.com/aspnet/AspNetCore/commit/458111ad03) Move TagHelperFactsService and export it.
* [`[5b6db93383]`](https://github.com/aspnet/AspNetCore/commit/5b6db93383) fixed minor copy and paste error in mockconnection handler (#2163)
* [`[e2bcefc3d0]`](https://github.com/aspnet/AspNetCore/commit/e2bcefc3d0) Move TreeEnumerator to shared source (#494)
* [`[49537878d3]`](https://github.com/aspnet/AspNetCore/commit/49537878d3) Account for other TFMs
* [`[0b8b099e82]`](https://github.com/aspnet/AspNetCore/commit/0b8b099e82) Adds contentRoot to ANCM path (#1272)
* [`[520876e55d]`](https://github.com/aspnet/AspNetCore/commit/520876e55d) Re-add some Legacy ITagHelperResolver infrastructure.
* [`[8f6f79bc47]`](https://github.com/aspnet/AspNetCore/commit/8f6f79bc47) Add script to list repo versions
* [`[44e5874029]`](https://github.com/aspnet/AspNetCore/commit/44e5874029) Move RazorSyntaxFactsService to VS.Editor.Razor and export it.
* [`[de23788019]`](https://github.com/aspnet/AspNetCore/commit/de23788019) Move indentation service to VS.Editor.Razor and export it.
* [`[44a47182b2]`](https://github.com/aspnet/AspNetCore/commit/44a47182b2) Add EditorSettingsManager as an exported MEF component.
* [`[d7785d6187]`](https://github.com/aspnet/AspNetCore/commit/d7785d6187) Add tag repos script
* [`[afb36d9667]`](https://github.com/aspnet/AspNetCore/commit/afb36d9667) Files put in contentFiles are not actually in contentFiles (#1269)
* [`[7235918051]`](https://github.com/aspnet/AspNetCore/commit/7235918051) Update templating to latest commit
* [`[726da0f11f]`](https://github.com/aspnet/AspNetCore/commit/726da0f11f) Fix HttpsPolicy dependency for full framework (#151)
* [`[f27a5a674e]`](https://github.com/aspnet/AspNetCore/commit/f27a5a674e) Updates ANCM path to look in content files (#1268)
* [`[bcd433e6d4]`](https://github.com/aspnet/AspNetCore/commit/bcd433e6d4) Updates ANCM to latest version (#648)
* [`[cfd974337d]`](https://github.com/aspnet/AspNetCore/commit/cfd974337d) Improved request error handling.
* [`[18f308fb05]`](https://github.com/aspnet/AspNetCore/commit/18f308fb05) Updating spec with StreamInvocation, removing StreamCompletion
* [`[ff43390ed2]`](https://github.com/aspnet/AspNetCore/commit/ff43390ed2) [Redis] Add functional test support (#1051)
* [`[cd3f58bed7]`](https://github.com/aspnet/AspNetCore/commit/cd3f58bed7) #1263 Delay IServer and Startup.Configure until StartAsync
* [`[9789e09cfb]`](https://github.com/aspnet/AspNetCore/commit/9789e09cfb) Adding EventSource/EventCounters to Sockets (#1083)
* [`[eb966ab7b1]`](https://github.com/aspnet/AspNetCore/commit/eb966ab7b1) Updating package versions
* [`[065e9bb57a]`](https://github.com/aspnet/AspNetCore/commit/065e9bb57a) Update "temporary" OpenSSL wrapper to support 1.1, and add HTTP/2 sample with docker (#2149)
* [`[c12c938d4a]`](https://github.com/aspnet/AspNetCore/commit/c12c938d4a) Copy aspnetcore.dll to contentfiles and re-add old nuget locations. (#245)
* [`[b8c3d26975]`](https://github.com/aspnet/AspNetCore/commit/b8c3d26975) Migrate to new pipe APIs (#454)
* [`[73a37363e1]`](https://github.com/aspnet/AspNetCore/commit/73a37363e1) Migrate to new pipe APIs  (#2124)
* [`[8f9ea25c63]`](https://github.com/aspnet/AspNetCore/commit/8f9ea25c63) Add Microsoft.AspNetCore.Routing.UrlMatchingTree.Sources package
* [`[2d1aaeb036]`](https://github.com/aspnet/AspNetCore/commit/2d1aaeb036) Set log level. (#829)
* [`[b7dc2757c7]`](https://github.com/aspnet/AspNetCore/commit/b7dc2757c7) More runtime setup packages to mirror
* [`[fac246e67c]`](https://github.com/aspnet/AspNetCore/commit/fac246e67c) Add support for PB_SkipTests and PB_SignType variables (#646)
* [`[6294d38805]`](https://github.com/aspnet/AspNetCore/commit/6294d38805) Disabling tests while investigating file location issues (#831)
* [`[c14ef1a7a6]`](https://github.com/aspnet/AspNetCore/commit/c14ef1a7a6) Disabling tests until file path issues are resolved. (#97)
* [`[7f8ba171f4]`](https://github.com/aspnet/AspNetCore/commit/7f8ba171f4) Move UrlMatchingTree to shared source (#492)
* [`[f21d107766]`](https://github.com/aspnet/AspNetCore/commit/f21d107766) Use different ports in ServerFixture for testing (#1112)
* [`[ff12b9b20c]`](https://github.com/aspnet/AspNetCore/commit/ff12b9b20c) Replacing StreamCompletion with StreamInvocation
* [`[eac0e2d03b]`](https://github.com/aspnet/AspNetCore/commit/eac0e2d03b) Add support for detecting when the user cancels the trust prompt and a mode to check for the validity and trust of existing certificates
* [`[aeabbdcada]`](https://github.com/aspnet/AspNetCore/commit/aeabbdcada) Stop create-react-app from opening an extra browser tab (pointed to the wrong port)
* [`[96d7f85327]`](https://github.com/aspnet/AspNetCore/commit/96d7f85327) Add UseReactDevelopmentServer() middleware. Factor out common code.
* [`[30333e250a]`](https://github.com/aspnet/AspNetCore/commit/30333e250a) AddSpaStaticFiles/UseSpaStaticFiles APIs to clean up the React template (or other cases where SPA files are outside wwwroot)
* [`[82e096c9a5]`](https://github.com/aspnet/AspNetCore/commit/82e096c9a5) Adds windows auth support (#241)
* [`[552163ab77]`](https://github.com/aspnet/AspNetCore/commit/552163ab77) Adds windows Auth support (#471)
* [`[02850d48dd]`](https://github.com/aspnet/AspNetCore/commit/02850d48dd) Add a missing tick to README.md
* [`[2ef19ab810]`](https://github.com/aspnet/AspNetCore/commit/2ef19ab810) More packages to restore
* [`[b0740dcb2b]`](https://github.com/aspnet/AspNetCore/commit/b0740dcb2b) Add more packages required by the 2.1 runtime
* [`[a24bed01d7]`](https://github.com/aspnet/AspNetCore/commit/a24bed01d7) Identify the difference between skipped and shipped repositories
* [`[3c727be270]`](https://github.com/aspnet/AspNetCore/commit/3c727be270) Fix path check for ANCM (#1262)
* [`[40bd6e560e]`](https://github.com/aspnet/AspNetCore/commit/40bd6e560e) Adds HostingModel as an extra DeploymentParameter (#1261)
* [`[9ab00e0e0f]`](https://github.com/aspnet/AspNetCore/commit/9ab00e0e0f) Also add NS.Library 2.0.1
* [`[a828818ca8]`](https://github.com/aspnet/AspNetCore/commit/a828818ca8) Mirror packages required to target netcoreapp2.1
* [`[a78b9c7490]`](https://github.com/aspnet/AspNetCore/commit/a78b9c7490) Support the Extensions.Abstractions from Hosting.Abstractions (#1259)
* [`[1a21fd49b1]`](https://github.com/aspnet/AspNetCore/commit/1a21fd49b1) Changing the Closed Event to be a Task (#1080)
* [`[0051c81c96]`](https://github.com/aspnet/AspNetCore/commit/0051c81c96) Upgrade dependencies
* [`[08002e961b]`](https://github.com/aspnet/AspNetCore/commit/08002e961b) In WebpackDevMiddleware.ts, support loading Webpack config files with __esModule. Fixes #1378
* [`[53b4697269]`](https://github.com/aspnet/AspNetCore/commit/53b4697269) Show cause of connection failure in test (#2155)
* [`[c61e9b3e84]`](https://github.com/aspnet/AspNetCore/commit/c61e9b3e84) Preparing to update to 2.2 SDK
* [`[a01e23250f]`](https://github.com/aspnet/AspNetCore/commit/a01e23250f) Preparing to update to 2.2 SDK
* [`[39fbf4d139]`](https://github.com/aspnet/AspNetCore/commit/39fbf4d139) Add Microsoft.DotNet.PlatformAbstractions to the list of external dependencies
* [`[cf84583492]`](https://github.com/aspnet/AspNetCore/commit/cf84583492) Update the templating package IDs in artifacts.props
* [`[14888f46bc]`](https://github.com/aspnet/AspNetCore/commit/14888f46bc) Update DependencyModel to 2.1.0-preview2-25711-01
* [`[ee5178160e]`](https://github.com/aspnet/AspNetCore/commit/ee5178160e) Account for .Sources packages when computing the repo graph
* [`[05fd382b93]`](https://github.com/aspnet/AspNetCore/commit/05fd382b93)  #1256 Check HasStarted for StatusCode and ReasonPhrase
* [`[64596d538b]`](https://github.com/aspnet/AspNetCore/commit/64596d538b) TestServer: Copy the feature collection to mitigate multi-threading
* [`[1e556e0b46]`](https://github.com/aspnet/AspNetCore/commit/1e556e0b46)  #1253 TestServer: mark response headers IsReadOnly on start
* [`[0c77224f46]`](https://github.com/aspnet/AspNetCore/commit/0c77224f46) Allow prerendering middleware to pass through non-prerendered responses (important when using dev middleware)
* [`[a83ec3a053]`](https://github.com/aspnet/AspNetCore/commit/a83ec3a053) ArgumentNullException -> ArgumentException
* [`[bb07119b4a]`](https://github.com/aspnet/AspNetCore/commit/bb07119b4a) Handle "month" input type (#7022)
* [`[a5293eeca5]`](https://github.com/aspnet/AspNetCore/commit/a5293eeca5) Add Microsoft.AspNetCore.SpaServices.Extensions
* [`[c8b337ebaa]`](https://github.com/aspnet/AspNetCore/commit/c8b337ebaa) Add new Microsoft.AspNetCore.SpaServices.Extensions package to host new runtime functionality needed for updated templates until 2.1 ships
* [`[bcaee8df4e]`](https://github.com/aspnet/AspNetCore/commit/bcaee8df4e) Disable broken Anti-forgery tests
* [`[a7c9e8ab25]`](https://github.com/aspnet/AspNetCore/commit/a7c9e8ab25) Test: Do not set response headers after the response has started
* [`[277d7f2c81]`](https://github.com/aspnet/AspNetCore/commit/277d7f2c81) Update ANCM (#635)
* [`[bb34616a88]`](https://github.com/aspnet/AspNetCore/commit/bb34616a88) Test: fix status code order
* [`[7ebdee8667]`](https://github.com/aspnet/AspNetCore/commit/7ebdee8667) Update thet list of external dependencies
* [`[618d3dabee]`](https://github.com/aspnet/AspNetCore/commit/618d3dabee) Modifies ANCM DLL location based on folder rather than name. (#240)
* [`[9607e545a1]`](https://github.com/aspnet/AspNetCore/commit/9607e545a1) Include message for ShouldContinue
* [`[7d712f58aa]`](https://github.com/aspnet/AspNetCore/commit/7d712f58aa) Put Libuv.FunctionalTests into a separate test group
* [`[fe5924cc22]`](https://github.com/aspnet/AspNetCore/commit/fe5924cc22) Add Force parameter to UpdateRepos
* [`[993cd9f73d]`](https://github.com/aspnet/AspNetCore/commit/993cd9f73d) Trigger graceful shutdown on stopping webhost service
* [`[14c1a20578]`](https://github.com/aspnet/AspNetCore/commit/14c1a20578) Update routing to include aspnet/Routing#490
* [`[6c8af17e3a]`](https://github.com/aspnet/AspNetCore/commit/6c8af17e3a) Add placeholder package descriptions to fix NuGetPackageVerifier errors (#490)
* [`[bd18430428]`](https://github.com/aspnet/AspNetCore/commit/bd18430428) Added StartupWithIStartupFilter (#236)
* [`[325f1724ad]`](https://github.com/aspnet/AspNetCore/commit/325f1724ad) Make UpdateRepos add dependencies.props to commits
* [`[41abe63c10]`](https://github.com/aspnet/AspNetCore/commit/41abe63c10) Open ssl pfx (#2150)
* [`[238da2742d]`](https://github.com/aspnet/AspNetCore/commit/238da2742d) Use SocketAsyncEventArgs to improve perf (#2147)
* [`[b9ed1e073a]`](https://github.com/aspnet/AspNetCore/commit/b9ed1e073a) Require Microsoft.VisualStudio.Component.VC.Tools.x86.x64 to be installed before compiling ANCM (#238)
* [`[70c8133fce]`](https://github.com/aspnet/AspNetCore/commit/70c8133fce) allow paths that contain '.' (#125)
* [`[fd83b300b8]`](https://github.com/aspnet/AspNetCore/commit/fd83b300b8) Port TreeMatcher (#488)
* [`[801ad07560]`](https://github.com/aspnet/AspNetCore/commit/801ad07560) Add TextBuffer snapshot restriction back to VisualStudioRazorParser.
* [`[3e3772eecd]`](https://github.com/aspnet/AspNetCore/commit/3e3772eecd) Implement read-only HeaderDictionary (#958)
* [`[f287c46bad]`](https://github.com/aspnet/AspNetCore/commit/f287c46bad) Fix exception message for AuthenticationScheme (#960)
* [`[399dcca4f2]`](https://github.com/aspnet/AspNetCore/commit/399dcca4f2) Make Foreground dispatchable methods noop if parser is disposed.
* [`[18feba377f]`](https://github.com/aspnet/AspNetCore/commit/18feba377f) Rename Microsoft.DotNet.Web.ProjectTemplates.2.0.nuspec -> Microsoft.DotNet.Web.ProjectTemplates.nuspec
* [`[09161305bb]`](https://github.com/aspnet/AspNetCore/commit/09161305bb) Reorganize repo branch and project folder structure
* [`[834fd5a5d0]`](https://github.com/aspnet/AspNetCore/commit/834fd5a5d0) Only use release VS.
* [`[d9825d1547]`](https://github.com/aspnet/AspNetCore/commit/d9825d1547) Better JSON deserialization errors. Implements #4607, #4862
* [`[a2972ebf1c]`](https://github.com/aspnet/AspNetCore/commit/a2972ebf1c) Dispatch DocumentStructureChanged event on foreground thread.
* [`[72e1cb1385]`](https://github.com/aspnet/AspNetCore/commit/72e1cb1385) Add VirtualSchemes
* [`[13312109ff]`](https://github.com/aspnet/AspNetCore/commit/13312109ff) Test: Added a new MiddleWare to test the Gracefulshutdown message (#233)
* [`[639d49713e]`](https://github.com/aspnet/AspNetCore/commit/639d49713e) Fix UpdateRepos.ps1
* [`[7002dbf20a]`](https://github.com/aspnet/AspNetCore/commit/7002dbf20a) Added Name and Documentation to DirectiveTokenDescriptor
* [`[1ffcf2c009]`](https://github.com/aspnet/AspNetCore/commit/1ffcf2c009) Reorganize repo branch and project folder structure
* [`[c315b27ad9]`](https://github.com/aspnet/AspNetCore/commit/c315b27ad9) Fix the uninitialized g_hWinHttpModule global variable to avoid empty error messages (#225)
* [`[e2dcbea4ec]`](https://github.com/aspnet/AspNetCore/commit/e2dcbea4ec) #907 Clarify the encoding requirements for Response.Redirect. (#956)
* [`[a64b36c484]`](https://github.com/aspnet/AspNetCore/commit/a64b36c484) Fix #602 - improve the error message when a shipping package has an undefined external dependency
* [`[06475270ec]`](https://github.com/aspnet/AspNetCore/commit/06475270ec) Actually throwing exceptions from SendAsync (#1084)
* [`[08186bb198]`](https://github.com/aspnet/AspNetCore/commit/08186bb198) Use ipv4 when binding to ANCM port (#470)
* [`[1927f65e97]`](https://github.com/aspnet/AspNetCore/commit/1927f65e97) Change LogLevel from Information to Debug (see #1517)
* [`[936f82874a]`](https://github.com/aspnet/AspNetCore/commit/936f82874a) Release pins before disposal (#412)
* [`[9371e7b50a]`](https://github.com/aspnet/AspNetCore/commit/9371e7b50a) [Redis] Reorder some code to make it less spaghetti (#1081)
* [`[49cf523651]`](https://github.com/aspnet/AspNetCore/commit/49cf523651) Add location information to ANCM package (#230)
* [`[3fadca6a1b]`](https://github.com/aspnet/AspNetCore/commit/3fadca6a1b) Add IConstraintFactory (#487)
* [`[f0becd0586]`](https://github.com/aspnet/AspNetCore/commit/f0becd0586) Fix regex syntax
* [`[adf599e7c2]`](https://github.com/aspnet/AspNetCore/commit/adf599e7c2) Fail the submodule script if the VCS roots are not configured to match submodules
* [`[60faa8db90]`](https://github.com/aspnet/AspNetCore/commit/60faa8db90) Add missing parameters to updater scripts
* [`[ab4c519dd5]`](https://github.com/aspnet/AspNetCore/commit/ab4c519dd5) Infer multipart/form-data for FromFile parameters
* [`[13757936ad]`](https://github.com/aspnet/AspNetCore/commit/13757936ad) Adding roundtripping test for GUID property
* [`[7e97adc1c0]`](https://github.com/aspnet/AspNetCore/commit/7e97adc1c0) Add arguments to configure the git username and email to the updater scripts
* [`[dde1a75b80]`](https://github.com/aspnet/AspNetCore/commit/dde1a75b80) Updating spec
* [`[cc42b0eaef]`](https://github.com/aspnet/AspNetCore/commit/cc42b0eaef) Fixing a bug where cancellation could result in HubException
* [`[8c446fc02d]`](https://github.com/aspnet/AspNetCore/commit/8c446fc02d) [Redis] Save a few bytes for acks (#1070)
* [`[1d2e0fedb0]`](https://github.com/aspnet/AspNetCore/commit/1d2e0fedb0) Enabling byte[]
* [`[4d6383727a]`](https://github.com/aspnet/AspNetCore/commit/4d6383727a) Updating jasmine
* [`[52862b23d7]`](https://github.com/aspnet/AspNetCore/commit/52862b23d7) Updating msgpack5 to the latest version
* [`[a42c8a33b8]`](https://github.com/aspnet/AspNetCore/commit/a42c8a33b8) Return FINISH_REQUEST on request failure (#469)
* [`[cccfe3dd57]`](https://github.com/aspnet/AspNetCore/commit/cccfe3dd57) Use submodules for source dependencies (#621)
* [`[06bff32f4e]`](https://github.com/aspnet/AspNetCore/commit/06bff32f4e) Fix missed reorder of HttpsRedirection calls in spa templates (#140)
* [`[82ccf4f06e]`](https://github.com/aspnet/AspNetCore/commit/82ccf4f06e)  #816 Allow directly constructing an HttpContext for TestServer
* [`[36fe9b40ef]`](https://github.com/aspnet/AspNetCore/commit/36fe9b40ef) Adds Hsts and HttpsRedirection to spa templates (#137)
* [`[2419867dfc]`](https://github.com/aspnet/AspNetCore/commit/2419867dfc) Handle errors in Redis subscription callbacks (#1069)
* [`[3cc35da562]`](https://github.com/aspnet/AspNetCore/commit/3cc35da562) Add a switch to protect from unintended pushes
* [`[c998d74e1d]`](https://github.com/aspnet/AspNetCore/commit/c998d74e1d) Set XmlRepository whem setting encryptor in DataProtection light-up (#117)
* [`[0c34523e8b]`](https://github.com/aspnet/AspNetCore/commit/0c34523e8b) Log exception after critical accept loop error (#2140)
* [`[fc613303ed]`](https://github.com/aspnet/AspNetCore/commit/fc613303ed) Add an overload that takes the application base path explicitly
* [`[9a0064285d]`](https://github.com/aspnet/AspNetCore/commit/9a0064285d) KeyVault HostingStartup (#114)
* [`[158e9d572b]`](https://github.com/aspnet/AspNetCore/commit/158e9d572b) Upgrade selenium dependencies to support Windows Fall Creator Update
* [`[88cb3df0eb]`](https://github.com/aspnet/AspNetCore/commit/88cb3df0eb) Added support for multiple values (arrays) in default claim action (#1501)
* [`[38ce406c6e]`](https://github.com/aspnet/AspNetCore/commit/38ce406c6e) Make tests not fail just because a same-named env var was already present
* [`[02331040a1]`](https://github.com/aspnet/AspNetCore/commit/02331040a1) Dispose of the existing native context before creating a new one.
* [`[b0de6da24f]`](https://github.com/aspnet/AspNetCore/commit/b0de6da24f) Update the Scaffolding and Templating submodules
* [`[0573454c70]`](https://github.com/aspnet/AspNetCore/commit/0573454c70) Add ValueStopwatch package to artifacts.props
* [`[5f164857fa]`](https://github.com/aspnet/AspNetCore/commit/5f164857fa) Add RIDs to sample test project to fix standalone publish
* [`[83bb07d5a4]`](https://github.com/aspnet/AspNetCore/commit/83bb07d5a4) Fix parameter name (#1066)
* [`[18f770e937]`](https://github.com/aspnet/AspNetCore/commit/18f770e937) Late parameter binding (#1049)
* [`[6652182b58]`](https://github.com/aspnet/AspNetCore/commit/6652182b58) Add script to update each Repo
* [`[9d3a55a1f4]`](https://github.com/aspnet/AspNetCore/commit/9d3a55a1f4) Update bootstrapper
* [`[2cd59f86c4]`](https://github.com/aspnet/AspNetCore/commit/2cd59f86c4) client disconnect change (#223)
* [`[99fc843cc5]`](https://github.com/aspnet/AspNetCore/commit/99fc843cc5) Re-enable skipped tests
* [`[6c7551d9c7]`](https://github.com/aspnet/AspNetCore/commit/6c7551d9c7) Require the Microsoft.VisualStudio.Component.VSSDK workload to be installed
* [`[e892ed8bbd]`](https://github.com/aspnet/AspNetCore/commit/e892ed8bbd) Add a way to prevent specific hosting startup from runnning (#1243)
* [`[88db534e42]`](https://github.com/aspnet/AspNetCore/commit/88db534e42) UseExceptionHandler throws if ExceptionHandlingPath not set (#417)
* [`[1e360cbb36]`](https://github.com/aspnet/AspNetCore/commit/1e360cbb36) #1244 Disable restore on publish for integration tests
* [`[de2aef61ba]`](https://github.com/aspnet/AspNetCore/commit/de2aef61ba) Make controllers with ApiControllerAttribute visible in ApiExplorer
* [`[4e641df9b1]`](https://github.com/aspnet/AspNetCore/commit/4e641df9b1) Update roslyn VSIX package versions to match what is in aspnet/Razor
* [`[9d4c3adda1]`](https://github.com/aspnet/AspNetCore/commit/9d4c3adda1) Update modules/Templating to fix workaround dotnet/templating#1302
* [`[8d5a61f6ec]`](https://github.com/aspnet/AspNetCore/commit/8d5a61f6ec) Initial commit with readme, gitignore, license, and contributing.
* [`[60d604580c]`](https://github.com/aspnet/AspNetCore/commit/60d604580c) Add identity fix
* [`[e453fafad5]`](https://github.com/aspnet/AspNetCore/commit/e453fafad5) Reorganize tests (#117)
* [`[c567a690bc]`](https://github.com/aspnet/AspNetCore/commit/c567a690bc) [Fixes #6902] Added an overload for StatusCode that takes in System.Net.HttpStatusCode
* [`[bb413c6ac3]`](https://github.com/aspnet/AspNetCore/commit/bb413c6ac3) Rename a bunch of old stuff
* [`[81ddda7b96]`](https://github.com/aspnet/AspNetCore/commit/81ddda7b96) Add MetadataCollection
* [`[812fa9599a]`](https://github.com/aspnet/AspNetCore/commit/812fa9599a) Reorganize some folders
* [`[ddcc409353]`](https://github.com/aspnet/AspNetCore/commit/ddcc409353) Move some files in/out of abstractions
* [`[734df3f88f]`](https://github.com/aspnet/AspNetCore/commit/734df3f88f) Use TeamCity to select commits
* [`[eeb49c2af7]`](https://github.com/aspnet/AspNetCore/commit/eeb49c2af7) Pass setsockopt fd as int (#2136)
* [`[b2c73f13e2]`](https://github.com/aspnet/AspNetCore/commit/b2c73f13e2) Add AppAuthentication package (#617)
* [`[521b9bdd5e]`](https://github.com/aspnet/AspNetCore/commit/521b9bdd5e) Add missing import
* [`[1df37f8060]`](https://github.com/aspnet/AspNetCore/commit/1df37f8060) Fix spelling mistake in constant name
* [`[4172d62aa5]`](https://github.com/aspnet/AspNetCore/commit/4172d62aa5) Add missing @ symbol to AccessDenied.cshtml
* [`[d612072d1a]`](https://github.com/aspnet/AspNetCore/commit/d612072d1a) Fix a broken MVC test
* [`[736b49294d]`](https://github.com/aspnet/AspNetCore/commit/736b49294d) Add Template abstraction
* [`[1c0aeb08bb]`](https://github.com/aspnet/AspNetCore/commit/1c0aeb08bb) Add RuntimeStore config to music store
* [`[2d661396df]`](https://github.com/aspnet/AspNetCore/commit/2d661396df) Port TemplateBinder to dispatcher
* [`[eebc7db2ca]`](https://github.com/aspnet/AspNetCore/commit/eebc7db2ca) Use RoutePatternMatcher logic in TemplateMatcher (#484)
* [`[8c4bdbcf6b]`](https://github.com/aspnet/AspNetCore/commit/8c4bdbcf6b) Add "zero config" HTTPS support using local development certificate. (#2093)
* [`[c3ba875d12]`](https://github.com/aspnet/AspNetCore/commit/c3ba875d12) Better handle Socket transport accept errors (#2133)
* [`[9c5d38a786]`](https://github.com/aspnet/AspNetCore/commit/9c5d38a786) Expose VirtualDirectory to In Process mode (#210)
* [`[94c895a1bd]`](https://github.com/aspnet/AspNetCore/commit/94c895a1bd) Parse Path and PathBase from Virtual Directory. (#457)
* [`[332b108f41]`](https://github.com/aspnet/AspNetCore/commit/332b108f41) Changes PostCompletion to handle OnAsyncCompletion after managed request has completed.  (#212)
* [`[7d205d1093]`](https://github.com/aspnet/AspNetCore/commit/7d205d1093) add event names to Logging messages (#2132)
* [`[6ac0137a9f]`](https://github.com/aspnet/AspNetCore/commit/6ac0137a9f) Make AtDirectiveCompletionPoint resilient to null owners.
* [`[eec6b4f2f5]`](https://github.com/aspnet/AspNetCore/commit/eec6b4f2f5) Removing Connected event from TestConnection (#1055)
* [`[30e7422407]`](https://github.com/aspnet/AspNetCore/commit/30e7422407) Enable reconnect for Redis connection by default (#1037)
* [`[537a735d30]`](https://github.com/aspnet/AspNetCore/commit/537a735d30) Fix target dependencies
* [`[386483b9ef]`](https://github.com/aspnet/AspNetCore/commit/386483b9ef) Create timestamp free cumulative archives
* [`[fb8aff12f1]`](https://github.com/aspnet/AspNetCore/commit/fb8aff12f1) Add EditorSettings management to workspaces.
* [`[4da6565d5b]`](https://github.com/aspnet/AspNetCore/commit/4da6565d5b) Update modules/Scaffolding to ce3c4802 to fix aspnet/Scaffolding#645
* [`[1768a081ba]`](https://github.com/aspnet/AspNetCore/commit/1768a081ba) Updating default pattern(#1046)
* [`[bfb2c86cda]`](https://github.com/aspnet/AspNetCore/commit/bfb2c86cda) moving export methods to a standalone file (#211)
* [`[204cf7a1dc]`](https://github.com/aspnet/AspNetCore/commit/204cf7a1dc) This brings support for the final syntax of "ref readonly" and some bug fixes. (#2121)
* [`[c845a331bb]`](https://github.com/aspnet/AspNetCore/commit/c845a331bb) adding forwarding end freb event (#209)
* [`[e91af13a7d]`](https://github.com/aspnet/AspNetCore/commit/e91af13a7d) Generate the PackageVersionProps file and put it in the lineup package
* [`[212d97e511]`](https://github.com/aspnet/AspNetCore/commit/212d97e511) Manage VisualStudioRazorParser lifetime.
* [`[bf23f16c22]`](https://github.com/aspnet/AspNetCore/commit/bf23f16c22) Add SQLitePCLRaw.bundle_sqlcipher
* [`[058d70190a]`](https://github.com/aspnet/AspNetCore/commit/058d70190a) Metapackage false
* [`[31217a7577]`](https://github.com/aspnet/AspNetCore/commit/31217a7577) Add SpaServices.Extensions to artifacts.props
* [`[485278bf0d]`](https://github.com/aspnet/AspNetCore/commit/485278bf0d) Add RoutePatternMatcher to Dispatcher (#482)
* [`[30010a103b]`](https://github.com/aspnet/AspNetCore/commit/30010a103b) Fix for #2085 - "The Detaskening" (#2123)
* [`[e7e84035c0]`](https://github.com/aspnet/AspNetCore/commit/e7e84035c0) Adding StreamCompletion message to the HubProtocol spec (#1041)
* [`[57d2382c46]`](https://github.com/aspnet/AspNetCore/commit/57d2382c46) Http Post section revision (#1042)
* [`[caff492cdc]`](https://github.com/aspnet/AspNetCore/commit/caff492cdc) Removing sending OPTIONS request if WebSocket transport requested (#1036)
* [`[fff3e1ebd0]`](https://github.com/aspnet/AspNetCore/commit/fff3e1ebd0) Validate benchmarks (#2126)
* [`[e583a17ef8]`](https://github.com/aspnet/AspNetCore/commit/e583a17ef8) Clean up how IHttpContextAccessor is added
* [`[5ffb082acb]`](https://github.com/aspnet/AspNetCore/commit/5ffb082acb) Add Missing Await in Test (#1045)
* [`[448a2afed8]`](https://github.com/aspnet/AspNetCore/commit/448a2afed8) fix the AV in recycle process, issue #192.  (#201)
* [`[bd517f891f]`](https://github.com/aspnet/AspNetCore/commit/bd517f891f) Support conversions from RouteTemplate -> RoutePattern
* [`[9cc5d13a40]`](https://github.com/aspnet/AspNetCore/commit/9cc5d13a40) [Redis] Adding same group to connection multiple times should NOP (#1040)
* [`[b6d01fda46]`](https://github.com/aspnet/AspNetCore/commit/b6d01fda46) Target 15.6 for the VSIX in dev
* [`[df78db934d]`](https://github.com/aspnet/AspNetCore/commit/df78db934d) Port IRouteConstraint to the dispatcher project
* [`[fdc5f21428]`](https://github.com/aspnet/AspNetCore/commit/fdc5f21428) Port PathTokenizer (#478)
* [`[bc4a514d9e]`](https://github.com/aspnet/AspNetCore/commit/bc4a514d9e) Better message for integration tests
* [`[6bddb258cd]`](https://github.com/aspnet/AspNetCore/commit/6bddb258cd) Adding StreamCompletion message (TS)
* [`[8d1d6d0300]`](https://github.com/aspnet/AspNetCore/commit/8d1d6d0300) Adding StreamCompletion message (C#)
* [`[9b9bb4dde7]`](https://github.com/aspnet/AspNetCore/commit/9b9bb4dde7) Exclude net461 tests on mac/linux (#113)
* [`[e46ba481c8]`](https://github.com/aspnet/AspNetCore/commit/e46ba481c8) Throw JsonSerializationException from converters (#116)
* [`[86d6e51ba2]`](https://github.com/aspnet/AspNetCore/commit/86d6e51ba2) Fix rpm packages and hosting tar.gz
* [`[08a64048da]`](https://github.com/aspnet/AspNetCore/commit/08a64048da) Redesign public API for templates
* [`[a903a74db1]`](https://github.com/aspnet/AspNetCore/commit/a903a74db1) Adding roundtripping test for CancelInvocation message (#1031)
* [`[04d4da2987]`](https://github.com/aspnet/AspNetCore/commit/04d4da2987)  Replace Received Event with OnReceived (#1006)
* [`[3fbfba63f8]`](https://github.com/aspnet/AspNetCore/commit/3fbfba63f8) HTTP/2: implement 100-continue (#2106)
* [`[c563f371c7]`](https://github.com/aspnet/AspNetCore/commit/c563f371c7) Add HealthChecks to artifacts.props (#611)
* [`[a30befae0f]`](https://github.com/aspnet/AspNetCore/commit/a30befae0f) Add abstractions for Health Checks and a simple middleware and service to run them (#408)
* [`[c57aa3b2a8]`](https://github.com/aspnet/AspNetCore/commit/c57aa3b2a8) Treat more exceptions from Socket.ReceiveAsync as aborted connections (#2122)
* [`[bb308ff72e]`](https://github.com/aspnet/AspNetCore/commit/bb308ff72e) LoggerDefine for Redis (#1002)
* [`[65fcbdb8c8]`](https://github.com/aspnet/AspNetCore/commit/65fcbdb8c8) Installer generation updates
* [`[b3ac9f4bf8]`](https://github.com/aspnet/AspNetCore/commit/b3ac9f4bf8) Not very important code optimization (#1030)
* [`[fc8c29c5d6]`](https://github.com/aspnet/AspNetCore/commit/fc8c29c5d6) Make the outputpath for the installers
* [`[d5df2acd45]`](https://github.com/aspnet/AspNetCore/commit/d5df2acd45) Put installers into artifacts/installers/ and the lzma into artifacts/lzma/
* [`[a3c1b6d033]`](https://github.com/aspnet/AspNetCore/commit/a3c1b6d033) Avoid allocation of a new char array on every request in RouteCollection class
* [`[eb67f8bcef]`](https://github.com/aspnet/AspNetCore/commit/eb67f8bcef) Update package reference versions in more 1.x templates (#72)
* [`[68014a7acd]`](https://github.com/aspnet/AspNetCore/commit/68014a7acd) Changes async calls to use OnAsyncComplete event pattern (#184)
* [`[4bb84cf6d0]`](https://github.com/aspnet/AspNetCore/commit/4bb84cf6d0) Ensure the deb/rpm installers use the same dotnet-core version
* [`[7117147a09]`](https://github.com/aspnet/AspNetCore/commit/7117147a09) adding FREB and more ETW log (#185)
* [`[1f6db0e3ad]`](https://github.com/aspnet/AspNetCore/commit/1f6db0e3ad) Add Microsoft.NETCore.Platforms to the list of external dependencies
* [`[af286c81bb]`](https://github.com/aspnet/AspNetCore/commit/af286c81bb) Groups collection without lock
* [`[3a5cd6dd25]`](https://github.com/aspnet/AspNetCore/commit/3a5cd6dd25) Port TemplateParser to Dispatcher project (#473)
* [`[2836d53a2d]`](https://github.com/aspnet/AspNetCore/commit/2836d53a2d) Add Microsoft.AspNetCore.DeveloperCertificates.Tools to the artifacts.props
* [`[ff0f112d7b]`](https://github.com/aspnet/AspNetCore/commit/ff0f112d7b) Add HTTPS developer certificate management tool
* [`[927f8ed3d2]`](https://github.com/aspnet/AspNetCore/commit/927f8ed3d2) Add empty baselines for dispatcher
* [`[4f3fdaebee]`](https://github.com/aspnet/AspNetCore/commit/4f3fdaebee) #1208 Default timeout for IHost.StopAsync. Create Host with DI.
* [`[8946a68923]`](https://github.com/aspnet/AspNetCore/commit/8946a68923) Infer binding sources for ApiController parameters
* [`[bdfbc3fea6]`](https://github.com/aspnet/AspNetCore/commit/bdfbc3fea6) Adds endings to new dependencies
* [`[600cf9d444]`](https://github.com/aspnet/AspNetCore/commit/600cf9d444)  Adds ANCM external dependencies (#608)
* [`[a80061f42b]`](https://github.com/aspnet/AspNetCore/commit/a80061f42b) Move Identity to an Area for 2.1
* [`[a709158e8a]`](https://github.com/aspnet/AspNetCore/commit/a709158e8a) Summary of changes\n\t- Improved logging to browser console\n\nAddresses #802
* [`[748afb1f65]`](https://github.com/aspnet/AspNetCore/commit/748afb1f65) #270 Fix hang in SendFile tests
* [`[c255c7f276]`](https://github.com/aspnet/AspNetCore/commit/c255c7f276) Put ApplicationInsights.HostingStartup back into metapackage (#606)
* [`[fe031e5655]`](https://github.com/aspnet/AspNetCore/commit/fe031e5655) Move core installer download to its own target
* [`[733ac1efab]`](https://github.com/aspnet/AspNetCore/commit/733ac1efab) Handle EPIPE like ECONNRESET on Linux (#2112)
* [`[3cae26c6a2]`](https://github.com/aspnet/AspNetCore/commit/3cae26c6a2) Set RepositoryRoot
* [`[ebbf5a730e]`](https://github.com/aspnet/AspNetCore/commit/ebbf5a730e) Adds Microsoft.AspNetCore.HttpsPolicy to packages. (#583)
* [`[38be05d442]`](https://github.com/aspnet/AspNetCore/commit/38be05d442) Update the 1.x templates for the latest patch
* [`[91d4be47b9]`](https://github.com/aspnet/AspNetCore/commit/91d4be47b9) Produce separate reference package for runtime store generation
* [`[9dfffd14bb]`](https://github.com/aspnet/AspNetCore/commit/9dfffd14bb) HTTP/2: support trailers.
* [`[5541615008]`](https://github.com/aspnet/AspNetCore/commit/5541615008) Automate dependency version selection
* [`[87b3cc6879]`](https://github.com/aspnet/AspNetCore/commit/87b3cc6879) Update EF
* [`[31c16af40b]`](https://github.com/aspnet/AspNetCore/commit/31c16af40b) Add smart indentation for brace completion.
* [`[5fab5a4775]`](https://github.com/aspnet/AspNetCore/commit/5fab5a4775) Ship Kestrel.Transport.Sockets
* [`[bdbe922b22]`](https://github.com/aspnet/AspNetCore/commit/bdbe922b22) Add logging (#467)
* [`[701184a962]`](https://github.com/aspnet/AspNetCore/commit/701184a962) Microsoft.AspNetCore.BenchmarkRunner.Sources (#597)
* [`[66a3c9496a]`](https://github.com/aspnet/AspNetCore/commit/66a3c9496a) Set SO_REUSEADDR on managed listen sockets on Unix (#2111)
* [`[deed6c9780]`](https://github.com/aspnet/AspNetCore/commit/deed6c9780) HTTP/2: add exception error messages and log them.
* [`[75a7552360]`](https://github.com/aspnet/AspNetCore/commit/75a7552360) Add Referer to GetTypedHeaders (#949)
* [`[824539f47a]`](https://github.com/aspnet/AspNetCore/commit/824539f47a) #1349 Don't throw for partial cookies
* [`[c2a0010eda]`](https://github.com/aspnet/AspNetCore/commit/c2a0010eda) Fix the metapackage generation
* [`[01b4530fa7]`](https://github.com/aspnet/AspNetCore/commit/01b4530fa7) Add Content-Security-Policy (#950)
* [`[84157041bc]`](https://github.com/aspnet/AspNetCore/commit/84157041bc) Update properties fore restore on CI
* [`[a48a3be6d7]`](https://github.com/aspnet/AspNetCore/commit/a48a3be6d7) Explicitly specify metapackage version
* [`[9aeefd3fd5]`](https://github.com/aspnet/AspNetCore/commit/9aeefd3fd5) Fix compile error
* [`[c8068b7d1c]`](https://github.com/aspnet/AspNetCore/commit/c8068b7d1c) Use submodules for source dependencies
* [`[7f96eab775]`](https://github.com/aspnet/AspNetCore/commit/7f96eab775) #381 handle known headers with no value.
* [`[fdb4184dbf]`](https://github.com/aspnet/AspNetCore/commit/fdb4184dbf) Sockets transport (#2100)
* [`[00dc9831dd]`](https://github.com/aspnet/AspNetCore/commit/00dc9831dd) AzureIntegration#38 Make the SiteExtension a shipping package (#593)
* [`[f1efb29b18]`](https://github.com/aspnet/AspNetCore/commit/f1efb29b18) Use ContractResolver instead of forcing to lower case (#112)
* [`[de34990241]`](https://github.com/aspnet/AspNetCore/commit/de34990241) Short Circuit message to local connection in Redis (#1009)
* [`[bd07f8b683]`](https://github.com/aspnet/AspNetCore/commit/bd07f8b683) #1353 use a compliant Expires header value for expiration.
* [`[509210bcac]`](https://github.com/aspnet/AspNetCore/commit/509210bcac) Fix syntax errors in bootstrapper script
* [`[8701baf73d]`](https://github.com/aspnet/AspNetCore/commit/8701baf73d) Add negotiate timeout option to hub options (#1003)
* [`[de535422d7]`](https://github.com/aspnet/AspNetCore/commit/de535422d7) Optional error and complete functions for observables (#1000)
* [`[02cd997e32]`](https://github.com/aspnet/AspNetCore/commit/02cd997e32) Add Validate(scheme) and use for RemoteSignInScheme not self validation
* [`[d46d2ce193]`](https://github.com/aspnet/AspNetCore/commit/d46d2ce193) HTTP/2: validate request headers prior to starting new stream.
* [`[f4e9ddad22]`](https://github.com/aspnet/AspNetCore/commit/f4e9ddad22) Link syntax tree Span nodes
* [`[e3d2b48b89]`](https://github.com/aspnet/AspNetCore/commit/e3d2b48b89) Fix [ForegroundFact].
* [`[d0cab06f08]`](https://github.com/aspnet/AspNetCore/commit/d0cab06f08) Only add sources that exist
* [`[7ba167fcd8]`](https://github.com/aspnet/AspNetCore/commit/7ba167fcd8) Add 'default response' to API Response Type
* [`[633cb68149]`](https://github.com/aspnet/AspNetCore/commit/633cb68149) Populate WebHost configuration with command line arguments if provided
* [`[5e4e386a84]`](https://github.com/aspnet/AspNetCore/commit/5e4e386a84) List more external dependencies
* [`[be7c5c7752]`](https://github.com/aspnet/AspNetCore/commit/be7c5c7752) Mirror everything that isn't on nuget.org
* [`[bda1eb2ab9]`](https://github.com/aspnet/AspNetCore/commit/bda1eb2ab9) Update restore source for aspnet testing utility packages
* [`[c76125af0e]`](https://github.com/aspnet/AspNetCore/commit/c76125af0e) Add previously-built aspnetcore artifacts as external dependencies
* [`[869d762641]`](https://github.com/aspnet/AspNetCore/commit/869d762641) Copy symbol packages to artifacts/symbols
* [`[badaa7393b]`](https://github.com/aspnet/AspNetCore/commit/badaa7393b) Add header names for CORS (#951)
* [`[e34a5f8fb8]`](https://github.com/aspnet/AspNetCore/commit/e34a5f8fb8) Add MaxAge to OpenIdConnectOptions  - max_age parameter added to the authentication request if MaxAge is not null  - throws exception if MaxAge is set to a negative value  - Fractions of seconds are ignored  - See https://openid.net/specs/openid-connect-core-1_0.html#AuthRequest for expected behavior
* [`[de2e0967c3]`](https://github.com/aspnet/AspNetCore/commit/de2e0967c3) Adding CancelInvocation message (#979)
* [`[71116396cf]`](https://github.com/aspnet/AspNetCore/commit/71116396cf) Add Microsoft.AspNetCore.Certificates.Generation.Sources to artifacts.props
* [`[665f166d67]`](https://github.com/aspnet/AspNetCore/commit/665f166d67) fix issue with incorrect user detection when Invoking for User (#747)
* [`[3c5d283689]`](https://github.com/aspnet/AspNetCore/commit/3c5d283689) Fix the VarInt example for the 2GiB
* [`[2ce4719690]`](https://github.com/aspnet/AspNetCore/commit/2ce4719690) new toolset compiler - 2.6.0-beta1-62126-01 (#2090)
* [`[60f520de34]`](https://github.com/aspnet/AspNetCore/commit/60f520de34) Removing Microsoft.AspNetCore.Server.IIS package (#582)
* [`[7609f4dca7]`](https://github.com/aspnet/AspNetCore/commit/7609f4dca7) Add HttpClientFactory to repos
* [`[722c47a674]`](https://github.com/aspnet/AspNetCore/commit/722c47a674) Add Microsoft.Extensions.Http to artifacts
* [`[c53c133bcb]`](https://github.com/aspnet/AspNetCore/commit/c53c133bcb) Compose store symbols to the correct location
* [`[2f8951e244]`](https://github.com/aspnet/AspNetCore/commit/2f8951e244) Productize HttpMethodEndpointSelector (#463)
* [`[c4400d22d4]`](https://github.com/aspnet/AspNetCore/commit/c4400d22d4) Port fix for URL helper redirect (#6916)
* [`[d0a8b5f78f]`](https://github.com/aspnet/AspNetCore/commit/d0a8b5f78f) Port fix for URL helper redirect (#6917)
* [`[72514f3943]`](https://github.com/aspnet/AspNetCore/commit/72514f3943) Removing the connected event (#989)
* [`[746f578c3c]`](https://github.com/aspnet/AspNetCore/commit/746f578c3c) Panwang/inproc (#174)
* [`[fea4095833]`](https://github.com/aspnet/AspNetCore/commit/fea4095833) Match BlockKindInternal values with BlockKind
* [`[9fbb2f1141]`](https://github.com/aspnet/AspNetCore/commit/9fbb2f1141) Simplify collection initialization (#6897)
* [`[950db6587c]`](https://github.com/aspnet/AspNetCore/commit/950db6587c) Require attribute routing with [ApiController]
* [`[11ce1395e5]`](https://github.com/aspnet/AspNetCore/commit/11ce1395e5) HPACK fixes and improvements.
* [`[156ddfc4e8]`](https://github.com/aspnet/AspNetCore/commit/156ddfc4e8) Fix EOF handling of TlsStream.ReadAsync (#2094)
* [`[ba1c210f03]`](https://github.com/aspnet/AspNetCore/commit/ba1c210f03) Fixing JS end-to-end tests
* [`[8fbac32ed8]`](https://github.com/aspnet/AspNetCore/commit/8fbac32ed8) Only attempt to publish npm when npm artifacts exist
* [`[2b6989bc09]`](https://github.com/aspnet/AspNetCore/commit/2b6989bc09) Add /t:Push
* [`[4d091430fc]`](https://github.com/aspnet/AspNetCore/commit/4d091430fc) Update AspNetCoreModule to latest version
* [`[0c1352dd27]`](https://github.com/aspnet/AspNetCore/commit/0c1352dd27) Update metapackage via artifact dependencies
* [`[1887c7bb62]`](https://github.com/aspnet/AspNetCore/commit/1887c7bb62) Changing version to final
* [`[f7ff445501]`](https://github.com/aspnet/AspNetCore/commit/f7ff445501) Casing of NuGet.config
* [`[955cd09ddc]`](https://github.com/aspnet/AspNetCore/commit/955cd09ddc) Add mirror dependencies
* [`[ea7bc30dd3]`](https://github.com/aspnet/AspNetCore/commit/ea7bc30dd3) Avoid AV if schema change doesn't exist. (#177)
* [`[f41dc2aef9]`](https://github.com/aspnet/AspNetCore/commit/f41dc2aef9) Only handle indentation for open curly brace instead of all metacode
* [`[37c12d5a64]`](https://github.com/aspnet/AspNetCore/commit/37c12d5a64) Add sources
* [`[bfbc04f758]`](https://github.com/aspnet/AspNetCore/commit/bfbc04f758) Use AddHttpContextAccessor method added in aspnet/HttpAbstractions#947
* [`[c5f89a8b57]`](https://github.com/aspnet/AspNetCore/commit/c5f89a8b57) Added Conflict result helper to ControllerBase - Added ConflictObjectResult and ConflictResult types. - Conflict(), Conflict(object error), Conflict(ModelState modelState) added to ControllerBase.cs.
* [`[826e89a2d1]`](https://github.com/aspnet/AspNetCore/commit/826e89a2d1) Use HttpMethods helpers
* [`[f6fa111333]`](https://github.com/aspnet/AspNetCore/commit/f6fa111333) Another attempt
* [`[d961ada80b]`](https://github.com/aspnet/AspNetCore/commit/d961ada80b) Removing DotNetCliToolReference from IIS sample csproj (#437)
* [`[9dc69fe361]`](https://github.com/aspnet/AspNetCore/commit/9dc69fe361) Adds support for ANCM in process (#425)
* [`[786f825a3d]`](https://github.com/aspnet/AspNetCore/commit/786f825a3d) Change powershell zip procedure to work on earlier versions.
* [`[e3ce1f52d4]`](https://github.com/aspnet/AspNetCore/commit/e3ce1f52d4) Added Conflict result helper to ControllerBase - Added ConflictObjectResult and ConflictResult types. - Conflict(), Conflict(object error), Conflict(ModelState modelState) added to ControllerBase.cs.
* [`[c93cfd0375]`](https://github.com/aspnet/AspNetCore/commit/c93cfd0375) Add Microsoft.AspNetCore.Server.IIS to package artifacts (#572)
* [`[aa0d5ec659]`](https://github.com/aspnet/AspNetCore/commit/aa0d5ec659) Updating HubProtocol spec to account for using VarInt to encode length prefix
* [`[c3c8919523]`](https://github.com/aspnet/AspNetCore/commit/c3c8919523) Mirror Microsoft.NETCore.App 2.0.2 and its dependencies
* [`[372be2f638]`](https://github.com/aspnet/AspNetCore/commit/372be2f638) Generate and set DotNetRestoreSourcePropsPath
* [`[a63932a492]`](https://github.com/aspnet/AspNetCore/commit/a63932a492) Add option to suppress writing startup messages
* [`[be5d4ec11e]`](https://github.com/aspnet/AspNetCore/commit/be5d4ec11e) Undo a breaking change
* [`[0959c941b4]`](https://github.com/aspnet/AspNetCore/commit/0959c941b4) Cleaned up OAuth handler's exception messages (#1462)
* [`[1b1137b880]`](https://github.com/aspnet/AspNetCore/commit/1b1137b880) HTTP/2: connection error when receiving frames disallowed by stream states.
* [`[d6a3c3f83e]`](https://github.com/aspnet/AspNetCore/commit/d6a3c3f83e) Add helper to register IHttpContextAccessor (#947)
* [`[afdda7cbee]`](https://github.com/aspnet/AspNetCore/commit/afdda7cbee) Update fsproj for FSharpWebSite. Fixes #6554
* [`[2fcfc6be7c]`](https://github.com/aspnet/AspNetCore/commit/2fcfc6be7c) Add EnableRangeProcessing (#6895)
* [`[f49cbd1b25]`](https://github.com/aspnet/AspNetCore/commit/f49cbd1b25) Selectors initialization and DispatcherBase logging (#451)
* [`[059264ba34]`](https://github.com/aspnet/AspNetCore/commit/059264ba34) Fix RazorAddin project.
* [`[9bf6fe233f]`](https://github.com/aspnet/AspNetCore/commit/9bf6fe233f) Add Mono.Addins to lineup.
* [`[70df19c8a2]`](https://github.com/aspnet/AspNetCore/commit/70df19c8a2) Fixing MsgPack serializing byte[] as string Part 1
* [`[bc2502cf4c]`](https://github.com/aspnet/AspNetCore/commit/bc2502cf4c) Import dependencies.props last to ensure TargetFramework is set first
* [`[fb142f0b24]`](https://github.com/aspnet/AspNetCore/commit/fb142f0b24) Import dependencies.props last to ensure TargetFramework is set first
* [`[63e0af2ee8]`](https://github.com/aspnet/AspNetCore/commit/63e0af2ee8) Import dependencies.props last to ensure TargetFramework is set first
* [`[bb9840a552]`](https://github.com/aspnet/AspNetCore/commit/bb9840a552) HTTP/2: do not ACK PING frames received with ACK set.
* [`[7ccd7ce108]`](https://github.com/aspnet/AspNetCore/commit/7ccd7ce108) Add VisualStudio.Mac assemblies.
* [`[fca4f23895]`](https://github.com/aspnet/AspNetCore/commit/fca4f23895) Add Microsoft.MonoDevelop.RazorAddin.
* [`[6c8286eed7]`](https://github.com/aspnet/AspNetCore/commit/6c8286eed7) Split LanguageServices.Razor.
* [`[abb41302e9]`](https://github.com/aspnet/AspNetCore/commit/abb41302e9) Add a dispatcher by default (#462)
* [`[bd8e9ecc31]`](https://github.com/aspnet/AspNetCore/commit/bd8e9ecc31) Added RazorParserFeatureFlags and added support for minimized bool tag helper bound attributes  - Fixes #1678, #431
* [`[b0d91c17f1]`](https://github.com/aspnet/AspNetCore/commit/b0d91c17f1) Add Strict-Transport-Security header name (#944)
* [`[d2e49a726c]`](https://github.com/aspnet/AspNetCore/commit/d2e49a726c) Generate the package version props file
* [`[6045eff343]`](https://github.com/aspnet/AspNetCore/commit/6045eff343) Push NPM packages
* [`[4ecafc0afd]`](https://github.com/aspnet/AspNetCore/commit/4ecafc0afd) Update AspNetCoreModule to 1.0.0-pre-10134
* [`[e7c5ce6bb9]`](https://github.com/aspnet/AspNetCore/commit/e7c5ce6bb9) Push lineup packages and put symbols in a separate directory
* [`[be6b099f6c]`](https://github.com/aspnet/AspNetCore/commit/be6b099f6c) #189 Reduce noise for load and commit logs.
* [`[586d3c99c7]`](https://github.com/aspnet/AspNetCore/commit/586d3c99c7) Fix bug in DependsOnTargets and /t:Push
* [`[edcf6857d1]`](https://github.com/aspnet/AspNetCore/commit/edcf6857d1) Add x64 service hub json.
* [`[9aebb2d823]`](https://github.com/aspnet/AspNetCore/commit/9aebb2d823) Don't clear cloned sources when SkipClone=true
* [`[2e7f1355e5]`](https://github.com/aspnet/AspNetCore/commit/2e7f1355e5) Add property to skip cloning
* [`[e841229782]`](https://github.com/aspnet/AspNetCore/commit/e841229782) Verify and mirror external dependencies and self-consistent package versions (#566)
* [`[a2303c732f]`](https://github.com/aspnet/AspNetCore/commit/a2303c732f) Move tests to seperate app (#107)
* [`[bd750ad76d]`](https://github.com/aspnet/AspNetCore/commit/bd750ad76d) Making endpoints and addresses easier
* [`[602ca479b8]`](https://github.com/aspnet/AspNetCore/commit/602ca479b8) Checking if window.document defined before trying to resolve url
* [`[4f4fb174ea]`](https://github.com/aspnet/AspNetCore/commit/4f4fb174ea) Replacing 8-byte-long length prefix with varint
* [`[4a6c74f4f9]`](https://github.com/aspnet/AspNetCore/commit/4a6c74f4f9) Added ability to set prompt parameter in OpenIdConnectOptions (#1401)
* [`[44d08dcb2b]`](https://github.com/aspnet/AspNetCore/commit/44d08dcb2b) Add integration test
* [`[5fed462123]`](https://github.com/aspnet/AspNetCore/commit/5fed462123) Add tree dispatcher
* [`[144ee21696]`](https://github.com/aspnet/AspNetCore/commit/144ee21696) #1188 Add AuthenticationProperties to HandleRequestResult and RemoteFailureContext
* [`[321639b0eb]`](https://github.com/aspnet/AspNetCore/commit/321639b0eb) Add AuthenticationProperties to AuthenticateResult for failures.
* [`[551c1ebc0b]`](https://github.com/aspnet/AspNetCore/commit/551c1ebc0b) Configure enabled protocols per endpoint and add HTTP/2 w/ prior knowledge support (#2067).
* [`[f3bb4080b0]`](https://github.com/aspnet/AspNetCore/commit/f3bb4080b0) Use CustomAfterMicrosoftCommonTargets in dotnet-user-secrets
* [`[eeebefee1b]`](https://github.com/aspnet/AspNetCore/commit/eeebefee1b) Add data source
* [`[1158ffb3f0]`](https://github.com/aspnet/AspNetCore/commit/1158ffb3f0) Fix paths for task that only runs in CI
* [`[e17cdae046]`](https://github.com/aspnet/AspNetCore/commit/e17cdae046) Added overloads from 0-n arguments (#949)
* [`[bd8b4d86df]`](https://github.com/aspnet/AspNetCore/commit/bd8b4d86df) Port fix for #6875: Only set Content-Length when serving body (#6888)
* [`[231cbffe1a]`](https://github.com/aspnet/AspNetCore/commit/231cbffe1a) Create shared package folder for IIS Integration In-process. (#397)
* [`[000f9cb192]`](https://github.com/aspnet/AspNetCore/commit/000f9cb192) Initial support for websocket subprotocols (#933)
* [`[eb9417b577]`](https://github.com/aspnet/AspNetCore/commit/eb9417b577) Re-enable API Check
* [`[eeac99985a]`](https://github.com/aspnet/AspNetCore/commit/eeac99985a) Only set Content-Length when serving body (#6886)
* [`[49237c7651]`](https://github.com/aspnet/AspNetCore/commit/49237c7651) Add API check baselines for 2.0
* [`[562e0234d6]`](https://github.com/aspnet/AspNetCore/commit/562e0234d6) Add MVC 2.0 baselines
* [`[835ba2218a]`](https://github.com/aspnet/AspNetCore/commit/835ba2218a) Update API check baselines to 2.0
* [`[26255cc29c]`](https://github.com/aspnet/AspNetCore/commit/26255cc29c) Check for null before sending to a specific connection id (#935)
* [`[0267695656]`](https://github.com/aspnet/AspNetCore/commit/0267695656) Exceptions thrown during writing should close the connection
* [`[7685e17e80]`](https://github.com/aspnet/AspNetCore/commit/7685e17e80) Add Addresses and link generation
* [`[65cd41dbf5]`](https://github.com/aspnet/AspNetCore/commit/65cd41dbf5) Block POST requests for websocket connections (#934)
* [`[6687f4eefc]`](https://github.com/aspnet/AspNetCore/commit/6687f4eefc) Update API check baselines to 2.0
* [`[5abcfe7e3d]`](https://github.com/aspnet/AspNetCore/commit/5abcfe7e3d) Update API check baselines to 2.0
* [`[1686878035]`](https://github.com/aspnet/AspNetCore/commit/1686878035) Adding JS tests that send and receive structural objects
* [`[343ce0f01b]`](https://github.com/aspnet/AspNetCore/commit/343ce0f01b) HTTP/2: close connection with PROTOCOL_ERROR when a stream depends on itself.
* [`[8204f17234]`](https://github.com/aspnet/AspNetCore/commit/8204f17234) Add latest runtime packages
* [`[d1cca77852]`](https://github.com/aspnet/AspNetCore/commit/d1cca77852) Update API Check baselines to 2.0.0
* [`[13fdbac48f]`](https://github.com/aspnet/AspNetCore/commit/13fdbac48f)  #942 Add the SignedOutCallbackRedirect event for OIDC
* [`[83c3ac62fb]`](https://github.com/aspnet/AspNetCore/commit/83c3ac62fb) Updated formatters to wrap exceptions in InputFormatException for invalid input
* [`[475712d613]`](https://github.com/aspnet/AspNetCore/commit/475712d613) Update API Check baselines
* [`[f24d71136a]`](https://github.com/aspnet/AspNetCore/commit/f24d71136a) Add breaking changes file
* [`[a8eda83222]`](https://github.com/aspnet/AspNetCore/commit/a8eda83222) Add MVC 2.0 baselines
* [`[464fc8a15f]`](https://github.com/aspnet/AspNetCore/commit/464fc8a15f) Update Default.cshtml
* [`[41f26dc69d]`](https://github.com/aspnet/AspNetCore/commit/41f26dc69d) Add endpoint disambiguation
* [`[38712609bb]`](https://github.com/aspnet/AspNetCore/commit/38712609bb) Design extensibility for executors
* [`[5d1603c37f]`](https://github.com/aspnet/AspNetCore/commit/5d1603c37f) Replace ProblemDetailsAttribute with ApiControllerAttribute
* [`[97fab8711a]`](https://github.com/aspnet/AspNetCore/commit/97fab8711a) Add UnprocessableEntityResult, UnprocessableEntityObjectResult and ControllerBase.UnprocessableEntity methods (#6851)
* [`[197ef139d6]`](https://github.com/aspnet/AspNetCore/commit/197ef139d6) Provide a way within the Page/PageModel to run code before any handler runs
* [`[27a3a89b60]`](https://github.com/aspnet/AspNetCore/commit/27a3a89b60) Simplifying ApplicationLifetime.ExecuteHandlers() (#1228)
* [`[236ef5d1d1]`](https://github.com/aspnet/AspNetCore/commit/236ef5d1d1) Support validation and BindBehavior on top-level action parameters and bound properties. Fixes #6790
* [`[4db78685dc]`](https://github.com/aspnet/AspNetCore/commit/4db78685dc) camelCasing objects serialized by JsonHubProtocol
* [`[6ed3f6d1aa]`](https://github.com/aspnet/AspNetCore/commit/6ed3f6d1aa) Enabling hub connection with customized hub protocols
* [`[786980bc3f]`](https://github.com/aspnet/AspNetCore/commit/786980bc3f) add names to EventIds used by logger extensions (#927)
* [`[0fae663b9a]`](https://github.com/aspnet/AspNetCore/commit/0fae663b9a) Update WebApplicationTestFixture.cs
* [`[126901a08f]`](https://github.com/aspnet/AspNetCore/commit/126901a08f) Adding default ctors for HubProtocols
* [`[ba25dee141]`](https://github.com/aspnet/AspNetCore/commit/ba25dee141) Enabling customizing serialization settings in MessagePack protocol
* [`[a96fb68690]`](https://github.com/aspnet/AspNetCore/commit/a96fb68690) Fixed FileExtensionsAttributeAdapter to trim(whitespaces, dot character) and lowercase the extensions
* [`[e3533885a8]`](https://github.com/aspnet/AspNetCore/commit/e3533885a8) HTTP/2: close connection with PROTOCOL_ERROR when receiving a frame with an even stream ID.
* [`[a4887f4caf]`](https://github.com/aspnet/AspNetCore/commit/a4887f4caf) HTTP/2: close connection with PROTOCOL_ERROR when receiving GOAWAY frame with non-zero stream ID.
* [`[fc56552b2a]`](https://github.com/aspnet/AspNetCore/commit/fc56552b2a) HTTP/2: close connection on PING frame with non-zero stream ID.
* [`[555a881cb7]`](https://github.com/aspnet/AspNetCore/commit/555a881cb7) HTTP/2: close connection with PROTOCOL_ERROR when an unknown frame type is interleaved with headers.
* [`[e2af346733]`](https://github.com/aspnet/AspNetCore/commit/e2af346733) HTTP/2: close the connection with PROTOCOL_ERROR when a PUSH_PROMISE frame is received.
* [`[7f214492b8]`](https://github.com/aspnet/AspNetCore/commit/7f214492b8) Introduce a filter to send bad request results with details when ModelState is invalid (#6849)
* [`[ed827c0012]`](https://github.com/aspnet/AspNetCore/commit/ed827c0012) Fix bug in test data
* [`[d652b86852]`](https://github.com/aspnet/AspNetCore/commit/d652b86852) Split RVD in twain
* [`[cad2fb7c9f]`](https://github.com/aspnet/AspNetCore/commit/cad2fb7c9f) Rider directory added to gitignore.
* [`[f71e31a1cd]`](https://github.com/aspnet/AspNetCore/commit/f71e31a1cd) Fix the double buffer rent/free (#921)
* [`[6af6dde460]`](https://github.com/aspnet/AspNetCore/commit/6af6dde460) Fix unexpected failures in CopyPackagesToSplitFolders when files exists
* [`[20d4d70cc7]`](https://github.com/aspnet/AspNetCore/commit/20d4d70cc7) lowercasing event names
* [`[f87c9d9fb5]`](https://github.com/aspnet/AspNetCore/commit/f87c9d9fb5) Increase the minimum download timeout
* [`[34e10f7b2c]`](https://github.com/aspnet/AspNetCore/commit/34e10f7b2c) Add additional repositories that are being patched
* [`[5ca089e33e]`](https://github.com/aspnet/AspNetCore/commit/5ca089e33e) Enabling multiple callbacks for HubConnection.onClose
* [`[2e540341db]`](https://github.com/aspnet/AspNetCore/commit/2e540341db) Adds in-process mode to ANCM. (#152)
* [`[8b112a9548]`](https://github.com/aspnet/AspNetCore/commit/8b112a9548) Fix bug in external version verification causing Private=true to apply to all versions of that external dependency
* [`[e3c7e23cc4]`](https://github.com/aspnet/AspNetCore/commit/e3c7e23cc4) Logging#543 Reorder request disposal due to logging.
* [`[4e9a7be7dd]`](https://github.com/aspnet/AspNetCore/commit/4e9a7be7dd) SignalR Core Logging (#889)
* [`[8922f69532]`](https://github.com/aspnet/AspNetCore/commit/8922f69532) Mirror external dependencies
* [`[951dc99d5b]`](https://github.com/aspnet/AspNetCore/commit/951dc99d5b) Verify external dependencies (#561)
* [`[72598ad07c]`](https://github.com/aspnet/AspNetCore/commit/72598ad07c) Update env checked to see if TeamCity cloned the source
* [`[22ef9c3feb]`](https://github.com/aspnet/AspNetCore/commit/22ef9c3feb) Don't clone repositories when TC is configured to clone them
* [`[1468bb7afd]`](https://github.com/aspnet/AspNetCore/commit/1468bb7afd) Update the list of packages patching in 2.0.x
* [`[a94e4df01a]`](https://github.com/aspnet/AspNetCore/commit/a94e4df01a) Update the list of packages patching in 2.0.x
* [`[e0ab3ddcca]`](https://github.com/aspnet/AspNetCore/commit/e0ab3ddcca) Update the list of packages patching in 2.0.x
* [`[cb7540bd40]`](https://github.com/aspnet/AspNetCore/commit/cb7540bd40) Add aspnet/Security to the 2.0.x patch
* [`[95c10050c9]`](https://github.com/aspnet/AspNetCore/commit/95c10050c9) Stop using obsolete version of AddScheme in test
* [`[648bb1e810]`](https://github.com/aspnet/AspNetCore/commit/648bb1e810) Obsolete old AddSchemes
* [`[9687079723]`](https://github.com/aspnet/AspNetCore/commit/9687079723) Check if HTTP/2 frame writer has already been aborted.
* [`[9944c0fd43]`](https://github.com/aspnet/AspNetCore/commit/9944c0fd43) Fix reading DATA frames with maximum length.
* [`[c8f9364e3e]`](https://github.com/aspnet/AspNetCore/commit/c8f9364e3e) Expose connection features to HTTP/2 connections.
* [`[f7968714a9]`](https://github.com/aspnet/AspNetCore/commit/f7968714a9) Increase minimum required version of visual studio to 15.3.0 (#6856)
* [`[a7fb243501]`](https://github.com/aspnet/AspNetCore/commit/a7fb243501) Added typed HubContext
* [`[cf141cf119]`](https://github.com/aspnet/AspNetCore/commit/cf141cf119) Create new template engine when version changes
* [`[d2b202377f]`](https://github.com/aspnet/AspNetCore/commit/d2b202377f) Add Microsoft.VisualStudio.Text.Data and UI to the universe lineup.
* [`[1e1e89b457]`](https://github.com/aspnet/AspNetCore/commit/1e1e89b457) logging/#543 Clear HttpContext.User when the user is disposed.
* [`[1367a5d385]`](https://github.com/aspnet/AspNetCore/commit/1367a5d385) Make all handlers public
* [`[ac36121f26]`](https://github.com/aspnet/AspNetCore/commit/ac36121f26) Update README
* [`[127d23a022]`](https://github.com/aspnet/AspNetCore/commit/127d23a022) Parse LanguageVersion correctly
* [`[f23ff9452c]`](https://github.com/aspnet/AspNetCore/commit/f23ff9452c) [Design] Create Template engine from project snapshot
* [`[bee9fcb0d8]`](https://github.com/aspnet/AspNetCore/commit/bee9fcb0d8) Adding support for multiple callbacks per client side method
* [`[cca1480f3a]`](https://github.com/aspnet/AspNetCore/commit/cca1480f3a) Switch from feature/x to rel/x branches
* [`[f0a5af2ba7]`](https://github.com/aspnet/AspNetCore/commit/f0a5af2ba7) Revisit the unwrapping code in ControllerActionInvoker Fixes #6679
* [`[241880eadc]`](https://github.com/aspnet/AspNetCore/commit/241880eadc) Minor improvements (#1403)
* [`[96bd2769d0]`](https://github.com/aspnet/AspNetCore/commit/96bd2769d0) Improvements to the testing package.
* [`[6e6a24cbb4]`](https://github.com/aspnet/AspNetCore/commit/6e6a24cbb4) Add a background listener for notifications
* [`[48d97bf271]`](https://github.com/aspnet/AspNetCore/commit/48d97bf271) Turned Stream into StreamAsync (#902)
* [`[177fa71634]`](https://github.com/aspnet/AspNetCore/commit/177fa71634) Copy packages to ship/noship and verify coherent versions (#560)
* [`[72eb546329]`](https://github.com/aspnet/AspNetCore/commit/72eb546329) Added attribute adapter for DataAnnotation's FileExtensionsAttribute
* [`[fd9cb08790]`](https://github.com/aspnet/AspNetCore/commit/fd9cb08790) Add Switch.Microsoft.AspNetCore.Mvc.UseDateTimeTypeForDateTimeOffset quirks mode - patch recipients can use switch to undo the #6648 fix
* [`[6041c6b966]`](https://github.com/aspnet/AspNetCore/commit/6041c6b966) Auto-select `type="text"` for `DateTimeOffset` values - cherry-picked from 7e4a8fe in dev - #6648 - a different take on #4871 - `DateTime` can also round-trip `DateTimeKind.UTC` with `[DataType("datetimeoffset")]` or `[UIHint("datetimeoffset")]` - since they're now handled differently by default, add more `DateTime` tests - expand tests involving `Html5DateRenderingMode.CurrentCulture`
* [`[91eb4cd54c]`](https://github.com/aspnet/AspNetCore/commit/91eb4cd54c) Fix flakiness in KeepAliveTimeoutTests.ConnectionKeptAliveBetweenRequests (#1684).
* [`[1470ee0658]`](https://github.com/aspnet/AspNetCore/commit/1470ee0658) Updating toolset compiler (#2052)
* [`[9f5e4eb483]`](https://github.com/aspnet/AspNetCore/commit/9f5e4eb483) Allow "page" route parameter to be used in Mvc controllers
* [`[37e122a0c6]`](https://github.com/aspnet/AspNetCore/commit/37e122a0c6) Added overloads without the HostingContext (#1220)
* [`[47287c508e]`](https://github.com/aspnet/AspNetCore/commit/47287c508e) Added new extension methods to configure all MVC localization services [Fixes #5436] Must call `AddViewLocalization()` to use `IStringLocalizer<T>` in an application
* [`[23b7d8f62a]`](https://github.com/aspnet/AspNetCore/commit/23b7d8f62a) Added RequestFormLimits filter. [Fixes #5128] Overriding Request Form max upload limit
* [`[46dadbb186]`](https://github.com/aspnet/AspNetCore/commit/46dadbb186) Make RegistryPolicyResolver an interface to fix 3d party DI (#275)
* [`[83adfd2484]`](https://github.com/aspnet/AspNetCore/commit/83adfd2484) Find commit hashes from the TeamCity environment variables
* [`[712c992ca8]`](https://github.com/aspnet/AspNetCore/commit/712c992ca8) Add BackgroundService, a base class for long running HostedServices (#1215)
* [`[a93e4be82f]`](https://github.com/aspnet/AspNetCore/commit/a93e4be82f) Added Cancellation support (#897)
* [`[e114911d77]`](https://github.com/aspnet/AspNetCore/commit/e114911d77) Introduce [ApiController]
* [`[8697f2b271]`](https://github.com/aspnet/AspNetCore/commit/8697f2b271) Update package feeds and dependencies for 2.0.1  (#6843)
* [`[9b53da7333]`](https://github.com/aspnet/AspNetCore/commit/9b53da7333) Update package feeds and dependencies for 2.0.1  (#203)
* [`[77cac3b6be]`](https://github.com/aspnet/AspNetCore/commit/77cac3b6be) Update package feeds and dependencies for 2.0.1  (#1284)
* [`[c09575dbd0]`](https://github.com/aspnet/AspNetCore/commit/c09575dbd0) Fix #4914 patternize filter overrides
* [`[500668619f]`](https://github.com/aspnet/AspNetCore/commit/500668619f) Detect duplicate startups in HostingStartupAssemblies (#1183)
* [`[b3aa691549]`](https://github.com/aspnet/AspNetCore/commit/b3aa691549) Add EnableRangeProcessingSwitch for FileContentResult and Fil… (#6839)
* [`[20b07a0dff]`](https://github.com/aspnet/AspNetCore/commit/20b07a0dff) Adding README to npm module
* [`[134096d9cb]`](https://github.com/aspnet/AspNetCore/commit/134096d9cb) Relayer implementation
* [`[997be52987]`](https://github.com/aspnet/AspNetCore/commit/997be52987) Add repos that should be patched due to cascading versions
* [`[479e37d7cc]`](https://github.com/aspnet/AspNetCore/commit/479e37d7cc) Include Identity in the list of repos that are being patched
* [`[a0547c7b9f]`](https://github.com/aspnet/AspNetCore/commit/a0547c7b9f) Generate a file that contains all of the dependencies and their versions
* [`[c13cef6a74]`](https://github.com/aspnet/AspNetCore/commit/c13cef6a74) Injecting IViewLocalizer into Razor Page causing IndexOutOfRangeException
* [`[982ac32fea]`](https://github.com/aspnet/AspNetCore/commit/982ac32fea) Prepending relative urls with '/'
* [`[4220c516bc]`](https://github.com/aspnet/AspNetCore/commit/4220c516bc) Ensure PackageReference versions are consistent with artifacts that will be produced
* [`[d1d934e990]`](https://github.com/aspnet/AspNetCore/commit/d1d934e990) Add Microsoft.AspNetCore.DataProtection.AzureKeyVault package (#234)
* [`[d22bb2c908]`](https://github.com/aspnet/AspNetCore/commit/d22bb2c908) Add logger extensions with event ids (#405)
* [`[b9d9418f6d]`](https://github.com/aspnet/AspNetCore/commit/b9d9418f6d) Block SignInScheme = self
* [`[e42f6980b6]`](https://github.com/aspnet/AspNetCore/commit/e42f6980b6) Add Hub<T> Functional Tests (#891)
* [`[4841444d60]`](https://github.com/aspnet/AspNetCore/commit/4841444d60) Packages produced from dev branch should be alpha2 now
* [`[a43fb2271e]`](https://github.com/aspnet/AspNetCore/commit/a43fb2271e) Use artifact info to correctly analyze the packages produced from a repository
* [`[b40578b89b]`](https://github.com/aspnet/AspNetCore/commit/b40578b89b) Moving versions to alpha2
* [`[e05faf2347]`](https://github.com/aspnet/AspNetCore/commit/e05faf2347) Fix #1684 - CompletionProvider null ref
* [`[9a67ac5341]`](https://github.com/aspnet/AspNetCore/commit/9a67ac5341) Make sure socket closed is logged
* [`[776c2604f8]`](https://github.com/aspnet/AspNetCore/commit/776c2604f8) Introduce opinionated API defaults.
* [`[d28b413390]`](https://github.com/aspnet/AspNetCore/commit/d28b413390) Add tracing to KeepAliveTimeoutTests.ConnectionKeptAliveBetweenRequests to investigate test failures.
* [`[35a7146351]`](https://github.com/aspnet/AspNetCore/commit/35a7146351) Add Microsoft.Extensions.Hosting (#233)
* [`[b01072eb47]`](https://github.com/aspnet/AspNetCore/commit/b01072eb47) Use RouteTemplate and TemplateMatcher (#443)
* [`[52757943ac]`](https://github.com/aspnet/AspNetCore/commit/52757943ac) Backport improvements from dev branch to repo tasks
* [`[7bc3db1b29]`](https://github.com/aspnet/AspNetCore/commit/7bc3db1b29) Fix some markdown glitches. (#879)
* [`[9eb27fa53f]`](https://github.com/aspnet/AspNetCore/commit/9eb27fa53f) Stub out a task to validate cascading version effects (#557)
* [`[ae9da9290e]`](https://github.com/aspnet/AspNetCore/commit/ae9da9290e) #1163 Implement the generic host
* [`[1fef45db67]`](https://github.com/aspnet/AspNetCore/commit/1fef45db67) Start preparing list of repositories that need patching (#556)
* [`[037c1ec47d]`](https://github.com/aspnet/AspNetCore/commit/037c1ec47d) Make @inherit + Razor Pages + _ViewImports work
* [`[a267e86e1f]`](https://github.com/aspnet/AspNetCore/commit/a267e86e1f) Adding the 'final' suffix to version
* [`[35601f95b3]`](https://github.com/aspnet/AspNetCore/commit/35601f95b3) Added a model binder for handling Enum types. [Fixes #6329] Why don't we check for Enum.IsDefined on action parameters of enum type
* [`[db2d9ee56f]`](https://github.com/aspnet/AspNetCore/commit/db2d9ee56f) Additional fixes for #4604
* [`[9db92dc6a7]`](https://github.com/aspnet/AspNetCore/commit/9db92dc6a7) JsonResultExecuter logs type of result. - MvcJsonLoggerExtensions.JsonResultExecuting logs result type instead of value - Nulls handled more elegantly. - Two tests added to JsonResultExecutorTests.cs. - #4604
* [`[da7bc24eec]`](https://github.com/aspnet/AspNetCore/commit/da7bc24eec) Add request parsing regression tests.
* [`[0120dae36b]`](https://github.com/aspnet/AspNetCore/commit/0120dae36b) Jhkim/updatetest (#155)
* [`[db397d812b]`](https://github.com/aspnet/AspNetCore/commit/db397d812b) TagHelperOutput extension methods for class value manipulation (#6565)
* [`[d226b20756]`](https://github.com/aspnet/AspNetCore/commit/d226b20756) Rename With/GetTransportType to With/GetTransport
* [`[72568acff0]`](https://github.com/aspnet/AspNetCore/commit/72568acff0) Appending version to browser javascript file names
* [`[1453f419a8]`](https://github.com/aspnet/AspNetCore/commit/1453f419a8) MessagePack Serialization fixes
* [`[4f18d99d02]`](https://github.com/aspnet/AspNetCore/commit/4f18d99d02) Added RedirectToAction overload with no arguments
* [`[5eae687ddd]`](https://github.com/aspnet/AspNetCore/commit/5eae687ddd) Updated EnableCorsAttribute and UseCors extension to not have to supply a policy name.
* [`[06f6de6c11]`](https://github.com/aspnet/AspNetCore/commit/06f6de6c11) Changed RequestSizeLimitAttribute to create an authorization filter rather than a resource filter. [Fixes #6777] RequestSizeLimit is ignored
* [`[2d4b2239a9]`](https://github.com/aspnet/AspNetCore/commit/2d4b2239a9) Reduce C# client logging and add HubProtocol log (#857)
* [`[c5f59e06c3]`](https://github.com/aspnet/AspNetCore/commit/c5f59e06c3) Added new test scenarios for websocket (#153)
* [`[135e1c248d]`](https://github.com/aspnet/AspNetCore/commit/135e1c248d) Use PackageLineup to manage PackageReference versions
* [`[7cca8618ea]`](https://github.com/aspnet/AspNetCore/commit/7cca8618ea) Change notifications for the project manager
* [`[de38922601]`](https://github.com/aspnet/AspNetCore/commit/de38922601) Allow BindPropertyAttribute to be applied on PageModel
* [`[1f596e127b]`](https://github.com/aspnet/AspNetCore/commit/1f596e127b) When the CI system supplies a .deps dir, use that as the lineups/packages resource source
* [`[abd669849d]`](https://github.com/aspnet/AspNetCore/commit/abd669849d) Making MsgPack work in IE10
* [`[54c71c4c10]`](https://github.com/aspnet/AspNetCore/commit/54c71c4c10) Replacing Cache-Control header with nonce
* [`[67b2b27ac9]`](https://github.com/aspnet/AspNetCore/commit/67b2b27ac9) Enabling passing relative Url when creating connections
* [`[bb79a9760c]`](https://github.com/aspnet/AspNetCore/commit/bb79a9760c) Enabling creating HubConnection without HttpConnection
* [`[a732b106f5]`](https://github.com/aspnet/AspNetCore/commit/a732b106f5) Fix websocket close handshake issue and race condition when websocket client disconnect without close handshake (#151)
* [`[393ab6a4f0]`](https://github.com/aspnet/AspNetCore/commit/393ab6a4f0) Add extension method to get HttpContext on HubConnectionContext (#849)
* [`[509ddc6ced]`](https://github.com/aspnet/AspNetCore/commit/509ddc6ced) Adds ANCM in-process flag. (#144)
* [`[a9b47f6722]`](https://github.com/aspnet/AspNetCore/commit/a9b47f6722) Startup experience (#442)
* [`[63397653fa]`](https://github.com/aspnet/AspNetCore/commit/63397653fa) Make DefaultApiDescriptionProvider understand ActionResult<T>
* [`[6bf165f22f]`](https://github.com/aspnet/AspNetCore/commit/6bf165f22f) Update default Razor search paths to include ~/[PagesRoot]/Shared Fixes #6604
* [`[c39c1aaa38]`](https://github.com/aspnet/AspNetCore/commit/c39c1aaa38) Move 2.1 templates to netcoreapp2.0 until we use an SDK that supports netcoreapp2.1
* [`[8c0dd1d2cc]`](https://github.com/aspnet/AspNetCore/commit/8c0dd1d2cc) Fix for CI agents having extra template package already installed
* [`[fea0db3814]`](https://github.com/aspnet/AspNetCore/commit/fea0db3814) Renamed private fields according to coding guidelinesù
* [`[b38f0dbc7a]`](https://github.com/aspnet/AspNetCore/commit/b38f0dbc7a) Change tests to use 2.0 templates until SDK is updated
* [`[56fdcad4d5]`](https://github.com/aspnet/AspNetCore/commit/56fdcad4d5) Also uninstall the 2.0 template package when reinstalling for tests
* [`[148e4af837]`](https://github.com/aspnet/AspNetCore/commit/148e4af837) Make template package uninstallation detection report errors properly
* [`[cb500fe3b8]`](https://github.com/aspnet/AspNetCore/commit/cb500fe3b8) Account for non-installed templates when preparing test run
* [`[ee009982dc]`](https://github.com/aspnet/AspNetCore/commit/ee009982dc) Add KeyVault encryption to DataProtection (#273)
* [`[5eeee55b13]`](https://github.com/aspnet/AspNetCore/commit/5eeee55b13) Add missing content files for Microsoft.DotNet.Web.ProjectTemplates.2.1
* [`[75f955a60a]`](https://github.com/aspnet/AspNetCore/commit/75f955a60a) Fix Coherence 2.0.x refs
* [`[df699bf7b2]`](https://github.com/aspnet/AspNetCore/commit/df699bf7b2) Update all SPA projects to use 2.1.x dependencies
* [`[28ed6ea7d8]`](https://github.com/aspnet/AspNetCore/commit/28ed6ea7d8) Simplify template dependency configuration
* [`[a6c2a458da]`](https://github.com/aspnet/AspNetCore/commit/a6c2a458da) Change 2.1 template dependencies to easily-updatable external value
* [`[98d6e2a1b6]`](https://github.com/aspnet/AspNetCore/commit/98d6e2a1b6) Add new Microsoft.DotNet.Web.ProjectTemplates.2.1 package, taking contents from dotnet/templating
* [`[692faf10ac]`](https://github.com/aspnet/AspNetCore/commit/692faf10ac) Correct all the 2.0 projects to reference 2.0 dependencies, not 2.1.0-*
* [`[39b3be4515]`](https://github.com/aspnet/AspNetCore/commit/39b3be4515) Add Microsoft.DotNet.Web.Client.ItemTemplates package copied from dotnet/templating repo
* [`[cd93041f76]`](https://github.com/aspnet/AspNetCore/commit/cd93041f76) Simplify substitution logic by removing need for string parsing
* [`[1e465e9643]`](https://github.com/aspnet/AspNetCore/commit/1e465e9643) Improve timeout logic
* [`[a8b7904b00]`](https://github.com/aspnet/AspNetCore/commit/a8b7904b00) Fix logger category of FileStreamResultExecutor
* [`[6cf4cbd736]`](https://github.com/aspnet/AspNetCore/commit/6cf4cbd736) Minor clarification to SPA test code
* [`[66d8e8198d]`](https://github.com/aspnet/AspNetCore/commit/66d8e8198d) Re-enable TestKeepAliveTimeout.
* [`[62bbe943e8]`](https://github.com/aspnet/AspNetCore/commit/62bbe943e8) Make sure long polling transport can survive http client timeout
* [`[3beb310866]`](https://github.com/aspnet/AspNetCore/commit/3beb310866) Avoid saving TempData in case of unhandled exceptions. [Fixes #6598] BUG? Accessing TempData prevent response to have content on error.
* [`[5ee4c8ec4d]`](https://github.com/aspnet/AspNetCore/commit/5ee4c8ec4d) Add [ForegroundTheory]
* [`[717f1e6f7d]`](https://github.com/aspnet/AspNetCore/commit/717f1e6f7d) Normalize paths in RazorViewEngine prior to invoking page factory Fixes #6672
* [`[9e614b6cc7]`](https://github.com/aspnet/AspNetCore/commit/9e614b6cc7) Initializing HubOptions.JsonSerializationSettings to default settings
* [`[b4c61b6c2d]`](https://github.com/aspnet/AspNetCore/commit/b4c61b6c2d) Client side method names should be case insensitive
* [`[09317b83a8]`](https://github.com/aspnet/AspNetCore/commit/09317b83a8) SPA templates have now moved to the aspnet/templating repo
* [`[a7cc243942]`](https://github.com/aspnet/AspNetCore/commit/a7cc243942) Introduce ProblemDescription
* [`[151cf44607]`](https://github.com/aspnet/AspNetCore/commit/151cf44607) Introduce ActionResult<T>
* [`[f0ade24cf7]`](https://github.com/aspnet/AspNetCore/commit/f0ade24cf7) Updating to new toolset compiler. (#2043)
* [`[00dc95098f]`](https://github.com/aspnet/AspNetCore/commit/00dc95098f) Update our diagnostics window
* [`[bac68ba3c2]`](https://github.com/aspnet/AspNetCore/commit/bac68ba3c2) Injecting IViewLocalizer into Razor Page causing IndexOutOfRangeException
* [`[67f255adca]`](https://github.com/aspnet/AspNetCore/commit/67f255adca) Change completion provider to be lazy if not Razor.
* [`[ca844afe5a]`](https://github.com/aspnet/AspNetCore/commit/ca844afe5a) Add a subsystem for detecting versions
* [`[2cc72d72cd]`](https://github.com/aspnet/AspNetCore/commit/2cc72d72cd) Logging traffic at Trace level
* [`[9174ca79fa]`](https://github.com/aspnet/AspNetCore/commit/9174ca79fa) Test both dev and published apps
* [`[0f51c56c3f]`](https://github.com/aspnet/AspNetCore/commit/0f51c56c3f) Combine ExpandoObjectAdapter and DictionaryAdapter (#106)
* [`[7e4a8fe479]`](https://github.com/aspnet/AspNetCore/commit/7e4a8fe479) Auto-select `type="text"` for `DateTimeOffset` values - #6648 - a different take on #4871 - `DateTime` can also round-trip `DateTimeKind.UTC` with `[DataType("datetimeoffset")]` or `[UIHint("datetimeoffset")]` - since they're now handled differently by default, add more `DateTime` tests - expand tests involving `Html5DateRenderingMode.CurrentCulture`
* [`[6c4c13a454]`](https://github.com/aspnet/AspNetCore/commit/6c4c13a454) Add back Identity service packages to the meta package
* [`[65e09f1cc6]`](https://github.com/aspnet/AspNetCore/commit/65e09f1cc6) Relax timeouts (#103)
* [`[8b30efbe75]`](https://github.com/aspnet/AspNetCore/commit/8b30efbe75) Use chained configuration
* [`[ceff4bd7da]`](https://github.com/aspnet/AspNetCore/commit/ceff4bd7da) Exceptions from user's event handlers should be caught and logged
* [`[0155cf2c73]`](https://github.com/aspnet/AspNetCore/commit/0155cf2c73) Fix inherits directive description.
* [`[61260ddf1c]`](https://github.com/aspnet/AspNetCore/commit/61260ddf1c) Add basic Razor directive completion.
* [`[9f88d16cc4]`](https://github.com/aspnet/AspNetCore/commit/9f88d16cc4) Only run browser automation tests if host OS supports it
* [`[eece782496]`](https://github.com/aspnet/AspNetCore/commit/eece782496) Make template nuspecs consistent. Include SPA template packages projects in solution.
* [`[039de8cd13]`](https://github.com/aspnet/AspNetCore/commit/039de8cd13) Copy SPA template packages from aspnet/javascriptservices repo
* [`[68889167bd]`](https://github.com/aspnet/AspNetCore/commit/68889167bd) Rename version.xml => version.props
* [`[d3ae3abe2a]`](https://github.com/aspnet/AspNetCore/commit/d3ae3abe2a) Use PackageLineup to manage PackageReference versions
* [`[6b2ccdead8]`](https://github.com/aspnet/AspNetCore/commit/6b2ccdead8) Add sample to "select" an address and generate a URL (#434)
* [`[fbacee2621]`](https://github.com/aspnet/AspNetCore/commit/fbacee2621) Report package versions to TeamCity
* [`[0840b4a1b1]`](https://github.com/aspnet/AspNetCore/commit/0840b4a1b1) Disable FTP tests
* [`[ac2fe035c2]`](https://github.com/aspnet/AspNetCore/commit/ac2fe035c2) EF rename
* [`[cd10d7e122]`](https://github.com/aspnet/AspNetCore/commit/cd10d7e122) Fixing csproj
* [`[daec40f2ba]`](https://github.com/aspnet/AspNetCore/commit/daec40f2ba) Add support for cross-publishing
* [`[305ab1fa4c]`](https://github.com/aspnet/AspNetCore/commit/305ab1fa4c) 1.0, 1.1 template tests (#100)
* [`[0dde7b1a27]`](https://github.com/aspnet/AspNetCore/commit/0dde7b1a27) Patch 2.0.1
* [`[29ad3d1dd6]`](https://github.com/aspnet/AspNetCore/commit/29ad3d1dd6) Adding third-party-notices.txt for msgpack5
* [`[ec18f7a1cb]`](https://github.com/aspnet/AspNetCore/commit/ec18f7a1cb) Close the ClientSample app when connection closed (#805)
* [`[7418785a5e]`](https://github.com/aspnet/AspNetCore/commit/7418785a5e) Fix WebSocket race in E2E test (#809)
* [`[8ec2848646]`](https://github.com/aspnet/AspNetCore/commit/8ec2848646) AllExcept for Dynamic and Typed Hubs (#796)
* [`[32d5391ff0]`](https://github.com/aspnet/AspNetCore/commit/32d5391ff0) Moved GetDesiredIndentation to a new service
* [`[f31e5ad42a]`](https://github.com/aspnet/AspNetCore/commit/f31e5ad42a) Updating signalr-client module version
* [`[ebd0baa458]`](https://github.com/aspnet/AspNetCore/commit/ebd0baa458) Add dispatcher packages
* [`[7dcbf25069]`](https://github.com/aspnet/AspNetCore/commit/7dcbf25069) Headers for TS files (#798)
* [`[5dceaa8149]`](https://github.com/aspnet/AspNetCore/commit/5dceaa8149) Adding Microsoft.AspNetCore.SignalR.Client
* [`[36acebf9fb]`](https://github.com/aspnet/AspNetCore/commit/36acebf9fb) Renaming Microsoft.AspNetCore.SignalR.Client to Microsoft.AspNetCore.SignalR.Client.Core
* [`[521eed1438]`](https://github.com/aspnet/AspNetCore/commit/521eed1438) Renaming Microsoft.AspNetCore.SignalR.Http to Microsoft.AspNetCore.SignalR
* [`[fa1f7f0b13]`](https://github.com/aspnet/AspNetCore/commit/fa1f7f0b13) Renaming Microsoft.AspNetCore.SignalR to Microsoft.AspNetCore.SignalR.Core
* [`[f6f8c15f2e]`](https://github.com/aspnet/AspNetCore/commit/f6f8c15f2e) Suppress API Check for the MVC 1.X shim
* [`[257d202a14]`](https://github.com/aspnet/AspNetCore/commit/257d202a14) Make AddMvcCore docs scarier
* [`[7db480b23e]`](https://github.com/aspnet/AspNetCore/commit/7db480b23e) Changing the way users can enable logging
* [`[370bc7d7c5]`](https://github.com/aspnet/AspNetCore/commit/370bc7d7c5) Use PackageLineup to manage PackageReference versions
* [`[a0269fb0ad]`](https://github.com/aspnet/AspNetCore/commit/a0269fb0ad) Use PackageLineup to manage PackageReference versions
* [`[ae925049bb]`](https://github.com/aspnet/AspNetCore/commit/ae925049bb) Add an example
* [`[d8431067a5]`](https://github.com/aspnet/AspNetCore/commit/d8431067a5) Add TaskSchedulers to the dispatcher abstraction
* [`[c94c110de3]`](https://github.com/aspnet/AspNetCore/commit/c94c110de3) Move dispatcher to workspaces.
* [`[16c267d95e]`](https://github.com/aspnet/AspNetCore/commit/16c267d95e) House Cleaning - Spelling and grammar :shower:
* [`[b8d2d24b67]`](https://github.com/aspnet/AspNetCore/commit/b8d2d24b67) Log connection resets as trace not error (#799)
* [`[6b8449f491]`](https://github.com/aspnet/AspNetCore/commit/6b8449f491) Sortable log files with stdoutLogFile (#131)
* [`[378c93e7d6]`](https://github.com/aspnet/AspNetCore/commit/378c93e7d6) Also inject EntityFramework package versions dynamically
* [`[1e8a22dae3]`](https://github.com/aspnet/AspNetCore/commit/1e8a22dae3) NameValueHeaderValue Escaping/Unescaping quoted-strings and helpers (#913)
* [`[18dee25eb9]`](https://github.com/aspnet/AspNetCore/commit/18dee25eb9) In tests, use dynamic port binding to avoid need for any coordination across simultaneous tests
* [`[5cb11b9bf4]`](https://github.com/aspnet/AspNetCore/commit/5cb11b9bf4) Implmement a project system for Razor
* [`[b811e69d00]`](https://github.com/aspnet/AspNetCore/commit/b811e69d00) Use PackageLineup to manage PackageReference versions
* [`[9d14573df1]`](https://github.com/aspnet/AspNetCore/commit/9d14573df1) Add NuGet.Frameworks to the universe lineup
* [`[12e9430d89]`](https://github.com/aspnet/AspNetCore/commit/12e9430d89) Sets the default cookie secure policy to None
* [`[b82200851f]`](https://github.com/aspnet/AspNetCore/commit/b82200851f) Do not re-discover runtime compiled RazorPage files for precompiled Razor Pages.
* [`[a53bf093a7]`](https://github.com/aspnet/AspNetCore/commit/a53bf093a7) Use PackageLineup to manage PackageReference versions
* [`[b2f9ad1b67]`](https://github.com/aspnet/AspNetCore/commit/b2f9ad1b67) Changed CookieTempDataProvider's CookieSecurePolicy from SameAsRequest to None
* [`[28172a3a3e]`](https://github.com/aspnet/AspNetCore/commit/28172a3a3e) Use PackageLineup to manage PackageReference versions
* [`[4b68a48f1d]`](https://github.com/aspnet/AspNetCore/commit/4b68a48f1d) Fix: Broken intellisense for extensible directives
* [`[dbb9262d68]`](https://github.com/aspnet/AspNetCore/commit/dbb9262d68) Test that we are running on specific runtime and using right version of store assemblies (#99)
* [`[b048577881]`](https://github.com/aspnet/AspNetCore/commit/b048577881) Add System.Net.Http to the universe lineup
* [`[b12683a35d]`](https://github.com/aspnet/AspNetCore/commit/b12683a35d) Mark trailing whitespace after type name in directives as markup
* [`[e5825641ce]`](https://github.com/aspnet/AspNetCore/commit/e5825641ce) Use PackageLineup to manage PackageReference versions
* [`[9c78b5a8be]`](https://github.com/aspnet/AspNetCore/commit/9c78b5a8be) Use PackageLineup to manage PackageReference versions
* [`[e7743cbb78]`](https://github.com/aspnet/AspNetCore/commit/e7743cbb78) Shorter LibuvThread locks (#2034)
* [`[e155b81434]`](https://github.com/aspnet/AspNetCore/commit/e155b81434) Use PackageLineup to manage PackageReference versions
* [`[e87f13d267]`](https://github.com/aspnet/AspNetCore/commit/e87f13d267) Use PackageLineup to manage PackageReference versions
* [`[82ba6b51ef]`](https://github.com/aspnet/AspNetCore/commit/82ba6b51ef) Use PackageLineup to manage PackageReference versions
* [`[1297798546]`](https://github.com/aspnet/AspNetCore/commit/1297798546) Use PackageLineup to manage PackageReference versions
* [`[e67d85d30c]`](https://github.com/aspnet/AspNetCore/commit/e67d85d30c) Use PackageLineup to manage PackageReference versions
* [`[4601db9bf6]`](https://github.com/aspnet/AspNetCore/commit/4601db9bf6) Log requests into test logs, override directory targets (#98)
* [`[e97e6546c2]`](https://github.com/aspnet/AspNetCore/commit/e97e6546c2) Add structured syntax suffixes and facets to MediaTypeHeaderValue (#921)
* [`[5ca9f8928f]`](https://github.com/aspnet/AspNetCore/commit/5ca9f8928f) Use PackageLineup to manage PackageReference versions
* [`[482a4e646e]`](https://github.com/aspnet/AspNetCore/commit/482a4e646e) Rename 'template_feed' to 'src' for consistency with other repos
* [`[11377e08f6]`](https://github.com/aspnet/AspNetCore/commit/11377e08f6) Use PackageLineup to manage PackageReference versions
* [`[479eb49ca9]`](https://github.com/aspnet/AspNetCore/commit/479eb49ca9) Use PackageLineup to manage PackageReference versions
* [`[51ac8d53f4]`](https://github.com/aspnet/AspNetCore/commit/51ac8d53f4) Fix site name
* [`[1e0fe87c20]`](https://github.com/aspnet/AspNetCore/commit/1e0fe87c20) Use PackageLineup to manage PackageReference versions
* [`[9b45e7f118]`](https://github.com/aspnet/AspNetCore/commit/9b45e7f118) Use PackageLineup to manage PackageReference versions
* [`[590d42dc88]`](https://github.com/aspnet/AspNetCore/commit/590d42dc88) Add Microsoft.Win32.Registry to the universe lineup
* [`[b53a6f9a25]`](https://github.com/aspnet/AspNetCore/commit/b53a6f9a25) Install site extension on top of existing dotnet (#97)
* [`[cfc05104e4]`](https://github.com/aspnet/AspNetCore/commit/cfc05104e4) Updated to use WebEncoders utility's Base64Url encode/decode functionality
* [`[bf685de16b]`](https://github.com/aspnet/AspNetCore/commit/bf685de16b) Using WebEncoders' Base64Url encode/decode functionality
* [`[03d40f712c]`](https://github.com/aspnet/AspNetCore/commit/03d40f712c) Initial state from previous aspnet/templates repo
* [`[f3d121cacf]`](https://github.com/aspnet/AspNetCore/commit/f3d121cacf) Mark whitespace between tag helper directive and its value as Markup
* [`[2a36aa141d]`](https://github.com/aspnet/AspNetCore/commit/2a36aa141d) Making the client and tests work on IE
* [`[ff2bf5ad75]`](https://github.com/aspnet/AspNetCore/commit/ff2bf5ad75) Creating ES5 version of the TS client
* [`[f63354713f]`](https://github.com/aspnet/AspNetCore/commit/f63354713f) Use PackageLineup to manage PackageReference versions
* [`[c0d47adb11]`](https://github.com/aspnet/AspNetCore/commit/c0d47adb11) Allow spaces in path (#779)
* [`[ac0ce9c8ee]`](https://github.com/aspnet/AspNetCore/commit/ac0ce9c8ee) Use PackageLineup to manage PackageReference versions (#162)
* [`[6907261453]`](https://github.com/aspnet/AspNetCore/commit/6907261453) Unset the UserAgent Header in the TS client (#781)
* [`[9e72cb0783]`](https://github.com/aspnet/AspNetCore/commit/9e72cb0783) Use PackageLineup to manage PackageReference versions
* [`[0516de2b28]`](https://github.com/aspnet/AspNetCore/commit/0516de2b28) Add Microsoft.Azure.Management.Fluent to the universe lineup (#550)
* [`[5e3a7922fe]`](https://github.com/aspnet/AspNetCore/commit/5e3a7922fe) Add module load location check (#94)
* [`[97b9ff3b33]`](https://github.com/aspnet/AspNetCore/commit/97b9ff3b33) Use PackageLineup to manage PackageReference versions
* [`[4917e69ad6]`](https://github.com/aspnet/AspNetCore/commit/4917e69ad6) Fixed spelling mistake
* [`[b60e598277]`](https://github.com/aspnet/AspNetCore/commit/b60e598277) Setting the User-Agent header (#759)
* [`[9d8556e7c4]`](https://github.com/aspnet/AspNetCore/commit/9d8556e7c4) Added FrameConnection.OnConnectionClosed back (#2028)
* [`[09be7c416a]`](https://github.com/aspnet/AspNetCore/commit/09be7c416a) Use preparsed version, rather than reparsing (#2021)
* [`[088f7e32ae]`](https://github.com/aspnet/AspNetCore/commit/088f7e32ae) Reset StatusCode & ReasonPhrase directly (#2025)
* [`[4735154ecd]`](https://github.com/aspnet/AspNetCore/commit/4735154ecd) Install .NET Core 1.1.2
* [`[1d4e7dcd08]`](https://github.com/aspnet/AspNetCore/commit/1d4e7dcd08) Avoid conflicts between PinVersion and lineups
* [`[ccc97c67ab]`](https://github.com/aspnet/AspNetCore/commit/ccc97c67ab) Making msgpack5 a prod dependency
* [`[1b5bd4afac]`](https://github.com/aspnet/AspNetCore/commit/1b5bd4afac) Added ParentIsTagHelper property to AttributeCompletionContext
* [`[471722eba1]`](https://github.com/aspnet/AspNetCore/commit/471722eba1) Use PackageLineup to manage PackageReference versions
* [`[347e4158fb]`](https://github.com/aspnet/AspNetCore/commit/347e4158fb) Skipped flakey tests.
* [`[ceba681e02]`](https://github.com/aspnet/AspNetCore/commit/ceba681e02) Add Microsoft.NETCore.App and NETStandard.Library to the lineup (#549)
* [`[a200cd46b1]`](https://github.com/aspnet/AspNetCore/commit/a200cd46b1) Use ForceAsyncAwaiter to make sure we're not on the app SyncContext (#758)
* [`[ca6c76c358]`](https://github.com/aspnet/AspNetCore/commit/ca6c76c358) Add a test where [Ignore..] gets overridden
* [`[c9c21d2ce9]`](https://github.com/aspnet/AspNetCore/commit/c9c21d2ce9) Fix tool reference update
* [`[8cc1cdc62f]`](https://github.com/aspnet/AspNetCore/commit/8cc1cdc62f) Install and use multiple runtimes/sdks (#93)
* [`[83f3605cfb]`](https://github.com/aspnet/AspNetCore/commit/83f3605cfb) Minification - part 1 (#762)
* [`[c7fabda615]`](https://github.com/aspnet/AspNetCore/commit/c7fabda615) Use installdotnet target and clear all nuget packages to force offline (#92)
* [`[04fe1204a9]`](https://github.com/aspnet/AspNetCore/commit/04fe1204a9) Rename app.module.(server|browser).ts to app.(server|browser).module.ts. Fixes #1228.
* [`[29fd1b3b33]`](https://github.com/aspnet/AspNetCore/commit/29fd1b3b33) Update README to show 2.0.0 as the latest packages
* [`[e2030fb1fa]`](https://github.com/aspnet/AspNetCore/commit/e2030fb1fa) Handle publicPath=/ in HMR. Fixes #1191.
* [`[7b2a4ff465]`](https://github.com/aspnet/AspNetCore/commit/7b2a4ff465) Allow "page" route parameter to be used in Mvc controllers
* [`[9793b6b8d5]`](https://github.com/aspnet/AspNetCore/commit/9793b6b8d5) Add another package required for Razor
* [`[9b1cbedffc]`](https://github.com/aspnet/AspNetCore/commit/9b1cbedffc) WebSocketClient.ConnectAsync throws when the provided CancellationToken is cancelled.
* [`[3d6a8615de]`](https://github.com/aspnet/AspNetCore/commit/3d6a8615de) Support DynamicObject types (#99)
* [`[59fe94b8e4]`](https://github.com/aspnet/AspNetCore/commit/59fe94b8e4) Setting up 2.0.1 branch
* [`[ce68ec23c0]`](https://github.com/aspnet/AspNetCore/commit/ce68ec23c0) Using WebEncoders' Base64Url encode/decode functionality
* [`[87189875ff]`](https://github.com/aspnet/AspNetCore/commit/87189875ff) Increase timeout in Server_ClientDisconnects_CallCanceled to mitigate test flakiness.
* [`[d15129110e]`](https://github.com/aspnet/AspNetCore/commit/d15129110e) Ensure .NET Core 1.0.5 is installed
* [`[7ca8255d6f]`](https://github.com/aspnet/AspNetCore/commit/7ca8255d6f) Add a default VS foregrounddispatcher
* [`[a9a86fa3bf]`](https://github.com/aspnet/AspNetCore/commit/a9a86fa3bf) Add foreground dispatcher
* [`[cddc5f8a75]`](https://github.com/aspnet/AspNetCore/commit/cddc5f8a75) Adapting TS-client to work with non-level-2 xhr
* [`[b187c1adc4]`](https://github.com/aspnet/AspNetCore/commit/b187c1adc4) Add fallback when resolving application name
* [`[d87e0f7fbd]`](https://github.com/aspnet/AspNetCore/commit/d87e0f7fbd) Fixes #1632 - track textviews in the document tracker
* [`[8b4fc0cef6]`](https://github.com/aspnet/AspNetCore/commit/8b4fc0cef6) Take control of VisualStudioRazorParser reparse test mechanics.
* [`[a145734d43]`](https://github.com/aspnet/AspNetCore/commit/a145734d43) Fix flakiness in ConnectionClosedWhenResponseDoesNotSatisfyMinimumDataRate (#1955).
* [`[4094e8b8f3]`](https://github.com/aspnet/AspNetCore/commit/4094e8b8f3) Use PackageReference instead of project.json in the VSIX project (#1642)
* [`[a702713cd4]`](https://github.com/aspnet/AspNetCore/commit/a702713cd4) SignalR C# Client logging (#752)
* [`[b8a936f2c1]`](https://github.com/aspnet/AspNetCore/commit/b8a936f2c1) Use IApplicationLifetime instead of IHostedService (#757)
* [`[c922eee1d6]`](https://github.com/aspnet/AspNetCore/commit/c922eee1d6) Fix artifacts dir for test
* [`[fa6fde2b20]`](https://github.com/aspnet/AspNetCore/commit/fa6fde2b20) Moved TagHelper directive validation and parsing from TagHelperBinder to CSharpCodeParser
* [`[9b6420dbfc]`](https://github.com/aspnet/AspNetCore/commit/9b6420dbfc) Include currently selected attribute in TagHelper completion results
* [`[28920c7691]`](https://github.com/aspnet/AspNetCore/commit/28920c7691) Simplify .gitignore
* [`[224c9898c0]`](https://github.com/aspnet/AspNetCore/commit/224c9898c0) Turn template test into theory (#90)
* [`[c62a3b491c]`](https://github.com/aspnet/AspNetCore/commit/c62a3b491c) Fix templates directory structure to produce correct nupkg output
* [`[e4c1b888ca]`](https://github.com/aspnet/AspNetCore/commit/e4c1b888ca) Adding loggers to TS client
* [`[978f5cebc0]`](https://github.com/aspnet/AspNetCore/commit/978f5cebc0) Starting HubOptions (#743)
* [`[1811c328c5]`](https://github.com/aspnet/AspNetCore/commit/1811c328c5) Add packages required for Razor to the lineup (#548)
* [`[0291686b20]`](https://github.com/aspnet/AspNetCore/commit/0291686b20) Reorganize templates into dir structure matching 'dotnet new' templates
* [`[964b671288]`](https://github.com/aspnet/AspNetCore/commit/964b671288) [Fixes #1012] Make it possible to override services when using UseStartup.
* [`[d72175a846]`](https://github.com/aspnet/AspNetCore/commit/d72175a846) Make StopAsync multi-thread safe (#377).
* [`[24154ec4c2]`](https://github.com/aspnet/AspNetCore/commit/24154ec4c2) Create a VisualStudio parser to handle the editing loop.
* [`[fa852d7d67]`](https://github.com/aspnet/AspNetCore/commit/fa852d7d67) Update hub route in client sample (#756)
* [`[d4b64af0e6]`](https://github.com/aspnet/AspNetCore/commit/d4b64af0e6) Use DictionaryKeyResolver for ExpandoObjectAdapter (#100)
* [`[419cedd4f7]`](https://github.com/aspnet/AspNetCore/commit/419cedd4f7) Updating spec for record separator, binary over text
* [`[cdbb13de66]`](https://github.com/aspnet/AspNetCore/commit/cdbb13de66) Putting signalr-client in @aspnet scope
* [`[6e42c8d0e4]`](https://github.com/aspnet/AspNetCore/commit/6e42c8d0e4) Made section 1.X compatibility only apply at design time.
* [`[7c52be5e42]`](https://github.com/aspnet/AspNetCore/commit/7c52be5e42) Stop generating .template.config files dynamically. Convert them to plain files on disk.
* [`[d469cc3151]`](https://github.com/aspnet/AspNetCore/commit/d469cc3151) Clients Subset - AllExcept (#700)
* [`[5104e8c806]`](https://github.com/aspnet/AspNetCore/commit/5104e8c806) Make 2.0 codegen compatible with 1.0 projects until multi-targeting is complete.
* [`[900e9ca835]`](https://github.com/aspnet/AspNetCore/commit/900e9ca835) Add deprecation notice to Yeoman package
* [`[cd9ad38a99]`](https://github.com/aspnet/AspNetCore/commit/cd9ad38a99) Run tests against 'dotnet new' output instead of Yeoman output
* [`[dc9ed60465]`](https://github.com/aspnet/AspNetCore/commit/dc9ed60465) Create the connection logging scope in ConnectionHandler (#2013)
* [`[d6ae8829b6]`](https://github.com/aspnet/AspNetCore/commit/d6ae8829b6) In HMR, don't rely on default JsonSerializer settings. Fixes #688
* [`[11a9b6498d]`](https://github.com/aspnet/AspNetCore/commit/11a9b6498d) Don't alloc IEnumerable in Reset for ITlsConnectionFeature (#2009)
* [`[a94ac6f37e]`](https://github.com/aspnet/AspNetCore/commit/a94ac6f37e) For Redux dev tools, use newer __REDUX_DEVTOOLS_EXTENSION__ API. Fixes #1196
* [`[a40adab38d]`](https://github.com/aspnet/AspNetCore/commit/a40adab38d) In non-ASP.NET apps, default project path to current working directory. Fixes #1100.
* [`[a7e715c88f]`](https://github.com/aspnet/AspNetCore/commit/a7e715c88f) Small grammatical fix to README.md
* [`[79d8a9d3d2]`](https://github.com/aspnet/AspNetCore/commit/79d8a9d3d2) Changing module type to commonjs
* [`[2e6687031d]`](https://github.com/aspnet/AspNetCore/commit/2e6687031d) Added initial connection middleware pipeline (#2003)
* [`[27b0f60f09]`](https://github.com/aspnet/AspNetCore/commit/27b0f60f09) ForbidAsync now uses correct Schemes method (#918)
* [`[900a5c7c4c]`](https://github.com/aspnet/AspNetCore/commit/900a5c7c4c) Add support for ResponseCache in Razor Pages
* [`[345190e6a9]`](https://github.com/aspnet/AspNetCore/commit/345190e6a9) Add timeout to Negotiate (#736)
* [`[bf63704547]`](https://github.com/aspnet/AspNetCore/commit/bf63704547) Renamed solutions
* [`[95f37a0edb]`](https://github.com/aspnet/AspNetCore/commit/95f37a0edb) Install store from artifact dependency
* [`[a4053acd06]`](https://github.com/aspnet/AspNetCore/commit/a4053acd06) Give Client a chance to receive Close Frame from Server (#730)
* [`[e349329dc7]`](https://github.com/aspnet/AspNetCore/commit/e349329dc7) Changing length prefixing to separator for JSON TS
* [`[5ad5f36f88]`](https://github.com/aspnet/AspNetCore/commit/5ad5f36f88) Changing length prefixing to separator for JSON C#
* [`[312e0da556]`](https://github.com/aspnet/AspNetCore/commit/312e0da556) Fix case sensitivity on Startup classes and methods (#1166)
* [`[c74d0e7458]`](https://github.com/aspnet/AspNetCore/commit/c74d0e7458) Adds .Value to logger calls to avoid calling .ToUriComponents on a bad header. (#1169)
* [`[b12451025f]`](https://github.com/aspnet/AspNetCore/commit/b12451025f) Exit OnConnected early if Negotiate fails (#733)
* [`[89548bb39a]`](https://github.com/aspnet/AspNetCore/commit/89548bb39a) Expand the list of external dependencies to include almost everything referenced from an ASP.NET Core project
* [`[fd66472b39]`](https://github.com/aspnet/AspNetCore/commit/fd66472b39) Get Kestrel.Performance working again
* [`[14f122fb9f]`](https://github.com/aspnet/AspNetCore/commit/14f122fb9f) Measure Writing in FrameWritingBenchmark
* [`[a7f021702f]`](https://github.com/aspnet/AspNetCore/commit/a7f021702f) Add more corefx packages to the universe lineup (#543)
* [`[a2c0410e39]`](https://github.com/aspnet/AspNetCore/commit/a2c0410e39) Use PackageLineup to manage package versions
* [`[442ee80039]`](https://github.com/aspnet/AspNetCore/commit/442ee80039) Less awaits for Reponse Write(Async)
* [`[45732a5dd3]`](https://github.com/aspnet/AspNetCore/commit/45732a5dd3) Fix: Nested tag helpers do not work when tag helper prefix is set
* [`[b00c9b4e05]`](https://github.com/aspnet/AspNetCore/commit/b00c9b4e05) Pinning versions for 2.0.0
* [`[3e8da43279]`](https://github.com/aspnet/AspNetCore/commit/3e8da43279) Pinning versions for 2.0.0
* [`[128683be0e]`](https://github.com/aspnet/AspNetCore/commit/128683be0e) Pinning versions for 2.0.0
* [`[5d6330e6b1]`](https://github.com/aspnet/AspNetCore/commit/5d6330e6b1) Pinning versions for 2.0.0
* [`[b613f44ccd]`](https://github.com/aspnet/AspNetCore/commit/b613f44ccd) Add packages to README
* [`[dc8d1d0788]`](https://github.com/aspnet/AspNetCore/commit/dc8d1d0788) Do not block on async calls
* [`[a359da0c44]`](https://github.com/aspnet/AspNetCore/commit/a359da0c44) Length prefixing base64 encoded messages
* [`[ec09268698]`](https://github.com/aspnet/AspNetCore/commit/ec09268698) Add using for presence in chat sample (#727)
* [`[5b4cc95583]`](https://github.com/aspnet/AspNetCore/commit/5b4cc95583) Removing unnecessary dependency
* [`[87db7cceb6]`](https://github.com/aspnet/AspNetCore/commit/87db7cceb6) Stop producing Microsoft.AspNetCore.Server.Kestrel.Tls as a package
* [`[26f1d4baa3]`](https://github.com/aspnet/AspNetCore/commit/26f1d4baa3) Use PackageLineup
* [`[db805eb3e3]`](https://github.com/aspnet/AspNetCore/commit/db805eb3e3) Fix ModelExpression's in section directive blocks.
* [`[0fafd19ec9]`](https://github.com/aspnet/AspNetCore/commit/0fafd19ec9) Initial HTTP/2 support.
* [`[c429467993]`](https://github.com/aspnet/AspNetCore/commit/c429467993) Add System.Buffers and System.Numerics.Vectors to the lineup
* [`[dc66815c35]`](https://github.com/aspnet/AspNetCore/commit/dc66815c35) Add external packages require for aspnet/Common (#541)
* [`[f3745608af]`](https://github.com/aspnet/AspNetCore/commit/f3745608af) Switch to v3 NuGet feed
* [`[8d2a9e5929]`](https://github.com/aspnet/AspNetCore/commit/8d2a9e5929) Support tuples for type directive tokens
* [`[488eb44467]`](https://github.com/aspnet/AspNetCore/commit/488eb44467) Fix obsolete warning message (#1363)
* [`[28a4bb4d5f]`](https://github.com/aspnet/AspNetCore/commit/28a4bb4d5f) Clone over https if we cannot determine the repository's clone url
* [`[418f58f31d]`](https://github.com/aspnet/AspNetCore/commit/418f58f31d) Clone repositories over https
* [`[655a693e4a]`](https://github.com/aspnet/AspNetCore/commit/655a693e4a) Make ViewComponentTagHelper use extension intermediate nodes
* [`[0c82d94a54]`](https://github.com/aspnet/AspNetCore/commit/0c82d94a54) #772 Signout FormPost test (#1358)
* [`[4898c0d3df]`](https://github.com/aspnet/AspNetCore/commit/4898c0d3df) Integrating MsgPack support in TS client
* [`[9eabce1b02]`](https://github.com/aspnet/AspNetCore/commit/9eabce1b02) Enabling tests which would have prevented a bug
* [`[e8a673248a]`](https://github.com/aspnet/AspNetCore/commit/e8a673248a) Conditional WebSockets testing (#714)
* [`[4504ae56d5]`](https://github.com/aspnet/AspNetCore/commit/4504ae56d5) Update protocol spec for Message Pack (#703)
* [`[594f55947f]`](https://github.com/aspnet/AspNetCore/commit/594f55947f) Keep ResponseCookie options on delete. (#905)
* [`[b393200fd3]`](https://github.com/aspnet/AspNetCore/commit/b393200fd3) SSE StopAsync should ignore exception (handled elsewhere) (#708)
* [`[364fc1a55d]`](https://github.com/aspnet/AspNetCore/commit/364fc1a55d) Allow nullable types with generic arguments in directives
* [`[f5710de3e5]`](https://github.com/aspnet/AspNetCore/commit/f5710de3e5) Produce a lineup package containing all packages produced
* [`[456957bf57]`](https://github.com/aspnet/AspNetCore/commit/456957bf57) Use dictionary for deployment parameters (#1126)
* [`[396f413b38]`](https://github.com/aspnet/AspNetCore/commit/396f413b38) Rename testing metapackage (#218)
* [`[653272600f]`](https://github.com/aspnet/AspNetCore/commit/653272600f) Add site extension generation code (#217)
* [`[8cda36157f]`](https://github.com/aspnet/AspNetCore/commit/8cda36157f) Change Read to ReadAsync (#702)
* [`[c125022050]`](https://github.com/aspnet/AspNetCore/commit/c125022050) #772 Fill in OIDC test gaps
* [`[b5e81bd4a0]`](https://github.com/aspnet/AspNetCore/commit/b5e81bd4a0) Use linux specific runtime identifier when gathering installer prerequisites
* [`[e2cec0b305]`](https://github.com/aspnet/AspNetCore/commit/e2cec0b305) Adding MsgPack hub protocol to TS client
* [`[e089852d59]`](https://github.com/aspnet/AspNetCore/commit/e089852d59) Turning messages to arrays
* [`[be9fec5d30]`](https://github.com/aspnet/AspNetCore/commit/be9fec5d30) Adding result kind to completion message
* [`[5ec8a7134e]`](https://github.com/aspnet/AspNetCore/commit/5ec8a7134e) Adds FormFeature quoted boundary test
* [`[32ef3eb355]`](https://github.com/aspnet/AspNetCore/commit/32ef3eb355) Hub<T> (#689)
* [`[eb5c23ea8e]`](https://github.com/aspnet/AspNetCore/commit/eb5c23ea8e) Parse LanguageVersion correctly
* [`[3a1d4c5dd6]`](https://github.com/aspnet/AspNetCore/commit/3a1d4c5dd6) Introducing HubProtocolReaderWriter
* [`[ad4784dbd2]`](https://github.com/aspnet/AspNetCore/commit/ad4784dbd2) Centralizing serializing hub messages
* [`[a0e490e549]`](https://github.com/aspnet/AspNetCore/commit/a0e490e549) Enabling binary protocols over text transports
* [`[f9ee7911a5]`](https://github.com/aspnet/AspNetCore/commit/f9ee7911a5) Use CloseOutputAsync to close client transport WebSocket (#695)
* [`[e9e7baf3f1]`](https://github.com/aspnet/AspNetCore/commit/e9e7baf3f1) Rename store zip and lzma filename
* [`[07f96a444e]`](https://github.com/aspnet/AspNetCore/commit/07f96a444e) Always log startup exceptions
* [`[a49db63f06]`](https://github.com/aspnet/AspNetCore/commit/a49db63f06) Increment M.H.Server.IntegrationTesting version
* [`[dbcac41be7]`](https://github.com/aspnet/AspNetCore/commit/dbcac41be7) Get the correct version of Mvc for multitargeting
* [`[5161ebaf8a]`](https://github.com/aspnet/AspNetCore/commit/5161ebaf8a) Enables the Razor Document Tracker
* [`[4fcad1548e]`](https://github.com/aspnet/AspNetCore/commit/4fcad1548e) Added support for multitargeting
* [`[93b37e14db]`](https://github.com/aspnet/AspNetCore/commit/93b37e14db) fix websocket connection issue and some memory leak, and add debug print (#129)
* [`[cbad7fad7a]`](https://github.com/aspnet/AspNetCore/commit/cbad7fad7a) Add API baseline for Microsoft.AspNetCore
* [`[5d802a7988]`](https://github.com/aspnet/AspNetCore/commit/5d802a7988) Add sample for refresh tokens
* [`[d797543cfc]`](https://github.com/aspnet/AspNetCore/commit/d797543cfc) Update obsolete error (#1346)
* [`[127784e058]`](https://github.com/aspnet/AspNetCore/commit/127784e058) Fix clean machine/testing for Mvc.Extensions.
* [`[5ed1a35ce0]`](https://github.com/aspnet/AspNetCore/commit/5ed1a35ce0) Fix problems with AoT when using Angular Material. Fixes #1168
* [`[aa980fc67c]`](https://github.com/aspnet/AspNetCore/commit/aa980fc67c) Roslyn-ize our tooling contracts.
* [`[ca7f72e3f0]`](https://github.com/aspnet/AspNetCore/commit/ca7f72e3f0) Move PinVersions into RepoTasks (#535)
* [`[31733e973f]`](https://github.com/aspnet/AspNetCore/commit/31733e973f) Set IncrementalVersion=true
* [`[5f1450c9ba]`](https://github.com/aspnet/AspNetCore/commit/5f1450c9ba) Make aspnet-angular compatible with AoT compilation
* [`[c83605baff]`](https://github.com/aspnet/AspNetCore/commit/c83605baff) Add aspnet-angular NPM package containing HttpWithStateTransfer utility
* [`[fc12d722b8]`](https://github.com/aspnet/AspNetCore/commit/fc12d722b8) fix(webpack): fix middleware to specifically serialize options as non-camecased
* [`[372e597f34]`](https://github.com/aspnet/AspNetCore/commit/372e597f34) Added Timeout to HttpClient to always be longer than the InvocationTimeoutMilliseconds.
* [`[41cb9ea31c]`](https://github.com/aspnet/AspNetCore/commit/41cb9ea31c) Fix hosting startup tests (#81).
* [`[6584a8b5fd]`](https://github.com/aspnet/AspNetCore/commit/6584a8b5fd) Shorten folder names
* [`[a8802b2d2c]`](https://github.com/aspnet/AspNetCore/commit/a8802b2d2c) Fix versions in the test project so restore works
* [`[169ef12cd8]`](https://github.com/aspnet/AspNetCore/commit/169ef12cd8) Change Microsoft.DotNet.Web.Spa.ProjectTemplates to use non-prerelease version number in NuGet package
* [`[c2e4d4f261]`](https://github.com/aspnet/AspNetCore/commit/c2e4d4f261) Re-enable the "dotnet restore" postAction, like the stock templates
* [`[d058fe5a39]`](https://github.com/aspnet/AspNetCore/commit/d058fe5a39) Fix StackOverflowException caused when creating the watcher on directories from a network share
* [`[c473800042]`](https://github.com/aspnet/AspNetCore/commit/c473800042) Installer generation updates
* [`[322c72144e]`](https://github.com/aspnet/AspNetCore/commit/322c72144e) Fix syntax error in old versions of bash
* [`[f0cc2f1061]`](https://github.com/aspnet/AspNetCore/commit/f0cc2f1061) Use wget and fallback to curl
* [`[8096b4aca4]`](https://github.com/aspnet/AspNetCore/commit/8096b4aca4) Choose port automatically
* [`[b512181608]`](https://github.com/aspnet/AspNetCore/commit/b512181608) Prevent deleting the .r/ folder on CI
* [`[643efbe660]`](https://github.com/aspnet/AspNetCore/commit/643efbe660) Change version on Binding redirects
* [`[0e38a9fdd8]`](https://github.com/aspnet/AspNetCore/commit/0e38a9fdd8) Fix VersionPrefix
* [`[2ef26486dd]`](https://github.com/aspnet/AspNetCore/commit/2ef26486dd) Add global filters with the right scope
* [`[644f34e90d]`](https://github.com/aspnet/AspNetCore/commit/644f34e90d) AuthZ PolicyEvalutor should take resource
* [`[a5b55edb93]`](https://github.com/aspnet/AspNetCore/commit/a5b55edb93) Fix filter order (#6577)
* [`[36e24b7a31]`](https://github.com/aspnet/AspNetCore/commit/36e24b7a31) Fix AuthZ Regression (#6574)
* [`[ae815475b8]`](https://github.com/aspnet/AspNetCore/commit/ae815475b8) Support for binary protocols on the server side
* [`[35c8da94bf]`](https://github.com/aspnet/AspNetCore/commit/35c8da94bf) Temporarily disable package downgrade warnings (#1576)
* [`[c02d701e6e]`](https://github.com/aspnet/AspNetCore/commit/c02d701e6e) Update Roslyn to 2.3.1 (#1574)
* [`[161b6e7b94]`](https://github.com/aspnet/AspNetCore/commit/161b6e7b94) Update Roslyn to 2.3.1 (#6571)
* [`[ecb26d9bbc]`](https://github.com/aspnet/AspNetCore/commit/ecb26d9bbc) Reenable a connection adapter test on TeamCity (#1961)
* [`[e65e647867]`](https://github.com/aspnet/AspNetCore/commit/e65e647867) Add empty baselines to suppress api check
* [`[819ee5faaf]`](https://github.com/aspnet/AspNetCore/commit/819ee5faaf) Add M.Dotnet.Watcher.Tools and M.E.Caching.SqlConfig.Tools to lzma
* [`[8fc2cd98b6]`](https://github.com/aspnet/AspNetCore/commit/8fc2cd98b6) Add timeout to Event Queue drain (#619)
* [`[98b9a4bf7f]`](https://github.com/aspnet/AspNetCore/commit/98b9a4bf7f) Don't run the precompilation tool when publishing with a RID
* [`[184ab74e68]`](https://github.com/aspnet/AspNetCore/commit/184ab74e68) Don't render view attributes when in design time.
* [`[006b4651da]`](https://github.com/aspnet/AspNetCore/commit/006b4651da) Change product code to work with editor expectations.
* [`[6c7859bfba]`](https://github.com/aspnet/AspNetCore/commit/6c7859bfba) Generate full pdbs for desktop packages
* [`[dfd63fe2cb]`](https://github.com/aspnet/AspNetCore/commit/dfd63fe2cb) Rename property to JsonNetVersion (#197)
* [`[266736764c]`](https://github.com/aspnet/AspNetCore/commit/266736764c) Rename to DiagnosticSourceVersion (#1143)
* [`[3010eaaee2]`](https://github.com/aspnet/AspNetCore/commit/3010eaaee2) Add logging scope (#670)
* [`[4b9a10363c]`](https://github.com/aspnet/AspNetCore/commit/4b9a10363c) Explicitly call Restore on AspNetCore.csproj before calling pack on it.
* [`[b41d8656d5]`](https://github.com/aspnet/AspNetCore/commit/b41d8656d5) Adds new date string in HttpRuleParser
* [`[843d9820e2]`](https://github.com/aspnet/AspNetCore/commit/843d9820e2) Add breakingchanges.netcore.json for Microsoft.AspNetCore.Mvc.Razor
* [`[68ba94218a]`](https://github.com/aspnet/AspNetCore/commit/68ba94218a) IsNullOrWhiteSpace => IsNullOrEmpty
* [`[8dfc6a00e5]`](https://github.com/aspnet/AspNetCore/commit/8dfc6a00e5) Use installed shared framework version during deps file generation
* [`[f0e572075b]`](https://github.com/aspnet/AspNetCore/commit/f0e572075b) Fix FlushAsync when a ConnectionAdapter is configured (#1957)
* [`[4d35489e85]`](https://github.com/aspnet/AspNetCore/commit/4d35489e85) Use dotnet pack to pack AspNetCore file
* [`[0e96c2e20d]`](https://github.com/aspnet/AspNetCore/commit/0e96c2e20d) Nano server tests: Make the dotnet cli folder name unique
* [`[59d3fb433b]`](https://github.com/aspnet/AspNetCore/commit/59d3fb433b) Fix #1555
* [`[459f453cd4]`](https://github.com/aspnet/AspNetCore/commit/459f453cd4) Pin runtime version for generated deps files
* [`[fcd9f0c3ff]`](https://github.com/aspnet/AspNetCore/commit/fcd9f0c3ff) Update Owin to latest (#1323)
* [`[8ba29b578d]`](https://github.com/aspnet/AspNetCore/commit/8ba29b578d) Dynamic Hub Change Part 2 (#644)
* [`[c9f506d4ea]`](https://github.com/aspnet/AspNetCore/commit/c9f506d4ea) Fix #6542 - correct namespace of [TempData]
* [`[0ebd33a25c]`](https://github.com/aspnet/AspNetCore/commit/0ebd33a25c) Plumbing TransferMode on the client side
* [`[1810925b13]`](https://github.com/aspnet/AspNetCore/commit/1810925b13) Add _ViewStart and _ViewImports to embedded view test
* [`[998547839e]`](https://github.com/aspnet/AspNetCore/commit/998547839e) Ensure IPageApplicationModelProviders are invoked in the sequence of their Order
* [`[90a6d8fdf7]`](https://github.com/aspnet/AspNetCore/commit/90a6d8fdf7) Shortening log path
* [`[abd2ce9cf2]`](https://github.com/aspnet/AspNetCore/commit/abd2ce9cf2) Disable TeamCity flow logger for now. It's a little too messy and needs refinement
* [`[6c1388567d]`](https://github.com/aspnet/AspNetCore/commit/6c1388567d) Fix teamcity block logger
* [`[d3ab458c6c]`](https://github.com/aspnet/AspNetCore/commit/d3ab458c6c) Add flow logger to help with console output parallelism
* [`[cd11f71428]`](https://github.com/aspnet/AspNetCore/commit/cd11f71428) Pin CLI tool references for all projects in a solution
* [`[36d3d97b99]`](https://github.com/aspnet/AspNetCore/commit/36d3d97b99) #1319 Add DisplayName overloads
* [`[2df19040c5]`](https://github.com/aspnet/AspNetCore/commit/2df19040c5) Update StackExchange.Redis to latest (#662)
* [`[806ba70a6a]`](https://github.com/aspnet/AspNetCore/commit/806ba70a6a) Update StackExchange.Redis to latest (#260)
* [`[2a69b50a64]`](https://github.com/aspnet/AspNetCore/commit/2a69b50a64) Change Razor.Test.Common to not act like an executable.
* [`[80d8e8a7cd]`](https://github.com/aspnet/AspNetCore/commit/80d8e8a7cd) Adding RuntimeFrameworkVersion to the RepoTasks.csproj
* [`[76aa9b26fc]`](https://github.com/aspnet/AspNetCore/commit/76aa9b26fc) Use async main in dotnet-watch
* [`[5753784ac4]`](https://github.com/aspnet/AspNetCore/commit/5753784ac4) #391 Add back the DisplayName setting
* [`[36ecbd9efd]`](https://github.com/aspnet/AspNetCore/commit/36ecbd9efd) Accounting for ReadAsync throwing OperationCanceledException
* [`[97fd4f432b]`](https://github.com/aspnet/AspNetCore/commit/97fd4f432b) Float the version of NS.Library to workaround issues in mirror
* [`[9528dd7432]`](https://github.com/aspnet/AspNetCore/commit/9528dd7432) Enable TS strict mode in all templates and generally clean up TS references
* [`[021c604244]`](https://github.com/aspnet/AspNetCore/commit/021c604244) Update WindowsAzure.Storage to latest (#258)
* [`[28292086ec]`](https://github.com/aspnet/AspNetCore/commit/28292086ec) Add Roslyn feed to work around missing RTM packages.
* [`[f8d43853f8]`](https://github.com/aspnet/AspNetCore/commit/f8d43853f8) Re-introduce RazorEditorParser.
* [`[095230cb85]`](https://github.com/aspnet/AspNetCore/commit/095230cb85) Update Newtonsoft.Json to 10.0.1 (#1958)
* [`[bcefbae00c]`](https://github.com/aspnet/AspNetCore/commit/bcefbae00c) Complete logging for Socket.* packages (#655)
* [`[bf0e2bca5e]`](https://github.com/aspnet/AspNetCore/commit/bf0e2bca5e) Update ApplicationInsights version
* [`[7b07fb66eb]`](https://github.com/aspnet/AspNetCore/commit/7b07fb66eb) Update all templates to aspnet-webpack@2.0.1
* [`[cdb04c74f9]`](https://github.com/aspnet/AspNetCore/commit/cdb04c74f9) Update aspnet-webpack to 2.0.1, automatically disabling the middleware if we detect the process doesn't have sufficient disk permissions
* [`[c812f9d885]`](https://github.com/aspnet/AspNetCore/commit/c812f9d885) Update to RoslynDev 2.6.0-* packages
* [`[5ea7030b69]`](https://github.com/aspnet/AspNetCore/commit/5ea7030b69) Reload AI configuration file on change (#76)
* [`[7ebbdad974]`](https://github.com/aspnet/AspNetCore/commit/7ebbdad974) Add support for connection scopes if logging is enabled (#1953)
* [`[dbf57b9268]`](https://github.com/aspnet/AspNetCore/commit/dbf57b9268) Update to Roslyn 2.3.0
* [`[308d64277e]`](https://github.com/aspnet/AspNetCore/commit/308d64277e) Update to Roslyn 2.3.0
* [`[576e3debf1]`](https://github.com/aspnet/AspNetCore/commit/576e3debf1) Complete the lstat patching for #1101
* [`[68d84099a0]`](https://github.com/aspnet/AspNetCore/commit/68d84099a0) Use the repository name as the directory to clone to.
* [`[6c39e227b8]`](https://github.com/aspnet/AspNetCore/commit/6c39e227b8) Check for the existence of a git repository before invoking git commands
* [`[fcda85727a]`](https://github.com/aspnet/AspNetCore/commit/fcda85727a) Check for the existence of a git repository before invoking git commands
* [`[98525da02b]`](https://github.com/aspnet/AspNetCore/commit/98525da02b) Use the right set of env variables for determining commit hash
* [`[86756d11dd]`](https://github.com/aspnet/AspNetCore/commit/86756d11dd) Moving typings to the TS client folder
* [`[e65ecebac6]`](https://github.com/aspnet/AspNetCore/commit/e65ecebac6) Make templates work with nonempty baseUrls (e.g., IIS virtual directories)
* [`[4903e12373]`](https://github.com/aspnet/AspNetCore/commit/4903e12373) Publish aspnet-webpack-react as 3.0.0 since it's no longer beta
* [`[56c806b34e]`](https://github.com/aspnet/AspNetCore/commit/56c806b34e) Update aspnet-prerendering to 3.0.1, fixing the default "fetch" base URL to match the real application root URL
* [`[1d2b560dfa]`](https://github.com/aspnet/AspNetCore/commit/1d2b560dfa) Update no-timestamp versions
* [`[fd1758fdfc]`](https://github.com/aspnet/AspNetCore/commit/fd1758fdfc) Make StopAsync multi-thread safe (#1666).
* [`[b0dc76a6ae]`](https://github.com/aspnet/AspNetCore/commit/b0dc76a6ae) Fix flakiness in RejectsRequestWithContentLengthAndUpgrade (#1742).
* [`[748b35109c]`](https://github.com/aspnet/AspNetCore/commit/748b35109c) de-exeify HostingStartup to fix downgrade errors
* [`[cec12fdd7d]`](https://github.com/aspnet/AspNetCore/commit/cec12fdd7d) de-exeify HostingStartup to fix downgrade errors
* [`[8acba88160]`](https://github.com/aspnet/AspNetCore/commit/8acba88160) Update aspnet-webpack to 2.0.0, now supporting HMR when apps are running in virtual directories
* [`[44f86eb8a1]`](https://github.com/aspnet/AspNetCore/commit/44f86eb8a1) Fix webpack HMR proxying logic for apps running on non-root URLs (e.g., full IIS virtual directories)
* [`[e4350945c5]`](https://github.com/aspnet/AspNetCore/commit/e4350945c5) Attach the correlation id to the request scope if logging is on (#1138)
* [`[22ff88ab79]`](https://github.com/aspnet/AspNetCore/commit/22ff88ab79) On Windows, patch Node's lstat to work around permissions error. Fixes #1101
* [`[c43da19ff1]`](https://github.com/aspnet/AspNetCore/commit/c43da19ff1) Do not add the configuration for CacheTagHelperOptions to the container multiple times
* [`[0c07e1e725]`](https://github.com/aspnet/AspNetCore/commit/0c07e1e725) [Fixes #6522] Commit cache entries only when the content gets successfully generated
* [`[a41ef82f19]`](https://github.com/aspnet/AspNetCore/commit/a41ef82f19) Exiting SSE transport receive loop when transport is stopping
* [`[5fe09f9df4]`](https://github.com/aspnet/AspNetCore/commit/5fe09f9df4) Upgrade Roslyn to 2.3.0-beta4-* (#6523)
* [`[aebb841e41]`](https://github.com/aspnet/AspNetCore/commit/aebb841e41) Upgrade Roslyn to 2.3.0-beta4-* (#1533)
* [`[8d4e04cfb4]`](https://github.com/aspnet/AspNetCore/commit/8d4e04cfb4) Fix duplicate test warnings.
* [`[ca08b0e06b]`](https://github.com/aspnet/AspNetCore/commit/ca08b0e06b) Add breakingchanges.json for tag helpers
* [`[667c2c4acc]`](https://github.com/aspnet/AspNetCore/commit/667c2c4acc) Join environment vars
* [`[f125329ed7]`](https://github.com/aspnet/AspNetCore/commit/f125329ed7) Use private instance of MemoryCache and impose size limit
* [`[6e70b1bcca]`](https://github.com/aspnet/AspNetCore/commit/6e70b1bcca) Fix flakiness in MaxRequestBufferSizeTests.LargeUpload (#1850).
* [`[3d76fdf086]`](https://github.com/aspnet/AspNetCore/commit/3d76fdf086) Private cache for cache tag helper and distributed cache tag helper
* [`[002c8b9bc9]`](https://github.com/aspnet/AspNetCore/commit/002c8b9bc9) Adding shutdown http message to support the scenario that ctrl signal is not allowed (#118)
* [`[9f60b42476]`](https://github.com/aspnet/AspNetCore/commit/9f60b42476) Change version suffix for Testing package
* [`[c8bbbe764a]`](https://github.com/aspnet/AspNetCore/commit/c8bbbe764a) #395 Add baseline and breaking change files
* [`[0f7c123081]`](https://github.com/aspnet/AspNetCore/commit/0f7c123081) Fix AuthenticationOptions.DefaultScheme's invalid XML summary
* [`[1d5dfcc6b4]`](https://github.com/aspnet/AspNetCore/commit/1d5dfcc6b4) Update our VSIX version to 15.5
* [`[eca4bfe6c3]`](https://github.com/aspnet/AspNetCore/commit/eca4bfe6c3) Add response minimum data rate feature.
* [`[492f820cf7]`](https://github.com/aspnet/AspNetCore/commit/492f820cf7) Missed caching API updates
* [`[99ff9d44a3]`](https://github.com/aspnet/AspNetCore/commit/99ff9d44a3) Update repo to utilize ApiCheck.
* [`[81363a4e5f]`](https://github.com/aspnet/AspNetCore/commit/81363a4e5f) Use clone uris and commit hash that the CI specifies
* [`[ec72c255f6]`](https://github.com/aspnet/AspNetCore/commit/ec72c255f6) Make HttpsConnectionAdapter pubternal
* [`[f80f7cefa5]`](https://github.com/aspnet/AspNetCore/commit/f80f7cefa5) Fix #6480
* [`[5ab63adf2e]`](https://github.com/aspnet/AspNetCore/commit/5ab63adf2e) Specify scheme for tests
* [`[4c3e0b6721]`](https://github.com/aspnet/AspNetCore/commit/4c3e0b6721) Specify scheme
* [`[df325deaf3]`](https://github.com/aspnet/AspNetCore/commit/df325deaf3) Add AddAuthentication(defaultScheme) overload
* [`[9c0a8a5c96]`](https://github.com/aspnet/AspNetCore/commit/9c0a8a5c96) Rename properties on taghelper nodes
* [`[a3c157cb61]`](https://github.com/aspnet/AspNetCore/commit/a3c157cb61) Validate certificate EKU when it is provided
* [`[2e2dc67978]`](https://github.com/aspnet/AspNetCore/commit/2e2dc67978) #390 Add back AutomaticAuthentication for opt-out.
* [`[f1c4aa14d3]`](https://github.com/aspnet/AspNetCore/commit/f1c4aa14d3) Simplify CacheTagHelper.ProcessAsync (#6506)
* [`[ff40124594]`](https://github.com/aspnet/AspNetCore/commit/ff40124594) Convert most of CodeWriter into extensions
* [`[bd8a2c8a62]`](https://github.com/aspnet/AspNetCore/commit/bd8a2c8a62) Add XML docs for the public HTTPs APIs shipping in 2.0 (#1942)
* [`[4492d3eab7]`](https://github.com/aspnet/AspNetCore/commit/4492d3eab7) In Angular template, rename boot.client.ts to boot.browser.ts for consistency
* [`[efdfbf5dbb]`](https://github.com/aspnet/AspNetCore/commit/efdfbf5dbb) In Yeoman templates, stop restoring using Yarn, since it doesn't respect npm-shrinkwrap.json
* [`[58145d33e3]`](https://github.com/aspnet/AspNetCore/commit/58145d33e3) Update ReactRedux template dependencies
* [`[2135c30d66]`](https://github.com/aspnet/AspNetCore/commit/2135c30d66) Update React template dependencies
* [`[5191531813]`](https://github.com/aspnet/AspNetCore/commit/5191531813) Add AoT compilation to Angular template
* [`[03018f32b7]`](https://github.com/aspnet/AspNetCore/commit/03018f32b7) Update Angular template dependencies
* [`[e632d2bb69]`](https://github.com/aspnet/AspNetCore/commit/e632d2bb69) In domain-task/fetch, only apply HTTPS cert validation workaround for HTTPS requests (not HTTP)
* [`[267b3fab0a]`](https://github.com/aspnet/AspNetCore/commit/267b3fab0a) Made IntermediateNodeWalker.Ancestors indexable
* [`[8bc4d7bb2d]`](https://github.com/aspnet/AspNetCore/commit/8bc4d7bb2d) Rect to Razor rename
* [`[d6e892b30c]`](https://github.com/aspnet/AspNetCore/commit/d6e892b30c) Adjusted verbosity of some property names and made TagHelperIntermediateNode.TagHelpers and IList
* [`[02160a04d9]`](https://github.com/aspnet/AspNetCore/commit/02160a04d9) Make ViewComponentTagHelperMetadata static.
* [`[6fdd4d653c]`](https://github.com/aspnet/AspNetCore/commit/6fdd4d653c) Made InvalidNonWhitespaceHtmlCharacters internal
* [`[45fad171a6]`](https://github.com/aspnet/AspNetCore/commit/45fad171a6) Reduce public surface area of some APIs.
* [`[d891fae4a9]`](https://github.com/aspnet/AspNetCore/commit/d891fae4a9) Rename ThrowForMissingEngineDependency.
* [`[bba508c7c6]`](https://github.com/aspnet/AspNetCore/commit/bba508c7c6) Change TagHelperDescriptor APIs to use IReadOnlyList.
* [`[c34a99e188]`](https://github.com/aspnet/AspNetCore/commit/c34a99e188) Update the TagHelperBinding API to use IReadOnlyList.
* [`[295b32ff21]`](https://github.com/aspnet/AspNetCore/commit/295b32ff21) Downgrade special version to alpha1
* [`[cb40da4e0f]`](https://github.com/aspnet/AspNetCore/commit/cb40da4e0f) Rename ParseOnlyLeadingDirectives.
* [`[b68290ddb7]`](https://github.com/aspnet/AspNetCore/commit/b68290ddb7) Make `RazorParserOptions` creation more like RazorEngine
* [`[87a5435036]`](https://github.com/aspnet/AspNetCore/commit/87a5435036) Make `RazorParserOptions.DesignTime` getter only.
* [`[288da1a405]`](https://github.com/aspnet/AspNetCore/commit/288da1a405) RedirectToPage(page, handler) does not work (#6503)
* [`[23da476176]`](https://github.com/aspnet/AspNetCore/commit/23da476176) Switch to IOptionsMonitor (#1295)
* [`[17f97397e6]`](https://github.com/aspnet/AspNetCore/commit/17f97397e6) TreatWarningsAsErrors
* [`[595f783857]`](https://github.com/aspnet/AspNetCore/commit/595f783857) Features everywhere (#639)
* [`[11c5293862]`](https://github.com/aspnet/AspNetCore/commit/11c5293862) Unnest IntermediateToken.TokenKind
* [`[afa61e7080]`](https://github.com/aspnet/AspNetCore/commit/afa61e7080) Rename LineMapping => SourceMapping.
* [`[4ba0358987]`](https://github.com/aspnet/AspNetCore/commit/4ba0358987) In AngularSpa template, log any FetchData errors but don't stop prerendering completely
* [`[721e3c45fd]`](https://github.com/aspnet/AspNetCore/commit/721e3c45fd) Update ReactReduxSpa NPM shrinkwrap file
* [`[27f59c6971]`](https://github.com/aspnet/AspNetCore/commit/27f59c6971) Make domain-task/fetch disable HTTPS cert validation when making relative requests to own server as workaround for #1089
* [`[de21ce1637]`](https://github.com/aspnet/AspNetCore/commit/de21ce1637) Expose IGroupManager on IHubContext (#638)
* [`[2597e52e53]`](https://github.com/aspnet/AspNetCore/commit/2597e52e53) Rename HubConnection Extension Methods from Invoke to InvokeAsync (#637)
* [`[cfaa4b69d7]`](https://github.com/aspnet/AspNetCore/commit/cfaa4b69d7) Dynamic Hub Work Part 1 (#636)
* [`[7454c53047]`](https://github.com/aspnet/AspNetCore/commit/7454c53047) Rely on Razors MalformedDirective identification for @page.
* [`[a78202e937]`](https://github.com/aspnet/AspNetCore/commit/a78202e937) Have `@page` understand malformed directives.
* [`[ed6badbabe]`](https://github.com/aspnet/AspNetCore/commit/ed6badbabe) Set X-Requested-With header and add HttpError (#623)
* [`[13b867a90e]`](https://github.com/aspnet/AspNetCore/commit/13b867a90e) #366 Add flag to disable synchronous IO
* [`[7408bcd025]`](https://github.com/aspnet/AspNetCore/commit/7408bcd025) Rewrite of code rendering context
* [`[658f4621b1]`](https://github.com/aspnet/AspNetCore/commit/658f4621b1) #1208 Clean up JWT and OIDC issuer handling
* [`[1a1e4c309f]`](https://github.com/aspnet/AspNetCore/commit/1a1e4c309f) #167 Add cancellation tokens and defualt timeouts for Load/CommitAsync.
* [`[8dfba25d59]`](https://github.com/aspnet/AspNetCore/commit/8dfba25d59) Streamline collections
* [`[98eb31194c]`](https://github.com/aspnet/AspNetCore/commit/98eb31194c) Guard against null
* [`[85402d4bd6]`](https://github.com/aspnet/AspNetCore/commit/85402d4bd6) Add CancellationToken to ISession Load/CommitAsync
* [`[ef43b100a6]`](https://github.com/aspnet/AspNetCore/commit/ef43b100a6) Fix a null reference exception and add some null checks
* [`[a23307e2b1]`](https://github.com/aspnet/AspNetCore/commit/a23307e2b1) Check for properties that can't befound
* [`[bb1d80be2a]`](https://github.com/aspnet/AspNetCore/commit/bb1d80be2a) Create common manifest file
* [`[66b939725e]`](https://github.com/aspnet/AspNetCore/commit/66b939725e) https://github.com/aspnet/Security/issues/1265. Check Auth failures and log them.
* [`[354facf4ad]`](https://github.com/aspnet/AspNetCore/commit/354facf4ad) Use localization middleware (#801)
* [`[f21f5039b2]`](https://github.com/aspnet/AspNetCore/commit/f21f5039b2) Replace ConnectionContext with HubConnectionContext (#629)
* [`[d36838ed88]`](https://github.com/aspnet/AspNetCore/commit/d36838ed88) Handle imported @page directives.
* [`[c50f55d1de]`](https://github.com/aspnet/AspNetCore/commit/c50f55d1de) Add a default sliding expiration of 30 seconds on Memory and Distributed Cache Tag Helpers.
* [`[8a9bf9c71a]`](https://github.com/aspnet/AspNetCore/commit/8a9bf9c71a) Rewrite of code rendering context
* [`[35889cba81]`](https://github.com/aspnet/AspNetCore/commit/35889cba81) Add properties to the body node that it needs
* [`[ddef61485b]`](https://github.com/aspnet/AspNetCore/commit/ddef61485b) DiagnosticSource to 4.4.1
* [`[654d6bee4a]`](https://github.com/aspnet/AspNetCore/commit/654d6bee4a) DiagnosticSource to 4.4.1
* [`[057a853de7]`](https://github.com/aspnet/AspNetCore/commit/057a853de7) DiagnosticSource to 4.4.1
* [`[81544958b8]`](https://github.com/aspnet/AspNetCore/commit/81544958b8) DiagnosticSource to 4.4.1
* [`[13e76c24d3]`](https://github.com/aspnet/AspNetCore/commit/13e76c24d3) Dispose CancellationTokenSource created in CacheTagHelper (#6293)
* [`[728b96344d]`](https://github.com/aspnet/AspNetCore/commit/728b96344d) [Fixes #6274] Fix and re-enable skiped test
* [`[eeee3ef731]`](https://github.com/aspnet/AspNetCore/commit/eeee3ef731) Add SignOut overload + Use new auth api (#6476)
* [`[2a57171ea8]`](https://github.com/aspnet/AspNetCore/commit/2a57171ea8) Use new auth API
* [`[cc283f7b4c]`](https://github.com/aspnet/AspNetCore/commit/cc283f7b4c) Use new Auth API (#811)
* [`[dbc5bf9a48]`](https://github.com/aspnet/AspNetCore/commit/dbc5bf9a48) Switch to new auth API
* [`[8090216dbe]`](https://github.com/aspnet/AspNetCore/commit/8090216dbe) Make RequiredAttributeDescriptor IEquatable.
* [`[00d17dea79]`](https://github.com/aspnet/AspNetCore/commit/00d17dea79) Domain socket handles (#1922)
* [`[e9ffcdb414]`](https://github.com/aspnet/AspNetCore/commit/e9ffcdb414) Add feature to optionally disallow synchronous IO (#1919)
* [`[4654997201]`](https://github.com/aspnet/AspNetCore/commit/4654997201) Add AllowedChildTagDescriptor.
* [`[a7cc63d6e1]`](https://github.com/aspnet/AspNetCore/commit/a7cc63d6e1) Simplification of IntermediateNode
* [`[d917504c14]`](https://github.com/aspnet/AspNetCore/commit/d917504c14) [Fixes #6468] Clean up the productionized testing infrastructure
* [`[6e1fa2b2c3]`](https://github.com/aspnet/AspNetCore/commit/6e1fa2b2c3) Use ASP.NET Core CI NuGet feed to enable access to preview3 packages
* [`[94fc84a9b4]`](https://github.com/aspnet/AspNetCore/commit/94fc84a9b4) Add simpler prerendering API. Fixes #607
* [`[513d288a5d]`](https://github.com/aspnet/AspNetCore/commit/513d288a5d) Use GetRandomFileName instead of GetTempFileName. Fixes #1060
* [`[429a432dd3]`](https://github.com/aspnet/AspNetCore/commit/429a432dd3) Check for null during node process disposal. Fixes #1061
* [`[6e45de2205]`](https://github.com/aspnet/AspNetCore/commit/6e45de2205) Improved systemd activation tests (#1930)
* [`[0f4295f90e]`](https://github.com/aspnet/AspNetCore/commit/0f4295f90e) Make parsers stateless (#628)
* [`[15008b0b7f]`](https://github.com/aspnet/AspNetCore/commit/15008b0b7f) Add WaitForShutdown to WebHostExtensions
* [`[10b195bcce]`](https://github.com/aspnet/AspNetCore/commit/10b195bcce) Move DefaultConnectionContext out of Sockets.Abstractions (#627)
* [`[b0a70aeef7]`](https://github.com/aspnet/AspNetCore/commit/b0a70aeef7) Add synchronous Start back to IWebHost (#1125)
* [`[112cbc0bb6]`](https://github.com/aspnet/AspNetCore/commit/112cbc0bb6) Check for warnrings in tests taht compile
* [`[7aeb228063]`](https://github.com/aspnet/AspNetCore/commit/7aeb228063) Redesign tag helper codegen
* [`[2a6f0e4dc9]`](https://github.com/aspnet/AspNetCore/commit/2a6f0e4dc9) Productionize the csharp rendering context APIs.
* [`[7162fe2371]`](https://github.com/aspnet/AspNetCore/commit/7162fe2371) Clarify installer error message
* [`[bce7d84906]`](https://github.com/aspnet/AspNetCore/commit/bce7d84906) Fix cart count when the same album is added to the cart multiple times (#765)
* [`[bc4328de16]`](https://github.com/aspnet/AspNetCore/commit/bc4328de16) Add entry to breakingchanges.json
* [`[948982ebff]`](https://github.com/aspnet/AspNetCore/commit/948982ebff) Create custom collection for model binder providers
* [`[edfe5399c3]`](https://github.com/aspnet/AspNetCore/commit/edfe5399c3) Add some details about view compilation options (#156)
* [`[81c2b57dda]`](https://github.com/aspnet/AspNetCore/commit/81c2b57dda) Increase default request min rate to 240 bytes/second (#1929).
* [`[bc86ea4e47]`](https://github.com/aspnet/AspNetCore/commit/bc86ea4e47) Move convention extensions from RazorPagesOptions to PageConventionCollectionsExtensions Fixes #6462
* [`[68ba9a9445]`](https://github.com/aspnet/AspNetCore/commit/68ba9a9445) Avoid torn reads from _frame.MinReadBodyDataRate in FrameConnection.Tick().
* [`[660b7df0e2]`](https://github.com/aspnet/AspNetCore/commit/660b7df0e2) Upgrade Roslyn to 2.3.0-beta3-*
* [`[4db7f2eb6d]`](https://github.com/aspnet/AspNetCore/commit/4db7f2eb6d) Update to Roslyn 2.3.0-beta3 version
* [`[f76a390a4e]`](https://github.com/aspnet/AspNetCore/commit/f76a390a4e) Fall back to linear search for prefix matches - #6469
* [`[f2061ed716]`](https://github.com/aspnet/AspNetCore/commit/f2061ed716) Rename request body min rate APIs (#1901).
* [`[eb1f72c369]`](https://github.com/aspnet/AspNetCore/commit/eb1f72c369) Installer generation updates
* [`[64ed5bb4ff]`](https://github.com/aspnet/AspNetCore/commit/64ed5bb4ff) Use new SelfContained property
* [`[7c7bb627b9]`](https://github.com/aspnet/AspNetCore/commit/7c7bb627b9) Moved typename and propertyname to extension methods
* [`[293ac81fe1]`](https://github.com/aspnet/AspNetCore/commit/293ac81fe1) Use ordinal comparisons in `ExpressionTextCache` - #6349 - C# field and property names are case-sensitive   - it's not important (where this cache is used) that HTML field names are case-insenstive
* [`[d7533529f9]`](https://github.com/aspnet/AspNetCore/commit/d7533529f9) Fix restore warnings for Microsoft.NETCore.App
* [`[17f6b17a6d]`](https://github.com/aspnet/AspNetCore/commit/17f6b17a6d) Add RequestSizeLimitAttribute (#6453)
* [`[413c1c919f]`](https://github.com/aspnet/AspNetCore/commit/413c1c919f) Update to StreamRpc 1.1.92
* [`[bcf790b9d5]`](https://github.com/aspnet/AspNetCore/commit/bcf790b9d5) Added convenience properties to TagHelperIntermediateNode
* [`[cb246ae45b]`](https://github.com/aspnet/AspNetCore/commit/cb246ae45b) Use specified signed runtime store archives when available for installers
* [`[3ba8c2d3f0]`](https://github.com/aspnet/AspNetCore/commit/3ba8c2d3f0) Add ListenHandleTests (#1923)
* [`[bbd7f03114]`](https://github.com/aspnet/AspNetCore/commit/bbd7f03114) Update PackagePublisher version
* [`[417e6b81ea]`](https://github.com/aspnet/AspNetCore/commit/417e6b81ea) Cross-compile hosting startups (#68)
* [`[a247a3d8e6]`](https://github.com/aspnet/AspNetCore/commit/a247a3d8e6) Attempting to fix systemd activation with minimal changes (#1925)
* [`[ff433f72b8]`](https://github.com/aspnet/AspNetCore/commit/ff433f72b8) Run DesignTimeDirectivePass later in the phase
* [`[bb9b206342]`](https://github.com/aspnet/AspNetCore/commit/bb9b206342) Update Moq to 4.7.49
* [`[08c04f8912]`](https://github.com/aspnet/AspNetCore/commit/08c04f8912) Fix NuGet downgrade warnings from CoreFxLab packages
* [`[9b9495cd5f]`](https://github.com/aspnet/AspNetCore/commit/9b9495cd5f) Update Moq to 4.7.49
* [`[f8ccf05715]`](https://github.com/aspnet/AspNetCore/commit/f8ccf05715) Updated runtime store tests and friends
* [`[579aca0121]`](https://github.com/aspnet/AspNetCore/commit/579aca0121) Define semantics for pagemodels Fixes #6210
* [`[d68de2b5ea]`](https://github.com/aspnet/AspNetCore/commit/d68de2b5ea) Make Client Side Event Handlers Async (#610)
* [`[d6f5e16f38]`](https://github.com/aspnet/AspNetCore/commit/d6f5e16f38) Support non blocking send on client (#603)
* [`[05cc4123a7]`](https://github.com/aspnet/AspNetCore/commit/05cc4123a7) Add duplicate directive error for th prefix.
* [`[b2bc4e6207]`](https://github.com/aspnet/AspNetCore/commit/b2bc4e6207) Added a (Uri,HttpMessageHandler) ctor for HttpConnection (#609)
* [`[a90f4118ad]`](https://github.com/aspnet/AspNetCore/commit/a90f4118ad) Do not include type names in `ModelState` error messages - #6076 - add resources and accessors specifically for the element / parameter cases - avoid `metadata.GetDisplayName()` where possible - fill in the `ValidationContext` that `ValidatorObjectAdapter` uses   - e.g. `Validate_NestedComplexType_IValidatableObject_Invalid()` test fails without this
* [`[dc29e98032]`](https://github.com/aspnet/AspNetCore/commit/dc29e98032) Support Authorize attribute on EndPoints (#606)
* [`[8df3032540]`](https://github.com/aspnet/AspNetCore/commit/8df3032540) Add support for specifying filters on page models.
* [`[fc56105d83]`](https://github.com/aspnet/AspNetCore/commit/fc56105d83) Fixed external login scenarios tests
* [`[f3ed8129f3]`](https://github.com/aspnet/AspNetCore/commit/f3ed8129f3) Ensure Microsoft.AspNetCore.All is only compatible with netcoreapp2.0 (#180)
* [`[163836fe1f]`](https://github.com/aspnet/AspNetCore/commit/163836fe1f) #800 Re-enable API check (#878)
* [`[e70ce98213]`](https://github.com/aspnet/AspNetCore/commit/e70ce98213) Add docs about limitation of this option
* [`[7166dfecd7]`](https://github.com/aspnet/AspNetCore/commit/7166dfecd7) Add generic overloads on FilterCollection
* [`[cf7d2b4c40]`](https://github.com/aspnet/AspNetCore/commit/cf7d2b4c40) Pin Roslyn compiler version (#597)
* [`[59e032dbcb]`](https://github.com/aspnet/AspNetCore/commit/59e032dbcb) Adding negotiation to TS client
* [`[f8d91b54d4]`](https://github.com/aspnet/AspNetCore/commit/f8d91b54d4) MsgPack end-to-end
* [`[a2b856794e]`](https://github.com/aspnet/AspNetCore/commit/a2b856794e) [Fixes #804] Re-enable tests disabled by cookie path changes
* [`[71949129ea]`](https://github.com/aspnet/AspNetCore/commit/71949129ea) Enabling length prefixing, parsing multiple messages
* [`[3504337918]`](https://github.com/aspnet/AspNetCore/commit/3504337918) Adding MsgPack HubProtocol
* [`[9b4be69e9d]`](https://github.com/aspnet/AspNetCore/commit/9b4be69e9d) Do not enforce timeouts when the debugger is attached
* [`[42f43e6cdf]`](https://github.com/aspnet/AspNetCore/commit/42f43e6cdf) Upgrade TargetFramework in TestServer from 4.5 to 4.6.1 (#190)
* [`[81fa36f029]`](https://github.com/aspnet/AspNetCore/commit/81fa36f029) Add a test that always publishes in Debug
* [`[5155456653]`](https://github.com/aspnet/AspNetCore/commit/5155456653) Handle graceful shutdown from ANCM
* [`[80383606d3]`](https://github.com/aspnet/AspNetCore/commit/80383606d3) AuthZ: Eliminate extra ToArray()
* [`[13ef35fa79]`](https://github.com/aspnet/AspNetCore/commit/13ef35fa79) Changed the handlers to be Func<object[], Task> (#578)
* [`[e36da30072]`](https://github.com/aspnet/AspNetCore/commit/e36da30072) Ignore failed send after close (WebSockets) (#593)
* [`[9370ffce3c]`](https://github.com/aspnet/AspNetCore/commit/9370ffce3c) Updating Moq to 4.7.49
* [`[9acfc8d221]`](https://github.com/aspnet/AspNetCore/commit/9acfc8d221) Watch _ViewImports outside the pages root for changes
* [`[d278d6eedf]`](https://github.com/aspnet/AspNetCore/commit/d278d6eedf) Updating Moq to 4.7.49
* [`[d1813a7cd7]`](https://github.com/aspnet/AspNetCore/commit/d1813a7cd7) Normalize paths returned by view location expanders
* [`[c67e790b3b]`](https://github.com/aspnet/AspNetCore/commit/c67e790b3b) Update inject directive to utilize DirectiveUsage.
* [`[c2c95ec175]`](https://github.com/aspnet/AspNetCore/commit/c2c95ec175) Add file scoped multiple occurring extensible directives.
* [`[3536cf5aad]`](https://github.com/aspnet/AspNetCore/commit/3536cf5aad) Fix #5183 - update docs of CreateWriter
* [`[0ad9c7d4eb]`](https://github.com/aspnet/AspNetCore/commit/0ad9c7d4eb) Making Pages Binding Consistent
* [`[d73ecf8b36]`](https://github.com/aspnet/AspNetCore/commit/d73ecf8b36) Suppress warnings for auto generated code
* [`[09ac126ecf]`](https://github.com/aspnet/AspNetCore/commit/09ac126ecf) Make single line single file scoped directives automatically import.
* [`[3fcd909d90]`](https://github.com/aspnet/AspNetCore/commit/3fcd909d90) Temporarily disable systemd activation test (#1918)
* [`[f4a86f5511]`](https://github.com/aspnet/AspNetCore/commit/f4a86f5511) Add DiagnosticSource to RazorView (#6386)
* [`[7febdbaa20]`](https://github.com/aspnet/AspNetCore/commit/7febdbaa20) #539 Implement request body size limit
* [`[7b15720a05]`](https://github.com/aspnet/AspNetCore/commit/7b15720a05) # This is a combination of 2 commits. # This is the 1st commit message:
* [`[c13ba3ef0a]`](https://github.com/aspnet/AspNetCore/commit/c13ba3ef0a) #339 Don't send chunked responses for HEAD requests
* [`[2d90ae47f9]`](https://github.com/aspnet/AspNetCore/commit/2d90ae47f9) Lazily initialize annotations for intermediate nodes.
* [`[e5da44a82f]`](https://github.com/aspnet/AspNetCore/commit/e5da44a82f) Generate full pdbs for views on desktop and re-enable runtime error tests (#6442)
* [`[8352ec7626]`](https://github.com/aspnet/AspNetCore/commit/8352ec7626) Add npm-shrinkwrap.json files for all templates
* [`[bebb82eb69]`](https://github.com/aspnet/AspNetCore/commit/bebb82eb69) Implement longer-term fix for #1066 (see description)
* [`[117c1a6cbd]`](https://github.com/aspnet/AspNetCore/commit/117c1a6cbd) Implement workaround for #1066
* [`[0f264e18e9]`](https://github.com/aspnet/AspNetCore/commit/0f264e18e9) Fix TS Client tests (#586)
* [`[03e555a24e]`](https://github.com/aspnet/AspNetCore/commit/03e555a24e) Fix packing issue
* [`[052db40567]`](https://github.com/aspnet/AspNetCore/commit/052db40567) Fix documentation and target files issues
* [`[35152d5933]`](https://github.com/aspnet/AspNetCore/commit/35152d5933) [Fixes #6233] Productionize and harden our functional testing infrastructure
* [`[6f762fe478]`](https://github.com/aspnet/AspNetCore/commit/6f762fe478) Update RPM installation directory
* [`[9602787463]`](https://github.com/aspnet/AspNetCore/commit/9602787463) Fix broken SSE transport
* [`[622da80b43]`](https://github.com/aspnet/AspNetCore/commit/622da80b43) Update PackagePublisher version (#113)
* [`[ef273b4796]`](https://github.com/aspnet/AspNetCore/commit/ef273b4796) Add authorization per hub method (#577)
* [`[a84ba8820f]`](https://github.com/aspnet/AspNetCore/commit/a84ba8820f) Use Channel<byte[]> as the abstraction (#579)
* [`[5fa9fc9458]`](https://github.com/aspnet/AspNetCore/commit/5fa9fc9458) Updated breaking changes file
* [`[05c6cbe466]`](https://github.com/aspnet/AspNetCore/commit/05c6cbe466) Fix documentation for JwtBearerOptions.Events (#1249)
* [`[513f6ac816]`](https://github.com/aspnet/AspNetCore/commit/513f6ac816) Avoid having to return anything in StartupBase.ConfigureServices (#957)
* [`[aa5a348385]`](https://github.com/aspnet/AspNetCore/commit/aa5a348385) _ViewStart.cshtml not picked up when added to the root of the app
* [`[53f5a77490]`](https://github.com/aspnet/AspNetCore/commit/53f5a77490) Use preview2-final NuGet feed until it ships to NuGet.org
* [`[5fd9b93324]`](https://github.com/aspnet/AspNetCore/commit/5fd9b93324) Switch to a specific version of .NET Core 2.0 Preview 2, because "latest" is 2.1 and breaks. Fixes #1058
* [`[55bd0c05cb]`](https://github.com/aspnet/AspNetCore/commit/55bd0c05cb) Update SpaServices NuGet package installation requirement
* [`[0dfffd45c2]`](https://github.com/aspnet/AspNetCore/commit/0dfffd45c2) RazorPages page directives missing quotes should alert user
* [`[9d138affa2]`](https://github.com/aspnet/AspNetCore/commit/9d138affa2) Suppress JsonPatchDocument validation (#6429)
* [`[6bbcbc1261]`](https://github.com/aspnet/AspNetCore/commit/6bbcbc1261) Move seen directives to the parser context.
* [`[7a04e35da5]`](https://github.com/aspnet/AspNetCore/commit/7a04e35da5) Update built-in directives to use DirectiveUsage.
* [`[2453689804]`](https://github.com/aspnet/AspNetCore/commit/2453689804) Add file scoped extensible directives.
* [`[ab8cb5e2c9]`](https://github.com/aspnet/AspNetCore/commit/ab8cb5e2c9) Preapre for StackTrace.Sources changes
* [`[acb96ec971]`](https://github.com/aspnet/AspNetCore/commit/acb96ec971) Preapre for StackTrace.Sources changes
* [`[c83f606b22]`](https://github.com/aspnet/AspNetCore/commit/c83f606b22) Add a StressTest target (#1914)
* [`[a34e4055cd]`](https://github.com/aspnet/AspNetCore/commit/a34e4055cd) Reduce pipelines dependency to just extensions
* [`[e3b3e20738]`](https://github.com/aspnet/AspNetCore/commit/e3b3e20738) Move some stuff to .Extensions
* [`[7a234ca513]`](https://github.com/aspnet/AspNetCore/commit/7a234ca513) Rename UsingStatement>UsingDirective
* [`[a580c8fdf1]`](https://github.com/aspnet/AspNetCore/commit/a580c8fdf1) Get rid of AccessModifiers
* [`[a40ca857c5]`](https://github.com/aspnet/AspNetCore/commit/a40ca857c5) Rename HtmlAttributeValueStyle>AttributeStructure
* [`[b36bbac60a]`](https://github.com/aspnet/AspNetCore/commit/b36bbac60a) Clean up .Legacy
* [`[4811807329]`](https://github.com/aspnet/AspNetCore/commit/4811807329) Moved CSharpCodeWriter out of legacy
* [`[ea2f1033d3]`](https://github.com/aspnet/AspNetCore/commit/ea2f1033d3) Make Transport.Abstractions pubternal (#1911)
* [`[21e26ad4aa]`](https://github.com/aspnet/AspNetCore/commit/21e26ad4aa) Rename RazorIRNode
* [`[d14b453c33]`](https://github.com/aspnet/AspNetCore/commit/d14b453c33) Allow publishing rid specific desktop applications
* [`[fc502c7645]`](https://github.com/aspnet/AspNetCore/commit/fc502c7645) Set license to Apache 2.0
* [`[d2469e078a]`](https://github.com/aspnet/AspNetCore/commit/d2469e078a) Move Source down to ExtensionIRNode
* [`[8649e1a4be]`](https://github.com/aspnet/AspNetCore/commit/8649e1a4be) Add Tag Helper descriptors to the Tag Helper node
* [`[8d095d3af6]`](https://github.com/aspnet/AspNetCore/commit/8d095d3af6) Unwrap inner exceptions for AggregateExceptions
* [`[5834660081]`](https://github.com/aspnet/AspNetCore/commit/5834660081) Fix issues with adding desktop reference.
* [`[062d7561ae]`](https://github.com/aspnet/AspNetCore/commit/062d7561ae) Make section an extension node
* [`[be46b5a922]`](https://github.com/aspnet/AspNetCore/commit/be46b5a922) Use better asserts for cookies
* [`[5bcba9677e]`](https://github.com/aspnet/AspNetCore/commit/5bcba9677e) Re-enable desktop tests
* [`[0dd29b3050]`](https://github.com/aspnet/AspNetCore/commit/0dd29b3050) Always close websocket on server (#567)
* [`[9b89aca3c3]`](https://github.com/aspnet/AspNetCore/commit/9b89aca3c3) Use IsPackable instead of ExcludeFromPack
* [`[c89f0a1e43]`](https://github.com/aspnet/AspNetCore/commit/c89f0a1e43) Allow AddPageRoute to route to pages root. (#6412)
* [`[e0e74462ba]`](https://github.com/aspnet/AspNetCore/commit/e0e74462ba) Fix warnings in tests from adding assembly references that don't exist
* [`[fe4cc976b9]`](https://github.com/aspnet/AspNetCore/commit/fe4cc976b9) Use MuxerPath to determine location to dotnet.exe
* [`[e1e7c9b810]`](https://github.com/aspnet/AspNetCore/commit/e1e7c9b810) Wait until the writer is complete to reset RequestBodyPipe (#1902)
* [`[12f89f66a6]`](https://github.com/aspnet/AspNetCore/commit/12f89f66a6) Improve PathString <-> string logic
* [`[6d85e752e1]`](https://github.com/aspnet/AspNetCore/commit/6d85e752e1) Throwing HttpInvocationException instead of generic Exception
* [`[d007a3fbba]`](https://github.com/aspnet/AspNetCore/commit/d007a3fbba) In aspnet-prerendering, fix type definitions to satisfy TypeScript 2.4.0. Fixes #1034
* [`[fcd3cf9dd7]`](https://github.com/aspnet/AspNetCore/commit/fcd3cf9dd7) In aspnet-prerendering, simply type imports/exports by changing PrerenderingInterfaces to a regular module (not a .d.ts file)
* [`[132c8c7a7e]`](https://github.com/aspnet/AspNetCore/commit/132c8c7a7e) Implement consistent error story for directives.
* [`[dd4e163173]`](https://github.com/aspnet/AspNetCore/commit/dd4e163173) Change GenerateChecksum to SuppressChecksum
* [`[7afd279a6d]`](https://github.com/aspnet/AspNetCore/commit/7afd279a6d) Don't pause and resume read timing on upgrade requests (#1904).
* [`[e88ad84a72]`](https://github.com/aspnet/AspNetCore/commit/e88ad84a72) Create a scoped service provider for the call to Configure (#1106)
* [`[900f38b0c2]`](https://github.com/aspnet/AspNetCore/commit/900f38b0c2) Copy precompiled pdb to publish directory
* [`[7ac4bf14f2]`](https://github.com/aspnet/AspNetCore/commit/7ac4bf14f2) Use file globbing to resolve manifests
* [`[48bca777fe]`](https://github.com/aspnet/AspNetCore/commit/48bca777fe) Added "private": true to package.json
* [`[d169b96d2d]`](https://github.com/aspnet/AspNetCore/commit/d169b96d2d) Decouple IConnection.ts and HubConnection.ts from http (#566)
* [`[f4f6501b8d]`](https://github.com/aspnet/AspNetCore/commit/f4f6501b8d) Updating libuv dependency to 1.10.0
* [`[879f0b7f40]`](https://github.com/aspnet/AspNetCore/commit/879f0b7f40) [Fixes #1133] Limit the path on the nonce and correlation id cookies
* [`[efbc953868]`](https://github.com/aspnet/AspNetCore/commit/efbc953868) Update debian_config.json package name
* [`[615c6c17e2]`](https://github.com/aspnet/AspNetCore/commit/615c6c17e2) Updated AppInsights version to 2.1.0-beta6
* [`[0298868c00]`](https://github.com/aspnet/AspNetCore/commit/0298868c00) Reorganize and add more logging to Sockets.Http (#549)
* [`[29643cbc5e]`](https://github.com/aspnet/AspNetCore/commit/29643cbc5e) Fixed version of netstandard.library
* [`[835fb60380]`](https://github.com/aspnet/AspNetCore/commit/835fb60380) Fixed version of netstandard.library
* [`[39aa81abcc]`](https://github.com/aspnet/AspNetCore/commit/39aa81abcc) Fixed version of netstandard.library
* [`[e13965c252]`](https://github.com/aspnet/AspNetCore/commit/e13965c252) Fixed version of netstandard.library
* [`[483d06734a]`](https://github.com/aspnet/AspNetCore/commit/483d06734a) Fixed version of netstandard.library
* [`[89e96e8bf8]`](https://github.com/aspnet/AspNetCore/commit/89e96e8bf8) Fixed version of netstandard.library
* [`[ed7e07a057]`](https://github.com/aspnet/AspNetCore/commit/ed7e07a057) Updated to use latest netstandard.library
* [`[e762adc018]`](https://github.com/aspnet/AspNetCore/commit/e762adc018) Updated Hub protocol
* [`[53c94b9450]`](https://github.com/aspnet/AspNetCore/commit/53c94b9450) Updated the spec
* [`[40bef1bc78]`](https://github.com/aspnet/AspNetCore/commit/40bef1bc78) Simplify delegate invoking (#565)
* [`[0c6460ab64]`](https://github.com/aspnet/AspNetCore/commit/0c6460ab64) Changed WebApiCompatShim projects to use PackageTargetFallback
* [`[3ef23ece23]`](https://github.com/aspnet/AspNetCore/commit/3ef23ece23) Changed all references of PackageTargetFallback to AssetTargetFallback (#1035)
* [`[5eea3f50c5]`](https://github.com/aspnet/AspNetCore/commit/5eea3f50c5) Changed all references of PackageTargetFallback to AssetTargetFallback (#1441)
* [`[8832014516]`](https://github.com/aspnet/AspNetCore/commit/8832014516) PackageTarget->AssetTarget
* [`[0b844b2ccf]`](https://github.com/aspnet/AspNetCore/commit/0b844b2ccf) Changed all references of PackageTargetFallback to AssetTargetFallback
* [`[9519473769]`](https://github.com/aspnet/AspNetCore/commit/9519473769) Changed all references of PackageTargetFallback to AssetTargetFallback
* [`[6134a11c28]`](https://github.com/aspnet/AspNetCore/commit/6134a11c28) Changed all references of PackageTargetFallback to AssetTargetFallback
* [`[df5c6730f7]`](https://github.com/aspnet/AspNetCore/commit/df5c6730f7) Add new default schemes + tests (#870)
* [`[4b1f5f24da]`](https://github.com/aspnet/AspNetCore/commit/4b1f5f24da) Add netcoreapp2.0 runtime targets.
* [`[22d52f2a3c]`](https://github.com/aspnet/AspNetCore/commit/22d52f2a3c) Split the functions/section/inherits directives
* [`[200ce72312]`](https://github.com/aspnet/AspNetCore/commit/200ce72312) Rename PostLogoutRedirectUri to avoid spec confusion
* [`[5d1a523682]`](https://github.com/aspnet/AspNetCore/commit/5d1a523682) Make ILoggerFactory an optional service on any DI-injected services
* [`[bcb359e355]`](https://github.com/aspnet/AspNetCore/commit/bcb359e355) Update System.Threading.Tasks.Dataflow dependency to latest corefx version
* [`[abf05e2856]`](https://github.com/aspnet/AspNetCore/commit/abf05e2856) Docker: add warning when FileSystemXmlRepository saves a key to non-volume mounted folder
* [`[27ac5da6d5]`](https://github.com/aspnet/AspNetCore/commit/27ac5da6d5) Add indexer null-check for preallocated tag helper attributes
* [`[78877b6ba2]`](https://github.com/aspnet/AspNetCore/commit/78877b6ba2) Add "--no-restore" parameter to "dotnet run" (#1104)
* [`[e3287ae672]`](https://github.com/aspnet/AspNetCore/commit/e3287ae672) Add diagnostics to the IR.
* [`[a38d3bdc4b]`](https://github.com/aspnet/AspNetCore/commit/a38d3bdc4b) Change NETStandard.Library.NETFramework reference to preview2-25405-01 for consistency with stock Web templates
* [`[ae21379736]`](https://github.com/aspnet/AspNetCore/commit/ae21379736) Fixed 205 status code
* [`[cee4cf7544]`](https://github.com/aspnet/AspNetCore/commit/cee4cf7544) Antares blocks some windows APIs. We have use socket instead of calli… (#109)
* [`[007e3b6b51]`](https://github.com/aspnet/AspNetCore/commit/007e3b6b51) Add "--no-restore" parameter to "dotnet publish" (#1101)
* [`[6860806213]`](https://github.com/aspnet/AspNetCore/commit/6860806213) Make usage of FileName and FilePath consistent
* [`[f5253459ec]`](https://github.com/aspnet/AspNetCore/commit/f5253459ec) Change nuget pacakge version to include -pre-
* [`[9797d4bc5f]`](https://github.com/aspnet/AspNetCore/commit/9797d4bc5f) Reenable API check
* [`[3cabb6aeb1]`](https://github.com/aspnet/AspNetCore/commit/3cabb6aeb1) Don't over-discover Hub methods (#511)
* [`[6ce71c24e5]`](https://github.com/aspnet/AspNetCore/commit/6ce71c24e5) Add RazorIRNodeReference for manipulating nodes
* [`[512195247a]`](https://github.com/aspnet/AspNetCore/commit/512195247a) Update DiaSymReader path update
* [`[b059bcc426]`](https://github.com/aspnet/AspNetCore/commit/b059bcc426) Obsolete AuthenticationManager (#866)
* [`[8277b2cc27]`](https://github.com/aspnet/AspNetCore/commit/8277b2cc27) Enable skipped test (#551)
* [`[a97c08843c]`](https://github.com/aspnet/AspNetCore/commit/a97c08843c) Complete IPipeWriter in OutputProducer.Abort() (#1894)
* [`[d879518a18]`](https://github.com/aspnet/AspNetCore/commit/d879518a18) Always complete RequestBodyPipe.Reader (#1893)
* [`[c27b07ef3f]`](https://github.com/aspnet/AspNetCore/commit/c27b07ef3f) Use C# 7 features
* [`[a3bcc0d863]`](https://github.com/aspnet/AspNetCore/commit/a3bcc0d863) Update debugger detection to support Node v8.1+, and stop aborting if debugger messages are unrecognised.
* [`[5e7bb0f5c5]`](https://github.com/aspnet/AspNetCore/commit/5e7bb0f5c5) Don't log OperationCanceledException every time an HMR client disconnects
* [`[8396be24c8]`](https://github.com/aspnet/AspNetCore/commit/8396be24c8) Fix VS2017.3 warning about not specifying TypeScriptToolsVersion
* [`[728b18431d]`](https://github.com/aspnet/AspNetCore/commit/728b18431d) In dotnet new templates, only show "npm install" instruction when executing in CLI
* [`[1c4b0fcdf3]`](https://github.com/aspnet/AspNetCore/commit/1c4b0fcdf3) Code clean up
* [`[a224b1a833]`](https://github.com/aspnet/AspNetCore/commit/a224b1a833) Re-enable desktop tests
* [`[d92d8cddeb]`](https://github.com/aspnet/AspNetCore/commit/d92d8cddeb) Modify ControllerBase.RedirectToPageResult to call the correct overload
* [`[f099232ca4]`](https://github.com/aspnet/AspNetCore/commit/f099232ca4) Moved scope writer logic to BasicWriter
* [`[27b73d737b]`](https://github.com/aspnet/AspNetCore/commit/27b73d737b) Set correct value style for literal tag helper bound attributes
* [`[12917ef0e9]`](https://github.com/aspnet/AspNetCore/commit/12917ef0e9) Re-layer the .NET Client into Http and non-Http (#544)
* [`[f34e87042c]`](https://github.com/aspnet/AspNetCore/commit/f34e87042c) extend timeout and more logging (#183)
* [`[e714153782]`](https://github.com/aspnet/AspNetCore/commit/e714153782) Update to PackagePublisher 1.0.2-*
* [`[503ba669d0]`](https://github.com/aspnet/AspNetCore/commit/503ba669d0) Get rid of Parent from IR node
* [`[b171431f5d]`](https://github.com/aspnet/AspNetCore/commit/b171431f5d) Fix Downgrade to NETStandard.Library 1.6.1 Warnings
* [`[14944a2791]`](https://github.com/aspnet/AspNetCore/commit/14944a2791) Add collection types for IR children
* [`[118fefb7e2]`](https://github.com/aspnet/AspNetCore/commit/118fefb7e2) Rename incorrect casing
* [`[17800b6055]`](https://github.com/aspnet/AspNetCore/commit/17800b6055) Fix #1355 Make extension nodes check for their extensions
* [`[bdea0f07ef]`](https://github.com/aspnet/AspNetCore/commit/bdea0f07ef) Fix SocketSample group send (#539)
* [`[27979d835f]`](https://github.com/aspnet/AspNetCore/commit/27979d835f) Clean up GroupManager (#542)
* [`[e05c697c58]`](https://github.com/aspnet/AspNetCore/commit/e05c697c58) Fix #1356 verify diagnostics in integration tests
* [`[4d18334573]`](https://github.com/aspnet/AspNetCore/commit/4d18334573) Target .NET Standard 2.0
* [`[fcc04f8c3d]`](https://github.com/aspnet/AspNetCore/commit/fcc04f8c3d) Add request body minimum data rate feature (#1874).
* [`[8bba757703]`](https://github.com/aspnet/AspNetCore/commit/8bba757703) Don't ignore whitespace at the start of '<text>' tag
* [`[b686298133]`](https://github.com/aspnet/AspNetCore/commit/b686298133) Don't throw for OnStarting or OnCompleted calls. (#864)
* [`[fc54fef0bf]`](https://github.com/aspnet/AspNetCore/commit/fc54fef0bf) Fix nuget output path (#107)
* [`[6c69cb8f36]`](https://github.com/aspnet/AspNetCore/commit/6c69cb8f36) Make SHA256 algorithm creation FIPS compliant.
* [`[bdf115a5ff]`](https://github.com/aspnet/AspNetCore/commit/bdf115a5ff) Make SHA256 algorithm creation FIPS compliant.
* [`[05dd8c7386]`](https://github.com/aspnet/AspNetCore/commit/05dd8c7386) Add the npm 5 lockfile to source
* [`[bf6d2227db]`](https://github.com/aspnet/AspNetCore/commit/bf6d2227db) In dotnet new templates, display instruction to run "npm install" manually
* [`[bcaa3af92e]`](https://github.com/aspnet/AspNetCore/commit/bcaa3af92e) Re-add bootstrap import
* [`[f3b7103c83]`](https://github.com/aspnet/AspNetCore/commit/f3b7103c83) In AngularSpa template, redefine app.module.shared as a real NgModule. Fixes #986.
* [`[0dd24068ca]`](https://github.com/aspnet/AspNetCore/commit/0dd24068ca) Update VS template name localisation IDs and texts as instructed
* [`[0526852e05]`](https://github.com/aspnet/AspNetCore/commit/0526852e05) Pin templates' .NET reference version numbers on Coherence 25571 in same way as stock Web templates do. This also fixes net461 support.
* [`[523517f60c]`](https://github.com/aspnet/AspNetCore/commit/523517f60c) Add support for timing out poll requests (#538)
* [`[d58bcba814]`](https://github.com/aspnet/AspNetCore/commit/d58bcba814) Re-enable symbols generation on x86
* [`[0e3f19e3bf]`](https://github.com/aspnet/AspNetCore/commit/0e3f19e3bf) Skip symbol zips when no symbols are produced
* [`[8766528470]`](https://github.com/aspnet/AspNetCore/commit/8766528470) Update shared framework version to 2.0.0-preview2-25407-01
* [`[49206c14f0]`](https://github.com/aspnet/AspNetCore/commit/49206c14f0) Sort
* [`[7fbca28188]`](https://github.com/aspnet/AspNetCore/commit/7fbca28188) Fix downgrade warning
* [`[448e6787e2]`](https://github.com/aspnet/AspNetCore/commit/448e6787e2) Fix auth enabled check
* [`[a6d2c04195]`](https://github.com/aspnet/AspNetCore/commit/a6d2c04195) [Fixes #1379] Rename CSharpStatement to CSharpCode
* [`[1124eb5016]`](https://github.com/aspnet/AspNetCore/commit/1124eb5016) Perform case insensitive lookups for precompiled views
* [`[60c8a3471d]`](https://github.com/aspnet/AspNetCore/commit/60c8a3471d) Enable localisation for template names/descriptions in VS
* [`[d1df3671d8]`](https://github.com/aspnet/AspNetCore/commit/d1df3671d8) Add Auth Test that was accidentally deleted (#541)
* [`[8f883e8e13]`](https://github.com/aspnet/AspNetCore/commit/8f883e8e13) Use RazorViewAttribute \ RazorPageAttribute for view discovery
* [`[2845e9b7d4]`](https://github.com/aspnet/AspNetCore/commit/2845e9b7d4) Add configuration package reference because Logging dropped it (#6375)
* [`[95c5049dd0]`](https://github.com/aspnet/AspNetCore/commit/95c5049dd0) Add DisplayName and Description for directives
* [`[45dec0dca4]`](https://github.com/aspnet/AspNetCore/commit/45dec0dca4) Fix #1407 null refs in VCTH tests
* [`[f96c48c08d]`](https://github.com/aspnet/AspNetCore/commit/f96c48c08d) Add a request body size limit (#1877)
* [`[9dedc98094]`](https://github.com/aspnet/AspNetCore/commit/9dedc98094) Deprecate the IAuthenticationHandler property (#863)
* [`[ccef6b261b]`](https://github.com/aspnet/AspNetCore/commit/ccef6b261b) Lift Microsoft.Extensions.WebEncoders to target .NET Standard 2.0
* [`[50f1d8f9fe]`](https://github.com/aspnet/AspNetCore/commit/50f1d8f9fe) Added IHubProtocol to ts client (#537)
* [`[5127a74d3f]`](https://github.com/aspnet/AspNetCore/commit/5127a74d3f) Clean up dependencies.props
* [`[2aaceaa9f8]`](https://github.com/aspnet/AspNetCore/commit/2aaceaa9f8) Move core packages to netstandard2.0
* [`[0bbe42a912]`](https://github.com/aspnet/AspNetCore/commit/0bbe42a912) Unbreak the chat sample
* [`[1fad901843]`](https://github.com/aspnet/AspNetCore/commit/1fad901843) Fix inherited hub auth and added tests (#535)
* [`[a754e91f37]`](https://github.com/aspnet/AspNetCore/commit/a754e91f37) Update sample test app to netstandard2.0
* [`[35ec06975d]`](https://github.com/aspnet/AspNetCore/commit/35ec06975d) Use file globbing to resolve manifests
* [`[0362488242]`](https://github.com/aspnet/AspNetCore/commit/0362488242) Lift sample test app to .NET Standard 2.0
* [`[89057003b3]`](https://github.com/aspnet/AspNetCore/commit/89057003b3) Check IHttpMaxRequestBodySizeFeature.IsReadOnly (#379)
* [`[289a87f7c8]`](https://github.com/aspnet/AspNetCore/commit/289a87f7c8) Manually construct the precompilation nupkg.
* [`[a14a0ab039]`](https://github.com/aspnet/AspNetCore/commit/a14a0ab039) Adding structured negotiate
* [`[74fef5f722]`](https://github.com/aspnet/AspNetCore/commit/74fef5f722) Moved VCTH types to Razor.Extensions
* [`[4c4be7ed6f]`](https://github.com/aspnet/AspNetCore/commit/4c4be7ed6f) Add support for Hub Authorize Attribute (#532)
* [`[fd7abb31e8]`](https://github.com/aspnet/AspNetCore/commit/fd7abb31e8) Lift M.ANC.Sockets.Common to .NET Standard 2.0
* [`[2176af7edd]`](https://github.com/aspnet/AspNetCore/commit/2176af7edd) Add IHttpMaxRequestBodySizeFeature.IsReadOnly (#858)
* [`[028bd68bf5]`](https://github.com/aspnet/AspNetCore/commit/028bd68bf5) Removing unneeded queryString from TS client
* [`[3448b6a74e]`](https://github.com/aspnet/AspNetCore/commit/3448b6a74e) Re-enable net461 functional tests.
* [`[d9531031a8]`](https://github.com/aspnet/AspNetCore/commit/d9531031a8) Updated to netstandard2.0
* [`[265c980c2b]`](https://github.com/aspnet/AspNetCore/commit/265c980c2b) Manually construct the precompilation nupkg.
* [`[b19146dcc5]`](https://github.com/aspnet/AspNetCore/commit/b19146dcc5) Update shared framework version to 2.0.0-preview2-25406-03 (#145)
* [`[6664efb6d9]`](https://github.com/aspnet/AspNetCore/commit/6664efb6d9) Fixes #1296 - ItemCollection should be ICollection
* [`[b328ce48ad]`](https://github.com/aspnet/AspNetCore/commit/b328ce48ad) Updated Readme
* [`[59a8f5f3b5]`](https://github.com/aspnet/AspNetCore/commit/59a8f5f3b5) Simplify the JSON and protobuf protocols (#524)
* [`[59ec6e0c50]`](https://github.com/aspnet/AspNetCore/commit/59ec6e0c50) Updated refereces of 'rel/2.0.0-preview2' to 'dev'
* [`[af91b58bd3]`](https://github.com/aspnet/AspNetCore/commit/af91b58bd3) Enabled a way to buffer request body in formatters
* [`[07e975a0ed]`](https://github.com/aspnet/AspNetCore/commit/07e975a0ed) Return a shared contract resolver
* [`[d4a83886dd]`](https://github.com/aspnet/AspNetCore/commit/d4a83886dd) Override with shared framework version
* [`[d0d9298f6d]`](https://github.com/aspnet/AspNetCore/commit/d0d9298f6d) Put runtime version into dependencies.props and rename.
* [`[cde593c0e0]`](https://github.com/aspnet/AspNetCore/commit/cde593c0e0) Allow overriding RuntimeFrameworkVersion used for deps generation.
* [`[cb389fe9b0]`](https://github.com/aspnet/AspNetCore/commit/cb389fe9b0) Display info for dotnet used to create runtime store and deps files
* [`[b9e397ed3b]`](https://github.com/aspnet/AspNetCore/commit/b9e397ed3b) Temporarily workaround TryGetPageDirective returning null instead of empty string.
* [`[c261b37fda]`](https://github.com/aspnet/AspNetCore/commit/c261b37fda) #371 Conditionally register auth scheme base on ANCM variable
* [`[d5c1c63d19]`](https://github.com/aspnet/AspNetCore/commit/d5c1c63d19) Generate assembly attributes as part of code generation
* [`[20c04d099e]`](https://github.com/aspnet/AspNetCore/commit/20c04d099e) Update to use Razor parser to parse page directive
* [`[ae3dfcdb32]`](https://github.com/aspnet/AspNetCore/commit/ae3dfcdb32) Remote ConfigureDefaultOptions
* [`[c3ffde286b]`](https://github.com/aspnet/AspNetCore/commit/c3ffde286b) Clear MaxRequestBodySize
* [`[f1901516c6]`](https://github.com/aspnet/AspNetCore/commit/f1901516c6) #519 Expose a connection limit option
* [`[b796bc0f39]`](https://github.com/aspnet/AspNetCore/commit/b796bc0f39) Add Page filters
* [`[e2c6eab554]`](https://github.com/aspnet/AspNetCore/commit/e2c6eab554) Update Roslyn dependency for C# 7.1
* [`[8f299c5b11]`](https://github.com/aspnet/AspNetCore/commit/8f299c5b11) Update Roslyn Version to support C# 7.1
* [`[fcb8669c98]`](https://github.com/aspnet/AspNetCore/commit/fcb8669c98) Use project.json for the VSIX project
* [`[cad9f2f671]`](https://github.com/aspnet/AspNetCore/commit/cad9f2f671) Use RX in streaming sample
* [`[43eb9574a1]`](https://github.com/aspnet/AspNetCore/commit/43eb9574a1) Fix invalid format string (#181)
* [`[ac3cbb5f8d]`](https://github.com/aspnet/AspNetCore/commit/ac3cbb5f8d) Generated api check baselines for AzureStorage
* [`[5870fce035]`](https://github.com/aspnet/AspNetCore/commit/5870fce035) Add configure delegate for CookieOptions
* [`[db9ae62632]`](https://github.com/aspnet/AspNetCore/commit/db9ae62632) IInitializeOptions => IPostConfigureOptions
* [`[9698f539f0]`](https://github.com/aspnet/AspNetCore/commit/9698f539f0) Add IHttpMaxRequestBodySizeFeature (#852)
* [`[3932c68d18]`](https://github.com/aspnet/AspNetCore/commit/3932c68d18) Move KestrelServerOptionsSetup to Kestrel
* [`[c6e228d176]`](https://github.com/aspnet/AspNetCore/commit/c6e228d176)  #1875 Add Configuration support and tests.
* [`[5e2bb55be0]`](https://github.com/aspnet/AspNetCore/commit/5e2bb55be0) Change Certificates.Configuration to a Sources package
* [`[fe83e69b1a]`](https://github.com/aspnet/AspNetCore/commit/fe83e69b1a) Add a startup filter which initializes the key ring before the server starts
* [`[285b973a5c]`](https://github.com/aspnet/AspNetCore/commit/285b973a5c) Use IHostingEnvironment to determine application identifier
* [`[2625e2a768]`](https://github.com/aspnet/AspNetCore/commit/2625e2a768) Consolidate runtime store dependencies into one package
* [`[de5b3560d5]`](https://github.com/aspnet/AspNetCore/commit/de5b3560d5) Skip symbol generation during runtime store creation
* [`[22ebf68f74]`](https://github.com/aspnet/AspNetCore/commit/22ebf68f74) Enable Api check and added breakingchanges json
* [`[a55b818a07]`](https://github.com/aspnet/AspNetCore/commit/a55b818a07) Bind AuthenticationOptions to config + PathString type converter (#851)
* [`[ec36c3d491]`](https://github.com/aspnet/AspNetCore/commit/ec36c3d491) Bind AuthenticationOptions to config + PathString type converter (#851)
* [`[fc1dbbbcfd]`](https://github.com/aspnet/AspNetCore/commit/fc1dbbbcfd) Adds a missing ToList() in assert code.
* [`[4e91e4e36f]`](https://github.com/aspnet/AspNetCore/commit/4e91e4e36f) Correct short-circuit log message for result filters (#6350)
* [`[d10a6293bd]`](https://github.com/aspnet/AspNetCore/commit/d10a6293bd) Discover hub methods at startup time (#503)
* [`[1f32a8322e]`](https://github.com/aspnet/AspNetCore/commit/1f32a8322e) Make invalid namespace tokens support IntelliSense.
* [`[2e8c154fcb]`](https://github.com/aspnet/AspNetCore/commit/2e8c154fcb) Make namespace tokens tolerant to EOF and invalid states.
* [`[a0d9b08f58]`](https://github.com/aspnet/AspNetCore/commit/a0d9b08f58) Set Content-Length and increase BufferSize (#6347)
* [`[e31fc1e57d]`](https://github.com/aspnet/AspNetCore/commit/e31fc1e57d) Closing transports with error if hubs cannot be created
* [`[2dbe4b79c4]`](https://github.com/aspnet/AspNetCore/commit/2dbe4b79c4) Fix functional tests to properly dispose of their app deployer.
* [`[b899775185]`](https://github.com/aspnet/AspNetCore/commit/b899775185) Add configurable SameSite cookie option
* [`[4a308f1e9d]`](https://github.com/aspnet/AspNetCore/commit/4a308f1e9d) Make SimpleAppDesktopOnly look like other testapp projects.
* [`[263dd0e4fe]`](https://github.com/aspnet/AspNetCore/commit/263dd0e4fe) Fix #324 by adding streaming support to the server (#461)
* [`[249c39e803]`](https://github.com/aspnet/AspNetCore/commit/249c39e803) Temporarily skip NanoServer's IIS tests
* [`[27c6ad410e]`](https://github.com/aspnet/AspNetCore/commit/27c6ad410e) Skip desktop testing to work around corefx issue.
* [`[6e88ea9429]`](https://github.com/aspnet/AspNetCore/commit/6e88ea9429) Add support for pre-compiling desktop applications.
* [`[3a4cae72bd]`](https://github.com/aspnet/AspNetCore/commit/3a4cae72bd) Use Strict SameSite mode for temp data cookies
* [`[44ccbee9ba]`](https://github.com/aspnet/AspNetCore/commit/44ccbee9ba) Moving CertificateLoader from MetaPackages to Hosting.
* [`[b04be188c0]`](https://github.com/aspnet/AspNetCore/commit/b04be188c0) #81 Move CertificateLoader to Hosting
* [`[0688cd3ef7]`](https://github.com/aspnet/AspNetCore/commit/0688cd3ef7) Log errors if directives do not start at beginning of line.
* [`[3b53f04518]`](https://github.com/aspnet/AspNetCore/commit/3b53f04518) Change ParserContext to take a RazorSourceDocument.
* [`[e3366c7640]`](https://github.com/aspnet/AspNetCore/commit/e3366c7640) Cross-compile netcoreapp2.0 and net461
* [`[a334e88597]`](https://github.com/aspnet/AspNetCore/commit/a334e88597) Decrease connections used in ConnectionCountingReturnsToZero for slow test agents (#1872)
* [`[1b6993fb91]`](https://github.com/aspnet/AspNetCore/commit/1b6993fb91) Database Error Page: Prep for removal of ILogger-based interception.
* [`[402b337178]`](https://github.com/aspnet/AspNetCore/commit/402b337178) Temporary workaround for GenerateResource task error on VS.
* [`[1dc8a67aca]`](https://github.com/aspnet/AspNetCore/commit/1dc8a67aca) Correct content TFM path
* [`[1b97a7fff6]`](https://github.com/aspnet/AspNetCore/commit/1b97a7fff6) #58 Retarget Xdt and SiteExtension to net461
* [`[a66cca5e22]`](https://github.com/aspnet/AspNetCore/commit/a66cca5e22) Add net461 test targets
* [`[0177ab8424]`](https://github.com/aspnet/AspNetCore/commit/0177ab8424) Change SelfHostDepoyer to use net461
* [`[eb4be67863]`](https://github.com/aspnet/AspNetCore/commit/eb4be67863) Add temporary NPV exception
* [`[39fd6974f7]`](https://github.com/aspnet/AspNetCore/commit/39fd6974f7) Updated to use the latest shared runtime
* [`[e65a67bb5c]`](https://github.com/aspnet/AspNetCore/commit/e65a67bb5c) Updated to use the latest shared runtime
* [`[4056e86382]`](https://github.com/aspnet/AspNetCore/commit/4056e86382) Updated to use the latest shared runtime
* [`[baddfe50ba]`](https://github.com/aspnet/AspNetCore/commit/baddfe50ba) Updated to use the latest shared runtime
* [`[df75fd2188]`](https://github.com/aspnet/AspNetCore/commit/df75fd2188) Updated to use the latest shared runtime
* [`[0a6b11d160]`](https://github.com/aspnet/AspNetCore/commit/0a6b11d160) Updated to use the latest shared runtime
* [`[402f979c1c]`](https://github.com/aspnet/AspNetCore/commit/402f979c1c) Updated to use the latest shared runtime
* [`[087183ea18]`](https://github.com/aspnet/AspNetCore/commit/087183ea18) Updated to use the latest shared runtime
* [`[bdd09062ff]`](https://github.com/aspnet/AspNetCore/commit/bdd09062ff) Updated to use the latest shared runtime
* [`[762d52133c]`](https://github.com/aspnet/AspNetCore/commit/762d52133c) Change Base64 to Base64Encoder (#492)
* [`[8273d0aa27]`](https://github.com/aspnet/AspNetCore/commit/8273d0aa27) Rename ApplicationInsights test project (#60)
* [`[b862d35b10]`](https://github.com/aspnet/AspNetCore/commit/b862d35b10) Update Targets (#486)
* [`[4b18cf52ae]`](https://github.com/aspnet/AspNetCore/commit/4b18cf52ae) Add ConfigureAspNetCoreDefaults
* [`[a99d1d96cc]`](https://github.com/aspnet/AspNetCore/commit/a99d1d96cc) Add new identity packages back
* [`[597a0c9a11]`](https://github.com/aspnet/AspNetCore/commit/597a0c9a11) Add support for friendly routes in pages
* [`[1939384685]`](https://github.com/aspnet/AspNetCore/commit/1939384685) Add Microsoft.AspNetCore.Identity.Service.AzureKeyVault package
* [`[461d8a77db]`](https://github.com/aspnet/AspNetCore/commit/461d8a77db) Updated to use the latest shared runtime
* [`[176be2749d]`](https://github.com/aspnet/AspNetCore/commit/176be2749d) Updated to use the latest shared runtime
* [`[87d063b2b5]`](https://github.com/aspnet/AspNetCore/commit/87d063b2b5) Updated to use the latest shared runtime
* [`[9dd8f1c4b9]`](https://github.com/aspnet/AspNetCore/commit/9dd8f1c4b9) Updated to use the latest shared runtime
* [`[0276c4b0a0]`](https://github.com/aspnet/AspNetCore/commit/0276c4b0a0) Updated to use the latest shared runtime
* [`[6a17e4899c]`](https://github.com/aspnet/AspNetCore/commit/6a17e4899c) Updated to use the latest shared runtime
* [`[fcb96242a7]`](https://github.com/aspnet/AspNetCore/commit/fcb96242a7) Updated to use the latest shared runtime
* [`[758006d17f]`](https://github.com/aspnet/AspNetCore/commit/758006d17f) Updated to use the latest shared runtime
* [`[db88056e77]`](https://github.com/aspnet/AspNetCore/commit/db88056e77) Updated to use the latest shared runtime
* [`[a2c22afd7e]`](https://github.com/aspnet/AspNetCore/commit/a2c22afd7e) Updated to use the latest shared runtime
* [`[c7ba8137a8]`](https://github.com/aspnet/AspNetCore/commit/c7ba8137a8) Updated to use the latest shared runtime
* [`[46dd25fcac]`](https://github.com/aspnet/AspNetCore/commit/46dd25fcac) Updated to use the latest shared runtime
* [`[57647bff2e]`](https://github.com/aspnet/AspNetCore/commit/57647bff2e) Updated to use the latest shared runtime
* [`[85d712251d]`](https://github.com/aspnet/AspNetCore/commit/85d712251d) Updated to use the latest shared runtime
* [`[bd921bf96d]`](https://github.com/aspnet/AspNetCore/commit/bd921bf96d) Updated to use the latest shared runtime
* [`[9ef496fe5b]`](https://github.com/aspnet/AspNetCore/commit/9ef496fe5b) Updated to use the latest shared runtime
* [`[6d3ce16da9]`](https://github.com/aspnet/AspNetCore/commit/6d3ce16da9) Updated to use the latest shared runtime
* [`[0ab3f1e94f]`](https://github.com/aspnet/AspNetCore/commit/0ab3f1e94f) Updated to use the latest shared runtime
* [`[688e518991]`](https://github.com/aspnet/AspNetCore/commit/688e518991) Add result filters to pages
* [`[84e007a2a7]`](https://github.com/aspnet/AspNetCore/commit/84e007a2a7) Move exception and result filters in base
* [`[dcccea3004]`](https://github.com/aspnet/AspNetCore/commit/dcccea3004) Add Checksum computation to RazorSourceDocument.
* [`[c343628926]`](https://github.com/aspnet/AspNetCore/commit/c343628926) Implement max connection limits
* [`[c523839078]`](https://github.com/aspnet/AspNetCore/commit/c523839078) Update default settings for SameSite
* [`[8c822a8e77]`](https://github.com/aspnet/AspNetCore/commit/8c822a8e77) Move away from `Assembly.Load` to Assembly.LoadFile
* [`[1619166911]`](https://github.com/aspnet/AspNetCore/commit/1619166911) Update manifest names
* [`[c3f7613725]`](https://github.com/aspnet/AspNetCore/commit/c3f7613725) Make RazorReferenceManage public
* [`[3b488c470a]`](https://github.com/aspnet/AspNetCore/commit/3b488c470a) Make IHostedServiceAsync
* [`[cb9f44ddf6]`](https://github.com/aspnet/AspNetCore/commit/cb9f44ddf6) Fixing WebSocketsTransport to handle exceptions correctly
* [`[348cdf9da9]`](https://github.com/aspnet/AspNetCore/commit/348cdf9da9) Fix sln
* [`[fbf7e1fb72]`](https://github.com/aspnet/AspNetCore/commit/fbf7e1fb72) Add auth reference
* [`[ad6b029443]`](https://github.com/aspnet/AspNetCore/commit/ad6b029443) Temporarily disable MVC functional tests on net461
* [`[d387e6b560]`](https://github.com/aspnet/AspNetCore/commit/d387e6b560) Fix package reference
* [`[e3cae98a05]`](https://github.com/aspnet/AspNetCore/commit/e3cae98a05) Add new packages
* [`[b1f92fb6bc]`](https://github.com/aspnet/AspNetCore/commit/b1f92fb6bc) Forbid + obsolete context.Authentication
* [`[7bd98f5cf9]`](https://github.com/aspnet/AspNetCore/commit/7bd98f5cf9) Update TFM to netstandard2.0 (#53)
* [`[009759c7f6]`](https://github.com/aspnet/AspNetCore/commit/009759c7f6) Fix broken microbenchmarks (#1861).
* [`[d917311883]`](https://github.com/aspnet/AspNetCore/commit/d917311883) Make ViewComponentTagHelper's bound attribute display names nicer.
* [`[cdddaefa81]`](https://github.com/aspnet/AspNetCore/commit/cdddaefa81) Fixed a bug in VCTH pass and added an integration test
* [`[bb5eb96625]`](https://github.com/aspnet/AspNetCore/commit/bb5eb96625) Load the precompilation type from the loaded assembly
* [`[03404cd3df]`](https://github.com/aspnet/AspNetCore/commit/03404cd3df) Return to NetStandard
* [`[ab64769c59]`](https://github.com/aspnet/AspNetCore/commit/ab64769c59) Fix compilation failure
* [`[452578e4a8]`](https://github.com/aspnet/AspNetCore/commit/452578e4a8) Revisit the architecture of CompilerCache
* [`[75fd215b1a]`](https://github.com/aspnet/AspNetCore/commit/75fd215b1a) Change Microsoft.DotNet.Web.Spa.ProjectTemplates to use 1.0.0-preview-* version numbers since the first release will be 1.0.0
* [`[bee4c6ff11]`](https://github.com/aspnet/AspNetCore/commit/bee4c6ff11) Stop "dotnet new" from stripping out important parts of .csproj files
* [`[cc859306a3]`](https://github.com/aspnet/AspNetCore/commit/cc859306a3) Make template package version numbers more descriptive
* [`[30392a1811]`](https://github.com/aspnet/AspNetCore/commit/30392a1811) Retarget to netstandard2.0 and net461
* [`[3963a6aa52]`](https://github.com/aspnet/AspNetCore/commit/3963a6aa52) #125 Add HostingStartup packages to .All
* [`[c1dd95be2a]`](https://github.com/aspnet/AspNetCore/commit/c1dd95be2a) Add a test for #6294
* [`[b9a9ec9305]`](https://github.com/aspnet/AspNetCore/commit/b9a9ec9305) Add support for a default SSL certificate in development When the ssl certificate specified is 'localhost' and no certificate has been explicitly specified in the certificates section, fallback to a certificate with 'CN=localhost' (ASP.NET Core SSL developer certificate) in the current user store and if not found, an ssl certificate with 'CN=localhost' on the current machine (IIS Express developer certificate)
* [`[2992f8e38a]`](https://github.com/aspnet/AspNetCore/commit/2992f8e38a) Separate PageContext and ViewContext
* [`[3f36fa5986]`](https://github.com/aspnet/AspNetCore/commit/3f36fa5986) Fix sample
* [`[9428d1778d]`](https://github.com/aspnet/AspNetCore/commit/9428d1778d) Upgrade corefx packages to 4.4.0
* [`[d25dbd572c]`](https://github.com/aspnet/AspNetCore/commit/d25dbd572c) Target NETStandard2.0
* [`[b706a75e03]`](https://github.com/aspnet/AspNetCore/commit/b706a75e03) Target .NET Standard 2.0
* [`[c592282646]`](https://github.com/aspnet/AspNetCore/commit/c592282646) Fix Node debugging by catching warning
* [`[a322fea940]`](https://github.com/aspnet/AspNetCore/commit/a322fea940) Add data received logs to SSE and LongPolling in TS client (#484)
* [`[1165a1de33]`](https://github.com/aspnet/AspNetCore/commit/1165a1de33) Updates to generated resource files
* [`[9a6cb89b8d]`](https://github.com/aspnet/AspNetCore/commit/9a6cb89b8d) Adjusted example error message to reflect the situation that causes the error.
* [`[a18f59ab88]`](https://github.com/aspnet/AspNetCore/commit/a18f59ab88) Changed expected exception message to the one defined in Resources.resx.
* [`[f457c7b9d8]`](https://github.com/aspnet/AspNetCore/commit/f457c7b9d8) Changed expected parameter p2 to non-optional as it is non-optional in the template string.
* [`[b86e9f9254]`](https://github.com/aspnet/AspNetCore/commit/b86e9f9254) Change template description to be consistent with others in 2.0
* [`[d55ebfeee0]`](https://github.com/aspnet/AspNetCore/commit/d55ebfeee0) Split http and non-http layers (#487)
* [`[970dc6c457]`](https://github.com/aspnet/AspNetCore/commit/970dc6c457) Add --silent to npm install command in CI. Fixes #972 (at least, to the extent that fixing it is reasonably possible)
* [`[6baa2faf09]`](https://github.com/aspnet/AspNetCore/commit/6baa2faf09) Split out built-in templates into new package Microsoft.DotNet.Web.Spa.ProjectTemplates
* [`[aaea92906f]`](https://github.com/aspnet/AspNetCore/commit/aaea92906f) Add explicit decimal data types
* [`[bce531f61a]`](https://github.com/aspnet/AspNetCore/commit/bce531f61a) add features: flowing authentication info, hosting environment variable support; fix client disconnect and app_offline issues (#102)
* [`[03bdb40f8a]`](https://github.com/aspnet/AspNetCore/commit/03bdb40f8a) Add UseShutdownTimeout Extension (#1086)
* [`[ec2faf5594]`](https://github.com/aspnet/AspNetCore/commit/ec2faf5594) Target netstandard2.0
* [`[efb097ce60]`](https://github.com/aspnet/AspNetCore/commit/efb097ce60) Target .NET Standard 2.0 and add net461 testing
* [`[a6d97d35e3]`](https://github.com/aspnet/AspNetCore/commit/a6d97d35e3) Add back support for AddTagHelpersAsServices
* [`[e681c23d5c]`](https://github.com/aspnet/AspNetCore/commit/e681c23d5c) Add ITagHelperComponentManager (#6302)
* [`[39f1f5c933]`](https://github.com/aspnet/AspNetCore/commit/39f1f5c933) Move Pages filter creation to application model provider
* [`[7ac6842d18]`](https://github.com/aspnet/AspNetCore/commit/7ac6842d18) #1075 Suppress exceptions from failing to load HostingStartup assemblies
* [`[e48eef8347]`](https://github.com/aspnet/AspNetCore/commit/e48eef8347) Add privateassets=all to NS.Library.NETFramework reference
* [`[4ab7a19dc2]`](https://github.com/aspnet/AspNetCore/commit/4ab7a19dc2) Target netstandard2.0.
* [`[769da5fd87]`](https://github.com/aspnet/AspNetCore/commit/769da5fd87) Add SameSitePolicy to CookiePolicyMiddleware
* [`[e1c90b3601]`](https://github.com/aspnet/AspNetCore/commit/e1c90b3601) Change "dotnet new" config choices to reference netcoreapp2.0 (not that it makes a difference when it's the only choice)
* [`[b9e62cd4c9]`](https://github.com/aspnet/AspNetCore/commit/b9e62cd4c9) Fix "dotnet new" postAction issues (and disable the "npm install" action)
* [`[9d9a52119e]`](https://github.com/aspnet/AspNetCore/commit/9d9a52119e) Progress towards splitting the layers (#473)
* [`[ad9cfbb176]`](https://github.com/aspnet/AspNetCore/commit/ad9cfbb176) Make quotes consistent
* [`[941ae9a34d]`](https://github.com/aspnet/AspNetCore/commit/941ae9a34d) Add postActions to "dotnet new" templates
* [`[083f55e337]`](https://github.com/aspnet/AspNetCore/commit/083f55e337) Delete pranav's test logs :)
* [`[c2262b7234]`](https://github.com/aspnet/AspNetCore/commit/c2262b7234) Update TFM to netstandard2.0 (#112)
* [`[a05ad22173]`](https://github.com/aspnet/AspNetCore/commit/a05ad22173) Target NETStandard2.0
* [`[8f3d04870f]`](https://github.com/aspnet/AspNetCore/commit/8f3d04870f) Target .NET Standard 2.0
* [`[2ce2d8b6c5]`](https://github.com/aspnet/AspNetCore/commit/2ce2d8b6c5) #758 Convert the header parsers to use StringSegment
* [`[d6a653145d]`](https://github.com/aspnet/AspNetCore/commit/d6a653145d) Target NETStandard 2.0
* [`[df36d02311]`](https://github.com/aspnet/AspNetCore/commit/df36d02311) Retarget to netstandard2.0
* [`[e8123db21e]`](https://github.com/aspnet/AspNetCore/commit/e8123db21e) Add SameSite attribute to SetCookie header
* [`[c5f771d96d]`](https://github.com/aspnet/AspNetCore/commit/c5f771d96d) Use factory pattern for caching in ControllerActionInvoker
* [`[197eb43d8a]`](https://github.com/aspnet/AspNetCore/commit/197eb43d8a) Read request body concurrent to app execution.
* [`[e68a1b294f]`](https://github.com/aspnet/AspNetCore/commit/e68a1b294f) Fix long polling graceful shutdown (#476)
* [`[3645ae6cf2]`](https://github.com/aspnet/AspNetCore/commit/3645ae6cf2) Generate Documentation files
* [`[323dae4ce9]`](https://github.com/aspnet/AspNetCore/commit/323dae4ce9) Handle case where scanning happens after dispose. (#475)
* [`[87c4da41e8]`](https://github.com/aspnet/AspNetCore/commit/87c4da41e8) Disabling hosting startup - VS injects a bad version of AppInsights because it doesn't check the shared framework version in use. Since we constantly are on the bleeding edge, we get out of sync frequently. This change disables them from running.
* [`[390582dcf1]`](https://github.com/aspnet/AspNetCore/commit/390582dcf1) Target .NET Standard 2.0 (#1849)
* [`[240a88f7af]`](https://github.com/aspnet/AspNetCore/commit/240a88f7af) Make the http end points more resty (#470)
* [`[b6f558d60b]`](https://github.com/aspnet/AspNetCore/commit/b6f558d60b) Fix flaxy test (#1079)
* [`[c7bac3133f]`](https://github.com/aspnet/AspNetCore/commit/c7bac3133f) Chain hosting timeout to StopAsync cancellation token (#1078)
* [`[62cd07d0a6]`](https://github.com/aspnet/AspNetCore/commit/62cd07d0a6) Target NETStandard2.0 and add WindowsServices back
* [`[e3114dc6a4]`](https://github.com/aspnet/AspNetCore/commit/e3114dc6a4) Temporarily change tfm to netstandard1.3 Ideally we want to target netstandard2.0 but this conversion is blocked on the issue: https://github.com/dotnet/sdk/issues/1219
* [`[9bc9f0ef05]`](https://github.com/aspnet/AspNetCore/commit/9bc9f0ef05) Rename HtmlCase => HtmlConventions.
* [`[6b1117caa9]`](https://github.com/aspnet/AspNetCore/commit/6b1117caa9) Make this type internal
* [`[9aff0a67c1]`](https://github.com/aspnet/AspNetCore/commit/9aff0a67c1) Range support for FileResult(#6150)
* [`[315221c758]`](https://github.com/aspnet/AspNetCore/commit/315221c758) Re-enable some skipped tests
* [`[4bb9721d39]`](https://github.com/aspnet/AspNetCore/commit/4bb9721d39) Adding strongly typed Invoke and On overloads
* [`[2a88d6efcf]`](https://github.com/aspnet/AspNetCore/commit/2a88d6efcf) Fix aspnet/Mvc#6296 sanitize class and namespace
* [`[d5483f3b64]`](https://github.com/aspnet/AspNetCore/commit/d5483f3b64) Add workaround for 'publish' tests failing since 2.0 update
* [`[e1a0931ca0]`](https://github.com/aspnet/AspNetCore/commit/e1a0931ca0) Add reference to NodeServices and SpaServices
* [`[9e59ed4bc8]`](https://github.com/aspnet/AspNetCore/commit/9e59ed4bc8) Put back <IsPackable>false</IsPackable> on template csproj files
* [`[ac3ab36b3d]`](https://github.com/aspnet/AspNetCore/commit/ac3ab36b3d) Add JavaScriptServices to Universe
* [`[42b88c15f2]`](https://github.com/aspnet/AspNetCore/commit/42b88c15f2) Make all templates as consistent as possible with stock MVC Core 2.0 one
* [`[74239f08c0]`](https://github.com/aspnet/AspNetCore/commit/74239f08c0) Update TFM to netstandard2.0
* [`[8580226a4b]`](https://github.com/aspnet/AspNetCore/commit/8580226a4b) #51 Add AzureSiteExtension tag and package type
* [`[4c98b7f8f3]`](https://github.com/aspnet/AspNetCore/commit/4c98b7f8f3) Make ViewComponentTagHelper's display name nicer.
* [`[6e87b0f5eb]`](https://github.com/aspnet/AspNetCore/commit/6e87b0f5eb) Target netstandard2.0 TFM
* [`[ece5e748ad]`](https://github.com/aspnet/AspNetCore/commit/ece5e748ad) Minor documentation fix for SerializableError
* [`[03f3975360]`](https://github.com/aspnet/AspNetCore/commit/03f3975360) Allow directive string tokens to be colorized.
* [`[e391ac7a3c]`](https://github.com/aspnet/AspNetCore/commit/e391ac7a3c) Split options into ParserOptions and CodeGenerationOptions
* [`[85e59efa21]`](https://github.com/aspnet/AspNetCore/commit/85e59efa21) Rename Angular2Spa to AngularSpa, plus rephrase "Angular 2" as "Angular" in many places
* [`[811ea019a5]`](https://github.com/aspnet/AspNetCore/commit/811ea019a5) Fixes #1245 - Make TemplateCodeExtension public
* [`[88cc1c14d0]`](https://github.com/aspnet/AspNetCore/commit/88cc1c14d0) Added a new environment variable value UsePrivateAspNetCoreFile for ANCMTestFlags and fixing test issues (#101)
* [`[178a05cc33]`](https://github.com/aspnet/AspNetCore/commit/178a05cc33) Added missing Framework symbol
* [`[33b275a7d3]`](https://github.com/aspnet/AspNetCore/commit/33b275a7d3) Update ReactReduxSpa to latest versions of all dependencies, and pin to exact versions
* [`[c9d235d425]`](https://github.com/aspnet/AspNetCore/commit/c9d235d425) Update ReactSpa to latest versions of dependencies, and pin to exact versions. Simplify some instructions.
* [`[1f5a27e20a]`](https://github.com/aspnet/AspNetCore/commit/1f5a27e20a) Switch to Options Initializer
* [`[c4414c362f]`](https://github.com/aspnet/AspNetCore/commit/c4414c362f) ServerTests => Auth 2.0
* [`[8ed21d56c8]`](https://github.com/aspnet/AspNetCore/commit/8ed21d56c8) IIS => Auth 2.0
* [`[bff13c7f43]`](https://github.com/aspnet/AspNetCore/commit/bff13c7f43) HttpSysServer => Auth 2.0
* [`[07470d41b1]`](https://github.com/aspnet/AspNetCore/commit/07470d41b1) Ignore empty header values #722
* [`[7f0319f5dd]`](https://github.com/aspnet/AspNetCore/commit/7f0319f5dd) Throw InvalidOperationException from IHttpUpgradeFeature.UpgradeAsync when request is not upgradable
* [`[7bd13061b5]`](https://github.com/aspnet/AspNetCore/commit/7bd13061b5) Set the chunk generator of non-string tag helper attributes to ExpressionChunkGenerator
* [`[10f88aeafc]`](https://github.com/aspnet/AspNetCore/commit/10f88aeafc) Fix duplicate ID test warning.
* [`[b8ea008151]`](https://github.com/aspnet/AspNetCore/commit/b8ea008151) Make extensible directive type token rendering allow value types.
* [`[19f895b9ad]`](https://github.com/aspnet/AspNetCore/commit/19f895b9ad) Validate line mappings for integration tests in Razor.Extensions.
* [`[e658ee6375]`](https://github.com/aspnet/AspNetCore/commit/e658ee6375) Simplifications in ReactSpa and ReactReduxSpa
* [`[785e7d48a2]`](https://github.com/aspnet/AspNetCore/commit/785e7d48a2) Implemented react-router v4 to ReactRedux template
* [`[c791ceee49]`](https://github.com/aspnet/AspNetCore/commit/c791ceee49) Updatged package.json and webpack vendor config
* [`[d2c56d19d0]`](https://github.com/aspnet/AspNetCore/commit/d2c56d19d0) Implemented react-router-dom v4
* [`[7a11cf97fd]`](https://github.com/aspnet/AspNetCore/commit/7a11cf97fd) Updated react-router to react-router-dom 4.0.0
* [`[82dca64b8a]`](https://github.com/aspnet/AspNetCore/commit/82dca64b8a) When generating test project, do include test files
* [`[4e847f4545]`](https://github.com/aspnet/AspNetCore/commit/4e847f4545) Reference icon in vs-2017.3.host.json files
* [`[ca9c6387d0]`](https://github.com/aspnet/AspNetCore/commit/ca9c6387d0) Add template icons
* [`[d7a3289164]`](https://github.com/aspnet/AspNetCore/commit/d7a3289164) Outputs vs-2017.3.host.json file
* [`[5ade33b870]`](https://github.com/aspnet/AspNetCore/commit/5ade33b870) Update to Angular 4 (but leave directory name as Angular2Spa until finished)
* [`[d22f689fd2]`](https://github.com/aspnet/AspNetCore/commit/d22f689fd2) Add support to use System.Memory as a package instead of internilized source (#1821)
* [`[b96a486650]`](https://github.com/aspnet/AspNetCore/commit/b96a486650) Compile CodeGeneration tests
* [`[ad294fb4ba]`](https://github.com/aspnet/AspNetCore/commit/ad294fb4ba) Add a new THProvider api
* [`[a18b96cbf3]`](https://github.com/aspnet/AspNetCore/commit/a18b96cbf3) Suppress unneeded dlls from Razor VSIX
* [`[51c142ae91]`](https://github.com/aspnet/AspNetCore/commit/51c142ae91) Modify GetProperties overload (#6276)
* [`[dfd938e4f7]`](https://github.com/aspnet/AspNetCore/commit/dfd938e4f7) Fixed � in summary (#838)
* [`[9fe7c77d30]`](https://github.com/aspnet/AspNetCore/commit/9fe7c77d30) Move TagHelperBinding out of Legacy.
* [`[8616cf5dd0]`](https://github.com/aspnet/AspNetCore/commit/8616cf5dd0) Reduce catch all element completion usage.
* [`[289ecd475d]`](https://github.com/aspnet/AspNetCore/commit/289ecd475d) Added ANCMtestFlags environment variable (#98)
* [`[4d905a4110]`](https://github.com/aspnet/AspNetCore/commit/4d905a4110) Make our executor methods virtual
* [`[b5636ea871]`](https://github.com/aspnet/AspNetCore/commit/b5636ea871) Clarify contribution instructions. Fixes #934.
* [`[f70e17c138]`](https://github.com/aspnet/AspNetCore/commit/f70e17c138) Upgrade test framework versions
* [`[225c482c37]`](https://github.com/aspnet/AspNetCore/commit/225c482c37) Upgrade test framework versions
* [`[5662717983]`](https://github.com/aspnet/AspNetCore/commit/5662717983) Add null check in WriteLiteral
* [`[8b455ecae7]`](https://github.com/aspnet/AspNetCore/commit/8b455ecae7) Fixing `dotnet ef database update` Currently it is impossible to create database for the chat sample - `dotnet ef` commands fail with: "No parameterless constructor was found on 'ApplicationDbContext'. Either add a parameterless constructor to 'Application DbContext' or add an implementation of 'IDbContextFactory<ApplicationDbContext>' in the same assembly as 'ApplicationDbC ontext'." - adding IDbContextFactory implementation to fix this
* [`[5761ddd284]`](https://github.com/aspnet/AspNetCore/commit/5761ddd284) Upgrade test framework versions
* [`[1d9dcdf7ae]`](https://github.com/aspnet/AspNetCore/commit/1d9dcdf7ae) Install NuGet.CommandLine 3.5.0 to acquire nuget.exe
* [`[df9c3f9660]`](https://github.com/aspnet/AspNetCore/commit/df9c3f9660) Upgrade test framework versions
* [`[cd6befdef1]`](https://github.com/aspnet/AspNetCore/commit/cd6befdef1) Assign unique event Ids in the logger (#6270)
* [`[9ab09dbe48]`](https://github.com/aspnet/AspNetCore/commit/9ab09dbe48) Change Exception to UvException where possible (#1833)
* [`[41f1922502]`](https://github.com/aspnet/AspNetCore/commit/41f1922502) Simplify LibuvConnection.OnRead() (#1828)
* [`[04863032a2]`](https://github.com/aspnet/AspNetCore/commit/04863032a2) Increase the size of the WebSockets buffer to 4K. (#448)
* [`[5d162d79e8]`](https://github.com/aspnet/AspNetCore/commit/5d162d79e8) Upgrade test framework versions
* [`[b63b86215b]`](https://github.com/aspnet/AspNetCore/commit/b63b86215b) Upgrade test framework versions
* [`[2167e4151e]`](https://github.com/aspnet/AspNetCore/commit/2167e4151e) Fix #1311 add a base class for features
* [`[72fe4cc952]`](https://github.com/aspnet/AspNetCore/commit/72fe4cc952) Fix #1330 - make TagHelpers static class internal
* [`[2ec2b98f83]`](https://github.com/aspnet/AspNetCore/commit/2ec2b98f83) Fix #1312 - make ExecuteCore protected
* [`[2b9c69bed8]`](https://github.com/aspnet/AspNetCore/commit/2b9c69bed8) Fixes #1308 and #1315
* [`[1e148819af]`](https://github.com/aspnet/AspNetCore/commit/1e148819af) Upgrade test framework versions
* [`[75c73a31e1]`](https://github.com/aspnet/AspNetCore/commit/75c73a31e1) Upgrade test framework versions
* [`[8cf7d248e7]`](https://github.com/aspnet/AspNetCore/commit/8cf7d248e7) [Issue #1318] Renamed RuntimeTarget to CodeTarget
* [`[da1296244b]`](https://github.com/aspnet/AspNetCore/commit/da1296244b) [Issue #1316] Seal RazorTemplateEngineOptions
* [`[7e447c33ea]`](https://github.com/aspnet/AspNetCore/commit/7e447c33ea) [Issue #1317] Rename HasAnyErrors to HasErrors in tag helper descriptor api
* [`[8fbe301dc0]`](https://github.com/aspnet/AspNetCore/commit/8fbe301dc0) [Issue #1319] Make TagHelperRenderingContext internal
* [`[2274aaeead]`](https://github.com/aspnet/AspNetCore/commit/2274aaeead) [Issue #1320] Make preallocated IR nodes internal
* [`[86d045c667]`](https://github.com/aspnet/AspNetCore/commit/86d045c667) Fix #1305 move instrumentation to MVC
* [`[cb1d0f3956]`](https://github.com/aspnet/AspNetCore/commit/cb1d0f3956) Prevent infinite loop in PipelineExtensions.PeekAsyncAwaited() (#1827).
* [`[682d630fa2]`](https://github.com/aspnet/AspNetCore/commit/682d630fa2) Upgrade test framework versions and fix issues with tests
* [`[72bb0750f4]`](https://github.com/aspnet/AspNetCore/commit/72bb0750f4) Upgrade test framework versions
* [`[d916cfeadd]`](https://github.com/aspnet/AspNetCore/commit/d916cfeadd) Temporarily skipping error page middleware test
* [`[60fff08745]`](https://github.com/aspnet/AspNetCore/commit/60fff08745) Fix NormalizeRanges test
* [`[b9dabd24be]`](https://github.com/aspnet/AspNetCore/commit/b9dabd24be) Fix #1309 make CSharpDocument abstract
* [`[b758a86a38]`](https://github.com/aspnet/AspNetCore/commit/b758a86a38) Modify ViewComponent_CannotFindComponent error message (#6263)
* [`[8ecf6874e8]`](https://github.com/aspnet/AspNetCore/commit/8ecf6874e8) Upgrade test framework versions
* [`[c3ca9cf334]`](https://github.com/aspnet/AspNetCore/commit/c3ca9cf334) Upgrade test framework versions
* [`[ab98c5d837]`](https://github.com/aspnet/AspNetCore/commit/ab98c5d837) Fix #1322 #1328 #1310 #1325
* [`[0e3d091fb7]`](https://github.com/aspnet/AspNetCore/commit/0e3d091fb7) Upgrade test framework versions
* [`[906af6de30]`](https://github.com/aspnet/AspNetCore/commit/906af6de30) Update API check exceptions
* [`[5e462aa87a]`](https://github.com/aspnet/AspNetCore/commit/5e462aa87a) Added log messages related to repository information
* [`[9d58c8836b]`](https://github.com/aspnet/AspNetCore/commit/9d58c8836b) Switched from av-ts to vue-property-decorator and vue-class-component
* [`[06e3a08ac0]`](https://github.com/aspnet/AspNetCore/commit/06e3a08ac0) Multi-server
* [`[7300413d0c]`](https://github.com/aspnet/AspNetCore/commit/7300413d0c) Storing user lists per server
* [`[5d32407f24]`](https://github.com/aspnet/AspNetCore/commit/5d32407f24) More structural way of storing users
* [`[785c1251dd]`](https://github.com/aspnet/AspNetCore/commit/785c1251dd) Add auth link
* [`[d3e37f20ce]`](https://github.com/aspnet/AspNetCore/commit/d3e37f20ce) Add some new IR nodes
* [`[ae02eb436a]`](https://github.com/aspnet/AspNetCore/commit/ae02eb436a) Update auth links
* [`[11f23f7ce2]`](https://github.com/aspnet/AspNetCore/commit/11f23f7ce2) disable npm optional dependencies (#447)
* [`[2afe2e1627]`](https://github.com/aspnet/AspNetCore/commit/2afe2e1627) Rename RazorMethodDeclaration -> MethodDeclaration
* [`[3969c23316]`](https://github.com/aspnet/AspNetCore/commit/3969c23316) Adds a tracking system for Razor documents
* [`[d016950e50]`](https://github.com/aspnet/AspNetCore/commit/d016950e50) Add Aurelia and Vue to framework list
* [`[42a4e9a143]`](https://github.com/aspnet/AspNetCore/commit/42a4e9a143) Make uses of ObjectMethodExecutor internal
* [`[4bc1a76e22]`](https://github.com/aspnet/AspNetCore/commit/4bc1a76e22) Moved TagHelperBinder from pass to a phase
* [`[37f15bdd85]`](https://github.com/aspnet/AspNetCore/commit/37f15bdd85) Create Frame in FrameConnection.
* [`[eb3c47b6ca]`](https://github.com/aspnet/AspNetCore/commit/eb3c47b6ca) Add annotations
* [`[51fb1b787a]`](https://github.com/aspnet/AspNetCore/commit/51fb1b787a) Add TagHelperFactsServiceTest to validate root with parent expecting descriptor.
* [`[b9518e3684]`](https://github.com/aspnet/AspNetCore/commit/b9518e3684) Invert the dependency between connection adapters and Frame (#1822)
* [`[cf23aedb55]`](https://github.com/aspnet/AspNetCore/commit/cf23aedb55) Use EnvironmentName instead of magic string (#1065)
* [`[f5107596a5]`](https://github.com/aspnet/AspNetCore/commit/f5107596a5) Add Id to ConnectionInfo (#828)
* [`[08965550ad]`](https://github.com/aspnet/AspNetCore/commit/08965550ad) Re-enable error page runtime test.
* [`[014a786b45]`](https://github.com/aspnet/AspNetCore/commit/014a786b45) Replace IModelBindingMessageProvider with new highly-virtual base class (#6241)
* [`[9a931554d5]`](https://github.com/aspnet/AspNetCore/commit/9a931554d5) Replace RuntimeEnvironment (#1066)
* [`[991c1d8517]`](https://github.com/aspnet/AspNetCore/commit/991c1d8517) Implement new Hub Protocol (Part Deux) (#390)
* [`[774aebaa01]`](https://github.com/aspnet/AspNetCore/commit/774aebaa01) Rename TagHelperDescriptorProvider => TagHelperBinder.
* [`[d1d9bceff5]`](https://github.com/aspnet/AspNetCore/commit/d1d9bceff5) #833 Change non-standard header name 'ContentMD5' to 'Content-MD5'
* [`[a33e0cef24]`](https://github.com/aspnet/AspNetCore/commit/a33e0cef24) Upgrade StackExchange.Redis.StrongName to version 1.2.3 (#442)
* [`[47ee65f318]`](https://github.com/aspnet/AspNetCore/commit/47ee65f318) Upgrade StackExchange.Redis.StrongName to version 1.2.3 (#231)
* [`[d73b490b69]`](https://github.com/aspnet/AspNetCore/commit/d73b490b69) Fixing SocialWeather sample
* [`[a570139b08]`](https://github.com/aspnet/AspNetCore/commit/a570139b08) Fix #1059 and #1060
* [`[debc3dd433]`](https://github.com/aspnet/AspNetCore/commit/debc3dd433) Functional test to show FSharpAsync works end-to-end (#6240)
* [`[d268571db6]`](https://github.com/aspnet/AspNetCore/commit/d268571db6) Disable lightup logger if user adds AI logger (#46)
* [`[1da4e07fff]`](https://github.com/aspnet/AspNetCore/commit/1da4e07fff) Use common ObjectMethodExecutor (#440)
* [`[906f1d8f3e]`](https://github.com/aspnet/AspNetCore/commit/906f1d8f3e) Fix command on macOS
* [`[f6e6b2cce9]`](https://github.com/aspnet/AspNetCore/commit/f6e6b2cce9) Fix generation of deps files on macOS and Linux
* [`[f0a26a7f08]`](https://github.com/aspnet/AspNetCore/commit/f0a26a7f08) Migration2
* [`[a1977cac50]`](https://github.com/aspnet/AspNetCore/commit/a1977cac50) Migration
* [`[8b411493e9]`](https://github.com/aspnet/AspNetCore/commit/8b411493e9) Migration
* [`[3b644e8100]`](https://github.com/aspnet/AspNetCore/commit/3b644e8100) Migration
* [`[1f3b20e177]`](https://github.com/aspnet/AspNetCore/commit/1f3b20e177) Migration
* [`[e2cb8e8ac8]`](https://github.com/aspnet/AspNetCore/commit/e2cb8e8ac8) A new and exciting implementation of action selection
* [`[1a0331eaaa]`](https://github.com/aspnet/AspNetCore/commit/1a0331eaaa) Restore template to avoid deps trimming issue
* [`[9b80f2a635]`](https://github.com/aspnet/AspNetCore/commit/9b80f2a635) Migration
* [`[c053b8cd9d]`](https://github.com/aspnet/AspNetCore/commit/c053b8cd9d) Fixing Win7 tests
* [`[13ea876ca1]`](https://github.com/aspnet/AspNetCore/commit/13ea876ca1) Register IApplicationDiscriminator service
* [`[e780d31ce3]`](https://github.com/aspnet/AspNetCore/commit/e780d31ce3) Updated store tests to work on linux an osx too
* [`[ec0ce4b638]`](https://github.com/aspnet/AspNetCore/commit/ec0ce4b638) Change TFM to netcoreapp2.0 (#78)
* [`[378136f794]`](https://github.com/aspnet/AspNetCore/commit/378136f794) Change TFM to netcoreapp2.0 (#78)
* [`[6e2fdda162]`](https://github.com/aspnet/AspNetCore/commit/6e2fdda162) Simplify connection lifetime control flow (#1776)
* [`[9168442704]`](https://github.com/aspnet/AspNetCore/commit/9168442704) Migration
* [`[31001de66a]`](https://github.com/aspnet/AspNetCore/commit/31001de66a) Migrate to netcoreapp2.0
* [`[a9c165e666]`](https://github.com/aspnet/AspNetCore/commit/a9c165e666) netcoreapp2.0 (#1810)
* [`[caaae2003e]`](https://github.com/aspnet/AspNetCore/commit/caaae2003e) Fix deps trimming (#107)
* [`[d488a989a6]`](https://github.com/aspnet/AspNetCore/commit/d488a989a6) Added smoke tests to create and use package cache
* [`[214de568a9]`](https://github.com/aspnet/AspNetCore/commit/214de568a9) Add Mcrosoft.Extensions.Configuration.AzureKeyVault to the .All metapackage
* [`[1705888721]`](https://github.com/aspnet/AspNetCore/commit/1705888721) Add a test for #153 - already fixed
* [`[1795fc26c1]`](https://github.com/aspnet/AspNetCore/commit/1795fc26c1) Add AttributeCompletion API.
* [`[c71f6e7c3f]`](https://github.com/aspnet/AspNetCore/commit/c71f6e7c3f) [Fixes #1058] Added a test to verify nested enum behavior
* [`[539a13717e]`](https://github.com/aspnet/AspNetCore/commit/539a13717e) Migrate to netcoreapp2.0
* [`[b854e200cd]`](https://github.com/aspnet/AspNetCore/commit/b854e200cd) Updated repo.targets to run only Nano functional tests when RUN_TESTS_ON_NANO is set to 'true'
* [`[a80594d706]`](https://github.com/aspnet/AspNetCore/commit/a80594d706) Add FSharpWebSite plus simple functional test against it (#6231)
* [`[6986ab3a0f]`](https://github.com/aspnet/AspNetCore/commit/6986ab3a0f) Change TFM to netcoreapp2.0
* [`[31eba3812f]`](https://github.com/aspnet/AspNetCore/commit/31eba3812f) clean-up after netcoreapp2.0 (#174)
* [`[1be9dc10ab]`](https://github.com/aspnet/AspNetCore/commit/1be9dc10ab) netcoreapp2.0 (#121)
* [`[e38dc4be38]`](https://github.com/aspnet/AspNetCore/commit/e38dc4be38) Change TFM to netcoreapp2.0
* [`[eff3bf5a09]`](https://github.com/aspnet/AspNetCore/commit/eff3bf5a09) Migrate to netcoreapp2.0
* [`[ce021a888e]`](https://github.com/aspnet/AspNetCore/commit/ce021a888e) Change TFM to netcoreapp2.0
* [`[9cd4bca6f5]`](https://github.com/aspnet/AspNetCore/commit/9cd4bca6f5) netcoreapp2.0 (#162)
* [`[f2260d572f]`](https://github.com/aspnet/AspNetCore/commit/f2260d572f) Templates: update React's component's State and Property type
* [`[5f8417779d]`](https://github.com/aspnet/AspNetCore/commit/5f8417779d) netcoreapp2.0 (#109)
* [`[30306fc4f4]`](https://github.com/aspnet/AspNetCore/commit/30306fc4f4) Change TFM to netcoreapp2.0
* [`[319f95db5e]`](https://github.com/aspnet/AspNetCore/commit/319f95db5e) netcoreapp20 (#173)
* [`[d84abf1fe6]`](https://github.com/aspnet/AspNetCore/commit/d84abf1fe6) Migrate to netcoreapp2.0 (#1202)
* [`[1c5e417606]`](https://github.com/aspnet/AspNetCore/commit/1c5e417606) Change TFM to netcoreapp2.0 (#6234)
* [`[905114e960]`](https://github.com/aspnet/AspNetCore/commit/905114e960) Migration
* [`[6965881ae1]`](https://github.com/aspnet/AspNetCore/commit/6965881ae1) netcoreapp2.0 (#47)
* [`[f357587c43]`](https://github.com/aspnet/AspNetCore/commit/f357587c43) netcoreapp2.0 (#47)
* [`[7f64811ccd]`](https://github.com/aspnet/AspNetCore/commit/7f64811ccd) Change targets (#437)
* [`[c9486eac0b]`](https://github.com/aspnet/AspNetCore/commit/c9486eac0b) Add blog link
* [`[d41f47f5bc]`](https://github.com/aspnet/AspNetCore/commit/d41f47f5bc) Make statusCode optional on RenderToStringResult. Fixes #917 and #918
* [`[6acc8899ad]`](https://github.com/aspnet/AspNetCore/commit/6acc8899ad) netcoreapp2.0 (#788)
* [`[41e434df8f]`](https://github.com/aspnet/AspNetCore/commit/41e434df8f) Dups
* [`[15ceec0b3f]`](https://github.com/aspnet/AspNetCore/commit/15ceec0b3f) Have templates declare dependency on SpaServices 1.1.1
* [`[decb13b33b]`](https://github.com/aspnet/AspNetCore/commit/decb13b33b) Make versions consistent across all .NET projects
* [`[02b31d05a2]`](https://github.com/aspnet/AspNetCore/commit/02b31d05a2) Stick closer to established style guides. Up buffer size to match websocket buffer size from original proxy code.
* [`[54884459bd]`](https://github.com/aspnet/AspNetCore/commit/54884459bd) Allow proxy middleware to abort long running connections.
* [`[018a3e65ff]`](https://github.com/aspnet/AspNetCore/commit/018a3e65ff) Put back "name" in AureliaSpa package.json because this is auto-replaced during template evaluation
* [`[e3a8c13c22]`](https://github.com/aspnet/AspNetCore/commit/e3a8c13c22) Make Aurelia webpack config as consistent as possible with the other templates
* [`[a658915842]`](https://github.com/aspnet/AspNetCore/commit/a658915842) Updated repo.targets to run only E2ETests when nano node is run
* [`[9072e0ba26]`](https://github.com/aspnet/AspNetCore/commit/9072e0ba26) Added a ConnectionAbortedException to Transport.Abstractions (#1806)
* [`[e15d1be616]`](https://github.com/aspnet/AspNetCore/commit/e15d1be616) Introduce SourceChange in place of TextChange
* [`[91bef13d31]`](https://github.com/aspnet/AspNetCore/commit/91bef13d31) Migration
* [`[ab81d51594]`](https://github.com/aspnet/AspNetCore/commit/ab81d51594) netcoreapp2.0
* [`[012d9990ef]`](https://github.com/aspnet/AspNetCore/commit/012d9990ef) Show fwlink on HTTPS certificate errors (#83).
* [`[670ad82d5b]`](https://github.com/aspnet/AspNetCore/commit/670ad82d5b) Updated targets dependency
* [`[11f7285881]`](https://github.com/aspnet/AspNetCore/commit/11f7285881) Run only nano tess based on condition
* [`[fef32e2faa]`](https://github.com/aspnet/AspNetCore/commit/fef32e2faa) Enable running Nano tests
* [`[9b32921a77]`](https://github.com/aspnet/AspNetCore/commit/9b32921a77) Missed rename updates
* [`[c0f86d5687]`](https://github.com/aspnet/AspNetCore/commit/c0f86d5687) Use ItemDefinitionGroup to simplify the list of packages.
* [`[ebdc68ac10]`](https://github.com/aspnet/AspNetCore/commit/ebdc68ac10) Exclude SQLitePCl.bundle_green targets when reference included via the Microsoft.AspNetCore.All metapackage
* [`[634c9c180c]`](https://github.com/aspnet/AspNetCore/commit/634c9c180c) Fix HTTPS functional tests on macOS (#96).
* [`[fbd3d9438a]`](https://github.com/aspnet/AspNetCore/commit/fbd3d9438a) Store sample app's certificate passwords in user secrets.
* [`[a23a255e2e]`](https://github.com/aspnet/AspNetCore/commit/a23a255e2e) Fix whitespace.
* [`[6ab84e0f27]`](https://github.com/aspnet/AspNetCore/commit/6ab84e0f27) Move System.Data.SqlClient version from csproj to dependencies.props (#786)
* [`[db517803c8]`](https://github.com/aspnet/AspNetCore/commit/db517803c8) Move System.Data.SqlClient version from csproj to dependencies.props (#293)
* [`[d74040786c]`](https://github.com/aspnet/AspNetCore/commit/d74040786c) #1053 Prevent IISExpressDeployer.Dispose nullref if the process failed to start
* [`[1ca8374028]`](https://github.com/aspnet/AspNetCore/commit/1ca8374028) Fix UseAzureAppServices_RegisterLogger test
* [`[1018f41f15]`](https://github.com/aspnet/AspNetCore/commit/1018f41f15) Missed some obsolete logging calls
* [`[f0c85abbaf]`](https://github.com/aspnet/AspNetCore/commit/f0c85abbaf) Correct RangeHelper documentation
* [`[dc44c1f123]`](https://github.com/aspnet/AspNetCore/commit/dc44c1f123) Use win7-x64/x86 rids for runtime store
* [`[95eb1cdae7]`](https://github.com/aspnet/AspNetCore/commit/95eb1cdae7) Force 2.0.0 dependencies for ApplicationInsights (#36)
* [`[3c358e9028]`](https://github.com/aspnet/AspNetCore/commit/3c358e9028) Replace ConfigureLogging(Action<ILoggerFactory>) with ConfigureLogging(Action<LoggerFactory>) extension
* [`[720a47765d]`](https://github.com/aspnet/AspNetCore/commit/720a47765d) Re-enable baseline check for ViewFeatures\r\nFixes #6186
* [`[b3b986bfa9]`](https://github.com/aspnet/AspNetCore/commit/b3b986bfa9) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[88461902cd]`](https://github.com/aspnet/AspNetCore/commit/88461902cd) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[350aba7279]`](https://github.com/aspnet/AspNetCore/commit/350aba7279) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[e7b403adee]`](https://github.com/aspnet/AspNetCore/commit/e7b403adee) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[856908eafa]`](https://github.com/aspnet/AspNetCore/commit/856908eafa) Skip ApplicationInsightsLoggingTest.ScriptInjected (#42)
* [`[a4510bd2c3]`](https://github.com/aspnet/AspNetCore/commit/a4510bd2c3) Skip ApplicationInsightsLoggingTest.ScriptInjected (#42)
* [`[605aeddc22]`](https://github.com/aspnet/AspNetCore/commit/605aeddc22) Support more certificate loading scenarios (#69).
* [`[cf2d6ce697]`](https://github.com/aspnet/AspNetCore/commit/cf2d6ce697) Redis presence manager
* [`[7713124bd8]`](https://github.com/aspnet/AspNetCore/commit/7713124bd8) Making PresenceHubLifetimeManager a wrapper
* [`[7f3baf5ce6]`](https://github.com/aspnet/AspNetCore/commit/7f3baf5ce6) Splitting PresenceManager
* [`[19b390c5ab]`](https://github.com/aspnet/AspNetCore/commit/19b390c5ab) Redis based scaleout presence
* [`[632c8abf77]`](https://github.com/aspnet/AspNetCore/commit/632c8abf77) Single server presence
* [`[963fcd41ed]`](https://github.com/aspnet/AspNetCore/commit/963fcd41ed) Add functionality to track online users
* [`[a5a9b6adab]`](https://github.com/aspnet/AspNetCore/commit/a5a9b6adab) Use RuntimeFrameworkVersion instead for directory name (#82)
* [`[35b5d92652]`](https://github.com/aspnet/AspNetCore/commit/35b5d92652) Fix EBUSY errors on uv_loop_close  (#1798)
* [`[0e509b4bbb]`](https://github.com/aspnet/AspNetCore/commit/0e509b4bbb) Add incomplete directive integration tests.
* [`[6155cc2c52]`](https://github.com/aspnet/AspNetCore/commit/6155cc2c52) #32 Set the SiteExtension package metadata
* [`[659c008ea8]`](https://github.com/aspnet/AspNetCore/commit/659c008ea8) fix LZMA archive directory structure (#88)
* [`[2f7fd9897e]`](https://github.com/aspnet/AspNetCore/commit/2f7fd9897e) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[152379a55d]`](https://github.com/aspnet/AspNetCore/commit/152379a55d) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[87fcdc4b0e]`](https://github.com/aspnet/AspNetCore/commit/87fcdc4b0e) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[0c7628437d]`](https://github.com/aspnet/AspNetCore/commit/0c7628437d) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[13df2a8877]`](https://github.com/aspnet/AspNetCore/commit/13df2a8877) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[c0f4a211e4]`](https://github.com/aspnet/AspNetCore/commit/c0f4a211e4) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[1f1f0994d6]`](https://github.com/aspnet/AspNetCore/commit/1f1f0994d6) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[0e83bce219]`](https://github.com/aspnet/AspNetCore/commit/0e83bce219) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[e711985920]`](https://github.com/aspnet/AspNetCore/commit/e711985920) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[e835438042]`](https://github.com/aspnet/AspNetCore/commit/e835438042) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[561a22e367]`](https://github.com/aspnet/AspNetCore/commit/561a22e367) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[0f114f9df9]`](https://github.com/aspnet/AspNetCore/commit/0f114f9df9) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[4628a2ff4e]`](https://github.com/aspnet/AspNetCore/commit/4628a2ff4e) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[f9cd44d780]`](https://github.com/aspnet/AspNetCore/commit/f9cd44d780) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[169694053b]`](https://github.com/aspnet/AspNetCore/commit/169694053b) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[e950934314]`](https://github.com/aspnet/AspNetCore/commit/e950934314) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[aa4bef0f54]`](https://github.com/aspnet/AspNetCore/commit/aa4bef0f54) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[d277144cb3]`](https://github.com/aspnet/AspNetCore/commit/d277144cb3) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[d39aa567ae]`](https://github.com/aspnet/AspNetCore/commit/d39aa567ae) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[e70ee8ab6e]`](https://github.com/aspnet/AspNetCore/commit/e70ee8ab6e) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[cbde9c0c8a]`](https://github.com/aspnet/AspNetCore/commit/cbde9c0c8a) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[d9a9f248b4]`](https://github.com/aspnet/AspNetCore/commit/d9a9f248b4) Use the bundled NETStandard.Library package in netstandard targeting libraries
* [`[08ec9a7e49]`](https://github.com/aspnet/AspNetCore/commit/08ec9a7e49) Use RuntimeFrameworkVersion instead for directory name (#82)
* [`[dc66eabbff]`](https://github.com/aspnet/AspNetCore/commit/dc66eabbff) Fail if baseline longer than generated
* [`[4dc7946cd8]`](https://github.com/aspnet/AspNetCore/commit/4dc7946cd8) Implement new request trace identifier format
* [`[749e282102]`](https://github.com/aspnet/AspNetCore/commit/749e282102) Prepare for OnReader/WriterCallbacks changes (#1791)
* [`[86beea4269]`](https://github.com/aspnet/AspNetCore/commit/86beea4269) Fix @namespace directive to handle incomplete directives.
* [`[232b73a151]`](https://github.com/aspnet/AspNetCore/commit/232b73a151) Fix aspnet/Mvc#6218
* [`[207e0f0b59]`](https://github.com/aspnet/AspNetCore/commit/207e0f0b59) Change `GetImports` to allow querying of information on non-existent files.
* [`[c176bdbab0]`](https://github.com/aspnet/AspNetCore/commit/c176bdbab0) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[18acd972df]`](https://github.com/aspnet/AspNetCore/commit/18acd972df) Add more packages
* [`[186c411f43]`](https://github.com/aspnet/AspNetCore/commit/186c411f43) Clean up (#427)
* [`[f23ba913db]`](https://github.com/aspnet/AspNetCore/commit/f23ba913db) Skip dotnet-watch functional tests while we investigate CI hangs
* [`[db868af8d8]`](https://github.com/aspnet/AspNetCore/commit/db868af8d8) Added stricter SSE message type parsing (#410)
* [`[88f43ffc1a]`](https://github.com/aspnet/AspNetCore/commit/88f43ffc1a) Fix race conditions between CTRL+C and RunAsync in dotnet-watch
* [`[9185deecda]`](https://github.com/aspnet/AspNetCore/commit/9185deecda) Avoid port conflicts in AddressRegistrationTests (#1721).
* [`[dfd1da68ec]`](https://github.com/aspnet/AspNetCore/commit/dfd1da68ec) Application insights logger lightup (#31)
* [`[a6c4df69eb]`](https://github.com/aspnet/AspNetCore/commit/a6c4df69eb) Wrong target for dependency
* [`[97a333fb66]`](https://github.com/aspnet/AspNetCore/commit/97a333fb66) sed differences on OSX and Linux
* [`[97bf16f852]`](https://github.com/aspnet/AspNetCore/commit/97bf16f852) Hack a no timestamp version of the runtime store and deps file
* [`[485cf19ab6]`](https://github.com/aspnet/AspNetCore/commit/485cf19ab6) Hack a no timestamp version of the runtime store and deps file
* [`[8f65367947]`](https://github.com/aspnet/AspNetCore/commit/8f65367947) Set actual additional deps path.
* [`[5b62024fc8]`](https://github.com/aspnet/AspNetCore/commit/5b62024fc8) * Properly handle FINs and resets in the SocketConnection (#1782)
* [`[79ea2bb9b3]`](https://github.com/aspnet/AspNetCore/commit/79ea2bb9b3) Quick fix for SslStream ODEs in HttpsAdaptedConnection.PrepareRequest (#1786)
* [`[8102d6a038]`](https://github.com/aspnet/AspNetCore/commit/8102d6a038) Add configuration to logging in WebHost
* [`[70716bdff5]`](https://github.com/aspnet/AspNetCore/commit/70716bdff5) use actual set of packages (#78)
* [`[77d9b16ad2]`](https://github.com/aspnet/AspNetCore/commit/77d9b16ad2) restore restoring of the archive project
* [`[d19ed0070c]`](https://github.com/aspnet/AspNetCore/commit/d19ed0070c) Move Long Polling and SSE send logic to a common place (#424)
* [`[ac508e9ef3]`](https://github.com/aspnet/AspNetCore/commit/ac508e9ef3) just package the archive separately
* [`[db31459551]`](https://github.com/aspnet/AspNetCore/commit/db31459551) fix timestamps
* [`[add3d93101]`](https://github.com/aspnet/AspNetCore/commit/add3d93101) :arrow_up: RuntimeFrameworkVersion to 1.0.5
* [`[3a248e22c8]`](https://github.com/aspnet/AspNetCore/commit/3a248e22c8) Upgrade System.Data.SqlClient to 4.4.0-* (#287)
* [`[6c6950b40c]`](https://github.com/aspnet/AspNetCore/commit/6c6950b40c) ensure we overwrite the ZIP when we rearchive it
* [`[a67bbab6b3]`](https://github.com/aspnet/AspNetCore/commit/a67bbab6b3) Changing the RID back from win-x64 to win7-x64 to workaround SQL issue
* [`[fc45d79606]`](https://github.com/aspnet/AspNetCore/commit/fc45d79606) Changing the RID back from win-x64 to win7-x64 to workaround SQL issue
* [`[547e415ca4]`](https://github.com/aspnet/AspNetCore/commit/547e415ca4) Changing the RID back from win-x64 to win7-x64 to workaround SQL issue
* [`[b59c8b8420]`](https://github.com/aspnet/AspNetCore/commit/b59c8b8420) Changing the RID back from win-x64 to win7-x64 to workaround SQL issue
* [`[f9e9511435]`](https://github.com/aspnet/AspNetCore/commit/f9e9511435) Upgrade System.Data.SqlClient to 4.4.0-* (#785)
* [`[a8d18ed7c6]`](https://github.com/aspnet/AspNetCore/commit/a8d18ed7c6) Changing the RID back from win-x64 to win7-x64 to workaround SQL issue
* [`[795b4d36e7]`](https://github.com/aspnet/AspNetCore/commit/795b4d36e7) AddUserSecrets is optional
* [`[c56d76693e]`](https://github.com/aspnet/AspNetCore/commit/c56d76693e) Rename file
* [`[291cc1e84b]`](https://github.com/aspnet/AspNetCore/commit/291cc1e84b) Updated runtime identifier
* [`[cb4aff5890]`](https://github.com/aspnet/AspNetCore/commit/cb4aff5890) updated runtime identifiers
* [`[d1a8a15b87]`](https://github.com/aspnet/AspNetCore/commit/d1a8a15b87) Updated runtime identifiers
* [`[4039af267d]`](https://github.com/aspnet/AspNetCore/commit/4039af267d) fix drop share reference
* [`[d940c1eb75]`](https://github.com/aspnet/AspNetCore/commit/d940c1eb75) Updated runtime identifiers
* [`[ccad1b62b4]`](https://github.com/aspnet/AspNetCore/commit/ccad1b62b4) Updated runtime identifier names
* [`[82f99a1424]`](https://github.com/aspnet/AspNetCore/commit/82f99a1424) Work around for a Firefox bug
* [`[8bece90c83]`](https://github.com/aspnet/AspNetCore/commit/8bece90c83) Fix asp-page-handler to generate form tags correctly.
* [`[8a41339680]`](https://github.com/aspnet/AspNetCore/commit/8a41339680) Long path woes
* [`[39b2990b62]`](https://github.com/aspnet/AspNetCore/commit/39b2990b62) Preserving user's queryString
* [`[58e7c1b1fe]`](https://github.com/aspnet/AspNetCore/commit/58e7c1b1fe) Allowing passing ITransport to start
* [`[b1b3a816cc]`](https://github.com/aspnet/AspNetCore/commit/b1b3a816cc) Rename View() to Page()
* [`[4ccb09c444]`](https://github.com/aspnet/AspNetCore/commit/4ccb09c444) Package Fallback Folder archive generation (#70)
* [`[ba2bca4a96]`](https://github.com/aspnet/AspNetCore/commit/ba2bca4a96) Run IHostingStartup's before materializing IConfiguration (#1052)
* [`[979107493e]`](https://github.com/aspnet/AspNetCore/commit/979107493e) Treat all SQL exceptions the same in DatabaseErrorPageMiddlewareTest
* [`[c2f15fcac3]`](https://github.com/aspnet/AspNetCore/commit/c2f15fcac3) Move user-facing strings into resource files
* [`[cb4d44cb8e]`](https://github.com/aspnet/AspNetCore/commit/cb4d44cb8e) Fix MSB4011 warnings
* [`[bd9c6600e8]`](https://github.com/aspnet/AspNetCore/commit/bd9c6600e8) Fix reference to Microsoft.AspNetCore.FunctionalTests.csproj in solution file.
* [`[21de306963]`](https://github.com/aspnet/AspNetCore/commit/21de306963) Bind Kestrel options to config by default (#30).
* [`[344862fbc3]`](https://github.com/aspnet/AspNetCore/commit/344862fbc3) Change string token parsing to not flow errored tokens.
* [`[3ae799c9c8]`](https://github.com/aspnet/AspNetCore/commit/3ae799c9c8) Zip store and deps together
* [`[490f94d425]`](https://github.com/aspnet/AspNetCore/commit/490f94d425) Add placeholder `DefineSection` method.
* [`[74b318b3e4]`](https://github.com/aspnet/AspNetCore/commit/74b318b3e4) Support binary messages in SSE parser (#418)
* [`[1160784d08]`](https://github.com/aspnet/AspNetCore/commit/1160784d08) Add Microsoft.Extensions.Hosting.Abstractions
* [`[7787e963dd]`](https://github.com/aspnet/AspNetCore/commit/7787e963dd) Enable validate scopes in dependency injection (#783)
* [`[ab0bf52f3b]`](https://github.com/aspnet/AspNetCore/commit/ab0bf52f3b) Rebase fix
* [`[285d62b312]`](https://github.com/aspnet/AspNetCore/commit/285d62b312) Move IHostedService to new Microsoft.Extensions.Hosting.Abstractions package.
* [`[735337f586]`](https://github.com/aspnet/AspNetCore/commit/735337f586) Add functional tests
* [`[0d66125fda]`](https://github.com/aspnet/AspNetCore/commit/0d66125fda) WebHost static API updates
* [`[9464003bda]`](https://github.com/aspnet/AspNetCore/commit/9464003bda) Add wait in ListenerPrimaryTests to avoid race condition with List.Add
* [`[a9ce780cef]`](https://github.com/aspnet/AspNetCore/commit/a9ce780cef) Updating package version to preview2
* [`[91e989e628]`](https://github.com/aspnet/AspNetCore/commit/91e989e628) Updating package version to preview2
* [`[4331c021b1]`](https://github.com/aspnet/AspNetCore/commit/4331c021b1) Clean up before AddManifestToNupkg
* [`[552ddd1011]`](https://github.com/aspnet/AspNetCore/commit/552ddd1011) Updating package version to preview2
* [`[981d057395]`](https://github.com/aspnet/AspNetCore/commit/981d057395) Updating package version to preview2
* [`[3006d315cc]`](https://github.com/aspnet/AspNetCore/commit/3006d315cc) Updating package version to preview2
* [`[dc24aa7abd]`](https://github.com/aspnet/AspNetCore/commit/dc24aa7abd) Updating package version to preview2
* [`[19e3b1afe6]`](https://github.com/aspnet/AspNetCore/commit/19e3b1afe6) Updating package version to preview2
* [`[998767043a]`](https://github.com/aspnet/AspNetCore/commit/998767043a) Updating package version to preview2
* [`[da4599c066]`](https://github.com/aspnet/AspNetCore/commit/da4599c066) Updating package version to preview2
* [`[3f9e0a09de]`](https://github.com/aspnet/AspNetCore/commit/3f9e0a09de) Updating package version to preview2
* [`[e918c59113]`](https://github.com/aspnet/AspNetCore/commit/e918c59113) Updating package version to preview2
* [`[80662c5d06]`](https://github.com/aspnet/AspNetCore/commit/80662c5d06) Updating package version to preview2
* [`[099f8f1a47]`](https://github.com/aspnet/AspNetCore/commit/099f8f1a47) Updating package version to preview2
* [`[d0e7b6b7cd]`](https://github.com/aspnet/AspNetCore/commit/d0e7b6b7cd) Updating package version to preview2
* [`[eba8d8a94f]`](https://github.com/aspnet/AspNetCore/commit/eba8d8a94f) Updating package version to preview2
* [`[22f92e4aac]`](https://github.com/aspnet/AspNetCore/commit/22f92e4aac) Updating package version to preview2
* [`[08132f809e]`](https://github.com/aspnet/AspNetCore/commit/08132f809e) Updating package version to preview2
* [`[36a11404ac]`](https://github.com/aspnet/AspNetCore/commit/36a11404ac) Updating package version to preview2
* [`[4063f64c00]`](https://github.com/aspnet/AspNetCore/commit/4063f64c00) Updating package version to preview2
* [`[f86cd6b9b4]`](https://github.com/aspnet/AspNetCore/commit/f86cd6b9b4) Updating package version to preview2
* [`[060fcca779]`](https://github.com/aspnet/AspNetCore/commit/060fcca779) Updating package version to preview2
* [`[febaba8367]`](https://github.com/aspnet/AspNetCore/commit/febaba8367) Updating package version to preview2
* [`[e66b8e3879]`](https://github.com/aspnet/AspNetCore/commit/e66b8e3879) Updating package version to preview2
* [`[b86626fc21]`](https://github.com/aspnet/AspNetCore/commit/b86626fc21) Updating package version to preview2
* [`[ef21413f9c]`](https://github.com/aspnet/AspNetCore/commit/ef21413f9c) Updating package version to preview2
* [`[e1a29f1b61]`](https://github.com/aspnet/AspNetCore/commit/e1a29f1b61) Trim by all manifests
* [`[63337549b1]`](https://github.com/aspnet/AspNetCore/commit/63337549b1) fix namespace reference for LoggedTest
* [`[5aea7292cd]`](https://github.com/aspnet/AspNetCore/commit/5aea7292cd) prevent websocket deadlock (#419)
* [`[f165914b40]`](https://github.com/aspnet/AspNetCore/commit/f165914b40) Update how `FormTagHelper` handles `get` method attributes.
* [`[eb1301f28d]`](https://github.com/aspnet/AspNetCore/commit/eb1301f28d) Skip HostName binding test when network is unreachable
* [`[4dad47eeab]`](https://github.com/aspnet/AspNetCore/commit/4dad47eeab) Ignore assembly version when activating DataProtection types from string name (#223)
* [`[c73bd7e63e]`](https://github.com/aspnet/AspNetCore/commit/c73bd7e63e) Increase timeout in EF tests
* [`[8358de0bd2]`](https://github.com/aspnet/AspNetCore/commit/8358de0bd2) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[8270a002b3]`](https://github.com/aspnet/AspNetCore/commit/8270a002b3) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[5b976a9fa3]`](https://github.com/aspnet/AspNetCore/commit/5b976a9fa3) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[ce4e94c1ac]`](https://github.com/aspnet/AspNetCore/commit/ce4e94c1ac) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[9e13f0fdb0]`](https://github.com/aspnet/AspNetCore/commit/9e13f0fdb0) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[0cc0a46b74]`](https://github.com/aspnet/AspNetCore/commit/0cc0a46b74) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[ccc15bf81f]`](https://github.com/aspnet/AspNetCore/commit/ccc15bf81f) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[2004897188]`](https://github.com/aspnet/AspNetCore/commit/2004897188) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[0c9a7379f2]`](https://github.com/aspnet/AspNetCore/commit/0c9a7379f2) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[d3d88481e2]`](https://github.com/aspnet/AspNetCore/commit/d3d88481e2) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[38dd87032d]`](https://github.com/aspnet/AspNetCore/commit/38dd87032d) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[07665c99e8]`](https://github.com/aspnet/AspNetCore/commit/07665c99e8) Add JavaScriptSnippetTagHelperComponent (#27)
* [`[42b988ad88]`](https://github.com/aspnet/AspNetCore/commit/42b988ad88) ./ paths relative on page.
* [`[98b1945d65]`](https://github.com/aspnet/AspNetCore/commit/98b1945d65) Set TargetManifestFiles in PropertyGroup
* [`[85f37c0198]`](https://github.com/aspnet/AspNetCore/commit/85f37c0198) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[db319f455c]`](https://github.com/aspnet/AspNetCore/commit/db319f455c) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[691cd146ce]`](https://github.com/aspnet/AspNetCore/commit/691cd146ce) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[04fe7fd31b]`](https://github.com/aspnet/AspNetCore/commit/04fe7fd31b) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[720cf1cf0e]`](https://github.com/aspnet/AspNetCore/commit/720cf1cf0e) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[d81af19645]`](https://github.com/aspnet/AspNetCore/commit/d81af19645) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[e61f7a591c]`](https://github.com/aspnet/AspNetCore/commit/e61f7a591c) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[142a13164e]`](https://github.com/aspnet/AspNetCore/commit/142a13164e) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[8f0bb46484]`](https://github.com/aspnet/AspNetCore/commit/8f0bb46484) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[2c2992b465]`](https://github.com/aspnet/AspNetCore/commit/2c2992b465) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[84b549abe0]`](https://github.com/aspnet/AspNetCore/commit/84b549abe0) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[ee3fc37413]`](https://github.com/aspnet/AspNetCore/commit/ee3fc37413) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[c68e8035d9]`](https://github.com/aspnet/AspNetCore/commit/c68e8035d9) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[5fe4807c1e]`](https://github.com/aspnet/AspNetCore/commit/5fe4807c1e) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[0786f18c3e]`](https://github.com/aspnet/AspNetCore/commit/0786f18c3e) Use Bundled NETStandard.Library \ NETCoreApp versions instead of explicitly specifying one
* [`[8377d226f1]`](https://github.com/aspnet/AspNetCore/commit/8377d226f1) Execute IHostingStart instances in the primary assembly (#1033)
* [`[566a587126]`](https://github.com/aspnet/AspNetCore/commit/566a587126) Added ApplicationSchedulingMode to KestrelServerOptions (#1759)
* [`[649ee4d28d]`](https://github.com/aspnet/AspNetCore/commit/649ee4d28d) Add support for page handler to URL generating APIs.
* [`[ef0333ac6a]`](https://github.com/aspnet/AspNetCore/commit/ef0333ac6a) Add Antiforgery to the FormTagHelper pre-check for processing.
* [`[27148c05f6]`](https://github.com/aspnet/AspNetCore/commit/27148c05f6) Update our Roslyn dependencies to 15.3
* [`[5c8a161ace]`](https://github.com/aspnet/AspNetCore/commit/5c8a161ace) Change `FormTagHelper` to apply to all form tags.
* [`[2c5132251b]`](https://github.com/aspnet/AspNetCore/commit/2c5132251b) Updated to support IISExpress and add new test cases for the additional environment variables (#93)
* [`[f26c31c116]`](https://github.com/aspnet/AspNetCore/commit/f26c31c116) Fix scope id test failures on mac and linux (#1754)
* [`[39047638cc]`](https://github.com/aspnet/AspNetCore/commit/39047638cc) Add debug logging in address binding when IPv6Any fails
* [`[089ff49643]`](https://github.com/aspnet/AspNetCore/commit/089ff49643) Put hostname address registration into separate test
* [`[c22f8f5c59]`](https://github.com/aspnet/AspNetCore/commit/c22f8f5c59) Fix potential race in  LibuvThread.StopAsync (#1756)
* [`[c77f7b7c77]`](https://github.com/aspnet/AspNetCore/commit/c77f7b7c77) Add Microsoft.AspNetCore to Microsoft.AspNetCore.All
* [`[ccdaa5a729]`](https://github.com/aspnet/AspNetCore/commit/ccdaa5a729) Make /Pages the default root for pages.
* [`[280a849060]`](https://github.com/aspnet/AspNetCore/commit/280a849060) Move the target files to the correct location in .nupkg
* [`[d2816d14ab]`](https://github.com/aspnet/AspNetCore/commit/d2816d14ab) Make WebHost internal
* [`[0f28da1234]`](https://github.com/aspnet/AspNetCore/commit/0f28da1234) Use correct version of M.A.Diagnostics.Identity.Service
* [`[04fd762943]`](https://github.com/aspnet/AspNetCore/commit/04fd762943) Rename form-action -> handler
* [`[c6fcd743db]`](https://github.com/aspnet/AspNetCore/commit/c6fcd743db) Add more package to package cache.
* [`[3a4a3ca291]`](https://github.com/aspnet/AspNetCore/commit/3a4a3ca291) WebHost static API updates
* [`[1018a20c61]`](https://github.com/aspnet/AspNetCore/commit/1018a20c61) more logging (#417)
* [`[a98581670e]`](https://github.com/aspnet/AspNetCore/commit/a98581670e) Schedule connection adapter reads on configured thread pool (#1741)
* [`[3085f016e4]`](https://github.com/aspnet/AspNetCore/commit/3085f016e4) Fix GetToken()
* [`[df9e48b1f0]`](https://github.com/aspnet/AspNetCore/commit/df9e48b1f0) Add cancellation support for write async (#1736)
* [`[c959795a64]`](https://github.com/aspnet/AspNetCore/commit/c959795a64) Creating one IAuthenticatedEncryptor per IKey
* [`[1e61428f8e]`](https://github.com/aspnet/AspNetCore/commit/1e61428f8e) Lift packages to target .NET Core 2.0
* [`[cacee2a837]`](https://github.com/aspnet/AspNetCore/commit/cacee2a837) Break fix: Undo part of 141b637 - affected test using a test factory for `HttpResponseStreamWriter`s
* [`[71d2abed06]`](https://github.com/aspnet/AspNetCore/commit/71d2abed06) More clean up of LibuvConnection (#1743)
* [`[58cc0bc3f9]`](https://github.com/aspnet/AspNetCore/commit/58cc0bc3f9) Fix the configuration key name for PreferHostingUrls (#1034)
* [`[5472763fc2]`](https://github.com/aspnet/AspNetCore/commit/5472763fc2) Added feature to control http body behavior (#821)
* [`[650a3ccc26]`](https://github.com/aspnet/AspNetCore/commit/650a3ccc26) Pass exception to Complete (#1739)
* [`[da5c304f5d]`](https://github.com/aspnet/AspNetCore/commit/da5c304f5d) Temporarily deativate API Check
* [`[ca017eced2]`](https://github.com/aspnet/AspNetCore/commit/ca017eced2) Add page to AnchorTagHelper and FormTagHelper
* [`[f568d3c2bc]`](https://github.com/aspnet/AspNetCore/commit/f568d3c2bc) Support finding "sibling" pages when using RedirecToPage
* [`[297196baa0]`](https://github.com/aspnet/AspNetCore/commit/297196baa0) Design updates to handler methods and binding
* [`[908b4c8d62]`](https://github.com/aspnet/AspNetCore/commit/908b4c8d62) FormAction from QueryString
* [`[a749939be4]`](https://github.com/aspnet/AspNetCore/commit/a749939be4) Clean up libuv connection (#1726)
* [`[8eac7c2d6c]`](https://github.com/aspnet/AspNetCore/commit/8eac7c2d6c) [Fixes #6117] Added RedirectToPage overloads to Controller
* [`[7dff704c34]`](https://github.com/aspnet/AspNetCore/commit/7dff704c34) Unskipped Nano server's standalone tests
* [`[83faaebdb6]`](https://github.com/aspnet/AspNetCore/commit/83faaebdb6) Upgrade Roslyn dependency to 2.0.0.
* [`[1696e2aebf]`](https://github.com/aspnet/AspNetCore/commit/1696e2aebf) Upgrade Razor's Roslyn dependency to 2.0.0.
* [`[9daa61084e]`](https://github.com/aspnet/AspNetCore/commit/9daa61084e) Make DataStoreErrorLogger._log static
* [`[31635abf6b]`](https://github.com/aspnet/AspNetCore/commit/31635abf6b) Resolve warnings about duplicate imports of Microsoft.Common.targets
* [`[025870e8b9]`](https://github.com/aspnet/AspNetCore/commit/025870e8b9) Fix #6159 - Fix deep copy for ControllerModel and ActionModel
* [`[e606844509]`](https://github.com/aspnet/AspNetCore/commit/e606844509) Unskipped standalone functional tests
* [`[51f77ea7f3]`](https://github.com/aspnet/AspNetCore/commit/51f77ea7f3) Workaround: On xplat machines, provided executable permission to published standalone application executable
* [`[f4d84f50cd]`](https://github.com/aspnet/AspNetCore/commit/f4d84f50cd) Upgrading Moq to 4.7.1
* [`[2388cca5ac]`](https://github.com/aspnet/AspNetCore/commit/2388cca5ac) Workaround for issue https://github.com/aspnet/Routing/issues/390
* [`[4f20655850]`](https://github.com/aspnet/AspNetCore/commit/4f20655850) Set DisplayName for auth
* [`[c25aadf599]`](https://github.com/aspnet/AspNetCore/commit/c25aadf599) Enable page directive to handle malformed text.
* [`[ea3becb3ca]`](https://github.com/aspnet/AspNetCore/commit/ea3becb3ca) Reenable APICheck
* [`[9fe480f735]`](https://github.com/aspnet/AspNetCore/commit/9fe480f735) Add LazyReferenceMetadataFeature
* [`[ee9feedc27]`](https://github.com/aspnet/AspNetCore/commit/ee9feedc27) Improve implementation of IHttpUpgradeFeature
* [`[4566cf9fdb]`](https://github.com/aspnet/AspNetCore/commit/4566cf9fdb) Add DisplayName to scheme
* [`[e3180baea5]`](https://github.com/aspnet/AspNetCore/commit/e3180baea5) Re-enable Entity Framework tests
* [`[f31b45d84a]`](https://github.com/aspnet/AspNetCore/commit/f31b45d84a) Enable TagHelper directives to handle malformed text.
* [`[681b798a2e]`](https://github.com/aspnet/AspNetCore/commit/681b798a2e) RedirectToPage doesn't trim /Index from URL
* [`[e2e350ec6c]`](https://github.com/aspnet/AspNetCore/commit/e2e350ec6c) [Fixes #763] Investigate System.Security.Claims references required to make compilation work
* [`[e450dd707e]`](https://github.com/aspnet/AspNetCore/commit/e450dd707e) Deleted obsolete razor views and models
* [`[4c8b548b30]`](https://github.com/aspnet/AspNetCore/commit/4c8b548b30) Change *.HostingStartups to target netcoreapp2.0 so we get .deps.json for free. (#24)
* [`[d1494224f4]`](https://github.com/aspnet/AspNetCore/commit/d1494224f4) Make the tests that use the Heartbeat more deterministic. (#1724)
* [`[fc51c4ffa6]`](https://github.com/aspnet/AspNetCore/commit/fc51c4ffa6) Add inject
* [`[62abf9431f]`](https://github.com/aspnet/AspNetCore/commit/62abf9431f) Add using to sample
* [`[27e90edc1c]`](https://github.com/aspnet/AspNetCore/commit/27e90edc1c) SignalR => Auth 2.0
* [`[a053ca4758]`](https://github.com/aspnet/AspNetCore/commit/a053ca4758) Move shutdown logic from transport to core (#1707)
* [`[d40dbb81ea]`](https://github.com/aspnet/AspNetCore/commit/d40dbb81ea) Fixed broken tests that leak UvWriteReq
* [`[d938fef626]`](https://github.com/aspnet/AspNetCore/commit/d938fef626) MvcPrecompilation => Auth 2.0
* [`[4bf518b09b]`](https://github.com/aspnet/AspNetCore/commit/4bf518b09b) Fix #6140 - Allow linking between controller and page
* [`[76a4299b52]`](https://github.com/aspnet/AspNetCore/commit/76a4299b52) #326 Fix API set target
* [`[42d82a507d]`](https://github.com/aspnet/AspNetCore/commit/42d82a507d) Make all UvRequest objects normal GC handles (#1698)
* [`[025efe1d6e]`](https://github.com/aspnet/AspNetCore/commit/025efe1d6e) Fix usings to use Auth 2.0
* [`[c9bfd2296d]`](https://github.com/aspnet/AspNetCore/commit/c9bfd2296d) Parity between Controller and Page/PageModel
* [`[bb73898ca2]`](https://github.com/aspnet/AspNetCore/commit/bb73898ca2) Disable api check
* [`[da30688fa9]`](https://github.com/aspnet/AspNetCore/commit/da30688fa9) Disable api checks for now
* [`[99aa3bd35d]`](https://github.com/aspnet/AspNetCore/commit/99aa3bd35d) Auth 2.0
* [`[4237a93ee8]`](https://github.com/aspnet/AspNetCore/commit/4237a93ee8) MusicStore => Auth 2.0
* [`[3e8cd1e7c9]`](https://github.com/aspnet/AspNetCore/commit/3e8cd1e7c9) MVC => Auth 2.0
* [`[7f4aa60a45]`](https://github.com/aspnet/AspNetCore/commit/7f4aa60a45) Add support for precompiling RazorPages
* [`[16eae43d38]`](https://github.com/aspnet/AspNetCore/commit/16eae43d38) Missed repository update
* [`[e4ba1d01ce]`](https://github.com/aspnet/AspNetCore/commit/e4ba1d01ce) Ensure that KeepAliveTimeoutTests do not run with sync context (#1718)
* [`[d65e77e4f7]`](https://github.com/aspnet/AspNetCore/commit/d65e77e4f7) Updated dependency model version to 2.0.0-*
* [`[c202608f19]`](https://github.com/aspnet/AspNetCore/commit/c202608f19) Platform specific path separator
* [`[a8eb5bee70]`](https://github.com/aspnet/AspNetCore/commit/a8eb5bee70) Implement view search for pages
* [`[8c8f6c708b]`](https://github.com/aspnet/AspNetCore/commit/8c8f6c708b) Server-Sent Events Transport + Parser (#401)
* [`[4319593e7f]`](https://github.com/aspnet/AspNetCore/commit/4319593e7f) Updated dependency model version to 2.0.0-*
* [`[a4a194e273]`](https://github.com/aspnet/AspNetCore/commit/a4a194e273) Make ViewComponentTagHelper discovery resilient to null.
* [`[2d15ba8917]`](https://github.com/aspnet/AspNetCore/commit/2d15ba8917) Add manifests to .All MetaPackage
* [`[2d278009b2]`](https://github.com/aspnet/AspNetCore/commit/2d278009b2) clean up client sample (#392)
* [`[d4d0e28f0e]`](https://github.com/aspnet/AspNetCore/commit/d4d0e28f0e) Updated ViewCompilation project to netcoreapp2.0
* [`[d8b1724454]`](https://github.com/aspnet/AspNetCore/commit/d8b1724454) improve logging of Autobahn tests (#166)
* [`[e691e1cff8]`](https://github.com/aspnet/AspNetCore/commit/e691e1cff8) Removing legacy raw format for `send` Fixes issues #383 and #127
* [`[0ce85e2ea2]`](https://github.com/aspnet/AspNetCore/commit/0ce85e2ea2) #263 Add Caching_SetTtlAndStatusCode_Cached test diagnostics
* [`[88890595d1]`](https://github.com/aspnet/AspNetCore/commit/88890595d1) Define a constant to workaround corefxlab classes asses modifier issue
* [`[a0743650ef]`](https://github.com/aspnet/AspNetCore/commit/a0743650ef) Don't use hardcoded ports in PreferHostingUrls tests (#1701).
* [`[801a7c7652]`](https://github.com/aspnet/AspNetCore/commit/801a7c7652) Add copyright header to TransportSocketOptions.cs.
* [`[87c513b0d8]`](https://github.com/aspnet/AspNetCore/commit/87c513b0d8) Add target to set default target manifest
* [`[d508c027ba]`](https://github.com/aspnet/AspNetCore/commit/d508c027ba) Add GetToken overload to HttpContext as well
* [`[c56b64fc41]`](https://github.com/aspnet/AspNetCore/commit/c56b64fc41) Add factory methods
* [`[e4af3f7e35]`](https://github.com/aspnet/AspNetCore/commit/e4af3f7e35) Expose a UseTransportThread property on KestrelServerOptions (#1695)
* [`[de6da7c757]`](https://github.com/aspnet/AspNetCore/commit/de6da7c757) Add ConfigureAwait(false) to test helpers (#1699)
* [`[8ed55107e7]`](https://github.com/aspnet/AspNetCore/commit/8ed55107e7) Add support for page precompilation
* [`[775847a1fa]`](https://github.com/aspnet/AspNetCore/commit/775847a1fa) Disable SqlServer specific tests on netcoreapp2.0 on win7/2008
* [`[31cc1e5018]`](https://github.com/aspnet/AspNetCore/commit/31cc1e5018) Fix extra space
* [`[6a403d231e]`](https://github.com/aspnet/AspNetCore/commit/6a403d231e) Clean up IThreadPool interface (#1696)
* [`[c18724a275]`](https://github.com/aspnet/AspNetCore/commit/c18724a275) Updated to use 0.4.0 version of IntegrationTesting package
* [`[04c86c65b6]`](https://github.com/aspnet/AspNetCore/commit/04c86c65b6) Nuget pack requires a version attribute
* [`[4b4b375909]`](https://github.com/aspnet/AspNetCore/commit/4b4b375909) Add GetToken overload using default scheme
* [`[385e2523a9]`](https://github.com/aspnet/AspNetCore/commit/385e2523a9) Re-enable ViewComponentTagHelpers for tooling.
* [`[b19a46f3c2]`](https://github.com/aspnet/AspNetCore/commit/b19a46f3c2) Write complete version number
* [`[49628bca2e]`](https://github.com/aspnet/AspNetCore/commit/49628bca2e) Use case invariant lookups for DependencyModel to workaround CLI version differences
* [`[8fa95d66d4]`](https://github.com/aspnet/AspNetCore/commit/8fa95d66d4) Add support for suppressing inbound and outbound routing
* [`[fd7707e7d2]`](https://github.com/aspnet/AspNetCore/commit/fd7707e7d2) Upgraded IntegrationTesting package to 0.4.0
* [`[7aa7b3e0a9]`](https://github.com/aspnet/AspNetCore/commit/7aa7b3e0a9) Track connections until request processing completes
* [`[c08c57f764]`](https://github.com/aspnet/AspNetCore/commit/c08c57f764) Reject HTTP/1.1 requests that do not have a correct Host header
* [`[52be2b750e]`](https://github.com/aspnet/AspNetCore/commit/52be2b750e)   #21 Initial site extension and packaging
* [`[f9e19ed522]`](https://github.com/aspnet/AspNetCore/commit/f9e19ed522) DefaultAuthentication => DefaultAuthenticate
* [`[3eae7cc393]`](https://github.com/aspnet/AspNetCore/commit/3eae7cc393) Add AggregateExceptionTest (#6135)
* [`[ee1fd61e64]`](https://github.com/aspnet/AspNetCore/commit/ee1fd61e64) Uncap version max for vsix manifest.
* [`[6f7cb763a2]`](https://github.com/aspnet/AspNetCore/commit/6f7cb763a2) Update TModel code generation.
* [`[d273c6cd4c]`](https://github.com/aspnet/AspNetCore/commit/d273c6cd4c) Ensure output hint descriptors don't schema check.
* [`[6e22dbcdc6]`](https://github.com/aspnet/AspNetCore/commit/6e22dbcdc6) Missed rename in commit
* [`[0b17f14d68]`](https://github.com/aspnet/AspNetCore/commit/0b17f14d68) Moved AddTagHelperHtmlAttribute from renderer to writer
* [`[cf44f103c1]`](https://github.com/aspnet/AspNetCore/commit/cf44f103c1) Prefix TagHelpers with tag helper prefix in completion list.
* [`[da403d4d16]`](https://github.com/aspnet/AspNetCore/commit/da403d4d16) Long path woes
* [`[a9a8f45158]`](https://github.com/aspnet/AspNetCore/commit/a9a8f45158) change autobahn tests to use dynamic port (#167)
* [`[b8aa060f32]`](https://github.com/aspnet/AspNetCore/commit/b8aa060f32) Target 1.0.4 RuntimeFrameworkVersion in the tool
* [`[9e37272f06]`](https://github.com/aspnet/AspNetCore/commit/9e37272f06) Clean up the logic in DoReceive
* [`[229d817d83]`](https://github.com/aspnet/AspNetCore/commit/229d817d83) Unskipped standalone Windows OS functional tests
* [`[46a5ca972f]`](https://github.com/aspnet/AspNetCore/commit/46a5ca972f) Allow catch-all THDs to apply to all completions.
* [`[b52430674f]`](https://github.com/aspnet/AspNetCore/commit/b52430674f) Unskipped standalone functional tests
* [`[efa0a48fb1]`](https://github.com/aspnet/AspNetCore/commit/efa0a48fb1) Add initial Socket transport for Kestrel (#1659)
* [`[0723d46ec4]`](https://github.com/aspnet/AspNetCore/commit/0723d46ec4) Honor PreferHostingUrls #1575
* [`[4d6bdba554]`](https://github.com/aspnet/AspNetCore/commit/4d6bdba554) Add nuspec and version.txt to artifacts
* [`[404960ce1a]`](https://github.com/aspnet/AspNetCore/commit/404960ce1a) Use name suggested in Coherence-Signed#439
* [`[3045cff3c5]`](https://github.com/aspnet/AspNetCore/commit/3045cff3c5) Fix adapted output pipe options (#1682)
* [`[cd486226d6]`](https://github.com/aspnet/AspNetCore/commit/cd486226d6) [Fixes #1195] Add a way to parse just until the first directive
* [`[0822dd74ac]`](https://github.com/aspnet/AspNetCore/commit/0822dd74ac) Updated NuGetPackageVerifier.json to add exclusion for Microsoft.AspNetCore.Server.IntegrationTesting
* [`[f1a59d030e]`](https://github.com/aspnet/AspNetCore/commit/f1a59d030e) Supply runtime identifier on publishing standalone apps
* [`[c0e3519bc3]`](https://github.com/aspnet/AspNetCore/commit/c0e3519bc3) Set an order on @inject to run behind @namespace
* [`[d8a95c731b]`](https://github.com/aspnet/AspNetCore/commit/d8a95c731b) Move RazorViewEngineOptionsSetup to internal namespace (#6125)
* [`[1d3747c071]`](https://github.com/aspnet/AspNetCore/commit/1d3747c071) Skipped standalone tests temporarily
* [`[37df30929c]`](https://github.com/aspnet/AspNetCore/commit/37df30929c) Update Aurelia SPA template
* [`[6036f27f52]`](https://github.com/aspnet/AspNetCore/commit/6036f27f52) Fix deadlocks in startup and shutdown
* [`[676f4ba3e4]`](https://github.com/aspnet/AspNetCore/commit/676f4ba3e4) Converted test projects to run on netcoreapp2.0
* [`[cc1b5f4d5b]`](https://github.com/aspnet/AspNetCore/commit/cc1b5f4d5b) Converted test projects to run on netcoreapp2.0
* [`[3b31e977b2]`](https://github.com/aspnet/AspNetCore/commit/3b31e977b2) Fix ability to generate baselines.
* [`[688731983c]`](https://github.com/aspnet/AspNetCore/commit/688731983c) Add dependencies.props to Solution Items.
* [`[f2f643ad15]`](https://github.com/aspnet/AspNetCore/commit/f2f643ad15) Updated XML documentation for HttpResponse.Body (#816)
* [`[e25a2eced8]`](https://github.com/aspnet/AspNetCore/commit/e25a2eced8) port dotnet/corefx#17444 to WebSockets (#162)
* [`[8b6d933711]`](https://github.com/aspnet/AspNetCore/commit/8b6d933711) Add ConfigureAwaits to prevent test deadlocks
* [`[4e8872b94d]`](https://github.com/aspnet/AspNetCore/commit/4e8872b94d) Implement IServer.StopAsync
* [`[e043fa871e]`](https://github.com/aspnet/AspNetCore/commit/e043fa871e) Make IServer Start and Stop async
* [`[62f74d5be0]`](https://github.com/aspnet/AspNetCore/commit/62f74d5be0)  #947 Add IServer.StopAsyc, IWebHost.StopAsync, and make Start async
* [`[e08e63a033]`](https://github.com/aspnet/AspNetCore/commit/e08e63a033) Updated to use 1.0.2 version of PackagePublisher
* [`[ca481dab85]`](https://github.com/aspnet/AspNetCore/commit/ca481dab85) Add non-blocking invocations to the spec (#382)
* [`[11ab602b2f]`](https://github.com/aspnet/AspNetCore/commit/11ab602b2f) Make timeout logic transport agnostic (#1649)
* [`[f6cf5293a0]`](https://github.com/aspnet/AspNetCore/commit/f6cf5293a0) Add challenge/forbid overloads for MVC
* [`[dfbf6d43ff]`](https://github.com/aspnet/AspNetCore/commit/dfbf6d43ff) Temporarily skipping ReferenceAssemblies_ReturnsLoadableReferenceAssemblies
* [`[a1cfd22a32]`](https://github.com/aspnet/AspNetCore/commit/a1cfd22a32) Add element completion API for TagHelpers.
* [`[710864eff7]`](https://github.com/aspnet/AspNetCore/commit/710864eff7) Skip NtlmAuthenticationTests.NtlmAuthentication test
* [`[3474bdf776]`](https://github.com/aspnet/AspNetCore/commit/3474bdf776) RedirectToPage from a form-action handler includes the formaction
* [`[db159190bd]`](https://github.com/aspnet/AspNetCore/commit/db159190bd) Don't fail tests if port 5000 is in use (#1650)
* [`[106b34867d]`](https://github.com/aspnet/AspNetCore/commit/106b34867d) Temporarily skipping ErrorPageMiddleware functional test to unblock mirror
* [`[59a3aade9b]`](https://github.com/aspnet/AspNetCore/commit/59a3aade9b) Fix [TempData] for PageModel's
* [`[db66b1e553]`](https://github.com/aspnet/AspNetCore/commit/db66b1e553) TransportFactory should not try creating WebSocket transport on Win7/2008R2
* [`[09ccfd8f94]`](https://github.com/aspnet/AspNetCore/commit/09ccfd8f94) Use the 0.4.0 version of Microsoft.AspNetCore.IntegrationTesting
* [`[734c735fb5]`](https://github.com/aspnet/AspNetCore/commit/734c735fb5) Simplify console output and fix color output on CMD
* [`[a181dc558a]`](https://github.com/aspnet/AspNetCore/commit/a181dc558a) SignalR Hub Protocol (#372)
* [`[e5cac9fb7f]`](https://github.com/aspnet/AspNetCore/commit/e5cac9fb7f) Implement @namespace
* [`[9993fd96da]`](https://github.com/aspnet/AspNetCore/commit/9993fd96da) Use policy names in EndPointOptions (#340)
* [`[b4b4a19549]`](https://github.com/aspnet/AspNetCore/commit/b4b4a19549) Fix #1194 - DirectiveIRNode doesn't have source
* [`[e2267f54a6]`](https://github.com/aspnet/AspNetCore/commit/e2267f54a6) Add support for naming a page (#1204)
* [`[69b019ebd8]`](https://github.com/aspnet/AspNetCore/commit/69b019ebd8) Third party rule name changed
* [`[be88d2918e]`](https://github.com/aspnet/AspNetCore/commit/be88d2918e) Disable API Check
* [`[04719dee82]`](https://github.com/aspnet/AspNetCore/commit/04719dee82) Adding transport factory
* [`[569a4e3d13]`](https://github.com/aspnet/AspNetCore/commit/569a4e3d13) Add benchmarks to solution
* [`[1fbdb30186]`](https://github.com/aspnet/AspNetCore/commit/1fbdb30186) Normalize newlines in default imports
* [`[ca66e89899]`](https://github.com/aspnet/AspNetCore/commit/ca66e89899) Add a basic attribute routing test
* [`[6c79e84d1b]`](https://github.com/aspnet/AspNetCore/commit/6c79e84d1b) Add BenchmarkDotNet boilerplate
* [`[8c58086030]`](https://github.com/aspnet/AspNetCore/commit/8c58086030) Make TreeRouter restore RouteData snapshots consistently. Fixes #394.
* [`[c0205cfc4e]`](https://github.com/aspnet/AspNetCore/commit/c0205cfc4e) Fix watchOptions in webpack.config.js being ignored by WebpackDevMiddleware (#806)
* [`[b28f85236f]`](https://github.com/aspnet/AspNetCore/commit/b28f85236f) Console type needs exe
* [`[ee1cfdf41e]`](https://github.com/aspnet/AspNetCore/commit/ee1cfdf41e) [Fixes #] DeveloperExceptionPage throws when SourceFileContent is null in an ICompilationException
* [`[99278c4691]`](https://github.com/aspnet/AspNetCore/commit/99278c4691) Workaround for "Explicit RID still required for .NET Framework test projects"
* [`[303636db13]`](https://github.com/aspnet/AspNetCore/commit/303636db13) Updates to generated .cs files
* [`[207f40f92d]`](https://github.com/aspnet/AspNetCore/commit/207f40f92d) Move test infrastructure
* [`[d29e4d4cf0]`](https://github.com/aspnet/AspNetCore/commit/d29e4d4cf0) Specialized struct generics rather than interface (#1640)
* [`[0546dc21f4]`](https://github.com/aspnet/AspNetCore/commit/0546dc21f4) Disable response buffering via the IHttpBufferingFeature (#379)
* [`[1a8ac88da7]`](https://github.com/aspnet/AspNetCore/commit/1a8ac88da7) Add PreserveMethod (#6075)
* [`[1262a6d4b2]`](https://github.com/aspnet/AspNetCore/commit/1262a6d4b2) Adding CodeGeneration benchmark
* [`[acf3e759d1]`](https://github.com/aspnet/AspNetCore/commit/acf3e759d1) Add BenchmarkDotNet boilerplate
* [`[4c183b4d00]`](https://github.com/aspnet/AspNetCore/commit/4c183b4d00) Quickly fail the UFT-8 validation if the first byte is already invalid
* [`[1faaefef30]`](https://github.com/aspnet/AspNetCore/commit/1faaefef30) Fix Libuv.Tests directory name (#1646)
* [`[0618bae3bd]`](https://github.com/aspnet/AspNetCore/commit/0618bae3bd) Rename Microsoft.AspNetCore.Razor.Evolution => Microsoft.AspNetCore.Razor.Language.
* [`[90acd055fe]`](https://github.com/aspnet/AspNetCore/commit/90acd055fe) Make [FromBody] treat empty request bodies as invalid (#4750)
* [`[2863cca8ca]`](https://github.com/aspnet/AspNetCore/commit/2863cca8ca) FrameFeatureCollection benchmark (#1643)
* [`[fb22629da6]`](https://github.com/aspnet/AspNetCore/commit/fb22629da6) Use Span.IndexOf rather than Contains (#1638)
* [`[ce3c71b5b3]`](https://github.com/aspnet/AspNetCore/commit/ce3c71b5b3) Set PreferHostingUrls when IIS adding override address
* [`[d92c55dbfc]`](https://github.com/aspnet/AspNetCore/commit/d92c55dbfc) Fix spelling nit
* [`[58284bde5c]`](https://github.com/aspnet/AspNetCore/commit/58284bde5c) Don't dispose WriteReqPool and PipeFactory too soon (#1633)
* [`[0fd885e5eb]`](https://github.com/aspnet/AspNetCore/commit/0fd885e5eb) Signal the reader after aborting the connection (#1636)
* [`[53b0eea2ec]`](https://github.com/aspnet/AspNetCore/commit/53b0eea2ec) Use writable buffer writer (#1564)
* [`[033c8adc3a]`](https://github.com/aspnet/AspNetCore/commit/033c8adc3a) Add RangeHelper
* [`[fe60c2426c]`](https://github.com/aspnet/AspNetCore/commit/fe60c2426c) Moved HtmlContentIRNode from renderer to writer
* [`[e1533c2203]`](https://github.com/aspnet/AspNetCore/commit/e1533c2203) Use 2.0.0 version of Internal.AspNetCore.Sdk
* [`[ea3b7b0a76]`](https://github.com/aspnet/AspNetCore/commit/ea3b7b0a76) Add vscode artifacts to .gitignore.
* [`[1e7972bd8f]`](https://github.com/aspnet/AspNetCore/commit/1e7972bd8f) Add convenience methods for redirecting from a Razor Page back to itself
* [`[239b691ff5]`](https://github.com/aspnet/AspNetCore/commit/239b691ff5) A few HttpParser changes (#1624)
* [`[841ceb24b6]`](https://github.com/aspnet/AspNetCore/commit/841ceb24b6) Fixing start/stop race in the TS client
* [`[5dc476182c]`](https://github.com/aspnet/AspNetCore/commit/5dc476182c) Reference bootstrap JS in KnockoutSpa/ReactSpa/VueSpa. Fixes #846
* [`[687ff27beb]`](https://github.com/aspnet/AspNetCore/commit/687ff27beb) redisable functional tests on mac (#354)
* [`[f253dbc0c0]`](https://github.com/aspnet/AspNetCore/commit/f253dbc0c0) Split transport-specific tests and general tests into distinct test projects (#1588).
* [`[25842d5f74]`](https://github.com/aspnet/AspNetCore/commit/25842d5f74) Add more packages to cache #21
* [`[26bd01337d]`](https://github.com/aspnet/AspNetCore/commit/26bd01337d) Re-write UvStreamHandleTests.ReadStopIsIdempotent without Moq.
* [`[96d97f65e9]`](https://github.com/aspnet/AspNetCore/commit/96d97f65e9) Allow null parent tag when calling `GetTagHelpersGivenParent`.
* [`[c85a0ff7ef]`](https://github.com/aspnet/AspNetCore/commit/c85a0ff7ef) Use dependencies when available
* [`[af3cf497a6]`](https://github.com/aspnet/AspNetCore/commit/af3cf497a6) Update TagHelperMatchingConventions to disallow opt-out prefix.
* [`[2464d81167]`](https://github.com/aspnet/AspNetCore/commit/2464d81167) fix repo.targets test project reference
* [`[a594d0eeb8]`](https://github.com/aspnet/AspNetCore/commit/a594d0eeb8) Workaround for "Explicit RID still required for .NET Framework test projects"
* [`[ad1d0cc67d]`](https://github.com/aspnet/AspNetCore/commit/ad1d0cc67d) Pass configuration section to LoggerFactory
* [`[0da88e0dda]`](https://github.com/aspnet/AspNetCore/commit/0da88e0dda) Avoid double escaping in PathString
* [`[6c7d099548]`](https://github.com/aspnet/AspNetCore/commit/6c7d099548) Fix directory name
* [`[eb918fc4b2]`](https://github.com/aspnet/AspNetCore/commit/eb918fc4b2) Use osx.10.12-x64 RID on macOS
* [`[0228fd2770]`](https://github.com/aspnet/AspNetCore/commit/0228fd2770) Moved ExecuteTagHelpersIRNode from renderer to writer
* [`[ad79cdd123]`](https://github.com/aspnet/AspNetCore/commit/ad79cdd123) fix hangs due to uncleared TCS in IntegrationTesting (#1008)
* [`[4032de064e]`](https://github.com/aspnet/AspNetCore/commit/4032de064e) Removing _PageStart.cshtml
* [`[c6e4609096]`](https://github.com/aspnet/AspNetCore/commit/c6e4609096) Getting rid of _PageImports
* [`[89de0e52d7]`](https://github.com/aspnet/AspNetCore/commit/89de0e52d7) Generate package cache for each RID
* [`[3b016e6832]`](https://github.com/aspnet/AspNetCore/commit/3b016e6832) Use 4.3.0 version of System.Threading.Tasks.Extensions
* [`[c6c267507a]`](https://github.com/aspnet/AspNetCore/commit/c6c267507a) Temporarity skip AzureIntegration packages due to rename
* [`[ff3ff939c3]`](https://github.com/aspnet/AspNetCore/commit/ff3ff939c3) Update WindowsAzure.Storage version (#217)
* [`[697745c490]`](https://github.com/aspnet/AspNetCore/commit/697745c490) [Fixes #218] Set IXmlRepository using ConfigureOptions
* [`[0cb7ae7fbf]`](https://github.com/aspnet/AspNetCore/commit/0cb7ae7fbf) Add support for namespace tokens in extensible directives
* [`[dd02ba577f]`](https://github.com/aspnet/AspNetCore/commit/dd02ba577f) Use corefxlab and corefx by source (#1612)
* [`[aa5eb9eb83]`](https://github.com/aspnet/AspNetCore/commit/aa5eb9eb83) #18 rename lightup packages to *.HostingStartup
* [`[9e8d4db7d8]`](https://github.com/aspnet/AspNetCore/commit/9e8d4db7d8) Move TempDataPropertyProvider into filter
* [`[7d50f34b85]`](https://github.com/aspnet/AspNetCore/commit/7d50f34b85) Show unexpected error logs in assertion failures.
* [`[bab4332a47]`](https://github.com/aspnet/AspNetCore/commit/bab4332a47) Add benchmark that drains the buffer without going through the pipe (#1611)
* [`[b40d8b4248]`](https://github.com/aspnet/AspNetCore/commit/b40d8b4248) Fix naming of IConnectionInformation.OutputReaderScheduler (#1608)
* [`[3424e20c67]`](https://github.com/aspnet/AspNetCore/commit/3424e20c67) Re-enable skipped test
* [`[6fea6454f0]`](https://github.com/aspnet/AspNetCore/commit/6fea6454f0) Moved CreateTagHelperIRNode from renderer to writer
* [`[1a05359d12]`](https://github.com/aspnet/AspNetCore/commit/1a05359d12) Reset writer scope for tag helpers inside template
* [`[fa378842af]`](https://github.com/aspnet/AspNetCore/commit/fa378842af) Use NuGetPackageRoot instead of NuGetPackageFolders
* [`[dda9cf3259]`](https://github.com/aspnet/AspNetCore/commit/dda9cf3259) Do not generate C# line pragmas without a file path.
* [`[925ad75cdf]`](https://github.com/aspnet/AspNetCore/commit/925ad75cdf) Add convenience methods for redirecting to another Razor Page
* [`[c7e2e1880e]`](https://github.com/aspnet/AspNetCore/commit/c7e2e1880e) Make FileSystemRazorProject internal (#1152)
* [`[ebb2ce8fc9]`](https://github.com/aspnet/AspNetCore/commit/ebb2ce8fc9) Converting transport type from string to enum
* [`[2d19a82678]`](https://github.com/aspnet/AspNetCore/commit/2d19a82678) Update more resource designer files
* [`[7ceea5323a]`](https://github.com/aspnet/AspNetCore/commit/7ceea5323a) Rename namespaces/directories/classes in Kestrel.Core and Transport.Libuv (#1582).
* [`[68554f8106]`](https://github.com/aspnet/AspNetCore/commit/68554f8106) Updated the ir lowering phase to lazily add namespaces.
* [`[9e12230eef]`](https://github.com/aspnet/AspNetCore/commit/9e12230eef) Add RazorPage test without model
* [`[794508fbf2]`](https://github.com/aspnet/AspNetCore/commit/794508fbf2) Only publish ForTesting folder when needed
* [`[7944be712f]`](https://github.com/aspnet/AspNetCore/commit/7944be712f) Allow starting connection only once
* [`[52085a78cc]`](https://github.com/aspnet/AspNetCore/commit/52085a78cc) Change special version to preview1
* [`[3b8e1a5380]`](https://github.com/aspnet/AspNetCore/commit/3b8e1a5380) Added a close timeout to the web socket transport
* [`[dbb682799e]`](https://github.com/aspnet/AspNetCore/commit/dbb682799e) Update generated designer files
* [`[87e6da6e4c]`](https://github.com/aspnet/AspNetCore/commit/87e6da6e4c) Handle exceptions and Cancellation in DisposeAsync (#366)
* [`[4dbf6f23c3]`](https://github.com/aspnet/AspNetCore/commit/4dbf6f23c3) Moved TagHelperIRNode, InitializeTagHelperStructureIRNode from renderer to writer
* [`[d37b1548f8]`](https://github.com/aspnet/AspNetCore/commit/d37b1548f8) Update to new resx format
* [`[7d8bd29724]`](https://github.com/aspnet/AspNetCore/commit/7d8bd29724) Moved DeclareTagHelperFields from renderer to writer
* [`[8da2dddd49]`](https://github.com/aspnet/AspNetCore/commit/8da2dddd49) Fix issue where multiple calls to dispose don't wait properly (#360)
* [`[cb5c483a1d]`](https://github.com/aspnet/AspNetCore/commit/cb5c483a1d) Add line mappings for using directives.
* [`[6bd0344880]`](https://github.com/aspnet/AspNetCore/commit/6bd0344880) Add Microsoft.AspNetCore.Server.Kestrel.Transport.Abstractions project (#1582).
* [`[f285b18f08]`](https://github.com/aspnet/AspNetCore/commit/f285b18f08) Ensure no data is written to a connection after uv_shutdown (#1600)
* [`[13ee32b7ab]`](https://github.com/aspnet/AspNetCore/commit/13ee32b7ab) Fetch corefx lab sources and compile them into kestrel (#1581)
* [`[0e15ff3e95]`](https://github.com/aspnet/AspNetCore/commit/0e15ff3e95) Re-add marker IR tokens to represent CSharp in an expression.
* [`[6a5f7dec10]`](https://github.com/aspnet/AspNetCore/commit/6a5f7dec10) Investigate System.Reflection.TypeExtensions added to unbreak tests
* [`[11de3fd384]`](https://github.com/aspnet/AspNetCore/commit/11de3fd384) Fix issue with remote deployer wait
* [`[4c0afbad86]`](https://github.com/aspnet/AspNetCore/commit/4c0afbad86) Generate line mappings for empty expressions.
* [`[fe3d45fad1]`](https://github.com/aspnet/AspNetCore/commit/fe3d45fad1) Adding AllowAnonymousToPage & AllowAnonymousToFolder
* [`[83958886cc]`](https://github.com/aspnet/AspNetCore/commit/83958886cc) Implement IHttpRequestIdentifierFeature on Frame
* [`[da1e4130d2]`](https://github.com/aspnet/AspNetCore/commit/da1e4130d2) Moved from Renderer to Writer
* [`[2cabd589ac]`](https://github.com/aspnet/AspNetCore/commit/2cabd589ac) Add more `ExpressionHelper` tests - #5792
* [`[a74cda4402]`](https://github.com/aspnet/AspNetCore/commit/a74cda4402) Setting TokenKind for RazorIRToken
* [`[468c090272]`](https://github.com/aspnet/AspNetCore/commit/468c090272) Update vsix metadata
* [`[915e984f32]`](https://github.com/aspnet/AspNetCore/commit/915e984f32) increase timeout for remote deployer (#1001)
* [`[d9faf17f5c]`](https://github.com/aspnet/AspNetCore/commit/d9faf17f5c) * Fixing a racey test * Fixing a misplaced test file
* [`[e25bfa8919]`](https://github.com/aspnet/AspNetCore/commit/e25bfa8919) Skipping model validation tests temporarily to unblock mirror - A fix was already checked in https://github.com/dotnet/corefx/commit/f3d0e4d0dd7ee4b27100e0994a7576f87cc225ed but this did not make into the netcoreapp2.0 shared runtime
* [`[975cfcb8ce]`](https://github.com/aspnet/AspNetCore/commit/975cfcb8ce) #16 Create a lightup package for Application Insights
* [`[13925be91e]`](https://github.com/aspnet/AspNetCore/commit/13925be91e) Initial Auth 2.0 checkin
* [`[385531f11a]`](https://github.com/aspnet/AspNetCore/commit/385531f11a) Workaround issues preventing tests from running in Visual Studio.
* [`[7904c7756d]`](https://github.com/aspnet/AspNetCore/commit/7904c7756d) Add a simple action selection benchmark
* [`[7d4ccd9c58]`](https://github.com/aspnet/AspNetCore/commit/7d4ccd9c58) Add benchmark project and boilerplate
* [`[6b9d54265f]`](https://github.com/aspnet/AspNetCore/commit/6b9d54265f) Call ProduceEnd() before consuming request body if response has already started (#1530).
* [`[0ab49f4977]`](https://github.com/aspnet/AspNetCore/commit/0ab49f4977) Fix benchmarks on netcoreapp2.0
* [`[b4cec03f65]`](https://github.com/aspnet/AspNetCore/commit/b4cec03f65) Update libuv package (#1577)
* [`[3d29b7854b]`](https://github.com/aspnet/AspNetCore/commit/3d29b7854b) Bugfix issue #355: Don't handle Invocation when no InvocationHandler … (#356)
* [`[209729332c]`](https://github.com/aspnet/AspNetCore/commit/209729332c) Add GetImportItems to RazorTemplateEngine Fixes #1109
* [`[1bf9b057d4]`](https://github.com/aspnet/AspNetCore/commit/1bf9b057d4) Converted test projects to run on netcoreapp2.0
* [`[4f351bd37c]`](https://github.com/aspnet/AspNetCore/commit/4f351bd37c) Add support for media type suffixes (#5273, #6032)
* [`[b0bd5475cd]`](https://github.com/aspnet/AspNetCore/commit/b0bd5475cd) More decoupling (#1572)
* [`[b4b671556a]`](https://github.com/aspnet/AspNetCore/commit/b4b671556a) fix nginx deployer (#998)
* [`[7774ed50fa]`](https://github.com/aspnet/AspNetCore/commit/7774ed50fa) additional checks and logging for iisx shutdown (#997)
* [`[4cdc970055]`](https://github.com/aspnet/AspNetCore/commit/4cdc970055) Server addresses configuration enhancements
* [`[f15c99c980]`](https://github.com/aspnet/AspNetCore/commit/f15c99c980) more logging and more resiliant port selection (#996)
* [`[1be31ae2ce]`](https://github.com/aspnet/AspNetCore/commit/1be31ae2ce) Throw if UseUrls specifies HTTPS or path base (#1519).
* [`[dd9eab551d]`](https://github.com/aspnet/AspNetCore/commit/dd9eab551d) Workaround tooling issue with runtime only TagHelpers.
* [`[6b6a8347cc]`](https://github.com/aspnet/AspNetCore/commit/6b6a8347cc) Add Connection as a primary request header
* [`[fdea42624d]`](https://github.com/aspnet/AspNetCore/commit/fdea42624d) Fix UrlResolutionTagHelper tag helper inclusion.
* [`[959324b337]`](https://github.com/aspnet/AspNetCore/commit/959324b337) Add EditorBrowsable attribute
* [`[60a87829f8]`](https://github.com/aspnet/AspNetCore/commit/60a87829f8) Fix type name
* [`[7890fdbf94]`](https://github.com/aspnet/AspNetCore/commit/7890fdbf94) Add Activity tracking to HostingApplication (#964)
* [`[22c7c90b5a]`](https://github.com/aspnet/AspNetCore/commit/22c7c90b5a) Add `TagHelperFactsService`.
* [`[c1500da2a8]`](https://github.com/aspnet/AspNetCore/commit/c1500da2a8) Don't render directive token from imports in design time
* [`[1672820e4e]`](https://github.com/aspnet/AspNetCore/commit/1672820e4e) Add functional test covering an `IList<T>` property - #5656
* [`[582ffe2e10]`](https://github.com/aspnet/AspNetCore/commit/582ffe2e10) Add HeadTagHelper and BodyTagHelper
* [`[792b71dbcb]`](https://github.com/aspnet/AspNetCore/commit/792b71dbcb) Add VS Code settings (#1556)
* [`[e7f563843c]`](https://github.com/aspnet/AspNetCore/commit/e7f563843c) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[bd6520cc50]`](https://github.com/aspnet/AspNetCore/commit/bd6520cc50) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[0b5113c76e]`](https://github.com/aspnet/AspNetCore/commit/0b5113c76e) Suppress compilation errors for TModel in imports
* [`[e0c3738779]`](https://github.com/aspnet/AspNetCore/commit/e0c3738779) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[bfd1d48506]`](https://github.com/aspnet/AspNetCore/commit/bfd1d48506) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[f73dc5cebe]`](https://github.com/aspnet/AspNetCore/commit/f73dc5cebe) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[1d1b255170]`](https://github.com/aspnet/AspNetCore/commit/1d1b255170) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[f87e0234e2]`](https://github.com/aspnet/AspNetCore/commit/f87e0234e2) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[eb25f5d6ff]`](https://github.com/aspnet/AspNetCore/commit/eb25f5d6ff) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[305ccf9cc5]`](https://github.com/aspnet/AspNetCore/commit/305ccf9cc5) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[ba5156d3e1]`](https://github.com/aspnet/AspNetCore/commit/ba5156d3e1) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[afef0e3e2a]`](https://github.com/aspnet/AspNetCore/commit/afef0e3e2a) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[c4f2581988]`](https://github.com/aspnet/AspNetCore/commit/c4f2581988) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[99ff496e71]`](https://github.com/aspnet/AspNetCore/commit/99ff496e71) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[5f161fb51f]`](https://github.com/aspnet/AspNetCore/commit/5f161fb51f) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[a06a765cf4]`](https://github.com/aspnet/AspNetCore/commit/a06a765cf4) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[7dd9d69fe1]`](https://github.com/aspnet/AspNetCore/commit/7dd9d69fe1) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[a0bb843dd5]`](https://github.com/aspnet/AspNetCore/commit/a0bb843dd5) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[db7095bc90]`](https://github.com/aspnet/AspNetCore/commit/db7095bc90) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[2e3c35b863]`](https://github.com/aspnet/AspNetCore/commit/2e3c35b863) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[68647d1733]`](https://github.com/aspnet/AspNetCore/commit/68647d1733) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[e4e62b3156]`](https://github.com/aspnet/AspNetCore/commit/e4e62b3156) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[7fa3babfb4]`](https://github.com/aspnet/AspNetCore/commit/7fa3babfb4) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[679a0e60f7]`](https://github.com/aspnet/AspNetCore/commit/679a0e60f7) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[af84fadf8c]`](https://github.com/aspnet/AspNetCore/commit/af84fadf8c) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[023f612406]`](https://github.com/aspnet/AspNetCore/commit/023f612406) Updating to 2.0.0 Internal.AspNetCore.Sdk
* [`[eda5028cf4]`](https://github.com/aspnet/AspNetCore/commit/eda5028cf4) Add TagHelperComponentTagHelper
* [`[5cb1846dd2]`](https://github.com/aspnet/AspNetCore/commit/5cb1846dd2) Fix and reorganise WebpackDevMiddleware.ts following PR
* [`[1f03b1e633]`](https://github.com/aspnet/AspNetCore/commit/1f03b1e633) Tiny shortcut to reduce string checking in non-debug scenarios
* [`[0c09c68b77]`](https://github.com/aspnet/AspNetCore/commit/0c09c68b77) Support V8 Inspector Integration for Node.js
* [`[ce40973859]`](https://github.com/aspnet/AspNetCore/commit/ce40973859) Add option to configure Webpack Hot Middleware client
* [`[347524a116]`](https://github.com/aspnet/AspNetCore/commit/347524a116) Add status code response capabilities to PrerenderTagHelper and RenderToStringResult. Client can now send status codes back based on client routes.
* [`[6ed6b8e3d2]`](https://github.com/aspnet/AspNetCore/commit/6ed6b8e3d2) Set AutoCompleteOnClose=false on JsonTextWriter. Fixes #822
* [`[c18f0780c1]`](https://github.com/aspnet/AspNetCore/commit/c18f0780c1) [Fixes #5413] JsonOutputFormatter adds all closing brackets when exceptions are thrown
* [`[56c2d76e03]`](https://github.com/aspnet/AspNetCore/commit/56c2d76e03) Upgrade Json.Net version to 10.0.1
* [`[200d8debc0]`](https://github.com/aspnet/AspNetCore/commit/200d8debc0) Use the SDK version of GetOSPlatform
* [`[b22326323a]`](https://github.com/aspnet/AspNetCore/commit/b22326323a) Add properties to Page and PageModel
* [`[c1487bf93d]`](https://github.com/aspnet/AspNetCore/commit/c1487bf93d) Fix some style nits
* [`[8165609f4e]`](https://github.com/aspnet/AspNetCore/commit/8165609f4e) Logging optimization.2 14 (#944)
* [`[b2bd3e0841]`](https://github.com/aspnet/AspNetCore/commit/b2bd3e0841) Upgraded Json.NET version to 10.0.1
* [`[9c5b33dd8a]`](https://github.com/aspnet/AspNetCore/commit/9c5b33dd8a) Upgraded Json.Net version to 10.0.1
* [`[f79904404e]`](https://github.com/aspnet/AspNetCore/commit/f79904404e) Log status of port before starting server with SelfHostDeployer (#993)
* [`[dcf51f706c]`](https://github.com/aspnet/AspNetCore/commit/dcf51f706c) Upgraded Json.NET version to 10.0.1
* [`[2b8a937828]`](https://github.com/aspnet/AspNetCore/commit/2b8a937828) Upgraded Json.NET version to 10.0.1
* [`[ab6e74f4b4]`](https://github.com/aspnet/AspNetCore/commit/ab6e74f4b4) Upgraded Json.NET version to 10.0.1
* [`[a2914ab483]`](https://github.com/aspnet/AspNetCore/commit/a2914ab483) Replace console logger with ITestOutputHelper (#64)
* [`[d6322872ed]`](https://github.com/aspnet/AspNetCore/commit/d6322872ed) #348 Implement IISHostingStartup
* [`[737a9a58ad]`](https://github.com/aspnet/AspNetCore/commit/737a9a58ad) Fix breaks in Razor Tests
* [`[af7798a9be]`](https://github.com/aspnet/AspNetCore/commit/af7798a9be) Fix a type error in the tag helper comparison
* [`[8d1cc43f8e]`](https://github.com/aspnet/AspNetCore/commit/8d1cc43f8e) Get rid of extra dependencies
* [`[bc9b9876e5]`](https://github.com/aspnet/AspNetCore/commit/bc9b9876e5) Add a service for initializing tooling
* [`[58317b18ce]`](https://github.com/aspnet/AspNetCore/commit/58317b18ce) Fixing NRE when CacheTagHelper throws and exception (#5989)
* [`[575fe68b2b]`](https://github.com/aspnet/AspNetCore/commit/575fe68b2b) Order enum values by DisplayAttribute.Order
* [`[2bdbbbf41d]`](https://github.com/aspnet/AspNetCore/commit/2bdbbbf41d) UseMiddleware resolves InvokeAsync in addition to Invoke
* [`[71d09dc15c]`](https://github.com/aspnet/AspNetCore/commit/71d09dc15c) Using PackagePublisher tool to publish packages as it does retries
* [`[6436538068]`](https://github.com/aspnet/AspNetCore/commit/6436538068) Rename `IHtmlHelper.TextBox()` parameter (for consistency) - #5394
* [`[db7348e776]`](https://github.com/aspnet/AspNetCore/commit/db7348e776) Fix flakiness in WhenAppWritesLessThanContentLengthButRequestIsAbortedErrorNotLogged.
* [`[09667e86ab]`](https://github.com/aspnet/AspNetCore/commit/09667e86ab) Port ObjectMethodExecutor race fix
* [`[6922cbb903]`](https://github.com/aspnet/AspNetCore/commit/6922cbb903) Use FrameworkSkipCondition
* [`[7228c15e28]`](https://github.com/aspnet/AspNetCore/commit/7228c15e28) Use FrameworkSkipCondition
* [`[0e8b790a08]`](https://github.com/aspnet/AspNetCore/commit/0e8b790a08) Disable API Check for these command-line tools
* [`[6130003193]`](https://github.com/aspnet/AspNetCore/commit/6130003193) Convert to netcoreapp2.0 (#338)
* [`[5928d0d54b]`](https://github.com/aspnet/AspNetCore/commit/5928d0d54b) Don't generate CSharpStatementIRNode for null or whitespace
* [`[47f1db20e0]`](https://github.com/aspnet/AspNetCore/commit/47f1db20e0) Fix races on port acquisition in AddressRegistrationTests (#1520).
* [`[1683018d71]`](https://github.com/aspnet/AspNetCore/commit/1683018d71) Add a static 'register' method to MVC's extensions
* [`[565dd30957]`](https://github.com/aspnet/AspNetCore/commit/565dd30957) Make the parser options configurable
* [`[fe6517dcdd]`](https://github.com/aspnet/AspNetCore/commit/fe6517dcdd) Add ITagHelperComponent
* [`[b4640f8bb8]`](https://github.com/aspnet/AspNetCore/commit/b4640f8bb8) Use AspNetCore.Mvc.RazorPages
* [`[2df3639535]`](https://github.com/aspnet/AspNetCore/commit/2df3639535) Add System.Reflection.TypeExtensions to workaround test failures
* [`[9ffc745e76]`](https://github.com/aspnet/AspNetCore/commit/9ffc745e76) Add Mvc.Razor.Extensions to VSIX
* [`[0fa79818e1]`](https://github.com/aspnet/AspNetCore/commit/0fa79818e1) Add DisplayName to RequiredAttributeDescriptor.
* [`[7a50fdda48]`](https://github.com/aspnet/AspNetCore/commit/7a50fdda48) Converted sample and test project to run on netcoreapp2.0
* [`[0f28c49c5e]`](https://github.com/aspnet/AspNetCore/commit/0f28c49c5e) Fix the invalid usages of Span<T> (#1549)
* [`[e7101f248a]`](https://github.com/aspnet/AspNetCore/commit/e7101f248a) Support model binding to Razor Pages properties on page and PageModel classes
* [`[d5cbdb8ac6]`](https://github.com/aspnet/AspNetCore/commit/d5cbdb8ac6) Update WebHost.cs (#986)
* [`[3e6303b6c1]`](https://github.com/aspnet/AspNetCore/commit/3e6303b6c1) Fix flakiness in connection reset logging tests.
* [`[54831fed35]`](https://github.com/aspnet/AspNetCore/commit/54831fed35) Simplified if condition
* [`[77da34c7b3]`](https://github.com/aspnet/AspNetCore/commit/77da34c7b3) Converted sample and test projects to netcoreapp2.0
* [`[33a3be4a16]`](https://github.com/aspnet/AspNetCore/commit/33a3be4a16) Converted sample and test project to run on netcoreapp2.0
* [`[6ac219c710]`](https://github.com/aspnet/AspNetCore/commit/6ac219c710) updated
* [`[095e45953f]`](https://github.com/aspnet/AspNetCore/commit/095e45953f) Add System.Net.Http 4.3.1 dependency to work around HttpClient issues
* [`[70e4ec9a06]`](https://github.com/aspnet/AspNetCore/commit/70e4ec9a06) Introducing the IConnection interface Unifying events
* [`[14d3f2bc9b]`](https://github.com/aspnet/AspNetCore/commit/14d3f2bc9b) Allow overridden methods on hubs (#334)
* [`[adcc6e8d7b]`](https://github.com/aspnet/AspNetCore/commit/adcc6e8d7b) Renaming FunctionalTests project in repo.props
* [`[cdadfd48d0]`](https://github.com/aspnet/AspNetCore/commit/cdadfd48d0) Try renaming functional tests as a potential mitigation for long path issues
* [`[e3e4176124]`](https://github.com/aspnet/AspNetCore/commit/e3e4176124) Try renaming functional tests as a potential mitigation for long path issues.
* [`[ae34e14358]`](https://github.com/aspnet/AspNetCore/commit/ae34e14358) Don't generate line mappings for imports
* [`[1b5beea573]`](https://github.com/aspnet/AspNetCore/commit/1b5beea573) Temporarily skipping failing NTLM tests
* [`[28bf0b445b]`](https://github.com/aspnet/AspNetCore/commit/28bf0b445b) add some very simple, fairly stupid, benchmarks (#322)
* [`[32bed162a8]`](https://github.com/aspnet/AspNetCore/commit/32bed162a8) Always log the hosting startup assemblies (#982)
* [`[ddb1bfeb20]`](https://github.com/aspnet/AspNetCore/commit/ddb1bfeb20) Add support for executing IHostingStartup in specified assemblies (#961)
* [`[705c36921a]`](https://github.com/aspnet/AspNetCore/commit/705c36921a) Use alternate workaround for #6005
* [`[ff99c4c865]`](https://github.com/aspnet/AspNetCore/commit/ff99c4c865) Fix benchmarks (broken) (#1515)
* [`[1ef45e64b8]`](https://github.com/aspnet/AspNetCore/commit/1ef45e64b8) Update to net46
* [`[8cc72b7871]`](https://github.com/aspnet/AspNetCore/commit/8cc72b7871) Update to net46
* [`[4d5f726e67]`](https://github.com/aspnet/AspNetCore/commit/4d5f726e67) Update to net46
* [`[6278dbeac5]`](https://github.com/aspnet/AspNetCore/commit/6278dbeac5) Don't filter by assembly name if null is provided
* [`[c07759996f]`](https://github.com/aspnet/AspNetCore/commit/c07759996f) Fix absolute path handling.
* [`[72febdac64]`](https://github.com/aspnet/AspNetCore/commit/72febdac64) Move Razor.Host to Razor
* [`[f31c302e5c]`](https://github.com/aspnet/AspNetCore/commit/f31c302e5c) Converted test project to run on netcoreapp2.0
* [`[eb0ab115d8]`](https://github.com/aspnet/AspNetCore/commit/eb0ab115d8) capture wstest log output (#156)
* [`[d2be921ca4]`](https://github.com/aspnet/AspNetCore/commit/d2be921ca4) Converted test project to run on netcoreapp2.0
* [`[cab6eea663]`](https://github.com/aspnet/AspNetCore/commit/cab6eea663) Set file path from RazorSourceDocument in syntax tree
* [`[49daa416ba]`](https://github.com/aspnet/AspNetCore/commit/49daa416ba) Use StringComparer.Ordinal
* [`[60f456dc7e]`](https://github.com/aspnet/AspNetCore/commit/60f456dc7e) Retarget test app
* [`[32bc9a57c9]`](https://github.com/aspnet/AspNetCore/commit/32bc9a57c9) #317 Dispose WindowsIdentity
* [`[c328e22699]`](https://github.com/aspnet/AspNetCore/commit/c328e22699) #306 Consistently use WindowsPrincipal
* [`[d103bdb1ba]`](https://github.com/aspnet/AspNetCore/commit/d103bdb1ba) #287 Do not include an auth display name
* [`[f246dd3502]`](https://github.com/aspnet/AspNetCore/commit/f246dd3502) Upgrade test projects to .NET Core 2.0
* [`[e955c4b9aa]`](https://github.com/aspnet/AspNetCore/commit/e955c4b9aa) Handling exceptions thrown when invoking a hub method (#332)
* [`[fffb823e99]`](https://github.com/aspnet/AspNetCore/commit/fffb823e99) Dispose socket in test after synchronous connect
* [`[5642f09a83]`](https://github.com/aspnet/AspNetCore/commit/5642f09a83) Fixing TS client tests folder name Mirroring disk folder structure for TS client in VS and adding missing files
* [`[75a4d006aa]`](https://github.com/aspnet/AspNetCore/commit/75a4d006aa) Disable API Check in projects with untracked breaking changes
* [`[6fbbd5d148]`](https://github.com/aspnet/AspNetCore/commit/6fbbd5d148) Disable API Check in projects with untracked breaking changes
* [`[1152c468be]`](https://github.com/aspnet/AspNetCore/commit/1152c468be) Disable API Check in projects with untracked breaking changes
* [`[c9f12a23f8]`](https://github.com/aspnet/AspNetCore/commit/c9f12a23f8) Disable API Check in projects with untracked breaking changes
* [`[387e2d8ad1]`](https://github.com/aspnet/AspNetCore/commit/387e2d8ad1) Disable API Check in projects with untracked breaking changes
* [`[55507de7dd]`](https://github.com/aspnet/AspNetCore/commit/55507de7dd) Disable API Check in a project with untracked breaking changes
* [`[51e84a623c]`](https://github.com/aspnet/AspNetCore/commit/51e84a623c) Fix runtime failures
* [`[18785dbed6]`](https://github.com/aspnet/AspNetCore/commit/18785dbed6) Add System.Reflection.TypeExtensions to fix net46 tests
* [`[b8eae7a697]`](https://github.com/aspnet/AspNetCore/commit/b8eae7a697) Add reference to System.Security.Claims
* [`[c65734667a]`](https://github.com/aspnet/AspNetCore/commit/c65734667a) Optimize calls into StreamSocketOuput to WriteFast further (#1538)
* [`[90acbd1e62]`](https://github.com/aspnet/AspNetCore/commit/90acbd1e62) Fix compilation error
* [`[751a0e2e7e]`](https://github.com/aspnet/AspNetCore/commit/751a0e2e7e) Better checks for connection reset in RequestTests.ConnectionReset* tests (#1517)
* [`[72587baac3]`](https://github.com/aspnet/AspNetCore/commit/72587baac3) Check that MaxRequestBufferSize is greater than or equal to MaxRequestHeadersTotalSize (#1491).
* [`[11d265bddd]`](https://github.com/aspnet/AspNetCore/commit/11d265bddd) Avoid entry point assembly being loaded twice during assembly parts discovery.
* [`[6c131ea240]`](https://github.com/aspnet/AspNetCore/commit/6c131ea240) Verify scopeids are connectable using Socket before testing Kestrel (#1536)
* [`[2f89b1d40b]`](https://github.com/aspnet/AspNetCore/commit/2f89b1d40b) Update tfm in shutdown test
* [`[bac161fdd6]`](https://github.com/aspnet/AspNetCore/commit/bac161fdd6) Converted test projects to run on netcoreapp2.0
* [`[c6a35e7b26]`](https://github.com/aspnet/AspNetCore/commit/c6a35e7b26) Added HasIndexer property to BoundAttributeDescriptor
* [`[2ab3d42630]`](https://github.com/aspnet/AspNetCore/commit/2ab3d42630) Removing site.js (#330)
* [`[55d6362325]`](https://github.com/aspnet/AspNetCore/commit/55d6362325) [Fixes #1094] Use custom JsonConverters for serializing/deserializing TagHelperResolutionResult
* [`[f99a0d6b8e]`](https://github.com/aspnet/AspNetCore/commit/f99a0d6b8e) Pin DotNetCliToolReferences
* [`[67f1571cfe]`](https://github.com/aspnet/AspNetCore/commit/67f1571cfe) Update to net46
* [`[8f9f6bcb6f]`](https://github.com/aspnet/AspNetCore/commit/8f9f6bcb6f) Adding Auth to endpoints
* [`[10782d59a2]`](https://github.com/aspnet/AspNetCore/commit/10782d59a2) Dev gate (#326)
* [`[24ed93288e]`](https://github.com/aspnet/AspNetCore/commit/24ed93288e) Use for rather than foreach on List (#1523)
* [`[f546f16356]`](https://github.com/aspnet/AspNetCore/commit/f546f16356) Forgot to WriteFast in SocketOutput (#1527)
* [`[cf576559b6]`](https://github.com/aspnet/AspNetCore/commit/cf576559b6) Fix write after close (#1526)
* [`[5f547d8e32]`](https://github.com/aspnet/AspNetCore/commit/5f547d8e32) Add intentation support
* [`[f3744efc5c]`](https://github.com/aspnet/AspNetCore/commit/f3744efc5c) Use Version 8.0.3 of Json.Net
* [`[d5e003fa4c]`](https://github.com/aspnet/AspNetCore/commit/d5e003fa4c) Fix `RazorLanguageService`.
* [`[3b40ba52ca]`](https://github.com/aspnet/AspNetCore/commit/3b40ba52ca) Check if request is aborted before verifying response bytes written (#1498).
* [`[53ac097ce4]`](https://github.com/aspnet/AspNetCore/commit/53ac097ce4) Add TagHelperFactsService
* [`[8923b0da70]`](https://github.com/aspnet/AspNetCore/commit/8923b0da70) Use correct config for response buffer limit (#1516)
* [`[63ce7f6160]`](https://github.com/aspnet/AspNetCore/commit/63ce7f6160) Supported transports (#294)
* [`[4a71b1d57d]`](https://github.com/aspnet/AspNetCore/commit/4a71b1d57d) [Fixes #980] Generate parser error for unquoted string token directives
* [`[9659c73e05]`](https://github.com/aspnet/AspNetCore/commit/9659c73e05) Fix the client raw sample to use user input (#321)
* [`[ca6f988bd9]`](https://github.com/aspnet/AspNetCore/commit/ca6f988bd9) Add GetTagHelperSpans
* [`[66deaf0b3f]`](https://github.com/aspnet/AspNetCore/commit/66deaf0b3f) Make test of @page/@model whitespace
* [`[913354f688]`](https://github.com/aspnet/AspNetCore/commit/913354f688) Unifying errors in parsers
* [`[33c94c1a47]`](https://github.com/aspnet/AspNetCore/commit/33c94c1a47) Replacing onError with onClosed Unifying errors in transports
* [`[e6cb639cc0]`](https://github.com/aspnet/AspNetCore/commit/e6cb639cc0) Add handler functional test
* [`[ab3dce85fc]`](https://github.com/aspnet/AspNetCore/commit/ab3dce85fc) tidy up status codes and transport conflicts (#306)
* [`[fdd08ceab2]`](https://github.com/aspnet/AspNetCore/commit/fdd08ceab2) Adding RazorSyntaxFactsService
* [`[39819d6708]`](https://github.com/aspnet/AspNetCore/commit/39819d6708) Added fast path for single memory ReadableBuffer (#1512)
* [`[2ed456fd68]`](https://github.com/aspnet/AspNetCore/commit/2ed456fd68) Faster Write implementation using cpblk (#1511)
* [`[8a6a22c767]`](https://github.com/aspnet/AspNetCore/commit/8a6a22c767) Fix one of Taylor's broken comparers
* [`[bbd08f0cc9]`](https://github.com/aspnet/AspNetCore/commit/bbd08f0cc9) Add TagHelper directive and match info to CodeDocument
* [`[feb5f395d2]`](https://github.com/aspnet/AspNetCore/commit/feb5f395d2) Make TagHelperDescriptor and friends IEquatable
* [`[b6aa6b8099]`](https://github.com/aspnet/AspNetCore/commit/b6aa6b8099) Make AcceptedCharacters non-legacy
* [`[acbbdf0b2c]`](https://github.com/aspnet/AspNetCore/commit/acbbdf0b2c) Rename BlockType -> BlockKind
* [`[0aee9152bd]`](https://github.com/aspnet/AspNetCore/commit/0aee9152bd) Make AcceptedCharacters public
* [`[6a0641f716]`](https://github.com/aspnet/AspNetCore/commit/6a0641f716) Try latest corefx packages (#319)
* [`[f6e5e74d95]`](https://github.com/aspnet/AspNetCore/commit/f6e5e74d95) Update packages (#1509)
* [`[1094cc0670]`](https://github.com/aspnet/AspNetCore/commit/1094cc0670) Use StreamSocketOutput for writing benchmarks (#1507)
* [`[5b814a55ac]`](https://github.com/aspnet/AspNetCore/commit/5b814a55ac) Speed up WritableBuffer.WriteXxx (#1504)
* [`[01a10c3505]`](https://github.com/aspnet/AspNetCore/commit/01a10c3505) Downgrade corefxlab
* [`[07cbf7faa9]`](https://github.com/aspnet/AspNetCore/commit/07cbf7faa9) Use pipelines for SocketOutput - Changed socket output to be based on pipelines - Changed connection filter glue to be based on pipelines - Codegen that used `MemoryPoolIterator` for output now uses `WritableBuffer` - Made `UvWriteReq` async/await friendly with `LibuvAwaitable<T>` - Deleted MemoryPool and friends
* [`[b283740530]`](https://github.com/aspnet/AspNetCore/commit/b283740530) Adding .editorconfig
* [`[43a290d2c4]`](https://github.com/aspnet/AspNetCore/commit/43a290d2c4) Updated readme with instructions on verifying cross repo changes
* [`[a61220d907]`](https://github.com/aspnet/AspNetCore/commit/a61220d907) suppress some Autobahn test failures (#153)
* [`[95de690acd]`](https://github.com/aspnet/AspNetCore/commit/95de690acd) Log error when selfhostdeployer is unable to start the process
* [`[fcb4b6ddbc]`](https://github.com/aspnet/AspNetCore/commit/fcb4b6ddbc) Skip xplat standalone tests temporarily
* [`[8f9ff1abd9]`](https://github.com/aspnet/AspNetCore/commit/8f9ff1abd9) Clean up TagHelperDescriptor APIs.
* [`[1197657e5b]`](https://github.com/aspnet/AspNetCore/commit/1197657e5b) TempData property attribute
* [`[ce28117b8b]`](https://github.com/aspnet/AspNetCore/commit/ce28117b8b) Normalize line endings in RazorEngine tests
* [`[23375c911b]`](https://github.com/aspnet/AspNetCore/commit/23375c911b) Fixes a race where wrong task could be awaited in channel completion
* [`[90b48347a5]`](https://github.com/aspnet/AspNetCore/commit/90b48347a5) Port the legacy RazorEditorParser
* [`[0911f9023b]`](https://github.com/aspnet/AspNetCore/commit/0911f9023b) add additional test for 0-byte sends (#308)
* [`[74889c8f99]`](https://github.com/aspnet/AspNetCore/commit/74889c8f99) Modified MvcRazorHost tests to use new Razor
* [`[1732ac5760]`](https://github.com/aspnet/AspNetCore/commit/1732ac5760) add support for binary format in /poll (#303)
* [`[c89ba8c1ec]`](https://github.com/aspnet/AspNetCore/commit/c89ba8c1ec) Consolidate dependency versions to one file
* [`[1d61e9059f]`](https://github.com/aspnet/AspNetCore/commit/1d61e9059f) :arrow_up: update ResponseCompression to latest dev version
* [`[0133153bc9]`](https://github.com/aspnet/AspNetCore/commit/0133153bc9) use new protocol for '/send' (#297)
* [`[cd246adb6f]`](https://github.com/aspnet/AspNetCore/commit/cd246adb6f) Update spec for behavior on poll reconnect (#305)
* [`[1ce7fc7245]`](https://github.com/aspnet/AspNetCore/commit/1ce7fc7245) Use TryAdd to add services
* [`[8f4ca32f48]`](https://github.com/aspnet/AspNetCore/commit/8f4ca32f48) Fix #5807 - Race condition in Invoker
* [`[6f7717a381]`](https://github.com/aspnet/AspNetCore/commit/6f7717a381) Unify dependency versions to one file
* [`[43a41398ac]`](https://github.com/aspnet/AspNetCore/commit/43a41398ac) Unify dependency versions to one file
* [`[77e763a516]`](https://github.com/aspnet/AspNetCore/commit/77e763a516) port aspnet/WebSockets#149 (#301)
* [`[890a81562f]`](https://github.com/aspnet/AspNetCore/commit/890a81562f) Unify dependency versions
* [`[832cbdcee8]`](https://github.com/aspnet/AspNetCore/commit/832cbdcee8) Unify dependency versions to one file
* [`[73d58b7a13]`](https://github.com/aspnet/AspNetCore/commit/73d58b7a13) Unify dependency versions to one file
* [`[ce6c832465]`](https://github.com/aspnet/AspNetCore/commit/ce6c832465) Unify dependency version to one file
* [`[9a4a810aa8]`](https://github.com/aspnet/AspNetCore/commit/9a4a810aa8) Fix race conditions in test event listener
* [`[5bcf919faa]`](https://github.com/aspnet/AspNetCore/commit/5bcf919faa) Account for repositories with no packaes to publish
* [`[1db9776b24]`](https://github.com/aspnet/AspNetCore/commit/1db9776b24) Fix publishing packages to the volatile feed
* [`[310ccc31d0]`](https://github.com/aspnet/AspNetCore/commit/310ccc31d0) Include default imports when ImportsFileName is null
* [`[bee1a55cff]`](https://github.com/aspnet/AspNetCore/commit/bee1a55cff) Use RazorPagesOptions.RootDirectory when looking for page hierarchies. Fixes #5915
* [`[d8143e2603]`](https://github.com/aspnet/AspNetCore/commit/d8143e2603) Update Yeoman package README
* [`[d4c0d4b81e]`](https://github.com/aspnet/AspNetCore/commit/d4c0d4b81e) Adds an EventSource named 'Microsoft-AspNetCore-Server-Kestrel' with the following event and properties:
* [`[9021999c32]`](https://github.com/aspnet/AspNetCore/commit/9021999c32) Fix deployer for Win7 and Win2008
* [`[de25357c28]`](https://github.com/aspnet/AspNetCore/commit/de25357c28) Do not throw if a library does not have a runtime component
* [`[82d87df166]`](https://github.com/aspnet/AspNetCore/commit/82d87df166) Fix warning as error
* [`[2ffaa88830]`](https://github.com/aspnet/AspNetCore/commit/2ffaa88830) Using NullLogger types from Logging.Abstractions
* [`[4569750d86]`](https://github.com/aspnet/AspNetCore/commit/4569750d86) Using NullLogger types from Logging.Abstractions (#389)
* [`[461b08b6f7]`](https://github.com/aspnet/AspNetCore/commit/461b08b6f7) Using NullLogger types from Logging.Abstractions (#178)
* [`[a48c0cacca]`](https://github.com/aspnet/AspNetCore/commit/a48c0cacca) Using NullLogger types from Logging.Abstractions (#115)
* [`[cb150de808]`](https://github.com/aspnet/AspNetCore/commit/cb150de808) port dotnet/corefx#17049 (#151)
* [`[64f84811bd]`](https://github.com/aspnet/AspNetCore/commit/64f84811bd) Fix incorrect debug asserts
* [`[fcbb43cc03]`](https://github.com/aspnet/AspNetCore/commit/fcbb43cc03) use new CoreFxLab buffer read/write primitives (#276)
* [`[365ae19c8b]`](https://github.com/aspnet/AspNetCore/commit/365ae19c8b) Add InvalidTagHelperIndexerAssignment to RazorPageBase
* [`[577b765a8a]`](https://github.com/aspnet/AspNetCore/commit/577b765a8a) Update TransportProtocols.md (#295)
* [`[2f2d3a6f24]`](https://github.com/aspnet/AspNetCore/commit/2f2d3a6f24) Fixing Receive/Close race
* [`[e8ad3b4160]`](https://github.com/aspnet/AspNetCore/commit/e8ad3b4160) Adding detailed logging to the client
* [`[df0d4cbfa8]`](https://github.com/aspnet/AspNetCore/commit/df0d4cbfa8) Using NullLogger types from Logging.Abstractions
* [`[e44d875df4]`](https://github.com/aspnet/AspNetCore/commit/e44d875df4) Adding AuthorizePage & AuthorizeFolder without requiring a policy
* [`[f7fd5114b3]`](https://github.com/aspnet/AspNetCore/commit/f7fd5114b3) Introduce MvcRazorTemplateEngine
* [`[9b553ca1c0]`](https://github.com/aspnet/AspNetCore/commit/9b553ca1c0) make all tests allow 'non-strict' conformance (#149)
* [`[b94912bcb1]`](https://github.com/aspnet/AspNetCore/commit/b94912bcb1) InitializeHeaders only at start of parsing/Fix remaining (#1488)
* [`[1bfa9c4b4b]`](https://github.com/aspnet/AspNetCore/commit/1bfa9c4b4b) Make it possible to detect that a process is running inside dotnet-watch by setting 'DOTNET_WATCH=1'
* [`[3077b8a8c0]`](https://github.com/aspnet/AspNetCore/commit/3077b8a8c0) Modifies babel config to allow for webpack tree shaking
* [`[2fc88fe9c1]`](https://github.com/aspnet/AspNetCore/commit/2fc88fe9c1) Add support for base path in FindHiearchicalItems
* [`[7d7ecf3a1b]`](https://github.com/aspnet/AspNetCore/commit/7d7ecf3a1b) Make precompilation tests use project reference instead of package reference
* [`[35986c778f]`](https://github.com/aspnet/AspNetCore/commit/35986c778f) Back up to .NET 4.5.2 - do not have .NET 4.6.1 reference assemblies on all CI machines - have corrected System.XML casing issue mentioned in 7637f2ea
* [`[32dd435c6e]`](https://github.com/aspnet/AspNetCore/commit/32dd435c6e) Add an opt-out DisableTelemetry option in the OpenID Connect middleware (#1140)
* [`[7d43bfc709]`](https://github.com/aspnet/AspNetCore/commit/7d43bfc709) Add RazorSourceDocument.Create(string template) Add document and fix casing of RazorSourceDocument.FileName Fixes #1063
* [`[e4623bb186]`](https://github.com/aspnet/AspNetCore/commit/e4623bb186) Add Vue template to Yeoman generator
* [`[c6a089880c]`](https://github.com/aspnet/AspNetCore/commit/c6a089880c) Add VueSpa.csproj to .sln
* [`[119b274c19]`](https://github.com/aspnet/AspNetCore/commit/119b274c19) Add server-side rendering (via bundleRenderer, as this is what the Vue docs recommend, and apparently the only way it does encapsulation)
* [`[360688f78b]`](https://github.com/aspnet/AspNetCore/commit/360688f78b) Add Vue template
* [`[9de5519c8b]`](https://github.com/aspnet/AspNetCore/commit/9de5519c8b) Update of wrong variable name
* [`[1b02cd2baf]`](https://github.com/aspnet/AspNetCore/commit/1b02cd2baf) Implement `OwinEnvironment` `IEnumerable.GetEnumerator()` (#789)
* [`[5644310811]`](https://github.com/aspnet/AspNetCore/commit/5644310811) Clean up benchmarks (#1487)
* [`[49f09d5a25]`](https://github.com/aspnet/AspNetCore/commit/49f09d5a25) Log rejected request targets.
* [`[b612da4e6c]`](https://github.com/aspnet/AspNetCore/commit/b612da4e6c) Avoid an unnecessary closure allocation in ListenerSecondary (#1485)
* [`[a26f96237b]`](https://github.com/aspnet/AspNetCore/commit/a26f96237b) Specify StringComparison when calling string.StartsWith (#1484)
* [`[374d84c4ad]`](https://github.com/aspnet/AspNetCore/commit/374d84c4ad) Because VS keeps adding it
* [`[dcdd8cfa9a]`](https://github.com/aspnet/AspNetCore/commit/dcdd8cfa9a) Removing our own copy of NullLoggerFactory Moving TaskQueue to the Internal folder as it is in the Internal namespace
* [`[3c8ee39f1d]`](https://github.com/aspnet/AspNetCore/commit/3c8ee39f1d) Fxi writing perf test (#1478)
* [`[c97dd446eb]`](https://github.com/aspnet/AspNetCore/commit/c97dd446eb) Simplify console output and fix color output on CMD
* [`[0a1ac6a70a]`](https://github.com/aspnet/AspNetCore/commit/0a1ac6a70a) Added missing import in boot.ts in Aurelia template
* [`[8d27d9d583]`](https://github.com/aspnet/AspNetCore/commit/8d27d9d583) Updates Aurelia project url (#741)
* [`[5e6ab1ee3e]`](https://github.com/aspnet/AspNetCore/commit/5e6ab1ee3e) No mono
* [`[94d47a3917]`](https://github.com/aspnet/AspNetCore/commit/94d47a3917) No mono
* [`[90922646bf]`](https://github.com/aspnet/AspNetCore/commit/90922646bf) Enable UnloadProjectsOnCompletion to prevent OOM (#480)
* [`[a2d088bc3c]`](https://github.com/aspnet/AspNetCore/commit/a2d088bc3c) Increasing the timeout of host start (#279)
* [`[49b328d4c2]`](https://github.com/aspnet/AspNetCore/commit/49b328d4c2) Handle absolute, asterisk, and authority-form request targets
* [`[e07c451b2c]`](https://github.com/aspnet/AspNetCore/commit/e07c451b2c) Adding win81 RIDs to match CI Servers' RIDs
* [`[7f3f6957be]`](https://github.com/aspnet/AspNetCore/commit/7f3f6957be) Set path in DefaultPageFactory (#5911)
* [`[5ff734bb71]`](https://github.com/aspnet/AspNetCore/commit/5ff734bb71) [Fixes #53] Enable skipped Standalone tests
* [`[1330b7792d]`](https://github.com/aspnet/AspNetCore/commit/1330b7792d) Add editor references to LanguageServices
* [`[bf2a6140f0]`](https://github.com/aspnet/AspNetCore/commit/bf2a6140f0) Add back a constructor
* [`[a418a175a9]`](https://github.com/aspnet/AspNetCore/commit/a418a175a9) Add TagName to TagHelperContext
* [`[9f0edefd16]`](https://github.com/aspnet/AspNetCore/commit/9f0edefd16) fix #273 by grouping websocket tests (#278)
* [`[3f911fd518]`](https://github.com/aspnet/AspNetCore/commit/3f911fd518) Account for missing ArtifactsDir
* [`[21de1b6221]`](https://github.com/aspnet/AspNetCore/commit/21de1b6221) No mono (#755)
* [`[addbac24aa]`](https://github.com/aspnet/AspNetCore/commit/addbac24aa) Account for missing trailing slash in package path when restoring vsix
* [`[37b0df7406]`](https://github.com/aspnet/AspNetCore/commit/37b0df7406) port change from AutobahnTester in SignalR (#148)
* [`[a00ec445ef]`](https://github.com/aspnet/AspNetCore/commit/a00ec445ef) Moving TS client to a dedicated subfolder (#274)
* [`[02df601715]`](https://github.com/aspnet/AspNetCore/commit/02df601715) Dispatching raising events to separate threads
* [`[3cd8c8c14d]`](https://github.com/aspnet/AspNetCore/commit/3cd8c8c14d) [Fixes #5932] Add constructor taking the BinderType to ModelBinderAttribute
* [`[331c9a4e49]`](https://github.com/aspnet/AspNetCore/commit/331c9a4e49) Fixed NanoServer tests
* [`[0846e13b06]`](https://github.com/aspnet/AspNetCore/commit/0846e13b06) RemoteWindowsDeployer: Changing current working directory to the app output folder
* [`[941d396942]`](https://github.com/aspnet/AspNetCore/commit/941d396942) Speed up ParseRequestLine (#1463)
* [`[49d058a997]`](https://github.com/aspnet/AspNetCore/commit/49d058a997) No mono (#1472)
* [`[a034b2ed04]`](https://github.com/aspnet/AspNetCore/commit/a034b2ed04) Collate diagnositcs from Imports
* [`[a93839e1b2]`](https://github.com/aspnet/AspNetCore/commit/a93839e1b2) Adding TaskQueue
* [`[63e3c9428a]`](https://github.com/aspnet/AspNetCore/commit/63e3c9428a) You can't have two benchmarks as the baseline.
* [`[3a1f3d14f9]`](https://github.com/aspnet/AspNetCore/commit/3a1f3d14f9) Add absolute-uri benchmark and change plaintext, live aspnet, and unicode benchmarks to use origin-form
* [`[62c3c15a1f]`](https://github.com/aspnet/AspNetCore/commit/62c3c15a1f) Fixing a race DisposeAsync is called when StartAsync hasn't finished
* [`[bb973decb8]`](https://github.com/aspnet/AspNetCore/commit/bb973decb8) Unify header rejection messages.
* [`[015dafc25f]`](https://github.com/aspnet/AspNetCore/commit/015dafc25f) [Feature] String should be an acceptable value for a checkbox if it can be parsed as a boolean (#5845)
* [`[e9250323e0]`](https://github.com/aspnet/AspNetCore/commit/e9250323e0) update GeneratedCodeTests
* [`[d3a09ca9e8]`](https://github.com/aspnet/AspNetCore/commit/d3a09ca9e8) Correct ListAdapter tests Modifying a ReadOnlyCollection will always fail
* [`[42d0d40b36]`](https://github.com/aspnet/AspNetCore/commit/42d0d40b36) [Fixes #61] Move must keep object reference
* [`[0bca84a268]`](https://github.com/aspnet/AspNetCore/commit/0bca84a268) Add HttpUtilities to CodeGenerator
* [`[84b038498a]`](https://github.com/aspnet/AspNetCore/commit/84b038498a) Use an exact match from the first repository that finds a package.
* [`[e25eb418bb]`](https://github.com/aspnet/AspNetCore/commit/e25eb418bb) Change non-printable char representation in log messages from <0xXX> to \xXX.
* [`[1f0bb14546]`](https://github.com/aspnet/AspNetCore/commit/1f0bb14546) Clean up left over code from port to pipelines (#1465)
* [`[bca4474dd2]`](https://github.com/aspnet/AspNetCore/commit/bca4474dd2) Use the same name for the props file when loading it from the deps directory
* [`[4e84690938]`](https://github.com/aspnet/AspNetCore/commit/4e84690938) Make publishing to the volatile feed work.
* [`[13519b6079]`](https://github.com/aspnet/AspNetCore/commit/13519b6079) Fix CopyTo implementation in benchmark. (#1462)
* [`[d9d280d1ef]`](https://github.com/aspnet/AspNetCore/commit/d9d280d1ef) Make CookieTempDataProvider the default ITempDataProvider (#5892)
* [`[5743d740b4]`](https://github.com/aspnet/AspNetCore/commit/5743d740b4) Convert HTTP parsing FrameTests to IHttpParser tests (#1416).
* [`[2be05e24c8]`](https://github.com/aspnet/AspNetCore/commit/2be05e24c8) Removing [Fin]
* [`[e2f8c226ef]`](https://github.com/aspnet/AspNetCore/commit/e2f8c226ef) Simplify TakeSingleHeader and Vectorize (#1457)
* [`[f374d92712]`](https://github.com/aspnet/AspNetCore/commit/f374d92712) WebSockets transport now creates correct url (#268)
* [`[78dfd278c1]`](https://github.com/aspnet/AspNetCore/commit/78dfd278c1) Integrating new transport protocols (#257)
* [`[02a4342908]`](https://github.com/aspnet/AspNetCore/commit/02a4342908) Made changes to TakeSingleHeader (#1453)
* [`[06134bc6e0]`](https://github.com/aspnet/AspNetCore/commit/06134bc6e0) Add IPv6 loopback address by default #1434
* [`[9a27405718]`](https://github.com/aspnet/AspNetCore/commit/9a27405718) Add LanguageServices test project
* [`[dee8d8694f]`](https://github.com/aspnet/AspNetCore/commit/dee8d8694f) Prevent LOH allocations when constructing large Razor Source Documents. (#1049)
* [`[4a20c849cb]`](https://github.com/aspnet/AspNetCore/commit/4a20c849cb) Add functional test for Page.View() (#5896)
* [`[cefca39510]`](https://github.com/aspnet/AspNetCore/commit/cefca39510) Fix broken padding in design time
* [`[7bca31d079]`](https://github.com/aspnet/AspNetCore/commit/7bca31d079) Add convenience extension methods for IPageApplicationModelConvention
* [`[a1f4928ed5]`](https://github.com/aspnet/AspNetCore/commit/a1f4928ed5) Clean up Header qvalue parsing
* [`[5c96a7cdef]`](https://github.com/aspnet/AspNetCore/commit/5c96a7cdef) Use an alternate workaround for #5873 - use specific workaround for Microsoft/vstest#428   - generating an executable for a test project is a bit too weird - also work around dotnet/sdk#926   - generating an executable covered this as well
* [`[966cd4a68d]`](https://github.com/aspnet/AspNetCore/commit/966cd4a68d) Introducing BasicWriter and TagHelperWriter
* [`[11c7eb5665]`](https://github.com/aspnet/AspNetCore/commit/11c7eb5665) Verify all request rejections are logged (#1295).
* [`[7d94abd606]`](https://github.com/aspnet/AspNetCore/commit/7d94abd606) Enable default server address test
* [`[0404bcc58c]`](https://github.com/aspnet/AspNetCore/commit/0404bcc58c) Add more microbenchmarks.
* [`[537b06f025]`](https://github.com/aspnet/AspNetCore/commit/537b06f025) Interleave multispan and single span code path (#1442)
* [`[0ce111d9f1]`](https://github.com/aspnet/AspNetCore/commit/0ce111d9f1) Fix write size in benchmark (#1449)
* [`[080494fc78]`](https://github.com/aspnet/AspNetCore/commit/080494fc78) Fix TaskCache type collision
* [`[acf97b6102]`](https://github.com/aspnet/AspNetCore/commit/acf97b6102) Unpin CoreFxLab package versions
* [`[da763b4873]`](https://github.com/aspnet/AspNetCore/commit/da763b4873) Use ascii decoding routine that disallows null chars (#1445)
* [`[544a09dc83]`](https://github.com/aspnet/AspNetCore/commit/544a09dc83) Workaround rogue System.IO.Pipelines on nuget.org
* [`[20f75605ca]`](https://github.com/aspnet/AspNetCore/commit/20f75605ca) Workaround rogue System.IO.Pipelines on nuget.org
* [`[00c38fca59]`](https://github.com/aspnet/AspNetCore/commit/00c38fca59) Add ModelState to Page
* [`[145d27f9b3]`](https://github.com/aspnet/AspNetCore/commit/145d27f9b3) Add a PagesOption type that allows configuring the root for Page file discovery
* [`[83edc38e72]`](https://github.com/aspnet/AspNetCore/commit/83edc38e72) Use TechEmpower request as baseline for request parsing benchmarks.
* [`[7730d33482]`](https://github.com/aspnet/AspNetCore/commit/7730d33482) Introducing DocumentWriter
* [`[ac60f13312]`](https://github.com/aspnet/AspNetCore/commit/ac60f13312) Modify RequestProcessingAsync to call single parse method (#1427)
* [`[7cc5c537a4]`](https://github.com/aspnet/AspNetCore/commit/7cc5c537a4) Added a new benchmark
* [`[c598f1918d]`](https://github.com/aspnet/AspNetCore/commit/c598f1918d) Collect commit files from artifacts directory
* [`[85e28ae478]`](https://github.com/aspnet/AspNetCore/commit/85e28ae478) Trim quotes from template (#5838)
* [`[7cadb58e12]`](https://github.com/aspnet/AspNetCore/commit/7cadb58e12) Add convenience extension methods for IPageApplicationModelConvention
* [`[1e0f2b3951]`](https://github.com/aspnet/AspNetCore/commit/1e0f2b3951) Fix systemd activation tests (#1429)
* [`[7f4f4108db]`](https://github.com/aspnet/AspNetCore/commit/7f4f4108db) Fixed tests to copy remoteDeploymentConfig.json
* [`[aac4eebd79]`](https://github.com/aspnet/AspNetCore/commit/aac4eebd79) Direct address configuration #297
* [`[ac5fd3f29f]`](https://github.com/aspnet/AspNetCore/commit/ac5fd3f29f) PR feetback
* [`[8929b40527]`](https://github.com/aspnet/AspNetCore/commit/8929b40527) Single span optimizations (#1421)
* [`[40ee51846c]`](https://github.com/aspnet/AspNetCore/commit/40ee51846c) Add allocations column (#1422)
* [`[ca31627a5e]`](https://github.com/aspnet/AspNetCore/commit/ca31627a5e) Parser clean up (#1419)
* [`[00aa36db13]`](https://github.com/aspnet/AspNetCore/commit/00aa36db13) Delete makefile.shade
* [`[ba69cd5df4]`](https://github.com/aspnet/AspNetCore/commit/ba69cd5df4) Add VerifyAll target shim
* [`[f2a00da811]`](https://github.com/aspnet/AspNetCore/commit/f2a00da811) Loop over bytes inside states of parser state machine (#1417)
* [`[b89415d9b2]`](https://github.com/aspnet/AspNetCore/commit/b89415d9b2) knownmethods optimizations
* [`[485f9595e2]`](https://github.com/aspnet/AspNetCore/commit/485f9595e2) EndPoint options and injection
* [`[cb6059c143]`](https://github.com/aspnet/AspNetCore/commit/cb6059c143) Make the IHttpParser per frame and add a reset (#1415)
* [`[d3694f085a]`](https://github.com/aspnet/AspNetCore/commit/d3694f085a) Add IHttpParser interface (#1414)
* [`[60c45c382b]`](https://github.com/aspnet/AspNetCore/commit/60c45c382b) #896 Have TestHost populate features before calling IHttpContextFactory.Create
* [`[f7c2e5bffc]`](https://github.com/aspnet/AspNetCore/commit/f7c2e5bffc) [Fixes #5844] Using ExtensionIRNode for Inject directive
* [`[684a77430c]`](https://github.com/aspnet/AspNetCore/commit/684a77430c) Add CI feed to NuGet.config
* [`[3058c050bb]`](https://github.com/aspnet/AspNetCore/commit/3058c050bb) Unify dependency versions across all non-template projects
* [`[d422e61c3e]`](https://github.com/aspnet/AspNetCore/commit/d422e61c3e) Make CSharpRenderingContext and friends public
* [`[9a4009ff8b]`](https://github.com/aspnet/AspNetCore/commit/9a4009ff8b) Added link to the NDC video.
* [`[c56de066d3]`](https://github.com/aspnet/AspNetCore/commit/c56de066d3) Optimized parsing GET verb and version (#1399)
* [`[9c676187f6]`](https://github.com/aspnet/AspNetCore/commit/9c676187f6) Update in-memory tests to used named database.
* [`[c3b33a2676]`](https://github.com/aspnet/AspNetCore/commit/c3b33a2676) Add Url + ILoggerFactory ctor for HubConnection (#253)
* [`[3a8b8c81ab]`](https://github.com/aspnet/AspNetCore/commit/3a8b8c81ab) Update in-memory tests to used named database.
* [`[15adff9433]`](https://github.com/aspnet/AspNetCore/commit/15adff9433) Only format non-negative int64 #760
* [`[568aaff9c4]`](https://github.com/aspnet/AspNetCore/commit/568aaff9c4) Improve HTTP parsing tests (#1393).
* [`[f5ac8c4ebd]`](https://github.com/aspnet/AspNetCore/commit/f5ac8c4ebd) Don't require framework when running CodeGenerator.
* [`[0abac4a20d]`](https://github.com/aspnet/AspNetCore/commit/0abac4a20d) Fix null ref in DisposeAsync on ConnectionState
* [`[fde0f6b2fc]`](https://github.com/aspnet/AspNetCore/commit/fde0f6b2fc) Add an option to Kestrel to disable threadpool dispatching
* [`[a79bc75671]`](https://github.com/aspnet/AspNetCore/commit/a79bc75671) Migrate to csproj (#703)
* [`[3772c7c343]`](https://github.com/aspnet/AspNetCore/commit/3772c7c343) Downgrade versions of new packages to 1.0.0
* [`[a95743c5f6]`](https://github.com/aspnet/AspNetCore/commit/a95743c5f6) Add functional test to verify generated code is up to date (#1369).
* [`[c6705d8693]`](https://github.com/aspnet/AspNetCore/commit/c6705d8693) Convert TakeStartLine and TakeMessageHeaders to be state machines (#1401)
* [`[e2e0c8dadf]`](https://github.com/aspnet/AspNetCore/commit/e2e0c8dadf) Add install instructions to README.md
* [`[cc29517ef3]`](https://github.com/aspnet/AspNetCore/commit/cc29517ef3) Add https client ceritificate mapping test (#74)
* [`[b312a84ff4]`](https://github.com/aspnet/AspNetCore/commit/b312a84ff4) Fixed solution file
* [`[57e5d1200a]`](https://github.com/aspnet/AspNetCore/commit/57e5d1200a) Use sake-dev instead of a specific commit
* [`[6dfbab0b6c]`](https://github.com/aspnet/AspNetCore/commit/6dfbab0b6c) More graceful error when running parallel git target
* [`[76fa731a6d]`](https://github.com/aspnet/AspNetCore/commit/76fa731a6d) Add .editorconfig
* [`[8140b8cdfe]`](https://github.com/aspnet/AspNetCore/commit/8140b8cdfe) Use Spans to parse the start line and headers (#1394)
* [`[913d9ef465]`](https://github.com/aspnet/AspNetCore/commit/913d9ef465) Quick fix for attribute documentation
* [`[04395b8bfa]`](https://github.com/aspnet/AspNetCore/commit/04395b8bfa) Update VSIX version
* [`[550283957a]`](https://github.com/aspnet/AspNetCore/commit/550283957a) Tolerate null returns from OOP methods
* [`[f177648c88]`](https://github.com/aspnet/AspNetCore/commit/f177648c88) Add activity log for TagHelper exceptions
* [`[498c1c570d]`](https://github.com/aspnet/AspNetCore/commit/498c1c570d) Update error message
* [`[9950325269]`](https://github.com/aspnet/AspNetCore/commit/9950325269) Update view compilation error message
* [`[615d8e71d6]`](https://github.com/aspnet/AspNetCore/commit/615d8e71d6) ifdef all the Razor Info window code
* [`[39b536b402]`](https://github.com/aspnet/AspNetCore/commit/39b536b402) Don't treat canceled reads as end of input
* [`[94d21e03f5]`](https://github.com/aspnet/AspNetCore/commit/94d21e03f5) Fixing support for XML docs in OOP
* [`[990e2a8dc4]`](https://github.com/aspnet/AspNetCore/commit/990e2a8dc4) Use pass through connection adapter instead of ssl for max buffer size tests (#1391)
* [`[a38db81b71]`](https://github.com/aspnet/AspNetCore/commit/a38db81b71) Templates that were waiting for awesome-typescript-loader 3.0.0 to ship no longer need to wait - it has shipped
* [`[08c550655a]`](https://github.com/aspnet/AspNetCore/commit/08c550655a) use new Base64 codec in Text and SSE Formatters (#231)
* [`[539903c7cf]`](https://github.com/aspnet/AspNetCore/commit/539903c7cf) Replace makefile.shade with a PowerShell script
* [`[7d3bcd2bf8]`](https://github.com/aspnet/AspNetCore/commit/7d3bcd2bf8) Avoid unobserved exceptions
* [`[ac096c217b]`](https://github.com/aspnet/AspNetCore/commit/ac096c217b) Add Identity Service to Universe
* [`[9767dbd5c1]`](https://github.com/aspnet/AspNetCore/commit/9767dbd5c1) fix #209 by converting to byte[] (#229)
* [`[a6d611aecd]`](https://github.com/aspnet/AspNetCore/commit/a6d611aecd) Introduce RazorCompilation
* [`[701612c859]`](https://github.com/aspnet/AspNetCore/commit/701612c859) fix #204 by implementing SSE formatter (#210)
* [`[e11e6b3be7]`](https://github.com/aspnet/AspNetCore/commit/e11e6b3be7) Add TempData property and some functional tests
* [`[627ea78e72]`](https://github.com/aspnet/AspNetCore/commit/627ea78e72) Replace image resizing sample with chartist sample
* [`[ba549502e1]`](https://github.com/aspnet/AspNetCore/commit/ba549502e1) Use the IThreadPool as the ReaderScheduler (#1372)
* [`[cb5b8a45f1]`](https://github.com/aspnet/AspNetCore/commit/cb5b8a45f1) [Fixes #959] Generate LineMapping for Using statements with source  - Also generate/test IR baselines with all code generation tests
* [`[19331f9532]`](https://github.com/aspnet/AspNetCore/commit/19331f9532) Adding some basic functional tests
* [`[f84362cc76]`](https://github.com/aspnet/AspNetCore/commit/f84362cc76) one last try to get this test de-flaked (#227)
* [`[80b9673693]`](https://github.com/aspnet/AspNetCore/commit/80b9673693) Temporary add delay to connection test to make it pass (#1384)
* [`[755ba7613e]`](https://github.com/aspnet/AspNetCore/commit/755ba7613e) Fix #215 and restore tests (#218)
* [`[9709139a27]`](https://github.com/aspnet/AspNetCore/commit/9709139a27) Fixing a bug where pending invocations were not terminated correctly
* [`[12c6a4b917]`](https://github.com/aspnet/AspNetCore/commit/12c6a4b917) Adding IConnection interface
* [`[7a4746868a]`](https://github.com/aspnet/AspNetCore/commit/7a4746868a) Removing Dispose from Transport, Connection and HubConnection Converting StopAsync to DisposeAsync
* [`[4fd71e3a6b]`](https://github.com/aspnet/AspNetCore/commit/4fd71e3a6b) Fix 'No data found for...' errors in CI test runs.
* [`[cc7f835e1d]`](https://github.com/aspnet/AspNetCore/commit/cc7f835e1d) Creating npm package for ts client
* [`[fd82d0214e]`](https://github.com/aspnet/AspNetCore/commit/fd82d0214e) Fix Theorys that should have been Facts.
* [`[3162946139]`](https://github.com/aspnet/AspNetCore/commit/3162946139) In ReactReduxSpa, configure store before matching routes. Fixes #663
* [`[36e4dbe941]`](https://github.com/aspnet/AspNetCore/commit/36e4dbe941) Adding a functional test project for Razor Pages
* [`[ef60779d31]`](https://github.com/aspnet/AspNetCore/commit/ef60779d31) Add Gitter badge (#1371)
* [`[c76ae277a3]`](https://github.com/aspnet/AspNetCore/commit/c76ae277a3) Add baselines for codegen tests
* [`[1ae0b21630]`](https://github.com/aspnet/AspNetCore/commit/1ae0b21630) Replace CSharpIRToken with RazorIRToken
* [`[2e4b1f4d18]`](https://github.com/aspnet/AspNetCore/commit/2e4b1f4d18) Fix compilation error.
* [`[ed9068cef4]`](https://github.com/aspnet/AspNetCore/commit/ed9068cef4) Replace RazorError with RazorDiagnostics in public API
* [`[824ef2c937]`](https://github.com/aspnet/AspNetCore/commit/824ef2c937) Input Pipeline migration (#1277)
* [`[7a2f89b5de]`](https://github.com/aspnet/AspNetCore/commit/7a2f89b5de) Add assembly name filtering to GetTagHelpers calls.
* [`[927e75870d]`](https://github.com/aspnet/AspNetCore/commit/927e75870d) Add BindingSourceMetadataProvider
* [`[965ae5490f]`](https://github.com/aspnet/AspNetCore/commit/965ae5490f) Introducing RazorIRToken
* [`[de6bfa480f]`](https://github.com/aspnet/AspNetCore/commit/de6bfa480f) Only show C# projects in Razor info window.
* [`[290c11ef3a]`](https://github.com/aspnet/AspNetCore/commit/290c11ef3a) Set ToolsVersion=15.0
* [`[8c17375be0]`](https://github.com/aspnet/AspNetCore/commit/8c17375be0) Surface TagHelper resolution errors.
* [`[bfe1f06938]`](https://github.com/aspnet/AspNetCore/commit/bfe1f06938) Fix AddressRegistrationTests.RegisterAddresses_IPv6ScopeId_Success (#1363).
* [`[6f33ebc1f5]`](https://github.com/aspnet/AspNetCore/commit/6f33ebc1f5) ObjectMethodExecutor
* [`[a13aa4de10]`](https://github.com/aspnet/AspNetCore/commit/a13aa4de10) Using webSockets transport as the default transport
* [`[d5ec0859e5]`](https://github.com/aspnet/AspNetCore/commit/d5ec0859e5) Disabled logging fast-path (#937)
* [`[075771a12d]`](https://github.com/aspnet/AspNetCore/commit/075771a12d) Re-enable netcoreapp1.1 tests (part 2)
* [`[f3a0ee5bdb]`](https://github.com/aspnet/AspNetCore/commit/f3a0ee5bdb) Add `RazorLanguageServiceException` to capture unexpected exceptions.
* [`[366dbde378]`](https://github.com/aspnet/AspNetCore/commit/366dbde378) Add culture constructor to RouteValueProvider
* [`[239e2202e1]`](https://github.com/aspnet/AspNetCore/commit/239e2202e1) ActionContextAccessor netstandard behave like net451 (#5810)
* [`[cfa4689d47]`](https://github.com/aspnet/AspNetCore/commit/cfa4689d47) Re-enable netcoreapp1.1 tests
* [`[f56d1b9441]`](https://github.com/aspnet/AspNetCore/commit/f56d1b9441) Updating VS version
* [`[ec7df544ed]`](https://github.com/aspnet/AspNetCore/commit/ec7df544ed) Use latest LTS packages
* [`[607445fc2b]`](https://github.com/aspnet/AspNetCore/commit/607445fc2b) Workaround for broken System.Memory package
* [`[ce4a8f0276]`](https://github.com/aspnet/AspNetCore/commit/ce4a8f0276) Disabling tests broken by new pipelines
* [`[76b998a8dc]`](https://github.com/aspnet/AspNetCore/commit/76b998a8dc) Skip .NET Framework-only tests on xplat
* [`[e35ee53ee5]`](https://github.com/aspnet/AspNetCore/commit/e35ee53ee5) DefaultRazorIRLoweringPhase is too agressive
* [`[1167fec0ba]`](https://github.com/aspnet/AspNetCore/commit/1167fec0ba) Skip functional tests on Linux/macOS
* [`[fd8827e7a9]`](https://github.com/aspnet/AspNetCore/commit/fd8827e7a9) Fix dependency version and solution project type
* [`[7a1a6dd1d6]`](https://github.com/aspnet/AspNetCore/commit/7a1a6dd1d6) Part 2 of RuntimeTarget
* [`[068c29a748]`](https://github.com/aspnet/AspNetCore/commit/068c29a748) Add repo folders to gitignore
* [`[c4ea355ddf]`](https://github.com/aspnet/AspNetCore/commit/c4ea355ddf) Allow for an alternate application name to be used as part of deployment. (#945)
* [`[4b2245eeb9]`](https://github.com/aspnet/AspNetCore/commit/4b2245eeb9) [Fixes #924] Correct RightShiftAssign operator
* [`[0097e40e46]`](https://github.com/aspnet/AspNetCore/commit/0097e40e46) Downgrade to stable packages
* [`[f684fcb574]`](https://github.com/aspnet/AspNetCore/commit/f684fcb574) Downgrade to stable packages
* [`[708630fd23]`](https://github.com/aspnet/AspNetCore/commit/708630fd23) Downgrade to stable packages
* [`[2a5c4320d2]`](https://github.com/aspnet/AspNetCore/commit/2a5c4320d2) increase retry count in autobahn tests
* [`[29647fda33]`](https://github.com/aspnet/AspNetCore/commit/29647fda33) [Fixes #5801] Move call to validate constructor in ComplexTypeModelBinder into CreateModel
* [`[7298fb23a5]`](https://github.com/aspnet/AspNetCore/commit/7298fb23a5) Downgrade to stable packages
* [`[95b73eae15]`](https://github.com/aspnet/AspNetCore/commit/95b73eae15) Downgrade to stable packages
* [`[2797101f64]`](https://github.com/aspnet/AspNetCore/commit/2797101f64) Downgrade to stable packages
* [`[75a0b9889a]`](https://github.com/aspnet/AspNetCore/commit/75a0b9889a) Downgrade to stable packages
* [`[c9d0ba6f45]`](https://github.com/aspnet/AspNetCore/commit/c9d0ba6f45) Downgrade to stable packages
* [`[b2c30da48d]`](https://github.com/aspnet/AspNetCore/commit/b2c30da48d) Downgrade to stable packages
* [`[ec73ffbdf6]`](https://github.com/aspnet/AspNetCore/commit/ec73ffbdf6) Downgrade to stable packages
* [`[28ec5017dc]`](https://github.com/aspnet/AspNetCore/commit/28ec5017dc) Downgrade to stable packages
* [`[395eeb125e]`](https://github.com/aspnet/AspNetCore/commit/395eeb125e) Downgrade to stable packages
* [`[a3e847e6cc]`](https://github.com/aspnet/AspNetCore/commit/a3e847e6cc) De-statificying HubConnection Wiring and raising events correctly
* [`[d4fbdd055a]`](https://github.com/aspnet/AspNetCore/commit/d4fbdd055a) Raising Received event
* [`[4f6306f352]`](https://github.com/aspnet/AspNetCore/commit/4f6306f352) Adding rasing Connected and Closed events
* [`[966470d269]`](https://github.com/aspnet/AspNetCore/commit/966470d269) Adding connection state
* [`[3ba95b98af]`](https://github.com/aspnet/AspNetCore/commit/3ba95b98af) Converting static ConnectAsync to instance StartAsync
* [`[70d97dd7b8]`](https://github.com/aspnet/AspNetCore/commit/70d97dd7b8) finish binary protocol formatter/parser (#203)
* [`[cb7692d16e]`](https://github.com/aspnet/AspNetCore/commit/cb7692d16e) WebSockets Transport (#185)
* [`[dc60a2e9c5]`](https://github.com/aspnet/AspNetCore/commit/dc60a2e9c5) Downgrade to stable packages
* [`[01d2c102fc]`](https://github.com/aspnet/AspNetCore/commit/01d2c102fc) Downgrade to stable packages
* [`[d57d729d13]`](https://github.com/aspnet/AspNetCore/commit/d57d729d13) Enable configuring the default service provider (#943)
* [`[55f31a8279]`](https://github.com/aspnet/AspNetCore/commit/55f31a8279) Use .NET 4.5.2 target framework when deploying test sites - follow-up to 8ae481c - sites are also built for .NET 4.5.2 in desktop runs
* [`[2773777ed1]`](https://github.com/aspnet/AspNetCore/commit/2773777ed1) Use .NET 4.5.2 target framework when deploying test sites - follow-up to 0527786 - sites are also built for .NET 4.5.2 in desktop runs
* [`[c8053845a4]`](https://github.com/aspnet/AspNetCore/commit/c8053845a4) Downgrade to stable packages
* [`[9847f40654]`](https://github.com/aspnet/AspNetCore/commit/9847f40654) Downgrade to stable packages
* [`[8764af8a36]`](https://github.com/aspnet/AspNetCore/commit/8764af8a36) Downgrade to stable packages
* [`[27d9b78fd2]`](https://github.com/aspnet/AspNetCore/commit/27d9b78fd2) Downgrade to stable packages
* [`[95cf0f48ff]`](https://github.com/aspnet/AspNetCore/commit/95cf0f48ff) Downgrade to stable packages
* [`[279855d947]`](https://github.com/aspnet/AspNetCore/commit/279855d947) Downgrade to stable packages
* [`[8051f3671b]`](https://github.com/aspnet/AspNetCore/commit/8051f3671b) Downgrade to stable packages
* [`[b9bba9cbb1]`](https://github.com/aspnet/AspNetCore/commit/b9bba9cbb1) Downgrade to stable packages
* [`[52c684ec13]`](https://github.com/aspnet/AspNetCore/commit/52c684ec13) Downgrade to stable packages
* [`[89a63f5885]`](https://github.com/aspnet/AspNetCore/commit/89a63f5885) Downgrade to stable packages
* [`[0c714cf61b]`](https://github.com/aspnet/AspNetCore/commit/0c714cf61b) Downgrade to stable packages
* [`[df21a82516]`](https://github.com/aspnet/AspNetCore/commit/df21a82516) Downgrade to stable packages
* [`[a728e1da41]`](https://github.com/aspnet/AspNetCore/commit/a728e1da41) Text Protocol Formatter (#187)
* [`[fc580eb0e9]`](https://github.com/aspnet/AspNetCore/commit/fc580eb0e9) Updated copy license for test
* [`[b4e3ccf67f]`](https://github.com/aspnet/AspNetCore/commit/b4e3ccf67f) added test cases to Dev branch (#72)
* [`[eb820106e2]`](https://github.com/aspnet/AspNetCore/commit/eb820106e2) Generate the class name from relative path
* [`[2697ad9a37]`](https://github.com/aspnet/AspNetCore/commit/2697ad9a37) Faster RequestServices (#941)
* [`[44048331e9]`](https://github.com/aspnet/AspNetCore/commit/44048331e9) Make `ViewComponent.View()` overloads respect explicitly passed in model even when `null`
* [`[0dbf62196c]`](https://github.com/aspnet/AspNetCore/commit/0dbf62196c) Introduces RuntimeTarget and abstraction for APIs
* [`[82cbda4a9a]`](https://github.com/aspnet/AspNetCore/commit/82cbda4a9a) Making `OrTimeout` common (#193)
* [`[3c2fd50e8f]`](https://github.com/aspnet/AspNetCore/commit/3c2fd50e8f) Add fields to dotnet new NuSpec file
* [`[531c11df2a]`](https://github.com/aspnet/AspNetCore/commit/531c11df2a) Fix 5594 - ExceptionHandled + Result is broken
* [`[5a67ca35be]`](https://github.com/aspnet/AspNetCore/commit/5a67ca35be) Add 'primaryOutputs' to dotnet new template.json files (and reorder JSON properties alphabetically)
* [`[1bf283877e]`](https://github.com/aspnet/AspNetCore/commit/1bf283877e) More updates to "dotnet new" template to produce correct template.json values
* [`[1115a0aff5]`](https://github.com/aspnet/AspNetCore/commit/1115a0aff5) Fix package.json files in Angular2Spa and AureliaSpa to have replaceable name (not hardcoded as Angular2Spa, etc.). Other templates were already set up like this.
* [`[a5c7a7e491]`](https://github.com/aspnet/AspNetCore/commit/a5c7a7e491) Bring tests from fa710e6  (rel/1.0.3) into dev - relates to #5595 which was a 1.0.x-only problem
* [`[3611adb894]`](https://github.com/aspnet/AspNetCore/commit/3611adb894) Fix mispaired solution configurations
* [`[4bddb5ff1b]`](https://github.com/aspnet/AspNetCore/commit/4bddb5ff1b) Small follow up to 8ee3d45 - rename `containsIndexers` to `doNotCache` in `ExpressionHelper`
* [`[fc93c47789]`](https://github.com/aspnet/AspNetCore/commit/fc93c47789) Use Monitor.TryEnter/Exit in the Scan loop (#189)
* [`[8ee3d45ef1]`](https://github.com/aspnet/AspNetCore/commit/8ee3d45ef1) Do not cache expressions containing method calls - #5655 - also make `ExpressionTextCache` more robust for defence-in-depth
* [`[d72cd469bd]`](https://github.com/aspnet/AspNetCore/commit/d72cd469bd) Add CodeAnalysis.Razor to the vsix
* [`[1652bf554f]`](https://github.com/aspnet/AspNetCore/commit/1652bf554f) Workaround APICheck errors
* [`[bc3a741eee]`](https://github.com/aspnet/AspNetCore/commit/bc3a741eee) Use DocumentClassifierPassBase Workaround issue with the model directive disappearing
* [`[8b03e9ef73]`](https://github.com/aspnet/AspNetCore/commit/8b03e9ef73) Make PageStart work Move more API to RazorPageBase
* [`[1151cde469]`](https://github.com/aspnet/AspNetCore/commit/1151cde469) Delete makefile.shade
* [`[00fe95253a]`](https://github.com/aspnet/AspNetCore/commit/00fe95253a) Delete makefile.shade
* [`[b5779b41bf]`](https://github.com/aspnet/AspNetCore/commit/b5779b41bf) Re-add necessary target framework fallbacks
* [`[ea778b9b6d]`](https://github.com/aspnet/AspNetCore/commit/ea778b9b6d) Implement a simple base for document classifiers
* [`[eaadfb70eb]`](https://github.com/aspnet/AspNetCore/commit/eaadfb70eb) Create NoVSIX solution configurations
* [`[21be33023c]`](https://github.com/aspnet/AspNetCore/commit/21be33023c) Implement APM methods in streams (#1335).
* [`[3651264ebf]`](https://github.com/aspnet/AspNetCore/commit/3651264ebf) Add missing runtime identifiers
* [`[0c8df245de]`](https://github.com/aspnet/AspNetCore/commit/0c8df245de) Hiding Channels (#183)
* [`[481ca0a8e0]`](https://github.com/aspnet/AspNetCore/commit/481ca0a8e0) Replace 'loader' with 'use' in various Webpack configs. Fixes 'loader option has been deprecated' warnings.
* [`[28483e2cf3]`](https://github.com/aspnet/AspNetCore/commit/28483e2cf3) In ReactReduxSpa, pin @types/react-router-redux to known-good version 4.0.30, because 4.0.40 is broken. Fixes #651
* [`[e8dd8089d4]`](https://github.com/aspnet/AspNetCore/commit/e8dd8089d4) In Angular2Spa, fix HMR with 2.4.6 and relax version dependency to allow arbitrary 2.x again. Fixes #643
* [`[66148dacf3]`](https://github.com/aspnet/AspNetCore/commit/66148dacf3) Move angular2-template-loader dependency version to ^0.6.2 now that the bug in 0.6.1 is fixed. Fixes #649.
* [`[ba91f403dd]`](https://github.com/aspnet/AspNetCore/commit/ba91f403dd) Don't attempt to repack for x86 on xplat
* [`[ee6e7419f1]`](https://github.com/aspnet/AspNetCore/commit/ee6e7419f1) Install the shared runtime
* [`[412c41118b]`](https://github.com/aspnet/AspNetCore/commit/412c41118b) Set references to PrivateAssets=None
* [`[7190412979]`](https://github.com/aspnet/AspNetCore/commit/7190412979) Tigger caching header finalization on write #92
* [`[02675da467]`](https://github.com/aspnet/AspNetCore/commit/02675da467) Handle single line directives properly
* [`[8b764c57e4]`](https://github.com/aspnet/AspNetCore/commit/8b764c57e4) Parse string directive tokens correctly
* [`[1b01da7a05]`](https://github.com/aspnet/AspNetCore/commit/1b01da7a05) Check hostingLog enabled (#933)
* [`[9264f3aa2d]`](https://github.com/aspnet/AspNetCore/commit/9264f3aa2d) Add TryUpdateModelAsync to pages
* [`[2eba53de1b]`](https://github.com/aspnet/AspNetCore/commit/2eba53de1b) Add support for optional directives
* [`[314aa366e1]`](https://github.com/aspnet/AspNetCore/commit/314aa366e1) Add TempData property support for Pages
* [`[690ef186a3]`](https://github.com/aspnet/AspNetCore/commit/690ef186a3) Add PageActionDescriptorChangeProvider to allow reloading on page changes
* [`[2ff80ffb49]`](https://github.com/aspnet/AspNetCore/commit/2ff80ffb49) Porting DefaultPageHandlerMethodSelector and ExecutorFactory
* [`[64d4b1da0c]`](https://github.com/aspnet/AspNetCore/commit/64d4b1da0c) Add an option to disable publishing "refs" assemblies if compilation of views is enabled
* [`[624909763b]`](https://github.com/aspnet/AspNetCore/commit/624909763b) Make _PageImports work Add support for generating the Model property
* [`[0559bbb9af]`](https://github.com/aspnet/AspNetCore/commit/0559bbb9af) Temporarily pin to Angular 2.4.5 and angular2-template-loader 0.6.0 because of bugs in their patch releases (#643, #649)
* [`[01366e5855]`](https://github.com/aspnet/AspNetCore/commit/01366e5855) Update to Mvc 1.1.1
* [`[8dd1b9aa96]`](https://github.com/aspnet/AspNetCore/commit/8dd1b9aa96) Fix packaging issues
* [`[e9e0cf7325]`](https://github.com/aspnet/AspNetCore/commit/e9e0cf7325) Prevent ODE when ReadStart/Stop() is queued after disposal
* [`[5124adf450]`](https://github.com/aspnet/AspNetCore/commit/5124adf450) Better report Kestrel crashing errors
* [`[9f3dfd9819]`](https://github.com/aspnet/AspNetCore/commit/9f3dfd9819) Make RazorPages work E2E
* [`[fea5d5cfdc]`](https://github.com/aspnet/AspNetCore/commit/fea5d5cfdc) Truncate SystemClock to Seconds Precision (#1110)
* [`[bad8bc945a]`](https://github.com/aspnet/AspNetCore/commit/bad8bc945a) Convert from project.json to csproj
* [`[c349929cc1]`](https://github.com/aspnet/AspNetCore/commit/c349929cc1) Port old Razor tests to new Razor
* [`[8d5abd433f]`](https://github.com/aspnet/AspNetCore/commit/8d5abd433f) Add support for PageStarts
* [`[adf18d4810]`](https://github.com/aspnet/AspNetCore/commit/adf18d4810) Make LineMapping public
* [`[d43f05189a]`](https://github.com/aspnet/AspNetCore/commit/d43f05189a) Overwrite headers when serving response from cache #101
* [`[c95c2a5a6d]`](https://github.com/aspnet/AspNetCore/commit/c95c2a5a6d) [Fixes #5686] Extend `ModelMetadata` to reduce ugliness
* [`[a801a49377]`](https://github.com/aspnet/AspNetCore/commit/a801a49377) Add an API to RazorProject to navigate hierarchical files
* [`[dc0be8d747]`](https://github.com/aspnet/AspNetCore/commit/dc0be8d747) SaveTempDataFilter handle write to body
* [`[7019c55219]`](https://github.com/aspnet/AspNetCore/commit/7019c55219) Fix package path issues
* [`[0f27c30d90]`](https://github.com/aspnet/AspNetCore/commit/0f27c30d90) Upgraded to VS 2017 RC
* [`[7b28d05373]`](https://github.com/aspnet/AspNetCore/commit/7b28d05373) Pin AureliaSpa to extract-text-webpack-plugin 2.0.0-beta.4 until it can move to Webpack 2.2.0 final.
* [`[87b9db7579]`](https://github.com/aspnet/AspNetCore/commit/87b9db7579) Add yarn.lock to ignorefiles in aspnet-prerendering
* [`[61ffca6290]`](https://github.com/aspnet/AspNetCore/commit/61ffca6290) In aspnet-prerendering, parse the incoming querystring before passing it to the boot func for convenience. Fixes #638.
* [`[a9e97f6783]`](https://github.com/aspnet/AspNetCore/commit/a9e97f6783) fix(ng-router): update to 3.4.5 for experimental version
* [`[450ee8927c]`](https://github.com/aspnet/AspNetCore/commit/450ee8927c) Workaround dotnet test pathing issues
* [`[aec1bffdd7]`](https://github.com/aspnet/AspNetCore/commit/aec1bffdd7) Disable standalone tests to workaround issues in Microsoft.NET.Sdk
* [`[07f3b7b699]`](https://github.com/aspnet/AspNetCore/commit/07f3b7b699) Simplify packing
* [`[2fff96311b]`](https://github.com/aspnet/AspNetCore/commit/2fff96311b) tidying up the transport spec (#171)
* [`[0f589a5b4c]`](https://github.com/aspnet/AspNetCore/commit/0f589a5b4c) Allow non-strict result for Autobahn case 4.1.3
* [`[8a4d8c0b59]`](https://github.com/aspnet/AspNetCore/commit/8a4d8c0b59) Simplify packing
* [`[74beba7a63]`](https://github.com/aspnet/AspNetCore/commit/74beba7a63) Don't restore for vsix on xplat
* [`[c49d7b8c27]`](https://github.com/aspnet/AspNetCore/commit/c49d7b8c27) Add support for new style Roslyn dotless commits.
* [`[1777f7babd]`](https://github.com/aspnet/AspNetCore/commit/1777f7babd) Enabling Razor Instrumentation
* [`[7af2f6ff36]`](https://github.com/aspnet/AspNetCore/commit/7af2f6ff36) [Fixes #961] Disable instrumentation for TagHelper attribute values
* [`[2730e300c3]`](https://github.com/aspnet/AspNetCore/commit/2730e300c3) Add link to AspNetCoreImageTagHelper
* [`[7dd6ee791a]`](https://github.com/aspnet/AspNetCore/commit/7dd6ee791a) Simplify packing
* [`[e44ee63241]`](https://github.com/aspnet/AspNetCore/commit/e44ee63241) Rename WebListener => HttpSysServer
* [`[e549270b4a]`](https://github.com/aspnet/AspNetCore/commit/e549270b4a) Add RazorDiagnostic type
* [`[5def499323]`](https://github.com/aspnet/AspNetCore/commit/5def499323) Added Sockets.Common and  connection level testing (#173)
* [`[3ade209bf0]`](https://github.com/aspnet/AspNetCore/commit/3ade209bf0) Delete using chunk tests
* [`[6c55754823]`](https://github.com/aspnet/AspNetCore/commit/6c55754823) Fix failing linemappings tests
* [`[2e2b54a507]`](https://github.com/aspnet/AspNetCore/commit/2e2b54a507) Add more cache control header parsing tests
* [`[3289afe007]`](https://github.com/aspnet/AspNetCore/commit/3289afe007) Add check for index advance during parsing
* [`[ac75a3136d]`](https://github.com/aspnet/AspNetCore/commit/ac75a3136d) In generator-aspnetcore-spa, add option to produce Angular 2.4.5 project (with 'experimental' caveat)
* [`[a3af5c0b25]`](https://github.com/aspnet/AspNetCore/commit/a3af5c0b25) In Angular2Spa, reference angular2-universal-patch. This will allow for upgrades to Angular 2.4.5.
* [`[847430a0d9]`](https://github.com/aspnet/AspNetCore/commit/847430a0d9) Update Karma config to allow for Webpack 2-style config file. Fixes #625.
* [`[9dbc119ed1]`](https://github.com/aspnet/AspNetCore/commit/9dbc119ed1) Update View Compilation for new Razor
* [`[b79f8384b0]`](https://github.com/aspnet/AspNetCore/commit/b79f8384b0) Make some methods public for ViewCompilation.
* [`[84d2e027f5]`](https://github.com/aspnet/AspNetCore/commit/84d2e027f5) Use new Razor in MVC
* [`[6ed34ddd33]`](https://github.com/aspnet/AspNetCore/commit/6ed34ddd33) Update KnockoutSpa to Webpack 2 (plus awesome-typescript-loader)
* [`[9f7bc75960]`](https://github.com/aspnet/AspNetCore/commit/9f7bc75960) Update ReactReduxSpa to Webpack 2 (plus awesome-typescript-loader)
* [`[bdd7cfd38b]`](https://github.com/aspnet/AspNetCore/commit/bdd7cfd38b) Update ReactSpa to Webpack 2 (plus awesome-typescript-loader)
* [`[c11aedd272]`](https://github.com/aspnet/AspNetCore/commit/c11aedd272) Call OnStarting before verifying response length (#1303).
* [`[e2a2e9a620]`](https://github.com/aspnet/AspNetCore/commit/e2a2e9a620) Fix memory leak caused by closure allocations in KestrelThread (#1264).
* [`[93981ab13e]`](https://github.com/aspnet/AspNetCore/commit/93981ab13e) Update codegen to be compatible with MVC
* [`[25831260f7]`](https://github.com/aspnet/AspNetCore/commit/25831260f7) Make CodeWrite public
* [`[7449ffad74]`](https://github.com/aspnet/AspNetCore/commit/7449ffad74) Add include and exclude attributes to EnvironmentTagHelper
* [`[2276c9eafe]`](https://github.com/aspnet/AspNetCore/commit/2276c9eafe) Include file names as part of printing Razor parse errors
* [`[d44c9aee1e]`](https://github.com/aspnet/AspNetCore/commit/d44c9aee1e) Added printing of route values when a route is not matched
* [`[2b2cf6efec]`](https://github.com/aspnet/AspNetCore/commit/2b2cf6efec) Correct an issue with codegen for taghelperprefix
* [`[0f4ce625ed]`](https://github.com/aspnet/AspNetCore/commit/0f4ce625ed) Update to VS 2017 RC3
* [`[17dc23a024]`](https://github.com/aspnet/AspNetCore/commit/17dc23a024) [Fixes #5637] Make CookieName of CookieTempDataProvider configurable
* [`[03cdd15e5c]`](https://github.com/aspnet/AspNetCore/commit/03cdd15e5c) SaveTempDataFilter handle write to body
* [`[fb7c25b662]`](https://github.com/aspnet/AspNetCore/commit/fb7c25b662) Added OriginalQueryString property to IStatusCodeReExecuteFeature interface
* [`[e4d00a2da3]`](https://github.com/aspnet/AspNetCore/commit/e4d00a2da3) Update aspnet-webpack to support Webpack 2-style configs that export a function
* [`[d187edbd76]`](https://github.com/aspnet/AspNetCore/commit/d187edbd76) Use the TagHelperBinder to dedupe taghelpers
* [`[98d5d1c70e]`](https://github.com/aspnet/AspNetCore/commit/98d5d1c70e) Flow parser errors over to the CSharpDocument
* [`[7a487a880a]`](https://github.com/aspnet/AspNetCore/commit/7a487a880a) [Fixes #48] Regression: List add must support adding items where index is same as count of elements
* [`[0bf9abbedf]`](https://github.com/aspnet/AspNetCore/commit/0bf9abbedf) Hardcoding the right value for MVC
* [`[6a95002f0e]`](https://github.com/aspnet/AspNetCore/commit/6a95002f0e) Fix lowering of taghelpers inside a section
* [`[cd4afdc083]`](https://github.com/aspnet/AspNetCore/commit/cd4afdc083) [Fixes #116] Set 'no-store' also in Cache-Conrol header
* [`[7725c20c47]`](https://github.com/aspnet/AspNetCore/commit/7725c20c47) Enabled Razor.Evolution tests on linux
* [`[3e214e2399]`](https://github.com/aspnet/AspNetCore/commit/3e214e2399) Introducing IPageModelActivatorProvider
* [`[8ce50e3fb3]`](https://github.com/aspnet/AspNetCore/commit/8ce50e3fb3) Add details on running in Docker Windows containers
* [`[243446d225]`](https://github.com/aspnet/AspNetCore/commit/243446d225) Quick fix for MVC. Hardcoding fullname of HelperResult.
* [`[eafbe74160]`](https://github.com/aspnet/AspNetCore/commit/eafbe74160) Fixed parameter count mismatch when invoking methods with wrong case (#162)
* [`[51b3e82701]`](https://github.com/aspnet/AspNetCore/commit/51b3e82701) OnStarting throws when Response.HasStarted
* [`[9df4674ee5]`](https://github.com/aspnet/AspNetCore/commit/9df4674ee5) Make property attributes public in IR
* [`[936c43a96c]`](https://github.com/aspnet/AspNetCore/commit/936c43a96c) Make instrumentation pass public for MVC
* [`[1840d6823b]`](https://github.com/aspnet/AspNetCore/commit/1840d6823b) Addresses #5694 (#5695)
* [`[c997ea8165]`](https://github.com/aspnet/AspNetCore/commit/c997ea8165) Converting pipelines to channels
* [`[1119bcf1b3]`](https://github.com/aspnet/AspNetCore/commit/1119bcf1b3) Sharing channel connections
* [`[05cc7792df]`](https://github.com/aspnet/AspNetCore/commit/05cc7792df) Synchronize the background scan and closing of connections - It was possible for the application to be torn down during a background scan. When that happened, the timer would be disposed before the end of the scan and would throw an ObjectDisposedException when timer resumption happened. This change introduces a lock that avoids that race.
* [`[8f085c8e5d]`](https://github.com/aspnet/AspNetCore/commit/8f085c8e5d) Create an x86 process to target 32-bit applications Fixes #47
* [`[a031c4badb]`](https://github.com/aspnet/AspNetCore/commit/a031c4badb) Update OpenId package versions
* [`[162cd1fc06]`](https://github.com/aspnet/AspNetCore/commit/162cd1fc06) Handle misbehaving user code (#159)
* [`[934f6a70d1]`](https://github.com/aspnet/AspNetCore/commit/934f6a70d1) Various fixes in HttpConnectionDispatcher (#151)
* [`[9051bbf322]`](https://github.com/aspnet/AspNetCore/commit/9051bbf322) Fix deadlock in SocketOutput (#1304).
* [`[42ae78a360]`](https://github.com/aspnet/AspNetCore/commit/42ae78a360) [Fixes #5012] ProducesAttribute should not inherit from ResultFilterAttribute
* [`[8ac6b6699f]`](https://github.com/aspnet/AspNetCore/commit/8ac6b6699f) [Fixes #4945] Simple string returned by controller action is not a valid JSON!
* [`[ba3976aeeb]`](https://github.com/aspnet/AspNetCore/commit/ba3976aeeb) Update to version 1.1.1.
* [`[c8da6e0628]`](https://github.com/aspnet/AspNetCore/commit/c8da6e0628) Fix deadlock in SocketOutput (#1304).
* [`[acd1dc5e24]`](https://github.com/aspnet/AspNetCore/commit/acd1dc5e24) Fixed inconsistent single quotes (#154)
* [`[3ad8efb4ab]`](https://github.com/aspnet/AspNetCore/commit/3ad8efb4ab) Fixing test after getid to negotiate rename
* [`[9eb42cce2d]`](https://github.com/aspnet/AspNetCore/commit/9eb42cce2d) Clean up disposal of connection state (#148)
* [`[fb4a99ffff]`](https://github.com/aspnet/AspNetCore/commit/fb4a99ffff) Fixing test hangs, adding timeouts. (#149)
* [`[779115b1ad]`](https://github.com/aspnet/AspNetCore/commit/779115b1ad)  #407 Add ContentLength to IHeaderDictionary
* [`[4ac842b050]`](https://github.com/aspnet/AspNetCore/commit/4ac842b050) Update to version 1.0.3.
* [`[119945ca02]`](https://github.com/aspnet/AspNetCore/commit/119945ca02) Cache the ContentLength header value
* [`[ecca980c91]`](https://github.com/aspnet/AspNetCore/commit/ecca980c91) Implement IHeaderDictionary.ContentLength
* [`[32cd737b62]`](https://github.com/aspnet/AspNetCore/commit/32cd737b62) Update to VS RC3
* [`[56bd85aaf2]`](https://github.com/aspnet/AspNetCore/commit/56bd85aaf2) #298 Add a timeout for draining requests on shutdown
* [`[a1c8d3d841]`](https://github.com/aspnet/AspNetCore/commit/a1c8d3d841) Fix the TS client to respect the new endpoint - Seems like the ts client wasn't updated to use /negotiate instead of /getid
* [`[1e957a9e5a]`](https://github.com/aspnet/AspNetCore/commit/1e957a9e5a) Allow processing of incoming invocations in parallel (#143)
* [`[822cb35624]`](https://github.com/aspnet/AspNetCore/commit/822cb35624) Prepare 1.1.0 release and pin floating versions
* [`[32efe43f85]`](https://github.com/aspnet/AspNetCore/commit/32efe43f85) Delete some dead code
* [`[03b63d97a2]`](https://github.com/aspnet/AspNetCore/commit/03b63d97a2) Quick fixes from MVC
* [`[6fd04366b1]`](https://github.com/aspnet/AspNetCore/commit/6fd04366b1) Make dotnet-install runnable
* [`[0ce64a5b83]`](https://github.com/aspnet/AspNetCore/commit/0ce64a5b83) Update the path to dotnet-install.sh
* [`[044648a213]`](https://github.com/aspnet/AspNetCore/commit/044648a213) fixing graceful shutdown on Win7 and IISExpress
* [`[7fcf5f2529]`](https://github.com/aspnet/AspNetCore/commit/7fcf5f2529) Pin the SDK to preview4
* [`[4420390f73]`](https://github.com/aspnet/AspNetCore/commit/4420390f73) Precompilation does not work for applications using relative path
* [`[501540c76e]`](https://github.com/aspnet/AspNetCore/commit/501540c76e) Use the list of Content files specified in the project as a source
* [`[c1ef1e533f]`](https://github.com/aspnet/AspNetCore/commit/c1ef1e533f) Consolidate options to a single file
* [`[8a74148fe1]`](https://github.com/aspnet/AspNetCore/commit/8a74148fe1) Add link to XmlResult repo
* [`[1c4a78597a]`](https://github.com/aspnet/AspNetCore/commit/1c4a78597a) Pin SDK version
* [`[cac6ade7c9]`](https://github.com/aspnet/AspNetCore/commit/cac6ade7c9) Implement Stream Flush+FlushAsync fully
* [`[851dd7ba3b]`](https://github.com/aspnet/AspNetCore/commit/851dd7ba3b) Add support for TagHelper directives
* [`[c31475af4e]`](https://github.com/aspnet/AspNetCore/commit/c31475af4e) Move the LanguageServices package to src
* [`[9ecd30cb2f]`](https://github.com/aspnet/AspNetCore/commit/9ecd30cb2f) Add Microsoft.CodeAnalysis.Razor
* [`[fec3cab2bb]`](https://github.com/aspnet/AspNetCore/commit/fec3cab2bb) Fix line endings
* [`[10fe5e6fa2]`](https://github.com/aspnet/AspNetCore/commit/10fe5e6fa2) Fix performance tests
* [`[4a49ee2164]`](https://github.com/aspnet/AspNetCore/commit/4a49ee2164) Adds support for imports to IR lowering
* [`[d7d1a04751]`](https://github.com/aspnet/AspNetCore/commit/d7d1a04751) When Node is launched with a debug listener, disable connection draining on restart. Fixes #506.
* [`[351fe3d15c]`](https://github.com/aspnet/AspNetCore/commit/351fe3d15c) In SpaServices, add new HotModuleReplacementEndpoint option on HMR config. Fixes #579.
* [`[3313a7f0a6]`](https://github.com/aspnet/AspNetCore/commit/3313a7f0a6) Update Node version to 6.x (current LTS) in Dockerfiles. Fixes #591.
* [`[fddfad14c9]`](https://github.com/aspnet/AspNetCore/commit/fddfad14c9) #1082 Update IdentityModel dependencies to 5.1.2
* [`[3828232d51]`](https://github.com/aspnet/AspNetCore/commit/3828232d51) Fix AAD sample
* [`[f2fd58d8c4]`](https://github.com/aspnet/AspNetCore/commit/f2fd58d8c4) Fix the social sample port.
* [`[f32058c5c3]`](https://github.com/aspnet/AspNetCore/commit/f32058c5c3) Warn instead of throw when ignoring IServerAddressesFeature
* [`[305748a800]`](https://github.com/aspnet/AspNetCore/commit/305748a800) Move classes out of .Internal
* [`[20e02e8fd6]`](https://github.com/aspnet/AspNetCore/commit/20e02e8fd6) Don't overwhelm server with data in KeepAliveTimeoutTests.ConnectionNotTimedOutWhileRequestBeingSent().
* [`[6e647854fa]`](https://github.com/aspnet/AspNetCore/commit/6e647854fa) Add support for `ViewComponentTagHelpers`.
* [`[6396e14504]`](https://github.com/aspnet/AspNetCore/commit/6396e14504) Add null-check back to MediaType
* [`[b8b0c73222]`](https://github.com/aspnet/AspNetCore/commit/b8b0c73222) Added Win7 and Win2008 skip for WebSockets testing
* [`[a84f35022e]`](https://github.com/aspnet/AspNetCore/commit/a84f35022e) Rename a test
* [`[bcd210819a]`](https://github.com/aspnet/AspNetCore/commit/bcd210819a) Prepare 1.1.0 release and pin floating versions
* [`[3c22b86a95]`](https://github.com/aspnet/AspNetCore/commit/3c22b86a95) Create RTM package versions
* [`[8b6c25ad86]`](https://github.com/aspnet/AspNetCore/commit/8b6c25ad86) Minor fix to transport protocol spec
* [`[7a27c5891c]`](https://github.com/aspnet/AspNetCore/commit/7a27c5891c) Describe transport protocols (#125)
* [`[c4762cdfd5]`](https://github.com/aspnet/AspNetCore/commit/c4762cdfd5) Better handle OnHeartbeat in 32-bit environments
* [`[464077866c]`](https://github.com/aspnet/AspNetCore/commit/464077866c) rename getid to negotiate (#124)
* [`[66b98a1c04]`](https://github.com/aspnet/AspNetCore/commit/66b98a1c04) update 502.5 error page
* [`[87f808cc9d]`](https://github.com/aspnet/AspNetCore/commit/87f808cc9d) fixing the AV for graceful shutdown on Win7, set forwardWindowsAuthToken default to true and other minor issues
* [`[6e246fa583]`](https://github.com/aspnet/AspNetCore/commit/6e246fa583) Prepare for 1.0.0 release. Pin versions of tools and SDK
* [`[99e35b9651]`](https://github.com/aspnet/AspNetCore/commit/99e35b9651) :arrow_up: update tool versions to 1.0.1
* [`[24efd4268b]`](https://github.com/aspnet/AspNetCore/commit/24efd4268b) Pin the version of RazorTooling packages to 1.1.0-preview4-final
* [`[e481df3d49]`](https://github.com/aspnet/AspNetCore/commit/e481df3d49) Add better errors, fix help output text, and add 'dotnet watch --list' to help us diagnose issues
* [`[b7d2f8c905]`](https://github.com/aspnet/AspNetCore/commit/b7d2f8c905) separate GetEncodedUrl  and GetEncodedPathAndQuery
* [`[6ac2452231]`](https://github.com/aspnet/AspNetCore/commit/6ac2452231) update xml doc
* [`[51f6415ea1]`](https://github.com/aspnet/AspNetCore/commit/51f6415ea1) let UriHelper.GetEncodedUrl  can  get relative url
* [`[e749a80b30]`](https://github.com/aspnet/AspNetCore/commit/e749a80b30) Check for empty location in ViewsFeatureProvider
* [`[d7527d2e0a]`](https://github.com/aspnet/AspNetCore/commit/d7527d2e0a) Create new way of suppressing unique Id generation
* [`[1a49a27344]`](https://github.com/aspnet/AspNetCore/commit/1a49a27344) Use correct docker base image for csproj projects. Fixes #574.
* [`[ce53675b87]`](https://github.com/aspnet/AspNetCore/commit/ce53675b87) Add `[ValidateNever]` and `IPropertyValidationFilter` - #5642 - lazy-load `ValidationEntry.Model`   - avoids `Exception`s when moving to a property that will not be validated
* [`[e2117dd6b4]`](https://github.com/aspnet/AspNetCore/commit/e2117dd6b4) Do not disable publishing views if MvcRazorCompileOnPublish is not set.
* [`[1b0379126b]`](https://github.com/aspnet/AspNetCore/commit/1b0379126b) Downgrade the versions of new CodeAnalysis packages
* [`[07c22f2b29]`](https://github.com/aspnet/AspNetCore/commit/07c22f2b29) Mutate API description parameter type from JsonPatchDocument to Operation[]
* [`[f95d49c870]`](https://github.com/aspnet/AspNetCore/commit/f95d49c870) Change datetime to datetime-local
* [`[93774a0234]`](https://github.com/aspnet/AspNetCore/commit/93774a0234) Mitigate MediaType overflow
* [`[86490e309f]`](https://github.com/aspnet/AspNetCore/commit/86490e309f) stablize Autobahn 3.2 on WebListener
* [`[a7abdeabcd]`](https://github.com/aspnet/AspNetCore/commit/a7abdeabcd) Introducing PageActionInvoker
* [`[242ea0ee3f]`](https://github.com/aspnet/AspNetCore/commit/242ea0ee3f) Add parsing of includes and imports
* [`[5fa4672c99]`](https://github.com/aspnet/AspNetCore/commit/5fa4672c99) Optimize C# symbol content string allocation
* [`[8215d28ada]`](https://github.com/aspnet/AspNetCore/commit/8215d28ada) Port TagHelperDescriptorFactory tests.
* [`[3bba46d4d3]`](https://github.com/aspnet/AspNetCore/commit/3bba46d4d3) More WebSockets testing (#100)
* [`[89a63d190e]`](https://github.com/aspnet/AspNetCore/commit/89a63d190e) Don't close connection when Content-Length set but no bytes written.
* [`[e312552edd]`](https://github.com/aspnet/AspNetCore/commit/e312552edd) Add setting to extend dotnet-publish arguments in ApplicationDeployer
* [`[208da8ca12]`](https://github.com/aspnet/AspNetCore/commit/208da8ca12) Add plumbing for imports and includes
* [`[172a20c4ec]`](https://github.com/aspnet/AspNetCore/commit/172a20c4ec) Use WaitToWriteAsync(), TryWrite() in HubLifetimeManager(s) (#122)
* [`[ffd455b77e]`](https://github.com/aspnet/AspNetCore/commit/ffd455b77e) Adds Instrumentation support
* [`[20d8f1fca2]`](https://github.com/aspnet/AspNetCore/commit/20d8f1fca2) fix autobahn test app to be an app (#114)
* [`[eec6ae2379]`](https://github.com/aspnet/AspNetCore/commit/eec6ae2379) #163 Update woff2 media type
* [`[8dc68cb798]`](https://github.com/aspnet/AspNetCore/commit/8dc68cb798) Use TryRead and TryWrite (#113)
* [`[13b32adeae]`](https://github.com/aspnet/AspNetCore/commit/13b32adeae) Move InvokeAsync to ResourceInvoker
* [`[6b0282fa84]`](https://github.com/aspnet/AspNetCore/commit/6b0282fa84) Commonize code from ControllerActionInvokerCache and PageFilterFactoryProvider
* [`[b3df10b638]`](https://github.com/aspnet/AspNetCore/commit/b3df10b638) Use connections format
* [`[ac4a0560a3]`](https://github.com/aspnet/AspNetCore/commit/ac4a0560a3) Don't publish cshtml files as part of publish
* [`[a9c7e14da0]`](https://github.com/aspnet/AspNetCore/commit/a9c7e14da0) Making HttpClient configurable and reusable
* [`[3bf5f6a1ce]`](https://github.com/aspnet/AspNetCore/commit/3bf5f6a1ce) Restructure response caching middleware flow
* [`[bd19022c4c]`](https://github.com/aspnet/AspNetCore/commit/bd19022c4c) Fixed teardown for streaming connections - Added mega hack for cancellation until we get newer pipeline implementations.
* [`[baf7fce49d]`](https://github.com/aspnet/AspNetCore/commit/baf7fce49d) Made some fixes to the disconnect sequence - Fixed ChannelConnection to use IChannel<T> for both sides of the connection. This allows use to close both the input and the output when we are tearing down. - Use TryComplete instead of complete to avoid exceptions thrown on Complete(), particularly ChannelClosedException.
* [`[a9dfd83ff4]`](https://github.com/aspnet/AspNetCore/commit/a9dfd83ff4) Fix EF.Tools version
* [`[e26f91a392]`](https://github.com/aspnet/AspNetCore/commit/e26f91a392) Call OnStarting before verifying response length (#1289).
* [`[0af0318f43]`](https://github.com/aspnet/AspNetCore/commit/0af0318f43) fix rebase error
* [`[cf77813c82]`](https://github.com/aspnet/AspNetCore/commit/cf77813c82) Re-enable HTTPS tests (#1273).
* [`[c95639b886]`](https://github.com/aspnet/AspNetCore/commit/c95639b886) Prevent race when validating logs by only examining logs from Session #135
* [`[ee59368467]`](https://github.com/aspnet/AspNetCore/commit/ee59368467) Add Microsoft.CodeAnalysis.Razor.Workspaces.Test project.
* [`[7c6aea443f]`](https://github.com/aspnet/AspNetCore/commit/7c6aea443f) Downgrade Workspaces.Common to 1.3.0 to work with Microsoft.NETCore.App 1.2.
* [`[b18606ec8d]`](https://github.com/aspnet/AspNetCore/commit/b18606ec8d) Fixing chat sample - it was still using fully qualified hub method name
* [`[1ed838fec9]`](https://github.com/aspnet/AspNetCore/commit/1ed838fec9) Don't invoke Path.GetFullPath when calculating MvcRazorOutputPath Add an option that allows specifying the command to invoke
* [`[59b24fb724]`](https://github.com/aspnet/AspNetCore/commit/59b24fb724) Make TagHelperDescriptor public for tooling
* [`[6c7d121ce8]`](https://github.com/aspnet/AspNetCore/commit/6c7d121ce8) Fix bugs in TagHelper discovery
* [`[d281cb72ea]`](https://github.com/aspnet/AspNetCore/commit/d281cb72ea) add "messaging" endpoints and transports
* [`[9917e8bb30]`](https://github.com/aspnet/AspNetCore/commit/9917e8bb30) Update launchSettings for new VS 2017 rules
* [`[622d112372]`](https://github.com/aspnet/AspNetCore/commit/622d112372) #723 Make HttpContextAccessor static AsyncLocal
* [`[3b25acd4ad]`](https://github.com/aspnet/AspNetCore/commit/3b25acd4ad) ContentType.IsNullOrEmpty
* [`[1ac38fea6b]`](https://github.com/aspnet/AspNetCore/commit/1ac38fea6b) Use the version of Roslyn packages available in VS
* [`[cbc8d12a0c]`](https://github.com/aspnet/AspNetCore/commit/cbc8d12a0c) Code dump of Razor extension
* [`[5bf4ec4110]`](https://github.com/aspnet/AspNetCore/commit/5bf4ec4110) Skipping class library tests on xplat
* [`[3351192dc5]`](https://github.com/aspnet/AspNetCore/commit/3351192dc5) Code dump of Visual Studio language services
* [`[2c55a03667]`](https://github.com/aspnet/AspNetCore/commit/2c55a03667) Code dump of prototype servicehub service
* [`[a289e04cb4]`](https://github.com/aspnet/AspNetCore/commit/a289e04cb4) Code dump of TagHelper discovery prototype
* [`[3f5cce41c1]`](https://github.com/aspnet/AspNetCore/commit/3f5cce41c1) Make ViewCompilation a target
* [`[57b368566d]`](https://github.com/aspnet/AspNetCore/commit/57b368566d) Use StatusCode instead of three digit numbers for status codes
* [`[fa0219f75e]`](https://github.com/aspnet/AspNetCore/commit/fa0219f75e) Updating Social Weather sample to 1.2.0
* [`[217f707456]`](https://github.com/aspnet/AspNetCore/commit/217f707456) Sorting out exceptions
* [`[a93f59c660]`](https://github.com/aspnet/AspNetCore/commit/a93f59c660) Add Aurelia to generator's README.md. Fixes #561.
* [`[6d7ddc45ef]`](https://github.com/aspnet/AspNetCore/commit/6d7ddc45ef) Fix deadlock in SocketOutput (#1278).
* [`[2351c1b558]`](https://github.com/aspnet/AspNetCore/commit/2351c1b558) Create a direct way to configure Kestrel endpoints
* [`[c377e6cd28]`](https://github.com/aspnet/AspNetCore/commit/c377e6cd28) For project.json-based projects, fix Kudu deployment by adding a .deployment file at the root
* [`[6789dbc102]`](https://github.com/aspnet/AspNetCore/commit/6789dbc102) csproj-based projects don't need the _placeholder.txt files, because the publishing code correctly includes dist files even if they were not on disk before
* [`[3ea2f36449]`](https://github.com/aspnet/AspNetCore/commit/3ea2f36449) Fix wrong status code
* [`[33dd1d965f]`](https://github.com/aspnet/AspNetCore/commit/33dd1d965f) Add all status codes in IANA list and update reason phrases
* [`[839437ef8c]`](https://github.com/aspnet/AspNetCore/commit/839437ef8c) Fixing issue #44 (#56)
* [`[ac8a86ff3f]`](https://github.com/aspnet/AspNetCore/commit/ac8a86ff3f) Skip specifying the project argument when running dotnet commands
* [`[7d20ae2156]`](https://github.com/aspnet/AspNetCore/commit/7d20ae2156) Add more status codes and reason phrases
* [`[2aff751547]`](https://github.com/aspnet/AspNetCore/commit/2aff751547) fix reference issues in net46 by removing framework assembly refs
* [`[473337ea33]`](https://github.com/aspnet/AspNetCore/commit/473337ea33) CompositeChangeToken moved to aspnet/Common Microsoft.Extensions.Primitives
* [`[a4963aa6da]`](https://github.com/aspnet/AspNetCore/commit/a4963aa6da) fix issue #50 app_offline.htm is case sensitive (#54)
* [`[de0f277892]`](https://github.com/aspnet/AspNetCore/commit/de0f277892) Fix attribute routing error message related to replace tokens
* [`[d04dc7182a]`](https://github.com/aspnet/AspNetCore/commit/d04dc7182a) #263 Disable parallel test execution to improve reliability
* [`[5070526f43]`](https://github.com/aspnet/AspNetCore/commit/5070526f43) replaced hardcoded message with Resources.ArgumentCannotBeNullOrEmpty
* [`[2971909f87]`](https://github.com/aspnet/AspNetCore/commit/2971909f87) Fix WebListener namespaces
* [`[e8452821b9]`](https://github.com/aspnet/AspNetCore/commit/e8452821b9) [Fixes #50] JsonPatchDocument.Replace() yields invalid path when [JsonProperty] is used (1.1.0)
* [`[755d436840]`](https://github.com/aspnet/AspNetCore/commit/755d436840) Fixed error message related to escaping curly braces.
* [`[6125e3982b]`](https://github.com/aspnet/AspNetCore/commit/6125e3982b) Make last test x-plat conditional
* [`[f07e7a5875]`](https://github.com/aspnet/AspNetCore/commit/f07e7a5875) Use the new 101 constant from Http Abstractions.
* [`[e104451f79]`](https://github.com/aspnet/AspNetCore/commit/e104451f79) Make SourceSpan public
* [`[8d94d9179d]`](https://github.com/aspnet/AspNetCore/commit/8d94d9179d) Don't delete the 'src' folder for VS2017 solutions
* [`[87e6c4ed3f]`](https://github.com/aspnet/AspNetCore/commit/87e6c4ed3f) #283 Make old object model internal
* [`[cc84b8402d]`](https://github.com/aspnet/AspNetCore/commit/cc84b8402d) Fix help text for dotnet-user-secrets-set to show the correct Windows example
* [`[78492b39d8]`](https://github.com/aspnet/AspNetCore/commit/78492b39d8) Introduce a base type for executing auth and resource filters.
* [`[eb0a2a1833]`](https://github.com/aspnet/AspNetCore/commit/eb0a2a1833) [Fixes #915] Added TagHelper preallocated attribute optimization pass
* [`[e9a688be15]`](https://github.com/aspnet/AspNetCore/commit/e9a688be15) Optimize 'Span.Content' memory allocation
* [`[6b075880ce]`](https://github.com/aspnet/AspNetCore/commit/6b075880ce) Clean up SourceLocation
* [`[b34bfdd92d]`](https://github.com/aspnet/AspNetCore/commit/b34bfdd92d) Add 101 status code
* [`[8c456aa0fc]`](https://github.com/aspnet/AspNetCore/commit/8c456aa0fc) Make Karma serve .ts files with executable MIME type, otherwise newer versions of Chrome won't run it. Fixes #499
* [`[49bece54c2]`](https://github.com/aspnet/AspNetCore/commit/49bece54c2) Check if response is stream or object without using reference to reflection package.
* [`[0907379da8]`](https://github.com/aspnet/AspNetCore/commit/0907379da8) Streamed responses can be be Object or Stream
* [`[fbb8054c2e]`](https://github.com/aspnet/AspNetCore/commit/fbb8054c2e) Make error message clearer if Node isn't installed (or not found on PATH). Fixes #527
* [`[70f59fc8ec]`](https://github.com/aspnet/AspNetCore/commit/70f59fc8ec) Update core package versions to 1.1.0-beta2-* so that CI will produce non-timestamped packages
* [`[0763f1062b]`](https://github.com/aspnet/AspNetCore/commit/0763f1062b) Add missing trailing slash on publicPath in docs. Fixes #516.
* [`[e84bc66700]`](https://github.com/aspnet/AspNetCore/commit/e84bc66700) First cut of adding API sets
* [`[f45afb6c19]`](https://github.com/aspnet/AspNetCore/commit/f45afb6c19) Add a test for using with trailing newline
* [`[dbf27c30c3]`](https://github.com/aspnet/AspNetCore/commit/dbf27c30c3) Introducing HubActivator (#83)
* [`[874a4cdf3a]`](https://github.com/aspnet/AspNetCore/commit/874a4cdf3a) Add a .sln just for new projects
* [`[2b8233932a]`](https://github.com/aspnet/AspNetCore/commit/2b8233932a) Add IPageFactory and IPageActivator
* [`[0835de17ec]`](https://github.com/aspnet/AspNetCore/commit/0835de17ec) Adds stronger verification for spans
* [`[f191cc62a2]`](https://github.com/aspnet/AspNetCore/commit/f191cc62a2) Get rid of locations on Tokens.
* [`[bd4300d8cc]`](https://github.com/aspnet/AspNetCore/commit/bd4300d8cc) Optimize HTML symbol content string allocation
* [`[0dacf01f54]`](https://github.com/aspnet/AspNetCore/commit/0dacf01f54) [Fixes #912] Added TagHelper design time code generation support
* [`[c72605f43a]`](https://github.com/aspnet/AspNetCore/commit/c72605f43a) Fix NuGet downgrade warning
* [`[9146fce4ec]`](https://github.com/aspnet/AspNetCore/commit/9146fce4ec) Add extension method for IParameterModelConvention. (#5640)
* [`[9dece91975]`](https://github.com/aspnet/AspNetCore/commit/9dece91975) [Fixes #882] Added TagHelper runtime code generation support
* [`[f47a40a4a7]`](https://github.com/aspnet/AspNetCore/commit/f47a40a4a7) Add Razor design time code generation.
* [`[8022afd3a2]`](https://github.com/aspnet/AspNetCore/commit/8022afd3a2) Handling exceptions thrown on the server side
* [`[3a01d6cff1]`](https://github.com/aspnet/AspNetCore/commit/3a01d6cff1) Introducing async/await in TS client + minor clean up
* [`[f9efbf8e78]`](https://github.com/aspnet/AspNetCore/commit/f9efbf8e78) Temporarily disabling running tests in this repo
* [`[b424e5b2b0]`](https://github.com/aspnet/AspNetCore/commit/b424e5b2b0) Updating shared runtime in missed test projects
* [`[c6150ba287]`](https://github.com/aspnet/AspNetCore/commit/c6150ba287) Move section support into IR.
* [`[12da346de9]`](https://github.com/aspnet/AspNetCore/commit/12da346de9) Updating missed projects to 4.4 CoreFx packages
* [`[45dcbac069]`](https://github.com/aspnet/AspNetCore/commit/45dcbac069) Update to CoreFx 4.4.0-*
* [`[bde6cc40bc]`](https://github.com/aspnet/AspNetCore/commit/bde6cc40bc) Fix compile failure
* [`[4c0413c804]`](https://github.com/aspnet/AspNetCore/commit/4c0413c804) Implement Stream Flush+FlushAsync fully
* [`[1492b41af0]`](https://github.com/aspnet/AspNetCore/commit/1492b41af0) Updating to 4.4 CoreFx packages
* [`[ce525150ab]`](https://github.com/aspnet/AspNetCore/commit/ce525150ab) Updating to 4.4 CoreFx packages
* [`[7657ea41a3]`](https://github.com/aspnet/AspNetCore/commit/7657ea41a3) Updating to 4.4 CoreFx packages
* [`[5b8f7c2b2b]`](https://github.com/aspnet/AspNetCore/commit/5b8f7c2b2b) Updating to 4.4 CoreFx packages
* [`[a42006d295]`](https://github.com/aspnet/AspNetCore/commit/a42006d295) Workarond type collision
* [`[2b50ec99df]`](https://github.com/aspnet/AspNetCore/commit/2b50ec99df) Updating to 4.4 CoreFx packages
* [`[af82488d60]`](https://github.com/aspnet/AspNetCore/commit/af82488d60) Updating to 4.4 CoreFx packages
* [`[bdf9d2a2e2]`](https://github.com/aspnet/AspNetCore/commit/bdf9d2a2e2) Updating to 4.4 CoreFx packages
* [`[2dbfb8839b]`](https://github.com/aspnet/AspNetCore/commit/2dbfb8839b) Include VaryByOrigin when there are multiple Origins configured (#84)
* [`[461caa85f4]`](https://github.com/aspnet/AspNetCore/commit/461caa85f4) Test RequestHeadersTimeout in KestrelServerLimitsTests.RequestHeadersTimeoutValid (#1268).
* [`[c5b7a3f710]`](https://github.com/aspnet/AspNetCore/commit/c5b7a3f710) Fixed a policheck violation
* [`[448b7eb50a]`](https://github.com/aspnet/AspNetCore/commit/448b7eb50a) Add dot to last item to make it more consistent
* [`[ecdc864e4f]`](https://github.com/aspnet/AspNetCore/commit/ecdc864e4f) Updated content root of musicstore.standalone to enable debugging in VS
* [`[b41c4078bd]`](https://github.com/aspnet/AspNetCore/commit/b41c4078bd) Abort connections not closed during shutdown (#1112).
* [`[c088a8871d]`](https://github.com/aspnet/AspNetCore/commit/c088a8871d) Getting rid of Advance (part 1)
* [`[b8e1fb8011]`](https://github.com/aspnet/AspNetCore/commit/b8e1fb8011) Add line-mapping support to RazorSourceDocument
* [`[b473101927]`](https://github.com/aspnet/AspNetCore/commit/b473101927) Fix line endings
* [`[88d99b06b3]`](https://github.com/aspnet/AspNetCore/commit/88d99b06b3) Skip Razor.Evolution tests on Linux and Mac.
* [`[23c0522db9]`](https://github.com/aspnet/AspNetCore/commit/23c0522db9) Added missing copyright and license headers
* [`[348fa77a93]`](https://github.com/aspnet/AspNetCore/commit/348fa77a93) doc: Add link to comunity device detector package
* [`[6ca8127bd6]`](https://github.com/aspnet/AspNetCore/commit/6ca8127bd6) Add foundation for the testing from packages, not project references
* [`[8b44e8e382]`](https://github.com/aspnet/AspNetCore/commit/8b44e8e382) Prevent closure allocations in OnHeartbeat (#1261)
* [`[15c1bfa717]`](https://github.com/aspnet/AspNetCore/commit/15c1bfa717) Branch for RC.3
* [`[c665eef66b]`](https://github.com/aspnet/AspNetCore/commit/c665eef66b) Update SocketsSample to use correct method names
* [`[dcb819f644]`](https://github.com/aspnet/AspNetCore/commit/dcb819f644) Fix port testing logic in tests by being explicit about which interface we're checking
* [`[4dd45f75d3]`](https://github.com/aspnet/AspNetCore/commit/4dd45f75d3) Enable Server GC (#731)
* [`[f722dcf98d]`](https://github.com/aspnet/AspNetCore/commit/f722dcf98d) Fix PrerenderResult in Webpack sample
* [`[953f370336]`](https://github.com/aspnet/AspNetCore/commit/953f370336) Wait for port to be freed before continuing
* [`[e2dd09c918]`](https://github.com/aspnet/AspNetCore/commit/e2dd09c918) [Fixes #881] Added TagHelper IR support
* [`[9323122c22]`](https://github.com/aspnet/AspNetCore/commit/9323122c22) Explicitly specify the version of the CLI
* [`[67cd5f6093]`](https://github.com/aspnet/AspNetCore/commit/67cd5f6093) In csproj projects, reference 1.1.0-preview4-final version of Razor tools
* [`[4fd19b4293]`](https://github.com/aspnet/AspNetCore/commit/4fd19b4293) Run tests against both csproj and project.json-style projects. Assumes relevant dotnet SDKs are installed locally.
* [`[4580412f73]`](https://github.com/aspnet/AspNetCore/commit/4580412f73) Don't leave behind an unused package.json.tmp file
* [`[a76b6e25d4]`](https://github.com/aspnet/AspNetCore/commit/a76b6e25d4) Add .csproj files for the templates. Some are set up for prerendering; others not.
* [`[2135d77189]`](https://github.com/aspnet/AspNetCore/commit/2135d77189) generator-aspnetcore-spa support for selecting between project.json and .csproj
* [`[62b676174e]`](https://github.com/aspnet/AspNetCore/commit/62b676174e) generator-aspnetcore-spa now displays its own version number on startup
* [`[6decb30681]`](https://github.com/aspnet/AspNetCore/commit/6decb30681) Make 'counter' components use <h1> headers to be consistent with other pages
* [`[33ed333f92]`](https://github.com/aspnet/AspNetCore/commit/33ed333f92) Specify SDK at repo root
* [`[495c95d227]`](https://github.com/aspnet/AspNetCore/commit/495c95d227) If generator fails because NPM is too old, exit with nonzero status code
* [`[c8b37f47d0]`](https://github.com/aspnet/AspNetCore/commit/c8b37f47d0) Pin functional tests to preview2 of dotnet-cli
* [`[0651cca94a]`](https://github.com/aspnet/AspNetCore/commit/0651cca94a) Updating to 4.4 CoreFx packages
* [`[4b9276bac2]`](https://github.com/aspnet/AspNetCore/commit/4b9276bac2) Updating to 4.4 CoreFx packages
* [`[42297c152b]`](https://github.com/aspnet/AspNetCore/commit/42297c152b) Updating to 4.4 CoreFx packages
* [`[a5717aa583]`](https://github.com/aspnet/AspNetCore/commit/a5717aa583) Updating to 4.4 CoreFx packages
* [`[ae24eea1a1]`](https://github.com/aspnet/AspNetCore/commit/ae24eea1a1) Updating to 4.4 CoreFx packages
* [`[7ab28ecdc6]`](https://github.com/aspnet/AspNetCore/commit/7ab28ecdc6) Updating to 4.4 CoreFx packages
* [`[13edf7a27b]`](https://github.com/aspnet/AspNetCore/commit/13edf7a27b) Updating to 4.4 CoreFx packages
* [`[6eb489007a]`](https://github.com/aspnet/AspNetCore/commit/6eb489007a) Updating to 4.4 CoreFx packages
* [`[8046dcc0f2]`](https://github.com/aspnet/AspNetCore/commit/8046dcc0f2) Updating to 4.4 CoreFx packages
* [`[f6eb86be78]`](https://github.com/aspnet/AspNetCore/commit/f6eb86be78) Updating to 4.4 CoreFx packages
* [`[7ea92f08fc]`](https://github.com/aspnet/AspNetCore/commit/7ea92f08fc) Updating to 4.4 CoreFx packages
* [`[991fbb08bc]`](https://github.com/aspnet/AspNetCore/commit/991fbb08bc) Updating to 4.4 CoreFx packages
* [`[c8c2dfaad9]`](https://github.com/aspnet/AspNetCore/commit/c8c2dfaad9) Updating to 4.4 CoreFx packages
* [`[4b77edfe7a]`](https://github.com/aspnet/AspNetCore/commit/4b77edfe7a) Updating to 4.4 CoreFx packages
* [`[344a2a5f9b]`](https://github.com/aspnet/AspNetCore/commit/344a2a5f9b) Updating to 4.4 CoreFx packages
* [`[b3afbc79d2]`](https://github.com/aspnet/AspNetCore/commit/b3afbc79d2) Updating to 4.4 CoreFx packages
* [`[5cb5178619]`](https://github.com/aspnet/AspNetCore/commit/5cb5178619) Updating to 4.4 CoreFx packages
* [`[61b2b0d4e7]`](https://github.com/aspnet/AspNetCore/commit/61b2b0d4e7) Add model for differentiating design time and runtime parsing.
* [`[8e8525512d]`](https://github.com/aspnet/AspNetCore/commit/8e8525512d) Performance optimizations
* [`[eb230e0408]`](https://github.com/aspnet/AspNetCore/commit/eb230e0408) Port existing CSharp code generation integration tests.
* [`[5d4c4e1ccf]`](https://github.com/aspnet/AspNetCore/commit/5d4c4e1ccf) Add Razor runtime code generation.
* [`[2db4985c21]`](https://github.com/aspnet/AspNetCore/commit/2db4985c21) Modify functions, section and inherits to use extensible directives.
* [`[503b4c97ed]`](https://github.com/aspnet/AspNetCore/commit/503b4c97ed) Resolve dependencies and packages from VS2017 solutions (#464)
* [`[e1d9aa2dd4]`](https://github.com/aspnet/AspNetCore/commit/e1d9aa2dd4) Early version of the .NET Client
* [`[cedbe76f52]`](https://github.com/aspnet/AspNetCore/commit/cedbe76f52) Abort request on client FIN (#1139).
* [`[51ecbd7949]`](https://github.com/aspnet/AspNetCore/commit/51ecbd7949) Add benchmarks for Frame writes.
* [`[eb98067e86]`](https://github.com/aspnet/AspNetCore/commit/eb98067e86) Update docs about using socket transport. Fixes #500
* [`[a25d1f4731]`](https://github.com/aspnet/AspNetCore/commit/a25d1f4731) Publish aspnet-webpack 1.0.26
* [`[4c3834361e]`](https://github.com/aspnet/AspNetCore/commit/4c3834361e) Stop WebpackDevMiddleware littering the 'dist' directories with blah.host-update.js.map files (they never need to be written to disk)
* [`[4cc61d79e2]`](https://github.com/aspnet/AspNetCore/commit/4cc61d79e2) Add json-loader to add webpack.config.js files. Helps with #507.
* [`[1c4682e50d]`](https://github.com/aspnet/AspNetCore/commit/1c4682e50d) Fix all the ConditionalProxyMiddleware errors that happened if you ctrl+c on a "dotnet run" (not "dotnet watch run") since beta-000002.
* [`[44c8920412]`](https://github.com/aspnet/AspNetCore/commit/44c8920412) Add RepositoryUrl and RepositoryType properties
* [`[d1f94460e2]`](https://github.com/aspnet/AspNetCore/commit/d1f94460e2) Back-port fix for implicit imports for dotnet-user-secrets (#243)
* [`[e01431f33c]`](https://github.com/aspnet/AspNetCore/commit/e01431f33c) Relocate improvements to HttpAbstractions
* [`[9c94a7764b]`](https://github.com/aspnet/AspNetCore/commit/9c94a7764b) Improve header parsing performance
* [`[46cf13b2fc]`](https://github.com/aspnet/AspNetCore/commit/46cf13b2fc) Hub connection tests
* [`[d3e625c985]`](https://github.com/aspnet/AspNetCore/commit/d3e625c985) End-to-end browser tests
* [`[d50a24145d]`](https://github.com/aspnet/AspNetCore/commit/d50a24145d) Add functionalities to HeaderUtilities
* [`[4da06e8acd]`](https://github.com/aspnet/AspNetCore/commit/4da06e8acd) Move Int64 parsing logic to HttpAbstractions
* [`[cfa9631ce8]`](https://github.com/aspnet/AspNetCore/commit/cfa9631ce8) Resolve path traversals in RazorViewEngine
* [`[f09fd291a7]`](https://github.com/aspnet/AspNetCore/commit/f09fd291a7) Make `HtmlContentIRNode` content newlines platform agnostic.
* [`[34ef31356f]`](https://github.com/aspnet/AspNetCore/commit/34ef31356f) Fix policheck violation.
* [`[2639fad8ab]`](https://github.com/aspnet/AspNetCore/commit/2639fad8ab) Transitioned SourceLocation => MappingLocation on IRNodes.
* [`[6545e11bf2]`](https://github.com/aspnet/AspNetCore/commit/6545e11bf2) Fix filename in sample
* [`[026f9ffb69]`](https://github.com/aspnet/AspNetCore/commit/026f9ffb69) Nodes that have children should use .Children
* [`[18bb31cee4]`](https://github.com/aspnet/AspNetCore/commit/18bb31cee4) Change IntegrationTestBase to properly locate baseline files in net451.
* [`[de1b763d96]`](https://github.com/aspnet/AspNetCore/commit/de1b763d96) Update IControllerModelConvention.cs
* [`[7c685c1354]`](https://github.com/aspnet/AspNetCore/commit/7c685c1354) Add AssemblyInfo.cs to Microsoft.AspNetCore.NodeServices.Sockets package
* [`[f277816556]`](https://github.com/aspnet/AspNetCore/commit/f277816556) Update packaging for tools
* [`[80e6430332]`](https://github.com/aspnet/AspNetCore/commit/80e6430332) Re-add dotnet-cli feeds in order to use preview4 packages
* [`[633969c7b4]`](https://github.com/aspnet/AspNetCore/commit/633969c7b4) Update Dockerfiles for .NET Core 1.1.0. Fixes #489
* [`[853c28e568]`](https://github.com/aspnet/AspNetCore/commit/853c28e568) Add integration testing
* [`[2b918b8fe2]`](https://github.com/aspnet/AspNetCore/commit/2b918b8fe2) Removing type name from hub method name (#63)
* [`[1dd1d49321]`](https://github.com/aspnet/AspNetCore/commit/1dd1d49321) Redirects with fragment (#5519)
* [`[2f54c12b82]`](https://github.com/aspnet/AspNetCore/commit/2f54c12b82) Add missing interface to IR phase
* [`[d0961fe28a]`](https://github.com/aspnet/AspNetCore/commit/d0961fe28a) Fix CI
* [`[5f3c1060ab]`](https://github.com/aspnet/AspNetCore/commit/5f3c1060ab) Clean up shutdown management (#59)
* [`[7178464ed2]`](https://github.com/aspnet/AspNetCore/commit/7178464ed2) Munch on less memory when handling property metadata - #5499 - switch `foreach` to `for` and use less Linq when accessing `modelMetadata.Properties` - change backing field for `ModelExplorer.Properties` from a list to an array
* [`[48546dbb28]`](https://github.com/aspnet/AspNetCore/commit/48546dbb28) Add more to `MvcCoreServiceCollectionExtensionsTest` - 2nd half of #5554 - follow-on to #5540 PR
* [`[f32d0f2505]`](https://github.com/aspnet/AspNetCore/commit/f32d0f2505) Update MvcCoreServiceCollectionExtensions.cs
* [`[6decb66d8c]`](https://github.com/aspnet/AspNetCore/commit/6decb66d8c) Upgrade Cli.Utils to preview4-004215
* [`[e53a87be9c]`](https://github.com/aspnet/AspNetCore/commit/e53a87be9c) Add MaxRequestBodySize limit (#478).
* [`[28e3c8331b]`](https://github.com/aspnet/AspNetCore/commit/28e3c8331b) Dispose Hubs from ActivatorUtilities
* [`[2190dc2096]`](https://github.com/aspnet/AspNetCore/commit/2190dc2096) Add RazorCSharpSourceDocument
* [`[9cefcdd450]`](https://github.com/aspnet/AspNetCore/commit/9cefcdd450) Add legacy dependencies of C# lowering
* [`[03549bb542]`](https://github.com/aspnet/AspNetCore/commit/03549bb542) Add end-to-end support for extensible directives
* [`[9c1c1b4023]`](https://github.com/aspnet/AspNetCore/commit/9c1c1b4023) Publish aspnet-prerendering 2.0.2
* [`[0a116ba2a1]`](https://github.com/aspnet/AspNetCore/commit/0a116ba2a1) Prerendering logic supplies PathBase (formatted as baseUrl) to boot logic
* [`[2b2465ad2e]`](https://github.com/aspnet/AspNetCore/commit/2b2465ad2e) Update prerendering docs to account for aspnet-prerendering 2.0.0 and the new createServerRenderer API. Fixes #479
* [`[dc130adc91]`](https://github.com/aspnet/AspNetCore/commit/dc130adc91) Update aspnet-prerendering to reference baseUrl in domain-task's main module, not domain-task/fetch. Goal is to avoid Webpack having to bundle isomorphic-fetch on server unless you're actually using it.
* [`[b8913d29dd]`](https://github.com/aspnet/AspNetCore/commit/b8913d29dd) Update domain-task to export baseUrl from 'main' instead of only 'fetch'. Goal is to avoid Webpack detecting dependency on isomorphic-fetch unless you're actually using it.
* [`[17da5242e0]`](https://github.com/aspnet/AspNetCore/commit/17da5242e0) Create console reporter API
* [`[4abb48e1aa]`](https://github.com/aspnet/AspNetCore/commit/4abb48e1aa) Added EventSource to Hosting
* [`[a96370ea35]`](https://github.com/aspnet/AspNetCore/commit/a96370ea35) Update project.json versions
* [`[8f8bf5af34]`](https://github.com/aspnet/AspNetCore/commit/8f8bf5af34) Seperate view and model for enum display
* [`[5e669d6e7a]`](https://github.com/aspnet/AspNetCore/commit/5e669d6e7a) Publish Yeoman generators 0.7.1
* [`[5d02728159]`](https://github.com/aspnet/AspNetCore/commit/5d02728159) Publish Yeoman generators version 0.7.0. From here on, the templates produce ASP.NET Core 1.1.0 projects.
* [`[78632617f8]`](https://github.com/aspnet/AspNetCore/commit/78632617f8) Publish aspnet-webpack 1.0.25
* [`[e2f8031bb8]`](https://github.com/aspnet/AspNetCore/commit/e2f8031bb8) For HMR, proxy all requests including /__webpack_hmr. Fixes #271.
* [`[2cffab14f6]`](https://github.com/aspnet/AspNetCore/commit/2cffab14f6) StringAsTempFile cleans up in a wider range of circumstances (not relying on finalizer running). Helps with #7 but still doesn't cover all cases.
* [`[9001c191c1]`](https://github.com/aspnet/AspNetCore/commit/9001c191c1) Make Angular and React templates reference SpaServices directly. The AngularServices/ReactServices packages might be used in the future, but don't presently contain any extra usable functionality.
* [`[832da2a451]`](https://github.com/aspnet/AspNetCore/commit/832da2a451) Split out 'socket' hosting model into a separate optional NuGet package, since most developers won't need it
* [`[ebf5a18344]`](https://github.com/aspnet/AspNetCore/commit/ebf5a18344) Eliminate the NodeHostingModel enum because it isn't extensible. Instead, use extension methods on NodeServicesOptions to configure a NodeInstanceFactory.
* [`[46018f9512]`](https://github.com/aspnet/AspNetCore/commit/46018f9512) Add IR phase
* [`[e6b34fdce3]`](https://github.com/aspnet/AspNetCore/commit/e6b34fdce3) Renaming RpcConnection to HubConnection
* [`[4158dfed8f]`](https://github.com/aspnet/AspNetCore/commit/4158dfed8f) add net451 support to signalr.redis
* [`[dbaa01830b]`](https://github.com/aspnet/AspNetCore/commit/dbaa01830b) Replace 'foreach' by 'for' in StringValues (faster)
* [`[2039a18971]`](https://github.com/aspnet/AspNetCore/commit/2039a18971) Introducing modules for the ts client
* [`[8214954d5b]`](https://github.com/aspnet/AspNetCore/commit/8214954d5b) Add support for clients to configure a policy with custom logic about whether an origin should be allowed and provide a default implementation of the functionality to allow wildcard subdomains
* [`[62c0680193]`](https://github.com/aspnet/AspNetCore/commit/62c0680193) Make 'fetchdata' components in templates compatible with latest TypeScript compiler
* [`[a8d3eed32c]`](https://github.com/aspnet/AspNetCore/commit/a8d3eed32c) Detect legacy aspnet-prerendering mode earlier to fix #470
* [`[5d14f11b1b]`](https://github.com/aspnet/AspNetCore/commit/5d14f11b1b) Update all the project templates to .NET Core 1.1.0
* [`[4cbbf58600]`](https://github.com/aspnet/AspNetCore/commit/4cbbf58600) Update core packages to version 1.1.0-*, upgrading .NET Core dependencies to match 1.1.0 release
* [`[3ff4447924]`](https://github.com/aspnet/AspNetCore/commit/3ff4447924) Add XML docs to core packages
* [`[3b91ad9b39]`](https://github.com/aspnet/AspNetCore/commit/3b91ad9b39) Make core package project.json files conform to org-wide conventions
* [`[bebf24952e]`](https://github.com/aspnet/AspNetCore/commit/bebf24952e) Add AssemblyInfo files to core packages
* [`[42594afd42]`](https://github.com/aspnet/AspNetCore/commit/42594afd42) Introducing IApplicationLifetimeEvents (#875)
* [`[f63006dc1a]`](https://github.com/aspnet/AspNetCore/commit/f63006dc1a) Pack with NuGet 3.5.0 RTM
* [`[53e5c3d56c]`](https://github.com/aspnet/AspNetCore/commit/53e5c3d56c) #1001 don't log stack traces for localhost bind failures.
* [`[02b84d7ae1]`](https://github.com/aspnet/AspNetCore/commit/02b84d7ae1) Make ListenerPrimaryTests more reliable
* [`[834301e50d]`](https://github.com/aspnet/AspNetCore/commit/834301e50d) Publish generator-aspnetcore-spa 0.6.1
* [`[03774253eb]`](https://github.com/aspnet/AspNetCore/commit/03774253eb) Fix AureliaSpa TypeScript compile error introduced by newer version of TypeScript
* [`[a3cba50e88]`](https://github.com/aspnet/AspNetCore/commit/a3cba50e88) Make ReactReduxSpa able to do prerendering without node_modules at runtime
* [`[9cfea61f1e]`](https://github.com/aspnet/AspNetCore/commit/9cfea61f1e) Make Angular2Spa able to do prerendering without node_modules at runtime
* [`[157b74a0cd]`](https://github.com/aspnet/AspNetCore/commit/157b74a0cd) Update Angular2Spa and ReactReduxSpa to use aspnet-prerendering 2.0.0
* [`[1b59fc6f80]`](https://github.com/aspnet/AspNetCore/commit/1b59fc6f80) DI enabled Microsoft.AspNetCore.Sockets (#47)
* [`[69a0a29057]`](https://github.com/aspnet/AspNetCore/commit/69a0a29057) Handle Webpack 2.1.0 beta 23 renaming 'loaders' to 'rules'. Fixes #460.
* [`[518378f499]`](https://github.com/aspnet/AspNetCore/commit/518378f499) Add extensible directive abstractions
* [`[52ee9afc31]`](https://github.com/aspnet/AspNetCore/commit/52ee9afc31) Adding PageActionDescriptorProvider
* [`[5b2a4aecb6]`](https://github.com/aspnet/AspNetCore/commit/5b2a4aecb6) Make Microsoft.AspNetCore.Mvc.TestCommon a regular project
* [`[172f0579d5]`](https://github.com/aspnet/AspNetCore/commit/172f0579d5) Tool produces a 0-byte binary when compilation fails
* [`[9ccc896b1d]`](https://github.com/aspnet/AspNetCore/commit/9ccc896b1d) #297 Standardize the test site layout, use the publish tool
* [`[35103e84a0]`](https://github.com/aspnet/AspNetCore/commit/35103e84a0) Indentation fixed
* [`[a3a583b910]`](https://github.com/aspnet/AspNetCore/commit/a3a583b910) Add a runtimes section to fix win7
* [`[cdcffd50da]`](https://github.com/aspnet/AspNetCore/commit/cdcffd50da) Added Debug logger to MvcSandbox
* [`[a68018842a]`](https://github.com/aspnet/AspNetCore/commit/a68018842a) Add Win7 runtimes to the functional test project
* [`[077bc8104e]`](https://github.com/aspnet/AspNetCore/commit/077bc8104e) Fix IIS Express deployer for Win7
* [`[638b4b5fc4]`](https://github.com/aspnet/AspNetCore/commit/638b4b5fc4) Removing checked in jasmine
* [`[e316898c9f]`](https://github.com/aspnet/AspNetCore/commit/e316898c9f) Added missing copyright header
* [`[e0f85971a3]`](https://github.com/aspnet/AspNetCore/commit/e0f85971a3) Add --version options to dotnet-watch and dotnet-sql-cache
* [`[47769c1626]`](https://github.com/aspnet/AspNetCore/commit/47769c1626) Fix visit chunk generator naming.
* [`[4a5d8f2960]`](https://github.com/aspnet/AspNetCore/commit/4a5d8f2960) #126 Test the bin deployed aspnetcore.dll
* [`[e57ded038b]`](https://github.com/aspnet/AspNetCore/commit/e57ded038b) #46 Test support for bin deployed aspnetcore.dll
* [`[c91c2a9030]`](https://github.com/aspnet/AspNetCore/commit/c91c2a9030) #292 Test with the bin deployed aspnetcore.dll
* [`[2bf5a966cd]`](https://github.com/aspnet/AspNetCore/commit/2bf5a966cd) Fast path and inline HttpVersion.set
* [`[6b59c25474]`](https://github.com/aspnet/AspNetCore/commit/6b59c25474) Clean up
* [`[b9db30367b]`](https://github.com/aspnet/AspNetCore/commit/b9db30367b) Adding E2E test project
* [`[cf7489e600]`](https://github.com/aspnet/AspNetCore/commit/cf7489e600) Port WhiteSpaceRewriter and ConditionalAttributeCollapser.
* [`[aa58ea6907]`](https://github.com/aspnet/AspNetCore/commit/aa58ea6907) Change IR implementations to not hold all information in children.
* [`[d8b626c843]`](https://github.com/aspnet/AspNetCore/commit/d8b626c843) Implement IR lowering phase
* [`[46136e91ab]`](https://github.com/aspnet/AspNetCore/commit/46136e91ab) Resolve mysterious runtime errors caused because Microsoft.Extensions.DependencyModel v1.0.1-beta-000933 does not exist on NuGet.org
* [`[712dff32bb]`](https://github.com/aspnet/AspNetCore/commit/712dff32bb) organize usings
* [`[fd4cb7394b]`](https://github.com/aspnet/AspNetCore/commit/fd4cb7394b) organize usings
* [`[b2d45c3dd0]`](https://github.com/aspnet/AspNetCore/commit/b2d45c3dd0) Make TestApplicationErrorLogger thread-safe
* [`[b7c9b24193]`](https://github.com/aspnet/AspNetCore/commit/b7c9b24193) Update the IIS Express deployer to use the new ANCM package layout.
* [`[7b190ccf0f]`](https://github.com/aspnet/AspNetCore/commit/7b190ccf0f) Changed allowed header to Cache-control to illustrate Access-Control-Allow-Headers and Access-Control-Request-Headers
* [`[34aa1c5722]`](https://github.com/aspnet/AspNetCore/commit/34aa1c5722) README fixed
* [`[9ec4d88fbe]`](https://github.com/aspnet/AspNetCore/commit/9ec4d88fbe) Improve Skip coverage
* [`[ba0b7cc553]`](https://github.com/aspnet/AspNetCore/commit/ba0b7cc553) Add 100% coverage Take tests
* [`[dc90dd1649]`](https://github.com/aspnet/AspNetCore/commit/dc90dd1649) Add GetArraySegment test
* [`[ef5ad3deea]`](https://github.com/aspnet/AspNetCore/commit/ef5ad3deea) defaullt(MemoryPoolIterator) test coverage
* [`[2011a27bde]`](https://github.com/aspnet/AspNetCore/commit/2011a27bde) Use ternary op rather than lazy and
* [`[8ce47fb8b6]`](https://github.com/aspnet/AspNetCore/commit/8ce47fb8b6) Move perf, share code
* [`[5041d6c291]`](https://github.com/aspnet/AspNetCore/commit/5041d6c291) wasLastBlock adjustments
* [`[4cdcca212e]`](https://github.com/aspnet/AspNetCore/commit/4cdcca212e) Don't inline slow paths
* [`[12e2f30577]`](https://github.com/aspnet/AspNetCore/commit/12e2f30577) MemoryPoolIterator byref structs
* [`[90c7be1fc0]`](https://github.com/aspnet/AspNetCore/commit/90c7be1fc0) Add Request Parsing benchmark
* [`[53f361160e]`](https://github.com/aspnet/AspNetCore/commit/53f361160e) MemoryPoolIterator fast paths
* [`[8bcbfb9971]`](https://github.com/aspnet/AspNetCore/commit/8bcbfb9971) Only LocateFirstFoundByte once
* [`[28a21fa7a9]`](https://github.com/aspnet/AspNetCore/commit/28a21fa7a9) Move vectors closer to use
* [`[00a63537cf]`](https://github.com/aspnet/AspNetCore/commit/00a63537cf) And=> xor, powerOfTwoToHighByte to const
* [`[97d4406614]`](https://github.com/aspnet/AspNetCore/commit/97d4406614) Use Vector<byte>.ctor workaround
* [`[972d978d11]`](https://github.com/aspnet/AspNetCore/commit/972d978d11) Swap for vector loop unroll detection
* [`[9eb01d1c57]`](https://github.com/aspnet/AspNetCore/commit/9eb01d1c57) Reduce Vector register pressure by not overlapping
* [`[4f7977d440]`](https://github.com/aspnet/AspNetCore/commit/4f7977d440) Use PowerOfTwoToHighByte for FindFirstEqualByte
* [`[40d4670463]`](https://github.com/aspnet/AspNetCore/commit/40d4670463) Abstract the console
* [`[6c8ef157b4]`](https://github.com/aspnet/AspNetCore/commit/6c8ef157b4) Add TagHelper binding abstractions.
* [`[26a1cf3cff]`](https://github.com/aspnet/AspNetCore/commit/26a1cf3cff) Port existing TagHelper infrastructure.
* [`[51fb0c993b]`](https://github.com/aspnet/AspNetCore/commit/51fb0c993b) Add indexability to the RazorSourceDocument.
* [`[e3a4fad951]`](https://github.com/aspnet/AspNetCore/commit/e3a4fad951) fix sln for templates
* [`[3a4936dbf7]`](https://github.com/aspnet/AspNetCore/commit/3a4936dbf7) Add '-loader' suffix to all Webpack loader references
* [`[a457be5386]`](https://github.com/aspnet/AspNetCore/commit/a457be5386) Pinning missed tools and dependencies
* [`[296b12abc3]`](https://github.com/aspnet/AspNetCore/commit/296b12abc3) Pinning missed tools and dependencies
* [`[3db35194c9]`](https://github.com/aspnet/AspNetCore/commit/3db35194c9) Pinning versions for 1.1.0 release
* [`[74c9194aee]`](https://github.com/aspnet/AspNetCore/commit/74c9194aee) Pinning versions for 1.1.0 release
* [`[4faf89030c]`](https://github.com/aspnet/AspNetCore/commit/4faf89030c) Pinning versions for 1.1.0 release
* [`[d6c6408457]`](https://github.com/aspnet/AspNetCore/commit/d6c6408457) In AureliaSpa, lock local copy of Webpack to 2.1.0-beta.25 (not any later 2.1.0 beta) due to fix #436
* [`[1a29ddb9de]`](https://github.com/aspnet/AspNetCore/commit/1a29ddb9de) Fix EF dependencies in chat sample
* [`[192134cad8]`](https://github.com/aspnet/AspNetCore/commit/192134cad8) Throw if packing fails
* [`[e931db804f]`](https://github.com/aspnet/AspNetCore/commit/e931db804f) :arrow_up: prerelease version
* [`[a0e07744c0]`](https://github.com/aspnet/AspNetCore/commit/a0e07744c0) Pin versions
* [`[48d957ae85]`](https://github.com/aspnet/AspNetCore/commit/48d957ae85) Updating to Microsoft.NETCore.App 1.0.3
* [`[3b4d8e2e3d]`](https://github.com/aspnet/AspNetCore/commit/3b4d8e2e3d) Fix downgrade warnings during restore
* [`[4e96bbdfe5]`](https://github.com/aspnet/AspNetCore/commit/4e96bbdfe5) Update nupkg layout to include both architectures together.
* [`[975dc212b7]`](https://github.com/aspnet/AspNetCore/commit/975dc212b7) Fix package versions
* [`[c5a5ba1fee]`](https://github.com/aspnet/AspNetCore/commit/c5a5ba1fee) Add support for updateable ActionDescriptorCollection
* [`[177fb2a6b1]`](https://github.com/aspnet/AspNetCore/commit/177fb2a6b1) Temporarily disable running tests on Microsoft.AspNetCore.RazorPages.Test
* [`[29cd24f66b]`](https://github.com/aspnet/AspNetCore/commit/29cd24f66b) Add Microsoft.AspNetCore.Mvc.RazorPages projects
* [`[edff55ca47]`](https://github.com/aspnet/AspNetCore/commit/edff55ca47) Adding AspNetCore-Feature-Work feed
* [`[98bb5d67fd]`](https://github.com/aspnet/AspNetCore/commit/98bb5d67fd) Design PR for CORS sample and logging
* [`[2a0e827f9b]`](https://github.com/aspnet/AspNetCore/commit/2a0e827f9b) Update dependency version and explicitly require files in nuspec
* [`[ac5a9b7b73]`](https://github.com/aspnet/AspNetCore/commit/ac5a9b7b73) Pin versions
* [`[e2c4e36d78]`](https://github.com/aspnet/AspNetCore/commit/e2c4e36d78) Ensure .targets files are included in dotnet-watch
* [`[2b77446326]`](https://github.com/aspnet/AspNetCore/commit/2b77446326) Update sln to reflect changed testing project.
* [`[1562865ca6]`](https://github.com/aspnet/AspNetCore/commit/1562865ca6) Add RazorProject - an abstraction for working with Razor files in a project
* [`[d42a4c84a1]`](https://github.com/aspnet/AspNetCore/commit/d42a4c84a1) Rename IR* -> RazorIR*
* [`[d40f6d3151]`](https://github.com/aspnet/AspNetCore/commit/d40f6d3151) Add abstractions for Razor IR
* [`[b341340d1f]`](https://github.com/aspnet/AspNetCore/commit/b341340d1f) Add skeleton of syntax phases
* [`[d06e5b6002]`](https://github.com/aspnet/AspNetCore/commit/d06e5b6002) Add legacy parser
* [`[6b9b75841f]`](https://github.com/aspnet/AspNetCore/commit/6b9b75841f) Add Razor Evolution Engine and primitives
* [`[43caef488c]`](https://github.com/aspnet/AspNetCore/commit/43caef488c) Use IsTeamCity to determine if we're running on the CI
* [`[3b5a0db512]`](https://github.com/aspnet/AspNetCore/commit/3b5a0db512) Push packages as part of invoking verify on the feed
* [`[06106dd392]`](https://github.com/aspnet/AspNetCore/commit/06106dd392) Publish feeds to aspnetcore-feature-work
* [`[17f3e3bbab]`](https://github.com/aspnet/AspNetCore/commit/17f3e3bbab) Initial project skeleton for Razor Evolution
* [`[aa158f5d25]`](https://github.com/aspnet/AspNetCore/commit/aa158f5d25) Modified Base64UrlTextEncoder to reduce string allocations.
* [`[ae48d75e72]`](https://github.com/aspnet/AspNetCore/commit/ae48d75e72) Pin versions of dotnet packages
* [`[35a1c4fae7]`](https://github.com/aspnet/AspNetCore/commit/35a1c4fae7) Add prefix to redis channel names
* [`[4aa65cf0bf]`](https://github.com/aspnet/AspNetCore/commit/4aa65cf0bf) Updated to new System.IO.Pipelines package instead of Channels
* [`[41f58191bf]`](https://github.com/aspnet/AspNetCore/commit/41f58191bf) Update sample to add a README.md file
* [`[f3ebe03a0b]`](https://github.com/aspnet/AspNetCore/commit/f3ebe03a0b) fix #32 by handling connection header correctly (#33)
* [`[4de03b6dff]`](https://github.com/aspnet/AspNetCore/commit/4de03b6dff) Added logging for preflight requests and origin headers
* [`[2431c5925c]`](https://github.com/aspnet/AspNetCore/commit/2431c5925c) integrate Channels-based WebSockets into SignalR (#28)
* [`[5e2b267d9f]`](https://github.com/aspnet/AspNetCore/commit/5e2b267d9f) Adding tsc note to readme
* [`[b865716841]`](https://github.com/aspnet/AspNetCore/commit/b865716841) Displaying actual date
* [`[81ddada76b]`](https://github.com/aspnet/AspNetCore/commit/81ddada76b) Moving Pipe formatter to a subfolder
* [`[f3dfb62af9]`](https://github.com/aspnet/AspNetCore/commit/f3dfb62af9) Adding protobuf formatter
* [`[7d67629245]`](https://github.com/aspnet/AspNetCore/commit/7d67629245) Adding pipe formatter + some clean up
* [`[b5cef59448]`](https://github.com/aspnet/AspNetCore/commit/b5cef59448) Fixing - infinite loop when a client disconnects - enum values serialization
* [`[08cd20f1a0]`](https://github.com/aspnet/AspNetCore/commit/08cd20f1a0) Fixing namespace
* [`[41c4211c6b]`](https://github.com/aspnet/AspNetCore/commit/41c4211c6b) Renaming folder
* [`[098347adde]`](https://github.com/aspnet/AspNetCore/commit/098347adde) Making UI functional
* [`[04fede0436]`](https://github.com/aspnet/AspNetCore/commit/04fede0436) Adding pluggable formatters
* [`[325c909dff]`](https://github.com/aspnet/AspNetCore/commit/325c909dff) Removing transport fallback in the client
* [`[768e5ee432]`](https://github.com/aspnet/AspNetCore/commit/768e5ee432) Fix the version of the tool in testapps
* [`[847e4e2697]`](https://github.com/aspnet/AspNetCore/commit/847e4e2697) Better filter clients connecting to Kestrel's dispatch pipes
* [`[d9140e97c9]`](https://github.com/aspnet/AspNetCore/commit/d9140e97c9) dotnet-razor-precompile does not work when the application targets netcoreapp1.1
* [`[ecc8a0088d]`](https://github.com/aspnet/AspNetCore/commit/ecc8a0088d) Add ListenerPrimaryTests
* [`[eee9520ffd]`](https://github.com/aspnet/AspNetCore/commit/eee9520ffd) Ensure clients connecting to Kestrel's dispatch pipe are listeners
* [`[f1d0fafaa4]`](https://github.com/aspnet/AspNetCore/commit/f1d0fafaa4) Better filter clients connecting to Kestrel's dispatch pipes
* [`[97bf8c3c09]`](https://github.com/aspnet/AspNetCore/commit/97bf8c3c09) Fix NuGetPackageVerifier issues
* [`[51d4e11e6f]`](https://github.com/aspnet/AspNetCore/commit/51d4e11e6f) Fix more versions
* [`[f8fbb15e14]`](https://github.com/aspnet/AspNetCore/commit/f8fbb15e14) IISIntegration#292 Test support for bin deployed aspnetcore.dll
* [`[cdd6c16dc6]`](https://github.com/aspnet/AspNetCore/commit/cdd6c16dc6) Preparing to publish new generator-aspnetcore-spa
* [`[de71fc340b]`](https://github.com/aspnet/AspNetCore/commit/de71fc340b) Switch SignalR-* -> SignalR
* [`[f2cbf9f414]`](https://github.com/aspnet/AspNetCore/commit/f2cbf9f414) Add macOS Sierra to list of runtimes in TestSites project
* [`[67129b2515]`](https://github.com/aspnet/AspNetCore/commit/67129b2515) Update dependency versions
* [`[5c8043752d]`](https://github.com/aspnet/AspNetCore/commit/5c8043752d) Temporarily skipping test
* [`[9bc02df82a]`](https://github.com/aspnet/AspNetCore/commit/9bc02df82a) Look for SignalR.sln
* [`[8500226272]`](https://github.com/aspnet/AspNetCore/commit/8500226272) Fix makefile.shade
* [`[1506a44cd5]`](https://github.com/aspnet/AspNetCore/commit/1506a44cd5) Fix downgrade warnings
* [`[35f4f22117]`](https://github.com/aspnet/AspNetCore/commit/35f4f22117) Fixing downgrade warnings
* [`[32cced78b8]`](https://github.com/aspnet/AspNetCore/commit/32cced78b8) Update dependency versions
* [`[364db831f5]`](https://github.com/aspnet/AspNetCore/commit/364db831f5) Fix downgrade warning
* [`[009609319e]`](https://github.com/aspnet/AspNetCore/commit/009609319e) Fixing dependency versions
* [`[4f15bd6c50]`](https://github.com/aspnet/AspNetCore/commit/4f15bd6c50) Produce correct package.json from generator-aspnetcore-spa
* [`[291aa44877]`](https://github.com/aspnet/AspNetCore/commit/291aa44877) Updating Microsoft.Extensions.Logging.AzureAppServices version
* [`[5deda80e5a]`](https://github.com/aspnet/AspNetCore/commit/5deda80e5a) Downgrade Microsoft.Extensions.DependencyModel to 1.1.0
* [`[ec89197ecb]`](https://github.com/aspnet/AspNetCore/commit/ec89197ecb) Add ListenerPrimaryTests
* [`[e780ad9516]`](https://github.com/aspnet/AspNetCore/commit/e780ad9516) Ensure clients connecting to Kestrel's dispatch pipe are listeners
* [`[ee1d0dab11]`](https://github.com/aspnet/AspNetCore/commit/ee1d0dab11) Fixing versions
* [`[828ed07cef]`](https://github.com/aspnet/AspNetCore/commit/828ed07cef) In generator-aspnetcore-spa, offer user the choice of whether to include tests
* [`[5043f9b17a]`](https://github.com/aspnet/AspNetCore/commit/5043f9b17a) Make ConnectionFilterTests more reliable
* [`[757952d4d3]`](https://github.com/aspnet/AspNetCore/commit/757952d4d3) Always flush headers on first response write (#1202).
* [`[3c7e7d1f6c]`](https://github.com/aspnet/AspNetCore/commit/3c7e7d1f6c) Make ConnectionFilterTests more reliable
* [`[c0e75dcbf8]`](https://github.com/aspnet/AspNetCore/commit/c0e75dcbf8) Always flush headers on first response write (#1202).
* [`[a734a31745]`](https://github.com/aspnet/AspNetCore/commit/a734a31745) Add Karma/Jasmine/Chai test starting point to Angular2Spa
* [`[cb0aa63a43]`](https://github.com/aspnet/AspNetCore/commit/cb0aa63a43) UserName and minor fixups for ChatSample
* [`[7c05d62a6e]`](https://github.com/aspnet/AspNetCore/commit/7c05d62a6e) Use request PathBase value to set cookie path only if it has a non-null & non-empty value
* [`[2fcb187d7d]`](https://github.com/aspnet/AspNetCore/commit/2fcb187d7d) Use request PathBase value to set cookie path only if it has a non-null & non-empty value
* [`[48b869f026]`](https://github.com/aspnet/AspNetCore/commit/48b869f026) Don't hardcoded localhost for redis - It breaks the *nix clients
* [`[84cf678905]`](https://github.com/aspnet/AspNetCore/commit/84cf678905) Update System.Net.Http
* [`[5788765983]`](https://github.com/aspnet/AspNetCore/commit/5788765983) Fixed after the ancm nuget package change
* [`[812bffe6d0]`](https://github.com/aspnet/AspNetCore/commit/812bffe6d0) Null check for deserialize
* [`[40ccbb3940]`](https://github.com/aspnet/AspNetCore/commit/40ccbb3940) Fix the non-standard nuget package
* [`[576c0e6a65]`](https://github.com/aspnet/AspNetCore/commit/576c0e6a65) Throw an exception if configurationType to CreateConfigureDelegate is abstract/has no parameterless ctor
* [`[07a2f1de06]`](https://github.com/aspnet/AspNetCore/commit/07a2f1de06) Fixes CookieTempDataProvider to set the secure attribute of a cookie only if a request is secure
* [`[a3c06b00cc]`](https://github.com/aspnet/AspNetCore/commit/a3c06b00cc) Fixes CookieTempDataProvider to handle empty request PathBase while setting cookie options
* [`[a5c0e505c1]`](https://github.com/aspnet/AspNetCore/commit/a5c0e505c1) Fix cookie from being set to empty pathbase Found with issue: https://github.com/aspnet/Mvc/issues/5512
* [`[82c231efca]`](https://github.com/aspnet/AspNetCore/commit/82c231efca) Created public API baselines
* [`[b9e58a4fe6]`](https://github.com/aspnet/AspNetCore/commit/b9e58a4fe6) Created public API baselines
* [`[610c6ddd83]`](https://github.com/aspnet/AspNetCore/commit/610c6ddd83) Updating partner package versions
* [`[8b97327950]`](https://github.com/aspnet/AspNetCore/commit/8b97327950) Updating partner package versions
* [`[7d6b247780]`](https://github.com/aspnet/AspNetCore/commit/7d6b247780) Move argument conversion for json into JsonNetInvocationAdapter
* [`[fe2453b93a]`](https://github.com/aspnet/AspNetCore/commit/fe2453b93a) Escaping support for JSON pointers
* [`[7e3e38572f]`](https://github.com/aspnet/AspNetCore/commit/7e3e38572f) Created public API baselines
* [`[8ff910fdbe]`](https://github.com/aspnet/AspNetCore/commit/8ff910fdbe) Created public API baselines
* [`[d00f1f93b2]`](https://github.com/aspnet/AspNetCore/commit/d00f1f93b2) Added support for net451 and netstandard1.3 - Replaced Task.CompletedTask with TaskCache.CompletedTask - Updated tests and src
* [`[239999e4c9]`](https://github.com/aspnet/AspNetCore/commit/239999e4c9) Make things actually work (#10)
* [`[d870f75eec]`](https://github.com/aspnet/AspNetCore/commit/d870f75eec) Fixed some minor issues
* [`[ff8b2260fb]`](https://github.com/aspnet/AspNetCore/commit/ff8b2260fb) Update CSharpCodeParser.cs (#860)
* [`[b3dbb6e0f1]`](https://github.com/aspnet/AspNetCore/commit/b3dbb6e0f1) Yeoman generator, when running on Windows, ensures you have NPM 3+. Fixes #82.
* [`[dfa9c927b7]`](https://github.com/aspnet/AspNetCore/commit/dfa9c927b7) clean up project.jsons and NuGet.config (#9)
* [`[11c45321aa]`](https://github.com/aspnet/AspNetCore/commit/11c45321aa) In Angular2Spa, use angular2-template loader as a step towards AoT compilation. Implements #356
* [`[24d5dfb552]`](https://github.com/aspnet/AspNetCore/commit/24d5dfb552) Dynamic assembly checks to prevent NotSupprotedExceptions from System.Reflection.Emit Fixes #5487
* [`[415055ebab]`](https://github.com/aspnet/AspNetCore/commit/415055ebab) #1007 Additional id_token validation
* [`[fadcb586c6]`](https://github.com/aspnet/AspNetCore/commit/fadcb586c6) Support specifying environment variables for the Webpack dev middleware Node instance. Resolves #311.
* [`[2c97326721]`](https://github.com/aspnet/AspNetCore/commit/2c97326721) In domain-task, avoid use of "new Function" because of CSP. Fixes #345
* [`[d81cce8a25]`](https://github.com/aspnet/AspNetCore/commit/d81cce8a25) Make --framework an optional parameters to the tool Fixes #26
* [`[bfdd939e26]`](https://github.com/aspnet/AspNetCore/commit/bfdd939e26) Rename project to Razor ViewCompilation
* [`[d299cc9186]`](https://github.com/aspnet/AspNetCore/commit/d299cc9186) apply license headers
* [`[9caa688a30]`](https://github.com/aspnet/AspNetCore/commit/9caa688a30) Modified exception message for duplicate keys exception in CandidateResolver
* [`[54dfea2633]`](https://github.com/aspnet/AspNetCore/commit/54dfea2633) Created public API baselines
* [`[304000095a]`](https://github.com/aspnet/AspNetCore/commit/304000095a) Added logging for precompiled views in RazorViewEngine
* [`[1b4dd93fa6]`](https://github.com/aspnet/AspNetCore/commit/1b4dd93fa6) Update React MusicStore sample to use current technologies (TypeScript 2, .NET Core 1.0.1, etc.). Fixes #417
* [`[eb94340ea9]`](https://github.com/aspnet/AspNetCore/commit/eb94340ea9) pin publish-iis version
* [`[363ddf73a6]`](https://github.com/aspnet/AspNetCore/commit/363ddf73a6) Pin versions
* [`[1dc4b28bbe]`](https://github.com/aspnet/AspNetCore/commit/1dc4b28bbe) Add AcceptedAtActionResult tests
* [`[349980c89e]`](https://github.com/aspnet/AspNetCore/commit/349980c89e) Add DOTNET_USE_POLLING_FILE_WATCHER to help output
* [`[c84bdb35d3]`](https://github.com/aspnet/AspNetCore/commit/c84bdb35d3) dotnet-watch: add extended help to clarify usage (#218)
* [`[eed1784880]`](https://github.com/aspnet/AspNetCore/commit/eed1784880) Added tags to project.json
* [`[7c15646303]`](https://github.com/aspnet/AspNetCore/commit/7c15646303) Updates for 1.0.2
* [`[217223e636]`](https://github.com/aspnet/AspNetCore/commit/217223e636) Generics overload - Changed IHubConnectionContext and friends to be generic. - Hub by default is Hub<IClientProxy>. We'll enable dynamic and arbitrary TClients in another commit.
* [`[34f419f446]`](https://github.com/aspnet/AspNetCore/commit/34f419f446) Added tags to project.json
* [`[bfe50ddd8c]`](https://github.com/aspnet/AspNetCore/commit/bfe50ddd8c) Created public API baselines
* [`[194059a198]`](https://github.com/aspnet/AspNetCore/commit/194059a198) Implement Begin/End Read/Write methods in LoggingStream
* [`[0d559468f1]`](https://github.com/aspnet/AspNetCore/commit/0d559468f1) Make connection reset logs less scary
* [`[a83bbcfba7]`](https://github.com/aspnet/AspNetCore/commit/a83bbcfba7) Prevent block leak when socket is closed before connection filter is applied.
* [`[a1c598733b]`](https://github.com/aspnet/AspNetCore/commit/a1c598733b) Reject POST and PUT requests with no Content-Length or Transfer-Encoding (#1130).
* [`[5b65117b64]`](https://github.com/aspnet/AspNetCore/commit/5b65117b64) Add functional regression test for 'Connection: keep-alive, upgrade' request header.
* [`[ed98894c93]`](https://github.com/aspnet/AspNetCore/commit/ed98894c93) Created public API baselines
* [`[373097e0dd]`](https://github.com/aspnet/AspNetCore/commit/373097e0dd) Created public API baselines
* [`[db677639c3]`](https://github.com/aspnet/AspNetCore/commit/db677639c3) Created public API baselines
* [`[6cbbb73ca7]`](https://github.com/aspnet/AspNetCore/commit/6cbbb73ca7) Protect against NullReferenceException in Frame.StopStreams()
* [`[b3aca0413c]`](https://github.com/aspnet/AspNetCore/commit/b3aca0413c) Avoid zero-length writes to flush connection filter stream
* [`[80cdeceb0b]`](https://github.com/aspnet/AspNetCore/commit/80cdeceb0b) Created public API baselines
* [`[911da31476]`](https://github.com/aspnet/AspNetCore/commit/911da31476) Created public API baselines
* [`[8dc7ac8623]`](https://github.com/aspnet/AspNetCore/commit/8dc7ac8623) Add DOTNET_USE_POLLING_FILE_WATCHER to help output
* [`[4b66b87d74]`](https://github.com/aspnet/AspNetCore/commit/4b66b87d74) Created public API baselines
* [`[7c6583986c]`](https://github.com/aspnet/AspNetCore/commit/7c6583986c) Created public API baselines
* [`[9b95754b0f]`](https://github.com/aspnet/AspNetCore/commit/9b95754b0f) Created public API baselines
* [`[0c815da523]`](https://github.com/aspnet/AspNetCore/commit/0c815da523) #903 Ensure redirect uris can be generated
* [`[944e99121c]`](https://github.com/aspnet/AspNetCore/commit/944e99121c) Add nuget feed to restore CLI dependencies
* [`[968ea59ce4]`](https://github.com/aspnet/AspNetCore/commit/968ea59ce4) Created public API baselines
* [`[5de082e687]`](https://github.com/aspnet/AspNetCore/commit/5de082e687) Upgrade Microsoft.DotNet.Cli.Utils from preview2 to preview3
* [`[0cee00aae1]`](https://github.com/aspnet/AspNetCore/commit/0cee00aae1) [Fixes #5352] When replacing Controller.Dispose with an explicit implementation the base Dispose is an action
* [`[ed41672381]`](https://github.com/aspnet/AspNetCore/commit/ed41672381) Implemented better Redis scaleout - Less subscriptions and connections to RedisHubLifetimeManager
* [`[42d8ccbc47]`](https://github.com/aspnet/AspNetCore/commit/42d8ccbc47) dotnet-watch: add extended help to clarify usage (#218)
* [`[7985121bab]`](https://github.com/aspnet/AspNetCore/commit/7985121bab) [Fixes #5207] Support IsIndexer for ViewComponent tag helpers
* [`[63d7d35bd2]`](https://github.com/aspnet/AspNetCore/commit/63d7d35bd2) Filter out generic invoke methods in ViewComponents
* [`[60bc57fb8d]`](https://github.com/aspnet/AspNetCore/commit/60bc57fb8d) Fix redis subscriptions and missing awaits
* [`[047def1aaf]`](https://github.com/aspnet/AspNetCore/commit/047def1aaf) Added/Updated JsonPatchExtensionsTest
* [`[81931e75d4]`](https://github.com/aspnet/AspNetCore/commit/81931e75d4) Handle exceptions for invalid operation types Related to https://github.com/aspnet/Mvc/issues/5463
* [`[0dcfa2a3fd]`](https://github.com/aspnet/AspNetCore/commit/0dcfa2a3fd) Updating to Libuv 1.9.1
* [`[90f92fabe3]`](https://github.com/aspnet/AspNetCore/commit/90f92fabe3) Upgrade Microsoft.NET.Sdk in tests
* [`[f51fcadeb1]`](https://github.com/aspnet/AspNetCore/commit/f51fcadeb1) Dispose the ConnectionManager on application shutdown
* [`[8d03c014fb]`](https://github.com/aspnet/AspNetCore/commit/8d03c014fb) Fixing invocation results for tasks whose result is `VoidTaskResult`
* [`[5f23231d9b]`](https://github.com/aspnet/AspNetCore/commit/5f23231d9b) Make ConnectionMetadata object,object dictionary
* [`[7db1eb8f25]`](https://github.com/aspnet/AspNetCore/commit/7db1eb8f25) Add Async suffix to everything
* [`[a175609bb1]`](https://github.com/aspnet/AspNetCore/commit/a175609bb1) Start transport before endpoint
* [`[8dd61250f4]`](https://github.com/aspnet/AspNetCore/commit/8dd61250f4) Fix the projects - Fixed dependencies - Fixed NS dependency
* [`[019bb460ec]`](https://github.com/aspnet/AspNetCore/commit/019bb460ec) Clean up and TS client
* [`[5434d437e9]`](https://github.com/aspnet/AspNetCore/commit/5434d437e9) Added ChatSample
* [`[3065c8db93]`](https://github.com/aspnet/AspNetCore/commit/3065c8db93) minor fixes
* [`[2bbca5e7fe]`](https://github.com/aspnet/AspNetCore/commit/2bbca5e7fe) Adding error handling Fixing SSE transport on the server
* [`[61c527f23c]`](https://github.com/aspnet/AspNetCore/commit/61c527f23c) Fixing LongPolling transport
* [`[ce17f0d19a]`](https://github.com/aspnet/AspNetCore/commit/ce17f0d19a) Adding transport selection Fixing serverSentEvents transport Updating the client 'app'
* [`[466c8d9db9]`](https://github.com/aspnet/AspNetCore/commit/466c8d9db9) Adding ServerSentEvents
* [`[181053e876]`](https://github.com/aspnet/AspNetCore/commit/181053e876) Adding longpolling
* [`[6859d33536]`](https://github.com/aspnet/AspNetCore/commit/6859d33536) ts-client WebSockets + JSON
* [`[5e3be6e212]`](https://github.com/aspnet/AspNetCore/commit/5e3be6e212) Awaiting tasks returned from hubs and getting the actual result
* [`[01b237dda9]`](https://github.com/aspnet/AspNetCore/commit/01b237dda9) Antiforgery goes at the end of filters
* [`[f02f55c33d]`](https://github.com/aspnet/AspNetCore/commit/f02f55c33d) Antiforgery goes at the end of filters
* [`[3fc090e2fe]`](https://github.com/aspnet/AspNetCore/commit/3fc090e2fe) [Fixes #105] Disable caching when response uses antiforgery
* [`[f58a373704]`](https://github.com/aspnet/AspNetCore/commit/f58a373704) fix #106 by removing ReplaceFeature
* [`[c28ad48e98]`](https://github.com/aspnet/AspNetCore/commit/c28ad48e98) [Fixes #5216] Make generic parameters work with ViewComponent tag helpers
* [`[217dab2016]`](https://github.com/aspnet/AspNetCore/commit/217dab2016) Fix packaging on CI
* [`[fcd6764cd1]`](https://github.com/aspnet/AspNetCore/commit/fcd6764cd1) Add <clear /> to nuget.config
* [`[3b0947b4af]`](https://github.com/aspnet/AspNetCore/commit/3b0947b4af) Add workaround for bug in Configuration 1.0.1
* [`[54031fb399]`](https://github.com/aspnet/AspNetCore/commit/54031fb399) Downgrade to 1.0.1
* [`[7bf6f0d2ab]`](https://github.com/aspnet/AspNetCore/commit/7bf6f0d2ab) Updating to version 1.0.2.
* [`[b2108a6d65]`](https://github.com/aspnet/AspNetCore/commit/b2108a6d65) major updates to WebSockets implementation
* [`[08cb67b7e4]`](https://github.com/aspnet/AspNetCore/commit/08cb67b7e4) [Fixes #104] Expose cookie options via Antiforgery options
* [`[b4027529a7]`](https://github.com/aspnet/AspNetCore/commit/b4027529a7) Bundle deps.json files in tools packages
* [`[ea701f2cd6]`](https://github.com/aspnet/AspNetCore/commit/ea701f2cd6) Added UserClaimsPrincipal to ViewComponent
* [`[975e22ad06]`](https://github.com/aspnet/AspNetCore/commit/975e22ad06) Drop tools back to Microsoft.NETCore.App 1.0.1
* [`[2bddba8f90]`](https://github.com/aspnet/AspNetCore/commit/2bddba8f90) Handle SIGTERMs for graceful shutdown (#876)
* [`[0f863be588]`](https://github.com/aspnet/AspNetCore/commit/0f863be588) Renamed JsonInvocationAdapter to JsonNetInvocationAdapter
* [`[9e7513a7bd]`](https://github.com/aspnet/AspNetCore/commit/9e7513a7bd) Added UseSignalR
* [`[f41bcb9b2d]`](https://github.com/aspnet/AspNetCore/commit/f41bcb9b2d) Subscribe in parallel
* [`[40039afd4f]`](https://github.com/aspnet/AspNetCore/commit/40039afd4f) Make a SignalR project and SignalR.Redis project - Moved RPC into SignalR for now since we don't have a middle layer yet. - Fixed up name spaces
* [`[915ebbda6b]`](https://github.com/aspnet/AspNetCore/commit/915ebbda6b) Get rid of pub sub abstraction and add redis impl
* [`[53858495dc]`](https://github.com/aspnet/AspNetCore/commit/53858495dc) Hubs are more fleshed out (#11)
* [`[9744f94b39]`](https://github.com/aspnet/AspNetCore/commit/9744f94b39) Update README for dotnet-watch to specify which version to install (#210)
* [`[32710bbfbe]`](https://github.com/aspnet/AspNetCore/commit/32710bbfbe) [#5430] CookieTempDataProvider chunking broken
* [`[4dcde8a329]`](https://github.com/aspnet/AspNetCore/commit/4dcde8a329) Added Base64UrlTextEncoder utility from Security repo
* [`[2adb6ff955]`](https://github.com/aspnet/AspNetCore/commit/2adb6ff955) Interlocked.Read -> Volatile.Read
* [`[5d5b282dbd]`](https://github.com/aspnet/AspNetCore/commit/5d5b282dbd) Moved CaseSensitiveTagHelperAttributeComparer to Razor.TagHelpers.Testing.Sources
* [`[77ed9f22fc]`](https://github.com/aspnet/AspNetCore/commit/77ed9f22fc) Moved location of and modified CaseSensitiveTagHelperAttributeComparer
* [`[e55e3b6f5a]`](https://github.com/aspnet/AspNetCore/commit/e55e3b6f5a) Updated Authentication's Base64UrlTextEncoder to use WebUtilities's Base64UrlTextEncoder logic
* [`[500201bdf7]`](https://github.com/aspnet/AspNetCore/commit/500201bdf7) Made ChunkingCookieManager's default chunk size public
* [`[998a47d265]`](https://github.com/aspnet/AspNetCore/commit/998a47d265) [Fixes #4960] Action results returned from controller actions rendered as json instead of executed
* [`[a0e164f379]`](https://github.com/aspnet/AspNetCore/commit/a0e164f379) dotnet-user-secrets: add support for json output and piping json input
* [`[68839d76e3]`](https://github.com/aspnet/AspNetCore/commit/68839d76e3) allow 4.2.4 to have non-strict behavior (#128)
* [`[29408956f9]`](https://github.com/aspnet/AspNetCore/commit/29408956f9) Handle tokens in Transfer-Encoding header (#1181).
* [`[2d1c56ce5c]`](https://github.com/aspnet/AspNetCore/commit/2d1c56ce5c) #884 Honor OIDC's and Jwt's OnAuthenticationFailed HandleResponse()
* [`[4569d6d6d5]`](https://github.com/aspnet/AspNetCore/commit/4569d6d6d5) fix issue #26 AspNetCoreModule needs to abort failed responses (#34)
* [`[dd29d562b8]`](https://github.com/aspnet/AspNetCore/commit/dd29d562b8) Adding functional test to verify error page middleware includes raw compilation content.
* [`[7ee8a7b15e]`](https://github.com/aspnet/AspNetCore/commit/7ee8a7b15e) Update aspnet-webpack peerDependency to allow Webpack 2.1.0beta+ as well as Webpack 1.x
* [`[077f91847a]`](https://github.com/aspnet/AspNetCore/commit/077f91847a) Fix AngularServices NPM package dependency restoration following third-party package changes
* [`[7ee3346a72]`](https://github.com/aspnet/AspNetCore/commit/7ee3346a72) Fix Angular 2 MusicStore sample so packages can be restored on NPM 2.x (started failing because peerDependencies ceased to be valid following third-party package updates)
* [`[522e30ae19]`](https://github.com/aspnet/AspNetCore/commit/522e30ae19) Re-Add NuGetPackageVerifier
* [`[f9145a43f6]`](https://github.com/aspnet/AspNetCore/commit/f9145a43f6) In Angular2Spa server-side rendering, only render the <app> element, not an entire <html> doc
* [`[da51cd588b]`](https://github.com/aspnet/AspNetCore/commit/da51cd588b) In WebpackDevMiddleware, when copying files, create any needed subdirectories. Fixes #408.
* [`[8d896613bf]`](https://github.com/aspnet/AspNetCore/commit/8d896613bf) WindowsIdentity instead of principal
* [`[75ab32926b]`](https://github.com/aspnet/AspNetCore/commit/75ab32926b) Target netcoreapp and reference NETCore.App
* [`[d864418083]`](https://github.com/aspnet/AspNetCore/commit/d864418083) Use WindowsPrincipal everywhere
* [`[5e97c63467]`](https://github.com/aspnet/AspNetCore/commit/5e97c63467) Throw PlatformNotSupportedException on big-endian platforms
* [`[d475d41f71]`](https://github.com/aspnet/AspNetCore/commit/d475d41f71) Fix boundary cases in MemoryPoolIterator.(Try)PeekLong()
* [`[f70313c17a]`](https://github.com/aspnet/AspNetCore/commit/f70313c17a) Use WindowsIdentity instead of environment variables to verify NTLM auth scenarios
* [`[50e5827414]`](https://github.com/aspnet/AspNetCore/commit/50e5827414) Add HubCallerContext to Hub - Flow the connection id and user of the caller to the Hub
* [`[caad670cde]`](https://github.com/aspnet/AspNetCore/commit/caad670cde) Restore works again
* [`[6259b7b938]`](https://github.com/aspnet/AspNetCore/commit/6259b7b938) In generator-aspnetcore-spa, use 'yarn' (if available) instead of 'npm' to restore dependencies because it's > 10x faster
* [`[dfcaae6fda]`](https://github.com/aspnet/AspNetCore/commit/dfcaae6fda) Include AureliaSpa in generator-aspnetcore-spa
* [`[bd86026bb9]`](https://github.com/aspnet/AspNetCore/commit/bd86026bb9) Change AureliaSpa to use external source maps for compatibility with VS/VSCode debugging
* [`[996216c751]`](https://github.com/aspnet/AspNetCore/commit/996216c751) Tell aurelia-webpack-plugin to filter the set of dependencies it auto-imports. Note that this will have no effect until the next version of aurelia-webpack-plugin is published to NPM.
* [`[6bceb234d8]`](https://github.com/aspnet/AspNetCore/commit/6bceb234d8) In AureliaSpa, use whatwg-fetch to provide type info
* [`[acfb253a40]`](https://github.com/aspnet/AspNetCore/commit/acfb253a40) Change AureliaSpa to use vendor bundle like the other templates
* [`[3087352ea1]`](https://github.com/aspnet/AspNetCore/commit/3087352ea1) Simplify AureliaSpa's webpack.config.js
* [`[e60ea04f86]`](https://github.com/aspnet/AspNetCore/commit/e60ea04f86) Add AureliaSpa template (#398)
* [`[867e60d7fd]`](https://github.com/aspnet/AspNetCore/commit/867e60d7fd) Take dependency on newer webpack-dev-middleware because it fixes ambiguities in path handling
* [`[18de340981]`](https://github.com/aspnet/AspNetCore/commit/18de340981) fix disposal of Deployers during autobahn suites
* [`[1ffad5ca38]`](https://github.com/aspnet/AspNetCore/commit/1ffad5ca38) Handle multiple tokens in Connection header (#1170).
* [`[0eea3c2651]`](https://github.com/aspnet/AspNetCore/commit/0eea3c2651) Log messages added to BodyModelBinder for input formatters (#5451)
* [`[ca2a471691]`](https://github.com/aspnet/AspNetCore/commit/ca2a471691) Fixing NRE when a client closes connection
* [`[fd10deba6c]`](https://github.com/aspnet/AspNetCore/commit/fd10deba6c) Removing formatters
* [`[a854b13754]`](https://github.com/aspnet/AspNetCore/commit/a854b13754) Handling custom protobuf types
* [`[e1869d29a4]`](https://github.com/aspnet/AspNetCore/commit/e1869d29a4) fixing single client invocation
* [`[5d41b218f0]`](https://github.com/aspnet/AspNetCore/commit/5d41b218f0) Fixing line protocol
* [`[a8c831bad6]`](https://github.com/aspnet/AspNetCore/commit/a8c831bad6) Very hacky protobuff support
* [`[ae727d64a9]`](https://github.com/aspnet/AspNetCore/commit/ae727d64a9) Add download link
* [`[8d45fcd34e]`](https://github.com/aspnet/AspNetCore/commit/8d45fcd34e) Use ConditionalFact to not run tests on xplat
* [`[93ace1b84b]`](https://github.com/aspnet/AspNetCore/commit/93ace1b84b) Add Contributing information
* [`[ef19455912]`](https://github.com/aspnet/AspNetCore/commit/ef19455912) sync up the code with IIS OOB branch (#21)
* [`[398222d6e6]`](https://github.com/aspnet/AspNetCore/commit/398222d6e6) Show full generated output option for Razor compilation errors
* [`[3d2710a6c4]`](https://github.com/aspnet/AspNetCore/commit/3d2710a6c4) Changed MiddlewareFilter accessibility to internal (#5455)
* [`[e893f0c6d7]`](https://github.com/aspnet/AspNetCore/commit/e893f0c6d7) Fixing after rebase
* [`[fb387ed03d]`](https://github.com/aspnet/AspNetCore/commit/fb387ed03d) Decoupling formatters from endpoints Moving formatters out from Sockets
* [`[8b905907fe]`](https://github.com/aspnet/AspNetCore/commit/8b905907fe) Typed formatters
* [`[f64c986b5d]`](https://github.com/aspnet/AspNetCore/commit/f64c986b5d) Adding support to non-Json hub invocation
* [`[3d1caa474e]`](https://github.com/aspnet/AspNetCore/commit/3d1caa474e) Adding a functional test for desktop only project
* [`[ccfbec657f]`](https://github.com/aspnet/AspNetCore/commit/ccfbec657f) Microsoft.AspNetCore.Mvc.Razor.Precompilation.Tools does not need to target desktop
* [`[f96ba3a254]`](https://github.com/aspnet/AspNetCore/commit/f96ba3a254) Add extension method for AcceptAsync with timeout
* [`[70fce81d7d]`](https://github.com/aspnet/AspNetCore/commit/70fce81d7d) Adding additional test coverage
* [`[1ac731519a]`](https://github.com/aspnet/AspNetCore/commit/1ac731519a) Do not call `Encoding.GetEncoding()` with a string from the request - #5351 - fix affects only `TextInputFormatter`  - `TextOutputFormatter` already does the Right Thing:tm: with `Accept-Charset` headers  - `ResponseContentTypeHelper` uses `Encoding.GetEncoding()` but is not passed request data
* [`[60c59b576e]`](https://github.com/aspnet/AspNetCore/commit/60c59b576e) Replace HashSet with a Hybrid HashSet/List to improve performance on less nested models
* [`[d64b4c7acb]`](https://github.com/aspnet/AspNetCore/commit/d64b4c7acb) Control-flow simplification in Frame.CreateResponseHeader() (#1168).
* [`[843bae083e]`](https://github.com/aspnet/AspNetCore/commit/843bae083e) Use AspNetCore meta package
* [`[8fcbddc23b]`](https://github.com/aspnet/AspNetCore/commit/8fcbddc23b) Update ClaimsHelper.AddClaimsToIdentity to infer the claim value type from the JSON token type (#1002)
* [`[3dc9ac979c]`](https://github.com/aspnet/AspNetCore/commit/3dc9ac979c) Add docs note about TypeScriptCompileBlocked as requested in #399
* [`[bf71e3e71c]`](https://github.com/aspnet/AspNetCore/commit/bf71e3e71c) Publish updated generator-aspnetcore-spa
* [`[c140b5014a]`](https://github.com/aspnet/AspNetCore/commit/c140b5014a) Fix WebApplicationBasic config
* [`[de9460fba5]`](https://github.com/aspnet/AspNetCore/commit/de9460fba5) Update KO template type dependencies. Fixes #397.
* [`[5b9c01e54d]`](https://github.com/aspnet/AspNetCore/commit/5b9c01e54d) Added a functional test for ViewComponent tag helpers  - Added Copyright ViewComponent tag helper  - Added Dan ViewComponent tag helper
* [`[ca6acc807d]`](https://github.com/aspnet/AspNetCore/commit/ca6acc807d) Attempt to fix headings in docs
* [`[8285bb0c74]`](https://github.com/aspnet/AspNetCore/commit/8285bb0c74) Some extra links in docs
* [`[75abf1a2ab]`](https://github.com/aspnet/AspNetCore/commit/75abf1a2ab) Add docs about debugging
* [`[a427d5f0f0]`](https://github.com/aspnet/AspNetCore/commit/a427d5f0f0) Fix source map generation in projects that also use ExtractTextPlugin
* [`[e0c18ab269]`](https://github.com/aspnet/AspNetCore/commit/e0c18ab269) Publish updated Yeoman generators
* [`[f20ad391b6]`](https://github.com/aspnet/AspNetCore/commit/f20ad391b6) Change ReactReduxSpa template to require redux-typed 2.0.0 (because the template uses TS 2.0 compiler)
* [`[496338ccca]`](https://github.com/aspnet/AspNetCore/commit/496338ccca) Publish redux-typed 2.0.0 which depends on TypeScript 2.0 for usage (its .d.ts files use the "/// <reference types="..." />" syntax)
* [`[0615578d9a]`](https://github.com/aspnet/AspNetCore/commit/0615578d9a) Switch from inline to external source maps. This avoids several problems with inline source maps in VS 2015 (at least as of Update 3).
* [`[610601cc6e]`](https://github.com/aspnet/AspNetCore/commit/610601cc6e) test fixes and whitespace changes to generated code
* [`[f629f9a659]`](https://github.com/aspnet/AspNetCore/commit/f629f9a659) Check for null arguments in GetArgumentDictionary
* [`[79e576b86c]`](https://github.com/aspnet/AspNetCore/commit/79e576b86c) ProducesResponseTypeAttribute(int statusCode) ctor added
* [`[11ed34f229]`](https://github.com/aspnet/AspNetCore/commit/11ed34f229) add header ordering and short circuits to known headers
* [`[72bc9c0f2c]`](https://github.com/aspnet/AspNetCore/commit/72bc9c0f2c) Update DefaultAntiforgeryTokenStore.cs (#106)
* [`[ca1341144a]`](https://github.com/aspnet/AspNetCore/commit/ca1341144a) Upgrade dotnet-publish-iis to Microsoft.NETCore.App 1.1 and add dotnet-cli package type
* [`[fff0adeaaf]`](https://github.com/aspnet/AspNetCore/commit/fff0adeaaf) Faster response Content-Length parsing.
* [`[9579806306]`](https://github.com/aspnet/AspNetCore/commit/9579806306) [Fixes #5150] parsing issue on asp.net when request quality factor is specified
* [`[38aa48651f]`](https://github.com/aspnet/AspNetCore/commit/38aa48651f) Fix for Issue#5150
* [`[d8c6c4ab34]`](https://github.com/aspnet/AspNetCore/commit/d8c6c4ab34) Add support for VaryByQueryKey #2894
* [`[61de7fec6f]`](https://github.com/aspnet/AspNetCore/commit/61de7fec6f) [Fixes #5421] Visit children when accepting TagHelperChunk  - Fixes ViewComponentTagHelpers in nested scenarios
* [`[431548d55a]`](https://github.com/aspnet/AspNetCore/commit/431548d55a) Downgrading package quality to preview1
* [`[c2fee4d74d]`](https://github.com/aspnet/AspNetCore/commit/c2fee4d74d) AcceptedResult(), AcceptedAtActionResult(), AcceptedAtRouteResult() support
* [`[e7c992ff06]`](https://github.com/aspnet/AspNetCore/commit/e7c992ff06) Added fragment to FormActionTagHelper and FormActionTagHelper
* [`[4e1ec39a1f]`](https://github.com/aspnet/AspNetCore/commit/4e1ec39a1f) Store `GetFullHtmlFieldName()` and `CreateSanitizedId()` values - #3918 - don't repeat allocations for identical calls; helps w/ e.g. label / input / validation clusters - add `NameAndIdProvider`; it stores `PreviousNameAndId` in `HttpContext.Items`  - `PreviousNameAndId` allocated only when `string`s are allocated e.g. "id"s were sanitized
* [`[affcb935d7]`](https://github.com/aspnet/AspNetCore/commit/affcb935d7) clean-up and renaming
* [`[78584799a4]`](https://github.com/aspnet/AspNetCore/commit/78584799a4) Separate request rejection from bad request state setting.
* [`[f1071dea50]`](https://github.com/aspnet/AspNetCore/commit/f1071dea50) Set StatusCode before disposing HttpContext (#876)
* [`[68533f32f7]`](https://github.com/aspnet/AspNetCore/commit/68533f32f7) Upgrade test project to netcoreapp1.1
* [`[87e4b9df39]`](https://github.com/aspnet/AspNetCore/commit/87e4b9df39) Rename NuGet.Config to NuGet.config
* [`[69b4b64fd5]`](https://github.com/aspnet/AspNetCore/commit/69b4b64fd5) Cache ModelMetadata HashCode
* [`[a80d7d744a]`](https://github.com/aspnet/AspNetCore/commit/a80d7d744a) Speed up MSD.GetNode
* [`[1bb9a61d7a]`](https://github.com/aspnet/AspNetCore/commit/1bb9a61d7a) README, LICENSE, and CONTRIBUTING files
* [`[b2681bb69d]`](https://github.com/aspnet/AspNetCore/commit/b2681bb69d) Updating to preview4
* [`[62df63ada8]`](https://github.com/aspnet/AspNetCore/commit/62df63ada8) Updating to preview4
* [`[5bb405b585]`](https://github.com/aspnet/AspNetCore/commit/5bb405b585) Clone rel/1.1.0-preview1
* [`[0f4701dd92]`](https://github.com/aspnet/AspNetCore/commit/0f4701dd92) Clone to rel/1.1.0-preview1
* [`[3760d3724d]`](https://github.com/aspnet/AspNetCore/commit/3760d3724d) removing usage of deprecated httpPlatformHandler
* [`[99bf212cce]`](https://github.com/aspnet/AspNetCore/commit/99bf212cce) Make aspnet-webpack resilient against Webpack configs with nonstring entrypoints. Fixes #376.
* [`[418255e148]`](https://github.com/aspnet/AspNetCore/commit/418255e148) Exclude node_modules from .NET compilation. Fixes #378.
* [`[f6d7321243]`](https://github.com/aspnet/AspNetCore/commit/f6d7321243) Update remaining templates to TypeScript 2 / @types / etc.
* [`[a7ed0112db]`](https://github.com/aspnet/AspNetCore/commit/a7ed0112db) Publish redux-typed 1.0.1
* [`[d2dbd473a0]`](https://github.com/aspnet/AspNetCore/commit/d2dbd473a0) @davidfowl love dat Func<...,object,...>,object pattern
* [`[b035e31dc7]`](https://github.com/aspnet/AspNetCore/commit/b035e31dc7) Specify the publish feed in Universe makefile
* [`[a1c0970222]`](https://github.com/aspnet/AspNetCore/commit/a1c0970222) move prototype WebSockets-over-Channels code in
* [`[1571a2dbe9]`](https://github.com/aspnet/AspNetCore/commit/1571a2dbe9) Removing double casts
* [`[6317ea30c6]`](https://github.com/aspnet/AspNetCore/commit/6317ea30c6) Don't read commit file if it doesn't exist
* [`[8a2c0ecec1]`](https://github.com/aspnet/AspNetCore/commit/8a2c0ecec1) Don't fail if a repo does not have commit file
* [`[b1b5a40ebf]`](https://github.com/aspnet/AspNetCore/commit/b1b5a40ebf) #1004 clean up social sample code
* [`[151ac2cdcb]`](https://github.com/aspnet/AspNetCore/commit/151ac2cdcb) Add Microsoft.AspNetCore.ResponseCaching.Abstractions to NugetPackageVerifier.json
* [`[5323cef748]`](https://github.com/aspnet/AspNetCore/commit/5323cef748) Fix verify and assembly creation
* [`[4cbd904154]`](https://github.com/aspnet/AspNetCore/commit/4cbd904154) dotnet-watch: add --verbose and --quiet command line flags
* [`[f5ac590e53]`](https://github.com/aspnet/AspNetCore/commit/f5ac590e53) 1.1.0 dependencies
* [`[d449e87795]`](https://github.com/aspnet/AspNetCore/commit/d449e87795) Downgrading tool to netcoreapp1.0
* [`[3eab3ef013]`](https://github.com/aspnet/AspNetCore/commit/3eab3ef013) Updating package that was missed
* [`[2c9672f18a]`](https://github.com/aspnet/AspNetCore/commit/2c9672f18a) Add metapackage
* [`[49300ac5f7]`](https://github.com/aspnet/AspNetCore/commit/49300ac5f7) Updating to netcoreapp1.1
* [`[3651f1f46c]`](https://github.com/aspnet/AspNetCore/commit/3651f1f46c) Updating to netcoreapp1.1
* [`[1b5ae76197]`](https://github.com/aspnet/AspNetCore/commit/1b5ae76197) Updating to netcoreapp1.1
* [`[c8fe8ded59]`](https://github.com/aspnet/AspNetCore/commit/c8fe8ded59) Updating to netcoreapp1.1
* [`[d2e1a51fa8]`](https://github.com/aspnet/AspNetCore/commit/d2e1a51fa8) Updating to netcoreapp1.1
* [`[7e577832ff]`](https://github.com/aspnet/AspNetCore/commit/7e577832ff) Updating to netcoreapp1.1
* [`[d81ea871fb]`](https://github.com/aspnet/AspNetCore/commit/d81ea871fb) Updating to netcoreapp1.1
* [`[cbbcab2a0d]`](https://github.com/aspnet/AspNetCore/commit/cbbcab2a0d) Updating to netcoreapp1.1
* [`[8a057d5491]`](https://github.com/aspnet/AspNetCore/commit/8a057d5491) Updating to netcoreapp1.1
* [`[a52d692de0]`](https://github.com/aspnet/AspNetCore/commit/a52d692de0) Updating to netcoreapp1.1
* [`[e0aa2787ce]`](https://github.com/aspnet/AspNetCore/commit/e0aa2787ce) Updating to netcoreapp1.1
* [`[2876f82521]`](https://github.com/aspnet/AspNetCore/commit/2876f82521) Updating to netcoreapp1.1
* [`[17a4e83bab]`](https://github.com/aspnet/AspNetCore/commit/17a4e83bab) Updating to netcoreapp1.1
* [`[9c1fc542d2]`](https://github.com/aspnet/AspNetCore/commit/9c1fc542d2) Updating to netcoreapp1.1
* [`[cdbd9ffa74]`](https://github.com/aspnet/AspNetCore/commit/cdbd9ffa74) Updating to netcoreapp1.1
* [`[58d5c2f7d4]`](https://github.com/aspnet/AspNetCore/commit/58d5c2f7d4) Updating to netcoreapp1.1
* [`[d0e8c4dd4c]`](https://github.com/aspnet/AspNetCore/commit/d0e8c4dd4c) Updating to netcoreapp1.1
* [`[a3e7481fcb]`](https://github.com/aspnet/AspNetCore/commit/a3e7481fcb) Updating to netcoreapp1.1
* [`[f3a6083c9c]`](https://github.com/aspnet/AspNetCore/commit/f3a6083c9c) Updating to netcoreapp1.1
* [`[8cd356f170]`](https://github.com/aspnet/AspNetCore/commit/8cd356f170) Updating to netcoreapp1.1
* [`[62bb80580d]`](https://github.com/aspnet/AspNetCore/commit/62bb80580d) Updating to netcoreapp1.1
* [`[c5c94d88c8]`](https://github.com/aspnet/AspNetCore/commit/c5c94d88c8) Updating to netcoreapp1.1
* [`[bc6fff40e6]`](https://github.com/aspnet/AspNetCore/commit/bc6fff40e6) Use 1.0.0 dependencies
* [`[5d998a16d8]`](https://github.com/aspnet/AspNetCore/commit/5d998a16d8) dotnet-watch: simplify the end to end testing to not rely on tool installation via restore (#194)
* [`[0627d859af]`](https://github.com/aspnet/AspNetCore/commit/0627d859af) Fix path issue in assertion for DotNetDependencyProviderTests
* [`[d5b0126f61]`](https://github.com/aspnet/AspNetCore/commit/d5b0126f61) Add AspNetCore meta package
* [`[398a104810]`](https://github.com/aspnet/AspNetCore/commit/398a104810) Updating to netcoreapp1.1
* [`[09802d1ded]`](https://github.com/aspnet/AspNetCore/commit/09802d1ded) Updating to netcoreapp1.1
* [`[21fbdcc476]`](https://github.com/aspnet/AspNetCore/commit/21fbdcc476) Updating to netcoreapp1.1
* [`[559e8d6027]`](https://github.com/aspnet/AspNetCore/commit/559e8d6027) Updating to netcoreapp1.1
* [`[1b9ae67215]`](https://github.com/aspnet/AspNetCore/commit/1b9ae67215) Updating to netcoreapp1.1
* [`[052b6f1105]`](https://github.com/aspnet/AspNetCore/commit/052b6f1105) Updating to netcoreapp1.1
* [`[55134b31fe]`](https://github.com/aspnet/AspNetCore/commit/55134b31fe) Updating to netcoreapp1.1
* [`[7e082dbdef]`](https://github.com/aspnet/AspNetCore/commit/7e082dbdef) Updating to netcoreapp1.1
* [`[8656065f88]`](https://github.com/aspnet/AspNetCore/commit/8656065f88) Updating to netcoreapp1.1
* [`[c17540f02c]`](https://github.com/aspnet/AspNetCore/commit/c17540f02c) Updating to netcoreapp1.1
* [`[3c6ad8fc64]`](https://github.com/aspnet/AspNetCore/commit/3c6ad8fc64) Updating to netcoreapp1.1
* [`[c707642da1]`](https://github.com/aspnet/AspNetCore/commit/c707642da1) Updating to netcoreapp1.1
* [`[dd23f24241]`](https://github.com/aspnet/AspNetCore/commit/dd23f24241) Updating to netcoreapp1.1
* [`[ddcee4774d]`](https://github.com/aspnet/AspNetCore/commit/ddcee4774d) Updating to netcoreapp1.1
* [`[9ab8c48f17]`](https://github.com/aspnet/AspNetCore/commit/9ab8c48f17) Updating to netcoreapp1.1
* [`[6d5cd28e9b]`](https://github.com/aspnet/AspNetCore/commit/6d5cd28e9b) Updating to netcoreapp1.1
* [`[08332a96b7]`](https://github.com/aspnet/AspNetCore/commit/08332a96b7) Updating to netcoreapp1.1
* [`[72114ca4fa]`](https://github.com/aspnet/AspNetCore/commit/72114ca4fa) Updating to netcoreapp1.1
* [`[fd6df3c74d]`](https://github.com/aspnet/AspNetCore/commit/fd6df3c74d) Updating to netcoreapp1.1
* [`[65025d41a5]`](https://github.com/aspnet/AspNetCore/commit/65025d41a5) Updating to netcoreapp1.1
* [`[a2a214f698]`](https://github.com/aspnet/AspNetCore/commit/a2a214f698) Updating to netcoreapp1.1
* [`[9c80faa498]`](https://github.com/aspnet/AspNetCore/commit/9c80faa498) Updating to netcoreapp1.1
* [`[631482a1e9]`](https://github.com/aspnet/AspNetCore/commit/631482a1e9) Updating to netcoreapp1.1
* [`[e191420cae]`](https://github.com/aspnet/AspNetCore/commit/e191420cae) Updating to netcoreapp1.1
* [`[8fb38d3637]`](https://github.com/aspnet/AspNetCore/commit/8fb38d3637) Add Project References to ProjectContext
* [`[ffc3eb3afd]`](https://github.com/aspnet/AspNetCore/commit/ffc3eb3afd) HEAD response can include Content-Length header.
* [`[1ae83eff70]`](https://github.com/aspnet/AspNetCore/commit/1ae83eff70) Handle compilerOptions in project.json
* [`[8d8e1ee8dc]`](https://github.com/aspnet/AspNetCore/commit/8d8e1ee8dc) Avoid calling User.Identity.AuthenticationType (#282)
* [`[329b65fc69]`](https://github.com/aspnet/AspNetCore/commit/329b65fc69) Add AssemblyName to ProjectContext
* [`[ce6e65b1d7]`](https://github.com/aspnet/AspNetCore/commit/ce6e65b1d7) Don't take SocketOutput's _contextLock to return written blocks
* [`[7ee13875b1]`](https://github.com/aspnet/AspNetCore/commit/7ee13875b1) Reduce delay variability in KeepAliveTimeoutTests.ConnectionKeptAliveBetweenRequests() (#1157).
* [`[a15b1e2805]`](https://github.com/aspnet/AspNetCore/commit/a15b1e2805) Update cached Content-Length when setting raw header.
* [`[f8813a600d]`](https://github.com/aspnet/AspNetCore/commit/f8813a600d) Handle response content length mismatches (#175).
* [`[1543595c01]`](https://github.com/aspnet/AspNetCore/commit/1543595c01) Correct Windows path handling in new aspnet-webpack feature
* [`[3d77a21bc6]`](https://github.com/aspnet/AspNetCore/commit/3d77a21bc6) Publishing updated generator-aspnetcore-spa
* [`[0289f73a96]`](https://github.com/aspnet/AspNetCore/commit/0289f73a96) Fix the deployment issue caused by incorrectly referencing 'webpack-externals-plugin' when it should be 'webpack-node-externals'
* [`[6a9b7accce]`](https://github.com/aspnet/AspNetCore/commit/6a9b7accce) Update Dockerfiles to use Node 4.x (was using 0.x). Fixes #373
* [`[a6d959b783]`](https://github.com/aspnet/AspNetCore/commit/a6d959b783) Publish updated aspnet-webpack
* [`[30a694450c]`](https://github.com/aspnet/AspNetCore/commit/30a694450c) Make source maps compatible with VS/VSCode debugging (fix file paths, and strip out the "charset=utf-8;" segments from inline sourceMappingURLs)
* [`[d20a72b812]`](https://github.com/aspnet/AspNetCore/commit/d20a72b812) In webpack dev middleware, after compilation, also write updated files to disk. This is needed for VS/VSCode debugger compatibility.
* [`[24773c8aa4]`](https://github.com/aspnet/AspNetCore/commit/24773c8aa4) In aspnet-webpack, provide a SourceMapDevToolPlugin wrapper that strips out "charset=utf-8;" from inline source map URLs to enable VS debugger compatibility
* [`[8be3b16756]`](https://github.com/aspnet/AspNetCore/commit/8be3b16756) Fix DotNetDependencyProviderTest for CI
* [`[34e0b3ae35]`](https://github.com/aspnet/AspNetCore/commit/34e0b3ae35) Create CONTRIBUTING.md
* [`[95620d6cd5]`](https://github.com/aspnet/AspNetCore/commit/95620d6cd5) Create LICENSE.txt
* [`[d3a7d7f5da]`](https://github.com/aspnet/AspNetCore/commit/d3a7d7f5da) Create README.md
* [`[78e35d3c6f]`](https://github.com/aspnet/AspNetCore/commit/78e35d3c6f) Split ProjectModel into separate packages (#188)
* [`[6f5baf033d]`](https://github.com/aspnet/AspNetCore/commit/6f5baf033d) Add ResponseCompression integration tests
* [`[f7932b57a6]`](https://github.com/aspnet/AspNetCore/commit/f7932b57a6) Add Dependency Resolution Apis to ProjectContext Abstractions
* [`[c20b9ae894]`](https://github.com/aspnet/AspNetCore/commit/c20b9ae894) Add PackageLockFile to IProjectContext (#187)
* [`[3177ba0aae]`](https://github.com/aspnet/AspNetCore/commit/3177ba0aae) Wait for frame loop completion to dispose connection stream (#1156).
* [`[6c645879a8]`](https://github.com/aspnet/AspNetCore/commit/6c645879a8) Publish updated aspnet-webpack
* [`[d5055dbaf3]`](https://github.com/aspnet/AspNetCore/commit/d5055dbaf3) Make the fix for #365 not be a breaking change (at least, for the considerable majority of aspnet-webpack users)
* [`[3568476cca]`](https://github.com/aspnet/AspNetCore/commit/3568476cca) aspnet-webpack auto-loads 'event-source-polyfill' on client when HMR is enabled. This requires 'event-source-polyfill' to be included in the client-side bundle, so it's also now added to all the templates' vendor bundles. Fixes #365.
* [`[93779a5e46]`](https://github.com/aspnet/AspNetCore/commit/93779a5e46) aspnet-webpack configures HMR to point directly to http://localhost:<port>/__webpack_hmr instead of proxying via /__webpack_hmr. This is because IE/Edge doesn't honour CORS headers properly following redirects (returns "Network Error 0x80004004"). This could be avoided if we could reverse-proxy to __webpack_hmr (waiting for https://github.com/aspnet/KestrelHttpServer/issues/1139)
* [`[4a1c437f60]`](https://github.com/aspnet/AspNetCore/commit/4a1c437f60) Don't fail precompiled view discovery if assembly is not managed
* [`[8bd8887213]`](https://github.com/aspnet/AspNetCore/commit/8bd8887213) Don't call CompleteReader, the dispatcher can handle that
* [`[cf68c18dd2]`](https://github.com/aspnet/AspNetCore/commit/cf68c18dd2) Do async reads
* [`[adc3e63ecc]`](https://github.com/aspnet/AspNetCore/commit/adc3e63ecc) Improve callstack for LoggingThreadPool
* [`[e987e2107f]`](https://github.com/aspnet/AspNetCore/commit/e987e2107f) [Fixes #5379] Dont generate TagHelperDescriptors for ViewComponents with generic parameters
* [`[3b7f9b4043]`](https://github.com/aspnet/AspNetCore/commit/3b7f9b4043) Fixed version of System.Reflection.TypeExtensions package
* [`[ed3b750ad2]`](https://github.com/aspnet/AspNetCore/commit/ed3b750ad2) Less allocations in ViewBuffer when there is only one ViewBufferPage
* [`[3bb5b725d9]`](https://github.com/aspnet/AspNetCore/commit/3bb5b725d9) Fixed case of package name Microsoft.DotNet.InternalAbstractions
* [`[a623b4edd1]`](https://github.com/aspnet/AspNetCore/commit/a623b4edd1) Use Assembly's containing directory to locate precompiled views assembly
* [`[e67c82e7f2]`](https://github.com/aspnet/AspNetCore/commit/e67c82e7f2) Updated IISDeployer
* [`[4569653504]`](https://github.com/aspnet/AspNetCore/commit/4569653504) Don't allocate for ResponseCookiesFeature
* [`[eef2f14c78]`](https://github.com/aspnet/AspNetCore/commit/eef2f14c78) Flush even before we get end of message
* [`[54610b8fe4]`](https://github.com/aspnet/AspNetCore/commit/54610b8fe4) Handle null or empty vary rules
* [`[45337c1fc2]`](https://github.com/aspnet/AspNetCore/commit/45337c1fc2) Downgrade to 1.0.0 Microsoft.Extensions.DependencyModel
* [`[9d54cf1e8a]`](https://github.com/aspnet/AspNetCore/commit/9d54cf1e8a) Move ResponseCacheFeature to new Abstractions package (#67)
* [`[393c25988a]`](https://github.com/aspnet/AspNetCore/commit/393c25988a) [Fixes #33] Dictionary operations fail due to contract issues
* [`[41f00eea23]`](https://github.com/aspnet/AspNetCore/commit/41f00eea23) Default Status Code for void types changed to 200
* [`[bbecb0c0dc]`](https://github.com/aspnet/AspNetCore/commit/bbecb0c0dc) Fixing SSE transport
* [`[92a8d6d3bd]`](https://github.com/aspnet/AspNetCore/commit/92a8d6d3bd) Add API for multi-tfm projects (#184)
* [`[2f4316b24f]`](https://github.com/aspnet/AspNetCore/commit/2f4316b24f) Add Microsoft.DotNet.InternalAbstractions to resolve runtime failure. Pin the version of ProjectModel.Loader and Cli.Utils
* [`[4214884b3e]`](https://github.com/aspnet/AspNetCore/commit/4214884b3e) Fix xml doc warning.
* [`[a15b73af68]`](https://github.com/aspnet/AspNetCore/commit/a15b73af68) Pin to RTM versions of DotNet packages
* [`[03f8a7a217]`](https://github.com/aspnet/AspNetCore/commit/03f8a7a217) Use HeaderUtilities.FormatDate in DateHeaderValueManager (#1132)
* [`[1e302de78e]`](https://github.com/aspnet/AspNetCore/commit/1e302de78e) Resolve WebListener warnings
* [`[5820854940]`](https://github.com/aspnet/AspNetCore/commit/5820854940) Load precompiled views binary from the bin directory
* [`[3b2a2eb892]`](https://github.com/aspnet/AspNetCore/commit/3b2a2eb892) Add logging
* [`[d0196914ff]`](https://github.com/aspnet/AspNetCore/commit/d0196914ff) JS code style fixes
* [`[2c94884da9]`](https://github.com/aspnet/AspNetCore/commit/2c94884da9) Include address in error message when address already in use (#1086).
* [`[2708b8a534]`](https://github.com/aspnet/AspNetCore/commit/2708b8a534) Add CodeCoverage to tests
* [`[063d6eca0f]`](https://github.com/aspnet/AspNetCore/commit/063d6eca0f) Added custom RFC 1123 DateTimeFormatter to improve allocation profile (#716)
* [`[d054bbc2e8]`](https://github.com/aspnet/AspNetCore/commit/d054bbc2e8) Respond to new behavior for HTTP/1.1 Connection: close responses
* [`[c641a43f38]`](https://github.com/aspnet/AspNetCore/commit/c641a43f38) Fixing @davidfowl's shitty web code.
* [`[2433448bc7]`](https://github.com/aspnet/AspNetCore/commit/2433448bc7) #259 Auto-chunk even for Connection: close responses
* [`[1d76284e25]`](https://github.com/aspnet/AspNetCore/commit/1d76284e25) Serialize node invocationInfo JSON directly to stream to avoid running out of memory
* [`[268617ddba]`](https://github.com/aspnet/AspNetCore/commit/268617ddba) DefaultViewComponentFactory no longer allocates new lambda delegate on each call to CreateViewComponent
* [`[c33b227331]`](https://github.com/aspnet/AspNetCore/commit/c33b227331) Update redux-typed to use TS 2.0 and @types
* [`[02315b41c0]`](https://github.com/aspnet/AspNetCore/commit/02315b41c0) Update angular2-aspnet to use TS 2.0 and @types
* [`[4e291130a0]`](https://github.com/aspnet/AspNetCore/commit/4e291130a0) Update domain-task to use TS 2.0 and @types
* [`[5c0505440d]`](https://github.com/aspnet/AspNetCore/commit/5c0505440d) Update aspnet-webpack to use TS 2.0 and @types
* [`[f13c2595b8]`](https://github.com/aspnet/AspNetCore/commit/f13c2595b8) Update aspnet-prerendering to use TS 2.0 and @types
* [`[bc42e598f9]`](https://github.com/aspnet/AspNetCore/commit/bc42e598f9) Update NodeServices TypeScript compilation to use @types
* [`[a0ebab1f28]`](https://github.com/aspnet/AspNetCore/commit/a0ebab1f28) Update Dockerfile
* [`[81d96766ee]`](https://github.com/aspnet/AspNetCore/commit/81d96766ee) domain-task also needs TypeScript 2+ because of whatwg-streams
* [`[3f5e340b9f]`](https://github.com/aspnet/AspNetCore/commit/3f5e340b9f) Committed launch settings
* [`[1d6cdb7a53]`](https://github.com/aspnet/AspNetCore/commit/1d6cdb7a53) Fix Microsoft.Extensions.Logging.AzureAppServices package reference
* [`[9e5dbee208]`](https://github.com/aspnet/AspNetCore/commit/9e5dbee208) Cache should use weak comparison for ETags
* [`[40ff75d536]`](https://github.com/aspnet/AspNetCore/commit/40ff75d536) Create replacement API for Microsoft.DotNet.ProjectModel
* [`[295d419265]`](https://github.com/aspnet/AspNetCore/commit/295d419265) Update sample to include Redis for Core (#128)
* [`[de7cea4000]`](https://github.com/aspnet/AspNetCore/commit/de7cea4000) Getting RouteDataRequestCultureProvider from Microsoft.AspNetCore.Localization.Routing package
* [`[db90b7b048]`](https://github.com/aspnet/AspNetCore/commit/db90b7b048) Add AzureIntegration repo (#460)
* [`[b099ca7eeb]`](https://github.com/aspnet/AspNetCore/commit/b099ca7eeb) Fix NuGetPackageVerifier.json
* [`[52fad36ce6]`](https://github.com/aspnet/AspNetCore/commit/52fad36ce6) Add AssemblyInfo.cs
* [`[6eacfd2679]`](https://github.com/aspnet/AspNetCore/commit/6eacfd2679) Rename Azure.Storage to AzureStorage (#183)
* [`[b103a70104]`](https://github.com/aspnet/AspNetCore/commit/b103a70104) Add Microsoft.AspNetCore.AzureAppServicesIntegration package (#1)
* [`[18e8b7101c]`](https://github.com/aspnet/AspNetCore/commit/18e8b7101c) In aspnet-webpack, allow webpack-hot-middleware/client to be added manually with options. Fixes #353
* [`[6126c4d480]`](https://github.com/aspnet/AspNetCore/commit/6126c4d480) In Angular2Spa, move tsconfig.json back to root. Fixes #346.
* [`[3032909f3c]`](https://github.com/aspnet/AspNetCore/commit/3032909f3c) Added tests
* [`[e5e8d1bee3]`](https://github.com/aspnet/AspNetCore/commit/e5e8d1bee3) Decouple the dispatcher from routing for easier testing
* [`[411f44f263]`](https://github.com/aspnet/AspNetCore/commit/411f44f263) Reduce code duplication
* [`[67d0c13815]`](https://github.com/aspnet/AspNetCore/commit/67d0c13815) Updating partner package versions
* [`[91497621c9]`](https://github.com/aspnet/AspNetCore/commit/91497621c9) Updating partner package versions
* [`[74a3063c45]`](https://github.com/aspnet/AspNetCore/commit/74a3063c45) [Fixes #357] Fix behavior when optional parameters are defined within a route and not at the end
* [`[e7e6b896ba]`](https://github.com/aspnet/AspNetCore/commit/e7e6b896ba) Don't emit TE header or body for non-body responses
* [`[438ec83227]`](https://github.com/aspnet/AspNetCore/commit/438ec83227) [Fixes #359] Routing is matching empty segments to parameters and defaults are wrong
* [`[554eb73223]`](https://github.com/aspnet/AspNetCore/commit/554eb73223) Add Microsoft.AspNetCore.Hosting.Azure.AppServices package
* [`[b9fda49649]`](https://github.com/aspnet/AspNetCore/commit/b9fda49649) allowing flow app_offline to remote client (#17)
* [`[35cae5da7d]`](https://github.com/aspnet/AspNetCore/commit/35cae5da7d) Updating partner package versions
* [`[3fa95d1ff8]`](https://github.com/aspnet/AspNetCore/commit/3fa95d1ff8) Updating partner package versions
* [`[f64c864911]`](https://github.com/aspnet/AspNetCore/commit/f64c864911) Updating partner package versions
* [`[aec2a7c2d2]`](https://github.com/aspnet/AspNetCore/commit/aec2a7c2d2) Updating partner package versions
* [`[6d235e4ef5]`](https://github.com/aspnet/AspNetCore/commit/6d235e4ef5) Update partner package versions
* [`[6ccd09d6e5]`](https://github.com/aspnet/AspNetCore/commit/6ccd09d6e5) Updating partner package versions
* [`[f1c53378c3]`](https://github.com/aspnet/AspNetCore/commit/f1c53378c3) Updating partner package versions
* [`[89bd6dc1cd]`](https://github.com/aspnet/AspNetCore/commit/89bd6dc1cd) [Fixes #5212] Added a cookie based ITempDataProvider
* [`[4cd4ddfad5]`](https://github.com/aspnet/AspNetCore/commit/4cd4ddfad5) More structed connection metadata
* [`[4647a8a4bd]`](https://github.com/aspnet/AspNetCore/commit/4647a8a4bd) Updating partner package versions
* [`[3d3d6a3fba]`](https://github.com/aspnet/AspNetCore/commit/3d3d6a3fba) Updating partner package versions
* [`[92682b71f3]`](https://github.com/aspnet/AspNetCore/commit/92682b71f3) Addresses #5251
* [`[89c39a6c28]`](https://github.com/aspnet/AspNetCore/commit/89c39a6c28) Update StackExchange.Redis.StrongName (#182)
* [`[b8471455a7]`](https://github.com/aspnet/AspNetCore/commit/b8471455a7) Fix NuGet project description ASP.NET 5 > Core (#120)
* [`[8fb339483d]`](https://github.com/aspnet/AspNetCore/commit/8fb339483d) Move HttpContext property up a level
* [`[4e10d19175]`](https://github.com/aspnet/AspNetCore/commit/4e10d19175) Update default Max Body Size
* [`[2b7a396670]`](https://github.com/aspnet/AspNetCore/commit/2b7a396670) When EndPoint ends, the connection ends.
* [`[99d7aea78c]`](https://github.com/aspnet/AspNetCore/commit/99d7aea78c) Add User to Connection
* [`[e018fe70f7]`](https://github.com/aspnet/AspNetCore/commit/e018fe70f7) Handle message fragments
* [`[1a5138e972]`](https://github.com/aspnet/AspNetCore/commit/1a5138e972) Added hub sample
* [`[58e58b7fb7]`](https://github.com/aspnet/AspNetCore/commit/58e58b7fb7) Added JSON RPC demo
* [`[9ee33bf01f]`](https://github.com/aspnet/AspNetCore/commit/9ee33bf01f) Add transport connection metadata
* [`[58d08c07d0]`](https://github.com/aspnet/AspNetCore/commit/58d08c07d0) Added connect and disconnect messages
* [`[1ad1120c41]`](https://github.com/aspnet/AspNetCore/commit/1ad1120c41) Update the LastActive for reserved connections
* [`[613ac2d6c3]`](https://github.com/aspnet/AspNetCore/commit/613ac2d6c3) Fix long polling
* [`[d646e3666f]`](https://github.com/aspnet/AspNetCore/commit/d646e3666f) Made a thin websocket like wrapper around the client API
* [`[540784e525]`](https://github.com/aspnet/AspNetCore/commit/540784e525) Added .NET WebSocket sample
* [`[5c9729fe4f]`](https://github.com/aspnet/AspNetCore/commit/5c9729fe4f) Move sse to sse specific page
* [`[2a369f40f6]`](https://github.com/aspnet/AspNetCore/commit/2a369f40f6) Small fixes - Pass the Connection to each IHttpTransport - FlushAsync after writing for WebListener - Add metadata to Connection - Added WebListener dependency
* [`[9f5ef70164]`](https://github.com/aspnet/AspNetCore/commit/9f5ef70164) Added support for websockets - Upgraded to ASP.NET Core 1.1 preview
* [`[f4f763f136]`](https://github.com/aspnet/AspNetCore/commit/f4f763f136) Only run next queued task if the previous was successful
* [`[ad2724b22c]`](https://github.com/aspnet/AspNetCore/commit/ad2724b22c) Split Connection and ConnectionState
* [`[7b8e947567]`](https://github.com/aspnet/AspNetCore/commit/7b8e947567) Use new CopyToAsync method
* [`[957a9beb95]`](https://github.com/aspnet/AspNetCore/commit/957a9beb95) Updated license.md
* [`[c3753c4f0e]`](https://github.com/aspnet/AspNetCore/commit/c3753c4f0e) Renamed the project and split into class library and sample
* [`[4a79573def]`](https://github.com/aspnet/AspNetCore/commit/4a79573def) Jhkim/add installancm ps1 (#15)
* [`[756843786e]`](https://github.com/aspnet/AspNetCore/commit/756843786e) Ensure absolute path used in output dir
* [`[239b5f815f]`](https://github.com/aspnet/AspNetCore/commit/239b5f815f) Fixing longpolling
* [`[3b1f650d3b]`](https://github.com/aspnet/AspNetCore/commit/3b1f650d3b) Add custom tool for packaging as "CLI" package types.
* [`[32ed7ca0c4]`](https://github.com/aspnet/AspNetCore/commit/32ed7ca0c4) SSE kind of works - duplicate messages
* [`[7e76ea8731]`](https://github.com/aspnet/AspNetCore/commit/7e76ea8731) Update file license headers
* [`[aa52e66585]`](https://github.com/aspnet/AspNetCore/commit/aa52e66585) Make DistributedResponseCacheStore internal (#61)
* [`[261f73abc7]`](https://github.com/aspnet/AspNetCore/commit/261f73abc7) Add NonViewComponentAttribute
* [`[e97f36deb8]`](https://github.com/aspnet/AspNetCore/commit/e97f36deb8) Create CONTRIBUTING.md
* [`[9044706e2e]`](https://github.com/aspnet/AspNetCore/commit/9044706e2e) Create LICENSE.txt
* [`[681e32d0c1]`](https://github.com/aspnet/AspNetCore/commit/681e32d0c1) Create README.md
* [`[60d600dd5c]`](https://github.com/aspnet/AspNetCore/commit/60d600dd5c) Issue #5310 (#5334)
* [`[03352354dc]`](https://github.com/aspnet/AspNetCore/commit/03352354dc) Initial commit
* [`[3181c3f2e3]`](https://github.com/aspnet/AspNetCore/commit/3181c3f2e3) Only challenge if not already accepted.
* [`[e09dd6d0b8]`](https://github.com/aspnet/AspNetCore/commit/e09dd6d0b8) Fix #976: Break claims value in array into multiple claims (#996)
* [`[7a3fd8af33]`](https://github.com/aspnet/AspNetCore/commit/7a3fd8af33) Rename DataProtection.Azure.Blob to DataProtection.Azure.Storage (#180)
* [`[7fe0ce7c51]`](https://github.com/aspnet/AspNetCore/commit/7fe0ce7c51) Temporarily disabling failing IISExpress smoke tests
* [`[d376a1fa75]`](https://github.com/aspnet/AspNetCore/commit/d376a1fa75) Updating partner package versions
* [`[37b1fc039d]`](https://github.com/aspnet/AspNetCore/commit/37b1fc039d) Updating partner package versions
* [`[24385e74c4]`](https://github.com/aspnet/AspNetCore/commit/24385e74c4) Internalize iresponsecachekeyprovider (#59)
* [`[e4cf12017b]`](https://github.com/aspnet/AspNetCore/commit/e4cf12017b) Make UseIISIntegration idempotent (#274)
* [`[94be501f8c]`](https://github.com/aspnet/AspNetCore/commit/94be501f8c) Update to WebListener 1.1.0 (#706)
* [`[5f070daac8]`](https://github.com/aspnet/AspNetCore/commit/5f070daac8) In KnockoutSpa template, fix handling clicks on descendants of A elements. Fixes #273.
* [`[3270e28b3d]`](https://github.com/aspnet/AspNetCore/commit/3270e28b3d) Slight clean-up in KnockoutSpa's boot code
* [`[8968a24041]`](https://github.com/aspnet/AspNetCore/commit/8968a24041) Publishing updated generator-aspnetcore-spa package
* [`[10381b0456]`](https://github.com/aspnet/AspNetCore/commit/10381b0456) Use HttpMethods
* [`[310411075f]`](https://github.com/aspnet/AspNetCore/commit/310411075f) Slimmer locks
* [`[09fda749b0]`](https://github.com/aspnet/AspNetCore/commit/09fda749b0) Don't reset frame state when connection is aborted (#1103).
* [`[0152691108]`](https://github.com/aspnet/AspNetCore/commit/0152691108) Cookie Auto: set properties back to ticket when using SessionStore (#995)
* [`[73656f6503]`](https://github.com/aspnet/AspNetCore/commit/73656f6503) Assume zero length on non-keepalive requests without Content-Length or Transfer-Encoding (#1104).
* [`[44b0dfd5bb]`](https://github.com/aspnet/AspNetCore/commit/44b0dfd5bb) Sharding (#57)
* [`[c71cc6b8d2]`](https://github.com/aspnet/AspNetCore/commit/c71cc6b8d2) Updating partner package versions
* [`[8f10080ad0]`](https://github.com/aspnet/AspNetCore/commit/8f10080ad0) Updating partner package versions
* [`[4875019cb0]`](https://github.com/aspnet/AspNetCore/commit/4875019cb0) Updating partner package versions
* [`[039e1021a4]`](https://github.com/aspnet/AspNetCore/commit/039e1021a4) Updating partner package versions
* [`[1f8d3c6bf1]`](https://github.com/aspnet/AspNetCore/commit/1f8d3c6bf1) Updating partner package versions
* [`[9e8aee2478]`](https://github.com/aspnet/AspNetCore/commit/9e8aee2478) Updating partner package versions
* [`[874dcebbcb]`](https://github.com/aspnet/AspNetCore/commit/874dcebbcb) Updating partner package versions
* [`[c13a8affc0]`](https://github.com/aspnet/AspNetCore/commit/c13a8affc0) Updating partner package versions
* [`[fa5dcf55a6]`](https://github.com/aspnet/AspNetCore/commit/fa5dcf55a6) Updating partner package versions
* [`[fb8795e247]`](https://github.com/aspnet/AspNetCore/commit/fb8795e247) Updating partner package versions
* [`[067eb9c6f8]`](https://github.com/aspnet/AspNetCore/commit/067eb9c6f8) Make FeatureReferences<T>.Fetch inlineable (#704)
* [`[0a961a7bd0]`](https://github.com/aspnet/AspNetCore/commit/0a961a7bd0) Updated ReactReduxSpa template to match current patterns
* [`[c88aa0042a]`](https://github.com/aspnet/AspNetCore/commit/c88aa0042a) Fix for issue #29 (Honor JsonProperty when serializing a JsonPatchDocument) (#35)
* [`[a9ce762827]`](https://github.com/aspnet/AspNetCore/commit/a9ce762827) Update project.json in KnockoutSpa and ReactSpa
* [`[0d34dba4fd]`](https://github.com/aspnet/AspNetCore/commit/0d34dba4fd) In ReactSpa, fix HMR warning and correctly minify React for production
* [`[808592d3a0]`](https://github.com/aspnet/AspNetCore/commit/808592d3a0) Update ReactSpa template to match current patterns
* [`[d1228dc26a]`](https://github.com/aspnet/AspNetCore/commit/d1228dc26a) Update KnockoutSpa template to match current patterns
* [`[09b4135217]`](https://github.com/aspnet/AspNetCore/commit/09b4135217) Further workarounds for https://github.com/dotnet/cli/issues/1396
* [`[4937fef28f]`](https://github.com/aspnet/AspNetCore/commit/4937fef28f) Publish updated version of generator-aspnetcore-spa
* [`[46966322b7]`](https://github.com/aspnet/AspNetCore/commit/46966322b7) In LoadViaWebpack, account for CSS/font/etc files referenced with URLs that have a querystring. Fixes #335.
* [`[adf4732191]`](https://github.com/aspnet/AspNetCore/commit/adf4732191) Make aspnet-webpack and SpaServices both back-compatible with older versions of the other, in case people don't upgrade both at the same time
* [`[7b227229b3]`](https://github.com/aspnet/AspNetCore/commit/7b227229b3) In Webpack dev middleware, for configs that target Node, just run a 'watch' compiler (since Node isn't going to fetch the modules via HTTP anyway)
* [`[2241c55a90]`](https://github.com/aspnet/AspNetCore/commit/2241c55a90) Support for array-style webpack configs in aspnet-webpack. Fixes #291.
* [`[0312da7df3]`](https://github.com/aspnet/AspNetCore/commit/0312da7df3) Add request headers timeout (#1110).
* [`[7b2f7b94ab]`](https://github.com/aspnet/AspNetCore/commit/7b2f7b94ab) Return last block from SocketOutput when data is fully written
* [`[0a4c06eefb]`](https://github.com/aspnet/AspNetCore/commit/0a4c06eefb) Suppress validation summary `<div>` when nothing is generated - #2372 - make the `ValidationSummaryTagHelper` behave consistently with `Html.ValidationSummar()`
* [`[6cdd0451da]`](https://github.com/aspnet/AspNetCore/commit/6cdd0451da) DisplayMetadata use DisplayNameAttribute
* [`[35cde79e46]`](https://github.com/aspnet/AspNetCore/commit/35cde79e46) Renamed HttpMethod class to HttpMethods to avoid conflicts
* [`[375e8b7022]`](https://github.com/aspnet/AspNetCore/commit/375e8b7022) Change context relationships from inheritance to composition.
* [`[e521473f1d]`](https://github.com/aspnet/AspNetCore/commit/e521473f1d) Fixed naming abiguity
* [`[2bdbcee7ba]`](https://github.com/aspnet/AspNetCore/commit/2bdbcee7ba) Fixed naming abiguity
* [`[85eba9ca27]`](https://github.com/aspnet/AspNetCore/commit/85eba9ca27) Add README.md for generator-aspnetcore-spa. Fixes #308.
* [`[46906e4ea8]`](https://github.com/aspnet/AspNetCore/commit/46906e4ea8) Add repo info to package.json in all NPM packages hosted in this repo
* [`[7e88903bcc]`](https://github.com/aspnet/AspNetCore/commit/7e88903bcc) Fix Node event chaining in VirtualConnectionServer to work with latest NPM libraries. Fixes #331.
* [`[67fc64309f]`](https://github.com/aspnet/AspNetCore/commit/67fc64309f) Update Angular 2 Music Store sample to declare dependency on .NET Core 1.0.1
* [`[5a9d3cb189]`](https://github.com/aspnet/AspNetCore/commit/5a9d3cb189) Update readme to mention dependency on .NET Core 1.0.1
* [`[f79936c104]`](https://github.com/aspnet/AspNetCore/commit/f79936c104) In Angular2Spa webpack config, allow html/css files from node_modules to be loaded via Webpack.
* [`[e8594287db]`](https://github.com/aspnet/AspNetCore/commit/e8594287db) In aspnet-webpack, make sure that webpack-externals-plugin doesn't treat non-JS files as external. Fixes #332.
* [`[626332c5db]`](https://github.com/aspnet/AspNetCore/commit/626332c5db) Adding HTTP method constants
* [`[d245ded51d]`](https://github.com/aspnet/AspNetCore/commit/d245ded51d) Produce fake nupkg for testing
* [`[9982e73d3e]`](https://github.com/aspnet/AspNetCore/commit/9982e73d3e) Change project structure to accomodate test projects
* [`[918d612745]`](https://github.com/aspnet/AspNetCore/commit/918d612745) Add ChunkingCookieManager.Sources to NuGetPackageVerifier
* [`[1a0d4a512d]`](https://github.com/aspnet/AspNetCore/commit/1a0d4a512d) Update sample usage of EF tools
* [`[f90594a647]`](https://github.com/aspnet/AspNetCore/commit/f90594a647) Add support for '--' argument separator
* [`[78c859d7ea]`](https://github.com/aspnet/AspNetCore/commit/78c859d7ea) Turn on warnings as errors
* [`[782f96572d]`](https://github.com/aspnet/AspNetCore/commit/782f96572d) Specify sequential layout to avoid warning
* [`[0d782d9d9a]`](https://github.com/aspnet/AspNetCore/commit/0d782d9d9a) Adding design time support for ViewComponent TagHelpers
* [`[28932a7795]`](https://github.com/aspnet/AspNetCore/commit/28932a7795) Log the error inforamtion when redeem auth code
* [`[6cf94c0949]`](https://github.com/aspnet/AspNetCore/commit/6cf94c0949) List netcoreapp1.0 prior to net451 so that test discovery in VS works
* [`[ddeef1f9ac]`](https://github.com/aspnet/AspNetCore/commit/ddeef1f9ac) Add prompt parameter to Google auth endpoint
* [`[03b3d6bec8]`](https://github.com/aspnet/AspNetCore/commit/03b3d6bec8) Use DataAnnotationLocalizerProvider for Display localization
* [`[5aae7ded01]`](https://github.com/aspnet/AspNetCore/commit/5aae7ded01) Update Twitter auth package description
* [`[49ff98f8cb]`](https://github.com/aspnet/AspNetCore/commit/49ff98f8cb) More specific response status codes for errors (#653).
* [`[25f39dd0f5]`](https://github.com/aspnet/AspNetCore/commit/25f39dd0f5) #859 Discriminate between providers when sharing an auth cookie
* [`[1b1bd34b8d]`](https://github.com/aspnet/AspNetCore/commit/1b1bd34b8d) Add new dependnecy and test for UTF-8 BOM fix in views
* [`[a069f6b636]`](https://github.com/aspnet/AspNetCore/commit/a069f6b636) Store each header value separately
* [`[5e12a103a4]`](https://github.com/aspnet/AspNetCore/commit/5e12a103a4) API updates
* [`[aa1fd5d89a]`](https://github.com/aspnet/AspNetCore/commit/aa1fd5d89a) Move ChunkingCookieManager to a separate Sources project
* [`[e12838e38f]`](https://github.com/aspnet/AspNetCore/commit/e12838e38f) Auth: Always call prior handlers during Challenge
* [`[81d46cfaed]`](https://github.com/aspnet/AspNetCore/commit/81d46cfaed) Add EntityFramework.Tools
* [`[b55e444a55]`](https://github.com/aspnet/AspNetCore/commit/b55e444a55) Also print CWD in node 'require' error reports
* [`[f9807c546d]`](https://github.com/aspnet/AspNetCore/commit/f9807c546d) In SpaServices NuGet package, pass through error stack when NPM modules fail to load
* [`[232e908ce8]`](https://github.com/aspnet/AspNetCore/commit/232e908ce8) Pass through error stack when NPM module loading failed in aspnet-webpack and aspnet-prerendering to make debugging easier
* [`[5214a553a7]`](https://github.com/aspnet/AspNetCore/commit/5214a553a7) In Angular2Spa, server-side rendering now reports all errors
* [`[f558c5de99]`](https://github.com/aspnet/AspNetCore/commit/f558c5de99) Update the filewatcher Add a reference counter to avoid AV in case web.config was changed
* [`[11bbd6df8e]`](https://github.com/aspnet/AspNetCore/commit/11bbd6df8e) Support relative paths to projects.
* [`[7bafb00f05]`](https://github.com/aspnet/AspNetCore/commit/7bafb00f05) Improve error message when project file does not exist.
* [`[6891d00032]`](https://github.com/aspnet/AspNetCore/commit/6891d00032) Stricter expiration checks to avoid serving responses when max-age is 0
* [`[c30d471c27]`](https://github.com/aspnet/AspNetCore/commit/c30d471c27) Make IResponseCacheStore APIs async
* [`[63509b9e10]`](https://github.com/aspnet/AspNetCore/commit/63509b9e10) Make FrameRequestStream.CopyToAsync(...) copyless
* [`[2ba5a0ac93]`](https://github.com/aspnet/AspNetCore/commit/2ba5a0ac93) As per #325, reference module.hot directly instead of via a local var, because Webpack does static analysis that looks for this
* [`[925f47fece]`](https://github.com/aspnet/AspNetCore/commit/925f47fece) In Angular2Spa, use css-loader so you can reference external images from CSS files, etc.
* [`[80343e9f17]`](https://github.com/aspnet/AspNetCore/commit/80343e9f17) In aspnet-webpack, replace ExternalsPlugin with webpack-node-externals because of #132
* [`[50be444440]`](https://github.com/aspnet/AspNetCore/commit/50be444440) Update docs to describe using LESS with Angular 2 component styling
* [`[19684f2b7d]`](https://github.com/aspnet/AspNetCore/commit/19684f2b7d) In Angular2Spa template, use per-component scoped styles. Fixes common config issues like #234.
* [`[fb54566ff5]`](https://github.com/aspnet/AspNetCore/commit/fb54566ff5) Add dotnet-sql-cache
* [`[8f2eccbd36]`](https://github.com/aspnet/AspNetCore/commit/8f2eccbd36) Move dotnet-user-secrets into current repo
* [`[01f7ecd9d9]`](https://github.com/aspnet/AspNetCore/commit/01f7ecd9d9) [Fixes #5154] Stream should be suppressed from model metadata validation
* [`[3c05d10430]`](https://github.com/aspnet/AspNetCore/commit/3c05d10430) Set designTime to false
* [`[cd18489f00]`](https://github.com/aspnet/AspNetCore/commit/cd18489f00) Fix HMR again following previous change
* [`[41f1f6fe82]`](https://github.com/aspnet/AspNetCore/commit/41f1f6fe82) Delay Angular 2 bootstrapping until DOMContentLoaded
* [`[494c7b585c]`](https://github.com/aspnet/AspNetCore/commit/494c7b585c) Fix trailing whitespace
* [`[49a8536679]`](https://github.com/aspnet/AspNetCore/commit/49a8536679) Update angular2-universal dependencies (cherry-pick 62dd13b3b)
* [`[358ee2261e]`](https://github.com/aspnet/AspNetCore/commit/358ee2261e) Make indentation consistent
* [`[4ea7eb195e]`](https://github.com/aspnet/AspNetCore/commit/4ea7eb195e) Simplify webpack config. Eliminate dev/prod override files.
* [`[85dfdd9b50]`](https://github.com/aspnet/AspNetCore/commit/85dfdd9b50) Move tsconfig into ClientApp dir, since it's not needed at root
* [`[a91b6a6b5c]`](https://github.com/aspnet/AspNetCore/commit/a91b6a6b5c) Make HMR work again
* [`[a1c1bdb1e6]`](https://github.com/aspnet/AspNetCore/commit/a1c1bdb1e6) Simplify imports in boot-client.ts
* [`[8f550c5706]`](https://github.com/aspnet/AspNetCore/commit/8f550c5706) Simplify Angular 2 template where possible
* [`[243a9b4ef6]`](https://github.com/aspnet/AspNetCore/commit/243a9b4ef6) Add @types/node to avoid intellisense errors for "require" statements
* [`[ce0d2089d2]`](https://github.com/aspnet/AspNetCore/commit/ce0d2089d2) ng2 2.0, Universal 2.0, TS 2.0, Preboot 4.*
* [`[fbac81a471]`](https://github.com/aspnet/AspNetCore/commit/fbac81a471) Short circuit to avoid DateTimeOffset parsing
* [`[b3fe8b30ac]`](https://github.com/aspnet/AspNetCore/commit/b3fe8b30ac) Moved VCTHDFactory to .Internal namespace
* [`[7f638c1385]`](https://github.com/aspnet/AspNetCore/commit/7f638c1385) Always overwrite the VaryBy entry to ensure expiry is updated
* [`[3b351ad1bb]`](https://github.com/aspnet/AspNetCore/commit/3b351ad1bb) Restore tool version to preview3
* [`[afa89b3993]`](https://github.com/aspnet/AspNetCore/commit/afa89b3993) Change SkipReason for ThreadCountTests on OS X.
* [`[0cfd5363f8]`](https://github.com/aspnet/AspNetCore/commit/0cfd5363f8) Added ViewComponentTagHelperDescriptorResolver and related stuff
* [`[b6da89f54c]`](https://github.com/aspnet/AspNetCore/commit/b6da89f54c) [Fixes #852] TestHost: OnStarting and OnCompleted callbacks of response are not being awaited
* [`[e8f55bdb13]`](https://github.com/aspnet/AspNetCore/commit/e8f55bdb13) Add Fail fast option for AuthZ
* [`[dd4799adfd]`](https://github.com/aspnet/AspNetCore/commit/dd4799adfd) Split by commas when normalizing headers
* [`[6c13371fa0]`](https://github.com/aspnet/AspNetCore/commit/6c13371fa0) API review renames and updates continued
* [`[2ee0078cfd]`](https://github.com/aspnet/AspNetCore/commit/2ee0078cfd) Fix HttpNodeInstanceEntryPoint to match latest NPM modules
* [`[591d548de7]`](https://github.com/aspnet/AspNetCore/commit/591d548de7) Publish new Yeoman templates (0.2.9)
* [`[06ad36f830]`](https://github.com/aspnet/AspNetCore/commit/06ad36f830) In Angular 2 template, include prebuilt wwwroot/dist/* files to support VS and "dotnet new" templates (which can't run post-project-creation actions)
* [`[7a80d905b8]`](https://github.com/aspnet/AspNetCore/commit/7a80d905b8) In Angular 2 template, include reflect-metadata and zone.js in vendor bundle
* [`[1a273f5a34]`](https://github.com/aspnet/AspNetCore/commit/1a273f5a34) Improve keep-alive timeout.
* [`[760c8f3867]`](https://github.com/aspnet/AspNetCore/commit/760c8f3867) Ensure Append writes to the right page after Clear
* [`[3a868d87a2]`](https://github.com/aspnet/AspNetCore/commit/3a868d87a2) Added IExceptionHandlerPathFeature interface.
* [`[42027b6cc2]`](https://github.com/aspnet/AspNetCore/commit/42027b6cc2) [Fixes #5243] Handle null values in TempData properly
* [`[d9ff1d81d6]`](https://github.com/aspnet/AspNetCore/commit/d9ff1d81d6) PagedBufferedTextWriter does not flush synchronous data prior to writing data asynchronously
* [`[43071319aa]`](https://github.com/aspnet/AspNetCore/commit/43071319aa) Buffer rendered CacheTagHelper content strings to a custom TextWriter Fixes #4893
* [`[a480378a44]`](https://github.com/aspnet/AspNetCore/commit/a480378a44) Make AuthorizeFilter constructable
* [`[ccfa090e6e]`](https://github.com/aspnet/AspNetCore/commit/ccfa090e6e) API review renames and updates
* [`[d76b013a56]`](https://github.com/aspnet/AspNetCore/commit/d76b013a56) WebpackDevMiddleware now uses ProjectPath option consistently. Fixes #307
* [`[ad90db343c]`](https://github.com/aspnet/AspNetCore/commit/ad90db343c) [Fixes #101] Cookie path is always / in IIS
* [`[3b45ea5c27]`](https://github.com/aspnet/AspNetCore/commit/3b45ea5c27) Add a test that verifies strong name signing works for precompiled views
* [`[b72435c5cc]`](https://github.com/aspnet/AspNetCore/commit/b72435c5cc) Yeoman generator support for optional --projectguid=... CLI argument
* [`[7f841ff840]`](https://github.com/aspnet/AspNetCore/commit/7f841ff840) In Yeoman generator, support passing args from command line (e.g., --framework=angular-2)
* [`[e236e64055]`](https://github.com/aspnet/AspNetCore/commit/e236e64055) Fallback to empty cache control when none is explicitly cached
* [`[4a5e1f4a72]`](https://github.com/aspnet/AspNetCore/commit/4a5e1f4a72) Use as cast instead of C-style cast for IVewContextAware helpers
* [`[65b89668bb]`](https://github.com/aspnet/AspNetCore/commit/65b89668bb) Allow lookup of multiple keys
* [`[6a04fe5fb7]`](https://github.com/aspnet/AspNetCore/commit/6a04fe5fb7) Store body and header separately, preliminary sharding
* [`[755957b694]`](https://github.com/aspnet/AspNetCore/commit/755957b694) Use HttpClient from Fixture instrad of creating a new one per test
* [`[84efe624a6]`](https://github.com/aspnet/AspNetCore/commit/84efe624a6) Fix deadlock in HttpsTests
* [`[39bd49ea1a]`](https://github.com/aspnet/AspNetCore/commit/39bd49ea1a) Avoid blocking the MockLibuv loop with test code
* [`[c037a577b0]`](https://github.com/aspnet/AspNetCore/commit/c037a577b0) Set background color for ErrorPage
* [`[8c513402a3]`](https://github.com/aspnet/AspNetCore/commit/8c513402a3) Always call ConsumingComplete() with furthest examined position (#1095).
* [`[c777a9efea]`](https://github.com/aspnet/AspNetCore/commit/c777a9efea) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#1089)
* [`[ba49651552]`](https://github.com/aspnet/AspNetCore/commit/ba49651552) Increment version to 1.0.0-rc1-final
* [`[99a98af51e]`](https://github.com/aspnet/AspNetCore/commit/99a98af51e) #229 Update package descriptions and tags
* [`[f21c603f5a]`](https://github.com/aspnet/AspNetCore/commit/f21c603f5a) Downgrade dotnet-publish-iis to latest stable release
* [`[f071590fce]`](https://github.com/aspnet/AspNetCore/commit/f071590fce) Webpack HMR EventSource requests are now proxied (rather than redirected) to the local HMR server. Fixes #271.
* [`[bc2de2ad59]`](https://github.com/aspnet/AspNetCore/commit/bc2de2ad59) In aspnet-webpack HMR, don't rely on assumption that entry point is called 'main'. Fixes #289.
* [`[605090e909]`](https://github.com/aspnet/AspNetCore/commit/605090e909) Publish updated version of aspnet-webpack as 1.0.10
* [`[67f7e7450f]`](https://github.com/aspnet/AspNetCore/commit/67f7e7450f) Adding tsd to dev dependencies in aspnet-webpack.
* [`[da662c55fa]`](https://github.com/aspnet/AspNetCore/commit/da662c55fa) Make webpack dev dependency a peer dependency in aspnet-webpack.
* [`[b4bec30b0f]`](https://github.com/aspnet/AspNetCore/commit/b4bec30b0f) Clean up dependencies vs devDependencies in templates
* [`[28550784ed]`](https://github.com/aspnet/AspNetCore/commit/28550784ed) ReactReduxSpa's boot-server now supports redirections issued by react-router
* [`[1be9102aea]`](https://github.com/aspnet/AspNetCore/commit/1be9102aea) Prerendering server-side code can now issue redirections. Fixes #280
* [`[c2c45b04df]`](https://github.com/aspnet/AspNetCore/commit/c2c45b04df) In preparation for supporting redirections, aspnet-prerendering now passes through all boot func resolution props to .NET code
* [`[16ee36c20a]`](https://github.com/aspnet/AspNetCore/commit/16ee36c20a) Downgrade dotnet-publish-iis to latest stable release
* [`[e0663483ed]`](https://github.com/aspnet/AspNetCore/commit/e0663483ed) Downgrade to 1.0.0 runtime dependencies
* [`[eee1a9fef4]`](https://github.com/aspnet/AspNetCore/commit/eee1a9fef4) Do not generate a validation summary when `excludePropertyErrors` unless specific model has an error - #5209 - update affected `HtmlHelperValiationSummaryTest` and functional tests - add `ValidationSummaryTagHelperTest` tests to cover related scenarios
* [`[43a0a5a9f1]`](https://github.com/aspnet/AspNetCore/commit/43a0a5a9f1) Replace ConfigureOptions with IConfigureOptions
* [`[bbf1478821]`](https://github.com/aspnet/AspNetCore/commit/bbf1478821) #150 Handle OperationCancelledExceptions to prevent log noise
* [`[bc7eb631d9]`](https://github.com/aspnet/AspNetCore/commit/bc7eb631d9) Pin to 1.0.0-rc1-final
* [`[98e35cc6da]`](https://github.com/aspnet/AspNetCore/commit/98e35cc6da) Add retry to ApplicationDeployer delete
* [`[7a37091d3b]`](https://github.com/aspnet/AspNetCore/commit/7a37091d3b) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#254)
* [`[ce0ed3d237]`](https://github.com/aspnet/AspNetCore/commit/ce0ed3d237) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#968)
* [`[5dc14acc32]`](https://github.com/aspnet/AspNetCore/commit/5dc14acc32) Increase HttpClient timeout
* [`[032bcf43b2]`](https://github.com/aspnet/AspNetCore/commit/032bcf43b2) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#361)
* [`[755b702823]`](https://github.com/aspnet/AspNetCore/commit/755b702823) Correct test failures on Windows with `git config core.autocrlf false` - line endings in checked-out files do not necessarily match `Environment.NewLine`
* [`[50f066579a]`](https://github.com/aspnet/AspNetCore/commit/50f066579a) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#257)
* [`[0bcf4b0700]`](https://github.com/aspnet/AspNetCore/commit/0bcf4b0700) Further work on fix for #235 (solving additional problem that 'npm publish' is hardcoded to exclude node_modules dirs)
* [`[7a98ff1a64]`](https://github.com/aspnet/AspNetCore/commit/7a98ff1a64) Added view component tag helper code generator. (#5195)
* [`[5750c4aab7]`](https://github.com/aspnet/AspNetCore/commit/5750c4aab7) Publish updated generator-aspnetcore-spa package (0.2.5)
* [`[5fcce843ba]`](https://github.com/aspnet/AspNetCore/commit/5fcce843ba) Workaround to fix #235 (add placeholder inside node_modules)
* [`[1f2168949d]`](https://github.com/aspnet/AspNetCore/commit/1f2168949d) Publish updated aspnet-prerendering NPM package
* [`[4ca1669db1]`](https://github.com/aspnet/AspNetCore/commit/4ca1669db1) Prerendering imposes its own (overridable) timeout with descriptive error
* [`[041d173f56]`](https://github.com/aspnet/AspNetCore/commit/041d173f56) All NodeServices invocations now have a default timeout, plus a descriptive exception if that happens
* [`[2799861296]`](https://github.com/aspnet/AspNetCore/commit/2799861296) Support cancellation of NodeServices invocations
* [`[5b2065230d]`](https://github.com/aspnet/AspNetCore/commit/5b2065230d) Fix failing keep-alive timeout tests.
* [`[05392cbf35]`](https://github.com/aspnet/AspNetCore/commit/05392cbf35) Added view component tag helper code generator. (#5195)
* [`[830983a477]`](https://github.com/aspnet/AspNetCore/commit/830983a477) Fixes #5198 Stops caching of Enum display values (#5185)
* [`[bdbb854bdb]`](https://github.com/aspnet/AspNetCore/commit/bdbb854bdb) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#829)
* [`[02b8fb3bbc]`](https://github.com/aspnet/AspNetCore/commit/02b8fb3bbc) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources
* [`[dc8806f07e]`](https://github.com/aspnet/AspNetCore/commit/dc8806f07e) Downgrade and pin Microsoft.Extensions.RuntimeEnvironment.Sources
* [`[d046091727]`](https://github.com/aspnet/AspNetCore/commit/d046091727) Add an option to embed sources for compiled views (cshtml content) in the generated assembly
* [`[18f08fdb2f]`](https://github.com/aspnet/AspNetCore/commit/18f08fdb2f) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#705)
* [`[e984b89e0a]`](https://github.com/aspnet/AspNetCore/commit/e984b89e0a) Switch to master myget feed
* [`[b94519b821]`](https://github.com/aspnet/AspNetCore/commit/b94519b821) Pin versions
* [`[72c3688604]`](https://github.com/aspnet/AspNetCore/commit/72c3688604) Use TaskCache class from Microsoft.Extensions.TaskCache.Sources (#331)
* [`[f358d8e2b2]`](https://github.com/aspnet/AspNetCore/commit/f358d8e2b2) In HttpNodeInstance, correctly report response serialisation errors back to .NET (previously, it just timed out)
* [`[a526454321]`](https://github.com/aspnet/AspNetCore/commit/a526454321) Raise version from 0.2.0-pre to 1.0.0-rc1
* [`[a787a01a73]`](https://github.com/aspnet/AspNetCore/commit/a787a01a73) Downgrade to 1.0 dependencies
* [`[465d0c8d15]`](https://github.com/aspnet/AspNetCore/commit/465d0c8d15) Design review: Explicitly disable TypeNameHandling in all Json.NET usage
* [`[f7c28fe47f]`](https://github.com/aspnet/AspNetCore/commit/f7c28fe47f) Fix Microsoft.AspNetCore.DataProtection.Azure.Blob dependency version in sample and test
* [`[377401b5e6]`](https://github.com/aspnet/AspNetCore/commit/377401b5e6) Update README to clarify that you need .NET Core 1.0 RTM
* [`[c25d9b68ab]`](https://github.com/aspnet/AspNetCore/commit/c25d9b68ab) Use socket in Path encoding and unescaping cases
* [`[100beaaf94]`](https://github.com/aspnet/AspNetCore/commit/100beaaf94) Add length constrain in path processing
* [`[35429bd91f]`](https://github.com/aspnet/AspNetCore/commit/35429bd91f) Update overlong UTF8 test case
* [`[b99f98dffb]`](https://github.com/aspnet/AspNetCore/commit/b99f98dffb) Improve URL path decoding and unescaping components
* [`[ff97efe0d2]`](https://github.com/aspnet/AspNetCore/commit/ff97efe0d2) Overhaul the URL path unescaping
* [`[21236cc98e]`](https://github.com/aspnet/AspNetCore/commit/21236cc98e) [Fixes #5016] Perf: Check for OPTIONS before looking for CORS headers
* [`[411681e8d6]`](https://github.com/aspnet/AspNetCore/commit/411681e8d6) Add options to configure case sensitivity of request paths
* [`[7dcbb27b6f]`](https://github.com/aspnet/AspNetCore/commit/7dcbb27b6f) Updated Redis repository project to support .NET Core (#175)
* [`[f2085b1968]`](https://github.com/aspnet/AspNetCore/commit/f2085b1968) Add keep-alive timeout (#464).
* [`[19f8958fa8]`](https://github.com/aspnet/AspNetCore/commit/19f8958fa8) Move TestServer to shared directory.
* [`[0e210dadea]`](https://github.com/aspnet/AspNetCore/commit/0e210dadea) Port DataProtection blob XmlRepository (#163)
* [`[1e59352466]`](https://github.com/aspnet/AspNetCore/commit/1e59352466) Consolidate write flags and counting logic
* [`[8105a272d2]`](https://github.com/aspnet/AspNetCore/commit/8105a272d2) #210 Re-enable caching tests
* [`[88114568b9]`](https://github.com/aspnet/AspNetCore/commit/88114568b9) #167 Prevent duplicate Content-Length headers
* [`[6522926c22]`](https://github.com/aspnet/AspNetCore/commit/6522926c22) Port WebSocket fix from https://github.com/dotnet/corefx/pull/11348
* [`[b996ee39a4]`](https://github.com/aspnet/AspNetCore/commit/b996ee39a4) port dotnet/corefx#11348 (#114)
* [`[d72ef128dd]`](https://github.com/aspnet/AspNetCore/commit/d72ef128dd) Adding options to specify maximum response body size
* [`[b340b0f0f7]`](https://github.com/aspnet/AspNetCore/commit/b340b0f0f7) Add Redis IXmlRepository implementation (#173)
* [`[3b0f01a8ec]`](https://github.com/aspnet/AspNetCore/commit/3b0f01a8ec) Customize key prefix instead of suffix
* [`[7d1a03f51d]`](https://github.com/aspnet/AspNetCore/commit/7d1a03f51d) Serialize functional tests on OS X.
* [`[f05007e0f2]`](https://github.com/aspnet/AspNetCore/commit/f05007e0f2) Fix error message in RequestContext
* [`[03dcae2407]`](https://github.com/aspnet/AspNetCore/commit/03dcae2407) Simplify docs
* [`[f0d954b2a6]`](https://github.com/aspnet/AspNetCore/commit/f0d954b2a6) Design review: Change AddNodeServices to take an Action<NodeServicesOptions> like other aspects of MVC DI config
* [`[5944dd6f87]`](https://github.com/aspnet/AspNetCore/commit/5944dd6f87) Small perf fixes to improve precompilation times
* [`[f04fb8c421]`](https://github.com/aspnet/AspNetCore/commit/f04fb8c421) Design review: Always instantiate via DI
* [`[61fd900974]`](https://github.com/aspnet/AspNetCore/commit/61fd900974) Add missing setup step to docs. Fixes #290.
* [`[09e1cd3b07]`](https://github.com/aspnet/AspNetCore/commit/09e1cd3b07) TS compiler should ignore "bin" dir because, after VS publish, it might contain duplicates of the app's source files. Fixes #279.
* [`[be73cd77bf]`](https://github.com/aspnet/AspNetCore/commit/be73cd77bf) Add buttonTagHelper and submitTagHelper for formaction
* [`[6795ca2f78]`](https://github.com/aspnet/AspNetCore/commit/6795ca2f78) Make the char array for utf8 decoding smaller
* [`[daf4843fb3]`](https://github.com/aspnet/AspNetCore/commit/daf4843fb3) Move Microsoft.AspNetCore.Mvc.Razor.Precompilation.Tests -> Microsoft.AspNetCore.Mvc.Razor.Precompilation.FunctionalTests
* [`[df81f8be57]`](https://github.com/aspnet/AspNetCore/commit/df81f8be57) Added a view component tag helper descriptor factory (#5189)
* [`[d19845730f]`](https://github.com/aspnet/AspNetCore/commit/d19845730f) Added a copy constructor for tag helper descriptors. (#827)
* [`[52f219b16e]`](https://github.com/aspnet/AspNetCore/commit/52f219b16e) Support conditional requests and send 304 when possible
* [`[b31ec7d7a7]`](https://github.com/aspnet/AspNetCore/commit/b31ec7d7a7) #204 Consolidate unsafe buffer access into NativeRequestContext
* [`[ac2f21514f]`](https://github.com/aspnet/AspNetCore/commit/ac2f21514f) Add a flag to specify the log level
* [`[4bda1cbe6d]`](https://github.com/aspnet/AspNetCore/commit/4bda1cbe6d) Implemented asp-format support in input[type=hidden] tag helper.
* [`[1ecef8094a]`](https://github.com/aspnet/AspNetCore/commit/1ecef8094a) Make Kestrel's response buffer limit configurable
* [`[a4d2e5ebcd]`](https://github.com/aspnet/AspNetCore/commit/a4d2e5ebcd) Update static files to use strong comparison on ETags
* [`[e4afd782e8]`](https://github.com/aspnet/AspNetCore/commit/e4afd782e8) Add strong and weak ETag comparisons
* [`[a5e9215982]`](https://github.com/aspnet/AspNetCore/commit/a5e9215982) Update calls for string comparison
* [`[bfa10db258]`](https://github.com/aspnet/AspNetCore/commit/bfa10db258) Run functional tests sequentially to mitigate flakiness on OS X.
* [`[bb5a70f9a8]`](https://github.com/aspnet/AspNetCore/commit/bb5a70f9a8) Added a check for property bag in tag helper descriptor comparer.
* [`[f7ee16170c]`](https://github.com/aspnet/AspNetCore/commit/f7ee16170c) [Fixes #5161] Support running middleware pipeline as part of a resource filter
* [`[acfcafb6e1]`](https://github.com/aspnet/AspNetCore/commit/acfcafb6e1) Ensure MockLibuv.OnPostTask doesn't complete too early
* [`[0742d113be]`](https://github.com/aspnet/AspNetCore/commit/0742d113be) Make all calls to ThreadPool.QueueUserWorkItem through IThreadPool
* [`[1d6c5af72c]`](https://github.com/aspnet/AspNetCore/commit/1d6c5af72c) Add option for VaryBy query string params
* [`[c224a726f9]`](https://github.com/aspnet/AspNetCore/commit/c224a726f9) Moved PageGenerator to Razor repo and moved diagnostic view page sources to Common.
* [`[4587a0fc95]`](https://github.com/aspnet/AspNetCore/commit/4587a0fc95) Prevent possible deadlocks when using MockLibuv.OnPostTask
* [`[cdb1a1a343]`](https://github.com/aspnet/AspNetCore/commit/cdb1a1a343) Moving RazorPageGenerator from 'tools' to 'src' as we want this package to be published by CI (This tool is referenced in Hosting and Diagnostics)
* [`[ee36dfbcee]`](https://github.com/aspnet/AspNetCore/commit/ee36dfbcee) updated
* [`[aff6792af1]`](https://github.com/aspnet/AspNetCore/commit/aff6792af1) Added razor page generator tool
* [`[499fefcc03]`](https://github.com/aspnet/AspNetCore/commit/499fefcc03) Added some missing docs
* [`[a6a4b5369a]`](https://github.com/aspnet/AspNetCore/commit/a6a4b5369a) [Fixes #5166] Support passing instance directly when invoking ViewComponents with single parameter
* [`[3d1dbbaae5]`](https://github.com/aspnet/AspNetCore/commit/3d1dbbaae5) #183 Set empty paths for OPTIONS * requests
* [`[4158be273f]`](https://github.com/aspnet/AspNetCore/commit/4158be273f) Fix OpenIdConnect test
* [`[b6a177ef0b]`](https://github.com/aspnet/AspNetCore/commit/b6a177ef0b) Test for categoryName passed to ILoggerFactory.CreateLogger() in KestrelServer.ctor() (#797)
* [`[6c7f621d5d]`](https://github.com/aspnet/AspNetCore/commit/6c7f621d5d) Don't run desktop tests on xplat
* [`[cbbec15d37]`](https://github.com/aspnet/AspNetCore/commit/cbbec15d37) Ignore null ExpiresUtc property in RequestRefresh
* [`[9ed753288f]`](https://github.com/aspnet/AspNetCore/commit/9ed753288f) [Fixes #5170] Fixed KeyNotFoundException in UrlHelperFactory.GetUrlHelper()
* [`[3aa6d739ce]`](https://github.com/aspnet/AspNetCore/commit/3aa6d739ce) Fix broken test caused by logging change aspnet/Logging#480
* [`[aa97e4d777]`](https://github.com/aspnet/AspNetCore/commit/aa97e4d777) Fail gracefully when repositories have cycles
* [`[c2f52db3a5]`](https://github.com/aspnet/AspNetCore/commit/c2f52db3a5) Reorder SendFileAsync to match Write/FlushAsync
* [`[021ceb71be]`](https://github.com/aspnet/AspNetCore/commit/021ceb71be) Don't run desktop tests on xplat
* [`[3a5df89f1c]`](https://github.com/aspnet/AspNetCore/commit/3a5df89f1c) Move a nullref check to base class
* [`[a79a0360c1]`](https://github.com/aspnet/AspNetCore/commit/a79a0360c1) Update OpenIdConnectHandler
* [`[c5509fb594]`](https://github.com/aspnet/AspNetCore/commit/c5509fb594) Minor update in OpenIdConnectHandler and Options
* [`[ed6984fab5]`](https://github.com/aspnet/AspNetCore/commit/ed6984fab5) Update signed out redirect url in sample
* [`[127e095370]`](https://github.com/aspnet/AspNetCore/commit/127e095370) Added property bag to tag helper descriptor. (#822)
* [`[ece8f33a65]`](https://github.com/aspnet/AspNetCore/commit/ece8f33a65) [Fixes #5175] Async resource filters' short circuited result getting executed more than once.
* [`[fb724a71de]`](https://github.com/aspnet/AspNetCore/commit/fb724a71de) Add configurable options for ResponseCaching
* [`[7cabb3f117]`](https://github.com/aspnet/AspNetCore/commit/7cabb3f117) Moved PageGenerator and DiagnosticsViewPage projects to Common repo and some updates
* [`[26956c5ce1]`](https://github.com/aspnet/AspNetCore/commit/26956c5ce1) Update OIDC signout flow
* [`[0d5482685b]`](https://github.com/aspnet/AspNetCore/commit/0d5482685b) Update OpenIdConnect.AzureAdSample
* [`[21535e5b0d]`](https://github.com/aspnet/AspNetCore/commit/21535e5b0d) Add a test that demonstrates precompiled class library
* [`[4f61c65931]`](https://github.com/aspnet/AspNetCore/commit/4f61c65931) Update no-store behaviour
* [`[ea461c3b47]`](https://github.com/aspnet/AspNetCore/commit/ea461c3b47) Update CommonOptions.cs
* [`[dff0db80ca]`](https://github.com/aspnet/AspNetCore/commit/dff0db80ca) Initial upload
* [`[e927dd6924]`](https://github.com/aspnet/AspNetCore/commit/e927dd6924) More old code
* [`[7036e2b0f5]`](https://github.com/aspnet/AspNetCore/commit/7036e2b0f5) Change `ViewComponent.View()` to flow the `ViewData.Model`.
* [`[b34543621f]`](https://github.com/aspnet/AspNetCore/commit/b34543621f) Added property bag to tag helper descriptor. (#822)
* [`[7dc0a8c7bd]`](https://github.com/aspnet/AspNetCore/commit/7dc0a8c7bd) Return count from trywrite
* [`[489c0d9046]`](https://github.com/aspnet/AspNetCore/commit/489c0d9046) Added view component tag helper updates. (#823)
* [`[59a86c17e2]`](https://github.com/aspnet/AspNetCore/commit/59a86c17e2) Update OpenIdConnectSample
* [`[d887d74819]`](https://github.com/aspnet/AspNetCore/commit/d887d74819) Update OpenIdConnectChallengeTests
* [`[95a7785a12]`](https://github.com/aspnet/AspNetCore/commit/95a7785a12) Adds timeout to sample Regex.
* [`[26b5d1da27]`](https://github.com/aspnet/AspNetCore/commit/26b5d1da27) #86 Do not fire the ClientDisconnect token for completed responses
* [`[8fe007e995]`](https://github.com/aspnet/AspNetCore/commit/8fe007e995) #237 Make shared CLR code internal
* [`[c5c11e81b3]`](https://github.com/aspnet/AspNetCore/commit/c5c11e81b3) Split TestTransaction, add extension to TestServer
* [`[abc1b37ee1]`](https://github.com/aspnet/AspNetCore/commit/abc1b37ee1) Update OpenId Connect Challenge Tests
* [`[62f0f6e857]`](https://github.com/aspnet/AspNetCore/commit/62f0f6e857) HtmlEncode all user input in Azure OpenID sample
* [`[7ea76f5e54]`](https://github.com/aspnet/AspNetCore/commit/7ea76f5e54) Update OpenID connect Azure sample
* [`[91e5de4d69]`](https://github.com/aspnet/AspNetCore/commit/91e5de4d69) Add HTML encoding to OpenIdConnect AzureSample
* [`[6ca981e4df]`](https://github.com/aspnet/AspNetCore/commit/6ca981e4df) Refine OIDC sample
* [`[ec575595ad]`](https://github.com/aspnet/AspNetCore/commit/ec575595ad) Make dotnet publish use LogInformation instead of LogTrace
* [`[8a30c1f804]`](https://github.com/aspnet/AspNetCore/commit/8a30c1f804) Reset frame streams on each request (#1028).
* [`[c967382e89]`](https://github.com/aspnet/AspNetCore/commit/c967382e89) Add Win8 check
* [`[ddf5b44de6]`](https://github.com/aspnet/AspNetCore/commit/ddf5b44de6) Updating to version 1.0.1.
* [`[ca9935943d]`](https://github.com/aspnet/AspNetCore/commit/ca9935943d) Updating to version 1.0.1.
* [`[4e2ed96392]`](https://github.com/aspnet/AspNetCore/commit/4e2ed96392) Adding README.md
* [`[d8209b6cd4]`](https://github.com/aspnet/AspNetCore/commit/d8209b6cd4) #173 Ignore write failures, fix disconnect notifications.
* [`[40636998d7]`](https://github.com/aspnet/AspNetCore/commit/40636998d7) Improve inlinability of libuv success checking
* [`[d291bb7c24]`](https://github.com/aspnet/AspNetCore/commit/d291bb7c24) Add AuthZHandlerContextFactory
* [`[6f15d616a8]`](https://github.com/aspnet/AspNetCore/commit/6f15d616a8) Add IAuthorizationEvaluator
* [`[eed4d8c211]`](https://github.com/aspnet/AspNetCore/commit/eed4d8c211) Child Node processes poll and exit when parent has exited. Fixes #270
* [`[efef52a0ad]`](https://github.com/aspnet/AspNetCore/commit/efef52a0ad) #216 Lazy feature initialization
* [`[c51aec5292]`](https://github.com/aspnet/AspNetCore/commit/c51aec5292) port dotnet/corefx#10792 (#111)
* [`[9f1476aea8]`](https://github.com/aspnet/AspNetCore/commit/9f1476aea8) #230 Disable TLS token binding pending updates
* [`[f1118f3693]`](https://github.com/aspnet/AspNetCore/commit/f1118f3693) Add MvcPrecompilation
* [`[c942eab6e2]`](https://github.com/aspnet/AspNetCore/commit/c942eab6e2) Adding support for Razor precompilation Fixes #3917
* [`[4f766a3fa5]`](https://github.com/aspnet/AspNetCore/commit/4f766a3fa5) Fix issues with feeds used to restore testapps
* [`[dbe93ac6b1]`](https://github.com/aspnet/AspNetCore/commit/dbe93ac6b1) Adding Razor Precompilation
* [`[1ce8a2215c]`](https://github.com/aspnet/AspNetCore/commit/1ce8a2215c) In ReactSpa, use isomorphic-fetch for IE/Edge compatibility
* [`[48eb2b7a05]`](https://github.com/aspnet/AspNetCore/commit/48eb2b7a05) In KnockoutSpa, use isomorphic-fetch for IE/Edge compatibility
* [`[7bd30ea693]`](https://github.com/aspnet/AspNetCore/commit/7bd30ea693) Log all startup errors in KestrelServer
* [`[89034b59c5]`](https://github.com/aspnet/AspNetCore/commit/89034b59c5) Change to mix import/require style
* [`[9e714b61fe]`](https://github.com/aspnet/AspNetCore/commit/9e714b61fe) Bug(KnockoutSpa): Router TS issue
* [`[d928ef4f12]`](https://github.com/aspnet/AspNetCore/commit/d928ef4f12) Rename folders since the template package generator now creates a package for "dotnet new" as well as Yeoman
* [`[d2f109ef6c]`](https://github.com/aspnet/AspNetCore/commit/d2f109ef6c) Add environment variables to dotnet publish
* [`[936a4f6092]`](https://github.com/aspnet/AspNetCore/commit/936a4f6092) Update OpenId Connect Configuration tests
* [`[edb5baf81c]`](https://github.com/aspnet/AspNetCore/commit/edb5baf81c) Change SHA256 algorithm to work on FIPS-compliant machines.
* [`[6e5fd4f89f]`](https://github.com/aspnet/AspNetCore/commit/6e5fd4f89f) Up Antiforgery to 1.0.1 for FIPS compliance changes.
* [`[972be6e8c1]`](https://github.com/aspnet/AspNetCore/commit/972be6e8c1) Disable automatic chunking for all non keep-alive requests
* [`[cdf84eb87e]`](https://github.com/aspnet/AspNetCore/commit/cdf84eb87e) Change SHA256 algorithm to work on FIPS-compliant machines.
* [`[a44275b732]`](https://github.com/aspnet/AspNetCore/commit/a44275b732) Update projects to 1.0.1.
* [`[2f397d6f63]`](https://github.com/aspnet/AspNetCore/commit/2f397d6f63) Switch to UsePathBase instead of relying on Kestrel feature #236
* [`[098159998d]`](https://github.com/aspnet/AspNetCore/commit/098159998d) Add ability to configure environment variables for Node instances, plus auto-populate NODE_ENV based on IHostingEnvironment when possible. Fixes #230
* [`[e2a0e887af]`](https://github.com/aspnet/AspNetCore/commit/e2a0e887af) Add UsePathBase middleware
* [`[6f5722366d]`](https://github.com/aspnet/AspNetCore/commit/6f5722366d) Initial commit
* [`[56cb898bde]`](https://github.com/aspnet/AspNetCore/commit/56cb898bde) Rename PrimeCache to PrimeCacheAsync (keeping older name as obsolete overload). Fixes #246.
* [`[889af50318]`](https://github.com/aspnet/AspNetCore/commit/889af50318) Localize DataAnnotations (#5129)
* [`[c53bd8f8f6]`](https://github.com/aspnet/AspNetCore/commit/c53bd8f8f6) Prerenderer now passes original (unescaped) URL to Node - fixes #250
* [`[8de4ddc010]`](https://github.com/aspnet/AspNetCore/commit/8de4ddc010) Logging Info instead of Warning for Authorization failure in ControllerActionInvoker
* [`[e3b5686d96]`](https://github.com/aspnet/AspNetCore/commit/e3b5686d96) Updating NuGetPackageVerifier.json to account for project rename
* [`[16fbb94c44]`](https://github.com/aspnet/AspNetCore/commit/16fbb94c44) Automatically chunk and set 0 Content-Length for non keep-alive responses
* [`[5f4e60bf8d]`](https://github.com/aspnet/AspNetCore/commit/5f4e60bf8d) Always set "Connection: close" header for non keep-alive responses
* [`[8d7c51bd60]`](https://github.com/aspnet/AspNetCore/commit/8d7c51bd60) Change TagHelpers to work in partial parsing.
* [`[0d0d25b032]`](https://github.com/aspnet/AspNetCore/commit/0d0d25b032) In WebpackDevMiddleware, allow configuration of ProjectPath (implements #262)
* [`[62aabc1bae]`](https://github.com/aspnet/AspNetCore/commit/62aabc1bae) Add implementation for HTTP caching
* [`[7d716d2007]`](https://github.com/aspnet/AspNetCore/commit/7d716d2007) Date & Age handling
* [`[8f4cc3003b]`](https://github.com/aspnet/AspNetCore/commit/8f4cc3003b) Improve SocketOutputTests
* [`[f8189a2296]`](https://github.com/aspnet/AspNetCore/commit/f8189a2296) Rename to Microsoft.AspNetCore.Server.IntegrationTesting Fixes #824
* [`[37ee065c08]`](https://github.com/aspnet/AspNetCore/commit/37ee065c08) Updating to dotnet.myget.org
* [`[761d0e6290]`](https://github.com/aspnet/AspNetCore/commit/761d0e6290) Updating to dotnet.myget.org
* [`[82c9c40709]`](https://github.com/aspnet/AspNetCore/commit/82c9c40709) Capture exceptions when trying to parse files and return parse errors.
* [`[a4ec3bb24a]`](https://github.com/aspnet/AspNetCore/commit/a4ec3bb24a) [Fixes #4991] Misleading MissingMethodException message for incorrect routes
* [`[26a7c7016d]`](https://github.com/aspnet/AspNetCore/commit/26a7c7016d) Minor updates to CookieAuthenticationHandler and its tests
* [`[4600451dc6]`](https://github.com/aspnet/AspNetCore/commit/4600451dc6) Allow absolute uri in authentication properties for cookie auth redirect
* [`[69729bc75b]`](https://github.com/aspnet/AspNetCore/commit/69729bc75b) Perf to ToUriComponent
* [`[97afe4acc8]`](https://github.com/aspnet/AspNetCore/commit/97afe4acc8) Adjust the redirect URI precedence in cookie auth
* [`[6a9f1f9887]`](https://github.com/aspnet/AspNetCore/commit/6a9f1f9887) Honor AuthenticationProperties.RedirectUri in CookieAuthenticationHandler
* [`[cd886802fe]`](https://github.com/aspnet/AspNetCore/commit/cd886802fe) Fix race condition in new OnStarting and OnCompleted tests.
* [`[b876319379]`](https://github.com/aspnet/AspNetCore/commit/b876319379) Detect pool user in script
* [`[08a91f17bf]`](https://github.com/aspnet/AspNetCore/commit/08a91f17bf) Call OnStarting and OnCompleted callbacks in LIFO order (#1042).
* [`[714c3d6659]`](https://github.com/aspnet/AspNetCore/commit/714c3d6659) [Fixes #4991] Misleading MissingMethodException message for incorrect routes
* [`[3bbdeecb14]`](https://github.com/aspnet/AspNetCore/commit/3bbdeecb14) Updated tests to supply value for new deployment parameter 'DeletePublishedApplicationOnDispose'
* [`[cc65ddfa28]`](https://github.com/aspnet/AspNetCore/commit/cc65ddfa28) Updated ApplicationDeployer to conditionally delete published application folder
* [`[5181e4196c]`](https://github.com/aspnet/AspNetCore/commit/5181e4196c) Trace call to _uv_unsafe_async_send in MockLibuv.
* [`[00939fcac9]`](https://github.com/aspnet/AspNetCore/commit/00939fcac9) Migrate to dotnet.myget.org feed
* [`[81192017c9]`](https://github.com/aspnet/AspNetCore/commit/81192017c9) Migrate to dotnet.myget.org feed
* [`[efe4477110]`](https://github.com/aspnet/AspNetCore/commit/efe4477110) Switching to dotnet.myget.org feed
* [`[be5ecb7082]`](https://github.com/aspnet/AspNetCore/commit/be5ecb7082) Switching to dotnet.myget.org feed
* [`[2bc207fa8c]`](https://github.com/aspnet/AspNetCore/commit/2bc207fa8c) Switching to dotnet.myget.org feed
* [`[d20cb17c52]`](https://github.com/aspnet/AspNetCore/commit/d20cb17c52) Switching to dotnet.myget.org feed
* [`[91d57c72bf]`](https://github.com/aspnet/AspNetCore/commit/91d57c72bf) Switching to dotnet.myget.org feed
* [`[23a6604b9a]`](https://github.com/aspnet/AspNetCore/commit/23a6604b9a) Switching to dotnet.myget.org feed
* [`[0bb2c3c2f7]`](https://github.com/aspnet/AspNetCore/commit/0bb2c3c2f7) Switching to dotnet.myget.org feed
* [`[ba75b0be37]`](https://github.com/aspnet/AspNetCore/commit/ba75b0be37) Switching to dotnet.myget.org feed
* [`[56d09500a6]`](https://github.com/aspnet/AspNetCore/commit/56d09500a6) Switching to dotnet.myget.org feed
* [`[2e53d0e55b]`](https://github.com/aspnet/AspNetCore/commit/2e53d0e55b) Switching to dotnet.myget.org feed
* [`[806e23fe5d]`](https://github.com/aspnet/AspNetCore/commit/806e23fe5d) Switching to dotnet.myget.org feed
* [`[d16614a653]`](https://github.com/aspnet/AspNetCore/commit/d16614a653) Switching to dotnet.myget.org feed
* [`[acab75a1bb]`](https://github.com/aspnet/AspNetCore/commit/acab75a1bb) Switching to dotnet.myget.org feed
* [`[5968a964c4]`](https://github.com/aspnet/AspNetCore/commit/5968a964c4) Switching to dotnet.myget.org feed
* [`[79cb3b0ed9]`](https://github.com/aspnet/AspNetCore/commit/79cb3b0ed9) Switching to dotnet.myget.org feed
* [`[5ac2947b52]`](https://github.com/aspnet/AspNetCore/commit/5ac2947b52) Switching to dotnet.myget.org feed
* [`[cb68dd8cd3]`](https://github.com/aspnet/AspNetCore/commit/cb68dd8cd3) Switching to dotnet.myget.org feed
* [`[66abd74142]`](https://github.com/aspnet/AspNetCore/commit/66abd74142) Switching to dotnet.myget.org feed
* [`[0bdfef6913]`](https://github.com/aspnet/AspNetCore/commit/0bdfef6913) Switching to dotnet.myget.org feed
* [`[0fc5dc1820]`](https://github.com/aspnet/AspNetCore/commit/0fc5dc1820) #160 Rename UrlPrefix.Whole to FullPrefix. Make IsHeadMethod internal
* [`[08f98f4790]`](https://github.com/aspnet/AspNetCore/commit/08f98f4790) Add header limit options (#475).
* [`[f09e2bf571]`](https://github.com/aspnet/AspNetCore/commit/f09e2bf571) [Fixes #804] Fixed unsafe cast in CSharpCodeVisitor
* [`[687b3f6911]`](https://github.com/aspnet/AspNetCore/commit/687b3f6911) [Fixes #815] Fix Debug.Assert failure for malformed tags in expression
* [`[2f9bf9bb87]`](https://github.com/aspnet/AspNetCore/commit/2f9bf9bb87) Updating to Moq \ Castle.Core that does not require imports
* [`[936f5a4f6a]`](https://github.com/aspnet/AspNetCore/commit/936f5a4f6a) Made HttpMethod match case-INsensitive Related to https://github.com/aspnet/CORS/issues/77
* [`[e991ebaa4f]`](https://github.com/aspnet/AspNetCore/commit/e991ebaa4f) Updating to Moq \ Castle.Core that does not require imports
* [`[15b66cec1f]`](https://github.com/aspnet/AspNetCore/commit/15b66cec1f) [Fixes #77] Make HTTP method match as case-insensitive
* [`[8691686dd8]`](https://github.com/aspnet/AspNetCore/commit/8691686dd8) Updating to Moq \ Castle.Core that does not require imports
* [`[b5abd73e34]`](https://github.com/aspnet/AspNetCore/commit/b5abd73e34) Updating to Moq \ Castle.Core that does not require imports
* [`[d2b5144132]`](https://github.com/aspnet/AspNetCore/commit/d2b5144132) Updating to Moq \ Castle.Core that does not require imports
* [`[e1b2ee6627]`](https://github.com/aspnet/AspNetCore/commit/e1b2ee6627) Updating to Moq \ Castle.Core that does not require imports
* [`[b086b5b165]`](https://github.com/aspnet/AspNetCore/commit/b086b5b165) Updating to Moq \ Castle.Core that does not require imports
* [`[67dce322df]`](https://github.com/aspnet/AspNetCore/commit/67dce322df) Updating to Moq \ Castle.Core that does not require imports
* [`[f0f3832c14]`](https://github.com/aspnet/AspNetCore/commit/f0f3832c14) Updating to Moq \ Castle.Core that does not require imports
* [`[f2fa8b5660]`](https://github.com/aspnet/AspNetCore/commit/f2fa8b5660) Add functional test.
* [`[a5aacd6307]`](https://github.com/aspnet/AspNetCore/commit/a5aacd6307) Throw when setting OnStarting after response has already started (#806).
* [`[6e5187c1ae]`](https://github.com/aspnet/AspNetCore/commit/6e5187c1ae) Using new StringRouteConstraint for area constraint
* [`[2a6465b27a]`](https://github.com/aspnet/AspNetCore/commit/2a6465b27a) FIxing path separator to address #247 (#248)
* [`[55f409b38b]`](https://github.com/aspnet/AspNetCore/commit/55f409b38b) Fix hanging functional tests.
* [`[4b36501bd8]`](https://github.com/aspnet/AspNetCore/commit/4b36501bd8) #160 Move AllowAnonymous from the AuthenticationSchemes to its own bool
* [`[a344684d06]`](https://github.com/aspnet/AspNetCore/commit/a344684d06) Use HandleAuthenticateOnceSafeAsync in Cookie auth
* [`[926c7fab4b]`](https://github.com/aspnet/AspNetCore/commit/926c7fab4b) Use async-wait pattern in HandleAuthenticateOnceSafeAsync
* [`[0314632696]`](https://github.com/aspnet/AspNetCore/commit/0314632696) JwtBearer Token: Catch exception during unauthorized flow
* [`[e94f21ffc2]`](https://github.com/aspnet/AspNetCore/commit/e94f21ffc2) Moved content of 'shared' folder into MusicStore app and fixed tests
* [`[a40cc88169]`](https://github.com/aspnet/AspNetCore/commit/a40cc88169) IResponseCache adapter and support for vary by header
* [`[fa41588779]`](https://github.com/aspnet/AspNetCore/commit/fa41588779) Move server start failure test in MaxRequestLineSizeTests to KestrelServerTests.
* [`[663f6a1718]`](https://github.com/aspnet/AspNetCore/commit/663f6a1718) Expose `GetInputType` as a protected member of `InputTagHelper`.
* [`[e96f2cb738]`](https://github.com/aspnet/AspNetCore/commit/e96f2cb738) Set deployed application root folder as working directory
* [`[b8f21bee03]`](https://github.com/aspnet/AspNetCore/commit/b8f21bee03) Update warning code for obsolete property in #pragma.
* [`[be5deef584]`](https://github.com/aspnet/AspNetCore/commit/be5deef584) Created option for RequireHttpsAttribute.Permanent
* [`[78b5f53a6f]`](https://github.com/aspnet/AspNetCore/commit/78b5f53a6f) fix NuGetPackageVerifier.json
* [`[140dc6fcf5]`](https://github.com/aspnet/AspNetCore/commit/140dc6fcf5) Add obsoletion reason for KestrelServerOptions.MaxRequestBufferSize.
* [`[88de3d5070]`](https://github.com/aspnet/AspNetCore/commit/88de3d5070) StringRouteConstraint implementation
* [`[7052fa0ad2]`](https://github.com/aspnet/AspNetCore/commit/7052fa0ad2) Rephrased docs to clarify which are the parts you type into the command line
* [`[4665d1f458]`](https://github.com/aspnet/AspNetCore/commit/4665d1f458) docs(readme): Show how to get started with yeoman
* [`[a631f77a33]`](https://github.com/aspnet/AspNetCore/commit/a631f77a33) Copy only project.json before dotnet restore in Dockerfile templates
* [`[cf1a127e7d]`](https://github.com/aspnet/AspNetCore/commit/cf1a127e7d) Perform nodejs installation before COPY in Dockerfile templates
* [`[c07bd96270]`](https://github.com/aspnet/AspNetCore/commit/c07bd96270) Update generator-aspnetcore-spa version
* [`[a4a4e490c5]`](https://github.com/aspnet/AspNetCore/commit/a4a4e490c5) Addresses #678 and #679
* [`[9727a4db86]`](https://github.com/aspnet/AspNetCore/commit/9727a4db86) Improve the performance of connection filters
* [`[5aee524768]`](https://github.com/aspnet/AspNetCore/commit/5aee524768) Ensure Begin/End Read/Write methods are correctly implemented
* [`[4337d2a4a7]`](https://github.com/aspnet/AspNetCore/commit/4337d2a4a7) Implement Begin/End Read/Write methods in LibuvStream
* [`[ac8f751771]`](https://github.com/aspnet/AspNetCore/commit/ac8f751771) [Fixes #324] Diagnostics middleware no longer has a way to expand the source for compilation errors
* [`[8836eec7d8]`](https://github.com/aspnet/AspNetCore/commit/8836eec7d8) Limit request line length (#784).
* [`[dfe12223b8]`](https://github.com/aspnet/AspNetCore/commit/dfe12223b8) Ensure HTTPS handshake errors aren't logged on socket close
* [`[1020d69171]`](https://github.com/aspnet/AspNetCore/commit/1020d69171) Better logging for connection errors during HTTPS handshake
* [`[45f0fe178f]`](https://github.com/aspnet/AspNetCore/commit/45f0fe178f) import WebSockets code from CoreFX (#105)
* [`[44910bbd59]`](https://github.com/aspnet/AspNetCore/commit/44910bbd59) Use CoreFx managed WebSockets
* [`[e320755734]`](https://github.com/aspnet/AspNetCore/commit/e320755734) Do not run custom header parsers on null header values (#678)
* [`[20c1bb567d]`](https://github.com/aspnet/AspNetCore/commit/20c1bb567d) Move TestConnection to the Microsoft.AspNetCore.Testing namespace.
* [`[5876e1983a]`](https://github.com/aspnet/AspNetCore/commit/5876e1983a) Move TestConnection to shared directory.
* [`[52d9c0b336]`](https://github.com/aspnet/AspNetCore/commit/52d9c0b336) Added outline to buttons in developer exception page
* [`[484955f83e]`](https://github.com/aspnet/AspNetCore/commit/484955f83e) Make MessagePump constructor public for DI
* [`[f0732e9e21]`](https://github.com/aspnet/AspNetCore/commit/f0732e9e21) [Fixes #5038] HTTP Verbs mapping error GET and DELETE
* [`[4ece3f4b68]`](https://github.com/aspnet/AspNetCore/commit/4ece3f4b68) Change "String." to "string." to match coding convention
* [`[fc4a61586e]`](https://github.com/aspnet/AspNetCore/commit/fc4a61586e) Obsolete `EditorHints`.
* [`[e77dc3af6a]`](https://github.com/aspnet/AspNetCore/commit/e77dc3af6a) Implement manual state machine
* [`[d60ed06c19]`](https://github.com/aspnet/AspNetCore/commit/d60ed06c19) Add link tag attributes to generated fallback tags.
* [`[235ac59551]`](https://github.com/aspnet/AspNetCore/commit/235ac59551) API cleaup, organization
* [`[8d1e419a99]`](https://github.com/aspnet/AspNetCore/commit/8d1e419a99) Added ObsoleteAttribute to unused ViewEngine property
* [`[22492ed752]`](https://github.com/aspnet/AspNetCore/commit/22492ed752) [Fixes #319] It is not possible to copy text to clipboard from error message on development page.
* [`[2a6ab2be8c]`](https://github.com/aspnet/AspNetCore/commit/2a6ab2be8c) Add UpdateTokenValue API
* [`[c16fc06cb9]`](https://github.com/aspnet/AspNetCore/commit/c16fc06cb9) Modify warning about policy behavior (#924)
* [`[27a641f4bf]`](https://github.com/aspnet/AspNetCore/commit/27a641f4bf) Only create filters for models that need them (#5044)
* [`[d204adafd2]`](https://github.com/aspnet/AspNetCore/commit/d204adafd2) Add CI status to readme
* [`[7a3f24d49d]`](https://github.com/aspnet/AspNetCore/commit/7a3f24d49d) [Fixes #4960] Action results returned from controller actions rendered as json instead of executed
* [`[e815537907]`](https://github.com/aspnet/AspNetCore/commit/e815537907) Add ResponseCaching
* [`[935d15a15e]`](https://github.com/aspnet/AspNetCore/commit/935d15a15e) don't run Autobahn tests on Win7/Server2008 (#104)
* [`[1628d42b43]`](https://github.com/aspnet/AspNetCore/commit/1628d42b43) Clean up and update to post RTM
* [`[a14bb69d6a]`](https://github.com/aspnet/AspNetCore/commit/a14bb69d6a) Rough outline of middleware, sample, and test projects.
* [`[3d2e1c4d3e]`](https://github.com/aspnet/AspNetCore/commit/3d2e1c4d3e) Factoring out UrlGroup, ServerSession, RequestQueue, ChannelBinding, Disconnect Listener.
* [`[0a5f8e013e]`](https://github.com/aspnet/AspNetCore/commit/0a5f8e013e) AppDomain safety
* [`[3403eb7548]`](https://github.com/aspnet/AspNetCore/commit/3403eb7548) Make aspnet-webpack compatible with older versions of the NodeServices package
* [`[0a3463031b]`](https://github.com/aspnet/AspNetCore/commit/0a3463031b) Add Node.js support in all the Docker containers
* [`[e9ca434405]`](https://github.com/aspnet/AspNetCore/commit/e9ca434405) Update all templates to match latest "yo aspnet" output
* [`[de960d80aa]`](https://github.com/aspnet/AspNetCore/commit/de960d80aa) Allow explicit configuration of port number for webpack dev middleware server. Fixes #223.
* [`[14337e32ab]`](https://github.com/aspnet/AspNetCore/commit/14337e32ab) WebpackDevMiddleware now preserves client's view of hostname when doing 302 to /__webpack_hmr
* [`[698921d157]`](https://github.com/aspnet/AspNetCore/commit/698921d157) Update Dockerfile in all templates to match .NET Core 1.0 RTM. Fixes #120
* [`[c892f7da35]`](https://github.com/aspnet/AspNetCore/commit/c892f7da35) Support debugging when on IPv6 network (Node's "Debugger listening" message is phrased differently there)
* [`[763df65c14]`](https://github.com/aspnet/AspNetCore/commit/763df65c14) Revise if-else order in RemoteAuthenticateHandler
* [`[0e855b25a8]`](https://github.com/aspnet/AspNetCore/commit/0e855b25a8) Update Google and Microsoft Account Handler exception message
* [`[0d216d726a]`](https://github.com/aspnet/AspNetCore/commit/0d216d726a) Minor fixes in RemoteAuthenticationHandler and FacebookHandler
* [`[5092e75387]`](https://github.com/aspnet/AspNetCore/commit/5092e75387) Pin repo version to 1.0.1
* [`[e3e092ec60]`](https://github.com/aspnet/AspNetCore/commit/e3e092ec60) [Fixes #288] DeveloperExceptionPage needs better text spacing on OSX/Safari
* [`[f2f67fe880]`](https://github.com/aspnet/AspNetCore/commit/f2f67fe880) Support new config options to launch the Node process with a debug listener. This is compatible with node-inspector.
* [`[1c17bddc02]`](https://github.com/aspnet/AspNetCore/commit/1c17bddc02) Update HandleRemoteCallbackAsync readability
* [`[210c4b2061]`](https://github.com/aspnet/AspNetCore/commit/210c4b2061) Fix incorrect exception messages
* [`[6f46bc94f8]`](https://github.com/aspnet/AspNetCore/commit/6f46bc94f8) Sort using statements
* [`[5de4816f59]`](https://github.com/aspnet/AspNetCore/commit/5de4816f59) Update the RemoteAuthenticationHandler error handling
* [`[312edaafb4]`](https://github.com/aspnet/AspNetCore/commit/312edaafb4) Handle back channel failure gracefully
* [`[ecb3b90984]`](https://github.com/aspnet/AspNetCore/commit/ecb3b90984) Undo change to the GoogleDefaults
* [`[eabdd45816]`](https://github.com/aspnet/AspNetCore/commit/eabdd45816) Improve code readability for Authentication.Google
* [`[79872c1bde]`](https://github.com/aspnet/AspNetCore/commit/79872c1bde) Amend aspnet-webpack for better node-inspector support
* [`[2fe06ea784]`](https://github.com/aspnet/AspNetCore/commit/2fe06ea784) Make the dependency on es6-shim explicit, and include it in the vendor bundle
* [`[77b404188b]`](https://github.com/aspnet/AspNetCore/commit/77b404188b) fix angular's (click) events not being triggered on IE9
* [`[96228711f2]`](https://github.com/aspnet/AspNetCore/commit/96228711f2) chore(package): Update to rc4, beta router & universal 104.5
* [`[64a8ef1112]`](https://github.com/aspnet/AspNetCore/commit/64a8ef1112) Moving and updating "aspnet-webpack" package in templates (#207)
* [`[1bce0acfde]`](https://github.com/aspnet/AspNetCore/commit/1bce0acfde) Added asp-area to Components, _Layout and _LoginPartial links (Header links are broken in Admin area #666 )
* [`[184a25792a]`](https://github.com/aspnet/AspNetCore/commit/184a25792a) [Fixes #819] Display LoaderExceptions in ReflectionTypeLoadException
* [`[4600100695]`](https://github.com/aspnet/AspNetCore/commit/4600100695) Added a test to verify ReflectionTypeLoadException
* [`[1ac8ccafe2]`](https://github.com/aspnet/AspNetCore/commit/1ac8ccafe2) Regenerated ErrorPage.cs
* [`[f7641fa28b]`](https://github.com/aspnet/AspNetCore/commit/f7641fa28b) [Fixes #315] Display LoaderExceptions in ErrorPage
* [`[b5c117695e]`](https://github.com/aspnet/AspNetCore/commit/b5c117695e) Stop KestrelThreads in parallel
* [`[dc12f3150e]`](https://github.com/aspnet/AspNetCore/commit/dc12f3150e) Wait for graceful shutdown now that it usually works
* [`[496d94b41f]`](https://github.com/aspnet/AspNetCore/commit/496d94b41f) Fix cross appdomain exception
* [`[9a0ea424ea]`](https://github.com/aspnet/AspNetCore/commit/9a0ea424ea) Fix cross appdomain exception
* [`[0ab04d7e73]`](https://github.com/aspnet/AspNetCore/commit/0ab04d7e73) Tests to makes sure known strings are interned
* [`[51288e13f8]`](https://github.com/aspnet/AspNetCore/commit/51288e13f8) Enum to singular
* [`[0a1ea124ee]`](https://github.com/aspnet/AspNetCore/commit/0a1ea124ee) Use HttpVersionType enum rather than string compare
* [`[0620ce5a2f]`](https://github.com/aspnet/AspNetCore/commit/0620ce5a2f) Consolidate BadHttpRequestException messages
* [`[7c811ff568]`](https://github.com/aspnet/AspNetCore/commit/7c811ff568) Only allocate key string when unknown
* [`[49a48a0a33]`](https://github.com/aspnet/AspNetCore/commit/49a48a0a33) Mark `ValueProviderResultExtensions` as `[Obsolete]` - #4521
* [`[27f8c8dca2]`](https://github.com/aspnet/AspNetCore/commit/27f8c8dca2) Ensure libuv handles get disposed properly after binding errors
* [`[c4220c3d8c]`](https://github.com/aspnet/AspNetCore/commit/c4220c3d8c) Pass bigger buffer size to StreamCopyOperation.CopyToAsync (#148)
* [`[0e7967a7fc]`](https://github.com/aspnet/AspNetCore/commit/0e7967a7fc) Allocate things per KestrelThread instead of per listener
* [`[b4b2dd6bf2]`](https://github.com/aspnet/AspNetCore/commit/b4b2dd6bf2) Add buffer size parameter to CopyTo method (#674)
* [`[3c0e0f8d88]`](https://github.com/aspnet/AspNetCore/commit/3c0e0f8d88) Always throw same exception type on read after connection error (#975).
* [`[6bcf7643df]`](https://github.com/aspnet/AspNetCore/commit/6bcf7643df) Do not allocate large write task queues (#1005)
* [`[7b7e2889ce]`](https://github.com/aspnet/AspNetCore/commit/7b7e2889ce) Allocate less in GetIPEndPoint (#1004)
* [`[b955ec7743]`](https://github.com/aspnet/AspNetCore/commit/b955ec7743) Update shutdown logic for hosted applications
* [`[85ca3e4976]`](https://github.com/aspnet/AspNetCore/commit/85ca3e4976) Fix #4998 - Change lifetime of ViewComponentResultExecutor
* [`[aa385a1317]`](https://github.com/aspnet/AspNetCore/commit/aa385a1317) Use Environment.NewLine and Environment.StackTrace
* [`[7b8abf5a3e]`](https://github.com/aspnet/AspNetCore/commit/7b8abf5a3e) Improved Memoryblock tracking
* [`[b80f4d31f3]`](https://github.com/aspnet/AspNetCore/commit/b80f4d31f3) Add a test to verify our service lifetimes
* [`[bc76c0ef31]`](https://github.com/aspnet/AspNetCore/commit/bc76c0ef31) Fix #4998 - Resolve IViewComponentHelper every time
* [`[a1f8278381]`](https://github.com/aspnet/AspNetCore/commit/a1f8278381) Improve sample README
* [`[581a5ea573]`](https://github.com/aspnet/AspNetCore/commit/581a5ea573) column attribute for <textarea> is incorrect (#5049)
* [`[35cc5b6e83]`](https://github.com/aspnet/AspNetCore/commit/35cc5b6e83) Use `IValidationAttributeAdapterProvider` more often - #5009 - don't create a `RequiredAttributeAdapter` directly
* [`[6cd46a5c10]`](https://github.com/aspnet/AspNetCore/commit/6cd46a5c10) Remote auth expiration fix (#893)
* [`[749c7cb3ce]`](https://github.com/aspnet/AspNetCore/commit/749c7cb3ce) Add example of full-page prerendering via a custom action result
* [`[0240882031]`](https://github.com/aspnet/AspNetCore/commit/0240882031) Perf: Use RouteValueDictionary in AnchorTagHelper rather than creating a new Dictionary (#4941)
* [`[dde24fbba0]`](https://github.com/aspnet/AspNetCore/commit/dde24fbba0) Optimize ListStorage in RouteValueDictionary
* [`[52a7c112e8]`](https://github.com/aspnet/AspNetCore/commit/52a7c112e8) [Fixes #4876] ContentResult forcing chunked encoding
* [`[c5e09b0344]`](https://github.com/aspnet/AspNetCore/commit/c5e09b0344) Added a HttpResponseStreamWriter test for surrogate pairs
* [`[e5cb6f9595]`](https://github.com/aspnet/AspNetCore/commit/e5cb6f9595) Add `null` check for `ModelStateEntry.Children` - #4989
* [`[bdf9f8dd4e]`](https://github.com/aspnet/AspNetCore/commit/bdf9f8dd4e) Wait for connection in RequestTests.ConnectionResetAbortsRequest (#978).
* [`[41e50ba688]`](https://github.com/aspnet/AspNetCore/commit/41e50ba688) Enable all tests in HttpsConnectionFilterTests to run on all platforms
* [`[6801715daf]`](https://github.com/aspnet/AspNetCore/commit/6801715daf) Add support for IEnumerable<KeyValuePair<string, string>> in RouteValueDictionary Fixes #329 (#335)
* [`[854ffadc6a]`](https://github.com/aspnet/AspNetCore/commit/854ffadc6a) fix project reference
* [`[edf1f88398]`](https://github.com/aspnet/AspNetCore/commit/edf1f88398) Updating to AutoMapper 5.0
* [`[f4afb25a2d]`](https://github.com/aspnet/AspNetCore/commit/f4afb25a2d) Set ts-loader to "silent" mode until there's a fix for https://github.com/TypeStrong/ts-loader/issues/249
* [`[fae0a886af]`](https://github.com/aspnet/AspNetCore/commit/fae0a886af) Transfer multiline log messages from Node to .NET without treating each line as a separate log entry
* [`[f4efcacd40]`](https://github.com/aspnet/AspNetCore/commit/f4efcacd40) Switch to native .NET logging APIs
* [`[27ffa72e0d]`](https://github.com/aspnet/AspNetCore/commit/27ffa72e0d) Adding support for capturing the output of a node instance for custom logging implementations.
* [`[a14d9ba2df]`](https://github.com/aspnet/AspNetCore/commit/a14d9ba2df) Change onBeforeStartExternalProcess to a virtual method, so as to avoid expanding the set of constructor params in all hosting models
* [`[7119815d04]`](https://github.com/aspnet/AspNetCore/commit/7119815d04) Added OnBeforeStartExternalProcess callback which to NodeServicesOptions (and OutOfProcessNodeInstance, SocketNodeInstance and HttpNodeInstance) to configure environment of the node.exe process to be started, and the path to the node executable itself. Fixes #20
* [`[057efb43c8]`](https://github.com/aspnet/AspNetCore/commit/057efb43c8) aspnet-webpack module now preserves 'path' and 'publicPath' config settings when invoking Webpack compiler. Fixes #176.
* [`[14717f2a3f]`](https://github.com/aspnet/AspNetCore/commit/14717f2a3f) Always allocate the socket closed tcs
* [`[3bb7f4e2c4]`](https://github.com/aspnet/AspNetCore/commit/3bb7f4e2c4) Treat ECONNRESET as a connection error (#934).
* [`[91e94b1353]`](https://github.com/aspnet/AspNetCore/commit/91e94b1353) automate the autobahn test suite (#101)
* [`[fbcb5dcb1b]`](https://github.com/aspnet/AspNetCore/commit/fbcb5dcb1b) Prevent enumeration of queue during modification in SocketOutputTests
* [`[ed91ba0c2f]`](https://github.com/aspnet/AspNetCore/commit/ed91ba0c2f) - Fix a NullRef exception that was happening when projects have resx files - Print the changed file name in all cases
* [`[b7a0393311]`](https://github.com/aspnet/AspNetCore/commit/b7a0393311) Register DependencyContextRazorViewEngineOptionsSetup after RazorViewEngineOptionsSetup
* [`[8ec27958e7]`](https://github.com/aspnet/AspNetCore/commit/8ec27958e7) Replace Linq in hotpath (#5024)
* [`[c769d8dee9]`](https://github.com/aspnet/AspNetCore/commit/c769d8dee9) Fix null ref exception when referencing csproj
* [`[7e1aa4e1d0]`](https://github.com/aspnet/AspNetCore/commit/7e1aa4e1d0) Only test binding to "operational" network interfaces
* [`[6cee57752f]`](https://github.com/aspnet/AspNetCore/commit/6cee57752f) Update OpenIdConnectSample
* [`[310ab25347]`](https://github.com/aspnet/AspNetCore/commit/310ab25347) Make tests resilient to Localization (#5011)
* [`[e64b8e55e5]`](https://github.com/aspnet/AspNetCore/commit/e64b8e55e5) Add some multipart reader utilities to make reading streams easier
* [`[b132b69cb3]`](https://github.com/aspnet/AspNetCore/commit/b132b69cb3) Log stack trace when logging exceptions #198
* [`[8487bf0ae5]`](https://github.com/aspnet/AspNetCore/commit/8487bf0ae5) 14.28 If-Unmodified-Since - Incorrect condition
* [`[95796744c1]`](https://github.com/aspnet/AspNetCore/commit/95796744c1) Add scaffolding to the MVC sandbox - need more Tonka trucks
* [`[8a43be94ef]`](https://github.com/aspnet/AspNetCore/commit/8a43be94ef) AddressRegistrationTests should get local IPs from System.Net.NetworkInformation (#796)
* [`[61d03b9316]`](https://github.com/aspnet/AspNetCore/commit/61d03b9316) Update OIDC Azure Sample
* [`[d337bacc69]`](https://github.com/aspnet/AspNetCore/commit/d337bacc69) Add additional ifdefs to partial parsing tracing logic.
* [`[ef6533cf85]`](https://github.com/aspnet/AspNetCore/commit/ef6533cf85) Fixing wording/casing in command line tool output
* [`[b4677a44da]`](https://github.com/aspnet/AspNetCore/commit/b4677a44da)  #4847 Fix MapAreaRoute override existing area constraint (#4954)
* [`[150b4708f1]`](https://github.com/aspnet/AspNetCore/commit/150b4708f1) Fix PathString over-encoding
* [`[8bf0612411]`](https://github.com/aspnet/AspNetCore/commit/8bf0612411) Move PageGenerator to the tools dir
* [`[c1a1bdf373]`](https://github.com/aspnet/AspNetCore/commit/c1a1bdf373) Update React template homepage as per #158
* [`[01d5c90e23]`](https://github.com/aspnet/AspNetCore/commit/01d5c90e23) Include Microsoft.DotNet.Watcher.Tools in templates. Fixes #157
* [`[8b5136825c]`](https://github.com/aspnet/AspNetCore/commit/8b5136825c) Update remaining doc references to Invoke<T> and InvokeExport<T>
* [`[b0bc80b4d6]`](https://github.com/aspnet/AspNetCore/commit/b0bc80b4d6) Update docs around custom node instances to match latest API changes
* [`[3bc35aea21]`](https://github.com/aspnet/AspNetCore/commit/3bc35aea21) Simplify docs around receiving an INodeServices instance from DI
* [`[920f1c8bf3]`](https://github.com/aspnet/AspNetCore/commit/920f1c8bf3) Replace references to Invoke and InvokeExport with InvokeAsync and InvokeExportAsync throughout docs
* [`[4b38519001]`](https://github.com/aspnet/AspNetCore/commit/4b38519001) Change all links in docs to point to new main branch ('dev')
* [`[eec370e938]`](https://github.com/aspnet/AspNetCore/commit/eec370e938) Move file-watching logic into .NET to avoid Node's fs.watch issues on Windows (#128)
* [`[ce127f0d70]`](https://github.com/aspnet/AspNetCore/commit/ce127f0d70) Implement connection draining feature
* [`[be13f0b7bf]`](https://github.com/aspnet/AspNetCore/commit/be13f0b7bf) Centralise the child-process-terminating logic in NodeServicesImpl - don't also do it in OutOfProcessNodeInstance. This works towards connection draining.
* [`[26e8bd823c]`](https://github.com/aspnet/AspNetCore/commit/26e8bd823c) Instead of the Node process exiting instantly on file change, send a signal to .NET that it should restart. This is working towards the connection-draining feature.
* [`[a19e37f3c0]`](https://github.com/aspnet/AspNetCore/commit/a19e37f3c0) Move logic for restarting Node child process into NodeServicesImpl. Tidy up lots.
* [`[efa37e5590]`](https://github.com/aspnet/AspNetCore/commit/efa37e5590) Tidy up SampleApp.
* [`[7ce344270a]`](https://github.com/aspnet/AspNetCore/commit/7ce344270a) Show message about preserveCompilationContext when a Roslyn diagnostic error says a reference could not be found.
* [`[9f720eda90]`](https://github.com/aspnet/AspNetCore/commit/9f720eda90) Reset frame streams on each request (#940).
* [`[f4a2d6ea80]`](https://github.com/aspnet/AspNetCore/commit/f4a2d6ea80) Convert details -> div element
* [`[e960a55e82]`](https://github.com/aspnet/AspNetCore/commit/e960a55e82) Add support for showing failure summaries.
* [`[4fb3b18868]`](https://github.com/aspnet/AspNetCore/commit/4fb3b18868) Create new top-level DefaultNodeInstance concept that will soon hold the "connection draining" logic
* [`[ccff37126f]`](https://github.com/aspnet/AspNetCore/commit/ccff37126f) Removing extra imports from projects
* [`[4ee09cbe82]`](https://github.com/aspnet/AspNetCore/commit/4ee09cbe82) Make Http hosting model able to report exceptions that happened while locating the function to invoke
* [`[f8981185d9]`](https://github.com/aspnet/AspNetCore/commit/f8981185d9) Makes it possible to use absolute paths for publicPath in weback.config (#161)
* [`[9d16d2e9b5]`](https://github.com/aspnet/AspNetCore/commit/9d16d2e9b5) Use the scenario tool tested from testing common
* [`[4fe758240f]`](https://github.com/aspnet/AspNetCore/commit/4fe758240f) Added `ViewResultTest`s. (#4939)
* [`[01f247db48]`](https://github.com/aspnet/AspNetCore/commit/01f247db48) Prevent an unnecessary allocation of a state machine (thanks @PinpointTownes)
* [`[3ed0d01eae]`](https://github.com/aspnet/AspNetCore/commit/3ed0d01eae) Fix #4929 - Move IActionInvokerFactory from .Internal
* [`[0fec1424d5]`](https://github.com/aspnet/AspNetCore/commit/0fec1424d5) Added community project in the README.md
* [`[59b605cafb]`](https://github.com/aspnet/AspNetCore/commit/59b605cafb) Add UseWhenExtensions and UseWhenExtensionsTests
* [`[afd3bea80f]`](https://github.com/aspnet/AspNetCore/commit/afd3bea80f) Exception Page showing only method names in the callstack
* [`[dc35157f7a]`](https://github.com/aspnet/AspNetCore/commit/dc35157f7a) Use MethodDisplayInfo to display stack trace
* [`[21b3525933]`](https://github.com/aspnet/AspNetCore/commit/21b3525933) Make MultipleTriggers more stable
* [`[90dc4bc207]`](https://github.com/aspnet/AspNetCore/commit/90dc4bc207) [Fixes #324] Default parameters are not taken into account on attribute routing
* [`[0978a7dd16]`](https://github.com/aspnet/AspNetCore/commit/0978a7dd16) Add some tests, rename misnamed file
* [`[b6e2274163]`](https://github.com/aspnet/AspNetCore/commit/b6e2274163) In Redux templates, add .babelrc to publish output. Fixes #159
* [`[260a0d6bcb]`](https://github.com/aspnet/AspNetCore/commit/260a0d6bcb) Migrate entrypoint-http.js to TypeScript. Source is now HttpNodeInstanceEntryPoint.ts.
* [`[393e156b47]`](https://github.com/aspnet/AspNetCore/commit/393e156b47) Better reporting of Webpack compilation errors to fix #159
* [`[b82e70e192]`](https://github.com/aspnet/AspNetCore/commit/b82e70e192) Fix for prerendering hanging if webpack compilation fails
* [`[322e1f5d9c]`](https://github.com/aspnet/AspNetCore/commit/322e1f5d9c) Make routing feature class public
* [`[4986137ffe]`](https://github.com/aspnet/AspNetCore/commit/4986137ffe) Use filename* for files in multipart forms when available #651
* [`[c310c27ab8]`](https://github.com/aspnet/AspNetCore/commit/c310c27ab8) Make encoders registration optional (#140)
* [`[a852352223]`](https://github.com/aspnet/AspNetCore/commit/a852352223) Fix for https://github.com/aspnet/Mvc/issues/4903. (#4907)
* [`[5c04f0a831]`](https://github.com/aspnet/AspNetCore/commit/5c04f0a831) Use Angular lib instead of angular map file in sample (#92)
* [`[44bd5f195e]`](https://github.com/aspnet/AspNetCore/commit/44bd5f195e) Update readme regarding default transport
* [`[e51a118a9d]`](https://github.com/aspnet/AspNetCore/commit/e51a118a9d) Added consistent model property to view result variants (#4901)
* [`[8f2117cf89]`](https://github.com/aspnet/AspNetCore/commit/8f2117cf89) Upgrade Angular template to Angular 2 RC3 and migrate to new @angular/router
* [`[f1325d0cf2]`](https://github.com/aspnet/AspNetCore/commit/f1325d0cf2) Update 'templates' projects for .NET Core 1.0 RTM
* [`[eebf509846]`](https://github.com/aspnet/AspNetCore/commit/eebf509846) Update 'src' project dependencies for .NET Core 1.0 RTM
* [`[661677dca1]`](https://github.com/aspnet/AspNetCore/commit/661677dca1) Updating NuGet.config
* [`[b4822f90af]`](https://github.com/aspnet/AspNetCore/commit/b4822f90af) Updating NuGet.config
* [`[4c4167b6cb]`](https://github.com/aspnet/AspNetCore/commit/4c4167b6cb) Updating NuGet.config
* [`[c319ae51a5]`](https://github.com/aspnet/AspNetCore/commit/c319ae51a5) Changed min/max parameter order in StringLengthAttributeAdapter (#4899)
* [`[72dbda8804]`](https://github.com/aspnet/AspNetCore/commit/72dbda8804) Update to 1.0.1 version
* [`[3c0c02112d]`](https://github.com/aspnet/AspNetCore/commit/3c0c02112d) #659 Parse headers with consecutive commas
* [`[d19765802b]`](https://github.com/aspnet/AspNetCore/commit/d19765802b) Changed min/max parameter order in StringLengthAttributeAdapter
* [`[9263d63d2c]`](https://github.com/aspnet/AspNetCore/commit/9263d63d2c) Add net451 back so windows works and Unix skips net451
* [`[fc4f633e5e]`](https://github.com/aspnet/AspNetCore/commit/fc4f633e5e) Added centos and rhel rids to project.json
* [`[5af281a6dd]`](https://github.com/aspnet/AspNetCore/commit/5af281a6dd) Added rhel and centos rids to project.json
* [`[f63e53b597]`](https://github.com/aspnet/AspNetCore/commit/f63e53b597) Force 8-byte alignment on HTTP_REQUEST buffer
* [`[b8422416f5]`](https://github.com/aspnet/AspNetCore/commit/b8422416f5) Run tests on XPlat
* [`[fc7097c2fe]`](https://github.com/aspnet/AspNetCore/commit/fc7097c2fe) Publish Yeoman generators as version 0.1.9
* [`[8423233f44]`](https://github.com/aspnet/AspNetCore/commit/8423233f44) Update to angular2-universal 0.103.0 and amend boot-server.ts to fix "there can only be one platform" issue
* [`[ce6cdfd2bc]`](https://github.com/aspnet/AspNetCore/commit/ce6cdfd2bc) Templates should also publish node_modules, since it's used at runtime
* [`[7ddd4cacec]`](https://github.com/aspnet/AspNetCore/commit/7ddd4cacec) Amend all templates' project.json files to match current "yo aspnet" template content (plus the SPA-specific stuff)
* [`[73879918d4]`](https://github.com/aspnet/AspNetCore/commit/73879918d4) Add web.config to all templates (matching "yo aspnet" output)
* [`[6848e3a11d]`](https://github.com/aspnet/AspNetCore/commit/6848e3a11d) Fix templates' project.json scripts for compatibility with dotnet RC2 tooling and Azure
* [`[d3ded5bbdf]`](https://github.com/aspnet/AspNetCore/commit/d3ded5bbdf) Workaround for Yeoman generators not producing .gitignore files due to Yeoman issue #1862
* [`[6a8a4e8669]`](https://github.com/aspnet/AspNetCore/commit/6a8a4e8669) Update MemoryPoolBlock.cs
* [`[3db95ddcde]`](https://github.com/aspnet/AspNetCore/commit/3db95ddcde) As an American, I had to correct the spelling of 'independent'
* [`[7e51fc4480]`](https://github.com/aspnet/AspNetCore/commit/7e51fc4480) Update VS files (amended from laskoviymishka's commit 39f024)
* [`[6f8055b7bc]`](https://github.com/aspnet/AspNetCore/commit/6f8055b7bc) Update Yeoman generators to use aspnet-prerendering 1.0.2+ and publish as version 0.1.5
* [`[ea0a32a15b]`](https://github.com/aspnet/AspNetCore/commit/ea0a32a15b) Implement and document asp-prerender-data
* [`[1a53411046]`](https://github.com/aspnet/AspNetCore/commit/1a53411046) Fix some whitespace issues
* [`[bb53a94cfa]`](https://github.com/aspnet/AspNetCore/commit/bb53a94cfa) Fix #139 by pinning Angular 2 template to RC1
* [`[7b513de5c3]`](https://github.com/aspnet/AspNetCore/commit/7b513de5c3) Output "Application is shutting down" message
* [`[b4342b1604]`](https://github.com/aspnet/AspNetCore/commit/b4342b1604) Replace magic strings by the new constants introduced in IdentityModel
* [`[94fa34ca41]`](https://github.com/aspnet/AspNetCore/commit/94fa34ca41) TempData convenience property added to ViewComponent (#4873)
* [`[a2298021cd]`](https://github.com/aspnet/AspNetCore/commit/a2298021cd) Update to RTM versions
* [`[4f3d984f87]`](https://github.com/aspnet/AspNetCore/commit/4f3d984f87) Forgotten summary tag
* [`[219ef7450b]`](https://github.com/aspnet/AspNetCore/commit/219ef7450b) #106 Fix: Adds Secure Cookie flag and tests
* [`[d8d408638e]`](https://github.com/aspnet/AspNetCore/commit/d8d408638e) Updating to dev versions
* [`[eb2b58188a]`](https://github.com/aspnet/AspNetCore/commit/eb2b58188a) Updating to dev versions
* [`[de668c2ebd]`](https://github.com/aspnet/AspNetCore/commit/de668c2ebd) Updating to dev versions
* [`[cd7954a164]`](https://github.com/aspnet/AspNetCore/commit/cd7954a164) Updating to dev versions
* [`[dad4522ef3]`](https://github.com/aspnet/AspNetCore/commit/dad4522ef3) Updating to dev versions
* [`[38ba07487a]`](https://github.com/aspnet/AspNetCore/commit/38ba07487a) Updating to dev versions
* [`[10df99de67]`](https://github.com/aspnet/AspNetCore/commit/10df99de67) Updating to dev versions
* [`[e28e1df605]`](https://github.com/aspnet/AspNetCore/commit/e28e1df605) Updating to dev versions
* [`[0112361557]`](https://github.com/aspnet/AspNetCore/commit/0112361557) Updating to dev versions
* [`[2e63348580]`](https://github.com/aspnet/AspNetCore/commit/2e63348580) Updating to dev versions
* [`[2c264efd42]`](https://github.com/aspnet/AspNetCore/commit/2c264efd42) Updating to dev versions
* [`[c83fbdbf12]`](https://github.com/aspnet/AspNetCore/commit/c83fbdbf12) Updating to dev versions
* [`[36e5c0e6fa]`](https://github.com/aspnet/AspNetCore/commit/36e5c0e6fa) Updating to dev versions
* [`[fb09e5323c]`](https://github.com/aspnet/AspNetCore/commit/fb09e5323c) Updating to dev versions
* [`[20d608170e]`](https://github.com/aspnet/AspNetCore/commit/20d608170e) Updating to dev versions
* [`[66518476af]`](https://github.com/aspnet/AspNetCore/commit/66518476af) Updating to dev versions
* [`[ef0de2b6e7]`](https://github.com/aspnet/AspNetCore/commit/ef0de2b6e7) Updating to dev versions
* [`[67fe579e74]`](https://github.com/aspnet/AspNetCore/commit/67fe579e74) Updating to dev versions
* [`[a2857238f9]`](https://github.com/aspnet/AspNetCore/commit/a2857238f9) Updating to dev versions
* [`[69fa821522]`](https://github.com/aspnet/AspNetCore/commit/69fa821522) Updating to dev versions
* [`[f742566f3f]`](https://github.com/aspnet/AspNetCore/commit/f742566f3f) Updating to dev versions
* [`[eb74a19f9a]`](https://github.com/aspnet/AspNetCore/commit/eb74a19f9a) Added "451 Unavailable For Legal Reasons" to ReasonPhrases
* [`[6414ccc2fd]`](https://github.com/aspnet/AspNetCore/commit/6414ccc2fd) Added "308 Permanent Redirect" to ReasonPhrases
* [`[500b4f9ecc]`](https://github.com/aspnet/AspNetCore/commit/500b4f9ecc) Update Json.NET to 9.0.1
* [`[8f3d894b95]`](https://github.com/aspnet/AspNetCore/commit/8f3d894b95) #625 Changes Error Message when trying to reuse stream
* [`[a86db45a19]`](https://github.com/aspnet/AspNetCore/commit/a86db45a19) Update Json.NET to 9.0.1
* [`[20316e276c]`](https://github.com/aspnet/AspNetCore/commit/20316e276c) Update Json.NET to 9.0.1
* [`[76757ee82f]`](https://github.com/aspnet/AspNetCore/commit/76757ee82f) Update Json.NET to 9.0.1
* [`[70af8cf79e]`](https://github.com/aspnet/AspNetCore/commit/70af8cf79e) Update Json.NET to 9.0.1
* [`[6b7e27269c]`](https://github.com/aspnet/AspNetCore/commit/6b7e27269c) Update Json.NET to 9.0.1
* [`[d7d8af57f6]`](https://github.com/aspnet/AspNetCore/commit/d7d8af57f6) Update Json.NET to 9.0.1
* [`[69bf6ea08d]`](https://github.com/aspnet/AspNetCore/commit/69bf6ea08d) Update Json.NET to 9.0.1
* [`[3865136b97]`](https://github.com/aspnet/AspNetCore/commit/3865136b97) Added "451 Unavailable For Legal Reasons" to StatusCodes
* [`[0a3213ebaa]`](https://github.com/aspnet/AspNetCore/commit/0a3213ebaa) Added RFC 7538 support
* [`[2a1e6649b0]`](https://github.com/aspnet/AspNetCore/commit/2a1e6649b0) Added RFC 4918 support
* [`[a5ab80d403]`](https://github.com/aspnet/AspNetCore/commit/a5ab80d403) Updating to release.
* [`[cd33c4e908]`](https://github.com/aspnet/AspNetCore/commit/cd33c4e908) Updating to release.
* [`[fc2f0e480e]`](https://github.com/aspnet/AspNetCore/commit/fc2f0e480e) Updating to release.
* [`[c790b9f951]`](https://github.com/aspnet/AspNetCore/commit/c790b9f951) Updating to release.
* [`[36023d6dd5]`](https://github.com/aspnet/AspNetCore/commit/36023d6dd5) Updating to release.
* [`[05ce2b712c]`](https://github.com/aspnet/AspNetCore/commit/05ce2b712c) Updating to release.
* [`[1b15ec3869]`](https://github.com/aspnet/AspNetCore/commit/1b15ec3869) Updating to release.
* [`[716f0f7537]`](https://github.com/aspnet/AspNetCore/commit/716f0f7537) Updating to release.
* [`[9d14ded223]`](https://github.com/aspnet/AspNetCore/commit/9d14ded223) Updating to release.
* [`[028c7e2cec]`](https://github.com/aspnet/AspNetCore/commit/028c7e2cec) Updating to release.
* [`[3fc09ea482]`](https://github.com/aspnet/AspNetCore/commit/3fc09ea482) Updating to release.
* [`[7bb62a78eb]`](https://github.com/aspnet/AspNetCore/commit/7bb62a78eb) Updating to release.
* [`[de53e7566e]`](https://github.com/aspnet/AspNetCore/commit/de53e7566e) Updating to release.
* [`[3e80775179]`](https://github.com/aspnet/AspNetCore/commit/3e80775179) Updating to release.
* [`[02c7ef021f]`](https://github.com/aspnet/AspNetCore/commit/02c7ef021f) Updating to release.
* [`[c3b7ba4c9e]`](https://github.com/aspnet/AspNetCore/commit/c3b7ba4c9e) Updating to release.
* [`[7af884d4ea]`](https://github.com/aspnet/AspNetCore/commit/7af884d4ea) Updating to release.
* [`[13620507c9]`](https://github.com/aspnet/AspNetCore/commit/13620507c9) Updating to release.
* [`[2fffcb9da7]`](https://github.com/aspnet/AspNetCore/commit/2fffcb9da7) Updating to release.
* [`[3df9256f12]`](https://github.com/aspnet/AspNetCore/commit/3df9256f12) Updating to release.
* [`[288810c95c]`](https://github.com/aspnet/AspNetCore/commit/288810c95c) Updating to release.
* [`[e1f86a0c92]`](https://github.com/aspnet/AspNetCore/commit/e1f86a0c92) Updating to release.
* [`[2ffc31a7c6]`](https://github.com/aspnet/AspNetCore/commit/2ffc31a7c6) In ReactReduxSpa template, better report failure to match client-side routes
* [`[a881ca5b96]`](https://github.com/aspnet/AspNetCore/commit/a881ca5b96) Correctly set NODE_PATH when starting OutOfProcessNodeInstance
* [`[3fc19ea77b]`](https://github.com/aspnet/AspNetCore/commit/3fc19ea77b) Add missing lock to ensure thread-safe mutations of _activeInnerStreams in VirtualConnectionClient.cs
* [`[5ecb1f59a4]`](https://github.com/aspnet/AspNetCore/commit/5ecb1f59a4) Limit size of memory buffer when reading request (#304)
* [`[98feee9dbd]`](https://github.com/aspnet/AspNetCore/commit/98feee9dbd) Combine LargeMultipartUpload and LargeUpload into one test.
* [`[e20d18636e]`](https://github.com/aspnet/AspNetCore/commit/e20d18636e) Move more classes into Internal namespaces.
* [`[c72f8ac8bb]`](https://github.com/aspnet/AspNetCore/commit/c72f8ac8bb) Updated the dotnet CLI workaround for enabling standalone or portable apps to run in Nano
* [`[7298005887]`](https://github.com/aspnet/AspNetCore/commit/7298005887) Re-enable tests disabled due to corefx issue
* [`[f2c30472f2]`](https://github.com/aspnet/AspNetCore/commit/f2c30472f2) Link to more docs
* [`[0e2fb408d4]`](https://github.com/aspnet/AspNetCore/commit/0e2fb408d4) List features in README.md
* [`[11d6970e76]`](https://github.com/aspnet/AspNetCore/commit/11d6970e76) Copy edit README.md
* [`[f97b72baeb]`](https://github.com/aspnet/AspNetCore/commit/f97b72baeb) Rewrite repo README.md to link to other docs
* [`[dab67c817c]`](https://github.com/aspnet/AspNetCore/commit/dab67c817c) Copy edit SpaServices README.md
* [`[b4fd30dee7]`](https://github.com/aspnet/AspNetCore/commit/b4fd30dee7) Add links and syntax highlighting to SpaServices README.md
* [`[266ea8815b]`](https://github.com/aspnet/AspNetCore/commit/266ea8815b) Add SpaServices README.md
* [`[55e9adf84d]`](https://github.com/aspnet/AspNetCore/commit/55e9adf84d) Generate portable pdbs in coreclr
* [`[ccba161447]`](https://github.com/aspnet/AspNetCore/commit/ccba161447) Move `FileSystem` dependency from Razor to Razor.Runtime.
* [`[0f79bff98b]`](https://github.com/aspnet/AspNetCore/commit/0f79bff98b) Prevent NullReferenceException when disposing Context.Scope (#782).
* [`[b8b0d3894c]`](https://github.com/aspnet/AspNetCore/commit/b8b0d3894c) Try disabling running tests in parallel to fix DataProtectionProviderTests.System_UsesProvidedDirectoryAndCertificate failures
* [`[5339a3e0ce]`](https://github.com/aspnet/AspNetCore/commit/5339a3e0ce) Add ExceptionHandled to ExceptionContext (#4825)
* [`[8c8fd6446b]`](https://github.com/aspnet/AspNetCore/commit/8c8fd6446b) Use regular PDBs on full desktop when possible Add a test to verify exceptions thrown from views is pretty printed by diagnostics middleware
* [`[a8142b8858]`](https://github.com/aspnet/AspNetCore/commit/a8142b8858) Fix #4614 - update IModelBinder docs
* [`[b2c7469f17]`](https://github.com/aspnet/AspNetCore/commit/b2c7469f17) Fix Collection was modified exception in test
* [`[f1982bd987]`](https://github.com/aspnet/AspNetCore/commit/f1982bd987) Suppress default status code response type in api descriptions when explicit response types have been provided [Fixes #4823] How to override the default (200) status code with ProducesResponseType
* [`[62803d5979]`](https://github.com/aspnet/AspNetCore/commit/62803d5979) Serialize JSON using camel case by default - #4283 - update `JsonSerializerSettingsProvider` to choose the `CamelCaseNamingStrategy`
* [`[31ec88526a]`](https://github.com/aspnet/AspNetCore/commit/31ec88526a) Fix #4801 Rename ValidationExcludeFilter
* [`[baf0b6a5c7]`](https://github.com/aspnet/AspNetCore/commit/baf0b6a5c7) Fix #4803 - Move some types internal
* [`[22232bc1bf]`](https://github.com/aspnet/AspNetCore/commit/22232bc1bf) Fix incorrect import
* [`[b4632c273e]`](https://github.com/aspnet/AspNetCore/commit/b4632c273e) Handle exceptions thrown from Connection.Start in ListenerSecondary
* [`[ad9e22d42a]`](https://github.com/aspnet/AspNetCore/commit/ad9e22d42a) Update to preview2
* [`[aecfe778ee]`](https://github.com/aspnet/AspNetCore/commit/aecfe778ee) Improve handling of custom `ValidationAttribute`s and their `ValidationResult`s - #3595 sub-items 2 through 4 - handle an indexer name in `ValidationResult.MemberNames`  - aligns `ModelNames.CreatePropertyModelName()` with `TemplateInfo.GetFullHtmlFieldName()` - handle multiple elements in `ValidationResult.MemberNames`  - later elements previously ignored - set `ValidationContext.MemberName` to `null` when no property name is available  - using type name for a member name was just wrong
* [`[db4b0af98b]`](https://github.com/aspnet/AspNetCore/commit/db4b0af98b) Read environment variables by default #784
* [`[44c8b9985b]`](https://github.com/aspnet/AspNetCore/commit/44c8b9985b) Add language type annotations and fix links in NodeServices readme
* [`[f0ec89bbd9]`](https://github.com/aspnet/AspNetCore/commit/f0ec89bbd9) Add NodeServices docs
* [`[bfa281e24e]`](https://github.com/aspnet/AspNetCore/commit/bfa281e24e) Use aspnetexternal feed instead of CI share
* [`[c1dadbd723]`](https://github.com/aspnet/AspNetCore/commit/c1dadbd723) Make Bad Request tests more reliable
* [`[5a3875ea72]`](https://github.com/aspnet/AspNetCore/commit/5a3875ea72) Alter content negotiation algorithm so that it can be configured (via MvcOptions) to always respect an explicit Accept header. Fixes #4612.
* [`[e41b455141]`](https://github.com/aspnet/AspNetCore/commit/e41b455141) Update
* [`[7808a47ccc]`](https://github.com/aspnet/AspNetCore/commit/7808a47ccc) Use Sources RuntimeEnvironment
* [`[7af64a8944]`](https://github.com/aspnet/AspNetCore/commit/7af64a8944) Tidy up image resizing example
* [`[e58a4e4015]`](https://github.com/aspnet/AspNetCore/commit/e58a4e4015) Tidy up image credits
* [`[b19d0dff92]`](https://github.com/aspnet/AspNetCore/commit/b19d0dff92) Support streamed response from SocketNodeInstance
* [`[967edd2b2a]`](https://github.com/aspnet/AspNetCore/commit/967edd2b2a) Support streamed response from HttpNodeInstance
* [`[2e2784aa3d]`](https://github.com/aspnet/AspNetCore/commit/2e2784aa3d) [Design] Split up MvcRouteHandler
* [`[3440aa4344]`](https://github.com/aspnet/AspNetCore/commit/3440aa4344) Switch image resizing example from 'jimp' to 'sharp' because it's far faster
* [`[3e82d94f1c]`](https://github.com/aspnet/AspNetCore/commit/3e82d94f1c) Add image resizing example. Currently used base64 encoded data transfer and the 'jimp' module, neither of which are fast. Will replace these shortly.
* [`[8dbd143857]`](https://github.com/aspnet/AspNetCore/commit/8dbd143857) Move ES2015 example into a subpage of the NodeServicesExamples sample
* [`[facc2c6d08]`](https://github.com/aspnet/AspNetCore/commit/facc2c6d08) Rename ES2015Transpilation sample to NodeServicesExamples (because will be adding some more examples here)
* [`[c8859abeb7]`](https://github.com/aspnet/AspNetCore/commit/c8859abeb7) Fix #110 - enable asynchronous mode for Stream transport on Windows
* [`[3160b78f98]`](https://github.com/aspnet/AspNetCore/commit/3160b78f98) Update to Json.NET 9.0.1-beta1
* [`[2cf172c66e]`](https://github.com/aspnet/AspNetCore/commit/2cf172c66e) Update to Json.NET 9.0.1-beta1
* [`[62748b9471]`](https://github.com/aspnet/AspNetCore/commit/62748b9471) Update Json.NET to 9.0.1-beta1
* [`[badbc7c8f7]`](https://github.com/aspnet/AspNetCore/commit/badbc7c8f7) Downtarget Kestrel to NETStandard 1.3
* [`[933b374f3e]`](https://github.com/aspnet/AspNetCore/commit/933b374f3e) Update Json.NET to 9.0.1-beta1
* [`[b6ceac559a]`](https://github.com/aspnet/AspNetCore/commit/b6ceac559a) Update Json.NET to 9.0.1-beta1
* [`[808ee7e965]`](https://github.com/aspnet/AspNetCore/commit/808ee7e965) Fixed SelfHostDeployer and IISExpressDeployer to use the correct application path
* [`[772bd562c9]`](https://github.com/aspnet/AspNetCore/commit/772bd562c9) Fixed RemoteWindowsDeployer to support IIS scenarios
* [`[50e8948bb9]`](https://github.com/aspnet/AspNetCore/commit/50e8948bb9) Fixing BadRequest tests to not try sending data after Bad Request
* [`[e1093651ba]`](https://github.com/aspnet/AspNetCore/commit/e1093651ba) Target netstandard1.3
* [`[3fc1fef2be]`](https://github.com/aspnet/AspNetCore/commit/3fc1fef2be) #573 Rename UriHelper.Encode
* [`[cb27e74fc9]`](https://github.com/aspnet/AspNetCore/commit/cb27e74fc9) Target netstandard1.3
* [`[69bd0dc4be]`](https://github.com/aspnet/AspNetCore/commit/69bd0dc4be) Reject requests that have null characters in path
* [`[78c130d226]`](https://github.com/aspnet/AspNetCore/commit/78c130d226) Fix for #4666 - reduce modelbinders created
* [`[40f0bb1b45]`](https://github.com/aspnet/AspNetCore/commit/40f0bb1b45) Added IIS variation to Nano smoke tests
* [`[2bbaa52b08]`](https://github.com/aspnet/AspNetCore/commit/2bbaa52b08) Disable ThreadCountTests on Mac.
* [`[d02f67785f]`](https://github.com/aspnet/AspNetCore/commit/d02f67785f) Use Microsoft.Extensions.StackTrace.Sources
* [`[b7c924b449]`](https://github.com/aspnet/AspNetCore/commit/b7c924b449) Use Microsoft.Extensions.StackTrace.Sources
* [`[09f5be1434]`](https://github.com/aspnet/AspNetCore/commit/09f5be1434) fix #909 by moving most classes to Internal ns
* [`[120021e8a3]`](https://github.com/aspnet/AspNetCore/commit/120021e8a3) Add a new IncludeErrorDetails option to prevent the JWT middleware from returning error/error_description
* [`[35d0592701]`](https://github.com/aspnet/AspNetCore/commit/35d0592701) Make AuthorizationHandler<TReq> async only
* [`[2256138650]`](https://github.com/aspnet/AspNetCore/commit/2256138650) Update Json.NET to 9.0.1-beta1
* [`[0f1836c6dd]`](https://github.com/aspnet/AspNetCore/commit/0f1836c6dd) Update Json.NET to 9.0.1-beta1
* [`[3f78743011]`](https://github.com/aspnet/AspNetCore/commit/3f78743011) Update Json.NET to 9.0.1-beta1
* [`[dd79d0b88c]`](https://github.com/aspnet/AspNetCore/commit/dd79d0b88c) [Fixes #316] TreeRouter does not match a route with the correct length
* [`[47d3ffdddc]`](https://github.com/aspnet/AspNetCore/commit/47d3ffdddc) Add activator fallback to support rc1 keys
* [`[ef74926463]`](https://github.com/aspnet/AspNetCore/commit/ef74926463) Fixing a test failing on Mac and Linux
* [`[d14f18012a]`](https://github.com/aspnet/AspNetCore/commit/d14f18012a) Avoid Null ReferenceException in Frame.RequestAbortedSource
* [`[07744e75d9]`](https://github.com/aspnet/AspNetCore/commit/07744e75d9) Gracefully handle connection close in SocketOutput.ProducingComplete
* [`[2d229e8980]`](https://github.com/aspnet/AspNetCore/commit/2d229e8980) Allow a maximum of 3 concurrent uv_write operations per connection
* [`[0342754c57]`](https://github.com/aspnet/AspNetCore/commit/0342754c57) Using the optimized method for converting header name to ASCII
* [`[de022b6051]`](https://github.com/aspnet/AspNetCore/commit/de022b6051) Improved handling of whitespace in headers.
* [`[53b890aab5]`](https://github.com/aspnet/AspNetCore/commit/53b890aab5) Fix filename for DefaultPropertyFilterProvider
* [`[6e46d9757d]`](https://github.com/aspnet/AspNetCore/commit/6e46d9757d) Improve perf of TryGetAsciiString
* [`[5f36adbee3]`](https://github.com/aspnet/AspNetCore/commit/5f36adbee3) Fix filename for ModelValidatorProviderContext (fixes #4798)
* [`[56dca7e0bc]`](https://github.com/aspnet/AspNetCore/commit/56dca7e0bc) Add a 'sid' check to the OIDC middleware to prevent unsolicited logout when possible
* [`[263d764215]`](https://github.com/aspnet/AspNetCore/commit/263d764215) Fix assembly metadata to fix package verifier warnings
* [`[a3b2a7b62b]`](https://github.com/aspnet/AspNetCore/commit/a3b2a7b62b) Fix package verifier warnings
* [`[d7206dee8d]`](https://github.com/aspnet/AspNetCore/commit/d7206dee8d) Disable a test that hangs
* [`[6e36bbe32c]`](https://github.com/aspnet/AspNetCore/commit/6e36bbe32c) Add negative path tests.
* [`[51c285574b]`](https://github.com/aspnet/AspNetCore/commit/51c285574b) Add `AdditionalCompilationReferences` option to `RazorViewEngineOptions`.
* [`[29bc240044]`](https://github.com/aspnet/AspNetCore/commit/29bc240044) Fix a timing issue in the polling watcher
* [`[f609f41a7c]`](https://github.com/aspnet/AspNetCore/commit/f609f41a7c) Reject non-ASCII chars in headers in addition to control chars
* [`[bb92cc1c29]`](https://github.com/aspnet/AspNetCore/commit/bb92cc1c29) Fix NRE when aborting connection or client disconects
* [`[8b3c308c22]`](https://github.com/aspnet/AspNetCore/commit/8b3c308c22) Limit value number instead of key number in form reader
* [`[0d471b827b]`](https://github.com/aspnet/AspNetCore/commit/0d471b827b) Update NetStandard.Library version
* [`[3b9539960b]`](https://github.com/aspnet/AspNetCore/commit/3b9539960b) [Perf] Preallocate TagHelperAttributes for simple bound string valued attributes Fixes #704
* [`[311733b113]`](https://github.com/aspnet/AspNetCore/commit/311733b113) Fix references to socket APIs, and target the lowest net standard versions possible
* [`[931ba118e1]`](https://github.com/aspnet/AspNetCore/commit/931ba118e1) net451 support and changed netcoreapp1.0->netstandard1.5 for libraries
* [`[50ee405656]`](https://github.com/aspnet/AspNetCore/commit/50ee405656) Workaround for a bug in .NET Core. This issue is referenced by #92. It is has been reported to the dotnet corefx team here: dotnet/corefx#8809 The issue won't be resolved in 1.0.0, so @stephentoub recommended that we reuse the HttpClient.
* [`[341cd4f1cb]`](https://github.com/aspnet/AspNetCore/commit/341cd4f1cb) Implement SocketNodeInstance
* [`[32ebaecdd8]`](https://github.com/aspnet/AspNetCore/commit/32ebaecdd8) Define DefaultNodeHostingModel in one common place so it can be changed easily
* [`[e299695974]`](https://github.com/aspnet/AspNetCore/commit/e299695974) #776 Show some JwtBearer errors in response headers
* [`[c9f8455dbc]`](https://github.com/aspnet/AspNetCore/commit/c9f8455dbc) Update sample ADAL dependency
* [`[6a6d2e0d9f]`](https://github.com/aspnet/AspNetCore/commit/6a6d2e0d9f) [Fixes #4506] Move and rename ActionDescriptor.Name to ControllerActionDescriptor.ActionName
* [`[5f4ca4fa66]`](https://github.com/aspnet/AspNetCore/commit/5f4ca4fa66) [Fixes #4223] Added a facade for ViewComponentResult
* [`[8493064fe5]`](https://github.com/aspnet/AspNetCore/commit/8493064fe5) [Fixes #4207] Review IActionResult classes and add facades as necessary. * Moved FileResults to use executor façades * Changed redirect result types to use executor façades.
* [`[44f0aa63c6]`](https://github.com/aspnet/AspNetCore/commit/44f0aa63c6) Do not HTML encode while checking for whitespace - #760 - using a `NullHtmlEncoder` improves `TagHelperContent.IsEmptyOrWhiteSpace` semantics  - e.g. a tab is still a tab after encoding  - also avoids `NotImplementedException` - implement `Write(char)` for char-by-char `IHtmlContent` corner case
* [`[bcdd3147a1]`](https://github.com/aspnet/AspNetCore/commit/bcdd3147a1) Fixing "Error -4092 EACCES permission denied" in tests
* [`[13a3bbaeb6]`](https://github.com/aspnet/AspNetCore/commit/13a3bbaeb6) Update AuthZ test
* [`[0753f06c28]`](https://github.com/aspnet/AspNetCore/commit/0753f06c28) Aborting request if a string can't be converted to ASCII
* [`[1433822ec8]`](https://github.com/aspnet/AspNetCore/commit/1433822ec8) Fix OS platform check in SelfHostDeployer
* [`[50208a3a79]`](https://github.com/aspnet/AspNetCore/commit/50208a3a79) Implement IHttpRequestFeature.RawTarget (aspnet/HttpAbstractions#596).
* [`[283573d6c9]`](https://github.com/aspnet/AspNetCore/commit/283573d6c9) [Fixes #4291] Simplified MvcRouteHandler code
* [`[6e8a5ad1e9]`](https://github.com/aspnet/AspNetCore/commit/6e8a5ad1e9) Print better error messages if project.json fails to parse
* [`[290e1e3f3f]`](https://github.com/aspnet/AspNetCore/commit/290e1e3f3f) improve validation of HTTP methods
* [`[720289a539]`](https://github.com/aspnet/AspNetCore/commit/720289a539) Fix Nano server tests to copy the dotnet runtime only when RUN_TESTS_ON_NANO environment variable is true
* [`[c7a46e4caf]`](https://github.com/aspnet/AspNetCore/commit/c7a46e4caf) AuthPolicy should use IPolicyProvider
* [`[c257c9528f]`](https://github.com/aspnet/AspNetCore/commit/c257c9528f) AuthZ: Combine needs to use policy provider
* [`[55d2ef02b1]`](https://github.com/aspnet/AspNetCore/commit/55d2ef02b1) Implement IHttpRequestFeature.RawTarget.
* [`[d692066b2b]`](https://github.com/aspnet/AspNetCore/commit/d692066b2b) Replace PlatformAbstractions with RuntimeInformation
* [`[22175e03a7]`](https://github.com/aspnet/AspNetCore/commit/22175e03a7) Fixed SmokeTestsOnNanoServer to provide dotent runtime to enable testing portable scenario
* [`[306084356e]`](https://github.com/aspnet/AspNetCore/commit/306084356e) ServerAddress.FromUrl() should throw if Host is missing (#860)
* [`[bb3555c3dc]`](https://github.com/aspnet/AspNetCore/commit/bb3555c3dc) Fixed RemoteWindowsDeployer to copy dontet runtime to target server for enabling portable apps scenario
* [`[0025724433]`](https://github.com/aspnet/AspNetCore/commit/0025724433) Replace PlatformAbstractions with RuntimeInformation
* [`[f60aa7aa70]`](https://github.com/aspnet/AspNetCore/commit/f60aa7aa70) Replace some of PlatformAbstractions with RuntimeInformation
* [`[31a6a126e3]`](https://github.com/aspnet/AspNetCore/commit/31a6a126e3) Always overwrite stdoutLogPath when publishing for Azure
* [`[060a1c8f5a]`](https://github.com/aspnet/AspNetCore/commit/060a1c8f5a) Replace PlatformAbstractions with RuntimeInformation
* [`[6b25ee7343]`](https://github.com/aspnet/AspNetCore/commit/6b25ee7343) Replace PlatformAbstractions with RuntimeInformation
* [`[8212694874]`](https://github.com/aspnet/AspNetCore/commit/8212694874) Add RawTarget property to IHttpRequestFeature (#596).
* [`[0a181b1f3f]`](https://github.com/aspnet/AspNetCore/commit/0a181b1f3f) Reset Frame's IHttpRequestFeature.Headers and IHttpResponseFeature.Headers between requests (#879).
* [`[acb8732ffd]`](https://github.com/aspnet/AspNetCore/commit/acb8732ffd) Replace PlatformAbstractions with RuntimeInformation
* [`[f45e533533]`](https://github.com/aspnet/AspNetCore/commit/f45e533533) Update metadata
* [`[4fccbeebdc]`](https://github.com/aspnet/AspNetCore/commit/4fccbeebdc) Update metadata
* [`[6d3a416f0e]`](https://github.com/aspnet/AspNetCore/commit/6d3a416f0e) Test code nitpicks.
* [`[871885259b]`](https://github.com/aspnet/AspNetCore/commit/871885259b) Update the OIDC AzureAd sample.
* [`[d6763bd77c]`](https://github.com/aspnet/AspNetCore/commit/d6763bd77c) #423 Support distributed sign-out.
* [`[cea5fbbafa]`](https://github.com/aspnet/AspNetCore/commit/cea5fbbafa) Fix disabled tests in MultipleLoopTests.
* [`[e14f4b095d]`](https://github.com/aspnet/AspNetCore/commit/e14f4b095d) Track `TagHelperAttribute` quotes.
* [`[2453047fe2]`](https://github.com/aspnet/AspNetCore/commit/2453047fe2) ServerAddress.FromUrl() should throw for invalid url (#875)
* [`[ce8d23d3e5]`](https://github.com/aspnet/AspNetCore/commit/ce8d23d3e5) Update sample
* [`[dda9376a0c]`](https://github.com/aspnet/AspNetCore/commit/dda9376a0c) Perf: More efficient range header checks.
* [`[c63f02c19f]`](https://github.com/aspnet/AspNetCore/commit/c63f02c19f) Optimize form reader allocations
* [`[bf5f6b9275]`](https://github.com/aspnet/AspNetCore/commit/bf5f6b9275) Updating to netstandard1.6 Fixes https://github.com/aspnet/Coherence/issues/101
* [`[bb226aef6b]`](https://github.com/aspnet/AspNetCore/commit/bb226aef6b) Update Mvc.Core and dependencies to netstandard1.6
* [`[b6794ab1b7]`](https://github.com/aspnet/AspNetCore/commit/b6794ab1b7) Fixed null reference on ModelStateDictionary.ChildNodes when calling Clear
* [`[526f22f072]`](https://github.com/aspnet/AspNetCore/commit/526f22f072) Rename the environment variable used for polling watcher
* [`[2634fe318d]`](https://github.com/aspnet/AspNetCore/commit/2634fe318d) #814 Rework CookieAuth for compat with CookiePolicy.
* [`[be7069b198]`](https://github.com/aspnet/AspNetCore/commit/be7069b198) Fixed RemoteWindowsDeployer for testing portable apps and temporary workaround for a dotnet cli issue
* [`[8ab32c44f7]`](https://github.com/aspnet/AspNetCore/commit/8ab32c44f7) Make RestartProcessThatTerminatesAfterFileChange more reliable
* [`[cc9873ae6c]`](https://github.com/aspnet/AspNetCore/commit/cc9873ae6c) Unique-ify extension types to not be ambiguous.
* [`[54d9860eea]`](https://github.com/aspnet/AspNetCore/commit/54d9860eea) Rename `ServiceCollectionExtensions` to `AntiforgeryServiceCollectionExtensions`.
* [`[07d504cf9a]`](https://github.com/aspnet/AspNetCore/commit/07d504cf9a) Update the project.json metadata
* [`[72cc0ffbd5]`](https://github.com/aspnet/AspNetCore/commit/72cc0ffbd5) Set Date and Server headers at response start
* [`[d1bacbf41e]`](https://github.com/aspnet/AspNetCore/commit/d1bacbf41e) Fix makefile.
* [`[a3d0bd0ec4]`](https://github.com/aspnet/AspNetCore/commit/a3d0bd0ec4) Bind to both IPv4 and IPv6 when localhost is specified (#231).
* [`[d45cfd872f]`](https://github.com/aspnet/AspNetCore/commit/d45cfd872f) Don't break the CI.
* [`[5d72a7f747]`](https://github.com/aspnet/AspNetCore/commit/5d72a7f747) Modify ICompilationLibrariesProvider to return a sequence of reference path
* [`[3d0f436a06]`](https://github.com/aspnet/AspNetCore/commit/3d0f436a06) [Fixes #4294] TypeActivate MvcRouteHandler
* [`[b96851ec20]`](https://github.com/aspnet/AspNetCore/commit/b96851ec20) [Perf] Avoid ViewBuffers for writing bound TagHelper attribute values. Fixes aspnet/Razor#717
* [`[bde78dc3d4]`](https://github.com/aspnet/AspNetCore/commit/bde78dc3d4) [Perf]: Avoid ViewBuffers for writing bound TagHelper attribute values Fixes #717
* [`[149fbfa99a]`](https://github.com/aspnet/AspNetCore/commit/149fbfa99a) Reenable disabled tests #673
* [`[ed85f504d8]`](https://github.com/aspnet/AspNetCore/commit/ed85f504d8) #102 Filter out DEBUG requests under the debugger.
* [`[3f4e2323f4]`](https://github.com/aspnet/AspNetCore/commit/3f4e2323f4) Throw when setting Frame.StatusCode or Frame.ReasonPhrase after response has already started (#805).
* [`[cb284b9d58]`](https://github.com/aspnet/AspNetCore/commit/cb284b9d58) Fix race that would allow GetDateHeaderValues to return null
* [`[63bbafdb1d]`](https://github.com/aspnet/AspNetCore/commit/63bbafdb1d) Simplify watcher arguments by passing everything to dotnet
* [`[f54a964815]`](https://github.com/aspnet/AspNetCore/commit/f54a964815) AuthZFilter should call into Service more
* [`[0e4d154134]`](https://github.com/aspnet/AspNetCore/commit/0e4d154134) Update PinVersion tool use dotnet and v3 NuGet packages
* [`[90f0e29923]`](https://github.com/aspnet/AspNetCore/commit/90f0e29923) Inject the IRazorViewEngine directory instead of using GetRequiredService
* [`[ab76f743f4]`](https://github.com/aspnet/AspNetCore/commit/ab76f743f4) Use dependency context from all application parts when compiling views
* [`[27565c4e8d]`](https://github.com/aspnet/AspNetCore/commit/27565c4e8d) Fix broken query string binding test
* [`[1f8f82463a]`](https://github.com/aspnet/AspNetCore/commit/1f8f82463a) disable two failed tests temporarily
* [`[80ebb4a068]`](https://github.com/aspnet/AspNetCore/commit/80ebb4a068) Update `TagHelperDirectiveSpanVisitor` to properly capture TagHelper directive text.
* [`[69e029fc79]`](https://github.com/aspnet/AspNetCore/commit/69e029fc79) Update the namespace for Razor generated code to AspNetCore Fixes #4476
* [`[a49ba744aa]`](https://github.com/aspnet/AspNetCore/commit/a49ba744aa) Reduce Revision check calls via interface
* [`[8ab66ab5ce]`](https://github.com/aspnet/AspNetCore/commit/8ab66ab5ce) Fix resource generation to work with dotnet test
* [`[e854d3aa9a]`](https://github.com/aspnet/AspNetCore/commit/e854d3aa9a) Allow query string parameters without values
* [`[fa3a0e7c7a]`](https://github.com/aspnet/AspNetCore/commit/fa3a0e7c7a) #140 Disable header symmetry check on azure.
* [`[d92b3ba2c6]`](https://github.com/aspnet/AspNetCore/commit/d92b3ba2c6) Make ModelBindingContext.Result non-nullable
* [`[5ca6592677]`](https://github.com/aspnet/AspNetCore/commit/5ca6592677) Don't bind if only port is specified (#814) (#861)
* [`[dc9feade5a]`](https://github.com/aspnet/AspNetCore/commit/dc9feade5a) Disable `Microsoft.DotNet.Watcher.Tools.FunctionalTests.NoDepsAppTests.RestartProcessThatTerminatesAfterFileChange` - test is not reliable (95% success rate) - should be restored as part of #98
* [`[59fc691f41]`](https://github.com/aspnet/AspNetCore/commit/59fc691f41) #667 #801 Handle authorize and forbid for redirecting handlers.
* [`[db7009531a]`](https://github.com/aspnet/AspNetCore/commit/db7009531a) Update google token endpoint to v4
* [`[bfbe7ec15d]`](https://github.com/aspnet/AspNetCore/commit/bfbe7ec15d) Update fb to v2.6
* [`[440c6e43e1]`](https://github.com/aspnet/AspNetCore/commit/440c6e43e1) Minor rewording missed from PR
* [`[d61c5100c9]`](https://github.com/aspnet/AspNetCore/commit/d61c5100c9) Handle cache unreliability #99
* [`[6d91a160b6]`](https://github.com/aspnet/AspNetCore/commit/6d91a160b6) Add IsAvailable property to ISession #634
* [`[e7b8c3f90a]`](https://github.com/aspnet/AspNetCore/commit/e7b8c3f90a) Support ASPNETCORE_URLS to set server urls - Read both urls and server.urls in WebHost - UseUrls now sets urls instead of server.urls
* [`[057bcb43ac]`](https://github.com/aspnet/AspNetCore/commit/057bcb43ac) Move extension methods to Hosting.Abstractions - - Moved everything that could be moved to Hosting.Abstractions
* [`[6098880132]`](https://github.com/aspnet/AspNetCore/commit/6098880132) Reset connection info not using interface
* [`[925d8e0200]`](https://github.com/aspnet/AspNetCore/commit/925d8e0200) Always cache headers and streams across frames (#754).
* [`[156a010646]`](https://github.com/aspnet/AspNetCore/commit/156a010646) Call use-local-coherence as part of CI-test
* [`[39225f17c4]`](https://github.com/aspnet/AspNetCore/commit/39225f17c4) Downgrade Server.Testing version to 0.1
* [`[ed687d08b6]`](https://github.com/aspnet/AspNetCore/commit/ed687d08b6) Downgrade Server.Testing version to 0.1
* [`[87e3544fda]`](https://github.com/aspnet/AspNetCore/commit/87e3544fda) Downgrade Server.Testing version to 0.1
* [`[bdc3959938]`](https://github.com/aspnet/AspNetCore/commit/bdc3959938) Downgrade Server.Testing version to 0.1
* [`[504a825406]`](https://github.com/aspnet/AspNetCore/commit/504a825406) Fix owin spec links
* [`[230a13d0e1]`](https://github.com/aspnet/AspNetCore/commit/230a13d0e1) [Fixes #4633] Datetime? and DateTimeOffset? values on InputTagHelper are not rendered correctly.
* [`[ee2a591d2c]`](https://github.com/aspnet/AspNetCore/commit/ee2a591d2c) [Fixes #4655] Make comparisons in DefaultAssemblyPartDiscoveryProvider case insensitive
* [`[a490cf13a6]`](https://github.com/aspnet/AspNetCore/commit/a490cf13a6) [Fixes #4555] Assemblies with a transitive dependency to MVC are not included as part of the list of discovered assemblies
* [`[99bc05c7d7]`](https://github.com/aspnet/AspNetCore/commit/99bc05c7d7) [Fixes #663] Replace 'web' with 'MusicStore' in launchSettings.json
* [`[dabd28a5d9]`](https://github.com/aspnet/AspNetCore/commit/dabd28a5d9) #105 Use DataProtection to encrypt the cookie
* [`[93be3dee6e]`](https://github.com/aspnet/AspNetCore/commit/93be3dee6e) Fix FormTagHelper to set flag indicating generation of AntiforgeryToken [Fixes #4595] Better error message with extraneous @Html.AntiforgeryToken
* [`[20a2e748ec]`](https://github.com/aspnet/AspNetCore/commit/20a2e748ec) Added ValueProviderFactories to ResourceFilterExecutingContext This enables removing value provider factories from model binding(which is needed in some scenarios like large file uploads)
* [`[5eb1466487]`](https://github.com/aspnet/AspNetCore/commit/5eb1466487) Fast-path response header connection check
* [`[df4eb283b2]`](https://github.com/aspnet/AspNetCore/commit/df4eb283b2) [Perf] UrlHelper shares a single RouteValueDictionary across several calls to Action and RouteUrl methods
* [`[86567e1d93]`](https://github.com/aspnet/AspNetCore/commit/86567e1d93) Fix engine test.
* [`[f7b2ee80fd]`](https://github.com/aspnet/AspNetCore/commit/f7b2ee80fd) [Fixes #4550] Add an Option to set the Razor view location formats
* [`[59b2b9d66c]`](https://github.com/aspnet/AspNetCore/commit/59b2b9d66c) Use expanded Coherence directory for ci-test
* [`[b17c070e1c]`](https://github.com/aspnet/AspNetCore/commit/b17c070e1c) Updated to not use handle, centralize conversion logic.
* [`[9232029950]`](https://github.com/aspnet/AspNetCore/commit/9232029950) Use SslStream.RemoteCertificate to recreate disposed certificate.
* [`[43c75c922e]`](https://github.com/aspnet/AspNetCore/commit/43c75c922e) Allow functional tests with content to run from VS Fixes #4543
* [`[14251d55a5]`](https://github.com/aspnet/AspNetCore/commit/14251d55a5) Fix schema change warnings
* [`[9a06bf39ab]`](https://github.com/aspnet/AspNetCore/commit/9a06bf39ab) Move ECONNRESET value check to server initialization.
* [`[e8faec59f0]`](https://github.com/aspnet/AspNetCore/commit/e8faec59f0) Fixing schema change warnings
* [`[61883b5101]`](https://github.com/aspnet/AspNetCore/commit/61883b5101) Fix more schema warnings in Mvc
* [`[74357b3ed8]`](https://github.com/aspnet/AspNetCore/commit/74357b3ed8) [Perf]  Fast Generate Url for specific cases to avoid string allocations
* [`[0f8542e4b2]`](https://github.com/aspnet/AspNetCore/commit/0f8542e4b2) Throw a more descriptive exception for missing CORS policies
* [`[3595452af7]`](https://github.com/aspnet/AspNetCore/commit/3595452af7) Change priority for request token source lookup. Header token now takes priority over form field token.
* [`[941da9264b]`](https://github.com/aspnet/AspNetCore/commit/941da9264b) Move ModelBindingHelper to Internal (#4664)
* [`[e1c64d2119]`](https://github.com/aspnet/AspNetCore/commit/e1c64d2119) reuse typeof results in generated Frame code
* [`[185ad000bb]`](https://github.com/aspnet/AspNetCore/commit/185ad000bb) Prevent NullReferenceException in KestrelThread.OnStopRude
* [`[2c35945562]`](https://github.com/aspnet/AspNetCore/commit/2c35945562) Update project name in README.md
* [`[60e4e3a3f3]`](https://github.com/aspnet/AspNetCore/commit/60e4e3a3f3) Rename NodeServices.sln to JavaScriptServices.sln
* [`[8c8ee150f7]`](https://github.com/aspnet/AspNetCore/commit/8c8ee150f7) Send 'Connection: close' in all 400 responses to HTTP/1.1 requests (#840).
* [`[152c11394e]`](https://github.com/aspnet/AspNetCore/commit/152c11394e) Do not overwrite arguments for portable apps
* [`[cdea6fd3fb]`](https://github.com/aspnet/AspNetCore/commit/cdea6fd3fb) Fix TagHelper directive tests to fail when expected.
* [`[22deb2ad28]`](https://github.com/aspnet/AspNetCore/commit/22deb2ad28) Add LatencyTest project
* [`[bf7e7437a5]`](https://github.com/aspnet/AspNetCore/commit/bf7e7437a5) Fixing targets to enable starting music store from VS
* [`[36329b07c8]`](https://github.com/aspnet/AspNetCore/commit/36329b07c8) Add Description as well to AuthenticateInfo
* [`[e731a327cf]`](https://github.com/aspnet/AspNetCore/comm