# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public enum AddressFamily {
+        ControllerAreaNetwork = 65537,
+        Packet = 65536,
     }
     public class NetworkStream : Stream {
+        public override int Read(Span<byte> buffer);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadByte();
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteByte(byte value);
     }
     public enum ProtocolFamily {
+        ControllerAreaNetwork = 65537,
+        Packet = 65536,
     }
+    public sealed class SafeSocketHandle : SafeHandleMinusOneIsInvalid {
+        public SafeSocketHandle(IntPtr preexistingHandle, bool ownsHandle);
+        protected override bool ReleaseHandle();
+    }
     public class SendPacketsElement {
+        public SendPacketsElement(FileStream fileStream);
+        public SendPacketsElement(FileStream fileStream, long offset, int count);
+        public SendPacketsElement(FileStream fileStream, long offset, int count, bool endOfPacket);
+        public SendPacketsElement(string filepath, long offset, int count);
+        public SendPacketsElement(string filepath, long offset, int count, bool endOfPacket);
+        public FileStream FileStream { get; }
+        public long OffsetLong { get; }
     }
     public class Socket : IDisposable {
+        public SafeSocketHandle SafeHandle { get; }
     }
     public enum SocketOptionName {
+        TcpKeepAliveInterval = 17,
+        TcpKeepAliveRetryCount = 16,
+        TcpKeepAliveTime = 3,
     }
 }
```

