# Microsoft.AspNetCore.ApiAuthorization.IdentityServer

``` diff
 {
+    namespace Microsoft.AspNetCore.ApiAuthorization.IdentityServer {
+        public class ApiAuthorizationDbContext<TUser> : IdentityDbContext<TUser>, IDisposable, IPersistedGrantDbContext where TUser : IdentityUser {
+            public ApiAuthorizationDbContext(DbContextOptions options, IOptions<OperationalStoreOptions> operationalStoreOptions);
+            public DbSet<DeviceFlowCodes> DeviceFlowCodes { get; set; }
+            public DbSet<PersistedGrant> PersistedGrants { get; set; }
+            Task<int> IdentityServer4.EntityFramework.Interfaces.IPersistedGrantDbContext.SaveChangesAsync();
+            protected override void OnModelCreating(ModelBuilder builder);
+        }
+        public class ApiAuthorizationOptions {
+            public ApiAuthorizationOptions();
+            public ApiResourceCollection ApiResources { get; set; }
+            public ClientCollection Clients { get; set; }
+            public IdentityResourceCollection IdentityResources { get; set; }
+            public SigningCredentials SigningCredential { get; set; }
+        }
+        public class ApiResourceBuilder {
+            public ApiResourceBuilder();
+            public ApiResourceBuilder(ApiResource resource);
+            public ApiResourceBuilder AllowAllClients();
+            public static ApiResourceBuilder ApiResource(string name);
+            public ApiResource Build();
+            public static ApiResourceBuilder IdentityServerJwt(string name);
+            public ApiResourceBuilder ReplaceScopes(params string[] resourceScopes);
+            public ApiResourceBuilder WithApplicationProfile(string profile);
+            public ApiResourceBuilder WithScopes(params string[] resourceScopes);
+        }
+        public class ApiResourceCollection : Collection<ApiResource> {
+            public ApiResourceCollection();
+            public ApiResourceCollection(IList<ApiResource> list);
+            public ApiResource this[string key] { get; }
+            public void AddApiResource(string name, Action<ApiResourceBuilder> configure);
+            public void AddIdentityServerJwt(string name, Action<ApiResourceBuilder> configure);
+            public void AddRange(params ApiResource[] resources);
+        }
+        public static class ApplicationProfiles {
+            public const string API = "API";
+            public const string IdentityServerJwt = "IdentityServerJwt";
+            public const string IdentityServerSPA = "IdentityServerSPA";
+            public const string NativeApp = "NativeApp";
+            public const string SPA = "SPA";
+        }
+        public static class ApplicationProfilesPropertyNames {
+            public const string Clients = "Clients";
+            public const string Profile = "Profile";
+            public const string Source = "Source";
+        }
+        public static class ApplicationProfilesPropertyValues {
+            public const string AllowAllApplications = "*";
+            public const string Configuration = "Configuration";
+            public const string Default = "Default";
+        }
+        public class ClientBuilder {
+            public ClientBuilder();
+            public ClientBuilder(Client client);
+            public Client Build();
+            public static ClientBuilder IdentityServerSPA(string clientId);
+            public static ClientBuilder NativeApp(string clientId);
+            public static ClientBuilder SPA(string clientId);
+            public ClientBuilder WithApplicationProfile(string profile);
+            public ClientBuilder WithClientId(string clientId);
+            public ClientBuilder WithLogoutRedirectUri(string logoutUri);
+            public ClientBuilder WithoutClientSecrets();
+            public ClientBuilder WithRedirectUri(string redirectUri);
+            public ClientBuilder WithScopes(params string[] scopes);
+        }
+        public class ClientCollection : Collection<Client> {
+            public ClientCollection();
+            public ClientCollection(IList<Client> list);
+            public Client this[string key] { get; }
+            public void AddIdentityServerSPA(string clientId, Action<ClientBuilder> configure);
+            public void AddNativeApp(string clientId, Action<ClientBuilder> configure);
+            public void AddRange(params Client[] clients);
+            public void AddSPA(string clientId, Action<ClientBuilder> configure);
+        }
+        public class ClientParametersTagHelper : TagHelper {
+            public ClientParametersTagHelper(IClientRequestParametersProvider clientRequestParametersProvider);
+            public string ClientId { get; set; }
+            public ViewContext ViewContext { get; set; }
+            public override void Process(TagHelperContext context, TagHelperOutput output);
+        }
+        public interface IClientRequestParametersProvider {
+            IDictionary<string, string> GetClientParameters(HttpContext context, string clientId);
+        }
+        public class IdentityResourceBuilder {
+            public IdentityResourceBuilder();
+            public IdentityResourceBuilder(IdentityResource resource);
+            public static IdentityResourceBuilder Address();
+            public IdentityResourceBuilder AllowAllClients();
+            public IdentityResource Build();
+            public static IdentityResourceBuilder Email();
+            public static IdentityResourceBuilder OpenId();
+            public static IdentityResourceBuilder Phone();
+            public static IdentityResourceBuilder Profile();
+        }
+        public class IdentityResourceCollection : Collection<IdentityResource> {
+            public IdentityResourceCollection();
+            public IdentityResourceCollection(IList<IdentityResource> list);
+            public IdentityResource this[string key] { get; }
+            public void AddAddress();
+            public void AddAddress(Action<IdentityResourceBuilder> configure);
+            public void AddEmail();
+            public void AddEmail(Action<IdentityResourceBuilder> configure);
+            public void AddOpenId();
+            public void AddOpenId(Action<IdentityResourceBuilder> configure);
+            public void AddPhone();
+            public void AddPhone(Action<IdentityResourceBuilder> configure);
+            public void AddProfile();
+            public void AddProfile(Action<IdentityResourceBuilder> configure);
+            public void AddRange(params IdentityResource[] identityResources);
+        }
+        public class IdentityServerJwtConstants {
+            public const string IdentityServerJwtBearerScheme = "IdentityServerJwtBearer";
+            public const string IdentityServerJwtScheme = "IdentityServerJwt";
+            public IdentityServerJwtConstants();
+        }
+    }
+    namespace Microsoft.AspNetCore.Authentication {
+        public static class AuthenticationBuilderExtensions {
+            public static AuthenticationBuilder AddIdentityServerJwt(this AuthenticationBuilder builder);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class IdentityServerBuilderConfigurationExtensions {
+            public static IIdentityServerBuilder AddApiAuthorization<TUser, TContext>(this IIdentityServerBuilder builder) where TUser : class where TContext : DbContext, IPersistedGrantDbContext;
+            public static IIdentityServerBuilder AddApiAuthorization<TUser, TContext>(this IIdentityServerBuilder builder, Action<ApiAuthorizationOptions> configure) where TUser : class where TContext : DbContext, IPersistedGrantDbContext;
+            public static IIdentityServerBuilder AddApiResources(this IIdentityServerBuilder builder);
+            public static IIdentityServerBuilder AddApiResources(this IIdentityServerBuilder builder, IConfiguration configuration);
+            public static IIdentityServerBuilder AddClients(this IIdentityServerBuilder builder);
+            public static IIdentityServerBuilder AddClients(this IIdentityServerBuilder builder, IConfiguration configuration);
+            public static IIdentityServerBuilder AddIdentityResources(this IIdentityServerBuilder builder);
+            public static IIdentityServerBuilder AddIdentityResources(this IIdentityServerBuilder builder, IConfiguration configuration);
+            public static IIdentityServerBuilder AddSigningCredentials(this IIdentityServerBuilder builder);
+            public static IIdentityServerBuilder AddSigningCredentials(this IIdentityServerBuilder builder, IConfiguration configuration);
+        }
+    }
+}
```

