# Microsoft.AspNetCore.Authentication.Certificate

``` diff
 {
+    namespace Microsoft.AspNetCore.Authentication.Certificate {
+        public static class CertificateAuthenticationDefaults {
+            public const string AuthenticationScheme = "Certificate";
+        }
+        public class CertificateAuthenticationEvents {
+            public CertificateAuthenticationEvents();
+            public Func<CertificateAuthenticationFailedContext, Task> OnAuthenticationFailed { get; set; }
+            public Func<CertificateValidatedContext, Task> OnCertificateValidated { get; set; }
+            public virtual Task AuthenticationFailed(CertificateAuthenticationFailedContext context);
+            public virtual Task CertificateValidated(CertificateValidatedContext context);
+        }
+        public class CertificateAuthenticationFailedContext : ResultContext<CertificateAuthenticationOptions> {
+            public CertificateAuthenticationFailedContext(HttpContext context, AuthenticationScheme scheme, CertificateAuthenticationOptions options);
+            public Exception Exception { get; set; }
+        }
+        public class CertificateAuthenticationOptions : AuthenticationSchemeOptions {
+            public CertificateAuthenticationOptions();
+            public CertificateTypes AllowedCertificateTypes { get; set; }
+            public new CertificateAuthenticationEvents Events { get; set; }
+            public X509RevocationFlag RevocationFlag { get; set; }
+            public X509RevocationMode RevocationMode { get; set; }
+            public bool ValidateCertificateUse { get; set; }
+            public bool ValidateValidityPeriod { get; set; }
+        }
+        public enum CertificateTypes {
+            All = 3,
+            Chained = 1,
+            SelfSigned = 2,
+        }
+        public class CertificateValidatedContext : ResultContext<CertificateAuthenticationOptions> {
+            public CertificateValidatedContext(HttpContext context, AuthenticationScheme scheme, CertificateAuthenticationOptions options);
+            public X509Certificate2 ClientCertificate { get; set; }
+        }
+        public static class X509Certificate2Extensions {
+            public static bool IsSelfSigned(this X509Certificate2 certificate);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class CertificateAuthenticationAppBuilderExtensions {
+            public static AuthenticationBuilder AddCertificate(this AuthenticationBuilder builder);
+            public static AuthenticationBuilder AddCertificate(this AuthenticationBuilder builder, Action<CertificateAuthenticationOptions> configureOptions);
+            public static AuthenticationBuilder AddCertificate(this AuthenticationBuilder builder, string authenticationScheme);
+            public static AuthenticationBuilder AddCertificate(this AuthenticationBuilder builder, string authenticationScheme, Action<CertificateAuthenticationOptions> configureOptions);
+        }
+    }
+}
```

