# Microsoft.AspNetCore.Blazor.Server

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public static class BlazorHostingApplicationBuilderExtensions {
+            public static IApplicationBuilder UseClientSideBlazorFiles(this IApplicationBuilder app, string clientAssemblyFilePath);
+            public static IApplicationBuilder UseClientSideBlazorFiles<TClientApp>(this IApplicationBuilder app);
+        }
+        public static class BlazorHostingEndpointRouteBuilderExtensions {
+            public static IEndpointConventionBuilder MapFallbackToClientSideBlazor(this IEndpointRouteBuilder endpoints, string clientAssemblyFilePath, string filePath);
+            public static IEndpointConventionBuilder MapFallbackToClientSideBlazor(this IEndpointRouteBuilder endpoints, string clientAssemblyFilePath, string pattern, string filePath);
+            public static IEndpointConventionBuilder MapFallbackToClientSideBlazor<TClientApp>(this IEndpointRouteBuilder endpoints, string filePath);
+            public static IEndpointConventionBuilder MapFallbackToClientSideBlazor<TClientApp>(this IEndpointRouteBuilder endpoints, string pattern, string filePath);
+        }
+        public static class BlazorMonoDebugProxyAppBuilderExtensions {
+            public static void UseBlazorDebugging(this IApplicationBuilder app);
+        }
+    }
+}
```

