# Microsoft.AspNetCore.Blazor

``` diff
 {
+    namespace Microsoft.AspNetCore.Blazor {
+        public static class JSInteropMethods {
+            public static void NotifyLocationChanged(string uri, bool isInterceptedLink);
+        }
+    }
+    namespace Microsoft.AspNetCore.Blazor.Hosting {
+        public static class BlazorWebAssemblyHost {
+            public static IWebAssemblyHostBuilder CreateDefaultBuilder();
+        }
+        public interface IWebAssemblyHost : IDisposable {
+            IServiceProvider Services { get; }
+            Task StartAsync(CancellationToken cancellationToken = default(CancellationToken));
+            Task StopAsync(CancellationToken cancellationToken = default(CancellationToken));
+        }
+        public interface IWebAssemblyHostBuilder {
+            IDictionary<object, object> Properties { get; }
+            IWebAssemblyHost Build();
+            IWebAssemblyHostBuilder ConfigureServices(Action<WebAssemblyHostBuilderContext, IServiceCollection> configureDelegate);
+            IWebAssemblyHostBuilder UseServiceProviderFactory<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory);
+            IWebAssemblyHostBuilder UseServiceProviderFactory<TContainerBuilder>(Func<WebAssemblyHostBuilderContext, IServiceProviderFactory<TContainerBuilder>> factory);
+        }
+        public sealed class WebAssemblyHostBuilderContext {
+            public WebAssemblyHostBuilderContext(IDictionary<object, object> properties);
+            public IDictionary<object, object> Properties { get; }
+        }
+        public static class WebAssemblyHostBuilderExtensions {
+            public static IWebAssemblyHostBuilder ConfigureServices(this IWebAssemblyHostBuilder hostBuilder, Action<IServiceCollection> configureDelegate);
+            public static IWebAssemblyHostBuilder UseBlazorStartup(this IWebAssemblyHostBuilder builder, Type startupType);
+            public static IWebAssemblyHostBuilder UseBlazorStartup<TStartup>(this IWebAssemblyHostBuilder builder);
+        }
+        public static class WebAssemblyHostExtensions {
+            public static void Run(this IWebAssemblyHost host);
+        }
+    }
+    namespace Microsoft.AspNetCore.Blazor.Http {
+        public enum FetchCredentialsOption {
+            Include = 2,
+            Omit = 0,
+            SameOrigin = 1,
+        }
+        public class WebAssemblyHttpMessageHandler : HttpMessageHandler {
+            public const string FetchArgs = "WebAssemblyHttpMessageHandler.FetchArgs";
+            public WebAssemblyHttpMessageHandler();
+            public static FetchCredentialsOption DefaultCredentials { get; set; }
+            protected override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+        }
+    }
+    namespace Microsoft.AspNetCore.Blazor.Rendering {
+        public static class WebAssemblyEventDispatcher {
+            public static Task DispatchEvent(WebEventDescriptor eventDescriptor, string eventArgsJson);
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Builder {
+        public static class ComponentsApplicationBuilderExtensions {
+            public static void AddComponent<TComponent>(this IComponentsApplicationBuilder app, string domElementSelector) where TComponent : IComponent;
+        }
+        public interface IComponentsApplicationBuilder {
+            IServiceProvider Services { get; }
+            void AddComponent(Type componentType, string domElementSelector);
+        }
+    }
+}
```

