# Microsoft.AspNetCore.Components.Server

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public sealed class ComponentEndpointConventionBuilder : IEndpointConventionBuilder, IHubEndpointConventionBuilder {
+            public void Add(Action<EndpointBuilder> convention);
+        }
+        public static class ComponentEndpointConventionBuilderExtensions {
+            public static ComponentEndpointConventionBuilder AddComponent(this ComponentEndpointConventionBuilder builder, Type componentType, string selector);
+        }
+        public static class ComponentEndpointRouteBuilderExtensions {
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints);
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints, Action<HttpConnectionDispatcherOptions> configureOptions);
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints, Type type, string selector);
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints, Type type, string selector, Action<HttpConnectionDispatcherOptions> configureOptions);
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints, Type componentType, string selector, string path);
+            public static ComponentEndpointConventionBuilder MapBlazorHub(this IEndpointRouteBuilder endpoints, Type componentType, string selector, string path, Action<HttpConnectionDispatcherOptions> configureOptions);
+            public static ComponentEndpointConventionBuilder MapBlazorHub<TComponent>(this IEndpointRouteBuilder endpoints, string selector) where TComponent : IComponent;
+            public static ComponentEndpointConventionBuilder MapBlazorHub<TComponent>(this IEndpointRouteBuilder endpoints, string selector, Action<HttpConnectionDispatcherOptions> configureOptions) where TComponent : IComponent;
+            public static ComponentEndpointConventionBuilder MapBlazorHub<TComponent>(this IEndpointRouteBuilder endpoints, string selector, string path) where TComponent : IComponent;
+            public static ComponentEndpointConventionBuilder MapBlazorHub<TComponent>(this IEndpointRouteBuilder endpoints, string selector, string path, Action<HttpConnectionDispatcherOptions> configureOptions) where TComponent : IComponent;
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Server {
+        public sealed class CircuitOptions {
+            public CircuitOptions();
+            public bool DetailedErrors { get; set; }
+            public int DisconnectedCircuitMaxRetained { get; set; }
+            public TimeSpan DisconnectedCircuitRetentionPeriod { get; set; }
+            public TimeSpan JSInteropDefaultCallTimeout { get; set; }
+        }
+        public class ComponentPrerenderingContext {
+            public ComponentPrerenderingContext();
+            public Type ComponentType { get; set; }
+            public HttpContext Context { get; set; }
+            public ParameterView Parameters { get; set; }
+        }
+        public sealed class ComponentPrerenderResult {
+            public void WriteTo(TextWriter writer);
+        }
+        public interface IComponentPrerenderer {
+            Task<ComponentPrerenderResult> PrerenderComponentAsync(ComponentPrerenderingContext context);
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Server.Circuits {
+        public sealed class Circuit {
+            public string Id { get; }
+        }
+        public abstract class CircuitHandler {
+            protected CircuitHandler();
+            public virtual int Order { get; }
+            public virtual Task OnCircuitClosedAsync(Circuit circuit, CancellationToken cancellationToken);
+            public virtual Task OnCircuitOpenedAsync(Circuit circuit, CancellationToken cancellationToken);
+            public virtual Task OnConnectionDownAsync(Circuit circuit, CancellationToken cancellationToken);
+            public virtual Task OnConnectionUpAsync(Circuit circuit, CancellationToken cancellationToken);
+        }
+        public class RemoteUriHelper : UriHelperBase {
+            public RemoteUriHelper(ILogger<RemoteUriHelper> logger);
+            public bool HasAttachedJSRuntime { get; }
+            public override void InitializeState(string uriAbsolute, string baseUriAbsolute);
+            protected override void NavigateToCore(string uri, bool forceLoad);
+            public static void NotifyLocationChanged(string uriAbsolute, bool isInterceptedLink);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class ComponentServiceCollectionExtensions {
+            public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions> configure = null);
+        }
+        public interface IServerSideBlazorBuilder {
+            IServiceCollection Services { get; }
+        }
+        public static class ServerSideBlazorBuilderExtensions {
+            public static IServerSideBlazorBuilder AddCircuitOptions(this IServerSideBlazorBuilder builder, Action<CircuitOptions> configure);
+            public static IServerSideBlazorBuilder AddHubOptions(this IServerSideBlazorBuilder builder, Action<HubOptions> configure);
+        }
+    }
+}
```

