# Microsoft.AspNetCore.Components

``` diff
 {
+    namespace Microsoft.AspNetCore.Components {
+        public static class BindConverter {
+            public static bool FormatValue(bool value, CultureInfo culture = null);
+            public static string FormatValue(DateTime value, CultureInfo culture = null);
+            public static string FormatValue(DateTime value, string format, CultureInfo culture = null);
+            public static string FormatValue(DateTimeOffset value, CultureInfo culture = null);
+            public static string FormatValue(DateTimeOffset value, string format, CultureInfo culture = null);
+            public static string FormatValue(decimal value, CultureInfo culture = null);
+            public static string FormatValue(double value, CultureInfo culture = null);
+            public static string FormatValue(int value, CultureInfo culture = null);
+            public static string FormatValue(long value, CultureInfo culture = null);
+            public static bool? FormatValue(bool? value, CultureInfo culture = null);
+            public static string FormatValue(DateTime? value, CultureInfo culture = null);
+            public static string FormatValue(DateTime? value, string format, CultureInfo culture = null);
+            public static string FormatValue(DateTimeOffset? value, CultureInfo culture = null);
+            public static string FormatValue(DateTimeOffset? value, string format, CultureInfo culture = null);
+            public static string FormatValue(decimal? value, CultureInfo culture = null);
+            public static string FormatValue(double? value, CultureInfo culture = null);
+            public static string FormatValue(int? value, CultureInfo culture = null);
+            public static string FormatValue(long? value, CultureInfo culture = null);
+            public static string FormatValue(float? value, CultureInfo culture = null);
+            public static string FormatValue(float value, CultureInfo culture = null);
+            public static string FormatValue(string value, CultureInfo culture = null);
+            public static object FormatValue<T>(T value, CultureInfo culture = null);
+            public static bool TryConvertTo<T>(object obj, CultureInfo culture, out T value);
+            public static bool TryConvertToBool(object obj, CultureInfo culture, out bool value);
+            public static bool TryConvertToDateTime(object obj, CultureInfo culture, out DateTime value);
+            public static bool TryConvertToDateTime(object obj, CultureInfo culture, string format, out DateTime value);
+            public static bool TryConvertToDateTimeOffset(object obj, CultureInfo culture, out DateTimeOffset value);
+            public static bool TryConvertToDateTimeOffset(object obj, CultureInfo culture, string format, out DateTimeOffset value);
+            public static bool TryConvertToDecimal(object obj, CultureInfo culture, out decimal value);
+            public static bool TryConvertToDouble(object obj, CultureInfo culture, out double value);
+            public static bool TryConvertToFloat(object obj, CultureInfo culture, out float value);
+            public static bool TryConvertToInt(object obj, CultureInfo culture, out int value);
+            public static bool TryConvertToLong(object obj, CultureInfo culture, out long value);
+            public static bool TryConvertToNullableBool(object obj, CultureInfo culture, out bool? value);
+            public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, out DateTime? value);
+            public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, string format, out DateTime? value);
+            public static bool TryConvertToNullableDateTimeOffset(object obj, CultureInfo culture, out DateTimeOffset? value);
+            public static bool TryConvertToNullableDateTimeOffset(object obj, CultureInfo culture, string format, out DateTimeOffset? value);
+            public static bool TryConvertToNullableDecimal(object obj, CultureInfo culture, out decimal? value);
+            public static bool TryConvertToNullableDouble(object obj, CultureInfo culture, out double? value);
+            public static bool TryConvertToNullableFloat(object obj, CultureInfo culture, out float? value);
+            public static bool TryConvertToNullableInt(object obj, CultureInfo culture, out int? value);
+            public static bool TryConvertToNullableLong(object obj, CultureInfo culture, out long? value);
+            public static bool TryConvertToString(object obj, CultureInfo culture, out string value);
+        }
+        public sealed class BindElementAttribute : Attribute {
+            public BindElementAttribute(string element, string suffix, string valueAttribute, string changeAttribute);
+            public string ChangeAttribute { get; }
+            public string Element { get; }
+            public string Suffix { get; }
+            public string ValueAttribute { get; }
+        }
+        public sealed class CascadingParameterAttribute : Attribute {
+            public CascadingParameterAttribute();
+            public string Name { get; set; }
+        }
+        public class CascadingValue<TValue> : ICascadingValueComponent, IComponent {
+            public CascadingValue();
+            public RenderFragment ChildContent { get; set; }
+            public bool IsFixed { get; set; }
+            public string Name { get; set; }
+            public TValue Value { get; set; }
+            public void Attach(RenderHandle renderHandle);
+            public Task SetParametersAsync(ParameterView parameters);
+        }
+        public class ChangeEventArgs : EventArgs {
+            public ChangeEventArgs();
+            public object Value { get; set; }
+        }
+        public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+            public ComponentBase();
+            protected virtual void BuildRenderTree(RenderTreeBuilder builder);
+            protected Task InvokeAsync(Action workItem);
+            protected Task InvokeAsync(Func<Task> workItem);
+            void Microsoft.AspNetCore.Components.IComponent.Attach(RenderHandle renderHandle);
+            Task Microsoft.AspNetCore.Components.IHandleAfterRender.OnAfterRenderAsync();
+            Task Microsoft.AspNetCore.Components.IHandleEvent.HandleEventAsync(EventCallbackWorkItem callback, object arg);
+            protected virtual void OnAfterRender(bool firstRender);
+            protected virtual Task OnAfterRenderAsync(bool firstRender);
+            protected virtual void OnInitialized();
+            protected virtual Task OnInitializedAsync();
+            protected virtual void OnParametersSet();
+            protected virtual Task OnParametersSetAsync();
+            public virtual Task SetParametersAsync(ParameterView parameters);
+            protected virtual bool ShouldRender();
+            protected void StateHasChanged();
+        }
+        public abstract class Dispatcher {
+            protected Dispatcher();
+            public void AssertAccess();
+            public abstract bool CheckAccess();
+            public static Dispatcher CreateDefault();
+            public abstract Task InvokeAsync(Action workItem);
+            public abstract Task InvokeAsync(Func<Task> workItem);
+            public abstract Task<TResult> InvokeAsync<TResult>(Func<Task<TResult>> workItem);
+            public abstract Task<TResult> InvokeAsync<TResult>(Func<TResult> workItem);
+            protected void OnUnhandledException(UnhandledExceptionEventArgs e);
+        }
+        public readonly struct ElementReference {
+            public ElementReference(string id);
+            public string Id { get; }
+        }
+        public readonly struct EventCallback : IEventCallback {
+            public static readonly EventCallback Empty;
+            public static readonly EventCallbackFactory Factory;
+            public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);
+            public bool HasDelegate { get; }
+            public Task InvokeAsync(object arg);
+        }
+        public readonly struct EventCallback<TValue> : IEventCallback {
+            public static readonly EventCallback<TValue> Empty;
+            public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);
+            public bool HasDelegate { get; }
+            public Task InvokeAsync(TValue arg);
+        }
+        public sealed class EventCallbackFactory {
+            public EventCallbackFactory();
+            public EventCallback Create(object receiver, EventCallback callback);
+            public EventCallback Create(object receiver, Action callback);
+            public EventCallback Create(object receiver, Action<object> callback);
+            public EventCallback Create(object receiver, Func<object, Task> callback);
+            public EventCallback Create(object receiver, Func<Task> callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, EventCallback callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, EventCallback<TValue> callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, Action callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, Action<TValue> callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, Func<Task> callback);
+            public EventCallback<TValue> Create<TValue>(object receiver, Func<TValue, Task> callback);
+            public EventCallback<TValue> CreateInferred<TValue>(object receiver, Action<TValue> callback, TValue value);
+            public EventCallback<TValue> CreateInferred<TValue>(object receiver, Func<TValue, Task> callback, TValue value);
+        }
+        public static class EventCallbackFactoryBinderExtensions {
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool> setter, bool existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, string format, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, string format, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<decimal> setter, decimal existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double> setter, double existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int> setter, int existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long> setter, long existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool?> setter, bool? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime?> setter, DateTime? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime?> setter, DateTime? existingValue, string format, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset?> setter, DateTimeOffset? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset?> setter, DateTimeOffset? existingValue, string format, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<decimal?> setter, decimal? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double?> setter, double? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int?> setter, int? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long?> setter, long? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float?> setter, float? existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float> setter, float existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<string> setter, string existingValue, CultureInfo culture = null);
+            public static EventCallback<ChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Action<T> setter, T existingValue, CultureInfo culture = null);
+        }
+        public static class EventCallbackFactoryEventArgsExtensions {
+            public static EventCallback<ChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ChangeEventArgs> callback);
+            public static EventCallback<EventArgs> Create(this EventCallbackFactory factory, object receiver, Action<EventArgs> callback);
+            public static EventCallback<ChangeEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ChangeEventArgs, Task> callback);
+            public static EventCallback<EventArgs> Create(this EventCallbackFactory factory, object receiver, Func<EventArgs, Task> callback);
+        }
+        public readonly struct EventCallbackWorkItem {
+            public static readonly EventCallbackWorkItem Empty;
+            public EventCallbackWorkItem(MulticastDelegate @delegate);
+            public Task InvokeAsync(object arg);
+        }
+        public sealed class EventHandlerAttribute : Attribute {
+            public EventHandlerAttribute(string attributeName, Type eventArgsType);
+            public string AttributeName { get; }
+            public Type EventArgsType { get; }
+        }
+        public interface IComponent {
+            void Attach(RenderHandle renderHandle);
+            Task SetParametersAsync(ParameterView parameters);
+        }
+        public interface IHandleAfterRender {
+            Task OnAfterRenderAsync();
+        }
+        public interface IHandleEvent {
+            Task HandleEventAsync(EventCallbackWorkItem item, object arg);
+        }
+        public sealed class InjectAttribute : Attribute {
+            public InjectAttribute();
+        }
+        public sealed class LayoutAttribute : Attribute {
+            public LayoutAttribute(Type layoutType);
+            public Type LayoutType { get; private set; }
+        }
+        public abstract class LayoutComponentBase : ComponentBase {
+            protected LayoutComponentBase();
+            public RenderFragment Body { get; set; }
+        }
+        public class LayoutView : IComponent {
+            public LayoutView();
+            public RenderFragment ChildContent { get; set; }
+            public Type Layout { get; set; }
+            public void Attach(RenderHandle renderHandle);
+            public Task SetParametersAsync(ParameterView parameters);
+        }
+        public sealed class LocationChangeException : Exception {
+            public LocationChangeException(string message, Exception innerException);
+        }
+        public readonly struct MarkupString {
+            public MarkupString(string value);
+            public string Value { get; }
+            public static explicit operator MarkupString (string value);
+            public override string ToString();
+        }
+        public class NavigationException : Exception {
+            public NavigationException(string uri);
+            public string Location { get; }
+        }
+        public abstract class NavigationManager {
+            protected NavigationManager();
+            public string BaseUri { get; protected set; }
+            public string Uri { get; protected set; }
+            public event EventHandler<LocationChangedEventArgs> LocationChanged;
+            protected virtual void EnsureInitialized();
+            protected void Initialize(string baseUri, string uri);
+            public void NavigateTo(string uri, bool forceLoad = false);
+            protected abstract void NavigateToCore(string uri, bool forceLoad);
+            protected void NotifyLocationChanged(bool isInterceptedLink);
+            public Uri ToAbsoluteUri(string relativeUri);
+            public string ToBaseRelativePath(string uri);
+        }
+        public abstract class OwningComponentBase : ComponentBase, IDisposable {
+            protected OwningComponentBase();
+            protected bool IsDisposed { get; private set; }
+            protected IServiceProvider ScopedServices { get; }
+            protected virtual void Dispose(bool disposing);
+            void System.IDisposable.Dispose();
+        }
+        public abstract class OwningComponentBase<TService> : OwningComponentBase, IDisposable {
+            protected OwningComponentBase();
+            protected TService Service { get; }
+        }
+        public sealed class ParameterAttribute : Attribute {
+            public ParameterAttribute();
+            public bool CaptureUnmatchedValues { get; set; }
+        }
+        public readonly struct ParameterValue {
+            public bool Cascading { get; }
+            public string Name { get; }
+            public object Value { get; }
+        }
+        public readonly struct ParameterView {
+            public static ParameterView Empty { get; }
+            public static ParameterView FromDictionary(IDictionary<string, object> parameters);
+            public ParameterView.Enumerator GetEnumerator();
+            public TValue GetValueOrDefault<TValue>(string parameterName);
+            public TValue GetValueOrDefault<TValue>(string parameterName, TValue defaultValue);
+            public void SetParameterProperties(object target);
+            public IReadOnlyDictionary<string, object> ToDictionary();
+            public bool TryGetValue<TValue>(string parameterName, out TValue result);
+            public struct Enumerator {
+                public ParameterValue Current { get; }
+                public bool MoveNext();
+            }
+        }
+        public delegate void RenderFragment(RenderTreeBuilder builder);
+        public delegate RenderFragment RenderFragment<TValue>(TValue value);
+        public readonly struct RenderHandle {
+            public Dispatcher Dispatcher { get; }
+            public bool IsInitialized { get; }
+            public void Render(RenderFragment renderFragment);
+        }
+        public sealed class RouteAttribute : Attribute {
+            public RouteAttribute(string template);
+            public string Template { get; }
+        }
+        public sealed class RouteData {
+            public RouteData(Type pageType, IReadOnlyDictionary<string, object> routeValues);
+            public Type PageType { get; }
+            public IReadOnlyDictionary<string, object> RouteValues { get; }
+        }
+        public class RouteView : IComponent {
+            public RouteView();
+            public Type DefaultLayout { get; set; }
+            public RouteData RouteData { get; set; }
+            public void Attach(RenderHandle renderHandle);
+            protected virtual void Render(RenderTreeBuilder builder);
+            public Task SetParametersAsync(ParameterView parameters);
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.CompilerServices {
+        public static class RuntimeHelpers {
+            public static EventCallback<T> CreateInferredEventCallback<T>(object receiver, Action<T> callback, T value);
+            public static EventCallback<T> CreateInferredEventCallback<T>(object receiver, Func<T, Task> callback, T value);
+            public static T TypeCheck<T>(T value);
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Rendering {
+        public sealed class RenderTreeBuilder : IDisposable {
+            public RenderTreeBuilder();
+            public void AddAttribute(int sequence, in RenderTreeFrame frame);
+            public void AddAttribute(int sequence, string name, EventCallback value);
+            public void AddAttribute(int sequence, string name, bool value);
+            public void AddAttribute(int sequence, string name, MulticastDelegate value);
+            public void AddAttribute(int sequence, string name, object value);
+            public void AddAttribute(int sequence, string name, string value);
+            public void AddAttribute<TArgument>(int sequence, string name, EventCallback<TArgument> value);
+            public void AddComponentReferenceCapture(int sequence, Action<object> componentReferenceCaptureAction);
+            public void AddContent(int sequence, MarkupString markupContent);
+            public void AddContent(int sequence, RenderFragment fragment);
+            public void AddContent(int sequence, object textContent);
+            public void AddContent(int sequence, string textContent);
+            public void AddContent<TValue>(int sequence, RenderFragment<TValue> fragment, TValue value);
+            public void AddElementReferenceCapture(int sequence, Action<ElementReference> elementReferenceCaptureAction);
+            public void AddMarkupContent(int sequence, string markupContent);
+            public void AddMultipleAttributes(int sequence, IEnumerable<KeyValuePair<string, object>> attributes);
+            public void Clear();
+            public void CloseComponent();
+            public void CloseElement();
+            public void CloseRegion();
+            public ArrayRange<RenderTreeFrame> GetFrames();
+            public void OpenComponent(int sequence, Type componentType);
+            public void OpenComponent<TComponent>(int sequence) where TComponent : IComponent;
+            public void OpenElement(int sequence, string elementName);
+            public void OpenRegion(int sequence);
+            public void SetKey(object value);
+            public void SetUpdatesAttributeName(string updatesAttributeName);
+            void System.IDisposable.Dispose();
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.RenderTree {
+        public readonly struct ArrayBuilderSegment<T> : IEnumerable, IEnumerable<T> {
+            public T[] Array { get; }
+            public int Count { get; }
+            public int Offset { get; }
+            public T this[int index] { get; }
+            IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+        public readonly struct ArrayRange<T> {
+            public readonly int Count;
+            public readonly T[] Array;
+            public ArrayRange(T[] array, int count);
+            public ArrayRange<T> Clone();
+        }
+        public class EventFieldInfo {
+            public EventFieldInfo();
+            public int ComponentId { get; set; }
+            public object FieldValue { get; set; }
+        }
+        public readonly struct RenderBatch {
+            public ArrayRange<int> DisposedComponentIDs { get; }
+            public ArrayRange<ulong> DisposedEventHandlerIDs { get; }
+            public ArrayRange<RenderTreeFrame> ReferenceFrames { get; }
+            public ArrayRange<RenderTreeDiff> UpdatedComponents { get; }
+        }
+        public abstract class Renderer : IDisposable {
+            public Renderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory);
+            public abstract Dispatcher Dispatcher { get; }
+            public event UnhandledExceptionEventHandler UnhandledSynchronizationException;
+            protected internal int AssignRootComponentId(IComponent component);
+            public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo fieldInfo, EventArgs eventArgs);
+            public void Dispose();
+            protected virtual void Dispose(bool disposing);
+            protected ArrayRange<RenderTreeFrame> GetCurrentRenderTreeFrames(int componentId);
+            protected abstract void HandleException(Exception exception);
+            protected IComponent InstantiateComponent(Type componentType);
+            protected virtual void ProcessPendingRender();
+            protected Task RenderRootComponentAsync(int componentId);
+            protected Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);
+            protected abstract Task UpdateDisplayAsync(in RenderBatch renderBatch);
+        }
+        public readonly struct RenderTreeDiff {
+            public readonly ArrayBuilderSegment<RenderTreeEdit> Edits;
+            public readonly int ComponentId;
+        }
+        public readonly struct RenderTreeEdit {
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public readonly RenderTreeEditType Type;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int MoveToSiblingIndex;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int ReferenceFrameIndex;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(4)]
+            public readonly int SiblingIndex;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string RemovedAttributeName;
+        }
+        public enum RenderTreeEditType {
+            PermutationListEnd = 10,
+            PermutationListEntry = 9,
+            PrependFrame = 1,
+            RemoveAttribute = 4,
+            RemoveFrame = 2,
+            SetAttribute = 3,
+            StepIn = 6,
+            StepOut = 7,
+            UpdateMarkup = 8,
+            UpdateText = 5,
+        }
+        public readonly struct RenderTreeFrame {
+            [System.Runtime.InteropServices.FieldOffsetAttribute(4)]
+            public readonly RenderTreeFrameType FrameType;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(24)]
+            public readonly Action<ElementReference> ElementReferenceCaptureAction;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly Action<object> ComponentReferenceCaptureAction;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(12)]
+            public readonly int ComponentId;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int ComponentReferenceCaptureParentFrameIndex;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int ComponentSubtreeLength;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int ElementSubtreeLength;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly int RegionSubtreeLength;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public readonly int Sequence;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(24)]
+            public readonly object AttributeValue;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(32)]
+            public readonly object ComponentKey;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(24)]
+            public readonly object ElementKey;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(32)]
+            public readonly string AttributeEventUpdatesAttributeName;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string AttributeName;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string ElementName;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string ElementReferenceCaptureId;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string MarkupContent;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly string TextContent;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(16)]
+            public readonly Type ComponentType;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(8)]
+            public readonly ulong AttributeEventHandlerId;
+            public IComponent Component { get; }
+            public override string ToString();
+        }
+        public enum RenderTreeFrameType : short {
+            Attribute = (short)3,
+            Component = (short)4,
+            ComponentReferenceCapture = (short)7,
+            Element = (short)1,
+            ElementReferenceCapture = (short)6,
+            Markup = (short)8,
+            None = (short)0,
+            Region = (short)5,
+            Text = (short)2,
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Routing {
+        public interface IHostEnvironmentNavigationManager {
+            void Initialize(string baseUri, string uri);
+        }
+        public interface INavigationInterception {
+            Task EnableNavigationInterceptionAsync();
+        }
+        public class LocationChangedEventArgs : EventArgs {
+            public LocationChangedEventArgs(string location, bool isNavigationIntercepted);
+            public bool IsNavigationIntercepted { get; }
+            public string Location { get; }
+        }
+        public class Router : IComponent, IDisposable, IHandleAfterRender {
+            public Router();
+            public IEnumerable<Assembly> AdditionalAssemblies { get; set; }
+            public Assembly AppAssembly { get; set; }
+            public RenderFragment<RouteData> Found { get; set; }
+            public RenderFragment NotFound { get; set; }
+            public void Attach(RenderHandle renderHandle);
+            public void Dispose();
+            Task Microsoft.AspNetCore.Components.IHandleAfterRender.OnAfterRenderAsync();
+            public Task SetParametersAsync(ParameterView parameters);
+        }
+    }
+}
```

