# Microsoft.AspNetCore.ConcurrencyLimiter

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public static class ConcurrencyLimiterExtensions {
+            public static IApplicationBuilder UseConcurrencyLimiter(this IApplicationBuilder app);
+        }
+    }
+    namespace Microsoft.AspNetCore.ConcurrencyLimiter {
+        public class ConcurrencyLimiterMiddleware {
+            public ConcurrencyLimiterMiddleware(RequestDelegate next, ILoggerFactory loggerFactory, IQueuePolicy queue, IOptions<ConcurrencyLimiterOptions> options);
+            public Task Invoke(HttpContext context);
+        }
+        public class ConcurrencyLimiterOptions {
+            public ConcurrencyLimiterOptions();
+            public RequestDelegate OnRejected { get; set; }
+        }
+        public interface IQueuePolicy {
+            void OnExit();
+            ValueTask<bool> TryEnterAsync();
+        }
+        public class QueuePolicyOptions {
+            public QueuePolicyOptions();
+            public int MaxConcurrentRequests { get; set; }
+            public int RequestQueueLimit { get; set; }
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class QueuePolicyServiceCollectionExtensions {
+            public static IServiceCollection AddQueuePolicy(this IServiceCollection services, Action<QueuePolicyOptions> configure);
+            public static IServiceCollection AddStackPolicy(this IServiceCollection services, Action<QueuePolicyOptions> configure);
+        }
+    }
+}
```

