# Microsoft.AspNetCore.Mvc.Core

``` diff
 {
     namespace Microsoft.AspNetCore.Builder {
+        public sealed class ControllerActionEndpointConventionBuilder : IEndpointConventionBuilder {
+            public void Add(Action<EndpointBuilder> convention);
+        }
+        public static class ControllerEndpointRouteBuilderExtensions {
+            public static ControllerActionEndpointConventionBuilder MapAreaControllerRoute(this IEndpointRouteBuilder endpoints, string name, string areaName, string pattern, object defaults = null, object constraints = null, object dataTokens = null);
+            public static ControllerActionEndpointConventionBuilder MapControllerRoute(this IEndpointRouteBuilder endpoints, string name, string pattern, object defaults = null, object constraints = null, object dataTokens = null);
+            public static ControllerActionEndpointConventionBuilder MapControllers(this IEndpointRouteBuilder endpoints);
+            public static ControllerActionEndpointConventionBuilder MapDefaultControllerRoute(this IEndpointRouteBuilder endpoints);
+            public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+            public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, string action, string controller, string area);
+            public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller, string area);
+            public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, string action, string controller);
+            public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller);
+        }
     }
     namespace Microsoft.AspNetCore.Mvc {
         public class ApiBehaviorOptions : IEnumerable, IEnumerable<ICompatibilitySwitch> {
-            public bool AllowInferringBindingSourceForCollectionTypesAsFromQuery { get; set; }

-            public bool SuppressUseValidationProblemDetailsForInvalidModelStateResponses { get; set; }

         }
         public class ApiControllerAttribute : ControllerAttribute, IApiBehaviorMetadata, IFilterMetadata
         public enum CompatibilityVersion {
+            Version_3_0 = 3,
         }
-        public class ConsumesAttribute : Attribute, IActionConstraint, IActionConstraintMetadata, IApiRequestMetadataProvider, IConsumesActionConstraint, IFilterMetadata, IResourceFilter
+        public class ConsumesAttribute : Attribute, IActionConstraint, IActionConstraintMetadata, IApiRequestMetadataProvider, IFilterMetadata, IResourceFilter
+        public class JsonOptions {
+            public JsonOptions();
+            public JsonSerializerOptions JsonSerializerOptions { get; }
+        }
+        public class JsonResult : ActionResult, IActionResult, IStatusCodeActionResult {
+            public JsonResult(object value);
+            public JsonResult(object value, object serializerSettings);
+            public string ContentType { get; set; }
+            public object SerializerSettings { get; set; }
+            public int? StatusCode { get; set; }
+            public object Value { get; set; }
+            public override Task ExecuteResultAsync(ActionContext context);
+        }
         public class LocalRedirectResult : ActionResult {
-            public override void ExecuteResult(ActionContext context);

         }
         public class MvcOptions : IEnumerable, IEnumerable<ICompatibilitySwitch> {
-            public bool AllowBindingHeaderValuesToNonStringModelTypes { get; set; }

-            public bool AllowCombiningAuthorizeFilters { get; set; }

-            public bool AllowShortCircuitingValidationWhenNoValidatorsArePresent { get; set; }

-            public bool AllowValidatingTopLevelNodes { get; set; }

-            public InputFormatterExceptionPolicy InputFormatterExceptionPolicy { get; set; }

+            public int MaxIAsyncEnumerableBufferLimit { get; set; }
+            public int MaxModelBindingCollectionSize { get; set; }
+            public int MaxModelBindingRecursionDepth { get; set; }
+            public bool SuppressAsyncSuffixInActionNames { get; set; }
-            public bool SuppressBindingUndefinedValueToEnumType { get; set; }

+            public bool SuppressImplicitRequiredAttributeForNonNullableReferenceTypes { get; set; }
+            public bool SuppressOutputFormatterBuffering { get; set; }
+            public bool ValidateComplexTypesIfChildValidationFails { get; set; }
         }
         public class RedirectResult : ActionResult, IActionResult, IKeepTempDataResult {
-            public override void ExecuteResult(ActionContext context);

         }
         public class RedirectToActionResult : ActionResult, IActionResult, IKeepTempDataResult {
-            public override void ExecuteResult(ActionContext context);

         }
         public class RedirectToPageResult : ActionResult, IActionResult, IKeepTempDataResult {
-            public override void ExecuteResult(ActionContext context);

         }
         public class RedirectToRouteResult : ActionResult, IActionResult, IKeepTempDataResult {
-            public override void ExecuteResult(ActionContext context);

         }
         public static class UrlHelperExtensions {
+            public static string ActionLink(this IUrlHelper helper, string action = null, string controller = null, object values = null, string protocol = null, string host = null, string fragment = null);
+            public static string PageLink(this IUrlHelper urlHelper, string pageName = null, string pageHandler = null, object values = null, string protocol = null, string host = null, string fragment = null);
         }
     }
     namespace Microsoft.AspNetCore.Mvc.ActionConstraints {
+        public class HttpMethodActionConstraint : IActionConstraint, IActionConstraintMetadata {
+            public static readonly int HttpMethodConstraintOrder;
+            public HttpMethodActionConstraint(IEnumerable<string> httpMethods);
+            public IEnumerable<string> HttpMethods { get; }
+            public int Order { get; }
+            public virtual bool Accept(ActionConstraintContext context);
+        }
     }
     namespace Microsoft.AspNetCore.Mvc.ApplicationModels {
         public class ActionModel : IApiExplorerModel, ICommonModel, IFilterModel, IPropertyModel {
+            public IOutboundParameterTransformer RouteParameterTransformer { get; set; }
         }
     }
     namespace Microsoft.AspNetCore.Mvc.ApplicationParts {
+        public sealed class ApplicationPartAttribute : Attribute {
+            public ApplicationPartAttribute(string assemblyName);
+            public string AssemblyName { get; }
+        }
-        public class AssemblyPart : ApplicationPart, IApplicationPartTypeProvider, ICompilationReferencesProvider {
+        public class AssemblyPart : ApplicationPart, IApplicationPartTypeProvider {
-            public IEnumerable<string> GetReferencePaths();

         }
     }
     namespace Microsoft.AspNetCore.Mvc.Controllers {
-        public class ControllerFactoryProvider : IControllerFactoryProvider {
 {
-            public ControllerFactoryProvider(IControllerActivatorProvider activatorProvider, IControllerFactory controllerFactory, IEnumerable<IControllerPropertyActivator> propertyActivators);

-            public Func<ControllerContext, object> CreateControllerFactory(ControllerActionDescriptor descriptor);

-            public Action<ControllerContext, object> CreateControllerReleaser(ControllerActionDescriptor descriptor);

-        }
-        public class DefaultControllerActivator : IControllerActivator {
 {
-            public DefaultControllerActivator(ITypeActivatorCache typeActivatorCache);

-            public virtual object Create(ControllerContext controllerContext);

-            public virtual void Release(ControllerContext context, object controller);

-        }
-        public class DefaultControllerFactory : IControllerFactory {
 {
-            public DefaultControllerFactory(IControllerActivator controllerActivator, IEnumerable<IControllerPropertyActivator> propertyActivators);

-            protected IControllerActivator ControllerActivator { get; }

-            public virtual object CreateController(ControllerContext context);

-            public virtual void ReleaseController(ControllerContext context, object controller);

-        }
     }
+    namespace Microsoft.AspNetCore.Mvc.Diagnostics {
+        public sealed class AfterActionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterAction";
+            public AfterActionEventData(ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public HttpContext HttpContext { get; }
+            public RouteData RouteData { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterActionFilterOnActionExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecuted";
+            public AfterActionFilterOnActionExecutedEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutedContext ActionExecutedContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterActionFilterOnActionExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecuting";
+            public AfterActionFilterOnActionExecutingEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutingContext ActionExecutingContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterActionFilterOnActionExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecution";
+            public AfterActionFilterOnActionExecutionEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutedContext ActionExecutedContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterActionResultEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterActionResult";
+            public AfterActionResultEventData(ActionContext actionContext, IActionResult result);
+            public ActionContext ActionContext { get; }
+            protected override int Count { get; }
+            public IActionResult Result { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterAuthorizationFilterOnAuthorizationEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnAuthorization";
+            public AfterAuthorizationFilterOnAuthorizationEventData(ActionDescriptor actionDescriptor, AuthorizationFilterContext authorizationContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public AuthorizationFilterContext AuthorizationContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterControllerActionMethodEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterControllerActionMethod";
+            public AfterControllerActionMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, object controller, IActionResult result);
+            public ActionContext ActionContext { get; }
+            public IReadOnlyDictionary<string, object> Arguments { get; }
+            public object Controller { get; }
+            protected override int Count { get; }
+            public IActionResult Result { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterExceptionFilterOnExceptionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnException";
+            public AfterExceptionFilterOnExceptionEventData(ActionDescriptor actionDescriptor, ExceptionContext exceptionContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public ExceptionContext ExceptionContext { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResourceFilterOnResourceExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecuted";
+            public AfterResourceFilterOnResourceExecutedEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutedContext ResourceExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResourceFilterOnResourceExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecuting";
+            public AfterResourceFilterOnResourceExecutingEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutingContext ResourceExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResourceFilterOnResourceExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecution";
+            public AfterResourceFilterOnResourceExecutionEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutedContext ResourceExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResultFilterOnResultExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecuted";
+            public AfterResultFilterOnResultExecutedEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutedContext ResultExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResultFilterOnResultExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecuting";
+            public AfterResultFilterOnResultExecutingEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutingContext ResultExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterResultFilterOnResultExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecution";
+            public AfterResultFilterOnResultExecutionEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutedContext ResultExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeActionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeAction";
+            public BeforeActionEventData(ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public HttpContext HttpContext { get; }
+            public RouteData RouteData { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeActionFilterOnActionExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecuted";
+            public BeforeActionFilterOnActionExecutedEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutedContext ActionExecutedContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeActionFilterOnActionExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecuting";
+            public BeforeActionFilterOnActionExecutingEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutingContext ActionExecutingContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeActionFilterOnActionExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecution";
+            public BeforeActionFilterOnActionExecutionEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public ActionExecutingContext ActionExecutingContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeActionResultEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeActionResult";
+            public BeforeActionResultEventData(ActionContext actionContext, IActionResult result);
+            public ActionContext ActionContext { get; }
+            protected override int Count { get; }
+            public IActionResult Result { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeAuthorizationFilterOnAuthorizationEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnAuthorization";
+            public BeforeAuthorizationFilterOnAuthorizationEventData(ActionDescriptor actionDescriptor, AuthorizationFilterContext authorizationContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            public AuthorizationFilterContext AuthorizationContext { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeControllerActionMethodEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeControllerActionMethod";
+            public BeforeControllerActionMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> actionArguments, object controller);
+            public IReadOnlyDictionary<string, object> ActionArguments { get; }
+            public ActionContext ActionContext { get; }
+            public object Controller { get; }
+            protected sealed override int Count { get; }
+            protected sealed override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeExceptionFilterOnException : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnException";
+            public BeforeExceptionFilterOnException(ActionDescriptor actionDescriptor, ExceptionContext exceptionContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public ExceptionContext ExceptionContext { get; }
+            public IFilterMetadata Filter { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResourceFilterOnResourceExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecuted";
+            public BeforeResourceFilterOnResourceExecutedEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutedContext ResourceExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResourceFilterOnResourceExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecuting";
+            public BeforeResourceFilterOnResourceExecutingEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutingContext ResourceExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResourceFilterOnResourceExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecution";
+            public BeforeResourceFilterOnResourceExecutionEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResourceExecutingContext ResourceExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResultFilterOnResultExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecuted";
+            public BeforeResultFilterOnResultExecutedEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutedContext ResultExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResultFilterOnResultExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecuting";
+            public BeforeResultFilterOnResultExecutingEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutingContext ResultExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeResultFilterOnResultExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecution";
+            public BeforeResultFilterOnResultExecutionEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+            public ActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IFilterMetadata Filter { get; }
+            public ResultExecutingContext ResultExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public abstract class EventData : IEnumerable, IEnumerable<KeyValuePair<string, object>>, IReadOnlyCollection<KeyValuePair<string, object>>, IReadOnlyList<KeyValuePair<string, object>> {
+            protected const string EventNamespace = "Microsoft.AspNetCore.Mvc.";
+            protected EventData();
+            protected abstract int Count { get; }
+            int System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Count { get; }
+            KeyValuePair<string, object> System.Collections.Generic.IReadOnlyList<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.this[int index] { get; }
+            protected abstract KeyValuePair<string, object> this[int index] { get; }
+            IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+                public KeyValuePair<string, object> Current { get; }
+                object System.Collections.IEnumerator.Current { get; }
+                public void Dispose();
+                public bool MoveNext();
+                void System.Collections.IEnumerator.Reset();
+            }
+        }
+    }
     namespace Microsoft.AspNetCore.Mvc.Formatters {
-        public class FormatFilter : IFilterMetadata, IFormatFilter, IResourceFilter, IResultFilter {
+        public class FormatFilter : IFilterMetadata, IResourceFilter, IResultFilter {
-            public FormatFilter(IOptions<MvcOptions> options);

         }
-        public class InputFormatterException : Exception {
 {
-            public InputFormatterException();

-            public InputFormatterException(string message);

-            public InputFormatterException(string message, Exception innerException);

-        }
         public readonly struct MediaType {
-            public static MediaTypeSegmentWithQuality CreateMediaTypeSegmentWithQuality(string mediaType, int start);

+            public static MediaTypeSegmentWithQuality CreateMediaTypeSegmentWithQuality(string mediaType, int start);
         }
+        public readonly struct MediaTypeSegmentWithQuality {
+            public MediaTypeSegmentWithQuality(StringSegment mediaType, double quality);
+            public StringSegment MediaType { get; }
+            public double Quality { get; }
+            public override string ToString();
+        }
+        public class SystemTextJsonInputFormatter : TextInputFormatter, IInputFormatterExceptionPolicy {
+            public SystemTextJsonInputFormatter(JsonOptions options, ILogger<SystemTextJsonInputFormatter> logger);
+            InputFormatterExceptionPolicy Microsoft.AspNetCore.Mvc.Formatters.IInputFormatterExceptionPolicy.ExceptionPolicy { get; }
+            public JsonSerializerOptions SerializerOptions { get; }
+            public sealed override Task<InputFormatterResult> ReadRequestBodyAsync(InputFormatterContext context, Encoding encoding);
+        }
+        public class SystemTextJsonOutputFormatter : TextOutputFormatter {
+            public SystemTextJsonOutputFormatter(JsonOptions options);
+            public JsonSerializerOptions SerializerOptions { get; }
+            public sealed override Task WriteResponseBodyAsync(OutputFormatterWriteContext context, Encoding selectedEncoding);
+        }
     }
-    namespace Microsoft.AspNetCore.Mvc.Formatters.Internal {
 {
-        public static class AcceptHeaderParser {
 {
-            public static IList<MediaTypeSegmentWithQuality> ParseAcceptHeader(IList<string> acceptHeaders);

-            public static void ParseAcceptHeader(IList<string> acceptHeaders, IList<MediaTypeSegmentWithQuality> parsedValues);

-        }
-        public enum HttpParseResult {
 {
-            InvalidFormat = 2,

-            NotParsed = 1,

-            Parsed = 0,

-        }
-        public static class HttpTokenParsingRules

-        public interface IFormatFilter : IFilterMetadata {
 {
-            string GetFormat(ActionContext context);

-        }
-        public readonly struct MediaTypeSegmentWithQuality {
 {
-            public MediaTypeSegmentWithQuality(StringSegment mediaType, double quality);

-            public StringSegment MediaType { get; }

-            public double Quality { get; }

-            public override string ToString();

-        }
-    }
     namespace Microsoft.AspNetCore.Mvc.Infrastructure {
+        public sealed class ActionResultObjectValueAttribute : Attribute {
+            public ActionResultObjectValueAttribute();
+        }
+        public sealed class ActionResultStatusCodeAttribute : Attribute {
+            public ActionResultStatusCodeAttribute();
+        }
+        public class AmbiguousActionException : InvalidOperationException {
+            protected AmbiguousActionException(SerializationInfo info, StreamingContext context);
+            public AmbiguousActionException(string message);
+        }
+        public interface IApiBehaviorMetadata : IFilterMetadata
         public class ObjectResultExecutor : IActionResultExecutor<ObjectResult> {
+            public ObjectResultExecutor(OutputFormatterSelector formatterSelector, IHttpResponseStreamWriterFactory writerFactory, ILoggerFactory loggerFactory, IOptions<MvcOptions> mvcOptions);
         }
         public class VirtualFileResultExecutor : FileResultExecutorBase, IActionResultExecutor<VirtualFileResult> {
-            public VirtualFileResultExecutor(ILoggerFactory loggerFactory, IHostingEnvironment hostingEnvironment);

+            public VirtualFileResultExecutor(ILoggerFactory loggerFactory, IWebHostEnvironment hostingEnvironment);
         }
     }
-    namespace Microsoft.AspNetCore.Mvc.Internal {
 {
-        public static class ActionAttributeRouteModel {
 {
-            public static IEnumerable<ValueTuple<AttributeRouteModel, SelectorModel, SelectorModel>> GetAttributeRoutes(ActionModel actionModel);

-        }
-        public class ActionConstraintCache {
 {
-            public ActionConstraintCache(IActionDescriptorCollectionProvider collectionProvider, IEnumerable<IActionConstraintProvider> actionConstraintProviders);

-            public IReadOnlyList<IActionConstraint> GetActionConstraints(HttpContext httpContext, ActionDescriptor action);

-        }
-        public class ActionInvokerFactory : IActionInvokerFactory {
 {
-            public ActionInvokerFactory(IEnumerable<IActionInvokerProvider> actionInvokerProviders);

-            public IActionInvoker CreateInvoker(ActionContext actionContext);

-        }
-        public class ActionResultTypeMapper : IActionResultTypeMapper {
 {
-            public ActionResultTypeMapper();

-            public IActionResult Convert(object value, Type returnType);

-            public Type GetResultDataType(Type returnType);

-        }
-        public class ActionSelector : IActionSelector {
 {
-            public ActionSelector(IActionDescriptorCollectionProvider actionDescriptorCollectionProvider, ActionConstraintCache actionConstraintCache, ILoggerFactory loggerFactory);

-            protected virtual IReadOnlyList<ActionDescriptor> SelectBestActions(IReadOnlyList<ActionDescriptor> actions);

-            public ActionDescriptor SelectBestCandidate(RouteContext context, IReadOnlyList<ActionDescriptor> candidates);

-            public IReadOnlyList<ActionDescriptor> SelectCandidates(RouteContext context);

-        }
-        public class AmbiguousActionException : InvalidOperationException {
 {
-            protected AmbiguousActionException(SerializationInfo info, StreamingContext context);

-            public AmbiguousActionException(string message);

-        }
-        public class ApiBehaviorOptionsSetup : ConfigureCompatibilityOptions<ApiBehaviorOptions>, IConfigureOptions<ApiBehaviorOptions> {
 {
-            public ApiBehaviorOptionsSetup(ILoggerFactory loggerFactory, IOptions<MvcCompatibilityOptions> compatibilityOptions);

-            protected override IReadOnlyDictionary<string, object> DefaultValues { get; }

-            public void Configure(ApiBehaviorOptions options);

-            public override void PostConfigure(string name, ApiBehaviorOptions options);

-        }
-        public class ApiDescriptionActionData {
 {
-            public ApiDescriptionActionData();

-            public string GroupName { get; set; }

-        }
-        public static class ApplicationModelConventions {
 {
-            public static void ApplyConventions(ApplicationModel applicationModel, IEnumerable<IApplicationModelConvention> conventions);

-        }
-        public class AttributeRoute : IRouter {
 {
-            public AttributeRoute(IActionDescriptorCollectionProvider actionDescriptorCollectionProvider, IServiceProvider services, Func<ActionDescriptor[], IRouter> handlerFactory);

-            public VirtualPathData GetVirtualPath(VirtualPathContext context);

-            public Task RouteAsync(RouteContext context);

-        }
-        public static class AttributeRouting {
 {
-            public static IRouter CreateAttributeMegaRoute(IServiceProvider services);

-        }
-        public class AuthorizationApplicationModelProvider : IApplicationModelProvider {
 {
-            public AuthorizationApplicationModelProvider(IAuthorizationPolicyProvider policyProvider);

-            public int Order { get; }

-            public static AuthorizeFilter GetFilter(IAuthorizationPolicyProvider policyProvider, IEnumerable<IAuthorizeData> authData);

-            public void OnProvidersExecuted(ApplicationModelProviderContext context);

-            public void OnProvidersExecuting(ApplicationModelProviderContext context);

-        }
-        public class ClientValidatorCache {
 {
-            public ClientValidatorCache();

-            public IReadOnlyList<IClientModelValidator> GetValidators(ModelMetadata metadata, IClientModelValidatorProvider validatorProvider);

-        }
-        public static class ControllerActionDescriptorBuilder {
 {
-            public static void AddRouteValues(ControllerActionDescriptor actionDescriptor, ControllerModel controller, ActionModel action);

-            public static IList<ControllerActionDescriptor> Build(ApplicationModel application);

-        }
-        public class ControllerActionDescriptorProvider : IActionDescriptorProvider {
 {
-            public ControllerActionDescriptorProvider(ApplicationPartManager partManager, IEnumerable<IApplicationModelProvider> applicationModelProviders, IOptions<MvcOptions> optionsAccessor);

-            public int Order { get; }

-            protected internal ApplicationModel BuildModel();

-            protected internal IEnumerable<ControllerActionDescriptor> GetDescriptors();

-            public void OnProvidersExecuted(ActionDescriptorProviderContext context);

-            public void OnProvidersExecuting(ActionDescriptorProviderContext context);

-        }
-        public class ControllerActionFilter : IAsyncActionFilter, IFilterMetadata, IOrderedFilter {
 {
-            public ControllerActionFilter();

-            public int Order { get; set; }

-            public Task OnActionExecutionAsync(ActionExecutingContext context, ActionExecutionDelegate next);

-        }
-        public class ControllerActionInvoker : ResourceInvoker, IActionInvoker {
 {
-            protected override Task InvokeInnerFilterAsync();

-            protected override void ReleaseResources();

-        }
-        public class ControllerActionInvokerCache {
 {
-            public ControllerActionInvokerCache(IActionDescriptorCollectionProvider collectionProvider, ParameterBinder parameterBinder, IModelBinderFactory modelBinderFactory, IModelMetadataProvider modelMetadataProvider, IEnumerable<IFilterProvider> filterProviders, IControllerFactoryProvider factoryProvider, IOptions<MvcOptions> mvcOptions);

-            public (ControllerActionInvokerCacheEntry cacheEntry, IFilterMetadata[] filters) GetCachedResult(ControllerContext controllerContext);

-        }
-        public class ControllerActionInvokerCacheEntry {
 {
-            public FilterItem[] CachedFilters { get; }

-            public ControllerBinderDelegate ControllerBinderDelegate { get; }

-            public Func<ControllerContext, object> ControllerFactory { get; }

-            public Action<ControllerContext, object> ControllerReleaser { get; }

-        }
-        public class ControllerActionInvokerProvider : IActionInvokerProvider {
 {
-            public ControllerActionInvokerProvider(ControllerActionInvokerCache controllerActionInvokerCache, IOptions<MvcOptions> optionsAccessor, ILoggerFactory loggerFactory, DiagnosticSource diagnosticSource, IActionResultTypeMapper mapper);

-            public int Order { get; }

-            public void OnProvidersExecuted(ActionInvokerProviderContext context);

-            public void OnProvidersExecuting(ActionInvokerProviderContext context);

-        }
-        public delegate Task ControllerBinderDelegate(ControllerContext controllerContext, object controller, Dictionary<string, object> arguments);

-        public static class ControllerBinderDelegateProvider {
 {
-            public static ControllerBinderDelegate CreateBinderDelegate(ParameterBinder parameterBinder, IModelBinderFactory modelBinderFactory, IModelMetadataProvider modelMetadataProvider, ControllerActionDescriptor actionDescriptor, MvcOptions mvcOptions);

-        }
-        public class ControllerResultFilter : IAsyncResultFilter, IFilterMetadata, IOrderedFilter {
 {
-            public ControllerResultFilter();

-            public int Order { get; set; }

-            public Task OnResultExecutionAsync(ResultExecutingContext context, ResultExecutionDelegate next);

-        }
-        public class CopyOnWriteList<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T> {
 {
-            public CopyOnWriteList(IReadOnlyList<T> source);

-            public int Count { get; }

-            public bool IsReadOnly { get; }

-            protected IReadOnlyList<T> Readable { get; }

-            public T this[int index] { get; set; }

-            protected List<T> Writable { get; }

-            public void Add(T item);

-            public void Clear();

-            public bool Contains(T item);

-            public void CopyTo(T[] array, int arrayIndex);

-            public IEnumerator<T> GetEnumerator();

-            public int IndexOf(T item);

-            public void Insert(int index, T item);

-            public bool Remove(T item);

-            public void RemoveAt(int index);

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-        }
-        public class DefaultActionConstraintProvider : IActionConstraintProvider {
 {
-            public DefaultActionConstraintProvider();

-            public int Order { get; }

-            public void OnProvidersExecuted(ActionConstraintProviderContext context);

-            public void OnProvidersExecuting(ActionConstraintProviderContext context);

-        }
-        public class DefaultApplicationModelProvider : IApplicationModelProvider {
 {
-            public DefaultApplicationModelProvider(IOptions<MvcOptions> mvcOptionsAccessor, IModelMetadataProvider modelMetadataProvider);

-            public int Order { get; }

-            protected virtual ActionModel CreateActionModel(TypeInfo typeInfo, MethodInfo methodInfo);

-            protected virtual ControllerModel CreateControllerModel(TypeInfo typeInfo);

-            protected virtual ParameterModel CreateParameterModel(ParameterInfo parameterInfo);

-            protected virtual PropertyModel CreatePropertyModel(PropertyInfo propertyInfo);

-            protected virtual bool IsAction(TypeInfo typeInfo, MethodInfo methodInfo);

-            public virtual void OnProvidersExecuted(ApplicationModelProviderContext context);

-            public virtual void OnProvidersExecuting(ApplicationModelProviderContext context);

-        }
-        public class DefaultBindingMetadataProvider : IBindingMetadataProvider, IMetadataDetailsProvider {
 {
-            public DefaultBindingMetadataProvider();

-            public void CreateBindingMetadata(BindingMetadataProviderContext context);

-        }
-        public class DefaultCollectionValidationStrategy : IValidationStrategy {
 {
-            public static readonly DefaultCollectionValidationStrategy Instance;

-            public IEnumerator<ValidationEntry> GetChildren(ModelMetadata metadata, string key, object model);

-            public IEnumerator GetEnumeratorForElementType(ModelMetadata metadata, object model);

-        }
-        public class DefaultComplexObjectValidationStrategy : IValidationStrategy {
 {
-            public static readonly IValidationStrategy Instance;

-            public IEnumerator<ValidationEntry> GetChildren(ModelMetadata metadata, string key, object model);

-        }
-        public class DefaultCompositeMetadataDetailsProvider : IBindingMetadataProvider, ICompositeMetadataDetailsProvider, IDisplayMetadataProvider, IMetadataDetailsProvider, IValidationMetadataProvider {
 {
-            public DefaultCompositeMetadataDetailsProvider(IEnumerable<IMetadataDetailsProvider> providers);

-            public virtual void CreateBindingMetadata(BindingMetadataProviderContext context);

-            public virtual void CreateDisplayMetadata(DisplayMetadataProviderContext context);

-            public virtual void CreateValidationMetadata(ValidationMetadataProviderContext context);

-        }
-        public class DefaultControllerPropertyActivator : IControllerPropertyActivator {
 {
-            public DefaultControllerPropertyActivator();

-            public void Activate(ControllerContext context, object controller);

-            public Action<ControllerContext, object> GetActivatorDelegate(ControllerActionDescriptor actionDescriptor);

-        }
-        public class DefaultFilterProvider : IFilterProvider {
 {
-            public DefaultFilterProvider();

-            public int Order { get; }

-            public void OnProvidersExecuted(FilterProviderContext context);

-            public void OnProvidersExecuting(FilterProviderContext context);

-            public virtual void ProvideFilter(FilterProviderContext context, FilterItem filterItem);

-        }
-        public class DefaultValidationMetadataProvider : IMetadataDetailsProvider, IValidationMetadataProvider {
 {
-            public DefaultValidationMetadataProvider();

-            public void CreateValidationMetadata(ValidationMetadataProviderContext context);

-        }
-        public class DisableRequestSizeLimitFilter : IAuthorizationFilter, IFilterMetadata, IRequestSizePolicy {
 {
-            public DisableRequestSizeLimitFilter(ILoggerFactory loggerFactory);

-            public void OnAuthorization(AuthorizationFilterContext context);

-        }
-        public class ElementalValueProvider : IValueProvider {
 {
-            public ElementalValueProvider(string key, string value, CultureInfo culture);

-            public CultureInfo Culture { get; }

-            public string Key { get; }

-            public string Value { get; }

-            public bool ContainsPrefix(string prefix);

-            public ValueProviderResult GetValue(string key);

-        }
-        public class ExplicitIndexCollectionValidationStrategy : IValidationStrategy {
 {
-            public ExplicitIndexCollectionValidationStrategy(IEnumerable<string> elementKeys);

-            public IEnumerable<string> ElementKeys { get; }

-            public IEnumerator<ValidationEntry> GetChildren(ModelMetadata metadata, string key, object model);

-        }
-        public struct FilterCursor {
 {
-            public FilterCursor(IFilterMetadata[] filters);

-            public FilterCursorItem<TFilter, TFilterAsync> GetNextFilter<TFilter, TFilterAsync>() where TFilter : class where TFilterAsync : class;

-            public void Reset();

-        }
-        public readonly struct FilterCursorItem<TFilter, TFilterAsync> {
 {
-            public FilterCursorItem(TFilter filter, TFilterAsync filterAsync);

-            public TFilter Filter { get; }

-            public TFilterAsync FilterAsync { get; }

-        }
-        public class FilterDescriptorOrderComparer : IComparer<FilterDescriptor> {
 {
-            public FilterDescriptorOrderComparer();

-            public static FilterDescriptorOrderComparer Comparer { get; }

-            public int Compare(FilterDescriptor x, FilterDescriptor y);

-        }
-        public static class FilterFactory {
 {
-            public static IFilterMetadata[] CreateUncachedFilters(IFilterProvider[] filterProviders, ActionContext actionContext, FilterItem[] cachedFilterItems);

-            public static FilterFactoryResult GetAllFilters(IFilterProvider[] filterProviders, ActionContext actionContext);

-        }
-        public readonly struct FilterFactoryResult {
 {
-            public FilterFactoryResult(FilterItem[] cacheableFilters, IFilterMetadata[] filters);

-            public FilterItem[] CacheableFilters { get; }

-            public IFilterMetadata[] Filters { get; }

-        }
-        public class HttpMethodActionConstraint : IActionConstraint, IActionConstraintMetadata {
 {
-            public static readonly int HttpMethodConstraintOrder;

-            public HttpMethodActionConstraint(IEnumerable<string> httpMethods);

-            public IEnumerable<string> HttpMethods { get; }

-            public int Order { get; }

-            public virtual bool Accept(ActionConstraintContext context);

-        }
-        public interface IConsumesActionConstraint : IActionConstraint, IActionConstraintMetadata

-        public interface IControllerPropertyActivator {
 {
-            void Activate(ControllerContext context, object controller);

-            Action<ControllerContext, object> GetActivatorDelegate(ControllerActionDescriptor actionDescriptor);

-        }
-        public interface IMiddlewareFilterFeature {
 {
-            ResourceExecutingContext ResourceExecutingContext { get; }

-            ResourceExecutionDelegate ResourceExecutionDelegate { get; }

-        }
-        public interface IResponseCacheFilter : IFilterMetadata

-        public interface ITypeActivatorCache {
 {
-            TInstance CreateInstance<TInstance>(IServiceProvider serviceProvider, Type optionType);

-        }
-        public class MemoryPoolHttpRequestStreamReaderFactory : IHttpRequestStreamReaderFactory {
 {
-            public static readonly int DefaultBufferSize;

-            public MemoryPoolHttpRequestStreamReaderFactory(ArrayPool<byte> bytePool, ArrayPool<char> charPool);

-            public TextReader CreateReader(Stream stream, Encoding encoding);

-        }
-        public class MemoryPoolHttpResponseStreamWriterFactory : IHttpResponseStreamWriterFactory {
 {
-            public static readonly int DefaultBufferSize;

-            public MemoryPoolHttpResponseStreamWriterFactory(ArrayPool<byte> bytePool, ArrayPool<char> charPool);

-            public TextWriter CreateWriter(Stream stream, Encoding encoding);

-        }
-        public class MiddlewareFilterBuilder {
 {
-            public MiddlewareFilterBuilder(MiddlewareFilterConfigurationProvider configurationProvider);

-            public IApplicationBuilder ApplicationBuilder { get; set; }

-            public RequestDelegate GetPipeline(Type configurationType);

-        }
-        public class MiddlewareFilterConfigurationProvider {
 {
-            public MiddlewareFilterConfigurationProvider();

-            public Action<IApplicationBuilder> CreateConfigureDelegate(Type configurationType);

-        }
-        public class MiddlewareFilterFeature : IMiddlewareFilterFeature {
 {
-            public MiddlewareFilterFeature();

-            public ResourceExecutingContext ResourceExecutingContext { get; set; }

-            public ResourceExecutionDelegate ResourceExecutionDelegate { get; set; }

-        }
-        public class MvcAttributeRouteHandler : IRouter {
 {
-            public MvcAttributeRouteHandler(IActionInvokerFactory actionInvokerFactory, IActionSelector actionSelector, DiagnosticSource diagnosticSource, ILoggerFactory loggerFactory);

-            public MvcAttributeRouteHandler(IActionInvokerFactory actionInvokerFactory, IActionSelector actionSelector, DiagnosticSource diagnosticSource, ILoggerFactory loggerFactory, IActionContextAccessor actionContextAccessor);

-            public ActionDescriptor[] Actions { get; set; }

-            public VirtualPathData GetVirtualPath(VirtualPathContext context);

-            public Task RouteAsync(RouteContext context);

-        }
-        public class MvcBuilder : IMvcBuilder {
 {
-            public MvcBuilder(IServiceCollection services, ApplicationPartManager manager);

-            public ApplicationPartManager PartManager { get; }

-            public IServiceCollection Services { get; }

-        }
-        public class MvcCoreBuilder : IMvcCoreBuilder {
 {
-            public MvcCoreBuilder(IServiceCollection services, ApplicationPartManager manager);

-            public ApplicationPartManager PartManager { get; }

-            public IServiceCollection Services { get; }

-        }
-        public static class MvcCoreDiagnosticSourceExtensions {
 {
-            public static void AfterAction(this DiagnosticSource diagnosticSource, ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);

-            public static void AfterActionMethod(this DiagnosticSource diagnosticSource, ActionContext actionContext, IDictionary<string, object> actionArguments, object controller, IActionResult result);

-            public static void AfterActionResult(this DiagnosticSource diagnosticSource, ActionContext actionContext, IActionResult result);

-            public static void AfterOnActionExecuted(this DiagnosticSource diagnosticSource, ActionExecutedContext actionExecutedContext, IActionFilter filter);

-            public static void AfterOnActionExecuting(this DiagnosticSource diagnosticSource, ActionExecutingContext actionExecutingContext, IActionFilter filter);

-            public static void AfterOnActionExecution(this DiagnosticSource diagnosticSource, ActionExecutedContext actionExecutedContext, IAsyncActionFilter filter);

-            public static void AfterOnAuthorization(this DiagnosticSource diagnosticSource, AuthorizationFilterContext authorizationContext, IAuthorizationFilter filter);

-            public static void AfterOnAuthorizationAsync(this DiagnosticSource diagnosticSource, AuthorizationFilterContext authorizationContext, IAsyncAuthorizationFilter filter);

-            public static void AfterOnException(this DiagnosticSource diagnosticSource, ExceptionContext exceptionContext, IExceptionFilter filter);

-            public static void AfterOnExceptionAsync(this DiagnosticSource diagnosticSource, ExceptionContext exceptionContext, IAsyncExceptionFilter filter);

-            public static void AfterOnResourceExecuted(this DiagnosticSource diagnosticSource, ResourceExecutedContext resourceExecutedContext, IResourceFilter filter);

-            public static void AfterOnResourceExecuting(this DiagnosticSource diagnosticSource, ResourceExecutingContext resourceExecutingContext, IResourceFilter filter);

-            public static void AfterOnResourceExecution(this DiagnosticSource diagnosticSource, ResourceExecutedContext resourceExecutedContext, IAsyncResourceFilter filter);

-            public static void AfterOnResultExecuted(this DiagnosticSource diagnosticSource, ResultExecutedContext resultExecutedContext, IResultFilter filter);

-            public static void AfterOnResultExecuting(this DiagnosticSource diagnosticSource, ResultExecutingContext resultExecutingContext, IResultFilter filter);

-            public static void AfterOnResultExecution(this DiagnosticSource diagnosticSource, ResultExecutedContext resultExecutedContext, IAsyncResultFilter filter);

-            public static void BeforeAction(this DiagnosticSource diagnosticSource, ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);

-            public static void BeforeActionMethod(this DiagnosticSource diagnosticSource, ActionContext actionContext, IDictionary<string, object> actionArguments, object controller);

-            public static void BeforeActionResult(this DiagnosticSource diagnosticSource, ActionContext actionContext, IActionResult result);

-            public static void BeforeOnActionExecuted(this DiagnosticSource diagnosticSource, ActionExecutedContext actionExecutedContext, IActionFilter filter);

-            public static void BeforeOnActionExecuting(this DiagnosticSource diagnosticSource, ActionExecutingContext actionExecutingContext, IActionFilter filter);

-            public static void BeforeOnActionExecution(this DiagnosticSource diagnosticSource, ActionExecutingContext actionExecutingContext, IAsyncActionFilter filter);

-            public static void BeforeOnAuthorization(this DiagnosticSource diagnosticSource, AuthorizationFilterContext authorizationContext, IAuthorizationFilter filter);

-            public static void BeforeOnAuthorizationAsync(this DiagnosticSource diagnosticSource, AuthorizationFilterContext authorizationContext, IAsyncAuthorizationFilter filter);

-            public static void BeforeOnException(this DiagnosticSource diagnosticSource, ExceptionContext exceptionContext, IExceptionFilter filter);

-            public static void BeforeOnExceptionAsync(this DiagnosticSource diagnosticSource, ExceptionContext exceptionContext, IAsyncExceptionFilter filter);

-            public static void BeforeOnResourceExecuted(this DiagnosticSource diagnosticSource, ResourceExecutedContext resourceExecutedContext, IResourceFilter filter);

-            public static void BeforeOnResourceExecuting(this DiagnosticSource diagnosticSource, ResourceExecutingContext resourceExecutingContext, IResourceFilter filter);

-            public static void BeforeOnResourceExecution(this DiagnosticSource diagnosticSource, ResourceExecutingContext resourceExecutingContext, IAsyncResourceFilter filter);

-            public static void BeforeOnResultExecuted(this DiagnosticSource diagnosticSource, ResultExecutedContext resultExecutedContext, IResultFilter filter);

-            public static void BeforeOnResultExecuting(this DiagnosticSource diagnosticSource, ResultExecutingContext resultExecutingContext, IResultFilter filter);

-            public static void BeforeOnResultExecution(this DiagnosticSource diagnosticSource, ResultExecutingContext resultExecutingContext, IAsyncResultFilter filter);

-        }
-        public class MvcCoreRouteOptionsSetup : IConfigureOptions<RouteOptions> {
 {
-            public MvcCoreRouteOptionsSetup();

-            public void Configure(RouteOptions options);

-        }
-        public class MvcMarkerService {
 {
-            public MvcMarkerService();

-        }
-        public class MvcRouteHandler : IRouter {
 {
-            public MvcRouteHandler(IActionInvokerFactory actionInvokerFactory, IActionSelector actionSelector, DiagnosticSource diagnosticSource, ILoggerFactory loggerFactory);

-            public MvcRouteHandler(IActionInvokerFactory actionInvokerFactory, IActionSelector actionSelector, DiagnosticSource diagnosticSource, ILoggerFactory loggerFactory, IActionContextAccessor actionContextAccessor);

-            public VirtualPathData GetVirtualPath(VirtualPathContext context);

-            public Task RouteAsync(RouteContext context);

-        }
-        public class NonDisposableStream : Stream {
 {
-            public NonDisposableStream(Stream innerStream);

-            public override bool CanRead { get; }

-            public override bool CanSeek { get; }

-            public override bool CanTimeout { get; }

-            public override bool CanWrite { get; }

-            protected Stream InnerStream { get; }

-            public override long Length { get; }

-            public override long Position { get; set; }

-            public override int ReadTimeout { get; set; }

-            public override int WriteTimeout { get; set; }

-            public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);

-            public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);

-            public override void Close();

-            public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);

-            protected override void Dispose(bool disposing);

-            public override int EndRead(IAsyncResult asyncResult);

-            public override void EndWrite(IAsyncResult asyncResult);

-            public override void Flush();

-            public override Task FlushAsync(CancellationToken cancellationToken);

-            public override int Read(byte[] buffer, int offset, int count);

-            public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-            public override int ReadByte();

-            public override long Seek(long offset, SeekOrigin origin);

-            public override void SetLength(long value);

-            public override void Write(byte[] buffer, int offset, int count);

-            public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-            public override void WriteByte(byte value);

-        }
-        public class NoOpBinder : IModelBinder {
 {
-            public static readonly IModelBinder Instance;

-            public NoOpBinder();

-            public Task BindModelAsync(ModelBindingContext bindingContext);

-        }
-        public static class NormalizedRouteValue {
 {
-            public static string GetNormalizedRouteValue(ActionContext context, string key);

-        }
-        public static class ParameterDefaultValues {
 {
-            public static object[] GetParameterDefaultValues(MethodInfo methodInfo);

-            public static bool TryGetDeclaredParameterDefaultValue(ParameterInfo parameterInfo, out object defaultValue);

-        }
-        public class PlaceholderBinder : IModelBinder {
 {
-            public PlaceholderBinder();

-            public IModelBinder Inner { get; set; }

-            public Task BindModelAsync(ModelBindingContext bindingContext);

-        }
-        public class PrefixContainer {
 {
-            public PrefixContainer(ICollection<string> values);

-            public bool ContainsPrefix(string prefix);

-            public IDictionary<string, string> GetKeysFromPrefix(string prefix);

-        }
-        public static class PropertyValueSetter {
 {
-            public static void SetValue(ModelMetadata metadata, object instance, object value);

-        }
-        public class RequestFormLimitsFilter : IAuthorizationFilter, IFilterMetadata, IRequestFormLimitsPolicy {
 {
-            public RequestFormLimitsFilter(ILoggerFactory loggerFactory);

-            public FormOptions FormOptions { get; set; }

-            public void OnAuthorization(AuthorizationFilterContext context);

-        }
-        public class RequestSizeLimitFilter : IAuthorizationFilter, IFilterMetadata, IRequestSizePolicy {
 {
-            public RequestSizeLimitFilter(ILoggerFactory loggerFactory);

-            public long Bytes { get; set; }

-            public void OnAuthorization(AuthorizationFilterContext context);

-        }
-        public abstract class ResourceInvoker {
 {
-            protected readonly ActionContext _actionContext;

-            protected readonly IFilterMetadata[] _filters;

-            protected IActionResult _result;

-            protected readonly IActionResultTypeMapper _mapper;

-            protected FilterCursor _cursor;

-            protected readonly ILogger _logger;

-            protected readonly IList<IValueProviderFactory> _valueProviderFactories;

-            protected readonly DiagnosticSource _diagnosticSource;

-            protected object _instance;

-            public ResourceInvoker(DiagnosticSource diagnosticSource, ILogger logger, IActionResultTypeMapper mapper, ActionContext actionContext, IFilterMetadata[] filters, IList<IValueProviderFactory> valueProviderFactories);

-            public virtual Task InvokeAsync();

-            protected abstract Task InvokeInnerFilterAsync();

-            protected virtual Task InvokeResultAsync(IActionResult result);

-            protected abstract void ReleaseResources();

-        }
-        public class ResponseCacheFilter : IActionFilter, IFilterMetadata, IResponseCacheFilter {
 {
-            public ResponseCacheFilter(CacheProfile cacheProfile, ILoggerFactory loggerFactory);

-            public int Duration { get; set; }

-            public ResponseCacheLocation Location { get; set; }

-            public bool NoStore { get; set; }

-            public string VaryByHeader { get; set; }

-            public string[] VaryByQueryKeys { get; set; }

-            public void OnActionExecuted(ActionExecutedContext context);

-            public void OnActionExecuting(ActionExecutingContext context);

-        }
-        public class ResponseCacheFilterExecutor {
 {
-            public ResponseCacheFilterExecutor(CacheProfile cacheProfile);

-            public int Duration { get; set; }

-            public ResponseCacheLocation Location { get; set; }

-            public bool NoStore { get; set; }

-            public string VaryByHeader { get; set; }

-            public string[] VaryByQueryKeys { get; set; }

-            public void Execute(FilterContext context);

-        }
-        public static class ResponseContentTypeHelper {
 {
-            public static void ResolveContentTypeAndEncoding(string actionResultContentType, string httpResponseContentType, string defaultContentType, out string resolvedContentType, out Encoding resolvedContentTypeEncoding);

-        }
-        public class ShortFormDictionaryValidationStrategy<TKey, TValue> : IValidationStrategy {
 {
-            public ShortFormDictionaryValidationStrategy(IEnumerable<KeyValuePair<string, TKey>> keyMappings, ModelMetadata valueMetadata);

-            public IEnumerable<KeyValuePair<string, TKey>> KeyMappings { get; }

-            public IEnumerator<ValidationEntry> GetChildren(ModelMetadata metadata, string key, object model);

-        }
-        public class TypeActivatorCache : ITypeActivatorCache {
 {
-            public TypeActivatorCache();

-            public TInstance CreateInstance<TInstance>(IServiceProvider serviceProvider, Type implementationType);

-        }
-        public class ValidatorCache {
 {
-            public ValidatorCache();

-            public IReadOnlyList<IModelValidator> GetValidators(ModelMetadata metadata, IModelValidatorProvider validatorProvider);

-        }
-        public static class ViewEnginePath {
 {
-            public static readonly char[] PathSeparators;

-            public static string CombinePath(string first, string second);

-            public static string ResolvePath(string path);

-        }
-    }
     namespace Microsoft.AspNetCore.Mvc.ModelBinding {
         public class FormValueProvider : BindingSourceValueProvider, IEnumerableValueProvider, IValueProvider
         public abstract class JQueryValueProvider : BindingSourceValueProvider, IEnumerableValueProvider, IKeyRewriterValueProvider, IValueProvider
         public class ModelAttributes {
-            public ModelAttributes(IEnumerable<object> typeAttributes);

-            public ModelAttributes(IEnumerable<object> propertyAttributes, IEnumerable<object> typeAttributes);

         }
         public class ModelBinderFactory : IModelBinderFactory {
-            public ModelBinderFactory(IModelMetadataProvider metadataProvider, IOptions<MvcOptions> options);

         }
         public abstract class ObjectModelValidator : IObjectModelValidator {
-            public abstract ValidationVisitor GetValidationVisitor(ActionContext actionContext, IModelValidatorProvider validatorProvider, ValidatorCache validatorCache, IModelMetadataProvider metadataProvider, ValidationStateDictionary validationState);

+            public abstract ValidationVisitor GetValidationVisitor(ActionContext actionContext, IModelValidatorProvider validatorProvider, ValidatorCache validatorCache, IModelMetadataProvider metadataProvider, ValidationStateDictionary validationState);
         }
         public class ParameterBinder {
-            public ParameterBinder(IModelMetadataProvider modelMetadataProvider, IModelBinderFactory modelBinderFactory, IObjectModelValidator validator);

-            public Task<ModelBindingResult> BindModelAsync(ActionContext actionContext, IValueProvider valueProvider, ParameterDescriptor parameter);

-            public virtual Task<ModelBindingResult> BindModelAsync(ActionContext actionContext, IValueProvider valueProvider, ParameterDescriptor parameter, object value);

         }
+        public class PrefixContainer {
+            public PrefixContainer(ICollection<string> values);
+            public bool ContainsPrefix(string prefix);
+            public IDictionary<string, string> GetKeysFromPrefix(string prefix);
+        }
         public class QueryStringValueProvider : BindingSourceValueProvider, IEnumerableValueProvider, IValueProvider
         public class RouteValueProvider : BindingSourceValueProvider
     }
     namespace Microsoft.AspNetCore.Mvc.ModelBinding.Binders {
         public class ArrayModelBinder<TElement> : CollectionModelBinder<TElement> {
-            public ArrayModelBinder(IModelBinder elementBinder);

+            public ArrayModelBinder(IModelBinder elementBinder, ILoggerFactory loggerFactory, bool allowValidatingTopLevelNodes, MvcOptions mvcOptions);
         }
         public class ByteArrayModelBinder : IModelBinder {
-            public ByteArrayModelBinder();

         }
         public class CollectionModelBinder<TElement> : ICollectionModelBinder, IModelBinder {
-            public CollectionModelBinder(IModelBinder elementBinder);

+            public CollectionModelBinder(IModelBinder elementBinder, ILoggerFactory loggerFactory, bool allowValidatingTopLevelNodes, MvcOptions mvcOptions);
         }
         public class ComplexTypeModelBinder : IModelBinder {
-            public ComplexTypeModelBinder(IDictionary<ModelMetadata, IModelBinder> propertyBinders);

         }
         public class DecimalModelBinder : IModelBinder {
-            public DecimalModelBinder(NumberStyles supportedStyles);

         }
         public class DictionaryModelBinder<TKey, TValue> : CollectionModelBinder<KeyValuePair<TKey, TValue>> {
-            public DictionaryModelBinder(IModelBinder keyBinder, IModelBinder valueBinder);

+            public DictionaryModelBinder(IModelBinder keyBinder, IModelBinder valueBinder, ILoggerFactory loggerFactory, bool allowValidatingTopLevelNodes, MvcOptions mvcOptions);
         }
         public class DoubleModelBinder : IModelBinder {
-            public DoubleModelBinder(NumberStyles supportedStyles);

         }
         public class FloatModelBinder : IModelBinder {
-            public FloatModelBinder(NumberStyles supportedStyles);

         }
         public class FormCollectionModelBinder : IModelBinder {
-            public FormCollectionModelBinder();

         }
         public class FormFileModelBinder : IModelBinder {
-            public FormFileModelBinder();

         }
         public class HeaderModelBinder : IModelBinder {
-            public HeaderModelBinder();

         }
         public class KeyValuePairModelBinder<TKey, TValue> : IModelBinder {
-            public KeyValuePairModelBinder(IModelBinder keyBinder, IModelBinder valueBinder);

         }
         public class SimpleTypeModelBinder : IModelBinder {
-            public SimpleTypeModelBinder(Type type);

         }
     }
-    namespace Microsoft.AspNetCore.Mvc.ModelBinding.Internal {
 {
-        public static class ModelBindingHelper {
 {
-            public static bool CanGetCompatibleCollection<T>(ModelBindingContext bindingContext);

-            public static void ClearValidationStateForModel(ModelMetadata modelMetadata, ModelStateDictionary modelState, string modelKey);

-            public static void ClearValidationStateForModel(Type modelType, ModelStateDictionary modelState, IModelMetadataProvider metadataProvider, string modelKey);

-            public static object ConvertTo(object value, Type type, CultureInfo culture);

-            public static T ConvertTo<T>(object value, CultureInfo culture);

-            public static ICollection<T> GetCompatibleCollection<T>(ModelBindingContext bindingContext);

-            public static ICollection<T> GetCompatibleCollection<T>(ModelBindingContext bindingContext, int capacity);

-            public static Expression<Func<ModelMetadata, bool>> GetPropertyFilterExpression<TModel>(Expression<Func<TModel, object>>[] expressions);

-            public static Task<bool> TryUpdateModelAsync(object model, Type modelType, string prefix, ActionContext actionContext, IModelMetadataProvider metadataProvider, IModelBinderFactory modelBinderFactory, IValueProvider valueProvider, IObjectModelValidator objectModelValidator);

-            public static Task<bool> TryUpdateModelAsync(object model, Type modelType, string prefix, ActionContext actionContext, IModelMetadataProvider metadataProvider, IModelBinderFactory modelBinderFactory, IValueProvider valueProvider, IObjectModelValidator objectModelValidator, Func<ModelMetadata, bool> propertyFilter);

-            public static Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, ActionContext actionContext, IModelMetadataProvider metadataProvider, IModelBinderFactory modelBinderFactory, IValueProvider valueProvider, IObjectModelValidator objectModelValidator) where TModel : class;

-            public static Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, ActionContext actionContext, IModelMetadataProvider metadataProvider, IModelBinderFactory modelBinderFactory, IValueProvider valueProvider, IObjectModelValidator objectModelValidator, Func<ModelMetadata, bool> propertyFilter) where TModel : class;

-            public static Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, ActionContext actionContext, IModelMetadataProvider metadataProvider, IModelBinderFactory modelBinderFactory, IValueProvider valueProvider, IObjectModelValidator objectModelValidator, params Expression<Func<TModel, object>>[] includeExpressions) where TModel : class;

-        }
-        public class ValidationStack {
 {
-            public ValidationStack();

-            public int Count { get; }

-            public void Pop(object model);

-            public bool Push(object model);

-        }
-    }
     namespace Microsoft.AspNetCore.Mvc.ModelBinding.Metadata {
         public class ValidationMetadataProviderContext {
+            public IReadOnlyList<object> ParameterAttributes { get; }
         }
     }
     namespace Microsoft.AspNetCore.Mvc.ModelBinding.Validation {
+        public class ClientValidatorCache {
+            public ClientValidatorCache();
+            public IReadOnlyList<IClientModelValidator> GetValidators(ModelMetadata metadata, IClientModelValidatorProvider validatorProvider);
+        }
         public class ValidationVisitor {
-            public ValidationVisitor(ActionContext actionContext, IModelValidatorProvider validatorProvider, ValidatorCache validatorCache, IModelMetadataProvider metadataProvider, ValidationStateDictionary validationState);

+            public ValidationVisitor(ActionContext actionContext, IModelValidatorProvider validatorProvider, ValidatorCache validatorCache, IModelMetadataProvider metadataProvider, ValidationStateDictionary validationState);
-            protected ValidationStack CurrentPath { get; }

         }
+        public class ValidatorCache {
+            public ValidatorCache();
+            public IReadOnlyList<IModelValidator> GetValidators(ModelMetadata metadata, IModelValidatorProvider validatorProvider);
+        }
     }
     namespace Microsoft.AspNetCore.Mvc.Routing {
+        public abstract class DynamicRouteValueTransformer {
+            protected DynamicRouteValueTransformer();
+            public abstract ValueTask<RouteValueDictionary> TransformAsync(HttpContext httpContext, RouteValueDictionary values);
+        }
         public class KnownRouteValueConstraint : IParameterPolicy, IRouteConstraint {
-            public KnownRouteValueConstraint();

         }
     }
     namespace Microsoft.Extensions.DependencyInjection {
         public static class MvcCoreMvcBuilderExtensions {
+            public static IMvcBuilder AddJsonOptions(this IMvcBuilder builder, Action<JsonOptions> configure);
         }
         public static class MvcCoreMvcCoreBuilderExtensions {
+            public static IMvcCoreBuilder AddJsonOptions(this IMvcCoreBuilder builder, Action<JsonOptions> configure);
         }
     }
 }
```

