# Microsoft.AspNetCore.Server.Kestrel.Core

``` diff
 {
     namespace Microsoft.AspNetCore.Server.Kestrel.Core {
         public sealed class BadHttpRequestException : IOException {
-            public static void Throw(RequestRejectionReason reason, HttpMethod method);

         }
         public class KestrelServer : IDisposable, IServer {
+            public KestrelServer(IOptions<KestrelServerOptions> options, IConnectionListenerFactory transportFactory, ILoggerFactory loggerFactory);
-            public KestrelServer(IOptions<KestrelServerOptions> options, ITransportFactory transportFactory, ILoggerFactory loggerFactory);

         }
         public class KestrelServerOptions {
-            public SchedulingMode ApplicationSchedulingMode { get; set; }

+            public bool DisableStringReuse { get; set; }
         }
-        public class ListenOptions : IConnectionBuilder, IEndPointInformation {
+        public class ListenOptions : IConnectionBuilder {
-            public List<IConnectionAdapter> ConnectionAdapters { get; }

-            public FileHandleType HandleType { get; set; }

-            public IPEndPoint IPEndPoint { get; set; }
+            public IPEndPoint IPEndPoint { get; }
-            public bool NoDelay { get; set; }

-            public ListenType Type { get; }

         }
-        public class ServerAddress {
 {
-            public ServerAddress();

-            public string Host { get; private set; }

-            public bool IsUnixPipe { get; }

-            public string PathBase { get; private set; }

-            public int Port { get; internal set; }

-            public string Scheme { get; private set; }

-            public string UnixPipePath { get; }

-            public override bool Equals(object obj);

-            public static ServerAddress FromUrl(string url);

-            public override int GetHashCode();

-            public override string ToString();

-        }
     }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Adapter.Internal {
 {
-        public class AdaptedPipeline : IDuplexPipe {
 {
-            public AdaptedPipeline(IDuplexPipe transport, Pipe inputPipe, Pipe outputPipe, IKestrelTrace log);

-            public Pipe Input { get; }

-            public IKestrelTrace Log { get; }

-            public Pipe Output { get; }

-            PipeReader System.IO.Pipelines.IDuplexPipe.Input { get; }

-            PipeWriter System.IO.Pipelines.IDuplexPipe.Output { get; }

-            public Task RunAsync(Stream stream);

-        }
-        public class ConnectionAdapterContext {
 {
-            public Stream ConnectionStream { get; }

-            public IFeatureCollection Features { get; }

-        }
-        public interface IAdaptedConnection : IDisposable {
 {
-            Stream ConnectionStream { get; }

-        }
-        public interface IConnectionAdapter {
 {
-            bool IsHttps { get; }

-            Task<IAdaptedConnection> OnConnectionAsync(ConnectionAdapterContext context);

-        }
-        public class LoggingConnectionAdapter : IConnectionAdapter {
 {
-            public LoggingConnectionAdapter(ILogger logger);

-            public bool IsHttps { get; }

-            public Task<IAdaptedConnection> OnConnectionAsync(ConnectionAdapterContext context);

-        }
-        public class RawStream : Stream {
 {
-            public RawStream(PipeReader input, PipeWriter output);

-            public override bool CanRead { get; }

-            public override bool CanSeek { get; }

-            public override bool CanWrite { get; }

-            public override long Length { get; }

-            public override long Position { get; set; }

-            public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);

-            public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);

-            public override int EndRead(IAsyncResult asyncResult);

-            public override void EndWrite(IAsyncResult asyncResult);

-            public override void Flush();

-            public override Task FlushAsync(CancellationToken cancellationToken);

-            public override int Read(byte[] buffer, int offset, int count);

-            public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-            public override ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));

-            public override long Seek(long offset, SeekOrigin origin);

-            public override void SetLength(long value);

-            public override void Write(byte[] buffer, int offset, int count);

-            public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-            public override ValueTask WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken = default(CancellationToken));

-        }
-    }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal {
 {
-        public class ConnectionDispatcher : IConnectionDispatcher {
 {
-            public ConnectionDispatcher(ServiceContext serviceContext, ConnectionDelegate connectionDelegate);

-            public Task OnConnection(TransportConnection connection);

-        }
-        public class ConnectionLimitMiddleware {
 {
-            public ConnectionLimitMiddleware(ConnectionDelegate next, long connectionLimit, IKestrelTrace trace);

-            public Task OnConnectionAsync(ConnectionContext connection);

-        }
-        public class ConnectionLogScope : IEnumerable, IEnumerable<KeyValuePair<string, object>>, IReadOnlyCollection<KeyValuePair<string, object>>, IReadOnlyList<KeyValuePair<string, object>> {
 {
-            public ConnectionLogScope(string connectionId);

-            public int Count { get; }

-            public KeyValuePair<string, object> this[int index] { get; }

-            public IEnumerator<KeyValuePair<string, object>> GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public override string ToString();

-        }
-        public class HttpConnection : ITimeoutHandler {
 {
-            public HttpConnection(HttpConnectionContext context);

-            public string ConnectionId { get; }

-            public IPEndPoint LocalEndPoint { get; }

-            public IPEndPoint RemoteEndPoint { get; }

-            public void OnTimeout(TimeoutReason reason);

-            public Task ProcessRequestsAsync<TContext>(IHttpApplication<TContext> httpApplication);

-        }
-        public static class HttpConnectionBuilderExtensions {
 {
-            public static IConnectionBuilder UseHttpServer<TContext>(this IConnectionBuilder builder, ServiceContext serviceContext, IHttpApplication<TContext> application, HttpProtocols protocols);

-            public static IConnectionBuilder UseHttpServer<TContext>(this IConnectionBuilder builder, IList<IConnectionAdapter> adapters, ServiceContext serviceContext, IHttpApplication<TContext> application, HttpProtocols protocols);

-        }
-        public class HttpConnectionContext {
 {
-            public HttpConnectionContext();

-            public IList<IConnectionAdapter> ConnectionAdapters { get; set; }

-            public ConnectionContext ConnectionContext { get; set; }

-            public IFeatureCollection ConnectionFeatures { get; set; }

-            public string ConnectionId { get; set; }

-            public IPEndPoint LocalEndPoint { get; set; }

-            public MemoryPool<byte> MemoryPool { get; set; }

-            public HttpProtocols Protocols { get; set; }

-            public IPEndPoint RemoteEndPoint { get; set; }

-            public ServiceContext ServiceContext { get; set; }

-            public ITimeoutControl TimeoutControl { get; set; }

-            public IDuplexPipe Transport { get; set; }

-        }
-        public class HttpConnectionMiddleware<TContext> {
 {
-            public HttpConnectionMiddleware(IList<IConnectionAdapter> adapters, ServiceContext serviceContext, IHttpApplication<TContext> application, HttpProtocols protocols);

-            public Task OnConnectionAsync(ConnectionContext connectionContext);

-        }
-        public interface IRequestProcessor {
 {
-            void Abort(ConnectionAbortedException ex);

-            void HandleReadDataRateTimeout();

-            void HandleRequestHeadersTimeout();

-            void OnInputOrOutputCompleted();

-            Task ProcessRequestsAsync<TContext>(IHttpApplication<TContext> application);

-            void StopProcessingNextRequest();

-            void Tick(DateTimeOffset now);

-        }
-        public class KestrelServerOptionsSetup : IConfigureOptions<KestrelServerOptions> {
 {
-            public KestrelServerOptionsSetup(IServiceProvider services);

-            public void Configure(KestrelServerOptions options);

-        }
-        public class KestrelTrace : IKestrelTrace, ILogger {
 {
-            protected readonly ILogger _logger;

-            public KestrelTrace(ILogger logger);

-            public virtual void ApplicationAbortedConnection(string connectionId, string traceIdentifier);

-            public virtual void ApplicationError(string connectionId, string traceIdentifier, Exception ex);

-            public virtual void ApplicationNeverCompleted(string connectionId);

-            public virtual IDisposable BeginScope<TState>(TState state);

-            public virtual void ConnectionBadRequest(string connectionId, BadHttpRequestException ex);

-            public virtual void ConnectionDisconnect(string connectionId);

-            public virtual void ConnectionHeadResponseBodyWrite(string connectionId, long count);

-            public virtual void ConnectionKeepAlive(string connectionId);

-            public virtual void ConnectionPause(string connectionId);

-            public virtual void ConnectionRejected(string connectionId);

-            public virtual void ConnectionResume(string connectionId);

-            public virtual void ConnectionStart(string connectionId);

-            public virtual void ConnectionStop(string connectionId);

-            public virtual void HeartbeatSlow(TimeSpan interval, DateTimeOffset now);

-            public virtual void HPackDecodingError(string connectionId, int streamId, HPackDecodingException ex);

-            public virtual void HPackEncodingError(string connectionId, int streamId, HPackEncodingException ex);

-            public virtual void Http2ConnectionClosed(string connectionId, int highestOpenedStreamId);

-            public virtual void Http2ConnectionClosing(string connectionId);

-            public virtual void Http2ConnectionError(string connectionId, Http2ConnectionErrorException ex);

-            public void Http2FrameReceived(string connectionId, Http2Frame frame);

-            public void Http2FrameSending(string connectionId, Http2Frame frame);

-            public virtual void Http2StreamError(string connectionId, Http2StreamErrorException ex);

-            public void Http2StreamResetAbort(string traceIdentifier, Http2ErrorCode error, ConnectionAbortedException abortReason);

-            public virtual bool IsEnabled(LogLevel logLevel);

-            public virtual void Log<TState>(LogLevel logLevel, EventId eventId, TState state, Exception exception, Func<TState, Exception, string> formatter);

-            public virtual void NotAllConnectionsAborted();

-            public virtual void NotAllConnectionsClosedGracefully();

-            public virtual void RequestBodyDone(string connectionId, string traceIdentifier);

-            public virtual void RequestBodyDrainTimedOut(string connectionId, string traceIdentifier);

-            public virtual void RequestBodyMinimumDataRateNotSatisfied(string connectionId, string traceIdentifier, double rate);

-            public virtual void RequestBodyNotEntirelyRead(string connectionId, string traceIdentifier);

-            public virtual void RequestBodyStart(string connectionId, string traceIdentifier);

-            public virtual void RequestProcessingError(string connectionId, Exception ex);

-            public virtual void ResponseMinimumDataRateNotSatisfied(string connectionId, string traceIdentifier);

-        }
-        public class ServiceContext {
 {
-            public ServiceContext();

-            public ConnectionManager ConnectionManager { get; set; }

-            public DateHeaderValueManager DateHeaderValueManager { get; set; }

-            public Heartbeat Heartbeat { get; set; }

-            public IHttpParser<Http1ParsingHandler> HttpParser { get; set; }

-            public IKestrelTrace Log { get; set; }

-            public PipeScheduler Scheduler { get; set; }

-            public KestrelServerOptions ServerOptions { get; set; }

-            public ISystemClock SystemClock { get; set; }

-        }
-    }
     namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http {
-        public enum ConnectionOptions {
 {
-            Close = 1,

-            KeepAlive = 2,

-            None = 0,

-            Upgrade = 4,

-        }
-        public class DateHeaderValueManager : IHeartbeatHandler {
 {
-            public DateHeaderValueManager();

-            public DateHeaderValueManager.DateHeaderValues GetDateHeaderValues();

-            public void OnHeartbeat(DateTimeOffset now);

-            public class DateHeaderValues {
 {
-                public byte[] Bytes;

-                public string String;

-                public DateHeaderValues();

-            }
-        }
-        public class Http1Connection : HttpProtocol, IHttpMinRequestBodyDataRateFeature, IHttpMinResponseDataRateFeature, IRequestProcessor {
 {
-            protected readonly long _keepAliveTicks;

-            public Http1Connection(HttpConnectionContext context);

-            public PipeReader Input { get; }

-            MinDataRate Microsoft.AspNetCore.Server.Kestrel.Core.Features.IHttpMinRequestBodyDataRateFeature.MinDataRate { get; set; }

-            MinDataRate Microsoft.AspNetCore.Server.Kestrel.Core.Features.IHttpMinResponseDataRateFeature.MinDataRate { get; set; }

-            public MinDataRate MinRequestBodyDataRate { get; set; }

-            public MinDataRate MinResponseDataRate { get; set; }

-            public bool RequestTimedOut { get; }

-            public void Abort(ConnectionAbortedException abortReason);

-            protected override void ApplicationAbort();

-            protected override bool BeginRead(out ValueTask<ReadResult> awaitable);

-            protected override void BeginRequestProcessing();

-            protected override MessageBody CreateMessageBody();

-            protected override string CreateRequestId();

-            public void HandleReadDataRateTimeout();

-            public void HandleRequestHeadersTimeout();

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Internal.IRequestProcessor.Tick(DateTimeOffset now);

-            public void OnInputOrOutputCompleted();

-            protected override void OnRequestProcessingEnded();

-            protected override void OnRequestProcessingEnding();

-            protected override void OnReset();

-            public void OnStartLine(HttpMethod method, HttpVersion version, Span<byte> target, Span<byte> path, Span<byte> query, Span<byte> customMethod, bool pathEncoded);

-            public void ParseRequest(ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined);

-            public void SendTimeoutResponse();

-            public void StopProcessingNextRequest();

-            public bool TakeMessageHeaders(ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined);

-            public bool TakeStartLine(ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined);

-            protected override bool TryParseRequest(ReadResult result, out bool endConnection);

-        }
-        public abstract class Http1MessageBody : MessageBody {
 {
-            protected Http1MessageBody(Http1Connection context);

-            protected void Copy(ReadOnlySequence<byte> readableBuffer, PipeWriter writableBuffer);

-            public static MessageBody For(HttpVersion httpVersion, HttpRequestHeaders headers, Http1Connection context);

-            protected override Task OnConsumeAsync();

-            protected override void OnReadStarted();

-            protected override Task OnStopAsync();

-            protected virtual bool Read(ReadOnlySequence<byte> readableBuffer, PipeWriter writableBuffer, out SequencePosition consumed, out SequencePosition examined);

-        }
-        public class Http1OutputProducer : IDisposable, IHttpOutputAborter, IHttpOutputProducer {
 {
-            public Http1OutputProducer(PipeWriter pipeWriter, string connectionId, ConnectionContext connectionContext, IKestrelTrace log, ITimeoutControl timeoutControl, IHttpMinResponseDataRateFeature minResponseDataRateFeature);

-            public void Abort(ConnectionAbortedException error);

-            public void Dispose();

-            public Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));

-            public Task Write100ContinueAsync();

-            public Task WriteAsync<T>(Func<PipeWriter, T, long> callback, T state, CancellationToken cancellationToken);

-            public Task WriteDataAsync(ReadOnlySpan<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));

-            public void WriteResponseHeaders(int statusCode, string reasonPhrase, HttpResponseHeaders responseHeaders);

-            public Task WriteStreamSuffixAsync();

-        }
-        public struct Http1ParsingHandler : IHttpHeadersHandler, IHttpRequestLineHandler {
 {
-            public Http1Connection Connection;

-            public Http1ParsingHandler(Http1Connection connection);

-            public void OnHeader(Span<byte> name, Span<byte> value);

-            public void OnStartLine(HttpMethod method, HttpVersion version, Span<byte> target, Span<byte> path, Span<byte> query, Span<byte> customMethod, bool pathEncoded);

-        }
-        public abstract class HttpHeaders : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IHeaderDictionary {
 {
-            protected bool _isReadOnly;

-            protected Dictionary<string, StringValues> MaybeUnknown;

-            protected long? _contentLength;

-            protected HttpHeaders();

-            public long? ContentLength { get; set; }

-            public int Count { get; }

-            StringValues Microsoft.AspNetCore.Http.IHeaderDictionary.this[string key] { get; set; }

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.IsReadOnly { get; }

-            StringValues System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.this[string key] { get; set; }

-            ICollection<string> System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.Keys { get; }

-            ICollection<StringValues> System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.Values { get; }

-            protected Dictionary<string, StringValues> Unknown { get; }

-            protected virtual bool AddValueFast(string key, in StringValues value);

-            protected static StringValues AppendValue(in StringValues existing, string append);

-            protected static int BitCount(long value);

-            protected virtual void ClearFast();

-            protected virtual bool CopyToFast(KeyValuePair<string, StringValues>[] array, int arrayIndex);

-            protected virtual int GetCountFast();

-            protected virtual IEnumerator<KeyValuePair<string, StringValues>> GetEnumeratorFast();

-            public static TransferCoding GetFinalTransferCoding(in StringValues transferEncoding);

-            public static ConnectionOptions ParseConnection(in StringValues connection);

-            protected virtual bool RemoveFast(string key);

-            public void Reset();

-            public void SetReadOnly();

-            protected virtual void SetValueFast(string key, in StringValues value);

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.Add(KeyValuePair<string, StringValues> item);

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.Clear();

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.Contains(KeyValuePair<string, StringValues> item);

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.CopyTo(KeyValuePair<string, StringValues>[] array, int arrayIndex);

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.Remove(KeyValuePair<string, StringValues> item);

-            void System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.Add(string key, StringValues value);

-            bool System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.ContainsKey(string key);

-            bool System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.Remove(string key);

-            bool System.Collections.Generic.IDictionary<System.String,Microsoft.Extensions.Primitives.StringValues>.TryGetValue(string key, out StringValues value);

-            IEnumerator<KeyValuePair<string, StringValues>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            protected void ThrowArgumentException();

-            protected void ThrowDuplicateKeyException();

-            protected void ThrowHeadersReadOnlyException();

-            protected void ThrowKeyNotFoundException();

-            protected virtual bool TryGetValueFast(string key, out StringValues value);

-            public static void ValidateHeaderNameCharacters(string headerCharacters);

-            public static void ValidateHeaderValueCharacters(in StringValues headerValues);

-            public static void ValidateHeaderValueCharacters(string headerCharacters);

-        }
         public class HttpParser<TRequestHandler> : IHttpParser<TRequestHandler> where TRequestHandler : IHttpHeadersHandler, IHttpRequestLineHandler {
-            bool Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http.IHttpParser<TRequestHandler>.ParseHeaders(TRequestHandler handler, in ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined, out int consumedBytes);

-            public bool ParseHeaders(TRequestHandler handler, in ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined, out int consumedBytes);

+            public bool ParseHeaders(TRequestHandler handler, ref SequenceReader<byte> reader);
         }
-        public abstract class HttpProtocol : IEnumerable, IEnumerable<KeyValuePair<Type, object>>, IFeatureCollection, IHttpBodyControlFeature, IHttpConnectionFeature, IHttpMaxRequestBodySizeFeature, IHttpRequestFeature, IHttpRequestIdentifierFeature, IHttpRequestLifetimeFeature, IHttpResponseControl, IHttpResponseFeature, IHttpUpgradeFeature {
 {
-            protected HttpVersion _httpVersion;

-            protected RequestProcessingStatus _requestProcessingStatus;

-            protected Streams _streams;

-            protected volatile bool _keepAlive;

-            protected string _methodText;

-            public HttpProtocol(HttpConnectionContext context);

-            public bool AllowSynchronousIO { get; set; }

-            public IFeatureCollection ConnectionFeatures { get; }

-            protected string ConnectionId { get; }

-            public string ConnectionIdFeature { get; set; }

-            public bool HasResponseStarted { get; }

-            public bool HasStartedConsumingRequestBody { get; set; }

-            protected HttpRequestHeaders HttpRequestHeaders { get; }

-            public IHttpResponseControl HttpResponseControl { get; set; }

-            protected HttpResponseHeaders HttpResponseHeaders { get; }

-            public string HttpVersion { get; set; }

-            public bool IsUpgradableRequest { get; private set; }

-            public bool IsUpgraded { get; set; }

-            public IPAddress LocalIpAddress { get; set; }

-            public int LocalPort { get; set; }

-            protected IKestrelTrace Log { get; }

-            public long? MaxRequestBodySize { get; set; }

-            public HttpMethod Method { get; set; }

-            bool Microsoft.AspNetCore.Http.Features.IFeatureCollection.IsReadOnly { get; }

-            object Microsoft.AspNetCore.Http.Features.IFeatureCollection.this[Type key] { get; set; }

-            int Microsoft.AspNetCore.Http.Features.IFeatureCollection.Revision { get; }

-            bool Microsoft.AspNetCore.Http.Features.IHttpBodyControlFeature.AllowSynchronousIO { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpConnectionFeature.ConnectionId { get; set; }

-            IPAddress Microsoft.AspNetCore.Http.Features.IHttpConnectionFeature.LocalIpAddress { get; set; }

-            int Microsoft.AspNetCore.Http.Features.IHttpConnectionFeature.LocalPort { get; set; }

-            IPAddress Microsoft.AspNetCore.Http.Features.IHttpConnectionFeature.RemoteIpAddress { get; set; }

-            int Microsoft.AspNetCore.Http.Features.IHttpConnectionFeature.RemotePort { get; set; }

-            bool Microsoft.AspNetCore.Http.Features.IHttpMaxRequestBodySizeFeature.IsReadOnly { get; }

-            long? Microsoft.AspNetCore.Http.Features.IHttpMaxRequestBodySizeFeature.MaxRequestBodySize { get; set; }

-            Stream Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Body { get; set; }

-            IHeaderDictionary Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Headers { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Method { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Path { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.PathBase { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Protocol { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.QueryString { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.RawTarget { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestFeature.Scheme { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpRequestIdentifierFeature.TraceIdentifier { get; set; }

-            CancellationToken Microsoft.AspNetCore.Http.Features.IHttpRequestLifetimeFeature.RequestAborted { get; set; }

-            Stream Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.Body { get; set; }

-            bool Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.HasStarted { get; }

-            IHeaderDictionary Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.Headers { get; set; }

-            string Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.ReasonPhrase { get; set; }

-            int Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.StatusCode { get; set; }

-            bool Microsoft.AspNetCore.Http.Features.IHttpUpgradeFeature.IsUpgradableRequest { get; }

-            public IHttpOutputProducer Output { get; protected set; }

-            public string Path { get; set; }

-            public string PathBase { get; set; }

-            public string QueryString { get; set; }

-            public string RawTarget { get; set; }

-            public string ReasonPhrase { get; set; }

-            public IPAddress RemoteIpAddress { get; set; }

-            public int RemotePort { get; set; }

-            public CancellationToken RequestAborted { get; set; }

-            public Stream RequestBody { get; set; }

-            public Pipe RequestBodyPipe { get; protected set; }

-            public IHeaderDictionary RequestHeaders { get; set; }

-            public Stream ResponseBody { get; set; }

-            public IHeaderDictionary ResponseHeaders { get; set; }

-            public string Scheme { get; set; }

-            protected KestrelServerOptions ServerOptions { get; }

-            public ServiceContext ServiceContext { get; }

-            public int StatusCode { get; set; }

-            public ITimeoutControl TimeoutControl { get; }

-            public string TraceIdentifier { get; set; }

-            protected void AbortRequest();

-            protected abstract void ApplicationAbort();

-            protected virtual bool BeginRead(out ValueTask<ReadResult> awaitable);

-            protected virtual void BeginRequestProcessing();

-            protected abstract MessageBody CreateMessageBody();

-            protected abstract string CreateRequestId();

-            protected Task FireOnCompleted();

-            protected Task FireOnStarting();

-            public Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));

-            public void HandleNonBodyResponseWrite();

-            public Task InitializeResponseAsync(int firstWriteByteCount);

-            public Task InitializeResponseAwaited(Task startingTask, int firstWriteByteCount);

-            public void InitializeStreams(MessageBody messageBody);

-            TFeature Microsoft.AspNetCore.Http.Features.IFeatureCollection.Get<TFeature>();

-            void Microsoft.AspNetCore.Http.Features.IFeatureCollection.Set<TFeature>(TFeature feature);

-            void Microsoft.AspNetCore.Http.Features.IHttpRequestLifetimeFeature.Abort();

-            void Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.OnCompleted(Func<object, Task> callback, object state);

-            void Microsoft.AspNetCore.Http.Features.IHttpResponseFeature.OnStarting(Func<object, Task> callback, object state);

-            Task<Stream> Microsoft.AspNetCore.Http.Features.IHttpUpgradeFeature.UpgradeAsync();

-            public void OnCompleted(Func<object, Task> callback, object state);

-            protected virtual void OnErrorAfterResponseStarted();

-            public void OnHeader(Span<byte> name, Span<byte> value);

-            protected virtual void OnRequestProcessingEnded();

-            protected virtual void OnRequestProcessingEnding();

-            protected abstract void OnReset();

-            public void OnStarting(Func<object, Task> callback, object state);

-            protected void PoisonRequestBodyStream(Exception abortReason);

-            public Task ProcessRequestsAsync<TContext>(IHttpApplication<TContext> application);

-            public void ProduceContinue();

-            protected Task ProduceEnd();

-            protected void ReportApplicationError(Exception ex);

-            public void Reset();

-            protected void ResetHttp1Features();

-            protected void ResetHttp2Features();

-            public void SetBadRequestState(BadHttpRequestException ex);

-            public bool StatusCanHaveBody(int statusCode);

-            public void StopStreams();

-            IEnumerator<KeyValuePair<Type, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.Type,System.Object>>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public void ThrowRequestTargetRejected(Span<byte> target);

-            protected abstract bool TryParseRequest(ReadResult result, out bool endConnection);

-            protected Task TryProduceInvalidRequestResponse();

-            protected void VerifyResponseContentLength();

-            public Task WriteAsync(ReadOnlyMemory<byte> data, CancellationToken cancellationToken = default(CancellationToken));

-            public Task WriteAsyncAwaited(Task initializeTask, ReadOnlyMemory<byte> data, CancellationToken cancellationToken);

-        }
-        public class HttpRequestHeaders : HttpHeaders {
 {
-            public HttpRequestHeaders();

-            public bool HasConnection { get; }

-            public bool HasTransferEncoding { get; }

-            public StringValues HeaderAccept { get; set; }

-            public StringValues HeaderAcceptCharset { get; set; }

-            public StringValues HeaderAcceptEncoding { get; set; }

-            public StringValues HeaderAcceptLanguage { get; set; }

-            public StringValues HeaderAccessControlRequestHeaders { get; set; }

-            public StringValues HeaderAccessControlRequestMethod { get; set; }

-            public StringValues HeaderAllow { get; set; }

-            public StringValues HeaderAuthorization { get; set; }

-            public StringValues HeaderCacheControl { get; set; }

-            public StringValues HeaderConnection { get; set; }

-            public StringValues HeaderContentEncoding { get; set; }

-            public StringValues HeaderContentLanguage { get; set; }

-            public StringValues HeaderContentLength { get; set; }

-            public StringValues HeaderContentLocation { get; set; }

-            public StringValues HeaderContentMD5 { get; set; }

-            public StringValues HeaderContentRange { get; set; }

-            public StringValues HeaderContentType { get; set; }

-            public StringValues HeaderCookie { get; set; }

-            public StringValues HeaderDate { get; set; }

-            public StringValues HeaderExpect { get; set; }

-            public StringValues HeaderExpires { get; set; }

-            public StringValues HeaderFrom { get; set; }

-            public StringValues HeaderHost { get; set; }

-            public StringValues HeaderIfMatch { get; set; }

-            public StringValues HeaderIfModifiedSince { get; set; }

-            public StringValues HeaderIfNoneMatch { get; set; }

-            public StringValues HeaderIfRange { get; set; }

-            public StringValues HeaderIfUnmodifiedSince { get; set; }

-            public StringValues HeaderKeepAlive { get; set; }

-            public StringValues HeaderLastModified { get; set; }

-            public StringValues HeaderMaxForwards { get; set; }

-            public StringValues HeaderOrigin { get; set; }

-            public StringValues HeaderPragma { get; set; }

-            public StringValues HeaderProxyAuthorization { get; set; }

-            public StringValues HeaderRange { get; set; }

-            public StringValues HeaderReferer { get; set; }

-            public StringValues HeaderTE { get; set; }

-            public StringValues HeaderTrailer { get; set; }

-            public StringValues HeaderTransferEncoding { get; set; }

-            public StringValues HeaderTranslate { get; set; }

-            public StringValues HeaderUpgrade { get; set; }

-            public StringValues HeaderUserAgent { get; set; }

-            public StringValues HeaderVia { get; set; }

-            public StringValues HeaderWarning { get; set; }

-            public int HostCount { get; }

-            protected override bool AddValueFast(string key, in StringValues value);

-            public unsafe void Append(byte* pKeyBytes, int keyLength, string value);

-            public void Append(Span<byte> name, string value);

-            protected override void ClearFast();

-            protected override bool CopyToFast(KeyValuePair<string, StringValues>[] array, int arrayIndex);

-            protected override int GetCountFast();

-            public HttpRequestHeaders.Enumerator GetEnumerator();

-            protected override IEnumerator<KeyValuePair<string, StringValues>> GetEnumeratorFast();

-            protected override bool RemoveFast(string key);

-            protected override void SetValueFast(string key, in StringValues value);

-            protected override bool TryGetValueFast(string key, out StringValues value);

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, StringValues>> {
 {
-                public KeyValuePair<string, StringValues> Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
-        public enum HttpRequestTarget {
 {
-            AbsoluteForm = 1,

-            AsteriskForm = 3,

-            AuthorityForm = 2,

-            OriginForm = 0,

-            Unknown = -1,

-        }
-        public class HttpResponseHeaders : HttpHeaders {
 {
-            public HttpResponseHeaders();

-            public bool HasConnection { get; }

-            public bool HasDate { get; }

-            public bool HasServer { get; }

-            public bool HasTransferEncoding { get; }

-            public StringValues HeaderAcceptRanges { get; set; }

-            public StringValues HeaderAccessControlAllowCredentials { get; set; }

-            public StringValues HeaderAccessControlAllowHeaders { get; set; }

-            public StringValues HeaderAccessControlAllowMethods { get; set; }

-            public StringValues HeaderAccessControlAllowOrigin { get; set; }

-            public StringValues HeaderAccessControlExposeHeaders { get; set; }

-            public StringValues HeaderAccessControlMaxAge { get; set; }

-            public StringValues HeaderAge { get; set; }

-            public StringValues HeaderAllow { get; set; }

-            public StringValues HeaderCacheControl { get; set; }

-            public StringValues HeaderConnection { get; set; }

-            public StringValues HeaderContentEncoding { get; set; }

-            public StringValues HeaderContentLanguage { get; set; }

-            public StringValues HeaderContentLength { get; set; }

-            public StringValues HeaderContentLocation { get; set; }

-            public StringValues HeaderContentMD5 { get; set; }

-            public StringValues HeaderContentRange { get; set; }

-            public StringValues HeaderContentType { get; set; }

-            public StringValues HeaderDate { get; set; }

-            public StringValues HeaderETag { get; set; }

-            public StringValues HeaderExpires { get; set; }

-            public StringValues HeaderKeepAlive { get; set; }

-            public StringValues HeaderLastModified { get; set; }

-            public StringValues HeaderLocation { get; set; }

-            public StringValues HeaderPragma { get; set; }

-            public StringValues HeaderProxyAuthenticate { get; set; }

-            public StringValues HeaderRetryAfter { get; set; }

-            public StringValues HeaderServer { get; set; }

-            public StringValues HeaderSetCookie { get; set; }

-            public StringValues HeaderTrailer { get; set; }

-            public StringValues HeaderTransferEncoding { get; set; }

-            public StringValues HeaderUpgrade { get; set; }

-            public StringValues HeaderVary { get; set; }

-            public StringValues HeaderVia { get; set; }

-            public StringValues HeaderWarning { get; set; }

-            public StringValues HeaderWWWAuthenticate { get; set; }

-            protected override bool AddValueFast(string key, in StringValues value);

-            protected override void ClearFast();

-            protected override bool CopyToFast(KeyValuePair<string, StringValues>[] array, int arrayIndex);

-            protected override int GetCountFast();

-            public HttpResponseHeaders.Enumerator GetEnumerator();

-            protected override IEnumerator<KeyValuePair<string, StringValues>> GetEnumeratorFast();

-            protected override bool RemoveFast(string key);

-            public void SetRawConnection(in StringValues value, byte[] raw);

-            public void SetRawDate(in StringValues value, byte[] raw);

-            public void SetRawServer(in StringValues value, byte[] raw);

-            public void SetRawTransferEncoding(in StringValues value, byte[] raw);

-            protected override void SetValueFast(string key, in StringValues value);

-            protected override bool TryGetValueFast(string key, out StringValues value);

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, StringValues>> {
 {
-                public KeyValuePair<string, StringValues> Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
-        public class HttpResponseTrailers : HttpHeaders {
 {
-            public HttpResponseTrailers();

-            public StringValues HeaderETag { get; set; }

-            protected override bool AddValueFast(string key, in StringValues value);

-            protected override void ClearFast();

-            protected override bool CopyToFast(KeyValuePair<string, StringValues>[] array, int arrayIndex);

-            protected override int GetCountFast();

-            public HttpResponseTrailers.Enumerator GetEnumerator();

-            protected override IEnumerator<KeyValuePair<string, StringValues>> GetEnumeratorFast();

-            protected override bool RemoveFast(string key);

-            protected override void SetValueFast(string key, in StringValues value);

-            protected override bool TryGetValueFast(string key, out StringValues value);

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, StringValues>> {
 {
-                public KeyValuePair<string, StringValues> Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
         public interface IHttpHeadersHandler {
+            void OnHeadersComplete();
         }
-        public interface IHttpOutputAborter {
 {
-            void Abort(ConnectionAbortedException abortReason);

-        }
-        public interface IHttpOutputProducer {
 {
-            Task FlushAsync(CancellationToken cancellationToken);

-            Task Write100ContinueAsync();

-            Task WriteAsync<T>(Func<PipeWriter, T, long> callback, T state, CancellationToken cancellationToken);

-            Task WriteDataAsync(ReadOnlySpan<byte> data, CancellationToken cancellationToken);

-            void WriteResponseHeaders(int statusCode, string ReasonPhrase, HttpResponseHeaders responseHeaders);

-            Task WriteStreamSuffixAsync();

-        }
         public interface IHttpParser<TRequestHandler> where TRequestHandler : IHttpHeadersHandler, IHttpRequestLineHandler {
-            bool ParseHeaders(TRequestHandler handler, in ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined, out int consumedBytes);

+            bool ParseHeaders(TRequestHandler handler, ref SequenceReader<byte> reader);
         }
-        public interface IHttpResponseControl {
 {
-            Task FlushAsync(CancellationToken cancellationToken);

-            void ProduceContinue();

-            Task WriteAsync(ReadOnlyMemory<byte> data, CancellationToken cancellationToken);

-        }
-        public abstract class MessageBody {
 {
-            protected MessageBody(HttpProtocol context, MinDataRate minRequestBodyDataRate);

-            public virtual bool IsEmpty { get; }

-            protected IKestrelTrace Log { get; }

-            public bool RequestKeepAlive { get; protected set; }

-            public bool RequestUpgrade { get; protected set; }

-            public static MessageBody ZeroContentLengthClose { get; }

-            public static MessageBody ZeroContentLengthKeepAlive { get; }

-            protected void AddAndCheckConsumedBytes(long consumedBytes);

-            public virtual Task ConsumeAsync();

-            public virtual Task CopyToAsync(Stream destination, CancellationToken cancellationToken = default(CancellationToken));

-            protected virtual Task OnConsumeAsync();

-            protected virtual void OnDataRead(long bytesRead);

-            protected virtual void OnReadStarted();

-            protected virtual void OnReadStarting();

-            protected virtual Task OnStopAsync();

-            public virtual ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));

-            public virtual Task StopAsync();

-            protected void TryProduceContinue();

-        }
-        public static class PathNormalizer {
 {
-            public unsafe static bool ContainsDotSegments(byte* start, byte* end);

-            public static string DecodePath(Span<byte> path, bool pathEncoded, string rawTarget, int queryLength);

-            public unsafe static int RemoveDotSegments(byte* start, byte* end);

-            public static int RemoveDotSegments(Span<byte> input);

-        }
-        public static class PipelineExtensions {
 {
-            public static ArraySegment<byte> GetArray(this Memory<byte> buffer);

-            public static ArraySegment<byte> GetArray(this ReadOnlyMemory<byte> memory);

-            public static ReadOnlySpan<byte> ToSpan(this ReadOnlySequence<byte> buffer);

-        }
-        public enum ProduceEndType {
 {
-            ConnectionKeepAlive = 2,

-            SocketDisconnect = 1,

-            SocketShutdown = 0,

-        }
-        public static class ReasonPhrases {
 {
-            public static byte[] ToStatusBytes(int statusCode, string reasonPhrase = null);

-        }
-        public enum RequestProcessingStatus {
 {
-            AppStarted = 3,

-            ParsingHeaders = 2,

-            ParsingRequestLine = 1,

-            RequestPending = 0,

-            ResponseStarted = 4,

-        }
-        public enum RequestRejectionReason {
 {
-            BadChunkSizeData = 9,

-            BadChunkSuffix = 8,

-            ChunkedRequestIncomplete = 10,

-            ConnectMethodRequired = 23,

-            FinalTransferCodingNotChunked = 19,

-            HeadersExceedMaxTotalSize = 14,

-            InvalidCharactersInHeaderName = 12,

-            InvalidContentLength = 5,

-            InvalidHostHeader = 26,

-            InvalidRequestHeader = 2,

-            InvalidRequestHeadersNoCRLF = 3,

-            InvalidRequestLine = 1,

-            InvalidRequestTarget = 11,

-            LengthRequired = 20,

-            LengthRequiredHttp10 = 21,

-            MalformedRequestInvalidHeaders = 4,

-            MissingHostHeader = 24,

-            MultipleContentLengths = 6,

-            MultipleHostHeaders = 25,

-            OptionsMethodRequired = 22,

-            RequestBodyExceedsContentLength = 28,

-            RequestBodyTimeout = 18,

-            RequestBodyTooLarge = 16,

-            RequestHeadersTimeout = 17,

-            RequestLineTooLong = 13,

-            TooManyHeaders = 15,

-            UnexpectedEndOfRequestContent = 7,

-            UnrecognizedHTTPVersion = 0,

-            UpgradeRequestCannotHavePayload = 27,

-        }
-        public enum TransferCoding {
 {
-            Chunked = 1,

-            None = 0,

-            Other = 2,

-        }
     }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http2 {
 {
-        public class Http2Connection : IHttp2StreamLifetimeHandler, IHttpHeadersHandler, IRequestProcessor {
 {
-            public Http2Connection(HttpConnectionContext context);

-            public static byte[] ClientPreface { get; }

-            public IFeatureCollection ConnectionFeatures { get; }

-            public string ConnectionId { get; }

-            public PipeReader Input { get; }

-            public KestrelServerLimits Limits { get; }

-            public IKestrelTrace Log { get; }

-            public ITimeoutControl TimeoutControl { get; }

-            public void Abort(ConnectionAbortedException ex);

-            public void HandleReadDataRateTimeout();

-            public void HandleRequestHeadersTimeout();

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http2.IHttp2StreamLifetimeHandler.OnStreamCompleted(int streamId);

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Internal.IRequestProcessor.Tick(DateTimeOffset now);

-            public void OnHeader(Span<byte> name, Span<byte> value);

-            public void OnInputOrOutputCompleted();

-            public Task ProcessRequestsAsync<TContext>(IHttpApplication<TContext> application);

-            public void StopProcessingNextRequest();

-            public void StopProcessingNextRequest(bool sendGracefulGoAway = false);

-        }
-        public class Http2ConnectionErrorException : Exception {
 {
-            public Http2ConnectionErrorException(string message, Http2ErrorCode errorCode);

-            public Http2ErrorCode ErrorCode { get; }

-        }
-        public enum Http2ConnectionState {
 {
-            Closed = 2,

-            Closing = 1,

-            Open = 0,

-        }
-        public enum Http2ContinuationFrameFlags : byte {
 {
-            END_HEADERS = (byte)4,

-            NONE = (byte)0,

-        }
-        public enum Http2DataFrameFlags : byte {
 {
-            END_STREAM = (byte)1,

-            NONE = (byte)0,

-            PADDED = (byte)8,

-        }
-        public enum Http2ErrorCode : uint {
 {
-            CANCEL = (uint)8,

-            COMPRESSION_ERROR = (uint)9,

-            CONNECT_ERROR = (uint)10,

-            ENHANCE_YOUR_CALM = (uint)11,

-            FLOW_CONTROL_ERROR = (uint)3,

-            FRAME_SIZE_ERROR = (uint)6,

-            HTTP_1_1_REQUIRED = (uint)13,

-            INADEQUATE_SECURITY = (uint)12,

-            INTERNAL_ERROR = (uint)2,

-            NO_ERROR = (uint)0,

-            PROTOCOL_ERROR = (uint)1,

-            REFUSED_STREAM = (uint)7,

-            SETTINGS_TIMEOUT = (uint)4,

-            STREAM_CLOSED = (uint)5,

-        }
-        public class Http2Frame {
 {
-            public Http2Frame();

-            public bool ContinuationEndHeaders { get; }

-            public Http2ContinuationFrameFlags ContinuationFlags { get; set; }

-            public bool DataEndStream { get; }

-            public Http2DataFrameFlags DataFlags { get; set; }

-            public bool DataHasPadding { get; }

-            public byte DataPadLength { get; set; }

-            public int DataPayloadLength { get; }

-            public byte Flags { get; set; }

-            public Http2ErrorCode GoAwayErrorCode { get; set; }

-            public int GoAwayLastStreamId { get; set; }

-            public bool HeadersEndHeaders { get; }

-            public bool HeadersEndStream { get; }

-            public Http2HeadersFrameFlags HeadersFlags { get; set; }

-            public bool HeadersHasPadding { get; }

-            public bool HeadersHasPriority { get; }

-            public byte HeadersPadLength { get; set; }

-            public int HeadersPayloadLength { get; }

-            public byte HeadersPriorityWeight { get; set; }

-            public int HeadersStreamDependency { get; set; }

-            public int PayloadLength { get; set; }

-            public bool PingAck { get; }

-            public Http2PingFrameFlags PingFlags { get; set; }

-            public bool PriorityIsExclusive { get; set; }

-            public int PriorityStreamDependency { get; set; }

-            public byte PriorityWeight { get; set; }

-            public Http2ErrorCode RstStreamErrorCode { get; set; }

-            public bool SettingsAck { get; }

-            public Http2SettingsFrameFlags SettingsFlags { get; set; }

-            public int StreamId { get; set; }

-            public Http2FrameType Type { get; set; }

-            public int WindowUpdateSizeIncrement { get; set; }

-            public void PrepareContinuation(Http2ContinuationFrameFlags flags, int streamId);

-            public void PrepareData(int streamId, byte? padLength = default(byte?));

-            public void PrepareGoAway(int lastStreamId, Http2ErrorCode errorCode);

-            public void PrepareHeaders(Http2HeadersFrameFlags flags, int streamId);

-            public void PreparePing(Http2PingFrameFlags flags);

-            public void PreparePriority(int streamId, int streamDependency, bool exclusive, byte weight);

-            public void PrepareRstStream(int streamId, Http2ErrorCode errorCode);

-            public void PrepareSettings(Http2SettingsFrameFlags flags);

-            public void PrepareWindowUpdate(int streamId, int sizeIncrement);

-            public override string ToString();

-        }
-        public static class Http2FrameReader {
 {
-            public const int HeaderLength = 9;

-            public const int SettingSize = 6;

-            public static int GetPayloadFieldsLength(Http2Frame frame);

-            public static bool ReadFrame(ReadOnlySequence<byte> readableBuffer, Http2Frame frame, uint maxFrameSize, out ReadOnlySequence<byte> framePayload);

-            public static IList<Http2PeerSetting> ReadSettings(ReadOnlySequence<byte> payload);

-        }
-        public enum Http2FrameType : byte {
 {
-            CONTINUATION = (byte)9,

-            DATA = (byte)0,

-            GOAWAY = (byte)7,

-            HEADERS = (byte)1,

-            PING = (byte)6,

-            PRIORITY = (byte)2,

-            PUSH_PROMISE = (byte)5,

-            RST_STREAM = (byte)3,

-            SETTINGS = (byte)4,

-            WINDOW_UPDATE = (byte)8,

-        }
-        public class Http2FrameWriter {
 {
-            public Http2FrameWriter(PipeWriter outputPipeWriter, ConnectionContext connectionContext, Http2Connection http2Connection, OutputFlowControl connectionOutputFlowControl, ITimeoutControl timeoutControl, MinDataRate minResponseDataRate, string connectionId, IKestrelTrace log);

-            public void Abort(ConnectionAbortedException error);

-            public void AbortPendingStreamDataWrites(StreamOutputFlowControl flowControl);

-            public void Complete();

-            public Task FlushAsync(IHttpOutputAborter outputAborter, CancellationToken cancellationToken);

-            public bool TryUpdateConnectionWindow(int bytes);

-            public bool TryUpdateStreamWindow(StreamOutputFlowControl flowControl, int bytes);

-            public void UpdateMaxFrameSize(uint maxFrameSize);

-            public Task Write100ContinueAsync(int streamId);

-            public Task WriteDataAsync(int streamId, StreamOutputFlowControl flowControl, ReadOnlySequence<byte> data, bool endStream);

-            public Task WriteGoAwayAsync(int lastStreamId, Http2ErrorCode errorCode);

-            public Task WritePingAsync(Http2PingFrameFlags flags, ReadOnlySequence<byte> payload);

-            public void WriteResponseHeaders(int streamId, int statusCode, IHeaderDictionary headers);

-            public Task WriteResponseTrailers(int streamId, HttpResponseTrailers headers);

-            public Task WriteRstStreamAsync(int streamId, Http2ErrorCode errorCode);

-            public Task WriteSettingsAckAsync();

-            public Task WriteSettingsAsync(IList<Http2PeerSetting> settings);

-            public Task WriteWindowUpdateAsync(int streamId, int sizeIncrement);

-        }
-        public enum Http2HeadersFrameFlags : byte {
 {
-            END_HEADERS = (byte)4,

-            END_STREAM = (byte)1,

-            NONE = (byte)0,

-            PADDED = (byte)8,

-            PRIORITY = (byte)32,

-        }
-        public class Http2MessageBody : MessageBody {
 {
-            public static MessageBody For(Http2Stream context, MinDataRate minRequestBodyDataRate);

-            protected override void OnDataRead(long bytesRead);

-            protected override void OnReadStarted();

-            protected override void OnReadStarting();

-        }
-        public class Http2OutputProducer : IHttpOutputAborter, IHttpOutputProducer {
 {
-            public Http2OutputProducer(int streamId, Http2FrameWriter frameWriter, StreamOutputFlowControl flowControl, ITimeoutControl timeoutControl, MemoryPool<byte> pool, Http2Stream stream, IKestrelTrace log);

-            public void Dispose();

-            public Task FlushAsync(CancellationToken cancellationToken);

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http.IHttpOutputAborter.Abort(ConnectionAbortedException abortReason);

-            public Task Write100ContinueAsync();

-            public Task WriteAsync<T>(Func<PipeWriter, T, long> callback, T state, CancellationToken cancellationToken);

-            public Task WriteDataAsync(ReadOnlySpan<byte> data, CancellationToken cancellationToken);

-            public void WriteResponseHeaders(int statusCode, string ReasonPhrase, HttpResponseHeaders responseHeaders);

-            public Task WriteRstStreamAsync(Http2ErrorCode error);

-            public Task WriteStreamSuffixAsync();

-        }
-        public struct Http2PeerSetting {
 {
-            public Http2PeerSetting(Http2SettingsParameter parameter, uint value);

-            public Http2SettingsParameter Parameter { get; }

-            public uint Value { get; }

-        }
-        public class Http2PeerSettings {
 {
-            public const bool DefaultEnablePush = true;

-            public const uint DefaultHeaderTableSize = (uint)4096;

-            public const uint DefaultInitialWindowSize = (uint)65535;

-            public const uint DefaultMaxConcurrentStreams = (uint)4294967295;

-            public const uint DefaultMaxFrameSize = (uint)16384;

-            public const uint DefaultMaxHeaderListSize = (uint)4294967295;

-            public const uint MaxWindowSize = (uint)2147483647;

-            public Http2PeerSettings();

-            public bool EnablePush { get; set; }

-            public uint HeaderTableSize { get; set; }

-            public uint InitialWindowSize { get; set; }

-            public uint MaxConcurrentStreams { get; set; }

-            public uint MaxFrameSize { get; set; }

-            public uint MaxHeaderListSize { get; set; }

-            public void Update(IList<Http2PeerSetting> settings);

-        }
-        public enum Http2PingFrameFlags : byte {
 {
-            ACK = (byte)1,

-            NONE = (byte)0,

-        }
-        public enum Http2SettingsFrameFlags : byte {
 {
-            ACK = (byte)1,

-            NONE = (byte)0,

-        }
-        public enum Http2SettingsParameter : ushort {
 {
-            SETTINGS_ENABLE_PUSH = (ushort)2,

-            SETTINGS_HEADER_TABLE_SIZE = (ushort)1,

-            SETTINGS_INITIAL_WINDOW_SIZE = (ushort)4,

-            SETTINGS_MAX_CONCURRENT_STREAMS = (ushort)3,

-            SETTINGS_MAX_FRAME_SIZE = (ushort)5,

-            SETTINGS_MAX_HEADER_LIST_SIZE = (ushort)6,

-        }
-        public class Http2SettingsParameterOutOfRangeException : Exception {
 {
-            public Http2SettingsParameterOutOfRangeException(Http2SettingsParameter parameter, long lowerBound, long upperBound);

-            public Http2SettingsParameter Parameter { get; }

-        }
-        public class Http2Stream : HttpProtocol, IHttp2StreamIdFeature, IHttpResponseTrailersFeature {
 {
-            public Http2Stream(Http2StreamContext context);

-            public bool EndStreamReceived { get; }

-            public long? InputRemaining { get; internal set; }

-            IHeaderDictionary Microsoft.AspNetCore.Http.Features.IHttpResponseTrailersFeature.Trailers { get; set; }

-            int Microsoft.AspNetCore.Server.Kestrel.Core.Features.IHttp2StreamIdFeature.StreamId { get; }

-            public bool RequestBodyStarted { get; private set; }

-            public int StreamId { get; }

-            public void Abort(IOException abortReason);

-            public void AbortRstStreamReceived();

-            protected override void ApplicationAbort();

-            protected override MessageBody CreateMessageBody();

-            protected override string CreateRequestId();

-            public Task OnDataAsync(Http2Frame dataFrame, ReadOnlySequence<byte> payload);

-            public void OnDataRead(int bytesRead);

-            public void OnEndStreamReceived();

-            protected override void OnErrorAfterResponseStarted();

-            protected override void OnRequestProcessingEnded();

-            protected override void OnReset();

-            protected override bool TryParseRequest(ReadResult result, out bool endConnection);

-            public bool TryUpdateOutputWindow(int bytes);

-        }
-        public class Http2StreamContext : HttpConnectionContext {
 {
-            public Http2StreamContext();

-            public Http2PeerSettings ClientPeerSettings { get; set; }

-            public InputFlowControl ConnectionInputFlowControl { get; set; }

-            public OutputFlowControl ConnectionOutputFlowControl { get; set; }

-            public Http2FrameWriter FrameWriter { get; set; }

-            public Http2PeerSettings ServerPeerSettings { get; set; }

-            public int StreamId { get; set; }

-            public IHttp2StreamLifetimeHandler StreamLifetimeHandler { get; set; }

-        }
-        public class Http2StreamErrorException : Exception {
 {
-            public Http2StreamErrorException(int streamId, string message, Http2ErrorCode errorCode);

-            public Http2ErrorCode ErrorCode { get; }

-            public int StreamId { get; }

-        }
-        public interface IHttp2StreamLifetimeHandler {
 {
-            void OnStreamCompleted(int streamId);

-        }
-        public class ThreadPoolAwaitable : ICriticalNotifyCompletion, INotifyCompletion {
 {
-            public static ThreadPoolAwaitable Instance;

-            public bool IsCompleted { get; }

-            public ThreadPoolAwaitable GetAwaiter();

-            public void GetResult();

-            public void OnCompleted(Action continuation);

-            public void UnsafeOnCompleted(Action continuation);

-        }
-    }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http2.FlowControl {
 {
-        public struct FlowControl {
 {
-            public FlowControl(uint initialWindowSize);

-            public int Available { get; private set; }

-            public bool IsAborted { get; private set; }

-            public void Abort();

-            public void Advance(int bytes);

-            public bool TryUpdateWindow(int bytes);

-        }
-        public class InputFlowControl {
 {
-            public InputFlowControl(uint initialWindowSize, uint minWindowSizeIncrement);

-            public bool IsAvailabilityLow { get; }

-            public int Abort();

-            public void StopWindowUpdates();

-            public bool TryAdvance(int bytes);

-            public bool TryUpdateWindow(int bytes, out int updateSize);

-        }
-        public class OutputFlowControl {
 {
-            public OutputFlowControl(uint initialWindowSize);

-            public OutputFlowControlAwaitable AvailabilityAwaitable { get; }

-            public int Available { get; }

-            public bool IsAborted { get; }

-            public void Abort();

-            public void Advance(int bytes);

-            public bool TryUpdateWindow(int bytes);

-        }
-        public class OutputFlowControlAwaitable : ICriticalNotifyCompletion, INotifyCompletion {
 {
-            public OutputFlowControlAwaitable();

-            public bool IsCompleted { get; }

-            public void Complete();

-            public OutputFlowControlAwaitable GetAwaiter();

-            public void GetResult();

-            public void OnCompleted(Action continuation);

-            public void UnsafeOnCompleted(Action continuation);

-        }
-        public class StreamInputFlowControl {
 {
-            public StreamInputFlowControl(int streamId, Http2FrameWriter frameWriter, InputFlowControl connectionLevelFlowControl, uint initialWindowSize, uint minWindowSizeIncrement);

-            public void Abort();

-            public void Advance(int bytes);

-            public void StopWindowUpdates();

-            public void UpdateWindows(int bytes);

-        }
-        public class StreamOutputFlowControl {
 {
-            public StreamOutputFlowControl(OutputFlowControl connectionLevelFlowControl, uint initialWindowSize);

-            public int Available { get; }

-            public bool IsAborted { get; }

-            public void Abort();

-            public void Advance(int bytes);

-            public int AdvanceUpToAndWait(long bytes, out OutputFlowControlAwaitable awaitable);

-            public bool TryUpdateWindow(int bytes);

-        }
-    }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http2.HPack {
 {
-        public class DynamicTable {
 {
-            public DynamicTable(int maxSize);

-            public int Count { get; }

-            public int MaxSize { get; }

-            public int Size { get; }

-            public HeaderField this[int index] { get; }

-            public void Insert(Span<byte> name, Span<byte> value);

-            public void Resize(int maxSize);

-        }
-        public struct HeaderField {
 {
-            public const int RfcOverhead = 32;

-            public HeaderField(Span<byte> name, Span<byte> value);

-            public int Length { get; }

-            public byte[] Name { get; }

-            public byte[] Value { get; }

-            public static int GetLength(int nameLength, int valueLength);

-        }
-        public class HPackDecoder {
 {
-            public HPackDecoder(int maxDynamicTableSize, int maxRequestHeaderFieldSize);

-            public void Decode(ReadOnlySequence<byte> data, bool endHeaders, IHttpHeadersHandler handler);

-        }
-        public class HPackDecodingException : Exception {
 {
-            public HPackDecodingException(string message);

-            public HPackDecodingException(string message, Exception innerException);

-        }
-        public class HPackEncoder {
 {
-            public HPackEncoder();

-            public bool BeginEncode(IEnumerable<KeyValuePair<string, string>> headers, Span<byte> buffer, out int length);

-            public bool BeginEncode(int statusCode, IEnumerable<KeyValuePair<string, string>> headers, Span<byte> buffer, out int length);

-            public bool Encode(Span<byte> buffer, out int length);

-        }
-        public class HPackEncodingException : Exception {
 {
-            public HPackEncodingException(string message);

-            public HPackEncodingException(string message, Exception innerException);

-        }
-        public class Huffman {
 {
-            public Huffman();

-            public static int Decode(ReadOnlySpan<byte> src, Span<byte> dst);

-            public static (uint encoded, int bitLength) Encode(int data);

-        }
-        public class HuffmanDecodingException : Exception {
 {
-            public HuffmanDecodingException(string message);

-        }
-        public class IntegerDecoder {
 {
-            public IntegerDecoder();

-            public bool BeginTryDecode(byte b, int prefixLength, out int result);

-            public static void ThrowIntegerTooBigException();

-            public bool TryDecode(byte b, out int result);

-        }
-        public static class IntegerEncoder {
 {
-            public static bool Encode(int i, int n, Span<byte> buffer, out int length);

-        }
-        public class StaticTable {
 {
-            public int Count { get; }

-            public static StaticTable Instance { get; }

-            public IReadOnlyDictionary<int, int> StatusIndex { get; }

-            public HeaderField this[int index] { get; }

-        }
-        public static class StatusCodes {
 {
-            public static byte[] ToStatusBytes(int statusCode);

-        }
-    }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Infrastructure {
 {
-        public class ConnectionManager {
 {
-            public ConnectionManager(IKestrelTrace trace, ResourceCounter upgradedConnections);

-            public ConnectionManager(IKestrelTrace trace, long? upgradedConnectionLimit);

-            public ResourceCounter UpgradedConnectionCount { get; }

-            public void AddConnection(long id, KestrelConnection connection);

-            public void RemoveConnection(long id);

-            public void Walk(Action<KestrelConnection> callback);

-        }
-        public static class ConnectionManagerShutdownExtensions {
 {
-            public static Task<bool> AbortAllConnectionsAsync(this ConnectionManager connectionManager);

-            public static Task<bool> CloseAllConnectionsAsync(this ConnectionManager connectionManager, CancellationToken token);

-        }
-        public class ConnectionReference {
 {
-            public ConnectionReference(KestrelConnection connection);

-            public string ConnectionId { get; }

-            public bool TryGetConnection(out KestrelConnection connection);

-        }
-        public class Disposable : IDisposable {
 {
-            public Disposable(Action dispose);

-            public void Dispose();

-            protected virtual void Dispose(bool disposing);

-        }
-        public class Heartbeat : IDisposable {
 {
-            public static readonly TimeSpan Interval;

-            public Heartbeat(IHeartbeatHandler[] callbacks, ISystemClock systemClock, IDebugger debugger, IKestrelTrace trace);

-            public void Dispose();

-            public void Start();

-        }
-        public class HeartbeatManager : IHeartbeatHandler, ISystemClock {
 {
-            public HeartbeatManager(ConnectionManager connectionManager);

-            public DateTimeOffset UtcNow { get; }

-            public void OnHeartbeat(DateTimeOffset now);

-        }
-        public static class HttpUtilities {
 {
-            public const string Http10Version = "HTTP/1.0";

-            public const string Http11Version = "HTTP/1.1";

-            public const string Http2Version = "HTTP/2";

-            public const string HttpsUriScheme = "https://";

-            public const string HttpUriScheme = "http://";

-            public static string GetAsciiOrUTF8StringNonNullCharacters(this Span<byte> span);

-            public static string GetAsciiStringEscaped(this Span<byte> span, int maxChars);

-            public static string GetAsciiStringNonNullCharacters(this Span<byte> span);

-            public static bool GetKnownHttpScheme(this Span<byte> span, out HttpScheme knownScheme);

-            public static bool GetKnownMethod(this Span<byte> span, out HttpMethod method, out int length);

-            public static HttpMethod GetKnownMethod(string value);

-            public static bool GetKnownVersion(this Span<byte> span, out HttpVersion knownVersion, out byte length);

-            public static bool IsHostHeaderValid(string hostText);

-            public static string MethodToString(HttpMethod method);

-            public static string SchemeToString(HttpScheme scheme);

-            public static string VersionToString(HttpVersion httpVersion);

-        }
-        public interface IDebugger {
 {
-            bool IsAttached { get; }

-        }
-        public interface IHeartbeatHandler {
 {
-            void OnHeartbeat(DateTimeOffset now);

-        }
-        public interface IKestrelTrace : ILogger {
 {
-            void ApplicationAbortedConnection(string connectionId, string traceIdentifier);

-            void ApplicationError(string connectionId, string traceIdentifier, Exception ex);

-            void ApplicationNeverCompleted(string connectionId);

-            void ConnectionBadRequest(string connectionId, BadHttpRequestException ex);

-            void ConnectionDisconnect(string connectionId);

-            void ConnectionHeadResponseBodyWrite(string connectionId, long count);

-            void ConnectionKeepAlive(string connectionId);

-            void ConnectionPause(string connectionId);

-            void ConnectionRejected(string connectionId);

-            void ConnectionResume(string connectionId);

-            void ConnectionStart(string connectionId);

-            void ConnectionStop(string connectionId);

-            void HeartbeatSlow(TimeSpan interval, DateTimeOffset now);

-            void HPackDecodingError(string connectionId, int streamId, HPackDecodingException ex);

-            void HPackEncodingError(string connectionId, int streamId, HPackEncodingException ex);

-            void Http2ConnectionClosed(string connectionId, int highestOpenedStreamId);

-            void Http2ConnectionClosing(string connectionId);

-            void Http2ConnectionError(string connectionId, Http2ConnectionErrorException ex);

-            void Http2FrameReceived(string connectionId, Http2Frame frame);

-            void Http2FrameSending(string connectionId, Http2Frame frame);

-            void Http2StreamError(string connectionId, Http2StreamErrorException ex);

-            void Http2StreamResetAbort(string traceIdentifier, Http2ErrorCode error, ConnectionAbortedException abortReason);

-            void NotAllConnectionsAborted();

-            void NotAllConnectionsClosedGracefully();

-            void RequestBodyDone(string connectionId, string traceIdentifier);

-            void RequestBodyDrainTimedOut(string connectionId, string traceIdentifier);

-            void RequestBodyMinimumDataRateNotSatisfied(string connectionId, string traceIdentifier, double rate);

-            void RequestBodyNotEntirelyRead(string connectionId, string traceIdentifier);

-            void RequestBodyStart(string connectionId, string traceIdentifier);

-            void RequestProcessingError(string connectionId, Exception ex);

-            void ResponseMinimumDataRateNotSatisfied(string connectionId, string traceIdentifier);

-        }
-        public interface ISystemClock {
 {
-            DateTimeOffset UtcNow { get; }

-        }
-        public interface ITimeoutControl {
 {
-            TimeoutReason TimerReason { get; }

-            void BytesRead(long count);

-            void BytesWrittenToBuffer(MinDataRate minRate, long count);

-            void CancelTimeout();

-            void InitializeHttp2(InputFlowControl connectionInputFlowControl);

-            void ResetTimeout(long ticks, TimeoutReason timeoutReason);

-            void SetTimeout(long ticks, TimeoutReason timeoutReason);

-            void StartRequestBody(MinDataRate minRate);

-            void StartTimingRead();

-            void StartTimingWrite();

-            void StopRequestBody();

-            void StopTimingRead();

-            void StopTimingWrite();

-        }
-        public interface ITimeoutHandler {
 {
-            void OnTimeout(TimeoutReason reason);

-        }
-        public class KestrelConnection {
 {
-            public KestrelConnection(TransportConnection transportConnection);

-            public Task ExecutionTask { get; }

-            public TransportConnection TransportConnection { get; }

-        }
-        public sealed class KestrelEventSource : EventSource {
 {
-            public static readonly KestrelEventSource Log;

-            public void ConnectionRejected(string connectionId);

-            public void ConnectionStart(TransportConnection connection);

-            public void ConnectionStop(TransportConnection connection);

-            public void RequestStart(HttpProtocol httpProtocol);

-            public void RequestStop(HttpProtocol httpProtocol);

-        }
-        public abstract class ReadOnlyStream : Stream {
 {
-            protected ReadOnlyStream();

-            public override bool CanRead { get; }

-            public override bool CanWrite { get; }

-            public override int WriteTimeout { get; set; }

-            public override void Write(byte[] buffer, int offset, int count);

-            public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-        }
-        public abstract class ResourceCounter {
 {
-            protected ResourceCounter();

-            public static ResourceCounter Unlimited { get; }

-            public static ResourceCounter Quota(long amount);

-            public abstract void ReleaseOne();

-            public abstract bool TryLockOne();

-        }
-        public class Streams {
 {
-            public Streams(IHttpBodyControlFeature bodyControl, IHttpResponseControl httpResponseControl);

-            public void Abort(Exception error);

-            public (Stream request, Stream response) Start(MessageBody body);

-            public void Stop();

-            public Stream Upgrade();

-        }
-        public class ThrowingWasUpgradedWriteOnlyStream : WriteOnlyStream {
 {
-            public ThrowingWasUpgradedWriteOnlyStream();

-            public override bool CanSeek { get; }

-            public override long Length { get; }

-            public override long Position { get; set; }

-            public override void Flush();

-            public override long Seek(long offset, SeekOrigin origin);

-            public override void SetLength(long value);

-            public override void Write(byte[] buffer, int offset, int count);

-            public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-        }
-        public class TimeoutControl : IConnectionTimeoutFeature, ITimeoutControl {
 {
-            public TimeoutControl(ITimeoutHandler timeoutHandler);

-            public TimeoutReason TimerReason { get; private set; }

-            public void BytesRead(long count);

-            public void BytesWrittenToBuffer(MinDataRate minRate, long count);

-            public void CancelTimeout();

-            public void Initialize(DateTimeOffset now);

-            public void InitializeHttp2(InputFlowControl connectionInputFlowControl);

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Features.IConnectionTimeoutFeature.ResetTimeout(TimeSpan timeSpan);

-            void Microsoft.AspNetCore.Server.Kestrel.Core.Features.IConnectionTimeoutFeature.SetTimeout(TimeSpan timeSpan);

-            public void ResetTimeout(long ticks, TimeoutReason timeoutReason);

-            public void SetTimeout(long ticks, TimeoutReason timeoutReason);

-            public void StartRequestBody(MinDataRate minRate);

-            public void StartTimingRead();

-            public void StartTimingWrite();

-            public void StopRequestBody();

-            public void StopTimingRead();

-            public void StopTimingWrite();

-            public void Tick(DateTimeOffset now);

-        }
-        public static class TimeoutControlExtensions {
 {
-            public static void StartDrainTimeout(this ITimeoutControl timeoutControl, MinDataRate minDataRate, long? maxResponseBufferSize);

-        }
-        public enum TimeoutReason {
 {
-            KeepAlive = 1,

-            None = 0,

-            ReadDataRate = 3,

-            RequestBodyDrain = 5,

-            RequestHeaders = 2,

-            TimeoutFeature = 6,

-            WriteDataRate = 4,

-        }
-        public class TimingPipeFlusher {
 {
-            public TimingPipeFlusher(PipeWriter writer, ITimeoutControl timeoutControl, IKestrelTrace log);

-            public Task FlushAsync();

-            public Task FlushAsync(IHttpOutputAborter outputAborter, CancellationToken cancellationToken);

-            public Task FlushAsync(MinDataRate minRate, long count);

-            public Task FlushAsync(MinDataRate minRate, long count, IHttpOutputAborter outputAborter, CancellationToken cancellationToken);

-        }
-        public abstract class WriteOnlyStream : Stream {
 {
-            protected WriteOnlyStream();

-            public override bool CanRead { get; }

-            public override bool CanWrite { get; }

-            public override int ReadTimeout { get; set; }

-            public override int Read(byte[] buffer, int offset, int count);

-            public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);

-        }
-    }
     namespace Microsoft.AspNetCore.Server.Kestrel.Https {
+        public static class CertificateLoader {
+            public static X509Certificate2 LoadFromStoreCert(string subject, string storeName, StoreLocation storeLocation, bool allowInvalid);
+        }
         public class HttpsConnectionAdapterOptions {
+            public Action<ConnectionContext, SslServerAuthenticationOptions> OnAuthenticate { get; set; }
+            public void AllowAnyClientCertificate();
         }
     }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Https.Internal {
 {
-        public static class CertificateLoader {
 {
-            public static X509Certificate2 LoadFromStoreCert(string subject, string storeName, StoreLocation storeLocation, bool allowInvalid);

-        }
-        public class HttpsConnectionAdapter : IConnectionAdapter {
 {
-            public HttpsConnectionAdapter(HttpsConnectionAdapterOptions options);

-            public HttpsConnectionAdapter(HttpsConnectionAdapterOptions options, ILoggerFactory loggerFactory);

-            public bool IsHttps { get; }

-            public Task<IAdaptedConnection> OnConnectionAsync(ConnectionAdapterContext context);

-        }
-    }
 }
```

