# .NET Core 3.0.0 Preview 8 - August 13, 2019

.NET Core 3.0.0 Preview 8 is available for download and usage in your environment. This release includes .NET Core 3.0.0 Preview 8 and .NET Core SDK 3.0.100 Preview 8.

**Visual Studio compatibility:** .NET Core 3.0 Preview 8 requires Visual Studio 2019 16.3 Preview 2 to take full advantage of all its features. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-300-preview-8)
* [Known issues](3.0.0-preview-known-issues.md)

## Blog Roundup
* [.NET Core 3.0 Preview 8][dotnet-blog]
* [ASP.NET Core][aspnet-blog]
* [EF Core][ef-blog]

The .NET Core SDK 3.0.100 Preview 8 includes .NET Core 3.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.0.100 preview, the following command will show that you're running version `3.0.100-preview8-013656` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #3184](https://github.com/dotnet/core/issues/3184) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     |  [Snap Install](3.0.0-preview8-download.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Symbols
All symbols for .NET Core releases for all platforms are now available from **nuget** or **public symbols server**. The symbols zips files that we used to share in the release notes earlier will no longer be provided.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 3.0.0 Preview 8

Here is list of some of the additions and updates we're excited to bring in Preview 8. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* CoreCLR: [bugs][coreclr_bugs] | [features][coreclr_features]
* CoreFX: [bugs][corefx_bugs] | [features][corefx_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.0/preview/3.0.0-preview8.md

[//]: # ( Runtime 3.0.0-preview8-28405-07)
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/24de5026-3471-4803-b674-689b338569df/10770879c266d430f4707e4f05f14559/dotnet-host-3.0.0-preview8-28405-07-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/e6c88fa0-7af3-4a5e-924c-c2b7746a3c56/058c182d3153f92102c36ba18a540c73/dotnet-host-3.0.0-preview8-28405-07-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/f65168d8-ecae-473a-a5ca-4300ed6d82ca/1ef8f137d05783380d128550fb1f0eb8/dotnet-hostfxr-3.0.0-preview8-28405-07-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/be0dd399-26ff-4535-8817-cea74af8870f/caba64c029563357d10101531e7d1bba/dotnet-hostfxr-3.0.0-preview8-28405-07-x64.rpm

[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/0afc82ac-e13e-4079-8579-0b17ead6479a/37153d3072e9f32ae816664b40302c28/dotnet-apphost-pack-3.0.0-preview8-28405-07-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ec8c5f86-bf16-460d-b873-671b4d01cf21/389bf94fb1070ff4f115b68212b0ab0e/dotnet-apphost-pack-3.0.0-preview8-28405-07-x64.rpm
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2e0f456-964a-4b90-bcd2-37b18bcdbfeb/30dc00fa236512937c1fbbdbecd269bb/dotnet-runtime-3.0.0-preview8-28405-07-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/177a9aa3-d714-4c14-8421-8ba58eaad7fa/cc80f512ca48c6b57ddb923e3505c7b6/dotnet-runtime-3.0.0-preview8-28405-07-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40161cce-db0e-4b42-826d-a8c8a48f926b/36589bcb129c09d631430908812e549a/dotnet-runtime-3.0.0-preview8-28405-07-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3873ce54-438c-43bd-871b-0472e4d5462b/01353d2e8c4289bb344d935c4bf4de3e/dotnet-runtime-3.0.0-preview8-28405-07-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1fe828e7-0544-4f49-b13f-0e14674c8c9a/27ec82f1180d55732827bd96fe303631/dotnet-runtime-3.0.0-preview8-28405-07-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bd72232-17fe-4108-a6a4-1883ad898443/98d9f83c932aa00567c234f47f9423b2/dotnet-runtime-3.0.0-preview8-28405-07-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4257101f-2cc4-4a69-86ec-1919a199746a/beddc17d2d5f7ffdfc2416c57b756c4d/dotnet-runtime-3.0.0-preview8-28405-07-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/328328f0-5072-4977-b487-e5dadea73bfb/68b1e99931e11074962b1d761af7080b/dotnet-runtime-3.0.0-preview8-28405-07-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f416c728-d905-4774-af89-ff8cdc9d2689/cafc4302d161e67c58513d0c2948ddc9/dotnet-runtime-3.0.0-preview8-28405-07-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/76735c7a-b2b9-47e6-9264-38ec2c7da035/f1a9bc6f91d03248a3f2cca392b8a680/dotnet-runtime-3.0.0-preview8-28405-07-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/16406ea2-f456-478c-ab15-07f9469c4be5/09c33d058632cec9d97d858d5ddcffb6/dotnet-runtime-3.0.0-preview8-28405-07-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/26841e45-2665-4509-9ef0-1fc1660c9015/e92ec24b1825ea21b0c606e4358c9d3b/dotnet-runtime-3.0.0-preview8-28405-07-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/b19fcec7-447a-465a-b1d5-b18084485b8d/40017d81e52d89f3aaac2537357c6c63/dotnet-runtime-3.0.0-preview8-28405-07-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c7b80a75-be96-41ed-a17d-fb5d2a7e4ca7/c6ba37aa37e57cc4f15d068921abe225/dotnet-runtime-3.0.0-preview8-28405-07-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/5be6adc2-91f1-4b19-9a7c-e0e702410f7d/c43d92c201fa97351da60cca0694003d/dotnet-runtime-deps-3.0.0-preview8-28405-07-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c76d6e7e-dcba-41bf-83ae-77ef4d4b83b9/80a4ac4e1f832552ebcc5f080bf80610/dotnet-runtime-deps-3.0.0-preview8-28405-07-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/4d4b4728-6e76-48db-8e45-24c2821509bf/d251cdbf921c9c169d54e2ab2a7e0571/dotnet-runtime-deps-3.0.0-preview8-28405-07-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/83403c6f-93e8-4a0f-982b-96c193af0997/bf053f5d21cea9b0cab965ebd46b1d6f/dotnet-runtime-deps-3.0.0-preview8-28405-07-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/026acef2-64dc-4028-ac04-413daf0f77d1/fb6340a3423fa2432ae7f5fd4ac8a828/dotnet-runtime-deps-3.0.0-preview8-28405-07-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6a8f5337-1e21-4553-b953-a2464a6d4084/28fefb47068cd854e2eab35678e2d154/dotnet-runtime-deps-3.0.0-preview8-28405-07-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/54a51271-ab58-41f3-9b18-a939888251fe/9b44470e8bc2bb6259e91696ad4e56b5/dotnet-runtime-deps-3.0.0-preview8-28405-07-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/cb26477c-ca65-4fa7-86cc-de0131303875/b844b61ec6ddab5d82dabc6c5efd419b/dotnet-targeting-pack-3.0.0-preview8-28405-07-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ba96af61-e1c3-4668-b2fc-7230c79e1cd0/382c3eabc382e3928ebc56299414c4c8/dotnet-targeting-pack-3.0.0-preview8-28405-07-x64.rpm
[netstandard-targeting-pack-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b482d47d-151a-4771-ae98-a05e22faac82/f4447c80442379ed65f5b307a8d0d1e3/netstandard-targeting-pack-2.1.0-preview8-28405-07-osx-x64.pkg
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/4caf9463-865a-4265-83e6-15fc4c217eb2/320dde5e522457a91b2a1daaa57bb764/netstandard-targeting-pack-2.1.0-preview8-28405-07-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/82467fdf-3521-4a44-85c6-ef23061a022d/9e07507d17cc70800891aa4441581c9c/netstandard-targeting-pack-2.1.0-preview8-28405-07-x64.rpm

[//]: # ( ASP 3.0.0-preview8.19405.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b734651-326f-4eb4-8a75-da94e991a901/f404fe1e1a2e989cb2e7bde13a3a2be5/aspnetcore-runtime-3.0.0-preview8.19405.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0dcbd93c-7fb7-49a6-98f9-9233e97e5c62/6bbfd6a0f2a96793a0f4c38e3cc66306/aspnetcore-runtime-3.0.0-preview8.19405.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8eefd1be-89e6-4e51-ae9f-75716111e4ba/818c35f8dca4d2e564bbe3da869990f3/aspnetcore-runtime-3.0.0-preview8.19405.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0bff102b-7983-4947-be67-be740e168ec1/d4b2a3818f2849501710b6ee16a1e2be/aspnetcore-runtime-3.0.0-preview8.19405.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b252c8ee-ae2d-4f0c-844b-e9417ca7fa09/39c32d263cab2b233a12399dd246a498/aspnetcore-runtime-3.0.0-preview8.19405.7-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/47a7a0c6-1be7-46f3-87f9-f5be2ea8b6d7/c027ed71e0019276fc98dadb23665a72/aspnetcore-runtime-3.0.0-preview8.19405.7-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/70632f83-b799-4d0b-b543-5b9bbb5a816d/9450fef9f62d19bfad16d9007712173e/aspnetcore-runtime-3.0.0-preview8.19405.7-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7554fcf8-7e94-4b8d-96cc-4ace14ac2694/d78ac8ce7902cae8683a6eca67b78111/aspnetcore-runtime-3.0.0-preview8.19405.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/376f6702-cd40-423e-bfc7-00ae38668679/a1e0306d4a56f91c0918db32560bc796/aspnetcore-runtime-3.0.0-preview8.19405.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/321ca295-9e7e-42e2-b54a-1d738bfbb290/014f76039ba4edc71fd6cc5d07774d0b/aspnetcore-runtime-3.0.0-preview8.19405.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e626edfe-4423-453b-9d43-4ddb5b5deb7d/f0e4480cbb181e6888ce5fd24de7cbc0/aspnetcore-runtime-3.0.0-preview8.19405.7-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/13e08a26-96aa-4b54-ab4f-ab967fa13be2/1bbd4e9a5f04e254ec43ede7f43e7005/aspnetcore-runtime-3.0.0-preview8.19405.7-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/fca66248-bd05-4948-8efd-390b5d056397/c3078f7d3368438863eb26d93308858f/aspnetcore-runtime-3.0.0-preview8.19405.7-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/90cf071f-8412-45b1-9237-ade8d9d5b871/adcdf7d67cb0554f6a53af3d3b303e9d/aspnetcore-targeting-pack-3.0.0-preview8.19405.7.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/26473bdd-e207-4e89-9eb5-14729db564a9/673896c711e4b8d54543b1c790c31be8/aspnetcore-targeting-pack-3.0.0-preview8.19405.7.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b1bc1733-f98d-4a46-ac6c-0183b16344f7/2c46d765b3d2295f575c116b25e5f0b1/dotnet-hosting-3.0.0-preview8.19405.7-win.exe

[//]: # ( SDK 3.0.100-preview8-013656 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f91f8a12-9278-452c-9c1d-2db285d1ed24/1b9e29825adfaab4a4b616464b00ccc0/dotnet-sdk-3.0.100-preview8-013656-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1463b0d-7289-4e4c-bd2a-a6c008d52793/f9c937d47dd4c5447e863adefb44ab78/dotnet-sdk-3.0.100-preview8-013656-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f455c93d-abd2-4c4b-89da-39c6dd763eb9/2d17f950ee996f7499c1b6ce463f77e1/dotnet-sdk-3.0.100-preview8-013656-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0e368ac-7161-4bde-a139-1a3ef5a82bbe/439cdbb58950916d3718771c5d986c35/dotnet-sdk-3.0.100-preview8-013656-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d6b24cf2-ca2a-46f4-b6c8-72e851b80e16/c0fb5d8040803f8f88326dfde012ddfa/dotnet-sdk-3.0.100-preview8-013656-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a974d0a6-d03a-41c1-9dfd-f5884655fd33/cf9d659401cca08c3c55374b3cb8b629/dotnet-sdk-3.0.100-preview8-013656-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ca974af-c77d-4c18-89f8-3572dea18d24/8c86e55c4b6f7bd69a80fe84a40c5c6d/dotnet-sdk-3.0.100-preview8-013656-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/e24cdd15-ccbe-4524-b623-f6b198d07856/4dd5cac3a1b93257e98044a7ee07c259/dotnet-sdk-3.0.100-preview8-013656-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a46fa009-033b-430d-89a8-c9a107f73d87/d25f962e8212aafb3b0c426eb8cb4dc6/dotnet-sdk-3.0.100-preview8-013656-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/701abc79-0ceb-406c-aa4b-5e429c665448/05424ebe3bdb06688b910664fbff0671/dotnet-sdk-3.0.100-preview8-013656-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/20950cfc-c203-45ae-ba74-2d1c66178285/8426d962b1c4a2b3f8ae785d0d7aab2a/dotnet-sdk-3.0.100-preview8-013656-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0ae7a584-c325-43d8-a087-e65e9d6a1c54/d7dc063ce3732d76dd97955125e2982f/dotnet-sdk-3.0.100-preview8-013656-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/3dd3123a-7ada-40d0-b920-cd9b22cdb172/5e9142450ceec2b15829ca0fe5c54a68/dotnet-sdk-3.0.100-preview8-013656-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/5e6e263d-a49d-4ae5-99f1-56a04e9f10d7/8c787474558b11857b5920ce00466af8/dotnet-sdk-3.0.100-preview8-013656-x64.rpm

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview8-28405-07-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview8-013656-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0-preview-8/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-3-0-preview-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-3-0-preview-8-and-entity-framework-6-3-preview-8

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0-preview8+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0-preview8+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.0+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
