# System.Net.Security

``` diff
 namespace System.Net.Security {
     public abstract class AuthenticatedStream : Stream {
+        public override ValueTask DisposeAsync();
     }
     public class NegotiateStream : AuthenticatedStream {
+        public override ValueTask DisposeAsync();
     }
     public class SslStream : AuthenticatedStream {
+        public override ValueTask DisposeAsync();
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadByte();
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

