# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    public struct AsyncIteratorMethodBuilder {
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void Complete();
+        public static AsyncIteratorMethodBuilder Create();
+        public void MoveNext<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
+    public sealed class CallerArgumentExpressionAttribute : Attribute {
+        public CallerArgumentExpressionAttribute(string parameterName);
+        public string ParameterName { get; }
+    }
+    public readonly struct ConfiguredAsyncEnumerable<T> {
+        public ConfiguredAsyncEnumerable<T>.Enumerator GetAsyncEnumerator();
+        public readonly struct Enumerator {
+            public T Current { get; }
+            public ConfiguredValueTaskAwaitable DisposeAsync();
+            public ConfiguredValueTaskAwaitable<bool> MoveNextAsync();
+        }
+    }
+    public sealed class IDispatchConstantAttribute : CustomConstantAttribute {
+        public IDispatchConstantAttribute();
+        public override object Value { get; }
+    }
     public enum MethodImplOptions {
+        AggressiveOptimization = 512,
     }
     public static class RuntimeFeature {
+        public const string DefaultImplementationsOfInterfaces = "DefaultImplementationsOfInterfaces";
     }
 }
```

