# System.Runtime.Intrinsics

``` diff
+namespace System.Runtime.Intrinsics {
+    public static class Vector128 {
+        public static Vector128<Byte> Create(byte value);
+        public static Vector128<Byte> Create(byte e0, byte e1, byte e2, byte e3, byte e4, byte e5, byte e6, byte e7, byte e8, byte e9, byte e10, byte e11, byte e12, byte e13, byte e14, byte e15);
+        public static Vector128<Double> Create(double value);
+        public static Vector128<Double> Create(double e0, double e1);
+        public static Vector128<Int16> Create(short value);
+        public static Vector128<Int16> Create(short e0, short e1, short e2, short e3, short e4, short e5, short e6, short e7);
+        public static Vector128<Int32> Create(int value);
+        public static Vector128<Int32> Create(int e0, int e1, int e2, int e3);
+        public static Vector128<Int64> Create(long value);
+        public static Vector128<Int64> Create(long e0, long e1);
+        public static Vector128<Byte> Create(Vector64<byte> lower, Vector64<byte> upper);
+        public static Vector128<Double> Create(Vector64<double> lower, Vector64<double> upper);
+        public static Vector128<Int16> Create(Vector64<short> lower, Vector64<short> upper);
+        public static Vector128<Int32> Create(Vector64<int> lower, Vector64<int> upper);
+        public static Vector128<Int64> Create(Vector64<long> lower, Vector64<long> upper);
+        public static Vector128<SByte> Create(Vector64<sbyte> lower, Vector64<sbyte> upper);
+        public static Vector128<Single> Create(Vector64<float> lower, Vector64<float> upper);
+        public static Vector128<UInt16> Create(Vector64<ushort> lower, Vector64<ushort> upper);
+        public static Vector128<UInt32> Create(Vector64<uint> lower, Vector64<uint> upper);
+        public static Vector128<UInt64> Create(Vector64<ulong> lower, Vector64<ulong> upper);
+        public static Vector128<SByte> Create(sbyte value);
+        public static Vector128<SByte> Create(sbyte e0, sbyte e1, sbyte e2, sbyte e3, sbyte e4, sbyte e5, sbyte e6, sbyte e7, sbyte e8, sbyte e9, sbyte e10, sbyte e11, sbyte e12, sbyte e13, sbyte e14, sbyte e15);
+        public static Vector128<Single> Create(float value);
+        public static Vector128<Single> Create(float e0, float e1, float e2, float e3);
+        public static Vector128<UInt16> Create(ushort value);
+        public static Vector128<UInt16> Create(ushort e0, ushort e1, ushort e2, ushort e3, ushort e4, ushort e5, ushort e6, ushort e7);
+        public static Vector128<UInt32> Create(uint value);
+        public static Vector128<UInt32> Create(uint e0, uint e1, uint e2, uint e3);
+        public static Vector128<UInt64> Create(ulong value);
+        public static Vector128<UInt64> Create(ulong e0, ulong e1);
+        public static Vector128<Byte> CreateScalar(byte value);
+        public static Vector128<Double> CreateScalar(double value);
+        public static Vector128<Int16> CreateScalar(short value);
+        public static Vector128<Int32> CreateScalar(int value);
+        public static Vector128<Int64> CreateScalar(long value);
+        public static Vector128<SByte> CreateScalar(sbyte value);
+        public static Vector128<Single> CreateScalar(float value);
+        public static Vector128<UInt16> CreateScalar(ushort value);
+        public static Vector128<UInt32> CreateScalar(uint value);
+        public static Vector128<UInt64> CreateScalar(ulong value);
+        public static Vector128<Byte> CreateScalarUnsafe(byte value);
+        public static Vector128<Double> CreateScalarUnsafe(double value);
+        public static Vector128<Int16> CreateScalarUnsafe(short value);
+        public static Vector128<Int32> CreateScalarUnsafe(int value);
+        public static Vector128<Int64> CreateScalarUnsafe(long value);
+        public static Vector128<SByte> CreateScalarUnsafe(sbyte value);
+        public static Vector128<Single> CreateScalarUnsafe(float value);
+        public static Vector128<UInt16> CreateScalarUnsafe(ushort value);
+        public static Vector128<UInt32> CreateScalarUnsafe(uint value);
+        public static Vector128<UInt64> CreateScalarUnsafe(ulong value);
+    }
+    public readonly struct Vector128<T> where T : struct {
+        public static Vector128<T> Zero { get; }
+        public Vector128<U> As<U>() where U : struct;
+        public Vector128<Byte> AsByte();
+        public Vector128<Double> AsDouble();
+        public Vector128<Int16> AsInt16();
+        public Vector128<Int32> AsInt32();
+        public Vector128<Int64> AsInt64();
+        public Vector128<SByte> AsSByte();
+        public Vector128<Single> AsSingle();
+        public Vector128<UInt16> AsUInt16();
+        public Vector128<UInt32> AsUInt32();
+        public Vector128<UInt64> AsUInt64();
+        public T GetElement(int index);
+        public Vector64<T> GetLower();
+        public Vector64<T> GetUpper();
+        public T ToScalar();
+        public Vector256<T> ToVector256();
+        public Vector256<T> ToVector256Unsafe();
+        public Vector128<T> WithElement(int index, T value);
+        public Vector128<T> WithLower(Vector64<T> value);
+        public Vector128<T> WithUpper(Vector64<T> value);
+    }
+    public static class Vector256 {
+        public static Vector256<Byte> Create(byte value);
+        public static Vector256<Byte> Create(byte e0, byte e1, byte e2, byte e3, byte e4, byte e5, byte e6, byte e7, byte e8, byte e9, byte e10, byte e11, byte e12, byte e13, byte e14, byte e15, byte e16, byte e17, byte e18, byte e19, byte e20, byte e21, byte e22, byte e23, byte e24, byte e25, byte e26, byte e27, byte e28, byte e29, byte e30, byte e31);
+        public static Vector256<Double> Create(double value);
+        public static Vector256<Double> Create(double e0, double e1, double e2, double e3);
+        public static Vector256<Int16> Create(short value);
+        public static Vector256<Int16> Create(short e0, short e1, short e2, short e3, short e4, short e5, short e6, short e7, short e8, short e9, short e10, short e11, short e12, short e13, short e14, short e15);
+        public static Vector256<Int32> Create(int value);
+        public static Vector256<Int32> Create(int e0, int e1, int e2, int e3, int e4, int e5, int e6, int e7);
+        public static Vector256<Int64> Create(long value);
+        public static Vector256<Int64> Create(long e0, long e1, long e2, long e3);
+        public static Vector256<Byte> Create(Vector128<byte> lower, Vector128<byte> upper);
+        public static Vector256<Double> Create(Vector128<double> lower, Vector128<double> upper);
+        public static Vector256<Int16> Create(Vector128<short> lower, Vector128<short> upper);
+        public static Vector256<Int32> Create(Vector128<int> lower, Vector128<int> upper);
+        public static Vector256<Int64> Create(Vector128<long> lower, Vector128<long> upper);
+        public static Vector256<SByte> Create(Vector128<sbyte> lower, Vector128<sbyte> upper);
+        public static Vector256<Single> Create(Vector128<float> lower, Vector128<float> upper);
+        public static Vector256<UInt16> Create(Vector128<ushort> lower, Vector128<ushort> upper);
+        public static Vector256<UInt32> Create(Vector128<uint> lower, Vector128<uint> upper);
+        public static Vector256<UInt64> Create(Vector128<ulong> lower, Vector128<ulong> upper);
+        public static Vector256<SByte> Create(sbyte value);
+        public static Vector256<SByte> Create(sbyte e0, sbyte e1, sbyte e2, sbyte e3, sbyte e4, sbyte e5, sbyte e6, sbyte e7, sbyte e8, sbyte e9, sbyte e10, sbyte e11, sbyte e12, sbyte e13, sbyte e14, sbyte e15, sbyte e16, sbyte e17, sbyte e18, sbyte e19, sbyte e20, sbyte e21, sbyte e22, sbyte e23, sbyte e24, sbyte e25, sbyte e26, sbyte e27, sbyte e28, sbyte e29, sbyte e30, sbyte e31);
+        public static Vector256<Single> Create(float value);
+        public static Vector256<Single> Create(float e0, float e1, float e2, float e3, float e4, float e5, float e6, float e7);
+        public static Vector256<UInt16> Create(ushort value);
+        public static Vector256<UInt16> Create(ushort e0, ushort e1, ushort e2, ushort e3, ushort e4, ushort e5, ushort e6, ushort e7, ushort e8, ushort e9, ushort e10, ushort e11, ushort e12, ushort e13, ushort e14, ushort e15);
+        public static Vector256<UInt32> Create(uint value);
+        public static Vector256<UInt32> Create(uint e0, uint e1, uint e2, uint e3, uint e4, uint e5, uint e6, uint e7);
+        public static Vector256<UInt64> Create(ulong value);
+        public static Vector256<UInt64> Create(ulong e0, ulong e1, ulong e2, ulong e3);
+        public static Vector256<Byte> CreateScalar(byte value);
+        public static Vector256<Double> CreateScalar(double value);
+        public static Vector256<Int16> CreateScalar(short value);
+        public static Vector256<Int32> CreateScalar(int value);
+        public static Vector256<Int64> CreateScalar(long value);
+        public static Vector256<SByte> CreateScalar(sbyte value);
+        public static Vector256<Single> CreateScalar(float value);
+        public static Vector256<UInt16> CreateScalar(ushort value);
+        public static Vector256<UInt32> CreateScalar(uint value);
+        public static Vector256<UInt64> CreateScalar(ulong value);
+        public static Vector256<Byte> CreateScalarUnsafe(byte value);
+        public static Vector256<Double> CreateScalarUnsafe(double value);
+        public static Vector256<Int16> CreateScalarUnsafe(short value);
+        public static Vector256<Int32> CreateScalarUnsafe(int value);
+        public static Vector256<Int64> CreateScalarUnsafe(long value);
+        public static Vector256<SByte> CreateScalarUnsafe(sbyte value);
+        public static Vector256<Single> CreateScalarUnsafe(float value);
+        public static Vector256<UInt16> CreateScalarUnsafe(ushort value);
+        public static Vector256<UInt32> CreateScalarUnsafe(uint value);
+        public static Vector256<UInt64> CreateScalarUnsafe(ulong value);
+    }
+    public readonly struct Vector256<T> where T : struct {
+        public static Vector256<T> Zero { get; }
+        public Vector256<U> As<U>() where U : struct;
+        public Vector256<Byte> AsByte();
+        public Vector256<Double> AsDouble();
+        public Vector256<Int16> AsInt16();
+        public Vector256<Int32> AsInt32();
+        public Vector256<Int64> AsInt64();
+        public Vector256<SByte> AsSByte();
+        public Vector256<Single> AsSingle();
+        public Vector256<UInt16> AsUInt16();
+        public Vector256<UInt32> AsUInt32();
+        public Vector256<UInt64> AsUInt64();
+        public T GetElement(int index);
+        public Vector128<T> GetLower();
+        public Vector128<T> GetUpper();
+        public T ToScalar();
+        public Vector256<T> WithElement(int index, T value);
+        public Vector256<T> WithLower(Vector128<T> value);
+        public Vector256<T> WithUpper(Vector128<T> value);
+    }
+    public static class Vector64 {
+        public static Vector64<Byte> Create(byte value);
+        public static Vector64<Byte> Create(byte e0, byte e1, byte e2, byte e3, byte e4, byte e5, byte e6, byte e7);
+        public static Vector64<Double> Create(double value);
+        public static Vector64<Int16> Create(short value);
+        public static Vector64<Int16> Create(short e0, short e1, short e2, short e3);
+        public static Vector64<Int32> Create(int value);
+        public static Vector64<Int32> Create(int e0, int e1);
+        public static Vector64<Int64> Create(long value);
+        public static Vector64<SByte> Create(sbyte value);
+        public static Vector64<SByte> Create(sbyte e0, sbyte e1, sbyte e2, sbyte e3, sbyte e4, sbyte e5, sbyte e6, sbyte e7);
+        public static Vector64<Single> Create(float value);
+        public static Vector64<Single> Create(float e0, float e1);
+        public static Vector64<UInt16> Create(ushort value);
+        public static Vector64<UInt16> Create(ushort e0, ushort e1, ushort e2, ushort e3);
+        public static Vector64<UInt32> Create(uint value);
+        public static Vector64<UInt32> Create(uint e0, uint e1);
+        public static Vector64<UInt64> Create(ulong value);
+        public static Vector64<Byte> CreateScalar(byte value);
+        public static Vector64<Int16> CreateScalar(short value);
+        public static Vector64<Int32> CreateScalar(int value);
+        public static Vector64<SByte> CreateScalar(sbyte value);
+        public static Vector64<Single> CreateScalar(float value);
+        public static Vector64<UInt16> CreateScalar(ushort value);
+        public static Vector64<UInt32> CreateScalar(uint value);
+        public static Vector64<Byte> CreateScalarUnsafe(byte value);
+        public static Vector64<Int16> CreateScalarUnsafe(short value);
+        public static Vector64<Int32> CreateScalarUnsafe(int value);
+        public static Vector64<SByte> CreateScalarUnsafe(sbyte value);
+        public static Vector64<Single> CreateScalarUnsafe(float value);
+        public static Vector64<UInt16> CreateScalarUnsafe(ushort value);
+        public static Vector64<UInt32> CreateScalarUnsafe(uint value);
+    }
+    public readonly struct Vector64<T> where T : struct {
+        public static Vector64<T> Zero { get; }
+        public Vector64<U> As<U>() where U : struct;
+        public Vector64<Byte> AsByte();
+        public Vector64<Double> AsDouble();
+        public Vector64<Int16> AsInt16();
+        public Vector64<Int32> AsInt32();
+        public Vector64<Int64> AsInt64();
+        public Vector64<SByte> AsSByte();
+        public Vector64<Single> AsSingle();
+        public Vector64<UInt16> AsUInt16();
+        public Vector64<UInt32> AsUInt32();
+        public Vector64<UInt64> AsUInt64();
+        public T GetElement(int index);
+        public T ToScalar();
+        public Vector128<T> ToVector128();
+        public Vector128<T> ToVector128Unsafe();
+        public Vector64<T> WithElement(int index, T value);
+    }
+}
```

