# System.Text

``` diff
 namespace System.Text {
+    public readonly struct Rune : IComparable<Rune>, IEquatable<Rune> {
+        public Rune(char ch);
+        public Rune(int value);
+        public Rune(uint value);
+        public bool IsAscii { get; }
+        public bool IsBmp { get; }
+        public int Plane { get; }
+        public static Rune ReplacementChar { get; }
+        public int Utf16SequenceLength { get; }
+        public int Utf8SequenceLength { get; }
+        public int Value { get; }
+        public int CompareTo(Rune other);
+        public override bool Equals(object obj);
+        public bool Equals(Rune other);
+        public override int GetHashCode();
+        public static double GetNumericValue(Rune value);
+        public static Rune GetRuneAt(string input, int index);
+        public static UnicodeCategory GetUnicodeCategory(Rune value);
+        public static bool IsControl(Rune value);
+        public static bool IsDigit(Rune value);
+        public static bool IsLetter(Rune value);
+        public static bool IsLetterOrDigit(Rune value);
+        public static bool IsLower(Rune value);
+        public static bool IsNumber(Rune value);
+        public static bool IsPunctuation(Rune value);
+        public static bool IsSeparator(Rune value);
+        public static bool IsSymbol(Rune value);
+        public static bool IsUpper(Rune value);
+        public static bool IsValid(int value);
+        public static bool IsValid(uint value);
+        public static bool IsWhiteSpace(Rune value);
+        public static bool operator ==(Rune left, Rune right);
+        public static explicit operator Rune (char ch);
+        public static explicit operator Rune (int value);
+        public static explicit operator Rune (uint value);
+        public static bool operator >(Rune left, Rune right);
+        public static bool operator >=(Rune left, Rune right);
+        public static bool operator !=(Rune left, Rune right);
+        public static bool operator <(Rune left, Rune right);
+        public static bool operator <=(Rune left, Rune right);
+        public static Rune ToLower(Rune value, CultureInfo culture);
+        public static Rune ToLowerInvariant(Rune value);
+        public override string ToString();
+        public static Rune ToUpper(Rune value, CultureInfo culture);
+        public static Rune ToUpperInvariant(Rune value);
+        public static bool TryCreate(char ch, out Rune result);
+        public static bool TryCreate(int value, out Rune result);
+        public static bool TryCreate(uint value, out Rune result);
+        public bool TryEncode(Span<char> destination, out int charsWritten);
+        public static bool TryGetRuneAt(string input, int index, out Rune value);
+    }
+    public ref struct SpanRuneEnumerator {
+        public Rune Current { get; }
+        public SpanRuneEnumerator GetEnumerator();
+        public bool MoveNext();
+    }
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder Append(ReadOnlyMemory<char> value);
+        public StringBuilder.ChunkEnumerator GetChunks();
+        public struct ChunkEnumerator {
+            public ReadOnlyMemory<char> Current { get; }
+            public StringBuilder.ChunkEnumerator GetEnumerator();
+            public bool MoveNext();
+        }
     }
+    public struct StringRuneEnumerator : IDisposable, IEnumerable, IEnumerable<Rune>, IEnumerator, IEnumerator<Rune> {
+        public Rune Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public StringRuneEnumerator GetEnumerator();
+        public bool MoveNext();
+        IEnumerator<Rune> System.Collections.Generic.IEnumerable<System.Text.Rune>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        void System.Collections.IEnumerator.Reset();
+        void System.IDisposable.Dispose();
+    }
 }
```

