# System.Data.Common

``` diff
 namespace System.Data.Common {
     public abstract class DbCommand : Component, IDbCommand, IDisposable {
+        public virtual ValueTask DisposeAsync();
+        public virtual Task PrepareAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class DbConnection : Component, IDbConnection, IDisposable {
+        protected virtual ValueTask<DbTransaction> BeginDbTransactionAsync(IsolationLevel isolationLevel, CancellationToken cancellationToken);
+        public ValueTask<DbTransaction> BeginTransactionAsync(IsolationLevel isolationLevel, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask<DbTransaction> BeginTransactionAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task ChangeDatabaseAsync(string databaseName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task CloseAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public virtual ValueTask DisposeAsync();
     }
     public abstract class DbDataReader : MarshalByRefObject, IDataReader, IDataRecord, IDisposable, IEnumerable {
+        public virtual Task CloseAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public virtual ValueTask DisposeAsync();
     }
     public abstract class DbProviderFactory {
+        public virtual bool CanCreateCommandBuilder { get; }
+        public virtual bool CanCreateDataAdapter { get; }
     }
     public abstract class DbTransaction : MarshalByRefObject, IDbTransaction, IDisposable {
+        public virtual Task CommitAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public virtual ValueTask DisposeAsync();
+        public virtual Task RollbackAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

